// Compiled by ClojureScript 1.9.521 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_time.coerce');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('goog.date.UtcDateTime');

/**
 * @interface
 */
cljs_time.coerce.ICoerce = function(){};

/**
 * Convert `obj` to a goog.date.DateTime instance.
 */
cljs_time.coerce.to_date_time = (function cljs_time$coerce$to_date_time(obj){
if((!((obj == null))) && (!((obj.cljs_time$coerce$ICoerce$to_date_time$arity$1 == null)))){
return obj.cljs_time$coerce$ICoerce$to_date_time$arity$1(obj);
} else {
var x__7859__auto__ = (((obj == null))?null:obj);
var m__7860__auto__ = (cljs_time.coerce.to_date_time[goog.typeOf(x__7859__auto__)]);
if(!((m__7860__auto__ == null))){
return (m__7860__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7860__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__7860__auto__.call(null,obj));
} else {
var m__7860__auto____$1 = (cljs_time.coerce.to_date_time["_"]);
if(!((m__7860__auto____$1 == null))){
return (m__7860__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7860__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__7860__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("ICoerce.to-date-time",obj);
}
}
}
});

/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.from_long = (function cljs_time$coerce$from_long(millis){
var G__14423 = millis;
if((G__14423 == null)){
return null;
} else {
return (goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1 ? goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1(G__14423) : goog.date.UtcDateTime.fromTimestamp.call(null,G__14423));
}
});
/**
 * Returns DateTime instance from string using formatters in cljs-time.format,
 *   returning first which parses
 */
cljs_time.coerce.from_string = (function cljs_time$coerce$from_string(s){
if(cljs.core.truth_(s)){
return cljs.core.first((function (){var iter__7979__auto__ = (function cljs_time$coerce$from_string_$_iter__14434(s__14435){
return (new cljs.core.LazySeq(null,(function (){
var s__14435__$1 = s__14435;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__14435__$1);
if(temp__4657__auto__){
var s__14435__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__14435__$2)){
var c__7977__auto__ = cljs.core.chunk_first(s__14435__$2);
var size__7978__auto__ = cljs.core.count(c__7977__auto__);
var b__14437 = cljs.core.chunk_buffer(size__7978__auto__);
if((function (){var i__14436 = (0);
while(true){
if((i__14436 < size__7978__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7977__auto__,i__14436);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e14442){if((e14442 instanceof Error)){
var _ = e14442;
return null;
} else {
throw e14442;

}
}})();
if(cljs.core.truth_(d)){
cljs.core.chunk_append(b__14437,d);

var G__14444 = (i__14436 + (1));
i__14436 = G__14444;
continue;
} else {
var G__14445 = (i__14436 + (1));
i__14436 = G__14445;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__14437),cljs_time$coerce$from_string_$_iter__14434(cljs.core.chunk_rest(s__14435__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__14437),null);
}
} else {
var f = cljs.core.first(s__14435__$2);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e14443){if((e14443 instanceof Error)){
var _ = e14443;
return null;
} else {
throw e14443;

}
}})();
if(cljs.core.truth_(d)){
return cljs.core.cons(d,cljs_time$coerce$from_string_$_iter__14434(cljs.core.rest(s__14435__$2)));
} else {
var G__14446 = cljs.core.rest(s__14435__$2);
s__14435__$1 = G__14446;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7979__auto__(cljs.core.vals(cljs_time.format.formatters));
})());
} else {
return null;
}
});
/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   js Date object.
 */
cljs_time.coerce.from_date = (function cljs_time$coerce$from_date(date){
var G__14448 = date;
var G__14448__$1 = (((G__14448 == null))?null:G__14448.getTime());
if((G__14448__$1 == null)){
return null;
} else {
return cljs_time.coerce.from_long(G__14448__$1);
}
});
/**
 * Convert `obj` to the number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.to_long = (function cljs_time$coerce$to_long(obj){
var G__14450 = obj;
var G__14450__$1 = (((G__14450 == null))?null:cljs_time.coerce.to_date_time(G__14450));
if((G__14450__$1 == null)){
return null;
} else {
return G__14450__$1.getTime();
}
});
/**
 * Convert `obj` to Unix epoch.
 */
cljs_time.coerce.to_epoch = (function cljs_time$coerce$to_epoch(obj){
var millis = cljs_time.coerce.to_long(obj);
var and__7179__auto__ = millis;
if(cljs.core.truth_(and__7179__auto__)){
return cljs.core.quot(millis,(1000));
} else {
return and__7179__auto__;
}
});
/**
 * Convert `obj` to a JavaScript Date instance.
 */
cljs_time.coerce.to_date = (function cljs_time$coerce$to_date(obj){
var G__14452 = obj;
var G__14452__$1 = (((G__14452 == null))?null:cljs_time.coerce.to_date_time(G__14452));
var G__14452__$2 = (((G__14452__$1 == null))?null:G__14452__$1.getTime());
if((G__14452__$2 == null)){
return null;
} else {
return (new Date(G__14452__$2));
}
});
/**
 * Returns a string representation of obj in UTC time-zone
 *   using "yyyy-MM-dd'T'HH:mm:ss.SSSZZ" date-time representation.
 */
cljs_time.coerce.to_string = (function cljs_time$coerce$to_string(obj){
var G__14454 = obj;
var G__14454__$1 = (((G__14454 == null))?null:cljs_time.coerce.to_date_time(G__14454));
if((G__14454__$1 == null)){
return null;
} else {
return cljs_time.format.unparse(cljs.core.cst$kw$date_DASH_time.cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters),G__14454__$1);
}
});
/**
 * Convert `obj` to a goog.date.Date instance
 */
cljs_time.coerce.to_local_date = (function cljs_time$coerce$to_local_date(obj){
if(cljs.core.truth_(obj)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(goog.date.Date,cljs.core.type(obj))){
return obj;
} else {
var temp__4655__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
return (new goog.date.Date(dt.getYear(),dt.getMonth(),dt.getDate()));
} else {
return null;
}
}
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.DateTime instance
 */
cljs_time.coerce.to_local_date_time = (function cljs_time$coerce$to_local_date_time(obj){
if(cljs.core.truth_(obj)){
var temp__4655__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
var G__14456 = (new goog.date.DateTime(dt.getYear(),dt.getMonth(),dt.getDate()));
G__14456.setHours(dt.getHours());

G__14456.setMinutes(dt.getMinutes());

G__14456.setSeconds(dt.getSeconds());

G__14456.setMilliseconds(dt.getMilliseconds());

return G__14456;
} else {
return null;
}
} else {
return null;
}
});
(cljs_time.coerce.ICoerce["null"] = true);

(cljs_time.coerce.to_date_time["null"] = (function (_){
return null;
}));

Date.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date){
var date__$1 = this;
return cljs_time.coerce.from_date(date__$1);
});

goog.date.Date.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL;

goog.date.Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date){
var local_date__$1 = this;
if(cljs.core.truth_(local_date__$1)){
return cljs_time.core.to_utc_time_zone(local_date__$1);
} else {
return null;
}
});

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL;

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date_time){
var local_date_time__$1 = this;
if(cljs.core.truth_(local_date_time__$1)){
return cljs_time.core.to_utc_time_zone(local_date_time__$1);
} else {
return null;
}
});

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$ = cljs.core.PROTOCOL_SENTINEL;

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date_time){
var date_time__$1 = this;
return date_time__$1;
});

(cljs_time.coerce.ICoerce["number"] = true);

(cljs_time.coerce.to_date_time["number"] = (function (long$){
return cljs_time.coerce.from_long(long$);
}));

(cljs_time.coerce.ICoerce["string"] = true);

(cljs_time.coerce.to_date_time["string"] = (function (string){
return cljs_time.coerce.from_string(string);
}));
