// Compiled by ClojureScript 1.9.521 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs_time.internal.parse');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs_time.internal.core');
goog.require('clojure.string');
goog.require('goog.date.Date');
goog.require('goog.date.DateTime');
goog.require('goog.date.UtcDateTime');
goog.require('goog.date.Interval');
cljs_time.internal.parse.replace = (function cljs_time$internal$parse$replace(s,match,replacement){
return clojure.string.replace(((typeof s === 'string')?s:clojure.string.join.cljs$core$IFn$_invoke$arity$1(s)),match,replacement);
});
cljs_time.internal.parse.token = (function cljs_time$internal$parse$token(s){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$token,s], null);
});
cljs_time.internal.parse.quoted = (function cljs_time$internal$parse$quoted(s){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$quoted,s], null);
});
cljs_time.internal.parse.read_while = (function cljs_time$internal$parse$read_while(pred,s){
var G__13803 = s;
var vec__13804 = G__13803;
var seq__13805 = cljs.core.seq(vec__13804);
var first__13806 = cljs.core.first(seq__13805);
var seq__13805__$1 = cljs.core.next(seq__13805);
var h = first__13806;
var more = seq__13805__$1;
var s__$1 = vec__13804;
var out = cljs.core.PersistentVector.EMPTY;
var G__13803__$1 = G__13803;
var out__$1 = out;
while(true){
var vec__13807 = G__13803__$1;
var seq__13808 = cljs.core.seq(vec__13807);
var first__13809 = cljs.core.first(seq__13808);
var seq__13808__$1 = cljs.core.next(seq__13808);
var h__$1 = first__13809;
var more__$1 = seq__13808__$1;
var s__$2 = vec__13807;
var out__$2 = out__$1;
if(cljs.core.truth_((function (){var and__7179__auto__ = h__$1;
if(cljs.core.truth_(and__7179__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(h__$1) : pred.call(null,h__$1));
} else {
return and__7179__auto__;
}
})())){
var G__13810 = more__$1;
var G__13811 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out__$2,h__$1);
G__13803__$1 = G__13810;
out__$1 = G__13811;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [out__$2,s__$2], null);
}
break;
}
});
cljs_time.internal.parse.read_token = (function cljs_time$internal$parse$read_token(ch,s){
var vec__13815 = cljs_time.internal.parse.read_while(cljs.core.PersistentHashSet.createAsIfByAssoc([ch], true),s);
var end = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13815,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13815,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.token(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.str,ch,end)),s__$1], null);
});
cljs_time.internal.parse.read_quoted = (function cljs_time$internal$parse$read_quoted(_,p__13818){
var vec__13825 = p__13818;
var seq__13826 = cljs.core.seq(vec__13825);
var first__13827 = cljs.core.first(seq__13826);
var seq__13826__$1 = cljs.core.next(seq__13826);
var h = first__13827;
var more = seq__13826__$1;
var s = vec__13825;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,"'")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.quoted("'"),more], null);
} else {
var vec__13828 = cljs_time.internal.parse.read_while(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["'",null], null), null)),s);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13828,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13828,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.quoted(q),cljs.core.rest(s__$1)], null);
}
});
cljs_time.internal.parse.read_punctuation = (function cljs_time$internal$parse$read_punctuation(ch,s){
var vec__13835 = cljs_time.internal.parse.read_while((function (p1__13831_SHARP_){
return cljs.core.not(cljs.core.re_find(/[a-zA-Z']/,p1__13831_SHARP_));
}),s);
var end = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13835,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13835,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.quoted(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.str,ch,end)),s__$1], null);
});
cljs_time.internal.parse.read_match = (function cljs_time$internal$parse$read_match(match,ch,s){
var c = (cljs.core.count(match) - (1));
var sub = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),c))].join('');
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(match,sub)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sub,cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,c,cljs.core.count(s))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join('')], null);
}
});
cljs_time.internal.parse.alpha_QMARK_ = (function cljs_time$internal$parse$alpha_QMARK_(ch){
return cljs.core.re_find(/[a-zA-Z]/,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ch)].join(''));
});
cljs_time.internal.parse.read = (function cljs_time$internal$parse$read(s){
var vec__13841 = s;
var seq__13842 = cljs.core.seq(vec__13841);
var first__13843 = cljs.core.first(seq__13842);
var seq__13842__$1 = cljs.core.next(seq__13842);
var h = first__13843;
var more = seq__13842__$1;
var f = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,"'"))?cljs_time.internal.parse.read_quoted:(cljs.core.truth_(cljs_time.internal.parse.alpha_QMARK_(h))?cljs_time.internal.parse.read_token:cljs_time.internal.parse.read_punctuation
));
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(h,more) : f.call(null,h,more));
});
cljs_time.internal.parse.read_pattern = (function cljs_time$internal$parse$read_pattern(s){
var s__$1 = s;
var out = cljs.core.PersistentVector.EMPTY;
while(true){
var vec__13847 = cljs_time.internal.parse.read(s__$1);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13847,(0),null);
var s__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13847,(1),null);
var out__$1 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out,h);
if(cljs.core.seq(s__$2)){
var G__13850 = s__$2;
var G__13851 = out__$1;
s__$1 = G__13850;
out = G__13851;
continue;
} else {
return out__$1;
}
break;
}
});
cljs_time.internal.parse.parse_match = (function cljs_time$internal$parse$parse_match(s,key,match){
var vec__13855 = cljs_time.internal.parse.read_match(match,cljs.core.first(s),clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.rest(s)));
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13855,(0),null);
var s_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13855,(1),null);
if(cljs.core.truth_(m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,m], null),s_SINGLEQUOTE_], null);
} else {
return null;
}
});
cljs_time.internal.parse.parse_number = (function cljs_time$internal$parse$parse_number(var_args){
var args13859 = [];
var len__8304__auto___13867 = arguments.length;
var i__8305__auto___13868 = (0);
while(true){
if((i__8305__auto___13868 < len__8304__auto___13867)){
args13859.push((arguments[i__8305__auto___13868]));

var G__13869 = (i__8305__auto___13868 + (1));
i__8305__auto___13868 = G__13869;
continue;
} else {
}
break;
}

var G__13861 = args13859.length;
switch (G__13861) {
case 2:
return cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13859.length)].join('')));

}
});

cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$2 = (function (s,limit){
return cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3(s,(1),limit);
});

cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3 = (function (s,lower,upper){
var vec__13862 = cljs_time.internal.parse.read_while((function (p1__13858_SHARP_){
return cljs.core.re_find(/\d/,p1__13858_SHARP_);
}),s);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13862,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13862,(1),null);
if((cljs.core.count(n) >= lower)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__13865 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take.cljs$core$IFn$_invoke$arity$2(upper,n));
return parseInt(G__13865);
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(upper,n),s__$1)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__13866 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,n);
return parseInt(G__13866);
})(),s__$1], null);
}
});

cljs_time.internal.parse.parse_number.cljs$lang$maxFixedArity = 3;

cljs_time.internal.parse.parse_period = (function cljs_time$internal$parse$parse_period(var_args){
var args13871 = [];
var len__8304__auto___13877 = arguments.length;
var i__8305__auto___13878 = (0);
while(true){
if((i__8305__auto___13878 < len__8304__auto___13877)){
args13871.push((arguments[i__8305__auto___13878]));

var G__13879 = (i__8305__auto___13878 + (1));
i__8305__auto___13878 = G__13879;
continue;
} else {
}
break;
}

var G__13873 = args13871.length;
switch (G__13873) {
case 3:
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13871.length)].join('')));

}
});

cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$3 = (function (s,period,limit){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,period,(1),limit);
});

cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4 = (function (s,period,lower,upper){
var vec__13874 = cljs_time.internal.parse.parse_number.cljs$core$IFn$_invoke$arity$3(s,lower,upper);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13874,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13874,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [period,n], null),s__$1], null);
});

cljs_time.internal.parse.parse_period.cljs$lang$maxFixedArity = 4;

cljs_time.internal.parse.parse_year = (function cljs_time$internal$parse$parse_year(var_args){
var args13881 = [];
var len__8304__auto___13884 = arguments.length;
var i__8305__auto___13885 = (0);
while(true){
if((i__8305__auto___13885 < len__8304__auto___13884)){
args13881.push((arguments[i__8305__auto___13885]));

var G__13886 = (i__8305__auto___13885 + (1));
i__8305__auto___13885 = G__13886;
continue;
} else {
}
break;
}

var G__13883 = args13881.length;
switch (G__13883) {
case 1:
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13881.length)].join('')));

}
});

cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$years,lower,upper);
});
});

cljs_time.internal.parse.parse_year.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_weekyear = (function cljs_time$internal$parse$parse_weekyear(var_args){
var args13888 = [];
var len__8304__auto___13891 = arguments.length;
var i__8305__auto___13892 = (0);
while(true){
if((i__8305__auto___13892 < len__8304__auto___13891)){
args13888.push((arguments[i__8305__auto___13892]));

var G__13893 = (i__8305__auto___13892 + (1));
i__8305__auto___13892 = G__13893;
continue;
} else {
}
break;
}

var G__13890 = args13888.length;
switch (G__13890) {
case 1:
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13888.length)].join('')));

}
});

cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$weekyear,lower,upper);
});
});

cljs_time.internal.parse.parse_weekyear.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_weekyear_week = (function cljs_time$internal$parse$parse_weekyear_week(var_args){
var args13895 = [];
var len__8304__auto___13898 = arguments.length;
var i__8305__auto___13899 = (0);
while(true){
if((i__8305__auto___13899 < len__8304__auto___13898)){
args13895.push((arguments[i__8305__auto___13899]));

var G__13900 = (i__8305__auto___13899 + (1));
i__8305__auto___13899 = G__13900;
continue;
} else {
}
break;
}

var G__13897 = args13895.length;
switch (G__13897) {
case 1:
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13895.length)].join('')));

}
});

cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$weekyear_DASH_week,lower,upper);
});
});

cljs_time.internal.parse.parse_weekyear_week.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_month = (function cljs_time$internal$parse$parse_month(var_args){
var args13902 = [];
var len__8304__auto___13905 = arguments.length;
var i__8305__auto___13906 = (0);
while(true){
if((i__8305__auto___13906 < len__8304__auto___13905)){
args13902.push((arguments[i__8305__auto___13906]));

var G__13907 = (i__8305__auto___13906 + (1));
i__8305__auto___13906 = G__13907;
continue;
} else {
}
break;
}

var G__13904 = args13902.length;
switch (G__13904) {
case 1:
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13902.length)].join('')));

}
});

cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$months,lower,upper);
});
});

cljs_time.internal.parse.parse_month.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_day = (function cljs_time$internal$parse$parse_day(var_args){
var args13909 = [];
var len__8304__auto___13912 = arguments.length;
var i__8305__auto___13913 = (0);
while(true){
if((i__8305__auto___13913 < len__8304__auto___13912)){
args13909.push((arguments[i__8305__auto___13913]));

var G__13914 = (i__8305__auto___13913 + (1));
i__8305__auto___13913 = G__13914;
continue;
} else {
}
break;
}

var G__13911 = args13909.length;
switch (G__13911) {
case 1:
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13909.length)].join('')));

}
});

cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$days,lower,upper);
});
});

cljs_time.internal.parse.parse_day.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_hours = (function cljs_time$internal$parse$parse_hours(var_args){
var args13916 = [];
var len__8304__auto___13919 = arguments.length;
var i__8305__auto___13920 = (0);
while(true){
if((i__8305__auto___13920 < len__8304__auto___13919)){
args13916.push((arguments[i__8305__auto___13920]));

var G__13921 = (i__8305__auto___13920 + (1));
i__8305__auto___13920 = G__13921;
continue;
} else {
}
break;
}

var G__13918 = args13916.length;
switch (G__13918) {
case 1:
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13916.length)].join('')));

}
});

cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$hours,lower,upper);
});
});

cljs_time.internal.parse.parse_hours.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_HOURS = (function cljs_time$internal$parse$parse_HOURS(var_args){
var args13923 = [];
var len__8304__auto___13926 = arguments.length;
var i__8305__auto___13927 = (0);
while(true){
if((i__8305__auto___13927 < len__8304__auto___13926)){
args13923.push((arguments[i__8305__auto___13927]));

var G__13928 = (i__8305__auto___13927 + (1));
i__8305__auto___13927 = G__13928;
continue;
} else {
}
break;
}

var G__13925 = args13923.length;
switch (G__13925) {
case 1:
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13923.length)].join('')));

}
});

cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$HOURS,lower,upper);
});
});

cljs_time.internal.parse.parse_HOURS.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_minutes = (function cljs_time$internal$parse$parse_minutes(var_args){
var args13930 = [];
var len__8304__auto___13933 = arguments.length;
var i__8305__auto___13934 = (0);
while(true){
if((i__8305__auto___13934 < len__8304__auto___13933)){
args13930.push((arguments[i__8305__auto___13934]));

var G__13935 = (i__8305__auto___13934 + (1));
i__8305__auto___13934 = G__13935;
continue;
} else {
}
break;
}

var G__13932 = args13930.length;
switch (G__13932) {
case 1:
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13930.length)].join('')));

}
});

cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$minutes,lower,upper);
});
});

cljs_time.internal.parse.parse_minutes.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_seconds = (function cljs_time$internal$parse$parse_seconds(var_args){
var args13937 = [];
var len__8304__auto___13940 = arguments.length;
var i__8305__auto___13941 = (0);
while(true){
if((i__8305__auto___13941 < len__8304__auto___13940)){
args13937.push((arguments[i__8305__auto___13941]));

var G__13942 = (i__8305__auto___13941 + (1));
i__8305__auto___13941 = G__13942;
continue;
} else {
}
break;
}

var G__13939 = args13937.length;
switch (G__13939) {
case 1:
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13937.length)].join('')));

}
});

cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$seconds,lower,upper);
});
});

cljs_time.internal.parse.parse_seconds.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.parse_millis = (function cljs_time$internal$parse$parse_millis(var_args){
var args13944 = [];
var len__8304__auto___13947 = arguments.length;
var i__8305__auto___13948 = (0);
while(true){
if((i__8305__auto___13948 < len__8304__auto___13947)){
args13944.push((arguments[i__8305__auto___13948]));

var G__13949 = (i__8305__auto___13948 + (1));
i__8305__auto___13948 = G__13949;
continue;
} else {
}
break;
}

var G__13946 = args13944.length;
switch (G__13946) {
case 1:
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13944.length)].join('')));

}
});

cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$1 = (function (limit){
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((1),limit);
});

cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2 = (function (lower,upper){
return (function (s){
return cljs_time.internal.parse.parse_period.cljs$core$IFn$_invoke$arity$4(s,cljs.core.cst$kw$millis,lower,upper);
});
});

cljs_time.internal.parse.parse_millis.cljs$lang$maxFixedArity = 2;

cljs_time.internal.parse.timezone_adj = (function cljs_time$internal$parse$timezone_adj(sign,hh,mm){
var hh__$1 = parseInt(hh,(10));
var mm__$1 = parseInt(mm,(10));
var mins = ((hh__$1 * (60)) + mm__$1);
var adj_fn = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sign,"+"))?cljs.core._:cljs.core._PLUS_);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$timezone,(new goog.date.Interval(goog.date.Interval.MINUTES,(adj_fn.cljs$core$IFn$_invoke$arity$1 ? adj_fn.cljs$core$IFn$_invoke$arity$1(mins) : adj_fn.call(null,mins))))], null);
});
cljs_time.internal.parse.parse_timezone = (function cljs_time$internal$parse$parse_timezone(fmt){
return (function (s){
var vec__13968 = s;
var seq__13969 = cljs.core.seq(vec__13968);
var first__13970 = cljs.core.first(seq__13969);
var seq__13969__$1 = cljs.core.next(seq__13969);
var h = first__13970;
var more = seq__13969__$1;
var err = ((function (vec__13968,seq__13969,first__13970,seq__13969__$1,h,more){
return (function (){
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid timezone format: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error], null));
});})(vec__13968,seq__13969,first__13970,seq__13969__$1,h,more))
;
var dddd = ((function (vec__13968,seq__13969,first__13970,seq__13969__$1,h,more,err){
return (function (p1__13951_SHARP_){
var tz_QMARK_ = clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.take.cljs$core$IFn$_invoke$arity$2((4),more));
var temp__4657__auto__ = cljs.core.re_find(/^(\d{2})(\d{2})/,tz_QMARK_);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__13971 = temp__4657__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13971,(0),null);
var hh = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13971,(1),null);
var mm = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13971,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.timezone_adj(p1__13951_SHARP_,hh,mm),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((4),more)], null);
} else {
return null;
}
});})(vec__13968,seq__13969,first__13970,seq__13969__$1,h,more,err))
;
var long$ = ((function (vec__13968,seq__13969,first__13970,seq__13969__$1,h,more,err,dddd){
return (function (p1__13952_SHARP_){
var tz_QMARK_ = clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.take.cljs$core$IFn$_invoke$arity$2((5),more));
var temp__4657__auto__ = cljs.core.re_find(/^(\d{2}):(\d{2})/,tz_QMARK_);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__13974 = temp__4657__auto__;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13974,(0),null);
var hh = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13974,(1),null);
var mm = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13974,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs_time.internal.parse.timezone_adj(p1__13952_SHARP_,hh,mm),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((5),more)], null);
} else {
return null;
}
});})(vec__13968,seq__13969,first__13970,seq__13969__$1,h,more,err,dddd))
;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["+",null,"-",null], null), null).call(null,h))){
var G__13977 = (((fmt instanceof cljs.core.Keyword))?fmt.fqn:null);
switch (G__13977) {
case "dddd":
var or__7191__auto__ = dddd(h);
if(cljs.core.truth_(or__7191__auto__)){
return or__7191__auto__;
} else {
var or__7191__auto____$1 = long$(h);
if(cljs.core.truth_(or__7191__auto____$1)){
return or__7191__auto____$1;
} else {
throw err();
}
}

break;
case "long":
var or__7191__auto__ = dddd(h);
if(cljs.core.truth_(or__7191__auto__)){
return or__7191__auto__;
} else {
var or__7191__auto____$1 = long$(h);
if(cljs.core.truth_(or__7191__auto____$1)){
return or__7191__auto____$1;
} else {
throw err();
}
}

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join('')));

}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(h,"Z")){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$timezone,cljs_time.internal.parse.timezone_adj(cljs.core._PLUS_,"0","0")], null)], null);
} else {
var G__13978 = (((fmt instanceof cljs.core.Keyword))?fmt.fqn:null);
switch (G__13978) {
case "abbr":
var tz_QMARK_ = cljs.core.take.cljs$core$IFn$_invoke$arity$2((3),s);
var vec__13979 = cljs_time.internal.parse.read_while(((function (tz_QMARK_,G__13978,vec__13968,seq__13969,first__13970,seq__13969__$1,h,more,err,dddd,long$){
return (function (p1__13953_SHARP_){
return cljs.core.re_find(/[A-Z]/,p1__13953_SHARP_);
});})(tz_QMARK_,G__13978,vec__13968,seq__13969,first__13970,seq__13969__$1,h,more,err,dddd,long$))
,tz_QMARK_);
var tz = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13979,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13979,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(tz),(3))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$timezone,clojure.string.join.cljs$core$IFn$_invoke$arity$1(tz)], null),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((3),s)], null);
} else {
throw err();
}

break;
case "full":
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot parse long form timezone:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error], null));

break;
default:
throw err();

}

}
}
});
});
cljs_time.internal.parse.parse_meridiem = (function cljs_time$internal$parse$parse_meridiem(){
return (function (s){
var vec__13993 = cljs.core.split_at((2),s);
var vec__13996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13993,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13996,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13996,(1),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13993,(1),null);
var meridiem = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(m),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('');
var vec__13999 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["AM",null,"am",null,"pm",null,"PM",null], null), null).call(null,meridiem))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [meridiem,s__$1], null):(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["a",null,"p",null], null), null).call(null,m))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, ["a","am","p","pm"], null).call(null,m),cljs.core.cons(n,s__$1)], null):(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["A",null,"P",null], null), null).call(null,m))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, ["A","am","P","pm"], null).call(null,m),cljs.core.cons(n,s__$1)], null):null)));
var meridiem__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13999,(0),null);
var s__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13999,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meridiem,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(meridiem__$1)], null),clojure.string.join.cljs$core$IFn$_invoke$arity$1(s__$2)], null);
});
});
cljs_time.internal.parse.parse_period_name = (function cljs_time$internal$parse$parse_period_name(s,period,periods,short_QMARK_){
var periods__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(periods,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14002_SHARP_){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(p1__14002_SHARP_,(0),(3));
}),periods));
var vec__14007 = cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,s),cljs.core.second),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (periods__$1){
return (function (p1__14003_SHARP_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14003_SHARP_,cljs_time.internal.parse.replace(s,cljs.core.re_pattern([cljs.core.str.cljs$core$IFn$_invoke$arity$1("^"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__14003_SHARP_)].join('')),"")], null);
});})(periods__$1))
,periods__$1)));
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14007,(0),null);
var s__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14007,(1),null);
if(cljs.core.truth_(m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [period,cljs.core.mod(cljs_time.internal.core.index_of(periods__$1,m),(12))], null),s__$1], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Could not parse "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(period)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" name")].join(''),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error,cljs.core.cst$kw$sub_DASH_type,cljs.core.cst$kw$period_DASH_match_DASH_erroro,cljs.core.cst$kw$period,period,cljs.core.cst$kw$in,s__$1], null));
}
});
cljs_time.internal.parse.parse_month_name = (function cljs_time$internal$parse$parse_month_name(short_QMARK_){
return (function (s){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs_time.internal.parse.parse_period_name(s,cljs.core.cst$kw$months,cljs_time.internal.core.months,short_QMARK_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.inc);
});
});
cljs_time.internal.parse.parse_day_name = (function cljs_time$internal$parse$parse_day_name(short_QMARK_){
return (function (s){
return cljs_time.internal.parse.parse_period_name(s,cljs.core.cst$kw$days,cljs_time.internal.core.days,short_QMARK_);
});
});
cljs_time.internal.parse.parse_quoted = (function cljs_time$internal$parse$parse_quoted(quoted){
return (function (s){
var s_SINGLEQUOTE_ = cljs_time.internal.parse.replace(s,cljs.core.re_pattern([cljs.core.str.cljs$core$IFn$_invoke$arity$1("^"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(quoted)].join('')),"");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s,s_SINGLEQUOTE_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Quoted text not found",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error,cljs.core.cst$kw$where,cljs.core.cst$kw$parse_DASH_quoted], null));
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$quoted,quoted], null),s_SINGLEQUOTE_], null);
}
});
});
cljs_time.internal.parse.parse_ordinal_suffix = (function cljs_time$internal$parse$parse_ordinal_suffix(){
return (function (s){
var or__7191__auto__ = cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"st");
if(cljs.core.truth_(or__7191__auto__)){
return or__7191__auto__;
} else {
var or__7191__auto____$1 = cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"nd");
if(cljs.core.truth_(or__7191__auto____$1)){
return or__7191__auto____$1;
} else {
var or__7191__auto____$2 = cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"rd");
if(cljs.core.truth_(or__7191__auto____$2)){
return or__7191__auto____$2;
} else {
return cljs_time.internal.parse.parse_match(s,cljs.core.cst$kw$ordinal_DASH_suffix,"th");
}
}
}
});
});
cljs_time.internal.parse.lookup = (function cljs_time$internal$parse$lookup(p__14010){
var vec__14015 = p__14010;
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14015,(0),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14015,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.cst$kw$token)){
var G__14018 = pattern;
switch (G__14018) {
case "S":
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "SSS":
return cljs_time.internal.parse.parse_millis.cljs$core$IFn$_invoke$arity$2((3),(3));

break;
case "s":
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "ss":
return cljs_time.internal.parse.parse_seconds.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "m":
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "mm":
return cljs_time.internal.parse.parse_minutes.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "h":
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "hh":
return cljs_time.internal.parse.parse_hours.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "H":
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "HH":
return cljs_time.internal.parse.parse_HOURS.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "d":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "dd":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "D":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((1),(3));

break;
case "DD":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((2),(3));

break;
case "DDD":
return cljs_time.internal.parse.parse_day.cljs$core$IFn$_invoke$arity$2((3),(3));

break;
case "M":
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "MM":
return cljs_time.internal.parse.parse_month.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "MMM":
return cljs_time.internal.parse.parse_month_name(true);

break;
case "MMMM":
return cljs_time.internal.parse.parse_month_name(false);

break;
case "y":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),(4));

break;
case "yy":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "yyyy":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((4),(4));

break;
case "Y":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((1),(4));

break;
case "YY":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "YYYY":
return cljs_time.internal.parse.parse_year.cljs$core$IFn$_invoke$arity$2((4),(4));

break;
case "x":
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((1),(4));

break;
case "xx":
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "xxxx":
return cljs_time.internal.parse.parse_weekyear.cljs$core$IFn$_invoke$arity$2((4),(4));

break;
case "w":
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2((1),(2));

break;
case "ww":
return cljs_time.internal.parse.parse_weekyear_week.cljs$core$IFn$_invoke$arity$2((2),(2));

break;
case "E":
return cljs_time.internal.parse.parse_day_name(true);

break;
case "EEE":
return cljs_time.internal.parse.parse_day_name(true);

break;
case "EEEE":
return cljs_time.internal.parse.parse_day_name(false);

break;
case "a":
return cljs_time.internal.parse.parse_meridiem();

break;
case "A":
return cljs_time.internal.parse.parse_meridiem();

break;
case "Z":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$dddd);

break;
case "ZZ":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$long);

break;
case "ZZZ":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "ZZZZ":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "z":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "zz":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "zzz":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$abbr);

break;
case "zzzz":
return cljs_time.internal.parse.parse_timezone(cljs.core.cst$kw$full);

break;
case "o":
return cljs_time.internal.parse.parse_ordinal_suffix();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Illegal pattern component: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(pattern)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,cljs.core.cst$kw$illegal_DASH_pattern], null));

}
} else {
return cljs_time.internal.parse.parse_quoted(pattern);
}
});
cljs_time.internal.parse.parse = (function cljs_time$internal$parse$parse(pattern,value){
var s = value;
var G__14036 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_time.internal.parse.lookup,cljs_time.internal.parse.read_pattern(pattern));
var vec__14037 = G__14036;
var seq__14038 = cljs.core.seq(vec__14037);
var first__14039 = cljs.core.first(seq__14038);
var seq__14038__$1 = cljs.core.next(seq__14038);
var parser = first__14039;
var more = seq__14038__$1;
var out = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
var G__14036__$1 = G__14036;
var out__$1 = out;
while(true){
var s__$2 = s__$1;
var vec__14040 = G__14036__$1;
var seq__14041 = cljs.core.seq(vec__14040);
var first__14042 = cljs.core.first(seq__14041);
var seq__14041__$1 = cljs.core.next(seq__14041);
var parser__$1 = first__14042;
var more__$1 = seq__14041__$1;
var out__$2 = out__$1;
var err = ((function (s__$1,G__14036__$1,out__$1,s__$2,vec__14040,seq__14041,first__14042,seq__14041__$1,parser__$1,more__$1,out__$2,s,G__14036,vec__14037,seq__14038,first__14039,seq__14038__$1,parser,more,out){
return (function (){
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid format: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" is malformed at "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([s__$2], 0)))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_error,cljs.core.cst$kw$sub_DASH_type,cljs.core.cst$kw$invalid_DASH_format], null));
});})(s__$1,G__14036__$1,out__$1,s__$2,vec__14040,seq__14041,first__14042,seq__14041__$1,parser__$1,more__$1,out__$2,s,G__14036,vec__14037,seq__14038,first__14039,seq__14038__$1,parser,more,out))
;
if(cljs.core.seq(s__$2)){
if((parser__$1 == null)){
throw err();
} else {
var vec__14043 = (parser__$1.cljs$core$IFn$_invoke$arity$1 ? parser__$1.cljs$core$IFn$_invoke$arity$1(s__$2) : parser__$1.call(null,s__$2));
var value__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14043,(0),null);
var s__$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14043,(1),null);
var G__14046 = s__$3;
var G__14047 = more__$1;
var G__14048 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out__$2,value__$1);
s__$1 = G__14046;
G__14036__$1 = G__14047;
out__$1 = G__14048;
continue;
}
} else {
if(cljs.core.truth_(parser__$1)){
throw err();
} else {
return out__$2;
}
}
break;
}
});
cljs_time.internal.parse.compile = (function cljs_time$internal$parse$compile(class$,p__14049,values){
var map__14056 = p__14049;
var map__14056__$1 = ((((!((map__14056 == null)))?((((map__14056.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14056.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14056):map__14056);
var fmt = map__14056__$1;
var default_year = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14056__$1,cljs.core.cst$kw$default_DASH_year);
var map__14058 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$quoted,null], null), null),cljs.core.first),values));
var map__14058__$1 = ((((!((map__14058 == null)))?((((map__14058.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14058.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14058):map__14058);
var date_map = map__14058__$1;
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,cljs.core.cst$kw$minutes);
var HOURS = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,cljs.core.cst$kw$HOURS);
var millis = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,cljs.core.cst$kw$millis);
var timezone = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,cljs.core.cst$kw$timezone);
var meridiem = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,cljs.core.cst$kw$meridiem);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,cljs.core.cst$kw$months);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,cljs.core.cst$kw$days);
var seconds = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,cljs.core.cst$kw$seconds);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,cljs.core.cst$kw$hours);
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14058__$1,cljs.core.cst$kw$years);
var years__$1 = (function (){var or__7191__auto__ = years;
if(cljs.core.truth_(or__7191__auto__)){
return or__7191__auto__;
} else {
var or__7191__auto____$1 = default_year;
if(cljs.core.truth_(or__7191__auto____$1)){
return or__7191__auto____$1;
} else {
return (0);
}
}
})();
var months__$1 = (cljs.core.truth_(months)?(months - (1)):null);
var hours__$1 = (cljs.core.truth_(meridiem)?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$PM,null,cljs.core.cst$kw$pm,null], null), null).call(null,meridiem))?(function (){var hours__$1 = (hours + (12));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hours__$1,(24))){
return (12);
} else {
return hours__$1;
}
})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hours,(12)))?(0):hours)):HOURS);
var date_map__$1 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(date_map,cljs.core.cst$kw$hours,hours__$1),cljs.core.cst$kw$HOURS,cljs.core.array_seq([cljs.core.cst$kw$meridiem], 0));
var timezone__$1 = (((timezone instanceof goog.date.Interval))?timezone:(new goog.date.Interval(goog.date.Interval.SECONDS,(0))));
cljs_time.internal.core.valid_date_QMARK_(date_map__$1);

var G__14060 = (function (){var G__14061 = (((class$ instanceof cljs.core.Keyword))?class$.fqn:null);
switch (G__14061) {
case "goog.date.Date":
return (new goog.date.Date(years__$1,months__$1,days));

break;
case "goog.date.DateTime":
return (new goog.date.DateTime(years__$1,months__$1,days,hours__$1,minutes,seconds,millis));

break;
case "goog.date.UtcDateTime":
return (new goog.date.UtcDateTime(years__$1,months__$1,days,hours__$1,minutes,seconds,millis));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)].join('')));

}
})();
G__14060.add(timezone__$1);

return G__14060;
});
