// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.camera.core');
goog.require('cljs.core');
goog.require('camelot.rest');
goog.require('camelot.nav');
goog.require('om.dom');
goog.require('camelot.util.filter');
goog.require('camelot.component.util');
goog.require('cljs.core.async');
goog.require('camelot.translation.core');
goog.require('camelot.util.cursorise');
goog.require('om.core');
goog.require('camelot.component.camera.manage');
goog.require('clojure.string');
/**
 * Delete the camera and trigger a removal event.
 */
camelot.component.camera.core.delete$ = (function camelot$component$camera$core$delete(state,data,event){
event.preventDefault();

event.stopPropagation();

if(cljs.core.truth_((function (){var G__34012 = camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_confirm_DASH_delete);
return confirm(G__34012);
})())){
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str("/cameras/"),cljs.core.str(cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(data))].join(''),(function (){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_34020){
var state_val_34021 = (state_34020[(1)]);
if((state_val_34021 === (1))){
var inst_34013 = cljs.core.cst$kw$chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_34014 = [cljs.core.cst$kw$event,cljs.core.cst$kw$data];
var inst_34015 = [cljs.core.cst$kw$delete,data];
var inst_34016 = cljs.core.PersistentHashMap.fromArrays(inst_34014,inst_34015);
var state_34020__$1 = state_34020;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34020__$1,(2),inst_34013,inst_34016);
} else {
if((state_val_34021 === (2))){
var inst_34018 = (state_34020[(2)]);
var state_34020__$1 = state_34020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34020__$1,inst_34018);
} else {
return null;
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$component$camera$core$delete_$_state_machine__28453__auto__ = null;
var camelot$component$camera$core$delete_$_state_machine__28453__auto____0 = (function (){
var statearr_34025 = [null,null,null,null,null,null,null];
(statearr_34025[(0)] = camelot$component$camera$core$delete_$_state_machine__28453__auto__);

(statearr_34025[(1)] = (1));

return statearr_34025;
});
var camelot$component$camera$core$delete_$_state_machine__28453__auto____1 = (function (state_34020){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_34020);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e34026){if((e34026 instanceof Object)){
var ex__28456__auto__ = e34026;
var statearr_34027_34029 = state_34020;
(statearr_34027_34029[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34020);

return cljs.core.cst$kw$recur;
} else {
throw e34026;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__34030 = state_34020;
state_34020 = G__34030;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$camera$core$delete_$_state_machine__28453__auto__ = function(state_34020){
switch(arguments.length){
case 0:
return camelot$component$camera$core$delete_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$camera$core$delete_$_state_machine__28453__auto____1.call(this,state_34020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$camera$core$delete_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$camera$core$delete_$_state_machine__28453__auto____0;
camelot$component$camera$core$delete_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$camera$core$delete_$_state_machine__28453__auto____1;
return camelot$component$camera$core$delete_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_34028 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_34028[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_34028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
}));
} else {
return null;
}
});
camelot.component.camera.core.add_success_handler = (function camelot$component$camera$core$add_success_handler(data,resp){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$list,(function (p1__34031_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34031_SHARP_,camelot.util.cursorise.decursorise(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp)));
}));

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$new_DASH_camera_DASH_name,null);
});
camelot.component.camera.core.add_camera_handler = (function camelot$component$camera$core$add_camera_handler(data){
camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3("/cameras",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$new_DASH_camera_DASH_name.cljs$core$IFn$_invoke$arity$1(data)], null)], null),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.component.camera.core.add_success_handler,data));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-camera","create-click");
});
camelot.component.camera.core.validate_proposed_camera = (function camelot$component$camera$core$validate_proposed_camera(data){
return cljs.core.not((function (){var or__6417__auto__ = (cljs.core.cst$kw$new_DASH_camera_DASH_name.cljs$core$IFn$_invoke$arity$1(data) == null);
if(or__6417__auto__){
return or__6417__auto__;
} else {
var camera = clojure.string.lower_case(clojure.string.trim(cljs.core.cst$kw$new_DASH_camera_DASH_name.cljs$core$IFn$_invoke$arity$1(data)));
var or__6417__auto____$1 = cljs.core.empty_QMARK_(camera);
if(or__6417__auto____$1){
return or__6417__auto____$1;
} else {
return cljs.core.some(((function (or__6417__auto____$1,camera,or__6417__auto__){
return (function (p1__34032_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(camera,clojure.string.lower_case(clojure.string.trim(p1__34032_SHARP_)));
});})(or__6417__auto____$1,camera,or__6417__auto__))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(data)));
}
}
})());
});
camelot.component.camera.core.add_camera_component = (function camelot$component$camera$core$add_camera_component(data,owner){
if(typeof camelot.component.camera.core.t_camelot$component$camera$core34043 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.camera.core.t_camelot$component$camera$core34043 = (function (add_camera_component,data,owner,meta34044){
this.add_camera_component = add_camera_component;
this.data = data;
this.owner = owner;
this.meta34044 = meta34044;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.camera.core.t_camelot$component$camera$core34043.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34045,meta34044__$1){
var self__ = this;
var _34045__$1 = this;
return (new camelot.component.camera.core.t_camelot$component$camera$core34043(self__.add_camera_component,self__.data,self__.owner,meta34044__$1));
});

camelot.component.camera.core.t_camelot$component$camera$core34043.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34045){
var self__ = this;
var _34045__$1 = this;
return self__.meta34044;
});

camelot.component.camera.core.t_camelot$component$camera$core34043.prototype.om$core$IRender$ = true;

camelot.component.camera.core.t_camelot$component$camera$core34043.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var is_valid = camelot.component.camera.core.validate_proposed_camera(self__.data);
var G__34046 = ({"className": "field-input-form", "onSubmit": ((function (is_valid,___$1){
return (function (p1__34033_SHARP_){
return p1__34033_SHARP_.preventDefault();
});})(is_valid,___$1))
});
var G__34047 = om.util.force_children((function (){var G__34049 = ({"className": "field-input", "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_new_DASH_camera_DASH_name_DASH_placeholder), "value": cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_camera_DASH_name], null)), "onChange": ((function (G__34046,is_valid,___$1){
return (function (p1__34034_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$new_DASH_camera_DASH_name,p1__34034_SHARP_.target.value);
});})(G__34046,is_valid,___$1))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__34049) : om.dom.input.call(null,G__34049));
})());
var G__34048 = om.util.force_children((function (){var G__34050 = ({"type": "submit", "disabled": (cljs.core.truth_(is_valid)?"":"disabled"), "title": (cljs.core.truth_(is_valid)?null:camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_invalid_DASH_title)), "className": "btn btn-primary input-field-submit", "onClick": ((function (G__34046,G__34047,is_valid,___$1){
return (function (){
return camelot.component.camera.core.add_camera_handler(self__.data);
});})(G__34046,G__34047,is_valid,___$1))
, "value": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_add)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__34050) : om.dom.input.call(null,G__34050));
})());
return React.DOM.form(G__34046,G__34047,G__34048);
});

camelot.component.camera.core.t_camelot$component$camera$core34043.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$add_DASH_camera_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta34044], null);
});

camelot.component.camera.core.t_camelot$component$camera$core34043.cljs$lang$type = true;

camelot.component.camera.core.t_camelot$component$camera$core34043.cljs$lang$ctorStr = "camelot.component.camera.core/t_camelot$component$camera$core34043";

camelot.component.camera.core.t_camelot$component$camera$core34043.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.camera.core/t_camelot$component$camera$core34043");
});

camelot.component.camera.core.__GT_t_camelot$component$camera$core34043 = (function camelot$component$camera$core$add_camera_component_$___GT_t_camelot$component$camera$core34043(add_camera_component__$1,data__$1,owner__$1,meta34044){
return (new camelot.component.camera.core.t_camelot$component$camera$core34043(add_camera_component__$1,data__$1,owner__$1,meta34044));
});

}

return (new camelot.component.camera.core.t_camelot$component$camera$core34043(camelot$component$camera$core$add_camera_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.camera.core.camera_list_component = (function camelot$component$camera$core$camera_list_component(data,owner){
if(typeof camelot.component.camera.core.t_camelot$component$camera$core34066 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.camera.core.t_camelot$component$camera$core34066 = (function (camera_list_component,data,owner,meta34067){
this.camera_list_component = camera_list_component;
this.data = data;
this.owner = owner;
this.meta34067 = meta34067;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.camera.core.t_camelot$component$camera$core34066.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34068,meta34067__$1){
var self__ = this;
var _34068__$1 = this;
return (new camelot.component.camera.core.t_camelot$component$camera$core34066(self__.camera_list_component,self__.data,self__.owner,meta34067__$1));
});

camelot.component.camera.core.t_camelot$component$camera$core34066.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34068){
var self__ = this;
var _34068__$1 = this;
return self__.meta34067;
});

camelot.component.camera.core.t_camelot$component$camera$core34066.prototype.om$core$IRenderState$ = true;

camelot.component.camera.core.t_camelot$component$camera$core34066.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__34069 = ({"className": "menu-item detailed dynamic", "onClick": ((function (___$1){
return (function (){
return camelot.nav.nav_BANG_([cljs.core.str("/camera/"),cljs.core.str(cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data))].join(''));
});})(___$1))
});
var G__34070 = om.util.force_children((function (){var G__34074 = ({"className": "pull-right fa fa-times remove top-corner", "onClick": cljs.core.partial.cljs$core$IFn$_invoke$arity$3(camelot.component.camera.core.delete$,state,self__.data)});
return React.DOM.div(G__34074);
})());
var G__34071 = om.util.force_children((function (){var G__34075 = ({"className": "status pull-right"});
var G__34076 = om.util.force_children(cljs.core.cst$kw$camera_DASH_status_DASH_description.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__34075,G__34076);
})());
var G__34072 = om.util.force_children((function (){var G__34077 = ({"className": "menu-item-title"});
var G__34078 = om.util.force_children(cljs.core.cst$kw$camera_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__34077,G__34078);
})());
var G__34073 = om.util.force_children((function (){var G__34079 = ({"className": "menu-item-description"});
var G__34080 = om.util.force_children(cljs.core.cst$kw$camera_DASH_notes.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__34079,G__34080);
})());
return React.DOM.div(G__34069,G__34070,G__34071,G__34072,G__34073);
});

camelot.component.camera.core.t_camelot$component$camera$core34066.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$camera_DASH_list_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta34067], null);
});

camelot.component.camera.core.t_camelot$component$camera$core34066.cljs$lang$type = true;

camelot.component.camera.core.t_camelot$component$camera$core34066.cljs$lang$ctorStr = "camelot.component.camera.core/t_camelot$component$camera$core34066";

camelot.component.camera.core.t_camelot$component$camera$core34066.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.camera.core/t_camelot$component$camera$core34066");
});

camelot.component.camera.core.__GT_t_camelot$component$camera$core34066 = (function camelot$component$camera$core$camera_list_component_$___GT_t_camelot$component$camera$core34066(camera_list_component__$1,data__$1,owner__$1,meta34067){
return (new camelot.component.camera.core.t_camelot$component$camera$core34066(camera_list_component__$1,data__$1,owner__$1,meta34067));
});

}

return (new camelot.component.camera.core.t_camelot$component$camera$core34066(camelot$component$camera$core$camera_list_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.camera.core.manage_view = (function camelot$component$camera$core$manage_view(data,owner,p__34082){
var map__34091 = p__34082;
var map__34091__$1 = ((((!((map__34091 == null)))?((((map__34091.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34091.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34091):map__34091);
var camera_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34091__$1,cljs.core.cst$kw$camera_DASH_id);
if(typeof camelot.component.camera.core.t_camelot$component$camera$core34093 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.camera.core.t_camelot$component$camera$core34093 = (function (manage_view,data,owner,p__34082,map__34091,camera_id,meta34094){
this.manage_view = manage_view;
this.data = data;
this.owner = owner;
this.p__34082 = p__34082;
this.map__34091 = map__34091;
this.camera_id = camera_id;
this.meta34094 = meta34094;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.camera.core.t_camelot$component$camera$core34093.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__34091,map__34091__$1,camera_id){
return (function (_34095,meta34094__$1){
var self__ = this;
var _34095__$1 = this;
return (new camelot.component.camera.core.t_camelot$component$camera$core34093(self__.manage_view,self__.data,self__.owner,self__.p__34082,self__.map__34091,self__.camera_id,meta34094__$1));
});})(map__34091,map__34091__$1,camera_id))
;

camelot.component.camera.core.t_camelot$component$camera$core34093.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__34091,map__34091__$1,camera_id){
return (function (_34095){
var self__ = this;
var _34095__$1 = this;
return self__.meta34094;
});})(map__34091,map__34091__$1,camera_id))
;

camelot.component.camera.core.t_camelot$component$camera$core34093.prototype.om$core$IWillMount$ = true;

camelot.component.camera.core.t_camelot$component$camera$core34093.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__34091,map__34091__$1,camera_id){
return (function (_){
var self__ = this;
var ___$1 = this;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$data,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str("/cameras/"),cljs.core.str(self__.camera_id)].join(''),((function (___$1,map__34091,map__34091__$1,camera_id){
return (function (p1__34081_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$data,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__34081_SHARP_));

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2("/cameras/",((function (___$1,map__34091,map__34091__$1,camera_id){
return (function (x){
var others = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (___$1,map__34091,map__34091__$1,camera_id){
return (function (v){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__34081_SHARP_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$value], null)),cljs.core.cst$kw$camera_DASH_name.cljs$core$IFn$_invoke$arity$1(v));
});})(___$1,map__34091,map__34091__$1,camera_id))
,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(x));
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,others);
});})(___$1,map__34091,map__34091__$1,camera_id))
);
});})(___$1,map__34091,map__34091__$1,camera_id))
);
});})(map__34091,map__34091__$1,camera_id))
;

camelot.component.camera.core.t_camelot$component$camera$core34093.prototype.om$core$IRender$ = true;

camelot.component.camera.core.t_camelot$component$camera$core34093.prototype.om$core$IRender$render$arity$1 = ((function (map__34091,map__34091__$1,camera_id){
return (function (_){
var self__ = this;
var ___$1 = this;
if((cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data) == null)){
var G__34096 = ({"className": "align-center"});
var G__34097 = om.util.force_children((function (){var G__34098 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__34098);
})());
return React.DOM.div(G__34096,G__34097);
} else {
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.camera.manage.manage_component,self__.data);
}
});})(map__34091,map__34091__$1,camera_id))
;

camelot.component.camera.core.t_camelot$component$camera$core34093.getBasis = ((function (map__34091,map__34091__$1,camera_id){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$manage_DASH_view,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$camera_DASH_id], null)], null)], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__34082,cljs.core.cst$sym$map__34091,cljs.core.cst$sym$camera_DASH_id,cljs.core.cst$sym$meta34094], null);
});})(map__34091,map__34091__$1,camera_id))
;

camelot.component.camera.core.t_camelot$component$camera$core34093.cljs$lang$type = true;

camelot.component.camera.core.t_camelot$component$camera$core34093.cljs$lang$ctorStr = "camelot.component.camera.core/t_camelot$component$camera$core34093";

camelot.component.camera.core.t_camelot$component$camera$core34093.cljs$lang$ctorPrWriter = ((function (map__34091,map__34091__$1,camera_id){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.camera.core/t_camelot$component$camera$core34093");
});})(map__34091,map__34091__$1,camera_id))
;

camelot.component.camera.core.__GT_t_camelot$component$camera$core34093 = ((function (map__34091,map__34091__$1,camera_id){
return (function camelot$component$camera$core$manage_view_$___GT_t_camelot$component$camera$core34093(manage_view__$1,data__$1,owner__$1,p__34082__$1,map__34091__$2,camera_id__$1,meta34094){
return (new camelot.component.camera.core.t_camelot$component$camera$core34093(manage_view__$1,data__$1,owner__$1,p__34082__$1,map__34091__$2,camera_id__$1,meta34094));
});})(map__34091,map__34091__$1,camera_id))
;

}

return (new camelot.component.camera.core.t_camelot$component$camera$core34093(camelot$component$camera$core$manage_view,data,owner,p__34082,map__34091__$1,camera_id,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.camera.core.camera_menu_component = (function camelot$component$camera$core$camera_menu_component(data,owner){
if(typeof camelot.component.camera.core.t_camelot$component$camera$core34155 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.camera.core.t_camelot$component$camera$core34155 = (function (camera_menu_component,data,owner,meta34156){
this.camera_menu_component = camera_menu_component;
this.data = data;
this.owner = owner;
this.meta34156 = meta34156;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34157,meta34156__$1){
var self__ = this;
var _34157__$1 = this;
return (new camelot.component.camera.core.t_camelot$component$camera$core34155(self__.camera_menu_component,self__.data,self__.owner,meta34156__$1));
});

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34157){
var self__ = this;
var _34157__$1 = this;
return self__.meta34156;
});

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.om$core$IInitState$ = true;

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.om$core$IWillMount$ = true;

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);
});

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.om$core$IDidMount$ = true;

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
camelot.rest.get_resource("/cameras",((function (___$1){
return (function (p1__34099_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__34099_SHARP_));
});})(___$1))
);

var ch = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$chan);
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,ch,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,ch,___$1){
return (function (state_34173){
var state_val_34174 = (state_34173[(1)]);
if((state_val_34174 === (1))){
var state_34173__$1 = state_34173;
var statearr_34175_34207 = state_34173__$1;
(statearr_34175_34207[(2)] = null);

(statearr_34175_34207[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34174 === (2))){
var state_34173__$1 = state_34173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34173__$1,(4),ch);
} else {
if((state_val_34174 === (3))){
var inst_34171 = (state_34173[(2)]);
var state_34173__$1 = state_34173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34173__$1,inst_34171);
} else {
if((state_val_34174 === (4))){
var inst_34160 = (state_34173[(7)]);
var inst_34160__$1 = (state_34173[(2)]);
var inst_34161 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(inst_34160__$1);
var inst_34162 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34161,cljs.core.cst$kw$delete);
var state_34173__$1 = (function (){var statearr_34176 = state_34173;
(statearr_34176[(7)] = inst_34160__$1);

return statearr_34176;
})();
if(inst_34162){
var statearr_34177_34208 = state_34173__$1;
(statearr_34177_34208[(1)] = (5));

} else {
var statearr_34178_34209 = state_34173__$1;
(statearr_34178_34209[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34174 === (5))){
var inst_34160 = (state_34173[(7)]);
var inst_34164 = (function (){var r = inst_34160;
return ((function (r,inst_34160,state_val_34174,c__28576__auto__,ch,___$1){
return (function (p1__34100_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (r,inst_34160,state_val_34174,c__28576__auto__,ch,___$1){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(r));
});})(r,inst_34160,state_val_34174,c__28576__auto__,ch,___$1))
,p1__34100_SHARP_);
});
;})(r,inst_34160,state_val_34174,c__28576__auto__,ch,___$1))
})();
var inst_34165 = om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,inst_34164);
var state_34173__$1 = state_34173;
var statearr_34179_34210 = state_34173__$1;
(statearr_34179_34210[(2)] = inst_34165);

(statearr_34179_34210[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34174 === (6))){
var state_34173__$1 = state_34173;
var statearr_34180_34211 = state_34173__$1;
(statearr_34180_34211[(2)] = null);

(statearr_34180_34211[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34174 === (7))){
var inst_34168 = (state_34173[(2)]);
var state_34173__$1 = (function (){var statearr_34181 = state_34173;
(statearr_34181[(8)] = inst_34168);

return statearr_34181;
})();
var statearr_34182_34212 = state_34173__$1;
(statearr_34182_34212[(2)] = null);

(statearr_34182_34212[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__28576__auto__,ch,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto__,ch,___$1){
return (function() {
var camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto__ = null;
var camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto____0 = (function (){
var statearr_34186 = [null,null,null,null,null,null,null,null,null];
(statearr_34186[(0)] = camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto__);

(statearr_34186[(1)] = (1));

return statearr_34186;
});
var camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto____1 = (function (state_34173){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_34173);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e34187){if((e34187 instanceof Object)){
var ex__28456__auto__ = e34187;
var statearr_34188_34213 = state_34173;
(statearr_34188_34213[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34173);

return cljs.core.cst$kw$recur;
} else {
throw e34187;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__34214 = state_34173;
state_34173 = G__34214;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto__ = function(state_34173){
switch(arguments.length){
case 0:
return camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto____1.call(this,state_34173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto____0;
camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto____1;
return camelot$component$camera$core$camera_menu_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,ch,___$1))
})();
var state__28578__auto__ = (function (){var statearr_34189 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_34189[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_34189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,ch,___$1))
);

return c__28576__auto__;
});

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.om$core$IWillUnmount$ = true;

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);
});

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.om$core$IRenderState$ = true;

camelot.component.camera.core.t_camelot$component$camera$core34155.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__34190 = ({"className": "section"});
var G__34191 = om.util.force_children((function (){var G__34196 = null;
var G__34197 = om.util.force_children((function (){var G__34198 = ({"className": "field-input", "value": cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data), "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_filter_DASH_cameras), "onChange": ((function (G__34196,G__34190,___$1){
return (function (p1__34101_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$filter,p1__34101_SHARP_.target.value);
});})(G__34196,G__34190,___$1))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__34198) : om.dom.input.call(null,G__34198));
})());
return React.DOM.div(G__34196,G__34197);
})());
var G__34192 = om.util.force_children((function (){var G__34199 = ({"className": "simple-menu scroll"});
var G__34200 = om.util.force_children((function (){var filtered = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__34199,G__34190,G__34191,___$1){
return (function (p1__34102_SHARP_){
if(((cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data) == null)) || (cljs.core.empty_QMARK_(cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data)))){
return true;
} else {
return cljs.core.re_matches(cljs.core.re_pattern([cljs.core.str("(?i).*"),cljs.core.str(cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data)),cljs.core.str(".*")].join('')),[cljs.core.str(cljs.core.cst$kw$camera_DASH_name.cljs$core$IFn$_invoke$arity$1(p1__34102_SHARP_)),cljs.core.str(cljs.core.cst$kw$camera_DASH_status_DASH_description.cljs$core$IFn$_invoke$arity$1(p1__34102_SHARP_)),cljs.core.str(cljs.core.cst$kw$camera_DASH_notes.cljs$core$IFn$_invoke$arity$1(p1__34102_SHARP_))].join(''));
}
});})(G__34199,G__34190,G__34191,___$1))
,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data)));
if(cljs.core.empty_QMARK_(filtered)){
return om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.blank_slate_component,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$item_DASH_name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_blank_DASH_item_DASH_name),cljs.core.cst$kw$advice,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_blank_DASH_filter_DASH_advice)], null)], null));
} else {
return om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.camera.core.camera_list_component,filtered,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$camera_DASH_id,cljs.core.cst$kw$init_DASH_state,state], null));
}
})());
return React.DOM.div(G__34199,G__34200);
})());
var G__34193 = om.util.force_children((function (){var G__34201 = ({"className": "sep"});
return React.DOM.div(G__34201);
})());
var G__34194 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.camera.core.add_camera_component,self__.data));
var G__34195 = om.util.force_children((function (){var G__34202 = ({"className": "btn btn-default", "onClick": ((function (G__34190,G__34191,G__34192,G__34193,G__34194,___$1){
return (function (){
camelot.nav.nav_BANG_("/cameras");

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-camera","advanced-click");
});})(G__34190,G__34191,G__34192,G__34193,G__34194,___$1))
});
var G__34203 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_advanced));
return React.DOM.button(G__34202,G__34203);
})());
return React.DOM.div(G__34190,G__34191,G__34192,G__34193,G__34194,G__34195);
} else {
var G__34204 = ({"className": "align-center"});
var G__34205 = om.util.force_children((function (){var G__34206 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__34206);
})());
return React.DOM.div(G__34204,G__34205);
}
});

camelot.component.camera.core.t_camelot$component$camera$core34155.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$camera_DASH_menu_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta34156], null);
});

camelot.component.camera.core.t_camelot$component$camera$core34155.cljs$lang$type = true;

camelot.component.camera.core.t_camelot$component$camera$core34155.cljs$lang$ctorStr = "camelot.component.camera.core/t_camelot$component$camera$core34155";

camelot.component.camera.core.t_camelot$component$camera$core34155.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.camera.core/t_camelot$component$camera$core34155");
});

camelot.component.camera.core.__GT_t_camelot$component$camera$core34155 = (function camelot$component$camera$core$camera_menu_component_$___GT_t_camelot$component$camera$core34155(camera_menu_component__$1,data__$1,owner__$1,meta34156){
return (new camelot.component.camera.core.t_camelot$component$camera$core34155(camera_menu_component__$1,data__$1,owner__$1,meta34156));
});

}

return (new camelot.component.camera.core.t_camelot$component$camera$core34155(camelot$component$camera$core$camera_menu_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
