// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.deployment.core');
goog.require('cljs.core');
goog.require('camelot.rest');
goog.require('camelot.nav');
goog.require('om.dom');
goog.require('camelot.component.deployment.camera_check');
goog.require('camelot.component.deployment.create');
goog.require('camelot.state');
goog.require('camelot.component.util');
goog.require('cljs.core.async');
goog.require('camelot.translation.core');
goog.require('cljs_time.format');
goog.require('om.core');
goog.require('camelot.component.deployment.shared');
camelot.component.deployment.core.day_formatter = cljs_time.format.formatter.cljs$core$IFn$_invoke$arity$1("yyyy-MM-dd");
/**
 * Delete the trap station and trigger a removal event.
 */
camelot.component.deployment.core.delete$ = (function camelot$component$deployment$core$delete(state,data,event){
event.preventDefault();

event.stopPropagation();

if(cljs.core.truth_((function (){var G__40621 = camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_confirm_DASH_delete);
return confirm(G__40621);
})())){
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str("/trap-stations/"),cljs.core.str(cljs.core.cst$kw$trap_DASH_station_DASH_id.cljs$core$IFn$_invoke$arity$1(data))].join(''),(function (){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_40629){
var state_val_40630 = (state_40629[(1)]);
if((state_val_40630 === (1))){
var inst_40622 = cljs.core.cst$kw$chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_40623 = [cljs.core.cst$kw$event,cljs.core.cst$kw$data];
var inst_40624 = [cljs.core.cst$kw$delete,data];
var inst_40625 = cljs.core.PersistentHashMap.fromArrays(inst_40623,inst_40624);
var state_40629__$1 = state_40629;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40629__$1,(2),inst_40622,inst_40625);
} else {
if((state_val_40630 === (2))){
var inst_40627 = (state_40629[(2)]);
var state_40629__$1 = state_40629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40629__$1,inst_40627);
} else {
return null;
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$component$deployment$core$delete_$_state_machine__28453__auto__ = null;
var camelot$component$deployment$core$delete_$_state_machine__28453__auto____0 = (function (){
var statearr_40634 = [null,null,null,null,null,null,null];
(statearr_40634[(0)] = camelot$component$deployment$core$delete_$_state_machine__28453__auto__);

(statearr_40634[(1)] = (1));

return statearr_40634;
});
var camelot$component$deployment$core$delete_$_state_machine__28453__auto____1 = (function (state_40629){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_40629);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e40635){if((e40635 instanceof Object)){
var ex__28456__auto__ = e40635;
var statearr_40636_40638 = state_40629;
(statearr_40636_40638[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40629);

return cljs.core.cst$kw$recur;
} else {
throw e40635;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__40639 = state_40629;
state_40629 = G__40639;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$deployment$core$delete_$_state_machine__28453__auto__ = function(state_40629){
switch(arguments.length){
case 0:
return camelot$component$deployment$core$delete_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$deployment$core$delete_$_state_machine__28453__auto____1.call(this,state_40629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$deployment$core$delete_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$core$delete_$_state_machine__28453__auto____0;
camelot$component$deployment$core$delete_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$core$delete_$_state_machine__28453__auto____1;
return camelot$component$deployment$core$delete_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_40637 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_40637[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_40637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
}));
} else {
return null;
}
});
/**
 * Entry in the page navigation menu.
 */
camelot.component.deployment.core.action_item_component = (function camelot$component$deployment$core$action_item_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core40661 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core40661 = (function (action_item_component,data,owner,meta40662){
this.action_item_component = action_item_component;
this.data = data;
this.owner = owner;
this.meta40662 = meta40662;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.core.t_camelot$component$deployment$core40661.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40663,meta40662__$1){
var self__ = this;
var _40663__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40661(self__.action_item_component,self__.data,self__.owner,meta40662__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core40661.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40663){
var self__ = this;
var _40663__$1 = this;
return self__.meta40662;
});

camelot.component.deployment.core.t_camelot$component$deployment$core40661.prototype.om$core$IRenderState$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40661.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__40664 = ({"className": [cljs.core.str("menu-item"),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$action.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(state)))?" active":""))].join(''), "onClick": ((function (___$1){
return (function (){
var c__28576__auto___40682 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___40682,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___40682,___$1){
return (function (state_40671){
var state_val_40672 = (state_40671[(1)]);
if((state_val_40672 === (1))){
var inst_40666 = cljs.core.cst$kw$active_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_40667 = cljs.core.cst$kw$action.cljs$core$IFn$_invoke$arity$1(self__.data);
var state_40671__$1 = state_40671;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40671__$1,(2),inst_40666,inst_40667);
} else {
if((state_val_40672 === (2))){
var inst_40669 = (state_40671[(2)]);
var state_40671__$1 = state_40671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40671__$1,inst_40669);
} else {
return null;
}
}
});})(c__28576__auto___40682,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto___40682,___$1){
return (function() {
var camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto__ = null;
var camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto____0 = (function (){
var statearr_40676 = [null,null,null,null,null,null,null];
(statearr_40676[(0)] = camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto__);

(statearr_40676[(1)] = (1));

return statearr_40676;
});
var camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto____1 = (function (state_40671){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_40671);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e40677){if((e40677 instanceof Object)){
var ex__28456__auto__ = e40677;
var statearr_40678_40683 = state_40671;
(statearr_40678_40683[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40671);

return cljs.core.cst$kw$recur;
} else {
throw e40677;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__40684 = state_40671;
state_40671 = G__40684;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto__ = function(state_40671){
switch(arguments.length){
case 0:
return camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto____1.call(this,state_40671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto____0;
camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto____1;
return camelot$component$deployment$core$action_item_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___40682,___$1))
})();
var state__28578__auto__ = (function (){var statearr_40679 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_40679[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___40682);

return statearr_40679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___40682,___$1))
);


return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("deployment",[cljs.core.str(cljs.core.name(cljs.core.cst$kw$action.cljs$core$IFn$_invoke$arity$1(self__.data))),cljs.core.str("-click")].join(''));
});})(___$1))
});
var G__40665 = om.util.force_children((function (){var G__40680 = ({"className": "menu-item-title"});
var G__40681 = om.util.force_children(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__40680,G__40681);
})());
return React.DOM.div(G__40664,G__40665);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40661.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$action_DASH_item_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Entry in the page navigation menu."], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40662], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40661.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40661.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core40661";

camelot.component.deployment.core.t_camelot$component$deployment$core40661.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core40661");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core40661 = (function camelot$component$deployment$core$action_item_component_$___GT_t_camelot$component$deployment$core40661(action_item_component__$1,data__$1,owner__$1,meta40662){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40661(action_item_component__$1,data__$1,owner__$1,meta40662));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core40661(camelot$component$deployment$core$action_item_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Page navigation menu component.
 */
camelot.component.deployment.core.action_menu_component = (function camelot$component$deployment$core$action_menu_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core40712 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core40712 = (function (action_menu_component,data,owner,meta40713){
this.action_menu_component = action_menu_component;
this.data = data;
this.owner = owner;
this.meta40713 = meta40713;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.core.t_camelot$component$deployment$core40712.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40714,meta40713__$1){
var self__ = this;
var _40714__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40712(self__.action_menu_component,self__.data,self__.owner,meta40713__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core40712.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40714){
var self__ = this;
var _40714__$1 = this;
return self__.meta40713;
});

camelot.component.deployment.core.t_camelot$component$deployment$core40712.prototype.om$core$IInitState$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40712.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40712.prototype.om$core$IWillMount$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40712.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var chan = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$active_DASH_chan);
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,chan,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,chan,___$1){
return (function (state_40723){
var state_val_40724 = (state_40723[(1)]);
if((state_val_40724 === (1))){
var state_40723__$1 = state_40723;
var statearr_40725_40739 = state_40723__$1;
(statearr_40725_40739[(2)] = null);

(statearr_40725_40739[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40724 === (2))){
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40723__$1,(4),chan);
} else {
if((state_val_40724 === (3))){
var inst_40721 = (state_40723[(2)]);
var state_40723__$1 = state_40723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40723__$1,inst_40721);
} else {
if((state_val_40724 === (4))){
var inst_40717 = (state_40723[(2)]);
var inst_40718 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$active,inst_40717);
var state_40723__$1 = (function (){var statearr_40726 = state_40723;
(statearr_40726[(7)] = inst_40718);

return statearr_40726;
})();
var statearr_40727_40740 = state_40723__$1;
(statearr_40727_40740[(2)] = null);

(statearr_40727_40740[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(c__28576__auto__,chan,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto__,chan,___$1){
return (function() {
var camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto__ = null;
var camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto____0 = (function (){
var statearr_40731 = [null,null,null,null,null,null,null,null];
(statearr_40731[(0)] = camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto__);

(statearr_40731[(1)] = (1));

return statearr_40731;
});
var camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto____1 = (function (state_40723){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_40723);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e40732){if((e40732 instanceof Object)){
var ex__28456__auto__ = e40732;
var statearr_40733_40741 = state_40723;
(statearr_40733_40741[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40723);

return cljs.core.cst$kw$recur;
} else {
throw e40732;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__40742 = state_40723;
state_40723 = G__40742;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto__ = function(state_40723){
switch(arguments.length){
case 0:
return camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto____1.call(this,state_40723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto____0;
camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto____1;
return camelot$component$deployment$core$action_menu_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,chan,___$1))
})();
var state__28578__auto__ = (function (){var statearr_40734 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_40734[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_40734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,chan,___$1))
);

return c__28576__auto__;
});

camelot.component.deployment.core.t_camelot$component$deployment$core40712.prototype.om$core$IRenderState$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40712.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__40735 = ({"className": "section"});
var G__40736 = om.util.force_children((function (){var G__40737 = ({"className": "simple-menu"});
var G__40738 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.action_item_component,cljs.core.cst$kw$menu.cljs$core$IFn$_invoke$arity$1(self__.data),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$action,cljs.core.cst$kw$state,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$active,cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(self__.data))], null)));
return React.DOM.div(G__40737,G__40738);
})());
return React.DOM.div(G__40735,G__40736);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40712.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$action_DASH_menu_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Page navigation menu component."], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40713], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40712.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40712.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core40712";

camelot.component.deployment.core.t_camelot$component$deployment$core40712.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core40712");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core40712 = (function camelot$component$deployment$core$action_menu_component_$___GT_t_camelot$component$deployment$core40712(action_menu_component__$1,data__$1,owner__$1,meta40713){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40712(action_menu_component__$1,data__$1,owner__$1,meta40713));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core40712(camelot$component$deployment$core$action_menu_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.read_only_field_component = (function camelot$component$deployment$core$read_only_field_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core40753 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core40753 = (function (read_only_field_component,data,owner,meta40754){
this.read_only_field_component = read_only_field_component;
this.data = data;
this.owner = owner;
this.meta40754 = meta40754;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.core.t_camelot$component$deployment$core40753.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40755,meta40754__$1){
var self__ = this;
var _40755__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40753(self__.read_only_field_component,self__.data,self__.owner,meta40754__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core40753.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40755){
var self__ = this;
var _40755__$1 = this;
return self__.meta40754;
});

camelot.component.deployment.core.t_camelot$component$deployment$core40753.prototype.om$core$IRenderState$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40753.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__40756 = ({"className": "field-details-item-container"});
var G__40757 = om.util.force_children((function (){var G__40759 = ({"className": "field-label"});
var G__40760 = om.util.force_children(cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(state));
return React.DOM.label(G__40759,G__40760);
})());
var G__40758 = om.util.force_children((function (){var G__40761 = ({"className": "field-details"});
var G__40762 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(state))?cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$value], null)):cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(state)));
return React.DOM.div(G__40761,G__40762);
})());
return React.DOM.div(G__40756,G__40757,G__40758);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40753.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$read_DASH_only_DASH_field_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40754], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40753.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40753.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core40753";

camelot.component.deployment.core.t_camelot$component$deployment$core40753.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core40753");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core40753 = (function camelot$component$deployment$core$read_only_field_component_$___GT_t_camelot$component$deployment$core40753(read_only_field_component__$1,data__$1,owner__$1,meta40754){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40753(read_only_field_component__$1,data__$1,owner__$1,meta40754));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core40753(camelot$component$deployment$core$read_only_field_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for read-only details about the currently selected deployment.
 */
camelot.component.deployment.core.deployment_selected_details_component = (function camelot$component$deployment$core$deployment_selected_details_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core40789 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core40789 = (function (deployment_selected_details_component,data,owner,meta40790){
this.deployment_selected_details_component = deployment_selected_details_component;
this.data = data;
this.owner = owner;
this.meta40790 = meta40790;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.core.t_camelot$component$deployment$core40789.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40791,meta40790__$1){
var self__ = this;
var _40791__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40789(self__.deployment_selected_details_component,self__.data,self__.owner,meta40790__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core40789.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40791){
var self__ = this;
var _40791__$1 = this;
return self__.meta40790;
});

camelot.component.deployment.core.t_camelot$component$deployment$core40789.prototype.om$core$IRender$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40789.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__40792 = ({"className": "section"});
var G__40793 = om.util.force_children((function (){var G__40797 = ({"className": "generic-container simple-menu"});
var G__40798 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$site_SLASH_site_DASH_name$label)], null)], null)):null));
var G__40799 = om.util.force_children((function (){var temp__4655__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_start_DASH_date,cljs.core.cst$kw$value], null));
if(cljs.core.truth_(temp__4655__auto__)){
var fv__7567__auto__ = temp__4655__auto__;
return om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$value,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs_time.format.unparse,camelot.component.deployment.core.day_formatter).call(null,fv__7567__auto__),cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_DASH_session_SLASH_trap_DASH_station_DASH_session_DASH_start_DASH_date$label)], null)], null));
} else {
return null;
}
})());
var G__40800 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_latitude,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_latitude,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_latitude$label)], null)], null)):null));
var G__40801 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_longitude,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_longitude,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_longitude$label)], null)], null)):null));
var G__40802 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$primary_DASH_camera_DASH_name,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$primary_DASH_camera_DASH_name,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_primary_DASH_camera_DASH_name)], null)], null)):null));
var G__40803 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$secondary_DASH_camera_DASH_name,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$secondary_DASH_camera_DASH_name,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_secondary_DASH_camera_DASH_name)], null)], null)):null));
var G__40804 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_altitude,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_altitude,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_altitude$label)], null)], null)):null));
var G__40805 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_above_DASH_ground,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_above_DASH_ground,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_distance_DASH_above_DASH_ground$label)], null)], null)):null));
var G__40806 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_road,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_road,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_distance_DASH_to_DASH_road$label)], null)], null)):null));
var G__40807 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_river,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_river,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_distance_DASH_to_DASH_river$label)], null)], null)):null));
var G__40808 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_settlement,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_settlement,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_distance_DASH_to_DASH_settlement$label)], null)], null)):null));
var G__40809 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_notes,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_notes,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_notes$label)], null)], null)):null));
return React.DOM.div(G__40797,G__40798,G__40799,G__40800,G__40801,G__40802,G__40803,G__40804,G__40805,G__40806,G__40807,G__40808,G__40809);
})());
var G__40794 = om.util.force_children((function (){var G__40810 = ({"className": "sep"});
return React.DOM.div(G__40810);
})());
var G__40795 = om.util.force_children((function (){var G__40811 = ({"className": "btn btn-primary", "onClick": ((function (G__40792,G__40793,G__40794,___$1){
return (function (){
return camelot.nav.nav_BANG_(camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["deployments",cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_id,cljs.core.cst$kw$value], null)),"edit"], 0)));
});})(G__40792,G__40793,G__40794,___$1))
});
var G__40812 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_edit));
return React.DOM.button(G__40811,G__40812);
})());
var G__40796 = om.util.force_children((function (){var G__40813 = ({"className": "btn btn-default", "onClick": ((function (G__40792,G__40793,G__40794,G__40795,___$1){
return (function (){
camelot.nav.nav_BANG_([cljs.core.str("/trap-station-sessions/"),cljs.core.str(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_id,cljs.core.cst$kw$value], null)))].join(''));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-survey","advanced-click");
});})(G__40792,G__40793,G__40794,G__40795,___$1))
});
var G__40814 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_advanced));
return React.DOM.button(G__40813,G__40814);
})());
return React.DOM.div(G__40792,G__40793,G__40794,G__40795,G__40796);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40789.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$deployment_DASH_selected_DASH_details_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Component for read-only details about the currently selected deployment."], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40790], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40789.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40789.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core40789";

camelot.component.deployment.core.t_camelot$component$deployment$core40789.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core40789");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core40789 = (function camelot$component$deployment$core$deployment_selected_details_component_$___GT_t_camelot$component$deployment$core40789(deployment_selected_details_component__$1,data__$1,owner__$1,meta40790){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40789(deployment_selected_details_component__$1,data__$1,owner__$1,meta40790));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core40789(camelot$component$deployment$core$deployment_selected_details_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.deployment_section_containers_component = (function camelot$component$deployment$core$deployment_section_containers_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core40826 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core40826 = (function (deployment_section_containers_component,data,owner,meta40827){
this.deployment_section_containers_component = deployment_section_containers_component;
this.data = data;
this.owner = owner;
this.meta40827 = meta40827;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.core.t_camelot$component$deployment$core40826.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40828,meta40827__$1){
var self__ = this;
var _40828__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40826(self__.deployment_section_containers_component,self__.data,self__.owner,meta40827__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core40826.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40828){
var self__ = this;
var _40828__$1 = this;
return self__.meta40827;
});

camelot.component.deployment.core.t_camelot$component$deployment$core40826.prototype.om$core$IInitState$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40826.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$can_DASH_edit_QMARK_,camelot.component.deployment.shared.can_edit_QMARK_(self__.data)], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40826.prototype.om$core$IWillMount$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40826.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(camelot.component.deployment.shared.can_edit_QMARK_(self__.data))){
return null;
} else {
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$active,cljs.core.cst$kw$details);
}
});

camelot.component.deployment.core.t_camelot$component$deployment$core40826.prototype.om$core$IRenderState$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40826.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__40829 = null;
var G__40830 = om.util.force_children((function (){var G__40832 = ({"className": "section-container"});
var G__40833 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.deployment.core.action_menu_component,self__.data));
return React.DOM.div(G__40832,G__40833);
})());
var G__40831 = om.util.force_children((function (){var G__40834 = ({"className": "section-container"});
var G__40835 = om.util.force_children((function (){var G__40836 = (((cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(self__.data) instanceof cljs.core.Keyword))?cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(self__.data).fqn:null);
switch (G__40836) {
case "details":
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.deployment.core.deployment_selected_details_component,self__.data);

break;
case "check":
return om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.camera_check.record_camera_check_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,state], null));

break;
default:
return null;

}
})());
return React.DOM.div(G__40834,G__40835);
})());
return React.DOM.div(G__40829,G__40830,G__40831);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40826.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$deployment_DASH_section_DASH_containers_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40827], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40826.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40826.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core40826";

camelot.component.deployment.core.t_camelot$component$deployment$core40826.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core40826");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core40826 = (function camelot$component$deployment$core$deployment_section_containers_component_$___GT_t_camelot$component$deployment$core40826(deployment_section_containers_component__$1,data__$1,owner__$1,meta40827){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40826(deployment_section_containers_component__$1,data__$1,owner__$1,meta40827));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core40826(camelot$component$deployment$core$deployment_section_containers_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.edit_view_component = (function camelot$component$deployment$core$edit_view_component(app,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core40841 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core40841 = (function (edit_view_component,app,owner,meta40842){
this.edit_view_component = edit_view_component;
this.app = app;
this.owner = owner;
this.meta40842 = meta40842;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.core.t_camelot$component$deployment$core40841.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40843,meta40842__$1){
var self__ = this;
var _40843__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40841(self__.edit_view_component,self__.app,self__.owner,meta40842__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core40841.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40843){
var self__ = this;
var _40843__$1 = this;
return self__.meta40842;
});

camelot.component.deployment.core.t_camelot$component$deployment$core40841.prototype.om$core$IRender$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40841.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.deployment.create.edit_component,self__.app);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40841.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$edit_DASH_view_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40842], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40841.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40841.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core40841";

camelot.component.deployment.core.t_camelot$component$deployment$core40841.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core40841");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core40841 = (function camelot$component$deployment$core$edit_view_component_$___GT_t_camelot$component$deployment$core40841(edit_view_component__$1,app__$1,owner__$1,meta40842){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40841(edit_view_component__$1,app__$1,owner__$1,meta40842));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core40841(camelot$component$deployment$core$edit_view_component,app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.create_view_component = (function camelot$component$deployment$core$create_view_component(app,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core40847 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core40847 = (function (create_view_component,app,owner,meta40848){
this.create_view_component = create_view_component;
this.app = app;
this.owner = owner;
this.meta40848 = meta40848;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.core.t_camelot$component$deployment$core40847.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40849,meta40848__$1){
var self__ = this;
var _40849__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40847(self__.create_view_component,self__.app,self__.owner,meta40848__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core40847.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40849){
var self__ = this;
var _40849__$1 = this;
return self__.meta40848;
});

camelot.component.deployment.core.t_camelot$component$deployment$core40847.prototype.om$core$IRender$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40847.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.deployment.create.view_component,self__.app);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40847.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$create_DASH_view_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40848], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40847.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40847.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core40847";

camelot.component.deployment.core.t_camelot$component$deployment$core40847.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core40847");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core40847 = (function camelot$component$deployment$core$create_view_component_$___GT_t_camelot$component$deployment$core40847(create_view_component__$1,app__$1,owner__$1,meta40848){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40847(create_view_component__$1,app__$1,owner__$1,meta40848));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core40847(camelot$component$deployment$core$create_view_component,app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Top-level view for deployment components.
 */
camelot.component.deployment.core.deployment_view_component = (function camelot$component$deployment$core$deployment_view_component(app,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core40874 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core40874 = (function (deployment_view_component,app,owner,meta40875){
this.deployment_view_component = deployment_view_component;
this.app = app;
this.owner = owner;
this.meta40875 = meta40875;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.core.t_camelot$component$deployment$core40874.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40876,meta40875__$1){
var self__ = this;
var _40876__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40874(self__.deployment_view_component,self__.app,self__.owner,meta40875__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core40874.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40876){
var self__ = this;
var _40876__$1 = this;
return self__.meta40875;
});

camelot.component.deployment.core.t_camelot$component$deployment$core40874.prototype.om$core$IWillMount$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40874.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,cljs.core.cst$kw$page_DASH_state,null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40874.prototype.om$core$IDidMount$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40874.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str("/deployment/"),cljs.core.str(cljs.core.cst$kw$page_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.app))].join(''),((function (___$1){
return (function (p1__40850_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,cljs.core.cst$kw$page_DASH_state,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__40850_SHARP_),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$validation_DASH_problem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,false], null)], null)], 0)),cljs.core.cst$kw$menu,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$action,cljs.core.cst$kw$check,cljs.core.cst$kw$name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_record_DASH_camera_DASH_check)], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$action,cljs.core.cst$kw$details,cljs.core.cst$kw$name,camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_details)], null)], null),cljs.core.cst$kw$active,cljs.core.cst$kw$check], null));
});})(___$1))
);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40874.prototype.om$core$IWillUnmount$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40874.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,cljs.core.cst$kw$page_DASH_state,null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40874.prototype.om$core$IRender$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40874.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$page_DASH_state.cljs$core$IFn$_invoke$arity$1(self__.app))){
var G__40877 = ({"className": "split-menu"});
var G__40878 = om.util.force_children((function (){var G__40881 = ({"className": "back-button-container"});
var G__40882 = om.util.force_children((function (){var G__40883 = ({"className": "btn btn-default back", "onClick": ((function (G__40881,G__40877,___$1){
return (function (){
return camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$1((2));
});})(G__40881,G__40877,___$1))
});
var G__40884 = om.util.force_children((function (){var G__40887 = ({"className": "fa fa-mail-reply"});
return React.DOM.span(G__40887);
})());
var G__40885 = om.util.force_children(" ");
var G__40886 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_back));
return React.DOM.button(G__40883,G__40884,G__40885,G__40886);
})());
return React.DOM.div(G__40881,G__40882);
})());
var G__40879 = om.util.force_children((function (){var G__40888 = ({"className": "intro"});
var G__40889 = om.util.force_children((function (){var G__40890 = null;
var G__40891 = om.util.force_children(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$page_DASH_state,cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_name,cljs.core.cst$kw$value], null)));
return React.DOM.h4(G__40890,G__40891);
})());
return React.DOM.div(G__40888,G__40889);
})());
var G__40880 = om.util.force_children((function (){var G__40892 = null;
var G__40893 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.deployment.core.deployment_section_containers_component,cljs.core.cst$kw$page_DASH_state.cljs$core$IFn$_invoke$arity$1(self__.app)));
return React.DOM.div(G__40892,G__40893);
})());
return React.DOM.div(G__40877,G__40878,G__40879,G__40880);
} else {
var G__40894 = ({"className": "align-center"});
var G__40895 = om.util.force_children((function (){var G__40896 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__40896);
})());
return React.DOM.div(G__40894,G__40895);
}
});

camelot.component.deployment.core.t_camelot$component$deployment$core40874.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$deployment_DASH_view_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Top-level view for deployment components."], null)),cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40875], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40874.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40874.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core40874";

camelot.component.deployment.core.t_camelot$component$deployment$core40874.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core40874");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core40874 = (function camelot$component$deployment$core$deployment_view_component_$___GT_t_camelot$component$deployment$core40874(deployment_view_component__$1,app__$1,owner__$1,meta40875){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40874(deployment_view_component__$1,app__$1,owner__$1,meta40875));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core40874(camelot$component$deployment$core$deployment_view_component,app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.deployment_list_component = (function camelot$component$deployment$core$deployment_list_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core40940 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core40940 = (function (deployment_list_component,data,owner,meta40941){
this.deployment_list_component = deployment_list_component;
this.data = data;
this.owner = owner;
this.meta40941 = meta40941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.core.t_camelot$component$deployment$core40940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40942,meta40941__$1){
var self__ = this;
var _40942__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40940(self__.deployment_list_component,self__.data,self__.owner,meta40941__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core40940.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40942){
var self__ = this;
var _40942__$1 = this;
return self__.meta40941;
});

camelot.component.deployment.core.t_camelot$component$deployment$core40940.prototype.om$core$IRenderState$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40940.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__40943 = ({"className": "menu-item detailed dynamic", "onClick": ((function (___$1){
return (function (){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("survey-deployment","trap-station-click");

return camelot.nav.nav_BANG_(camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["deployments",cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data)], 0)));
});})(___$1))
});
var G__40944 = om.util.force_children((function (){var G__40950 = ({"className": "pull-right fa fa-times remove top-corner", "onClick": cljs.core.partial.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.delete$,state,self__.data)});
return React.DOM.div(G__40950);
})());
var G__40945 = om.util.force_children((cljs.core.truth_((function (){var or__6417__auto__ = cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_end_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return (cljs.core.cst$kw$primary_DASH_camera_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data) == null);
}
})())?(function (){var G__40951 = ({"className": "status pull-right"});
var G__40952 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_finalised));
return React.DOM.span(G__40951,G__40952);
})():null));
var G__40946 = om.util.force_children((function (){var G__40953 = ({"className": "menu-item-title"});
var G__40954 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__40953,G__40954);
})());
var G__40947 = om.util.force_children((function (){var G__40955 = ({"className": "menu-item-description"});
var G__40956 = om.util.force_children((function (){var G__40963 = null;
var G__40964 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_latitude$label));
var G__40965 = om.util.force_children(":");
return React.DOM.label(G__40963,G__40964,G__40965);
})());
var G__40957 = om.util.force_children(" ");
var G__40958 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_latitude.cljs$core$IFn$_invoke$arity$1(self__.data));
var G__40959 = om.util.force_children(", ");
var G__40960 = om.util.force_children((function (){var G__40966 = null;
var G__40967 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_longitude$label));
var G__40968 = om.util.force_children(":");
return React.DOM.label(G__40966,G__40967,G__40968);
})());
var G__40961 = om.util.force_children(" ");
var G__40962 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_longitude.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__40955,G__40956,G__40957,G__40958,G__40959,G__40960,G__40961,G__40962);
})());
var G__40948 = om.util.force_children((function (){var G__40969 = ({"className": "menu-item-description"});
var G__40970 = om.util.force_children((function (){var G__40973 = null;
var G__40974 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_start_DASH_date));
var G__40975 = om.util.force_children(":");
return React.DOM.label(G__40973,G__40974,G__40975);
})());
var G__40971 = om.util.force_children(" ");
var G__40972 = om.util.force_children(cljs_time.format.unparse(camelot.component.deployment.core.day_formatter,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_start_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data)));
return React.DOM.div(G__40969,G__40970,G__40971,G__40972);
})());
var G__40949 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_end_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__40976 = ({"className": "menu-item-description"});
var G__40977 = om.util.force_children((function (){var G__40980 = null;
var G__40981 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_end_DASH_date));
var G__40982 = om.util.force_children(":");
return React.DOM.label(G__40980,G__40981,G__40982);
})());
var G__40978 = om.util.force_children(" ");
var G__40979 = om.util.force_children(cljs_time.format.unparse(camelot.component.deployment.core.day_formatter,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_end_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data)));
return React.DOM.div(G__40976,G__40977,G__40978,G__40979);
})():null));
return React.DOM.div(G__40943,G__40944,G__40945,G__40946,G__40947,G__40948,G__40949);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40940.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$deployment_DASH_list_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta40941], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core40940.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core40940.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core40940";

camelot.component.deployment.core.t_camelot$component$deployment$core40940.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core40940");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core40940 = (function camelot$component$deployment$core$deployment_list_component_$___GT_t_camelot$component$deployment$core40940(deployment_list_component__$1,data__$1,owner__$1,meta40941){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core40940(deployment_list_component__$1,data__$1,owner__$1,meta40941));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core40940(camelot$component$deployment$core$deployment_list_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.deployment_list_section_component = (function camelot$component$deployment$core$deployment_list_section_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core41046 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core41046 = (function (deployment_list_section_component,data,owner,meta41047){
this.deployment_list_section_component = deployment_list_section_component;
this.data = data;
this.owner = owner;
this.meta41047 = meta41047;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.core.t_camelot$component$deployment$core41046.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41048,meta41047__$1){
var self__ = this;
var _41048__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core41046(self__.deployment_list_section_component,self__.data,self__.owner,meta41047__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core41046.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41048){
var self__ = this;
var _41048__$1 = this;
return self__.meta41047;
});

camelot.component.deployment.core.t_camelot$component$deployment$core41046.prototype.om$core$IInitState$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core41046.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core41046.prototype.om$core$IWillMount$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core41046.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$trap_DASH_stations,null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core41046.prototype.om$core$IDidMount$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core41046.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$deployment_DASH_sort_DASH_order,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_start_DASH_date);

camelot.rest.get_resource([cljs.core.str("/deployment/survey/"),cljs.core.str(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null)))].join(''),((function (___$1){
return (function (p1__40983_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$trap_DASH_stations,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__40983_SHARP_));
});})(___$1))
);

var ch = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$chan);
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,ch,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,ch,___$1){
return (function (state_41064){
var state_val_41065 = (state_41064[(1)]);
if((state_val_41065 === (1))){
var state_41064__$1 = state_41064;
var statearr_41066_41107 = state_41064__$1;
(statearr_41066_41107[(2)] = null);

(statearr_41066_41107[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41065 === (2))){
var state_41064__$1 = state_41064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41064__$1,(4),ch);
} else {
if((state_val_41065 === (3))){
var inst_41062 = (state_41064[(2)]);
var state_41064__$1 = state_41064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41064__$1,inst_41062);
} else {
if((state_val_41065 === (4))){
var inst_41051 = (state_41064[(7)]);
var inst_41051__$1 = (state_41064[(2)]);
var inst_41052 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(inst_41051__$1);
var inst_41053 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41052,cljs.core.cst$kw$delete);
var state_41064__$1 = (function (){var statearr_41067 = state_41064;
(statearr_41067[(7)] = inst_41051__$1);

return statearr_41067;
})();
if(inst_41053){
var statearr_41068_41108 = state_41064__$1;
(statearr_41068_41108[(1)] = (5));

} else {
var statearr_41069_41109 = state_41064__$1;
(statearr_41069_41109[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41065 === (5))){
var inst_41051 = (state_41064[(7)]);
var inst_41055 = (function (){var r = inst_41051;
return ((function (r,inst_41051,state_val_41065,c__28576__auto__,ch,___$1){
return (function (p1__40984_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (r,inst_41051,state_val_41065,c__28576__auto__,ch,___$1){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(r));
});})(r,inst_41051,state_val_41065,c__28576__auto__,ch,___$1))
,p1__40984_SHARP_);
});
;})(r,inst_41051,state_val_41065,c__28576__auto__,ch,___$1))
})();
var inst_41056 = om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$trap_DASH_stations,inst_41055);
var state_41064__$1 = state_41064;
var statearr_41070_41110 = state_41064__$1;
(statearr_41070_41110[(2)] = inst_41056);

(statearr_41070_41110[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41065 === (6))){
var state_41064__$1 = state_41064;
var statearr_41071_41111 = state_41064__$1;
(statearr_41071_41111[(2)] = null);

(statearr_41071_41111[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41065 === (7))){
var inst_41059 = (state_41064[(2)]);
var state_41064__$1 = (function (){var statearr_41072 = state_41064;
(statearr_41072[(8)] = inst_41059);

return statearr_41072;
})();
var statearr_41073_41112 = state_41064__$1;
(statearr_41073_41112[(2)] = null);

(statearr_41073_41112[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__28576__auto__,ch,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto__,ch,___$1){
return (function() {
var camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto__ = null;
var camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto____0 = (function (){
var statearr_41077 = [null,null,null,null,null,null,null,null,null];
(statearr_41077[(0)] = camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto__);

(statearr_41077[(1)] = (1));

return statearr_41077;
});
var camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto____1 = (function (state_41064){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_41064);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e41078){if((e41078 instanceof Object)){
var ex__28456__auto__ = e41078;
var statearr_41079_41113 = state_41064;
(statearr_41079_41113[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41064);

return cljs.core.cst$kw$recur;
} else {
throw e41078;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__41114 = state_41064;
state_41064 = G__41114;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto__ = function(state_41064){
switch(arguments.length){
case 0:
return camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto____1.call(this,state_41064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto____0;
camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto____1;
return camelot$component$deployment$core$deployment_list_section_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,ch,___$1))
})();
var state__28578__auto__ = (function (){var statearr_41080 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_41080[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_41080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,ch,___$1))
);

return c__28576__auto__;
});

camelot.component.deployment.core.t_camelot$component$deployment$core41046.prototype.om$core$IRenderState$ = true;

camelot.component.deployment.core.t_camelot$component$deployment$core41046.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$trap_DASH_stations.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__41081 = ({"className": "section"});
var G__41082 = om.util.force_children((function (){var G__41085 = ({"className": "simple-menu"});
var G__41086 = om.util.force_children(((cljs.core.empty_QMARK_(cljs.core.cst$kw$trap_DASH_stations.cljs$core$IFn$_invoke$arity$1(self__.data)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.blank_slate_component,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$item_DASH_name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_blank_DASH_item_DASH_name_DASH_lc),cljs.core.cst$kw$advice,(function (){var G__41087 = null;
var G__41088 = om.util.force_children((function (){var G__41090 = null;
var G__41091 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_advice_DASH_context));
return React.DOM.p(G__41090,G__41091);
})());
var G__41089 = om.util.force_children((function (){var G__41092 = null;
var G__41093 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_advice_DASH_direction));
return React.DOM.p(G__41092,G__41093);
})());
return React.DOM.div(G__41087,G__41088,G__41089);
})()], null)], null)):(function (){var G__41094 = null;
var G__41095 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.shared.deployment_sort_menu,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$show_DASH_end_DASH_date,true], null)], null)));
var G__41096 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.deployment_list_component,cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (){var G__41097 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.cst$kw$deployment_DASH_sort_DASH_order);
return (camelot.component.deployment.shared.deployment_sorters.cljs$core$IFn$_invoke$arity$1 ? camelot.component.deployment.shared.deployment_sorters.cljs$core$IFn$_invoke$arity$1(G__41097) : camelot.component.deployment.shared.deployment_sorters.call(null,G__41097));
})(),cljs.core.cst$kw$trap_DASH_stations.cljs$core$IFn$_invoke$arity$1(self__.data)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_id,cljs.core.cst$kw$init_DASH_state,state], null)));
return React.DOM.div(G__41094,G__41095,G__41096);
})()));
return React.DOM.div(G__41085,G__41086);
})());
var G__41083 = om.util.force_children((function (){var G__41098 = ({"className": "sep"});
return React.DOM.div(G__41098);
})());
var G__41084 = om.util.force_children((function (){var G__41099 = ({"className": "btn btn-primary", "onClick": ((function (G__41081,G__41082,G__41083,___$1){
return (function (){
camelot.nav.nav_BANG_([cljs.core.str("/"),cljs.core.str(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null))),cljs.core.str("/deployments/create")].join(''));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("survey-deployment","create-click");
});})(G__41081,G__41082,G__41083,___$1))
, "title": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_create_DASH_title)});
var G__41100 = om.util.force_children((function (){var G__41103 = ({"className": "fa fa-plus"});
return React.DOM.span(G__41103);
})());
var G__41101 = om.util.force_children(" ");
var G__41102 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_create_DASH_button));
return React.DOM.button(G__41099,G__41100,G__41101,G__41102);
})());
return React.DOM.div(G__41081,G__41082,G__41083,G__41084);
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$deployment_DASH_sort_DASH_order,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_start_DASH_date);

var G__41104 = ({"className": "align-center"});
var G__41105 = om.util.force_children((function (){var G__41106 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__41106);
})());
return React.DOM.div(G__41104,G__41105);
}
});

camelot.component.deployment.core.t_camelot$component$deployment$core41046.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$deployment_DASH_list_DASH_section_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta41047], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core41046.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core41046.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core41046";

camelot.component.deployment.core.t_camelot$component$deployment$core41046.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core41046");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core41046 = (function camelot$component$deployment$core$deployment_list_section_component_$___GT_t_camelot$component$deployment$core41046(deployment_list_section_component__$1,data__$1,owner__$1,meta41047){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core41046(deployment_list_section_component__$1,data__$1,owner__$1,meta41047));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core41046(camelot$component$deployment$core$deployment_list_section_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
