// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.deployment.recent');
goog.require('cljs.core');
goog.require('camelot.util.capture');
goog.require('camelot.rest');
goog.require('camelot.nav');
goog.require('om.dom');
goog.require('camelot.component.progress_bar');
goog.require('camelot.state');
goog.require('camelot.component.util');
goog.require('cljs.core.async');
goog.require('camelot.component.survey.create');
goog.require('camelot.translation.core');
goog.require('cljs_time.format');
goog.require('om.core');
goog.require('camelot.component.deployment.shared');
camelot.component.deployment.recent.day_formatter = cljs_time.format.formatter.cljs$core$IFn$_invoke$arity$1("yyyy-MM-dd");
camelot.component.deployment.recent.help_text = camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_help_DASH_text);
/**
 * Delete the session camera and trigger a removal event.
 */
camelot.component.deployment.recent.delete$ = (function camelot$component$deployment$recent$delete(state,data,event){
event.preventDefault();

event.stopPropagation();

if(cljs.core.truth_((function (){var G__36587 = (cljs.core.truth_(cljs.core.cst$kw$has_DASH_uploaded_DASH_media.cljs$core$IFn$_invoke$arity$1(data))?camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_confirm_DASH_delete_DASH_has_DASH_media):camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_confirm_DASH_delete));
return confirm(G__36587);
})())){
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str("/trap-station-session-cameras/"),cljs.core.str(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera_DASH_id.cljs$core$IFn$_invoke$arity$1(data))].join(''),(function (){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_36595){
var state_val_36596 = (state_36595[(1)]);
if((state_val_36596 === (1))){
var inst_36588 = cljs.core.cst$kw$chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_36589 = [cljs.core.cst$kw$event,cljs.core.cst$kw$data];
var inst_36590 = [cljs.core.cst$kw$delete,data];
var inst_36591 = cljs.core.PersistentHashMap.fromArrays(inst_36589,inst_36590);
var state_36595__$1 = state_36595;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36595__$1,(2),inst_36588,inst_36591);
} else {
if((state_val_36596 === (2))){
var inst_36593 = (state_36595[(2)]);
var state_36595__$1 = state_36595;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36595__$1,inst_36593);
} else {
return null;
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$component$deployment$recent$delete_$_state_machine__28453__auto__ = null;
var camelot$component$deployment$recent$delete_$_state_machine__28453__auto____0 = (function (){
var statearr_36600 = [null,null,null,null,null,null,null];
(statearr_36600[(0)] = camelot$component$deployment$recent$delete_$_state_machine__28453__auto__);

(statearr_36600[(1)] = (1));

return statearr_36600;
});
var camelot$component$deployment$recent$delete_$_state_machine__28453__auto____1 = (function (state_36595){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_36595);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e36601){if((e36601 instanceof Object)){
var ex__28456__auto__ = e36601;
var statearr_36602_36604 = state_36595;
(statearr_36602_36604[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36595);

return cljs.core.cst$kw$recur;
} else {
throw e36601;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__36605 = state_36595;
state_36595 = G__36605;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$deployment$recent$delete_$_state_machine__28453__auto__ = function(state_36595){
switch(arguments.length){
case 0:
return camelot$component$deployment$recent$delete_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$deployment$recent$delete_$_state_machine__28453__auto____1.call(this,state_36595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$deployment$recent$delete_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$recent$delete_$_state_machine__28453__auto____0;
camelot$component$deployment$recent$delete_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$recent$delete_$_state_machine__28453__auto____1;
return camelot$component$deployment$recent$delete_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_36603 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_36603[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_36603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
}));
} else {
return null;
}
});
camelot.component.deployment.recent.add_upload_problem = (function camelot$component$deployment$recent$add_upload_problem(owner,event_details,desc){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.nav.analytics_event,"capture-upload"),event_details);

if((om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$errors) == null)){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$errors,desc);
} else {
return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$errors,(function (p1__36606_SHARP_){
return [cljs.core.str(p1__36606_SHARP_),cljs.core.str(desc)].join('');
}));
}
});
camelot.component.deployment.recent.is_uploadable_QMARK_ = (function camelot$component$deployment$recent$is_uploadable_QMARK_(file){
return cljs.core.some((function (p1__36607_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(file.type,p1__36607_SHARP_);
}),cljs.core.keys(camelot.util.capture.image_mimes));
});
camelot.component.deployment.recent.unsupported_str = (function camelot$component$deployment$recent$unsupported_str(file){
return [cljs.core.str(camelot.translation.core.translate.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_format_DASH_not_DASH_supported,cljs.core.array_seq([file.name], 0))),cljs.core.str("\n")].join('');
});
camelot.component.deployment.recent.upload_file = (function camelot$component$deployment$recent$upload_file(sesscam_id,owner,file,chan){
if(cljs.core.truth_(camelot.component.deployment.recent.is_uploadable_QMARK_(file))){
return camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$4("/capture/upload",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["session-camera-id",sesscam_id], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["file",file], null)], null),(function (p1__36608_SHARP_){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_36651){
var state_val_36652 = (state_36651[(1)]);
if((state_val_36652 === (1))){
var inst_36642 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__36608_SHARP_);
var inst_36643 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_36642);
var inst_36644 = [cljs.core.cst$kw$file,cljs.core.cst$kw$success,cljs.core.cst$kw$error];
var inst_36645 = (inst_36643 == null);
var inst_36646 = [file,inst_36645,inst_36643];
var inst_36647 = cljs.core.PersistentHashMap.fromArrays(inst_36644,inst_36646);
var state_36651__$1 = state_36651;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36651__$1,(2),chan,inst_36647);
} else {
if((state_val_36652 === (2))){
var inst_36649 = (state_36651[(2)]);
var state_36651__$1 = state_36651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36651__$1,inst_36649);
} else {
return null;
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__ = null;
var camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____0 = (function (){
var statearr_36656 = [null,null,null,null,null,null,null];
(statearr_36656[(0)] = camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__);

(statearr_36656[(1)] = (1));

return statearr_36656;
});
var camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____1 = (function (state_36651){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_36651);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e36657){if((e36657 instanceof Object)){
var ex__28456__auto__ = e36657;
var statearr_36658_36675 = state_36651;
(statearr_36658_36675[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36651);

return cljs.core.cst$kw$recur;
} else {
throw e36657;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__36676 = state_36651;
state_36651 = G__36676;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__ = function(state_36651){
switch(arguments.length){
case 0:
return camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____1.call(this,state_36651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____0;
camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____1;
return camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_36659 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_36659[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_36659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
}),(function (){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_36666){
var state_val_36667 = (state_36666[(1)]);
if((state_val_36667 === (1))){
var inst_36660 = [cljs.core.cst$kw$file,cljs.core.cst$kw$success];
var inst_36661 = [file,false];
var inst_36662 = cljs.core.PersistentHashMap.fromArrays(inst_36660,inst_36661);
var state_36666__$1 = state_36666;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36666__$1,(2),chan,inst_36662);
} else {
if((state_val_36667 === (2))){
var inst_36664 = (state_36666[(2)]);
var state_36666__$1 = state_36666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36666__$1,inst_36664);
} else {
return null;
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__ = null;
var camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____0 = (function (){
var statearr_36671 = [null,null,null,null,null,null,null];
(statearr_36671[(0)] = camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__);

(statearr_36671[(1)] = (1));

return statearr_36671;
});
var camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____1 = (function (state_36666){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_36666);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e36672){if((e36672 instanceof Object)){
var ex__28456__auto__ = e36672;
var statearr_36673_36677 = state_36666;
(statearr_36673_36677[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36666);

return cljs.core.cst$kw$recur;
} else {
throw e36672;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__36678 = state_36666;
state_36666 = G__36678;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__ = function(state_36666){
switch(arguments.length){
case 0:
return camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____1.call(this,state_36666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____0;
camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto____1;
return camelot$component$deployment$recent$upload_file_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_36674 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_36674[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_36674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
}));
} else {
return camelot.component.deployment.recent.add_upload_problem(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["skipped",file.type], null),camelot.component.deployment.recent.unsupported_str(file));
}
});
camelot.component.deployment.recent.uploadable_count = (function camelot$component$deployment$recent$uploadable_count(fs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__36680_SHARP_,p2__36679_SHARP_){
if(cljs.core.truth_(camelot.component.deployment.recent.is_uploadable_QMARK_((fs[p2__36679_SHARP_])))){
return (p1__36680_SHARP_ + (1));
} else {
return p1__36680_SHARP_;
}
}),(0),cljs.core.range.cljs$core$IFn$_invoke$arity$1(fs.length));
});
camelot.component.deployment.recent.display_upload_failure = (function camelot$component$deployment$recent$display_upload_failure(owner,f,err){
var reason = [cljs.core.str("' "),cljs.core.str((function (){var or__6417__auto__ = err;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_upload_DASH_error);
}
})()),cljs.core.str("\n")].join('');
var desc = [cljs.core.str("'"),cljs.core.str(f.name),cljs.core.str(reason)].join('');
return camelot.component.deployment.recent.add_upload_problem(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["failed",f.type], null),desc);
});
camelot.component.deployment.recent.handle_upload_failure = (function camelot$component$deployment$recent$handle_upload_failure(owner,f,err){
camelot.component.deployment.recent.display_upload_failure(owner,f,err);

return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$failed,cljs.core.inc);
});
camelot.component.deployment.recent.drop_file_handler = (function camelot$component$deployment$recent$drop_file_handler(data,owner,files){
var uploadable = camelot.component.deployment.recent.uploadable_count(files);
var upl_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("capture-upload","upload-init");

om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$total,((function (uploadable,upl_chan){
return (function (p1__36681_SHARP_){
return (p1__36681_SHARP_ + files.length);
});})(uploadable,upl_chan))
);

om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$ignored,((function (uploadable,upl_chan){
return (function (p1__36682_SHARP_){
return (p1__36682_SHARP_ + (files.length - uploadable));
});})(uploadable,upl_chan))
);

var c__28576__auto___36765 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___36765,uploadable,upl_chan){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___36765,uploadable,upl_chan){
return (function (state_36743){
var state_val_36744 = (state_36743[(1)]);
if((state_val_36744 === (1))){
var state_36743__$1 = state_36743;
var statearr_36745_36766 = state_36743__$1;
(statearr_36745_36766[(2)] = null);

(statearr_36745_36766[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36744 === (2))){
var state_36743__$1 = state_36743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36743__$1,(4),upl_chan);
} else {
if((state_val_36744 === (3))){
var inst_36741 = (state_36743[(2)]);
var state_36743__$1 = state_36743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36743__$1,inst_36741);
} else {
if((state_val_36744 === (4))){
var inst_36726 = (state_36743[(7)]);
var inst_36726__$1 = (state_36743[(2)]);
var inst_36727 = cljs.core.cst$kw$success.cljs$core$IFn$_invoke$arity$1(inst_36726__$1);
var state_36743__$1 = (function (){var statearr_36746 = state_36743;
(statearr_36746[(7)] = inst_36726__$1);

return statearr_36746;
})();
if(cljs.core.truth_(inst_36727)){
var statearr_36747_36767 = state_36743__$1;
(statearr_36747_36767[(1)] = (5));

} else {
var statearr_36748_36768 = state_36743__$1;
(statearr_36748_36768[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36744 === (5))){
var inst_36726 = (state_36743[(7)]);
var inst_36729 = om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$complete,cljs.core.inc);
var inst_36730 = cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(inst_36726);
var inst_36731 = inst_36730.type;
var inst_36732 = camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$3("capture-upload","success",inst_36731);
var state_36743__$1 = (function (){var statearr_36749 = state_36743;
(statearr_36749[(8)] = inst_36729);

return statearr_36749;
})();
var statearr_36750_36769 = state_36743__$1;
(statearr_36750_36769[(2)] = inst_36732);

(statearr_36750_36769[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36744 === (6))){
var inst_36726 = (state_36743[(7)]);
var inst_36734 = cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(inst_36726);
var inst_36735 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_36726);
var inst_36736 = camelot.component.deployment.recent.handle_upload_failure(owner,inst_36734,inst_36735);
var state_36743__$1 = state_36743;
var statearr_36751_36770 = state_36743__$1;
(statearr_36751_36770[(2)] = inst_36736);

(statearr_36751_36770[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36744 === (7))){
var inst_36738 = (state_36743[(2)]);
var state_36743__$1 = (function (){var statearr_36752 = state_36743;
(statearr_36752[(9)] = inst_36738);

return statearr_36752;
})();
var statearr_36753_36771 = state_36743__$1;
(statearr_36753_36771[(2)] = null);

(statearr_36753_36771[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__28576__auto___36765,uploadable,upl_chan))
;
return ((function (switch__28452__auto__,c__28576__auto___36765,uploadable,upl_chan){
return (function() {
var camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto__ = null;
var camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto____0 = (function (){
var statearr_36757 = [null,null,null,null,null,null,null,null,null,null];
(statearr_36757[(0)] = camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto__);

(statearr_36757[(1)] = (1));

return statearr_36757;
});
var camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto____1 = (function (state_36743){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_36743);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e36758){if((e36758 instanceof Object)){
var ex__28456__auto__ = e36758;
var statearr_36759_36772 = state_36743;
(statearr_36759_36772[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36743);

return cljs.core.cst$kw$recur;
} else {
throw e36758;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__36773 = state_36743;
state_36743 = G__36773;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto__ = function(state_36743){
switch(arguments.length){
case 0:
return camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto____1.call(this,state_36743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto____0;
camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto____1;
return camelot$component$deployment$recent$drop_file_handler_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___36765,uploadable,upl_chan))
})();
var state__28578__auto__ = (function (){var statearr_36760 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_36760[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___36765);

return statearr_36760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___36765,uploadable,upl_chan))
);


var seq__36761 = cljs.core.seq(cljs.core.range.cljs$core$IFn$_invoke$arity$1(files.length));
var chunk__36762 = null;
var count__36763 = (0);
var i__36764 = (0);
while(true){
if((i__36764 < count__36763)){
var idx = chunk__36762.cljs$core$IIndexed$_nth$arity$2(null,i__36764);
camelot.component.deployment.recent.upload_file(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera_DASH_id.cljs$core$IFn$_invoke$arity$1(data),owner,(files[idx]),upl_chan);

var G__36774 = seq__36761;
var G__36775 = chunk__36762;
var G__36776 = count__36763;
var G__36777 = (i__36764 + (1));
seq__36761 = G__36774;
chunk__36762 = G__36775;
count__36763 = G__36776;
i__36764 = G__36777;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__36761);
if(temp__4657__auto__){
var seq__36761__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__36761__$1)){
var c__7228__auto__ = cljs.core.chunk_first(seq__36761__$1);
var G__36778 = cljs.core.chunk_rest(seq__36761__$1);
var G__36779 = c__7228__auto__;
var G__36780 = cljs.core.count(c__7228__auto__);
var G__36781 = (0);
seq__36761 = G__36778;
chunk__36762 = G__36779;
count__36763 = G__36780;
i__36764 = G__36781;
continue;
} else {
var idx = cljs.core.first(seq__36761__$1);
camelot.component.deployment.recent.upload_file(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera_DASH_id.cljs$core$IFn$_invoke$arity$1(data),owner,(files[idx]),upl_chan);

var G__36782 = cljs.core.next(seq__36761__$1);
var G__36783 = null;
var G__36784 = (0);
var G__36785 = (0);
seq__36761 = G__36782;
chunk__36762 = G__36783;
count__36763 = G__36784;
i__36764 = G__36785;
continue;
}
} else {
return null;
}
}
break;
}
});
camelot.component.deployment.recent.recent_deployment_list_component = (function camelot$component$deployment$recent$recent_deployment_list_component(data,owner){
if(typeof camelot.component.deployment.recent.t_camelot$component$deployment$recent36834 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.recent.t_camelot$component$deployment$recent36834 = (function (recent_deployment_list_component,data,owner,meta36835){
this.recent_deployment_list_component = recent_deployment_list_component;
this.data = data;
this.owner = owner;
this.meta36835 = meta36835;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36836,meta36835__$1){
var self__ = this;
var _36836__$1 = this;
return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent36834(self__.recent_deployment_list_component,self__.data,self__.owner,meta36835__$1));
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36836){
var self__ = this;
var _36836__$1 = this;
return self__.meta36835;
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.prototype.om$core$IInitState$ = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$total,(0),cljs.core.cst$kw$ignored,(0),cljs.core.cst$kw$complete,(0),cljs.core.cst$kw$failed,(0),cljs.core.cst$kw$errors,null], null);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.prototype.om$core$IDidMount$ = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var n = om.core.get_node.cljs$core$IFn$_invoke$arity$1(self__.owner);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$total,(0));

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$complete,(0));

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$failed,(0));

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$errors,null);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$ignored,(0));

n.addEventListener("dragenter",((function (n,___$1){
return (function (p1__36786_SHARP_){
p1__36786_SHARP_.stopPropagation();

return p1__36786_SHARP_.preventDefault();
});})(n,___$1))
);

n.addEventListener("dragover",((function (n,___$1){
return (function (p1__36787_SHARP_){
p1__36787_SHARP_.stopPropagation();

return p1__36787_SHARP_.preventDefault();
});})(n,___$1))
);

return n.addEventListener("drop",((function (n,___$1){
return (function (p1__36788_SHARP_){
p1__36788_SHARP_.stopPropagation();

p1__36788_SHARP_.preventDefault();

var fs = p1__36788_SHARP_.dataTransfer.files;
return camelot.component.deployment.recent.drop_file_handler(self__.data,self__.owner,fs);
});})(n,___$1))
);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.prototype.om$core$IRenderState$ = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__36837 = ({"className": "menu-item detailed dynamic no-click", "onClick": ((function (___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.display_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$notification,cljs.core.cst$kw$info], null),cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(state));
});})(___$1))
});
var G__36838 = om.util.force_children((function (){var G__36846 = ({"className": "pull-right fa fa-times remove top-corner", "onClick": cljs.core.partial.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.recent.delete$,state,self__.data)});
return React.DOM.div(G__36846);
})());
var G__36839 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$has_DASH_uploaded_DASH_media.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__36847 = ({"className": "status pull-right"});
var G__36848 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_media_DASH_uploaded));
return React.DOM.span(G__36847,G__36848);
})():null));
var G__36840 = om.util.force_children((function (){var G__36849 = ({"className": "menu-item-title"});
var G__36850 = om.util.force_children(cljs.core.cst$kw$camera_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
var G__36851 = om.util.force_children(" ");
var G__36852 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_at_DASH_lc));
var G__36853 = om.util.force_children(" ");
var G__36854 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.div(G__36849,G__36850,G__36851,G__36852,G__36853,G__36854);
})());
var G__36841 = om.util.force_children((cljs.core.truth_((function (){var and__6405__auto__ = cljs.core.cst$kw$total.cljs$core$IFn$_invoke$arity$1(state);
if(cljs.core.truth_(and__6405__auto__)){
return ((cljs.core.cst$kw$total.cljs$core$IFn$_invoke$arity$1(state) > (0))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$ignored.cljs$core$IFn$_invoke$arity$1(state) + cljs.core.cst$kw$failed.cljs$core$IFn$_invoke$arity$1(state)) + cljs.core.cst$kw$complete.cljs$core$IFn$_invoke$arity$1(state)),cljs.core.cst$kw$total.cljs$core$IFn$_invoke$arity$1(state)));
} else {
return and__6405__auto__;
}
})())?(function (){var G__36855 = ({"className": "pull-right fa fa-check fa-3x green"});
return React.DOM.span(G__36855);
})():null));
var G__36842 = om.util.force_children((function (){var G__36856 = ({"className": "menu-item-description"});
var G__36857 = om.util.force_children((function (){var G__36864 = null;
var G__36865 = om.util.force_children(" ");
var G__36866 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_date));
var G__36867 = om.util.force_children(":");
return React.DOM.label(G__36864,G__36865,G__36866,G__36867);
})());
var G__36858 = om.util.force_children(" ");
var G__36859 = om.util.force_children(cljs_time.format.unparse(camelot.component.deployment.recent.day_formatter,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_start_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data)));
var G__36860 = om.util.force_children(" ");
var G__36861 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_to_DASH_lc));
var G__36862 = om.util.force_children(" ");
var G__36863 = om.util.force_children(cljs_time.format.unparse(camelot.component.deployment.recent.day_formatter,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_end_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data)));
return React.DOM.div(G__36856,G__36857,G__36858,G__36859,G__36860,G__36861,G__36862,G__36863);
})());
var G__36843 = om.util.force_children((function (){var G__36868 = ({"className": "menu-item-description"});
var G__36869 = om.util.force_children((function (){var G__36874 = null;
var G__36875 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_gps_DASH_coordinates));
var G__36876 = om.util.force_children(":");
return React.DOM.label(G__36874,G__36875,G__36876);
})());
var G__36870 = om.util.force_children(" ");
var G__36871 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_latitude.cljs$core$IFn$_invoke$arity$1(self__.data));
var G__36872 = om.util.force_children(", ");
var G__36873 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_longitude.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.div(G__36868,G__36869,G__36870,G__36871,G__36872,G__36873);
})());
var G__36844 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.progress_bar.component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,cljs.core.select_keys(state,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$total,cljs.core.cst$kw$ignored,cljs.core.cst$kw$complete,cljs.core.cst$kw$failed], null))], null)));
var G__36845 = om.util.force_children(((((cljs.core.get.cljs$core$IFn$_invoke$arity$2(state,cljs.core.cst$kw$ignored) + cljs.core.get.cljs$core$IFn$_invoke$arity$2(state,cljs.core.cst$kw$failed)) === (0)))?null:(function (){var G__36877 = ({"className": "pointer"});
var G__36878 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_show_DASH_details));
return React.DOM.div(G__36877,G__36878);
})()));
return React.DOM.div(G__36837,G__36838,G__36839,G__36840,G__36841,G__36842,G__36843,G__36844,G__36845);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$recent_DASH_deployment_DASH_list_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta36835], null);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.cljs$lang$type = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.cljs$lang$ctorStr = "camelot.component.deployment.recent/t_camelot$component$deployment$recent36834";

camelot.component.deployment.recent.t_camelot$component$deployment$recent36834.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.recent/t_camelot$component$deployment$recent36834");
});

camelot.component.deployment.recent.__GT_t_camelot$component$deployment$recent36834 = (function camelot$component$deployment$recent$recent_deployment_list_component_$___GT_t_camelot$component$deployment$recent36834(recent_deployment_list_component__$1,data__$1,owner__$1,meta36835){
return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent36834(recent_deployment_list_component__$1,data__$1,owner__$1,meta36835));
});

}

return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent36834(camelot$component$deployment$recent$recent_deployment_list_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.recent.recent_deployment_section_component = (function camelot$component$deployment$recent$recent_deployment_section_component(data,owner){
if(typeof camelot.component.deployment.recent.t_camelot$component$deployment$recent36930 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.recent.t_camelot$component$deployment$recent36930 = (function (recent_deployment_section_component,data,owner,meta36931){
this.recent_deployment_section_component = recent_deployment_section_component;
this.data = data;
this.owner = owner;
this.meta36931 = meta36931;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_36932,meta36931__$1){
var self__ = this;
var _36932__$1 = this;
return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent36930(self__.recent_deployment_section_component,self__.data,self__.owner,meta36931__$1));
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_36932){
var self__ = this;
var _36932__$1 = this;
return self__.meta36931;
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.prototype.om$core$IInitState$ = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.prototype.om$core$IWillMount$ = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$recent_DASH_deployments,null);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.prototype.om$core$IDidMount$ = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$deployment_DASH_sort_DASH_order,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_end_DASH_date);

camelot.rest.get_resource([cljs.core.str("/camera-deployment/survey/"),cljs.core.str(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null))),cljs.core.str("/recent")].join(''),((function (___$1){
return (function (p1__36879_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$recent_DASH_deployments,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__36879_SHARP_));
});})(___$1))
);

var ch = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$chan);
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,ch,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,ch,___$1){
return (function (state_36948){
var state_val_36949 = (state_36948[(1)]);
if((state_val_36949 === (1))){
var state_36948__$1 = state_36948;
var statearr_36950_36979 = state_36948__$1;
(statearr_36950_36979[(2)] = null);

(statearr_36950_36979[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36949 === (2))){
var state_36948__$1 = state_36948;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36948__$1,(4),ch);
} else {
if((state_val_36949 === (3))){
var inst_36946 = (state_36948[(2)]);
var state_36948__$1 = state_36948;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36948__$1,inst_36946);
} else {
if((state_val_36949 === (4))){
var inst_36935 = (state_36948[(7)]);
var inst_36935__$1 = (state_36948[(2)]);
var inst_36936 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(inst_36935__$1);
var inst_36937 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_36936,cljs.core.cst$kw$delete);
var state_36948__$1 = (function (){var statearr_36951 = state_36948;
(statearr_36951[(7)] = inst_36935__$1);

return statearr_36951;
})();
if(inst_36937){
var statearr_36952_36980 = state_36948__$1;
(statearr_36952_36980[(1)] = (5));

} else {
var statearr_36953_36981 = state_36948__$1;
(statearr_36953_36981[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36949 === (5))){
var inst_36935 = (state_36948[(7)]);
var inst_36939 = (function (){var r = inst_36935;
return ((function (r,inst_36935,state_val_36949,c__28576__auto__,ch,___$1){
return (function (p1__36880_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (r,inst_36935,state_val_36949,c__28576__auto__,ch,___$1){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(r));
});})(r,inst_36935,state_val_36949,c__28576__auto__,ch,___$1))
,p1__36880_SHARP_);
});
;})(r,inst_36935,state_val_36949,c__28576__auto__,ch,___$1))
})();
var inst_36940 = om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$recent_DASH_deployments,inst_36939);
var state_36948__$1 = state_36948;
var statearr_36954_36982 = state_36948__$1;
(statearr_36954_36982[(2)] = inst_36940);

(statearr_36954_36982[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36949 === (6))){
var state_36948__$1 = state_36948;
var statearr_36955_36983 = state_36948__$1;
(statearr_36955_36983[(2)] = null);

(statearr_36955_36983[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36949 === (7))){
var inst_36943 = (state_36948[(2)]);
var state_36948__$1 = (function (){var statearr_36956 = state_36948;
(statearr_36956[(8)] = inst_36943);

return statearr_36956;
})();
var statearr_36957_36984 = state_36948__$1;
(statearr_36957_36984[(2)] = null);

(statearr_36957_36984[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__28576__auto__,ch,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto__,ch,___$1){
return (function() {
var camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto__ = null;
var camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto____0 = (function (){
var statearr_36961 = [null,null,null,null,null,null,null,null,null];
(statearr_36961[(0)] = camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto__);

(statearr_36961[(1)] = (1));

return statearr_36961;
});
var camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto____1 = (function (state_36948){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_36948);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e36962){if((e36962 instanceof Object)){
var ex__28456__auto__ = e36962;
var statearr_36963_36985 = state_36948;
(statearr_36963_36985[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36948);

return cljs.core.cst$kw$recur;
} else {
throw e36962;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__36986 = state_36948;
state_36948 = G__36986;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto__ = function(state_36948){
switch(arguments.length){
case 0:
return camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto____1.call(this,state_36948);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto____0;
camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto____1;
return camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,ch,___$1))
})();
var state__28578__auto__ = (function (){var statearr_36964 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_36964[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_36964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,ch,___$1))
);

return c__28576__auto__;
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.prototype.om$core$IRenderState$ = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if((cljs.core.cst$kw$recent_DASH_deployments.cljs$core$IFn$_invoke$arity$1(self__.data) == null)){
var G__36965 = ({"className": "align-center"});
var G__36966 = om.util.force_children((function (){var G__36967 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__36967);
})());
return React.DOM.div(G__36965,G__36966);
} else {
var G__36968 = ({"className": "section"});
var G__36969 = om.util.force_children((function (){var G__36970 = ({"className": "simple-menu"});
var G__36971 = om.util.force_children(((cljs.core.empty_QMARK_(cljs.core.cst$kw$recent_DASH_deployments.cljs$core$IFn$_invoke$arity$1(self__.data)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.blank_slate_component,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$item_DASH_name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_blank_DASH_item_DASH_name),cljs.core.cst$kw$advice,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_blank_DASH_advice)], null)], null)):(function (){var G__36972 = null;
var G__36973 = om.util.force_children((function (){var G__36976 = ({"className": "help-text"});
var G__36977 = om.util.force_children(camelot.component.deployment.recent.help_text);
return React.DOM.div(G__36976,G__36977);
})());
var G__36974 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.shared.deployment_sort_menu,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$show_DASH_end_DASH_date,true], null)], null)));
var G__36975 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.recent.recent_deployment_list_component,cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (){var G__36978 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.cst$kw$deployment_DASH_sort_DASH_order);
return (camelot.component.deployment.shared.deployment_sorters.cljs$core$IFn$_invoke$arity$1 ? camelot.component.deployment.shared.deployment_sorters.cljs$core$IFn$_invoke$arity$1(G__36978) : camelot.component.deployment.shared.deployment_sorters.call(null,G__36978));
})(),cljs.core.cst$kw$recent_DASH_deployments.cljs$core$IFn$_invoke$arity$1(self__.data)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera_DASH_id,cljs.core.cst$kw$init_DASH_state,state], null)));
return React.DOM.div(G__36972,G__36973,G__36974,G__36975);
})()));
return React.DOM.div(G__36970,G__36971);
})());
return React.DOM.div(G__36968,G__36969);
}
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$recent_DASH_deployment_DASH_section_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta36931], null);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.cljs$lang$type = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.cljs$lang$ctorStr = "camelot.component.deployment.recent/t_camelot$component$deployment$recent36930";

camelot.component.deployment.recent.t_camelot$component$deployment$recent36930.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.deployment.recent/t_camelot$component$deployment$recent36930");
});

camelot.component.deployment.recent.__GT_t_camelot$component$deployment$recent36930 = (function camelot$component$deployment$recent$recent_deployment_section_component_$___GT_t_camelot$component$deployment$recent36930(recent_deployment_section_component__$1,data__$1,owner__$1,meta36931){
return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent36930(recent_deployment_section_component__$1,data__$1,owner__$1,meta36931));
});

}

return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent36930(camelot$component$deployment$recent$recent_deployment_section_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
