// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.library.util');
goog.require('cljs.core');
goog.require('camelot.rest');
goog.require('camelot.nav');
goog.require('camelot.util.filter');
goog.require('camelot.state');
goog.require('camelot.translation.core');
goog.require('om.core');
camelot.component.library.util.collection_columns = (3);
camelot.component.library.util.page_size = (50);
camelot.component.library.util.get_matching = (function camelot$component$library$util$get_matching(data){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__42720_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$records,p1__42720_SHARP_], null));
}),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search,cljs.core.cst$kw$ordered_DASH_ids], null)));
});
camelot.component.library.util.unidentified_QMARK_ = (function camelot$component$library$util$unidentified_QMARK_(x){
return ((x == null)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("unidentified",x));
});
camelot.component.library.util.media_ids_on_page = (function camelot$component$library$util$media_ids_on_page(data){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(camelot.component.library.util.page_size,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search,cljs.core.cst$kw$page], null)) - (1)) * camelot.component.library.util.page_size),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search,cljs.core.cst$kw$ordered_DASH_ids], null))));
});
camelot.component.library.util.media_on_page = (function camelot$component$library$util$media_on_page(var_args){
var args42722 = [];
var len__7492__auto___42725 = arguments.length;
var i__7493__auto___42726 = (0);
while(true){
if((i__7493__auto___42726 < len__7492__auto___42725)){
args42722.push((arguments[i__7493__auto___42726]));

var G__42727 = (i__7493__auto___42726 + (1));
i__7493__auto___42726 = G__42727;
continue;
} else {
}
break;
}

var G__42724 = args42722.length;
switch (G__42724) {
case 1:
return camelot.component.library.util.media_on_page.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return camelot.component.library.util.media_on_page.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42722.length)].join('')));

}
});

camelot.component.library.util.media_on_page.cljs$core$IFn$_invoke$arity$1 = (function (data){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__42721_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$records,p1__42721_SHARP_], null));
}),camelot.component.library.util.media_ids_on_page(data));
});

camelot.component.library.util.media_on_page.cljs$core$IFn$_invoke$arity$0 = (function (){
var data = camelot.state.library_state();
return camelot.component.library.util.media_on_page.cljs$core$IFn$_invoke$arity$1(data);
});

camelot.component.library.util.media_on_page.cljs$lang$maxFixedArity = 1;

camelot.component.library.util.all_media_selected = (function camelot$component$library$util$all_media_selected(var_args){
var args42729 = [];
var len__7492__auto___42732 = arguments.length;
var i__7493__auto___42733 = (0);
while(true){
if((i__7493__auto___42733 < len__7492__auto___42732)){
args42729.push((arguments[i__7493__auto___42733]));

var G__42734 = (i__7493__auto___42733 + (1));
i__7493__auto___42733 = G__42734;
continue;
} else {
}
break;
}

var G__42731 = args42729.length;
switch (G__42731) {
case 1:
return camelot.component.library.util.all_media_selected.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return camelot.component.library.util.all_media_selected.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42729.length)].join('')));

}
});

camelot.component.library.util.all_media_selected.cljs$core$IFn$_invoke$arity$1 = (function (data){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$selected,camelot.component.library.util.media_on_page.cljs$core$IFn$_invoke$arity$1(data));
});

camelot.component.library.util.all_media_selected.cljs$core$IFn$_invoke$arity$0 = (function (){
return camelot.component.library.util.all_media_selected.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state());
});

camelot.component.library.util.all_media_selected.cljs$lang$maxFixedArity = 1;

camelot.component.library.util.find_with_id = (function camelot$component$library$util$find_with_id(data,media_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$records,media_id], null));
});
camelot.component.library.util.delete_with_ids_BANG_ = (function camelot$component$library$util$delete_with_ids_BANG_(data,media_ids){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$records,(function (rs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__42736_SHARP_,p2__42737_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__42736_SHARP_,p2__42737_SHARP_);
}),rs,media_ids);
}));

return om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search,cljs.core.cst$kw$ordered_DASH_ids], null),(function (ms){
return cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__42738_SHARP_){
return cljs.core.contains_QMARK_(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,media_ids),p1__42738_SHARP_);
}),ms));
}));
});
camelot.component.library.util.delete_sightings_from_media_with_id_BANG_ = (function camelot$component$library$util$delete_sightings_from_media_with_id_BANG_(media_id){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.component.library.util.find_with_id(camelot.state.library_state(),media_id),cljs.core.cst$kw$sightings,cljs.core.PersistentVector.EMPTY);
});
camelot.component.library.util.hydrate_media = (function camelot$component$library$util$hydrate_media(var_args){
var args__7499__auto__ = [];
var len__7492__auto___42748 = arguments.length;
var i__7493__auto___42749 = (0);
while(true){
if((i__7493__auto___42749 < len__7492__auto___42748)){
args__7499__auto__.push((arguments[i__7493__auto___42749]));

var G__42750 = (i__7493__auto___42749 + (1));
i__7493__auto___42749 = G__42750;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((3) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((3)),(0),null)):null);
return camelot.component.library.util.hydrate_media.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7500__auto__);
});

camelot.component.library.util.hydrate_media.cljs$core$IFn$_invoke$arity$variadic = (function (data,media,md,p__42744){
var vec__42745 = p__42744;
var cb = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42745,(0),null);
return camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3("/library/hydrate",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$media_DASH_ids,media], null)], null),((function (vec__42745,cb){
return (function (p1__42739_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$records,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (vec__42745,cb){
return (function (acc,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$media_DASH_id.cljs$core$IFn$_invoke$arity$1(x),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([om.core.value(cljs.core.get.cljs$core$IFn$_invoke$arity$2(md,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera_DASH_id.cljs$core$IFn$_invoke$arity$1(x))),x], 0)),cljs.core.cst$kw$selected,false));
});})(vec__42745,cb))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__42739_SHARP_)));

if(cljs.core.truth_(cb)){
return (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(data) : cb.call(null,data));
} else {
return null;
}
});})(vec__42745,cb))
);
});

camelot.component.library.util.hydrate_media.cljs$lang$maxFixedArity = (3);

camelot.component.library.util.hydrate_media.cljs$lang$applyTo = (function (seq42740){
var G__42741 = cljs.core.first(seq42740);
var seq42740__$1 = cljs.core.next(seq42740);
var G__42742 = cljs.core.first(seq42740__$1);
var seq42740__$2 = cljs.core.next(seq42740__$1);
var G__42743 = cljs.core.first(seq42740__$2);
var seq42740__$3 = cljs.core.next(seq42740__$2);
return camelot.component.library.util.hydrate_media.cljs$core$IFn$_invoke$arity$variadic(G__42741,G__42742,G__42743,seq42740__$3);
});

camelot.component.library.util.load_library_callback = (function camelot$component$library$util$load_library_callback(data,md,resp){
var media_ids = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp);
return camelot.component.library.util.hydrate_media.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.take.cljs$core$IFn$_invoke$arity$2(camelot.component.library.util.page_size,media_ids),md,cljs.core.array_seq([((function (media_ids){
return (function (p1__42751_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(p1__42751_SHARP_,cljs.core.cst$kw$selected_DASH_media_DASH_id,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(p1__42751_SHARP_,cljs.core.cst$kw$metadata,md);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(p1__42751_SHARP_),cljs.core.cst$kw$ordered_DASH_ids,cljs.core.vec(media_ids));

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(p1__42751_SHARP_),cljs.core.cst$kw$page,(1));
});})(media_ids))
], 0));
});
camelot.component.library.util.get_media_flags = (function camelot$component$library$util$get_media_flags(rec){
return cljs.core.select_keys(rec,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$media_DASH_id,cljs.core.cst$kw$media_DASH_attention_DASH_needed,cljs.core.cst$kw$media_DASH_cameracheck,cljs.core.cst$kw$media_DASH_reference_DASH_quality,cljs.core.cst$kw$media_DASH_processed], null));
});
camelot.component.library.util.hide_select_message = (function camelot$component$library$util$hide_select_message(){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state()),cljs.core.cst$kw$show_DASH_select_DASH_count,cljs.core.dec);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.library_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search,cljs.core.cst$kw$show_DASH_select_DASH_count_DASH_override], null),false);
});
camelot.component.library.util.show_select_message = (function camelot$component$library$util$show_select_message(){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state()),cljs.core.cst$kw$show_DASH_select_DASH_count,cljs.core.inc);

return window.setTimeout(camelot.component.library.util.hide_select_message,(1600));
});
camelot.component.library.util.show_identified_message = (function camelot$component$library$util$show_identified_message(){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state()),cljs.core.cst$kw$show_DASH_select_DASH_count,cljs.core.inc);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.library_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search,cljs.core.cst$kw$show_DASH_select_DASH_action], null),camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_identified));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.library_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search,cljs.core.cst$kw$show_DASH_select_DASH_count_DASH_override], null),true);

return window.setTimeout(camelot.component.library.util.hide_select_message,(1600));
});
camelot.component.library.util.set_flag_states = (function camelot$component$library$util$set_flag_states(flag_state_map){
var selected = camelot.component.library.util.all_media_selected.cljs$core$IFn$_invoke$arity$0();
return camelot.rest.post_resource("/library/media/flags",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (selected){
return (function (p1__42752_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([camelot.component.library.util.get_media_flags(p1__42752_SHARP_),flag_state_map], 0));
});})(selected))
,selected)], null),((function (selected){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (selected){
return (function (p1__42753_SHARP_){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (selected){
return (function (p__42758){
var vec__42759 = p__42758;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42759,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42759,(1),null);
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(p1__42753_SHARP_,k,v);
});})(selected))
,cljs.core.vec(flag_state_map)));
});})(selected))
,selected));
});})(selected))
);
});
camelot.component.library.util.set_attention_needed = (function camelot$component$library$util$set_attention_needed(flag_state){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state()),cljs.core.cst$kw$show_DASH_select_DASH_action,(cljs.core.truth_(flag_state)?camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_flagged):camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_unflagged)));

camelot.component.library.util.show_select_message();

var calc_state = (cljs.core.truth_(flag_state)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$media_DASH_attention_DASH_needed,flag_state,cljs.core.cst$kw$media_DASH_processed,false], null):new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$media_DASH_attention_DASH_needed,flag_state], null));
return camelot.component.library.util.set_flag_states(calc_state);
});
camelot.component.library.util.set_reference_quality = (function camelot$component$library$util$set_reference_quality(flag_state){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state()),cljs.core.cst$kw$show_DASH_select_DASH_action,(cljs.core.truth_(flag_state)?camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_reference_DASH_quality):camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_ordinary_DASH_quality)));

camelot.component.library.util.show_select_message();

return camelot.component.library.util.set_flag_states(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$media_DASH_reference_DASH_quality,flag_state], null));
});
camelot.component.library.util.set_processed = (function camelot$component$library$util$set_processed(flag_state){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state()),cljs.core.cst$kw$show_DASH_select_DASH_action,(cljs.core.truth_(flag_state)?camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_processed):camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_unprocessed)));

camelot.component.library.util.show_select_message();

return camelot.component.library.util.set_flag_states(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$media_DASH_processed,flag_state], null));
});
camelot.component.library.util.set_cameracheck = (function camelot$component$library$util$set_cameracheck(flag_state){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state()),cljs.core.cst$kw$show_DASH_select_DASH_action,(cljs.core.truth_(flag_state)?camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_test_DASH_fires):camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_not_DASH_test_DASH_fires)));

camelot.component.library.util.show_select_message();

return camelot.component.library.util.set_flag_states((cljs.core.truth_(flag_state)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$media_DASH_cameracheck,true,cljs.core.cst$kw$media_DASH_processed,true], null):new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$media_DASH_cameracheck,false], null)));
});
camelot.component.library.util.load_library = (function camelot$component$library$util$load_library(var_args){
var args42762 = [];
var len__7492__auto___42765 = arguments.length;
var i__7493__auto___42766 = (0);
while(true){
if((i__7493__auto___42766 < len__7492__auto___42765)){
args42762.push((arguments[i__7493__auto___42766]));

var G__42767 = (i__7493__auto___42766 + (1));
i__7493__auto___42766 = G__42767;
continue;
} else {
}
break;
}

var G__42764 = args42762.length;
switch (G__42764) {
case 1:
return camelot.component.library.util.load_library.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return camelot.component.library.util.load_library.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42762.length)].join('')));

}
});

camelot.component.library.util.load_library.cljs$core$IFn$_invoke$arity$1 = (function (data){
return camelot.component.library.util.load_library.cljs$core$IFn$_invoke$arity$2(data,"");
});

camelot.component.library.util.load_library.cljs$core$IFn$_invoke$arity$2 = (function (data,search){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search,cljs.core.cst$kw$inprogress], null),true);

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2("/library/metadata",(function (md){
return camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3("/library",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$search,search], null)], null),(function (resp){
camelot.component.library.util.load_library_callback(data,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(md),resp);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search,cljs.core.cst$kw$inprogress], null),false);
}));
}));
});

camelot.component.library.util.load_library.cljs$lang$maxFixedArity = 2;

camelot.component.library.util.load_taxonomies = (function camelot$component$library$util$load_taxonomies(var_args){
var args42771 = [];
var len__7492__auto___42774 = arguments.length;
var i__7493__auto___42775 = (0);
while(true){
if((i__7493__auto___42775 < len__7492__auto___42774)){
args42771.push((arguments[i__7493__auto___42775]));

var G__42776 = (i__7493__auto___42775 + (1));
i__7493__auto___42775 = G__42776;
continue;
} else {
}
break;
}

var G__42773 = args42771.length;
switch (G__42773) {
case 1:
return camelot.component.library.util.load_taxonomies.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return camelot.component.library.util.load_taxonomies.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42771.length)].join('')));

}
});

camelot.component.library.util.load_taxonomies.cljs$core$IFn$_invoke$arity$1 = (function (data){
return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2("/taxonomy",(function (resp){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$species,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42769_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__42769_SHARP_,cljs.core.cst$kw$taxonomy_DASH_id)],[p1__42769_SHARP_]);
}),cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp))));
}));
});

camelot.component.library.util.load_taxonomies.cljs$core$IFn$_invoke$arity$2 = (function (data,survey_id){
return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str("/taxonomy/survey/"),cljs.core.str(survey_id)].join(''),(function (resp){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$species,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42770_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__42770_SHARP_,cljs.core.cst$kw$taxonomy_DASH_id)],[p1__42770_SHARP_]);
}),cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp))));
}));
});

camelot.component.library.util.load_taxonomies.cljs$lang$maxFixedArity = 2;

camelot.component.library.util.load_trap_stations = (function camelot$component$library$util$load_trap_stations(var_args){
var args42778 = [];
var len__7492__auto___42781 = arguments.length;
var i__7493__auto___42782 = (0);
while(true){
if((i__7493__auto___42782 < len__7492__auto___42781)){
args42778.push((arguments[i__7493__auto___42782]));

var G__42783 = (i__7493__auto___42782 + (1));
i__7493__auto___42782 = G__42783;
continue;
} else {
}
break;
}

var G__42780 = args42778.length;
switch (G__42780) {
case 1:
return camelot.component.library.util.load_trap_stations.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return camelot.component.library.util.load_trap_stations.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42778.length)].join('')));

}
});

camelot.component.library.util.load_trap_stations.cljs$core$IFn$_invoke$arity$1 = (function (data){
return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2("/trap-stations",(function (resp){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$trap_DASH_stations,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp));
}));
});

camelot.component.library.util.load_trap_stations.cljs$core$IFn$_invoke$arity$2 = (function (data,survey_id){
return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str("/trap-stations/survey/"),cljs.core.str(survey_id)].join(''),(function (resp){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$trap_DASH_stations,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp));
}));
});

camelot.component.library.util.load_trap_stations.cljs$lang$maxFixedArity = 2;

camelot.component.library.util.deselect_all = (function camelot$component$library$util$deselect_all(var_args){
var args42787 = [];
var len__7492__auto___42790 = arguments.length;
var i__7493__auto___42791 = (0);
while(true){
if((i__7493__auto___42791 < len__7492__auto___42790)){
args42787.push((arguments[i__7493__auto___42791]));

var G__42792 = (i__7493__auto___42791 + (1));
i__7493__auto___42791 = G__42792;
continue;
} else {
}
break;
}

var G__42789 = args42787.length;
switch (G__42789) {
case 1:
return camelot.component.library.util.deselect_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return camelot.component.library.util.deselect_all.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42787.length)].join('')));

}
});

camelot.component.library.util.deselect_all.cljs$core$IFn$_invoke$arity$1 = (function (data){
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42785_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(p1__42785_SHARP_,cljs.core.cst$kw$selected,false);
}),camelot.component.library.util.all_media_selected.cljs$core$IFn$_invoke$arity$1(data)));
});

camelot.component.library.util.deselect_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42786_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(p1__42786_SHARP_,cljs.core.cst$kw$selected,false);
}),camelot.component.library.util.all_media_selected.cljs$core$IFn$_invoke$arity$0()));
});

camelot.component.library.util.deselect_all.cljs$lang$maxFixedArity = 1;

camelot.component.library.util.select_all = (function camelot$component$library$util$select_all(){
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42794_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(p1__42794_SHARP_,cljs.core.cst$kw$selected,true);
}),camelot.component.library.util.media_on_page.cljs$core$IFn$_invoke$arity$0()));
});
camelot.component.library.util.select_all_STAR_ = (function camelot$component$library$util$select_all_STAR_(){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state()),cljs.core.cst$kw$show_DASH_select_DASH_action,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_selected));

camelot.component.library.util.show_select_message();

return camelot.component.library.util.select_all();
});
camelot.component.library.util.deselect_all_STAR_ = (function camelot$component$library$util$deselect_all_STAR_(){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state()),cljs.core.cst$kw$show_DASH_select_DASH_action,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_selected));

camelot.component.library.util.show_select_message();

return camelot.component.library.util.deselect_all.cljs$core$IFn$_invoke$arity$0();
});
camelot.component.library.util.updated_select_position = (function camelot$component$library$util$updated_select_position(media_ids,e,idx){
if((idx == null)){
return (0);
} else {
var G__42796 = e.keyCode;
switch (G__42796) {
case (37):
e.preventDefault();

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("library-key","<left>");

var x__6748__auto__ = (idx - (1));
var y__6749__auto__ = (0);
return ((x__6748__auto__ > y__6749__auto__) ? x__6748__auto__ : y__6749__auto__);

break;
case (38):
e.preventDefault();

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("library-key","<up>");

if((idx < (3))){
return idx;
} else {
return (idx - (3));
}

break;
case (39):
e.preventDefault();

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("library-key","<right>");

var x__6755__auto__ = (idx + (1));
var y__6756__auto__ = (cljs.core.count(media_ids) - (1));
return ((x__6755__auto__ < y__6756__auto__) ? x__6755__auto__ : y__6756__auto__);

break;
case (40):
e.preventDefault();

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("library-key","<down>");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(Math.floor((cljs.core.count(media_ids) / camelot.component.library.util.collection_columns)),Math.floor((idx / camelot.component.library.util.collection_columns)))){
return idx;
} else {
var x__6755__auto__ = (idx + (3));
var y__6756__auto__ = (cljs.core.count(media_ids) - (1));
return ((x__6755__auto__ < y__6756__auto__) ? x__6755__auto__ : y__6756__auto__);
}

break;
default:
return null;

}
}
});
camelot.component.library.util.apply_selection_range = (function camelot$component$library$util$apply_selection_range(data,media_idxs,new_endpoint,shift,ctrl){
if(cljs.core.truth_((function (){var and__6405__auto__ = shift;
if(cljs.core.truth_(and__6405__auto__)){
return cljs.core.cst$kw$anchor_DASH_media_DASH_id.cljs$core$IFn$_invoke$arity$1(data);
} else {
return and__6405__auto__;
}
})())){
var anchor_idx = cljs.core.ffirst(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__42798_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$anchor_DASH_media_DASH_id.cljs$core$IFn$_invoke$arity$1(data),cljs.core.second(p1__42798_SHARP_));
}),media_idxs));
var first_idx = (function (){var x__6755__auto__ = anchor_idx;
var y__6756__auto__ = new_endpoint;
return ((x__6755__auto__ < y__6756__auto__) ? x__6755__auto__ : y__6756__auto__);
})();
var last_idx = (function (){var x__6748__auto__ = anchor_idx;
var y__6749__auto__ = new_endpoint;
return ((x__6748__auto__ > y__6749__auto__) ? x__6748__auto__ : y__6749__auto__);
})();
var media_in_range = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.component.library.util.find_with_id,data),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,cljs.core.take.cljs$core$IFn$_invoke$arity$2(((last_idx - first_idx) + (1)),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(first_idx,media_idxs))));
camelot.component.library.util.deselect_all.cljs$core$IFn$_invoke$arity$1(data);

cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (anchor_idx,first_idx,last_idx,media_in_range){
return (function (p1__42799_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(p1__42799_SHARP_,cljs.core.cst$kw$selected,true);
});})(anchor_idx,first_idx,last_idx,media_in_range))
,media_in_range));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$selected_DASH_media_DASH_id,cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(media_idxs,new_endpoint)));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state()),cljs.core.cst$kw$show_DASH_select_DASH_action,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$util_SLASH_selected));

return camelot.component.library.util.show_select_message();
} else {
var id = cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(media_idxs,new_endpoint));
if(cljs.core.truth_(ctrl)){
} else {
camelot.component.library.util.deselect_all.cljs$core$IFn$_invoke$arity$1(data);
}

if(cljs.core.truth_(ctrl)){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.component.library.util.find_with_id(data,id),cljs.core.cst$kw$selected,cljs.core.not);
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.component.library.util.find_with_id(data,id),cljs.core.cst$kw$selected,true);
}

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$selected_DASH_media_DASH_id,id);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$anchor_DASH_media_DASH_id,id);
}
});
camelot.component.library.util.movement_QMARK_ = (function camelot$component$library$util$movement_QMARK_(evt){
return cljs.core.some_QMARK_(cljs.core.some(cljs.core.PersistentHashSet.fromArray([evt.keyCode], true),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [(37),(38),(39),(40),(65),(87),(68),(83)], null)));
});
camelot.component.library.util.keyboard_select_media = (function camelot$component$library$util$keyboard_select_media(data,evt){
var media_idxs = cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,e){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,e], null);
}),camelot.component.library.util.media_ids_on_page(data)));
var endpoint_idx = cljs.core.ffirst(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (media_idxs){
return (function (p1__42800_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$selected_DASH_media_DASH_id.cljs$core$IFn$_invoke$arity$1(data),cljs.core.second(p1__42800_SHARP_));
});})(media_idxs))
,media_idxs));
var new_endpoint = camelot.component.library.util.updated_select_position(media_idxs,evt,endpoint_idx);
if(cljs.core.truth_((function (){var and__6405__auto__ = camelot.component.library.util.movement_QMARK_(evt);
if(cljs.core.truth_(and__6405__auto__)){
return new_endpoint;
} else {
return and__6405__auto__;
}
})())){
return camelot.component.library.util.apply_selection_range(data,media_idxs,new_endpoint,evt.shiftKey,evt.ctrlKey);
} else {
return null;
}
});
camelot.component.library.util.mouse_select_media = (function camelot$component$library$util$mouse_select_media(data,media_id,shift,ctrl){
var media_idxs = cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,e){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,e], null);
}),camelot.component.library.util.media_ids_on_page(data)));
var new_endpoint = cljs.core.ffirst(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (media_idxs){
return (function (p1__42801_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(media_id,cljs.core.second(p1__42801_SHARP_));
});})(media_idxs))
,media_idxs));
if(cljs.core.truth_(new_endpoint)){
return camelot.component.library.util.apply_selection_range(data,media_idxs,new_endpoint,shift,ctrl);
} else {
return null;
}
});
camelot.component.library.util.toggle_select_image = (function camelot$component$library$util$toggle_select_image(data,media_id,evt){
return camelot.component.library.util.mouse_select_media(data,media_id,evt.shiftKey,evt.ctrlKey);
});
