// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.nav');
goog.require('cljs.core');
goog.require('camelot.rest');
goog.require('camelot.nav');
goog.require('om.dom');
goog.require('camelot.component.progress_bar');
goog.require('goog.date.duration');
goog.require('cljs.core.async');
goog.require('camelot.translation.core');
goog.require('om.core');
goog.require('clojure.string');
camelot.component.nav.bulk_import_refresh_long_timeout = (5000);
camelot.component.nav.bulk_import_refresh_short_timeout = (1000);
camelot.component.nav.time_elapsed = (function camelot$component$nav$time_elapsed(data){
var total = (cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$end_DASH_time], null)).getTime() - cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$start_DASH_time], null)).getTime());
var sec = cljs.core.mod((total / (1000)),(60));
var fsec = Math.floor(sec);
return [cljs.core.str(goog.date.duration.format(total)),cljs.core.str(" "),cljs.core.str(fsec),cljs.core.str(" "),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fsec,(1)))?"second":"seconds"))].join('');
});
camelot.component.nav.time_remaining_estimate = (function camelot$component$nav$time_remaining_estimate(data,progress){
var dif = (cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$end_DASH_time], null)).getTime() - cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$start_DASH_time], null)).getTime());
var todo = ((dif / progress) - dif);
var sec = cljs.core.mod((todo / (1000)),(60));
var fsec = Math.floor(sec);
return [cljs.core.str(goog.date.duration.format(todo)),cljs.core.str(" "),cljs.core.str(fsec),cljs.core.str(" "),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fsec,(1)))?"second":"seconds"))].join('');
});
camelot.component.nav.cancel_import = (function camelot$component$nav$cancel_import(data){
return camelot.rest.post_x_opts("/importer/cancel",cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$successs,(function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$cancelling_DASH_import,true);
}),cljs.core.cst$kw$suppress_DASH_error_DASH_dialog,true], null));
});
/**
 * Get the progress of the bulk import.
 */
camelot.component.nav.import_progress = (function camelot$component$nav$import_progress(data){
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),cljs.core.vals(cljs.core.select_keys(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$complete,cljs.core.cst$kw$failed,cljs.core.cst$kw$ignored], null)))) / (function (){var x__6748__auto__ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.vals(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts], null))));
var y__6749__auto__ = (1);
return ((x__6748__auto__ > y__6749__auto__) ? x__6748__auto__ : y__6749__auto__);
})());
});
/**
 * Hide the settings panel
 */
camelot.component.nav.settings_hide_BANG_ = (function camelot$component$nav$settings_hide_BANG_(){
var elt = document.getElementById("settings");
var navelt = document.getElementById("settings-nav");
if(cljs.core.truth_(elt)){
elt.className = "";
} else {
}

if(cljs.core.truth_(navelt)){
return navelt.className = clojure.string.replace_first(navelt.className,/active/,"");
} else {
return null;
}
});
/**
 * Show the settings panel
 */
camelot.component.nav.settings_show_BANG_ = (function camelot$component$nav$settings_show_BANG_(){
var elt = document.getElementById("settings");
var navelt = document.getElementById("settings-nav");
elt.className = "show";

return navelt.className = [cljs.core.str("active "),cljs.core.str(navelt.className)].join('');
});
/**
 * Toggle the settings panel show state
 */
camelot.component.nav.toggle_settings_BANG_ = (function camelot$component$nav$toggle_settings_BANG_(){
var navelt = document.getElementById("settings-nav");
if(clojure.string.includes_QMARK_(navelt.className,"active")){
return camelot.component.nav.settings_hide_BANG_();
} else {
return camelot.component.nav.settings_show_BANG_();
}
});
camelot.component.nav.bulk_import_details_panel_component = (function camelot$component$nav$bulk_import_details_panel_component(data,owner){
if(typeof camelot.component.nav.t_camelot$component$nav42234 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.nav.t_camelot$component$nav42234 = (function (bulk_import_details_panel_component,data,owner,meta42235){
this.bulk_import_details_panel_component = bulk_import_details_panel_component;
this.data = data;
this.owner = owner;
this.meta42235 = meta42235;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.nav.t_camelot$component$nav42234.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42236,meta42235__$1){
var self__ = this;
var _42236__$1 = this;
return (new camelot.component.nav.t_camelot$component$nav42234(self__.bulk_import_details_panel_component,self__.data,self__.owner,meta42235__$1));
});

camelot.component.nav.t_camelot$component$nav42234.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42236){
var self__ = this;
var _42236__$1 = this;
return self__.meta42235;
});

camelot.component.nav.t_camelot$component$nav42234.prototype.om$core$IRender$ = true;

camelot.component.nav.t_camelot$component$nav42234.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var total = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),cljs.core.vals(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts], null))));
var progress = camelot.component.nav.import_progress(self__.data);
var G__42237 = ({"id": "bulk-import-details-panel", "onClick": ((function (total,progress,___$1){
return (function (p1__42171_SHARP_){
p1__42171_SHARP_.preventDefault();

return p1__42171_SHARP_.stopPropagation();
});})(total,progress,___$1))
, "className": (cljs.core.truth_((function (){var and__6405__auto__ = cljs.core.pos_int_QMARK_(total);
if(and__6405__auto__){
return cljs.core.cst$kw$show_DASH_bulk_DASH_import_DASH_details.cljs$core$IFn$_invoke$arity$1(self__.data);
} else {
return and__6405__auto__;
}
})())?"expanded":"")});
var G__42238 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$import_DASH_status.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__42239 = ({"className": "bulk-import-details-container"});
var G__42240 = om.util.force_children((function (){var G__42246 = ({"className": "progress-numbers"});
var G__42247 = om.util.force_children(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),cljs.core.vals(cljs.core.select_keys(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$complete,cljs.core.cst$kw$failed,cljs.core.cst$kw$ignored], null)))));
var G__42248 = om.util.force_children(" ");
var G__42249 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_of_DASH_lc));
var G__42250 = om.util.force_children(" ");
var G__42251 = om.util.force_children(total);
return React.DOM.span(G__42246,G__42247,G__42248,G__42249,G__42250,G__42251);
})());
var G__42241 = om.util.force_children((function (){var G__42252 = ({"className": "field-label"});
var G__42253 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_progress_DASH_label));
return React.DOM.label(G__42252,G__42253);
})());
var G__42242 = om.util.force_children((function (){var G__42254 = ({"className": "bulk-import-progress-bar"});
var G__42255 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.progress_bar.component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts], null)),cljs.core.cst$kw$total,total)], null)));
var G__42256 = om.util.force_children(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(progress,(1)))?null:(function (){var G__42257 = ({"className": "fa fa-times-circle cancel-button", "title": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_cancel), "onClick": ((function (G__42254,G__42255,G__42239,G__42240,G__42241,G__42237,total,progress,___$1){
return (function (){
return camelot.component.nav.cancel_import(self__.data);
});})(G__42254,G__42255,G__42239,G__42240,G__42241,G__42237,total,progress,___$1))
});
return React.DOM.span(G__42257);
})()));
return React.DOM.div(G__42254,G__42255,G__42256);
})());
var G__42243 = om.util.force_children(((cljs.core.pos_int_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts,cljs.core.cst$kw$ignored], null))))?(function (){var G__42258 = ({"className": "bulk-import-cancelled bulk-import-status"});
var G__42259 = om.util.force_children((function (){var G__42260 = ({"className": "fa fa-ban fa-2x", "title": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_cancelled)});
return React.DOM.span(G__42260);
})());
return React.DOM.p(G__42258,G__42259);
})():((cljs.core.pos_int_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts,cljs.core.cst$kw$failed], null))))?(function (){var G__42261 = ({"className": "bulk-import-failure bulk-import-status"});
var G__42262 = om.util.force_children((function (){var G__42263 = ({"className": "fa fa-exclamation-triangle fa-2x", "title": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_failures)});
return React.DOM.span(G__42263);
})());
return React.DOM.p(G__42261,G__42262);
})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(progress,(1)))?(function (){var G__42264 = ({"className": "bulk-import-success bulk-import-status"});
var G__42265 = om.util.force_children((function (){var G__42266 = ({"className": "fa fa-check fa-2x", "title": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_success)});
return React.DOM.span(G__42266);
})());
return React.DOM.p(G__42264,G__42265);
})():null))));
var G__42244 = om.util.force_children((((progress === (0)))?(function (){var G__42267 = null;
var G__42268 = om.util.force_children((function (){var G__42269 = ({"className": "field-label"});
var G__42270 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_calculating));
return React.DOM.label(G__42269,G__42270);
})());
return React.DOM.div(G__42267,G__42268);
})():((cljs.core.pos_int_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts,cljs.core.cst$kw$ignored], null))))?(function (){var G__42271 = null;
var G__42272 = om.util.force_children((function (){var G__42273 = ({"className": "field-label"});
var G__42274 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_cancelled));
return React.DOM.label(G__42273,G__42274);
})());
return React.DOM.div(G__42271,G__42272);
})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(progress,(1)))?(function (){var G__42275 = null;
var G__42276 = om.util.force_children((function (){var G__42278 = ({"className": "field-label"});
var G__42279 = om.util.force_children((((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts,cljs.core.cst$kw$failed], null)) === (0)))?camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_complete):camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_complete_DASH_with_DASH_errors)));
return React.DOM.label(G__42278,G__42279);
})());
var G__42277 = om.util.force_children((function (){var G__42280 = null;
var G__42281 = om.util.force_children(camelot.component.nav.time_elapsed(self__.data));
return React.DOM.p(G__42280,G__42281);
})());
return React.DOM.div(G__42275,G__42276,G__42277);
})():(function (){var G__42282 = null;
var G__42283 = om.util.force_children((function (){var G__42285 = ({"className": "field-label"});
var G__42286 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_time_DASH_remaining));
return React.DOM.label(G__42285,G__42286);
})());
var G__42284 = om.util.force_children((function (){var G__42287 = null;
var G__42288 = om.util.force_children(camelot.component.nav.time_remaining_estimate(self__.data,progress));
return React.DOM.p(G__42287,G__42288);
})());
return React.DOM.div(G__42282,G__42283,G__42284);
})()
))));
var G__42245 = om.util.force_children(((cljs.core.pos_int_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts,cljs.core.cst$kw$failed], null))))?(function (){var G__42289 = null;
var G__42290 = om.util.force_children((function (){var G__42292 = null;
var G__42293 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_failed_DASH_paths));
return React.DOM.label(G__42292,G__42293);
})());
var G__42291 = om.util.force_children((function (){var G__42294 = ({"rows": "8", "style": ({"width": "100%"})});
var G__42295 = clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$failed_DASH_paths], null)));
return (om.dom.textarea.cljs$core$IFn$_invoke$arity$2 ? om.dom.textarea.cljs$core$IFn$_invoke$arity$2(G__42294,G__42295) : om.dom.textarea.call(null,G__42294,G__42295));
})());
return React.DOM.div(G__42289,G__42290,G__42291);
})():null));
return React.DOM.div(G__42239,G__42240,G__42241,G__42242,G__42243,G__42244,G__42245);
})():null));
return React.DOM.div(G__42237,G__42238);
});

camelot.component.nav.t_camelot$component$nav42234.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$bulk_DASH_import_DASH_details_DASH_panel_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta42235], null);
});

camelot.component.nav.t_camelot$component$nav42234.cljs$lang$type = true;

camelot.component.nav.t_camelot$component$nav42234.cljs$lang$ctorStr = "camelot.component.nav/t_camelot$component$nav42234";

camelot.component.nav.t_camelot$component$nav42234.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.nav/t_camelot$component$nav42234");
});

camelot.component.nav.__GT_t_camelot$component$nav42234 = (function camelot$component$nav$bulk_import_details_panel_component_$___GT_t_camelot$component$nav42234(bulk_import_details_panel_component__$1,data__$1,owner__$1,meta42235){
return (new camelot.component.nav.t_camelot$component$nav42234(bulk_import_details_panel_component__$1,data__$1,owner__$1,meta42235));
});

}

return (new camelot.component.nav.t_camelot$component$nav42234(camelot$component$nav$bulk_import_details_panel_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Display the bulk import status, if available.
 */
camelot.component.nav.bulk_import_progress_component = (function camelot$component$nav$bulk_import_progress_component(data,owner){
if(typeof camelot.component.nav.t_camelot$component$nav42389 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.nav.t_camelot$component$nav42389 = (function (bulk_import_progress_component,data,owner,meta42390){
this.bulk_import_progress_component = bulk_import_progress_component;
this.data = data;
this.owner = owner;
this.meta42390 = meta42390;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.nav.t_camelot$component$nav42389.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42391,meta42390__$1){
var self__ = this;
var _42391__$1 = this;
return (new camelot.component.nav.t_camelot$component$nav42389(self__.bulk_import_progress_component,self__.data,self__.owner,meta42390__$1));
});

camelot.component.nav.t_camelot$component$nav42389.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42391){
var self__ = this;
var _42391__$1 = this;
return self__.meta42390;
});

camelot.component.nav.t_camelot$component$nav42389.prototype.om$core$IInitState$ = true;

camelot.component.nav.t_camelot$component$nav42389.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cmd_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.nav.t_camelot$component$nav42389.prototype.om$core$IDidMount$ = true;

camelot.component.nav.t_camelot$component$nav42389.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,___$1){
return (function (state_42430){
var state_val_42431 = (state_42430[(1)]);
if((state_val_42431 === (7))){
var inst_42426 = (state_42430[(2)]);
var state_42430__$1 = state_42430;
var statearr_42432_42481 = state_42430__$1;
(statearr_42432_42481[(2)] = inst_42426);

(statearr_42432_42481[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42431 === (1))){
var inst_42392 = camelot.component.nav.bulk_import_refresh_long_timeout;
var state_42430__$1 = (function (){var statearr_42433 = state_42430;
(statearr_42433[(7)] = inst_42392);

return statearr_42433;
})();
var statearr_42434_42482 = state_42430__$1;
(statearr_42434_42482[(2)] = null);

(statearr_42434_42482[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42431 === (4))){
var inst_42405 = (state_42430[(8)]);
var inst_42403 = (state_42430[(9)]);
var inst_42397 = (state_42430[(10)]);
var inst_42403__$1 = (state_42430[(2)]);
var inst_42404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42403__$1,(0),null);
var inst_42405__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42403__$1,(1),null);
var inst_42406 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42405__$1,inst_42397);
var state_42430__$1 = (function (){var statearr_42435 = state_42430;
(statearr_42435[(8)] = inst_42405__$1);

(statearr_42435[(9)] = inst_42403__$1);

(statearr_42435[(11)] = inst_42404);

return statearr_42435;
})();
if(inst_42406){
var statearr_42436_42483 = state_42430__$1;
(statearr_42436_42483[(1)] = (5));

} else {
var statearr_42437_42484 = state_42430__$1;
(statearr_42437_42484[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42431 === (6))){
var inst_42405 = (state_42430[(8)]);
var inst_42403 = (state_42430[(9)]);
var inst_42404 = (state_42430[(11)]);
var inst_42392 = (state_42430[(7)]);
var inst_42397 = (state_42430[(10)]);
var inst_42410 = [cljs.core.cst$kw$success,cljs.core.cst$kw$suppress_DASH_error_DASH_dialog];
var inst_42411 = (function (){var tout = inst_42392;
var cch = inst_42397;
var vec__42394 = inst_42403;
var msg = inst_42404;
var port = inst_42405;
return ((function (tout,cch,vec__42394,msg,port,inst_42405,inst_42403,inst_42404,inst_42392,inst_42397,inst_42410,state_val_42431,c__28576__auto__,___$1){
return (function (p1__42296_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__42296_SHARP_));
});
;})(tout,cch,vec__42394,msg,port,inst_42405,inst_42403,inst_42404,inst_42392,inst_42397,inst_42410,state_val_42431,c__28576__auto__,___$1))
})();
var inst_42412 = [inst_42411,true];
var inst_42413 = cljs.core.PersistentHashMap.fromArrays(inst_42410,inst_42412);
var inst_42414 = camelot.rest.get_x_opts("/importer",inst_42413);
var inst_42415 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.data) : cljs.core.deref.call(null,self__.data));
var inst_42416 = camelot.component.nav.import_progress(inst_42415);
var inst_42417 = (inst_42416 > (0));
var inst_42418 = (inst_42416 < (1));
var inst_42419 = (inst_42417) && (inst_42418);
var state_42430__$1 = (function (){var statearr_42438 = state_42430;
(statearr_42438[(12)] = inst_42414);

return statearr_42438;
})();
if(cljs.core.truth_(inst_42419)){
var statearr_42439_42485 = state_42430__$1;
(statearr_42439_42485[(1)] = (8));

} else {
var statearr_42440_42486 = state_42430__$1;
(statearr_42440_42486[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42431 === (3))){
var inst_42428 = (state_42430[(2)]);
var state_42430__$1 = state_42430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42430__$1,inst_42428);
} else {
if((state_val_42431 === (2))){
var inst_42392 = (state_42430[(7)]);
var inst_42397 = (state_42430[(10)]);
var inst_42397__$1 = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$cmd_DASH_chan);
var inst_42398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42399 = cljs.core.async.timeout(inst_42392);
var inst_42400 = [inst_42397__$1,inst_42399];
var inst_42401 = (new cljs.core.PersistentVector(null,2,(5),inst_42398,inst_42400,null));
var state_42430__$1 = (function (){var statearr_42441 = state_42430;
(statearr_42441[(10)] = inst_42397__$1);

return statearr_42441;
})();
return cljs.core.async.ioc_alts_BANG_(state_42430__$1,(4),inst_42401);
} else {
if((state_val_42431 === (9))){
var state_42430__$1 = state_42430;
var statearr_42442_42487 = state_42430__$1;
(statearr_42442_42487[(2)] = camelot.component.nav.bulk_import_refresh_long_timeout);

(statearr_42442_42487[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42431 === (5))){
var inst_42408 = console.log("Bulk import poller cleaned up");
var state_42430__$1 = state_42430;
var statearr_42443_42488 = state_42430__$1;
(statearr_42443_42488[(2)] = inst_42408);

(statearr_42443_42488[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42431 === (10))){
var inst_42423 = (state_42430[(2)]);
var inst_42392 = inst_42423;
var state_42430__$1 = (function (){var statearr_42444 = state_42430;
(statearr_42444[(7)] = inst_42392);

return statearr_42444;
})();
var statearr_42445_42489 = state_42430__$1;
(statearr_42445_42489[(2)] = null);

(statearr_42445_42489[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42431 === (8))){
var state_42430__$1 = state_42430;
var statearr_42446_42490 = state_42430__$1;
(statearr_42446_42490[(2)] = camelot.component.nav.bulk_import_refresh_short_timeout);

(statearr_42446_42490[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto__,___$1){
return (function() {
var camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__ = null;
var camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____0 = (function (){
var statearr_42450 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42450[(0)] = camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__);

(statearr_42450[(1)] = (1));

return statearr_42450;
});
var camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____1 = (function (state_42430){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_42430);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e42451){if((e42451 instanceof Object)){
var ex__28456__auto__ = e42451;
var statearr_42452_42491 = state_42430;
(statearr_42452_42491[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42430);

return cljs.core.cst$kw$recur;
} else {
throw e42451;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__42492 = state_42430;
state_42430 = G__42492;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__ = function(state_42430){
switch(arguments.length){
case 0:
return camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____1.call(this,state_42430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____0;
camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____1;
return camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,___$1))
})();
var state__28578__auto__ = (function (){var statearr_42453 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_42453[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_42453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,___$1))
);

return c__28576__auto__;
});

camelot.component.nav.t_camelot$component$nav42389.prototype.om$core$IWillUnmount$ = true;

camelot.component.nav.t_camelot$component$nav42389.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,___$1){
return (function (state_42461){
var state_val_42462 = (state_42461[(1)]);
if((state_val_42462 === (1))){
var inst_42454 = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$cmd_DASH_chan);
var inst_42455 = [cljs.core.cst$kw$cmd];
var inst_42456 = [cljs.core.cst$kw$stop];
var inst_42457 = cljs.core.PersistentHashMap.fromArrays(inst_42455,inst_42456);
var state_42461__$1 = state_42461;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42461__$1,(2),inst_42454,inst_42457);
} else {
if((state_val_42462 === (2))){
var inst_42459 = (state_42461[(2)]);
var state_42461__$1 = state_42461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42461__$1,inst_42459);
} else {
return null;
}
}
});})(c__28576__auto__,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto__,___$1){
return (function() {
var camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__ = null;
var camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____0 = (function (){
var statearr_42466 = [null,null,null,null,null,null,null];
(statearr_42466[(0)] = camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__);

(statearr_42466[(1)] = (1));

return statearr_42466;
});
var camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____1 = (function (state_42461){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_42461);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e42467){if((e42467 instanceof Object)){
var ex__28456__auto__ = e42467;
var statearr_42468_42493 = state_42461;
(statearr_42468_42493[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42461);

return cljs.core.cst$kw$recur;
} else {
throw e42467;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__42494 = state_42461;
state_42461 = G__42494;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__ = function(state_42461){
switch(arguments.length){
case 0:
return camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____1.call(this,state_42461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____0;
camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto____1;
return camelot$component$nav$bulk_import_progress_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,___$1))
})();
var state__28578__auto__ = (function (){var statearr_42469 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_42469[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_42469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,___$1))
);

return c__28576__auto__;
});

camelot.component.nav.t_camelot$component$nav42389.prototype.om$core$IRender$ = true;

camelot.component.nav.t_camelot$component$nav42389.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var p = camelot.component.nav.import_progress(self__.data);
if((p > (0))){
var G__42470 = null;
var G__42471 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.nav.bulk_import_details_panel_component,self__.data));
var G__42472 = om.util.force_children((function (){var G__42473 = ({"className": "bulk-import-progress", "title": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_status)});
var G__42474 = om.util.force_children((function (){var G__42477 = ({"className": "fa fa-upload"});
return React.DOM.span(G__42477);
})());
var G__42475 = om.util.force_children(" ");
var G__42476 = om.util.force_children((function (){var G__42478 = null;
var G__42479 = om.util.force_children(((p * (100)) | (0)));
var G__42480 = om.util.force_children("%");
return React.DOM.span(G__42478,G__42479,G__42480);
})());
return React.DOM.div(G__42473,G__42474,G__42475,G__42476);
})());
return React.DOM.div(G__42470,G__42471,G__42472);
} else {
return null;
}
});

camelot.component.nav.t_camelot$component$nav42389.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$bulk_DASH_import_DASH_progress_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Display the bulk import status, if available."], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta42390], null);
});

camelot.component.nav.t_camelot$component$nav42389.cljs$lang$type = true;

camelot.component.nav.t_camelot$component$nav42389.cljs$lang$ctorStr = "camelot.component.nav/t_camelot$component$nav42389";

camelot.component.nav.t_camelot$component$nav42389.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.nav/t_camelot$component$nav42389");
});

camelot.component.nav.__GT_t_camelot$component$nav42389 = (function camelot$component$nav$bulk_import_progress_component_$___GT_t_camelot$component$nav42389(bulk_import_progress_component__$1,data__$1,owner__$1,meta42390){
return (new camelot.component.nav.t_camelot$component$nav42389(bulk_import_progress_component__$1,data__$1,owner__$1,meta42390));
});

}

return (new camelot.component.nav.t_camelot$component$nav42389(camelot$component$nav$bulk_import_progress_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Render a list item for an item in the navigation bar.
 */
camelot.component.nav.nav_item_component = (function camelot$component$nav$nav_item_component(data,owner){
if(typeof camelot.component.nav.t_camelot$component$nav42511 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.nav.t_camelot$component$nav42511 = (function (nav_item_component,data,owner,meta42512){
this.nav_item_component = nav_item_component;
this.data = data;
this.owner = owner;
this.meta42512 = meta42512;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.nav.t_camelot$component$nav42511.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42513,meta42512__$1){
var self__ = this;
var _42513__$1 = this;
return (new camelot.component.nav.t_camelot$component$nav42511(self__.nav_item_component,self__.data,self__.owner,meta42512__$1));
});

camelot.component.nav.t_camelot$component$nav42511.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42513){
var self__ = this;
var _42513__$1 = this;
return self__.meta42512;
});

camelot.component.nav.t_camelot$component$nav42511.prototype.om$core$IRender$ = true;

camelot.component.nav.t_camelot$component$nav42511.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$function.cljs$core$IFn$_invoke$arity$1(self__.data),"settings")){
var G__42514 = ({"id": "settings-nav", "className": "icon-only", "onClick": ((function (___$1){
return (function (){
return camelot.component.nav.toggle_settings_BANG_();
});})(___$1))
});
var G__42515 = om.util.force_children((function (){var G__42516 = null;
var G__42517 = om.util.force_children((function (){var G__42518 = ({"className": "fa fa-cogs fa-2x"});
return React.DOM.span(G__42518);
})());
return React.DOM.a(G__42516,G__42517);
})());
return React.DOM.li(G__42514,G__42515);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$function.cljs$core$IFn$_invoke$arity$1(self__.data),"bulk-import-progress")){
var G__42519 = ({"id": "bulk-import-progress-nav", "onMouseOver": ((function (___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$show_DASH_bulk_DASH_import_DASH_details,true);
});})(___$1))
, "onMouseOut": ((function (___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$show_DASH_bulk_DASH_import_DASH_details,false);
});})(___$1))
});
var G__42520 = om.util.force_children((function (){var G__42521 = ({"className": "bulk-import-progress-container"});
var G__42522 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.nav.bulk_import_progress_component,self__.data));
return React.DOM.div(G__42521,G__42522);
})());
return React.DOM.li(G__42519,G__42520);
} else {
var G__42523 = ({"className": (cljs.core.truth_(cljs.core.cst$kw$experimental.cljs$core$IFn$_invoke$arity$1(self__.data))?"experimental":(cljs.core.truth_(cljs.core.cst$kw$deprecated.cljs$core$IFn$_invoke$arity$1(self__.data))?"deprecated":"")), "onClick": ((function (___$1){
return (function (){
return camelot.nav.nav_BANG_(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(self__.data));
});})(___$1))
});
var G__42524 = om.util.force_children((function (){var G__42525 = null;
var G__42526 = om.util.force_children(cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.a(G__42525,G__42526);
})());
return React.DOM.li(G__42523,G__42524);

}
}
});

camelot.component.nav.t_camelot$component$nav42511.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$nav_DASH_item_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Render a list item for an item in the navigation bar."], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta42512], null);
});

camelot.component.nav.t_camelot$component$nav42511.cljs$lang$type = true;

camelot.component.nav.t_camelot$component$nav42511.cljs$lang$ctorStr = "camelot.component.nav/t_camelot$component$nav42511";

camelot.component.nav.t_camelot$component$nav42511.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.nav/t_camelot$component$nav42511");
});

camelot.component.nav.__GT_t_camelot$component$nav42511 = (function camelot$component$nav$nav_item_component_$___GT_t_camelot$component$nav42511(nav_item_component__$1,data__$1,owner__$1,meta42512){
return (new camelot.component.nav.t_camelot$component$nav42511(nav_item_component__$1,data__$1,owner__$1,meta42512));
});

}

return (new camelot.component.nav.t_camelot$component$nav42511(camelot$component$nav$nav_item_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Render navigation bar and contents.
 */
camelot.component.nav.nav_component = (function camelot$component$nav$nav_component(data,owner){
if(typeof camelot.component.nav.t_camelot$component$nav42537 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.nav.t_camelot$component$nav42537 = (function (nav_component,data,owner,meta42538){
this.nav_component = nav_component;
this.data = data;
this.owner = owner;
this.meta42538 = meta42538;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.nav.t_camelot$component$nav42537.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42539,meta42538__$1){
var self__ = this;
var _42539__$1 = this;
return (new camelot.component.nav.t_camelot$component$nav42537(self__.nav_component,self__.data,self__.owner,meta42538__$1));
});

camelot.component.nav.t_camelot$component$nav42537.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42539){
var self__ = this;
var _42539__$1 = this;
return self__.meta42538;
});

camelot.component.nav.t_camelot$component$nav42537.prototype.om$core$IRender$ = true;

camelot.component.nav.t_camelot$component$nav42537.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__42540 = null;
var G__42541 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$loading.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__42543 = ({"className": "loading"});
var G__42544 = om.util.force_children((function (){var G__42546 = ({"src": "images/spinner.gif", "height": "32px"});
return React.DOM.img(G__42546);
})());
var G__42545 = om.util.force_children(cljs.core.cst$kw$loading.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.label(G__42543,G__42544,G__42545);
})():null));
var G__42542 = om.util.force_children(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(om.dom.ul,({"className": "nav navbar-nav"}),om.core.build_all.cljs$core$IFn$_invoke$arity$2(camelot.component.nav.nav_item_component,(cljs.core.truth_(cljs.core.cst$kw$restricted_DASH_mode.cljs$core$IFn$_invoke$arity$1(self__.data))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null):cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.cst$kw$menu_DASH_items.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$nav.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$application.cljs$core$IFn$_invoke$arity$1(self__.data))))))));
return React.DOM.div(G__42540,G__42541,G__42542);
});

camelot.component.nav.t_camelot$component$nav42537.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$nav_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Render navigation bar and contents."], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta42538], null);
});

camelot.component.nav.t_camelot$component$nav42537.cljs$lang$type = true;

camelot.component.nav.t_camelot$component$nav42537.cljs$lang$ctorStr = "camelot.component.nav/t_camelot$component$nav42537";

camelot.component.nav.t_camelot$component$nav42537.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.nav/t_camelot$component$nav42537");
});

camelot.component.nav.__GT_t_camelot$component$nav42537 = (function camelot$component$nav$nav_component_$___GT_t_camelot$component$nav42537(nav_component__$1,data__$1,owner__$1,meta42538){
return (new camelot.component.nav.t_camelot$component$nav42537(nav_component__$1,data__$1,owner__$1,meta42538));
});

}

return (new camelot.component.nav.t_camelot$component$nav42537(camelot$component$nav$nav_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
