// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.site.core');
goog.require('cljs.core');
goog.require('camelot.rest');
goog.require('camelot.nav');
goog.require('om.dom');
goog.require('camelot.component.site.manage');
goog.require('camelot.component.util');
goog.require('cljs.core.async');
goog.require('camelot.translation.core');
goog.require('camelot.util.cursorise');
goog.require('om.core');
goog.require('clojure.string');
/**
 * Delete the site and trigger a removal event.
 */
camelot.component.site.core.delete$ = (function camelot$component$site$core$delete(state,data,event){
event.preventDefault();

event.stopPropagation();

if(cljs.core.truth_((function (){var G__34354 = camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_confirm_DASH_delete);
return confirm(G__34354);
})())){
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str("/sites/"),cljs.core.str(cljs.core.cst$kw$site_DASH_id.cljs$core$IFn$_invoke$arity$1(data))].join(''),(function (){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_34362){
var state_val_34363 = (state_34362[(1)]);
if((state_val_34363 === (1))){
var inst_34355 = cljs.core.cst$kw$chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_34356 = [cljs.core.cst$kw$event,cljs.core.cst$kw$data];
var inst_34357 = [cljs.core.cst$kw$delete,data];
var inst_34358 = cljs.core.PersistentHashMap.fromArrays(inst_34356,inst_34357);
var state_34362__$1 = state_34362;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34362__$1,(2),inst_34355,inst_34358);
} else {
if((state_val_34363 === (2))){
var inst_34360 = (state_34362[(2)]);
var state_34362__$1 = state_34362;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34362__$1,inst_34360);
} else {
return null;
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$component$site$core$delete_$_state_machine__28453__auto__ = null;
var camelot$component$site$core$delete_$_state_machine__28453__auto____0 = (function (){
var statearr_34367 = [null,null,null,null,null,null,null];
(statearr_34367[(0)] = camelot$component$site$core$delete_$_state_machine__28453__auto__);

(statearr_34367[(1)] = (1));

return statearr_34367;
});
var camelot$component$site$core$delete_$_state_machine__28453__auto____1 = (function (state_34362){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_34362);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e34368){if((e34368 instanceof Object)){
var ex__28456__auto__ = e34368;
var statearr_34369_34371 = state_34362;
(statearr_34369_34371[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34362);

return cljs.core.cst$kw$recur;
} else {
throw e34368;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__34372 = state_34362;
state_34362 = G__34372;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$site$core$delete_$_state_machine__28453__auto__ = function(state_34362){
switch(arguments.length){
case 0:
return camelot$component$site$core$delete_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$site$core$delete_$_state_machine__28453__auto____1.call(this,state_34362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$site$core$delete_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$site$core$delete_$_state_machine__28453__auto____0;
camelot$component$site$core$delete_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$site$core$delete_$_state_machine__28453__auto____1;
return camelot$component$site$core$delete_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_34370 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_34370[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_34370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
}));
} else {
return null;
}
});
camelot.component.site.core.add_success_handler = (function camelot$component$site$core$add_success_handler(data,resp){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$list,(function (p1__34373_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34373_SHARP_,camelot.util.cursorise.decursorise(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp)));
}));

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$new_DASH_site_DASH_name,null);
});
camelot.component.site.core.add_site_handler = (function camelot$component$site$core$add_site_handler(data){
camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3("/sites",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$new_DASH_site_DASH_name.cljs$core$IFn$_invoke$arity$1(data)], null)], null),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.component.site.core.add_success_handler,data));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-site","create-click");
});
camelot.component.site.core.validate_proposed_site = (function camelot$component$site$core$validate_proposed_site(data){
return cljs.core.not((function (){var or__6417__auto__ = (cljs.core.cst$kw$new_DASH_site_DASH_name.cljs$core$IFn$_invoke$arity$1(data) == null);
if(or__6417__auto__){
return or__6417__auto__;
} else {
var site = clojure.string.lower_case(clojure.string.trim(cljs.core.cst$kw$new_DASH_site_DASH_name.cljs$core$IFn$_invoke$arity$1(data)));
var or__6417__auto____$1 = cljs.core.empty_QMARK_(site);
if(or__6417__auto____$1){
return or__6417__auto____$1;
} else {
return cljs.core.some(((function (or__6417__auto____$1,site,or__6417__auto__){
return (function (p1__34374_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(site,clojure.string.lower_case(clojure.string.trim(p1__34374_SHARP_)));
});})(or__6417__auto____$1,site,or__6417__auto__))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(data)));
}
}
})());
});
camelot.component.site.core.add_site_component = (function camelot$component$site$core$add_site_component(data,owner){
if(typeof camelot.component.site.core.t_camelot$component$site$core34385 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.site.core.t_camelot$component$site$core34385 = (function (add_site_component,data,owner,meta34386){
this.add_site_component = add_site_component;
this.data = data;
this.owner = owner;
this.meta34386 = meta34386;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.site.core.t_camelot$component$site$core34385.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34387,meta34386__$1){
var self__ = this;
var _34387__$1 = this;
return (new camelot.component.site.core.t_camelot$component$site$core34385(self__.add_site_component,self__.data,self__.owner,meta34386__$1));
});

camelot.component.site.core.t_camelot$component$site$core34385.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34387){
var self__ = this;
var _34387__$1 = this;
return self__.meta34386;
});

camelot.component.site.core.t_camelot$component$site$core34385.prototype.om$core$IRender$ = true;

camelot.component.site.core.t_camelot$component$site$core34385.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var is_valid = camelot.component.site.core.validate_proposed_site(self__.data);
var G__34388 = ({"className": "field-input-form", "onSubmit": ((function (is_valid,___$1){
return (function (p1__34375_SHARP_){
return p1__34375_SHARP_.preventDefault();
});})(is_valid,___$1))
});
var G__34389 = om.util.force_children((function (){var G__34391 = ({"className": "field-input", "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_new_DASH_site_DASH_name), "value": cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_site_DASH_name], null)), "onChange": ((function (G__34388,is_valid,___$1){
return (function (p1__34376_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$new_DASH_site_DASH_name,p1__34376_SHARP_.target.value);
});})(G__34388,is_valid,___$1))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__34391) : om.dom.input.call(null,G__34391));
})());
var G__34390 = om.util.force_children((function (){var G__34392 = ({"type": "submit", "disabled": (cljs.core.truth_(is_valid)?"":"disabled"), "title": (cljs.core.truth_(is_valid)?null:camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_validation_DASH_duplicate_DASH_site)), "className": "btn btn-primary input-field-submit", "onClick": ((function (G__34388,G__34389,is_valid,___$1){
return (function (){
return camelot.component.site.core.add_site_handler(self__.data);
});})(G__34388,G__34389,is_valid,___$1))
, "value": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_add)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__34392) : om.dom.input.call(null,G__34392));
})());
return React.DOM.form(G__34388,G__34389,G__34390);
});

camelot.component.site.core.t_camelot$component$site$core34385.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$add_DASH_site_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta34386], null);
});

camelot.component.site.core.t_camelot$component$site$core34385.cljs$lang$type = true;

camelot.component.site.core.t_camelot$component$site$core34385.cljs$lang$ctorStr = "camelot.component.site.core/t_camelot$component$site$core34385";

camelot.component.site.core.t_camelot$component$site$core34385.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.site.core/t_camelot$component$site$core34385");
});

camelot.component.site.core.__GT_t_camelot$component$site$core34385 = (function camelot$component$site$core$add_site_component_$___GT_t_camelot$component$site$core34385(add_site_component__$1,data__$1,owner__$1,meta34386){
return (new camelot.component.site.core.t_camelot$component$site$core34385(add_site_component__$1,data__$1,owner__$1,meta34386));
});

}

return (new camelot.component.site.core.t_camelot$component$site$core34385(camelot$component$site$core$add_site_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.site.core.site_list_component = (function camelot$component$site$core$site_list_component(data,owner){
if(typeof camelot.component.site.core.t_camelot$component$site$core34426 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.site.core.t_camelot$component$site$core34426 = (function (site_list_component,data,owner,meta34427){
this.site_list_component = site_list_component;
this.data = data;
this.owner = owner;
this.meta34427 = meta34427;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.site.core.t_camelot$component$site$core34426.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34428,meta34427__$1){
var self__ = this;
var _34428__$1 = this;
return (new camelot.component.site.core.t_camelot$component$site$core34426(self__.site_list_component,self__.data,self__.owner,meta34427__$1));
});

camelot.component.site.core.t_camelot$component$site$core34426.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34428){
var self__ = this;
var _34428__$1 = this;
return self__.meta34427;
});

camelot.component.site.core.t_camelot$component$site$core34426.prototype.om$core$IRenderState$ = true;

camelot.component.site.core.t_camelot$component$site$core34426.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__34429 = ({"className": "menu-item detailed dynamic", "onClick": ((function (___$1){
return (function (){
return camelot.nav.nav_BANG_([cljs.core.str("/site/"),cljs.core.str(cljs.core.cst$kw$site_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data))].join(''));
});})(___$1))
});
var G__34430 = om.util.force_children((function (){var G__34435 = ({"className": "pull-right fa fa-times remove top-corner", "onClick": cljs.core.partial.cljs$core$IFn$_invoke$arity$3(camelot.component.site.core.delete$,state,self__.data)});
return React.DOM.div(G__34435);
})());
var G__34431 = om.util.force_children((function (){var G__34436 = ({"className": "status pull-right"});
var G__34437 = om.util.force_children(cljs.core.cst$kw$site_DASH_city.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__34436,G__34437);
})());
var G__34432 = om.util.force_children((function (){var G__34438 = ({"className": "menu-item-title"});
var G__34439 = om.util.force_children(cljs.core.cst$kw$site_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__34438,G__34439);
})());
var G__34433 = om.util.force_children((function (){var G__34440 = ({"className": "menu-item-description"});
var G__34441 = om.util.force_children(((cljs.core.empty_QMARK_(cljs.core.cst$kw$site_DASH_sublocation.cljs$core$IFn$_invoke$arity$1(self__.data)))?null:(function (){var G__34443 = null;
var G__34444 = om.util.force_children((function (){var G__34447 = null;
var G__34448 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$site_SLASH_site_DASH_sublocation$label));
var G__34449 = om.util.force_children(":");
return React.DOM.label(G__34447,G__34448,G__34449);
})());
var G__34445 = om.util.force_children(" ");
var G__34446 = om.util.force_children(cljs.core.cst$kw$site_DASH_sublocation.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.div(G__34443,G__34444,G__34445,G__34446);
})()));
var G__34442 = om.util.force_children(((cljs.core.empty_QMARK_(cljs.core.cst$kw$site_DASH_state_DASH_province.cljs$core$IFn$_invoke$arity$1(self__.data)))?null:(function (){var G__34450 = null;
var G__34451 = om.util.force_children((function (){var G__34454 = null;
var G__34455 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$site_SLASH_site_DASH_state_DASH_province$label));
var G__34456 = om.util.force_children(":");
return React.DOM.label(G__34454,G__34455,G__34456);
})());
var G__34452 = om.util.force_children(" ");
var G__34453 = om.util.force_children(cljs.core.cst$kw$site_DASH_state_DASH_province.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.div(G__34450,G__34451,G__34452,G__34453);
})()));
return React.DOM.span(G__34440,G__34441,G__34442);
})());
var G__34434 = om.util.force_children((function (){var G__34457 = ({"className": "menu-item-description"});
var G__34458 = om.util.force_children(cljs.core.cst$kw$site_DASH_notes.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.div(G__34457,G__34458);
})());
return React.DOM.div(G__34429,G__34430,G__34431,G__34432,G__34433,G__34434);
});

camelot.component.site.core.t_camelot$component$site$core34426.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$site_DASH_list_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta34427], null);
});

camelot.component.site.core.t_camelot$component$site$core34426.cljs$lang$type = true;

camelot.component.site.core.t_camelot$component$site$core34426.cljs$lang$ctorStr = "camelot.component.site.core/t_camelot$component$site$core34426";

camelot.component.site.core.t_camelot$component$site$core34426.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.site.core/t_camelot$component$site$core34426");
});

camelot.component.site.core.__GT_t_camelot$component$site$core34426 = (function camelot$component$site$core$site_list_component_$___GT_t_camelot$component$site$core34426(site_list_component__$1,data__$1,owner__$1,meta34427){
return (new camelot.component.site.core.t_camelot$component$site$core34426(site_list_component__$1,data__$1,owner__$1,meta34427));
});

}

return (new camelot.component.site.core.t_camelot$component$site$core34426(camelot$component$site$core$site_list_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.site.core.manage_view = (function camelot$component$site$core$manage_view(data,owner,p__34460){
var map__34469 = p__34460;
var map__34469__$1 = ((((!((map__34469 == null)))?((((map__34469.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34469.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34469):map__34469);
var site_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34469__$1,cljs.core.cst$kw$site_DASH_id);
if(typeof camelot.component.site.core.t_camelot$component$site$core34471 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.site.core.t_camelot$component$site$core34471 = (function (manage_view,data,owner,p__34460,map__34469,site_id,meta34472){
this.manage_view = manage_view;
this.data = data;
this.owner = owner;
this.p__34460 = p__34460;
this.map__34469 = map__34469;
this.site_id = site_id;
this.meta34472 = meta34472;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.site.core.t_camelot$component$site$core34471.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__34469,map__34469__$1,site_id){
return (function (_34473,meta34472__$1){
var self__ = this;
var _34473__$1 = this;
return (new camelot.component.site.core.t_camelot$component$site$core34471(self__.manage_view,self__.data,self__.owner,self__.p__34460,self__.map__34469,self__.site_id,meta34472__$1));
});})(map__34469,map__34469__$1,site_id))
;

camelot.component.site.core.t_camelot$component$site$core34471.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__34469,map__34469__$1,site_id){
return (function (_34473){
var self__ = this;
var _34473__$1 = this;
return self__.meta34472;
});})(map__34469,map__34469__$1,site_id))
;

camelot.component.site.core.t_camelot$component$site$core34471.prototype.om$core$IWillMount$ = true;

camelot.component.site.core.t_camelot$component$site$core34471.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__34469,map__34469__$1,site_id){
return (function (_){
var self__ = this;
var ___$1 = this;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$data,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str("/sites/"),cljs.core.str(self__.site_id)].join(''),((function (___$1,map__34469,map__34469__$1,site_id){
return (function (p1__34459_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$data,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__34459_SHARP_));

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2("/sites/",((function (___$1,map__34469,map__34469__$1,site_id){
return (function (x){
var others = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (___$1,map__34469,map__34469__$1,site_id){
return (function (v){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__34459_SHARP_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$value], null)),cljs.core.cst$kw$site_DASH_name.cljs$core$IFn$_invoke$arity$1(v));
});})(___$1,map__34469,map__34469__$1,site_id))
,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(x));
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,others);
});})(___$1,map__34469,map__34469__$1,site_id))
);
});})(___$1,map__34469,map__34469__$1,site_id))
);
});})(map__34469,map__34469__$1,site_id))
;

camelot.component.site.core.t_camelot$component$site$core34471.prototype.om$core$IRender$ = true;

camelot.component.site.core.t_camelot$component$site$core34471.prototype.om$core$IRender$render$arity$1 = ((function (map__34469,map__34469__$1,site_id){
return (function (_){
var self__ = this;
var ___$1 = this;
if((cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data) == null)){
var G__34474 = ({"className": "align-center"});
var G__34475 = om.util.force_children((function (){var G__34476 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__34476);
})());
return React.DOM.div(G__34474,G__34475);
} else {
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.site.manage.manage_component,self__.data);
}
});})(map__34469,map__34469__$1,site_id))
;

camelot.component.site.core.t_camelot$component$site$core34471.getBasis = ((function (map__34469,map__34469__$1,site_id){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$manage_DASH_view,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$site_DASH_id], null)], null)], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__34460,cljs.core.cst$sym$map__34469,cljs.core.cst$sym$site_DASH_id,cljs.core.cst$sym$meta34472], null);
});})(map__34469,map__34469__$1,site_id))
;

camelot.component.site.core.t_camelot$component$site$core34471.cljs$lang$type = true;

camelot.component.site.core.t_camelot$component$site$core34471.cljs$lang$ctorStr = "camelot.component.site.core/t_camelot$component$site$core34471";

camelot.component.site.core.t_camelot$component$site$core34471.cljs$lang$ctorPrWriter = ((function (map__34469,map__34469__$1,site_id){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.site.core/t_camelot$component$site$core34471");
});})(map__34469,map__34469__$1,site_id))
;

camelot.component.site.core.__GT_t_camelot$component$site$core34471 = ((function (map__34469,map__34469__$1,site_id){
return (function camelot$component$site$core$manage_view_$___GT_t_camelot$component$site$core34471(manage_view__$1,data__$1,owner__$1,p__34460__$1,map__34469__$2,site_id__$1,meta34472){
return (new camelot.component.site.core.t_camelot$component$site$core34471(manage_view__$1,data__$1,owner__$1,p__34460__$1,map__34469__$2,site_id__$1,meta34472));
});})(map__34469,map__34469__$1,site_id))
;

}

return (new camelot.component.site.core.t_camelot$component$site$core34471(camelot$component$site$core$manage_view,data,owner,p__34460,map__34469__$1,site_id,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.site.core.site_menu_component = (function camelot$component$site$core$site_menu_component(data,owner){
if(typeof camelot.component.site.core.t_camelot$component$site$core34533 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.site.core.t_camelot$component$site$core34533 = (function (site_menu_component,data,owner,meta34534){
this.site_menu_component = site_menu_component;
this.data = data;
this.owner = owner;
this.meta34534 = meta34534;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.site.core.t_camelot$component$site$core34533.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34535,meta34534__$1){
var self__ = this;
var _34535__$1 = this;
return (new camelot.component.site.core.t_camelot$component$site$core34533(self__.site_menu_component,self__.data,self__.owner,meta34534__$1));
});

camelot.component.site.core.t_camelot$component$site$core34533.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34535){
var self__ = this;
var _34535__$1 = this;
return self__.meta34534;
});

camelot.component.site.core.t_camelot$component$site$core34533.prototype.om$core$IInitState$ = true;

camelot.component.site.core.t_camelot$component$site$core34533.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.site.core.t_camelot$component$site$core34533.prototype.om$core$IWillMount$ = true;

camelot.component.site.core.t_camelot$component$site$core34533.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);
});

camelot.component.site.core.t_camelot$component$site$core34533.prototype.om$core$IDidMount$ = true;

camelot.component.site.core.t_camelot$component$site$core34533.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
camelot.rest.get_resource("/sites",((function (___$1){
return (function (p1__34477_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__34477_SHARP_));
});})(___$1))
);

var ch = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$chan);
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,ch,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,ch,___$1){
return (function (state_34551){
var state_val_34552 = (state_34551[(1)]);
if((state_val_34552 === (1))){
var state_34551__$1 = state_34551;
var statearr_34553_34585 = state_34551__$1;
(statearr_34553_34585[(2)] = null);

(statearr_34553_34585[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34552 === (2))){
var state_34551__$1 = state_34551;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34551__$1,(4),ch);
} else {
if((state_val_34552 === (3))){
var inst_34549 = (state_34551[(2)]);
var state_34551__$1 = state_34551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34551__$1,inst_34549);
} else {
if((state_val_34552 === (4))){
var inst_34538 = (state_34551[(7)]);
var inst_34538__$1 = (state_34551[(2)]);
var inst_34539 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(inst_34538__$1);
var inst_34540 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34539,cljs.core.cst$kw$delete);
var state_34551__$1 = (function (){var statearr_34554 = state_34551;
(statearr_34554[(7)] = inst_34538__$1);

return statearr_34554;
})();
if(inst_34540){
var statearr_34555_34586 = state_34551__$1;
(statearr_34555_34586[(1)] = (5));

} else {
var statearr_34556_34587 = state_34551__$1;
(statearr_34556_34587[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34552 === (5))){
var inst_34538 = (state_34551[(7)]);
var inst_34542 = (function (){var r = inst_34538;
return ((function (r,inst_34538,state_val_34552,c__28576__auto__,ch,___$1){
return (function (p1__34478_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (r,inst_34538,state_val_34552,c__28576__auto__,ch,___$1){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(r));
});})(r,inst_34538,state_val_34552,c__28576__auto__,ch,___$1))
,p1__34478_SHARP_);
});
;})(r,inst_34538,state_val_34552,c__28576__auto__,ch,___$1))
})();
var inst_34543 = om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,inst_34542);
var state_34551__$1 = state_34551;
var statearr_34557_34588 = state_34551__$1;
(statearr_34557_34588[(2)] = inst_34543);

(statearr_34557_34588[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34552 === (6))){
var state_34551__$1 = state_34551;
var statearr_34558_34589 = state_34551__$1;
(statearr_34558_34589[(2)] = null);

(statearr_34558_34589[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34552 === (7))){
var inst_34546 = (state_34551[(2)]);
var state_34551__$1 = (function (){var statearr_34559 = state_34551;
(statearr_34559[(8)] = inst_34546);

return statearr_34559;
})();
var statearr_34560_34590 = state_34551__$1;
(statearr_34560_34590[(2)] = null);

(statearr_34560_34590[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__28576__auto__,ch,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto__,ch,___$1){
return (function() {
var camelot$component$site$core$site_menu_component_$_state_machine__28453__auto__ = null;
var camelot$component$site$core$site_menu_component_$_state_machine__28453__auto____0 = (function (){
var statearr_34564 = [null,null,null,null,null,null,null,null,null];
(statearr_34564[(0)] = camelot$component$site$core$site_menu_component_$_state_machine__28453__auto__);

(statearr_34564[(1)] = (1));

return statearr_34564;
});
var camelot$component$site$core$site_menu_component_$_state_machine__28453__auto____1 = (function (state_34551){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_34551);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e34565){if((e34565 instanceof Object)){
var ex__28456__auto__ = e34565;
var statearr_34566_34591 = state_34551;
(statearr_34566_34591[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34551);

return cljs.core.cst$kw$recur;
} else {
throw e34565;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__34592 = state_34551;
state_34551 = G__34592;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$site$core$site_menu_component_$_state_machine__28453__auto__ = function(state_34551){
switch(arguments.length){
case 0:
return camelot$component$site$core$site_menu_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$site$core$site_menu_component_$_state_machine__28453__auto____1.call(this,state_34551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$site$core$site_menu_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$site$core$site_menu_component_$_state_machine__28453__auto____0;
camelot$component$site$core$site_menu_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$site$core$site_menu_component_$_state_machine__28453__auto____1;
return camelot$component$site$core$site_menu_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,ch,___$1))
})();
var state__28578__auto__ = (function (){var statearr_34567 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_34567[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_34567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,ch,___$1))
);

return c__28576__auto__;
});

camelot.component.site.core.t_camelot$component$site$core34533.prototype.om$core$IWillUnmount$ = true;

camelot.component.site.core.t_camelot$component$site$core34533.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);
});

camelot.component.site.core.t_camelot$component$site$core34533.prototype.om$core$IRenderState$ = true;

camelot.component.site.core.t_camelot$component$site$core34533.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__34568 = ({"className": "section"});
var G__34569 = om.util.force_children((function (){var G__34574 = null;
var G__34575 = om.util.force_children((function (){var G__34576 = ({"className": "field-input", "value": cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data), "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_filter_DASH_sites), "onChange": ((function (G__34574,G__34568,___$1){
return (function (p1__34479_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$filter,p1__34479_SHARP_.target.value);
});})(G__34574,G__34568,___$1))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__34576) : om.dom.input.call(null,G__34576));
})());
return React.DOM.div(G__34574,G__34575);
})());
var G__34570 = om.util.force_children((function (){var G__34577 = ({"className": "simple-menu scroll"});
var G__34578 = om.util.force_children((function (){var filtered = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__34577,G__34568,G__34569,___$1){
return (function (p1__34480_SHARP_){
if(((cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data) == null)) || (cljs.core.empty_QMARK_(cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data)))){
return true;
} else {
return cljs.core.re_matches(cljs.core.re_pattern([cljs.core.str("(?i).*"),cljs.core.str(cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data)),cljs.core.str(".*")].join('')),[cljs.core.str(cljs.core.cst$kw$site_DASH_name.cljs$core$IFn$_invoke$arity$1(p1__34480_SHARP_)),cljs.core.str(" "),cljs.core.str(cljs.core.cst$kw$site_DASH_city.cljs$core$IFn$_invoke$arity$1(p1__34480_SHARP_)),cljs.core.str(" "),cljs.core.str(cljs.core.cst$kw$site_DASH_sublocation.cljs$core$IFn$_invoke$arity$1(p1__34480_SHARP_)),cljs.core.str(" "),cljs.core.str(cljs.core.cst$kw$site_DASH_state_DASH_province.cljs$core$IFn$_invoke$arity$1(p1__34480_SHARP_)),cljs.core.str(" "),cljs.core.str(cljs.core.cst$kw$site_DASH_country.cljs$core$IFn$_invoke$arity$1(p1__34480_SHARP_)),cljs.core.str(" "),cljs.core.str(cljs.core.cst$kw$site_DASH_notes.cljs$core$IFn$_invoke$arity$1(p1__34480_SHARP_))].join(''));
}
});})(G__34577,G__34568,G__34569,___$1))
,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data)));
if(cljs.core.empty_QMARK_(filtered)){
return om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.blank_slate_component,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$item_DASH_name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_item_DASH_name),cljs.core.cst$kw$advice,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_advice)], null)], null));
} else {
return om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.site.core.site_list_component,filtered,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$site_DASH_id,cljs.core.cst$kw$init_DASH_state,state], null));
}
})());
return React.DOM.div(G__34577,G__34578);
})());
var G__34571 = om.util.force_children((function (){var G__34579 = ({"className": "sep"});
return React.DOM.div(G__34579);
})());
var G__34572 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.site.core.add_site_component,self__.data));
var G__34573 = om.util.force_children((function (){var G__34580 = ({"className": "btn btn-default", "onClick": ((function (G__34568,G__34569,G__34570,G__34571,G__34572,___$1){
return (function (){
camelot.nav.nav_BANG_("/sites");

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-site","advanced-click");
});})(G__34568,G__34569,G__34570,G__34571,G__34572,___$1))
});
var G__34581 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_advanced));
return React.DOM.button(G__34580,G__34581);
})());
return React.DOM.div(G__34568,G__34569,G__34570,G__34571,G__34572,G__34573);
} else {
var G__34582 = ({"className": "align-center"});
var G__34583 = om.util.force_children((function (){var G__34584 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__34584);
})());
return React.DOM.div(G__34582,G__34583);
}
});

camelot.component.site.core.t_camelot$component$site$core34533.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$site_DASH_menu_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta34534], null);
});

camelot.component.site.core.t_camelot$component$site$core34533.cljs$lang$type = true;

camelot.component.site.core.t_camelot$component$site$core34533.cljs$lang$ctorStr = "camelot.component.site.core/t_camelot$component$site$core34533";

camelot.component.site.core.t_camelot$component$site$core34533.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.site.core/t_camelot$component$site$core34533");
});

camelot.component.site.core.__GT_t_camelot$component$site$core34533 = (function camelot$component$site$core$site_menu_component_$___GT_t_camelot$component$site$core34533(site_menu_component__$1,data__$1,owner__$1,meta34534){
return (new camelot.component.site.core.t_camelot$component$site$core34533(site_menu_component__$1,data__$1,owner__$1,meta34534));
});

}

return (new camelot.component.site.core.t_camelot$component$site$core34533(camelot$component$site$core$site_menu_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
