// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.species_search');
goog.require('cljs.core');
goog.require('camelot.rest');
goog.require('camelot.nav');
goog.require('om.dom');
goog.require('goog.string');
goog.require('camelot.state');
goog.require('cljs.core.async');
goog.require('camelot.translation.core');
goog.require('om.core');
goog.require('clojure.string');
camelot.component.species_search.db_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["Systema Dipterorum",null,"ITIS Global: The Integrated Taxonomic Information System",null,"ITIS Regional: The Integrated Taxonomic Information System",null,"FishBase",null,"WSC: World Spider Catalog",null], null), null);
camelot.component.species_search.get_classification = (function camelot$component$species_search$get_classification(rank,classifications){
var G__35388 = (function (){var or__6417__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__35386_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35386_SHARP_,"rank"),rank);
}),classifications)),"name");
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return "";
}
})();
return goog.string.unescapeEntities(G__35388);
});
camelot.component.species_search.process_result = (function camelot$component$species_search$process_result(res){
var vec__35393 = clojure.string.split.cljs$core$IFn$_invoke$arity$2((function (){var G__35396 = (function (){var or__6417__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,"name");
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return "";
}
})();
return goog.string.unescapeEntities(G__35396);
})(),/ /);
var genus = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35393,(0),null);
var species = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35393,(1),null);
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,"id"),cljs.core.cst$kw$citation,cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,goog.string.unescapeEntities("bibliographic_citation")),cljs.core.cst$kw$species,species,cljs.core.cst$kw$genus,genus], null);
});
camelot.component.species_search.process_all_results = (function camelot$component$species_search$process_all_results(raw){
return cljs.core.vec(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.sorted_set_by,(function (p1__35397_SHARP_,p2__35398_SHARP_){
var g = cljs.core.compare(cljs.core.cst$kw$genus.cljs$core$IFn$_invoke$arity$1(p1__35397_SHARP_),cljs.core.cst$kw$genus.cljs$core$IFn$_invoke$arity$1(p2__35398_SHARP_));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(g,(0))){
return cljs.core.compare(cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(p1__35397_SHARP_),cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(p2__35398_SHARP_));
} else {
return g;
}
}),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__35399_SHARP_){
var and__6405__auto__ = cljs.core.cst$kw$genus.cljs$core$IFn$_invoke$arity$1(p1__35399_SHARP_);
if(cljs.core.truth_(and__6405__auto__)){
return cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(p1__35399_SHARP_);
} else {
return and__6405__auto__;
}
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2(camelot.component.species_search.process_result,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__35400_SHARP_){
return (cljs.core.contains_QMARK_(camelot.component.species_search.db_whitelist,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35400_SHARP_,"source_database"))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35400_SHARP_,"name_status"),"accepted name"));
}),cljs.core.get.cljs$core$IFn$_invoke$arity$2(raw,"results"))))));
});
camelot.component.species_search.lookup_species = (function camelot$component$species_search$lookup_species(chan,e){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_35465){
var state_val_35466 = (state_35465[(1)]);
if((state_val_35466 === (1))){
var inst_35447 = [cljs.core.cst$kw$busy];
var inst_35448 = [true];
var inst_35449 = cljs.core.PersistentHashMap.fromArrays(inst_35447,inst_35448);
var state_35465__$1 = state_35465;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35465__$1,(2),chan,inst_35449);
} else {
if((state_val_35466 === (2))){
var inst_35451 = (state_35465[(2)]);
var inst_35452 = [cljs.core.cst$kw$query_DASH_params];
var inst_35453 = ["search"];
var inst_35454 = e.target;
var inst_35455 = cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(inst_35454);
var inst_35456 = cljs.core.first(inst_35455);
var inst_35457 = inst_35456.value;
var inst_35458 = [inst_35457];
var inst_35459 = cljs.core.PersistentHashMap.fromArrays(inst_35453,inst_35458);
var inst_35460 = [inst_35459];
var inst_35461 = cljs.core.PersistentHashMap.fromArrays(inst_35452,inst_35460);
var inst_35462 = (function (){return ((function (inst_35451,inst_35452,inst_35453,inst_35454,inst_35455,inst_35456,inst_35457,inst_35458,inst_35459,inst_35460,inst_35461,state_val_35466,c__28576__auto__){
return (function (p1__35401_SHARP_){
var c__28576__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto____$1,inst_35451,inst_35452,inst_35453,inst_35454,inst_35455,inst_35456,inst_35457,inst_35458,inst_35459,inst_35460,inst_35461,state_val_35466,c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto____$1,inst_35451,inst_35452,inst_35453,inst_35454,inst_35455,inst_35456,inst_35457,inst_35458,inst_35459,inst_35460,inst_35461,state_val_35466,c__28576__auto__){
return (function (state_35475){
var state_val_35476 = (state_35475[(1)]);
if((state_val_35476 === (1))){
var inst_35467 = [cljs.core.cst$kw$busy,cljs.core.cst$kw$results];
var inst_35468 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__35401_SHARP_);
var inst_35469 = camelot.component.species_search.process_all_results(inst_35468);
var inst_35470 = [false,inst_35469];
var inst_35471 = cljs.core.PersistentHashMap.fromArrays(inst_35467,inst_35470);
var state_35475__$1 = state_35475;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35475__$1,(2),chan,inst_35471);
} else {
if((state_val_35476 === (2))){
var inst_35473 = (state_35475[(2)]);
var state_35475__$1 = state_35475;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35475__$1,inst_35473);
} else {
return null;
}
}
});})(c__28576__auto____$1,inst_35451,inst_35452,inst_35453,inst_35454,inst_35455,inst_35456,inst_35457,inst_35458,inst_35459,inst_35460,inst_35461,state_val_35466,c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto____$1,inst_35451,inst_35452,inst_35453,inst_35454,inst_35455,inst_35456,inst_35457,inst_35458,inst_35459,inst_35460,inst_35461,state_val_35466,c__28576__auto__){
return (function() {
var camelot$component$species_search$lookup_species_$_state_machine__28453__auto__ = null;
var camelot$component$species_search$lookup_species_$_state_machine__28453__auto____0 = (function (){
var statearr_35480 = [null,null,null,null,null,null,null];
(statearr_35480[(0)] = camelot$component$species_search$lookup_species_$_state_machine__28453__auto__);

(statearr_35480[(1)] = (1));

return statearr_35480;
});
var camelot$component$species_search$lookup_species_$_state_machine__28453__auto____1 = (function (state_35475){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_35475);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e35481){if((e35481 instanceof Object)){
var ex__28456__auto__ = e35481;
var statearr_35482_35492 = state_35475;
(statearr_35482_35492[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35475);

return cljs.core.cst$kw$recur;
} else {
throw e35481;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__35493 = state_35475;
state_35475 = G__35493;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$species_search$lookup_species_$_state_machine__28453__auto__ = function(state_35475){
switch(arguments.length){
case 0:
return camelot$component$species_search$lookup_species_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$species_search$lookup_species_$_state_machine__28453__auto____1.call(this,state_35475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$species_search$lookup_species_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$species_search$lookup_species_$_state_machine__28453__auto____0;
camelot$component$species_search$lookup_species_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$species_search$lookup_species_$_state_machine__28453__auto____1;
return camelot$component$species_search$lookup_species_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto____$1,inst_35451,inst_35452,inst_35453,inst_35454,inst_35455,inst_35456,inst_35457,inst_35458,inst_35459,inst_35460,inst_35461,state_val_35466,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_35483 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_35483[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto____$1);

return statearr_35483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto____$1,inst_35451,inst_35452,inst_35453,inst_35454,inst_35455,inst_35456,inst_35457,inst_35458,inst_35459,inst_35460,inst_35461,state_val_35466,c__28576__auto__))
);

return c__28576__auto____$1;
});
;})(inst_35451,inst_35452,inst_35453,inst_35454,inst_35455,inst_35456,inst_35457,inst_35458,inst_35459,inst_35460,inst_35461,state_val_35466,c__28576__auto__))
})();
var inst_35463 = camelot.rest.get_x_raw("/species/search",inst_35461,inst_35462);
var state_35465__$1 = (function (){var statearr_35484 = state_35465;
(statearr_35484[(7)] = inst_35451);

return statearr_35484;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35465__$1,inst_35463);
} else {
return null;
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$component$species_search$lookup_species_$_state_machine__28453__auto__ = null;
var camelot$component$species_search$lookup_species_$_state_machine__28453__auto____0 = (function (){
var statearr_35488 = [null,null,null,null,null,null,null,null];
(statearr_35488[(0)] = camelot$component$species_search$lookup_species_$_state_machine__28453__auto__);

(statearr_35488[(1)] = (1));

return statearr_35488;
});
var camelot$component$species_search$lookup_species_$_state_machine__28453__auto____1 = (function (state_35465){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_35465);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e35489){if((e35489 instanceof Object)){
var ex__28456__auto__ = e35489;
var statearr_35490_35494 = state_35465;
(statearr_35490_35494[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35465);

return cljs.core.cst$kw$recur;
} else {
throw e35489;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__35495 = state_35465;
state_35465 = G__35495;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$species_search$lookup_species_$_state_machine__28453__auto__ = function(state_35465){
switch(arguments.length){
case 0:
return camelot$component$species_search$lookup_species_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$species_search$lookup_species_$_state_machine__28453__auto____1.call(this,state_35465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$species_search$lookup_species_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$species_search$lookup_species_$_state_machine__28453__auto____0;
camelot$component$species_search$lookup_species_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$species_search$lookup_species_$_state_machine__28453__auto____1;
return camelot$component$species_search$lookup_species_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_35491 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_35491[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_35491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});
camelot.component.species_search.search_input_component = (function camelot$component$species_search$search_input_component(data,owner){
if(typeof camelot.component.species_search.t_camelot$component$species_search35506 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.species_search.t_camelot$component$species_search35506 = (function (search_input_component,data,owner,meta35507){
this.search_input_component = search_input_component;
this.data = data;
this.owner = owner;
this.meta35507 = meta35507;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.species_search.t_camelot$component$species_search35506.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35508,meta35507__$1){
var self__ = this;
var _35508__$1 = this;
return (new camelot.component.species_search.t_camelot$component$species_search35506(self__.search_input_component,self__.data,self__.owner,meta35507__$1));
});

camelot.component.species_search.t_camelot$component$species_search35506.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35508){
var self__ = this;
var _35508__$1 = this;
return self__.meta35507;
});

camelot.component.species_search.t_camelot$component$species_search35506.prototype.om$core$IInitState$ = true;

camelot.component.species_search.t_camelot$component$species_search35506.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$search,""], null);
});

camelot.component.species_search.t_camelot$component$species_search35506.prototype.om$core$IRenderState$ = true;

camelot.component.species_search.t_camelot$component$species_search35506.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__35509 = ({"onSubmit": ((function (___$1){
return (function (p1__35496_SHARP_){
p1__35496_SHARP_.preventDefault();

if(cljs.core.truth_(cljs.core.cst$kw$busy.cljs$core$IFn$_invoke$arity$1(self__.data))){
return null;
} else {
return camelot.component.species_search.lookup_species(cljs.core.cst$kw$result_DASH_chan.cljs$core$IFn$_invoke$arity$1(state),p1__35496_SHARP_);
}
});})(___$1))
, "className": "field-input-form"});
var G__35510 = om.util.force_children((function (){var G__35512 = ({"type": "text", "name": "search", "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$species_DASH_search_SLASH_scientific_DASH_name), "className": "field-input inline long-input", "onChange": ((function (G__35509,___$1){
return (function (p1__35497_SHARP_){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$search,p1__35497_SHARP_.target.value);
});})(G__35509,___$1))
, "value": cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(state)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__35512) : om.dom.input.call(null,G__35512));
})());
var G__35511 = om.util.force_children((function (){var G__35513 = ({"type": "submit", "name": "submit", "disabled": ((((cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(state) == null)) || ((cljs.core.count(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(state).trim()) < (5))))?"disabled":""), "className": "btn btn-default input-field-submit", "value": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_search)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__35513) : om.dom.input.call(null,G__35513));
})());
return React.DOM.form(G__35509,G__35510,G__35511);
});

camelot.component.species_search.t_camelot$component$species_search35506.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$search_DASH_input_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta35507], null);
});

camelot.component.species_search.t_camelot$component$species_search35506.cljs$lang$type = true;

camelot.component.species_search.t_camelot$component$species_search35506.cljs$lang$ctorStr = "camelot.component.species-search/t_camelot$component$species_search35506";

camelot.component.species_search.t_camelot$component$species_search35506.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.species-search/t_camelot$component$species_search35506");
});

camelot.component.species_search.__GT_t_camelot$component$species_search35506 = (function camelot$component$species_search$search_input_component_$___GT_t_camelot$component$species_search35506(search_input_component__$1,data__$1,owner__$1,meta35507){
return (new camelot.component.species_search.t_camelot$component$species_search35506(search_input_component__$1,data__$1,owner__$1,meta35507));
});

}

return (new camelot.component.species_search.t_camelot$component$species_search35506(camelot$component$species_search$search_input_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.species_search.truncate = (function camelot$component$species_search$truncate(s,nc){
if((cljs.core.count(s) > nc)){
return [cljs.core.str(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),nc)),cljs.core.str("...")].join('');
} else {
return s;
}
});
camelot.component.species_search.search_result_component = (function camelot$component$species_search$search_result_component(data,owner){
if(typeof camelot.component.species_search.t_camelot$component$species_search35568 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.species_search.t_camelot$component$species_search35568 = (function (search_result_component,data,owner,meta35569){
this.search_result_component = search_result_component;
this.data = data;
this.owner = owner;
this.meta35569 = meta35569;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.species_search.t_camelot$component$species_search35568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35570,meta35569__$1){
var self__ = this;
var _35570__$1 = this;
return (new camelot.component.species_search.t_camelot$component$species_search35568(self__.search_result_component,self__.data,self__.owner,meta35569__$1));
});

camelot.component.species_search.t_camelot$component$species_search35568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35570){
var self__ = this;
var _35570__$1 = this;
return self__.meta35569;
});

camelot.component.species_search.t_camelot$component$species_search35568.prototype.om$core$IRenderState$ = true;

camelot.component.species_search.t_camelot$component$species_search35568.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__35571 = ({"onClick": ((function (___$1){
return (function (){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,___$1){
return (function (state_35582){
var state_val_35583 = (state_35582[(1)]);
if((state_val_35583 === (1))){
var inst_35575 = cljs.core.cst$kw$select_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_35576 = [cljs.core.cst$kw$type,cljs.core.cst$kw$data];
var inst_35577 = [cljs.core.cst$kw$selection,self__.data];
var inst_35578 = cljs.core.PersistentHashMap.fromArrays(inst_35576,inst_35577);
var state_35582__$1 = state_35582;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35582__$1,(2),inst_35575,inst_35578);
} else {
if((state_val_35583 === (2))){
var inst_35580 = (state_35582[(2)]);
var state_35582__$1 = state_35582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35582__$1,inst_35580);
} else {
return null;
}
}
});})(c__28576__auto__,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto__,___$1){
return (function() {
var camelot$component$species_search$search_result_component_$_state_machine__28453__auto__ = null;
var camelot$component$species_search$search_result_component_$_state_machine__28453__auto____0 = (function (){
var statearr_35587 = [null,null,null,null,null,null,null];
(statearr_35587[(0)] = camelot$component$species_search$search_result_component_$_state_machine__28453__auto__);

(statearr_35587[(1)] = (1));

return statearr_35587;
});
var camelot$component$species_search$search_result_component_$_state_machine__28453__auto____1 = (function (state_35582){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_35582);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e35588){if((e35588 instanceof Object)){
var ex__28456__auto__ = e35588;
var statearr_35589_35621 = state_35582;
(statearr_35589_35621[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35582);

return cljs.core.cst$kw$recur;
} else {
throw e35588;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__35622 = state_35582;
state_35582 = G__35622;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$species_search$search_result_component_$_state_machine__28453__auto__ = function(state_35582){
switch(arguments.length){
case 0:
return camelot$component$species_search$search_result_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$species_search$search_result_component_$_state_machine__28453__auto____1.call(this,state_35582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$species_search$search_result_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$species_search$search_result_component_$_state_machine__28453__auto____0;
camelot$component$species_search$search_result_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$species_search$search_result_component_$_state_machine__28453__auto____1;
return camelot$component$species_search$search_result_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,___$1))
})();
var state__28578__auto__ = (function (){var statearr_35590 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_35590[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_35590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,___$1))
);

return c__28576__auto__;
});})(___$1))
});
var G__35572 = om.util.force_children((function (){var G__35591 = null;
var G__35592 = om.util.force_children(cljs.core.cst$kw$genus.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.td(G__35591,G__35592);
})());
var G__35573 = om.util.force_children((function (){var G__35593 = null;
var G__35594 = om.util.force_children(cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.td(G__35593,G__35594);
})());
var G__35574 = om.util.force_children((function (){var G__35595 = ({"colSpan": "2", "className": "action-column"});
var G__35596 = om.util.force_children((function (){var G__35597 = ({"className": "button-container"});
var G__35598 = om.util.force_children((function (){var G__35600 = ({"className": "btn btn-default", "onClick": ((function (G__35597,G__35595,G__35571,G__35572,G__35573,___$1){
return (function (p1__35514_SHARP_){
p1__35514_SHARP_.preventDefault();

p1__35514_SHARP_.stopPropagation();

var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,G__35597,G__35595,G__35571,G__35572,G__35573,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,G__35597,G__35595,G__35571,G__35572,G__35573,___$1){
return (function (state_35610){
var state_val_35611 = (state_35610[(1)]);
if((state_val_35611 === (1))){
var inst_35602 = cljs.core.cst$kw$select_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_35603 = [cljs.core.cst$kw$type,cljs.core.cst$kw$data];
var inst_35604 = cljs.core.cst$kw$citation.cljs$core$IFn$_invoke$arity$1(self__.data);
var inst_35605 = [cljs.core.cst$kw$citation,inst_35604];
var inst_35606 = cljs.core.PersistentHashMap.fromArrays(inst_35603,inst_35605);
var state_35610__$1 = state_35610;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35610__$1,(2),inst_35602,inst_35606);
} else {
if((state_val_35611 === (2))){
var inst_35608 = (state_35610[(2)]);
var state_35610__$1 = state_35610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35610__$1,inst_35608);
} else {
return null;
}
}
});})(c__28576__auto__,G__35597,G__35595,G__35571,G__35572,G__35573,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto__,G__35597,G__35595,G__35571,G__35572,G__35573,___$1){
return (function() {
var camelot$component$species_search$search_result_component_$_state_machine__28453__auto__ = null;
var camelot$component$species_search$search_result_component_$_state_machine__28453__auto____0 = (function (){
var statearr_35615 = [null,null,null,null,null,null,null];
(statearr_35615[(0)] = camelot$component$species_search$search_result_component_$_state_machine__28453__auto__);

(statearr_35615[(1)] = (1));

return statearr_35615;
});
var camelot$component$species_search$search_result_component_$_state_machine__28453__auto____1 = (function (state_35610){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_35610);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e35616){if((e35616 instanceof Object)){
var ex__28456__auto__ = e35616;
var statearr_35617_35623 = state_35610;
(statearr_35617_35623[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35610);

return cljs.core.cst$kw$recur;
} else {
throw e35616;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__35624 = state_35610;
state_35610 = G__35624;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$species_search$search_result_component_$_state_machine__28453__auto__ = function(state_35610){
switch(arguments.length){
case 0:
return camelot$component$species_search$search_result_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$species_search$search_result_component_$_state_machine__28453__auto____1.call(this,state_35610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$species_search$search_result_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$species_search$search_result_component_$_state_machine__28453__auto____0;
camelot$component$species_search$search_result_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$species_search$search_result_component_$_state_machine__28453__auto____1;
return camelot$component$species_search$search_result_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,G__35597,G__35595,G__35571,G__35572,G__35573,___$1))
})();
var state__28578__auto__ = (function (){var statearr_35618 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_35618[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_35618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,G__35597,G__35595,G__35571,G__35572,G__35573,___$1))
);

return c__28576__auto__;
});})(G__35597,G__35595,G__35571,G__35572,G__35573,___$1))
});
var G__35601 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_citation));
return React.DOM.button(G__35600,G__35601);
})());
var G__35599 = om.util.force_children((function (){var G__35619 = ({"className": "btn btn-primary"});
var G__35620 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_add));
return React.DOM.button(G__35619,G__35620);
})());
return React.DOM.p(G__35597,G__35598,G__35599);
})());
return React.DOM.td(G__35595,G__35596);
})());
return React.DOM.tr(G__35571,G__35572,G__35573,G__35574);
});

camelot.component.species_search.t_camelot$component$species_search35568.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$search_DASH_result_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta35569], null);
});

camelot.component.species_search.t_camelot$component$species_search35568.cljs$lang$type = true;

camelot.component.species_search.t_camelot$component$species_search35568.cljs$lang$ctorStr = "camelot.component.species-search/t_camelot$component$species_search35568";

camelot.component.species_search.t_camelot$component$species_search35568.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.species-search/t_camelot$component$species_search35568");
});

camelot.component.species_search.__GT_t_camelot$component$species_search35568 = (function camelot$component$species_search$search_result_component_$___GT_t_camelot$component$species_search35568(search_result_component__$1,data__$1,owner__$1,meta35569){
return (new camelot.component.species_search.t_camelot$component$species_search35568(search_result_component__$1,data__$1,owner__$1,meta35569));
});

}

return (new camelot.component.species_search.t_camelot$component$species_search35568(camelot$component$species_search$search_result_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.species_search.search_result_list_component = (function camelot$component$species_search$search_result_list_component(data,owner){
if(typeof camelot.component.species_search.t_camelot$component$species_search35648 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.species_search.t_camelot$component$species_search35648 = (function (search_result_list_component,data,owner,meta35649){
this.search_result_list_component = search_result_list_component;
this.data = data;
this.owner = owner;
this.meta35649 = meta35649;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.species_search.t_camelot$component$species_search35648.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35650,meta35649__$1){
var self__ = this;
var _35650__$1 = this;
return (new camelot.component.species_search.t_camelot$component$species_search35648(self__.search_result_list_component,self__.data,self__.owner,meta35649__$1));
});

camelot.component.species_search.t_camelot$component$species_search35648.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35650){
var self__ = this;
var _35650__$1 = this;
return self__.meta35649;
});

camelot.component.species_search.t_camelot$component$species_search35648.prototype.om$core$IRenderState$ = true;

camelot.component.species_search.t_camelot$component$species_search35648.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$busy.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__35651 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__35651);
} else {
if(cljs.core.seq(cljs.core.cst$kw$search_DASH_results.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__35652 = ({"className": "scroll"});
var G__35653 = om.util.force_children((function (){var G__35654 = ({"className": "species-search-table"});
var G__35655 = om.util.force_children((function (){var G__35657 = null;
var G__35658 = om.util.force_children((function (){var G__35659 = ({"className": "table-heading"});
var G__35660 = om.util.force_children((function (){var G__35663 = null;
var G__35664 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$taxonomy_SLASH_taxonomy_DASH_genus$label));
return React.DOM.th(G__35663,G__35664);
})());
var G__35661 = om.util.force_children((function (){var G__35665 = null;
var G__35666 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$taxonomy_SLASH_taxonomy_DASH_species$label));
return React.DOM.th(G__35665,G__35666);
})());
var G__35662 = om.util.force_children((function (){var G__35667 = null;
var G__35668 = om.util.force_children("");
return React.DOM.th(G__35667,G__35668);
})());
return React.DOM.tr(G__35659,G__35660,G__35661,G__35662);
})());
return React.DOM.thead(G__35657,G__35658);
})());
var G__35656 = om.util.force_children((function (){var G__35669 = ({"className": "selectable"});
var G__35670 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.species_search.search_result_component,cljs.core.cst$kw$search_DASH_results.cljs$core$IFn$_invoke$arity$1(self__.data),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,state], null)));
return React.DOM.tbody(G__35669,G__35670);
})());
return React.DOM.table(G__35654,G__35655,G__35656);
})());
return React.DOM.div(G__35652,G__35653);
} else {
return React.DOM.span(null);
}
}
});

camelot.component.species_search.t_camelot$component$species_search35648.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$search_DASH_result_DASH_list_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta35649], null);
});

camelot.component.species_search.t_camelot$component$species_search35648.cljs$lang$type = true;

camelot.component.species_search.t_camelot$component$species_search35648.cljs$lang$ctorStr = "camelot.component.species-search/t_camelot$component$species_search35648";

camelot.component.species_search.t_camelot$component$species_search35648.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.species-search/t_camelot$component$species_search35648");
});

camelot.component.species_search.__GT_t_camelot$component$species_search35648 = (function camelot$component$species_search$search_result_list_component_$___GT_t_camelot$component$species_search35648(search_result_list_component__$1,data__$1,owner__$1,meta35649){
return (new camelot.component.species_search.t_camelot$component$species_search35648(search_result_list_component__$1,data__$1,owner__$1,meta35649));
});

}

return (new camelot.component.species_search.t_camelot$component$species_search35648(camelot$component$species_search$search_result_list_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.species_search.citation_modal = (function camelot$component$species_search$citation_modal(data,owner){
if(typeof camelot.component.species_search.t_camelot$component$species_search35684 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.species_search.t_camelot$component$species_search35684 = (function (citation_modal,data,owner,meta35685){
this.citation_modal = citation_modal;
this.data = data;
this.owner = owner;
this.meta35685 = meta35685;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.species_search.t_camelot$component$species_search35684.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35686,meta35685__$1){
var self__ = this;
var _35686__$1 = this;
return (new camelot.component.species_search.t_camelot$component$species_search35684(self__.citation_modal,self__.data,self__.owner,meta35685__$1));
});

camelot.component.species_search.t_camelot$component$species_search35684.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35686){
var self__ = this;
var _35686__$1 = this;
return self__.meta35685;
});

camelot.component.species_search.t_camelot$component$species_search35684.prototype.om$core$IRender$ = true;

camelot.component.species_search.t_camelot$component$species_search35684.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$citation.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__35687 = ({"className": "citation-modal"});
var G__35688 = om.util.force_children((function (){var G__35691 = null;
var G__35692 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_citation));
return React.DOM.h3(G__35691,G__35692);
})());
var G__35689 = om.util.force_children((function (){var G__35693 = ({"className": "citation-font"});
var G__35694 = om.util.force_children(cljs.core.cst$kw$citation.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.p(G__35693,G__35694);
})());
var G__35690 = om.util.force_children((function (){var G__35695 = ({"onClick": ((function (G__35687,G__35688,G__35689,___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$citation,null);
});})(G__35687,G__35688,G__35689,___$1))
, "className": "btn btn-primary hide-citation"});
var G__35696 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_hide));
return React.DOM.button(G__35695,G__35696);
})());
return React.DOM.div(G__35687,G__35688,G__35689,G__35690);
} else {
return null;
}
});

camelot.component.species_search.t_camelot$component$species_search35684.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$citation_DASH_modal,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta35685], null);
});

camelot.component.species_search.t_camelot$component$species_search35684.cljs$lang$type = true;

camelot.component.species_search.t_camelot$component$species_search35684.cljs$lang$ctorStr = "camelot.component.species-search/t_camelot$component$species_search35684";

camelot.component.species_search.t_camelot$component$species_search35684.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.species-search/t_camelot$component$species_search35684");
});

camelot.component.species_search.__GT_t_camelot$component$species_search35684 = (function camelot$component$species_search$citation_modal_$___GT_t_camelot$component$species_search35684(citation_modal__$1,data__$1,owner__$1,meta35685){
return (new camelot.component.species_search.t_camelot$component$species_search35684(citation_modal__$1,data__$1,owner__$1,meta35685));
});

}

return (new camelot.component.species_search.t_camelot$component$species_search35684(camelot$component$species_search$citation_modal,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.species_search.species_search_component = (function camelot$component$species_search$species_search_component(data,owner,p__35697){
var map__35805 = p__35697;
var map__35805__$1 = ((((!((map__35805 == null)))?((((map__35805.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35805.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35805):map__35805);
var extch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35805__$1,cljs.core.cst$kw$extch);
if(typeof camelot.component.species_search.t_camelot$component$species_search35807 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.species_search.t_camelot$component$species_search35807 = (function (species_search_component,data,owner,p__35697,map__35805,extch,meta35808){
this.species_search_component = species_search_component;
this.data = data;
this.owner = owner;
this.p__35697 = p__35697;
this.map__35805 = map__35805;
this.extch = extch;
this.meta35808 = meta35808;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
camelot.component.species_search.t_camelot$component$species_search35807.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__35805,map__35805__$1,extch){
return (function (_35809,meta35808__$1){
var self__ = this;
var _35809__$1 = this;
return (new camelot.component.species_search.t_camelot$component$species_search35807(self__.species_search_component,self__.data,self__.owner,self__.p__35697,self__.map__35805,self__.extch,meta35808__$1));
});})(map__35805,map__35805__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search35807.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__35805,map__35805__$1,extch){
return (function (_35809){
var self__ = this;
var _35809__$1 = this;
return self__.meta35808;
});})(map__35805,map__35805__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search35807.prototype.om$core$IInitState$ = true;

camelot.component.species_search.t_camelot$component$species_search35807.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__35805,map__35805__$1,extch){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$results,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),cljs.core.cst$kw$select_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});})(map__35805,map__35805__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search35807.prototype.om$core$IDidMount$ = true;

camelot.component.species_search.t_camelot$component$species_search35807.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__35805,map__35805__$1,extch){
return (function (_){
var self__ = this;
var ___$1 = this;
var res = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$result_DASH_chan);
var sel = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$select_DASH_chan);
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,res,sel,___$1,map__35805,map__35805__$1,extch){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,res,sel,___$1,map__35805,map__35805__$1,extch){
return (function (state_35868){
var state_val_35869 = (state_35868[(1)]);
if((state_val_35869 === (7))){
var inst_35863 = (state_35868[(2)]);
var state_35868__$1 = (function (){var statearr_35870 = state_35868;
(statearr_35870[(7)] = inst_35863);

return statearr_35870;
})();
var statearr_35871_35912 = state_35868__$1;
(statearr_35871_35912[(2)] = null);

(statearr_35871_35912[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (20))){
var inst_35853 = (state_35868[(2)]);
var state_35868__$1 = state_35868;
var statearr_35872_35913 = state_35868__$1;
(statearr_35872_35913[(2)] = inst_35853);

(statearr_35872_35913[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (1))){
var state_35868__$1 = state_35868;
var statearr_35873_35914 = state_35868__$1;
(statearr_35873_35914[(2)] = null);

(statearr_35873_35914[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (4))){
var inst_35818 = (state_35868[(2)]);
var inst_35819 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35818,(0),null);
var inst_35820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35818,(1),null);
var inst_35821 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35820,res);
var state_35868__$1 = (function (){var statearr_35874 = state_35868;
(statearr_35874[(8)] = inst_35819);

return statearr_35874;
})();
if(inst_35821){
var statearr_35875_35915 = state_35868__$1;
(statearr_35875_35915[(1)] = (5));

} else {
var statearr_35876_35916 = state_35868__$1;
(statearr_35876_35916[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (15))){
var state_35868__$1 = state_35868;
if(cljs.core.truth_(self__.extch)){
var statearr_35877_35917 = state_35868__$1;
(statearr_35877_35917[(1)] = (17));

} else {
var statearr_35878_35918 = state_35868__$1;
(statearr_35878_35918[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (13))){
var inst_35838 = (state_35868[(2)]);
var state_35868__$1 = state_35868;
var statearr_35879_35919 = state_35868__$1;
(statearr_35879_35919[(2)] = inst_35838);

(statearr_35879_35919[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (6))){
var inst_35819 = (state_35868[(8)]);
var inst_35840 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_35819);
var inst_35841 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35840,cljs.core.cst$kw$citation);
var state_35868__$1 = state_35868;
if(inst_35841){
var statearr_35880_35920 = state_35868__$1;
(statearr_35880_35920[(1)] = (14));

} else {
var statearr_35881_35921 = state_35868__$1;
(statearr_35881_35921[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (17))){
var inst_35819 = (state_35868[(8)]);
var inst_35848 = [cljs.core.cst$kw$type,cljs.core.cst$kw$taxonomy];
var inst_35849 = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(inst_35819);
var inst_35850 = [cljs.core.cst$kw$search,inst_35849];
var inst_35851 = cljs.core.PersistentHashMap.fromArrays(inst_35848,inst_35850);
var state_35868__$1 = state_35868;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_35868__$1,(20),self__.extch,inst_35851);
} else {
if((state_val_35869 === (3))){
var inst_35866 = (state_35868[(2)]);
var state_35868__$1 = state_35868;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35868__$1,inst_35866);
} else {
if((state_val_35869 === (12))){
var state_35868__$1 = state_35868;
var statearr_35882_35922 = state_35868__$1;
(statearr_35882_35922[(2)] = null);

(statearr_35882_35922[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (2))){
var inst_35814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35815 = [res,sel];
var inst_35816 = (new cljs.core.PersistentVector(null,2,(5),inst_35814,inst_35815,null));
var state_35868__$1 = state_35868;
return cljs.core.async.ioc_alts_BANG_(state_35868__$1,(4),inst_35816);
} else {
if((state_val_35869 === (19))){
var inst_35858 = (state_35868[(2)]);
var inst_35859 = camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("species-search","add-species");
var state_35868__$1 = (function (){var statearr_35883 = state_35868;
(statearr_35883[(9)] = inst_35858);

return statearr_35883;
})();
var statearr_35884_35923 = state_35868__$1;
(statearr_35884_35923[(2)] = inst_35859);

(statearr_35884_35923[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (11))){
var inst_35819 = (state_35868[(8)]);
var inst_35833 = cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(inst_35819);
var inst_35834 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$search_DASH_results,inst_35833);
var inst_35835 = camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("species-search","search");
var state_35868__$1 = (function (){var statearr_35885 = state_35868;
(statearr_35885[(10)] = inst_35834);

return statearr_35885;
})();
var statearr_35886_35924 = state_35868__$1;
(statearr_35886_35924[(2)] = inst_35835);

(statearr_35886_35924[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (9))){
var inst_35819 = (state_35868[(8)]);
var inst_35827 = cljs.core.cst$kw$busy.cljs$core$IFn$_invoke$arity$1(inst_35819);
var inst_35828 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$busy,inst_35827);
var state_35868__$1 = state_35868;
var statearr_35887_35925 = state_35868__$1;
(statearr_35887_35925[(2)] = inst_35828);

(statearr_35887_35925[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (5))){
var inst_35819 = (state_35868[(8)]);
var inst_35823 = cljs.core.cst$kw$busy.cljs$core$IFn$_invoke$arity$1(inst_35819);
var inst_35824 = (inst_35823 == null);
var state_35868__$1 = state_35868;
if(cljs.core.truth_(inst_35824)){
var statearr_35888_35926 = state_35868__$1;
(statearr_35888_35926[(1)] = (8));

} else {
var statearr_35889_35927 = state_35868__$1;
(statearr_35889_35927[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (14))){
var inst_35819 = (state_35868[(8)]);
var inst_35843 = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(inst_35819);
var inst_35844 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$citation,inst_35843);
var inst_35845 = camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("species-search","view-citation");
var state_35868__$1 = (function (){var statearr_35890 = state_35868;
(statearr_35890[(11)] = inst_35844);

return statearr_35890;
})();
var statearr_35891_35928 = state_35868__$1;
(statearr_35891_35928[(2)] = inst_35845);

(statearr_35891_35928[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (16))){
var inst_35861 = (state_35868[(2)]);
var state_35868__$1 = state_35868;
var statearr_35892_35929 = state_35868__$1;
(statearr_35892_35929[(2)] = inst_35861);

(statearr_35892_35929[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (10))){
var inst_35819 = (state_35868[(8)]);
var inst_35830 = (state_35868[(2)]);
var inst_35831 = cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(inst_35819);
var state_35868__$1 = (function (){var statearr_35893 = state_35868;
(statearr_35893[(12)] = inst_35830);

return statearr_35893;
})();
if(cljs.core.truth_(inst_35831)){
var statearr_35894_35930 = state_35868__$1;
(statearr_35894_35930[(1)] = (11));

} else {
var statearr_35895_35931 = state_35868__$1;
(statearr_35895_35931[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (18))){
var inst_35819 = (state_35868[(8)]);
var inst_35855 = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(inst_35819);
var inst_35856 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$selection,inst_35855);
var state_35868__$1 = state_35868;
var statearr_35896_35932 = state_35868__$1;
(statearr_35896_35932[(2)] = inst_35856);

(statearr_35896_35932[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35869 === (8))){
var state_35868__$1 = state_35868;
var statearr_35897_35933 = state_35868__$1;
(statearr_35897_35933[(2)] = null);

(statearr_35897_35933[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__,res,sel,___$1,map__35805,map__35805__$1,extch))
;
return ((function (switch__28452__auto__,c__28576__auto__,res,sel,___$1,map__35805,map__35805__$1,extch){
return (function() {
var camelot$component$species_search$species_search_component_$_state_machine__28453__auto__ = null;
var camelot$component$species_search$species_search_component_$_state_machine__28453__auto____0 = (function (){
var statearr_35901 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35901[(0)] = camelot$component$species_search$species_search_component_$_state_machine__28453__auto__);

(statearr_35901[(1)] = (1));

return statearr_35901;
});
var camelot$component$species_search$species_search_component_$_state_machine__28453__auto____1 = (function (state_35868){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_35868);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e35902){if((e35902 instanceof Object)){
var ex__28456__auto__ = e35902;
var statearr_35903_35934 = state_35868;
(statearr_35903_35934[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35868);

return cljs.core.cst$kw$recur;
} else {
throw e35902;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__35935 = state_35868;
state_35868 = G__35935;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$component$species_search$species_search_component_$_state_machine__28453__auto__ = function(state_35868){
switch(arguments.length){
case 0:
return camelot$component$species_search$species_search_component_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$component$species_search$species_search_component_$_state_machine__28453__auto____1.call(this,state_35868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$component$species_search$species_search_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$species_search$species_search_component_$_state_machine__28453__auto____0;
camelot$component$species_search$species_search_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$species_search$species_search_component_$_state_machine__28453__auto____1;
return camelot$component$species_search$species_search_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,res,sel,___$1,map__35805,map__35805__$1,extch))
})();
var state__28578__auto__ = (function (){var statearr_35904 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_35904[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_35904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,res,sel,___$1,map__35805,map__35805__$1,extch))
);

return c__28576__auto__;
});})(map__35805,map__35805__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search35807.prototype.om$core$IRenderState$ = true;

camelot.component.species_search.t_camelot$component$species_search35807.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__35805,map__35805__$1,extch){
return (function (this$,state){
var self__ = this;
var this$__$1 = this;
var G__35905 = ({"className": "species-search"});
var G__35906 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.species_search.citation_modal,self__.data));
var G__35907 = om.util.force_children((function (){var G__35910 = ({"className": "field-label"});
var G__35911 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$species_DASH_search_SLASH_search_DASH_species));
return React.DOM.label(G__35910,G__35911);
})());
var G__35908 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.species_search.search_input_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$result_DASH_chan,cljs.core.cst$kw$result_DASH_chan.cljs$core$IFn$_invoke$arity$1(state)], null)], null)));
var G__35909 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.species_search.search_result_list_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$select_DASH_chan,cljs.core.cst$kw$select_DASH_chan.cljs$core$IFn$_invoke$arity$1(state)], null)], null)));
return React.DOM.div(G__35905,G__35906,G__35907,G__35908,G__35909);
});})(map__35805,map__35805__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search35807.getBasis = ((function (map__35805,map__35805__$1,extch){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$species_DASH_search_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$extch], null)], null)], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__35697,cljs.core.cst$sym$map__35805,cljs.core.cst$sym$extch,cljs.core.cst$sym$meta35808], null);
});})(map__35805,map__35805__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search35807.cljs$lang$type = true;

camelot.component.species_search.t_camelot$component$species_search35807.cljs$lang$ctorStr = "camelot.component.species-search/t_camelot$component$species_search35807";

camelot.component.species_search.t_camelot$component$species_search35807.cljs$lang$ctorPrWriter = ((function (map__35805,map__35805__$1,extch){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"camelot.component.species-search/t_camelot$component$species_search35807");
});})(map__35805,map__35805__$1,extch))
;

camelot.component.species_search.__GT_t_camelot$component$species_search35807 = ((function (map__35805,map__35805__$1,extch){
return (function camelot$component$species_search$species_search_component_$___GT_t_camelot$component$species_search35807(species_search_component__$1,data__$1,owner__$1,p__35697__$1,map__35805__$2,extch__$1,meta35808){
return (new camelot.component.species_search.t_camelot$component$species_search35807(species_search_component__$1,data__$1,owner__$1,p__35697__$1,map__35805__$2,extch__$1,meta35808));
});})(map__35805,map__35805__$1,extch))
;

}

return (new camelot.component.species_search.t_camelot$component$species_search35807(camelot$component$species_search$species_search_component,data,owner,p__35697,map__35805__$1,extch,cljs.core.PersistentArrayMap.EMPTY));
});
