// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.nav');
goog.require('cljs.core');
goog.require('secretary.core');
goog.require('goog.history.EventType');
goog.require('camelot.state');
goog.require('goog.History');
goog.require('goog.events');
goog.require('om.core');
goog.require('clojure.string');
/**
 * Get the current location token
 */
camelot.nav.get_token = (function camelot$nav$get_token(){
return [cljs.core.str(window.location.pathname),cljs.core.str(window.location.hash)].join('');
});
if(typeof camelot.nav.history !== 'undefined'){
} else {
camelot.nav.history = (function (){var G__31631 = (new goog.History());
var G__31632_31635 = G__31631;
var G__31633_31636 = goog.history.EventType.NAVIGATE;
var G__31634_31637 = ((function (G__31632_31635,G__31633_31636,G__31631){
return (function (p1__31630_SHARP_){
return secretary.core.dispatch_BANG_(p1__31630_SHARP_.token);
});})(G__31632_31635,G__31633_31636,G__31631))
;
goog.events.listen(G__31632_31635,G__31633_31636,G__31634_31637);

G__31631.setEnabled(true);

return G__31631;
})();
}
camelot.nav.survey_url = (function camelot$nav$survey_url(var_args){
var args31638 = [];
var len__7492__auto___31642 = arguments.length;
var i__7493__auto___31643 = (0);
while(true){
if((i__7493__auto___31643 < len__7492__auto___31642)){
args31638.push((arguments[i__7493__auto___31643]));

var G__31644 = (i__7493__auto___31643 + (1));
i__7493__auto___31643 = G__31644;
continue;
} else {
}
break;
}

var G__31641 = args31638.length;
switch (G__31641) {
case 0:
return camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7511__auto__ = (new cljs.core.IndexedSeq(args31638.slice((0)),(0),null));
return camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7511__auto__);

}
});

camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$0 = (function (){
var survey_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null));
if((survey_id == null)){
return [cljs.core.str("/organisation")].join('');
} else {
return [cljs.core.str("/"),cljs.core.str(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null)))].join('');
}
});

camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$variadic = (function (paths){
var survey_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null));
if(cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(paths,survey_id)))){
return [cljs.core.str("/organisation")].join('');
} else {
return [cljs.core.str("/"),cljs.core.str(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null))),cljs.core.str("/"),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2("/",paths))].join('');
}
});

camelot.nav.survey_url.cljs$lang$applyTo = (function (seq31639){
return camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31639));
});

camelot.nav.survey_url.cljs$lang$maxFixedArity = (0);

camelot.nav.fire_analytics = (function camelot$nav$fire_analytics(var_args){
var args__7499__auto__ = [];
var len__7492__auto___31647 = arguments.length;
var i__7493__auto___31648 = (0);
while(true){
if((i__7493__auto___31648 < len__7492__auto___31647)){
args__7499__auto__.push((arguments[i__7493__auto___31648]));

var G__31649 = (i__7493__auto___31648 + (1));
i__7493__auto___31648 = G__31649;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((0) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((0)),(0),null)):null);
return camelot.nav.fire_analytics.cljs$core$IFn$_invoke$arity$variadic(argseq__7500__auto__);
});

camelot.nav.fire_analytics.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core.truth_(cljs.core.cst$kw$send_DASH_usage_DASH_data.cljs$core$IFn$_invoke$arity$1(camelot.state.settings()))){
var temp__4655__auto__ = (window["cljs_ga"]);
if(cljs.core.truth_(temp__4655__auto__)){
var ga = temp__4655__auto__;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(ga,args);
} else {
return console.warn("Analytics library not found");
}
} else {
return null;
}
});

camelot.nav.fire_analytics.cljs$lang$maxFixedArity = (0);

camelot.nav.fire_analytics.cljs$lang$applyTo = (function (seq31646){
return camelot.nav.fire_analytics.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31646));
});

/**
 * Trigger an analytics event.
 */
camelot.nav.analytics_event = (function camelot$nav$analytics_event(var_args){
var args31650 = [];
var len__7492__auto___31653 = arguments.length;
var i__7493__auto___31654 = (0);
while(true){
if((i__7493__auto___31654 < len__7492__auto___31653)){
args31650.push((arguments[i__7493__auto___31654]));

var G__31655 = (i__7493__auto___31654 + (1));
i__7493__auto___31654 = G__31655;
continue;
} else {
}
break;
}

var G__31652 = args31650.length;
switch (G__31652) {
case 2:
return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31650.length)].join('')));

}
});

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2 = (function (component,action){
return camelot.nav.fire_analytics.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["send","event",component,action], 0));
});

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$3 = (function (component,action,label){
return camelot.nav.fire_analytics.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["send","event",component,action,label], 0));
});

camelot.nav.analytics_event.cljs$lang$maxFixedArity = 3;

/**
 * Trigger a pageview analytics event.
 */
camelot.nav.analytics_pageview = (function camelot$nav$analytics_pageview(page){
if(cljs.core.truth_(cljs.core.cst$kw$send_DASH_usage_DASH_data.cljs$core$IFn$_invoke$arity$1(camelot.state.settings()))){
var temp__4655__auto__ = (window["cljs_ga"]);
if(cljs.core.truth_(temp__4655__auto__)){
var ga = temp__4655__auto__;
(ga.cljs$core$IFn$_invoke$arity$3 ? ga.cljs$core$IFn$_invoke$arity$3("set","page",page) : ga.call(null,"set","page",page));

return (ga.cljs$core$IFn$_invoke$arity$2 ? ga.cljs$core$IFn$_invoke$arity$2("send","pageview") : ga.call(null,"send","pageview"));
} else {
return null;
}
} else {
return null;
}
});
camelot.nav.set_token_BANG_ = (function camelot$nav$set_token_BANG_(history,token){
var token__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(token,(0),(2)),"/#"))?cljs.core.subs.cljs$core$IFn$_invoke$arity$2(token,(2)):token);
camelot.nav.analytics_pageview(token__$1);

history.setToken(token__$1);

return token__$1;
});
/**
 * Navigate to a URL token, creating a breadcrumb
 */
camelot.nav.breadnav_BANG_ = (function camelot$nav$breadnav_BANG_(token,breadcrumb,state){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$nav_DASH_history,(function (h){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(h),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$token,camelot.nav.get_token(),cljs.core.cst$kw$label,breadcrumb,cljs.core.cst$kw$state,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state))], null));
}));

return camelot.nav.set_token_BANG_(camelot.nav.history,token);
});
/**
 * Navigate to a URL token
 */
camelot.nav.breadnav_consume_BANG_ = (function camelot$nav$breadnav_consume_BANG_(token){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$nav_DASH_history,(function (h){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__31657_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$token.cljs$core$IFn$_invoke$arity$1(p1__31657_SHARP_),token);
}),h);
}));

return camelot.nav.set_token_BANG_(camelot.nav.history,token);
});
/**
 * Navigate to a URL token
 */
camelot.nav.nav_BANG_ = (function camelot$nav$nav_BANG_(token){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$nav_DASH_history,cljs.core.PersistentVector.EMPTY);

return camelot.nav.set_token_BANG_(camelot.nav.history,token);
});
camelot.nav.nav_up_url = (function camelot$nav$nav_up_url(token,levels){
if((typeof token === 'string') && (typeof levels === 'number')){
} else {
throw (new Error("Assert failed: (and (string? token) (number? levels))"));
}

var url = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__31658_SHARP_){
return clojure.string.replace(p1__31658_SHARP_,/(.*)\/.+?$/,"$1");
}),token,cljs.core.range.cljs$core$IFn$_invoke$arity$1(levels));
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(url,"/#")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(url,""))){
return "/#/organisation";
} else {
return url;
}
});
/**
 * Navigate up 1 or more levels.
 */
camelot.nav.nav_up_BANG_ = (function camelot$nav$nav_up_BANG_(var_args){
var args31659 = [];
var len__7492__auto___31662 = arguments.length;
var i__7493__auto___31663 = (0);
while(true){
if((i__7493__auto___31663 < len__7492__auto___31662)){
args31659.push((arguments[i__7493__auto___31663]));

var G__31664 = (i__7493__auto___31663 + (1));
i__7493__auto___31663 = G__31664;
continue;
} else {
}
break;
}

var G__31661 = args31659.length;
switch (G__31661) {
case 0:
return camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31659.length)].join('')));

}
});

camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$1((1));
});

camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (levels){
return camelot.nav.nav_BANG_(camelot.nav.nav_up_url(camelot.nav.get_token(),levels));
});

camelot.nav.nav_up_BANG_.cljs$lang$maxFixedArity = 1;

