// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.rest');
goog.require('cljs.core');
goog.require('cljs_http.client');
goog.require('camelot.state');
goog.require('cljs.core.async');
goog.require('camelot.util.transit');
goog.require('om.core');
goog.require('camelot.util.misc');
camelot.rest.success_status_codes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
camelot.rest._build_error = (function camelot$rest$_build_error(method,url,params,status,response){
var sep = "\n--------\n";
var req = [cljs.core.str("Requested: "),cljs.core.str(url),cljs.core.str(" via "),cljs.core.str(method)].join('');
var stat = [cljs.core.str("Status Code: "),cljs.core.str(status),cljs.core.str("\n")].join('');
if((status === (0))){
return [cljs.core.str("Unable to contact server"),cljs.core.str(sep),cljs.core.str(req)].join('');
} else {
if((params == null)){
return [cljs.core.str(response),cljs.core.str(sep),cljs.core.str(stat),cljs.core.str(req)].join('');
} else {
return [cljs.core.str(response),cljs.core.str(sep),cljs.core.str(stat),cljs.core.str(req),cljs.core.str("\nWith parameters: "),cljs.core.str(params),cljs.core.str("\n")].join('');

}
}
});
camelot.rest.build_error = (function camelot$rest$build_error(var_args){
var args32679 = [];
var len__7492__auto___32682 = arguments.length;
var i__7493__auto___32683 = (0);
while(true){
if((i__7493__auto___32683 < len__7492__auto___32682)){
args32679.push((arguments[i__7493__auto___32683]));

var G__32684 = (i__7493__auto___32683 + (1));
i__7493__auto___32683 = G__32684;
continue;
} else {
}
break;
}

var G__32681 = args32679.length;
switch (G__32681) {
case 4:
return camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32679.length)].join('')));

}
});

camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4 = (function (method,url,status,response){
return camelot.rest._build_error(method,url,null,status,response);
});

camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5 = (function (method,url,params,status,response){
return camelot.rest._build_error(method,url,params,status,response);
});

camelot.rest.build_error.cljs$lang$maxFixedArity = 5;

camelot.rest.set_error_state_BANG_ = (function camelot$rest$set_error_state_BANG_(resource,response){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.display_state(),cljs.core.cst$kw$error,camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("POST",camelot.util.misc.with_baseurl(resource),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$params_DASH_unavailable,true], null),cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(response)));
});
/**
 * Send an normal (transit-free) GET request.
 */
camelot.rest.get_x_raw = (function camelot$rest$get_x_raw(x_url,params,cb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_32752){
var state_val_32753 = (state_32752[(1)]);
if((state_val_32753 === (1))){
var inst_32728 = camelot.util.misc.with_baseurl(x_url);
var inst_32729 = cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(inst_32728,cljs.core.array_seq([params], 0));
var state_32752__$1 = state_32752;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32752__$1,(2),inst_32729);
} else {
if((state_val_32753 === (2))){
var inst_32731 = (state_32752[(7)]);
var inst_32731__$1 = (state_32752[(2)]);
var inst_32732 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_32731__$1);
var inst_32733 = [inst_32732];
var inst_32734 = cljs.core.PersistentHashSet.fromArray(inst_32733,true);
var inst_32735 = cljs.core.some(inst_32734,camelot.rest.success_status_codes);
var state_32752__$1 = (function (){var statearr_32754 = state_32752;
(statearr_32754[(7)] = inst_32731__$1);

return statearr_32754;
})();
if(cljs.core.truth_(inst_32735)){
var statearr_32755_32770 = state_32752__$1;
(statearr_32755_32770[(1)] = (3));

} else {
var statearr_32756_32771 = state_32752__$1;
(statearr_32756_32771[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (3))){
var state_32752__$1 = state_32752;
if(cljs.core.truth_(cb)){
var statearr_32757_32772 = state_32752__$1;
(statearr_32757_32772[(1)] = (6));

} else {
var statearr_32758_32773 = state_32752__$1;
(statearr_32758_32773[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (4))){
var inst_32731 = (state_32752[(7)]);
var inst_32743 = camelot.state.display_state();
var inst_32744 = camelot.util.misc.with_baseurl(x_url);
var inst_32745 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_32731);
var inst_32746 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_32731);
var inst_32747 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4("GET",inst_32744,inst_32745,inst_32746);
var inst_32748 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32743,cljs.core.cst$kw$error,inst_32747);
var state_32752__$1 = state_32752;
var statearr_32759_32774 = state_32752__$1;
(statearr_32759_32774[(2)] = inst_32748);

(statearr_32759_32774[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (5))){
var inst_32750 = (state_32752[(2)]);
var state_32752__$1 = state_32752;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32752__$1,inst_32750);
} else {
if((state_val_32753 === (6))){
var inst_32731 = (state_32752[(7)]);
var inst_32738 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_32731) : cb.call(null,inst_32731));
var state_32752__$1 = state_32752;
var statearr_32760_32775 = state_32752__$1;
(statearr_32760_32775[(2)] = inst_32738);

(statearr_32760_32775[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (7))){
var state_32752__$1 = state_32752;
var statearr_32761_32776 = state_32752__$1;
(statearr_32761_32776[(2)] = null);

(statearr_32761_32776[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32753 === (8))){
var inst_32741 = (state_32752[(2)]);
var state_32752__$1 = state_32752;
var statearr_32762_32777 = state_32752__$1;
(statearr_32762_32777[(2)] = inst_32741);

(statearr_32762_32777[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$get_x_raw_$_state_machine__28453__auto__ = null;
var camelot$rest$get_x_raw_$_state_machine__28453__auto____0 = (function (){
var statearr_32766 = [null,null,null,null,null,null,null,null];
(statearr_32766[(0)] = camelot$rest$get_x_raw_$_state_machine__28453__auto__);

(statearr_32766[(1)] = (1));

return statearr_32766;
});
var camelot$rest$get_x_raw_$_state_machine__28453__auto____1 = (function (state_32752){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_32752);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e32767){if((e32767 instanceof Object)){
var ex__28456__auto__ = e32767;
var statearr_32768_32778 = state_32752;
(statearr_32768_32778[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32752);

return cljs.core.cst$kw$recur;
} else {
throw e32767;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__32779 = state_32752;
state_32752 = G__32779;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$get_x_raw_$_state_machine__28453__auto__ = function(state_32752){
switch(arguments.length){
case 0:
return camelot$rest$get_x_raw_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$get_x_raw_$_state_machine__28453__auto____1.call(this,state_32752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$get_x_raw_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$get_x_raw_$_state_machine__28453__auto____0;
camelot$rest$get_x_raw_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$get_x_raw_$_state_machine__28453__auto____1;
return camelot$rest$get_x_raw_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_32769 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_32769[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_32769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});
/**
 * Make a request via GET.
 */
camelot.rest.get_x = (function camelot$rest$get_x(var_args){
var args32780 = [];
var len__7492__auto___32867 = arguments.length;
var i__7493__auto___32868 = (0);
while(true){
if((i__7493__auto___32868 < len__7492__auto___32867)){
args32780.push((arguments[i__7493__auto___32868]));

var G__32869 = (i__7493__auto___32868 + (1));
i__7493__auto___32868 = G__32869;
continue;
} else {
}
break;
}

var G__32782 = args32780.length;
switch (G__32782) {
case 2:
return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32780.length)].join('')));

}
});

camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2 = (function (x_url,cb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_32807){
var state_val_32808 = (state_32807[(1)]);
if((state_val_32808 === (1))){
var inst_32783 = camelot.util.misc.with_baseurl(x_url);
var inst_32784 = camelot.util.transit.request(cljs_http.client.get,inst_32783,null);
var state_32807__$1 = state_32807;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32807__$1,(2),inst_32784);
} else {
if((state_val_32808 === (2))){
var inst_32786 = (state_32807[(7)]);
var inst_32786__$1 = (state_32807[(2)]);
var inst_32787 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_32786__$1);
var inst_32788 = [inst_32787];
var inst_32789 = cljs.core.PersistentHashSet.fromArray(inst_32788,true);
var inst_32790 = cljs.core.some(inst_32789,camelot.rest.success_status_codes);
var state_32807__$1 = (function (){var statearr_32809 = state_32807;
(statearr_32809[(7)] = inst_32786__$1);

return statearr_32809;
})();
if(cljs.core.truth_(inst_32790)){
var statearr_32810_32871 = state_32807__$1;
(statearr_32810_32871[(1)] = (3));

} else {
var statearr_32811_32872 = state_32807__$1;
(statearr_32811_32872[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32808 === (3))){
var state_32807__$1 = state_32807;
if(cljs.core.truth_(cb)){
var statearr_32812_32873 = state_32807__$1;
(statearr_32812_32873[(1)] = (6));

} else {
var statearr_32813_32874 = state_32807__$1;
(statearr_32813_32874[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32808 === (4))){
var inst_32786 = (state_32807[(7)]);
var inst_32798 = camelot.state.display_state();
var inst_32799 = camelot.util.misc.with_baseurl(x_url);
var inst_32800 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_32786);
var inst_32801 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_32786);
var inst_32802 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4("GET",inst_32799,inst_32800,inst_32801);
var inst_32803 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32798,cljs.core.cst$kw$error,inst_32802);
var state_32807__$1 = state_32807;
var statearr_32814_32875 = state_32807__$1;
(statearr_32814_32875[(2)] = inst_32803);

(statearr_32814_32875[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32808 === (5))){
var inst_32805 = (state_32807[(2)]);
var state_32807__$1 = state_32807;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32807__$1,inst_32805);
} else {
if((state_val_32808 === (6))){
var inst_32786 = (state_32807[(7)]);
var inst_32793 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_32786) : cb.call(null,inst_32786));
var state_32807__$1 = state_32807;
var statearr_32815_32876 = state_32807__$1;
(statearr_32815_32876[(2)] = inst_32793);

(statearr_32815_32876[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32808 === (7))){
var state_32807__$1 = state_32807;
var statearr_32816_32877 = state_32807__$1;
(statearr_32816_32877[(2)] = null);

(statearr_32816_32877[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32808 === (8))){
var inst_32796 = (state_32807[(2)]);
var state_32807__$1 = state_32807;
var statearr_32817_32878 = state_32807__$1;
(statearr_32817_32878[(2)] = inst_32796);

(statearr_32817_32878[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$state_machine__28453__auto__ = null;
var camelot$rest$state_machine__28453__auto____0 = (function (){
var statearr_32821 = [null,null,null,null,null,null,null,null];
(statearr_32821[(0)] = camelot$rest$state_machine__28453__auto__);

(statearr_32821[(1)] = (1));

return statearr_32821;
});
var camelot$rest$state_machine__28453__auto____1 = (function (state_32807){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_32807);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e32822){if((e32822 instanceof Object)){
var ex__28456__auto__ = e32822;
var statearr_32823_32879 = state_32807;
(statearr_32823_32879[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32807);

return cljs.core.cst$kw$recur;
} else {
throw e32822;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__32880 = state_32807;
state_32807 = G__32880;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$state_machine__28453__auto__ = function(state_32807){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$state_machine__28453__auto____1.call(this,state_32807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__28453__auto____0;
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__28453__auto____1;
return camelot$rest$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_32824 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_32824[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_32824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});

camelot.rest.get_x.cljs$core$IFn$_invoke$arity$3 = (function (x_url,params,cb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_32849){
var state_val_32850 = (state_32849[(1)]);
if((state_val_32850 === (1))){
var inst_32825 = camelot.util.misc.with_baseurl(x_url);
var inst_32826 = camelot.util.transit.request(cljs_http.client.get,inst_32825,params);
var state_32849__$1 = state_32849;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32849__$1,(2),inst_32826);
} else {
if((state_val_32850 === (2))){
var inst_32828 = (state_32849[(7)]);
var inst_32828__$1 = (state_32849[(2)]);
var inst_32829 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_32828__$1);
var inst_32830 = [inst_32829];
var inst_32831 = cljs.core.PersistentHashSet.fromArray(inst_32830,true);
var inst_32832 = cljs.core.some(inst_32831,camelot.rest.success_status_codes);
var state_32849__$1 = (function (){var statearr_32851 = state_32849;
(statearr_32851[(7)] = inst_32828__$1);

return statearr_32851;
})();
if(cljs.core.truth_(inst_32832)){
var statearr_32852_32881 = state_32849__$1;
(statearr_32852_32881[(1)] = (3));

} else {
var statearr_32853_32882 = state_32849__$1;
(statearr_32853_32882[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32850 === (3))){
var state_32849__$1 = state_32849;
if(cljs.core.truth_(cb)){
var statearr_32854_32883 = state_32849__$1;
(statearr_32854_32883[(1)] = (6));

} else {
var statearr_32855_32884 = state_32849__$1;
(statearr_32855_32884[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32850 === (4))){
var inst_32828 = (state_32849[(7)]);
var inst_32840 = camelot.state.display_state();
var inst_32841 = camelot.util.misc.with_baseurl(x_url);
var inst_32842 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_32828);
var inst_32843 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_32828);
var inst_32844 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4("GET",inst_32841,inst_32842,inst_32843);
var inst_32845 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32840,cljs.core.cst$kw$error,inst_32844);
var state_32849__$1 = state_32849;
var statearr_32856_32885 = state_32849__$1;
(statearr_32856_32885[(2)] = inst_32845);

(statearr_32856_32885[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32850 === (5))){
var inst_32847 = (state_32849[(2)]);
var state_32849__$1 = state_32849;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32849__$1,inst_32847);
} else {
if((state_val_32850 === (6))){
var inst_32828 = (state_32849[(7)]);
var inst_32835 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_32828) : cb.call(null,inst_32828));
var state_32849__$1 = state_32849;
var statearr_32857_32886 = state_32849__$1;
(statearr_32857_32886[(2)] = inst_32835);

(statearr_32857_32886[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32850 === (7))){
var state_32849__$1 = state_32849;
var statearr_32858_32887 = state_32849__$1;
(statearr_32858_32887[(2)] = null);

(statearr_32858_32887[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32850 === (8))){
var inst_32838 = (state_32849[(2)]);
var state_32849__$1 = state_32849;
var statearr_32859_32888 = state_32849__$1;
(statearr_32859_32888[(2)] = inst_32838);

(statearr_32859_32888[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$state_machine__28453__auto__ = null;
var camelot$rest$state_machine__28453__auto____0 = (function (){
var statearr_32863 = [null,null,null,null,null,null,null,null];
(statearr_32863[(0)] = camelot$rest$state_machine__28453__auto__);

(statearr_32863[(1)] = (1));

return statearr_32863;
});
var camelot$rest$state_machine__28453__auto____1 = (function (state_32849){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_32849);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e32864){if((e32864 instanceof Object)){
var ex__28456__auto__ = e32864;
var statearr_32865_32889 = state_32849;
(statearr_32865_32889[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32849);

return cljs.core.cst$kw$recur;
} else {
throw e32864;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__32890 = state_32849;
state_32849 = G__32890;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$state_machine__28453__auto__ = function(state_32849){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$state_machine__28453__auto____1.call(this,state_32849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__28453__auto____0;
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__28453__auto____1;
return camelot$rest$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_32866 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_32866[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_32866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});

camelot.rest.get_x.cljs$lang$maxFixedArity = 3;

/**
 * POST state
 */
camelot.rest.get_x_opts = (function camelot$rest$get_x_opts(resource,p__32891){
var map__32964 = p__32891;
var map__32964__$1 = ((((!((map__32964 == null)))?((((map__32964.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32964.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32964):map__32964);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32964__$1,cljs.core.cst$kw$params);
var success = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32964__$1,cljs.core.cst$kw$success);
var failure = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32964__$1,cljs.core.cst$kw$failure);
var suppress_error_dialog = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32964__$1,cljs.core.cst$kw$suppress_DASH_error_DASH_dialog);
var always = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32964__$1,cljs.core.cst$kw$always);
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,map__32964,map__32964__$1,params,success,failure,suppress_error_dialog,always){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,map__32964,map__32964__$1,params,success,failure,suppress_error_dialog,always){
return (function (state_33004){
var state_val_33005 = (state_33004[(1)]);
if((state_val_33005 === (7))){
var state_33004__$1 = state_33004;
var statearr_33006_33036 = state_33004__$1;
(statearr_33006_33036[(2)] = null);

(statearr_33006_33036[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (1))){
var inst_32966 = camelot.util.misc.with_baseurl(resource);
var inst_32967 = camelot.util.transit.request(cljs_http.client.get,inst_32966,params);
var state_33004__$1 = state_33004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33004__$1,(2),inst_32967);
} else {
if((state_val_33005 === (4))){
var state_33004__$1 = state_33004;
if(cljs.core.truth_(failure)){
var statearr_33007_33037 = state_33004__$1;
(statearr_33007_33037[(1)] = (9));

} else {
var statearr_33008_33038 = state_33004__$1;
(statearr_33008_33038[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (15))){
var inst_32969 = (state_33004[(7)]);
var inst_32999 = (always.cljs$core$IFn$_invoke$arity$1 ? always.cljs$core$IFn$_invoke$arity$1(inst_32969) : always.call(null,inst_32969));
var state_33004__$1 = state_33004;
var statearr_33009_33039 = state_33004__$1;
(statearr_33009_33039[(2)] = inst_32999);

(statearr_33009_33039[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (13))){
var inst_32969 = (state_33004[(7)]);
var inst_32988 = camelot.state.display_state();
var inst_32989 = camelot.util.misc.with_baseurl(resource);
var inst_32990 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_32969);
var inst_32991 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_32969);
var inst_32992 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("GET",inst_32989,params,inst_32990,inst_32991);
var inst_32993 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32988,cljs.core.cst$kw$error,inst_32992);
var state_33004__$1 = state_33004;
var statearr_33010_33040 = state_33004__$1;
(statearr_33010_33040[(2)] = inst_32993);

(statearr_33010_33040[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (6))){
var inst_32969 = (state_33004[(7)]);
var inst_32976 = (success.cljs$core$IFn$_invoke$arity$1 ? success.cljs$core$IFn$_invoke$arity$1(inst_32969) : success.call(null,inst_32969));
var state_33004__$1 = state_33004;
var statearr_33011_33041 = state_33004__$1;
(statearr_33011_33041[(2)] = inst_32976);

(statearr_33011_33041[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (17))){
var inst_33002 = (state_33004[(2)]);
var state_33004__$1 = state_33004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33004__$1,inst_33002);
} else {
if((state_val_33005 === (3))){
var state_33004__$1 = state_33004;
if(cljs.core.truth_(success)){
var statearr_33012_33042 = state_33004__$1;
(statearr_33012_33042[(1)] = (6));

} else {
var statearr_33013_33043 = state_33004__$1;
(statearr_33013_33043[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (12))){
var state_33004__$1 = state_33004;
var statearr_33014_33044 = state_33004__$1;
(statearr_33014_33044[(2)] = null);

(statearr_33014_33044[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (2))){
var inst_32969 = (state_33004[(7)]);
var inst_32969__$1 = (state_33004[(2)]);
var inst_32970 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_32969__$1);
var inst_32971 = [inst_32970];
var inst_32972 = cljs.core.PersistentHashSet.fromArray(inst_32971,true);
var inst_32973 = cljs.core.some(inst_32972,camelot.rest.success_status_codes);
var state_33004__$1 = (function (){var statearr_33015 = state_33004;
(statearr_33015[(7)] = inst_32969__$1);

return statearr_33015;
})();
if(cljs.core.truth_(inst_32973)){
var statearr_33016_33045 = state_33004__$1;
(statearr_33016_33045[(1)] = (3));

} else {
var statearr_33017_33046 = state_33004__$1;
(statearr_33017_33046[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (11))){
var inst_32985 = (state_33004[(2)]);
var state_33004__$1 = (function (){var statearr_33018 = state_33004;
(statearr_33018[(8)] = inst_32985);

return statearr_33018;
})();
if(cljs.core.truth_(suppress_error_dialog)){
var statearr_33019_33047 = state_33004__$1;
(statearr_33019_33047[(1)] = (12));

} else {
var statearr_33020_33048 = state_33004__$1;
(statearr_33020_33048[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (9))){
var inst_32969 = (state_33004[(7)]);
var inst_32982 = (failure.cljs$core$IFn$_invoke$arity$1 ? failure.cljs$core$IFn$_invoke$arity$1(inst_32969) : failure.call(null,inst_32969));
var state_33004__$1 = state_33004;
var statearr_33021_33049 = state_33004__$1;
(statearr_33021_33049[(2)] = inst_32982);

(statearr_33021_33049[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (5))){
var inst_32997 = (state_33004[(2)]);
var state_33004__$1 = (function (){var statearr_33022 = state_33004;
(statearr_33022[(9)] = inst_32997);

return statearr_33022;
})();
if(cljs.core.truth_(always)){
var statearr_33023_33050 = state_33004__$1;
(statearr_33023_33050[(1)] = (15));

} else {
var statearr_33024_33051 = state_33004__$1;
(statearr_33024_33051[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (14))){
var inst_32995 = (state_33004[(2)]);
var state_33004__$1 = state_33004;
var statearr_33025_33052 = state_33004__$1;
(statearr_33025_33052[(2)] = inst_32995);

(statearr_33025_33052[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (16))){
var state_33004__$1 = state_33004;
var statearr_33026_33053 = state_33004__$1;
(statearr_33026_33053[(2)] = null);

(statearr_33026_33053[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (10))){
var state_33004__$1 = state_33004;
var statearr_33027_33054 = state_33004__$1;
(statearr_33027_33054[(2)] = null);

(statearr_33027_33054[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33005 === (8))){
var inst_32979 = (state_33004[(2)]);
var state_33004__$1 = state_33004;
var statearr_33028_33055 = state_33004__$1;
(statearr_33028_33055[(2)] = inst_32979);

(statearr_33028_33055[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__,map__32964,map__32964__$1,params,success,failure,suppress_error_dialog,always))
;
return ((function (switch__28452__auto__,c__28576__auto__,map__32964,map__32964__$1,params,success,failure,suppress_error_dialog,always){
return (function() {
var camelot$rest$get_x_opts_$_state_machine__28453__auto__ = null;
var camelot$rest$get_x_opts_$_state_machine__28453__auto____0 = (function (){
var statearr_33032 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33032[(0)] = camelot$rest$get_x_opts_$_state_machine__28453__auto__);

(statearr_33032[(1)] = (1));

return statearr_33032;
});
var camelot$rest$get_x_opts_$_state_machine__28453__auto____1 = (function (state_33004){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_33004);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e33033){if((e33033 instanceof Object)){
var ex__28456__auto__ = e33033;
var statearr_33034_33056 = state_33004;
(statearr_33034_33056[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33004);

return cljs.core.cst$kw$recur;
} else {
throw e33033;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__33057 = state_33004;
state_33004 = G__33057;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$get_x_opts_$_state_machine__28453__auto__ = function(state_33004){
switch(arguments.length){
case 0:
return camelot$rest$get_x_opts_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$get_x_opts_$_state_machine__28453__auto____1.call(this,state_33004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$get_x_opts_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$get_x_opts_$_state_machine__28453__auto____0;
camelot$rest$get_x_opts_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$get_x_opts_$_state_machine__28453__auto____1;
return camelot$rest$get_x_opts_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,map__32964,map__32964__$1,params,success,failure,suppress_error_dialog,always))
})();
var state__28578__auto__ = (function (){var statearr_33035 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_33035[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_33035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,map__32964,map__32964__$1,params,success,failure,suppress_error_dialog,always))
);

return c__28576__auto__;
});
/**
 * Make a request via DELETE.
 */
camelot.rest.delete_x = (function camelot$rest$delete_x(var_args){
var args33058 = [];
var len__7492__auto___33145 = arguments.length;
var i__7493__auto___33146 = (0);
while(true){
if((i__7493__auto___33146 < len__7492__auto___33145)){
args33058.push((arguments[i__7493__auto___33146]));

var G__33147 = (i__7493__auto___33146 + (1));
i__7493__auto___33146 = G__33147;
continue;
} else {
}
break;
}

var G__33060 = args33058.length;
switch (G__33060) {
case 2:
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33058.length)].join('')));

}
});

camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2 = (function (x_url,cb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_33085){
var state_val_33086 = (state_33085[(1)]);
if((state_val_33086 === (1))){
var inst_33061 = camelot.util.misc.with_baseurl(x_url);
var inst_33062 = camelot.util.transit.request(cljs_http.client.delete$,inst_33061,null);
var state_33085__$1 = state_33085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33085__$1,(2),inst_33062);
} else {
if((state_val_33086 === (2))){
var inst_33064 = (state_33085[(7)]);
var inst_33064__$1 = (state_33085[(2)]);
var inst_33065 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33064__$1);
var inst_33066 = [inst_33065];
var inst_33067 = cljs.core.PersistentHashSet.fromArray(inst_33066,true);
var inst_33068 = cljs.core.some(inst_33067,camelot.rest.success_status_codes);
var state_33085__$1 = (function (){var statearr_33087 = state_33085;
(statearr_33087[(7)] = inst_33064__$1);

return statearr_33087;
})();
if(cljs.core.truth_(inst_33068)){
var statearr_33088_33149 = state_33085__$1;
(statearr_33088_33149[(1)] = (3));

} else {
var statearr_33089_33150 = state_33085__$1;
(statearr_33089_33150[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33086 === (3))){
var state_33085__$1 = state_33085;
if(cljs.core.truth_(cb)){
var statearr_33090_33151 = state_33085__$1;
(statearr_33090_33151[(1)] = (6));

} else {
var statearr_33091_33152 = state_33085__$1;
(statearr_33091_33152[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33086 === (4))){
var inst_33064 = (state_33085[(7)]);
var inst_33076 = camelot.state.display_state();
var inst_33077 = camelot.util.misc.with_baseurl(x_url);
var inst_33078 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33064);
var inst_33079 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_33064);
var inst_33080 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4("DELETE",inst_33077,inst_33078,inst_33079);
var inst_33081 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33076,cljs.core.cst$kw$error,inst_33080);
var state_33085__$1 = state_33085;
var statearr_33092_33153 = state_33085__$1;
(statearr_33092_33153[(2)] = inst_33081);

(statearr_33092_33153[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33086 === (5))){
var inst_33083 = (state_33085[(2)]);
var state_33085__$1 = state_33085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33085__$1,inst_33083);
} else {
if((state_val_33086 === (6))){
var inst_33064 = (state_33085[(7)]);
var inst_33071 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_33064) : cb.call(null,inst_33064));
var state_33085__$1 = state_33085;
var statearr_33093_33154 = state_33085__$1;
(statearr_33093_33154[(2)] = inst_33071);

(statearr_33093_33154[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33086 === (7))){
var state_33085__$1 = state_33085;
var statearr_33094_33155 = state_33085__$1;
(statearr_33094_33155[(2)] = null);

(statearr_33094_33155[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33086 === (8))){
var inst_33074 = (state_33085[(2)]);
var state_33085__$1 = state_33085;
var statearr_33095_33156 = state_33085__$1;
(statearr_33095_33156[(2)] = inst_33074);

(statearr_33095_33156[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$state_machine__28453__auto__ = null;
var camelot$rest$state_machine__28453__auto____0 = (function (){
var statearr_33099 = [null,null,null,null,null,null,null,null];
(statearr_33099[(0)] = camelot$rest$state_machine__28453__auto__);

(statearr_33099[(1)] = (1));

return statearr_33099;
});
var camelot$rest$state_machine__28453__auto____1 = (function (state_33085){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_33085);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e33100){if((e33100 instanceof Object)){
var ex__28456__auto__ = e33100;
var statearr_33101_33157 = state_33085;
(statearr_33101_33157[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33085);

return cljs.core.cst$kw$recur;
} else {
throw e33100;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__33158 = state_33085;
state_33085 = G__33158;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$state_machine__28453__auto__ = function(state_33085){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$state_machine__28453__auto____1.call(this,state_33085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__28453__auto____0;
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__28453__auto____1;
return camelot$rest$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_33102 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_33102[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_33102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});

camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$3 = (function (x_url,params,cb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_33127){
var state_val_33128 = (state_33127[(1)]);
if((state_val_33128 === (1))){
var inst_33103 = camelot.util.misc.with_baseurl(x_url);
var inst_33104 = camelot.util.transit.request(cljs_http.client.delete$,inst_33103,params);
var state_33127__$1 = state_33127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33127__$1,(2),inst_33104);
} else {
if((state_val_33128 === (2))){
var inst_33106 = (state_33127[(7)]);
var inst_33106__$1 = (state_33127[(2)]);
var inst_33107 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33106__$1);
var inst_33108 = [inst_33107];
var inst_33109 = cljs.core.PersistentHashSet.fromArray(inst_33108,true);
var inst_33110 = cljs.core.some(inst_33109,camelot.rest.success_status_codes);
var state_33127__$1 = (function (){var statearr_33129 = state_33127;
(statearr_33129[(7)] = inst_33106__$1);

return statearr_33129;
})();
if(cljs.core.truth_(inst_33110)){
var statearr_33130_33159 = state_33127__$1;
(statearr_33130_33159[(1)] = (3));

} else {
var statearr_33131_33160 = state_33127__$1;
(statearr_33131_33160[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (3))){
var state_33127__$1 = state_33127;
if(cljs.core.truth_(cb)){
var statearr_33132_33161 = state_33127__$1;
(statearr_33132_33161[(1)] = (6));

} else {
var statearr_33133_33162 = state_33127__$1;
(statearr_33133_33162[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (4))){
var inst_33106 = (state_33127[(7)]);
var inst_33118 = camelot.state.display_state();
var inst_33119 = camelot.util.misc.with_baseurl(x_url);
var inst_33120 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33106);
var inst_33121 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_33106);
var inst_33122 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("DELETE",inst_33119,params,inst_33120,inst_33121);
var inst_33123 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33118,cljs.core.cst$kw$error,inst_33122);
var state_33127__$1 = state_33127;
var statearr_33134_33163 = state_33127__$1;
(statearr_33134_33163[(2)] = inst_33123);

(statearr_33134_33163[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (5))){
var inst_33125 = (state_33127[(2)]);
var state_33127__$1 = state_33127;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33127__$1,inst_33125);
} else {
if((state_val_33128 === (6))){
var inst_33106 = (state_33127[(7)]);
var inst_33113 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_33106) : cb.call(null,inst_33106));
var state_33127__$1 = state_33127;
var statearr_33135_33164 = state_33127__$1;
(statearr_33135_33164[(2)] = inst_33113);

(statearr_33135_33164[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (7))){
var state_33127__$1 = state_33127;
var statearr_33136_33165 = state_33127__$1;
(statearr_33136_33165[(2)] = null);

(statearr_33136_33165[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33128 === (8))){
var inst_33116 = (state_33127[(2)]);
var state_33127__$1 = state_33127;
var statearr_33137_33166 = state_33127__$1;
(statearr_33137_33166[(2)] = inst_33116);

(statearr_33137_33166[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$state_machine__28453__auto__ = null;
var camelot$rest$state_machine__28453__auto____0 = (function (){
var statearr_33141 = [null,null,null,null,null,null,null,null];
(statearr_33141[(0)] = camelot$rest$state_machine__28453__auto__);

(statearr_33141[(1)] = (1));

return statearr_33141;
});
var camelot$rest$state_machine__28453__auto____1 = (function (state_33127){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_33127);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e33142){if((e33142 instanceof Object)){
var ex__28456__auto__ = e33142;
var statearr_33143_33167 = state_33127;
(statearr_33143_33167[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33127);

return cljs.core.cst$kw$recur;
} else {
throw e33142;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__33168 = state_33127;
state_33127 = G__33168;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$state_machine__28453__auto__ = function(state_33127){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$state_machine__28453__auto____1.call(this,state_33127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__28453__auto____0;
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__28453__auto____1;
return camelot$rest$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_33144 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_33144[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_33144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});

camelot.rest.delete_x.cljs$lang$maxFixedArity = 3;

/**
 * POST state
 */
camelot.rest.post_x_opts = (function camelot$rest$post_x_opts(resource,params,p__33169){
var map__33245 = p__33169;
var map__33245__$1 = ((((!((map__33245 == null)))?((((map__33245.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33245.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33245):map__33245);
var success = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33245__$1,cljs.core.cst$kw$success);
var failure = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33245__$1,cljs.core.cst$kw$failure);
var suppress_error_dialog = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33245__$1,cljs.core.cst$kw$suppress_DASH_error_DASH_dialog);
var always = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33245__$1,cljs.core.cst$kw$always);
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,map__33245,map__33245__$1,success,failure,suppress_error_dialog,always){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,map__33245,map__33245__$1,success,failure,suppress_error_dialog,always){
return (function (state_33288){
var state_val_33289 = (state_33288[(1)]);
if((state_val_33289 === (7))){
var state_33288__$1 = state_33288;
var statearr_33290_33320 = state_33288__$1;
(statearr_33290_33320[(2)] = null);

(statearr_33290_33320[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (1))){
var inst_33247 = camelot.util.misc.with_baseurl(resource);
var inst_33248 = [cljs.core.cst$kw$data];
var inst_33249 = [params];
var inst_33250 = cljs.core.PersistentHashMap.fromArrays(inst_33248,inst_33249);
var inst_33251 = camelot.util.transit.request(cljs_http.client.post,inst_33247,inst_33250);
var state_33288__$1 = state_33288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33288__$1,(2),inst_33251);
} else {
if((state_val_33289 === (4))){
var state_33288__$1 = state_33288;
if(cljs.core.truth_(failure)){
var statearr_33291_33321 = state_33288__$1;
(statearr_33291_33321[(1)] = (9));

} else {
var statearr_33292_33322 = state_33288__$1;
(statearr_33292_33322[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (15))){
var inst_33253 = (state_33288[(7)]);
var inst_33283 = (always.cljs$core$IFn$_invoke$arity$1 ? always.cljs$core$IFn$_invoke$arity$1(inst_33253) : always.call(null,inst_33253));
var state_33288__$1 = state_33288;
var statearr_33293_33323 = state_33288__$1;
(statearr_33293_33323[(2)] = inst_33283);

(statearr_33293_33323[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (13))){
var inst_33253 = (state_33288[(7)]);
var inst_33272 = camelot.state.display_state();
var inst_33273 = camelot.util.misc.with_baseurl(resource);
var inst_33274 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33253);
var inst_33275 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_33253);
var inst_33276 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("POST",inst_33273,params,inst_33274,inst_33275);
var inst_33277 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33272,cljs.core.cst$kw$error,inst_33276);
var state_33288__$1 = state_33288;
var statearr_33294_33324 = state_33288__$1;
(statearr_33294_33324[(2)] = inst_33277);

(statearr_33294_33324[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (6))){
var inst_33253 = (state_33288[(7)]);
var inst_33260 = (success.cljs$core$IFn$_invoke$arity$1 ? success.cljs$core$IFn$_invoke$arity$1(inst_33253) : success.call(null,inst_33253));
var state_33288__$1 = state_33288;
var statearr_33295_33325 = state_33288__$1;
(statearr_33295_33325[(2)] = inst_33260);

(statearr_33295_33325[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (17))){
var inst_33286 = (state_33288[(2)]);
var state_33288__$1 = state_33288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33288__$1,inst_33286);
} else {
if((state_val_33289 === (3))){
var state_33288__$1 = state_33288;
if(cljs.core.truth_(success)){
var statearr_33296_33326 = state_33288__$1;
(statearr_33296_33326[(1)] = (6));

} else {
var statearr_33297_33327 = state_33288__$1;
(statearr_33297_33327[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (12))){
var state_33288__$1 = state_33288;
var statearr_33298_33328 = state_33288__$1;
(statearr_33298_33328[(2)] = null);

(statearr_33298_33328[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (2))){
var inst_33253 = (state_33288[(7)]);
var inst_33253__$1 = (state_33288[(2)]);
var inst_33254 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33253__$1);
var inst_33255 = [inst_33254];
var inst_33256 = cljs.core.PersistentHashSet.fromArray(inst_33255,true);
var inst_33257 = cljs.core.some(inst_33256,camelot.rest.success_status_codes);
var state_33288__$1 = (function (){var statearr_33299 = state_33288;
(statearr_33299[(7)] = inst_33253__$1);

return statearr_33299;
})();
if(cljs.core.truth_(inst_33257)){
var statearr_33300_33329 = state_33288__$1;
(statearr_33300_33329[(1)] = (3));

} else {
var statearr_33301_33330 = state_33288__$1;
(statearr_33301_33330[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (11))){
var inst_33269 = (state_33288[(2)]);
var state_33288__$1 = (function (){var statearr_33302 = state_33288;
(statearr_33302[(8)] = inst_33269);

return statearr_33302;
})();
if(cljs.core.truth_(suppress_error_dialog)){
var statearr_33303_33331 = state_33288__$1;
(statearr_33303_33331[(1)] = (12));

} else {
var statearr_33304_33332 = state_33288__$1;
(statearr_33304_33332[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (9))){
var inst_33253 = (state_33288[(7)]);
var inst_33266 = (failure.cljs$core$IFn$_invoke$arity$1 ? failure.cljs$core$IFn$_invoke$arity$1(inst_33253) : failure.call(null,inst_33253));
var state_33288__$1 = state_33288;
var statearr_33305_33333 = state_33288__$1;
(statearr_33305_33333[(2)] = inst_33266);

(statearr_33305_33333[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (5))){
var inst_33281 = (state_33288[(2)]);
var state_33288__$1 = (function (){var statearr_33306 = state_33288;
(statearr_33306[(9)] = inst_33281);

return statearr_33306;
})();
if(cljs.core.truth_(always)){
var statearr_33307_33334 = state_33288__$1;
(statearr_33307_33334[(1)] = (15));

} else {
var statearr_33308_33335 = state_33288__$1;
(statearr_33308_33335[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (14))){
var inst_33279 = (state_33288[(2)]);
var state_33288__$1 = state_33288;
var statearr_33309_33336 = state_33288__$1;
(statearr_33309_33336[(2)] = inst_33279);

(statearr_33309_33336[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (16))){
var state_33288__$1 = state_33288;
var statearr_33310_33337 = state_33288__$1;
(statearr_33310_33337[(2)] = null);

(statearr_33310_33337[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (10))){
var state_33288__$1 = state_33288;
var statearr_33311_33338 = state_33288__$1;
(statearr_33311_33338[(2)] = null);

(statearr_33311_33338[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (8))){
var inst_33263 = (state_33288[(2)]);
var state_33288__$1 = state_33288;
var statearr_33312_33339 = state_33288__$1;
(statearr_33312_33339[(2)] = inst_33263);

(statearr_33312_33339[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__,map__33245,map__33245__$1,success,failure,suppress_error_dialog,always))
;
return ((function (switch__28452__auto__,c__28576__auto__,map__33245,map__33245__$1,success,failure,suppress_error_dialog,always){
return (function() {
var camelot$rest$post_x_opts_$_state_machine__28453__auto__ = null;
var camelot$rest$post_x_opts_$_state_machine__28453__auto____0 = (function (){
var statearr_33316 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33316[(0)] = camelot$rest$post_x_opts_$_state_machine__28453__auto__);

(statearr_33316[(1)] = (1));

return statearr_33316;
});
var camelot$rest$post_x_opts_$_state_machine__28453__auto____1 = (function (state_33288){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_33288);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e33317){if((e33317 instanceof Object)){
var ex__28456__auto__ = e33317;
var statearr_33318_33340 = state_33288;
(statearr_33318_33340[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33288);

return cljs.core.cst$kw$recur;
} else {
throw e33317;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__33341 = state_33288;
state_33288 = G__33341;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$post_x_opts_$_state_machine__28453__auto__ = function(state_33288){
switch(arguments.length){
case 0:
return camelot$rest$post_x_opts_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$post_x_opts_$_state_machine__28453__auto____1.call(this,state_33288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$post_x_opts_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$post_x_opts_$_state_machine__28453__auto____0;
camelot$rest$post_x_opts_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$post_x_opts_$_state_machine__28453__auto____1;
return camelot$rest$post_x_opts_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,map__33245,map__33245__$1,success,failure,suppress_error_dialog,always))
})();
var state__28578__auto__ = (function (){var statearr_33319 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_33319[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_33319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,map__33245,map__33245__$1,success,failure,suppress_error_dialog,always))
);

return c__28576__auto__;
});
/**
 * POST state
 */
camelot.rest.post_x = (function camelot$rest$post_x(var_args){
var args33342 = [];
var len__7492__auto___33345 = arguments.length;
var i__7493__auto___33346 = (0);
while(true){
if((i__7493__auto___33346 < len__7492__auto___33345)){
args33342.push((arguments[i__7493__auto___33346]));

var G__33347 = (i__7493__auto___33346 + (1));
i__7493__auto___33346 = G__33347;
continue;
} else {
}
break;
}

var G__33344 = args33342.length;
switch (G__33344) {
case 3:
return camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return camelot.rest.post_x.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33342.length)].join('')));

}
});

camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3 = (function (resource,params,cb){
return camelot.rest.post_x_opts(resource,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(params),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$success,cb], null));
});

camelot.rest.post_x.cljs$core$IFn$_invoke$arity$4 = (function (resource,params,cb,failcb){
return camelot.rest.post_x_opts(resource,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(params),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$success,cb,cljs.core.cst$kw$failure,failcb,cljs.core.cst$kw$suppress_DASH_error_DASH_dialog,true], null));
});

camelot.rest.post_x.cljs$lang$maxFixedArity = 4;

/**
 * POST state
 */
camelot.rest.post_x_raw = (function camelot$rest$post_x_raw(var_args){
var args33349 = [];
var len__7492__auto___33406 = arguments.length;
var i__7493__auto___33407 = (0);
while(true){
if((i__7493__auto___33407 < len__7492__auto___33406)){
args33349.push((arguments[i__7493__auto___33407]));

var G__33408 = (i__7493__auto___33407 + (1));
i__7493__auto___33407 = G__33408;
continue;
} else {
}
break;
}

var G__33351 = args33349.length;
switch (G__33351) {
case 3:
return camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33349.length)].join('')));

}
});

camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$3 = (function (resource,params,cb){
return camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$4(resource,params,cb,null);
});

camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$4 = (function (resource,params,cb,failcb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_33384){
var state_val_33385 = (state_33384[(1)]);
if((state_val_33385 === (7))){
var state_33384__$1 = state_33384;
var statearr_33386_33410 = state_33384__$1;
(statearr_33386_33410[(2)] = null);

(statearr_33386_33410[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33385 === (1))){
var inst_33352 = camelot.util.misc.with_baseurl(resource);
var inst_33353 = [cljs.core.cst$kw$multipart_DASH_params];
var inst_33354 = [params];
var inst_33355 = cljs.core.PersistentHashMap.fromArrays(inst_33353,inst_33354);
var inst_33356 = cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(inst_33352,cljs.core.array_seq([inst_33355], 0));
var state_33384__$1 = state_33384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33384__$1,(2),inst_33356);
} else {
if((state_val_33385 === (4))){
var state_33384__$1 = state_33384;
if(cljs.core.truth_(failcb)){
var statearr_33387_33411 = state_33384__$1;
(statearr_33387_33411[(1)] = (9));

} else {
var statearr_33388_33412 = state_33384__$1;
(statearr_33388_33412[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33385 === (6))){
var inst_33358 = (state_33384[(7)]);
var inst_33365 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_33358) : cb.call(null,inst_33358));
var state_33384__$1 = state_33384;
var statearr_33389_33413 = state_33384__$1;
(statearr_33389_33413[(2)] = inst_33365);

(statearr_33389_33413[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33385 === (3))){
var state_33384__$1 = state_33384;
if(cljs.core.truth_(cb)){
var statearr_33390_33414 = state_33384__$1;
(statearr_33390_33414[(1)] = (6));

} else {
var statearr_33391_33415 = state_33384__$1;
(statearr_33391_33415[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33385 === (2))){
var inst_33358 = (state_33384[(7)]);
var inst_33358__$1 = (state_33384[(2)]);
var inst_33359 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33358__$1);
var inst_33360 = [inst_33359];
var inst_33361 = cljs.core.PersistentHashSet.fromArray(inst_33360,true);
var inst_33362 = cljs.core.some(inst_33361,camelot.rest.success_status_codes);
var state_33384__$1 = (function (){var statearr_33392 = state_33384;
(statearr_33392[(7)] = inst_33358__$1);

return statearr_33392;
})();
if(cljs.core.truth_(inst_33362)){
var statearr_33393_33416 = state_33384__$1;
(statearr_33393_33416[(1)] = (3));

} else {
var statearr_33394_33417 = state_33384__$1;
(statearr_33394_33417[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33385 === (11))){
var inst_33380 = (state_33384[(2)]);
var state_33384__$1 = state_33384;
var statearr_33395_33418 = state_33384__$1;
(statearr_33395_33418[(2)] = inst_33380);

(statearr_33395_33418[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33385 === (9))){
var inst_33371 = (failcb.cljs$core$IFn$_invoke$arity$0 ? failcb.cljs$core$IFn$_invoke$arity$0() : failcb.call(null));
var state_33384__$1 = state_33384;
var statearr_33396_33419 = state_33384__$1;
(statearr_33396_33419[(2)] = inst_33371);

(statearr_33396_33419[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33385 === (5))){
var inst_33382 = (state_33384[(2)]);
var state_33384__$1 = state_33384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33384__$1,inst_33382);
} else {
if((state_val_33385 === (10))){
var inst_33358 = (state_33384[(7)]);
var inst_33373 = camelot.state.display_state();
var inst_33374 = camelot.util.misc.with_baseurl(resource);
var inst_33375 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33358);
var inst_33376 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_33358);
var inst_33377 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("POST",inst_33374,params,inst_33375,inst_33376);
var inst_33378 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33373,cljs.core.cst$kw$error,inst_33377);
var state_33384__$1 = state_33384;
var statearr_33397_33420 = state_33384__$1;
(statearr_33397_33420[(2)] = inst_33378);

(statearr_33397_33420[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33385 === (8))){
var inst_33368 = (state_33384[(2)]);
var state_33384__$1 = state_33384;
var statearr_33398_33421 = state_33384__$1;
(statearr_33398_33421[(2)] = inst_33368);

(statearr_33398_33421[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$state_machine__28453__auto__ = null;
var camelot$rest$state_machine__28453__auto____0 = (function (){
var statearr_33402 = [null,null,null,null,null,null,null,null];
(statearr_33402[(0)] = camelot$rest$state_machine__28453__auto__);

(statearr_33402[(1)] = (1));

return statearr_33402;
});
var camelot$rest$state_machine__28453__auto____1 = (function (state_33384){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_33384);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e33403){if((e33403 instanceof Object)){
var ex__28456__auto__ = e33403;
var statearr_33404_33422 = state_33384;
(statearr_33404_33422[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33384);

return cljs.core.cst$kw$recur;
} else {
throw e33403;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__33423 = state_33384;
state_33384 = G__33423;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$state_machine__28453__auto__ = function(state_33384){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$state_machine__28453__auto____1.call(this,state_33384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__28453__auto____0;
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__28453__auto____1;
return camelot$rest$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_33405 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_33405[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_33405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});

camelot.rest.post_x_raw.cljs$lang$maxFixedArity = 4;

/**
 * PUT state
 */
camelot.rest.put_x = (function camelot$rest$put_x(var_args){
var args33424 = [];
var len__7492__auto___33479 = arguments.length;
var i__7493__auto___33480 = (0);
while(true){
if((i__7493__auto___33480 < len__7492__auto___33479)){
args33424.push((arguments[i__7493__auto___33480]));

var G__33481 = (i__7493__auto___33480 + (1));
i__7493__auto___33480 = G__33481;
continue;
} else {
}
break;
}

var G__33426 = args33424.length;
switch (G__33426) {
case 3:
return camelot.rest.put_x.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return camelot.rest.put_x.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33424.length)].join('')));

}
});

camelot.rest.put_x.cljs$core$IFn$_invoke$arity$3 = (function (resource,params,cb){
return camelot.rest.put_x.cljs$core$IFn$_invoke$arity$4(resource,params,cb,null);
});

camelot.rest.put_x.cljs$core$IFn$_invoke$arity$4 = (function (resource,params,cb,failcb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_33456){
var state_val_33457 = (state_33456[(1)]);
if((state_val_33457 === (7))){
var state_33456__$1 = state_33456;
var statearr_33458_33483 = state_33456__$1;
(statearr_33458_33483[(2)] = null);

(statearr_33458_33483[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33457 === (1))){
var inst_33427 = camelot.util.misc.with_baseurl(resource);
var inst_33428 = camelot.util.transit.request(cljs_http.client.put,inst_33427,params);
var state_33456__$1 = state_33456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33456__$1,(2),inst_33428);
} else {
if((state_val_33457 === (4))){
var state_33456__$1 = state_33456;
if(cljs.core.truth_(failcb)){
var statearr_33459_33484 = state_33456__$1;
(statearr_33459_33484[(1)] = (9));

} else {
var statearr_33460_33485 = state_33456__$1;
(statearr_33460_33485[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33457 === (6))){
var inst_33430 = (state_33456[(7)]);
var inst_33437 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_33430) : cb.call(null,inst_33430));
var state_33456__$1 = state_33456;
var statearr_33461_33486 = state_33456__$1;
(statearr_33461_33486[(2)] = inst_33437);

(statearr_33461_33486[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33457 === (3))){
var state_33456__$1 = state_33456;
if(cljs.core.truth_(cb)){
var statearr_33462_33487 = state_33456__$1;
(statearr_33462_33487[(1)] = (6));

} else {
var statearr_33463_33488 = state_33456__$1;
(statearr_33463_33488[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33457 === (2))){
var inst_33430 = (state_33456[(7)]);
var inst_33430__$1 = (state_33456[(2)]);
var inst_33431 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33430__$1);
var inst_33432 = [inst_33431];
var inst_33433 = cljs.core.PersistentHashSet.fromArray(inst_33432,true);
var inst_33434 = cljs.core.some(inst_33433,camelot.rest.success_status_codes);
var state_33456__$1 = (function (){var statearr_33464 = state_33456;
(statearr_33464[(7)] = inst_33430__$1);

return statearr_33464;
})();
if(cljs.core.truth_(inst_33434)){
var statearr_33465_33489 = state_33456__$1;
(statearr_33465_33489[(1)] = (3));

} else {
var statearr_33466_33490 = state_33456__$1;
(statearr_33466_33490[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33457 === (11))){
var inst_33430 = (state_33456[(7)]);
var inst_33446 = (state_33456[(2)]);
var inst_33447 = camelot.state.display_state();
var inst_33448 = camelot.util.misc.with_baseurl(resource);
var inst_33449 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33430);
var inst_33450 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_33430);
var inst_33451 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("PUT",inst_33448,params,inst_33449,inst_33450);
var inst_33452 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33447,cljs.core.cst$kw$error,inst_33451);
var state_33456__$1 = (function (){var statearr_33467 = state_33456;
(statearr_33467[(8)] = inst_33446);

return statearr_33467;
})();
var statearr_33468_33491 = state_33456__$1;
(statearr_33468_33491[(2)] = inst_33452);

(statearr_33468_33491[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33457 === (9))){
var inst_33443 = (failcb.cljs$core$IFn$_invoke$arity$0 ? failcb.cljs$core$IFn$_invoke$arity$0() : failcb.call(null));
var state_33456__$1 = state_33456;
var statearr_33469_33492 = state_33456__$1;
(statearr_33469_33492[(2)] = inst_33443);

(statearr_33469_33492[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33457 === (5))){
var inst_33454 = (state_33456[(2)]);
var state_33456__$1 = state_33456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33456__$1,inst_33454);
} else {
if((state_val_33457 === (10))){
var state_33456__$1 = state_33456;
var statearr_33470_33493 = state_33456__$1;
(statearr_33470_33493[(2)] = null);

(statearr_33470_33493[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33457 === (8))){
var inst_33440 = (state_33456[(2)]);
var state_33456__$1 = state_33456;
var statearr_33471_33494 = state_33456__$1;
(statearr_33471_33494[(2)] = inst_33440);

(statearr_33471_33494[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$state_machine__28453__auto__ = null;
var camelot$rest$state_machine__28453__auto____0 = (function (){
var statearr_33475 = [null,null,null,null,null,null,null,null,null];
(statearr_33475[(0)] = camelot$rest$state_machine__28453__auto__);

(statearr_33475[(1)] = (1));

return statearr_33475;
});
var camelot$rest$state_machine__28453__auto____1 = (function (state_33456){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_33456);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e33476){if((e33476 instanceof Object)){
var ex__28456__auto__ = e33476;
var statearr_33477_33495 = state_33456;
(statearr_33477_33495[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33456);

return cljs.core.cst$kw$recur;
} else {
throw e33476;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__33496 = state_33456;
state_33456 = G__33496;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$state_machine__28453__auto__ = function(state_33456){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$state_machine__28453__auto____1.call(this,state_33456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__28453__auto____0;
camelot$rest$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__28453__auto____1;
return camelot$rest$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_33478 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_33478[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_33478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});

camelot.rest.put_x.cljs$lang$maxFixedArity = 4;

/**
 * Retrieve global application details
 */
camelot.rest.get_application = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.rest.get_x,"/application");
/**
 * Retrieve screens
 */
camelot.rest.get_screens = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.rest.get_x,"/screens");
/**
 * Retrieve configuration
 */
camelot.rest.get_configuration = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.rest.get_x,"/settings");
/**
 * GET resource state
 */
camelot.rest.get_resource = (function camelot$rest$get_resource(resource,cb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_33563){
var state_val_33564 = (state_33563[(1)]);
if((state_val_33564 === (1))){
var inst_33539 = camelot.util.misc.with_baseurl(resource);
var inst_33540 = camelot.util.transit.request(cljs_http.client.get,inst_33539,null);
var state_33563__$1 = state_33563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33563__$1,(2),inst_33540);
} else {
if((state_val_33564 === (2))){
var inst_33542 = (state_33563[(7)]);
var inst_33542__$1 = (state_33563[(2)]);
var inst_33543 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33542__$1);
var inst_33544 = [inst_33543];
var inst_33545 = cljs.core.PersistentHashSet.fromArray(inst_33544,true);
var inst_33546 = cljs.core.some(inst_33545,camelot.rest.success_status_codes);
var state_33563__$1 = (function (){var statearr_33565 = state_33563;
(statearr_33565[(7)] = inst_33542__$1);

return statearr_33565;
})();
if(cljs.core.truth_(inst_33546)){
var statearr_33566_33581 = state_33563__$1;
(statearr_33566_33581[(1)] = (3));

} else {
var statearr_33567_33582 = state_33563__$1;
(statearr_33567_33582[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (3))){
var state_33563__$1 = state_33563;
if(cljs.core.truth_(cb)){
var statearr_33568_33583 = state_33563__$1;
(statearr_33568_33583[(1)] = (6));

} else {
var statearr_33569_33584 = state_33563__$1;
(statearr_33569_33584[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (4))){
var inst_33542 = (state_33563[(7)]);
var inst_33554 = camelot.state.display_state();
var inst_33555 = camelot.util.misc.with_baseurl(resource);
var inst_33556 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33542);
var inst_33557 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_33542);
var inst_33558 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4("GET",inst_33555,inst_33556,inst_33557);
var inst_33559 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33554,cljs.core.cst$kw$error,inst_33558);
var state_33563__$1 = state_33563;
var statearr_33570_33585 = state_33563__$1;
(statearr_33570_33585[(2)] = inst_33559);

(statearr_33570_33585[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (5))){
var inst_33561 = (state_33563[(2)]);
var state_33563__$1 = state_33563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33563__$1,inst_33561);
} else {
if((state_val_33564 === (6))){
var inst_33542 = (state_33563[(7)]);
var inst_33549 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_33542) : cb.call(null,inst_33542));
var state_33563__$1 = state_33563;
var statearr_33571_33586 = state_33563__$1;
(statearr_33571_33586[(2)] = inst_33549);

(statearr_33571_33586[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (7))){
var state_33563__$1 = state_33563;
var statearr_33572_33587 = state_33563__$1;
(statearr_33572_33587[(2)] = null);

(statearr_33572_33587[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (8))){
var inst_33552 = (state_33563[(2)]);
var state_33563__$1 = state_33563;
var statearr_33573_33588 = state_33563__$1;
(statearr_33573_33588[(2)] = inst_33552);

(statearr_33573_33588[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$get_resource_$_state_machine__28453__auto__ = null;
var camelot$rest$get_resource_$_state_machine__28453__auto____0 = (function (){
var statearr_33577 = [null,null,null,null,null,null,null,null];
(statearr_33577[(0)] = camelot$rest$get_resource_$_state_machine__28453__auto__);

(statearr_33577[(1)] = (1));

return statearr_33577;
});
var camelot$rest$get_resource_$_state_machine__28453__auto____1 = (function (state_33563){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_33563);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e33578){if((e33578 instanceof Object)){
var ex__28456__auto__ = e33578;
var statearr_33579_33589 = state_33563;
(statearr_33579_33589[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33563);

return cljs.core.cst$kw$recur;
} else {
throw e33578;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__33590 = state_33563;
state_33563 = G__33590;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$get_resource_$_state_machine__28453__auto__ = function(state_33563){
switch(arguments.length){
case 0:
return camelot$rest$get_resource_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$get_resource_$_state_machine__28453__auto____1.call(this,state_33563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$get_resource_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$get_resource_$_state_machine__28453__auto____0;
camelot$rest$get_resource_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$get_resource_$_state_machine__28453__auto____1;
return camelot$rest$get_resource_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_33580 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_33580[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_33580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});
/**
 * PUT resource state
 */
camelot.rest.put_resource = (function camelot$rest$put_resource(resource,params,cb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_33657){
var state_val_33658 = (state_33657[(1)]);
if((state_val_33658 === (1))){
var inst_33633 = camelot.util.misc.with_baseurl(resource);
var inst_33634 = camelot.util.transit.request(cljs_http.client.put,inst_33633,params);
var state_33657__$1 = state_33657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33657__$1,(2),inst_33634);
} else {
if((state_val_33658 === (2))){
var inst_33636 = (state_33657[(7)]);
var inst_33636__$1 = (state_33657[(2)]);
var inst_33637 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33636__$1);
var inst_33638 = [inst_33637];
var inst_33639 = cljs.core.PersistentHashSet.fromArray(inst_33638,true);
var inst_33640 = cljs.core.some(inst_33639,camelot.rest.success_status_codes);
var state_33657__$1 = (function (){var statearr_33659 = state_33657;
(statearr_33659[(7)] = inst_33636__$1);

return statearr_33659;
})();
if(cljs.core.truth_(inst_33640)){
var statearr_33660_33675 = state_33657__$1;
(statearr_33660_33675[(1)] = (3));

} else {
var statearr_33661_33676 = state_33657__$1;
(statearr_33661_33676[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (3))){
var state_33657__$1 = state_33657;
if(cljs.core.truth_(cb)){
var statearr_33662_33677 = state_33657__$1;
(statearr_33662_33677[(1)] = (6));

} else {
var statearr_33663_33678 = state_33657__$1;
(statearr_33663_33678[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (4))){
var inst_33636 = (state_33657[(7)]);
var inst_33648 = camelot.state.display_state();
var inst_33649 = camelot.util.misc.with_baseurl(resource);
var inst_33650 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33636);
var inst_33651 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_33636);
var inst_33652 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("PUT",inst_33649,params,inst_33650,inst_33651);
var inst_33653 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33648,cljs.core.cst$kw$error,inst_33652);
var state_33657__$1 = state_33657;
var statearr_33664_33679 = state_33657__$1;
(statearr_33664_33679[(2)] = inst_33653);

(statearr_33664_33679[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (5))){
var inst_33655 = (state_33657[(2)]);
var state_33657__$1 = state_33657;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33657__$1,inst_33655);
} else {
if((state_val_33658 === (6))){
var inst_33636 = (state_33657[(7)]);
var inst_33643 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_33636) : cb.call(null,inst_33636));
var state_33657__$1 = state_33657;
var statearr_33665_33680 = state_33657__$1;
(statearr_33665_33680[(2)] = inst_33643);

(statearr_33665_33680[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (7))){
var state_33657__$1 = state_33657;
var statearr_33666_33681 = state_33657__$1;
(statearr_33666_33681[(2)] = null);

(statearr_33666_33681[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (8))){
var inst_33646 = (state_33657[(2)]);
var state_33657__$1 = state_33657;
var statearr_33667_33682 = state_33657__$1;
(statearr_33667_33682[(2)] = inst_33646);

(statearr_33667_33682[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$put_resource_$_state_machine__28453__auto__ = null;
var camelot$rest$put_resource_$_state_machine__28453__auto____0 = (function (){
var statearr_33671 = [null,null,null,null,null,null,null,null];
(statearr_33671[(0)] = camelot$rest$put_resource_$_state_machine__28453__auto__);

(statearr_33671[(1)] = (1));

return statearr_33671;
});
var camelot$rest$put_resource_$_state_machine__28453__auto____1 = (function (state_33657){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_33657);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e33672){if((e33672 instanceof Object)){
var ex__28456__auto__ = e33672;
var statearr_33673_33683 = state_33657;
(statearr_33673_33683[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33657);

return cljs.core.cst$kw$recur;
} else {
throw e33672;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__33684 = state_33657;
state_33657 = G__33684;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$put_resource_$_state_machine__28453__auto__ = function(state_33657){
switch(arguments.length){
case 0:
return camelot$rest$put_resource_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$put_resource_$_state_machine__28453__auto____1.call(this,state_33657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$put_resource_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$put_resource_$_state_machine__28453__auto____0;
camelot$rest$put_resource_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$put_resource_$_state_machine__28453__auto____1;
return camelot$rest$put_resource_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_33674 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_33674[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_33674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});
/**
 * POST resource state
 */
camelot.rest.post_resource = (function camelot$rest$post_resource(resource,params,cb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_33751){
var state_val_33752 = (state_33751[(1)]);
if((state_val_33752 === (1))){
var inst_33727 = camelot.util.misc.with_baseurl(resource);
var inst_33728 = camelot.util.transit.request(cljs_http.client.post,inst_33727,params);
var state_33751__$1 = state_33751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33751__$1,(2),inst_33728);
} else {
if((state_val_33752 === (2))){
var inst_33730 = (state_33751[(7)]);
var inst_33730__$1 = (state_33751[(2)]);
var inst_33731 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33730__$1);
var inst_33732 = [inst_33731];
var inst_33733 = cljs.core.PersistentHashSet.fromArray(inst_33732,true);
var inst_33734 = cljs.core.some(inst_33733,camelot.rest.success_status_codes);
var state_33751__$1 = (function (){var statearr_33753 = state_33751;
(statearr_33753[(7)] = inst_33730__$1);

return statearr_33753;
})();
if(cljs.core.truth_(inst_33734)){
var statearr_33754_33769 = state_33751__$1;
(statearr_33754_33769[(1)] = (3));

} else {
var statearr_33755_33770 = state_33751__$1;
(statearr_33755_33770[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33752 === (3))){
var state_33751__$1 = state_33751;
if(cljs.core.truth_(cb)){
var statearr_33756_33771 = state_33751__$1;
(statearr_33756_33771[(1)] = (6));

} else {
var statearr_33757_33772 = state_33751__$1;
(statearr_33757_33772[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33752 === (4))){
var inst_33730 = (state_33751[(7)]);
var inst_33742 = camelot.state.display_state();
var inst_33743 = camelot.util.misc.with_baseurl(resource);
var inst_33744 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33730);
var inst_33745 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_33730);
var inst_33746 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("POST",inst_33743,params,inst_33744,inst_33745);
var inst_33747 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33742,cljs.core.cst$kw$error,inst_33746);
var state_33751__$1 = state_33751;
var statearr_33758_33773 = state_33751__$1;
(statearr_33758_33773[(2)] = inst_33747);

(statearr_33758_33773[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33752 === (5))){
var inst_33749 = (state_33751[(2)]);
var state_33751__$1 = state_33751;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33751__$1,inst_33749);
} else {
if((state_val_33752 === (6))){
var inst_33730 = (state_33751[(7)]);
var inst_33737 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_33730) : cb.call(null,inst_33730));
var state_33751__$1 = state_33751;
var statearr_33759_33774 = state_33751__$1;
(statearr_33759_33774[(2)] = inst_33737);

(statearr_33759_33774[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33752 === (7))){
var state_33751__$1 = state_33751;
var statearr_33760_33775 = state_33751__$1;
(statearr_33760_33775[(2)] = null);

(statearr_33760_33775[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33752 === (8))){
var inst_33740 = (state_33751[(2)]);
var state_33751__$1 = state_33751;
var statearr_33761_33776 = state_33751__$1;
(statearr_33761_33776[(2)] = inst_33740);

(statearr_33761_33776[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$post_resource_$_state_machine__28453__auto__ = null;
var camelot$rest$post_resource_$_state_machine__28453__auto____0 = (function (){
var statearr_33765 = [null,null,null,null,null,null,null,null];
(statearr_33765[(0)] = camelot$rest$post_resource_$_state_machine__28453__auto__);

(statearr_33765[(1)] = (1));

return statearr_33765;
});
var camelot$rest$post_resource_$_state_machine__28453__auto____1 = (function (state_33751){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_33751);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e33766){if((e33766 instanceof Object)){
var ex__28456__auto__ = e33766;
var statearr_33767_33777 = state_33751;
(statearr_33767_33777[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33751);

return cljs.core.cst$kw$recur;
} else {
throw e33766;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__33778 = state_33751;
state_33751 = G__33778;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$post_resource_$_state_machine__28453__auto__ = function(state_33751){
switch(arguments.length){
case 0:
return camelot$rest$post_resource_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$post_resource_$_state_machine__28453__auto____1.call(this,state_33751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$post_resource_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$post_resource_$_state_machine__28453__auto____0;
camelot$rest$post_resource_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$post_resource_$_state_machine__28453__auto____1;
return camelot$rest$post_resource_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_33768 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_33768[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_33768;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});
/**
 * DELETE resource
 */
camelot.rest.delete_resource = (function camelot$rest$delete_resource(resource,params,cb){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_33845){
var state_val_33846 = (state_33845[(1)]);
if((state_val_33846 === (1))){
var inst_33821 = camelot.util.misc.with_baseurl(resource);
var inst_33822 = camelot.util.transit.request(cljs_http.client.delete$,inst_33821,params);
var state_33845__$1 = state_33845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33845__$1,(2),inst_33822);
} else {
if((state_val_33846 === (2))){
var inst_33824 = (state_33845[(7)]);
var inst_33824__$1 = (state_33845[(2)]);
var inst_33825 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33824__$1);
var inst_33826 = [inst_33825];
var inst_33827 = cljs.core.PersistentHashSet.fromArray(inst_33826,true);
var inst_33828 = cljs.core.some(inst_33827,camelot.rest.success_status_codes);
var state_33845__$1 = (function (){var statearr_33847 = state_33845;
(statearr_33847[(7)] = inst_33824__$1);

return statearr_33847;
})();
if(cljs.core.truth_(inst_33828)){
var statearr_33848_33863 = state_33845__$1;
(statearr_33848_33863[(1)] = (3));

} else {
var statearr_33849_33864 = state_33845__$1;
(statearr_33849_33864[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33846 === (3))){
var state_33845__$1 = state_33845;
if(cljs.core.truth_(cb)){
var statearr_33850_33865 = state_33845__$1;
(statearr_33850_33865[(1)] = (6));

} else {
var statearr_33851_33866 = state_33845__$1;
(statearr_33851_33866[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33846 === (4))){
var inst_33824 = (state_33845[(7)]);
var inst_33836 = camelot.state.display_state();
var inst_33837 = camelot.util.misc.with_baseurl(resource);
var inst_33838 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_33824);
var inst_33839 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_33824);
var inst_33840 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("DELETE",inst_33837,params,inst_33838,inst_33839);
var inst_33841 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33836,cljs.core.cst$kw$error,inst_33840);
var state_33845__$1 = state_33845;
var statearr_33852_33867 = state_33845__$1;
(statearr_33852_33867[(2)] = inst_33841);

(statearr_33852_33867[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33846 === (5))){
var inst_33843 = (state_33845[(2)]);
var state_33845__$1 = state_33845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33845__$1,inst_33843);
} else {
if((state_val_33846 === (6))){
var inst_33824 = (state_33845[(7)]);
var inst_33831 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_33824) : cb.call(null,inst_33824));
var state_33845__$1 = state_33845;
var statearr_33853_33868 = state_33845__$1;
(statearr_33853_33868[(2)] = inst_33831);

(statearr_33853_33868[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33846 === (7))){
var state_33845__$1 = state_33845;
var statearr_33854_33869 = state_33845__$1;
(statearr_33854_33869[(2)] = null);

(statearr_33854_33869[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33846 === (8))){
var inst_33834 = (state_33845[(2)]);
var state_33845__$1 = state_33845;
var statearr_33855_33870 = state_33845__$1;
(statearr_33855_33870[(2)] = inst_33834);

(statearr_33855_33870[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var camelot$rest$delete_resource_$_state_machine__28453__auto__ = null;
var camelot$rest$delete_resource_$_state_machine__28453__auto____0 = (function (){
var statearr_33859 = [null,null,null,null,null,null,null,null];
(statearr_33859[(0)] = camelot$rest$delete_resource_$_state_machine__28453__auto__);

(statearr_33859[(1)] = (1));

return statearr_33859;
});
var camelot$rest$delete_resource_$_state_machine__28453__auto____1 = (function (state_33845){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_33845);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e33860){if((e33860 instanceof Object)){
var ex__28456__auto__ = e33860;
var statearr_33861_33871 = state_33845;
(statearr_33861_33871[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33845);

return cljs.core.cst$kw$recur;
} else {
throw e33860;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__33872 = state_33845;
state_33845 = G__33872;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
camelot$rest$delete_resource_$_state_machine__28453__auto__ = function(state_33845){
switch(arguments.length){
case 0:
return camelot$rest$delete_resource_$_state_machine__28453__auto____0.call(this);
case 1:
return camelot$rest$delete_resource_$_state_machine__28453__auto____1.call(this,state_33845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
camelot$rest$delete_resource_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$delete_resource_$_state_machine__28453__auto____0;
camelot$rest$delete_resource_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$delete_resource_$_state_machine__28453__auto____1;
return camelot$rest$delete_resource_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_33862 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_33862[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_33862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});
