// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.util.data');
goog.require('cljs.core');
goog.require('clojure.string');
camelot.util.data.select_keys_inv = (function camelot$util$data$select_keys_inv(ks,data){
return cljs.core.select_keys(data,ks);
});
camelot.util.data.starts_with_QMARK_ = (function camelot$util$data$starts_with_QMARK_(prefix,s){
return cljs.core.re_matches(cljs.core.re_pattern([cljs.core.str("^"),cljs.core.str(prefix),cljs.core.str(".*")].join('')),s);
});
camelot.util.data.longest_prefix_match = (function camelot$util$data$longest_prefix_match(s,ps){
var G__38287 = ps;
var G__38287__$1 = (((G__38287 == null))?null:cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__38287){
return (function (p1__38285_SHARP_){
return camelot.util.data.starts_with_QMARK_(p1__38285_SHARP_,s);
});})(G__38287))
,G__38287));
var G__38287__$2 = (((G__38287__$1 == null))?null:cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.count,cljs.core._GT_,G__38287__$1));
if((G__38287__$2 == null)){
return null;
} else {
return cljs.core.first(G__38287__$2);
}
});
camelot.util.data.map_keys_reducer_fn = (function camelot$util$data$map_keys_reducer_fn(ks,acc,k,v){
if((cljs.core.contains_QMARK_(cljs.core.set(ks),k)) && (cljs.core.map_QMARK_(v))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([acc,cljs.core.reduce_kv((function (p1__38288_SHARP_,p2__38289_SHARP_,p3__38290_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__38288_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str(cljs.core.name(k)),cljs.core.str("-"),cljs.core.str(cljs.core.name(p2__38289_SHARP_))].join('')),p3__38290_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,v)], 0));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v);
}
});
camelot.util.data.map_keys_to_key_prefix = (function camelot$util$data$map_keys_to_key_prefix(d,ks){
return cljs.core.reduce_kv(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.util.data.map_keys_reducer_fn,ks),cljs.core.PersistentArrayMap.EMPTY,d);
});
camelot.util.data.strip_prefix = (function camelot$util$data$strip_prefix(p,s){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(p));
});
camelot.util.data.strip_key_prefix = (function camelot$util$data$strip_key_prefix(k,p){
var n = clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((function (p1__38291_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__38291_SHARP_,"-");
}),camelot.util.data.strip_prefix(p,cljs.core.name(k))));
if(cljs.core.seq(n)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(n);
} else {
return null;
}
});
camelot.util.data.key_prefix_reducer_fn = (function camelot$util$data$key_prefix_reducer_fn(ks,acc,k,v){
var m = camelot.util.data.longest_prefix_match(cljs.core.name(k),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,ks));
if(cljs.core.truth_(m)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(m),((function (m){
return (function (p1__38292_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__38292_SHARP_,camelot.util.data.strip_key_prefix(k,m),v);
});})(m))
);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v);
}
});
camelot.util.data.key_prefix_to_map = (function camelot$util$data$key_prefix_to_map(d,ks){
return cljs.core.reduce_kv(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.util.data.key_prefix_reducer_fn,ks),cljs.core.PersistentArrayMap.EMPTY,d);
});
/**
 * Predicate returning true if n is a natural number (zero incl.).
 */
camelot.util.data.nat_QMARK_ = (function camelot$util$data$nat_QMARK_(n){
return (typeof n === 'number') && (((n === (0))) || ((n > (0))));
});
