// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.util.deployment');
goog.require('cljs.core');
goog.require('schema.core');
goog.require('camelot.util.data');
camelot.util.deployment.assoc_cameras_for_group = (function camelot$util$deployment$assoc_cameras_for_group(p__38297){
var vec__38304 = p__38297;
var session_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38304,(0),null);
var group = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38304,(1),null);
var dissoc_list = ((function (vec__38304,session_id,group){
return (function (p1__38295_SHARP_,p2__38296_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,p1__38295_SHARP_,p2__38296_SHARP_);
});})(vec__38304,session_id,group))
;
var keys = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camera_DASH_id,cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$camera_DASH_status_DASH_id,cljs.core.cst$kw$camera_DASH_media_DASH_unrecoverable], null);
var vec__38307 = group;
var g1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38307,(0),null);
var g2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38307,(1),null);
return dissoc_list(camelot.util.data.map_keys_to_key_prefix(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([g1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$primary,cljs.core.select_keys(g1,keys)], null)], 0)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$secondary,cljs.core.select_keys(g2,keys)], null)], 0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$primary,cljs.core.cst$kw$secondary], null)),keys);
});
/**
 * Associate data for primary and secondary cameras.
 */
camelot.util.deployment.assoc_cameras = (function camelot$util$deployment$assoc_cameras(data){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(camelot.util.deployment.assoc_cameras_for_group,cljs.core.group_by(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_id,data));
});
/**
 * Convert primary and secondary camera data into a list of cameras, stripping the prefix.
 */
camelot.util.deployment.map_with_cameras_as_list = (function camelot$util$deployment$map_with_cameras_as_list(d){
var types = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$primary,cljs.core.cst$kw$secondary], null);
var nd = camelot.util.data.key_prefix_to_map(d,types);
var cams = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (types,nd){
return (function (p1__38310_SHARP_){
return camelot.util.data.nat_QMARK_(cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(p1__38310_SHARP_));
});})(types,nd))
,cljs.core.vals(camelot.util.data.select_keys_inv(types,nd)));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nd,cljs.core.cst$kw$cameras,cams),cljs.core.cst$kw$primary,cljs.core.array_seq([cljs.core.cst$kw$secondary], 0));
});
var ufv___38317 = schema.utils.use_fn_validation;
var output_schema38311_38318 = schema.core.Bool;
var input_schema38312_38319 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(cljs.core.cst$sym$active_DASH_status_DASH_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Int], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(cljs.core.cst$sym$camera,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$schema$core_SLASH_Any], null)))], null);
var input_checker38313_38320 = (new cljs.core.Delay(((function (ufv___38317,output_schema38311_38318,input_schema38312_38319){
return (function (){
return schema.core.checker(input_schema38312_38319);
});})(ufv___38317,output_schema38311_38318,input_schema38312_38319))
,null));
var output_checker38314_38321 = (new cljs.core.Delay(((function (ufv___38317,output_schema38311_38318,input_schema38312_38319,input_checker38313_38320){
return (function (){
return schema.core.checker(output_schema38311_38318);
});})(ufv___38317,output_schema38311_38318,input_schema38312_38319,input_checker38313_38320))
,null));
var ret__9207__auto___38322 = /**
 * Inputs: [active-status-id :- s/Int camera]
 *   Returns: s/Bool
 * 
 *   Predicate indicating whether a camera was removed from the next session.
 */
camelot.util.deployment.original_camera_removed_QMARK_ = ((function (ufv___38317,output_schema38311_38318,input_schema38312_38319,input_checker38313_38320,output_checker38314_38321){
return (function camelot$util$deployment$original_camera_removed_QMARK_(G__38315,G__38316){
var validate__7789__auto__ = ufv___38317.get_cell();
if(cljs.core.truth_(validate__7789__auto__)){
var args__7790__auto___38323 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38315,G__38316], null);
var temp__4657__auto___38324 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(input_checker38313_38320) : cljs.core.deref.call(null,input_checker38313_38320)).call(null,args__7790__auto___38323);
if(cljs.core.truth_(temp__4657__auto___38324)){
var error__7791__auto___38325 = temp__4657__auto___38324;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$original_DASH_camera_DASH_removed_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Bool,cljs.core.cst$kw$doc,"Predicate indicating whether a camera was removed from the next session."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___38325], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,input_schema38312_38319,cljs.core.cst$kw$value,args__7790__auto___38323,cljs.core.cst$kw$error,error__7791__auto___38325], null));
} else {
}
} else {
}

var o__7792__auto__ = (function (){var active_status_id = G__38315;
var camera = G__38316;
while(true){
var and__6405__auto__ = camelot.util.data.nat_QMARK_(cljs.core.cst$kw$camera_DASH_original_DASH_id.cljs$core$IFn$_invoke$arity$1(camera));
if(cljs.core.truth_(and__6405__auto__)){
return (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_original_DASH_id.cljs$core$IFn$_invoke$arity$1(camera),cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(camera))) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_status_DASH_id.cljs$core$IFn$_invoke$arity$1(camera),active_status_id));
} else {
return and__6405__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__7789__auto__)){
var temp__4657__auto___38326 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(output_checker38314_38321) : cljs.core.deref.call(null,output_checker38314_38321)).call(null,o__7792__auto__);
if(cljs.core.truth_(temp__4657__auto___38326)){
var error__7791__auto___38327 = temp__4657__auto___38326;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$original_DASH_camera_DASH_removed_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Bool,cljs.core.cst$kw$doc,"Predicate indicating whether a camera was removed from the next session."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___38327], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,output_schema38311_38318,cljs.core.cst$kw$value,o__7792__auto__,cljs.core.cst$kw$error,error__7791__auto___38327], null));
} else {
}
} else {
}

return o__7792__auto__;
});})(ufv___38317,output_schema38311_38318,input_schema38312_38319,input_checker38313_38320,output_checker38314_38321))
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(camelot.util.deployment.original_camera_removed_QMARK_),schema.core.__GT_FnSchema(output_schema38311_38318,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema38312_38319], null)));

var ufv___38334 = schema.utils.use_fn_validation;
var output_schema38328_38335 = schema.core.Bool;
var input_schema38329_38336 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Int,cljs.core.with_meta(cljs.core.cst$sym$active_DASH_status_DASH_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Int], null))),schema.core.one(schema.core.Any,cljs.core.with_meta(cljs.core.cst$sym$camera,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$schema$core_SLASH_Any], null)))], null);
var input_checker38330_38337 = (new cljs.core.Delay(((function (ufv___38334,output_schema38328_38335,input_schema38329_38336){
return (function (){
return schema.core.checker(input_schema38329_38336);
});})(ufv___38334,output_schema38328_38335,input_schema38329_38336))
,null));
var output_checker38331_38338 = (new cljs.core.Delay(((function (ufv___38334,output_schema38328_38335,input_schema38329_38336,input_checker38330_38337){
return (function (){
return schema.core.checker(output_schema38328_38335);
});})(ufv___38334,output_schema38328_38335,input_schema38329_38336,input_checker38330_38337))
,null));
var ret__9207__auto___38339 = /**
 * Inputs: [active-status-id :- s/Int camera]
 *   Returns: s/Bool
 * 
 *   Predicate returning true if the camera is/will be considered active.
 */
camelot.util.deployment.camera_active_QMARK_ = ((function (ufv___38334,output_schema38328_38335,input_schema38329_38336,input_checker38330_38337,output_checker38331_38338){
return (function camelot$util$deployment$camera_active_QMARK_(G__38332,G__38333){
var validate__7789__auto__ = ufv___38334.get_cell();
if(cljs.core.truth_(validate__7789__auto__)){
var args__7790__auto___38340 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38332,G__38333], null);
var temp__4657__auto___38341 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(input_checker38330_38337) : cljs.core.deref.call(null,input_checker38330_38337)).call(null,args__7790__auto___38340);
if(cljs.core.truth_(temp__4657__auto___38341)){
var error__7791__auto___38342 = temp__4657__auto___38341;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$camera_DASH_active_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Bool,cljs.core.cst$kw$doc,"Predicate returning true if the camera is/will be considered active."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___38342], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,input_schema38329_38336,cljs.core.cst$kw$value,args__7790__auto___38340,cljs.core.cst$kw$error,error__7791__auto___38342], null));
} else {
}
} else {
}

var o__7792__auto__ = (function (){var active_status_id = G__38332;
var camera = G__38333;
while(true){
var and__6405__auto__ = camelot.util.data.nat_QMARK_(cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(camera));
if(cljs.core.truth_(and__6405__auto__)){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_status_DASH_id.cljs$core$IFn$_invoke$arity$1(camera),active_status_id)) || ((cljs.core.cst$kw$camera_DASH_original_DASH_id.cljs$core$IFn$_invoke$arity$1(camera) == null)) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_original_DASH_id.cljs$core$IFn$_invoke$arity$1(camera),cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(camera)));
} else {
return and__6405__auto__;
}
break;
}
})();
if(cljs.core.truth_(validate__7789__auto__)){
var temp__4657__auto___38343 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(output_checker38331_38338) : cljs.core.deref.call(null,output_checker38331_38338)).call(null,o__7792__auto__);
if(cljs.core.truth_(temp__4657__auto___38343)){
var error__7791__auto___38344 = temp__4657__auto___38343;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$camera_DASH_active_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Bool,cljs.core.cst$kw$doc,"Predicate returning true if the camera is/will be considered active."], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___38344], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,output_schema38328_38335,cljs.core.cst$kw$value,o__7792__auto__,cljs.core.cst$kw$error,error__7791__auto___38344], null));
} else {
}
} else {
}

return o__7792__auto__;
});})(ufv___38334,output_schema38328_38335,input_schema38329_38336,input_checker38330_38337,output_checker38331_38338))
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(camelot.util.deployment.camera_active_QMARK_),schema.core.__GT_FnSchema(output_schema38328_38335,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema38329_38336], null)));

var ufv___38350 = schema.utils.use_fn_validation;
var output_schema38345_38351 = schema.core.Keyword;
var input_schema38346_38352 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$primary,cljs.core.cst$kw$secondary], 0)),cljs.core.with_meta(cljs.core.cst$sym$cam_DASH_type,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.list(cljs.core.cst$sym$s_SLASH_enum,cljs.core.cst$kw$primary,cljs.core.cst$kw$secondary)], null)))], null);
var input_checker38347_38353 = (new cljs.core.Delay(((function (ufv___38350,output_schema38345_38351,input_schema38346_38352){
return (function (){
return schema.core.checker(input_schema38346_38352);
});})(ufv___38350,output_schema38345_38351,input_schema38346_38352))
,null));
var output_checker38348_38354 = (new cljs.core.Delay(((function (ufv___38350,output_schema38345_38351,input_schema38346_38352,input_checker38347_38353){
return (function (){
return schema.core.checker(output_schema38345_38351);
});})(ufv___38350,output_schema38345_38351,input_schema38346_38352,input_checker38347_38353))
,null));
var ret__9207__auto___38355 = /**
 * Inputs: [cam-type :- (s/enum :primary :secondary)]
 *   Returns: s/Keyword
 */
camelot.util.deployment.camera_id_key = ((function (ufv___38350,output_schema38345_38351,input_schema38346_38352,input_checker38347_38353,output_checker38348_38354){
return (function camelot$util$deployment$camera_id_key(G__38349){
var validate__7789__auto__ = ufv___38350.get_cell();
if(cljs.core.truth_(validate__7789__auto__)){
var args__7790__auto___38356 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38349], null);
var temp__4657__auto___38357 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(input_checker38347_38353) : cljs.core.deref.call(null,input_checker38347_38353)).call(null,args__7790__auto___38356);
if(cljs.core.truth_(temp__4657__auto___38357)){
var error__7791__auto___38358 = temp__4657__auto___38357;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$camera_DASH_id_DASH_key,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Keyword], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___38358], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,input_schema38346_38352,cljs.core.cst$kw$value,args__7790__auto___38356,cljs.core.cst$kw$error,error__7791__auto___38358], null));
} else {
}
} else {
}

var o__7792__auto__ = (function (){var cam_type = G__38349;
while(true){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str(cljs.core.name(cam_type)),cljs.core.str("-camera-id")].join(''));
break;
}
})();
if(cljs.core.truth_(validate__7789__auto__)){
var temp__4657__auto___38359 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(output_checker38348_38354) : cljs.core.deref.call(null,output_checker38348_38354)).call(null,o__7792__auto__);
if(cljs.core.truth_(temp__4657__auto___38359)){
var error__7791__auto___38360 = temp__4657__auto___38359;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$camera_DASH_id_DASH_key,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Keyword], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___38360], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,output_schema38345_38351,cljs.core.cst$kw$value,o__7792__auto__,cljs.core.cst$kw$error,error__7791__auto___38360], null));
} else {
}
} else {
}

return o__7792__auto__;
});})(ufv___38350,output_schema38345_38351,input_schema38346_38352,input_checker38347_38353,output_checker38348_38354))
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(camelot.util.deployment.camera_id_key),schema.core.__GT_FnSchema(output_schema38345_38351,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema38346_38352], null)));

var ufv___38366 = schema.utils.use_fn_validation;
var output_schema38361_38367 = schema.core.Keyword;
var input_schema38362_38368 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$primary,cljs.core.cst$kw$secondary], 0)),cljs.core.with_meta(cljs.core.cst$sym$cam_DASH_type,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.list(cljs.core.cst$sym$s_SLASH_enum,cljs.core.cst$kw$primary,cljs.core.cst$kw$secondary)], null)))], null);
var input_checker38363_38369 = (new cljs.core.Delay(((function (ufv___38366,output_schema38361_38367,input_schema38362_38368){
return (function (){
return schema.core.checker(input_schema38362_38368);
});})(ufv___38366,output_schema38361_38367,input_schema38362_38368))
,null));
var output_checker38364_38370 = (new cljs.core.Delay(((function (ufv___38366,output_schema38361_38367,input_schema38362_38368,input_checker38363_38369){
return (function (){
return schema.core.checker(output_schema38361_38367);
});})(ufv___38366,output_schema38361_38367,input_schema38362_38368,input_checker38363_38369))
,null));
var ret__9207__auto___38371 = /**
 * Inputs: [cam-type :- (s/enum :primary :secondary)]
 *   Returns: s/Keyword
 */
camelot.util.deployment.camera_status_id_key = ((function (ufv___38366,output_schema38361_38367,input_schema38362_38368,input_checker38363_38369,output_checker38364_38370){
return (function camelot$util$deployment$camera_status_id_key(G__38365){
var validate__7789__auto__ = ufv___38366.get_cell();
if(cljs.core.truth_(validate__7789__auto__)){
var args__7790__auto___38372 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38365], null);
var temp__4657__auto___38373 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(input_checker38363_38369) : cljs.core.deref.call(null,input_checker38363_38369)).call(null,args__7790__auto___38372);
if(cljs.core.truth_(temp__4657__auto___38373)){
var error__7791__auto___38374 = temp__4657__auto___38373;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$camera_DASH_status_DASH_id_DASH_key,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Keyword], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___38374], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,input_schema38362_38368,cljs.core.cst$kw$value,args__7790__auto___38372,cljs.core.cst$kw$error,error__7791__auto___38374], null));
} else {
}
} else {
}

var o__7792__auto__ = (function (){var cam_type = G__38365;
while(true){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str(cljs.core.name(cam_type)),cljs.core.str("-camera-status-id")].join(''));
break;
}
})();
if(cljs.core.truth_(validate__7789__auto__)){
var temp__4657__auto___38375 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(output_checker38364_38370) : cljs.core.deref.call(null,output_checker38364_38370)).call(null,o__7792__auto__);
if(cljs.core.truth_(temp__4657__auto___38375)){
var error__7791__auto___38376 = temp__4657__auto___38375;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$camera_DASH_status_DASH_id_DASH_key,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Keyword], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___38376], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,output_schema38361_38367,cljs.core.cst$kw$value,o__7792__auto__,cljs.core.cst$kw$error,error__7791__auto___38376], null));
} else {
}
} else {
}

return o__7792__auto__;
});})(ufv___38366,output_schema38361_38367,input_schema38362_38368,input_checker38363_38369,output_checker38364_38370))
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(camelot.util.deployment.camera_status_id_key),schema.core.__GT_FnSchema(output_schema38361_38367,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema38362_38368], null)));

var ufv___38382 = schema.utils.use_fn_validation;
var output_schema38377_38383 = schema.core.Keyword;
var input_schema38378_38384 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$primary,cljs.core.cst$kw$secondary], 0)),cljs.core.with_meta(cljs.core.cst$sym$cam_DASH_type,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.list(cljs.core.cst$sym$s_SLASH_enum,cljs.core.cst$kw$primary,cljs.core.cst$kw$secondary)], null)))], null);
var input_checker38379_38385 = (new cljs.core.Delay(((function (ufv___38382,output_schema38377_38383,input_schema38378_38384){
return (function (){
return schema.core.checker(input_schema38378_38384);
});})(ufv___38382,output_schema38377_38383,input_schema38378_38384))
,null));
var output_checker38380_38386 = (new cljs.core.Delay(((function (ufv___38382,output_schema38377_38383,input_schema38378_38384,input_checker38379_38385){
return (function (){
return schema.core.checker(output_schema38377_38383);
});})(ufv___38382,output_schema38377_38383,input_schema38378_38384,input_checker38379_38385))
,null));
var ret__9207__auto___38387 = /**
 * Inputs: [cam-type :- (s/enum :primary :secondary)]
 *   Returns: s/Keyword
 */
camelot.util.deployment.camera_media_unrecoverable_key = ((function (ufv___38382,output_schema38377_38383,input_schema38378_38384,input_checker38379_38385,output_checker38380_38386){
return (function camelot$util$deployment$camera_media_unrecoverable_key(G__38381){
var validate__7789__auto__ = ufv___38382.get_cell();
if(cljs.core.truth_(validate__7789__auto__)){
var args__7790__auto___38388 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__38381], null);
var temp__4657__auto___38389 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(input_checker38379_38385) : cljs.core.deref.call(null,input_checker38379_38385)).call(null,args__7790__auto___38388);
if(cljs.core.truth_(temp__4657__auto___38389)){
var error__7791__auto___38390 = temp__4657__auto___38389;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$camera_DASH_media_DASH_unrecoverable_DASH_key,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Keyword], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___38390], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,input_schema38378_38384,cljs.core.cst$kw$value,args__7790__auto___38388,cljs.core.cst$kw$error,error__7791__auto___38390], null));
} else {
}
} else {
}

var o__7792__auto__ = (function (){var cam_type = G__38381;
while(true){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str(cljs.core.name(cam_type)),cljs.core.str("-camera-media-unrecoverable")].join(''));
break;
}
})();
if(cljs.core.truth_(validate__7789__auto__)){
var temp__4657__auto___38391 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(output_checker38380_38386) : cljs.core.deref.call(null,output_checker38380_38386)).call(null,o__7792__auto__);
if(cljs.core.truth_(temp__4657__auto___38391)){
var error__7791__auto___38392 = temp__4657__auto___38391;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$camera_DASH_media_DASH_unrecoverable_DASH_key,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Keyword], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___38392], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,output_schema38377_38383,cljs.core.cst$kw$value,o__7792__auto__,cljs.core.cst$kw$error,error__7791__auto___38392], null));
} else {
}
} else {
}

return o__7792__auto__;
});})(ufv___38382,output_schema38377_38383,input_schema38378_38384,input_checker38379_38385,output_checker38380_38386))
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(camelot.util.deployment.camera_media_unrecoverable_key),schema.core.__GT_FnSchema(output_schema38377_38383,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema38378_38384], null)));

