// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.util.feature');
goog.require('cljs.core');
goog.require('schema.core');
/**
 * Map of feature keys and whether or not they're enabled by default.
 */
camelot.util.feature.default_feature_state = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$bulk_DASH_import,true,cljs.core.cst$kw$sighting_DASH_tags,false], null);
var ufv___35373 = schema.utils.use_fn_validation;
var output_schema35367_35374 = schema.core.Bool;
var input_schema35368_35375 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one(schema.core.Any,cljs.core.with_meta(cljs.core.cst$sym$config,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$schema$core_SLASH_Any], null))),schema.core.one(schema.core.Keyword,cljs.core.with_meta(cljs.core.cst$sym$feature,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Keyword], null)))], null);
var input_checker35369_35376 = (new cljs.core.Delay(((function (ufv___35373,output_schema35367_35374,input_schema35368_35375){
return (function (){
return schema.core.checker(input_schema35368_35375);
});})(ufv___35373,output_schema35367_35374,input_schema35368_35375))
,null));
var output_checker35370_35377 = (new cljs.core.Delay(((function (ufv___35373,output_schema35367_35374,input_schema35368_35375,input_checker35369_35376){
return (function (){
return schema.core.checker(output_schema35367_35374);
});})(ufv___35373,output_schema35367_35374,input_schema35368_35375,input_checker35369_35376))
,null));
var ret__9207__auto___35378 = /**
 * Inputs: [config feature :- s/Keyword]
 *   Returns: s/Bool
 */
camelot.util.feature.enabled_QMARK_ = ((function (ufv___35373,output_schema35367_35374,input_schema35368_35375,input_checker35369_35376,output_checker35370_35377){
return (function camelot$util$feature$enabled_QMARK_(G__35371,G__35372){
var validate__7789__auto__ = ufv___35373.get_cell();
if(cljs.core.truth_(validate__7789__auto__)){
var args__7790__auto___35379 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__35371,G__35372], null);
var temp__4657__auto___35380 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(input_checker35369_35376) : cljs.core.deref.call(null,input_checker35369_35376)).call(null,args__7790__auto___35379);
if(cljs.core.truth_(temp__4657__auto___35380)){
var error__7791__auto___35381 = temp__4657__auto___35380;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Input to %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$enabled_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Bool], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___35381], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,input_schema35368_35375,cljs.core.cst$kw$value,args__7790__auto___35379,cljs.core.cst$kw$error,error__7791__auto___35381], null));
} else {
}
} else {
}

var o__7792__auto__ = (function (){var config = G__35371;
var feature = G__35372;
while(true){
if(cljs.core.contains_QMARK_(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(config),feature)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(config,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$features,feature], null));
} else {
var or__6417__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(camelot.util.feature.default_feature_state,feature);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return false;
}
}
break;
}
})();
if(cljs.core.truth_(validate__7789__auto__)){
var temp__4657__auto___35382 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(output_checker35370_35377) : cljs.core.deref.call(null,output_checker35370_35377)).call(null,o__7792__auto__);
if(cljs.core.truth_(temp__4657__auto___35382)){
var error__7791__auto___35383 = temp__4657__auto___35382;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(schema.utils.format_STAR_.cljs$core$IFn$_invoke$arity$variadic("Output of %s does not match schema: %s",cljs.core.array_seq([cljs.core.with_meta(cljs.core.cst$sym$enabled_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$schema,cljs.core.cst$sym$s_SLASH_Bool], null)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([error__7791__auto___35383], 0))], 0)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,cljs.core.cst$kw$schema$core_SLASH_error,cljs.core.cst$kw$schema,output_schema35367_35374,cljs.core.cst$kw$value,o__7792__auto__,cljs.core.cst$kw$error,error__7791__auto___35383], null));
} else {
}
} else {
}

return o__7792__auto__;
});})(ufv___35373,output_schema35367_35374,input_schema35368_35375,input_checker35369_35376,output_checker35370_35377))
;
schema.utils.declare_class_schema_BANG_(schema.utils.fn_schema_bearer(camelot.util.feature.enabled_QMARK_),schema.core.__GT_FnSchema(output_schema35367_35374,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema35368_35375], null)));

