// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.util.misc');
goog.require('cljs.core');
goog.require('cljs_time.core');
/**
 * Calculate the number of `nights' between two dates.
 */
camelot.util.misc.nights_elapsed = (function camelot$util$misc$nights_elapsed(start,end){
return cljs_time.core.in_days(cljs_time.core.interval(cljs_time.core.at_midnight(start),cljs_time.core.at_midnight(end)));
});
/**
 * Return the given path along with the correct base URL.
 */
camelot.util.misc.with_baseurl = (function camelot$util$misc$with_baseurl(path){
var protocol = ((window["location"])["protocol"]);
var port = ((window["location"])["port"]);
if((clojure.string.starts_with_QMARK_(protocol,"http")) || (clojure.string.starts_with_QMARK_(protocol,"https"))){
return [cljs.core.str(((window["location"])["protocol"])),cljs.core.str("//"),cljs.core.str(((window["location"])["hostname"])),cljs.core.str((((cljs.core.count(port) === (0)))?null:[cljs.core.str(":"),cljs.core.str(port)].join(''))),cljs.core.str(path)].join('');
} else {
return [cljs.core.str("http://localhost:3449"),cljs.core.str(path)].join('');
}
});
