// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('camelot.view');
goog.require('cljs.core');
goog.require('camelot.component.organisation');
goog.require('camelot.component.bulk_import.core');
goog.require('secretary.core');
goog.require('camelot.rest');
goog.require('camelot.component.nav');
goog.require('om.dom');
goog.require('camelot.component.bulk_import.mapper');
goog.require('camelot.component.report.core');
goog.require('camelot.component.camera.core');
goog.require('camelot.component.site.core');
goog.require('camelot.state');
goog.require('camelot.component.survey.core');
goog.require('camelot.component.species.core');
goog.require('smithy.core');
goog.require('camelot.nav');
goog.require('smithy.util');
goog.require('camelot.util.cursorise');
goog.require('om.core');
goog.require('camelot.component.notification');
goog.require('camelot.component.library.core');
goog.require('camelot.component.deployment.core');
goog.require('camelot.util.misc');
/**
 * Update the state of the children defined for the selected resource type.
 */
camelot.view.load_resource_children = (function camelot$view$load_resource_children(vs){
var screen = smithy.util.get_screen(vs);
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$sidebar,cljs.core.cst$kw$resource], null));
var id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$id], null));
var ep = (cljs.core.truth_(id)?[cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$endpoint)),cljs.core.str("/"),cljs.core.str(id)].join(''):cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$endpoint));
return camelot.rest.get_resource(ep,((function (screen,res,id,ep){
return (function (p1__45141_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$children,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__45141_SHARP_));
});})(screen,res,id,ep))
);
});
/**
 * Check required fields against the entered data
 */
camelot.view.validate = (function camelot$view$validate(vs){
var entries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(vs),cljs.core.cst$kw$schema);
var reqd = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (entries){
return (function (p__45147){
var vec__45148 = p__45147;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45148,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45148,(1),null);
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(v,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$required], null));
});})(entries))
,entries);
var invalid = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (entries,reqd){
return (function (p1__45142_SHARP_){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$buffer,cljs.core.first(p1__45142_SHARP_),cljs.core.cst$kw$value], null));
var or__6417__auto__ = (data == null);
if(or__6417__auto__){
return or__6417__auto__;
} else {
var or__6417__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(data,"");
if(or__6417__auto____$1){
return or__6417__auto____$1;
} else {
var or__6417__auto____$2 = (function (){var and__6405__auto__ = cljs.core.re_matches(/.*-id$/,cljs.core.name(cljs.core.first(p1__45142_SHARP_)));
if(cljs.core.truth_(and__6405__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("-1",data);
} else {
return and__6405__auto__;
}
})();
if(cljs.core.truth_(or__6417__auto____$2)){
return or__6417__auto____$2;
} else {
return (cljs.core.coll_QMARK_(data)) && (cljs.core.empty_QMARK_(data));
}
}
}
});})(entries,reqd))
,reqd);
if((cljs.core.count(invalid) === (0))){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$show_DASH_validations,false);

return true;
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$show_DASH_validations,true);

return false;
}
});
/**
 * Mapping of keys to functions to generate drop-down menus.
 */
camelot.view.generators = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$camera_DASH_statuses,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vkey,cljs.core.cst$kw$camera_DASH_status_DASH_id,cljs.core.cst$kw$desc,cljs.core.cst$kw$camera_DASH_status_DASH_description,cljs.core.cst$kw$baseurl,"/camera-statuses"], null),cljs.core.cst$kw$survey_DASH_sites_DASH_available,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vkey,cljs.core.cst$kw$site_DASH_id,cljs.core.cst$kw$desc,cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$baseurl,"/survey-sites"], null),cljs.core.cst$kw$taxonomy_DASH_available,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vkey,cljs.core.cst$kw$taxonomy_DASH_id,cljs.core.cst$kw$desc,cljs.core.cst$kw$taxonomy_DASH_label,cljs.core.cst$kw$baseurl,"/taxonomy"], null),cljs.core.cst$kw$species_DASH_mass,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vkey,cljs.core.cst$kw$species_DASH_mass_DASH_id,cljs.core.cst$kw$desc,cljs.core.cst$kw$species_DASH_mass_DASH_label,cljs.core.cst$kw$baseurl,"/species-mass"], null),cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_cameras_DASH_available,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vkey,cljs.core.cst$kw$camera_DASH_id,cljs.core.cst$kw$desc,cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$baseurl,"/trap-station-session-cameras"], null)], null);
camelot.view.create = (function camelot$view$create(success_key,error_key,vs,resources,key){

var parent_id = smithy.util.get_parent_resource_id(vs);
var basedata = (function (){var G__45153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45153) : cljs.core.deref.call(null,G__45153));
})();
var data = (cljs.core.truth_(parent_id)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(basedata,smithy.util.get_screen_resource(vs,cljs.core.cst$kw$parent_DASH_id_DASH_key),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,parent_id], null)):basedata);
if(cljs.core.truth_(camelot.view.validate(vs))){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("create",smithy.util.get_resource_type_name(vs));

return camelot.rest.post_resource(smithy.util.get_endpoint(vs),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,data], null),((function (parent_id,basedata,data){
return (function (p1__45151_SHARP_){
camelot.view.load_resource_children(vs);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$readonly);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__45151_SHARP_));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__45151_SHARP_));

return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,success_key], null));
});})(parent_id,basedata,data))
);
} else {
return null;
}
});
camelot.view.map_to_params = (function camelot$view$map_to_params(m){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.reduce_kv((function (p1__45154_SHARP_,p2__45155_SHARP_,p3__45156_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__45154_SHARP_,[cljs.core.str(cljs.core.name(p2__45155_SHARP_)),cljs.core.str("="),cljs.core.str((cljs.core.truth_((function (){var and__6405__auto__ = !((p3__45156_SHARP_ == null));
if(and__6405__auto__){
return (p3__45156_SHARP_["getTime"]);
} else {
return and__6405__auto__;
}
})())?p3__45156_SHARP_.getTime():p3__45156_SHARP_))].join(''));
}),cljs.core.PersistentVector.EMPTY,m));
});
camelot.view.create_nav = (function camelot$view$create_nav(success_key,error_key,vs,resources,key){

var basedata = (function (){var G__45158 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45158) : cljs.core.deref.call(null,G__45158));
})();
if(cljs.core.truth_(camelot.view.validate(vs))){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("create-nav",smithy.util.get_resource_type_name(vs));

return window.open(camelot.util.misc.with_baseurl([cljs.core.str(smithy.util.get_endpoint(vs)),cljs.core.str("?"),cljs.core.str(camelot.view.map_to_params(camelot.util.cursorise.decursorise(basedata)))].join('')));
} else {
return null;
}
});
camelot.view.submit_update = (function camelot$view$submit_update(success_key,error_key,vs,resources,key){

var cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,success_key], null));
if(cljs.core.truth_(camelot.view.validate(vs))){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(resources,key,(function (){var G__45161 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45161) : cljs.core.deref.call(null,G__45161));
})());

camelot.component.nav.settings_hide_BANG_();

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("update",smithy.util.get_resource_type_name(vs));

return camelot.rest.put_resource(smithy.util.get_url(vs),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,(function (){var G__45162 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45162) : cljs.core.deref.call(null,G__45162));
})()], null),((function (cb){
return (function (){
if(cljs.core.truth_(smithy.util.settings_screen_QMARK_(vs))){
} else {
camelot.view.load_resource_children(vs);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$readonly);
}

if(cljs.core.truth_(cb)){
return (cb.cljs$core$IFn$_invoke$arity$0 ? cb.cljs$core$IFn$_invoke$arity$0() : cb.call(null));
} else {
return null;
}
});})(cb))
);
} else {
return null;
}
});
camelot.view.cancel_update = (function camelot$view$cancel_update(event_key,vs,resources,key){

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,(function (){var G__45164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(resources,key);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45164) : cljs.core.deref.call(null,G__45164));
})());

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$show_DASH_validations,false);

camelot.component.nav.settings_hide_BANG_();

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("cancel-update",smithy.util.get_resource_type_name(vs));

if(cljs.core.truth_(smithy.util.settings_screen_QMARK_(vs))){
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$readonly);
}

var cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,event_key], null));
if(cljs.core.truth_(cb)){
return (cb.cljs$core$IFn$_invoke$arity$0 ? cb.cljs$core$IFn$_invoke$arity$0() : cb.call(null));
} else {
return null;
}
});
camelot.view.delete$ = (function camelot$view$delete(success_key,error_key,vs,resources,key){

var cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,success_key], null));
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("delete",smithy.util.get_resource_type_name(vs));

return camelot.rest.delete_resource(smithy.util.get_url(vs),cljs.core.PersistentArrayMap.EMPTY,((function (cb){
return (function (){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(resources,key,cljs.core.PersistentArrayMap.EMPTY);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,cljs.core.PersistentArrayMap.EMPTY);

camelot.view.load_resource_children(vs);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$create);

if(cljs.core.truth_(cb)){
return (cb.cljs$core$IFn$_invoke$arity$0 ? cb.cljs$core$IFn$_invoke$arity$0() : cb.call(null));
} else {
return null;
}
});})(cb))
);
});
camelot.view.delete_media = (function camelot$view$delete_media(success_key,error_key,vs,resources,key){

var cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,success_key], null));
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("delete-media",smithy.util.get_resource_type_name(vs));

return camelot.rest.delete_resource([cljs.core.str(smithy.util.get_url(vs)),cljs.core.str("/media")].join(''),cljs.core.PersistentArrayMap.EMPTY,((function (cb){
return (function (){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$create);

if(cljs.core.truth_(cb)){
return (cb.cljs$core$IFn$_invoke$arity$0 ? cb.cljs$core$IFn$_invoke$arity$0() : cb.call(null));
} else {
return null;
}
});})(cb))
);
});
/**
 * Drop-down menu generator for the given view-state.
 */
camelot.view.build_generator = (function camelot$view$build_generator(vs){
return (function (template,gendata,gen,genargs){
var to_dropdown = (function (p1__45165_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$vkey,cljs.core.cst$kw$desc],[cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__45165_SHARP_,cljs.core.cst$kw$vkey.cljs$core$IFn$_invoke$arity$1(template)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__45165_SHARP_,cljs.core.cst$kw$desc.cljs$core$IFn$_invoke$arity$1(template))]);
});
return camelot.rest.get_resource([cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$2(template,cljs.core.cst$kw$baseurl)),cljs.core.str("/"),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)),cljs.core.cst$kw$create))?"available":"alternatives")),cljs.core.str("/"),cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$2(genargs,cljs.core.cst$kw$id))].join(''),((function (to_dropdown){
return (function (p1__45166_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(gendata,gen,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(to_dropdown,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__45166_SHARP_)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vkey,"",cljs.core.cst$kw$desc,""], null)));
});})(to_dropdown))
);
});
});
/**
 * Mapping of actions to the corresponding action function.
 */
camelot.view.actions = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$edit_DASH_mode,cljs.core.cst$kw$trap_DASH_stations,cljs.core.cst$kw$survey_DASH_sites,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_cameras,cljs.core.cst$kw$delete,cljs.core.cst$kw$load_DASH_resource_DASH_children,cljs.core.cst$kw$photos,cljs.core.cst$kw$delete_DASH_media,cljs.core.cst$kw$sightings,cljs.core.cst$kw$trap_DASH_station_DASH_sessions,cljs.core.cst$kw$media,cljs.core.cst$kw$load_DASH_resource],[(function (vs,rid){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$update);
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str("/trap-stations/"),cljs.core.str(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str("/survey-sites/"),cljs.core.str(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str("/trap-station-session-cameras/"),cljs.core.str(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
var screen = smithy.util.get_screen(vs);
if(cljs.core.truth_(confirm("Are you sure you wish to delete this?"))){
return camelot.view.delete$(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$success,cljs.core.cst$kw$event], null)),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$error,cljs.core.cst$kw$event], null)),vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details);
} else {
return null;
}
}),camelot.view.load_resource_children,(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str("/photos/"),cljs.core.str(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
var screen = smithy.util.get_screen(vs);
if(cljs.core.truth_(confirm("Are you sure you wish to delete all media taken in the session by this camera?"))){
return camelot.view.delete_media(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$success,cljs.core.cst$kw$event], null)),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$error,cljs.core.cst$kw$event], null)),vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details);
} else {
return null;
}
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str("/sightings/"),cljs.core.str(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str("/trap-station-sessions/"),cljs.core.str(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str("/media/"),cljs.core.str(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,id){
var cs = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$children], null));
var rkey = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(vs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$resource,cljs.core.cst$kw$id], null));
var resource = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (cs,rkey){
return (function (p1__45167_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((id | (0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__45167_SHARP_,rkey));
});})(cs,rkey))
,cs));
if(cljs.core.truth_(resource)){
return camelot.rest.get_resource(cljs.core.cst$kw$uri.cljs$core$IFn$_invoke$arity$1(resource),((function (cs,rkey,resource){
return (function (resp){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp));

if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$resource_DASH_id], null)))){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$resource_DASH_id,null);
} else {
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$readonly);
}
});})(cs,rkey,resource))
);
} else {
return null;
}
})]);
/**
 * Mapping of events to event functions.
 */
camelot.view.events = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$nav_DASH_history,cljs.core.cst$kw$create_DASH_nav,cljs.core.cst$kw$settings_DASH_save,cljs.core.cst$kw$create,cljs.core.cst$kw$settings_DASH_cancel,cljs.core.cst$kw$update,cljs.core.cst$kw$delete,cljs.core.cst$kw$breadcrumb_DASH_item_DASH_click,cljs.core.cst$kw$build_DASH_generator,cljs.core.cst$kw$sidebar_DASH_item_DASH_click,cljs.core.cst$kw$sidebar_DASH_create_DASH_click,cljs.core.cst$kw$cancel_DASH_update,cljs.core.cst$kw$analytics_DASH_event],[(function (){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),cljs.core.cst$kw$nav_DASH_history);
}),camelot.view.create_nav,(function (d){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.resources_state(),cljs.core.cst$kw$settings,(function (){var G__45168 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$buffer], null));
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__45168) : cljs.core.deref.call(null,G__45168));
})());
}),camelot.view.create,(function (){
return cljs.core.identity((1));
}),camelot.view.submit_update,camelot.view.delete$,(function (token,vs,state){
camelot.nav.breadnav_consume_BANG_(token);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$readonly);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details,state);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,state);
}),camelot.view.build_generator,(function (vs,id){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("sidebar-navigate",smithy.util.get_resource_type_name(vs));

return cljs.core.cst$kw$load_DASH_resource.cljs$core$IFn$_invoke$arity$1(camelot.view.actions).call(null,vs,id);
}),(function (vs){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("sidebar-create",smithy.util.get_resource_type_name(vs));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,cljs.core.PersistentArrayMap.EMPTY);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$create);
}),camelot.view.cancel_update,(function (event,action){
return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2(event,action);
})]);
/**
 * Render the navbar
 */
camelot.view.navbar = (function camelot$view$navbar(){
return om.core.root(camelot.component.nav.nav_component,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$target,document.getElementById("navigation")], null));
});
/**
 * Render the notification dialog
 */
camelot.view.notification_dialog = om.core.root(camelot.component.notification.notification_dialog_component,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$target,document.getElementById("notification-dialog")], null));
/**
 * Render the main page content
 */
camelot.view.generate_view = (function camelot$view$generate_view(var_args){
var args__7499__auto__ = [];
var len__7492__auto___45178 = arguments.length;
var i__7493__auto___45179 = (0);
while(true){
if((i__7493__auto___45179 < len__7492__auto___45178)){
args__7499__auto__.push((arguments[i__7493__auto___45179]));

var G__45180 = (i__7493__auto___45179 + (1));
i__7493__auto___45179 = G__45180;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic = (function (view,p__45172){
var vec__45173 = p__45172;
var map__45176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45173,(0),null);
var map__45176__$1 = ((((!((map__45176 == null)))?((((map__45176.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45176.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45176):map__45176);
var survey_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45176__$1,cljs.core.cst$kw$survey_DASH_id);
var page_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45176__$1,cljs.core.cst$kw$page_DASH_id);
var report_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45176__$1,cljs.core.cst$kw$report_DASH_key);
var camera_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45176__$1,cljs.core.cst$kw$camera_DASH_id);
var site_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45176__$1,cljs.core.cst$kw$site_DASH_id);
var taxonomy_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45176__$1,cljs.core.cst$kw$taxonomy_DASH_id);
var restricted_mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45176__$1,cljs.core.cst$kw$restricted_DASH_mode);
if(cljs.core.truth_(survey_id)){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$selected_DASH_survey,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$page_DASH_id,null);

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str("/surveys/"),cljs.core.str(survey_id)].join(''),((function (vec__45173,map__45176,map__45176__$1,survey_id,page_id,report_key,camera_id,site_id,taxonomy_id,restricted_mode){
return (function (p1__45169_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__45169_SHARP_));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$page_DASH_id,page_id);

return om.core.root(view,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$target,document.getElementById("page-content")], null));
});})(vec__45173,map__45176,map__45176__$1,survey_id,page_id,report_key,camera_id,site_id,taxonomy_id,restricted_mode))
);
} else {
return om.core.root(view,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$target,document.getElementById("page-content"),cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$report_DASH_key,report_key,cljs.core.cst$kw$camera_DASH_id,camera_id,cljs.core.cst$kw$taxonomy_DASH_id,taxonomy_id,cljs.core.cst$kw$restricted_DASH_mode,restricted_mode,cljs.core.cst$kw$site_DASH_id,site_id], null)], null));
}
});

camelot.view.generate_view.cljs$lang$maxFixedArity = (1);

camelot.view.generate_view.cljs$lang$applyTo = (function (seq45170){
var G__45171 = cljs.core.first(seq45170);
var seq45170__$1 = cljs.core.next(seq45170);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(G__45171,seq45170__$1);
});

/**
 * Render the settings panel
 */
camelot.view.settings_menu_view = (function camelot$view$settings_menu_view(){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$events,camelot.view.events);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$actions,camelot.view.actions);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$generators,camelot.view.generators);

if(cljs.core.truth_(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$screens.cljs$core$IFn$_invoke$arity$1(camelot.state.app_state_cursor())))){
var f = smithy.core.build_view_component(cljs.core.cst$kw$settings);
return om.core.root(f,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$target,document.getElementById("settings")], null));
} else {
return null;
}
});
camelot.view.page_content_view = (function camelot$view$page_content_view(type,mode,p__45181){
var map__45184 = p__45181;
var map__45184__$1 = ((((!((map__45184 == null)))?((((map__45184.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45184.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45184):map__45184);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45184__$1,cljs.core.cst$kw$id);
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45184__$1,cljs.core.cst$kw$resource_DASH_id);
if((!((cljs.core.cst$kw$view.cljs$core$IFn$_invoke$arity$1(camelot.state.app_state_cursor()) == null))) && (!((cljs.core.cst$kw$resources.cljs$core$IFn$_invoke$arity$1(camelot.state.app_state_cursor()) == null)))){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),cljs.core.cst$kw$view),cljs.core.cst$kw$content,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$screen,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$mode,mode,cljs.core.cst$kw$id,id,cljs.core.cst$kw$resource_DASH_id,resource_id], null),cljs.core.cst$kw$buffer,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$selected_DASH_resource,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$generator_DASH_data,cljs.core.PersistentArrayMap.EMPTY], null));

var f = smithy.core.build_view_component(cljs.core.cst$kw$content);
return om.core.root(f,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$target,document.getElementById("page-content")], null));
} else {
return null;
}
});
var action__31436__auto___45191 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45186 = params__31437__auto__;
var map__45186__$1 = ((((!((map__45186 == null)))?((((map__45186.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45186.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45186):map__45186);
return camelot.view.page_content_view(cljs.core.cst$kw$survey,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45188 = params__31437__auto__;
return camelot.view.page_content_view(cljs.core.cst$kw$survey,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/surveys",action__31436__auto___45191);

var action__31436__auto___45197 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45192 = params__31437__auto__;
var map__45192__$1 = ((((!((map__45192 == null)))?((((map__45192.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45192.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45192):map__45192);
var mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45192__$1,cljs.core.cst$kw$mode);
var rid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45192__$1,cljs.core.cst$kw$rid);
return camelot.view.page_content_view(cljs.core.cst$kw$survey,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(mode),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$resource_DASH_id,rid], null));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45194 = params__31437__auto__;
var mode = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45194,(0),null);
var rid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45194,(1),null);
return camelot.view.page_content_view(cljs.core.cst$kw$survey,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(mode),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$resource_DASH_id,rid], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/surveys/:mode/:rid",action__31436__auto___45197);

var action__31436__auto___45203 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45198 = params__31437__auto__;
var map__45198__$1 = ((((!((map__45198 == null)))?((((map__45198.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45198.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45198):map__45198);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45198__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45200 = params__31437__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45200,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/trap-station-session-cameras/:id",action__31436__auto___45203);

var action__31436__auto___45209 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45204 = params__31437__auto__;
var map__45204__$1 = ((((!((map__45204 == null)))?((((map__45204.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45204.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45204):map__45204);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45204__$1,cljs.core.cst$kw$id);
var mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45204__$1,cljs.core.cst$kw$mode);
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45204__$1,cljs.core.cst$kw$resource_DASH_id);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(mode),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$resource_DASH_id,resource_id,cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45206 = params__31437__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45206,(0),null);
var mode = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45206,(1),null);
var resource_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45206,(2),null);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(mode),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$resource_DASH_id,resource_id,cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/trap-station-session-cameras/:id/:mode/:resource-id",action__31436__auto___45209);

var action__31436__auto___45215 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45210 = params__31437__auto__;
var map__45210__$1 = ((((!((map__45210 == null)))?((((map__45210.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45210.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45210):map__45210);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45210__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45212 = params__31437__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45212,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/trap-station-sessions/:id",action__31436__auto___45215);

var action__31436__auto___45221 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45216 = params__31437__auto__;
var map__45216__$1 = ((((!((map__45216 == null)))?((((map__45216.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45216.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45216):map__45216);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45216__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$media,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45218 = params__31437__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45218,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$media,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/media/:id",action__31436__auto___45221);

var action__31436__auto___45227 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45222 = params__31437__auto__;
var map__45222__$1 = ((((!((map__45222 == null)))?((((map__45222.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45222.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45222):map__45222);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45222__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$photo,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45224 = params__31437__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45224,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$photo,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/photos/:id",action__31436__auto___45227);

var action__31436__auto___45233 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45228 = params__31437__auto__;
var map__45228__$1 = ((((!((map__45228 == null)))?((((map__45228.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45228.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45228):map__45228);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45228__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$sighting,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45230 = params__31437__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45230,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$sighting,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/sightings/:id",action__31436__auto___45233);

var action__31436__auto___45239 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45234 = params__31437__auto__;
var map__45234__$1 = ((((!((map__45234 == null)))?((((map__45234.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45234.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45234):map__45234);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45234__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45236 = params__31437__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45236,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/trap-stations/:id",action__31436__auto___45239);

var action__31436__auto___45245 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45240 = params__31437__auto__;
var map__45240__$1 = ((((!((map__45240 == null)))?((((map__45240.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45240.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45240):map__45240);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45240__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$survey_DASH_site,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45242 = params__31437__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45242,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$survey_DASH_site,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/survey-sites/:id",action__31436__auto___45245);

var action__31436__auto___45251 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45246 = params__31437__auto__;
var map__45246__$1 = ((((!((map__45246 == null)))?((((map__45246.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45246.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45246):map__45246);
return camelot.view.page_content_view(cljs.core.cst$kw$site,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45248 = params__31437__auto__;
return camelot.view.page_content_view(cljs.core.cst$kw$site,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/sites",action__31436__auto___45251);

var action__31436__auto___45257 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45252 = params__31437__auto__;
var map__45252__$1 = ((((!((map__45252 == null)))?((((map__45252.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45252.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45252):map__45252);
return camelot.view.page_content_view(cljs.core.cst$kw$camera,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45254 = params__31437__auto__;
return camelot.view.page_content_view(cljs.core.cst$kw$camera,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/cameras",action__31436__auto___45257);

var action__31436__auto___45263 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45258 = params__31437__auto__;
var map__45258__$1 = ((((!((map__45258 == null)))?((((map__45258.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45258.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45258):map__45258);
return camelot.view.page_content_view(cljs.core.cst$kw$taxonomy,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45260 = params__31437__auto__;
return camelot.view.page_content_view(cljs.core.cst$kw$taxonomy,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/taxonomy",action__31436__auto___45263);

var action__31436__auto___45269 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45264 = params__31437__auto__;
var map__45264__$1 = ((((!((map__45264 == null)))?((((map__45264.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45264.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45264):map__45264);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.library.core.library_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$restricted_DASH_mode,true], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45266 = params__31437__auto__;
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.library.core.library_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$restricted_DASH_mode,true], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/library/restricted",action__31436__auto___45269);

var action__31436__auto___45275 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45270 = params__31437__auto__;
var map__45270__$1 = ((((!((map__45270 == null)))?((((map__45270.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45270.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45270):map__45270);
return camelot.view.generate_view(camelot.component.library.core.library_view_component);
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45272 = params__31437__auto__;
return camelot.view.generate_view(camelot.component.library.core.library_view_component);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/library",action__31436__auto___45275);

var action__31436__auto___45281 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45276 = params__31437__auto__;
var map__45276__$1 = ((((!((map__45276 == null)))?((((map__45276.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45276.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45276):map__45276);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45276__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.library.core.library_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45278 = params__31437__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45278,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.library.core.library_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/library",action__31436__auto___45281);

var action__31436__auto___45287 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45282 = params__31437__auto__;
var map__45282__$1 = ((((!((map__45282 == null)))?((((map__45282.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45282.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45282):map__45282);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45282__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.bulk_import.core.bulk_import_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45284 = params__31437__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45284,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.bulk_import.core.bulk_import_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/bulk-import",action__31436__auto___45287);

var action__31436__auto___45293 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45288 = params__31437__auto__;
var map__45288__$1 = ((((!((map__45288 == null)))?((((map__45288.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45288.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45288):map__45288);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45288__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.bulk_import.mapper.bulk_import_mapping_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45290 = params__31437__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45290,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.bulk_import.mapper.bulk_import_mapping_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/bulk-import/mapper",action__31436__auto___45293);

var action__31436__auto___45299 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45294 = params__31437__auto__;
var map__45294__$1 = ((((!((map__45294 == null)))?((((map__45294.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45294.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45294):map__45294);
return camelot.view.generate_view(camelot.component.organisation.organisation_view);
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45296 = params__31437__auto__;
return camelot.view.generate_view(camelot.component.organisation.organisation_view);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/organisation",action__31436__auto___45299);

var action__31436__auto___45305 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45300 = params__31437__auto__;
var map__45300__$1 = ((((!((map__45300 == null)))?((((map__45300.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45300.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45300):map__45300);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45300__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.survey.core.survey_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45302 = params__31437__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45302,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.survey.core.survey_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey",action__31436__auto___45305);

var action__31436__auto___45311 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45306 = params__31437__auto__;
var map__45306__$1 = ((((!((map__45306 == null)))?((((map__45306.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45306.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45306):map__45306);
var taxonomy_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45306__$1,cljs.core.cst$kw$taxonomy_DASH_id);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.species.core.update_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$taxonomy_DASH_id,taxonomy_id], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45308 = params__31437__auto__;
var taxonomy_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45308,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.species.core.update_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$taxonomy_DASH_id,taxonomy_id], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/taxonomy/:taxonomy-id",action__31436__auto___45311);

var action__31436__auto___45317 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45312 = params__31437__auto__;
var map__45312__$1 = ((((!((map__45312 == null)))?((((map__45312.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45312.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45312):map__45312);
var camera_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45312__$1,cljs.core.cst$kw$camera_DASH_id);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.camera.core.manage_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$camera_DASH_id,camera_id], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45314 = params__31437__auto__;
var camera_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45314,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.camera.core.manage_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$camera_DASH_id,camera_id], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/camera/:camera-id",action__31436__auto___45317);

var action__31436__auto___45323 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45318 = params__31437__auto__;
var map__45318__$1 = ((((!((map__45318 == null)))?((((map__45318.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45318.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45318):map__45318);
var site_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45318__$1,cljs.core.cst$kw$site_DASH_id);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.site.core.manage_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$site_DASH_id,site_id], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45320 = params__31437__auto__;
var site_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45320,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.site.core.manage_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$site_DASH_id,site_id], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/site/:site-id",action__31436__auto___45323);

var action__31436__auto___45329 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45324 = params__31437__auto__;
var map__45324__$1 = ((((!((map__45324 == null)))?((((map__45324.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45324.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45324):map__45324);
var report_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45324__$1,cljs.core.cst$kw$report_DASH_key);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.report.core.configure_report_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$report_DASH_key,report_key], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45326 = params__31437__auto__;
var report_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45326,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.report.core.configure_report_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$report_DASH_key,report_key], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/report/:report-key",action__31436__auto___45329);

var action__31436__auto___45335 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45330 = params__31437__auto__;
var map__45330__$1 = ((((!((map__45330 == null)))?((((map__45330.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45330.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45330):map__45330);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45330__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.species.core.manage_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45332 = params__31437__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45332,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.species.core.manage_view,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/taxonomy",action__31436__auto___45335);

var action__31436__auto___45341 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45336 = params__31437__auto__;
var map__45336__$1 = ((((!((map__45336 == null)))?((((map__45336.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45336.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45336):map__45336);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45336__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.create_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45338 = params__31437__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45338,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.create_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/deployments/create",action__31436__auto___45341);

var action__31436__auto___45347 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45342 = params__31437__auto__;
var map__45342__$1 = ((((!((map__45342 == null)))?((((map__45342.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45342.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45342):map__45342);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45342__$1,cljs.core.cst$kw$survey);
var trap_station_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45342__$1,cljs.core.cst$kw$trap_DASH_station_DASH_id);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.edit_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$survey_DASH_id,survey,cljs.core.cst$kw$page_DASH_id,trap_station_id], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45344 = params__31437__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45344,(0),null);
var trap_station_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45344,(1),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.edit_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$survey_DASH_id,survey,cljs.core.cst$kw$page_DASH_id,trap_station_id], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/deployments/:trap-station-id/edit",action__31436__auto___45347);

var action__31436__auto___45353 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45348 = params__31437__auto__;
var map__45348__$1 = ((((!((map__45348 == null)))?((((map__45348.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45348.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45348):map__45348);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45348__$1,cljs.core.cst$kw$survey);
var trap_station_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45348__$1,cljs.core.cst$kw$trap_DASH_station_DASH_id);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.deployment_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$survey_DASH_id,survey,cljs.core.cst$kw$page_DASH_id,trap_station_id], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45350 = params__31437__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45350,(0),null);
var trap_station_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45350,(1),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.deployment_view_component,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$survey_DASH_id,survey,cljs.core.cst$kw$page_DASH_id,trap_station_id], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/deployments/:trap-station-id",action__31436__auto___45353);

var action__31436__auto___45359 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45354 = params__31437__auto__;
var map__45354__$1 = ((((!((map__45354 == null)))?((((map__45354.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45354.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45354):map__45354);
return camelot.view.generate_view(camelot.component.survey.core.create_view_component);
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45356 = params__31437__auto__;
return camelot.view.generate_view(camelot.component.survey.core.create_view_component);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/survey/create",action__31436__auto___45359);

var action__31436__auto___45365 = (function (params__31437__auto__){
if(cljs.core.map_QMARK_(params__31437__auto__)){
var map__45360 = params__31437__auto__;
var map__45360__$1 = ((((!((map__45360 == null)))?((((map__45360.cljs$lang$protocol_mask$partition0$ & (64))) || (map__45360.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45360):map__45360);
return camelot.view.generate_view(camelot.component.notification.not_found_page_component);
} else {
if(cljs.core.vector_QMARK_(params__31437__auto__)){
var vec__45362 = params__31437__auto__;
return camelot.view.generate_view(camelot.component.notification.not_found_page_component);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("*",action__31436__auto___45365);

