// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args28621 = [];
var len__7492__auto___28627 = arguments.length;
var i__7493__auto___28628 = (0);
while(true){
if((i__7493__auto___28628 < len__7492__auto___28627)){
args28621.push((arguments[i__7493__auto___28628]));

var G__28629 = (i__7493__auto___28628 + (1));
i__7493__auto___28628 = G__28629;
continue;
} else {
}
break;
}

var G__28623 = args28621.length;
switch (G__28623) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28621.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async28624 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28624 = (function (f,blockable,meta28625){
this.f = f;
this.blockable = blockable;
this.meta28625 = meta28625;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28624.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28626,meta28625__$1){
var self__ = this;
var _28626__$1 = this;
return (new cljs.core.async.t_cljs$core$async28624(self__.f,self__.blockable,meta28625__$1));
});

cljs.core.async.t_cljs$core$async28624.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28626){
var self__ = this;
var _28626__$1 = this;
return self__.meta28625;
});

cljs.core.async.t_cljs$core$async28624.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28624.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async28624.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async28624.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async28624.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta28625], null);
});

cljs.core.async.t_cljs$core$async28624.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28624.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28624";

cljs.core.async.t_cljs$core$async28624.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"cljs.core.async/t_cljs$core$async28624");
});

cljs.core.async.__GT_t_cljs$core$async28624 = (function cljs$core$async$__GT_t_cljs$core$async28624(f__$1,blockable__$1,meta28625){
return (new cljs.core.async.t_cljs$core$async28624(f__$1,blockable__$1,meta28625));
});

}

return (new cljs.core.async.t_cljs$core$async28624(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args28633 = [];
var len__7492__auto___28636 = arguments.length;
var i__7493__auto___28637 = (0);
while(true){
if((i__7493__auto___28637 < len__7492__auto___28636)){
args28633.push((arguments[i__7493__auto___28637]));

var G__28638 = (i__7493__auto___28637 + (1));
i__7493__auto___28637 = G__28638;
continue;
} else {
}
break;
}

var G__28635 = args28633.length;
switch (G__28635) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28633.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args28640 = [];
var len__7492__auto___28643 = arguments.length;
var i__7493__auto___28644 = (0);
while(true){
if((i__7493__auto___28644 < len__7492__auto___28643)){
args28640.push((arguments[i__7493__auto___28644]));

var G__28645 = (i__7493__auto___28644 + (1));
i__7493__auto___28644 = G__28645;
continue;
} else {
}
break;
}

var G__28642 = args28640.length;
switch (G__28642) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28640.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args28647 = [];
var len__7492__auto___28650 = arguments.length;
var i__7493__auto___28651 = (0);
while(true){
if((i__7493__auto___28651 < len__7492__auto___28650)){
args28647.push((arguments[i__7493__auto___28651]));

var G__28652 = (i__7493__auto___28651 + (1));
i__7493__auto___28651 = G__28652;
continue;
} else {
}
break;
}

var G__28649 = args28647.length;
switch (G__28649) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28647.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_28654 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_28654) : fn1.call(null,val_28654));
} else {
cljs.core.async.impl.dispatch.run(((function (val_28654,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_28654) : fn1.call(null,val_28654));
});})(val_28654,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args28655 = [];
var len__7492__auto___28658 = arguments.length;
var i__7493__auto___28659 = (0);
while(true){
if((i__7493__auto___28659 < len__7492__auto___28658)){
args28655.push((arguments[i__7493__auto___28659]));

var G__28660 = (i__7493__auto___28659 + (1));
i__7493__auto___28659 = G__28660;
continue;
} else {
}
break;
}

var G__28657 = args28655.length;
switch (G__28657) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28655.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7332__auto___28662 = n;
var x_28663 = (0);
while(true){
if((x_28663 < n__7332__auto___28662)){
(a[x_28663] = (0));

var G__28664 = (x_28663 + (1));
x_28663 = G__28664;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__28665 = (i + (1));
i = G__28665;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async28669 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28669 = (function (alt_flag,flag,meta28670){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta28670 = meta28670;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28669.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_28671,meta28670__$1){
var self__ = this;
var _28671__$1 = this;
return (new cljs.core.async.t_cljs$core$async28669(self__.alt_flag,self__.flag,meta28670__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async28669.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_28671){
var self__ = this;
var _28671__$1 = this;
return self__.meta28670;
});})(flag))
;

cljs.core.async.t_cljs$core$async28669.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28669.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async28669.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async28669.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async28669.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta28670], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async28669.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28669.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28669";

cljs.core.async.t_cljs$core$async28669.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"cljs.core.async/t_cljs$core$async28669");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async28669 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28669(alt_flag__$1,flag__$1,meta28670){
return (new cljs.core.async.t_cljs$core$async28669(alt_flag__$1,flag__$1,meta28670));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async28669(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async28675 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28675 = (function (alt_handler,flag,cb,meta28676){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta28676 = meta28676;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async28675.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28677,meta28676__$1){
var self__ = this;
var _28677__$1 = this;
return (new cljs.core.async.t_cljs$core$async28675(self__.alt_handler,self__.flag,self__.cb,meta28676__$1));
});

cljs.core.async.t_cljs$core$async28675.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28677){
var self__ = this;
var _28677__$1 = this;
return self__.meta28676;
});

cljs.core.async.t_cljs$core$async28675.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async28675.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async28675.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async28675.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async28675.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta28676], null);
});

cljs.core.async.t_cljs$core$async28675.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28675.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28675";

cljs.core.async.t_cljs$core$async28675.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"cljs.core.async/t_cljs$core$async28675");
});

cljs.core.async.__GT_t_cljs$core$async28675 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28675(alt_handler__$1,flag__$1,cb__$1,meta28676){
return (new cljs.core.async.t_cljs$core$async28675(alt_handler__$1,flag__$1,cb__$1,meta28676));
});

}

return (new cljs.core.async.t_cljs$core$async28675(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28678_SHARP_){
var G__28682 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28678_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28682) : fret.call(null,G__28682));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28679_SHARP_){
var G__28683 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28679_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28683) : fret.call(null,G__28683));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6417__auto__ = wport;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return port;
}
})()], null));
} else {
var G__28684 = (i + (1));
i = G__28684;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6417__auto__ = ret;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6405__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6405__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6405__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7499__auto__ = [];
var len__7492__auto___28690 = arguments.length;
var i__7493__auto___28691 = (0);
while(true){
if((i__7493__auto___28691 < len__7492__auto___28690)){
args__7499__auto__.push((arguments[i__7493__auto___28691]));

var G__28692 = (i__7493__auto___28691 + (1));
i__7493__auto___28691 = G__28692;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28687){
var map__28688 = p__28687;
var map__28688__$1 = ((((!((map__28688 == null)))?((((map__28688.cljs$lang$protocol_mask$partition0$ & (64))) || (map__28688.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28688):map__28688);
var opts = map__28688__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28685){
var G__28686 = cljs.core.first(seq28685);
var seq28685__$1 = cljs.core.next(seq28685);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28686,seq28685__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args28693 = [];
var len__7492__auto___28743 = arguments.length;
var i__7493__auto___28744 = (0);
while(true){
if((i__7493__auto___28744 < len__7492__auto___28743)){
args28693.push((arguments[i__7493__auto___28744]));

var G__28745 = (i__7493__auto___28744 + (1));
i__7493__auto___28744 = G__28745;
continue;
} else {
}
break;
}

var G__28695 = args28693.length;
switch (G__28695) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28693.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28576__auto___28747 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___28747){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___28747){
return (function (state_28719){
var state_val_28720 = (state_28719[(1)]);
if((state_val_28720 === (7))){
var inst_28715 = (state_28719[(2)]);
var state_28719__$1 = state_28719;
var statearr_28721_28748 = state_28719__$1;
(statearr_28721_28748[(2)] = inst_28715);

(statearr_28721_28748[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28720 === (1))){
var state_28719__$1 = state_28719;
var statearr_28722_28749 = state_28719__$1;
(statearr_28722_28749[(2)] = null);

(statearr_28722_28749[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28720 === (4))){
var inst_28698 = (state_28719[(7)]);
var inst_28698__$1 = (state_28719[(2)]);
var inst_28699 = (inst_28698__$1 == null);
var state_28719__$1 = (function (){var statearr_28723 = state_28719;
(statearr_28723[(7)] = inst_28698__$1);

return statearr_28723;
})();
if(cljs.core.truth_(inst_28699)){
var statearr_28724_28750 = state_28719__$1;
(statearr_28724_28750[(1)] = (5));

} else {
var statearr_28725_28751 = state_28719__$1;
(statearr_28725_28751[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28720 === (13))){
var state_28719__$1 = state_28719;
var statearr_28726_28752 = state_28719__$1;
(statearr_28726_28752[(2)] = null);

(statearr_28726_28752[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28720 === (6))){
var inst_28698 = (state_28719[(7)]);
var state_28719__$1 = state_28719;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28719__$1,(11),to,inst_28698);
} else {
if((state_val_28720 === (3))){
var inst_28717 = (state_28719[(2)]);
var state_28719__$1 = state_28719;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28719__$1,inst_28717);
} else {
if((state_val_28720 === (12))){
var state_28719__$1 = state_28719;
var statearr_28727_28753 = state_28719__$1;
(statearr_28727_28753[(2)] = null);

(statearr_28727_28753[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28720 === (2))){
var state_28719__$1 = state_28719;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28719__$1,(4),from);
} else {
if((state_val_28720 === (11))){
var inst_28708 = (state_28719[(2)]);
var state_28719__$1 = state_28719;
if(cljs.core.truth_(inst_28708)){
var statearr_28728_28754 = state_28719__$1;
(statearr_28728_28754[(1)] = (12));

} else {
var statearr_28729_28755 = state_28719__$1;
(statearr_28729_28755[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28720 === (9))){
var state_28719__$1 = state_28719;
var statearr_28730_28756 = state_28719__$1;
(statearr_28730_28756[(2)] = null);

(statearr_28730_28756[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28720 === (5))){
var state_28719__$1 = state_28719;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28731_28757 = state_28719__$1;
(statearr_28731_28757[(1)] = (8));

} else {
var statearr_28732_28758 = state_28719__$1;
(statearr_28732_28758[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28720 === (14))){
var inst_28713 = (state_28719[(2)]);
var state_28719__$1 = state_28719;
var statearr_28733_28759 = state_28719__$1;
(statearr_28733_28759[(2)] = inst_28713);

(statearr_28733_28759[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28720 === (10))){
var inst_28705 = (state_28719[(2)]);
var state_28719__$1 = state_28719;
var statearr_28734_28760 = state_28719__$1;
(statearr_28734_28760[(2)] = inst_28705);

(statearr_28734_28760[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28720 === (8))){
var inst_28702 = cljs.core.async.close_BANG_(to);
var state_28719__$1 = state_28719;
var statearr_28735_28761 = state_28719__$1;
(statearr_28735_28761[(2)] = inst_28702);

(statearr_28735_28761[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___28747))
;
return ((function (switch__28452__auto__,c__28576__auto___28747){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_28739 = [null,null,null,null,null,null,null,null];
(statearr_28739[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_28739[(1)] = (1));

return statearr_28739;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_28719){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_28719);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e28740){if((e28740 instanceof Object)){
var ex__28456__auto__ = e28740;
var statearr_28741_28762 = state_28719;
(statearr_28741_28762[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28719);

return cljs.core.cst$kw$recur;
} else {
throw e28740;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__28763 = state_28719;
state_28719 = G__28763;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_28719){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_28719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___28747))
})();
var state__28578__auto__ = (function (){var statearr_28742 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_28742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___28747);

return statearr_28742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___28747))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__28951){
var vec__28952 = p__28951;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28952,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28952,(1),null);
var job = vec__28952;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__28576__auto___29138 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___29138,res,vec__28952,v,p,job,jobs,results){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___29138,res,vec__28952,v,p,job,jobs,results){
return (function (state_28959){
var state_val_28960 = (state_28959[(1)]);
if((state_val_28960 === (1))){
var state_28959__$1 = state_28959;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28959__$1,(2),res,v);
} else {
if((state_val_28960 === (2))){
var inst_28956 = (state_28959[(2)]);
var inst_28957 = cljs.core.async.close_BANG_(res);
var state_28959__$1 = (function (){var statearr_28961 = state_28959;
(statearr_28961[(7)] = inst_28956);

return statearr_28961;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28959__$1,inst_28957);
} else {
return null;
}
}
});})(c__28576__auto___29138,res,vec__28952,v,p,job,jobs,results))
;
return ((function (switch__28452__auto__,c__28576__auto___29138,res,vec__28952,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0 = (function (){
var statearr_28965 = [null,null,null,null,null,null,null,null];
(statearr_28965[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__);

(statearr_28965[(1)] = (1));

return statearr_28965;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1 = (function (state_28959){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_28959);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e28966){if((e28966 instanceof Object)){
var ex__28456__auto__ = e28966;
var statearr_28967_29139 = state_28959;
(statearr_28967_29139[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28959);

return cljs.core.cst$kw$recur;
} else {
throw e28966;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__29140 = state_28959;
state_28959 = G__29140;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__ = function(state_28959){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1.call(this,state_28959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___29138,res,vec__28952,v,p,job,jobs,results))
})();
var state__28578__auto__ = (function (){var statearr_28968 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_28968[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___29138);

return statearr_28968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___29138,res,vec__28952,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__28969){
var vec__28970 = p__28969;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28970,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28970,(1),null);
var job = vec__28970;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7332__auto___29141 = n;
var __29142 = (0);
while(true){
if((__29142 < n__7332__auto___29141)){
var G__28973_29143 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__28973_29143) {
case "compute":
var c__28576__auto___29145 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29142,c__28576__auto___29145,G__28973_29143,n__7332__auto___29141,jobs,results,process,async){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (__29142,c__28576__auto___29145,G__28973_29143,n__7332__auto___29141,jobs,results,process,async){
return (function (state_28986){
var state_val_28987 = (state_28986[(1)]);
if((state_val_28987 === (1))){
var state_28986__$1 = state_28986;
var statearr_28988_29146 = state_28986__$1;
(statearr_28988_29146[(2)] = null);

(statearr_28988_29146[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28987 === (2))){
var state_28986__$1 = state_28986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28986__$1,(4),jobs);
} else {
if((state_val_28987 === (3))){
var inst_28984 = (state_28986[(2)]);
var state_28986__$1 = state_28986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28986__$1,inst_28984);
} else {
if((state_val_28987 === (4))){
var inst_28976 = (state_28986[(2)]);
var inst_28977 = process(inst_28976);
var state_28986__$1 = state_28986;
if(cljs.core.truth_(inst_28977)){
var statearr_28989_29147 = state_28986__$1;
(statearr_28989_29147[(1)] = (5));

} else {
var statearr_28990_29148 = state_28986__$1;
(statearr_28990_29148[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28987 === (5))){
var state_28986__$1 = state_28986;
var statearr_28991_29149 = state_28986__$1;
(statearr_28991_29149[(2)] = null);

(statearr_28991_29149[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28987 === (6))){
var state_28986__$1 = state_28986;
var statearr_28992_29150 = state_28986__$1;
(statearr_28992_29150[(2)] = null);

(statearr_28992_29150[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28987 === (7))){
var inst_28982 = (state_28986[(2)]);
var state_28986__$1 = state_28986;
var statearr_28993_29151 = state_28986__$1;
(statearr_28993_29151[(2)] = inst_28982);

(statearr_28993_29151[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29142,c__28576__auto___29145,G__28973_29143,n__7332__auto___29141,jobs,results,process,async))
;
return ((function (__29142,switch__28452__auto__,c__28576__auto___29145,G__28973_29143,n__7332__auto___29141,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0 = (function (){
var statearr_28997 = [null,null,null,null,null,null,null];
(statearr_28997[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__);

(statearr_28997[(1)] = (1));

return statearr_28997;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1 = (function (state_28986){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_28986);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e28998){if((e28998 instanceof Object)){
var ex__28456__auto__ = e28998;
var statearr_28999_29152 = state_28986;
(statearr_28999_29152[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28986);

return cljs.core.cst$kw$recur;
} else {
throw e28998;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__29153 = state_28986;
state_28986 = G__29153;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__ = function(state_28986){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1.call(this,state_28986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__;
})()
;})(__29142,switch__28452__auto__,c__28576__auto___29145,G__28973_29143,n__7332__auto___29141,jobs,results,process,async))
})();
var state__28578__auto__ = (function (){var statearr_29000 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_29000[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___29145);

return statearr_29000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(__29142,c__28576__auto___29145,G__28973_29143,n__7332__auto___29141,jobs,results,process,async))
);


break;
case "async":
var c__28576__auto___29154 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__29142,c__28576__auto___29154,G__28973_29143,n__7332__auto___29141,jobs,results,process,async){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (__29142,c__28576__auto___29154,G__28973_29143,n__7332__auto___29141,jobs,results,process,async){
return (function (state_29013){
var state_val_29014 = (state_29013[(1)]);
if((state_val_29014 === (1))){
var state_29013__$1 = state_29013;
var statearr_29015_29155 = state_29013__$1;
(statearr_29015_29155[(2)] = null);

(statearr_29015_29155[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29014 === (2))){
var state_29013__$1 = state_29013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29013__$1,(4),jobs);
} else {
if((state_val_29014 === (3))){
var inst_29011 = (state_29013[(2)]);
var state_29013__$1 = state_29013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29013__$1,inst_29011);
} else {
if((state_val_29014 === (4))){
var inst_29003 = (state_29013[(2)]);
var inst_29004 = async(inst_29003);
var state_29013__$1 = state_29013;
if(cljs.core.truth_(inst_29004)){
var statearr_29016_29156 = state_29013__$1;
(statearr_29016_29156[(1)] = (5));

} else {
var statearr_29017_29157 = state_29013__$1;
(statearr_29017_29157[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29014 === (5))){
var state_29013__$1 = state_29013;
var statearr_29018_29158 = state_29013__$1;
(statearr_29018_29158[(2)] = null);

(statearr_29018_29158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29014 === (6))){
var state_29013__$1 = state_29013;
var statearr_29019_29159 = state_29013__$1;
(statearr_29019_29159[(2)] = null);

(statearr_29019_29159[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29014 === (7))){
var inst_29009 = (state_29013[(2)]);
var state_29013__$1 = state_29013;
var statearr_29020_29160 = state_29013__$1;
(statearr_29020_29160[(2)] = inst_29009);

(statearr_29020_29160[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__29142,c__28576__auto___29154,G__28973_29143,n__7332__auto___29141,jobs,results,process,async))
;
return ((function (__29142,switch__28452__auto__,c__28576__auto___29154,G__28973_29143,n__7332__auto___29141,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0 = (function (){
var statearr_29024 = [null,null,null,null,null,null,null];
(statearr_29024[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__);

(statearr_29024[(1)] = (1));

return statearr_29024;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1 = (function (state_29013){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_29013);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e29025){if((e29025 instanceof Object)){
var ex__28456__auto__ = e29025;
var statearr_29026_29161 = state_29013;
(statearr_29026_29161[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29013);

return cljs.core.cst$kw$recur;
} else {
throw e29025;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__29162 = state_29013;
state_29013 = G__29162;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__ = function(state_29013){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1.call(this,state_29013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__;
})()
;})(__29142,switch__28452__auto__,c__28576__auto___29154,G__28973_29143,n__7332__auto___29141,jobs,results,process,async))
})();
var state__28578__auto__ = (function (){var statearr_29027 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_29027[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___29154);

return statearr_29027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(__29142,c__28576__auto___29154,G__28973_29143,n__7332__auto___29141,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__29163 = (__29142 + (1));
__29142 = G__29163;
continue;
} else {
}
break;
}

var c__28576__auto___29164 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___29164,jobs,results,process,async){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___29164,jobs,results,process,async){
return (function (state_29049){
var state_val_29050 = (state_29049[(1)]);
if((state_val_29050 === (1))){
var state_29049__$1 = state_29049;
var statearr_29051_29165 = state_29049__$1;
(statearr_29051_29165[(2)] = null);

(statearr_29051_29165[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29050 === (2))){
var state_29049__$1 = state_29049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29049__$1,(4),from);
} else {
if((state_val_29050 === (3))){
var inst_29047 = (state_29049[(2)]);
var state_29049__$1 = state_29049;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29049__$1,inst_29047);
} else {
if((state_val_29050 === (4))){
var inst_29030 = (state_29049[(7)]);
var inst_29030__$1 = (state_29049[(2)]);
var inst_29031 = (inst_29030__$1 == null);
var state_29049__$1 = (function (){var statearr_29052 = state_29049;
(statearr_29052[(7)] = inst_29030__$1);

return statearr_29052;
})();
if(cljs.core.truth_(inst_29031)){
var statearr_29053_29166 = state_29049__$1;
(statearr_29053_29166[(1)] = (5));

} else {
var statearr_29054_29167 = state_29049__$1;
(statearr_29054_29167[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29050 === (5))){
var inst_29033 = cljs.core.async.close_BANG_(jobs);
var state_29049__$1 = state_29049;
var statearr_29055_29168 = state_29049__$1;
(statearr_29055_29168[(2)] = inst_29033);

(statearr_29055_29168[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29050 === (6))){
var inst_29035 = (state_29049[(8)]);
var inst_29030 = (state_29049[(7)]);
var inst_29035__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_29036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29037 = [inst_29030,inst_29035__$1];
var inst_29038 = (new cljs.core.PersistentVector(null,2,(5),inst_29036,inst_29037,null));
var state_29049__$1 = (function (){var statearr_29056 = state_29049;
(statearr_29056[(8)] = inst_29035__$1);

return statearr_29056;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29049__$1,(8),jobs,inst_29038);
} else {
if((state_val_29050 === (7))){
var inst_29045 = (state_29049[(2)]);
var state_29049__$1 = state_29049;
var statearr_29057_29169 = state_29049__$1;
(statearr_29057_29169[(2)] = inst_29045);

(statearr_29057_29169[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29050 === (8))){
var inst_29035 = (state_29049[(8)]);
var inst_29040 = (state_29049[(2)]);
var state_29049__$1 = (function (){var statearr_29058 = state_29049;
(statearr_29058[(9)] = inst_29040);

return statearr_29058;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29049__$1,(9),results,inst_29035);
} else {
if((state_val_29050 === (9))){
var inst_29042 = (state_29049[(2)]);
var state_29049__$1 = (function (){var statearr_29059 = state_29049;
(statearr_29059[(10)] = inst_29042);

return statearr_29059;
})();
var statearr_29060_29170 = state_29049__$1;
(statearr_29060_29170[(2)] = null);

(statearr_29060_29170[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___29164,jobs,results,process,async))
;
return ((function (switch__28452__auto__,c__28576__auto___29164,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0 = (function (){
var statearr_29064 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29064[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__);

(statearr_29064[(1)] = (1));

return statearr_29064;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1 = (function (state_29049){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_29049);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e29065){if((e29065 instanceof Object)){
var ex__28456__auto__ = e29065;
var statearr_29066_29171 = state_29049;
(statearr_29066_29171[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29049);

return cljs.core.cst$kw$recur;
} else {
throw e29065;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__29172 = state_29049;
state_29049 = G__29172;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__ = function(state_29049){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1.call(this,state_29049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___29164,jobs,results,process,async))
})();
var state__28578__auto__ = (function (){var statearr_29067 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_29067[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___29164);

return statearr_29067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___29164,jobs,results,process,async))
);


var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,jobs,results,process,async){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,jobs,results,process,async){
return (function (state_29105){
var state_val_29106 = (state_29105[(1)]);
if((state_val_29106 === (7))){
var inst_29101 = (state_29105[(2)]);
var state_29105__$1 = state_29105;
var statearr_29107_29173 = state_29105__$1;
(statearr_29107_29173[(2)] = inst_29101);

(statearr_29107_29173[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (20))){
var state_29105__$1 = state_29105;
var statearr_29108_29174 = state_29105__$1;
(statearr_29108_29174[(2)] = null);

(statearr_29108_29174[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (1))){
var state_29105__$1 = state_29105;
var statearr_29109_29175 = state_29105__$1;
(statearr_29109_29175[(2)] = null);

(statearr_29109_29175[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (4))){
var inst_29070 = (state_29105[(7)]);
var inst_29070__$1 = (state_29105[(2)]);
var inst_29071 = (inst_29070__$1 == null);
var state_29105__$1 = (function (){var statearr_29110 = state_29105;
(statearr_29110[(7)] = inst_29070__$1);

return statearr_29110;
})();
if(cljs.core.truth_(inst_29071)){
var statearr_29111_29176 = state_29105__$1;
(statearr_29111_29176[(1)] = (5));

} else {
var statearr_29112_29177 = state_29105__$1;
(statearr_29112_29177[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (15))){
var inst_29083 = (state_29105[(8)]);
var state_29105__$1 = state_29105;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29105__$1,(18),to,inst_29083);
} else {
if((state_val_29106 === (21))){
var inst_29096 = (state_29105[(2)]);
var state_29105__$1 = state_29105;
var statearr_29113_29178 = state_29105__$1;
(statearr_29113_29178[(2)] = inst_29096);

(statearr_29113_29178[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (13))){
var inst_29098 = (state_29105[(2)]);
var state_29105__$1 = (function (){var statearr_29114 = state_29105;
(statearr_29114[(9)] = inst_29098);

return statearr_29114;
})();
var statearr_29115_29179 = state_29105__$1;
(statearr_29115_29179[(2)] = null);

(statearr_29115_29179[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (6))){
var inst_29070 = (state_29105[(7)]);
var state_29105__$1 = state_29105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29105__$1,(11),inst_29070);
} else {
if((state_val_29106 === (17))){
var inst_29091 = (state_29105[(2)]);
var state_29105__$1 = state_29105;
if(cljs.core.truth_(inst_29091)){
var statearr_29116_29180 = state_29105__$1;
(statearr_29116_29180[(1)] = (19));

} else {
var statearr_29117_29181 = state_29105__$1;
(statearr_29117_29181[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (3))){
var inst_29103 = (state_29105[(2)]);
var state_29105__$1 = state_29105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29105__$1,inst_29103);
} else {
if((state_val_29106 === (12))){
var inst_29080 = (state_29105[(10)]);
var state_29105__$1 = state_29105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29105__$1,(14),inst_29080);
} else {
if((state_val_29106 === (2))){
var state_29105__$1 = state_29105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29105__$1,(4),results);
} else {
if((state_val_29106 === (19))){
var state_29105__$1 = state_29105;
var statearr_29118_29182 = state_29105__$1;
(statearr_29118_29182[(2)] = null);

(statearr_29118_29182[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (11))){
var inst_29080 = (state_29105[(2)]);
var state_29105__$1 = (function (){var statearr_29119 = state_29105;
(statearr_29119[(10)] = inst_29080);

return statearr_29119;
})();
var statearr_29120_29183 = state_29105__$1;
(statearr_29120_29183[(2)] = null);

(statearr_29120_29183[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (9))){
var state_29105__$1 = state_29105;
var statearr_29121_29184 = state_29105__$1;
(statearr_29121_29184[(2)] = null);

(statearr_29121_29184[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (5))){
var state_29105__$1 = state_29105;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29122_29185 = state_29105__$1;
(statearr_29122_29185[(1)] = (8));

} else {
var statearr_29123_29186 = state_29105__$1;
(statearr_29123_29186[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (14))){
var inst_29083 = (state_29105[(8)]);
var inst_29085 = (state_29105[(11)]);
var inst_29083__$1 = (state_29105[(2)]);
var inst_29084 = (inst_29083__$1 == null);
var inst_29085__$1 = cljs.core.not(inst_29084);
var state_29105__$1 = (function (){var statearr_29124 = state_29105;
(statearr_29124[(8)] = inst_29083__$1);

(statearr_29124[(11)] = inst_29085__$1);

return statearr_29124;
})();
if(inst_29085__$1){
var statearr_29125_29187 = state_29105__$1;
(statearr_29125_29187[(1)] = (15));

} else {
var statearr_29126_29188 = state_29105__$1;
(statearr_29126_29188[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (16))){
var inst_29085 = (state_29105[(11)]);
var state_29105__$1 = state_29105;
var statearr_29127_29189 = state_29105__$1;
(statearr_29127_29189[(2)] = inst_29085);

(statearr_29127_29189[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (10))){
var inst_29077 = (state_29105[(2)]);
var state_29105__$1 = state_29105;
var statearr_29128_29190 = state_29105__$1;
(statearr_29128_29190[(2)] = inst_29077);

(statearr_29128_29190[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (18))){
var inst_29088 = (state_29105[(2)]);
var state_29105__$1 = state_29105;
var statearr_29129_29191 = state_29105__$1;
(statearr_29129_29191[(2)] = inst_29088);

(statearr_29129_29191[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29106 === (8))){
var inst_29074 = cljs.core.async.close_BANG_(to);
var state_29105__$1 = state_29105;
var statearr_29130_29192 = state_29105__$1;
(statearr_29130_29192[(2)] = inst_29074);

(statearr_29130_29192[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__,jobs,results,process,async))
;
return ((function (switch__28452__auto__,c__28576__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0 = (function (){
var statearr_29134 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29134[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__);

(statearr_29134[(1)] = (1));

return statearr_29134;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1 = (function (state_29105){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_29105);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e29135){if((e29135 instanceof Object)){
var ex__28456__auto__ = e29135;
var statearr_29136_29193 = state_29105;
(statearr_29136_29193[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29105);

return cljs.core.cst$kw$recur;
} else {
throw e29135;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__29194 = state_29105;
state_29105 = G__29194;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__ = function(state_29105){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1.call(this,state_29105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28453__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,jobs,results,process,async))
})();
var state__28578__auto__ = (function (){var statearr_29137 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_29137[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_29137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,jobs,results,process,async))
);

return c__28576__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args29195 = [];
var len__7492__auto___29198 = arguments.length;
var i__7493__auto___29199 = (0);
while(true){
if((i__7493__auto___29199 < len__7492__auto___29198)){
args29195.push((arguments[i__7493__auto___29199]));

var G__29200 = (i__7493__auto___29199 + (1));
i__7493__auto___29199 = G__29200;
continue;
} else {
}
break;
}

var G__29197 = args29195.length;
switch (G__29197) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29195.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args29202 = [];
var len__7492__auto___29205 = arguments.length;
var i__7493__auto___29206 = (0);
while(true){
if((i__7493__auto___29206 < len__7492__auto___29205)){
args29202.push((arguments[i__7493__auto___29206]));

var G__29207 = (i__7493__auto___29206 + (1));
i__7493__auto___29206 = G__29207;
continue;
} else {
}
break;
}

var G__29204 = args29202.length;
switch (G__29204) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29202.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args29209 = [];
var len__7492__auto___29262 = arguments.length;
var i__7493__auto___29263 = (0);
while(true){
if((i__7493__auto___29263 < len__7492__auto___29262)){
args29209.push((arguments[i__7493__auto___29263]));

var G__29264 = (i__7493__auto___29263 + (1));
i__7493__auto___29263 = G__29264;
continue;
} else {
}
break;
}

var G__29211 = args29209.length;
switch (G__29211) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29209.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__28576__auto___29266 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___29266,tc,fc){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___29266,tc,fc){
return (function (state_29237){
var state_val_29238 = (state_29237[(1)]);
if((state_val_29238 === (7))){
var inst_29233 = (state_29237[(2)]);
var state_29237__$1 = state_29237;
var statearr_29239_29267 = state_29237__$1;
(statearr_29239_29267[(2)] = inst_29233);

(statearr_29239_29267[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29238 === (1))){
var state_29237__$1 = state_29237;
var statearr_29240_29268 = state_29237__$1;
(statearr_29240_29268[(2)] = null);

(statearr_29240_29268[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29238 === (4))){
var inst_29214 = (state_29237[(7)]);
var inst_29214__$1 = (state_29237[(2)]);
var inst_29215 = (inst_29214__$1 == null);
var state_29237__$1 = (function (){var statearr_29241 = state_29237;
(statearr_29241[(7)] = inst_29214__$1);

return statearr_29241;
})();
if(cljs.core.truth_(inst_29215)){
var statearr_29242_29269 = state_29237__$1;
(statearr_29242_29269[(1)] = (5));

} else {
var statearr_29243_29270 = state_29237__$1;
(statearr_29243_29270[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29238 === (13))){
var state_29237__$1 = state_29237;
var statearr_29244_29271 = state_29237__$1;
(statearr_29244_29271[(2)] = null);

(statearr_29244_29271[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29238 === (6))){
var inst_29214 = (state_29237[(7)]);
var inst_29220 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_29214) : p.call(null,inst_29214));
var state_29237__$1 = state_29237;
if(cljs.core.truth_(inst_29220)){
var statearr_29245_29272 = state_29237__$1;
(statearr_29245_29272[(1)] = (9));

} else {
var statearr_29246_29273 = state_29237__$1;
(statearr_29246_29273[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29238 === (3))){
var inst_29235 = (state_29237[(2)]);
var state_29237__$1 = state_29237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29237__$1,inst_29235);
} else {
if((state_val_29238 === (12))){
var state_29237__$1 = state_29237;
var statearr_29247_29274 = state_29237__$1;
(statearr_29247_29274[(2)] = null);

(statearr_29247_29274[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29238 === (2))){
var state_29237__$1 = state_29237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29237__$1,(4),ch);
} else {
if((state_val_29238 === (11))){
var inst_29214 = (state_29237[(7)]);
var inst_29224 = (state_29237[(2)]);
var state_29237__$1 = state_29237;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29237__$1,(8),inst_29224,inst_29214);
} else {
if((state_val_29238 === (9))){
var state_29237__$1 = state_29237;
var statearr_29248_29275 = state_29237__$1;
(statearr_29248_29275[(2)] = tc);

(statearr_29248_29275[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29238 === (5))){
var inst_29217 = cljs.core.async.close_BANG_(tc);
var inst_29218 = cljs.core.async.close_BANG_(fc);
var state_29237__$1 = (function (){var statearr_29249 = state_29237;
(statearr_29249[(8)] = inst_29217);

return statearr_29249;
})();
var statearr_29250_29276 = state_29237__$1;
(statearr_29250_29276[(2)] = inst_29218);

(statearr_29250_29276[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29238 === (14))){
var inst_29231 = (state_29237[(2)]);
var state_29237__$1 = state_29237;
var statearr_29251_29277 = state_29237__$1;
(statearr_29251_29277[(2)] = inst_29231);

(statearr_29251_29277[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29238 === (10))){
var state_29237__$1 = state_29237;
var statearr_29252_29278 = state_29237__$1;
(statearr_29252_29278[(2)] = fc);

(statearr_29252_29278[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29238 === (8))){
var inst_29226 = (state_29237[(2)]);
var state_29237__$1 = state_29237;
if(cljs.core.truth_(inst_29226)){
var statearr_29253_29279 = state_29237__$1;
(statearr_29253_29279[(1)] = (12));

} else {
var statearr_29254_29280 = state_29237__$1;
(statearr_29254_29280[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___29266,tc,fc))
;
return ((function (switch__28452__auto__,c__28576__auto___29266,tc,fc){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_29258 = [null,null,null,null,null,null,null,null,null];
(statearr_29258[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_29258[(1)] = (1));

return statearr_29258;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_29237){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_29237);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e29259){if((e29259 instanceof Object)){
var ex__28456__auto__ = e29259;
var statearr_29260_29281 = state_29237;
(statearr_29260_29281[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29237);

return cljs.core.cst$kw$recur;
} else {
throw e29259;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__29282 = state_29237;
state_29237 = G__29282;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_29237){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_29237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___29266,tc,fc))
})();
var state__28578__auto__ = (function (){var statearr_29261 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_29261[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___29266);

return statearr_29261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___29266,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_29346){
var state_val_29347 = (state_29346[(1)]);
if((state_val_29347 === (7))){
var inst_29342 = (state_29346[(2)]);
var state_29346__$1 = state_29346;
var statearr_29348_29369 = state_29346__$1;
(statearr_29348_29369[(2)] = inst_29342);

(statearr_29348_29369[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29347 === (1))){
var inst_29326 = init;
var state_29346__$1 = (function (){var statearr_29349 = state_29346;
(statearr_29349[(7)] = inst_29326);

return statearr_29349;
})();
var statearr_29350_29370 = state_29346__$1;
(statearr_29350_29370[(2)] = null);

(statearr_29350_29370[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29347 === (4))){
var inst_29329 = (state_29346[(8)]);
var inst_29329__$1 = (state_29346[(2)]);
var inst_29330 = (inst_29329__$1 == null);
var state_29346__$1 = (function (){var statearr_29351 = state_29346;
(statearr_29351[(8)] = inst_29329__$1);

return statearr_29351;
})();
if(cljs.core.truth_(inst_29330)){
var statearr_29352_29371 = state_29346__$1;
(statearr_29352_29371[(1)] = (5));

} else {
var statearr_29353_29372 = state_29346__$1;
(statearr_29353_29372[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29347 === (6))){
var inst_29333 = (state_29346[(9)]);
var inst_29329 = (state_29346[(8)]);
var inst_29326 = (state_29346[(7)]);
var inst_29333__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_29326,inst_29329) : f.call(null,inst_29326,inst_29329));
var inst_29334 = cljs.core.reduced_QMARK_(inst_29333__$1);
var state_29346__$1 = (function (){var statearr_29354 = state_29346;
(statearr_29354[(9)] = inst_29333__$1);

return statearr_29354;
})();
if(inst_29334){
var statearr_29355_29373 = state_29346__$1;
(statearr_29355_29373[(1)] = (8));

} else {
var statearr_29356_29374 = state_29346__$1;
(statearr_29356_29374[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29347 === (3))){
var inst_29344 = (state_29346[(2)]);
var state_29346__$1 = state_29346;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29346__$1,inst_29344);
} else {
if((state_val_29347 === (2))){
var state_29346__$1 = state_29346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29346__$1,(4),ch);
} else {
if((state_val_29347 === (9))){
var inst_29333 = (state_29346[(9)]);
var inst_29326 = inst_29333;
var state_29346__$1 = (function (){var statearr_29357 = state_29346;
(statearr_29357[(7)] = inst_29326);

return statearr_29357;
})();
var statearr_29358_29375 = state_29346__$1;
(statearr_29358_29375[(2)] = null);

(statearr_29358_29375[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29347 === (5))){
var inst_29326 = (state_29346[(7)]);
var state_29346__$1 = state_29346;
var statearr_29359_29376 = state_29346__$1;
(statearr_29359_29376[(2)] = inst_29326);

(statearr_29359_29376[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29347 === (10))){
var inst_29340 = (state_29346[(2)]);
var state_29346__$1 = state_29346;
var statearr_29360_29377 = state_29346__$1;
(statearr_29360_29377[(2)] = inst_29340);

(statearr_29360_29377[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29347 === (8))){
var inst_29333 = (state_29346[(9)]);
var inst_29336 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_29333) : cljs.core.deref.call(null,inst_29333));
var state_29346__$1 = state_29346;
var statearr_29361_29378 = state_29346__$1;
(statearr_29361_29378[(2)] = inst_29336);

(statearr_29361_29378[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__28453__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28453__auto____0 = (function (){
var statearr_29365 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29365[(0)] = cljs$core$async$reduce_$_state_machine__28453__auto__);

(statearr_29365[(1)] = (1));

return statearr_29365;
});
var cljs$core$async$reduce_$_state_machine__28453__auto____1 = (function (state_29346){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_29346);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e29366){if((e29366 instanceof Object)){
var ex__28456__auto__ = e29366;
var statearr_29367_29379 = state_29346;
(statearr_29367_29379[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29346);

return cljs.core.cst$kw$recur;
} else {
throw e29366;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__29380 = state_29346;
state_29346 = G__29380;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28453__auto__ = function(state_29346){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28453__auto____1.call(this,state_29346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28453__auto____0;
cljs$core$async$reduce_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28453__auto____1;
return cljs$core$async$reduce_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_29368 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_29368[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_29368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args29381 = [];
var len__7492__auto___29433 = arguments.length;
var i__7493__auto___29434 = (0);
while(true){
if((i__7493__auto___29434 < len__7492__auto___29433)){
args29381.push((arguments[i__7493__auto___29434]));

var G__29435 = (i__7493__auto___29434 + (1));
i__7493__auto___29434 = G__29435;
continue;
} else {
}
break;
}

var G__29383 = args29381.length;
switch (G__29383) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29381.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_29408){
var state_val_29409 = (state_29408[(1)]);
if((state_val_29409 === (7))){
var inst_29390 = (state_29408[(2)]);
var state_29408__$1 = state_29408;
var statearr_29410_29437 = state_29408__$1;
(statearr_29410_29437[(2)] = inst_29390);

(statearr_29410_29437[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29409 === (1))){
var inst_29384 = cljs.core.seq(coll);
var inst_29385 = inst_29384;
var state_29408__$1 = (function (){var statearr_29411 = state_29408;
(statearr_29411[(7)] = inst_29385);

return statearr_29411;
})();
var statearr_29412_29438 = state_29408__$1;
(statearr_29412_29438[(2)] = null);

(statearr_29412_29438[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29409 === (4))){
var inst_29385 = (state_29408[(7)]);
var inst_29388 = cljs.core.first(inst_29385);
var state_29408__$1 = state_29408;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29408__$1,(7),ch,inst_29388);
} else {
if((state_val_29409 === (13))){
var inst_29402 = (state_29408[(2)]);
var state_29408__$1 = state_29408;
var statearr_29413_29439 = state_29408__$1;
(statearr_29413_29439[(2)] = inst_29402);

(statearr_29413_29439[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29409 === (6))){
var inst_29393 = (state_29408[(2)]);
var state_29408__$1 = state_29408;
if(cljs.core.truth_(inst_29393)){
var statearr_29414_29440 = state_29408__$1;
(statearr_29414_29440[(1)] = (8));

} else {
var statearr_29415_29441 = state_29408__$1;
(statearr_29415_29441[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29409 === (3))){
var inst_29406 = (state_29408[(2)]);
var state_29408__$1 = state_29408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29408__$1,inst_29406);
} else {
if((state_val_29409 === (12))){
var state_29408__$1 = state_29408;
var statearr_29416_29442 = state_29408__$1;
(statearr_29416_29442[(2)] = null);

(statearr_29416_29442[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29409 === (2))){
var inst_29385 = (state_29408[(7)]);
var state_29408__$1 = state_29408;
if(cljs.core.truth_(inst_29385)){
var statearr_29417_29443 = state_29408__$1;
(statearr_29417_29443[(1)] = (4));

} else {
var statearr_29418_29444 = state_29408__$1;
(statearr_29418_29444[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29409 === (11))){
var inst_29399 = cljs.core.async.close_BANG_(ch);
var state_29408__$1 = state_29408;
var statearr_29419_29445 = state_29408__$1;
(statearr_29419_29445[(2)] = inst_29399);

(statearr_29419_29445[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29409 === (9))){
var state_29408__$1 = state_29408;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29420_29446 = state_29408__$1;
(statearr_29420_29446[(1)] = (11));

} else {
var statearr_29421_29447 = state_29408__$1;
(statearr_29421_29447[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29409 === (5))){
var inst_29385 = (state_29408[(7)]);
var state_29408__$1 = state_29408;
var statearr_29422_29448 = state_29408__$1;
(statearr_29422_29448[(2)] = inst_29385);

(statearr_29422_29448[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29409 === (10))){
var inst_29404 = (state_29408[(2)]);
var state_29408__$1 = state_29408;
var statearr_29423_29449 = state_29408__$1;
(statearr_29423_29449[(2)] = inst_29404);

(statearr_29423_29449[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29409 === (8))){
var inst_29385 = (state_29408[(7)]);
var inst_29395 = cljs.core.next(inst_29385);
var inst_29385__$1 = inst_29395;
var state_29408__$1 = (function (){var statearr_29424 = state_29408;
(statearr_29424[(7)] = inst_29385__$1);

return statearr_29424;
})();
var statearr_29425_29450 = state_29408__$1;
(statearr_29425_29450[(2)] = null);

(statearr_29425_29450[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_29429 = [null,null,null,null,null,null,null,null];
(statearr_29429[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_29429[(1)] = (1));

return statearr_29429;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_29408){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_29408);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e29430){if((e29430 instanceof Object)){
var ex__28456__auto__ = e29430;
var statearr_29431_29451 = state_29408;
(statearr_29431_29451[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29408);

return cljs.core.cst$kw$recur;
} else {
throw e29430;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__29452 = state_29408;
state_29408 = G__29452;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_29408){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_29408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_29432 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_29432[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_29432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7080__auto__ = (((_ == null))?null:_);
var m__7081__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7081__auto__.call(null,_));
} else {
var m__7081__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7081__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7080__auto__ = (((m == null))?null:m);
var m__7081__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7081__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7081__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7081__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7080__auto__ = (((m == null))?null:m);
var m__7081__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7081__auto__.call(null,m,ch));
} else {
var m__7081__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7081__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7080__auto__ = (((m == null))?null:m);
var m__7081__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7081__auto__.call(null,m));
} else {
var m__7081__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7081__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__29681 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29681) : cljs.core.atom.call(null,G__29681));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async29682 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29682 = (function (mult,ch,cs,meta29683){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta29683 = meta29683;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29682.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_29684,meta29683__$1){
var self__ = this;
var _29684__$1 = this;
return (new cljs.core.async.t_cljs$core$async29682(self__.mult,self__.ch,self__.cs,meta29683__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async29682.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_29684){
var self__ = this;
var _29684__$1 = this;
return self__.meta29683;
});})(cs))
;

cljs.core.async.t_cljs$core$async29682.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async29682.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async29682.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async29682.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async29682.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async29682.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__29685_29909 = self__.cs;
var G__29686_29910 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29685_29909,G__29686_29910) : cljs.core.reset_BANG_.call(null,G__29685_29909,G__29686_29910));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async29682.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta29683], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async29682.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29682.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29682";

cljs.core.async.t_cljs$core$async29682.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"cljs.core.async/t_cljs$core$async29682");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async29682 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async29682(mult__$1,ch__$1,cs__$1,meta29683){
return (new cljs.core.async.t_cljs$core$async29682(mult__$1,ch__$1,cs__$1,meta29683));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async29682(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__28576__auto___29911 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___29911,cs,m,dchan,dctr,done){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___29911,cs,m,dchan,dctr,done){
return (function (state_29821){
var state_val_29822 = (state_29821[(1)]);
if((state_val_29822 === (7))){
var inst_29817 = (state_29821[(2)]);
var state_29821__$1 = state_29821;
var statearr_29823_29912 = state_29821__$1;
(statearr_29823_29912[(2)] = inst_29817);

(statearr_29823_29912[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (20))){
var inst_29720 = (state_29821[(7)]);
var inst_29732 = cljs.core.first(inst_29720);
var inst_29733 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29732,(0),null);
var inst_29734 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29732,(1),null);
var state_29821__$1 = (function (){var statearr_29824 = state_29821;
(statearr_29824[(8)] = inst_29733);

return statearr_29824;
})();
if(cljs.core.truth_(inst_29734)){
var statearr_29825_29913 = state_29821__$1;
(statearr_29825_29913[(1)] = (22));

} else {
var statearr_29826_29914 = state_29821__$1;
(statearr_29826_29914[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (27))){
var inst_29769 = (state_29821[(9)]);
var inst_29764 = (state_29821[(10)]);
var inst_29762 = (state_29821[(11)]);
var inst_29689 = (state_29821[(12)]);
var inst_29769__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_29762,inst_29764);
var inst_29770 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29769__$1,inst_29689,done);
var state_29821__$1 = (function (){var statearr_29827 = state_29821;
(statearr_29827[(9)] = inst_29769__$1);

return statearr_29827;
})();
if(cljs.core.truth_(inst_29770)){
var statearr_29828_29915 = state_29821__$1;
(statearr_29828_29915[(1)] = (30));

} else {
var statearr_29829_29916 = state_29821__$1;
(statearr_29829_29916[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (1))){
var state_29821__$1 = state_29821;
var statearr_29830_29917 = state_29821__$1;
(statearr_29830_29917[(2)] = null);

(statearr_29830_29917[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (24))){
var inst_29720 = (state_29821[(7)]);
var inst_29739 = (state_29821[(2)]);
var inst_29740 = cljs.core.next(inst_29720);
var inst_29698 = inst_29740;
var inst_29699 = null;
var inst_29700 = (0);
var inst_29701 = (0);
var state_29821__$1 = (function (){var statearr_29831 = state_29821;
(statearr_29831[(13)] = inst_29698);

(statearr_29831[(14)] = inst_29739);

(statearr_29831[(15)] = inst_29701);

(statearr_29831[(16)] = inst_29700);

(statearr_29831[(17)] = inst_29699);

return statearr_29831;
})();
var statearr_29832_29918 = state_29821__$1;
(statearr_29832_29918[(2)] = null);

(statearr_29832_29918[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (39))){
var state_29821__$1 = state_29821;
var statearr_29836_29919 = state_29821__$1;
(statearr_29836_29919[(2)] = null);

(statearr_29836_29919[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (4))){
var inst_29689 = (state_29821[(12)]);
var inst_29689__$1 = (state_29821[(2)]);
var inst_29690 = (inst_29689__$1 == null);
var state_29821__$1 = (function (){var statearr_29837 = state_29821;
(statearr_29837[(12)] = inst_29689__$1);

return statearr_29837;
})();
if(cljs.core.truth_(inst_29690)){
var statearr_29838_29920 = state_29821__$1;
(statearr_29838_29920[(1)] = (5));

} else {
var statearr_29839_29921 = state_29821__$1;
(statearr_29839_29921[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (15))){
var inst_29698 = (state_29821[(13)]);
var inst_29701 = (state_29821[(15)]);
var inst_29700 = (state_29821[(16)]);
var inst_29699 = (state_29821[(17)]);
var inst_29716 = (state_29821[(2)]);
var inst_29717 = (inst_29701 + (1));
var tmp29833 = inst_29698;
var tmp29834 = inst_29700;
var tmp29835 = inst_29699;
var inst_29698__$1 = tmp29833;
var inst_29699__$1 = tmp29835;
var inst_29700__$1 = tmp29834;
var inst_29701__$1 = inst_29717;
var state_29821__$1 = (function (){var statearr_29840 = state_29821;
(statearr_29840[(13)] = inst_29698__$1);

(statearr_29840[(15)] = inst_29701__$1);

(statearr_29840[(18)] = inst_29716);

(statearr_29840[(16)] = inst_29700__$1);

(statearr_29840[(17)] = inst_29699__$1);

return statearr_29840;
})();
var statearr_29841_29922 = state_29821__$1;
(statearr_29841_29922[(2)] = null);

(statearr_29841_29922[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (21))){
var inst_29743 = (state_29821[(2)]);
var state_29821__$1 = state_29821;
var statearr_29845_29923 = state_29821__$1;
(statearr_29845_29923[(2)] = inst_29743);

(statearr_29845_29923[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (31))){
var inst_29769 = (state_29821[(9)]);
var inst_29773 = done(null);
var inst_29774 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29769);
var state_29821__$1 = (function (){var statearr_29846 = state_29821;
(statearr_29846[(19)] = inst_29773);

return statearr_29846;
})();
var statearr_29847_29924 = state_29821__$1;
(statearr_29847_29924[(2)] = inst_29774);

(statearr_29847_29924[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (32))){
var inst_29763 = (state_29821[(20)]);
var inst_29764 = (state_29821[(10)]);
var inst_29762 = (state_29821[(11)]);
var inst_29761 = (state_29821[(21)]);
var inst_29776 = (state_29821[(2)]);
var inst_29777 = (inst_29764 + (1));
var tmp29842 = inst_29763;
var tmp29843 = inst_29762;
var tmp29844 = inst_29761;
var inst_29761__$1 = tmp29844;
var inst_29762__$1 = tmp29843;
var inst_29763__$1 = tmp29842;
var inst_29764__$1 = inst_29777;
var state_29821__$1 = (function (){var statearr_29848 = state_29821;
(statearr_29848[(20)] = inst_29763__$1);

(statearr_29848[(10)] = inst_29764__$1);

(statearr_29848[(11)] = inst_29762__$1);

(statearr_29848[(21)] = inst_29761__$1);

(statearr_29848[(22)] = inst_29776);

return statearr_29848;
})();
var statearr_29849_29925 = state_29821__$1;
(statearr_29849_29925[(2)] = null);

(statearr_29849_29925[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (40))){
var inst_29789 = (state_29821[(23)]);
var inst_29793 = done(null);
var inst_29794 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29789);
var state_29821__$1 = (function (){var statearr_29850 = state_29821;
(statearr_29850[(24)] = inst_29793);

return statearr_29850;
})();
var statearr_29851_29926 = state_29821__$1;
(statearr_29851_29926[(2)] = inst_29794);

(statearr_29851_29926[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (33))){
var inst_29780 = (state_29821[(25)]);
var inst_29782 = cljs.core.chunked_seq_QMARK_(inst_29780);
var state_29821__$1 = state_29821;
if(inst_29782){
var statearr_29852_29927 = state_29821__$1;
(statearr_29852_29927[(1)] = (36));

} else {
var statearr_29853_29928 = state_29821__$1;
(statearr_29853_29928[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (13))){
var inst_29710 = (state_29821[(26)]);
var inst_29713 = cljs.core.async.close_BANG_(inst_29710);
var state_29821__$1 = state_29821;
var statearr_29854_29929 = state_29821__$1;
(statearr_29854_29929[(2)] = inst_29713);

(statearr_29854_29929[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (22))){
var inst_29733 = (state_29821[(8)]);
var inst_29736 = cljs.core.async.close_BANG_(inst_29733);
var state_29821__$1 = state_29821;
var statearr_29855_29930 = state_29821__$1;
(statearr_29855_29930[(2)] = inst_29736);

(statearr_29855_29930[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (36))){
var inst_29780 = (state_29821[(25)]);
var inst_29784 = cljs.core.chunk_first(inst_29780);
var inst_29785 = cljs.core.chunk_rest(inst_29780);
var inst_29786 = cljs.core.count(inst_29784);
var inst_29761 = inst_29785;
var inst_29762 = inst_29784;
var inst_29763 = inst_29786;
var inst_29764 = (0);
var state_29821__$1 = (function (){var statearr_29856 = state_29821;
(statearr_29856[(20)] = inst_29763);

(statearr_29856[(10)] = inst_29764);

(statearr_29856[(11)] = inst_29762);

(statearr_29856[(21)] = inst_29761);

return statearr_29856;
})();
var statearr_29857_29931 = state_29821__$1;
(statearr_29857_29931[(2)] = null);

(statearr_29857_29931[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (41))){
var inst_29780 = (state_29821[(25)]);
var inst_29796 = (state_29821[(2)]);
var inst_29797 = cljs.core.next(inst_29780);
var inst_29761 = inst_29797;
var inst_29762 = null;
var inst_29763 = (0);
var inst_29764 = (0);
var state_29821__$1 = (function (){var statearr_29858 = state_29821;
(statearr_29858[(27)] = inst_29796);

(statearr_29858[(20)] = inst_29763);

(statearr_29858[(10)] = inst_29764);

(statearr_29858[(11)] = inst_29762);

(statearr_29858[(21)] = inst_29761);

return statearr_29858;
})();
var statearr_29859_29932 = state_29821__$1;
(statearr_29859_29932[(2)] = null);

(statearr_29859_29932[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (43))){
var state_29821__$1 = state_29821;
var statearr_29860_29933 = state_29821__$1;
(statearr_29860_29933[(2)] = null);

(statearr_29860_29933[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (29))){
var inst_29805 = (state_29821[(2)]);
var state_29821__$1 = state_29821;
var statearr_29861_29934 = state_29821__$1;
(statearr_29861_29934[(2)] = inst_29805);

(statearr_29861_29934[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (44))){
var inst_29814 = (state_29821[(2)]);
var state_29821__$1 = (function (){var statearr_29862 = state_29821;
(statearr_29862[(28)] = inst_29814);

return statearr_29862;
})();
var statearr_29863_29935 = state_29821__$1;
(statearr_29863_29935[(2)] = null);

(statearr_29863_29935[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (6))){
var inst_29753 = (state_29821[(29)]);
var inst_29752 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_29753__$1 = cljs.core.keys(inst_29752);
var inst_29754 = cljs.core.count(inst_29753__$1);
var inst_29755 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_29754) : cljs.core.reset_BANG_.call(null,dctr,inst_29754));
var inst_29760 = cljs.core.seq(inst_29753__$1);
var inst_29761 = inst_29760;
var inst_29762 = null;
var inst_29763 = (0);
var inst_29764 = (0);
var state_29821__$1 = (function (){var statearr_29864 = state_29821;
(statearr_29864[(30)] = inst_29755);

(statearr_29864[(20)] = inst_29763);

(statearr_29864[(10)] = inst_29764);

(statearr_29864[(11)] = inst_29762);

(statearr_29864[(21)] = inst_29761);

(statearr_29864[(29)] = inst_29753__$1);

return statearr_29864;
})();
var statearr_29865_29936 = state_29821__$1;
(statearr_29865_29936[(2)] = null);

(statearr_29865_29936[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (28))){
var inst_29780 = (state_29821[(25)]);
var inst_29761 = (state_29821[(21)]);
var inst_29780__$1 = cljs.core.seq(inst_29761);
var state_29821__$1 = (function (){var statearr_29866 = state_29821;
(statearr_29866[(25)] = inst_29780__$1);

return statearr_29866;
})();
if(inst_29780__$1){
var statearr_29867_29937 = state_29821__$1;
(statearr_29867_29937[(1)] = (33));

} else {
var statearr_29868_29938 = state_29821__$1;
(statearr_29868_29938[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (25))){
var inst_29763 = (state_29821[(20)]);
var inst_29764 = (state_29821[(10)]);
var inst_29766 = (inst_29764 < inst_29763);
var inst_29767 = inst_29766;
var state_29821__$1 = state_29821;
if(cljs.core.truth_(inst_29767)){
var statearr_29869_29939 = state_29821__$1;
(statearr_29869_29939[(1)] = (27));

} else {
var statearr_29870_29940 = state_29821__$1;
(statearr_29870_29940[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (34))){
var state_29821__$1 = state_29821;
var statearr_29871_29941 = state_29821__$1;
(statearr_29871_29941[(2)] = null);

(statearr_29871_29941[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (17))){
var state_29821__$1 = state_29821;
var statearr_29872_29942 = state_29821__$1;
(statearr_29872_29942[(2)] = null);

(statearr_29872_29942[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (3))){
var inst_29819 = (state_29821[(2)]);
var state_29821__$1 = state_29821;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29821__$1,inst_29819);
} else {
if((state_val_29822 === (12))){
var inst_29748 = (state_29821[(2)]);
var state_29821__$1 = state_29821;
var statearr_29873_29943 = state_29821__$1;
(statearr_29873_29943[(2)] = inst_29748);

(statearr_29873_29943[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (2))){
var state_29821__$1 = state_29821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29821__$1,(4),ch);
} else {
if((state_val_29822 === (23))){
var state_29821__$1 = state_29821;
var statearr_29874_29944 = state_29821__$1;
(statearr_29874_29944[(2)] = null);

(statearr_29874_29944[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (35))){
var inst_29803 = (state_29821[(2)]);
var state_29821__$1 = state_29821;
var statearr_29875_29945 = state_29821__$1;
(statearr_29875_29945[(2)] = inst_29803);

(statearr_29875_29945[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (19))){
var inst_29720 = (state_29821[(7)]);
var inst_29724 = cljs.core.chunk_first(inst_29720);
var inst_29725 = cljs.core.chunk_rest(inst_29720);
var inst_29726 = cljs.core.count(inst_29724);
var inst_29698 = inst_29725;
var inst_29699 = inst_29724;
var inst_29700 = inst_29726;
var inst_29701 = (0);
var state_29821__$1 = (function (){var statearr_29876 = state_29821;
(statearr_29876[(13)] = inst_29698);

(statearr_29876[(15)] = inst_29701);

(statearr_29876[(16)] = inst_29700);

(statearr_29876[(17)] = inst_29699);

return statearr_29876;
})();
var statearr_29877_29946 = state_29821__$1;
(statearr_29877_29946[(2)] = null);

(statearr_29877_29946[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (11))){
var inst_29698 = (state_29821[(13)]);
var inst_29720 = (state_29821[(7)]);
var inst_29720__$1 = cljs.core.seq(inst_29698);
var state_29821__$1 = (function (){var statearr_29878 = state_29821;
(statearr_29878[(7)] = inst_29720__$1);

return statearr_29878;
})();
if(inst_29720__$1){
var statearr_29879_29947 = state_29821__$1;
(statearr_29879_29947[(1)] = (16));

} else {
var statearr_29880_29948 = state_29821__$1;
(statearr_29880_29948[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (9))){
var inst_29750 = (state_29821[(2)]);
var state_29821__$1 = state_29821;
var statearr_29881_29949 = state_29821__$1;
(statearr_29881_29949[(2)] = inst_29750);

(statearr_29881_29949[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (5))){
var inst_29696 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_29697 = cljs.core.seq(inst_29696);
var inst_29698 = inst_29697;
var inst_29699 = null;
var inst_29700 = (0);
var inst_29701 = (0);
var state_29821__$1 = (function (){var statearr_29882 = state_29821;
(statearr_29882[(13)] = inst_29698);

(statearr_29882[(15)] = inst_29701);

(statearr_29882[(16)] = inst_29700);

(statearr_29882[(17)] = inst_29699);

return statearr_29882;
})();
var statearr_29883_29950 = state_29821__$1;
(statearr_29883_29950[(2)] = null);

(statearr_29883_29950[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (14))){
var state_29821__$1 = state_29821;
var statearr_29884_29951 = state_29821__$1;
(statearr_29884_29951[(2)] = null);

(statearr_29884_29951[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (45))){
var inst_29811 = (state_29821[(2)]);
var state_29821__$1 = state_29821;
var statearr_29885_29952 = state_29821__$1;
(statearr_29885_29952[(2)] = inst_29811);

(statearr_29885_29952[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (26))){
var inst_29753 = (state_29821[(29)]);
var inst_29807 = (state_29821[(2)]);
var inst_29808 = cljs.core.seq(inst_29753);
var state_29821__$1 = (function (){var statearr_29886 = state_29821;
(statearr_29886[(31)] = inst_29807);

return statearr_29886;
})();
if(inst_29808){
var statearr_29887_29953 = state_29821__$1;
(statearr_29887_29953[(1)] = (42));

} else {
var statearr_29888_29954 = state_29821__$1;
(statearr_29888_29954[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (16))){
var inst_29720 = (state_29821[(7)]);
var inst_29722 = cljs.core.chunked_seq_QMARK_(inst_29720);
var state_29821__$1 = state_29821;
if(inst_29722){
var statearr_29889_29955 = state_29821__$1;
(statearr_29889_29955[(1)] = (19));

} else {
var statearr_29890_29956 = state_29821__$1;
(statearr_29890_29956[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (38))){
var inst_29800 = (state_29821[(2)]);
var state_29821__$1 = state_29821;
var statearr_29891_29957 = state_29821__$1;
(statearr_29891_29957[(2)] = inst_29800);

(statearr_29891_29957[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (30))){
var state_29821__$1 = state_29821;
var statearr_29892_29958 = state_29821__$1;
(statearr_29892_29958[(2)] = null);

(statearr_29892_29958[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (10))){
var inst_29701 = (state_29821[(15)]);
var inst_29699 = (state_29821[(17)]);
var inst_29709 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_29699,inst_29701);
var inst_29710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29709,(0),null);
var inst_29711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29709,(1),null);
var state_29821__$1 = (function (){var statearr_29893 = state_29821;
(statearr_29893[(26)] = inst_29710);

return statearr_29893;
})();
if(cljs.core.truth_(inst_29711)){
var statearr_29894_29959 = state_29821__$1;
(statearr_29894_29959[(1)] = (13));

} else {
var statearr_29895_29960 = state_29821__$1;
(statearr_29895_29960[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (18))){
var inst_29746 = (state_29821[(2)]);
var state_29821__$1 = state_29821;
var statearr_29896_29961 = state_29821__$1;
(statearr_29896_29961[(2)] = inst_29746);

(statearr_29896_29961[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (42))){
var state_29821__$1 = state_29821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29821__$1,(45),dchan);
} else {
if((state_val_29822 === (37))){
var inst_29780 = (state_29821[(25)]);
var inst_29789 = (state_29821[(23)]);
var inst_29689 = (state_29821[(12)]);
var inst_29789__$1 = cljs.core.first(inst_29780);
var inst_29790 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29789__$1,inst_29689,done);
var state_29821__$1 = (function (){var statearr_29897 = state_29821;
(statearr_29897[(23)] = inst_29789__$1);

return statearr_29897;
})();
if(cljs.core.truth_(inst_29790)){
var statearr_29898_29962 = state_29821__$1;
(statearr_29898_29962[(1)] = (39));

} else {
var statearr_29899_29963 = state_29821__$1;
(statearr_29899_29963[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29822 === (8))){
var inst_29701 = (state_29821[(15)]);
var inst_29700 = (state_29821[(16)]);
var inst_29703 = (inst_29701 < inst_29700);
var inst_29704 = inst_29703;
var state_29821__$1 = state_29821;
if(cljs.core.truth_(inst_29704)){
var statearr_29900_29964 = state_29821__$1;
(statearr_29900_29964[(1)] = (10));

} else {
var statearr_29901_29965 = state_29821__$1;
(statearr_29901_29965[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___29911,cs,m,dchan,dctr,done))
;
return ((function (switch__28452__auto__,c__28576__auto___29911,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__28453__auto__ = null;
var cljs$core$async$mult_$_state_machine__28453__auto____0 = (function (){
var statearr_29905 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29905[(0)] = cljs$core$async$mult_$_state_machine__28453__auto__);

(statearr_29905[(1)] = (1));

return statearr_29905;
});
var cljs$core$async$mult_$_state_machine__28453__auto____1 = (function (state_29821){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_29821);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e29906){if((e29906 instanceof Object)){
var ex__28456__auto__ = e29906;
var statearr_29907_29966 = state_29821;
(statearr_29907_29966[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29821);

return cljs.core.cst$kw$recur;
} else {
throw e29906;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__29967 = state_29821;
state_29821 = G__29967;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28453__auto__ = function(state_29821){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28453__auto____1.call(this,state_29821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28453__auto____0;
cljs$core$async$mult_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28453__auto____1;
return cljs$core$async$mult_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___29911,cs,m,dchan,dctr,done))
})();
var state__28578__auto__ = (function (){var statearr_29908 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_29908[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___29911);

return statearr_29908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___29911,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args29968 = [];
var len__7492__auto___29971 = arguments.length;
var i__7493__auto___29972 = (0);
while(true){
if((i__7493__auto___29972 < len__7492__auto___29971)){
args29968.push((arguments[i__7493__auto___29972]));

var G__29973 = (i__7493__auto___29972 + (1));
i__7493__auto___29972 = G__29973;
continue;
} else {
}
break;
}

var G__29970 = args29968.length;
switch (G__29970) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29968.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7080__auto__ = (((m == null))?null:m);
var m__7081__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7081__auto__.call(null,m,ch));
} else {
var m__7081__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7081__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7080__auto__ = (((m == null))?null:m);
var m__7081__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7081__auto__.call(null,m,ch));
} else {
var m__7081__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7081__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7080__auto__ = (((m == null))?null:m);
var m__7081__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7081__auto__.call(null,m));
} else {
var m__7081__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7081__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7080__auto__ = (((m == null))?null:m);
var m__7081__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7081__auto__.call(null,m,state_map));
} else {
var m__7081__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7081__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7080__auto__ = (((m == null))?null:m);
var m__7081__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7081__auto__.call(null,m,mode));
} else {
var m__7081__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7081__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7499__auto__ = [];
var len__7492__auto___29985 = arguments.length;
var i__7493__auto___29986 = (0);
while(true){
if((i__7493__auto___29986 < len__7492__auto___29985)){
args__7499__auto__.push((arguments[i__7493__auto___29986]));

var G__29987 = (i__7493__auto___29986 + (1));
i__7493__auto___29986 = G__29987;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((3) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7500__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29979){
var map__29980 = p__29979;
var map__29980__$1 = ((((!((map__29980 == null)))?((((map__29980.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29980.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29980):map__29980);
var opts = map__29980__$1;
var statearr_29982_29988 = state;
(statearr_29982_29988[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__29980,map__29980__$1,opts){
return (function (val){
var statearr_29983_29989 = state;
(statearr_29983_29989[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__29980,map__29980__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_29984_29990 = state;
(statearr_29984_29990[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29975){
var G__29976 = cljs.core.first(seq29975);
var seq29975__$1 = cljs.core.next(seq29975);
var G__29977 = cljs.core.first(seq29975__$1);
var seq29975__$2 = cljs.core.next(seq29975__$1);
var G__29978 = cljs.core.first(seq29975__$2);
var seq29975__$3 = cljs.core.next(seq29975__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29976,G__29977,G__29978,seq29975__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__30160 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30160) : cljs.core.atom.call(null,G__30160));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__30161 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30161) : cljs.core.atom.call(null,G__30161));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30162 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30162 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta30163){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta30163 = meta30163;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30162.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30164,meta30163__$1){
var self__ = this;
var _30164__$1 = this;
return (new cljs.core.async.t_cljs$core$async30162(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta30163__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30162.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30164){
var self__ = this;
var _30164__$1 = this;
return self__.meta30163;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30162.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30162.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30162.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async30162.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30162.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30162.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30165_30329 = self__.cs;
var G__30166_30330 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30165_30329,G__30166_30330) : cljs.core.reset_BANG_.call(null,G__30165_30329,G__30166_30330));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30162.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30162.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30162.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta30163], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30162.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30162.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30162";

cljs.core.async.t_cljs$core$async30162.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"cljs.core.async/t_cljs$core$async30162");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async30162 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async30162(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30163){
return (new cljs.core.async.t_cljs$core$async30162(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30163));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async30162(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28576__auto___30331 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___30331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___30331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_30266){
var state_val_30267 = (state_30266[(1)]);
if((state_val_30267 === (7))){
var inst_30182 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
var statearr_30268_30332 = state_30266__$1;
(statearr_30268_30332[(2)] = inst_30182);

(statearr_30268_30332[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (20))){
var inst_30194 = (state_30266[(7)]);
var state_30266__$1 = state_30266;
var statearr_30269_30333 = state_30266__$1;
(statearr_30269_30333[(2)] = inst_30194);

(statearr_30269_30333[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (27))){
var state_30266__$1 = state_30266;
var statearr_30270_30334 = state_30266__$1;
(statearr_30270_30334[(2)] = null);

(statearr_30270_30334[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (1))){
var inst_30170 = (state_30266[(8)]);
var inst_30170__$1 = calc_state();
var inst_30172 = (inst_30170__$1 == null);
var inst_30173 = cljs.core.not(inst_30172);
var state_30266__$1 = (function (){var statearr_30271 = state_30266;
(statearr_30271[(8)] = inst_30170__$1);

return statearr_30271;
})();
if(inst_30173){
var statearr_30272_30335 = state_30266__$1;
(statearr_30272_30335[(1)] = (2));

} else {
var statearr_30273_30336 = state_30266__$1;
(statearr_30273_30336[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (24))){
var inst_30240 = (state_30266[(9)]);
var inst_30217 = (state_30266[(10)]);
var inst_30226 = (state_30266[(11)]);
var inst_30240__$1 = (inst_30217.cljs$core$IFn$_invoke$arity$1 ? inst_30217.cljs$core$IFn$_invoke$arity$1(inst_30226) : inst_30217.call(null,inst_30226));
var state_30266__$1 = (function (){var statearr_30274 = state_30266;
(statearr_30274[(9)] = inst_30240__$1);

return statearr_30274;
})();
if(cljs.core.truth_(inst_30240__$1)){
var statearr_30275_30337 = state_30266__$1;
(statearr_30275_30337[(1)] = (29));

} else {
var statearr_30276_30338 = state_30266__$1;
(statearr_30276_30338[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (4))){
var inst_30185 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
if(cljs.core.truth_(inst_30185)){
var statearr_30277_30339 = state_30266__$1;
(statearr_30277_30339[(1)] = (8));

} else {
var statearr_30278_30340 = state_30266__$1;
(statearr_30278_30340[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (15))){
var inst_30211 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
if(cljs.core.truth_(inst_30211)){
var statearr_30279_30341 = state_30266__$1;
(statearr_30279_30341[(1)] = (19));

} else {
var statearr_30280_30342 = state_30266__$1;
(statearr_30280_30342[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (21))){
var inst_30216 = (state_30266[(12)]);
var inst_30216__$1 = (state_30266[(2)]);
var inst_30217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30216__$1,cljs.core.cst$kw$solos);
var inst_30218 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30216__$1,cljs.core.cst$kw$mutes);
var inst_30219 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30216__$1,cljs.core.cst$kw$reads);
var state_30266__$1 = (function (){var statearr_30281 = state_30266;
(statearr_30281[(13)] = inst_30218);

(statearr_30281[(10)] = inst_30217);

(statearr_30281[(12)] = inst_30216__$1);

return statearr_30281;
})();
return cljs.core.async.ioc_alts_BANG_(state_30266__$1,(22),inst_30219);
} else {
if((state_val_30267 === (31))){
var inst_30248 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
if(cljs.core.truth_(inst_30248)){
var statearr_30282_30343 = state_30266__$1;
(statearr_30282_30343[(1)] = (32));

} else {
var statearr_30283_30344 = state_30266__$1;
(statearr_30283_30344[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (32))){
var inst_30225 = (state_30266[(14)]);
var state_30266__$1 = state_30266;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30266__$1,(35),out,inst_30225);
} else {
if((state_val_30267 === (33))){
var inst_30216 = (state_30266[(12)]);
var inst_30194 = inst_30216;
var state_30266__$1 = (function (){var statearr_30284 = state_30266;
(statearr_30284[(7)] = inst_30194);

return statearr_30284;
})();
var statearr_30285_30345 = state_30266__$1;
(statearr_30285_30345[(2)] = null);

(statearr_30285_30345[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (13))){
var inst_30194 = (state_30266[(7)]);
var inst_30201 = inst_30194.cljs$lang$protocol_mask$partition0$;
var inst_30202 = (inst_30201 & (64));
var inst_30203 = inst_30194.cljs$core$ISeq$;
var inst_30204 = (inst_30202) || (inst_30203);
var state_30266__$1 = state_30266;
if(cljs.core.truth_(inst_30204)){
var statearr_30286_30346 = state_30266__$1;
(statearr_30286_30346[(1)] = (16));

} else {
var statearr_30287_30347 = state_30266__$1;
(statearr_30287_30347[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (22))){
var inst_30225 = (state_30266[(14)]);
var inst_30226 = (state_30266[(11)]);
var inst_30224 = (state_30266[(2)]);
var inst_30225__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30224,(0),null);
var inst_30226__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30224,(1),null);
var inst_30227 = (inst_30225__$1 == null);
var inst_30228 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30226__$1,change);
var inst_30229 = (inst_30227) || (inst_30228);
var state_30266__$1 = (function (){var statearr_30288 = state_30266;
(statearr_30288[(14)] = inst_30225__$1);

(statearr_30288[(11)] = inst_30226__$1);

return statearr_30288;
})();
if(cljs.core.truth_(inst_30229)){
var statearr_30289_30348 = state_30266__$1;
(statearr_30289_30348[(1)] = (23));

} else {
var statearr_30290_30349 = state_30266__$1;
(statearr_30290_30349[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (36))){
var inst_30216 = (state_30266[(12)]);
var inst_30194 = inst_30216;
var state_30266__$1 = (function (){var statearr_30291 = state_30266;
(statearr_30291[(7)] = inst_30194);

return statearr_30291;
})();
var statearr_30292_30350 = state_30266__$1;
(statearr_30292_30350[(2)] = null);

(statearr_30292_30350[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (29))){
var inst_30240 = (state_30266[(9)]);
var state_30266__$1 = state_30266;
var statearr_30293_30351 = state_30266__$1;
(statearr_30293_30351[(2)] = inst_30240);

(statearr_30293_30351[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (6))){
var state_30266__$1 = state_30266;
var statearr_30294_30352 = state_30266__$1;
(statearr_30294_30352[(2)] = false);

(statearr_30294_30352[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (28))){
var inst_30236 = (state_30266[(2)]);
var inst_30237 = calc_state();
var inst_30194 = inst_30237;
var state_30266__$1 = (function (){var statearr_30295 = state_30266;
(statearr_30295[(15)] = inst_30236);

(statearr_30295[(7)] = inst_30194);

return statearr_30295;
})();
var statearr_30296_30353 = state_30266__$1;
(statearr_30296_30353[(2)] = null);

(statearr_30296_30353[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (25))){
var inst_30262 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
var statearr_30297_30354 = state_30266__$1;
(statearr_30297_30354[(2)] = inst_30262);

(statearr_30297_30354[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (34))){
var inst_30260 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
var statearr_30298_30355 = state_30266__$1;
(statearr_30298_30355[(2)] = inst_30260);

(statearr_30298_30355[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (17))){
var state_30266__$1 = state_30266;
var statearr_30299_30356 = state_30266__$1;
(statearr_30299_30356[(2)] = false);

(statearr_30299_30356[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (3))){
var state_30266__$1 = state_30266;
var statearr_30300_30357 = state_30266__$1;
(statearr_30300_30357[(2)] = false);

(statearr_30300_30357[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (12))){
var inst_30264 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30266__$1,inst_30264);
} else {
if((state_val_30267 === (2))){
var inst_30170 = (state_30266[(8)]);
var inst_30175 = inst_30170.cljs$lang$protocol_mask$partition0$;
var inst_30176 = (inst_30175 & (64));
var inst_30177 = inst_30170.cljs$core$ISeq$;
var inst_30178 = (inst_30176) || (inst_30177);
var state_30266__$1 = state_30266;
if(cljs.core.truth_(inst_30178)){
var statearr_30301_30358 = state_30266__$1;
(statearr_30301_30358[(1)] = (5));

} else {
var statearr_30302_30359 = state_30266__$1;
(statearr_30302_30359[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (23))){
var inst_30225 = (state_30266[(14)]);
var inst_30231 = (inst_30225 == null);
var state_30266__$1 = state_30266;
if(cljs.core.truth_(inst_30231)){
var statearr_30303_30360 = state_30266__$1;
(statearr_30303_30360[(1)] = (26));

} else {
var statearr_30304_30361 = state_30266__$1;
(statearr_30304_30361[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (35))){
var inst_30251 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
if(cljs.core.truth_(inst_30251)){
var statearr_30305_30362 = state_30266__$1;
(statearr_30305_30362[(1)] = (36));

} else {
var statearr_30306_30363 = state_30266__$1;
(statearr_30306_30363[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (19))){
var inst_30194 = (state_30266[(7)]);
var inst_30213 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30194);
var state_30266__$1 = state_30266;
var statearr_30307_30364 = state_30266__$1;
(statearr_30307_30364[(2)] = inst_30213);

(statearr_30307_30364[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (11))){
var inst_30194 = (state_30266[(7)]);
var inst_30198 = (inst_30194 == null);
var inst_30199 = cljs.core.not(inst_30198);
var state_30266__$1 = state_30266;
if(inst_30199){
var statearr_30308_30365 = state_30266__$1;
(statearr_30308_30365[(1)] = (13));

} else {
var statearr_30309_30366 = state_30266__$1;
(statearr_30309_30366[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (9))){
var inst_30170 = (state_30266[(8)]);
var state_30266__$1 = state_30266;
var statearr_30310_30367 = state_30266__$1;
(statearr_30310_30367[(2)] = inst_30170);

(statearr_30310_30367[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (5))){
var state_30266__$1 = state_30266;
var statearr_30311_30368 = state_30266__$1;
(statearr_30311_30368[(2)] = true);

(statearr_30311_30368[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (14))){
var state_30266__$1 = state_30266;
var statearr_30312_30369 = state_30266__$1;
(statearr_30312_30369[(2)] = false);

(statearr_30312_30369[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (26))){
var inst_30226 = (state_30266[(11)]);
var inst_30233 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_30226);
var state_30266__$1 = state_30266;
var statearr_30313_30370 = state_30266__$1;
(statearr_30313_30370[(2)] = inst_30233);

(statearr_30313_30370[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (16))){
var state_30266__$1 = state_30266;
var statearr_30314_30371 = state_30266__$1;
(statearr_30314_30371[(2)] = true);

(statearr_30314_30371[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (38))){
var inst_30256 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
var statearr_30315_30372 = state_30266__$1;
(statearr_30315_30372[(2)] = inst_30256);

(statearr_30315_30372[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (30))){
var inst_30218 = (state_30266[(13)]);
var inst_30217 = (state_30266[(10)]);
var inst_30226 = (state_30266[(11)]);
var inst_30243 = cljs.core.empty_QMARK_(inst_30217);
var inst_30244 = (inst_30218.cljs$core$IFn$_invoke$arity$1 ? inst_30218.cljs$core$IFn$_invoke$arity$1(inst_30226) : inst_30218.call(null,inst_30226));
var inst_30245 = cljs.core.not(inst_30244);
var inst_30246 = (inst_30243) && (inst_30245);
var state_30266__$1 = state_30266;
var statearr_30316_30373 = state_30266__$1;
(statearr_30316_30373[(2)] = inst_30246);

(statearr_30316_30373[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (10))){
var inst_30170 = (state_30266[(8)]);
var inst_30190 = (state_30266[(2)]);
var inst_30191 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30190,cljs.core.cst$kw$solos);
var inst_30192 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30190,cljs.core.cst$kw$mutes);
var inst_30193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30190,cljs.core.cst$kw$reads);
var inst_30194 = inst_30170;
var state_30266__$1 = (function (){var statearr_30317 = state_30266;
(statearr_30317[(16)] = inst_30193);

(statearr_30317[(17)] = inst_30192);

(statearr_30317[(18)] = inst_30191);

(statearr_30317[(7)] = inst_30194);

return statearr_30317;
})();
var statearr_30318_30374 = state_30266__$1;
(statearr_30318_30374[(2)] = null);

(statearr_30318_30374[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (18))){
var inst_30208 = (state_30266[(2)]);
var state_30266__$1 = state_30266;
var statearr_30319_30375 = state_30266__$1;
(statearr_30319_30375[(2)] = inst_30208);

(statearr_30319_30375[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (37))){
var state_30266__$1 = state_30266;
var statearr_30320_30376 = state_30266__$1;
(statearr_30320_30376[(2)] = null);

(statearr_30320_30376[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30267 === (8))){
var inst_30170 = (state_30266[(8)]);
var inst_30187 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_30170);
var state_30266__$1 = state_30266;
var statearr_30321_30377 = state_30266__$1;
(statearr_30321_30377[(2)] = inst_30187);

(statearr_30321_30377[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___30331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__28452__auto__,c__28576__auto___30331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__28453__auto__ = null;
var cljs$core$async$mix_$_state_machine__28453__auto____0 = (function (){
var statearr_30325 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30325[(0)] = cljs$core$async$mix_$_state_machine__28453__auto__);

(statearr_30325[(1)] = (1));

return statearr_30325;
});
var cljs$core$async$mix_$_state_machine__28453__auto____1 = (function (state_30266){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_30266);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e30326){if((e30326 instanceof Object)){
var ex__28456__auto__ = e30326;
var statearr_30327_30378 = state_30266;
(statearr_30327_30378[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30266);

return cljs.core.cst$kw$recur;
} else {
throw e30326;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__30379 = state_30266;
state_30266 = G__30379;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28453__auto__ = function(state_30266){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28453__auto____1.call(this,state_30266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28453__auto____0;
cljs$core$async$mix_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28453__auto____1;
return cljs$core$async$mix_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___30331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__28578__auto__ = (function (){var statearr_30328 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_30328[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___30331);

return statearr_30328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___30331,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7080__auto__ = (((p == null))?null:p);
var m__7081__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7081__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7081__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7081__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7080__auto__ = (((p == null))?null:p);
var m__7081__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7081__auto__.call(null,p,v,ch));
} else {
var m__7081__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7081__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args30380 = [];
var len__7492__auto___30383 = arguments.length;
var i__7493__auto___30384 = (0);
while(true){
if((i__7493__auto___30384 < len__7492__auto___30383)){
args30380.push((arguments[i__7493__auto___30384]));

var G__30385 = (i__7493__auto___30384 + (1));
i__7493__auto___30384 = G__30385;
continue;
} else {
}
break;
}

var G__30382 = args30380.length;
switch (G__30382) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30380.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7080__auto__ = (((p == null))?null:p);
var m__7081__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7081__auto__.call(null,p));
} else {
var m__7081__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7081__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7080__auto__ = (((p == null))?null:p);
var m__7081__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7080__auto__)]);
if(!((m__7081__auto__ == null))){
return (m__7081__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7081__auto__.call(null,p,v));
} else {
var m__7081__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7081__auto____$1 == null))){
return (m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7081__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7081__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args30388 = [];
var len__7492__auto___30516 = arguments.length;
var i__7493__auto___30517 = (0);
while(true){
if((i__7493__auto___30517 < len__7492__auto___30516)){
args30388.push((arguments[i__7493__auto___30517]));

var G__30518 = (i__7493__auto___30517 + (1));
i__7493__auto___30517 = G__30518;
continue;
} else {
}
break;
}

var G__30390 = args30388.length;
switch (G__30390) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30388.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__30391 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30391) : cljs.core.atom.call(null,G__30391));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6417__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6417__auto__,mults){
return (function (p1__30387_SHARP_){
if(cljs.core.truth_((p1__30387_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__30387_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__30387_SHARP_.call(null,topic)))){
return p1__30387_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30387_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6417__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async30392 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30392 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta30393){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta30393 = meta30393;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30392.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_30394,meta30393__$1){
var self__ = this;
var _30394__$1 = this;
return (new cljs.core.async.t_cljs$core$async30392(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta30393__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30392.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_30394){
var self__ = this;
var _30394__$1 = this;
return self__.meta30393;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30392.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30392.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30392.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async30392.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30392.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30392.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30395 = self__.mults;
var G__30396 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30395,G__30396) : cljs.core.reset_BANG_.call(null,G__30395,G__30396));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30392.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30392.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta30393], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async30392.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30392.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30392";

cljs.core.async.t_cljs$core$async30392.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"cljs.core.async/t_cljs$core$async30392");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async30392 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async30392(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta30393){
return (new cljs.core.async.t_cljs$core$async30392(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta30393));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async30392(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28576__auto___30520 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___30520,mults,ensure_mult,p){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___30520,mults,ensure_mult,p){
return (function (state_30468){
var state_val_30469 = (state_30468[(1)]);
if((state_val_30469 === (7))){
var inst_30464 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30470_30521 = state_30468__$1;
(statearr_30470_30521[(2)] = inst_30464);

(statearr_30470_30521[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (20))){
var state_30468__$1 = state_30468;
var statearr_30471_30522 = state_30468__$1;
(statearr_30471_30522[(2)] = null);

(statearr_30471_30522[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (1))){
var state_30468__$1 = state_30468;
var statearr_30472_30523 = state_30468__$1;
(statearr_30472_30523[(2)] = null);

(statearr_30472_30523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (24))){
var inst_30447 = (state_30468[(7)]);
var inst_30456 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_30447);
var state_30468__$1 = state_30468;
var statearr_30473_30524 = state_30468__$1;
(statearr_30473_30524[(2)] = inst_30456);

(statearr_30473_30524[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (4))){
var inst_30399 = (state_30468[(8)]);
var inst_30399__$1 = (state_30468[(2)]);
var inst_30400 = (inst_30399__$1 == null);
var state_30468__$1 = (function (){var statearr_30474 = state_30468;
(statearr_30474[(8)] = inst_30399__$1);

return statearr_30474;
})();
if(cljs.core.truth_(inst_30400)){
var statearr_30475_30525 = state_30468__$1;
(statearr_30475_30525[(1)] = (5));

} else {
var statearr_30476_30526 = state_30468__$1;
(statearr_30476_30526[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (15))){
var inst_30441 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30477_30527 = state_30468__$1;
(statearr_30477_30527[(2)] = inst_30441);

(statearr_30477_30527[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (21))){
var inst_30461 = (state_30468[(2)]);
var state_30468__$1 = (function (){var statearr_30478 = state_30468;
(statearr_30478[(9)] = inst_30461);

return statearr_30478;
})();
var statearr_30479_30528 = state_30468__$1;
(statearr_30479_30528[(2)] = null);

(statearr_30479_30528[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (13))){
var inst_30423 = (state_30468[(10)]);
var inst_30425 = cljs.core.chunked_seq_QMARK_(inst_30423);
var state_30468__$1 = state_30468;
if(inst_30425){
var statearr_30480_30529 = state_30468__$1;
(statearr_30480_30529[(1)] = (16));

} else {
var statearr_30481_30530 = state_30468__$1;
(statearr_30481_30530[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (22))){
var inst_30453 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
if(cljs.core.truth_(inst_30453)){
var statearr_30482_30531 = state_30468__$1;
(statearr_30482_30531[(1)] = (23));

} else {
var statearr_30483_30532 = state_30468__$1;
(statearr_30483_30532[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (6))){
var inst_30447 = (state_30468[(7)]);
var inst_30399 = (state_30468[(8)]);
var inst_30449 = (state_30468[(11)]);
var inst_30447__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_30399) : topic_fn.call(null,inst_30399));
var inst_30448 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_30449__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30448,inst_30447__$1);
var state_30468__$1 = (function (){var statearr_30484 = state_30468;
(statearr_30484[(7)] = inst_30447__$1);

(statearr_30484[(11)] = inst_30449__$1);

return statearr_30484;
})();
if(cljs.core.truth_(inst_30449__$1)){
var statearr_30485_30533 = state_30468__$1;
(statearr_30485_30533[(1)] = (19));

} else {
var statearr_30486_30534 = state_30468__$1;
(statearr_30486_30534[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (25))){
var inst_30458 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30487_30535 = state_30468__$1;
(statearr_30487_30535[(2)] = inst_30458);

(statearr_30487_30535[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (17))){
var inst_30423 = (state_30468[(10)]);
var inst_30432 = cljs.core.first(inst_30423);
var inst_30433 = cljs.core.async.muxch_STAR_(inst_30432);
var inst_30434 = cljs.core.async.close_BANG_(inst_30433);
var inst_30435 = cljs.core.next(inst_30423);
var inst_30409 = inst_30435;
var inst_30410 = null;
var inst_30411 = (0);
var inst_30412 = (0);
var state_30468__$1 = (function (){var statearr_30488 = state_30468;
(statearr_30488[(12)] = inst_30409);

(statearr_30488[(13)] = inst_30434);

(statearr_30488[(14)] = inst_30411);

(statearr_30488[(15)] = inst_30410);

(statearr_30488[(16)] = inst_30412);

return statearr_30488;
})();
var statearr_30489_30536 = state_30468__$1;
(statearr_30489_30536[(2)] = null);

(statearr_30489_30536[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (3))){
var inst_30466 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30468__$1,inst_30466);
} else {
if((state_val_30469 === (12))){
var inst_30443 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30490_30537 = state_30468__$1;
(statearr_30490_30537[(2)] = inst_30443);

(statearr_30490_30537[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (2))){
var state_30468__$1 = state_30468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30468__$1,(4),ch);
} else {
if((state_val_30469 === (23))){
var state_30468__$1 = state_30468;
var statearr_30491_30538 = state_30468__$1;
(statearr_30491_30538[(2)] = null);

(statearr_30491_30538[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (19))){
var inst_30399 = (state_30468[(8)]);
var inst_30449 = (state_30468[(11)]);
var inst_30451 = cljs.core.async.muxch_STAR_(inst_30449);
var state_30468__$1 = state_30468;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30468__$1,(22),inst_30451,inst_30399);
} else {
if((state_val_30469 === (11))){
var inst_30409 = (state_30468[(12)]);
var inst_30423 = (state_30468[(10)]);
var inst_30423__$1 = cljs.core.seq(inst_30409);
var state_30468__$1 = (function (){var statearr_30492 = state_30468;
(statearr_30492[(10)] = inst_30423__$1);

return statearr_30492;
})();
if(inst_30423__$1){
var statearr_30493_30539 = state_30468__$1;
(statearr_30493_30539[(1)] = (13));

} else {
var statearr_30494_30540 = state_30468__$1;
(statearr_30494_30540[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (9))){
var inst_30445 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30495_30541 = state_30468__$1;
(statearr_30495_30541[(2)] = inst_30445);

(statearr_30495_30541[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (5))){
var inst_30406 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_30407 = cljs.core.vals(inst_30406);
var inst_30408 = cljs.core.seq(inst_30407);
var inst_30409 = inst_30408;
var inst_30410 = null;
var inst_30411 = (0);
var inst_30412 = (0);
var state_30468__$1 = (function (){var statearr_30496 = state_30468;
(statearr_30496[(12)] = inst_30409);

(statearr_30496[(14)] = inst_30411);

(statearr_30496[(15)] = inst_30410);

(statearr_30496[(16)] = inst_30412);

return statearr_30496;
})();
var statearr_30497_30542 = state_30468__$1;
(statearr_30497_30542[(2)] = null);

(statearr_30497_30542[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (14))){
var state_30468__$1 = state_30468;
var statearr_30501_30543 = state_30468__$1;
(statearr_30501_30543[(2)] = null);

(statearr_30501_30543[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (16))){
var inst_30423 = (state_30468[(10)]);
var inst_30427 = cljs.core.chunk_first(inst_30423);
var inst_30428 = cljs.core.chunk_rest(inst_30423);
var inst_30429 = cljs.core.count(inst_30427);
var inst_30409 = inst_30428;
var inst_30410 = inst_30427;
var inst_30411 = inst_30429;
var inst_30412 = (0);
var state_30468__$1 = (function (){var statearr_30502 = state_30468;
(statearr_30502[(12)] = inst_30409);

(statearr_30502[(14)] = inst_30411);

(statearr_30502[(15)] = inst_30410);

(statearr_30502[(16)] = inst_30412);

return statearr_30502;
})();
var statearr_30503_30544 = state_30468__$1;
(statearr_30503_30544[(2)] = null);

(statearr_30503_30544[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (10))){
var inst_30409 = (state_30468[(12)]);
var inst_30411 = (state_30468[(14)]);
var inst_30410 = (state_30468[(15)]);
var inst_30412 = (state_30468[(16)]);
var inst_30417 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_30410,inst_30412);
var inst_30418 = cljs.core.async.muxch_STAR_(inst_30417);
var inst_30419 = cljs.core.async.close_BANG_(inst_30418);
var inst_30420 = (inst_30412 + (1));
var tmp30498 = inst_30409;
var tmp30499 = inst_30411;
var tmp30500 = inst_30410;
var inst_30409__$1 = tmp30498;
var inst_30410__$1 = tmp30500;
var inst_30411__$1 = tmp30499;
var inst_30412__$1 = inst_30420;
var state_30468__$1 = (function (){var statearr_30504 = state_30468;
(statearr_30504[(12)] = inst_30409__$1);

(statearr_30504[(17)] = inst_30419);

(statearr_30504[(14)] = inst_30411__$1);

(statearr_30504[(15)] = inst_30410__$1);

(statearr_30504[(16)] = inst_30412__$1);

return statearr_30504;
})();
var statearr_30505_30545 = state_30468__$1;
(statearr_30505_30545[(2)] = null);

(statearr_30505_30545[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (18))){
var inst_30438 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30506_30546 = state_30468__$1;
(statearr_30506_30546[(2)] = inst_30438);

(statearr_30506_30546[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (8))){
var inst_30411 = (state_30468[(14)]);
var inst_30412 = (state_30468[(16)]);
var inst_30414 = (inst_30412 < inst_30411);
var inst_30415 = inst_30414;
var state_30468__$1 = state_30468;
if(cljs.core.truth_(inst_30415)){
var statearr_30507_30547 = state_30468__$1;
(statearr_30507_30547[(1)] = (10));

} else {
var statearr_30508_30548 = state_30468__$1;
(statearr_30508_30548[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___30520,mults,ensure_mult,p))
;
return ((function (switch__28452__auto__,c__28576__auto___30520,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_30512 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30512[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_30512[(1)] = (1));

return statearr_30512;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_30468){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_30468);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e30513){if((e30513 instanceof Object)){
var ex__28456__auto__ = e30513;
var statearr_30514_30549 = state_30468;
(statearr_30514_30549[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30468);

return cljs.core.cst$kw$recur;
} else {
throw e30513;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__30550 = state_30468;
state_30468 = G__30550;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_30468){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_30468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___30520,mults,ensure_mult,p))
})();
var state__28578__auto__ = (function (){var statearr_30515 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_30515[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___30520);

return statearr_30515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___30520,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args30551 = [];
var len__7492__auto___30554 = arguments.length;
var i__7493__auto___30555 = (0);
while(true){
if((i__7493__auto___30555 < len__7492__auto___30554)){
args30551.push((arguments[i__7493__auto___30555]));

var G__30556 = (i__7493__auto___30555 + (1));
i__7493__auto___30555 = G__30556;
continue;
} else {
}
break;
}

var G__30553 = args30551.length;
switch (G__30553) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30551.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args30558 = [];
var len__7492__auto___30561 = arguments.length;
var i__7493__auto___30562 = (0);
while(true){
if((i__7493__auto___30562 < len__7492__auto___30561)){
args30558.push((arguments[i__7493__auto___30562]));

var G__30563 = (i__7493__auto___30562 + (1));
i__7493__auto___30562 = G__30563;
continue;
} else {
}
break;
}

var G__30560 = args30558.length;
switch (G__30560) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30558.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args30565 = [];
var len__7492__auto___30636 = arguments.length;
var i__7493__auto___30637 = (0);
while(true){
if((i__7493__auto___30637 < len__7492__auto___30636)){
args30565.push((arguments[i__7493__auto___30637]));

var G__30638 = (i__7493__auto___30637 + (1));
i__7493__auto___30637 = G__30638;
continue;
} else {
}
break;
}

var G__30567 = args30565.length;
switch (G__30567) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30565.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__28576__auto___30640 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___30640,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___30640,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_30606){
var state_val_30607 = (state_30606[(1)]);
if((state_val_30607 === (7))){
var state_30606__$1 = state_30606;
var statearr_30608_30641 = state_30606__$1;
(statearr_30608_30641[(2)] = null);

(statearr_30608_30641[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (1))){
var state_30606__$1 = state_30606;
var statearr_30609_30642 = state_30606__$1;
(statearr_30609_30642[(2)] = null);

(statearr_30609_30642[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (4))){
var inst_30570 = (state_30606[(7)]);
var inst_30572 = (inst_30570 < cnt);
var state_30606__$1 = state_30606;
if(cljs.core.truth_(inst_30572)){
var statearr_30610_30643 = state_30606__$1;
(statearr_30610_30643[(1)] = (6));

} else {
var statearr_30611_30644 = state_30606__$1;
(statearr_30611_30644[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (15))){
var inst_30602 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
var statearr_30612_30645 = state_30606__$1;
(statearr_30612_30645[(2)] = inst_30602);

(statearr_30612_30645[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (13))){
var inst_30595 = cljs.core.async.close_BANG_(out);
var state_30606__$1 = state_30606;
var statearr_30613_30646 = state_30606__$1;
(statearr_30613_30646[(2)] = inst_30595);

(statearr_30613_30646[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (6))){
var state_30606__$1 = state_30606;
var statearr_30614_30647 = state_30606__$1;
(statearr_30614_30647[(2)] = null);

(statearr_30614_30647[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (3))){
var inst_30604 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30606__$1,inst_30604);
} else {
if((state_val_30607 === (12))){
var inst_30592 = (state_30606[(8)]);
var inst_30592__$1 = (state_30606[(2)]);
var inst_30593 = cljs.core.some(cljs.core.nil_QMARK_,inst_30592__$1);
var state_30606__$1 = (function (){var statearr_30615 = state_30606;
(statearr_30615[(8)] = inst_30592__$1);

return statearr_30615;
})();
if(cljs.core.truth_(inst_30593)){
var statearr_30616_30648 = state_30606__$1;
(statearr_30616_30648[(1)] = (13));

} else {
var statearr_30617_30649 = state_30606__$1;
(statearr_30617_30649[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (2))){
var inst_30569 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_30570 = (0);
var state_30606__$1 = (function (){var statearr_30618 = state_30606;
(statearr_30618[(9)] = inst_30569);

(statearr_30618[(7)] = inst_30570);

return statearr_30618;
})();
var statearr_30619_30650 = state_30606__$1;
(statearr_30619_30650[(2)] = null);

(statearr_30619_30650[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (11))){
var inst_30570 = (state_30606[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_30606,(10),Object,null,(9));
var inst_30579 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_30570) : chs__$1.call(null,inst_30570));
var inst_30580 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_30570) : done.call(null,inst_30570));
var inst_30581 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_30579,inst_30580);
var state_30606__$1 = state_30606;
var statearr_30620_30651 = state_30606__$1;
(statearr_30620_30651[(2)] = inst_30581);


cljs.core.async.impl.ioc_helpers.process_exception(state_30606__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (9))){
var inst_30570 = (state_30606[(7)]);
var inst_30583 = (state_30606[(2)]);
var inst_30584 = (inst_30570 + (1));
var inst_30570__$1 = inst_30584;
var state_30606__$1 = (function (){var statearr_30621 = state_30606;
(statearr_30621[(10)] = inst_30583);

(statearr_30621[(7)] = inst_30570__$1);

return statearr_30621;
})();
var statearr_30622_30652 = state_30606__$1;
(statearr_30622_30652[(2)] = null);

(statearr_30622_30652[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (5))){
var inst_30590 = (state_30606[(2)]);
var state_30606__$1 = (function (){var statearr_30623 = state_30606;
(statearr_30623[(11)] = inst_30590);

return statearr_30623;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30606__$1,(12),dchan);
} else {
if((state_val_30607 === (14))){
var inst_30592 = (state_30606[(8)]);
var inst_30597 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_30592);
var state_30606__$1 = state_30606;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30606__$1,(16),out,inst_30597);
} else {
if((state_val_30607 === (16))){
var inst_30599 = (state_30606[(2)]);
var state_30606__$1 = (function (){var statearr_30624 = state_30606;
(statearr_30624[(12)] = inst_30599);

return statearr_30624;
})();
var statearr_30625_30653 = state_30606__$1;
(statearr_30625_30653[(2)] = null);

(statearr_30625_30653[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (10))){
var inst_30574 = (state_30606[(2)]);
var inst_30575 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_30606__$1 = (function (){var statearr_30626 = state_30606;
(statearr_30626[(13)] = inst_30574);

return statearr_30626;
})();
var statearr_30627_30654 = state_30606__$1;
(statearr_30627_30654[(2)] = inst_30575);


cljs.core.async.impl.ioc_helpers.process_exception(state_30606__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_30607 === (8))){
var inst_30588 = (state_30606[(2)]);
var state_30606__$1 = state_30606;
var statearr_30628_30655 = state_30606__$1;
(statearr_30628_30655[(2)] = inst_30588);

(statearr_30628_30655[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___30640,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__28452__auto__,c__28576__auto___30640,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_30632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30632[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_30632[(1)] = (1));

return statearr_30632;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_30606){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_30606);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e30633){if((e30633 instanceof Object)){
var ex__28456__auto__ = e30633;
var statearr_30634_30656 = state_30606;
(statearr_30634_30656[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30606);

return cljs.core.cst$kw$recur;
} else {
throw e30633;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__30657 = state_30606;
state_30606 = G__30657;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_30606){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_30606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___30640,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__28578__auto__ = (function (){var statearr_30635 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_30635[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___30640);

return statearr_30635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___30640,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args30659 = [];
var len__7492__auto___30717 = arguments.length;
var i__7493__auto___30718 = (0);
while(true){
if((i__7493__auto___30718 < len__7492__auto___30717)){
args30659.push((arguments[i__7493__auto___30718]));

var G__30719 = (i__7493__auto___30718 + (1));
i__7493__auto___30718 = G__30719;
continue;
} else {
}
break;
}

var G__30661 = args30659.length;
switch (G__30661) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30659.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28576__auto___30721 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___30721,out){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___30721,out){
return (function (state_30693){
var state_val_30694 = (state_30693[(1)]);
if((state_val_30694 === (7))){
var inst_30672 = (state_30693[(7)]);
var inst_30673 = (state_30693[(8)]);
var inst_30672__$1 = (state_30693[(2)]);
var inst_30673__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30672__$1,(0),null);
var inst_30674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30672__$1,(1),null);
var inst_30675 = (inst_30673__$1 == null);
var state_30693__$1 = (function (){var statearr_30695 = state_30693;
(statearr_30695[(9)] = inst_30674);

(statearr_30695[(7)] = inst_30672__$1);

(statearr_30695[(8)] = inst_30673__$1);

return statearr_30695;
})();
if(cljs.core.truth_(inst_30675)){
var statearr_30696_30722 = state_30693__$1;
(statearr_30696_30722[(1)] = (8));

} else {
var statearr_30697_30723 = state_30693__$1;
(statearr_30697_30723[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30694 === (1))){
var inst_30662 = cljs.core.vec(chs);
var inst_30663 = inst_30662;
var state_30693__$1 = (function (){var statearr_30698 = state_30693;
(statearr_30698[(10)] = inst_30663);

return statearr_30698;
})();
var statearr_30699_30724 = state_30693__$1;
(statearr_30699_30724[(2)] = null);

(statearr_30699_30724[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30694 === (4))){
var inst_30663 = (state_30693[(10)]);
var state_30693__$1 = state_30693;
return cljs.core.async.ioc_alts_BANG_(state_30693__$1,(7),inst_30663);
} else {
if((state_val_30694 === (6))){
var inst_30689 = (state_30693[(2)]);
var state_30693__$1 = state_30693;
var statearr_30700_30725 = state_30693__$1;
(statearr_30700_30725[(2)] = inst_30689);

(statearr_30700_30725[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30694 === (3))){
var inst_30691 = (state_30693[(2)]);
var state_30693__$1 = state_30693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30693__$1,inst_30691);
} else {
if((state_val_30694 === (2))){
var inst_30663 = (state_30693[(10)]);
var inst_30665 = cljs.core.count(inst_30663);
var inst_30666 = (inst_30665 > (0));
var state_30693__$1 = state_30693;
if(cljs.core.truth_(inst_30666)){
var statearr_30702_30726 = state_30693__$1;
(statearr_30702_30726[(1)] = (4));

} else {
var statearr_30703_30727 = state_30693__$1;
(statearr_30703_30727[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30694 === (11))){
var inst_30663 = (state_30693[(10)]);
var inst_30682 = (state_30693[(2)]);
var tmp30701 = inst_30663;
var inst_30663__$1 = tmp30701;
var state_30693__$1 = (function (){var statearr_30704 = state_30693;
(statearr_30704[(10)] = inst_30663__$1);

(statearr_30704[(11)] = inst_30682);

return statearr_30704;
})();
var statearr_30705_30728 = state_30693__$1;
(statearr_30705_30728[(2)] = null);

(statearr_30705_30728[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30694 === (9))){
var inst_30673 = (state_30693[(8)]);
var state_30693__$1 = state_30693;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30693__$1,(11),out,inst_30673);
} else {
if((state_val_30694 === (5))){
var inst_30687 = cljs.core.async.close_BANG_(out);
var state_30693__$1 = state_30693;
var statearr_30706_30729 = state_30693__$1;
(statearr_30706_30729[(2)] = inst_30687);

(statearr_30706_30729[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30694 === (10))){
var inst_30685 = (state_30693[(2)]);
var state_30693__$1 = state_30693;
var statearr_30707_30730 = state_30693__$1;
(statearr_30707_30730[(2)] = inst_30685);

(statearr_30707_30730[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30694 === (8))){
var inst_30663 = (state_30693[(10)]);
var inst_30674 = (state_30693[(9)]);
var inst_30672 = (state_30693[(7)]);
var inst_30673 = (state_30693[(8)]);
var inst_30677 = (function (){var cs = inst_30663;
var vec__30668 = inst_30672;
var v = inst_30673;
var c = inst_30674;
return ((function (cs,vec__30668,v,c,inst_30663,inst_30674,inst_30672,inst_30673,state_val_30694,c__28576__auto___30721,out){
return (function (p1__30658_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__30658_SHARP_);
});
;})(cs,vec__30668,v,c,inst_30663,inst_30674,inst_30672,inst_30673,state_val_30694,c__28576__auto___30721,out))
})();
var inst_30678 = cljs.core.filterv(inst_30677,inst_30663);
var inst_30663__$1 = inst_30678;
var state_30693__$1 = (function (){var statearr_30708 = state_30693;
(statearr_30708[(10)] = inst_30663__$1);

return statearr_30708;
})();
var statearr_30709_30731 = state_30693__$1;
(statearr_30709_30731[(2)] = null);

(statearr_30709_30731[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___30721,out))
;
return ((function (switch__28452__auto__,c__28576__auto___30721,out){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_30713 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30713[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_30713[(1)] = (1));

return statearr_30713;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_30693){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_30693);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e30714){if((e30714 instanceof Object)){
var ex__28456__auto__ = e30714;
var statearr_30715_30732 = state_30693;
(statearr_30715_30732[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30693);

return cljs.core.cst$kw$recur;
} else {
throw e30714;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__30733 = state_30693;
state_30693 = G__30733;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_30693){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_30693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___30721,out))
})();
var state__28578__auto__ = (function (){var statearr_30716 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_30716[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___30721);

return statearr_30716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___30721,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args30734 = [];
var len__7492__auto___30783 = arguments.length;
var i__7493__auto___30784 = (0);
while(true){
if((i__7493__auto___30784 < len__7492__auto___30783)){
args30734.push((arguments[i__7493__auto___30784]));

var G__30785 = (i__7493__auto___30784 + (1));
i__7493__auto___30784 = G__30785;
continue;
} else {
}
break;
}

var G__30736 = args30734.length;
switch (G__30736) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30734.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28576__auto___30787 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___30787,out){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___30787,out){
return (function (state_30760){
var state_val_30761 = (state_30760[(1)]);
if((state_val_30761 === (7))){
var inst_30742 = (state_30760[(7)]);
var inst_30742__$1 = (state_30760[(2)]);
var inst_30743 = (inst_30742__$1 == null);
var inst_30744 = cljs.core.not(inst_30743);
var state_30760__$1 = (function (){var statearr_30762 = state_30760;
(statearr_30762[(7)] = inst_30742__$1);

return statearr_30762;
})();
if(inst_30744){
var statearr_30763_30788 = state_30760__$1;
(statearr_30763_30788[(1)] = (8));

} else {
var statearr_30764_30789 = state_30760__$1;
(statearr_30764_30789[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30761 === (1))){
var inst_30737 = (0);
var state_30760__$1 = (function (){var statearr_30765 = state_30760;
(statearr_30765[(8)] = inst_30737);

return statearr_30765;
})();
var statearr_30766_30790 = state_30760__$1;
(statearr_30766_30790[(2)] = null);

(statearr_30766_30790[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30761 === (4))){
var state_30760__$1 = state_30760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30760__$1,(7),ch);
} else {
if((state_val_30761 === (6))){
var inst_30755 = (state_30760[(2)]);
var state_30760__$1 = state_30760;
var statearr_30767_30791 = state_30760__$1;
(statearr_30767_30791[(2)] = inst_30755);

(statearr_30767_30791[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30761 === (3))){
var inst_30757 = (state_30760[(2)]);
var inst_30758 = cljs.core.async.close_BANG_(out);
var state_30760__$1 = (function (){var statearr_30768 = state_30760;
(statearr_30768[(9)] = inst_30757);

return statearr_30768;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30760__$1,inst_30758);
} else {
if((state_val_30761 === (2))){
var inst_30737 = (state_30760[(8)]);
var inst_30739 = (inst_30737 < n);
var state_30760__$1 = state_30760;
if(cljs.core.truth_(inst_30739)){
var statearr_30769_30792 = state_30760__$1;
(statearr_30769_30792[(1)] = (4));

} else {
var statearr_30770_30793 = state_30760__$1;
(statearr_30770_30793[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30761 === (11))){
var inst_30737 = (state_30760[(8)]);
var inst_30747 = (state_30760[(2)]);
var inst_30748 = (inst_30737 + (1));
var inst_30737__$1 = inst_30748;
var state_30760__$1 = (function (){var statearr_30771 = state_30760;
(statearr_30771[(10)] = inst_30747);

(statearr_30771[(8)] = inst_30737__$1);

return statearr_30771;
})();
var statearr_30772_30794 = state_30760__$1;
(statearr_30772_30794[(2)] = null);

(statearr_30772_30794[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30761 === (9))){
var state_30760__$1 = state_30760;
var statearr_30773_30795 = state_30760__$1;
(statearr_30773_30795[(2)] = null);

(statearr_30773_30795[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30761 === (5))){
var state_30760__$1 = state_30760;
var statearr_30774_30796 = state_30760__$1;
(statearr_30774_30796[(2)] = null);

(statearr_30774_30796[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30761 === (10))){
var inst_30752 = (state_30760[(2)]);
var state_30760__$1 = state_30760;
var statearr_30775_30797 = state_30760__$1;
(statearr_30775_30797[(2)] = inst_30752);

(statearr_30775_30797[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30761 === (8))){
var inst_30742 = (state_30760[(7)]);
var state_30760__$1 = state_30760;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30760__$1,(11),out,inst_30742);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___30787,out))
;
return ((function (switch__28452__auto__,c__28576__auto___30787,out){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_30779 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30779[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_30779[(1)] = (1));

return statearr_30779;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_30760){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_30760);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e30780){if((e30780 instanceof Object)){
var ex__28456__auto__ = e30780;
var statearr_30781_30798 = state_30760;
(statearr_30781_30798[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30760);

return cljs.core.cst$kw$recur;
} else {
throw e30780;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__30799 = state_30760;
state_30760 = G__30799;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_30760){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_30760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___30787,out))
})();
var state__28578__auto__ = (function (){var statearr_30782 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_30782[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___30787);

return statearr_30782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___30787,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async30809 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30809 = (function (map_LT_,f,ch,meta30810){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta30810 = meta30810;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30809.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30811,meta30810__$1){
var self__ = this;
var _30811__$1 = this;
return (new cljs.core.async.t_cljs$core$async30809(self__.map_LT_,self__.f,self__.ch,meta30810__$1));
});

cljs.core.async.t_cljs$core$async30809.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30811){
var self__ = this;
var _30811__$1 = this;
return self__.meta30810;
});

cljs.core.async.t_cljs$core$async30809.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async30809.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async30809.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async30809.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async30809.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async30812 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30812 = (function (map_LT_,f,ch,meta30810,_,fn1,meta30813){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta30810 = meta30810;
this._ = _;
this.fn1 = fn1;
this.meta30813 = meta30813;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30812.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_30814,meta30813__$1){
var self__ = this;
var _30814__$1 = this;
return (new cljs.core.async.t_cljs$core$async30812(self__.map_LT_,self__.f,self__.ch,self__.meta30810,self__._,self__.fn1,meta30813__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async30812.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_30814){
var self__ = this;
var _30814__$1 = this;
return self__.meta30813;
});})(___$1))
;

cljs.core.async.t_cljs$core$async30812.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async30812.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async30812.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async30812.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__30800_SHARP_){
var G__30815 = (((p1__30800_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__30800_SHARP_) : self__.f.call(null,p1__30800_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__30815) : f1.call(null,G__30815));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async30812.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta30810,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async30809], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta30813], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async30812.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30812.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30812";

cljs.core.async.t_cljs$core$async30812.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"cljs.core.async/t_cljs$core$async30812");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async30812 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30812(map_LT___$1,f__$1,ch__$1,meta30810__$1,___$2,fn1__$1,meta30813){
return (new cljs.core.async.t_cljs$core$async30812(map_LT___$1,f__$1,ch__$1,meta30810__$1,___$2,fn1__$1,meta30813));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async30812(self__.map_LT_,self__.f,self__.ch,self__.meta30810,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6405__auto__ = ret;
if(cljs.core.truth_(and__6405__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6405__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__30816 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__30816) : self__.f.call(null,G__30816));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async30809.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async30809.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async30809.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta30810], null);
});

cljs.core.async.t_cljs$core$async30809.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30809.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30809";

cljs.core.async.t_cljs$core$async30809.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"cljs.core.async/t_cljs$core$async30809");
});

cljs.core.async.__GT_t_cljs$core$async30809 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30809(map_LT___$1,f__$1,ch__$1,meta30810){
return (new cljs.core.async.t_cljs$core$async30809(map_LT___$1,f__$1,ch__$1,meta30810));
});

}

return (new cljs.core.async.t_cljs$core$async30809(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async30820 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30820 = (function (map_GT_,f,ch,meta30821){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta30821 = meta30821;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30820.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30822,meta30821__$1){
var self__ = this;
var _30822__$1 = this;
return (new cljs.core.async.t_cljs$core$async30820(self__.map_GT_,self__.f,self__.ch,meta30821__$1));
});

cljs.core.async.t_cljs$core$async30820.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30822){
var self__ = this;
var _30822__$1 = this;
return self__.meta30821;
});

cljs.core.async.t_cljs$core$async30820.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async30820.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async30820.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async30820.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async30820.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async30820.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async30820.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta30821], null);
});

cljs.core.async.t_cljs$core$async30820.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30820.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30820";

cljs.core.async.t_cljs$core$async30820.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"cljs.core.async/t_cljs$core$async30820");
});

cljs.core.async.__GT_t_cljs$core$async30820 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30820(map_GT___$1,f__$1,ch__$1,meta30821){
return (new cljs.core.async.t_cljs$core$async30820(map_GT___$1,f__$1,ch__$1,meta30821));
});

}

return (new cljs.core.async.t_cljs$core$async30820(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async30826 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30826 = (function (filter_GT_,p,ch,meta30827){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta30827 = meta30827;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30826.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30828,meta30827__$1){
var self__ = this;
var _30828__$1 = this;
return (new cljs.core.async.t_cljs$core$async30826(self__.filter_GT_,self__.p,self__.ch,meta30827__$1));
});

cljs.core.async.t_cljs$core$async30826.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30828){
var self__ = this;
var _30828__$1 = this;
return self__.meta30827;
});

cljs.core.async.t_cljs$core$async30826.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async30826.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async30826.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async30826.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async30826.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async30826.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async30826.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async30826.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta30827], null);
});

cljs.core.async.t_cljs$core$async30826.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30826.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30826";

cljs.core.async.t_cljs$core$async30826.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"cljs.core.async/t_cljs$core$async30826");
});

cljs.core.async.__GT_t_cljs$core$async30826 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30826(filter_GT___$1,p__$1,ch__$1,meta30827){
return (new cljs.core.async.t_cljs$core$async30826(filter_GT___$1,p__$1,ch__$1,meta30827));
});

}

return (new cljs.core.async.t_cljs$core$async30826(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args30829 = [];
var len__7492__auto___30873 = arguments.length;
var i__7493__auto___30874 = (0);
while(true){
if((i__7493__auto___30874 < len__7492__auto___30873)){
args30829.push((arguments[i__7493__auto___30874]));

var G__30875 = (i__7493__auto___30874 + (1));
i__7493__auto___30874 = G__30875;
continue;
} else {
}
break;
}

var G__30831 = args30829.length;
switch (G__30831) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30829.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28576__auto___30877 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___30877,out){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___30877,out){
return (function (state_30852){
var state_val_30853 = (state_30852[(1)]);
if((state_val_30853 === (7))){
var inst_30848 = (state_30852[(2)]);
var state_30852__$1 = state_30852;
var statearr_30854_30878 = state_30852__$1;
(statearr_30854_30878[(2)] = inst_30848);

(statearr_30854_30878[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30853 === (1))){
var state_30852__$1 = state_30852;
var statearr_30855_30879 = state_30852__$1;
(statearr_30855_30879[(2)] = null);

(statearr_30855_30879[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30853 === (4))){
var inst_30834 = (state_30852[(7)]);
var inst_30834__$1 = (state_30852[(2)]);
var inst_30835 = (inst_30834__$1 == null);
var state_30852__$1 = (function (){var statearr_30856 = state_30852;
(statearr_30856[(7)] = inst_30834__$1);

return statearr_30856;
})();
if(cljs.core.truth_(inst_30835)){
var statearr_30857_30880 = state_30852__$1;
(statearr_30857_30880[(1)] = (5));

} else {
var statearr_30858_30881 = state_30852__$1;
(statearr_30858_30881[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30853 === (6))){
var inst_30834 = (state_30852[(7)]);
var inst_30839 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30834) : p.call(null,inst_30834));
var state_30852__$1 = state_30852;
if(cljs.core.truth_(inst_30839)){
var statearr_30859_30882 = state_30852__$1;
(statearr_30859_30882[(1)] = (8));

} else {
var statearr_30860_30883 = state_30852__$1;
(statearr_30860_30883[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30853 === (3))){
var inst_30850 = (state_30852[(2)]);
var state_30852__$1 = state_30852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30852__$1,inst_30850);
} else {
if((state_val_30853 === (2))){
var state_30852__$1 = state_30852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30852__$1,(4),ch);
} else {
if((state_val_30853 === (11))){
var inst_30842 = (state_30852[(2)]);
var state_30852__$1 = state_30852;
var statearr_30861_30884 = state_30852__$1;
(statearr_30861_30884[(2)] = inst_30842);

(statearr_30861_30884[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30853 === (9))){
var state_30852__$1 = state_30852;
var statearr_30862_30885 = state_30852__$1;
(statearr_30862_30885[(2)] = null);

(statearr_30862_30885[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30853 === (5))){
var inst_30837 = cljs.core.async.close_BANG_(out);
var state_30852__$1 = state_30852;
var statearr_30863_30886 = state_30852__$1;
(statearr_30863_30886[(2)] = inst_30837);

(statearr_30863_30886[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30853 === (10))){
var inst_30845 = (state_30852[(2)]);
var state_30852__$1 = (function (){var statearr_30864 = state_30852;
(statearr_30864[(8)] = inst_30845);

return statearr_30864;
})();
var statearr_30865_30887 = state_30852__$1;
(statearr_30865_30887[(2)] = null);

(statearr_30865_30887[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30853 === (8))){
var inst_30834 = (state_30852[(7)]);
var state_30852__$1 = state_30852;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30852__$1,(11),out,inst_30834);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___30877,out))
;
return ((function (switch__28452__auto__,c__28576__auto___30877,out){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_30869 = [null,null,null,null,null,null,null,null,null];
(statearr_30869[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_30869[(1)] = (1));

return statearr_30869;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_30852){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_30852);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e30870){if((e30870 instanceof Object)){
var ex__28456__auto__ = e30870;
var statearr_30871_30888 = state_30852;
(statearr_30871_30888[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30852);

return cljs.core.cst$kw$recur;
} else {
throw e30870;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__30889 = state_30852;
state_30852 = G__30889;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_30852){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_30852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___30877,out))
})();
var state__28578__auto__ = (function (){var statearr_30872 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_30872[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___30877);

return statearr_30872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___30877,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args30890 = [];
var len__7492__auto___30893 = arguments.length;
var i__7493__auto___30894 = (0);
while(true){
if((i__7493__auto___30894 < len__7492__auto___30893)){
args30890.push((arguments[i__7493__auto___30894]));

var G__30895 = (i__7493__auto___30894 + (1));
i__7493__auto___30894 = G__30895;
continue;
} else {
}
break;
}

var G__30892 = args30890.length;
switch (G__30892) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30890.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__){
return (function (state_31062){
var state_val_31063 = (state_31062[(1)]);
if((state_val_31063 === (7))){
var inst_31058 = (state_31062[(2)]);
var state_31062__$1 = state_31062;
var statearr_31064_31105 = state_31062__$1;
(statearr_31064_31105[(2)] = inst_31058);

(statearr_31064_31105[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (20))){
var inst_31028 = (state_31062[(7)]);
var inst_31039 = (state_31062[(2)]);
var inst_31040 = cljs.core.next(inst_31028);
var inst_31014 = inst_31040;
var inst_31015 = null;
var inst_31016 = (0);
var inst_31017 = (0);
var state_31062__$1 = (function (){var statearr_31065 = state_31062;
(statearr_31065[(8)] = inst_31017);

(statearr_31065[(9)] = inst_31039);

(statearr_31065[(10)] = inst_31014);

(statearr_31065[(11)] = inst_31015);

(statearr_31065[(12)] = inst_31016);

return statearr_31065;
})();
var statearr_31066_31106 = state_31062__$1;
(statearr_31066_31106[(2)] = null);

(statearr_31066_31106[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (1))){
var state_31062__$1 = state_31062;
var statearr_31067_31107 = state_31062__$1;
(statearr_31067_31107[(2)] = null);

(statearr_31067_31107[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (4))){
var inst_31003 = (state_31062[(13)]);
var inst_31003__$1 = (state_31062[(2)]);
var inst_31004 = (inst_31003__$1 == null);
var state_31062__$1 = (function (){var statearr_31068 = state_31062;
(statearr_31068[(13)] = inst_31003__$1);

return statearr_31068;
})();
if(cljs.core.truth_(inst_31004)){
var statearr_31069_31108 = state_31062__$1;
(statearr_31069_31108[(1)] = (5));

} else {
var statearr_31070_31109 = state_31062__$1;
(statearr_31070_31109[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (15))){
var state_31062__$1 = state_31062;
var statearr_31074_31110 = state_31062__$1;
(statearr_31074_31110[(2)] = null);

(statearr_31074_31110[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (21))){
var state_31062__$1 = state_31062;
var statearr_31075_31111 = state_31062__$1;
(statearr_31075_31111[(2)] = null);

(statearr_31075_31111[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (13))){
var inst_31017 = (state_31062[(8)]);
var inst_31014 = (state_31062[(10)]);
var inst_31015 = (state_31062[(11)]);
var inst_31016 = (state_31062[(12)]);
var inst_31024 = (state_31062[(2)]);
var inst_31025 = (inst_31017 + (1));
var tmp31071 = inst_31014;
var tmp31072 = inst_31015;
var tmp31073 = inst_31016;
var inst_31014__$1 = tmp31071;
var inst_31015__$1 = tmp31072;
var inst_31016__$1 = tmp31073;
var inst_31017__$1 = inst_31025;
var state_31062__$1 = (function (){var statearr_31076 = state_31062;
(statearr_31076[(8)] = inst_31017__$1);

(statearr_31076[(14)] = inst_31024);

(statearr_31076[(10)] = inst_31014__$1);

(statearr_31076[(11)] = inst_31015__$1);

(statearr_31076[(12)] = inst_31016__$1);

return statearr_31076;
})();
var statearr_31077_31112 = state_31062__$1;
(statearr_31077_31112[(2)] = null);

(statearr_31077_31112[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (22))){
var state_31062__$1 = state_31062;
var statearr_31078_31113 = state_31062__$1;
(statearr_31078_31113[(2)] = null);

(statearr_31078_31113[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (6))){
var inst_31003 = (state_31062[(13)]);
var inst_31012 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_31003) : f.call(null,inst_31003));
var inst_31013 = cljs.core.seq(inst_31012);
var inst_31014 = inst_31013;
var inst_31015 = null;
var inst_31016 = (0);
var inst_31017 = (0);
var state_31062__$1 = (function (){var statearr_31079 = state_31062;
(statearr_31079[(8)] = inst_31017);

(statearr_31079[(10)] = inst_31014);

(statearr_31079[(11)] = inst_31015);

(statearr_31079[(12)] = inst_31016);

return statearr_31079;
})();
var statearr_31080_31114 = state_31062__$1;
(statearr_31080_31114[(2)] = null);

(statearr_31080_31114[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (17))){
var inst_31028 = (state_31062[(7)]);
var inst_31032 = cljs.core.chunk_first(inst_31028);
var inst_31033 = cljs.core.chunk_rest(inst_31028);
var inst_31034 = cljs.core.count(inst_31032);
var inst_31014 = inst_31033;
var inst_31015 = inst_31032;
var inst_31016 = inst_31034;
var inst_31017 = (0);
var state_31062__$1 = (function (){var statearr_31081 = state_31062;
(statearr_31081[(8)] = inst_31017);

(statearr_31081[(10)] = inst_31014);

(statearr_31081[(11)] = inst_31015);

(statearr_31081[(12)] = inst_31016);

return statearr_31081;
})();
var statearr_31082_31115 = state_31062__$1;
(statearr_31082_31115[(2)] = null);

(statearr_31082_31115[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (3))){
var inst_31060 = (state_31062[(2)]);
var state_31062__$1 = state_31062;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31062__$1,inst_31060);
} else {
if((state_val_31063 === (12))){
var inst_31048 = (state_31062[(2)]);
var state_31062__$1 = state_31062;
var statearr_31083_31116 = state_31062__$1;
(statearr_31083_31116[(2)] = inst_31048);

(statearr_31083_31116[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (2))){
var state_31062__$1 = state_31062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31062__$1,(4),in$);
} else {
if((state_val_31063 === (23))){
var inst_31056 = (state_31062[(2)]);
var state_31062__$1 = state_31062;
var statearr_31084_31117 = state_31062__$1;
(statearr_31084_31117[(2)] = inst_31056);

(statearr_31084_31117[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (19))){
var inst_31043 = (state_31062[(2)]);
var state_31062__$1 = state_31062;
var statearr_31085_31118 = state_31062__$1;
(statearr_31085_31118[(2)] = inst_31043);

(statearr_31085_31118[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (11))){
var inst_31014 = (state_31062[(10)]);
var inst_31028 = (state_31062[(7)]);
var inst_31028__$1 = cljs.core.seq(inst_31014);
var state_31062__$1 = (function (){var statearr_31086 = state_31062;
(statearr_31086[(7)] = inst_31028__$1);

return statearr_31086;
})();
if(inst_31028__$1){
var statearr_31087_31119 = state_31062__$1;
(statearr_31087_31119[(1)] = (14));

} else {
var statearr_31088_31120 = state_31062__$1;
(statearr_31088_31120[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (9))){
var inst_31050 = (state_31062[(2)]);
var inst_31051 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_31062__$1 = (function (){var statearr_31089 = state_31062;
(statearr_31089[(15)] = inst_31050);

return statearr_31089;
})();
if(cljs.core.truth_(inst_31051)){
var statearr_31090_31121 = state_31062__$1;
(statearr_31090_31121[(1)] = (21));

} else {
var statearr_31091_31122 = state_31062__$1;
(statearr_31091_31122[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (5))){
var inst_31006 = cljs.core.async.close_BANG_(out);
var state_31062__$1 = state_31062;
var statearr_31092_31123 = state_31062__$1;
(statearr_31092_31123[(2)] = inst_31006);

(statearr_31092_31123[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (14))){
var inst_31028 = (state_31062[(7)]);
var inst_31030 = cljs.core.chunked_seq_QMARK_(inst_31028);
var state_31062__$1 = state_31062;
if(inst_31030){
var statearr_31093_31124 = state_31062__$1;
(statearr_31093_31124[(1)] = (17));

} else {
var statearr_31094_31125 = state_31062__$1;
(statearr_31094_31125[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (16))){
var inst_31046 = (state_31062[(2)]);
var state_31062__$1 = state_31062;
var statearr_31095_31126 = state_31062__$1;
(statearr_31095_31126[(2)] = inst_31046);

(statearr_31095_31126[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31063 === (10))){
var inst_31017 = (state_31062[(8)]);
var inst_31015 = (state_31062[(11)]);
var inst_31022 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31015,inst_31017);
var state_31062__$1 = state_31062;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31062__$1,(13),out,inst_31022);
} else {
if((state_val_31063 === (18))){
var inst_31028 = (state_31062[(7)]);
var inst_31037 = cljs.core.first(inst_31028);
var state_31062__$1 = state_31062;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31062__$1,(20),out,inst_31037);
} else {
if((state_val_31063 === (8))){
var inst_31017 = (state_31062[(8)]);
var inst_31016 = (state_31062[(12)]);
var inst_31019 = (inst_31017 < inst_31016);
var inst_31020 = inst_31019;
var state_31062__$1 = state_31062;
if(cljs.core.truth_(inst_31020)){
var statearr_31096_31127 = state_31062__$1;
(statearr_31096_31127[(1)] = (10));

} else {
var statearr_31097_31128 = state_31062__$1;
(statearr_31097_31128[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__))
;
return ((function (switch__28452__auto__,c__28576__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28453__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28453__auto____0 = (function (){
var statearr_31101 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31101[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28453__auto__);

(statearr_31101[(1)] = (1));

return statearr_31101;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28453__auto____1 = (function (state_31062){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_31062);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e31102){if((e31102 instanceof Object)){
var ex__28456__auto__ = e31102;
var statearr_31103_31129 = state_31062;
(statearr_31103_31129[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31062);

return cljs.core.cst$kw$recur;
} else {
throw e31102;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__31130 = state_31062;
state_31062 = G__31130;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28453__auto__ = function(state_31062){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28453__auto____1.call(this,state_31062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28453__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28453__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__))
})();
var state__28578__auto__ = (function (){var statearr_31104 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_31104[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_31104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__))
);

return c__28576__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args31131 = [];
var len__7492__auto___31134 = arguments.length;
var i__7493__auto___31135 = (0);
while(true){
if((i__7493__auto___31135 < len__7492__auto___31134)){
args31131.push((arguments[i__7493__auto___31135]));

var G__31136 = (i__7493__auto___31135 + (1));
i__7493__auto___31135 = G__31136;
continue;
} else {
}
break;
}

var G__31133 = args31131.length;
switch (G__31133) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31131.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args31138 = [];
var len__7492__auto___31141 = arguments.length;
var i__7493__auto___31142 = (0);
while(true){
if((i__7493__auto___31142 < len__7492__auto___31141)){
args31138.push((arguments[i__7493__auto___31142]));

var G__31143 = (i__7493__auto___31142 + (1));
i__7493__auto___31142 = G__31143;
continue;
} else {
}
break;
}

var G__31140 = args31138.length;
switch (G__31140) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31138.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args31145 = [];
var len__7492__auto___31196 = arguments.length;
var i__7493__auto___31197 = (0);
while(true){
if((i__7493__auto___31197 < len__7492__auto___31196)){
args31145.push((arguments[i__7493__auto___31197]));

var G__31198 = (i__7493__auto___31197 + (1));
i__7493__auto___31197 = G__31198;
continue;
} else {
}
break;
}

var G__31147 = args31145.length;
switch (G__31147) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31145.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28576__auto___31200 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___31200,out){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___31200,out){
return (function (state_31171){
var state_val_31172 = (state_31171[(1)]);
if((state_val_31172 === (7))){
var inst_31166 = (state_31171[(2)]);
var state_31171__$1 = state_31171;
var statearr_31173_31201 = state_31171__$1;
(statearr_31173_31201[(2)] = inst_31166);

(statearr_31173_31201[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31172 === (1))){
var inst_31148 = null;
var state_31171__$1 = (function (){var statearr_31174 = state_31171;
(statearr_31174[(7)] = inst_31148);

return statearr_31174;
})();
var statearr_31175_31202 = state_31171__$1;
(statearr_31175_31202[(2)] = null);

(statearr_31175_31202[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31172 === (4))){
var inst_31151 = (state_31171[(8)]);
var inst_31151__$1 = (state_31171[(2)]);
var inst_31152 = (inst_31151__$1 == null);
var inst_31153 = cljs.core.not(inst_31152);
var state_31171__$1 = (function (){var statearr_31176 = state_31171;
(statearr_31176[(8)] = inst_31151__$1);

return statearr_31176;
})();
if(inst_31153){
var statearr_31177_31203 = state_31171__$1;
(statearr_31177_31203[(1)] = (5));

} else {
var statearr_31178_31204 = state_31171__$1;
(statearr_31178_31204[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31172 === (6))){
var state_31171__$1 = state_31171;
var statearr_31179_31205 = state_31171__$1;
(statearr_31179_31205[(2)] = null);

(statearr_31179_31205[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31172 === (3))){
var inst_31168 = (state_31171[(2)]);
var inst_31169 = cljs.core.async.close_BANG_(out);
var state_31171__$1 = (function (){var statearr_31180 = state_31171;
(statearr_31180[(9)] = inst_31168);

return statearr_31180;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31171__$1,inst_31169);
} else {
if((state_val_31172 === (2))){
var state_31171__$1 = state_31171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31171__$1,(4),ch);
} else {
if((state_val_31172 === (11))){
var inst_31151 = (state_31171[(8)]);
var inst_31160 = (state_31171[(2)]);
var inst_31148 = inst_31151;
var state_31171__$1 = (function (){var statearr_31181 = state_31171;
(statearr_31181[(10)] = inst_31160);

(statearr_31181[(7)] = inst_31148);

return statearr_31181;
})();
var statearr_31182_31206 = state_31171__$1;
(statearr_31182_31206[(2)] = null);

(statearr_31182_31206[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31172 === (9))){
var inst_31151 = (state_31171[(8)]);
var state_31171__$1 = state_31171;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31171__$1,(11),out,inst_31151);
} else {
if((state_val_31172 === (5))){
var inst_31151 = (state_31171[(8)]);
var inst_31148 = (state_31171[(7)]);
var inst_31155 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31151,inst_31148);
var state_31171__$1 = state_31171;
if(inst_31155){
var statearr_31184_31207 = state_31171__$1;
(statearr_31184_31207[(1)] = (8));

} else {
var statearr_31185_31208 = state_31171__$1;
(statearr_31185_31208[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31172 === (10))){
var inst_31163 = (state_31171[(2)]);
var state_31171__$1 = state_31171;
var statearr_31186_31209 = state_31171__$1;
(statearr_31186_31209[(2)] = inst_31163);

(statearr_31186_31209[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31172 === (8))){
var inst_31148 = (state_31171[(7)]);
var tmp31183 = inst_31148;
var inst_31148__$1 = tmp31183;
var state_31171__$1 = (function (){var statearr_31187 = state_31171;
(statearr_31187[(7)] = inst_31148__$1);

return statearr_31187;
})();
var statearr_31188_31210 = state_31171__$1;
(statearr_31188_31210[(2)] = null);

(statearr_31188_31210[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___31200,out))
;
return ((function (switch__28452__auto__,c__28576__auto___31200,out){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_31192 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31192[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_31192[(1)] = (1));

return statearr_31192;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_31171){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_31171);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e31193){if((e31193 instanceof Object)){
var ex__28456__auto__ = e31193;
var statearr_31194_31211 = state_31171;
(statearr_31194_31211[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31171);

return cljs.core.cst$kw$recur;
} else {
throw e31193;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__31212 = state_31171;
state_31171 = G__31212;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_31171){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_31171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___31200,out))
})();
var state__28578__auto__ = (function (){var statearr_31195 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_31195[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___31200);

return statearr_31195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___31200,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args31213 = [];
var len__7492__auto___31283 = arguments.length;
var i__7493__auto___31284 = (0);
while(true){
if((i__7493__auto___31284 < len__7492__auto___31283)){
args31213.push((arguments[i__7493__auto___31284]));

var G__31285 = (i__7493__auto___31284 + (1));
i__7493__auto___31284 = G__31285;
continue;
} else {
}
break;
}

var G__31215 = args31213.length;
switch (G__31215) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31213.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28576__auto___31287 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___31287,out){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___31287,out){
return (function (state_31253){
var state_val_31254 = (state_31253[(1)]);
if((state_val_31254 === (7))){
var inst_31249 = (state_31253[(2)]);
var state_31253__$1 = state_31253;
var statearr_31255_31288 = state_31253__$1;
(statearr_31255_31288[(2)] = inst_31249);

(statearr_31255_31288[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (1))){
var inst_31216 = (new Array(n));
var inst_31217 = inst_31216;
var inst_31218 = (0);
var state_31253__$1 = (function (){var statearr_31256 = state_31253;
(statearr_31256[(7)] = inst_31218);

(statearr_31256[(8)] = inst_31217);

return statearr_31256;
})();
var statearr_31257_31289 = state_31253__$1;
(statearr_31257_31289[(2)] = null);

(statearr_31257_31289[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (4))){
var inst_31221 = (state_31253[(9)]);
var inst_31221__$1 = (state_31253[(2)]);
var inst_31222 = (inst_31221__$1 == null);
var inst_31223 = cljs.core.not(inst_31222);
var state_31253__$1 = (function (){var statearr_31258 = state_31253;
(statearr_31258[(9)] = inst_31221__$1);

return statearr_31258;
})();
if(inst_31223){
var statearr_31259_31290 = state_31253__$1;
(statearr_31259_31290[(1)] = (5));

} else {
var statearr_31260_31291 = state_31253__$1;
(statearr_31260_31291[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (15))){
var inst_31243 = (state_31253[(2)]);
var state_31253__$1 = state_31253;
var statearr_31261_31292 = state_31253__$1;
(statearr_31261_31292[(2)] = inst_31243);

(statearr_31261_31292[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (13))){
var state_31253__$1 = state_31253;
var statearr_31262_31293 = state_31253__$1;
(statearr_31262_31293[(2)] = null);

(statearr_31262_31293[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (6))){
var inst_31218 = (state_31253[(7)]);
var inst_31239 = (inst_31218 > (0));
var state_31253__$1 = state_31253;
if(cljs.core.truth_(inst_31239)){
var statearr_31263_31294 = state_31253__$1;
(statearr_31263_31294[(1)] = (12));

} else {
var statearr_31264_31295 = state_31253__$1;
(statearr_31264_31295[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (3))){
var inst_31251 = (state_31253[(2)]);
var state_31253__$1 = state_31253;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31253__$1,inst_31251);
} else {
if((state_val_31254 === (12))){
var inst_31217 = (state_31253[(8)]);
var inst_31241 = cljs.core.vec(inst_31217);
var state_31253__$1 = state_31253;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31253__$1,(15),out,inst_31241);
} else {
if((state_val_31254 === (2))){
var state_31253__$1 = state_31253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31253__$1,(4),ch);
} else {
if((state_val_31254 === (11))){
var inst_31233 = (state_31253[(2)]);
var inst_31234 = (new Array(n));
var inst_31217 = inst_31234;
var inst_31218 = (0);
var state_31253__$1 = (function (){var statearr_31265 = state_31253;
(statearr_31265[(7)] = inst_31218);

(statearr_31265[(10)] = inst_31233);

(statearr_31265[(8)] = inst_31217);

return statearr_31265;
})();
var statearr_31266_31296 = state_31253__$1;
(statearr_31266_31296[(2)] = null);

(statearr_31266_31296[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (9))){
var inst_31217 = (state_31253[(8)]);
var inst_31231 = cljs.core.vec(inst_31217);
var state_31253__$1 = state_31253;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31253__$1,(11),out,inst_31231);
} else {
if((state_val_31254 === (5))){
var inst_31218 = (state_31253[(7)]);
var inst_31221 = (state_31253[(9)]);
var inst_31226 = (state_31253[(11)]);
var inst_31217 = (state_31253[(8)]);
var inst_31225 = (inst_31217[inst_31218] = inst_31221);
var inst_31226__$1 = (inst_31218 + (1));
var inst_31227 = (inst_31226__$1 < n);
var state_31253__$1 = (function (){var statearr_31267 = state_31253;
(statearr_31267[(12)] = inst_31225);

(statearr_31267[(11)] = inst_31226__$1);

return statearr_31267;
})();
if(cljs.core.truth_(inst_31227)){
var statearr_31268_31297 = state_31253__$1;
(statearr_31268_31297[(1)] = (8));

} else {
var statearr_31269_31298 = state_31253__$1;
(statearr_31269_31298[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (14))){
var inst_31246 = (state_31253[(2)]);
var inst_31247 = cljs.core.async.close_BANG_(out);
var state_31253__$1 = (function (){var statearr_31271 = state_31253;
(statearr_31271[(13)] = inst_31246);

return statearr_31271;
})();
var statearr_31272_31299 = state_31253__$1;
(statearr_31272_31299[(2)] = inst_31247);

(statearr_31272_31299[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (10))){
var inst_31237 = (state_31253[(2)]);
var state_31253__$1 = state_31253;
var statearr_31273_31300 = state_31253__$1;
(statearr_31273_31300[(2)] = inst_31237);

(statearr_31273_31300[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31254 === (8))){
var inst_31226 = (state_31253[(11)]);
var inst_31217 = (state_31253[(8)]);
var tmp31270 = inst_31217;
var inst_31217__$1 = tmp31270;
var inst_31218 = inst_31226;
var state_31253__$1 = (function (){var statearr_31274 = state_31253;
(statearr_31274[(7)] = inst_31218);

(statearr_31274[(8)] = inst_31217__$1);

return statearr_31274;
})();
var statearr_31275_31301 = state_31253__$1;
(statearr_31275_31301[(2)] = null);

(statearr_31275_31301[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___31287,out))
;
return ((function (switch__28452__auto__,c__28576__auto___31287,out){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_31279 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31279[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_31279[(1)] = (1));

return statearr_31279;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_31253){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_31253);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e31280){if((e31280 instanceof Object)){
var ex__28456__auto__ = e31280;
var statearr_31281_31302 = state_31253;
(statearr_31281_31302[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31253);

return cljs.core.cst$kw$recur;
} else {
throw e31280;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__31303 = state_31253;
state_31253 = G__31303;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_31253){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_31253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___31287,out))
})();
var state__28578__auto__ = (function (){var statearr_31282 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_31282[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___31287);

return statearr_31282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___31287,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args31304 = [];
var len__7492__auto___31378 = arguments.length;
var i__7493__auto___31379 = (0);
while(true){
if((i__7493__auto___31379 < len__7492__auto___31378)){
args31304.push((arguments[i__7493__auto___31379]));

var G__31380 = (i__7493__auto___31379 + (1));
i__7493__auto___31379 = G__31380;
continue;
} else {
}
break;
}

var G__31306 = args31304.length;
switch (G__31306) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31304.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28576__auto___31382 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___31382,out){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___31382,out){
return (function (state_31348){
var state_val_31349 = (state_31348[(1)]);
if((state_val_31349 === (7))){
var inst_31344 = (state_31348[(2)]);
var state_31348__$1 = state_31348;
var statearr_31350_31383 = state_31348__$1;
(statearr_31350_31383[(2)] = inst_31344);

(statearr_31350_31383[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31349 === (1))){
var inst_31307 = [];
var inst_31308 = inst_31307;
var inst_31309 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_31348__$1 = (function (){var statearr_31351 = state_31348;
(statearr_31351[(7)] = inst_31308);

(statearr_31351[(8)] = inst_31309);

return statearr_31351;
})();
var statearr_31352_31384 = state_31348__$1;
(statearr_31352_31384[(2)] = null);

(statearr_31352_31384[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31349 === (4))){
var inst_31312 = (state_31348[(9)]);
var inst_31312__$1 = (state_31348[(2)]);
var inst_31313 = (inst_31312__$1 == null);
var inst_31314 = cljs.core.not(inst_31313);
var state_31348__$1 = (function (){var statearr_31353 = state_31348;
(statearr_31353[(9)] = inst_31312__$1);

return statearr_31353;
})();
if(inst_31314){
var statearr_31354_31385 = state_31348__$1;
(statearr_31354_31385[(1)] = (5));

} else {
var statearr_31355_31386 = state_31348__$1;
(statearr_31355_31386[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31349 === (15))){
var inst_31338 = (state_31348[(2)]);
var state_31348__$1 = state_31348;
var statearr_31356_31387 = state_31348__$1;
(statearr_31356_31387[(2)] = inst_31338);

(statearr_31356_31387[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31349 === (13))){
var state_31348__$1 = state_31348;
var statearr_31357_31388 = state_31348__$1;
(statearr_31357_31388[(2)] = null);

(statearr_31357_31388[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31349 === (6))){
var inst_31308 = (state_31348[(7)]);
var inst_31333 = inst_31308.length;
var inst_31334 = (inst_31333 > (0));
var state_31348__$1 = state_31348;
if(cljs.core.truth_(inst_31334)){
var statearr_31358_31389 = state_31348__$1;
(statearr_31358_31389[(1)] = (12));

} else {
var statearr_31359_31390 = state_31348__$1;
(statearr_31359_31390[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31349 === (3))){
var inst_31346 = (state_31348[(2)]);
var state_31348__$1 = state_31348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31348__$1,inst_31346);
} else {
if((state_val_31349 === (12))){
var inst_31308 = (state_31348[(7)]);
var inst_31336 = cljs.core.vec(inst_31308);
var state_31348__$1 = state_31348;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31348__$1,(15),out,inst_31336);
} else {
if((state_val_31349 === (2))){
var state_31348__$1 = state_31348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31348__$1,(4),ch);
} else {
if((state_val_31349 === (11))){
var inst_31316 = (state_31348[(10)]);
var inst_31312 = (state_31348[(9)]);
var inst_31326 = (state_31348[(2)]);
var inst_31327 = [];
var inst_31328 = inst_31327.push(inst_31312);
var inst_31308 = inst_31327;
var inst_31309 = inst_31316;
var state_31348__$1 = (function (){var statearr_31360 = state_31348;
(statearr_31360[(7)] = inst_31308);

(statearr_31360[(8)] = inst_31309);

(statearr_31360[(11)] = inst_31328);

(statearr_31360[(12)] = inst_31326);

return statearr_31360;
})();
var statearr_31361_31391 = state_31348__$1;
(statearr_31361_31391[(2)] = null);

(statearr_31361_31391[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31349 === (9))){
var inst_31308 = (state_31348[(7)]);
var inst_31324 = cljs.core.vec(inst_31308);
var state_31348__$1 = state_31348;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31348__$1,(11),out,inst_31324);
} else {
if((state_val_31349 === (5))){
var inst_31309 = (state_31348[(8)]);
var inst_31316 = (state_31348[(10)]);
var inst_31312 = (state_31348[(9)]);
var inst_31316__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_31312) : f.call(null,inst_31312));
var inst_31317 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31316__$1,inst_31309);
var inst_31318 = cljs.core.keyword_identical_QMARK_(inst_31309,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_31319 = (inst_31317) || (inst_31318);
var state_31348__$1 = (function (){var statearr_31362 = state_31348;
(statearr_31362[(10)] = inst_31316__$1);

return statearr_31362;
})();
if(cljs.core.truth_(inst_31319)){
var statearr_31363_31392 = state_31348__$1;
(statearr_31363_31392[(1)] = (8));

} else {
var statearr_31364_31393 = state_31348__$1;
(statearr_31364_31393[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31349 === (14))){
var inst_31341 = (state_31348[(2)]);
var inst_31342 = cljs.core.async.close_BANG_(out);
var state_31348__$1 = (function (){var statearr_31366 = state_31348;
(statearr_31366[(13)] = inst_31341);

return statearr_31366;
})();
var statearr_31367_31394 = state_31348__$1;
(statearr_31367_31394[(2)] = inst_31342);

(statearr_31367_31394[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31349 === (10))){
var inst_31331 = (state_31348[(2)]);
var state_31348__$1 = state_31348;
var statearr_31368_31395 = state_31348__$1;
(statearr_31368_31395[(2)] = inst_31331);

(statearr_31368_31395[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31349 === (8))){
var inst_31308 = (state_31348[(7)]);
var inst_31316 = (state_31348[(10)]);
var inst_31312 = (state_31348[(9)]);
var inst_31321 = inst_31308.push(inst_31312);
var tmp31365 = inst_31308;
var inst_31308__$1 = tmp31365;
var inst_31309 = inst_31316;
var state_31348__$1 = (function (){var statearr_31369 = state_31348;
(statearr_31369[(7)] = inst_31308__$1);

(statearr_31369[(8)] = inst_31309);

(statearr_31369[(14)] = inst_31321);

return statearr_31369;
})();
var statearr_31370_31396 = state_31348__$1;
(statearr_31370_31396[(2)] = null);

(statearr_31370_31396[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto___31382,out))
;
return ((function (switch__28452__auto__,c__28576__auto___31382,out){
return (function() {
var cljs$core$async$state_machine__28453__auto__ = null;
var cljs$core$async$state_machine__28453__auto____0 = (function (){
var statearr_31374 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31374[(0)] = cljs$core$async$state_machine__28453__auto__);

(statearr_31374[(1)] = (1));

return statearr_31374;
});
var cljs$core$async$state_machine__28453__auto____1 = (function (state_31348){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_31348);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e31375){if((e31375 instanceof Object)){
var ex__28456__auto__ = e31375;
var statearr_31376_31397 = state_31348;
(statearr_31376_31397[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31348);

return cljs.core.cst$kw$recur;
} else {
throw e31375;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__31398 = state_31348;
state_31348 = G__31398;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs$core$async$state_machine__28453__auto__ = function(state_31348){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28453__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28453__auto____1.call(this,state_31348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28453__auto____0;
cljs$core$async$state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28453__auto____1;
return cljs$core$async$state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___31382,out))
})();
var state__28578__auto__ = (function (){var statearr_31377 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_31377[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___31382);

return statearr_31377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___31382,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

