// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__31935 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31935) : cljs.core.atom.call(null,G__31935));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4657__auto__)){
var req = temp__4657__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__31940){
var vec__31941 = p__31940;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31941,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31941,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__31945 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__31945)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__31945)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__31945)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__31945)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__31945)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__31945)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__31946){
var map__31950 = p__31946;
var map__31950__$1 = ((((!((map__31950 == null)))?((((map__31950.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31950.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31950):map__31950);
var request = map__31950__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31950__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31950__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31950__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__6417__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__31952 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__31952,default_headers);

cljs_http.core.apply_response_type_BANG_(G__31952,response_type);

G__31952.setTimeoutInterval(timeout);

G__31952.setWithCredentials(send_credentials);

return G__31952;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__31953){
var map__31981 = p__31953;
var map__31981__$1 = ((((!((map__31981 == null)))?((((map__31981.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31981.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31981):map__31981);
var request = map__31981__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31981__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31981__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31981__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31981__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31981__$1,cljs.core.cst$kw$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__6417__auto__ = request_method;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr__$1 = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr__$1);

xhr__$1.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr__$1,map__31981,map__31981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__31983 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__31983) : cljs_http.core.error_kw.call(null,G__31983));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr__$1))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr__$1,map__31981,map__31981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

xhr__$1.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__28576__auto___32008 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___32008,channel,request_url,method,headers__$1,xhr__$1,map__31981,map__31981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___32008,channel,request_url,method,headers__$1,xhr__$1,map__31981,map__31981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (state_31994){
var state_val_31995 = (state_31994[(1)]);
if((state_val_31995 === (1))){
var state_31994__$1 = state_31994;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31994__$1,(2),cancel);
} else {
if((state_val_31995 === (2))){
var inst_31985 = (state_31994[(2)]);
var inst_31986 = xhr__$1.isComplete();
var inst_31987 = cljs.core.not(inst_31986);
var state_31994__$1 = (function (){var statearr_31996 = state_31994;
(statearr_31996[(7)] = inst_31985);

return statearr_31996;
})();
if(inst_31987){
var statearr_31997_32009 = state_31994__$1;
(statearr_31997_32009[(1)] = (3));

} else {
var statearr_31998_32010 = state_31994__$1;
(statearr_31998_32010[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31995 === (3))){
var inst_31989 = xhr__$1.abort();
var state_31994__$1 = state_31994;
var statearr_31999_32011 = state_31994__$1;
(statearr_31999_32011[(2)] = inst_31989);

(statearr_31999_32011[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31995 === (4))){
var state_31994__$1 = state_31994;
var statearr_32000_32012 = state_31994__$1;
(statearr_32000_32012[(2)] = null);

(statearr_32000_32012[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31995 === (5))){
var inst_31992 = (state_31994[(2)]);
var state_31994__$1 = state_31994;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31994__$1,inst_31992);
} else {
return null;
}
}
}
}
}
});})(c__28576__auto___32008,channel,request_url,method,headers__$1,xhr__$1,map__31981,map__31981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
;
return ((function (switch__28452__auto__,c__28576__auto___32008,channel,request_url,method,headers__$1,xhr__$1,map__31981,map__31981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function() {
var cljs_http$core$xhr_$_state_machine__28453__auto__ = null;
var cljs_http$core$xhr_$_state_machine__28453__auto____0 = (function (){
var statearr_32004 = [null,null,null,null,null,null,null,null];
(statearr_32004[(0)] = cljs_http$core$xhr_$_state_machine__28453__auto__);

(statearr_32004[(1)] = (1));

return statearr_32004;
});
var cljs_http$core$xhr_$_state_machine__28453__auto____1 = (function (state_31994){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_31994);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e32005){if((e32005 instanceof Object)){
var ex__28456__auto__ = e32005;
var statearr_32006_32013 = state_31994;
(statearr_32006_32013[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31994);

return cljs.core.cst$kw$recur;
} else {
throw e32005;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__32014 = state_31994;
state_31994 = G__32014;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__28453__auto__ = function(state_31994){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__28453__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__28453__auto____1.call(this,state_31994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__28453__auto____0;
cljs_http$core$xhr_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__28453__auto____1;
return cljs_http$core$xhr_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___32008,channel,request_url,method,headers__$1,xhr__$1,map__31981,map__31981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
})();
var state__28578__auto__ = (function (){var statearr_32007 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_32007[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___32008);

return statearr_32007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___32008,channel,request_url,method,headers__$1,xhr__$1,map__31981,map__31981__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__32015){
var map__32032 = p__32015;
var map__32032__$1 = ((((!((map__32032 == null)))?((((map__32032.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32032.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32032):map__32032);
var request = map__32032__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32032__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32032__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32032__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32032__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp__$1 = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp__$1.setRequestTimeout(timeout);

var req_32048 = jsonp__$1.send(null,((function (channel,jsonp__$1,map__32032,map__32032__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__32032,map__32032__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp__$1,map__32032,map__32032__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp__$1,map__32032,map__32032__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp__$1,cljs.core.cst$kw$request,req_32048], null));

if(cljs.core.truth_(cancel)){
var c__28576__auto___32049 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___32049,req_32048,channel,jsonp__$1,map__32032,map__32032__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___32049,req_32048,channel,jsonp__$1,map__32032,map__32032__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_32038){
var state_val_32039 = (state_32038[(1)]);
if((state_val_32039 === (1))){
var state_32038__$1 = state_32038;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32038__$1,(2),cancel);
} else {
if((state_val_32039 === (2))){
var inst_32035 = (state_32038[(2)]);
var inst_32036 = jsonp__$1.cancel(req_32048);
var state_32038__$1 = (function (){var statearr_32040 = state_32038;
(statearr_32040[(7)] = inst_32035);

return statearr_32040;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32038__$1,inst_32036);
} else {
return null;
}
}
});})(c__28576__auto___32049,req_32048,channel,jsonp__$1,map__32032,map__32032__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__28452__auto__,c__28576__auto___32049,req_32048,channel,jsonp__$1,map__32032,map__32032__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__28453__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__28453__auto____0 = (function (){
var statearr_32044 = [null,null,null,null,null,null,null,null];
(statearr_32044[(0)] = cljs_http$core$jsonp_$_state_machine__28453__auto__);

(statearr_32044[(1)] = (1));

return statearr_32044;
});
var cljs_http$core$jsonp_$_state_machine__28453__auto____1 = (function (state_32038){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_32038);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e32045){if((e32045 instanceof Object)){
var ex__28456__auto__ = e32045;
var statearr_32046_32050 = state_32038;
(statearr_32046_32050[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32038);

return cljs.core.cst$kw$recur;
} else {
throw e32045;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__32051 = state_32038;
state_32038 = G__32051;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__28453__auto__ = function(state_32038){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__28453__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__28453__auto____1.call(this,state_32038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__28453__auto____0;
cljs_http$core$jsonp_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__28453__auto____1;
return cljs_http$core$jsonp_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___32049,req_32048,channel,jsonp__$1,map__32032,map__32032__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__28578__auto__ = (function (){var statearr_32047 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_32047[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___32049);

return statearr_32047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___32049,req_32048,channel,jsonp__$1,map__32032,map__32032__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__32052){
var map__32055 = p__32052;
var map__32055__$1 = ((((!((map__32055 == null)))?((((map__32055.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32055.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32055):map__32055);
var request__$1 = map__32055__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32055__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request__$1);
} else {
return cljs_http.core.xhr(request__$1);
}
});
