// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('smithy.impl.components');
goog.require('cljs.core');
goog.require('om.dom');
goog.require('smithy.impl.inputs');
goog.require('smithy.util');
goog.require('goog.i18n.DateTimeFormat');
goog.require('om.core');
goog.require('goog.date.UtcDateTime');
/**
 * Component for an item in the action menu.
 */
smithy.impl.components.actionmenu_item_component = (function smithy$impl$components$actionmenu_item_component(p__41762,owner){
var map__41770 = p__41762;
var map__41770__$1 = ((((!((map__41770 == null)))?((((map__41770.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41770.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41770):map__41770);
var vkey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41770__$1,cljs.core.cst$kw$vkey);
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41770__$1,cljs.core.cst$kw$action);
var desc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41770__$1,cljs.core.cst$kw$desc);
if(typeof smithy.impl.components.t_smithy$impl$components41772 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components41772 = (function (actionmenu_item_component,p__41762,owner,map__41770,vkey,action,desc,meta41773){
this.actionmenu_item_component = actionmenu_item_component;
this.p__41762 = p__41762;
this.owner = owner;
this.map__41770 = map__41770;
this.vkey = vkey;
this.action = action;
this.desc = desc;
this.meta41773 = meta41773;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components41772.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__41770,map__41770__$1,vkey,action,desc){
return (function (_41774,meta41773__$1){
var self__ = this;
var _41774__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components41772(self__.actionmenu_item_component,self__.p__41762,self__.owner,self__.map__41770,self__.vkey,self__.action,self__.desc,meta41773__$1));
});})(map__41770,map__41770__$1,vkey,action,desc))
;

smithy.impl.components.t_smithy$impl$components41772.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__41770,map__41770__$1,vkey,action,desc){
return (function (_41774){
var self__ = this;
var _41774__$1 = this;
return self__.meta41773;
});})(map__41770,map__41770__$1,vkey,action,desc))
;

smithy.impl.components.t_smithy$impl$components41772.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components41772.prototype.om$core$IRender$render$arity$1 = ((function (map__41770,map__41770__$1,vkey,action,desc){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__41775 = ({"value": self__.action});
var G__41776 = self__.desc;
return (om.dom.option.cljs$core$IFn$_invoke$arity$2 ? om.dom.option.cljs$core$IFn$_invoke$arity$2(G__41775,G__41776) : om.dom.option.call(null,G__41775,G__41776));
});})(map__41770,map__41770__$1,vkey,action,desc))
;

smithy.impl.components.t_smithy$impl$components41772.getBasis = ((function (map__41770,map__41770__$1,vkey,action,desc){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$actionmenu_DASH_item_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vkey,cljs.core.cst$sym$action,cljs.core.cst$sym$desc], null)], null),cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Component for an item in the action menu."], null)),cljs.core.cst$sym$p__41762,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__41770,cljs.core.cst$sym$vkey,cljs.core.cst$sym$action,cljs.core.cst$sym$desc,cljs.core.cst$sym$meta41773], null);
});})(map__41770,map__41770__$1,vkey,action,desc))
;

smithy.impl.components.t_smithy$impl$components41772.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components41772.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components41772";

smithy.impl.components.t_smithy$impl$components41772.cljs$lang$ctorPrWriter = ((function (map__41770,map__41770__$1,vkey,action,desc){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components41772");
});})(map__41770,map__41770__$1,vkey,action,desc))
;

smithy.impl.components.__GT_t_smithy$impl$components41772 = ((function (map__41770,map__41770__$1,vkey,action,desc){
return (function smithy$impl$components$actionmenu_item_component_$___GT_t_smithy$impl$components41772(actionmenu_item_component__$1,p__41762__$1,owner__$1,map__41770__$2,vkey__$1,action__$1,desc__$1,meta41773){
return (new smithy.impl.components.t_smithy$impl$components41772(actionmenu_item_component__$1,p__41762__$1,owner__$1,map__41770__$2,vkey__$1,action__$1,desc__$1,meta41773));
});})(map__41770,map__41770__$1,vkey,action,desc))
;

}

return (new smithy.impl.components.t_smithy$impl$components41772(smithy$impl$components$actionmenu_item_component,p__41762,owner,map__41770__$1,vkey,action,desc,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Handler for action menu selection events.
 */
smithy.impl.components.select_action_event_handler = (function smithy$impl$components$select_action_event_handler(vs,e){
var value = e.target.value;
var event = [cljs.core.str(smithy.util.get_resource_type_name(vs)),cljs.core.str("-actionmenu")].join('');
var action = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$actions_DASH_ref,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(value)], null));
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$analytics_DASH_event], null)).call(null,event,value);

if(cljs.core.truth_(action)){
var G__41779 = vs;
var G__41780 = smithy.util.get_resource_id(vs);
return (action.cljs$core$IFn$_invoke$arity$2 ? action.cljs$core$IFn$_invoke$arity$2(G__41779,G__41780) : action.call(null,G__41779,G__41780));
} else {
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("Missing action: "),cljs.core.str(cljs.core.name(value))].join('')], 0));
}
});
/**
 * Return the menu options formatted for on Om's build-all.
 */
smithy.impl.components.actionmenu_builder_list = (function smithy$impl$components$actionmenu_builder_list(vs,key){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41781_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([key,cljs.core.cst$kw$action,cljs.core.cst$kw$desc],[cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(p1__41781_SHARP_),cljs.core.name(cljs.core.cst$kw$action.cljs$core$IFn$_invoke$arity$1(p1__41781_SHARP_)),cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(p1__41781_SHARP_)]);
}),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(vs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$actionmenu,cljs.core.cst$kw$menu], null))),cljs.core.PersistentArrayMap.fromArray([key,"",cljs.core.cst$kw$action,null,cljs.core.cst$kw$desc,"Actions..."], true, false));
});
/**
 * Component for the Action Menu drop-down
 */
smithy.impl.components.actionmenu_component = (function smithy$impl$components$actionmenu_component(vs,owner){
if(typeof smithy.impl.components.t_smithy$impl$components41788 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components41788 = (function (actionmenu_component,vs,owner,meta41789){
this.actionmenu_component = actionmenu_component;
this.vs = vs;
this.owner = owner;
this.meta41789 = meta41789;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components41788.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41790,meta41789__$1){
var self__ = this;
var _41790__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components41788(self__.actionmenu_component,self__.vs,self__.owner,meta41789__$1));
});

smithy.impl.components.t_smithy$impl$components41788.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41790){
var self__ = this;
var _41790__$1 = this;
return self__.meta41789;
});

smithy.impl.components.t_smithy$impl$components41788.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components41788.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$action_DASH_menu_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.vs),"")){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.vs,cljs.core.cst$kw$action_DASH_menu_DASH_id,"");
} else {
}

var key = cljs.core.cst$kw$vkey;
var G__41791 = ({"className": "actionmenu", "value": cljs.core.cst$kw$action_DASH_menu_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.vs), "onChange": ((function (key,___$1){
return (function (p1__41782_SHARP_){
smithy.impl.components.select_action_event_handler(self__.vs,p1__41782_SHARP_);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.vs,cljs.core.cst$kw$action_DASH_menu_DASH_id,p1__41782_SHARP_.target.value);
});})(key,___$1))
});
var G__41792 = om.core.build_all.cljs$core$IFn$_invoke$arity$3(smithy.impl.components.actionmenu_item_component,smithy.impl.components.actionmenu_builder_list(self__.vs,key),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,key], null));
return (om.dom.select.cljs$core$IFn$_invoke$arity$2 ? om.dom.select.cljs$core$IFn$_invoke$arity$2(G__41791,G__41792) : om.dom.select.call(null,G__41791,G__41792));
});

smithy.impl.components.t_smithy$impl$components41788.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$actionmenu_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Component for the Action Menu drop-down"], null)),cljs.core.cst$sym$vs,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta41789], null);
});

smithy.impl.components.t_smithy$impl$components41788.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components41788.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components41788";

smithy.impl.components.t_smithy$impl$components41788.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components41788");
});

smithy.impl.components.__GT_t_smithy$impl$components41788 = (function smithy$impl$components$actionmenu_component_$___GT_t_smithy$impl$components41788(actionmenu_component__$1,vs__$1,owner__$1,meta41789){
return (new smithy.impl.components.t_smithy$impl$components41788(actionmenu_component__$1,vs__$1,owner__$1,meta41789));
});

}

return (new smithy.impl.components.t_smithy$impl$components41788(smithy$impl$components$actionmenu_component,vs,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for input fields of any type.
 */
smithy.impl.components.field_component = (function smithy$impl$components$field_component(p__41793,owner){
var vec__41813 = p__41793;
var menu_item = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41813,(0),null);
var vs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41813,(1),null);
var buf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41813,(2),null);
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41813,(3),null);
if(typeof smithy.impl.components.t_smithy$impl$components41816 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components41816 = (function (field_component,p__41793,owner,vec__41813,menu_item,vs,buf,opts,meta41817){
this.field_component = field_component;
this.p__41793 = p__41793;
this.owner = owner;
this.vec__41813 = vec__41813;
this.menu_item = menu_item;
this.vs = vs;
this.buf = buf;
this.opts = opts;
this.meta41817 = meta41817;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components41816.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__41813,menu_item,vs,buf,opts){
return (function (_41818,meta41817__$1){
var self__ = this;
var _41818__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components41816(self__.field_component,self__.p__41793,self__.owner,self__.vec__41813,self__.menu_item,self__.vs,self__.buf,self__.opts,meta41817__$1));
});})(vec__41813,menu_item,vs,buf,opts))
;

smithy.impl.components.t_smithy$impl$components41816.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__41813,menu_item,vs,buf,opts){
return (function (_41818){
var self__ = this;
var _41818__$1 = this;
return self__.meta41817;
});})(vec__41813,menu_item,vs,buf,opts))
;

smithy.impl.components.t_smithy$impl$components41816.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components41816.prototype.om$core$IRender$render$arity$1 = ((function (vec__41813,menu_item,vs,buf,opts){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(self__.menu_item),cljs.core.cst$kw$label)){
var G__41819 = ({"className": "section-heading"});
var G__41820 = om.util.force_children(cljs.core.second(self__.menu_item));
return React.DOM.h4(G__41819,G__41820);
} else {
var value = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(self__.vs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.first(self__.menu_item)], null));
var G__41821 = ({"className": (cljs.core.truth_((function (){var and__6405__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$show_DASH_validations], null));
if(cljs.core.truth_(and__6405__auto__)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(value,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$required], null));
} else {
return and__6405__auto__;
}
})())?"field-container show-validations":"field-container")});
var G__41822 = om.util.force_children((function (){var G__41825 = ({"className": "field-required-label"});
var G__41826 = om.util.force_children("Required");
return React.DOM.label(G__41825,G__41826);
})());
var G__41823 = om.util.force_children((function (){var G__41827 = ({"className": "field-label", "title": cljs.core.get.cljs$core$IFn$_invoke$arity$2(value,cljs.core.cst$kw$description)});
var G__41828 = om.util.force_children(cljs.core.get.cljs$core$IFn$_invoke$arity$2(value,cljs.core.cst$kw$label));
var G__41829 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(value,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$required], null)))?(function (){var G__41830 = ({"className": "required-asterisk"});
var G__41831 = om.util.force_children("*");
return React.DOM.label(G__41830,G__41831);
})():null));
return React.DOM.label(G__41827,G__41828,G__41829);
})());
var G__41824 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.inputs.input_field,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(self__.menu_item),value,self__.buf,(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(value,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$detailed], null)))?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$detailed,true], null)], 0)):self__.opts)], null)));
return React.DOM.div(G__41821,G__41822,G__41823,G__41824);
}
});})(vec__41813,menu_item,vs,buf,opts))
;

smithy.impl.components.t_smithy$impl$components41816.getBasis = ((function (vec__41813,menu_item,vs,buf,opts){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$field_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$menu_DASH_item,cljs.core.cst$sym$vs,cljs.core.cst$sym$buf,cljs.core.cst$sym$opts], null),cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Component for input fields of any type."], null)),cljs.core.cst$sym$p__41793,cljs.core.cst$sym$owner,cljs.core.cst$sym$vec__41813,cljs.core.cst$sym$menu_DASH_item,cljs.core.cst$sym$vs,cljs.core.cst$sym$buf,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta41817], null);
});})(vec__41813,menu_item,vs,buf,opts))
;

smithy.impl.components.t_smithy$impl$components41816.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components41816.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components41816";

smithy.impl.components.t_smithy$impl$components41816.cljs$lang$ctorPrWriter = ((function (vec__41813,menu_item,vs,buf,opts){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components41816");
});})(vec__41813,menu_item,vs,buf,opts))
;

smithy.impl.components.__GT_t_smithy$impl$components41816 = ((function (vec__41813,menu_item,vs,buf,opts){
return (function smithy$impl$components$field_component_$___GT_t_smithy$impl$components41816(field_component__$1,p__41793__$1,owner__$1,vec__41813__$1,menu_item__$1,vs__$1,buf__$1,opts__$1,meta41817){
return (new smithy.impl.components.t_smithy$impl$components41816(field_component__$1,p__41793__$1,owner__$1,vec__41813__$1,menu_item__$1,vs__$1,buf__$1,opts__$1,meta41817));
});})(vec__41813,menu_item,vs,buf,opts))
;

}

return (new smithy.impl.components.t_smithy$impl$components41816(smithy$impl$components$field_component,p__41793,owner,vec__41813,menu_item,vs,buf,opts,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Render all fields in the body
 */
smithy.impl.components.body_component = (function smithy$impl$components$body_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components41836 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components41836 = (function (body_component,data,owner,meta41837){
this.body_component = body_component;
this.data = data;
this.owner = owner;
this.meta41837 = meta41837;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components41836.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41838,meta41837__$1){
var self__ = this;
var _41838__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components41836(self__.body_component,self__.data,self__.owner,meta41837__$1));
});

smithy.impl.components.t_smithy$impl$components41836.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41838){
var self__ = this;
var _41838__$1 = this;
return self__.meta41837;
});

smithy.impl.components.t_smithy$impl$components41836.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components41836.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.cst$kw$vs.cljs$core$IFn$_invoke$arity$1(self__.data);
var gens = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$generator_DASH_fn,(function (){var f = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$build_DASH_generator], null));
if(cljs.core.truth_(f)){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(vs) : f.call(null,vs));
} else {
return null;
}
})(),cljs.core.cst$kw$generators,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$generators_DASH_ref),cljs.core.cst$kw$generator_DASH_data,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$generator_DASH_data),cljs.core.cst$kw$generator_DASH_args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)),cljs.core.cst$kw$create))?smithy.util.get_parent_resource_id(vs):smithy.util.get_resource_id(vs))], null),cljs.core.cst$kw$image_DASH_resource_DASH_url,"/media/photo"], null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(om.dom.div,({"className": "section-body"}),om.core.build_all.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.field_component,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vs,gens,___$1){
return (function (p1__41832_SHARP_){
return (new cljs.core.PersistentVector(null,4,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__41832_SHARP_,vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer),((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)),cljs.core.cst$kw$readonly))?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([gens,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$disabled,true], null)], 0)):gens)],null));
});})(vs,gens,___$1))
,cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$screen.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$layout))));
});

smithy.impl.components.t_smithy$impl$components41836.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$body_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Render all fields in the body"], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta41837], null);
});

smithy.impl.components.t_smithy$impl$components41836.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components41836.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components41836";

smithy.impl.components.t_smithy$impl$components41836.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components41836");
});

smithy.impl.components.__GT_t_smithy$impl$components41836 = (function smithy$impl$components$body_component_$___GT_t_smithy$impl$components41836(body_component__$1,data__$1,owner__$1,meta41837){
return (new smithy.impl.components.t_smithy$impl$components41836(body_component__$1,data__$1,owner__$1,meta41837));
});

}

return (new smithy.impl.components.t_smithy$impl$components41836(smithy$impl$components$body_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Button-group component for finalising an update
 */
smithy.impl.components.update_button_component = (function smithy$impl$components$update_button_component(p__41839){
var map__41852 = p__41839;
var map__41852__$1 = ((((!((map__41852 == null)))?((((map__41852.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41852.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41852):map__41852);
var vs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41852__$1,cljs.core.cst$kw$vs);
var update = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41852__$1,cljs.core.cst$kw$update);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41852__$1,cljs.core.cst$kw$cancel);
var delete$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41852__$1,cljs.core.cst$kw$delete);
if(typeof smithy.impl.components.t_smithy$impl$components41854 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components41854 = (function (update_button_component,p__41839,map__41852,vs,update,cancel,delete$,meta41855){
this.update_button_component = update_button_component;
this.p__41839 = p__41839;
this.map__41852 = map__41852;
this.vs = vs;
this.update = update;
this.cancel = cancel;
this.delete$ = delete$;
this.meta41855 = meta41855;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components41854.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__41852,map__41852__$1,vs,update,cancel,delete$){
return (function (_41856,meta41855__$1){
var self__ = this;
var _41856__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components41854(self__.update_button_component,self__.p__41839,self__.map__41852,self__.vs,self__.update,self__.cancel,self__.delete$,meta41855__$1));
});})(map__41852,map__41852__$1,vs,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components41854.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__41852,map__41852__$1,vs,update,cancel,delete$){
return (function (_41856){
var self__ = this;
var _41856__$1 = this;
return self__.meta41855;
});})(map__41852,map__41852__$1,vs,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components41854.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components41854.prototype.om$core$IRender$render$arity$1 = ((function (map__41852,map__41852__$1,vs,update,cancel,delete$){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__41857 = ({"className": "button-container"});
var G__41858 = om.util.force_children((function (){var G__41860 = ({"className": "btn btn-default", "onClick": self__.cancel});
var G__41861 = om.util.force_children(" Cancel");
return React.DOM.button(G__41860,G__41861);
})());
var G__41859 = om.util.force_children((function (){var G__41862 = ({"className": "btn btn-primary", "onClick": self__.update});
var G__41863 = om.util.force_children(" Update");
return React.DOM.button(G__41862,G__41863);
})());
return React.DOM.div(G__41857,G__41858,G__41859);
});})(map__41852,map__41852__$1,vs,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components41854.getBasis = ((function (map__41852,map__41852__$1,vs,update,cancel,delete$){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$update_DASH_button_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$update,cljs.core.cst$sym$cancel,cljs.core.cst$sym$delete], null)], null)], null))),cljs.core.cst$kw$doc,"Button-group component for finalising an update"], null)),cljs.core.cst$sym$p__41839,cljs.core.cst$sym$map__41852,cljs.core.cst$sym$vs,cljs.core.cst$sym$update,cljs.core.cst$sym$cancel,cljs.core.cst$sym$delete,cljs.core.cst$sym$meta41855], null);
});})(map__41852,map__41852__$1,vs,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components41854.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components41854.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components41854";

smithy.impl.components.t_smithy$impl$components41854.cljs$lang$ctorPrWriter = ((function (map__41852,map__41852__$1,vs,update,cancel,delete$){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components41854");
});})(map__41852,map__41852__$1,vs,update,cancel,delete$))
;

smithy.impl.components.__GT_t_smithy$impl$components41854 = ((function (map__41852,map__41852__$1,vs,update,cancel,delete$){
return (function smithy$impl$components$update_button_component_$___GT_t_smithy$impl$components41854(update_button_component__$1,p__41839__$1,map__41852__$2,vs__$1,update__$1,cancel__$1,delete$__$1,meta41855){
return (new smithy.impl.components.t_smithy$impl$components41854(update_button_component__$1,p__41839__$1,map__41852__$2,vs__$1,update__$1,cancel__$1,delete$__$1,meta41855));
});})(map__41852,map__41852__$1,vs,update,cancel,delete$))
;

}

return (new smithy.impl.components.t_smithy$impl$components41854(smithy$impl$components$update_button_component,p__41839,map__41852__$1,vs,update,cancel,delete$,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for Update Mode
 */
smithy.impl.components.resource_update_component = (function smithy$impl$components$resource_update_component(p__41864,owner){
var map__41878 = p__41864;
var map__41878__$1 = ((((!((map__41878 == null)))?((((map__41878.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41878.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41878):map__41878);
var k = map__41878__$1;
var vs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41878__$1,cljs.core.cst$kw$vs);
var screen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41878__$1,cljs.core.cst$kw$screen);
var update = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41878__$1,cljs.core.cst$kw$update);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41878__$1,cljs.core.cst$kw$cancel);
var delete$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41878__$1,cljs.core.cst$kw$delete);
if(typeof smithy.impl.components.t_smithy$impl$components41880 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components41880 = (function (resource_update_component,p__41864,owner,vs,screen,map__41878,update,delete$,k,cancel,meta41881){
this.resource_update_component = resource_update_component;
this.p__41864 = p__41864;
this.owner = owner;
this.vs = vs;
this.screen = screen;
this.map__41878 = map__41878;
this.update = update;
this.delete$ = delete$;
this.k = k;
this.cancel = cancel;
this.meta41881 = meta41881;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components41880.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$){
return (function (_41882,meta41881__$1){
var self__ = this;
var _41882__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components41880(self__.resource_update_component,self__.p__41864,self__.owner,self__.vs,self__.screen,self__.map__41878,self__.update,self__.delete$,self__.k,self__.cancel,meta41881__$1));
});})(map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components41880.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$){
return (function (_41882){
var self__ = this;
var _41882__$1 = this;
return self__.meta41881;
});})(map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components41880.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components41880.prototype.om$core$IRender$render$arity$1 = ((function (map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__41883 = null;
var G__41884 = om.util.force_children((function (){var G__41887 = null;
var G__41888 = om.util.force_children([cljs.core.str("Update "),cljs.core.str(smithy.util.get_screen_title(self__.vs))].join(''));
return React.DOM.h4(G__41887,G__41888);
})());
var G__41885 = om.util.force_children((function (){var G__41889 = null;
var G__41890 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.body_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vs,self__.vs,cljs.core.cst$kw$screen,self__.screen], null)));
return React.DOM.div(G__41889,G__41890);
})());
var G__41886 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.update_button_component,self__.k));
return React.DOM.div(G__41883,G__41884,G__41885,G__41886);
});})(map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components41880.getBasis = ((function (map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$resource_DASH_update_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$screen,cljs.core.cst$sym$update,cljs.core.cst$sym$cancel,cljs.core.cst$sym$delete], null),cljs.core.cst$kw$as,cljs.core.cst$sym$k], null),cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Component for Update Mode"], null)),cljs.core.cst$sym$p__41864,cljs.core.cst$sym$owner,cljs.core.cst$sym$vs,cljs.core.cst$sym$screen,cljs.core.cst$sym$map__41878,cljs.core.cst$sym$update,cljs.core.cst$sym$delete,cljs.core.cst$sym$k,cljs.core.cst$sym$cancel,cljs.core.cst$sym$meta41881], null);
});})(map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components41880.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components41880.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components41880";

smithy.impl.components.t_smithy$impl$components41880.cljs$lang$ctorPrWriter = ((function (map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components41880");
});})(map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$))
;

smithy.impl.components.__GT_t_smithy$impl$components41880 = ((function (map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$){
return (function smithy$impl$components$resource_update_component_$___GT_t_smithy$impl$components41880(resource_update_component__$1,p__41864__$1,owner__$1,vs__$1,screen__$1,map__41878__$2,update__$1,delete$__$1,k__$1,cancel__$1,meta41881){
return (new smithy.impl.components.t_smithy$impl$components41880(resource_update_component__$1,p__41864__$1,owner__$1,vs__$1,screen__$1,map__41878__$2,update__$1,delete$__$1,k__$1,cancel__$1,meta41881));
});})(map__41878,map__41878__$1,k,vs,screen,update,cancel,delete$))
;

}

return (new smithy.impl.components.t_smithy$impl$components41880(smithy$impl$components$resource_update_component,p__41864,owner,vs,screen,map__41878__$1,update,delete$,k,cancel,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for Readonly Mode
 */
smithy.impl.components.resource_view_component = (function smithy$impl$components$resource_view_component(p__41891,owner){
var map__41905 = p__41891;
var map__41905__$1 = ((((!((map__41905 == null)))?((((map__41905.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41905.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41905):map__41905);
var vs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41905__$1,cljs.core.cst$kw$vs);
var screen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41905__$1,cljs.core.cst$kw$screen);
if(typeof smithy.impl.components.t_smithy$impl$components41907 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components41907 = (function (resource_view_component,p__41891,owner,map__41905,vs,screen,meta41908){
this.resource_view_component = resource_view_component;
this.p__41891 = p__41891;
this.owner = owner;
this.map__41905 = map__41905;
this.vs = vs;
this.screen = screen;
this.meta41908 = meta41908;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components41907.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__41905,map__41905__$1,vs,screen){
return (function (_41909,meta41908__$1){
var self__ = this;
var _41909__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components41907(self__.resource_view_component,self__.p__41891,self__.owner,self__.map__41905,self__.vs,self__.screen,meta41908__$1));
});})(map__41905,map__41905__$1,vs,screen))
;

smithy.impl.components.t_smithy$impl$components41907.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__41905,map__41905__$1,vs,screen){
return (function (_41909){
var self__ = this;
var _41909__$1 = this;
return self__.meta41908;
});})(map__41905,map__41905__$1,vs,screen))
;

smithy.impl.components.t_smithy$impl$components41907.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components41907.prototype.om$core$IRender$render$arity$1 = ((function (map__41905,map__41905__$1,vs,screen){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__41910 = null;
var G__41911 = om.util.force_children((cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(self__.vs),cljs.core.cst$kw$actionmenu))?om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.actionmenu_component,self__.vs):null));
var G__41912 = om.util.force_children((function (){var G__41914 = null;
var G__41915 = om.util.force_children(smithy.util.get_screen_title(self__.vs));
return React.DOM.h4(G__41914,G__41915);
})());
var G__41913 = om.util.force_children((function (){var G__41916 = null;
var G__41917 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.body_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vs,self__.vs,cljs.core.cst$kw$screen,self__.screen], null)));
return React.DOM.div(G__41916,G__41917);
})());
return React.DOM.div(G__41910,G__41911,G__41912,G__41913);
});})(map__41905,map__41905__$1,vs,screen))
;

smithy.impl.components.t_smithy$impl$components41907.getBasis = ((function (map__41905,map__41905__$1,vs,screen){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$resource_DASH_view_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$screen], null)], null),cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Component for Readonly Mode"], null)),cljs.core.cst$sym$p__41891,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__41905,cljs.core.cst$sym$vs,cljs.core.cst$sym$screen,cljs.core.cst$sym$meta41908], null);
});})(map__41905,map__41905__$1,vs,screen))
;

smithy.impl.components.t_smithy$impl$components41907.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components41907.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components41907";

smithy.impl.components.t_smithy$impl$components41907.cljs$lang$ctorPrWriter = ((function (map__41905,map__41905__$1,vs,screen){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components41907");
});})(map__41905,map__41905__$1,vs,screen))
;

smithy.impl.components.__GT_t_smithy$impl$components41907 = ((function (map__41905,map__41905__$1,vs,screen){
return (function smithy$impl$components$resource_view_component_$___GT_t_smithy$impl$components41907(resource_view_component__$1,p__41891__$1,owner__$1,map__41905__$2,vs__$1,screen__$1,meta41908){
return (new smithy.impl.components.t_smithy$impl$components41907(resource_view_component__$1,p__41891__$1,owner__$1,map__41905__$2,vs__$1,screen__$1,meta41908));
});})(map__41905,map__41905__$1,vs,screen))
;

}

return (new smithy.impl.components.t_smithy$impl$components41907(smithy$impl$components$resource_view_component,p__41891,owner,map__41905__$1,vs,screen,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for Create Mode
 */
smithy.impl.components.resource_create_component = (function smithy$impl$components$resource_create_component(p__41918,owner){
var map__41938 = p__41918;
var map__41938__$1 = ((((!((map__41938 == null)))?((((map__41938.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41938.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41938):map__41938);
var vs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41938__$1,cljs.core.cst$kw$vs);
var screen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41938__$1,cljs.core.cst$kw$screen);
var create = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41938__$1,cljs.core.cst$kw$create);
if(typeof smithy.impl.components.t_smithy$impl$components41940 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components41940 = (function (resource_create_component,p__41918,owner,map__41938,vs,screen,create,meta41941){
this.resource_create_component = resource_create_component;
this.p__41918 = p__41918;
this.owner = owner;
this.map__41938 = map__41938;
this.vs = vs;
this.screen = screen;
this.create = create;
this.meta41941 = meta41941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components41940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__41938,map__41938__$1,vs,screen,create){
return (function (_41942,meta41941__$1){
var self__ = this;
var _41942__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components41940(self__.resource_create_component,self__.p__41918,self__.owner,self__.map__41938,self__.vs,self__.screen,self__.create,meta41941__$1));
});})(map__41938,map__41938__$1,vs,screen,create))
;

smithy.impl.components.t_smithy$impl$components41940.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__41938,map__41938__$1,vs,screen,create){
return (function (_41942){
var self__ = this;
var _41942__$1 = this;
return self__.meta41941;
});})(map__41938,map__41938__$1,vs,screen,create))
;

smithy.impl.components.t_smithy$impl$components41940.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components41940.prototype.om$core$IRender$render$arity$1 = ((function (map__41938,map__41938__$1,vs,screen,create){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__41943 = null;
var G__41944 = om.util.force_children((cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.vs,cljs.core.cst$kw$title_DASH_override))?(function (){var G__41947 = null;
var G__41948 = om.util.force_children(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.vs,cljs.core.cst$kw$title_DASH_override));
return React.DOM.h4(G__41947,G__41948);
})():(function (){var G__41949 = null;
var G__41950 = om.util.force_children([cljs.core.str("Create "),cljs.core.str(smithy.util.get_screen_title(self__.vs))].join(''));
return React.DOM.h4(G__41949,G__41950);
})()));
var G__41945 = om.util.force_children((function (){var G__41951 = null;
var G__41952 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.body_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vs,self__.vs,cljs.core.cst$kw$screen,self__.screen], null)));
return React.DOM.div(G__41951,G__41952);
})());
var G__41946 = om.util.force_children((function (){var G__41953 = ({"className": "button-container"});
var G__41954 = om.util.force_children((function (){var G__41955 = ({"className": "btn btn-primary fa fa-plus fa-2x", "onClick": self__.create});
var G__41956 = om.util.force_children(" Create");
return React.DOM.button(G__41955,G__41956);
})());
return React.DOM.div(G__41953,G__41954);
})());
return React.DOM.div(G__41943,G__41944,G__41945,G__41946);
});})(map__41938,map__41938__$1,vs,screen,create))
;

smithy.impl.components.t_smithy$impl$components41940.getBasis = ((function (map__41938,map__41938__$1,vs,screen,create){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$resource_DASH_create_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$screen,cljs.core.cst$sym$create], null)], null),cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Component for Create Mode"], null)),cljs.core.cst$sym$p__41918,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__41938,cljs.core.cst$sym$vs,cljs.core.cst$sym$screen,cljs.core.cst$sym$create,cljs.core.cst$sym$meta41941], null);
});})(map__41938,map__41938__$1,vs,screen,create))
;

smithy.impl.components.t_smithy$impl$components41940.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components41940.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components41940";

smithy.impl.components.t_smithy$impl$components41940.cljs$lang$ctorPrWriter = ((function (map__41938,map__41938__$1,vs,screen,create){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components41940");
});})(map__41938,map__41938__$1,vs,screen,create))
;

smithy.impl.components.__GT_t_smithy$impl$components41940 = ((function (map__41938,map__41938__$1,vs,screen,create){
return (function smithy$impl$components$resource_create_component_$___GT_t_smithy$impl$components41940(resource_create_component__$1,p__41918__$1,owner__$1,map__41938__$2,vs__$1,screen__$1,create__$1,meta41941){
return (new smithy.impl.components.t_smithy$impl$components41940(resource_create_component__$1,p__41918__$1,owner__$1,map__41938__$2,vs__$1,screen__$1,create__$1,meta41941));
});})(map__41938,map__41938__$1,vs,screen,create))
;

}

return (new smithy.impl.components.t_smithy$impl$components41940(smithy$impl$components$resource_create_component,p__41918,owner,map__41938__$1,vs,screen,create,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for a single navigation item in the sidebar.
 */
smithy.impl.components.sidebar_item_component = (function smithy$impl$components$sidebar_item_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components41967 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components41967 = (function (sidebar_item_component,data,owner,meta41968){
this.sidebar_item_component = sidebar_item_component;
this.data = data;
this.owner = owner;
this.meta41968 = meta41968;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components41967.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41969,meta41968__$1){
var self__ = this;
var _41969__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components41967(self__.sidebar_item_component,self__.data,self__.owner,meta41968__$1));
});

smithy.impl.components.t_smithy$impl$components41967.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41969){
var self__ = this;
var _41969__$1 = this;
return self__.meta41968;
});

smithy.impl.components.t_smithy$impl$components41967.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components41967.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__41970 = ({"className": "sidebar-item", "onClick": ((function (___$1){
return (function (){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$view_DASH_state,cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$sidebar_DASH_item_DASH_click], null)).call(null,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.cst$kw$view_DASH_state),cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.cst$kw$resource_DASH_id));
});})(___$1))
});
var G__41971 = om.util.force_children((function (){var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$item.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.cst$kw$label));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.type(label),goog.date.UtcDateTime)){
var df = (new goog.i18n.DateTimeFormat("yyyy-MM-dd HH:mm:ss"));
var G__41972 = null;
var G__41973 = om.util.force_children(df.format((function (){var G__41974 = label.getTime();
return (goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1 ? goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1(G__41974) : goog.date.UtcDateTime.fromTimestamp.call(null,G__41974));
})()));
return React.DOM.a(G__41972,G__41973);
} else {
var G__41975 = null;
var G__41976 = om.util.force_children(label);
return React.DOM.a(G__41975,G__41976);
}
})());
return React.DOM.li(G__41970,G__41971);
});

smithy.impl.components.t_smithy$impl$components41967.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$sidebar_DASH_item_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Component for a single navigation item in the sidebar."], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta41968], null);
});

smithy.impl.components.t_smithy$impl$components41967.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components41967.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components41967";

smithy.impl.components.t_smithy$impl$components41967.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components41967");
});

smithy.impl.components.__GT_t_smithy$impl$components41967 = (function smithy$impl$components$sidebar_item_component_$___GT_t_smithy$impl$components41967(sidebar_item_component__$1,data__$1,owner__$1,meta41968){
return (new smithy.impl.components.t_smithy$impl$components41967(sidebar_item_component__$1,data__$1,owner__$1,meta41968));
});

}

return (new smithy.impl.components.t_smithy$impl$components41967(smithy$impl$components$sidebar_item_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Return the built components for the sidebar items.
 */
smithy.impl.components.build_sidebar_item_components = (function smithy$impl$components$build_sidebar_item_components(vs){
var screen = smithy.util.get_screen(vs);
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$sidebar,cljs.core.cst$kw$resource], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(om.dom.ul,null,(function (){var G__41981 = null;
var G__41982 = om.util.force_children(cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$title));
return React.DOM.li(G__41981,G__41982);
})(),om.core.build_all.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.sidebar_item_component,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (screen,res){
return (function (p1__41977_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$item,cljs.core.cst$kw$view_DASH_state,cljs.core.cst$kw$label,cljs.core.cst$kw$id,cljs.core.cst$kw$resource_DASH_id,cljs.core.cst$kw$uri],[p1__41977_SHARP_,vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$label),cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$id),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__41977_SHARP_,cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$id)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__41977_SHARP_,cljs.core.cst$kw$uri)]);
});})(screen,res))
,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (screen,res){
return (function (p1__41978_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__41978_SHARP_,cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(res));
});})(screen,res))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$children], null))))));
});
/**
 * Component for the navigation sidebar.
 */
smithy.impl.components.sidebar_component = (function smithy$impl$components$sidebar_component(vs,owner){
if(typeof smithy.impl.components.t_smithy$impl$components41990 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components41990 = (function (sidebar_component,vs,owner,meta41991){
this.sidebar_component = sidebar_component;
this.vs = vs;
this.owner = owner;
this.meta41991 = meta41991;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components41990.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41992,meta41991__$1){
var self__ = this;
var _41992__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components41990(self__.sidebar_component,self__.vs,self__.owner,meta41991__$1));
});

smithy.impl.components.t_smithy$impl$components41990.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41992){
var self__ = this;
var _41992__$1 = this;
return self__.meta41991;
});

smithy.impl.components.t_smithy$impl$components41990.prototype.om$core$IWillMount$ = true;

smithy.impl.components.t_smithy$impl$components41990.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$actions_DASH_ref,cljs.core.cst$kw$load_DASH_resource_DASH_children], null)).call(null,self__.vs);
});

smithy.impl.components.t_smithy$impl$components41990.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components41990.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__41993 = ({"className": "sidebar"});
var G__41994 = om.util.force_children(((cljs.core.not(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(self__.vs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$resource,cljs.core.cst$kw$non_DASH_creatable], null))))?(function (){var G__41996 = ({"className": "create-record-btn btn btn-primary fa fa-plus fa-2x", "disabled": cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)),cljs.core.cst$kw$create), "onClick": ((function (G__41993,___$1){
return (function (){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$sidebar_DASH_create_DASH_click], null)).call(null,self__.vs);
});})(G__41993,___$1))
});
return React.DOM.button(G__41996);
})():null));
var G__41995 = om.util.force_children(smithy.impl.components.build_sidebar_item_components(self__.vs));
return React.DOM.div(G__41993,G__41994,G__41995);
});

smithy.impl.components.t_smithy$impl$components41990.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$sidebar_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Component for the navigation sidebar."], null)),cljs.core.cst$sym$vs,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta41991], null);
});

smithy.impl.components.t_smithy$impl$components41990.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components41990.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components41990";

smithy.impl.components.t_smithy$impl$components41990.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components41990");
});

smithy.impl.components.__GT_t_smithy$impl$components41990 = (function smithy$impl$components$sidebar_component_$___GT_t_smithy$impl$components41990(sidebar_component__$1,vs__$1,owner__$1,meta41991){
return (new smithy.impl.components.t_smithy$impl$components41990(sidebar_component__$1,vs__$1,owner__$1,meta41991));
});

}

return (new smithy.impl.components.t_smithy$impl$components41990(smithy$impl$components$sidebar_component,vs,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Builder for a Update-Mode component
 */
smithy.impl.components.build_update_component = (function smithy$impl$components$build_update_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components42002 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components42002 = (function (build_update_component,data,owner,meta42003){
this.build_update_component = build_update_component;
this.data = data;
this.owner = owner;
this.meta42003 = meta42003;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components42002.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42004,meta42003__$1){
var self__ = this;
var _42004__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components42002(self__.build_update_component,self__.data,self__.owner,meta42003__$1));
});

smithy.impl.components.t_smithy$impl$components42002.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42004){
var self__ = this;
var _42004__$1 = this;
return self__.meta42003;
});

smithy.impl.components.t_smithy$impl$components42002.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components42002.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.cst$kw$vs.cljs$core$IFn$_invoke$arity$1(self__.data);
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer))){
var screen = smithy.util.get_screen(vs);
var rupdate = ((function (screen,vs,___$1){
return (function (){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$update], null)).call(null,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$update,cljs.core.cst$kw$submit,cljs.core.cst$kw$success,cljs.core.cst$kw$event], null)),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$update,cljs.core.cst$kw$submit,cljs.core.cst$kw$error,cljs.core.cst$kw$event], null)),vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details);
});})(screen,vs,___$1))
;
var rcancel = ((function (screen,rupdate,vs,___$1){
return (function (){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$cancel_DASH_update], null)).call(null,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$update,cljs.core.cst$kw$cancel,cljs.core.cst$kw$event], null)),vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details);
});})(screen,rupdate,vs,___$1))
;
var rdelete = ((function (screen,rupdate,rcancel,vs,___$1){
return (function (){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$delete], null)).call(null,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$success,cljs.core.cst$kw$event], null)),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$error,cljs.core.cst$kw$event], null)),vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details);
});})(screen,rupdate,rcancel,vs,___$1))
;
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.resource_update_component,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$vs,vs,cljs.core.cst$kw$screen,screen,cljs.core.cst$kw$update,rupdate,cljs.core.cst$kw$cancel,rcancel,cljs.core.cst$kw$delete,rdelete], null));
} else {
var G__42005 = null;
var G__42006 = om.util.force_children("Loading...");
return React.DOM.span(G__42005,G__42006);
}
});

smithy.impl.components.t_smithy$impl$components42002.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$build_DASH_update_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Builder for a Update-Mode component"], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta42003], null);
});

smithy.impl.components.t_smithy$impl$components42002.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components42002.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components42002";

smithy.impl.components.t_smithy$impl$components42002.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components42002");
});

smithy.impl.components.__GT_t_smithy$impl$components42002 = (function smithy$impl$components$build_update_component_$___GT_t_smithy$impl$components42002(build_update_component__$1,data__$1,owner__$1,meta42003){
return (new smithy.impl.components.t_smithy$impl$components42002(build_update_component__$1,data__$1,owner__$1,meta42003));
});

}

return (new smithy.impl.components.t_smithy$impl$components42002(smithy$impl$components$build_update_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Builder for a Readonly-Mode component
 */
smithy.impl.components.build_readonly_component = (function smithy$impl$components$build_readonly_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components42012 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components42012 = (function (build_readonly_component,data,owner,meta42013){
this.build_readonly_component = build_readonly_component;
this.data = data;
this.owner = owner;
this.meta42013 = meta42013;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components42012.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42014,meta42013__$1){
var self__ = this;
var _42014__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components42012(self__.build_readonly_component,self__.data,self__.owner,meta42013__$1));
});

smithy.impl.components.t_smithy$impl$components42012.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42014){
var self__ = this;
var _42014__$1 = this;
return self__.meta42013;
});

smithy.impl.components.t_smithy$impl$components42012.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components42012.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$vs,cljs.core.cst$kw$buffer], null)))){
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.resource_view_component,self__.data);
} else {
var G__42015 = null;
var G__42016 = om.util.force_children("Loading...");
return React.DOM.span(G__42015,G__42016);
}
});

smithy.impl.components.t_smithy$impl$components42012.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$build_DASH_readonly_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Builder for a Readonly-Mode component"], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta42013], null);
});

smithy.impl.components.t_smithy$impl$components42012.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components42012.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components42012";

smithy.impl.components.t_smithy$impl$components42012.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components42012");
});

smithy.impl.components.__GT_t_smithy$impl$components42012 = (function smithy$impl$components$build_readonly_component_$___GT_t_smithy$impl$components42012(build_readonly_component__$1,data__$1,owner__$1,meta42013){
return (new smithy.impl.components.t_smithy$impl$components42012(build_readonly_component__$1,data__$1,owner__$1,meta42013));
});

}

return (new smithy.impl.components.t_smithy$impl$components42012(smithy$impl$components$build_readonly_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Builder for a Create-Mode component
 */
smithy.impl.components.build_create_component = (function smithy$impl$components$build_create_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components42020 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components42020 = (function (build_create_component,data,owner,meta42021){
this.build_create_component = build_create_component;
this.data = data;
this.owner = owner;
this.meta42021 = meta42021;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components42020.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42022,meta42021__$1){
var self__ = this;
var _42022__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components42020(self__.build_create_component,self__.data,self__.owner,meta42021__$1));
});

smithy.impl.components.t_smithy$impl$components42020.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42022){
var self__ = this;
var _42022__$1 = this;
return self__.meta42021;
});

smithy.impl.components.t_smithy$impl$components42020.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components42020.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.cst$kw$vs.cljs$core$IFn$_invoke$arity$1(self__.data);
var screen = cljs.core.cst$kw$screen.cljs$core$IFn$_invoke$arity$1(self__.data);
var create_fn = ((function (vs,screen,___$1){
return (function (){
return (cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$nav_DASH_to], null)))?cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$create_DASH_nav], null)):cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$create], null))).call(null,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$create,cljs.core.cst$kw$submit,cljs.core.cst$kw$success,cljs.core.cst$kw$event], null)),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$create,cljs.core.cst$kw$submit,cljs.core.cst$kw$error,cljs.core.cst$kw$event], null)),vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details);
});})(vs,screen,___$1))
;
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$resource,cljs.core.cst$kw$non_DASH_creatable], null)))){
return null;
} else {
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.resource_create_component,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vs,vs,cljs.core.cst$kw$screen,screen,cljs.core.cst$kw$create,create_fn], null));
}
});

smithy.impl.components.t_smithy$impl$components42020.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$build_DASH_create_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Builder for a Create-Mode component"], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta42021], null);
});

smithy.impl.components.t_smithy$impl$components42020.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components42020.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components42020";

smithy.impl.components.t_smithy$impl$components42020.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components42020");
});

smithy.impl.components.__GT_t_smithy$impl$components42020 = (function smithy$impl$components$build_create_component_$___GT_t_smithy$impl$components42020(build_create_component__$1,data__$1,owner__$1,meta42021){
return (new smithy.impl.components.t_smithy$impl$components42020(build_create_component__$1,data__$1,owner__$1,meta42021));
});

}

return (new smithy.impl.components.t_smithy$impl$components42020(smithy$impl$components$build_create_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * A single segment in the breadcrumbs component.
 */
smithy.impl.components.breadcrumb_item_component = (function smithy$impl$components$breadcrumb_item_component(p__42023,owner){
var map__42033 = p__42023;
var map__42033__$1 = ((((!((map__42033 == null)))?((((map__42033.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42033.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42033):map__42033);
var vs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42033__$1,cljs.core.cst$kw$vs);
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42033__$1,cljs.core.cst$kw$token);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42033__$1,cljs.core.cst$kw$label);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42033__$1,cljs.core.cst$kw$state);
if(typeof smithy.impl.components.t_smithy$impl$components42035 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components42035 = (function (breadcrumb_item_component,p__42023,owner,map__42033,vs,token,label,state,meta42036){
this.breadcrumb_item_component = breadcrumb_item_component;
this.p__42023 = p__42023;
this.owner = owner;
this.map__42033 = map__42033;
this.vs = vs;
this.token = token;
this.label = label;
this.state = state;
this.meta42036 = meta42036;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components42035.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__42033,map__42033__$1,vs,token,label,state){
return (function (_42037,meta42036__$1){
var self__ = this;
var _42037__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components42035(self__.breadcrumb_item_component,self__.p__42023,self__.owner,self__.map__42033,self__.vs,self__.token,self__.label,self__.state,meta42036__$1));
});})(map__42033,map__42033__$1,vs,token,label,state))
;

smithy.impl.components.t_smithy$impl$components42035.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__42033,map__42033__$1,vs,token,label,state){
return (function (_42037){
var self__ = this;
var _42037__$1 = this;
return self__.meta42036;
});})(map__42033,map__42033__$1,vs,token,label,state))
;

smithy.impl.components.t_smithy$impl$components42035.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components42035.prototype.om$core$IRender$render$arity$1 = ((function (map__42033,map__42033__$1,vs,token,label,state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__42038 = ({"className": "breadcrumb-item"});
var G__42039 = om.util.force_children((function (){var G__42040 = ({"onClick": ((function (G__42038,___$1,map__42033,map__42033__$1,vs,token,label,state){
return (function (){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$breadcrumb_DASH_item_DASH_click], null)).call(null,self__.token,self__.vs,self__.state);
});})(G__42038,___$1,map__42033,map__42033__$1,vs,token,label,state))
});
var G__42041 = om.util.force_children(self__.label);
return React.DOM.a(G__42040,G__42041);
})());
return React.DOM.span(G__42038,G__42039);
});})(map__42033,map__42033__$1,vs,token,label,state))
;

smithy.impl.components.t_smithy$impl$components42035.getBasis = ((function (map__42033,map__42033__$1,vs,token,label,state){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$breadcrumb_DASH_item_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$token,cljs.core.cst$sym$label,cljs.core.cst$sym$state], null)], null),cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"A single segment in the breadcrumbs component."], null)),cljs.core.cst$sym$p__42023,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__42033,cljs.core.cst$sym$vs,cljs.core.cst$sym$token,cljs.core.cst$sym$label,cljs.core.cst$sym$state,cljs.core.cst$sym$meta42036], null);
});})(map__42033,map__42033__$1,vs,token,label,state))
;

smithy.impl.components.t_smithy$impl$components42035.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components42035.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components42035";

smithy.impl.components.t_smithy$impl$components42035.cljs$lang$ctorPrWriter = ((function (map__42033,map__42033__$1,vs,token,label,state){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components42035");
});})(map__42033,map__42033__$1,vs,token,label,state))
;

smithy.impl.components.__GT_t_smithy$impl$components42035 = ((function (map__42033,map__42033__$1,vs,token,label,state){
return (function smithy$impl$components$breadcrumb_item_component_$___GT_t_smithy$impl$components42035(breadcrumb_item_component__$1,p__42023__$1,owner__$1,map__42033__$2,vs__$1,token__$1,label__$1,state__$1,meta42036){
return (new smithy.impl.components.t_smithy$impl$components42035(breadcrumb_item_component__$1,p__42023__$1,owner__$1,map__42033__$2,vs__$1,token__$1,label__$1,state__$1,meta42036));
});})(map__42033,map__42033__$1,vs,token,label,state))
;

}

return (new smithy.impl.components.t_smithy$impl$components42035(smithy$impl$components$breadcrumb_item_component,p__42023,owner,map__42033__$1,vs,token,label,state,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Navigation Breadcrumbs component.
 */
smithy.impl.components.breadcrumb_component = (function smithy$impl$components$breadcrumb_component(vs,owner){
if(typeof smithy.impl.components.t_smithy$impl$components42048 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components42048 = (function (breadcrumb_component,vs,owner,meta42049){
this.breadcrumb_component = breadcrumb_component;
this.vs = vs;
this.owner = owner;
this.meta42049 = meta42049;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components42048.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42050,meta42049__$1){
var self__ = this;
var _42050__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components42048(self__.breadcrumb_component,self__.vs,self__.owner,meta42049__$1));
});

smithy.impl.components.t_smithy$impl$components42048.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42050){
var self__ = this;
var _42050__$1 = this;
return self__.meta42049;
});

smithy.impl.components.t_smithy$impl$components42048.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components42048.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var hist_fn = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$nav_DASH_history], null));
var history = (function (){var and__6405__auto__ = hist_fn;
if(cljs.core.truth_(and__6405__auto__)){
return (hist_fn.cljs$core$IFn$_invoke$arity$0 ? hist_fn.cljs$core$IFn$_invoke$arity$0() : hist_fn.call(null));
} else {
return and__6405__auto__;
}
})();
if(cljs.core.empty_QMARK_(history)){
return null;
} else {
var G__42051 = ({"className": "breadcrumbs"});
var G__42052 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(smithy.impl.components.breadcrumb_item_component,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__42051,hist_fn,history,___$1){
return (function (p1__42042_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__42042_SHARP_,cljs.core.cst$kw$vs,self__.vs);
});})(G__42051,hist_fn,history,___$1))
,history),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$token], null)));
return React.DOM.div(G__42051,G__42052);
}
});

smithy.impl.components.t_smithy$impl$components42048.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$breadcrumb_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Navigation Breadcrumbs component."], null)),cljs.core.cst$sym$vs,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta42049], null);
});

smithy.impl.components.t_smithy$impl$components42048.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components42048.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components42048";

smithy.impl.components.t_smithy$impl$components42048.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components42048");
});

smithy.impl.components.__GT_t_smithy$impl$components42048 = (function smithy$impl$components$breadcrumb_component_$___GT_t_smithy$impl$components42048(breadcrumb_component__$1,vs__$1,owner__$1,meta42049){
return (new smithy.impl.components.t_smithy$impl$components42048(breadcrumb_component__$1,vs__$1,owner__$1,meta42049));
});

}

return (new smithy.impl.components.t_smithy$impl$components42048(smithy$impl$components$breadcrumb_component,vs,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Wrap a component for the current view mode.
 */
smithy.impl.components.content_component = (function smithy$impl$components$content_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components42062 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components42062 = (function (content_component,data,owner,meta42063){
this.content_component = content_component;
this.data = data;
this.owner = owner;
this.meta42063 = meta42063;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components42062.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42064,meta42063__$1){
var self__ = this;
var _42064__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components42062(self__.content_component,self__.data,self__.owner,meta42063__$1));
});

smithy.impl.components.t_smithy$impl$components42062.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42064){
var self__ = this;
var _42064__$1 = this;
return self__.meta42063;
});

smithy.impl.components.t_smithy$impl$components42062.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components42062.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.cst$kw$vs.cljs$core$IFn$_invoke$arity$1(self__.data);
var G__42065 = ({"className": "main-content"});
var G__42066 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.breadcrumb_component,vs));
var G__42067 = om.util.force_children((function (){var G__42068 = (((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)) instanceof cljs.core.Keyword))?cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)).fqn:null);
switch (G__42068) {
case "update":
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.build_update_component,self__.data);

break;
case "readonly":
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.build_readonly_component,self__.data);

break;
case "create":
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.build_create_component,self__.data);

break;
default:
var G__42069 = null;
var G__42070 = om.util.force_children([cljs.core.str("Unable to find mode: "),cljs.core.str(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)))].join(''));
return React.DOM.span(G__42069,G__42070);

}
})());
return React.DOM.div(G__42065,G__42066,G__42067);
});

smithy.impl.components.t_smithy$impl$components42062.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$content_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null))),cljs.core.cst$kw$doc,"Wrap a component for the current view mode."], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta42063], null);
});

smithy.impl.components.t_smithy$impl$components42062.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components42062.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components42062";

smithy.impl.components.t_smithy$impl$components42062.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components42062");
});

smithy.impl.components.__GT_t_smithy$impl$components42062 = (function smithy$impl$components$content_component_$___GT_t_smithy$impl$components42062(content_component__$1,data__$1,owner__$1,meta42063){
return (new smithy.impl.components.t_smithy$impl$components42062(content_component__$1,data__$1,owner__$1,meta42063));
});

}

return (new smithy.impl.components.t_smithy$impl$components42062(smithy$impl$components$content_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Build a view component for `type', where type is a screen type.
 */
smithy.impl.components.build_view_component = (function smithy$impl$components$build_view_component(type){
return (function (app,owner){
if(typeof smithy.impl.components.t_smithy$impl$components42079 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components42079 = (function (build_view_component,type,app,owner,meta42080){
this.build_view_component = build_view_component;
this.type = type;
this.app = app;
this.owner = owner;
this.meta42080 = meta42080;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
smithy.impl.components.t_smithy$impl$components42079.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42081,meta42080__$1){
var self__ = this;
var _42081__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components42079(self__.build_view_component,self__.type,self__.app,self__.owner,meta42080__$1));
});

smithy.impl.components.t_smithy$impl$components42079.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42081){
var self__ = this;
var _42081__$1 = this;
return self__.meta42080;
});

smithy.impl.components.t_smithy$impl$components42079.prototype.om$core$IWillMount$ = true;

smithy.impl.components.t_smithy$impl$components42079.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$view,self__.type], null));
if(cljs.core.truth_(cljs.core.cst$kw$screens_DASH_ref_DASH_override.cljs$core$IFn$_invoke$arity$1(vs))){
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$screens_DASH_ref,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.app,cljs.core.cst$kw$screens));
}

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$events_DASH_ref,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.app,cljs.core.cst$kw$events));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$actions_DASH_ref,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.app,cljs.core.cst$kw$actions));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$generators_DASH_ref,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.app,cljs.core.cst$kw$generators));

return om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,((function (vs,___$1){
return (function (p1__42072_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,p1__42072_SHARP_);
});})(vs,___$1))
);
});

smithy.impl.components.t_smithy$impl$components42079.prototype.om$core$IRender$ = true;

smithy.impl.components.t_smithy$impl$components42079.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$view,self__.type], null));
var screen = smithy.util.get_screen(vs);
var temp__4655__auto___42085 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$resource_DASH_id], null));
if(cljs.core.truth_(temp__4655__auto___42085)){
var rid_42086 = temp__4655__auto___42085;
var temp__4655__auto___42087__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$actions_DASH_ref,cljs.core.cst$kw$load_DASH_resource], null));
if(cljs.core.truth_(temp__4655__auto___42087__$1)){
var f_42088 = temp__4655__auto___42087__$1;
(f_42088.cljs$core$IFn$_invoke$arity$2 ? f_42088.cljs$core$IFn$_invoke$arity$2(vs,rid_42086) : f_42088.call(null,vs,rid_42086));
} else {
}
} else {
}

var G__42082 = ({"className": "main-content-container"});
var G__42083 = om.util.force_children((cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(screen,cljs.core.cst$kw$sidebar))?om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.sidebar_component,vs):null));
var G__42084 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.content_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vs,vs,cljs.core.cst$kw$screen,screen], null)));
return React.DOM.div(G__42082,G__42083,G__42084);
});

smithy.impl.components.t_smithy$impl$components42079.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$build_DASH_view_DASH_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type], null))),cljs.core.cst$kw$doc,"Build a view component for `type', where type is a screen type."], null)),cljs.core.cst$sym$type,cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta42080], null);
});

smithy.impl.components.t_smithy$impl$components42079.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components42079.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components42079";

smithy.impl.components.t_smithy$impl$components42079.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"smithy.impl.components/t_smithy$impl$components42079");
});

smithy.impl.components.__GT_t_smithy$impl$components42079 = (function smithy$impl$components$build_view_component_$___GT_t_smithy$impl$components42079(build_view_component__$1,type__$1,app__$1,owner__$1,meta42080){
return (new smithy.impl.components.t_smithy$impl$components42079(build_view_component__$1,type__$1,app__$1,owner__$1,meta42080));
});

}

return (new smithy.impl.components.t_smithy$impl$components42079(smithy$impl$components$build_view_component,type,app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
});
