// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('smithy.util');
goog.require('cljs.core');
/**
 * Return the screen corresponding to the given view-state.
 */
smithy.util.get_screen = (function smithy$util$get_screen(vs){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screens_DASH_ref),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$type], null)));
});
/**
 * Return the resource `k' of the screen of the given view-state.
 */
smithy.util.get_screen_resource = (function smithy$util$get_screen_resource(vs,k){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(vs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$resource,k], null));
});
/**
 * Return the current resource's endpoint.
 */
smithy.util.get_endpoint = (function smithy$util$get_endpoint(vs){
return smithy.util.get_screen_resource(vs,cljs.core.cst$kw$endpoint);
});
/**
 * Return the title of the screen of the given view-state.
 */
smithy.util.get_screen_title = (function smithy$util$get_screen_title(vs){
return smithy.util.get_screen_resource(vs,cljs.core.cst$kw$title);
});
/**
 * Get the name for the current screen's resource type.
 */
smithy.util.get_resource_type_name = (function smithy$util$get_resource_type_name(vs){
return cljs.core.name(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(vs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$resource,cljs.core.cst$kw$type], null)));
});
smithy.util.get_resource_name = (function smithy$util$get_resource_name(vs){
var namekey = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(vs),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$sidebar,cljs.core.cst$kw$resource,cljs.core.cst$kw$label], null));
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details,namekey,cljs.core.cst$kw$value], null));
});
/**
 * Return the state as a breadcrumb label.
 */
smithy.util.get_breadcrumb_label = (function smithy$util$get_breadcrumb_label(vs){
return [cljs.core.str(smithy.util.get_screen_title(vs)),cljs.core.str(": "),cljs.core.str(smithy.util.get_resource_name(vs))].join('');
});
/**
 * Return the ID of the current resource for this view-state.
 */
smithy.util.get_resource_id = (function smithy$util$get_resource_id(vs){
var rid = smithy.util.get_screen_resource(vs,cljs.core.cst$kw$id);
if((rid == null)){
return null;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details,rid,cljs.core.cst$kw$value], null));
}
});
/**
 * Return the parent resource's endpoint URL for the current view-state.
 */
smithy.util.get_parent_resource_id = (function smithy$util$get_parent_resource_id(vs){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$id], null));
});
/**
 * Return the endpoint URL for the current view-state.
 */
smithy.util.get_url = (function smithy$util$get_url(vs){
var rid = smithy.util.get_resource_id(vs);
var base = smithy.util.get_endpoint(vs);
if((rid == null)){
return base;
} else {
return [cljs.core.str(base),cljs.core.str("/"),cljs.core.str(rid)].join('');
}
});
/**
 * Predicate for whether this view-state is for the settings screen.
 */
smithy.util.settings_screen_QMARK_ = (function smithy$util$settings_screen_QMARK_(vs){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen_resource(vs,cljs.core.cst$kw$type),cljs.core.cst$kw$settings);
});
