// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('taoensso.encore');
goog.require('cljs.core');
goog.require('goog.net.XhrIoPool');
goog.require('goog.events');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('goog.Uri.QueryData');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
goog.require('goog.net.EventType');
goog.require('goog.structs');
goog.require('goog.string.format');
goog.require('clojure.string');
goog.require('cljs.reader');
goog.require('goog.net.ErrorCode');
/**
 * Used for lib-consumer version assertions
 */
taoensso.encore.encore_version = 1.38;
taoensso.encore.assert_min_encore_version = (function taoensso$encore$assert_min_encore_version(min_version){
if((taoensso.encore.encore_version < min_version)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((taoensso.encore.format.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.format.cljs$core$IFn$_invoke$arity$3("Insufficient com.taoensso/encore version: %s < %s. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).",taoensso.encore.encore_version,min_version) : taoensso.encore.format.call(null,"Insufficient com.taoensso/encore version: %s < %s. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).",taoensso.encore.encore_version,min_version)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$min_DASH_version,min_version,cljs.core.cst$kw$this_DASH_version,taoensso.encore.encore_version], null));
} else {
return null;
}
});
taoensso.encore.read_edn = (function taoensso$encore$read_edn(s){
return cljs.reader.read_string(s);
});
taoensso.encore.pr_edn = (function taoensso$encore$pr_edn(var_args){
var args24793 = [];
var len__7492__auto___24798 = arguments.length;
var i__7493__auto___24799 = (0);
while(true){
if((i__7493__auto___24799 < len__7492__auto___24798)){
args24793.push((arguments[i__7493__auto___24799]));

var G__24800 = (i__7493__auto___24799 + (1));
i__7493__auto___24799 = G__24800;
continue;
} else {
}
break;
}

var G__24795 = args24793.length;
switch (G__24795) {
case 1:
return taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24793.length)].join('')));

}
});

taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$1 = (function (x){
return taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$2(null,x);
});

taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$2 = (function (opts,x){
var _STAR_print_level_STAR_24796 = cljs.core._STAR_print_level_STAR_;
var _STAR_print_length_STAR_24797 = cljs.core._STAR_print_length_STAR_;
cljs.core._STAR_print_level_STAR_ = null;

cljs.core._STAR_print_length_STAR_ = null;

try{return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([x], 0));
}finally {cljs.core._STAR_print_length_STAR_ = _STAR_print_length_STAR_24797;

cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_24796;
}});

taoensso.encore.pr_edn.cljs$lang$maxFixedArity = 2;

/**
 * Handles optional docstrings & attr maps for a macro def's name.
 *   Stolen from `clojure.tools.macro`.
 */
taoensso.encore.name_with_attrs = (function taoensso$encore$name_with_attrs(name,macro_args){
var vec__24808 = ((typeof cljs.core.first(macro_args) === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(macro_args),cljs.core.next(macro_args)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,macro_args], null));
var docstring = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24808,(0),null);
var macro_args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24808,(1),null);
var vec__24811 = ((cljs.core.map_QMARK_(cljs.core.first(macro_args__$1)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(macro_args__$1),cljs.core.next(macro_args__$1)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY,macro_args__$1], null));
var attr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24811,(0),null);
var macro_args__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24811,(1),null);
var attr__$1 = (cljs.core.truth_(docstring)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(attr,cljs.core.cst$kw$doc,docstring):attr);
var attr__$2 = (cljs.core.truth_(cljs.core.meta(name))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.meta(name),attr__$1):attr__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(name,attr__$2),macro_args__$2], null);
});
taoensso.encore.kw_identical_QMARK_ = cljs.core.keyword_identical_QMARK_;
taoensso.encore.stringy_QMARK_ = (function taoensso$encore$stringy_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) || (typeof x === 'string');
});
taoensso.encore.atom_QMARK_ = (function taoensso$encore$atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
taoensso.encore.chan_QMARK_ = (function taoensso$encore$chan_QMARK_(x){
return (x instanceof cljs.core.async.impl.channels.ManyToManyChannel);
});
taoensso.encore.re_pattern_QMARK_ = (function taoensso$encore$re_pattern_QMARK_(x){
return (x instanceof RegExp);
});
taoensso.encore.error_QMARK_ = (function taoensso$encore$error_QMARK_(x){
return (x instanceof Error);
});
/**
 * Returns data map iff `x` is an error of any type on platform.
 */
taoensso.encore.error_data = (function taoensso$encore$error_data(x){
var temp__4657__auto__ = (function (){var or__6417__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
if((x instanceof Error)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return null;
}
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var data_map = temp__4657__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(function (){var err = x;
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$err_DASH_type,cljs.core.type(err),cljs.core.cst$kw$err_DASH_msg,err.message,cljs.core.cst$kw$err_DASH_cause,err.cause], null);
})(),data_map], 0));
} else {
return null;
}
});
taoensso.encore.nnil_QMARK_ = (function taoensso$encore$nnil_QMARK_(x){
return !((x == null));
});
taoensso.encore.nblank_QMARK_ = (function taoensso$encore$nblank_QMARK_(x){
return !(clojure.string.blank_QMARK_(x));
});
taoensso.encore.nneg_QMARK_ = (function taoensso$encore$nneg_QMARK_(x){
return !((x < (0)));
});
taoensso.encore.pos_int_QMARK_ = (function taoensso$encore$pos_int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) && ((x > (0)));
});
taoensso.encore.nneg_int_QMARK_ = (function taoensso$encore$nneg_int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) && (!((x < (0))));
});
taoensso.encore.nvec_QMARK_ = (function taoensso$encore$nvec_QMARK_(n,x){
return (cljs.core.vector_QMARK_(x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(x),n));
});
taoensso.encore.udt_QMARK_ = taoensso.encore.nneg_int_QMARK_;
taoensso.encore.vec2_QMARK_ = (function taoensso$encore$vec2_QMARK_(x){
return taoensso.encore.nvec_QMARK_((2),x);
});
taoensso.encore.vec3_QMARK_ = (function taoensso$encore$vec3_QMARK_(x){
return taoensso.encore.nvec_QMARK_((3),x);
});
taoensso.encore.distinct_elements_QMARK_ = (function taoensso$encore$distinct_elements_QMARK_(x){
return (cljs.core.set_QMARK_(x)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(x),cljs.core.count((taoensso.encore.set_STAR_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.set_STAR_.cljs$core$IFn$_invoke$arity$1(x) : taoensso.encore.set_STAR_.call(null,x)))));
});
taoensso.encore.nblank_str_QMARK_ = (function taoensso$encore$nblank_str_QMARK_(x){
return (typeof x === 'string') && (!(clojure.string.blank_QMARK_(x)));
});
taoensso.encore.nneg_num_QMARK_ = (function taoensso$encore$nneg_num_QMARK_(x){
return (typeof x === 'number') && (!((x < (0))));
});
taoensso.encore.pos_num_QMARK_ = (function taoensso$encore$pos_num_QMARK_(x){
return (typeof x === 'number') && ((x > (0)));
});
taoensso.encore.zero_num_QMARK_ = (function taoensso$encore$zero_num_QMARK_(x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),x);
});
taoensso.encore.as__QMARK_nblank = (function taoensso$encore$as__QMARK_nblank(x){
if(typeof x === 'string'){
if(clojure.string.blank_QMARK_(x)){
return null;
} else {
return x;
}
} else {
return null;
}
});
taoensso.encore.as__QMARK_kw = (function taoensso$encore$as__QMARK_kw(x){
if((x instanceof cljs.core.Keyword)){
return x;
} else {
if(typeof x === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(x);
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_name = (function taoensso$encore$as__QMARK_name(x){
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if(typeof x === 'string'){
return x;
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_bool = (function taoensso$encore$as__QMARK_bool(x){
if((x == null)){
return null;
} else {
if((x === true) || (x === false)){
return x;
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,(0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"false")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"FALSE")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"0"))){
return false;
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,(1))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"true")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"TRUE")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"1"))){
return true;
} else {
return null;
}
}
}
}
});
taoensso.encore.as__QMARK_int = (function taoensso$encore$as__QMARK_int(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return cljs.core.long$(x);
} else {
if(typeof x === 'string'){
var x__$1 = parseInt(x,(10));
if(cljs.core.truth_(isNaN(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.as__QMARK_float = (function taoensso$encore$as__QMARK_float(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return x;
} else {
if(typeof x === 'string'){
var x__$1 = parseFloat(x);
if(cljs.core.truth_(isNan(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.nnil_EQ_ = (function taoensso$encore$nnil_EQ_(var_args){
var args24816 = [];
var len__7492__auto___24822 = arguments.length;
var i__7493__auto___24823 = (0);
while(true){
if((i__7493__auto___24823 < len__7492__auto___24822)){
args24816.push((arguments[i__7493__auto___24823]));

var G__24824 = (i__7493__auto___24823 + (1));
i__7493__auto___24823 = G__24824;
continue;
} else {
}
break;
}

var G__24821 = args24816.length;
switch (G__24821) {
case 2:
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7511__auto__ = (new cljs.core.IndexedSeq(args24816.slice((2)),(0),null));
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7511__auto__);

}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var and__6405__auto__ = taoensso.encore.nnil_QMARK_(x);
if(cljs.core.truth_(and__6405__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y);
} else {
return and__6405__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
var and__6405__auto__ = taoensso.encore.nnil_QMARK_(x);
if(cljs.core.truth_(and__6405__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more);
} else {
return and__6405__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$lang$applyTo = (function (seq24817){
var G__24818 = cljs.core.first(seq24817);
var seq24817__$1 = cljs.core.next(seq24817);
var G__24819 = cljs.core.first(seq24817__$1);
var seq24817__$2 = cljs.core.next(seq24817__$1);
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__24818,G__24819,seq24817__$2);
});

taoensso.encore.nnil_EQ_.cljs$lang$maxFixedArity = (2);

taoensso.encore.vec_STAR_ = (function taoensso$encore$vec_STAR_(x){
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
return cljs.core.vec(x);
}
});
taoensso.encore.set_STAR_ = (function taoensso$encore$set_STAR_(x){
if(cljs.core.set_QMARK_(x)){
return x;
} else {
return cljs.core.set(x);
}
});
taoensso.encore.ks_EQ_ = (function taoensso$encore$ks_EQ_(ks,m){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_LT__EQ_ = (function taoensso$encore$ks_LT__EQ_(ks,m){
return clojure.set.subset_QMARK_(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_GT__EQ_ = (function taoensso$encore$ks_GT__EQ_(ks,m){
return clojure.set.superset_QMARK_(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_nnil_QMARK_ = (function taoensso$encore$ks_nnil_QMARK_(ks,m){
return cljs.core.every_QMARK_((function (p1__24826_SHARP_){
return taoensso.encore.nnil_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,p1__24826_SHARP_));
}),ks);
});
taoensso.encore.assertion_error = (function taoensso$encore$assertion_error(msg){
return (new Error(msg));
});
/**
 * Implementation detail.
 */
taoensso.encore.hthrow = (function taoensso$encore$hthrow(var_args){
var args__7499__auto__ = [];
var len__7492__auto___24837 = arguments.length;
var i__7493__auto___24838 = (0);
while(true){
if((i__7493__auto___24838 < len__7492__auto___24837)){
args__7499__auto__.push((arguments[i__7493__auto___24838]));

var G__24839 = (i__7493__auto___24838 + (1));
i__7493__auto___24838 = G__24839;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((5) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((5)),(0),null)):null);
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__7500__auto__);
});

taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic = (function (hard_QMARK_,ns_str,_QMARK_line,form,val,p__24833){
var vec__24834 = p__24833;
var _QMARK_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24834,(0),null);
var pattern = "Condition failed in `%s:%s` [pred-form, val]: [%s, %s]";
var line_str = (function (){var or__6417__auto__ = _QMARK_line;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return "?";
}
})();
var form_str = [cljs.core.str((function (){var or__6417__auto__ = form;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return "<nil>";
}
})())].join('');
var val_str = [cljs.core.str((function (){var or__6417__auto__ = val;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return "<nil>";
}
})())].join('');
var _QMARK_err_str = (function (){var temp__4657__auto__ = _QMARK_err;
if(cljs.core.truth_(temp__4657__auto__)){
var e = temp__4657__auto__;
return [cljs.core.str(_QMARK_err)].join('');
} else {
return null;
}
})();
var msg = (function (){var m = (taoensso.encore.format.cljs$core$IFn$_invoke$arity$5 ? taoensso.encore.format.cljs$core$IFn$_invoke$arity$5(pattern,ns_str,line_str,form_str,val_str) : taoensso.encore.format.call(null,pattern,ns_str,line_str,form_str,val_str));
if(cljs.core.not(_QMARK_err_str)){
return m;
} else {
return [cljs.core.str(m),cljs.core.str("\nPredicate error: "),cljs.core.str(_QMARK_err_str)].join('');
}
})();
throw ((cljs.core.not(hard_QMARK_))?taoensso.encore.assertion_error(msg):cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$ns,ns_str,cljs.core.cst$kw$_QMARK_line,_QMARK_line,cljs.core.cst$kw$form,form,cljs.core.cst$kw$val,val,cljs.core.cst$kw$_QMARK_err,_QMARK_err], null)));
});

taoensso.encore.hthrow.cljs$lang$maxFixedArity = (5);

taoensso.encore.hthrow.cljs$lang$applyTo = (function (seq24827){
var G__24828 = cljs.core.first(seq24827);
var seq24827__$1 = cljs.core.next(seq24827);
var G__24829 = cljs.core.first(seq24827__$1);
var seq24827__$2 = cljs.core.next(seq24827__$1);
var G__24830 = cljs.core.first(seq24827__$2);
var seq24827__$3 = cljs.core.next(seq24827__$2);
var G__24831 = cljs.core.first(seq24827__$3);
var seq24827__$4 = cljs.core.next(seq24827__$3);
var G__24832 = cljs.core.first(seq24827__$4);
var seq24827__$5 = cljs.core.next(seq24827__$4);
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic(G__24828,G__24829,G__24830,G__24831,G__24832,seq24827__$5);
});

taoensso.encore.non_throwing = (function taoensso$encore$non_throwing(pred){
return (function (x){
var vec__24844 = (function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(x) : pred.call(null,x))], null);
}catch (e24847){if((e24847 instanceof Error)){
var e__23961__auto__ = e24847;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__23961__auto__], null);
} else {
throw e24847;

}
}})();
var _QMARK_r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24844,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24844,(1),null);
return _QMARK_r;
});
});
/**
 * Implementation detail.
 */
taoensso.encore.hpred = (function taoensso$encore$hpred(pred_form){
if(!(cljs.core.vector_QMARK_(pred_form))){
return pred_form;
} else {
var vec__24855 = pred_form;
var seq__24856 = cljs.core.seq(vec__24855);
var first__24857 = cljs.core.first(seq__24856);
var seq__24856__$1 = cljs.core.next(seq__24856);
var type = first__24857;
var first__24857__$1 = cljs.core.first(seq__24856__$1);
var seq__24856__$2 = cljs.core.next(seq__24856__$1);
var p1 = first__24857__$1;
var first__24857__$2 = cljs.core.first(seq__24856__$2);
var seq__24856__$3 = cljs.core.next(seq__24856__$2);
var p2 = first__24857__$2;
var more = seq__24856__$3;
var G__24858 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__24858) {
case "el":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x);
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "not=":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(p1,x);
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "ks-nnil?":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return taoensso.encore.ks_nnil_QMARK_(p1,x);
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "ks<=":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return taoensso.encore.ks_LT__EQ_(p1,x);
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "or":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
var or__6417__auto__ = (cljs.core.truth_(p1)?taoensso.encore.non_throwing(taoensso$encore$hpred(p1)).call(null,x):null);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
var or__6417__auto____$1 = (cljs.core.truth_(p2)?taoensso.encore.non_throwing(taoensso$encore$hpred(p2)).call(null,x):null);
if(cljs.core.truth_(or__6417__auto____$1)){
return or__6417__auto____$1;
} else {
return cljs.core.some(((function (or__6417__auto____$1,or__6417__auto__,G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (p1__24849_SHARP_){
return taoensso.encore.non_throwing(taoensso$encore$hpred(p1__24849_SHARP_)).call(null,x);
});})(or__6417__auto____$1,or__6417__auto__,G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))
,more);
}
}
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "not":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
var and__6405__auto__ = ((cljs.core.not(p1))?true:cljs.core.not(taoensso$encore$hpred(p1).call(null,x)));
if(and__6405__auto__){
var and__6405__auto____$1 = ((cljs.core.not(p2))?true:cljs.core.not(taoensso$encore$hpred(p2).call(null,x)));
if(and__6405__auto____$1){
return cljs.core.every_QMARK_(((function (and__6405__auto____$1,and__6405__auto__,G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (p1__24848_SHARP_){
return cljs.core.not(taoensso$encore$hpred(p1__24848_SHARP_).call(null,x));
});})(and__6405__auto____$1,and__6405__auto__,G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))
,more);
} else {
return and__6405__auto____$1;
}
} else {
return and__6405__auto__;
}
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "ks=":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return taoensso.encore.ks_EQ_(p1,x);
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "and":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
var and__6405__auto__ = ((cljs.core.not(p1))?true:taoensso$encore$hpred(p1).call(null,x));
if(cljs.core.truth_(and__6405__auto__)){
var and__6405__auto____$1 = ((cljs.core.not(p2))?true:taoensso$encore$hpred(p2).call(null,x));
if(cljs.core.truth_(and__6405__auto____$1)){
return cljs.core.every_QMARK_(((function (and__6405__auto____$1,and__6405__auto__,G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (p1__24850_SHARP_){
return taoensso$encore$hpred(p1__24850_SHARP_).call(null,x);
});})(and__6405__auto____$1,and__6405__auto__,G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))
,more);
} else {
return and__6405__auto____$1;
}
} else {
return and__6405__auto__;
}
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "ks>=":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return taoensso.encore.ks_GT__EQ_(p1,x);
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "not-in":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x));
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "not-el":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x));
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "=":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1,x);
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "set<=":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return clojure.set.subset_QMARK_(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "set>=":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return clojure.set.superset_QMARK_(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "set=":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
case "in":
return ((function (G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more){
return (function (x){
return cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x);
});
;})(G__24858,vec__24855,seq__24856,first__24857,seq__24856__$1,type,first__24857__$1,seq__24856__$2,p1,first__24857__$2,seq__24856__$3,p2,more))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
}
});
/**
 * Implementation detail.
 */
taoensso.encore.hcond = (function taoensso$encore$hcond(hard_QMARK_,ns_str,line,x_,x_form,pred,pred_form){
var vec__24868 = (function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x_) : cljs.core.deref.call(null,x_))], null);
}catch (e24874){if((e24874 instanceof Error)){
var e__23961__auto__ = e24874;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__23961__auto__], null);
} else {
throw e24874;

}
}})();
var _QMARK_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24868,(0),null);
var _QMARK_x_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24868,(1),null);
var have_x_QMARK_ = (_QMARK_x_err == null);
var vec__24871 = ((have_x_QMARK_)?(function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.hpred(pred).call(null,_QMARK_x)], null);
}catch (e24875){if((e24875 instanceof Error)){
var e__23961__auto__ = e24875;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__23961__auto__], null);
} else {
throw e24875;

}
}})():null);
var pass_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24871,(0),null);
var _QMARK_pred_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24871,(1),null);
if(cljs.core.truth_(pass_QMARK_)){
return _QMARK_x;
} else {
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic(hard_QMARK_,ns_str,line,(function (){var x__7251__auto__ = pred_form;
return cljs.core._conj((function (){var x__7251__auto____$1 = x_form;
return cljs.core._conj(cljs.core.List.EMPTY,x__7251__auto____$1);
})(),x__7251__auto__);
})(),((have_x_QMARK_)?_QMARK_x:_QMARK_x_err),cljs.core.array_seq([_QMARK_pred_err], 0));
}
});
/**
 * Like `name` but fully qualified: includes namespace in string when present.
 */
taoensso.encore.fq_name = (function taoensso$encore$fq_name(x){
if(typeof x === 'string'){
return x;
} else {
var n = cljs.core.name(x);
var temp__4655__auto__ = cljs.core.namespace(x);
if(cljs.core.truth_(temp__4655__auto__)){
var ns = temp__4655__auto__;
return [cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(n)].join('');
} else {
return n;
}
}
});
taoensso.encore.explode_keyword = (function taoensso$encore$explode_keyword(k){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(taoensso.encore.fq_name(k),/[\.\/]/);
});
taoensso.encore.merge_keywords = (function taoensso$encore$merge_keywords(var_args){
var args__7499__auto__ = [];
var len__7492__auto___24882 = arguments.length;
var i__7493__auto___24883 = (0);
while(true){
if((i__7493__auto___24883 < len__7492__auto___24882)){
args__7499__auto__.push((arguments[i__7493__auto___24883]));

var G__24884 = (i__7493__auto___24883 + (1));
i__7493__auto___24883 = G__24884;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic = (function (ks,p__24878){
var vec__24879 = p__24878;
var no_slash_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24879,(0),null);
var parts = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.PersistentVector.EMPTY,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.explode_keyword,cljs.core.filterv(cljs.core.identity,ks)));
if(cljs.core.empty_QMARK_(parts)){
return null;
} else {
if(cljs.core.truth_(no_slash_QMARK_)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",parts));
} else {
var ppop = cljs.core.pop(parts);
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(((cljs.core.empty_QMARK_(ppop))?null:clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ppop)),cljs.core.peek(parts));
}
}
});

taoensso.encore.merge_keywords.cljs$lang$maxFixedArity = (1);

taoensso.encore.merge_keywords.cljs$lang$applyTo = (function (seq24876){
var G__24877 = cljs.core.first(seq24876);
var seq24876__$1 = cljs.core.next(seq24876);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic(G__24877,seq24876__$1);
});

taoensso.encore.clamp = (function taoensso$encore$clamp(nmin,nmax,n){
if((n < nmin)){
return nmin;
} else {
if((n > nmax)){
return nmax;
} else {
return n;
}
}
});
taoensso.encore.pow = (function taoensso$encore$pow(n,exp){
return Math.pow(n,exp);
});
taoensso.encore.abs = (function taoensso$encore$abs(n){
if((n < (0))){
return (- n);
} else {
return n;
}
});
taoensso.encore.round = (function taoensso$encore$round(var_args){
var args__7499__auto__ = [];
var len__7492__auto___24892 = arguments.length;
var i__7493__auto___24893 = (0);
while(true){
if((i__7493__auto___24893 < len__7492__auto___24892)){
args__7499__auto__.push((arguments[i__7493__auto___24893]));

var G__24894 = (i__7493__auto___24893 + (1));
i__7493__auto___24893 = G__24894;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__24887){
var vec__24888 = p__24887;
var type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24888,(0),null);
var nplaces = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24888,(1),null);
var n__$1 = n;
var modifier = (cljs.core.truth_(nplaces)?Math.pow(10.0,nplaces):null);
var n_STAR_ = ((cljs.core.not(modifier))?n__$1:(n__$1 * modifier));
var rounded = (function (){var G__24891 = ((((function (){var or__6417__auto__ = type;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.cst$kw$round;
}
})() instanceof cljs.core.Keyword))?(function (){var or__6417__auto__ = type;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.cst$kw$round;
}
})().fqn:null);
switch (G__24891) {
case "round":
return Math.round(n_STAR_);

break;
case "floor":
return Math.floor(n_STAR_);

break;
case "ceil":
return Math.ceil(n_STAR_);

break;
case "trunc":
return cljs.core.long$(n_STAR_);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unknown round type",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,type], null));

}
})();
if(cljs.core.not(modifier)){
return cljs.core.long$(rounded);
} else {
return (rounded / modifier);
}
});

taoensso.encore.round.cljs$lang$maxFixedArity = (1);

taoensso.encore.round.cljs$lang$applyTo = (function (seq24885){
var G__24886 = cljs.core.first(seq24885);
var seq24885__$1 = cljs.core.next(seq24885);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic(G__24886,seq24885__$1);
});

taoensso.encore.round_STAR_ = taoensso.encore.round;
/**
 * Optimized common case.
 */
taoensso.encore.round1 = (function taoensso$encore$round1(n){
return ((function (){var G__24897 = (n * 10.0);
return Math.round(G__24897);
})() / 10.0);
});
/**
 * Optimized common case.
 */
taoensso.encore.round2 = (function taoensso$encore$round2(n){
return ((function (){var G__24899 = (n * 100.0);
return Math.round(G__24899);
})() / 100.0);
});
/**
 * Returns binary exponential backoff value.
 */
taoensso.encore.exp_backoff = (function taoensso$encore$exp_backoff(var_args){
var args__7499__auto__ = [];
var len__7492__auto___24910 = arguments.length;
var i__7493__auto___24911 = (0);
while(true){
if((i__7493__auto___24911 < len__7492__auto___24910)){
args__7499__auto__.push((arguments[i__7493__auto___24911]));

var G__24912 = (i__7493__auto___24911 + (1));
i__7493__auto___24911 = G__24912;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic = (function (nattempt,p__24902){
var vec__24903 = p__24902;
var map__24906 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24903,(0),null);
var map__24906__$1 = ((((!((map__24906 == null)))?((((map__24906.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24906.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24906):map__24906);
var min_SINGLEQUOTE_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24906__$1,cljs.core.cst$kw$min);
var max_SINGLEQUOTE_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24906__$1,cljs.core.cst$kw$max);
var factor = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__24906__$1,cljs.core.cst$kw$factor,(1000));
var binary_exp = (function (){var G__24908 = (2);
var G__24909 = (nattempt - (1));
return Math.pow(G__24908,G__24909);
})();
var time = (((binary_exp + cljs.core.rand.cljs$core$IFn$_invoke$arity$1(binary_exp)) * 0.5) * factor);
return cljs.core.long$((function (){var time__$1 = (cljs.core.truth_(min_SINGLEQUOTE_)?(function (){var x__6748__auto__ = min_SINGLEQUOTE_;
var y__6749__auto__ = time;
return ((x__6748__auto__ > y__6749__auto__) ? x__6748__auto__ : y__6749__auto__);
})():time);
var time__$2 = (cljs.core.truth_(max_SINGLEQUOTE_)?(function (){var x__6755__auto__ = max_SINGLEQUOTE_;
var y__6756__auto__ = time__$1;
return ((x__6755__auto__ < y__6756__auto__) ? x__6755__auto__ : y__6756__auto__);
})():time__$1);
return time__$2;
})());
});

taoensso.encore.exp_backoff.cljs$lang$maxFixedArity = (1);

taoensso.encore.exp_backoff.cljs$lang$applyTo = (function (seq24900){
var G__24901 = cljs.core.first(seq24900);
var seq24900__$1 = cljs.core.next(seq24900);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic(G__24901,seq24900__$1);
});

taoensso.encore.now_dt = (function taoensso$encore$now_dt(){
return (new Date());
});
taoensso.encore.now_udt = (function taoensso$encore$now_udt(){
return (new Date()).getTime();
});
/**
 * Useful for testing.
 */
taoensso.encore.now_udt_mock_fn = (function taoensso$encore$now_udt_mock_fn(var_args){
var args__7499__auto__ = [];
var len__7492__auto___24918 = arguments.length;
var i__7493__auto___24919 = (0);
while(true){
if((i__7493__auto___24919 < len__7492__auto___24918)){
args__7499__auto__.push((arguments[i__7493__auto___24919]));

var G__24920 = (i__7493__auto___24919 + (1));
i__7493__auto___24919 = G__24920;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((0) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((0)),(0),null)):null);
return taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__7500__auto__);
});

taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p__24914){
var vec__24915 = p__24914;
var mock_udts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24915,(0),null);
var mock_udts__$1 = (function (){var or__6417__auto__ = mock_udts;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();
}
})();
var idx = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.atom.call(null,(-1)));
return ((function (mock_udts__$1,idx,vec__24915,mock_udts){
return (function (){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(mock_udts__$1,cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(idx,cljs.core.inc));
});
;})(mock_udts__$1,idx,vec__24915,mock_udts))
});

taoensso.encore.now_udt_mock_fn.cljs$lang$maxFixedArity = (0);

taoensso.encore.now_udt_mock_fn.cljs$lang$applyTo = (function (seq24913){
return taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24913));
});

taoensso.encore.secs__GT_ms = (function taoensso$encore$secs__GT_ms(secs){
return cljs.core.long$((secs * 1000.0));
});
taoensso.encore.ms__GT_secs = (function taoensso$encore$ms__GT_secs(ms){
return cljs.core.quot(ms,(1000));
});
/**
 * Returns number of milliseconds in period defined by given args.
 */
taoensso.encore.ms = (function taoensso$encore$ms(var_args){
var args__7499__auto__ = [];
var len__7492__auto___24926 = arguments.length;
var i__7493__auto___24927 = (0);
while(true){
if((i__7493__auto___24927 < len__7492__auto___24926)){
args__7499__auto__.push((arguments[i__7493__auto___24927]));

var G__24928 = (i__7493__auto___24927 + (1));
i__7493__auto___24927 = G__24928;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((0) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((0)),(0),null)):null);
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(argseq__7500__auto__);
});

taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic = (function (p__24922){
var map__24923 = p__24922;
var map__24923__$1 = ((((!((map__24923 == null)))?((((map__24923.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24923.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24923):map__24923);
var opts = map__24923__$1;
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24923__$1,cljs.core.cst$kw$years);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24923__$1,cljs.core.cst$kw$months);
var weeks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24923__$1,cljs.core.cst$kw$weeks);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24923__$1,cljs.core.cst$kw$days);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24923__$1,cljs.core.cst$kw$hours);
var mins = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24923__$1,cljs.core.cst$kw$mins);
var secs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24923__$1,cljs.core.cst$kw$secs);
var msecs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24923__$1,cljs.core.cst$kw$msecs);
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24923__$1,cljs.core.cst$kw$ms);
if(cljs.core.truth_(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__24923,map__24923__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (have_in__24925){
return taoensso.encore.hcond(false,"taoensso.encore",675,(new cljs.core.Delay(((function (map__24923,map__24923__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (){
return have_in__24925;
});})(map__24923,map__24923__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,null)),cljs.core.cst$sym$have_DASH_in__24925,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$kw$msecs,null,cljs.core.cst$kw$secs,null,cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$mins,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$ms,null,cljs.core.cst$kw$weeks,null], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$kw$msecs,null,cljs.core.cst$kw$secs,null,cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$mins,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$ms,null,cljs.core.cst$kw$weeks,null], null), null));
});})(map__24923,map__24923__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,cljs.core.keys(opts)))){
} else {
throw (new Error("Assert failed: (have #{:msecs :secs :months :days :mins :hours :years :ms :weeks} :in (keys opts))"));
}

return taoensso.encore.round((((((((((cljs.core.truth_(years)?(((((years * (1000)) * (60)) * (60)) * (24)) * (365)):0.0) + (cljs.core.truth_(months)?(((((months * (1000)) * (60)) * (60)) * (24)) * 29.53):0.0)) + (cljs.core.truth_(weeks)?(((((weeks * (1000)) * (60)) * (60)) * (24)) * (7)):0.0)) + (cljs.core.truth_(days)?((((days * (1000)) * (60)) * (60)) * (24)):0.0)) + (cljs.core.truth_(hours)?(((hours * (1000)) * (60)) * (60)):0.0)) + (cljs.core.truth_(mins)?((mins * (1000)) * (60)):0.0)) + (cljs.core.truth_(secs)?(secs * (1000)):0.0)) + (cljs.core.truth_(msecs)?msecs:0.0)) + (cljs.core.truth_(ms)?ms:0.0)));
});

taoensso.encore.ms.cljs$lang$maxFixedArity = (0);

taoensso.encore.ms.cljs$lang$applyTo = (function (seq24921){
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24921));
});

taoensso.encore.secs = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(taoensso.encore.ms__GT_secs,taoensso.encore.ms);
taoensso.encore.singleton_QMARK_ = (function taoensso$encore$singleton_QMARK_(coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(coll),(1));
} else {
return cljs.core.not(cljs.core.next(coll));
}
});
taoensso.encore.__GT__QMARK_singleton = (function taoensso$encore$__GT__QMARK_singleton(coll){
if(cljs.core.truth_(taoensso.encore.singleton_QMARK_(coll))){
var vec__24936 = coll;
var c1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24936,(0),null);
return c1;
} else {
return null;
}
});
taoensso.encore.__GT_vec = (function taoensso$encore$__GT_vec(x){
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
if(cljs.core.sequential_QMARK_(x)){
return cljs.core.vec(x);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);

}
}
});
taoensso.encore.vsplit_first = (function taoensso$encore$vsplit_first(v){
var vec__24942 = v;
var v1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24942,(0),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v1,(((cljs.core.count(v) > (1)))?cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(v,(1)):null)], null);
});
taoensso.encore.nnil_set = (function taoensso$encore$nnil_set(x){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(taoensso.encore.set_STAR_(x),null);
});
taoensso.encore.conj_some = (function taoensso$encore$conj_some(var_args){
var args24945 = [];
var len__7492__auto___24951 = arguments.length;
var i__7493__auto___24952 = (0);
while(true){
if((i__7493__auto___24952 < len__7492__auto___24951)){
args24945.push((arguments[i__7493__auto___24952]));

var G__24953 = (i__7493__auto___24952 + (1));
i__7493__auto___24952 = G__24953;
continue;
} else {
}
break;
}

var G__24950 = args24945.length;
switch (G__24950) {
case 2:
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7511__auto__ = (new cljs.core.IndexedSeq(args24945.slice((2)),(0),null));
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7511__auto__);

}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2 = (function (coll,_QMARK_x){
if(cljs.core.truth_(taoensso.encore.nnil_QMARK_(_QMARK_x))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,_QMARK_x);
} else {
return coll;
}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic = (function (coll,_QMARK_x,_QMARK_xs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(taoensso.encore.conj_some,taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2(coll,_QMARK_x),_QMARK_xs);
});

taoensso.encore.conj_some.cljs$lang$applyTo = (function (seq24946){
var G__24947 = cljs.core.first(seq24946);
var seq24946__$1 = cljs.core.next(seq24946);
var G__24948 = cljs.core.first(seq24946__$1);
var seq24946__$2 = cljs.core.next(seq24946__$1);
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic(G__24947,G__24948,seq24946__$2);
});

taoensso.encore.conj_some.cljs$lang$maxFixedArity = (2);

/**
 * `run!` from Clojure 1.7+
 */
taoensso.encore.backport_run_BANG_ = (function taoensso$encore$backport_run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__24956_SHARP_,p2__24955_SHARP_){
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(p2__24955_SHARP_) : proc.call(null,p2__24955_SHARP_));
}),null,coll);
});
taoensso.encore.translate_signed_idx = (function taoensso$encore$translate_signed_idx(signed_idx,max_idx){
if((signed_idx >= (0))){
var x__6755__auto__ = signed_idx;
var y__6756__auto__ = max_idx;
return ((x__6755__auto__ < y__6756__auto__) ? x__6755__auto__ : y__6756__auto__);
} else {
var x__6748__auto__ = (0);
var y__6749__auto__ = (signed_idx + max_idx);
return ((x__6748__auto__ > y__6749__auto__) ? x__6748__auto__ : y__6749__auto__);
}
});
/**
 * Returns [<inclusive-start-idx*> <exclusive-end-idx*>] for counted 0-indexed
 *   input (str, vec, etc.) with support for:
 *  * Clamping of indexes beyond limits.
 *  * Max-length -> end-index.
 *  * -ive indexes (as +ive indexes but work from back of input):
 *    (+0) (+1) (+2) (+3) (+4)  ; inclusive +ive indexes
 *      h    e    l    l    o   ; 5 count
 *    (-5) (-4) (-3) (-2) (-1)  ; inclusive -ive indexes
 */
taoensso.encore.sub_indexes = (function taoensso$encore$sub_indexes(var_args){
var args__7499__auto__ = [];
var len__7492__auto___24963 = arguments.length;
var i__7493__auto___24964 = (0);
while(true){
if((i__7493__auto___24964 < len__7492__auto___24963)){
args__7499__auto__.push((arguments[i__7493__auto___24964]));

var G__24965 = (i__7493__auto___24964 + (1));
i__7493__auto___24964 = G__24965;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((2) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((2)),(0),null)):null);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7500__auto__);
});

taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic = (function (x,start_idx,p__24960){
var map__24961 = p__24960;
var map__24961__$1 = ((((!((map__24961 == null)))?((((map__24961.cljs$lang$protocol_mask$partition0$ & (64))) || (map__24961.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24961):map__24961);
var max_len = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24961__$1,cljs.core.cst$kw$max_DASH_len);
var end_idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24961__$1,cljs.core.cst$kw$end_DASH_idx);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (map__24961,map__24961__$1,max_len,end_idx){
return (function (){
return max_len;
});})(map__24961,map__24961__$1,max_len,end_idx))
,null)),cljs.core.cst$sym$max_DASH_len,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$nneg_DASH_int_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? nneg-int?] max-len)"));
}

var start_idx__$1 = start_idx;
var xlen = cljs.core.count(x);
var start_idx_STAR_ = taoensso.encore.translate_signed_idx(start_idx__$1,xlen);
var end_idx_STAR_ = (cljs.core.truth_(max_len)?(function (){var n1__24138__auto__ = (start_idx_STAR_ + max_len);
var n2__24139__auto__ = xlen;
if((n1__24138__auto__ > n2__24139__auto__)){
return n2__24139__auto__;
} else {
return n1__24138__auto__;
}
})():(cljs.core.truth_(end_idx)?(taoensso.encore.translate_signed_idx(end_idx,xlen) + (1)):xlen
));
if((start_idx_STAR_ > end_idx_STAR_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_idx_STAR_,end_idx_STAR_], null);
}
});

taoensso.encore.sub_indexes.cljs$lang$maxFixedArity = (2);

taoensso.encore.sub_indexes.cljs$lang$applyTo = (function (seq24957){
var G__24958 = cljs.core.first(seq24957);
var seq24957__$1 = cljs.core.next(seq24957);
var G__24959 = cljs.core.first(seq24957__$1);
var seq24957__$2 = cljs.core.next(seq24957__$1);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(G__24958,G__24959,seq24957__$2);
});

/**
 * Like `subvec` but uses `sub-indexes`.
 */
taoensso.encore.subvec_STAR_ = (function taoensso$encore$subvec_STAR_(var_args){
var args__7499__auto__ = [];
var len__7492__auto___24976 = arguments.length;
var i__7493__auto___24977 = (0);
while(true){
if((i__7493__auto___24977 < len__7492__auto___24976)){
args__7499__auto__.push((arguments[i__7493__auto___24977]));

var G__24978 = (i__7493__auto___24977 + (1));
i__7493__auto___24977 = G__24978;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((2) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((2)),(0),null)):null);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7500__auto__);
});

taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (v,start_idx,p__24969){
var vec__24970 = p__24969;
var _QMARK_max_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24970,(0),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__24970,_QMARK_max_len){
return (function (){
return v;
});})(vec__24970,_QMARK_max_len))
,null)),cljs.core.cst$sym$v,cljs.core.vector_QMARK_,cljs.core.cst$sym$vector_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? vector? v)"));
}

var vec__24973 = taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(v,start_idx,cljs.core.array_seq([cljs.core.cst$kw$max_DASH_len,_QMARK_max_len], 0));
var start_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24973,(0),null);
var end_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24973,(1),null);
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.subvec_STAR_.cljs$lang$maxFixedArity = (2);

taoensso.encore.subvec_STAR_.cljs$lang$applyTo = (function (seq24966){
var G__24967 = cljs.core.first(seq24966);
var seq24966__$1 = cljs.core.next(seq24966);
var G__24968 = cljs.core.first(seq24966__$1);
var seq24966__$2 = cljs.core.next(seq24966__$1);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__24967,G__24968,seq24966__$2);
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.encore.Swapped = (function (new_val,return_val,__meta,__extmap,__hash){
this.new_val = new_val;
this.return_val = return_val;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7039__auto__,k__7040__auto__){
var self__ = this;
var this__7039__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7039__auto____$1,k__7040__auto__,null);
});

taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7041__auto__,k24980,else__7042__auto__){
var self__ = this;
var this__7041__auto____$1 = this;
var G__24982 = (((k24980 instanceof cljs.core.Keyword))?k24980.fqn:null);
switch (G__24982) {
case "new-val":
return self__.new_val;

break;
case "return-val":
return self__.return_val;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k24980,else__7042__auto__);

}
});

taoensso.encore.Swapped.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7053__auto__,writer__7054__auto__,opts__7055__auto__){
var self__ = this;
var this__7053__auto____$1 = this;
var pr_pair__7056__auto__ = ((function (this__7053__auto____$1){
return (function (keyval__7057__auto__){
return cljs.core.pr_sequential_writer(writer__7054__auto__,cljs.core.pr_writer,""," ","",opts__7055__auto__,keyval__7057__auto__);
});})(this__7053__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7054__auto__,pr_pair__7056__auto__,"#taoensso.encore.Swapped{",", ","}",opts__7055__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$new_DASH_val,self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$return_DASH_val,self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IIterable$ = true;

taoensso.encore.Swapped.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__24979){
var self__ = this;
var G__24979__$1 = this;
return (new cljs.core.RecordIter((0),G__24979__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_val,cljs.core.cst$kw$return_DASH_val], null),cljs.core._iterator(self__.__extmap)));
});

taoensso.encore.Swapped.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7037__auto__){
var self__ = this;
var this__7037__auto____$1 = this;
return self__.__meta;
});

taoensso.encore.Swapped.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7033__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7034__auto__){
var self__ = this;
var this__7034__auto____$1 = this;
var h__6852__auto__ = self__.__hash;
if(!((h__6852__auto__ == null))){
return h__6852__auto__;
} else {
var h__6852__auto____$1 = cljs.core.hash_imap(this__7034__auto____$1);
self__.__hash = h__6852__auto____$1;

return h__6852__auto____$1;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7035__auto__,other__7036__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6405__auto__ = other__7036__auto__;
if(cljs.core.truth_(and__6405__auto__)){
var and__6405__auto____$1 = (this__7035__auto____$1.constructor === other__7036__auto__.constructor);
if(and__6405__auto____$1){
return cljs.core.equiv_map(this__7035__auto____$1,other__7036__auto__);
} else {
return and__6405__auto____$1;
}
} else {
return and__6405__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7048__auto__,k__7049__auto__){
var self__ = this;
var this__7048__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$return_DASH_val,null,cljs.core.cst$kw$new_DASH_val,null], null), null),k__7049__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7048__auto____$1),self__.__meta),k__7049__auto__);
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7049__auto__)),null));
}
});

taoensso.encore.Swapped.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7046__auto__,k__7047__auto__,G__24979){
var self__ = this;
var this__7046__auto____$1 = this;
var pred__24983 = cljs.core.keyword_identical_QMARK_;
var expr__24984 = k__7047__auto__;
if(cljs.core.truth_((function (){var G__24986 = cljs.core.cst$kw$new_DASH_val;
var G__24987 = expr__24984;
return (pred__24983.cljs$core$IFn$_invoke$arity$2 ? pred__24983.cljs$core$IFn$_invoke$arity$2(G__24986,G__24987) : pred__24983.call(null,G__24986,G__24987));
})())){
return (new taoensso.encore.Swapped(G__24979,self__.return_val,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__24988 = cljs.core.cst$kw$return_DASH_val;
var G__24989 = expr__24984;
return (pred__24983.cljs$core$IFn$_invoke$arity$2 ? pred__24983.cljs$core$IFn$_invoke$arity$2(G__24988,G__24989) : pred__24983.call(null,G__24988,G__24989));
})())){
return (new taoensso.encore.Swapped(self__.new_val,G__24979,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7047__auto__,G__24979),null));
}
}
});

taoensso.encore.Swapped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7051__auto__){
var self__ = this;
var this__7051__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$new_DASH_val,self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$return_DASH_val,self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7038__auto__,G__24979){
var self__ = this;
var this__7038__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,G__24979,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7044__auto__,entry__7045__auto__){
var self__ = this;
var this__7044__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7045__auto__)){
return cljs.core._assoc(this__7044__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7045__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7045__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7044__auto____$1,entry__7045__auto__);
}
});

taoensso.encore.Swapped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$new_DASH_val,cljs.core.cst$sym$return_DASH_val], null);
});

taoensso.encore.Swapped.cljs$lang$type = true;

taoensso.encore.Swapped.cljs$lang$ctorPrSeq = (function (this__7073__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"taoensso.encore/Swapped");
});

taoensso.encore.Swapped.cljs$lang$ctorPrWriter = (function (this__7073__auto__,writer__7074__auto__){
return cljs.core._write(writer__7074__auto__,"taoensso.encore/Swapped");
});

taoensso.encore.__GT_Swapped = (function taoensso$encore$__GT_Swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});

taoensso.encore.map__GT_Swapped = (function taoensso$encore$map__GT_Swapped(G__24981){
return (new taoensso.encore.Swapped(cljs.core.cst$kw$new_DASH_val.cljs$core$IFn$_invoke$arity$1(G__24981),cljs.core.cst$kw$return_DASH_val.cljs$core$IFn$_invoke$arity$1(G__24981),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__24981,cljs.core.cst$kw$new_DASH_val,cljs.core.array_seq([cljs.core.cst$kw$return_DASH_val], 0)),null));
});

taoensso.encore.swapped = (function taoensso$encore$swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});
taoensso.encore.swapped_QMARK_ = (function taoensso$encore$swapped_QMARK_(x){
return (x instanceof taoensso.encore.Swapped);
});
taoensso.encore.swapped_STAR_ = (function taoensso$encore$swapped_STAR_(x){
if(cljs.core.truth_(taoensso.encore.swapped_QMARK_(x))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_val.cljs$core$IFn$_invoke$arity$1(x),cljs.core.cst$kw$return_DASH_val.cljs$core$IFn$_invoke$arity$1(x)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,x], null);
}
});
/**
 * [<new-val> <return-val>]
 */
taoensso.encore.swapped_STAR__in = (function taoensso$encore$swapped_STAR__in(m,ks,f){
if(cljs.core.truth_((function (){var G__25004 = f;
var G__25005 = cljs.core.cst$kw$swap_SLASH_dissoc;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25004,G__25005) : taoensso.encore.kw_identical_QMARK_.call(null,G__25004,G__25005));
})())){
return taoensso.encore.swapped_STAR_((function (){var G__25006 = m;
var G__25007 = cljs.core.butlast(ks);
var G__25008 = cljs.core.last(ks);
return (taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3(G__25006,G__25007,G__25008) : taoensso.encore.dissoc_in.call(null,G__25006,G__25007,G__25008));
})());
} else {
var old_val_in = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(m,ks);
var vec__25009 = taoensso.encore.swapped_STAR_((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_val_in) : f.call(null,old_val_in)));
var new_val_in = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25009,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25009,(1),null);
var new_val = (cljs.core.truth_((function (){var G__25012 = new_val_in;
var G__25013 = cljs.core.cst$kw$swap_SLASH_dissoc;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25012,G__25013) : taoensso.encore.kw_identical_QMARK_.call(null,G__25012,G__25013));
})())?(function (){var G__25014 = m;
var G__25015 = cljs.core.butlast(ks);
var G__25016 = cljs.core.last(ks);
return (taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3(G__25014,G__25015,G__25016) : taoensso.encore.dissoc_in.call(null,G__25014,G__25015,G__25016));
})():cljs.core.assoc_in(m,ks,new_val_in));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_val,return_val], null);
}
});
/**
 * Reduces input with
 *   [<type> <ks> <reset-val-or-swap-fn>] or
 *       [<ks> <reset-val-or-swap-fn>] ops.
 */
taoensso.encore.replace_in_STAR_ = (function taoensso$encore$replace_in_STAR_(_QMARK_vf_type,m,ops){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (accum,_QMARK_op){
if(cljs.core.not(_QMARK_op)){
return accum;
} else {
var vec__25021 = ((cljs.core.not(_QMARK_vf_type))?_QMARK_op:cljs.core.cons(_QMARK_vf_type,_QMARK_op));
var vf_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25021,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25021,(1),null);
var valf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25021,(2),null);
var G__25024 = (((vf_type instanceof cljs.core.Keyword))?vf_type.fqn:null);
switch (G__25024) {
case "reset":
if(cljs.core.empty_QMARK_(ks)){
return valf;
} else {
return cljs.core.assoc_in(accum,ks,valf);
}

break;
case "swap":
if(cljs.core.empty_QMARK_(ks)){
return (valf.cljs$core$IFn$_invoke$arity$1 ? valf.cljs$core$IFn$_invoke$arity$1(accum) : valf.call(null,accum));
} else {
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(taoensso.encore.swapped_STAR__in(accum,ks,valf),(0));
}

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(vf_type)].join('')));

}
}
}),m,ops);
});
/**
 * Experimental. For use with `swap!`, etc.
 */
taoensso.encore.replace_in = (function taoensso$encore$replace_in(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25028 = arguments.length;
var i__7493__auto___25029 = (0);
while(true){
if((i__7493__auto___25029 < len__7492__auto___25028)){
args__7499__auto__.push((arguments[i__7493__auto___25029]));

var G__25030 = (i__7493__auto___25029 + (1));
i__7493__auto___25029 = G__25030;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ops){
return taoensso.encore.replace_in_STAR_(null,m,ops);
});

taoensso.encore.replace_in.cljs$lang$maxFixedArity = (1);

taoensso.encore.replace_in.cljs$lang$applyTo = (function (seq25026){
var G__25027 = cljs.core.first(seq25026);
var seq25026__$1 = cljs.core.next(seq25026);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic(G__25027,seq25026__$1);
});

/**
 * More powerful version of `swap!`:
 *  * Supports optional `update-in` semantics.
 *  * Swap fn can return `(swapped <new-val> <return-val>)` rather than just
 *    <new-val>. This is useful when writing atomic pull fns, etc.
 */
taoensso.encore.swap_in_BANG_ = (function taoensso$encore$swap_in_BANG_(var_args){
var args25031 = [];
var len__7492__auto___25044 = arguments.length;
var i__7493__auto___25045 = (0);
while(true){
if((i__7493__auto___25045 < len__7492__auto___25044)){
args25031.push((arguments[i__7493__auto___25045]));

var G__25046 = (i__7493__auto___25045 + (1));
i__7493__auto___25045 = G__25046;
continue;
} else {
}
break;
}

var G__25037 = args25031.length;
switch (G__25037) {
case 3:
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7511__auto__ = (new cljs.core.IndexedSeq(args25031.slice((3)),(0),null));
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7511__auto__);

}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,f){
if(cljs.core.empty_QMARK_(ks)){
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var vec__25038 = taoensso.encore.swapped_STAR_((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_val) : f.call(null,old_val)));
var new_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25038,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25038,(1),null);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
} else {
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var vec__25041 = taoensso.encore.swapped_STAR__in(old_val,ks,f);
var new_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25041,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25041,(1),null);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,f,more){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(more);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$more),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count more))"));
}

var pairs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,f], null)], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),more));
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_val = taoensso.encore.replace_in_STAR_(cljs.core.cst$kw$swap,old_val,pairs);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old_val,cljs.core.cst$kw$new,new_val], null);
}
break;
}
});

taoensso.encore.swap_in_BANG_.cljs$lang$applyTo = (function (seq25032){
var G__25033 = cljs.core.first(seq25032);
var seq25032__$1 = cljs.core.next(seq25032);
var G__25034 = cljs.core.first(seq25032__$1);
var seq25032__$2 = cljs.core.next(seq25032__$1);
var G__25035 = cljs.core.first(seq25032__$2);
var seq25032__$3 = cljs.core.next(seq25032__$2);
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25033,G__25034,G__25035,seq25032__$3);
});

taoensso.encore.swap_in_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Is to `reset!` as `swap-in!` is to `swap!`.
 */
taoensso.encore.reset_in_BANG_ = (function taoensso$encore$reset_in_BANG_(var_args){
var args25048 = [];
var len__7492__auto___25055 = arguments.length;
var i__7493__auto___25056 = (0);
while(true){
if((i__7493__auto___25056 < len__7492__auto___25055)){
args25048.push((arguments[i__7493__auto___25056]));

var G__25057 = (i__7493__auto___25056 + (1));
i__7493__auto___25056 = G__25057;
continue;
} else {
}
break;
}

var G__25054 = args25048.length;
switch (G__25054) {
case 3:
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7511__auto__ = (new cljs.core.IndexedSeq(args25048.slice((3)),(0),null));
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7511__auto__);

}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,new_val){
if(cljs.core.empty_QMARK_(ks)){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(atom_,new_val) : cljs.core.reset_BANG_.call(null,atom_,new_val));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atom_,(function (old_val){
return cljs.core.assoc_in(old_val,ks,new_val);
}));
}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,new_val,more){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(more);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$more),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count more))"));
}

var pairs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,new_val], null)], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),more));
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_val__$1 = taoensso.encore.replace_in_STAR_(cljs.core.cst$kw$reset,old_val,pairs);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val__$1))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old_val,cljs.core.cst$kw$new,new_val__$1], null);
}
break;
}
});

taoensso.encore.reset_in_BANG_.cljs$lang$applyTo = (function (seq25049){
var G__25050 = cljs.core.first(seq25049);
var seq25049__$1 = cljs.core.next(seq25049);
var G__25051 = cljs.core.first(seq25049__$1);
var seq25049__$2 = cljs.core.next(seq25049__$1);
var G__25052 = cljs.core.first(seq25049__$2);
var seq25049__$3 = cljs.core.next(seq25049__$2);
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25050,G__25051,G__25052,seq25049__$3);
});

taoensso.encore.reset_in_BANG_.cljs$lang$maxFixedArity = (3);

taoensso.encore.dissoc_in = (function taoensso$encore$dissoc_in(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25062 = arguments.length;
var i__7493__auto___25063 = (0);
while(true){
if((i__7493__auto___25063 < len__7492__auto___25062)){
args__7499__auto__.push((arguments[i__7493__auto___25063]));

var G__25064 = (i__7493__auto___25063 + (1));
i__7493__auto___25063 = G__25064;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((2) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((2)),(0),null)):null);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7500__auto__);
});

taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ks,dissoc_ks){
if(cljs.core.empty_QMARK_(ks)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,m,dissoc_ks);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(cljs.core.update_in,m,ks,cljs.core.dissoc,dissoc_ks);
}
});

taoensso.encore.dissoc_in.cljs$lang$maxFixedArity = (2);

taoensso.encore.dissoc_in.cljs$lang$applyTo = (function (seq25059){
var G__25060 = cljs.core.first(seq25059);
var seq25059__$1 = cljs.core.next(seq25059);
var G__25061 = cljs.core.first(seq25059__$1);
var seq25059__$2 = cljs.core.next(seq25059__$1);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic(G__25060,G__25061,seq25059__$2);
});

taoensso.encore.contains_in_QMARK_ = (function taoensso$encore$contains_in_QMARK_(coll,ks){
return cljs.core.contains_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.butlast(ks)),cljs.core.last(ks));
});
/**
 * Assocs each kv iff its value is not nil.
 */
taoensso.encore.assoc_some = (function taoensso$encore$assoc_some(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25085 = arguments.length;
var i__7493__auto___25086 = (0);
while(true){
if((i__7493__auto___25086 < len__7492__auto___25085)){
args__7499__auto__.push((arguments[i__7493__auto___25086]));

var G__25087 = (i__7493__auto___25086 + (1));
i__7493__auto___25086 = G__25087;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(kvs);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$kvs),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count kvs))"));
}

return cljs.core.into.cljs$core$IFn$_invoke$arity$2((function (){var or__6417__auto__ = m;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__7197__auto__ = (function taoensso$encore$iter__25067(s__25068){
return (new cljs.core.LazySeq(null,(function (){
var s__25068__$1 = s__25068;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__25068__$1);
if(temp__4657__auto__){
var s__25068__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25068__$2)){
var c__7195__auto__ = cljs.core.chunk_first(s__25068__$2);
var size__7196__auto__ = cljs.core.count(c__7195__auto__);
var b__25070 = cljs.core.chunk_buffer(size__7196__auto__);
if((function (){var i__25069 = (0);
while(true){
if((i__25069 < size__7196__auto__)){
var vec__25079 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7195__auto__,i__25069);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25079,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25079,(1),null);
if(!((v == null))){
cljs.core.chunk_append(b__25070,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__25088 = (i__25069 + (1));
i__25069 = G__25088;
continue;
} else {
var G__25089 = (i__25069 + (1));
i__25069 = G__25089;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25070),taoensso$encore$iter__25067(cljs.core.chunk_rest(s__25068__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25070),null);
}
} else {
var vec__25082 = cljs.core.first(s__25068__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25082,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25082,(1),null);
if(!((v == null))){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__25067(cljs.core.rest(s__25068__$2)));
} else {
var G__25090 = cljs.core.rest(s__25068__$2);
s__25068__$1 = G__25090;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7197__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
})());
});

taoensso.encore.assoc_some.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_some.cljs$lang$applyTo = (function (seq25065){
var G__25066 = cljs.core.first(seq25065);
var seq25065__$1 = cljs.core.next(seq25065);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic(G__25066,seq25065__$1);
});

/**
 * Assocs each kv iff its val is truthy.
 */
taoensso.encore.assoc_when = (function taoensso$encore$assoc_when(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25111 = arguments.length;
var i__7493__auto___25112 = (0);
while(true){
if((i__7493__auto___25112 < len__7492__auto___25111)){
args__7499__auto__.push((arguments[i__7493__auto___25112]));

var G__25113 = (i__7493__auto___25112 + (1));
i__7493__auto___25112 = G__25113;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(kvs);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$kvs),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count kvs))"));
}

return cljs.core.into.cljs$core$IFn$_invoke$arity$2((function (){var or__6417__auto__ = m;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__7197__auto__ = (function taoensso$encore$iter__25093(s__25094){
return (new cljs.core.LazySeq(null,(function (){
var s__25094__$1 = s__25094;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__25094__$1);
if(temp__4657__auto__){
var s__25094__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25094__$2)){
var c__7195__auto__ = cljs.core.chunk_first(s__25094__$2);
var size__7196__auto__ = cljs.core.count(c__7195__auto__);
var b__25096 = cljs.core.chunk_buffer(size__7196__auto__);
if((function (){var i__25095 = (0);
while(true){
if((i__25095 < size__7196__auto__)){
var vec__25105 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7195__auto__,i__25095);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25105,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25105,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append(b__25096,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__25114 = (i__25095 + (1));
i__25095 = G__25114;
continue;
} else {
var G__25115 = (i__25095 + (1));
i__25095 = G__25115;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25096),taoensso$encore$iter__25093(cljs.core.chunk_rest(s__25094__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25096),null);
}
} else {
var vec__25108 = cljs.core.first(s__25094__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25108,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25108,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__25093(cljs.core.rest(s__25094__$2)));
} else {
var G__25116 = cljs.core.rest(s__25094__$2);
s__25094__$1 = G__25116;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7197__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
})());
});

taoensso.encore.assoc_when.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_when.cljs$lang$applyTo = (function (seq25091){
var G__25092 = cljs.core.first(seq25091);
var seq25091__$1 = cljs.core.next(seq25091);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__25092,seq25091__$1);
});

taoensso.encore.queue_QMARK_ = (function taoensso$encore$queue_QMARK_(x){
return (x instanceof cljs.core.PersistentQueue);
});
/**
 * Returns a PersistentQueue.
 */
taoensso.encore.queue = (function taoensso$encore$queue(var_args){
var args25117 = [];
var len__7492__auto___25120 = arguments.length;
var i__7493__auto___25121 = (0);
while(true){
if((i__7493__auto___25121 < len__7492__auto___25120)){
args25117.push((arguments[i__7493__auto___25121]));

var G__25122 = (i__7493__auto___25121 + (1));
i__7493__auto___25121 = G__25122;
continue;
} else {
}
break;
}

var G__25119 = args25117.length;
switch (G__25119) {
case 0:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25117.length)].join('')));

}
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentQueue.EMPTY;
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0(),coll);
});

taoensso.encore.queue.cljs$lang$maxFixedArity = 1;

taoensso.encore.queue_STAR_ = (function taoensso$encore$queue_STAR_(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25125 = arguments.length;
var i__7493__auto___25126 = (0);
while(true){
if((i__7493__auto___25126 < len__7492__auto___25125)){
args__7499__auto__.push((arguments[i__7493__auto___25126]));

var G__25127 = (i__7493__auto___25126 + (1));
i__7493__auto___25126 = G__25127;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((0) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((0)),(0),null)):null);
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__7500__auto__);
});

taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (items){
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1(items);
});

taoensso.encore.queue_STAR_.cljs$lang$maxFixedArity = (0);

taoensso.encore.queue_STAR_.cljs$lang$applyTo = (function (seq25124){
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25124));
});

/**
 * (seq     {:a :A}) => ([:a :A])
 * (seq-kvs {:a :A}) => (:a :A)
 */
taoensso.encore.seq_kvs = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.concat);
/**
 * Like `apply` but assumes last arg is a map whose elements should be applied
 *   to `f` as an unpaired seq:
 *  (mapply (fn [x & {:keys [y z]}] (str x y z)) 1 {:y 2 :z 3})
 *    where fn will receive args as: `(1 :y 2 :z 3)`.
 */
taoensso.encore.mapply = (function taoensso$encore$mapply(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25131 = arguments.length;
var i__7493__auto___25132 = (0);
while(true){
if((i__7493__auto___25132 < len__7492__auto___25131)){
args__7499__auto__.push((arguments[i__7493__auto___25132]));

var G__25133 = (i__7493__auto___25132 + (1));
i__7493__auto___25132 = G__25133;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(args),(function (){var G__25130 = cljs.core.last(args);
return (taoensso.encore.seq_kvs.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.seq_kvs.cljs$core$IFn$_invoke$arity$1(G__25130) : taoensso.encore.seq_kvs.call(null,G__25130));
})()));
});

taoensso.encore.mapply.cljs$lang$maxFixedArity = (1);

taoensso.encore.mapply.cljs$lang$applyTo = (function (seq25128){
var G__25129 = cljs.core.first(seq25128);
var seq25128__$1 = cljs.core.next(seq25128);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic(G__25129,seq25128__$1);
});

/**
 * Workaround for Clojure versions [1.4, 1.5) that blow up on `reduce-kv`s
 *   against a nil coll, Ref. http://dev.clojure.org/jira/browse/CLJ-1098.
 */
taoensso.encore.clj1098 = (function taoensso$encore$clj1098(x){
var or__6417__auto__ = x;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
taoensso.encore.map_kvs = (function taoensso$encore$map_kvs(kf,vf,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var kf__$1 = ((cljs.core.not((function (){var G__25138 = kf;
var G__25139 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25138,G__25139) : taoensso.encore.kw_identical_QMARK_.call(null,G__25138,G__25139));
})()))?kf:(function (k,_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k);
}));
var vf__$1 = ((cljs.core.not((function (){var G__25140 = vf;
var G__25141 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25140,G__25141) : taoensso.encore.kw_identical_QMARK_.call(null,G__25140,G__25141));
})()))?vf:((function (kf__$1){
return (function (_,v){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(v);
});})(kf__$1))
);
return cljs.core.persistent_BANG_(cljs.core.reduce_kv(((function (kf__$1,vf__$1){
return (function (m__$1,k,v){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,(cljs.core.truth_(kf__$1)?(kf__$1.cljs$core$IFn$_invoke$arity$2 ? kf__$1.cljs$core$IFn$_invoke$arity$2(k,v) : kf__$1.call(null,k,v)):k),(cljs.core.truth_(vf__$1)?(vf__$1.cljs$core$IFn$_invoke$arity$2 ? vf__$1.cljs$core$IFn$_invoke$arity$2(k,v) : vf__$1.call(null,k,v)):v));
});})(kf__$1,vf__$1))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),m));
}
});
taoensso.encore.map_keys = (function taoensso$encore$map_keys(f,m){
return taoensso.encore.map_kvs((function (k,_){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(k) : f.call(null,k));
}),null,m);
});
taoensso.encore.map_vals = (function taoensso$encore$map_vals(f,m){
return taoensso.encore.map_kvs(null,(function (_,v){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(v) : f.call(null,v));
}),m);
});
taoensso.encore.filter_kvs = (function taoensso$encore$filter_kvs(predk,predv,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((function (){var and__6405__auto__ = (predk.cljs$core$IFn$_invoke$arity$1 ? predk.cljs$core$IFn$_invoke$arity$1(k) : predk.call(null,k));
if(cljs.core.truth_(and__6405__auto__)){
return (predv.cljs$core$IFn$_invoke$arity$1 ? predv.cljs$core$IFn$_invoke$arity$1(v) : predv.call(null,v));
} else {
return and__6405__auto__;
}
})())){
return m__$1;
} else {
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m__$1,k);
}
}),m,m);
}
});
taoensso.encore.filter_keys = (function taoensso$encore$filter_keys(pred,m){
return taoensso.encore.filter_kvs(pred,cljs.core.constantly(true),m);
});
taoensso.encore.filter_vals = (function taoensso$encore$filter_vals(pred,m){
return taoensso.encore.filter_kvs(cljs.core.constantly(true),pred,m);
});
/**
 * Smaller, common-case version of `filter-vals`. Esp useful with `nil?`/`blank?`
 *   pred when constructing maps: {:foo (when _ <...>) :bar (when _ <...>)} in a
 *   way that preservers :or semantics.
 */
taoensso.encore.remove_vals = (function taoensso$encore$remove_vals(pred,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(v) : pred.call(null,v)))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m__$1,k);
} else {
return m__$1;
}
}),m,m);
}
});
taoensso.encore.keywordize_map = (function taoensso$encore$keywordize_map(m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),v);
}),cljs.core.PersistentArrayMap.EMPTY,m);
}
});
/**
 * Cross between `hash-map` & `map-kvs`.
 */
taoensso.encore.as_map = (function taoensso$encore$as_map(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25160 = arguments.length;
var i__7493__auto___25161 = (0);
while(true){
if((i__7493__auto___25161 < len__7492__auto___25160)){
args__7499__auto__.push((arguments[i__7493__auto___25161]));

var G__25162 = (i__7493__auto___25161 + (1));
i__7493__auto___25161 = G__25162;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic = (function (kvs,p__25144){
var vec__25145 = p__25144;
var kf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25145,(0),null);
var vf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25145,(1),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__25145,kf,vf){
return (function (){
return kvs;
});})(vec__25145,kf,vf))
,null)),cljs.core.cst$sym$kvs,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.sequential_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$sequential_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? sequential?] kvs)"));
}

if((function (){
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__25145,kf,vf){
return (function (){
return kf;
});})(vec__25145,kf,vf))
,null)),cljs.core.cst$sym$kf,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.ifn_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$ifn_QMARK_], null)),taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__25145,kf,vf){
return (function (){
return vf;
});})(vec__25145,kf,vf))
,null)),cljs.core.cst$sym$vf,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.ifn_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$ifn_QMARK_], null))], null);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? ifn?] kf vf)"));
}

var _PERCENT_ = ((cljs.core.empty_QMARK_(kvs))?cljs.core.PersistentArrayMap.EMPTY:(function (){var kf__$1 = ((cljs.core.not((function (){var G__25148 = kf;
var G__25149 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25148,G__25149) : taoensso.encore.kw_identical_QMARK_.call(null,G__25148,G__25149));
})()))?kf:((function (vec__25145,kf,vf){
return (function (k,_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k);
});})(vec__25145,kf,vf))
);
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var G__25153 = kvs;
var vec__25154 = G__25153;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25154,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25154,(1),null);
var s = vec__25154;
var m__$1 = m;
var G__25153__$1 = G__25153;
while(true){
var m__$2 = m__$1;
var vec__25157 = G__25153__$1;
var k__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25157,(0),null);
var v__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25157,(1),null);
var s__$1 = vec__25157;
var k__$2 = ((cljs.core.not(kf__$1))?k__$1:(kf__$1.cljs$core$IFn$_invoke$arity$2 ? kf__$1.cljs$core$IFn$_invoke$arity$2(k__$1,v__$1) : kf__$1.call(null,k__$1,v__$1)));
var v__$2 = ((cljs.core.not(vf))?v__$1:(vf.cljs$core$IFn$_invoke$arity$2 ? vf.cljs$core$IFn$_invoke$arity$2(k__$2,v__$1) : vf.call(null,k__$2,v__$1)));
var new_m = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$2,k__$2,v__$2);
var temp__4655__auto__ = cljs.core.nnext(s__$1);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
var G__25163 = new_m;
var G__25164 = n;
m__$1 = G__25163;
G__25153__$1 = G__25164;
continue;
} else {
return cljs.core.persistent_BANG_(new_m);
}
break;
}
})());
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (_PERCENT_,vec__25145,kf,vf){
return (function (){
return _PERCENT_;
});})(_PERCENT_,vec__25145,kf,vf))
,null)),cljs.core.cst$sym$_PERCENT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$map_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? map?] %)"));
}

return _PERCENT_;
});

taoensso.encore.as_map.cljs$lang$maxFixedArity = (1);

taoensso.encore.as_map.cljs$lang$applyTo = (function (seq25142){
var G__25143 = cljs.core.first(seq25142);
var seq25142__$1 = cljs.core.next(seq25142);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic(G__25143,seq25142__$1);
});

/**
 * Faster `zipmap` using transients.
 */
taoensso.encore.fzipmap = (function taoensso$encore$fzipmap(ks,vs){
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks__$1 = cljs.core.seq(ks);
var vs__$1 = cljs.core.seq(vs);
while(true){
if(!((ks__$1) && (vs__$1))){
return cljs.core.persistent_BANG_(m);
} else {
var G__25165 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,cljs.core.first(ks__$1),cljs.core.first(vs__$1));
var G__25166 = cljs.core.next(ks__$1);
var G__25167 = cljs.core.next(vs__$1);
m = G__25165;
ks__$1 = G__25166;
vs__$1 = G__25167;
continue;
}
break;
}
});
/**
 * Like `into` but supports multiple "from"s.
 */
taoensso.encore.into_all = (function taoensso$encore$into_all(var_args){
var args25168 = [];
var len__7492__auto___25174 = arguments.length;
var i__7493__auto___25175 = (0);
while(true){
if((i__7493__auto___25175 < len__7492__auto___25174)){
args25168.push((arguments[i__7493__auto___25175]));

var G__25176 = (i__7493__auto___25175 + (1));
i__7493__auto___25175 = G__25176;
continue;
} else {
}
break;
}

var G__25173 = args25168.length;
switch (G__25173) {
case 2:
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7511__auto__ = (new cljs.core.IndexedSeq(args25168.slice((2)),(0),null));
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7511__auto__);

}
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(to,from);
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic = (function (to,from,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.into.cljs$core$IFn$_invoke$arity$2(to,from),more);
});

taoensso.encore.into_all.cljs$lang$applyTo = (function (seq25169){
var G__25170 = cljs.core.first(seq25169);
var seq25169__$1 = cljs.core.next(seq25169);
var G__25171 = cljs.core.first(seq25169__$1);
var seq25169__$2 = cljs.core.next(seq25169__$1);
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic(G__25170,G__25171,seq25169__$2);
});

taoensso.encore.into_all.cljs$lang$maxFixedArity = (2);

/**
 * Greedy version of `interleave`, Ref. http://goo.gl/KvzqWb.
 */
taoensso.encore.interleave_all = (function taoensso$encore$interleave_all(var_args){
var args25178 = [];
var len__7492__auto___25184 = arguments.length;
var i__7493__auto___25185 = (0);
while(true){
if((i__7493__auto___25185 < len__7492__auto___25184)){
args25178.push((arguments[i__7493__auto___25185]));

var G__25186 = (i__7493__auto___25185 + (1));
i__7493__auto___25185 = G__25186;
continue;
} else {
}
break;
}

var G__25183 = args25178.length;
switch (G__25183) {
case 0:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7511__auto__ = (new cljs.core.IndexedSeq(args25178.slice((2)),(0),null));
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7511__auto__);

}
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
if(s1){
return s1;
} else {
if(s2){
return s2;
} else {
return null;
}
}
}
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0))));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(taoensso.encore.interleave_all,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
}),null,null));
});

taoensso.encore.interleave_all.cljs$lang$applyTo = (function (seq25179){
var G__25180 = cljs.core.first(seq25179);
var seq25179__$1 = cljs.core.next(seq25179);
var G__25181 = cljs.core.first(seq25179__$1);
var seq25179__$2 = cljs.core.next(seq25179__$1);
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic(G__25180,G__25181,seq25179__$2);
});

taoensso.encore.interleave_all.cljs$lang$maxFixedArity = (2);

taoensso.encore.takev = (function taoensso$encore$takev(n,coll){
if(cljs.core.vector_QMARK_(coll)){
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(coll,(0),cljs.core.array_seq([n], 0));
} else {
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll));
}
});
/**
 * Prefer `set` when order doesn't matter (much faster).
 */
taoensso.encore.distinctv = (function taoensso$encore$distinctv(var_args){
var args25188 = [];
var len__7492__auto___25199 = arguments.length;
var i__7493__auto___25200 = (0);
while(true){
if((i__7493__auto___25200 < len__7492__auto___25199)){
args25188.push((arguments[i__7493__auto___25200]));

var G__25201 = (i__7493__auto___25200 + (1));
i__7493__auto___25200 = G__25201;
continue;
} else {
}
break;
}

var G__25190 = args25188.length;
switch (G__25190) {
case 1:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25188.length)].join('')));

}
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.persistent_BANG_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__25191,in$){
var vec__25192 = p__25191;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25192,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25192,(1),null);
if(!(cljs.core.contains_QMARK_(seen,in$))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,in$),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,in$)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$(cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll),(0)));
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.persistent_BANG_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__25195,in$){
var vec__25196 = p__25195;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25196,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25196,(1),null);
var in_STAR_ = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(in$) : keyfn.call(null,in$));
if(!(cljs.core.contains_QMARK_(seen,in_STAR_))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,in$),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,in_STAR_)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$(cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll),(0)));
});

taoensso.encore.distinctv.cljs$lang$maxFixedArity = 2;

/**
 * Like `sort-by` for distinct. Based on clojure.core/distinct.
 */
taoensso.encore.distinct_by = (function taoensso$encore$distinct_by(keyfn,coll){
var step = (function taoensso$encore$distinct_by_$_step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__25219,seen__$1){
while(true){
var vec__25220 = p__25219;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25220,(0),null);
var xs__$1 = vec__25220;
var temp__4657__auto__ = cljs.core.seq(xs__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var v_STAR_ = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(v) : keyfn.call(null,v));
if(cljs.core.contains_QMARK_(seen__$1,v_STAR_)){
var G__25223 = cljs.core.rest(s);
var G__25224 = seen__$1;
p__25219 = G__25223;
seen__$1 = G__25224;
continue;
} else {
return cljs.core.cons(v,taoensso$encore$distinct_by_$_step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,v_STAR_)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
taoensso.encore.removev = (function taoensso$encore$removev(pred,coll){
return cljs.core.filterv(cljs.core.complement(pred),coll);
});

/**
 * distinctv` transducer.
 */
taoensso.encore.xdistinct = (function taoensso$encore$xdistinct(var_args){
var args25229 = [];
var len__7492__auto___25234 = arguments.length;
var i__7493__auto___25235 = (0);
while(true){
if((i__7493__auto___25235 < len__7492__auto___25234)){
args25229.push((arguments[i__7493__auto___25235]));

var G__25236 = (i__7493__auto___25235 + (1));
i__7493__auto___25235 = G__25236;
continue;
} else {
}
break;
}

var G__25231 = args25229.length;
switch (G__25231) {
case 0:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25229.length)].join('')));

}
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen_ = (function (){var G__25232 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25232) : cljs.core.atom.call(null,G__25232));
})();
return ((function (seen_){
return (function() {
var G__25238 = null;
var G__25238__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__25238__1 = (function (acc){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(acc) : rf.call(null,acc));
});
var G__25238__2 = (function (acc,input){
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen_) : cljs.core.deref.call(null,seen_)),input)){
return acc;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(seen_,cljs.core.conj,input);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,input) : rf.call(null,acc,input));
}
});
G__25238 = function(acc,input){
switch(arguments.length){
case 0:
return G__25238__0.call(this);
case 1:
return G__25238__1.call(this,acc);
case 2:
return G__25238__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__25238.cljs$core$IFn$_invoke$arity$0 = G__25238__0;
G__25238.cljs$core$IFn$_invoke$arity$1 = G__25238__1;
G__25238.cljs$core$IFn$_invoke$arity$2 = G__25238__2;
return G__25238;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (function (rf){
var seen_ = (function (){var G__25233 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25233) : cljs.core.atom.call(null,G__25233));
})();
return ((function (seen_){
return (function() {
var G__25239 = null;
var G__25239__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__25239__1 = (function (acc){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(acc) : rf.call(null,acc));
});
var G__25239__2 = (function (acc,input){
var k = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(input) : keyfn.call(null,input));
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen_) : cljs.core.deref.call(null,seen_)),k)){
return acc;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(seen_,cljs.core.conj,k);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,input) : rf.call(null,acc,input));
}
});
G__25239 = function(acc,input){
switch(arguments.length){
case 0:
return G__25239__0.call(this);
case 1:
return G__25239__1.call(this,acc);
case 2:
return G__25239__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__25239.cljs$core$IFn$_invoke$arity$0 = G__25239__0;
G__25239.cljs$core$IFn$_invoke$arity$1 = G__25239__1;
G__25239.cljs$core$IFn$_invoke$arity$2 = G__25239__2;
return G__25239;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1(keyfn),coll);
});

taoensso.encore.xdistinct.cljs$lang$maxFixedArity = 2;

/**
 * Reverse comparator.
 */
taoensso.encore.rcompare = (function taoensso$encore$rcompare(x,y){
return cljs.core.compare(y,x);
});
taoensso.encore.nested_merge_with = (function taoensso$encore$nested_merge_with(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25242 = arguments.length;
var i__7493__auto___25243 = (0);
while(true){
if((i__7493__auto___25243 < len__7492__auto___25242)){
args__7499__auto__.push((arguments[i__7493__auto___25243]));

var G__25244 = (i__7493__auto___25243 + (1));
i__7493__auto___25243 = G__25244;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key(e);
var rv = cljs.core.val(e);
if(!(cljs.core.contains_QMARK_(m,k))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,rv);
} else {
var lv = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if((cljs.core.map_QMARK_(lv)) && (cljs.core.map_QMARK_(rv))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.array_seq([lv,rv], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(lv,rv) : f.call(null,lv,rv)));
}
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__6417__auto__ = m1;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

taoensso.encore.nested_merge_with.cljs$lang$maxFixedArity = (1);

taoensso.encore.nested_merge_with.cljs$lang$applyTo = (function (seq25240){
var G__25241 = cljs.core.first(seq25240);
var seq25240__$1 = cljs.core.next(seq25240);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(G__25241,seq25240__$1);
});

taoensso.encore.nested_merge = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nested_merge_with,(function (x,y){
if((cljs.core.map_QMARK_(x)) && ((y == null))){
return x;
} else {
return y;
}
}));
/**
 * Returns the 'greatest' element in coll in O(n) time.
 */
taoensso.encore.greatest = (function taoensso$encore$greatest(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25253 = arguments.length;
var i__7493__auto___25254 = (0);
while(true){
if((i__7493__auto___25254 < len__7492__auto___25253)){
args__7499__auto__.push((arguments[i__7493__auto___25254]));

var G__25255 = (i__7493__auto___25254 + (1));
i__7493__auto___25254 = G__25255;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__25249){
var vec__25250 = p__25249;
var _QMARK_comparator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25250,(0),null);
var comparator = (function (){var or__6417__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (comparator,vec__25250,_QMARK_comparator){
return (function (p1__25245_SHARP_,p2__25246_SHARP_){
if(((comparator.cljs$core$IFn$_invoke$arity$2 ? comparator.cljs$core$IFn$_invoke$arity$2(p1__25245_SHARP_,p2__25246_SHARP_) : comparator.call(null,p1__25245_SHARP_,p2__25246_SHARP_)) > (0))){
return p2__25246_SHARP_;
} else {
return p1__25245_SHARP_;
}
});})(comparator,vec__25250,_QMARK_comparator))
,coll);
});

taoensso.encore.greatest.cljs$lang$maxFixedArity = (1);

taoensso.encore.greatest.cljs$lang$applyTo = (function (seq25247){
var G__25248 = cljs.core.first(seq25247);
var seq25247__$1 = cljs.core.next(seq25247);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic(G__25248,seq25247__$1);
});

/**
 * Returns the 'least' element in coll in O(n) time.
 */
taoensso.encore.least = (function taoensso$encore$least(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25264 = arguments.length;
var i__7493__auto___25265 = (0);
while(true){
if((i__7493__auto___25265 < len__7492__auto___25264)){
args__7499__auto__.push((arguments[i__7493__auto___25265]));

var G__25266 = (i__7493__auto___25265 + (1));
i__7493__auto___25265 = G__25266;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__25260){
var vec__25261 = p__25260;
var _QMARK_comparator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25261,(0),null);
var comparator = (function (){var or__6417__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (comparator,vec__25261,_QMARK_comparator){
return (function (p1__25256_SHARP_,p2__25257_SHARP_){
if(((comparator.cljs$core$IFn$_invoke$arity$2 ? comparator.cljs$core$IFn$_invoke$arity$2(p1__25256_SHARP_,p2__25257_SHARP_) : comparator.call(null,p1__25256_SHARP_,p2__25257_SHARP_)) < (0))){
return p2__25257_SHARP_;
} else {
return p1__25256_SHARP_;
}
});})(comparator,vec__25261,_QMARK_comparator))
,coll);
});

taoensso.encore.least.cljs$lang$maxFixedArity = (1);

taoensso.encore.least.cljs$lang$applyTo = (function (seq25258){
var G__25259 = cljs.core.first(seq25258);
var seq25258__$1 = cljs.core.next(seq25258);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic(G__25259,seq25258__$1);
});

/**
 * Like `repeatedly` but faster and `conj`s items into given collection.
 */
taoensso.encore.repeatedly_into = (function taoensso$encore$repeatedly_into(coll,n,f){
if((coll instanceof clojure.lang.IEditableCollection)){
var v = cljs.core.transient$(coll);
var idx = (0);
while(true){
if((idx >= n)){
return cljs.core.persistent_BANG_(v);
} else {
var G__25267 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
var G__25268 = (idx + (1));
v = G__25267;
idx = G__25268;
continue;
}
break;
}
} else {
var v = coll;
var idx = (0);
while(true){
if((idx >= n)){
return v;
} else {
var G__25269 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
var G__25270 = (idx + (1));
v = G__25269;
idx = G__25270;
continue;
}
break;
}
}
});
taoensso.encore.undefined__GT_nil = (function taoensso$encore$undefined__GT_nil(x){
if((void 0 === x)){
return null;
} else {
return x;
}
});
taoensso.encore.nil__GT_str = (function taoensso$encore$nil__GT_str(x){
if(((void 0 === x)) || ((x == null))){
return "nil";
} else {
return x;
}
});
taoensso.encore.spaced_str_with_nils = (function taoensso$encore$spaced_str_with_nils(xs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,xs));
});
taoensso.encore.spaced_str = (function taoensso$encore$spaced_str(xs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.undefined__GT_nil,xs));
});
taoensso.encore.format_STAR_ = (function taoensso$encore$format_STAR_(fmt,args){
var fmt__$1 = (function (){var or__6417__auto__ = fmt;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return "";
}
})();
var args__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt__$1,args__$1);
});
/**
 * Like `clojure.core/format` but:
 *  * Returns "" when fmt is nil rather than throwing an NPE.
 *  * Formats nil as "nil" rather than "null".
 *  * Provides ClojureScript support via goog.string.format (this has fewer
 *    formatting options than Clojure's `format`!).
 */
taoensso.encore.format = (function taoensso$encore$format(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25273 = arguments.length;
var i__7493__auto___25274 = (0);
while(true){
if((i__7493__auto___25274 < len__7492__auto___25273)){
args__7499__auto__.push((arguments[i__7493__auto___25274]));

var G__25275 = (i__7493__auto___25274 + (1));
i__7493__auto___25274 = G__25275;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return taoensso.encore.format_STAR_(fmt,args);
});

taoensso.encore.format.cljs$lang$maxFixedArity = (1);

taoensso.encore.format.cljs$lang$applyTo = (function (seq25271){
var G__25272 = cljs.core.first(seq25271);
var seq25271__$1 = cljs.core.next(seq25271);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic(G__25272,seq25271__$1);
});

/**
 * Workaround for http://dev.clojure.org/jira/browse/CLJS-794,
 *                http://dev.clojure.org/jira/browse/CLJS-911.
 */
taoensso.encore.str_replace = (function taoensso$encore$str_replace(s,match,replacement){
var replacement__$1 = ((!(cljs.core.fn_QMARK_(replacement)))?replacement:(function() { 
var G__25278__delegate = function (args){
var G__25277 = cljs.core.vec(args);
return (replacement.cljs$core$IFn$_invoke$arity$1 ? replacement.cljs$core$IFn$_invoke$arity$1(G__25277) : replacement.call(null,G__25277));
};
var G__25278 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25279__i = 0, G__25279__a = new Array(arguments.length -  0);
while (G__25279__i < G__25279__a.length) {G__25279__a[G__25279__i] = arguments[G__25279__i + 0]; ++G__25279__i;}
  args = new cljs.core.IndexedSeq(G__25279__a,0);
} 
return G__25278__delegate.call(this,args);};
G__25278.cljs$lang$maxFixedArity = 0;
G__25278.cljs$lang$applyTo = (function (arglist__25280){
var args = cljs.core.seq(arglist__25280);
return G__25278__delegate(args);
});
G__25278.cljs$core$IFn$_invoke$arity$variadic = G__25278__delegate;
return G__25278;
})()
);
if(typeof match === 'string'){
return s.replace((new RegExp(goog.string.regExpEscape(match),"g")),replacement__$1);
} else {
if((match instanceof RegExp)){
var flags = [cljs.core.str("g"),cljs.core.str((cljs.core.truth_(match.ignoreCase)?"i":null)),cljs.core.str((cljs.core.truth_(match.multiline)?"m":null))].join('');
return s.replace((new RegExp(match.source,flags)),replacement__$1);
} else {
throw [cljs.core.str("Invalid match arg: "),cljs.core.str(match)].join('');

}
}
});
/**
 * Gives a consistent, flexible, cross-platform substring API built on
 *   `sub-indexes`.
 */
taoensso.encore.substr = (function taoensso$encore$substr(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25291 = arguments.length;
var i__7493__auto___25292 = (0);
while(true){
if((i__7493__auto___25292 < len__7492__auto___25291)){
args__7499__auto__.push((arguments[i__7493__auto___25292]));

var G__25293 = (i__7493__auto___25292 + (1));
i__7493__auto___25292 = G__25293;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((2) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((2)),(0),null)):null);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7500__auto__);
});

taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic = (function (s,start_idx,p__25284){
var vec__25285 = p__25284;
var _QMARK_max_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25285,(0),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__25285,_QMARK_max_len){
return (function (){
return s;
});})(vec__25285,_QMARK_max_len))
,null)),cljs.core.cst$sym$s,cljs.core.string_QMARK_,cljs.core.cst$sym$string_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? string? s)"));
}

var vec__25288 = taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(s,start_idx,cljs.core.array_seq([cljs.core.cst$kw$max_DASH_len,_QMARK_max_len], 0));
var start_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25288,(0),null);
var end_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25288,(1),null);
return s.substring(start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.substr.cljs$lang$maxFixedArity = (2);

taoensso.encore.substr.cljs$lang$applyTo = (function (seq25281){
var G__25282 = cljs.core.first(seq25281);
var seq25281__$1 = cljs.core.next(seq25281);
var G__25283 = cljs.core.first(seq25281__$1);
var seq25281__$2 = cljs.core.next(seq25281__$1);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(G__25282,G__25283,seq25281__$2);
});

taoensso.encore.str_contains_QMARK_ = (function taoensso$encore$str_contains_QMARK_(s,substr){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((-1),s.indexOf(substr));
});
taoensso.encore.str_starts_with_QMARK_ = (function taoensso$encore$str_starts_with_QMARK_(s,substr){
return (s.indexOf(substr) === (0));
});
taoensso.encore.str_ends_with_QMARK_ = (function taoensso$encore$str_ends_with_QMARK_(s,substr){
var s_len = s.length;
var substr_len = substr.length;
if((s_len >= substr_len)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((-1),s.indexOf(substr,(s_len - substr_len)));
} else {
return null;
}
});
taoensso.encore.str__QMARK_index = (function taoensso$encore$str__QMARK_index(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25301 = arguments.length;
var i__7493__auto___25302 = (0);
while(true){
if((i__7493__auto___25302 < len__7492__auto___25301)){
args__7499__auto__.push((arguments[i__7493__auto___25302]));

var G__25303 = (i__7493__auto___25302 + (1));
i__7493__auto___25302 = G__25303;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((2) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((2)),(0),null)):null);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7500__auto__);
});

taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic = (function (s,substr,p__25297){
var vec__25298 = p__25297;
var start_idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25298,(0),null);
var last_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25298,(1),null);
var start_idx__$1 = ((function (){var or__6417__auto__ = start_idx;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return (0);
}
})() | (0));
var result = ((cljs.core.truth_(last_QMARK_)?s.lastIndexOf(substr,start_idx__$1):s.indexOf(substr,start_idx__$1)) | (0));
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(result,(-1))){
return result;
} else {
return null;
}
});

taoensso.encore.str__QMARK_index.cljs$lang$maxFixedArity = (2);

taoensso.encore.str__QMARK_index.cljs$lang$applyTo = (function (seq25294){
var G__25295 = cljs.core.first(seq25294);
var seq25294__$1 = cljs.core.next(seq25294);
var G__25296 = cljs.core.first(seq25294__$1);
var seq25294__$2 = cljs.core.next(seq25294__$1);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic(G__25295,G__25296,seq25294__$2);
});

/**
 * Like `clojure.string/join` but ensures no double separators.
 */
taoensso.encore.join_once = (function taoensso$encore$join_once(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25306 = arguments.length;
var i__7493__auto___25307 = (0);
while(true){
if((i__7493__auto___25307 < len__7492__auto___25306)){
args__7499__auto__.push((arguments[i__7493__auto___25307]));

var G__25308 = (i__7493__auto___25307 + (1));
i__7493__auto___25307 = G__25308;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic = (function (separator,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s1,s2){
var s1__$1 = [cljs.core.str(s1)].join('');
var s2__$1 = [cljs.core.str(s2)].join('');
if(cljs.core.truth_(taoensso.encore.str_ends_with_QMARK_(s1__$1,separator))){
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s2__$1,separator))){
return [cljs.core.str(s1__$1),cljs.core.str(s2__$1.substring((1)))].join('');
} else {
return [cljs.core.str(s1__$1),cljs.core.str(s2__$1)].join('');
}
} else {
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s2__$1,separator))){
return [cljs.core.str(s1__$1),cljs.core.str(s2__$1)].join('');
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s1__$1,"")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s2__$1,""))){
return [cljs.core.str(s1__$1),cljs.core.str(s2__$1)].join('');
} else {
return [cljs.core.str(s1__$1),cljs.core.str(separator),cljs.core.str(s2__$1)].join('');
}
}
}
}),null,coll);
});

taoensso.encore.join_once.cljs$lang$maxFixedArity = (1);

taoensso.encore.join_once.cljs$lang$applyTo = (function (seq25304){
var G__25305 = cljs.core.first(seq25304);
var seq25304__$1 = cljs.core.next(seq25304);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic(G__25305,seq25304__$1);
});

/**
 * Joins string paths (URLs, file paths, etc.) ensuring correct "/"
 *   interposition.
 */
taoensso.encore.path = (function taoensso$encore$path(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25310 = arguments.length;
var i__7493__auto___25311 = (0);
while(true){
if((i__7493__auto___25311 < len__7492__auto___25310)){
args__7499__auto__.push((arguments[i__7493__auto___25311]));

var G__25312 = (i__7493__auto___25311 + (1));
i__7493__auto___25311 = G__25312;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((0) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((0)),(0),null)):null);
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(argseq__7500__auto__);
});

taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic = (function (parts){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.join_once,"/",parts);
});

taoensso.encore.path.cljs$lang$maxFixedArity = (0);

taoensso.encore.path.cljs$lang$applyTo = (function (seq25309){
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25309));
});

/**
 * Converts all word breaks of any form and length (including line breaks of any
 *   form, tabs, spaces, etc.) to a single regular space.
 */
taoensso.encore.norm_word_breaks = (function taoensso$encore$norm_word_breaks(s){
return clojure.string.replace([cljs.core.str(s)].join(''),/\s+/," ");
});
taoensso.encore.count_words = (function taoensso$encore$count_words(s){
if(clojure.string.blank_QMARK_(s)){
return (0);
} else {
return cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/\s+/));
}
});
/**
 * Returns a UUIDv4 string of form "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx",
 *   Ref. http://www.ietf.org/rfc/rfc4122.txt,
 *     https://gist.github.com/franks42/4159427
 */
taoensso.encore.uuid_str = (function taoensso$encore$uuid_str(var_args){
var args25313 = [];
var len__7492__auto___25316 = arguments.length;
var i__7493__auto___25317 = (0);
while(true){
if((i__7493__auto___25317 < len__7492__auto___25316)){
args25313.push((arguments[i__7493__auto___25317]));

var G__25318 = (i__7493__auto___25317 + (1));
i__7493__auto___25317 = G__25318;
continue;
} else {
}
break;
}

var G__25315 = args25313.length;
switch (G__25315) {
case 1:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25313.length)].join('')));

}
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1 = (function (max_length){
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0(),(0),cljs.core.array_seq([max_length], 0));
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0 = (function (){
var hex = (function (){
return cljs.core.rand_int((15)).toString((16));
});
var rhex = ((8) | ((3) & cljs.core.rand_int((14)))).toString((16));
return [cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str("-"),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str("-"),cljs.core.str("4"),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str("-"),cljs.core.str(rhex),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str("-"),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex()),cljs.core.str(hex())].join('');
});

taoensso.encore.uuid_str.cljs$lang$maxFixedArity = 1;

taoensso.encore.gc_rate = (1.0 / (16000));
taoensso.encore.gc_now_QMARK_ = (function taoensso$encore$gc_now_QMARK_(){
return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0() <= taoensso.encore.gc_rate);
});
/**
 * Swaps associative value at key and returns the new value.
 *   Specialized, fast `swap-in!` for use mostly by memoization utils.
 */
taoensso.encore.swap_val_BANG_ = (function taoensso$encore$swap_val_BANG_(atom_,k,f){
while(true){
var old_m = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_v = (function (){var G__25321 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(old_m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__25321) : f.call(null,G__25321));
})();
var new_m = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(old_m,k,new_v);
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_(atom_,old_m,new_m))){
return new_v;
} else {
continue;
}
break;
}
});
/**
 * As `clojure.core/memoize` but uses delays to avoid write races.
 */
taoensso.encore.memoize_ = (function taoensso$encore$memoize_(f){
var cache_ = (function (){var G__25324 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25324) : cljs.core.atom.call(null,G__25324));
})();
return ((function (cache_){
return (function() { 
var G__25326__delegate = function (args){
var G__25325 = (function (){var or__6417__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return taoensso.encore.swap_val_BANG_(cache_,args,((function (or__6417__auto__,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_(_QMARK_dv)){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__6417__auto__,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
});})(or__6417__auto__,cache_))
,null));
}
});})(or__6417__auto__,cache_))
);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__25325) : cljs.core.deref.call(null,G__25325));
};
var G__25326 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25327__i = 0, G__25327__a = new Array(arguments.length -  0);
while (G__25327__i < G__25327__a.length) {G__25327__a[G__25327__i] = arguments[G__25327__i + 0]; ++G__25327__i;}
  args = new cljs.core.IndexedSeq(G__25327__a,0);
} 
return G__25326__delegate.call(this,args);};
G__25326.cljs$lang$maxFixedArity = 0;
G__25326.cljs$lang$applyTo = (function (arglist__25328){
var args = cljs.core.seq(arglist__25328);
return G__25326__delegate(args);
});
G__25326.cljs$core$IFn$_invoke$arity$variadic = G__25326__delegate;
return G__25326;
})()
;
;})(cache_))
});
/**
 * Great for Reactjs render op caching on mobile devices, etc.
 */
taoensso.encore.memoize1 = (function taoensso$encore$memoize1(f){
var cache_ = (function (){var G__25331 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25331) : cljs.core.atom.call(null,G__25331));
})();
return ((function (cache_){
return (function() { 
var G__25333__delegate = function (args){
var G__25332 = (function (){var or__6417__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cache_,((function (or__6417__auto__,cache_){
return (function (cache){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cache,args))){
return cache;
} else {
return cljs.core.PersistentArrayMap.fromArray([args,(new cljs.core.Delay(((function (or__6417__auto__,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
});})(or__6417__auto__,cache_))
,null))], true, false);
}
});})(or__6417__auto__,cache_))
),args);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__25332) : cljs.core.deref.call(null,G__25332));
};
var G__25333 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25334__i = 0, G__25334__a = new Array(arguments.length -  0);
while (G__25334__i < G__25334__a.length) {G__25334__a[G__25334__i] = arguments[G__25334__i + 0]; ++G__25334__i;}
  args = new cljs.core.IndexedSeq(G__25334__a,0);
} 
return G__25333__delegate.call(this,args);};
G__25333.cljs$lang$maxFixedArity = 0;
G__25333.cljs$lang$applyTo = (function (arglist__25335){
var args = cljs.core.seq(arglist__25335);
return G__25333__delegate(args);
});
G__25333.cljs$core$IFn$_invoke$arity$variadic = G__25333__delegate;
return G__25333;
})()
;
;})(cache_))
});
/**
 * Like `(memoize* f)` but takes an explicit cache atom (possibly nil)
 *   and immediately applies memoized f to given arguments.
 */
taoensso.encore.memoized = (function taoensso$encore$memoized(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25341 = arguments.length;
var i__7493__auto___25342 = (0);
while(true){
if((i__7493__auto___25342 < len__7492__auto___25341)){
args__7499__auto__.push((arguments[i__7493__auto___25342]));

var G__25343 = (i__7493__auto___25342 + (1));
i__7493__auto___25342 = G__25343;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((2) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((2)),(0),null)):null);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7500__auto__);
});

taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic = (function (cache,f,args){
if(cljs.core.not(cache)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
} else {
var G__25340 = taoensso.encore.swap_val_BANG_(cache,args,(function (p1__25336_SHARP_){
if(cljs.core.truth_(p1__25336_SHARP_)){
return p1__25336_SHARP_;
} else {
return (new cljs.core.Delay((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}),null));
}
}));
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__25340) : cljs.core.deref.call(null,G__25340));
}
});

taoensso.encore.memoized.cljs$lang$maxFixedArity = (2);

taoensso.encore.memoized.cljs$lang$applyTo = (function (seq25337){
var G__25338 = cljs.core.first(seq25337);
var seq25337__$1 = cljs.core.next(seq25337);
var G__25339 = cljs.core.first(seq25337__$1);
var seq25337__$2 = cljs.core.next(seq25337__$1);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic(G__25338,G__25339,seq25337__$2);
});

/**
 * Like `clojure.core/memoize` but:
 *  * Uses delays to prevent race conditions on writes.
 *  * Supports auto invalidation & gc with `ttl-ms` option.
 *  * Supports manual invalidation by prepending args with `:mem/del` or `:mem/fresh`.
 *  * Supports cache size limit & gc with `cache-size` option.
 */
taoensso.encore.memoize_STAR_ = (function taoensso$encore$memoize_STAR_(var_args){
var args25346 = [];
var len__7492__auto___25427 = arguments.length;
var i__7493__auto___25428 = (0);
while(true){
if((i__7493__auto___25428 < len__7492__auto___25427)){
args25346.push((arguments[i__7493__auto___25428]));

var G__25429 = (i__7493__auto___25428 + (1));
i__7493__auto___25428 = G__25429;
continue;
} else {
}
break;
}

var G__25348 = args25346.length;
switch (G__25348) {
case 1:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25346.length)].join('')));

}
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
var cache_ = (function (){var G__25349 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25349) : cljs.core.atom.call(null,G__25349));
})();
return ((function (cache_){
return (function() { 
var G__25431__delegate = function (p__25350){
var vec__25351 = p__25350;
var seq__25352 = cljs.core.seq(vec__25351);
var first__25353 = cljs.core.first(seq__25352);
var seq__25352__$1 = cljs.core.next(seq__25352);
var arg1 = first__25353;
var argn = seq__25352__$1;
var args = vec__25351;
if(cljs.core.truth_((function (){var G__25354 = arg1;
var G__25355 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25354,G__25355) : taoensso.encore.kw_identical_QMARK_.call(null,G__25354,G__25355));
})())){
if(cljs.core.truth_((function (){var G__25356 = cljs.core.first(argn);
var G__25357 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25356,G__25357) : taoensso.encore.kw_identical_QMARK_.call(null,G__25356,G__25357));
})())){
var G__25358_25432 = cache_;
var G__25359_25433 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__25358_25432,G__25359_25433) : cljs.core.reset_BANG_.call(null,G__25358_25432,G__25359_25433));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_,cljs.core.dissoc,argn);
}

return null;
} else {
var fresh_QMARK_ = (function (){var G__25360 = arg1;
var G__25361 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25360,G__25361) : taoensso.encore.kw_identical_QMARK_.call(null,G__25360,G__25361));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var G__25362 = (function (){var or__6417__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args__$1);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return taoensso.encore.swap_val_BANG_(cache_,args__$1,((function (or__6417__auto__,fresh_QMARK_,args__$1,vec__25351,seq__25352,first__25353,seq__25352__$1,arg1,argn,args,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_((function (){var and__6405__auto__ = _QMARK_dv;
if(cljs.core.truth_(and__6405__auto__)){
return cljs.core.not(fresh_QMARK_);
} else {
return and__6405__auto__;
}
})())){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__6417__auto__,fresh_QMARK_,args__$1,vec__25351,seq__25352,first__25353,seq__25352__$1,arg1,argn,args,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(or__6417__auto__,fresh_QMARK_,args__$1,vec__25351,seq__25352,first__25353,seq__25352__$1,arg1,argn,args,cache_))
,null));
}
});})(or__6417__auto__,fresh_QMARK_,args__$1,vec__25351,seq__25352,first__25353,seq__25352__$1,arg1,argn,args,cache_))
);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__25362) : cljs.core.deref.call(null,G__25362));
}
};
var G__25431 = function (var_args){
var p__25350 = null;
if (arguments.length > 0) {
var G__25434__i = 0, G__25434__a = new Array(arguments.length -  0);
while (G__25434__i < G__25434__a.length) {G__25434__a[G__25434__i] = arguments[G__25434__i + 0]; ++G__25434__i;}
  p__25350 = new cljs.core.IndexedSeq(G__25434__a,0);
} 
return G__25431__delegate.call(this,p__25350);};
G__25431.cljs$lang$maxFixedArity = 0;
G__25431.cljs$lang$applyTo = (function (arglist__25435){
var p__25350 = cljs.core.seq(arglist__25435);
return G__25431__delegate(p__25350);
});
G__25431.cljs$core$IFn$_invoke$arity$variadic = G__25431__delegate;
return G__25431;
})()
;
;})(cache_))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (ttl_ms,f){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return ttl_ms;
}),null)),cljs.core.cst$sym$ttl_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_], null));


var cache = (function (){var G__25363 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25363) : cljs.core.atom.call(null,G__25363));
})();
return ((function (cache){
return (function() { 
var G__25436__delegate = function (p__25364){
var vec__25365 = p__25364;
var seq__25366 = cljs.core.seq(vec__25365);
var first__25367 = cljs.core.first(seq__25366);
var seq__25366__$1 = cljs.core.next(seq__25366);
var arg1 = first__25367;
var argn = seq__25366__$1;
var args = vec__25365;
if(cljs.core.truth_((function (){var G__25368 = arg1;
var G__25369 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25368,G__25369) : taoensso.encore.kw_identical_QMARK_.call(null,G__25368,G__25369));
})())){
if(cljs.core.truth_((function (){var G__25370 = cljs.core.first(argn);
var G__25371 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25370,G__25371) : taoensso.encore.kw_identical_QMARK_.call(null,G__25370,G__25371));
})())){
var G__25372_25437 = cache;
var G__25373_25438 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__25372_25437,G__25373_25438) : cljs.core.reset_BANG_.call(null,G__25372_25437,G__25373_25438));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache,cljs.core.dissoc,argn);
}

return null;
} else {
if(cljs.core.truth_(taoensso.encore.gc_now_QMARK_())){
var instant_25439 = taoensso.encore.now_udt();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cache,((function (instant_25439,vec__25365,seq__25366,first__25367,seq__25366__$1,arg1,argn,args,cache){
return (function (m){
return cljs.core.reduce_kv(((function (instant_25439,vec__25365,seq__25366,first__25367,seq__25366__$1,arg1,argn,args,cache){
return (function (m_STAR_,k,p__25374){
var vec__25375 = p__25374;
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25375,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25375,(1),null);
var cv = vec__25375;
if(((instant_25439 - udt) > ttl_ms)){
return m_STAR_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR_,k,cv);
}
});})(instant_25439,vec__25365,seq__25366,first__25367,seq__25366__$1,arg1,argn,args,cache))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.encore.clj1098(m));
});})(instant_25439,vec__25365,seq__25366,first__25367,seq__25366__$1,arg1,argn,args,cache))
);
} else {
}

var fresh_QMARK_ = (function (){var G__25381 = arg1;
var G__25382 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25381,G__25382) : taoensso.encore.kw_identical_QMARK_.call(null,G__25381,G__25382));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var instant = taoensso.encore.now_udt();
var vec__25378 = taoensso.encore.swap_val_BANG_(cache,args__$1,((function (fresh_QMARK_,args__$1,instant,vec__25365,seq__25366,first__25367,seq__25366__$1,arg1,argn,args,cache){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__6405__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__6405__auto__)){
var and__6405__auto____$1 = cljs.core.not(fresh_QMARK_);
if(and__6405__auto____$1){
var vec__25386 = _QMARK_cv;
var _dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25386,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25386,(1),null);
return ((instant - udt) < ttl_ms);
} else {
return and__6405__auto____$1;
}
} else {
return and__6405__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,instant,vec__25365,seq__25366,first__25367,seq__25366__$1,arg1,argn,args,cache){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(fresh_QMARK_,args__$1,instant,vec__25365,seq__25366,first__25367,seq__25366__$1,arg1,argn,args,cache))
,null)),instant], null);
}
});})(fresh_QMARK_,args__$1,instant,vec__25365,seq__25366,first__25367,seq__25366__$1,arg1,argn,args,cache))
);
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25378,(0),null);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(dv) : cljs.core.deref.call(null,dv));
}
};
var G__25436 = function (var_args){
var p__25364 = null;
if (arguments.length > 0) {
var G__25440__i = 0, G__25440__a = new Array(arguments.length -  0);
while (G__25440__i < G__25440__a.length) {G__25440__a[G__25440__i] = arguments[G__25440__i + 0]; ++G__25440__i;}
  p__25364 = new cljs.core.IndexedSeq(G__25440__a,0);
} 
return G__25436__delegate.call(this,p__25364);};
G__25436.cljs$lang$maxFixedArity = 0;
G__25436.cljs$lang$applyTo = (function (arglist__25441){
var p__25364 = cljs.core.seq(arglist__25441);
return G__25436__delegate(p__25364);
});
G__25436.cljs$core$IFn$_invoke$arity$variadic = G__25436__delegate;
return G__25436;
})()
;
;})(cache))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (cache_size,ttl_ms,f){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return ttl_ms;
}),null)),cljs.core.cst$sym$ttl_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_], null));


taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cache_size;
}),null)),cljs.core.cst$sym$cache_DASH_size,taoensso.encore.pos_int_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_);


var state = (function (){var G__25389 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tick,(0)], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25389) : cljs.core.atom.call(null,G__25389));
})();
return ((function (state){
return (function() { 
var G__25442__delegate = function (p__25390){
var vec__25391 = p__25390;
var seq__25392 = cljs.core.seq(vec__25391);
var first__25393 = cljs.core.first(seq__25392);
var seq__25392__$1 = cljs.core.next(seq__25392);
var arg1 = first__25393;
var argn = seq__25392__$1;
var args = vec__25391;
if(cljs.core.truth_((function (){var G__25394 = arg1;
var G__25395 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25394,G__25395) : taoensso.encore.kw_identical_QMARK_.call(null,G__25394,G__25395));
})())){
if(cljs.core.truth_((function (){var G__25396 = cljs.core.first(argn);
var G__25397 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25396,G__25397) : taoensso.encore.kw_identical_QMARK_.call(null,G__25396,G__25397));
})())){
var G__25398_25443 = state;
var G__25399_25444 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tick,(0)], null);
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__25398_25443,G__25399_25444) : cljs.core.reset_BANG_.call(null,G__25398_25443,G__25399_25444));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state,cljs.core.dissoc,argn);
}

return null;
} else {
if(cljs.core.truth_(taoensso.encore.gc_now_QMARK_())){
var instant_25445 = taoensso.encore.now_udt();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (instant_25445,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state){
return (function (m){
var m_STAR_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,cljs.core.cst$kw$tick);
var m_STAR___$1 = ((cljs.core.not(ttl_ms))?m_STAR_:cljs.core.reduce_kv(((function (m_STAR_,instant_25445,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state){
return (function (m_STAR___$1,k,p__25400){
var vec__25401 = p__25400;
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25401,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25401,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25401,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25401,(3),null);
var cv = vec__25401;
if(((instant_25445 - udt) > ttl_ms)){
return m_STAR___$1;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR___$1,k,cv);
}
});})(m_STAR_,instant_25445,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.encore.clj1098(m_STAR_)));
var n_to_prune = (cljs.core.count(m_STAR___$1) - cache_size);
var m_STAR___$2 = ((!((n_to_prune > (0))))?m_STAR___$1:cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,m_STAR___$1,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_25445,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state){
return (function (p1__25345_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25345_SHARP_,(1));
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_25445,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state))
,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n_to_prune,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_25445,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state){
return (function (p1__25344_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25344_SHARP_,(0));
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_25445,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state))
,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_25445,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state){
return (function (k){
var vec__25404 = (m_STAR___$1.cljs$core$IFn$_invoke$arity$1 ? m_STAR___$1.cljs$core$IFn$_invoke$arity$1(k) : m_STAR___$1.call(null,k));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25404,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25404,(1),null);
var tick_lru = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25404,(2),null);
var tick_lfu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25404,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(tick_lru + tick_lfu),k], null);
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_25445,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state))
,cljs.core.keys(m_STAR___$1)))))));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR___$2,cljs.core.cst$kw$tick,cljs.core.cst$kw$tick.cljs$core$IFn$_invoke$arity$1(m));
});})(instant_25445,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state))
);
} else {
}

var fresh_QMARK_ = (function (){var G__25410 = arg1;
var G__25411 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25410,G__25411) : taoensso.encore.kw_identical_QMARK_.call(null,G__25410,G__25411));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var _QMARK_instant = (cljs.core.truth_(ttl_ms)?taoensso.encore.now_udt():null);
var tick_SINGLEQUOTE_ = cljs.core.cst$kw$tick.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state)));
var vec__25407 = taoensso.encore.swap_val_BANG_(state,args__$1,((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__6405__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__6405__auto__)){
var and__6405__auto____$1 = cljs.core.not(fresh_QMARK_);
if(and__6405__auto____$1){
var or__6417__auto__ = (_QMARK_instant == null);
if(or__6417__auto__){
return or__6417__auto__;
} else {
var vec__25421 = _QMARK_cv;
var _dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25421,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25421,(1),null);
return ((_QMARK_instant - udt) < ttl_ms);
}
} else {
return and__6405__auto____$1;
}
} else {
return and__6405__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state))
,null)),_QMARK_instant,tick_SINGLEQUOTE_,(1)], null);
}
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state))
);
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25407,(0),null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__25407,dv,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state){
return (function (m){
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,args__$1);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__25424 = temp__4657__auto__;
var dv__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25424,(0),null);
var _QMARK_udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25424,(1),null);
var tick_lru = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25424,(2),null);
var tick_lfu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25424,(3),null);
var cv = vec__25424;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([m,cljs.core.PersistentArrayMap.fromArray([cljs.core.cst$kw$tick,(tick_SINGLEQUOTE_ + (1)),args__$1,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [dv__$1,_QMARK_udt,tick_SINGLEQUOTE_,(tick_lfu + (1))], null)], true, false)], 0));
} else {
return null;
}
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__25407,dv,vec__25391,seq__25392,first__25393,seq__25392__$1,arg1,argn,args,state))
);

return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(dv) : cljs.core.deref.call(null,dv));
}
};
var G__25442 = function (var_args){
var p__25390 = null;
if (arguments.length > 0) {
var G__25446__i = 0, G__25446__a = new Array(arguments.length -  0);
while (G__25446__i < G__25446__a.length) {G__25446__a[G__25446__i] = arguments[G__25446__i + 0]; ++G__25446__i;}
  p__25390 = new cljs.core.IndexedSeq(G__25446__a,0);
} 
return G__25442__delegate.call(this,p__25390);};
G__25442.cljs$lang$maxFixedArity = 0;
G__25442.cljs$lang$applyTo = (function (arglist__25447){
var p__25390 = cljs.core.seq(arglist__25447);
return G__25442__delegate(p__25390);
});
G__25442.cljs$core$IFn$_invoke$arity$variadic = G__25442__delegate;
return G__25442;
})()
;
;})(state))
});

taoensso.encore.memoize_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * Takes one or more rate specs of form [ncalls-limit window-ms ?spec-id] and
 *   returns a (fn [& [req-id])) that returns `nil` (=> all rate limits passed), or
 *   [<ms-wait> <worst-offending-spec-id>] / <ms-wait>.
 */
taoensso.encore.rate_limiter_STAR_ = (function taoensso$encore$rate_limiter_STAR_(specs){
if(cljs.core.empty_QMARK_(specs)){
return cljs.core.constantly(null);
} else {
var vspecs = cljs.core.vec(specs);
var vstates_ = (function (){var G__25536 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25536) : cljs.core.atom.call(null,G__25536));
})();
var max_win_ms = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(0),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vspecs,vstates_){
return (function (p__25537){
var vec__25538 = p__25537;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25538,(0),null);
var win_ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25538,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25538,(2),null);
var spec = vec__25538;
return win_ms;
});})(vspecs,vstates_))
,vspecs));
var nspecs = cljs.core.count(vspecs);
var nid_specs = cljs.core.count(cljs.core.filterv(((function (vspecs,vstates_,max_win_ms,nspecs){
return (function (p__25541){
var vec__25542 = p__25541;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25542,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25542,(1),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25542,(2),null);
return id;
});})(vspecs,vstates_,max_win_ms,nspecs))
,vspecs));
var _ = ((((nid_specs === (0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(nid_specs,nspecs)))?null:(function(){throw (new Error("Assert failed: (or (zero? nid-specs) (= nid-specs nspecs))"))})());
var return_ids_QMARK_ = !((nid_specs === (0)));
return ((function (vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function() { 
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate = function (p__25545){
var vec__25585 = p__25545;
var req_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25585,(0),null);
var instant = taoensso.encore.now_udt();
if(cljs.core.truth_((function (){var and__6405__auto__ = req_id;
if(cljs.core.truth_(and__6405__auto__)){
return taoensso.encore.gc_now_QMARK_();
} else {
return and__6405__auto__;
}
})())){
taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(vstates_,cljs.core.PersistentVector.EMPTY,((function (instant,vec__25585,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function taoensso$encore$rate_limiter_STAR__$_check_rate_limits_$_gc(m){
var m__$1 = taoensso.encore.clj1098(m);
return cljs.core.reduce_kv(((function (m__$1,instant,vec__25585,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (m_STAR_,req_id__$1,vstate){
var max_udt_win_start = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (m__$1,instant,vec__25585,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (acc,p__25592){
var vec__25593 = p__25592;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25593,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25593,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25593,(2),null);
var x__6748__auto__ = acc;
var y__6749__auto__ = udt;
return ((x__6748__auto__ > y__6749__auto__) ? x__6748__auto__ : y__6749__auto__);
});})(m__$1,instant,vec__25585,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,(0),vstate);
var min_win_ms_elapsed = (instant - max_udt_win_start);
if((min_win_ms_elapsed > max_win_ms)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m_STAR_,req_id__$1);
} else {
return m_STAR_;
}
});})(m__$1,instant,vec__25585,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,m__$1,m__$1);
});})(instant,vec__25585,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
} else {
}

return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(vstates_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [req_id], null),((function (instant,vec__25585,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (_QMARK_vstate){
if(cljs.core.not(_QMARK_vstate)){
return taoensso.encore.swapped(cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(nspecs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),instant], null))),null);
} else {
var vec__25596 = (function (){var in_vspecs = vspecs;
var in_vstate = _QMARK_vstate;
var out_vstate = cljs.core.PersistentVector.EMPTY;
var _QMARK_worst_limit_offence = null;
while(true){
var vec__25599 = in_vspecs;
var seq__25600 = cljs.core.seq(vec__25599);
var first__25601 = cljs.core.first(seq__25600);
var seq__25600__$1 = cljs.core.next(seq__25600);
var vec__25602 = first__25601;
var ncalls_limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25602,(0),null);
var win_ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25602,(1),null);
var _QMARK_spec_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25602,(2),null);
var next_in_vspecs = seq__25600__$1;
var vec__25605 = in_vstate;
var seq__25606 = cljs.core.seq(vec__25605);
var first__25607 = cljs.core.first(seq__25606);
var seq__25606__$1 = cljs.core.next(seq__25606);
var vec__25608 = first__25607;
var ncalls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25608,(0),null);
var udt_win_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25608,(1),null);
var next_in_vstate = seq__25606__$1;
var win_ms_elapsed = (instant - udt_win_start);
var reset_due_QMARK_ = (win_ms_elapsed >= win_ms);
var rate_limited_QMARK_ = (!(reset_due_QMARK_)) && ((ncalls >= ncalls_limit));
var new_out_vstate = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out_vstate,((reset_due_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),instant], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls,udt_win_start], null)));
var new__QMARK_worst_limit_offence = ((!(rate_limited_QMARK_))?_QMARK_worst_limit_offence:(function (){var ms_wait = (win_ms - win_ms_elapsed);
if((function (){var or__6417__auto__ = (_QMARK_worst_limit_offence == null);
if(or__6417__auto__){
return or__6417__auto__;
} else {
var vec__25614 = _QMARK_worst_limit_offence;
var max_ms_wait = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25614,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25614,(1),null);
return (ms_wait > max_ms_wait);
}
})()){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ms_wait,_QMARK_spec_id], null);
} else {
return _QMARK_worst_limit_offence;
}
})());
if(cljs.core.not(next_in_vspecs)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_out_vstate,new__QMARK_worst_limit_offence], null);
} else {
var G__25624 = next_in_vspecs;
var G__25625 = next_in_vstate;
var G__25626 = new_out_vstate;
var G__25627 = new__QMARK_worst_limit_offence;
in_vspecs = G__25624;
in_vstate = G__25625;
out_vstate = G__25626;
_QMARK_worst_limit_offence = G__25627;
continue;
}
break;
}
})();
var vstate_with_resets = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25596,(0),null);
var _QMARK_worst_limit_offence = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25596,(1),null);
var all_limits_pass_QMARK_ = (_QMARK_worst_limit_offence == null);
var new_vstate = ((!(all_limits_pass_QMARK_))?vstate_with_resets:cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vec__25596,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__25585,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (p__25617){
var vec__25618 = p__25617;
var ncalls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25618,(0),null);
var udt_win_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25618,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(ncalls + (1)),udt_win_start], null);
});})(vec__25596,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__25585,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,vstate_with_resets));
var result = (function (){var temp__4657__auto__ = _QMARK_worst_limit_offence;
if(cljs.core.truth_(temp__4657__auto__)){
var wlo = temp__4657__auto__;
if(return_ids_QMARK_){
return wlo;
} else {
var vec__25621 = wlo;
var ms_wait = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25621,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25621,(1),null);
return ms_wait;
}
} else {
return null;
}
})();
return taoensso.encore.swapped(new_vstate,result);
}
});})(instant,vec__25585,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
};
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits = function (var_args){
var p__25545 = null;
if (arguments.length > 0) {
var G__25628__i = 0, G__25628__a = new Array(arguments.length -  0);
while (G__25628__i < G__25628__a.length) {G__25628__a[G__25628__i] = arguments[G__25628__i + 0]; ++G__25628__i;}
  p__25545 = new cljs.core.IndexedSeq(G__25628__a,0);
} 
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate.call(this,p__25545);};
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$maxFixedArity = 0;
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$applyTo = (function (arglist__25629){
var p__25545 = cljs.core.seq(arglist__25629);
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate(p__25545);
});
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$core$IFn$_invoke$arity$variadic = taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate;
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits;
})()
;
;})(vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
}
});
taoensso.encore.rate_limit = (function taoensso$encore$rate_limit(specs,f){
var rl = taoensso.encore.rate_limiter_STAR_(specs);
return ((function (rl){
return (function() { 
var G__25630__delegate = function (args){
var temp__4655__auto__ = (rl.cljs$core$IFn$_invoke$arity$0 ? rl.cljs$core$IFn$_invoke$arity$0() : rl.call(null));
if(cljs.core.truth_(temp__4655__auto__)){
var backoff = temp__4655__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,backoff], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),null], null);
}
};
var G__25630 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25631__i = 0, G__25631__a = new Array(arguments.length -  0);
while (G__25631__i < G__25631__a.length) {G__25631__a[G__25631__i] = arguments[G__25631__i + 0]; ++G__25631__i;}
  args = new cljs.core.IndexedSeq(G__25631__a,0);
} 
return G__25630__delegate.call(this,args);};
G__25630.cljs$lang$maxFixedArity = 0;
G__25630.cljs$lang$applyTo = (function (arglist__25632){
var args = cljs.core.seq(arglist__25632);
return G__25630__delegate(args);
});
G__25630.cljs$core$IFn$_invoke$arity$variadic = G__25630__delegate;
return G__25630;
})()
;
;})(rl))
});
taoensso.encore.nano_time = (function (){var temp__4655__auto__ = (function (){var and__6405__auto__ = typeof window !== 'undefined';
if(and__6405__auto__){
return (window["performance"]);
} else {
return and__6405__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var perf = temp__4655__auto__;
var temp__4655__auto____$1 = (function (){var or__6417__auto__ = (perf["now"]);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
var or__6417__auto____$1 = (perf["mozNow"]);
if(cljs.core.truth_(or__6417__auto____$1)){
return or__6417__auto____$1;
} else {
var or__6417__auto____$2 = (perf["msNow"]);
if(cljs.core.truth_(or__6417__auto____$2)){
return or__6417__auto____$2;
} else {
var or__6417__auto____$3 = (perf["oNow"]);
if(cljs.core.truth_(or__6417__auto____$3)){
return or__6417__auto____$3;
} else {
return (perf["webkitNow"]);
}
}
}
}
})();
if(cljs.core.truth_(temp__4655__auto____$1)){
var f = temp__4655__auto____$1;
return ((function (f,temp__4655__auto____$1,perf,temp__4655__auto__){
return (function (){
return cljs.core.long$((1000000.0 * f.call(perf)));
});
;})(f,temp__4655__auto____$1,perf,temp__4655__auto__))
} else {
return ((function (temp__4655__auto____$1,perf,temp__4655__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt());
});
;})(temp__4655__auto____$1,perf,temp__4655__auto__))
}
} else {
return ((function (temp__4655__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt());
});
;})(temp__4655__auto__))
}
})();
taoensso.encore.qb_min_times = (function taoensso$encore$qb_min_times(times){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,times);
});
taoensso.encore.console_log = (function (){var temp__4655__auto__ = (function (){var and__6405__auto__ = typeof console !== 'undefined';
if(and__6405__auto__){
return console.log;
} else {
return and__6405__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return ((function (f,temp__4655__auto__){
return (function (xs){
return f.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(xs));
});
;})(f,temp__4655__auto__))
} else {
return ((function (temp__4655__auto__){
return (function (xs){
return null;
});
;})(temp__4655__auto__))
}
})();

taoensso.encore.log = (function taoensso$encore$log(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25644 = arguments.length;
var i__7493__auto___25645 = (0);
while(true){
if((i__7493__auto___25645 < len__7492__auto___25644)){
args__7499__auto__.push((arguments[i__7493__auto___25645]));

var G__25646 = (i__7493__auto___25645 + (1));
i__7493__auto___25645 = G__25646;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((0) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((0)),(0),null)):null);
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(argseq__7500__auto__);
});

taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(xs) : taoensso.encore.console_log.call(null,xs));
});

taoensso.encore.log.cljs$lang$maxFixedArity = (0);

taoensso.encore.log.cljs$lang$applyTo = (function (seq25633){
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25633));
});


taoensso.encore.logp = (function taoensso$encore$logp(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25647 = arguments.length;
var i__7493__auto___25648 = (0);
while(true){
if((i__7493__auto___25648 < len__7492__auto___25647)){
args__7499__auto__.push((arguments[i__7493__auto___25648]));

var G__25649 = (i__7493__auto___25648 + (1));
i__7493__auto___25648 = G__25649;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((0) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((0)),(0),null)):null);
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(argseq__7500__auto__);
});

taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var G__25635 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.spaced_str(xs)], null);
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(G__25635) : taoensso.encore.console_log.call(null,G__25635));
});

taoensso.encore.logp.cljs$lang$maxFixedArity = (0);

taoensso.encore.logp.cljs$lang$applyTo = (function (seq25634){
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25634));
});


taoensso.encore.logf = (function taoensso$encore$logf(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25650 = arguments.length;
var i__7493__auto___25651 = (0);
while(true){
if((i__7493__auto___25651 < len__7492__auto___25650)){
args__7499__auto__.push((arguments[i__7493__auto___25651]));

var G__25652 = (i__7493__auto___25651 + (1));
i__7493__auto___25651 = G__25652;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
var G__25638 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.format_STAR_(fmt,xs)], null);
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(G__25638) : taoensso.encore.console_log.call(null,G__25638));
});

taoensso.encore.logf.cljs$lang$maxFixedArity = (1);

taoensso.encore.logf.cljs$lang$applyTo = (function (seq25636){
var G__25637 = cljs.core.first(seq25636);
var seq25636__$1 = cljs.core.next(seq25636);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic(G__25637,seq25636__$1);
});


taoensso.encore.sayp = (function taoensso$encore$sayp(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25653 = arguments.length;
var i__7493__auto___25654 = (0);
while(true){
if((i__7493__auto___25654 < len__7492__auto___25653)){
args__7499__auto__.push((arguments[i__7493__auto___25654]));

var G__25655 = (i__7493__auto___25654 + (1));
i__7493__auto___25654 = G__25655;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((0) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((0)),(0),null)):null);
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(argseq__7500__auto__);
});

taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var G__25640 = taoensso.encore.spaced_str(xs);
return alert(G__25640);
});

taoensso.encore.sayp.cljs$lang$maxFixedArity = (0);

taoensso.encore.sayp.cljs$lang$applyTo = (function (seq25639){
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25639));
});


taoensso.encore.sayf = (function taoensso$encore$sayf(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25656 = arguments.length;
var i__7493__auto___25657 = (0);
while(true){
if((i__7493__auto___25657 < len__7492__auto___25656)){
args__7499__auto__.push((arguments[i__7493__auto___25657]));

var G__25658 = (i__7493__auto___25657 + (1));
i__7493__auto___25657 = G__25658;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
var G__25643 = taoensso.encore.format_STAR_(fmt,xs);
return alert(G__25643);
});

taoensso.encore.sayf.cljs$lang$maxFixedArity = (1);

taoensso.encore.sayf.cljs$lang$applyTo = (function (seq25641){
var G__25642 = cljs.core.first(seq25641);
var seq25641__$1 = cljs.core.next(seq25641);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic(G__25642,seq25641__$1);
});

/**
 * Returns browser window's current location. Forgeable.
 */
taoensso.encore.get_window_location = (function taoensso$encore$get_window_location(){
var loc_STAR_ = window.location;
var loc = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$href,loc_STAR_.href,cljs.core.cst$kw$protocol,loc_STAR_.protocol,cljs.core.cst$kw$hostname,loc_STAR_.hostname,cljs.core.cst$kw$host,loc_STAR_.host,cljs.core.cst$kw$pathname,loc_STAR_.pathname,cljs.core.cst$kw$search,loc_STAR_.search,cljs.core.cst$kw$hash,loc_STAR_.hash], null);
return loc;
});
taoensso.encore.xhr_pool_ = (new cljs.core.Delay((function (){
return (new goog.net.XhrIoPool());
}),null));
/**
 * Returns an immediately available XhrIo instance, or nil. The instance must be
 *   released back to pool manually.
 */
taoensso.encore.get_pooled_xhr_BANG_ = (function taoensso$encore$get_pooled_xhr_BANG_(){
var result = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).getObject();
if((void 0 === result)){
return null;
} else {
return result;
}
});
/**
 * [uri method get-or-post-params] -> [uri post-content]
 */
taoensso.encore.coerce_xhr_params = (function taoensso$encore$coerce_xhr_params(uri,method,params){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return params;
}),null)),cljs.core.cst$sym$params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$map_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? map?] params)"));
}

var _QMARK_pstr = ((cljs.core.empty_QMARK_(params))?null:(function (){var s = (function (){var G__25661 = (new goog.structs.Map(cljs.core.clj__GT_js(params)));
return goog.Uri.QueryData.createFromMap(G__25661);
})().toString();
if(clojure.string.blank_QMARK_(s)){
return null;
} else {
return s;
}
})());
var G__25662 = (((method instanceof cljs.core.Keyword))?method.fqn:null);
switch (G__25662) {
case "get":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(_QMARK_pstr)?[cljs.core.str(uri),cljs.core.str("?"),cljs.core.str(_QMARK_pstr)].join(''):uri),null], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
case "put":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(method)].join('')));

}
});
/**
 * Alpha - subject to change.
 *   Simple+lightweight Ajax via Google Closure. Returns nil, or the xhr instance.
 *   Ref. https://developers.google.com/closure/library/docs/xhrio.
 * 
 *   (ajax-lite "/my-post-route"
 *  {:method     :post
 *   :params     {:username "Rich Hickey"
 *                :type     "Awesome"}
 *   :headers    {"Foo" "Bar"}
 *   :resp-type  :text
 *   :timeout-ms 7000
 *   :with-credentials? false ; Enable if using CORS (requires xhr v2+)
 *  }
 *  (fn async-callback [resp-map]
 *    (let [{:keys [success? ?status ?error ?content ?content-type]} resp-map]
 *      ;; ?status  - 200, 404, ..., or nil on no response
 *      ;; ?error   - e/o #{:xhr-pool-depleted :exception :http-error :abort
 *      ;;                  :timeout :no-content <http-error-status> nil}
 *      (js/alert (str "Ajax response: " resp-map)))))
 */
taoensso.encore.ajax_lite = (function taoensso$encore$ajax_lite(uri,p__25666,callback){
var map__25697 = p__25666;
var map__25697__$1 = ((((!((map__25697 == null)))?((((map__25697.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25697.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25697):map__25697);
var opts = map__25697__$1;
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__25697__$1,cljs.core.cst$kw$method,cljs.core.cst$kw$get);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25697__$1,cljs.core.cst$kw$params);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25697__$1,cljs.core.cst$kw$headers);
var timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__25697__$1,cljs.core.cst$kw$timeout_DASH_ms,(10000));
var resp_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__25697__$1,cljs.core.cst$kw$resp_DASH_type,cljs.core.cst$kw$auto);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25697__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var progress_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25697__$1,cljs.core.cst$kw$progress_DASH_fn);
var errorf = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__25697__$1,cljs.core.cst$kw$errorf,taoensso.encore.logf);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (map__25697,map__25697__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (){
return timeout_ms;
});})(map__25697,map__25697__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
,null)),cljs.core.cst$sym$timeout_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$nneg_DASH_int_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? nneg-int?] timeout-ms)"));
}

var temp__4655__auto__ = taoensso.encore.get_pooled_xhr_BANG_();
if(cljs.core.truth_(temp__4655__auto__)){
var xhr = temp__4655__auto__;
try{var timeout_ms__$1 = (function (){var or__6417__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return timeout_ms;
}
})();
var method_STAR_ = (function (){var G__25703 = (((method instanceof cljs.core.Keyword))?method.fqn:null);
switch (G__25703) {
case "get":
return "GET";

break;
case "post":
return "POST";

break;
case "put":
return "PUT";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(method)].join('')));

}
})();
var params__$1 = taoensso.encore.map_keys(cljs.core.name,params);
var headers__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, ["X-Requested-With","XMLHTTPRequest"], null),taoensso.encore.map_keys(cljs.core.name,headers)], 0));
var vec__25700 = taoensso.encore.coerce_xhr_params(uri,method,params__$1);
var uri_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25700,(0),null);
var post_content_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25700,(1),null);
var headers_STAR_ = cljs.core.clj__GT_js(((cljs.core.not(post_content_STAR_))?headers__$1:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(headers__$1,"Content-Type","application/x-www-form-urlencoded; charset=UTF-8")));
var G__25704_25728 = xhr;
var G__25705_25729 = G__25704_25728;
var G__25706_25730 = goog.net.EventType.READY;
var G__25707_25731 = ((function (G__25705_25729,G__25706_25730,G__25704_25728,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__25700,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__25697,map__25697__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (_){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).releaseObject(xhr);
});})(G__25705_25729,G__25706_25730,G__25704_25728,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__25700,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__25697,map__25697__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listenOnce(G__25705_25729,G__25706_25730,G__25707_25731);

var G__25708_25732 = G__25704_25728;
var G__25709_25733 = goog.net.EventType.COMPLETE;
var G__25710_25734 = ((function (G__25708_25732,G__25709_25733,G__25704_25728,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__25700,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__25697,map__25697__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function taoensso$encore$ajax_lite_$_wrapped_callback(resp){
var status = xhr.getStatus();
var success_QMARK_ = xhr.isSuccess();
var _QMARK_http_status = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(status,(-1)))?status:null);
var _QMARK_content_type = (cljs.core.truth_(_QMARK_http_status)?xhr.getResponseHeader("Content-Type"):null);
var _QMARK_content = (cljs.core.truth_(_QMARK_http_status)?(function (){var resp_type__$1 = ((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(resp_type,cljs.core.cst$kw$auto)))?resp_type:(function (){var pred__25716 = ((function (status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__25708_25732,G__25709_25733,G__25704_25728,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__25700,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__25697,map__25697__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (p1__25665_SHARP_,p2__25664_SHARP_){
return taoensso.encore.str_contains_QMARK_(p2__25664_SHARP_,p1__25665_SHARP_);
});})(status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__25708_25732,G__25709_25733,G__25704_25728,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__25700,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__25697,map__25697__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
var expr__25717 = [cljs.core.str(_QMARK_content_type)].join('');
if(cljs.core.truth_(pred__25716("/edn",expr__25717))){
return cljs.core.cst$kw$edn;
} else {
if(cljs.core.truth_(pred__25716("/json",expr__25717))){
return cljs.core.cst$kw$json;
} else {
if(cljs.core.truth_(pred__25716("/xml",expr__25717))){
return cljs.core.cst$kw$xml;
} else {
if(cljs.core.truth_(pred__25716("/html",expr__25717))){
return cljs.core.cst$kw$text;
} else {
return cljs.core.cst$kw$text;
}
}
}
}
})());
try{var G__25720 = (((resp_type__$1 instanceof cljs.core.Keyword))?resp_type__$1.fqn:null);
switch (G__25720) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
case "xml":
return xhr.getResponseXml();

break;
case "edn":
return cljs.reader.read_string(xhr.getResponseText());

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(resp_type__$1)].join('')));

}
}catch (e25719){if((e25719 instanceof Error)){
var e = e25719;
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ajax_SLASH_bad_DASH_response_DASH_type,resp_type__$1,cljs.core.cst$kw$ajax_SLASH_resp_DASH_as_DASH_text,xhr.getResponseText()], null);
} else {
throw e25719;

}
}})():null);
var cb_arg = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$raw_DASH_resp,resp,cljs.core.cst$kw$xhr,xhr,cljs.core.cst$kw$success_QMARK_,success_QMARK_,cljs.core.cst$kw$_QMARK_content_DASH_type,(cljs.core.truth_(_QMARK_http_status)?_QMARK_content_type:null),cljs.core.cst$kw$_QMARK_content,_QMARK_content,cljs.core.cst$kw$_QMARK_status,_QMARK_http_status,cljs.core.cst$kw$_QMARK_error,(function (){var or__6417__auto__ = (cljs.core.truth_(_QMARK_http_status)?(function (){var n = _QMARK_http_status;
if(cljs.core.truth_(success_QMARK_)){
return null;
} else {
return _QMARK_http_status;
}
})():cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.fromArray([goog.net.ErrorCode.EXCEPTION,cljs.core.cst$kw$exception,goog.net.ErrorCode.HTTP_ERROR,cljs.core.cst$kw$http_DASH_error,goog.net.ErrorCode.ABORT,cljs.core.cst$kw$abort,goog.net.ErrorCode.TIMEOUT,cljs.core.cst$kw$timeout], true, false),xhr.getLastErrorCode(),cljs.core.cst$kw$unknown));
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
if(((_QMARK_content == null)) && (cljs.core.not(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(204),null,(1223),null], null), null).call(null,_QMARK_http_status)))){
return cljs.core.cst$kw$no_DASH_content;
} else {
return null;
}
}
})()], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(cb_arg) : callback.call(null,cb_arg));
});})(G__25708_25732,G__25709_25733,G__25704_25728,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__25700,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__25697,map__25697__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listenOnce(G__25708_25732,G__25709_25733,G__25710_25734);


var temp__4657__auto___25736 = progress_fn;
if(cljs.core.truth_(temp__4657__auto___25736)){
var pf_25737 = temp__4657__auto___25736;
var G__25721_25738 = xhr;
var G__25722_25739 = goog.net.EventType.PROGRESS;
var G__25723_25740 = ((function (G__25721_25738,G__25722_25739,pf_25737,temp__4657__auto___25736,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__25700,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__25697,map__25697__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (ev){
var length_computable_QMARK_ = ev.lengthComputable;
var loaded = ev.loaded;
var total = ev.total;
var _QMARK_ratio = (cljs.core.truth_((function (){var and__6405__auto__ = length_computable_QMARK_;
if(cljs.core.truth_(and__6405__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(total,(0));
} else {
return and__6405__auto__;
}
})())?(loaded / total):null);
var G__25724 = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$_QMARK_ratio,_QMARK_ratio,cljs.core.cst$kw$length_DASH_computable_QMARK_,length_computable_QMARK_,cljs.core.cst$kw$loaded,loaded,cljs.core.cst$kw$total,total,cljs.core.cst$kw$ev,ev], null);
return (pf_25737.cljs$core$IFn$_invoke$arity$1 ? pf_25737.cljs$core$IFn$_invoke$arity$1(G__25724) : pf_25737.call(null,G__25724));
});})(G__25721_25738,G__25722_25739,pf_25737,temp__4657__auto___25736,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__25700,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__25697,map__25697__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listen(G__25721_25738,G__25722_25739,G__25723_25740);
} else {
}

var G__25725_25741 = xhr;
var temp__4657__auto___25742 = cljs.core.cst$kw$always;
if(cljs.core.truth_(temp__4657__auto___25742)){
var x_25743 = temp__4657__auto___25742;
G__25725_25741.setTimeoutInterval((function (){var or__6417__auto__ = timeout_ms__$1;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return (0);
}
})());
} else {
}

var temp__4657__auto___25744 = with_credentials_QMARK_;
if(cljs.core.truth_(temp__4657__auto___25744)){
var x_25745 = temp__4657__auto___25744;
G__25725_25741.setWithCredentials(true);
} else {
}

var temp__4657__auto___25746 = cljs.core.cst$kw$always;
if(cljs.core.truth_(temp__4657__auto___25746)){
var x_25747 = temp__4657__auto___25746;
G__25725_25741.send(uri_STAR_,method_STAR_,post_content_STAR_,headers_STAR_);
} else {
}


return xhr;
}catch (e25699){if((e25699 instanceof Error)){
var e = e25699;
(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).releaseObject(xhr);

return null;
} else {
throw e25699;

}
}} else {
var G__25726_25748 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_QMARK_error,cljs.core.cst$kw$xhr_DASH_pool_DASH_depleted], null);
(callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__25726_25748) : callback.call(null,G__25726_25748));

return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1.
 */
taoensso.encore.url_encode = (function taoensso$encore$url_encode(s){
if(cljs.core.truth_(s)){
return clojure.string.replace(clojure.string.replace((function (){var G__25751 = [cljs.core.str(s)].join('');
var G__25752 = s;
return encodeURIComponent(G__25751,G__25752);
})(),"*","%2A"),"'","%27");
} else {
return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1.
 */
taoensso.encore.url_decode = (function taoensso$encore$url_decode(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25759 = arguments.length;
var i__7493__auto___25760 = (0);
while(true){
if((i__7493__auto___25760 < len__7492__auto___25759)){
args__7499__auto__.push((arguments[i__7493__auto___25760]));

var G__25761 = (i__7493__auto___25760 + (1));
i__7493__auto___25760 = G__25761;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__25755){
var vec__25756 = p__25755;
var encoding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25756,(0),null);
if(cljs.core.truth_(s)){
return decodeURIComponent(s);
} else {
return null;
}
});

taoensso.encore.url_decode.cljs$lang$maxFixedArity = (1);

taoensso.encore.url_decode.cljs$lang$applyTo = (function (seq25753){
var G__25754 = cljs.core.first(seq25753);
var seq25753__$1 = cljs.core.next(seq25753);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(G__25754,seq25753__$1);
});

taoensso.encore.format_query_string = (function taoensso$encore$format_query_string(m){
var param = (function (k,v){
return [cljs.core.str(taoensso.encore.url_encode(cljs.core.name(k))),cljs.core.str("="),cljs.core.str(taoensso.encore.url_encode(v))].join('');
});
var join = ((function (param){
return (function (strs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",strs);
});})(param))
;
if(cljs.core.empty_QMARK_(m)){
return null;
} else {
return join((function (){var iter__7197__auto__ = ((function (param,join){
return (function taoensso$encore$format_query_string_$_iter__25780(s__25781){
return (new cljs.core.LazySeq(null,((function (param,join){
return (function (){
var s__25781__$1 = s__25781;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__25781__$1);
if(temp__4657__auto__){
var s__25781__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25781__$2)){
var c__7195__auto__ = cljs.core.chunk_first(s__25781__$2);
var size__7196__auto__ = cljs.core.count(c__7195__auto__);
var b__25783 = cljs.core.chunk_buffer(size__7196__auto__);
if((function (){var i__25782 = (0);
while(true){
if((i__25782 < size__7196__auto__)){
var vec__25792 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7195__auto__,i__25782);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25792,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25792,(1),null);
cljs.core.chunk_append(b__25783,((cljs.core.sequential_QMARK_(v))?join(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(param,k),(function (){var or__6417__auto__ = cljs.core.seq(v);
if(or__6417__auto__){
return or__6417__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param(k,v)));

var G__25798 = (i__25782 + (1));
i__25782 = G__25798;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25783),taoensso$encore$format_query_string_$_iter__25780(cljs.core.chunk_rest(s__25781__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25783),null);
}
} else {
var vec__25795 = cljs.core.first(s__25781__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25795,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25795,(1),null);
return cljs.core.cons(((cljs.core.sequential_QMARK_(v))?join(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(param,k),(function (){var or__6417__auto__ = cljs.core.seq(v);
if(or__6417__auto__){
return or__6417__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param(k,v)),taoensso$encore$format_query_string_$_iter__25780(cljs.core.rest(s__25781__$2)));
}
} else {
return null;
}
break;
}
});})(param,join))
,null,null));
});})(param,join))
;
return iter__7197__auto__(m);
})());
}
});
taoensso.encore.assoc_conj = (function taoensso$encore$assoc_conj(m,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var temp__4655__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(temp__4655__auto__)){
var cur = temp__4655__auto__;
if(cljs.core.vector_QMARK_(cur)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cur,v);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cur,v], null);
}
} else {
return v;
}
})());
});
/**
 * Based on `ring-codec/form-decode`.
 */
taoensso.encore.parse_query_params = (function taoensso$encore$parse_query_params(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25808 = arguments.length;
var i__7493__auto___25809 = (0);
while(true){
if((i__7493__auto___25809 < len__7492__auto___25808)){
args__7499__auto__.push((arguments[i__7493__auto___25809]));

var G__25810 = (i__7493__auto___25809 + (1));
i__7493__auto___25809 = G__25810;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__25801){
var vec__25802 = p__25801;
var keywordize_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25802,(0),null);
var encoding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25802,(1),null);
var _PERCENT_ = ((clojure.string.blank_QMARK_(s))?cljs.core.PersistentArrayMap.EMPTY:(function (){var s__$1 = (cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s,"?"))?taoensso.encore.substr(s,(1)):s);
if(cljs.core.not(taoensso.encore.str_contains_QMARK_(s__$1,"="))){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var m = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (s__$1,vec__25802,keywordize_QMARK_,encoding){
return (function (m,param){
var temp__4655__auto__ = clojure.string.split.cljs$core$IFn$_invoke$arity$3(param,/=/,(2));
if(cljs.core.truth_(temp__4655__auto__)){
var vec__25805 = temp__4655__auto__;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25805,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25805,(1),null);
return taoensso.encore.assoc_conj(m,taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(k,cljs.core.array_seq([encoding], 0)),taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(v,cljs.core.array_seq([encoding], 0)));
} else {
return m;
}
});})(s__$1,vec__25802,keywordize_QMARK_,encoding))
,cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2(s__$1,/&/));
if(cljs.core.not(keywordize_QMARK_)){
return m;
} else {
return taoensso.encore.keywordize_map(m);
}
}
})());
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (_PERCENT_,vec__25802,keywordize_QMARK_,encoding){
return (function (){
return _PERCENT_;
});})(_PERCENT_,vec__25802,keywordize_QMARK_,encoding))
,null)),cljs.core.cst$sym$_PERCENT_,cljs.core.map_QMARK_,cljs.core.cst$sym$map_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? map? %)"));
}

return _PERCENT_;
});

taoensso.encore.parse_query_params.cljs$lang$maxFixedArity = (1);

taoensso.encore.parse_query_params.cljs$lang$applyTo = (function (seq25799){
var G__25800 = cljs.core.first(seq25799);
var seq25799__$1 = cljs.core.next(seq25799);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic(G__25800,seq25799__$1);
});

taoensso.encore.merge_url_with_query_string = (function taoensso$encore$merge_url_with_query_string(url,m){
var vec__25814 = clojure.string.split.cljs$core$IFn$_invoke$arity$3([cljs.core.str(url)].join(''),/\?/,(2));
var url__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25814,(0),null);
var _QMARK_qstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25814,(1),null);
var qmap = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(_QMARK_qstr)?taoensso.encore.keywordize_map(taoensso.encore.parse_query_params(_QMARK_qstr)):null),taoensso.encore.keywordize_map(m)], 0));
return [cljs.core.str(url__$1),cljs.core.str((function (){var temp__4657__auto__ = taoensso.encore.format_query_string(qmap);
if(cljs.core.truth_(temp__4657__auto__)){
var qstr = temp__4657__auto__;
return [cljs.core.str("?"),cljs.core.str(qstr)].join('');
} else {
return null;
}
})())].join('');
});
taoensso.encore.memoize_1 = taoensso.encore.memoize1;
taoensso.encore.logging_level = (function (){var G__25817 = cljs.core.cst$kw$debug;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25817) : cljs.core.atom.call(null,G__25817));
})();
taoensso.encore.set_exp_backoff_timeout_BANG_ = (function taoensso$encore$set_exp_backoff_timeout_BANG_(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25824 = arguments.length;
var i__7493__auto___25825 = (0);
while(true){
if((i__7493__auto___25825 < len__7492__auto___25824)){
args__7499__auto__.push((arguments[i__7493__auto___25825]));

var G__25826 = (i__7493__auto___25825 + (1));
i__7493__auto___25825 = G__25826;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (nullary_f,p__25820){
var vec__25821 = p__25820;
var nattempt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25821,(0),null);
return window.setTimeout(nullary_f,taoensso.encore.exp_backoff((function (){var or__6417__auto__ = nattempt;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return (0);
}
})()));
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$applyTo = (function (seq25818){
var G__25819 = cljs.core.first(seq25818);
var seq25818__$1 = cljs.core.next(seq25818);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25819,seq25818__$1);
});

taoensso.encore.keys_EQ_ = (function taoensso$encore$keys_EQ_(m,ks){
return taoensso.encore.ks_EQ_(ks,m);
});
taoensso.encore.keys_LT__EQ_ = (function taoensso$encore$keys_LT__EQ_(m,ks){
return taoensso.encore.ks_LT__EQ_(ks,m);
});
taoensso.encore.keys_GT__EQ_ = (function taoensso$encore$keys_GT__EQ_(m,ks){
return taoensso.encore.ks_GT__EQ_(ks,m);
});
taoensso.encore.keys_EQ_nnil_QMARK_ = (function taoensso$encore$keys_EQ_nnil_QMARK_(m,ks){
return taoensso.encore.ks_nnil_QMARK_(ks,m);
});
taoensso.encore.parse_bool = taoensso.encore.as__QMARK_bool;
taoensso.encore.parse_int = taoensso.encore.as__QMARK_int;
taoensso.encore.parse_float = taoensso.encore.as__QMARK_float;
taoensso.encore.as_bool = (function taoensso$encore$as_bool(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2200,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_bool(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_bool,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.as_int = (function taoensso$encore$as_int(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2201,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_int(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_int,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.as_float = (function taoensso$encore$as_float(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2202,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_float(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_float,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.merge_deep_with = taoensso.encore.nested_merge_with;
taoensso.encore.merge_deep = taoensso.encore.nested_merge;
taoensso.encore.rate_limiter = (function taoensso$encore$rate_limiter(ncalls_limit,window_ms){
return taoensso.encore.rate_limiter_STAR_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
});
taoensso.encore.rate_limited = (function taoensso$encore$rate_limited(ncalls_limit,window_ms,f){
var rl = taoensso.encore.rate_limiter_STAR_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
return ((function (rl){
return (function() { 
var G__25827__delegate = function (args){
var temp__4655__auto__ = (rl.cljs$core$IFn$_invoke$arity$0 ? rl.cljs$core$IFn$_invoke$arity$0() : rl.call(null));
if(cljs.core.truth_(temp__4655__auto__)){
var backoff_ms = temp__4655__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$backoff_DASH_ms,backoff_ms], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$result,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null))], null);
}
};
var G__25827 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25828__i = 0, G__25828__a = new Array(arguments.length -  0);
while (G__25828__i < G__25828__a.length) {G__25828__a[G__25828__i] = arguments[G__25828__i + 0]; ++G__25828__i;}
  args = new cljs.core.IndexedSeq(G__25828__a,0);
} 
return G__25827__delegate.call(this,args);};
G__25827.cljs$lang$maxFixedArity = 0;
G__25827.cljs$lang$applyTo = (function (arglist__25829){
var args = cljs.core.seq(arglist__25829);
return G__25827__delegate(args);
});
G__25827.cljs$core$IFn$_invoke$arity$variadic = G__25827__delegate;
return G__25827;
})()
;
;})(rl))
});
if(typeof taoensso.encore._STAR_log_level_STAR_ !== 'undefined'){
} else {
/**
 * DEPRECATED
 */
taoensso.encore._STAR_log_level_STAR_ = cljs.core.cst$kw$debug;
}

taoensso.encore.log_QMARK_ = (function (){var __GT_n = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$trace,(1),cljs.core.cst$kw$debug,(2),cljs.core.cst$kw$info,(3),cljs.core.cst$kw$warn,(4),cljs.core.cst$kw$error,(5),cljs.core.cst$kw$fatal,(6),cljs.core.cst$kw$report,(7)], null);
return ((function (__GT_n){
return (function (level){
return ((__GT_n.cljs$core$IFn$_invoke$arity$1 ? __GT_n.cljs$core$IFn$_invoke$arity$1(level) : __GT_n.call(null,level)) >= (__GT_n.cljs$core$IFn$_invoke$arity$1 ? __GT_n.cljs$core$IFn$_invoke$arity$1(taoensso.encore._STAR_log_level_STAR_) : __GT_n.call(null,taoensso.encore._STAR_log_level_STAR_)));
});
;})(__GT_n))
})();

taoensso.encore.tracef = (function taoensso$encore$tracef(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25851 = arguments.length;
var i__7493__auto___25852 = (0);
while(true){
if((i__7493__auto___25852 < len__7492__auto___25851)){
args__7499__auto__.push((arguments[i__7493__auto___25852]));

var G__25853 = (i__7493__auto___25852 + (1));
i__7493__auto___25852 = G__25853;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25832 = cljs.core.cst$kw$trace;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25832) : taoensso.encore.log_QMARK_.call(null,G__25832));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.tracef.cljs$lang$maxFixedArity = (1);

taoensso.encore.tracef.cljs$lang$applyTo = (function (seq25830){
var G__25831 = cljs.core.first(seq25830);
var seq25830__$1 = cljs.core.next(seq25830);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic(G__25831,seq25830__$1);
});


taoensso.encore.debugf = (function taoensso$encore$debugf(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25854 = arguments.length;
var i__7493__auto___25855 = (0);
while(true){
if((i__7493__auto___25855 < len__7492__auto___25854)){
args__7499__auto__.push((arguments[i__7493__auto___25855]));

var G__25856 = (i__7493__auto___25855 + (1));
i__7493__auto___25855 = G__25856;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25835 = cljs.core.cst$kw$debug;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25835) : taoensso.encore.log_QMARK_.call(null,G__25835));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.debugf.cljs$lang$maxFixedArity = (1);

taoensso.encore.debugf.cljs$lang$applyTo = (function (seq25833){
var G__25834 = cljs.core.first(seq25833);
var seq25833__$1 = cljs.core.next(seq25833);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic(G__25834,seq25833__$1);
});


taoensso.encore.infof = (function taoensso$encore$infof(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25857 = arguments.length;
var i__7493__auto___25858 = (0);
while(true){
if((i__7493__auto___25858 < len__7492__auto___25857)){
args__7499__auto__.push((arguments[i__7493__auto___25858]));

var G__25859 = (i__7493__auto___25858 + (1));
i__7493__auto___25858 = G__25859;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25838 = cljs.core.cst$kw$info;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25838) : taoensso.encore.log_QMARK_.call(null,G__25838));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.infof.cljs$lang$maxFixedArity = (1);

taoensso.encore.infof.cljs$lang$applyTo = (function (seq25836){
var G__25837 = cljs.core.first(seq25836);
var seq25836__$1 = cljs.core.next(seq25836);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic(G__25837,seq25836__$1);
});


taoensso.encore.warnf = (function taoensso$encore$warnf(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25860 = arguments.length;
var i__7493__auto___25861 = (0);
while(true){
if((i__7493__auto___25861 < len__7492__auto___25860)){
args__7499__auto__.push((arguments[i__7493__auto___25861]));

var G__25862 = (i__7493__auto___25861 + (1));
i__7493__auto___25861 = G__25862;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25841 = cljs.core.cst$kw$warn;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25841) : taoensso.encore.log_QMARK_.call(null,G__25841));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str("WARN: "),cljs.core.str(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.warnf.cljs$lang$maxFixedArity = (1);

taoensso.encore.warnf.cljs$lang$applyTo = (function (seq25839){
var G__25840 = cljs.core.first(seq25839);
var seq25839__$1 = cljs.core.next(seq25839);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic(G__25840,seq25839__$1);
});


taoensso.encore.errorf = (function taoensso$encore$errorf(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25863 = arguments.length;
var i__7493__auto___25864 = (0);
while(true){
if((i__7493__auto___25864 < len__7492__auto___25863)){
args__7499__auto__.push((arguments[i__7493__auto___25864]));

var G__25865 = (i__7493__auto___25864 + (1));
i__7493__auto___25864 = G__25865;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25844 = cljs.core.cst$kw$error;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25844) : taoensso.encore.log_QMARK_.call(null,G__25844));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str("ERROR: "),cljs.core.str(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.errorf.cljs$lang$maxFixedArity = (1);

taoensso.encore.errorf.cljs$lang$applyTo = (function (seq25842){
var G__25843 = cljs.core.first(seq25842);
var seq25842__$1 = cljs.core.next(seq25842);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic(G__25843,seq25842__$1);
});


taoensso.encore.fatalf = (function taoensso$encore$fatalf(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25866 = arguments.length;
var i__7493__auto___25867 = (0);
while(true){
if((i__7493__auto___25867 < len__7492__auto___25866)){
args__7499__auto__.push((arguments[i__7493__auto___25867]));

var G__25868 = (i__7493__auto___25867 + (1));
i__7493__auto___25867 = G__25868;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25847 = cljs.core.cst$kw$fatal;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25847) : taoensso.encore.log_QMARK_.call(null,G__25847));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str("FATAL: "),cljs.core.str(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.fatalf.cljs$lang$maxFixedArity = (1);

taoensso.encore.fatalf.cljs$lang$applyTo = (function (seq25845){
var G__25846 = cljs.core.first(seq25845);
var seq25845__$1 = cljs.core.next(seq25845);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic(G__25846,seq25845__$1);
});


taoensso.encore.reportf = (function taoensso$encore$reportf(var_args){
var args__7499__auto__ = [];
var len__7492__auto___25869 = arguments.length;
var i__7493__auto___25870 = (0);
while(true){
if((i__7493__auto___25870 < len__7492__auto___25869)){
args__7499__auto__.push((arguments[i__7493__auto___25870]));

var G__25871 = (i__7493__auto___25870 + (1));
i__7493__auto___25870 = G__25871;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((1) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((1)),(0),null)):null);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7500__auto__);
});

taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25850 = cljs.core.cst$kw$report;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25850) : taoensso.encore.log_QMARK_.call(null,G__25850));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.reportf.cljs$lang$maxFixedArity = (1);

taoensso.encore.reportf.cljs$lang$applyTo = (function (seq25848){
var G__25849 = cljs.core.first(seq25848);
var seq25848__$1 = cljs.core.next(seq25848);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic(G__25849,seq25848__$1);
});

