// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('taoensso.tower');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('taoensso.encore');
/**
 * "en_gb-var1" -> :en-gb-var1, etc.
 */
taoensso.tower.kw_locale = cljs.core.memoize((function() { 
var G__27312__delegate = function (_QMARK_loc,p__27308){
var vec__27309 = p__27308;
var lang_only_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27309,(0),null);
var loc_name = cljs.core.name((function (){var or__6417__auto__ = _QMARK_loc;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.cst$kw$nil;
}
})());
var loc_name__$1 = clojure.string.replace(loc_name,"_","-");
var loc_name__$2 = ((cljs.core.not(lang_only_QMARK_))?loc_name__$1:cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(loc_name__$1,/-/)));
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(loc_name__$2);
};
var G__27312 = function (_QMARK_loc,var_args){
var p__27308 = null;
if (arguments.length > 1) {
var G__27313__i = 0, G__27313__a = new Array(arguments.length -  1);
while (G__27313__i < G__27313__a.length) {G__27313__a[G__27313__i] = arguments[G__27313__i + 1]; ++G__27313__i;}
  p__27308 = new cljs.core.IndexedSeq(G__27313__a,0);
} 
return G__27312__delegate.call(this,_QMARK_loc,p__27308);};
G__27312.cljs$lang$maxFixedArity = 1;
G__27312.cljs$lang$applyTo = (function (arglist__27314){
var _QMARK_loc = cljs.core.first(arglist__27314);
var p__27308 = cljs.core.rest(arglist__27314);
return G__27312__delegate(_QMARK_loc,p__27308);
});
G__27312.cljs$core$IFn$_invoke$arity$variadic = G__27312__delegate;
return G__27312;
})()
);
/**
 * Alpha - subject to change.
 */
taoensso.tower.fmt_str = (function taoensso$tower$fmt_str(var_args){
var args__7499__auto__ = [];
var len__7492__auto___27320 = arguments.length;
var i__7493__auto___27321 = (0);
while(true){
if((i__7493__auto___27321 < len__7492__auto___27320)){
args__7499__auto__.push((arguments[i__7493__auto___27321]));

var G__27322 = (i__7493__auto___27321 + (1));
i__7493__auto___27321 = G__27322;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((2) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((2)),(0),null)):null);
return taoensso.tower.fmt_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7500__auto__);
});

taoensso.tower.fmt_str.cljs$core$IFn$_invoke$arity$variadic = (function (_loc,fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.format,(function (){var or__6417__auto__ = fmt;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return "";
}
})(),args);
});

taoensso.tower.fmt_str.cljs$lang$maxFixedArity = (2);

taoensso.tower.fmt_str.cljs$lang$applyTo = (function (seq27317){
var G__27318 = cljs.core.first(seq27317);
var seq27317__$1 = cljs.core.next(seq27317);
var G__27319 = cljs.core.first(seq27317__$1);
var seq27317__$2 = cljs.core.next(seq27317__$1);
return taoensso.tower.fmt_str.cljs$core$IFn$_invoke$arity$variadic(G__27318,G__27319,seq27317__$2);
});

taoensso.tower._STAR_tscope_STAR_ = null;
/**
 * Merges scope keywords: (scope :a.b :c/d :e) => :a.b.c.d/e
 */
taoensso.tower.scoped = cljs.core.memoize((function() { 
var G__27324__delegate = function (ks){
return taoensso.encore.merge_keywords(ks);
};
var G__27324 = function (var_args){
var ks = null;
if (arguments.length > 0) {
var G__27325__i = 0, G__27325__a = new Array(arguments.length -  0);
while (G__27325__i < G__27325__a.length) {G__27325__a[G__27325__i] = arguments[G__27325__i + 0]; ++G__27325__i;}
  ks = new cljs.core.IndexedSeq(G__27325__a,0);
} 
return G__27324__delegate.call(this,ks);};
G__27324.cljs$lang$maxFixedArity = 0;
G__27324.cljs$lang$applyTo = (function (arglist__27326){
var ks = cljs.core.seq(arglist__27326);
return G__27324__delegate(ks);
});
G__27324.cljs$core$IFn$_invoke$arity$variadic = G__27324__delegate;
return G__27324;
})()
);
taoensso.tower.tscoped = taoensso.tower.scoped;
/**
 * Returns intelligent, descending-preference vector of locale keys to search
 *   for given locale or vector of descending-preference locales.
 */
taoensso.tower.loc_tree = (function (){var loc_tree_STAR_ = cljs.core.memoize((function (loc){
var loc_parts = clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((taoensso.tower.kw_locale.cljs$core$IFn$_invoke$arity$1 ? taoensso.tower.kw_locale.cljs$core$IFn$_invoke$arity$1(loc) : taoensso.tower.kw_locale.call(null,loc))),/-/);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (loc_parts){
return (function (p1__27327_SHARP_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("-",p1__27327_SHARP_));
});})(loc_parts))
,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate(cljs.core.butlast,loc_parts)));
}));
return ((function (loc_tree_STAR_){
return (function (loc_or_locs){
if(!(cljs.core.vector_QMARK_(loc_or_locs))){
return (loc_tree_STAR_.cljs$core$IFn$_invoke$arity$1 ? loc_tree_STAR_.cljs$core$IFn$_invoke$arity$1(loc_or_locs) : loc_tree_STAR_.call(null,loc_or_locs));
} else {
var lang_first_idxs = cljs.core.zipmap(taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.peek,loc_tree_STAR_),loc_or_locs)),cljs.core.range.cljs$core$IFn$_invoke$arity$0());
var loc_score = ((function (lang_first_idxs,loc_tree_STAR_){
return (function (loc){
var tree = (loc_tree_STAR_.cljs$core$IFn$_invoke$arity$1 ? loc_tree_STAR_.cljs$core$IFn$_invoke$arity$1(loc) : loc_tree_STAR_.call(null,loc));
var lang = cljs.core.peek(tree);
var nparts = cljs.core.count(tree);
return (((10) * cljs.core.get.cljs$core$IFn$_invoke$arity$2(lang_first_idxs,lang)) - nparts);
});})(lang_first_idxs,loc_tree_STAR_))
;
var locs = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.PersistentVector.EMPTY,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(loc_tree_STAR_,loc_or_locs));
var sorted_locs = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(loc_score,taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1(locs));
return cljs.core.vec(sorted_locs);
}
});
;})(loc_tree_STAR_))
})();
/**
 * Implementation detail. Based on `encore/format`.
 */
taoensso.tower.default_tfmt_str = (function taoensso$tower$default_tfmt_str(var_args){
var args__7499__auto__ = [];
var len__7492__auto___27331 = arguments.length;
var i__7493__auto___27332 = (0);
while(true){
if((i__7493__auto___27332 < len__7492__auto___27331)){
args__7499__auto__.push((arguments[i__7493__auto___27332]));

var G__27333 = (i__7493__auto___27332 + (1));
i__7493__auto___27332 = G__27333;
continue;
} else {
}
break;
}

var argseq__7500__auto__ = ((((2) < args__7499__auto__.length))?(new cljs.core.IndexedSeq(args__7499__auto__.slice((2)),(0),null)):null);
return taoensso.tower.default_tfmt_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7500__auto__);
});

taoensso.tower.default_tfmt_str.cljs$core$IFn$_invoke$arity$variadic = (function (_loc,fmt,args){
var fmt__$1 = (function (){var or__6417__auto__ = fmt;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return "";
}
})();
var args__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt__$1,args__$1);
});

taoensso.tower.default_tfmt_str.cljs$lang$maxFixedArity = (2);

taoensso.tower.default_tfmt_str.cljs$lang$applyTo = (function (seq27328){
var G__27329 = cljs.core.first(seq27328);
var seq27328__$1 = cljs.core.next(seq27328);
var G__27330 = cljs.core.first(seq27328__$1);
var seq27328__$2 = cljs.core.next(seq27328__$1);
return taoensso.tower.default_tfmt_str.cljs$core$IFn$_invoke$arity$variadic(G__27329,G__27330,seq27328__$2);
});

taoensso.tower.nstr = (function taoensso$tower$nstr(x){
if((x == null)){
return "nil";
} else {
return [cljs.core.str(x)].join('');
}
});
taoensso.tower.find1 = (function taoensso$tower$find1(var_args){
var args27336 = [];
var len__7492__auto___27345 = arguments.length;
var i__7493__auto___27346 = (0);
while(true){
if((i__7493__auto___27346 < len__7492__auto___27345)){
args27336.push((arguments[i__7493__auto___27346]));

var G__27347 = (i__7493__auto___27346 + (1));
i__7493__auto___27346 = G__27347;
continue;
} else {
}
break;
}

var G__27338 = args27336.length;
switch (G__27338) {
case 4:
return taoensso.tower.find1.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return taoensso.tower.find1.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27336.length)].join('')));

}
});

taoensso.tower.find1.cljs$core$IFn$_invoke$arity$4 = (function (dict,scope,k,ltree){
var vec__27339 = ltree;
var l1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27339,(0),null);
var ls = vec__27339;
var scoped_k = (taoensso.tower.scoped.cljs$core$IFn$_invoke$arity$2 ? taoensso.tower.scoped.cljs$core$IFn$_invoke$arity$2(scope,k) : taoensso.tower.scoped.call(null,scope,k));
if(cljs.core.next(ls)){
return cljs.core.some(((function (vec__27339,l1,ls,scoped_k){
return (function (p1__27334_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dict,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [scoped_k,p1__27334_SHARP_], null));
});})(vec__27339,l1,ls,scoped_k))
,ls);
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dict,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [scoped_k,l1], null));
}
});

taoensso.tower.find1.cljs$core$IFn$_invoke$arity$3 = (function (dict,k,ltree){
var vec__27342 = ltree;
var l1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27342,(0),null);
var ls = vec__27342;
if(cljs.core.next(ls)){
return cljs.core.some(((function (vec__27342,l1,ls){
return (function (p1__27335_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dict,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,p1__27335_SHARP_], null));
});})(vec__27342,l1,ls))
,ls);
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dict,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,l1], null));
}
});

taoensso.tower.find1.cljs$lang$maxFixedArity = 4;

taoensso.tower.make_t_uncached = (function taoensso$tower$make_t_uncached(tconfig){
if(cljs.core.map_QMARK_(tconfig)){
} else {
throw (new Error("Assert failed: (map? tconfig)"));
}

var map__27380 = tconfig;
var map__27380__$1 = ((((!((map__27380 == null)))?((((map__27380.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27380.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27380):map__27380);
var compiled_dictionary = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27380__$1,cljs.core.cst$kw$compiled_DASH_dictionary);
var dev_mode_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27380__$1,cljs.core.cst$kw$dev_DASH_mode_QMARK_);
var fallback_locale = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27380__$1,cljs.core.cst$kw$fallback_DASH_locale,cljs.core.cst$kw$en);
var scope_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27380__$1,cljs.core.cst$kw$scope_DASH_fn,((function (map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale){
return (function (){
return taoensso.tower._STAR_tscope_STAR_;
});})(map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale))
);
var fmt_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27380__$1,cljs.core.cst$kw$fmt_DASH_fn,taoensso.tower.default_tfmt_str);
var log_missing_translation_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27380__$1,cljs.core.cst$kw$log_DASH_missing_DASH_translation_DASH_fn,((function (map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale,scope_fn,fmt_fn){
return (function (p__27382){
var map__27383 = p__27382;
var map__27383__$1 = ((((!((map__27383 == null)))?((((map__27383.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27383.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27383):map__27383);
var args = map__27383__$1;
var dev_mode_QMARK___$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27383__$1,cljs.core.cst$kw$dev_DASH_mode_QMARK_);
var pattern = "Missing-translation: %s";
if(cljs.core.truth_(dev_mode_QMARK___$1)){
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic(pattern,cljs.core.array_seq([args], 0));
} else {
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic(pattern,cljs.core.array_seq([args], 0));
}
});})(map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale,scope_fn,fmt_fn))
);
var cache_locales_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__27380__$1,cljs.core.cst$kw$cache_DASH_locales_QMARK_,true);
var _ = (function (){
if(cljs.core.truth_(cljs.core.cst$kw$compiled_DASH_dictionary.cljs$core$IFn$_invoke$arity$1(tconfig))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Missing tconfig key: :compiled-dictionary"),cljs.core.str("\n"),cljs.core.str("(:compiled-dictionary tconfig)")].join('')));
}

if(cljs.core.not(cljs.core.cst$kw$dictionary.cljs$core$IFn$_invoke$arity$1(tconfig))){
return null;
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Invalid tconfig key: :dictionary"),cljs.core.str("\n"),cljs.core.str("(not (:dictionary tconfig))")].join('')));
}
})()
;
var loc_tree_STAR_ = (cljs.core.truth_(cache_locales_QMARK_)?cljs.core.memoize(taoensso.tower.loc_tree):taoensso.tower.loc_tree);
var get_dict = ((function (map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale,scope_fn,fmt_fn,log_missing_translation_fn,cache_locales_QMARK_,_,loc_tree_STAR_){
return (function (){
return compiled_dictionary;
});})(map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale,scope_fn,fmt_fn,log_missing_translation_fn,cache_locales_QMARK_,_,loc_tree_STAR_))
;
return ((function (map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale,scope_fn,fmt_fn,log_missing_translation_fn,cache_locales_QMARK_,_,loc_tree_STAR_,get_dict){
return (function() { 
var taoensso$tower$make_t_uncached_$_new_t__delegate = function (l_or_ls,k_or_ks,fmt_args){
var dict = get_dict();
var ks = ((cljs.core.vector_QMARK_(k_or_ks))?k_or_ks:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_or_ks], null));
var ls = ((cljs.core.vector_QMARK_(l_or_ls))?l_or_ls:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [l_or_ls], null));
var vec__27397 = ls;
var l1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27397,(0),null);
var scope = (scope_fn.cljs$core$IFn$_invoke$arity$0 ? scope_fn.cljs$core$IFn$_invoke$arity$0() : scope_fn.call(null));
var ks_QMARK_ = cljs.core.vector_QMARK_(k_or_ks);
var tr = (function (){var or__6417__auto__ = (function (){var ltree = (loc_tree_STAR_.cljs$core$IFn$_invoke$arity$1 ? loc_tree_STAR_.cljs$core$IFn$_invoke$arity$1(ls) : loc_tree_STAR_.call(null,ls));
if(ks_QMARK_){
return cljs.core.some(((function (ltree,dict,ks,ls,vec__27397,l1,scope,ks_QMARK_,map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale,scope_fn,fmt_fn,log_missing_translation_fn,cache_locales_QMARK_,_,loc_tree_STAR_,get_dict){
return (function (p1__27349_SHARP_){
return taoensso.tower.find1.cljs$core$IFn$_invoke$arity$4(dict,scope,p1__27349_SHARP_,ltree);
});})(ltree,dict,ks,ls,vec__27397,l1,scope,ks_QMARK_,map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale,scope_fn,fmt_fn,log_missing_translation_fn,cache_locales_QMARK_,_,loc_tree_STAR_,get_dict))
,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword_QMARK_,ks));
} else {
return taoensso.tower.find1.cljs$core$IFn$_invoke$arity$4(dict,scope,k_or_ks,ltree);
}
})();
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
var last_k = cljs.core.peek(ks);
if(!((last_k instanceof cljs.core.Keyword))){
if((last_k == null)){
return cljs.core.cst$kw$taoensso$tower_SLASH_nil;
} else {
return last_k;
}
} else {
var temp__4657__auto___27409 = log_missing_translation_fn;
if(cljs.core.truth_(temp__4657__auto___27409)){
var log_f_27410 = temp__4657__auto___27409;
var G__27400_27411 = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$locales,ls,cljs.core.cst$kw$scope,scope,cljs.core.cst$kw$ks,ks,cljs.core.cst$kw$dev_DASH_mode_QMARK_,dev_mode_QMARK_], null);
(log_f_27410.cljs$core$IFn$_invoke$arity$1 ? log_f_27410.cljs$core$IFn$_invoke$arity$1(G__27400_27411) : log_f_27410.call(null,G__27400_27411));
} else {
}

var or__6417__auto____$1 = (function (){var ltree = (loc_tree_STAR_.cljs$core$IFn$_invoke$arity$1 ? loc_tree_STAR_.cljs$core$IFn$_invoke$arity$1(fallback_locale) : loc_tree_STAR_.call(null,fallback_locale));
if(ks_QMARK_){
return cljs.core.some(((function (ltree,last_k,or__6417__auto__,dict,ks,ls,vec__27397,l1,scope,ks_QMARK_,map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale,scope_fn,fmt_fn,log_missing_translation_fn,cache_locales_QMARK_,_,loc_tree_STAR_,get_dict){
return (function (p1__27350_SHARP_){
return taoensso.tower.find1.cljs$core$IFn$_invoke$arity$4(dict,scope,p1__27350_SHARP_,ltree);
});})(ltree,last_k,or__6417__auto__,dict,ks,ls,vec__27397,l1,scope,ks_QMARK_,map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale,scope_fn,fmt_fn,log_missing_translation_fn,cache_locales_QMARK_,_,loc_tree_STAR_,get_dict))
,ks);
} else {
return taoensso.tower.find1.cljs$core$IFn$_invoke$arity$4(dict,scope,k_or_ks,ltree);
}
})();
if(cljs.core.truth_(or__6417__auto____$1)){
return or__6417__auto____$1;
} else {
var ltree = (function (){var G__27401 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ls,fallback_locale);
return (loc_tree_STAR_.cljs$core$IFn$_invoke$arity$1 ? loc_tree_STAR_.cljs$core$IFn$_invoke$arity$1(G__27401) : loc_tree_STAR_.call(null,G__27401));
})();
var temp__4657__auto__ = taoensso.tower.find1.cljs$core$IFn$_invoke$arity$3(dict,cljs.core.cst$kw$missing,ltree);
if(cljs.core.truth_(temp__4657__auto__)){
var pattern = temp__4657__auto__;
var G__27402 = l1;
var G__27403 = pattern;
var G__27404 = taoensso.tower.nstr(ls);
var G__27405 = taoensso.tower.nstr(scope);
var G__27406 = taoensso.tower.nstr(ks);
return (fmt_fn.cljs$core$IFn$_invoke$arity$5 ? fmt_fn.cljs$core$IFn$_invoke$arity$5(G__27402,G__27403,G__27404,G__27405,G__27406) : fmt_fn.call(null,G__27402,G__27403,G__27404,G__27405,G__27406));
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_((function (){var G__27407 = tr;
var G__27408 = cljs.core.cst$kw$taoensso$tower_SLASH_nil;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__27407,G__27408) : taoensso.encore.kw_identical_QMARK_.call(null,G__27407,G__27408));
})())){
return null;
} else {
var tr__$1 = (function (){var or__6417__auto__ = tr;
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return "";
}
})();
if((fmt_args == null)){
return tr__$1;
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(fmt_fn,l1,tr__$1,fmt_args);
}
}
};
var taoensso$tower$make_t_uncached_$_new_t = function (l_or_ls,k_or_ks,var_args){
var fmt_args = null;
if (arguments.length > 2) {
var G__27412__i = 0, G__27412__a = new Array(arguments.length -  2);
while (G__27412__i < G__27412__a.length) {G__27412__a[G__27412__i] = arguments[G__27412__i + 2]; ++G__27412__i;}
  fmt_args = new cljs.core.IndexedSeq(G__27412__a,0);
} 
return taoensso$tower$make_t_uncached_$_new_t__delegate.call(this,l_or_ls,k_or_ks,fmt_args);};
taoensso$tower$make_t_uncached_$_new_t.cljs$lang$maxFixedArity = 2;
taoensso$tower$make_t_uncached_$_new_t.cljs$lang$applyTo = (function (arglist__27413){
var l_or_ls = cljs.core.first(arglist__27413);
arglist__27413 = cljs.core.next(arglist__27413);
var k_or_ks = cljs.core.first(arglist__27413);
var fmt_args = cljs.core.rest(arglist__27413);
return taoensso$tower$make_t_uncached_$_new_t__delegate(l_or_ls,k_or_ks,fmt_args);
});
taoensso$tower$make_t_uncached_$_new_t.cljs$core$IFn$_invoke$arity$variadic = taoensso$tower$make_t_uncached_$_new_t__delegate;
return taoensso$tower$make_t_uncached_$_new_t;
})()
;
;})(map__27380,map__27380__$1,compiled_dictionary,dev_mode_QMARK_,fallback_locale,scope_fn,fmt_fn,log_missing_translation_fn,cache_locales_QMARK_,_,loc_tree_STAR_,get_dict))
});
taoensso.tower.make_t_cached = cljs.core.memoize(taoensso.tower.make_t_uncached);
taoensso.tower.make_t = taoensso.tower.make_t_uncached;
