// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('typeahead.core');
goog.require('cljs.core');
goog.require('om.core');
goog.require('cljs.core.async');
goog.require('om.dom');
goog.require('clojure.string');
typeahead.core.term_separator_re = /[|+ :]/;
typeahead.core.__GT_basic_entry = (function typeahead$core$__GT_basic_entry(term){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$term,term,cljs.core.cst$kw$props,cljs.core.PersistentArrayMap.EMPTY], null);
});
/**
 * Add a list of characters to an index, implemented as a trie.
 */
typeahead.core.into_index = (function typeahead$core$into_index(idx,cs,props){
if(cljs.core.empty_QMARK_(cs)){
if(cljs.core.empty_QMARK_(idx)){
return props;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(idx,"",props);
}
} else {
var c = cljs.core.first(cs);
var next = typeahead$core$into_index(cljs.core.get.cljs$core$IFn$_invoke$arity$2(idx,c),cljs.core.rest(cs),props);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(idx,cljs.core.cst$kw$props),c,((cljs.core.contains_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(idx,c),cljs.core.cst$kw$props))?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, ["",cljs.core.get.cljs$core$IFn$_invoke$arity$2(idx,c)], null),next], 0)):next));
}
});
/**
 * Given an existing index, add a new word.
 */
typeahead.core.index_single = (function typeahead$core$index_single(idx,p__42974){
var map__42977 = p__42974;
var map__42977__$1 = ((((!((map__42977 == null)))?((((map__42977.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42977.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42977):map__42977);
var term = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42977__$1,cljs.core.cst$kw$term);
var props = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42977__$1,cljs.core.cst$kw$props);
return typeahead.core.into_index(idx,cljs.core.seq(clojure.string.lower_case(term)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$props,props], null));
});
typeahead.core.transforming_index = (function typeahead$core$transforming_index(transformer,phrases){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(typeahead.core.index_single,cljs.core.PersistentArrayMap.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(transformer,cljs.core.array_seq([phrases], 0))));
});
/**
 * Index the words of a list of phrases, returning the result as a trie.
 */
typeahead.core.word_index = (function typeahead$core$word_index(phrases){
return typeahead.core.transforming_index((function (p1__42979_SHARP_){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$term,x,cljs.core.cst$kw$props,(function (){var or__6417__auto__ = cljs.core.cst$kw$props.cljs$core$IFn$_invoke$arity$1(p1__42979_SHARP_);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()], null);
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$term.cljs$core$IFn$_invoke$arity$1(p1__42979_SHARP_),typeahead.core.term_separator_re));
}),phrases);
});
/**
 * Index a list of phrases, returning the result as a trie.
 */
typeahead.core.phrase_index = (function typeahead$core$phrase_index(phrases){
return typeahead.core.transforming_index((function (p1__42980_SHARP_){
var x__7251__auto__ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__42980_SHARP_,cljs.core.cst$kw$props,(function (){var or__6417__auto__ = cljs.core.cst$kw$props.cljs$core$IFn$_invoke$arity$1(p1__42980_SHARP_);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})());
return cljs.core._conj(cljs.core.List.EMPTY,x__7251__auto__);
}),phrases);
});
typeahead.core.completion_option_component = (function typeahead$core$completion_option_component(data,owner){
if(typeof typeahead.core.t_typeahead$core43006 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
typeahead.core.t_typeahead$core43006 = (function (completion_option_component,data,owner,meta43007){
this.completion_option_component = completion_option_component;
this.data = data;
this.owner = owner;
this.meta43007 = meta43007;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
typeahead.core.t_typeahead$core43006.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_43008,meta43007__$1){
var self__ = this;
var _43008__$1 = this;
return (new typeahead.core.t_typeahead$core43006(self__.completion_option_component,self__.data,self__.owner,meta43007__$1));
});

typeahead.core.t_typeahead$core43006.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_43008){
var self__ = this;
var _43008__$1 = this;
return self__.meta43007;
});

typeahead.core.t_typeahead$core43006.prototype.om$core$IRenderState$ = true;

typeahead.core.t_typeahead$core43006.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__43009 = ({"className": [cljs.core.str("menu-item"),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index.cljs$core$IFn$_invoke$arity$1(state)))?" active":""))].join(''), "onClick": ((function (___$1){
return (function (){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_async_DASH_pending,true);

var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,___$1){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,___$1){
return (function (state_43022){
var state_val_43023 = (state_43022[(1)]);
if((state_val_43023 === (1))){
var inst_43011 = cljs.core.cst$kw$typeahead$core_SLASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_43012 = [cljs.core.cst$kw$typeahead$core_SLASH_select];
var inst_43013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43014 = [cljs.core.cst$kw$entry,cljs.core.cst$kw$completion];
var inst_43015 = (new cljs.core.PersistentVector(null,2,(5),inst_43013,inst_43014,null));
var inst_43016 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,inst_43015);
var inst_43017 = [inst_43016];
var inst_43018 = cljs.core.PersistentHashMap.fromArrays(inst_43012,inst_43017);
var state_43022__$1 = state_43022;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43022__$1,(2),inst_43011,inst_43018);
} else {
if((state_val_43023 === (2))){
var inst_43020 = (state_43022[(2)]);
var state_43022__$1 = state_43022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43022__$1,inst_43020);
} else {
return null;
}
}
});})(c__28576__auto__,___$1))
;
return ((function (switch__28452__auto__,c__28576__auto__,___$1){
return (function() {
var typeahead$core$completion_option_component_$_state_machine__28453__auto__ = null;
var typeahead$core$completion_option_component_$_state_machine__28453__auto____0 = (function (){
var statearr_43027 = [null,null,null,null,null,null,null];
(statearr_43027[(0)] = typeahead$core$completion_option_component_$_state_machine__28453__auto__);

(statearr_43027[(1)] = (1));

return statearr_43027;
});
var typeahead$core$completion_option_component_$_state_machine__28453__auto____1 = (function (state_43022){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_43022);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e43028){if((e43028 instanceof Object)){
var ex__28456__auto__ = e43028;
var statearr_43029_43031 = state_43022;
(statearr_43029_43031[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43022);

return cljs.core.cst$kw$recur;
} else {
throw e43028;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__43032 = state_43022;
state_43022 = G__43032;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
typeahead$core$completion_option_component_$_state_machine__28453__auto__ = function(state_43022){
switch(arguments.length){
case 0:
return typeahead$core$completion_option_component_$_state_machine__28453__auto____0.call(this);
case 1:
return typeahead$core$completion_option_component_$_state_machine__28453__auto____1.call(this,state_43022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
typeahead$core$completion_option_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = typeahead$core$completion_option_component_$_state_machine__28453__auto____0;
typeahead$core$completion_option_component_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = typeahead$core$completion_option_component_$_state_machine__28453__auto____1;
return typeahead$core$completion_option_component_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,___$1))
})();
var state__28578__auto__ = (function (){var statearr_43030 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_43030[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_43030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,___$1))
);

return c__28576__auto__;
});})(___$1))
});
var G__43010 = om.util.force_children(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$entry,cljs.core.cst$kw$completion], null)));
return React.DOM.div(G__43009,G__43010);
});

typeahead.core.t_typeahead$core43006.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$completion_DASH_option_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta43007], null);
});

typeahead.core.t_typeahead$core43006.cljs$lang$type = true;

typeahead.core.t_typeahead$core43006.cljs$lang$ctorStr = "typeahead.core/t_typeahead$core43006";

typeahead.core.t_typeahead$core43006.cljs$lang$ctorPrWriter = (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"typeahead.core/t_typeahead$core43006");
});

typeahead.core.__GT_t_typeahead$core43006 = (function typeahead$core$completion_option_component_$___GT_t_typeahead$core43006(completion_option_component__$1,data__$1,owner__$1,meta43007){
return (new typeahead.core.t_typeahead$core43006(completion_option_component__$1,data__$1,owner__$1,meta43007));
});

}

return (new typeahead.core.t_typeahead$core43006(typeahead$core$completion_option_component,data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
typeahead.core.completion_list_component = (function typeahead$core$completion_list_component(data,owner,p__43035){
var map__43043 = p__43035;
var map__43043__$1 = ((((!((map__43043 == null)))?((((map__43043.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43043.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43043):map__43043);
var show_create = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43043__$1,cljs.core.cst$kw$show_DASH_create);
var result_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43043__$1,cljs.core.cst$kw$result_DASH_limit);
if(typeof typeahead.core.t_typeahead$core43045 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
typeahead.core.t_typeahead$core43045 = (function (completion_list_component,data,owner,p__43035,map__43043,show_create,result_limit,meta43046){
this.completion_list_component = completion_list_component;
this.data = data;
this.owner = owner;
this.p__43035 = p__43035;
this.map__43043 = map__43043;
this.show_create = show_create;
this.result_limit = result_limit;
this.meta43046 = meta43046;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
typeahead.core.t_typeahead$core43045.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__43043,map__43043__$1,show_create,result_limit){
return (function (_43047,meta43046__$1){
var self__ = this;
var _43047__$1 = this;
return (new typeahead.core.t_typeahead$core43045(self__.completion_list_component,self__.data,self__.owner,self__.p__43035,self__.map__43043,self__.show_create,self__.result_limit,meta43046__$1));
});})(map__43043,map__43043__$1,show_create,result_limit))
;

typeahead.core.t_typeahead$core43045.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__43043,map__43043__$1,show_create,result_limit){
return (function (_43047){
var self__ = this;
var _43047__$1 = this;
return self__.meta43046;
});})(map__43043,map__43043__$1,show_create,result_limit))
;

typeahead.core.t_typeahead$core43045.prototype.om$core$IRenderState$ = true;

typeahead.core.t_typeahead$core43045.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__43043,map__43043__$1,show_create,result_limit){
return (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.seq(self__.data)){
var G__43048 = ({"className": "typeahead-menu"});
var G__43049 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(typeahead.core.completion_option_component,cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (G__43048,___$1,map__43043,map__43043__$1,show_create,result_limit){
return (function (p1__43034_SHARP_,p2__43033_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$entry,cljs.core.cst$kw$index],[p2__43033_SHARP_,p1__43034_SHARP_]);
});})(G__43048,___$1,map__43043,map__43043__$1,show_create,result_limit))
,self__.data)),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$typeahead$core_SLASH_chan,cljs.core.cst$kw$typeahead$core_SLASH_chan.cljs$core$IFn$_invoke$arity$1(state)], null),cljs.core.cst$kw$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,cljs.core.mod(cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index.cljs$core$IFn$_invoke$arity$1(state),cljs.core.count(self__.data))], null),cljs.core.cst$kw$key,cljs.core.cst$kw$index], null)));
return React.DOM.div(G__43048,G__43049);
} else {
return null;
}
});})(map__43043,map__43043__$1,show_create,result_limit))
;

typeahead.core.t_typeahead$core43045.getBasis = ((function (map__43043,map__43043__$1,show_create,result_limit){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$completion_DASH_list_DASH_component,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$show_DASH_create,cljs.core.cst$sym$result_DASH_limit], null)], null)], null)))], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__43035,cljs.core.cst$sym$map__43043,cljs.core.cst$sym$show_DASH_create,cljs.core.cst$sym$result_DASH_limit,cljs.core.cst$sym$meta43046], null);
});})(map__43043,map__43043__$1,show_create,result_limit))
;

typeahead.core.t_typeahead$core43045.cljs$lang$type = true;

typeahead.core.t_typeahead$core43045.cljs$lang$ctorStr = "typeahead.core/t_typeahead$core43045";

typeahead.core.t_typeahead$core43045.cljs$lang$ctorPrWriter = ((function (map__43043,map__43043__$1,show_create,result_limit){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"typeahead.core/t_typeahead$core43045");
});})(map__43043,map__43043__$1,show_create,result_limit))
;

typeahead.core.__GT_t_typeahead$core43045 = ((function (map__43043,map__43043__$1,show_create,result_limit){
return (function typeahead$core$completion_list_component_$___GT_t_typeahead$core43045(completion_list_component__$1,data__$1,owner__$1,p__43035__$1,map__43043__$2,show_create__$1,result_limit__$1,meta43046){
return (new typeahead.core.t_typeahead$core43045(completion_list_component__$1,data__$1,owner__$1,p__43035__$1,map__43043__$2,show_create__$1,result_limit__$1,meta43046));
});})(map__43043,map__43043__$1,show_create,result_limit))
;

}

return (new typeahead.core.t_typeahead$core43045(typeahead$core$completion_list_component,data,owner,p__43035,map__43043__$1,show_create,result_limit,cljs.core.PersistentArrayMap.EMPTY));
});
typeahead.core.match_builder = (function typeahead$core$match_builder(data){
if(cljs.core.contains_QMARK_(data,cljs.core.cst$kw$props)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
} else {
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p1__43050_SHARP_){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return [cljs.core.str(p1__43050_SHARP_),cljs.core.str(x)].join('');
}),typeahead$core$match_builder(cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,p1__43050_SHARP_)));
}),cljs.core.array_seq([cljs.core.keys(data)], 0));
}
});
typeahead.core.search_reducer = (function typeahead$core$search_reducer(acc,s){
var r = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,s);
if((r == null)){
return cljs.core.reduced(cljs.core.PersistentArrayMap.EMPTY);
} else {
return r;
}
});
/**
 * Return all possible completions given the index data and a prefix.
 */
typeahead.core.complete = (function typeahead$core$complete(data,prefix){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (p1__43053_SHARP_,p2__43054_SHARP_){
return cljs.core.compare(clojure.string.lower_case(p1__43053_SHARP_),clojure.string.lower_case(p2__43054_SHARP_));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43052_SHARP_){
return [cljs.core.str(prefix),cljs.core.str(p1__43052_SHARP_)].join('');
}),typeahead.core.match_builder(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(typeahead.core.search_reducer,data,cljs.core.seq(clojure.string.lower_case(prefix))))));
});
typeahead.core.props_for_subtree = (function typeahead$core$props_for_subtree(st){
var or__6417__auto__ = cljs.core.cst$kw$props.cljs$core$IFn$_invoke$arity$1(st);
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(st,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["",cljs.core.cst$kw$props], null));
}
});
/**
 * Return the props for search, or nil if search is not in the index.
 */
typeahead.core.ifind = (function typeahead$core$ifind(index,search){
if((search == null)){
return null;
} else {
return typeahead.core.props_for_subtree(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(typeahead.core.search_reducer,index,cljs.core.seq(clojure.string.lower_case(search))));
}
});
typeahead.core.term_separators = (function typeahead$core$term_separators(search){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__43057_SHARP_){
return cljs.core.re_matches(typeahead.core.term_separator_re,cljs.core.second(p1__43057_SHARP_));
}),cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (p1__43055_SHARP_,p2__43056_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__43055_SHARP_,p2__43056_SHARP_],null));
}),cljs.core.seq(clojure.string.lower_case(search)))));
});
typeahead.core.next_separator = (function typeahead$core$next_separator(search,point){
var or__6417__auto__ = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__43058_SHARP_){
return (p1__43058_SHARP_ >= point);
}),typeahead.core.term_separators(search)));
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return cljs.core.count(search);
}
});
/**
 * Return the term at a given cursor position.
 */
typeahead.core.term_at_point = (function typeahead$core$term_at_point(search,point){
var p = typeahead.core.next_separator(search,(function (){var x__6755__auto__ = cljs.core.count(search);
var y__6756__auto__ = point;
return ((x__6755__auto__ < y__6756__auto__) ? x__6755__auto__ : y__6756__auto__);
})());
if(cljs.core.truth_((function (){var or__6417__auto__ = cljs.core.re_matches(typeahead.core.term_separator_re,[cljs.core.str(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(search,(point - (1))))].join(''));
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return (point === (0));
}
})())){
return "";
} else {
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.first(cljs.core.split_at(p,search))),typeahead.core.term_separator_re));
}
});
typeahead.core.splice = (function typeahead$core$splice(all,new$,start,end){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(start,all)),new$),(function (){var tail = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(end,all);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(tail),":")){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),tail);
} else {
return tail;
}
})());
});
typeahead.core.insertion_chars = (function typeahead$core$insertion_chars(insertion){
var qd = (cljs.core.truth_(cljs.core.re_matches(/.*[\ \|].*/,insertion))?[cljs.core.str("\""),cljs.core.str(insertion),cljs.core.str("\"")].join(''):insertion);
return cljs.core.seq(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(insertion),":"))?qd:[cljs.core.str(qd),cljs.core.str(" ")].join('')));
});
typeahead.core.replace_term = (function typeahead$core$replace_term(search,point,selection_end,insertion,multi_term){
if(cljs.core.truth_(multi_term)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(point,selection_end)){
var term = typeahead.core.term_at_point(search,point);
var end = typeahead.core.next_separator(search,point);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,typeahead.core.splice(cljs.core.seq(search),typeahead.core.insertion_chars(insertion),(end - cljs.core.count(term)),end));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,typeahead.core.splice(cljs.core.seq(search),typeahead.core.insertion_chars(insertion),point,selection_end));
}
} else {
return insertion;
}
});
/**
 * Return the field responsible for setting context at point, if any.
 */
typeahead.core.field_context = (function typeahead$core$field_context(search,point){
if((point === (0))){
return null;
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__43060_SHARP_,p2__43059_SHARP_){
var c = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(search,p2__43059_SHARP_);
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c,"|")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c," "))){
return cljs.core.reduced(null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c,":")){
return cljs.core.reduced(typeahead.core.term_at_point(search,p2__43059_SHARP_));
} else {
return null;

}
}
}),null,cljs.core.range.cljs$core$IFn$_invoke$arity$3((point - (1)),(0),(-1)));
}
});
typeahead.core.already_complete_QMARK_ = (function typeahead$core$already_complete_QMARK_(cs,v){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cs),(1))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cs),v));
});
/**
 * Input component with typeahead-style completion.
 */
typeahead.core.typeahead = (function typeahead$core$typeahead(data,owner,p__43063){
var map__43211 = p__43063;
var map__43211__$1 = ((((!((map__43211 == null)))?((((map__43211.cljs$lang$protocol_mask$partition0$ & (64))) || (map__43211.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43211):map__43211);
var create_text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43211__$1,cljs.core.cst$kw$create_DASH_text);
var create_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43211__$1,cljs.core.cst$kw$create_DASH_fn);
var input_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43211__$1,cljs.core.cst$kw$input_DASH_config);
var multi_term = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43211__$1,cljs.core.cst$kw$multi_DASH_term);
if(typeof typeahead.core.t_typeahead$core43213 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IWillUpdate}
 * @implements {cljs.core.IWithMeta}
*/
typeahead.core.t_typeahead$core43213 = (function (typeahead,data,owner,p__43063,map__43211,create_text,create_fn,input_config,multi_term,meta43214){
this.typeahead = typeahead;
this.data = data;
this.owner = owner;
this.p__43063 = p__43063;
this.map__43211 = map__43211;
this.create_text = create_text;
this.create_fn = create_fn;
this.input_config = input_config;
this.multi_term = multi_term;
this.meta43214 = meta43214;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
typeahead.core.t_typeahead$core43213.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (_43215,meta43214__$1){
var self__ = this;
var _43215__$1 = this;
return (new typeahead.core.t_typeahead$core43213(self__.typeahead,self__.data,self__.owner,self__.p__43063,self__.map__43211,self__.create_text,self__.create_fn,self__.input_config,self__.multi_term,meta43214__$1));
});})(map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core43213.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (_43215){
var self__ = this;
var _43215__$1 = this;
return self__.meta43214;
});})(map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core43213.prototype.om$core$IInitState$ = true;

typeahead.core.t_typeahead$core43213.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$typeahead$core_SLASH_value,"",cljs.core.cst$kw$typeahead$core_SLASH_int_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1))),cljs.core.cst$kw$typeahead$core_SLASH_completion_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,(0)], null);
});})(map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core43213.prototype.om$core$IWillUpdate$ = true;

typeahead.core.t_typeahead$core43213.prototype.om$core$IWillUpdate$will_update$arity$3 = ((function (map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (_,props,state){
var self__ = this;
var ___$1 = this;
var si = om.core.get_node.cljs$core$IFn$_invoke$arity$2(self__.owner,"search-input");
var ctx = typeahead.core.field_context(cljs.core.cst$kw$typeahead$core_SLASH_value.cljs$core$IFn$_invoke$arity$1(state),si.selectionStart);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$typeahead$core_SLASH_context.cljs$core$IFn$_invoke$arity$1(state),ctx)){
} else {
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_context,ctx);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_completions,null);

var cfn_43358 = cljs.core.cst$kw$completion_DASH_fn.cljs$core$IFn$_invoke$arity$1(typeahead.core.ifind(self__.data,ctx));
var and__6405__auto___43359 = cfn_43358;
if(cljs.core.truth_(and__6405__auto___43359)){
var G__43216_43360 = clojure.string.lower_case(ctx);
var G__43217_43361 = cljs.core.cst$kw$typeahead$core_SLASH_completion_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
(cfn_43358.cljs$core$IFn$_invoke$arity$2 ? cfn_43358.cljs$core$IFn$_invoke$arity$2(G__43216_43360,G__43217_43361) : cfn_43358.call(null,G__43216_43360,G__43217_43361));
} else {
}
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_term,(cljs.core.truth_(self__.multi_term)?typeahead.core.term_at_point:cljs.core.identity).call(null,cljs.core.cst$kw$typeahead$core_SLASH_value.cljs$core$IFn$_invoke$arity$1(state),si.selectionStart));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(document.activeElement,si)){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_is_DASH_focused,true);
} else {
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,si,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,si,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (state_43223){
var state_val_43224 = (state_43223[(1)]);
if((state_val_43224 === (1))){
var inst_43218 = cljs.core.async.timeout((100));
var state_43223__$1 = state_43223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43223__$1,(2),inst_43218);
} else {
if((state_val_43224 === (2))){
var inst_43220 = (state_43223[(2)]);
var inst_43221 = om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_is_DASH_focused,false);
var state_43223__$1 = (function (){var statearr_43225 = state_43223;
(statearr_43225[(7)] = inst_43220);

return statearr_43225;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_43223__$1,inst_43221);
} else {
return null;
}
}
});})(c__28576__auto__,si,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;
return ((function (switch__28452__auto__,c__28576__auto__,si,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function() {
var typeahead$core$typeahead_$_state_machine__28453__auto__ = null;
var typeahead$core$typeahead_$_state_machine__28453__auto____0 = (function (){
var statearr_43229 = [null,null,null,null,null,null,null,null];
(statearr_43229[(0)] = typeahead$core$typeahead_$_state_machine__28453__auto__);

(statearr_43229[(1)] = (1));

return statearr_43229;
});
var typeahead$core$typeahead_$_state_machine__28453__auto____1 = (function (state_43223){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_43223);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e43230){if((e43230 instanceof Object)){
var ex__28456__auto__ = e43230;
var statearr_43231_43362 = state_43223;
(statearr_43231_43362[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43223);

return cljs.core.cst$kw$recur;
} else {
throw e43230;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__43363 = state_43223;
state_43223 = G__43363;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
typeahead$core$typeahead_$_state_machine__28453__auto__ = function(state_43223){
switch(arguments.length){
case 0:
return typeahead$core$typeahead_$_state_machine__28453__auto____0.call(this);
case 1:
return typeahead$core$typeahead_$_state_machine__28453__auto____1.call(this,state_43223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
typeahead$core$typeahead_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = typeahead$core$typeahead_$_state_machine__28453__auto____0;
typeahead$core$typeahead_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = typeahead$core$typeahead_$_state_machine__28453__auto____1;
return typeahead$core$typeahead_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,si,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
})();
var state__28578__auto__ = (function (){var statearr_43232 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_43232[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_43232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,si,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
);

return c__28576__auto__;
}
});})(map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core43213.prototype.om$core$IWillMount$ = true;

typeahead.core.t_typeahead$core43213.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (_){
var self__ = this;
var ___$1 = this;
var ic = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_int_DASH_chan);
var cc = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_completion_DASH_chan);
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,ic,cc,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,ic,cc,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (state_43285){
var state_val_43286 = (state_43285[(1)]);
if((state_val_43286 === (7))){
var inst_43279 = (state_43285[(2)]);
var inst_43280 = om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,(0));
var state_43285__$1 = (function (){var statearr_43287 = state_43285;
(statearr_43287[(7)] = inst_43280);

(statearr_43287[(8)] = inst_43279);

return statearr_43287;
})();
var statearr_43288_43364 = state_43285__$1;
(statearr_43288_43364[(2)] = null);

(statearr_43288_43364[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (1))){
var state_43285__$1 = state_43285;
var statearr_43289_43365 = state_43285__$1;
(statearr_43289_43365[(2)] = null);

(statearr_43289_43365[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (4))){
var inst_43241 = (state_43285[(2)]);
var inst_43242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43241,(0),null);
var inst_43243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43241,(1),null);
var inst_43244 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43243,ic);
var state_43285__$1 = (function (){var statearr_43290 = state_43285;
(statearr_43290[(9)] = inst_43242);

return statearr_43290;
})();
if(inst_43244){
var statearr_43291_43366 = state_43285__$1;
(statearr_43291_43366[(1)] = (5));

} else {
var statearr_43292_43367 = state_43285__$1;
(statearr_43292_43367[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (15))){
var state_43285__$1 = state_43285;
var statearr_43293_43368 = state_43285__$1;
(statearr_43293_43368[(2)] = null);

(statearr_43293_43368[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (13))){
var inst_43254 = (state_43285[(10)]);
var inst_43253 = (state_43285[(11)]);
var inst_43251 = (state_43285[(12)]);
var inst_43252 = (state_43285[(13)]);
var inst_43261 = (state_43285[(14)]);
var inst_43259 = (state_43285[(2)]);
var inst_43260 = [cljs.core.str(inst_43254),cljs.core.str(inst_43259)].join('');
var inst_43261__$1 = typeahead.core.replace_term(inst_43251,inst_43252,inst_43253,inst_43260,self__.multi_term);
var inst_43262 = om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_value,inst_43261__$1);
var inst_43263 = om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_async_DASH_pending,false);
var inst_43264 = cljs.core.cst$kw$onChange.cljs$core$IFn$_invoke$arity$1(self__.input_config);
var state_43285__$1 = (function (){var statearr_43294 = state_43285;
(statearr_43294[(14)] = inst_43261__$1);

(statearr_43294[(15)] = inst_43263);

(statearr_43294[(16)] = inst_43262);

return statearr_43294;
})();
if(cljs.core.truth_(inst_43264)){
var statearr_43295_43369 = state_43285__$1;
(statearr_43295_43369[(1)] = (14));

} else {
var statearr_43296_43370 = state_43285__$1;
(statearr_43296_43370[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (6))){
var inst_43242 = (state_43285[(9)]);
var inst_43277 = om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_completions,inst_43242);
var state_43285__$1 = state_43285;
var statearr_43297_43371 = state_43285__$1;
(statearr_43297_43371[(2)] = inst_43277);

(statearr_43297_43371[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (3))){
var inst_43283 = (state_43285[(2)]);
var state_43285__$1 = state_43285;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43285__$1,inst_43283);
} else {
if((state_val_43286 === (12))){
var state_43285__$1 = state_43285;
var statearr_43298_43372 = state_43285__$1;
(statearr_43298_43372[(2)] = "");

(statearr_43298_43372[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (2))){
var inst_43237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43238 = [ic,cc];
var inst_43239 = (new cljs.core.PersistentVector(null,2,(5),inst_43237,inst_43238,null));
var state_43285__$1 = state_43285;
return cljs.core.async.ioc_alts_BANG_(state_43285__$1,(4),inst_43239);
} else {
if((state_val_43286 === (11))){
var state_43285__$1 = state_43285;
var statearr_43299_43373 = state_43285__$1;
(statearr_43299_43373[(2)] = ":");

(statearr_43299_43373[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (9))){
var state_43285__$1 = state_43285;
var statearr_43300_43374 = state_43285__$1;
(statearr_43300_43374[(2)] = null);

(statearr_43300_43374[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (5))){
var inst_43242 = (state_43285[(9)]);
var inst_43246 = cljs.core.cst$kw$typeahead$core_SLASH_select.cljs$core$IFn$_invoke$arity$1(inst_43242);
var state_43285__$1 = state_43285;
if(cljs.core.truth_(inst_43246)){
var statearr_43301_43375 = state_43285__$1;
(statearr_43301_43375[(1)] = (8));

} else {
var statearr_43302_43376 = state_43285__$1;
(statearr_43302_43376[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (14))){
var inst_43261 = (state_43285[(14)]);
var inst_43266 = cljs.core.cst$kw$onChange.cljs$core$IFn$_invoke$arity$1(self__.input_config);
var inst_43267 = (inst_43266.cljs$core$IFn$_invoke$arity$1 ? inst_43266.cljs$core$IFn$_invoke$arity$1(inst_43261) : inst_43266.call(null,inst_43261));
var state_43285__$1 = state_43285;
var statearr_43303_43377 = state_43285__$1;
(statearr_43303_43377[(2)] = inst_43267);

(statearr_43303_43377[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (16))){
var inst_43270 = (state_43285[(2)]);
var inst_43271 = om.core.get_node.cljs$core$IFn$_invoke$arity$2(self__.owner,"search-input");
var inst_43272 = inst_43271.focus();
var state_43285__$1 = (function (){var statearr_43304 = state_43285;
(statearr_43304[(17)] = inst_43270);

return statearr_43304;
})();
var statearr_43305_43378 = state_43285__$1;
(statearr_43305_43378[(2)] = inst_43272);

(statearr_43305_43378[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (10))){
var inst_43275 = (state_43285[(2)]);
var state_43285__$1 = state_43285;
var statearr_43306_43379 = state_43285__$1;
(statearr_43306_43379[(2)] = inst_43275);

(statearr_43306_43379[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43286 === (8))){
var inst_43242 = (state_43285[(9)]);
var inst_43248 = om.core.get_node.cljs$core$IFn$_invoke$arity$2(self__.owner,"search-input");
var inst_43249 = cljs.core.cst$kw$typeahead$core_SLASH_select.cljs$core$IFn$_invoke$arity$1(inst_43242);
var inst_43250 = typeahead.core.ifind(self__.data,inst_43249);
var inst_43251 = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_value);
var inst_43252 = inst_43248.selectionStart;
var inst_43253 = inst_43248.selectionEnd;
var inst_43254 = cljs.core.cst$kw$typeahead$core_SLASH_select.cljs$core$IFn$_invoke$arity$1(inst_43242);
var inst_43255 = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(inst_43250);
var state_43285__$1 = (function (){var statearr_43307 = state_43285;
(statearr_43307[(10)] = inst_43254);

(statearr_43307[(11)] = inst_43253);

(statearr_43307[(12)] = inst_43251);

(statearr_43307[(13)] = inst_43252);

return statearr_43307;
})();
if(cljs.core.truth_(inst_43255)){
var statearr_43308_43380 = state_43285__$1;
(statearr_43308_43380[(1)] = (11));

} else {
var statearr_43309_43381 = state_43285__$1;
(statearr_43309_43381[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__28576__auto__,ic,cc,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;
return ((function (switch__28452__auto__,c__28576__auto__,ic,cc,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function() {
var typeahead$core$typeahead_$_state_machine__28453__auto__ = null;
var typeahead$core$typeahead_$_state_machine__28453__auto____0 = (function (){
var statearr_43313 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43313[(0)] = typeahead$core$typeahead_$_state_machine__28453__auto__);

(statearr_43313[(1)] = (1));

return statearr_43313;
});
var typeahead$core$typeahead_$_state_machine__28453__auto____1 = (function (state_43285){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_43285);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e43314){if((e43314 instanceof Object)){
var ex__28456__auto__ = e43314;
var statearr_43315_43382 = state_43285;
(statearr_43315_43382[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43285);

return cljs.core.cst$kw$recur;
} else {
throw e43314;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__43383 = state_43285;
state_43285 = G__43383;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
typeahead$core$typeahead_$_state_machine__28453__auto__ = function(state_43285){
switch(arguments.length){
case 0:
return typeahead$core$typeahead_$_state_machine__28453__auto____0.call(this);
case 1:
return typeahead$core$typeahead_$_state_machine__28453__auto____1.call(this,state_43285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
typeahead$core$typeahead_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = typeahead$core$typeahead_$_state_machine__28453__auto____0;
typeahead$core$typeahead_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = typeahead$core$typeahead_$_state_machine__28453__auto____1;
return typeahead$core$typeahead_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,ic,cc,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
})();
var state__28578__auto__ = (function (){var statearr_43316 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_43316[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_43316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,ic,cc,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
);

return c__28576__auto__;
});})(map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core43213.prototype.om$core$IRenderState$ = true;

typeahead.core.t_typeahead$core43213.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (_,state){
var self__ = this;
var ___$1 = this;
var v = cljs.core.cst$kw$typeahead$core_SLASH_term.cljs$core$IFn$_invoke$arity$1(state);
var ctx = cljs.core.cst$kw$typeahead$core_SLASH_completions.cljs$core$IFn$_invoke$arity$1(state);
var G__43317 = ({"className": "typeahead"});
var G__43318 = om.util.force_children((function (){var G__43321 = cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.input_config,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$value,cljs.core.cst$kw$typeahead$core_SLASH_value.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$ref,"search-input",cljs.core.cst$kw$disabled,(cljs.core.truth_(cljs.core.cst$kw$disabled.cljs$core$IFn$_invoke$arity$1(state))?"disabled":""),cljs.core.cst$kw$onKeyDown,((function (G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (e){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(e.keyCode,(38))){
om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,cljs.core.dec);

e.preventDefault();

e.stopPropagation();

return om.core.refresh_BANG_(self__.owner);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(e.keyCode,(40))){
om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,cljs.core.inc);

e.preventDefault();

e.stopPropagation();

return om.core.refresh_BANG_(self__.owner);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(e.keyCode,(13))){
e.preventDefault();

e.stopPropagation();

if(!((cljs.core.empty_QMARK_(v)) && (cljs.core.empty_QMARK_(ctx)))){
var comps_43384 = typeahead.core.complete((function (){var or__6417__auto__ = (function (){var and__6405__auto__ = cljs.core.cst$kw$typeahead$core_SLASH_context.cljs$core$IFn$_invoke$arity$1(state);
if(cljs.core.truth_(and__6405__auto__)){
return ctx;
} else {
return and__6405__auto__;
}
})();
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return self__.data;
}
})(),v);
if(cljs.core.seq(comps_43384)){
var c__28576__auto___43385 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto___43385,comps_43384,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto___43385,comps_43384,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (state_43333){
var state_val_43334 = (state_43333[(1)]);
if((state_val_43334 === (1))){
var inst_43322 = cljs.core.cst$kw$typeahead$core_SLASH_int_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_43323 = [cljs.core.cst$kw$typeahead$core_SLASH_select];
var inst_43324 = cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index.cljs$core$IFn$_invoke$arity$1(state);
var inst_43325 = cljs.core.count(comps_43384);
var inst_43326 = cljs.core.mod(inst_43324,inst_43325);
var inst_43327 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(comps_43384,inst_43326);
var inst_43328 = [inst_43327];
var inst_43329 = cljs.core.PersistentHashMap.fromArrays(inst_43323,inst_43328);
var state_43333__$1 = state_43333;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43333__$1,(2),inst_43322,inst_43329);
} else {
if((state_val_43334 === (2))){
var inst_43331 = (state_43333[(2)]);
var state_43333__$1 = state_43333;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43333__$1,inst_43331);
} else {
return null;
}
}
});})(c__28576__auto___43385,comps_43384,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;
return ((function (switch__28452__auto__,c__28576__auto___43385,comps_43384,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function() {
var typeahead$core$typeahead_$_state_machine__28453__auto__ = null;
var typeahead$core$typeahead_$_state_machine__28453__auto____0 = (function (){
var statearr_43338 = [null,null,null,null,null,null,null];
(statearr_43338[(0)] = typeahead$core$typeahead_$_state_machine__28453__auto__);

(statearr_43338[(1)] = (1));

return statearr_43338;
});
var typeahead$core$typeahead_$_state_machine__28453__auto____1 = (function (state_43333){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_43333);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e43339){if((e43339 instanceof Object)){
var ex__28456__auto__ = e43339;
var statearr_43340_43386 = state_43333;
(statearr_43340_43386[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43333);

return cljs.core.cst$kw$recur;
} else {
throw e43339;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__43387 = state_43333;
state_43333 = G__43387;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
typeahead$core$typeahead_$_state_machine__28453__auto__ = function(state_43333){
switch(arguments.length){
case 0:
return typeahead$core$typeahead_$_state_machine__28453__auto____0.call(this);
case 1:
return typeahead$core$typeahead_$_state_machine__28453__auto____1.call(this,state_43333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
typeahead$core$typeahead_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = typeahead$core$typeahead_$_state_machine__28453__auto____0;
typeahead$core$typeahead_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = typeahead$core$typeahead_$_state_machine__28453__auto____1;
return typeahead$core$typeahead_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto___43385,comps_43384,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
})();
var state__28578__auto__ = (function (){var statearr_43341 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_43341[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto___43385);

return statearr_43341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto___43385,comps_43384,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
);

} else {
if(cljs.core.truth_(cljs.core.cst$kw$onKeyDown.cljs$core$IFn$_invoke$arity$1(self__.input_config))){
cljs.core.cst$kw$onKeyDown.cljs$core$IFn$_invoke$arity$1(self__.input_config).call(null,e);
} else {
}
}
} else {
if(cljs.core.truth_(cljs.core.cst$kw$onKeyDown.cljs$core$IFn$_invoke$arity$1(self__.input_config))){
cljs.core.cst$kw$onKeyDown.cljs$core$IFn$_invoke$arity$1(self__.input_config).call(null,e);
} else {
}
}

return om.core.refresh_BANG_(self__.owner);
} else {
return null;
}
}
}
});})(G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
,cljs.core.cst$kw$onChange,((function (G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (p1__43061_SHARP_){
var tv = p1__43061_SHARP_.target.value;
if(cljs.core.truth_(cljs.core.cst$kw$onChange.cljs$core$IFn$_invoke$arity$1(self__.input_config))){
cljs.core.cst$kw$onChange.cljs$core$IFn$_invoke$arity$1(self__.input_config).call(null,tv);
} else {
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_value,tv);

if(cljs.core.truth_(tv)){
var c__28576__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__28576__auto__,tv,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (){
var f__28577__auto__ = (function (){var switch__28452__auto__ = ((function (c__28576__auto__,tv,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (state_43346){
var state_val_43347 = (state_43346[(1)]);
if((state_val_43347 === (1))){
var inst_43342 = cljs.core.cst$kw$typeahead$core_SLASH_int_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var state_43346__$1 = state_43346;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43346__$1,(2),inst_43342,tv);
} else {
if((state_val_43347 === (2))){
var inst_43344 = (state_43346[(2)]);
var state_43346__$1 = state_43346;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43346__$1,inst_43344);
} else {
return null;
}
}
});})(c__28576__auto__,tv,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;
return ((function (switch__28452__auto__,c__28576__auto__,tv,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function() {
var typeahead$core$typeahead_$_state_machine__28453__auto__ = null;
var typeahead$core$typeahead_$_state_machine__28453__auto____0 = (function (){
var statearr_43351 = [null,null,null,null,null,null,null];
(statearr_43351[(0)] = typeahead$core$typeahead_$_state_machine__28453__auto__);

(statearr_43351[(1)] = (1));

return statearr_43351;
});
var typeahead$core$typeahead_$_state_machine__28453__auto____1 = (function (state_43346){
while(true){
var ret_value__28454__auto__ = (function (){try{while(true){
var result__28455__auto__ = switch__28452__auto__(state_43346);
if(cljs.core.keyword_identical_QMARK_(result__28455__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__28455__auto__;
}
break;
}
}catch (e43352){if((e43352 instanceof Object)){
var ex__28456__auto__ = e43352;
var statearr_43353_43388 = state_43346;
(statearr_43353_43388[(5)] = ex__28456__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43346);

return cljs.core.cst$kw$recur;
} else {
throw e43352;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28454__auto__,cljs.core.cst$kw$recur)){
var G__43389 = state_43346;
state_43346 = G__43389;
continue;
} else {
return ret_value__28454__auto__;
}
break;
}
});
typeahead$core$typeahead_$_state_machine__28453__auto__ = function(state_43346){
switch(arguments.length){
case 0:
return typeahead$core$typeahead_$_state_machine__28453__auto____0.call(this);
case 1:
return typeahead$core$typeahead_$_state_machine__28453__auto____1.call(this,state_43346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
typeahead$core$typeahead_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$0 = typeahead$core$typeahead_$_state_machine__28453__auto____0;
typeahead$core$typeahead_$_state_machine__28453__auto__.cljs$core$IFn$_invoke$arity$1 = typeahead$core$typeahead_$_state_machine__28453__auto____1;
return typeahead$core$typeahead_$_state_machine__28453__auto__;
})()
;})(switch__28452__auto__,c__28576__auto__,tv,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
})();
var state__28578__auto__ = (function (){var statearr_43354 = (f__28577__auto__.cljs$core$IFn$_invoke$arity$0 ? f__28577__auto__.cljs$core$IFn$_invoke$arity$0() : f__28577__auto__.call(null));
(statearr_43354[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__28576__auto__);

return statearr_43354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28578__auto__);
});})(c__28576__auto__,tv,G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
);

return c__28576__auto__;
} else {
return null;
}
});})(G__43317,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
], null)], 0)));
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__43321) : om.dom.input.call(null,G__43321));
})());
var G__43319 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$disabled.cljs$core$IFn$_invoke$arity$1(state))?(function (){var G__43355 = ({"className": "typeahead-spinner"});
var G__43356 = om.util.force_children((function (){var G__43357 = ({"src": "images/spinner.gif", "height": "16", "width": "16"});
return React.DOM.img(G__43357);
})());
return React.DOM.div(G__43355,G__43356);
})():null));
var G__43320 = om.util.force_children((((cljs.core.empty_QMARK_(v)) && (cljs.core.empty_QMARK_(ctx)))?null:(function (){var completions = typeahead.core.complete((function (){var or__6417__auto__ = (function (){var and__6405__auto__ = cljs.core.cst$kw$typeahead$core_SLASH_context.cljs$core$IFn$_invoke$arity$1(state);
if(cljs.core.truth_(and__6405__auto__)){
return ctx;
} else {
return and__6405__auto__;
}
})();
if(cljs.core.truth_(or__6417__auto__)){
return or__6417__auto__;
} else {
return self__.data;
}
})(),v);
if(cljs.core.truth_((function (){var and__6405__auto__ = cljs.core.not(typeahead.core.already_complete_QMARK_(completions,v));
if(and__6405__auto__){
return cljs.core.cst$kw$typeahead$core_SLASH_is_DASH_focused.cljs$core$IFn$_invoke$arity$1(state);
} else {
return and__6405__auto__;
}
})())){
return om.core.build.cljs$core$IFn$_invoke$arity$3(typeahead.core.completion_list_component,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (completions,G__43317,G__43318,G__43319,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (p1__43062_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$completion,cljs.core.cst$kw$context],[p1__43062_SHARP_,null]);
});})(completions,G__43317,G__43318,G__43319,v,ctx,___$1,map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
,completions),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$typeahead$core_SLASH_chan,cljs.core.cst$kw$typeahead$core_SLASH_int_DASH_chan.cljs$core$IFn$_invoke$arity$1(state)], null),cljs.core.cst$kw$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index.cljs$core$IFn$_invoke$arity$1(state)], null),cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$show_DASH_create,!((self__.create_fn == null))], null)], null));
} else {
return null;
}
})()));
return React.DOM.div(G__43317,G__43318,G__43319,G__43320);
});})(map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core43213.getBasis = ((function (map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$typeahead,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keys,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$create_DASH_text,cljs.core.cst$sym$create_DASH_fn,cljs.core.cst$sym$input_DASH_config,cljs.core.cst$sym$multi_DASH_term], null)], null)], null))),cljs.core.cst$kw$doc,"Input component with typeahead-style completion."], null)),cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__43063,cljs.core.cst$sym$map__43211,cljs.core.cst$sym$create_DASH_text,cljs.core.cst$sym$create_DASH_fn,cljs.core.cst$sym$input_DASH_config,cljs.core.cst$sym$multi_DASH_term,cljs.core.cst$sym$meta43214], null);
});})(map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core43213.cljs$lang$type = true;

typeahead.core.t_typeahead$core43213.cljs$lang$ctorStr = "typeahead.core/t_typeahead$core43213";

typeahead.core.t_typeahead$core43213.cljs$lang$ctorPrWriter = ((function (map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function (this__7023__auto__,writer__7024__auto__,opt__7025__auto__){
return cljs.core._write(writer__7024__auto__,"typeahead.core/t_typeahead$core43213");
});})(map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.__GT_t_typeahead$core43213 = ((function (map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term){
return (function typeahead$core$typeahead_$___GT_t_typeahead$core43213(typeahead__$2,data__$1,owner__$1,p__43063__$1,map__43211__$2,create_text__$1,create_fn__$1,input_config__$1,multi_term__$1,meta43214){
return (new typeahead.core.t_typeahead$core43213(typeahead__$2,data__$1,owner__$1,p__43063__$1,map__43211__$2,create_text__$1,create_fn__$1,input_config__$1,multi_term__$1,meta43214));
});})(map__43211,map__43211__$1,create_text,create_fn,input_config,multi_term))
;

}

return (new typeahead.core.t_typeahead$core43213(typeahead$core$typeahead,data,owner,p__43063,map__43211__$1,create_text,create_fn,input_config,multi_term,cljs.core.PersistentArrayMap.EMPTY));
});
