// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.bulk_import.mapper');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async');
goog.require('om.core');
goog.require('camelot.util.data');
goog.require('camelot.translation.core');
goog.require('camelot.component.util');
goog.require('camelot.util.model');
goog.require('camelot.component.upload');
goog.require('om.dom');
goog.require('camelot.nav');
goog.require('camelot.state');
goog.require('camelot.rest');
goog.require('clojure.string');
camelot.component.bulk_import.mapper.bulk_import_ui_sample_image = "images/bulk-import-sample.png";
camelot.component.bulk_import.mapper.get_import_data = (function camelot$component$bulk_import$mapper$get_import_data(data){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$file_DASH_data,cljs.core.deref(cljs.core.cst$kw$file_DASH_data.cljs$core$IFn$_invoke$arity$1(data)),cljs.core.cst$kw$mappings,cljs.core.deref(cljs.core.cst$kw$mappings.cljs$core$IFn$_invoke$arity$1(data)),cljs.core.cst$kw$survey_DASH_id,camelot.state.get_survey_id()], null);
});
camelot.component.bulk_import.mapper.submit_mappings = (function camelot$component$bulk_import$mapper$submit_mappings(data){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$show_DASH_import_DASH_status_DASH_dialog,true);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$initialising);

return camelot.rest.post_x.cljs$core$IFn$_invoke$arity$4("/surveys/bulkimport/import",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,camelot.component.bulk_import.mapper.get_import_data(data)], null),(function (p1__25189_SHARP_){
if(((cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__25189_SHARP_) == null)) || (cljs.core.empty_QMARK_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__25189_SHARP_)))){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$active);
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$validation_DASH_problem);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$import_DASH_status_DASH_details,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__25189_SHARP_));
}
}),(function (p1__25190_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$failed);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$import_DASH_status_DASH_details,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$errors,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__25190_SHARP_),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(p1__25190_SHARP_)], null));
}));
});
camelot.component.bulk_import.mapper.upload_success_handler = (function camelot$component$bulk_import$mapper$upload_success_handler(data,r){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$upload_DASH_pending,false);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$column_DASH_properties,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(r,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$response,cljs.core.cst$kw$column_DASH_properties], null)));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$file_DASH_data,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(r,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$response,cljs.core.cst$kw$file_DASH_data], null)));

if(((cljs.core.cst$kw$mappings.cljs$core$IFn$_invoke$arity$1(data) == null)) || (cljs.core.empty_QMARK_(cljs.core.deref(cljs.core.cst$kw$mappings.cljs$core$IFn$_invoke$arity$1(data))))){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$mappings,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(r,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$response,cljs.core.cst$kw$default_DASH_mappings], null)));
} else {
return null;
}
});
camelot.component.bulk_import.mapper.upload_pending_handler = (function camelot$component$bulk_import$mapper$upload_pending_handler(data,r){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$upload_DASH_pending,true);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$upload_DASH_failed,null);
});
camelot.component.bulk_import.mapper.field_mapping_option = (function camelot$component$bulk_import$mapper$field_mapping_option(data,owner){
if(typeof camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191 = (function (data,owner,meta25192){
this.data = data;
this.owner = owner;
this.meta25192 = meta25192;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25193,meta25192__$1){
var self__ = this;
var _25193__$1 = this;
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191(self__.data,self__.owner,meta25192__$1));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25193){
var self__ = this;
var _25193__$1 = this;
return self__.meta25192;
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__25194 = ({"value": cljs.core.first(self__.data)});
var G__25195 = cljs.core.first(self__.data);
return (om.dom.option.cljs$core$IFn$_invoke$arity$2 ? om.dom.option.cljs$core$IFn$_invoke$arity$2(G__25194,G__25195) : om.dom.option.call(null,G__25194,G__25195));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta25192], null);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191.cljs$lang$type = true;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191.cljs$lang$ctorStr = "camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25191";

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25191");
});

camelot.component.bulk_import.mapper.__GT_t_camelot$component$bulk_import$mapper25191 = (function camelot$component$bulk_import$mapper$field_mapping_option_$___GT_t_camelot$component$bulk_import$mapper25191(data__$1,owner__$1,meta25192){
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191(data__$1,owner__$1,meta25192));
});

}

return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25191(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.bulk_import.mapper.sighting_fields = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$taxonomy_DASH_genus,cljs.core.cst$kw$taxonomy_DASH_species,cljs.core.cst$kw$sighting_DASH_quantity,cljs.core.cst$kw$taxonomy_DASH_common_DASH_name], null);
camelot.component.bulk_import.mapper.sightings_partially_mapped_QMARK_ = (function camelot$component$bulk_import$mapper$sightings_partially_mapped_QMARK_(mappings){
var mapped_count = cljs.core.count(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.vals(cljs.core.select_keys(mappings,camelot.component.bulk_import.mapper.sighting_fields))));
return !(((mapped_count === (0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mapped_count,cljs.core.count(camelot.component.bulk_import.mapper.sighting_fields))));
});
/**
 * Pretty human-readable list of sighting fields.
 */
camelot.component.bulk_import.mapper.translated_sighting_field_names = (function camelot$component$bulk_import$mapper$translated_sighting_field_names(){
return camelot.translation.core.list_to_user_string(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25196_SHARP_){
return camelot.translation.core.translate(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("report/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(p1__25196_SHARP_))].join('')));
}),camelot.component.bulk_import.mapper.sighting_fields));
});
/**
 * Return a summary of the validation state
 */
camelot.component.bulk_import.mapper.validation_summary = (function camelot$component$bulk_import$mapper$validation_summary(problem,mappings){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(problem,cljs.core.cst$kw$mismatch)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$result,cljs.core.cst$kw$fail,cljs.core.cst$kw$reason,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_validation_DASH_mismatch)], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(problem,cljs.core.cst$kw$missing)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$result,cljs.core.cst$kw$fail,cljs.core.cst$kw$reason,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_validation_DASH_missing)], null);
} else {
if(cljs.core.truth_(camelot.component.bulk_import.mapper.sightings_partially_mapped_QMARK_(mappings))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$result,cljs.core.cst$kw$fail,cljs.core.cst$kw$reason,camelot.translation.core.translate.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_sightings_DASH_partially_DASH_mapped,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([camelot.component.bulk_import.mapper.translated_sighting_field_names()], 0))], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$result,cljs.core.cst$kw$pass,cljs.core.cst$kw$reason,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_validation_DASH_passed)], null);

}
}
}
});
camelot.component.bulk_import.mapper.cancel_button_component = (function camelot$component$bulk_import$mapper$cancel_button_component(data,owner){
if(typeof camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197 = (function (data,owner,meta25198){
this.data = data;
this.owner = owner;
this.meta25198 = meta25198;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25199,meta25198__$1){
var self__ = this;
var _25199__$1 = this;
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197(self__.data,self__.owner,meta25198__$1));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25199){
var self__ = this;
var _25199__$1 = this;
return self__.meta25198;
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$upload_DASH_pending.cljs$core$IFn$_invoke$arity$1(self__.data))){
return null;
} else {
var G__25200 = ({"className": "btn btn-default", "onClick": ((function (___$1){
return (function (){
return camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$1((2));
});})(___$1))
});
var G__25201 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$column_DASH_properties.cljs$core$IFn$_invoke$arity$1(self__.data))?camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_cancel):(function (){var G__25202 = null;
var G__25203 = om.util.force_children((function (){var G__25206 = ({"className": "fa fa-mail-reply"});
return React.DOM.span(G__25206);
})());
var G__25204 = om.util.force_children(" ");
var G__25205 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_back));
return React.DOM.span(G__25202,G__25203,G__25204,G__25205);
})()));
return React.DOM.button(G__25200,G__25201);
}
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta25198], null);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197.cljs$lang$type = true;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197.cljs$lang$ctorStr = "camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25197";

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25197");
});

camelot.component.bulk_import.mapper.__GT_t_camelot$component$bulk_import$mapper25197 = (function camelot$component$bulk_import$mapper$cancel_button_component_$___GT_t_camelot$component$bulk_import$mapper25197(data__$1,owner__$1,meta25198){
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197(data__$1,owner__$1,meta25198));
});

}

return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25197(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.bulk_import.mapper.field_mapping_component = (function camelot$component$bulk_import$mapper$field_mapping_component(data,owner,p__25208){
var map__25209 = p__25208;
var map__25209__$1 = ((((!((map__25209 == null)))?((((map__25209.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25209.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25209):map__25209);
var required = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25209__$1,cljs.core.cst$kw$required);
if(typeof camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211 = (function (data,owner,p__25208,map__25209,required,meta25212){
this.data = data;
this.owner = owner;
this.p__25208 = p__25208;
this.map__25209 = map__25209;
this.required = required;
this.meta25212 = meta25212;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__25209,map__25209__$1,required){
return (function (_25213,meta25212__$1){
var self__ = this;
var _25213__$1 = this;
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211(self__.data,self__.owner,self__.p__25208,self__.map__25209,self__.required,meta25212__$1));
});})(map__25209,map__25209__$1,required))
;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__25209,map__25209__$1,required){
return (function (_25213){
var self__ = this;
var _25213__$1 = this;
return self__.meta25212;
});})(map__25209,map__25209__$1,required))
;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__25209,map__25209__$1,required){
return (function (_,state){
var self__ = this;
var ___$1 = this;
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(self__.data);
var column_properties = cljs.core.cst$kw$column_DASH_properties.cljs$core$IFn$_invoke$arity$1(self__.data);
var mappings = cljs.core.cst$kw$mappings.cljs$core$IFn$_invoke$arity$1(self__.data);
var G__25214 = null;
var G__25215 = om.util.force_children((function (){var G__25218 = ({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("field-label"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(self__.required)?" required":""))].join('')});
var G__25219 = om.util.force_children((function (){var or__6624__auto__ = cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(cljs.core.second(field));
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return camelot.translation.core.translate([cljs.core.str.cljs$core$IFn$_invoke$arity$1("report/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.first(field)))].join(''));
}
})());
return React.DOM.label(G__25218,G__25219);
})());
var G__25216 = om.util.force_children((function (){var G__25220 = ({"className": "field-input", "onChange": ((function (G__25214,G__25215,field,column_properties,mappings,___$1,map__25209,map__25209__$1,required){
return (function (p1__25207_SHARP_){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,G__25214,G__25215,field,column_properties,mappings,___$1,map__25209,map__25209__$1,required){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,G__25214,G__25215,field,column_properties,mappings,___$1,map__25209,map__25209__$1,required){
return (function (state_25242){
var state_val_25243 = (state_25242[(1)]);
if((state_val_25243 === (1))){
var inst_25227 = (state_25242[(7)]);
var inst_25222 = cljs.core.cst$kw$chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_25223 = [cljs.core.cst$kw$mapping];
var inst_25224 = cljs.core.first(field);
var inst_25225 = [inst_25224];
var inst_25226 = p1__25207_SHARP_.target;
var inst_25227__$1 = inst_25226.value;
var inst_25228 = (inst_25227__$1 == null);
var inst_25229 = cljs.core.empty_QMARK_(inst_25227__$1);
var inst_25230 = (inst_25228) || (inst_25229);
var state_25242__$1 = (function (){var statearr_25244 = state_25242;
(statearr_25244[(7)] = inst_25227__$1);

(statearr_25244[(8)] = inst_25225);

(statearr_25244[(9)] = inst_25223);

(statearr_25244[(10)] = inst_25222);

return statearr_25244;
})();
if(cljs.core.truth_(inst_25230)){
var statearr_25245_25255 = state_25242__$1;
(statearr_25245_25255[(1)] = (3));

} else {
var statearr_25246_25256 = state_25242__$1;
(statearr_25246_25256[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25243 === (2))){
var inst_25240 = (state_25242[(2)]);
var state_25242__$1 = state_25242;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25242__$1,inst_25240);
} else {
if((state_val_25243 === (3))){
var state_25242__$1 = state_25242;
var statearr_25247_25257 = state_25242__$1;
(statearr_25247_25257[(2)] = null);

(statearr_25247_25257[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25243 === (4))){
var inst_25227 = (state_25242[(7)]);
var state_25242__$1 = state_25242;
var statearr_25248_25258 = state_25242__$1;
(statearr_25248_25258[(2)] = inst_25227);

(statearr_25248_25258[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25243 === (5))){
var inst_25225 = (state_25242[(8)]);
var inst_25223 = (state_25242[(9)]);
var inst_25222 = (state_25242[(10)]);
var inst_25234 = (state_25242[(2)]);
var inst_25235 = [inst_25234];
var inst_25236 = cljs.core.PersistentHashMap.fromArrays(inst_25225,inst_25235);
var inst_25237 = [inst_25236];
var inst_25238 = cljs.core.PersistentHashMap.fromArrays(inst_25223,inst_25237);
var state_25242__$1 = state_25242;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25242__$1,(2),inst_25222,inst_25238);
} else {
return null;
}
}
}
}
}
});})(c__14822__auto__,G__25214,G__25215,field,column_properties,mappings,___$1,map__25209,map__25209__$1,required))
;
return ((function (switch__14722__auto__,c__14822__auto__,G__25214,G__25215,field,column_properties,mappings,___$1,map__25209,map__25209__$1,required){
return (function() {
var camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto__ = null;
var camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto____0 = (function (){
var statearr_25249 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25249[(0)] = camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto__);

(statearr_25249[(1)] = (1));

return statearr_25249;
});
var camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto____1 = (function (state_25242){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_25242);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e25250){if((e25250 instanceof Object)){
var ex__14726__auto__ = e25250;
var statearr_25251_25259 = state_25242;
(statearr_25251_25259[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_25242);

return cljs.core.cst$kw$recur;
} else {
throw e25250;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__25260 = state_25242;
state_25242 = G__25260;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto__ = function(state_25242){
switch(arguments.length){
case 0:
return camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto____1.call(this,state_25242);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto____0;
camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto____1;
return camelot$component$bulk_import$mapper$field_mapping_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,G__25214,G__25215,field,column_properties,mappings,___$1,map__25209,map__25209__$1,required))
})();
var state__14824__auto__ = (function (){var statearr_25252 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_25252[(6)] = c__14822__auto__);

return statearr_25252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,G__25214,G__25215,field,column_properties,mappings,___$1,map__25209,map__25209__$1,required))
);

return c__14822__auto__;
});})(G__25214,G__25215,field,column_properties,mappings,___$1,map__25209,map__25209__$1,required))
, "value": cljs.core.get.cljs$core$IFn$_invoke$arity$2(mappings,cljs.core.first(field))});
var G__25221 = om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.bulk_import.mapper.field_mapping_option,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column_properties,cljs.core.PersistentHashMap.fromArrays([""],[cljs.core.PersistentArrayMap.EMPTY]))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.first], null));
return (om.dom.select.cljs$core$IFn$_invoke$arity$2 ? om.dom.select.cljs$core$IFn$_invoke$arity$2(G__25220,G__25221) : om.dom.select.call(null,G__25220,G__25221));
})());
var G__25217 = om.util.force_children((function (){var temp__4655__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(mappings,cljs.core.first(field));
if(cljs.core.truth_(temp__4655__auto__)){
var m = temp__4655__auto__;
var G__25253 = ({"className": "validation-warning"});
var G__25254 = om.util.force_children(camelot.util.model.reason_mapping_invalid(cljs.core.cst$kw$mappable_DASH_fields.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.first(field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(column_properties,m),camelot.translation.core.translate));
return React.DOM.label(G__25253,G__25254);
} else {
return null;
}
})());
return React.DOM.div(G__25214,G__25215,G__25216,G__25217);
});})(map__25209,map__25209__$1,required))
;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211.getBasis = ((function (map__25209,map__25209__$1,required){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__25208,cljs.core.cst$sym$map__25209,cljs.core.cst$sym$required,cljs.core.cst$sym$meta25212], null);
});})(map__25209,map__25209__$1,required))
;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211.cljs$lang$type = true;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211.cljs$lang$ctorStr = "camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25211";

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211.cljs$lang$ctorPrWriter = ((function (map__25209,map__25209__$1,required){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25211");
});})(map__25209,map__25209__$1,required))
;

camelot.component.bulk_import.mapper.__GT_t_camelot$component$bulk_import$mapper25211 = ((function (map__25209,map__25209__$1,required){
return (function camelot$component$bulk_import$mapper$field_mapping_component_$___GT_t_camelot$component$bulk_import$mapper25211(data__$1,owner__$1,p__25208__$1,map__25209__$2,required__$1,meta25212){
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211(data__$1,owner__$1,p__25208__$1,map__25209__$2,required__$1,meta25212));
});})(map__25209,map__25209__$1,required))
;

}

return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25211(data,owner,p__25208,map__25209__$1,required,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.bulk_import.mapper.error_item_component = (function camelot$component$bulk_import$mapper$error_item_component(data,owner){
if(typeof camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261 = (function (data,owner,meta25262){
this.data = data;
this.owner = owner;
this.meta25262 = meta25262;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25263,meta25262__$1){
var self__ = this;
var _25263__$1 = this;
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261(self__.data,self__.owner,meta25262__$1));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25263){
var self__ = this;
var _25263__$1 = this;
return self__.meta25262;
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__25264 = null;
var G__25265 = om.util.force_children(cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.li(G__25264,G__25265);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta25262], null);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261.cljs$lang$type = true;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261.cljs$lang$ctorStr = "camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25261";

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25261");
});

camelot.component.bulk_import.mapper.__GT_t_camelot$component$bulk_import$mapper25261 = (function camelot$component$bulk_import$mapper$error_item_component_$___GT_t_camelot$component$bulk_import$mapper25261(data__$1,owner__$1,meta25262){
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261(data__$1,owner__$1,meta25262));
});

}

return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25261(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.bulk_import.mapper.import_status_component = (function camelot$component$bulk_import$mapper$import_status_component(data,owner){
if(typeof camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266 = (function (data,owner,meta25267){
this.data = data;
this.owner = owner;
this.meta25267 = meta25267;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25268,meta25267__$1){
var self__ = this;
var _25268__$1 = this;
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266(self__.data,self__.owner,meta25267__$1));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25268){
var self__ = this;
var _25268__$1 = this;
return self__.meta25267;
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$import_DASH_status.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__25269 = cljs.core.cst$kw$import_DASH_status.cljs$core$IFn$_invoke$arity$1(self__.data);
var G__25269__$1 = (((G__25269 instanceof cljs.core.Keyword))?G__25269.fqn:null);
switch (G__25269__$1) {
case "active":
var G__25270 = null;
var G__25271 = om.util.force_children((function (){var G__25273 = null;
var G__25274 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_import_DASH_started));
return React.DOM.p(G__25273,G__25274);
})());
var G__25272 = om.util.force_children((function (){var G__25275 = ({"className": "bulk-import-sample-image"});
var G__25276 = om.util.force_children((function (){var G__25277 = ({"src": camelot.component.bulk_import.mapper.bulk_import_ui_sample_image, "alt": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_sample_DASH_ui)});
return React.DOM.img(G__25277);
})());
return React.DOM.div(G__25275,G__25276);
})());
return React.DOM.div(G__25270,G__25271,G__25272);

break;
case "validation-problem":
var G__25278 = null;
var G__25279 = om.util.force_children((function (){var G__25281 = null;
var G__25282 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_validation_DASH_problem));
return React.DOM.p(G__25281,G__25282);
})());
var G__25280 = om.util.force_children((function (){var G__25283 = ({"className": "bulk-import-validation-problem-list"});
var G__25284 = om.util.force_children((function (){var G__25285 = ({"rows": "6", "cols": "42", "className": "field-input"});
var G__25286 = clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.cst$kw$import_DASH_status_DASH_details.cljs$core$IFn$_invoke$arity$1(self__.data));
return (om.dom.textarea.cljs$core$IFn$_invoke$arity$2 ? om.dom.textarea.cljs$core$IFn$_invoke$arity$2(G__25285,G__25286) : om.dom.textarea.call(null,G__25285,G__25286));
})());
return React.DOM.div(G__25283,G__25284);
})());
return React.DOM.div(G__25278,G__25279,G__25280);

break;
case "failed":
var G__25287 = null;
var G__25288 = om.util.force_children((function (){var G__25291 = null;
var G__25292 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_import_DASH_failed));
return React.DOM.p(G__25291,G__25292);
})());
var G__25289 = om.util.force_children((function (){var G__25293 = null;
var G__25294 = om.util.force_children((function (){var G__25297 = null;
var G__25298 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_status_DASH_code));
return React.DOM.label(G__25297,G__25298);
})());
var G__25295 = om.util.force_children(": ");
var G__25296 = om.util.force_children(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status_DASH_details,cljs.core.cst$kw$status], null)));
return React.DOM.p(G__25293,G__25294,G__25295,G__25296);
})());
var G__25290 = om.util.force_children((function (){var G__25299 = ({"rows": "6", "cols": "42", "className": "field-input"});
var G__25300 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status_DASH_details,cljs.core.cst$kw$errors], null));
return (om.dom.textarea.cljs$core$IFn$_invoke$arity$2 ? om.dom.textarea.cljs$core$IFn$_invoke$arity$2(G__25299,G__25300) : om.dom.textarea.call(null,G__25299,G__25300));
})());
return React.DOM.div(G__25287,G__25288,G__25289,G__25290);

break;
case "initialising":
var G__25301 = null;
var G__25302 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_initialising));
return React.DOM.p(G__25301,G__25302);

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25269__$1)].join('')));

}
} else {
return null;
}
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta25267], null);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266.cljs$lang$type = true;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266.cljs$lang$ctorStr = "camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25266";

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25266");
});

camelot.component.bulk_import.mapper.__GT_t_camelot$component$bulk_import$mapper25266 = (function camelot$component$bulk_import$mapper$import_status_component_$___GT_t_camelot$component$bulk_import$mapper25266(data__$1,owner__$1,meta25267){
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266(data__$1,owner__$1,meta25267));
});

}

return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25266(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.bulk_import.mapper.import_status_dialog = (function camelot$component$bulk_import$mapper$import_status_dialog(data,owner){
if(typeof camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304 = (function (data,owner,meta25305){
this.data = data;
this.owner = owner;
this.meta25305 = meta25305;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25306,meta25305__$1){
var self__ = this;
var _25306__$1 = this;
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304(self__.data,self__.owner,meta25305__$1));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25306){
var self__ = this;
var _25306__$1 = this;
return self__.meta25305;
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.prompt_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$active_DASH_key,cljs.core.cst$kw$show_DASH_import_DASH_status_DASH_dialog,cljs.core.cst$kw$title,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_import_DASH_status_DASH_dialog_DASH_title),cljs.core.cst$kw$body,(function (){var G__25307 = null;
var G__25308 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.bulk_import.mapper.import_status_component,self__.data));
return React.DOM.div(G__25307,G__25308);
})(),cljs.core.cst$kw$closable,false,cljs.core.cst$kw$actions,(function (){var G__25309 = ({"className": "button-container"});
var G__25310 = om.util.force_children((function (){var G__25311 = ({"className": "btn btn-primary", "ref": "action-first", "disabled": ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$import_DASH_status.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$initialising))?"disabled":null), "title": ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$import_DASH_status.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$initialising))?camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_please_DASH_wait):null), "onClick": ((function (G__25309,___$1){
return (function (){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$show_DASH_import_DASH_status_DASH_dialog,false);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$import_DASH_status,null);
});})(G__25309,___$1))
});
var G__25312 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_continue));
return React.DOM.button(G__25311,G__25312);
})());
return React.DOM.div(G__25309,G__25310);
})()], null)], null));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta25305], null);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304.cljs$lang$type = true;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304.cljs$lang$ctorStr = "camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25304";

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25304");
});

camelot.component.bulk_import.mapper.__GT_t_camelot$component$bulk_import$mapper25304 = (function camelot$component$bulk_import$mapper$import_status_dialog_$___GT_t_camelot$component$bulk_import$mapper25304(data__$1,owner__$1,meta25305){
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304(data__$1,owner__$1,meta25305));
});

}

return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25304(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Sort based on column schema weightings.
 */
camelot.component.bulk_import.mapper.compare_column_schema_weight = (function camelot$component$bulk_import$mapper$compare_column_schema_weight(schema_definitions,a,b){
var da = cljs.core.get.cljs$core$IFn$_invoke$arity$2(schema_definitions,cljs.core.first(a));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(schema_definitions,cljs.core.first(b));
var o = cljs.core.compare(cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(da),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(db));
if((o === (0))){
return cljs.core.compare(cljs.core.first(a),cljs.core.first(b));
} else {
return o;
}
});
camelot.component.bulk_import.mapper.column_mapping_form_component = (function camelot$component$bulk_import$mapper$column_mapping_form_component(data,owner){
if(typeof camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315 = (function (data,owner,meta25316){
this.data = data;
this.owner = owner;
this.meta25316 = meta25316;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25317,meta25316__$1){
var self__ = this;
var _25317__$1 = this;
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315(self__.data,self__.owner,meta25316__$1));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25317){
var self__ = this;
var _25317__$1 = this;
return self__.meta25316;
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var temp__4655__auto__ = cljs.core.cst$kw$column_DASH_properties.cljs$core$IFn$_invoke$arity$1(self__.data);
if(cljs.core.truth_(temp__4655__auto__)){
var cps = temp__4655__auto__;
var colmaps = cljs.core.cst$kw$mappings.cljs$core$IFn$_invoke$arity$1(self__.data);
var mappable = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$mappable_DASH_fields.cljs$core$IFn$_invoke$arity$1(self__.data));
var G__25318 = null;
var G__25319 = om.util.force_children((function (){var G__25324 = null;
var G__25325 = om.util.force_children("Required fields");
return React.DOM.h5(G__25324,G__25325);
})());
var G__25320 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.bulk_import.mapper.field_mapping_component,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__25318,G__25319,colmaps,mappable,cps,temp__4655__auto__,___$1){
return (function (p1__25313_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$column_DASH_properties,cljs.core.cst$kw$mappings,cljs.core.cst$kw$mappable_DASH_fields,cljs.core.cst$kw$field,cljs.core.cst$kw$vkey],[cps,colmaps,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$mappable_DASH_fields.cljs$core$IFn$_invoke$arity$1(self__.data)),p1__25313_SHARP_,cljs.core.first(p1__25313_SHARP_)]);
});})(G__25318,G__25319,colmaps,mappable,cps,temp__4655__auto__,___$1))
,cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.component.bulk_import.mapper.compare_column_schema_weight,mappable),camelot.util.model.required_fields(cljs.core.cst$kw$mappable_DASH_fields.cljs$core$IFn$_invoke$arity$1(self__.data)))),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$init_DASH_state,state,cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$required,true], null),cljs.core.cst$kw$key,cljs.core.cst$kw$vkey], null)));
var G__25321 = om.util.force_children((function (){var G__25326 = null;
var G__25327 = om.util.force_children("Optional fields");
return React.DOM.h5(G__25326,G__25327);
})());
var G__25322 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.bulk_import.mapper.field_mapping_component,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__25318,G__25319,G__25320,G__25321,colmaps,mappable,cps,temp__4655__auto__,___$1){
return (function (p1__25314_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$column_DASH_properties,cljs.core.cst$kw$mappings,cljs.core.cst$kw$mappable_DASH_fields,cljs.core.cst$kw$field,cljs.core.cst$kw$vkey],[cps,colmaps,mappable,p1__25314_SHARP_,cljs.core.first(p1__25314_SHARP_)]);
});})(G__25318,G__25319,G__25320,G__25321,colmaps,mappable,cps,temp__4655__auto__,___$1))
,cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.component.bulk_import.mapper.compare_column_schema_weight,mappable),camelot.util.model.optional_fields(cljs.core.cst$kw$mappable_DASH_fields.cljs$core$IFn$_invoke$arity$1(self__.data)))),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$init_DASH_state,state,cljs.core.cst$kw$key,cljs.core.cst$kw$vkey], null)));
var G__25323 = om.util.force_children((function (){var vs = camelot.component.bulk_import.mapper.validation_summary(cljs.core.cst$kw$validation_DASH_problem.cljs$core$IFn$_invoke$arity$1(self__.data),colmaps);
var G__25328 = null;
var G__25329 = om.util.force_children(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$result.cljs$core$IFn$_invoke$arity$1(vs),cljs.core.cst$kw$fail))?(function (){var G__25331 = ({"className": "validation-warning"});
var G__25332 = om.util.force_children(cljs.core.cst$kw$reason.cljs$core$IFn$_invoke$arity$1(vs));
return React.DOM.label(G__25331,G__25332);
})():null));
var G__25330 = om.util.force_children((function (){var G__25333 = ({"className": "button-container pull-right"});
var G__25334 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.bulk_import.mapper.cancel_button_component,self__.data));
var G__25335 = om.util.force_children((function (){var G__25336 = ({"className": "btn btn-primary", "disabled": (cljs.core.truth_((function (){var or__6624__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$result.cljs$core$IFn$_invoke$arity$1(vs),cljs.core.cst$kw$fail);
if(or__6624__auto__){
return or__6624__auto__;
} else {
return cljs.core.cst$kw$show_DASH_import_DASH_status_DASH_dialog.cljs$core$IFn$_invoke$arity$1(self__.data);
}
})())?"disabled":null), "onClick": ((function (G__25333,G__25334,G__25328,G__25329,vs,G__25318,G__25319,G__25320,G__25321,G__25322,colmaps,mappable,cps,temp__4655__auto__,___$1){
return (function (){
return camelot.component.bulk_import.mapper.submit_mappings(self__.data);
});})(G__25333,G__25334,G__25328,G__25329,vs,G__25318,G__25319,G__25320,G__25321,G__25322,colmaps,mappable,cps,temp__4655__auto__,___$1))
, "title": cljs.core.cst$kw$reason.cljs$core$IFn$_invoke$arity$1(vs)});
var G__25337 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_submit));
return React.DOM.button(G__25336,G__25337);
})());
return React.DOM.div(G__25333,G__25334,G__25335);
})());
return React.DOM.div(G__25328,G__25329,G__25330);
})());
return React.DOM.div(G__25318,G__25319,G__25320,G__25321,G__25322,G__25323);
} else {
var G__25338 = ({"className": "button-container pull-right"});
var G__25339 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.bulk_import.mapper.cancel_button_component,self__.data));
return React.DOM.div(G__25338,G__25339);
}
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta25316], null);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315.cljs$lang$type = true;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315.cljs$lang$ctorStr = "camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25315";

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25315");
});

camelot.component.bulk_import.mapper.__GT_t_camelot$component$bulk_import$mapper25315 = (function camelot$component$bulk_import$mapper$column_mapping_form_component_$___GT_t_camelot$component$bulk_import$mapper25315(data__$1,owner__$1,meta25316){
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315(data__$1,owner__$1,meta25316));
});

}

return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25315(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.bulk_import.mapper.bulk_import_mapping_component = (function camelot$component$bulk_import$mapper$bulk_import_mapping_component(data,owner){
if(typeof camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {om.core.IWillUpdate}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346 = (function (data,owner,meta25347){
this.data = data;
this.owner = owner;
this.meta25347 = meta25347;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25348,meta25347__$1){
var self__ = this;
var _25348__$1 = this;
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346(self__.data,self__.owner,meta25347__$1));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25348){
var self__ = this;
var _25348__$1 = this;
return self__.meta25347;
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var fields = camelot.util.model.with_absolute_path(camelot.util.model.mappable_fields(camelot.util.model.schema_definitions));
var survey_fields = ((function (fields,___$1){
return (function camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_survey_fields(all_sf){
var survey_sf = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (fields,___$1){
return (function (p1__25340_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(camelot.state.get_survey_id(),cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(p1__25340_SHARP_));
});})(fields,___$1))
,all_sf);
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$mappable_DASH_fields,camelot.util.model.with_sighting_fields(fields,survey_sf));
});})(fields,___$1))
;
return camelot.rest.get_x_opts("/sighting-fields",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$success,((function (fields,___$1){
return (function (p1__25341_SHARP_){
return survey_fields(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__25341_SHARP_));
});})(fields,___$1))
,cljs.core.cst$kw$failure,((function (fields,___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$mappable_DASH_fields,camelot.util.model.with_sighting_fields(fields,fields));
});})(fields,___$1))
], null));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,___$1){
return (function (state_25370){
var state_val_25371 = (state_25370[(1)]);
if((state_val_25371 === (1))){
var state_25370__$1 = state_25370;
var statearr_25372_25408 = state_25370__$1;
(statearr_25372_25408[(2)] = null);

(statearr_25372_25408[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25371 === (2))){
var inst_25350 = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$chan);
var state_25370__$1 = state_25370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25370__$1,(4),inst_25350);
} else {
if((state_val_25371 === (3))){
var inst_25368 = (state_25370[(2)]);
var state_25370__$1 = state_25370;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25370__$1,inst_25368);
} else {
if((state_val_25371 === (4))){
var inst_25352 = (state_25370[(7)]);
var inst_25352__$1 = (state_25370[(2)]);
var inst_25353 = cljs.core.cst$kw$mapping.cljs$core$IFn$_invoke$arity$1(inst_25352__$1);
var state_25370__$1 = (function (){var statearr_25373 = state_25370;
(statearr_25373[(7)] = inst_25352__$1);

return statearr_25373;
})();
if(cljs.core.truth_(inst_25353)){
var statearr_25374_25409 = state_25370__$1;
(statearr_25374_25409[(1)] = (5));

} else {
var statearr_25375_25410 = state_25370__$1;
(statearr_25375_25410[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25371 === (5))){
var inst_25352 = (state_25370[(7)]);
var inst_25355 = cljs.core.cst$kw$mapping.cljs$core$IFn$_invoke$arity$1(inst_25352);
var inst_25356 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,inst_25355);
var inst_25357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25358 = cljs.core.first(inst_25356);
var inst_25359 = [cljs.core.cst$kw$mappings,inst_25358];
var inst_25360 = (new cljs.core.PersistentVector(null,2,(5),inst_25357,inst_25359,null));
var inst_25361 = cljs.core.second(inst_25356);
var inst_25362 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,inst_25360,inst_25361);
var state_25370__$1 = state_25370;
var statearr_25376_25411 = state_25370__$1;
(statearr_25376_25411[(2)] = inst_25362);

(statearr_25376_25411[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25371 === (6))){
var state_25370__$1 = state_25370;
var statearr_25377_25412 = state_25370__$1;
(statearr_25377_25412[(2)] = null);

(statearr_25377_25412[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25371 === (7))){
var inst_25365 = (state_25370[(2)]);
var state_25370__$1 = (function (){var statearr_25378 = state_25370;
(statearr_25378[(8)] = inst_25365);

return statearr_25378;
})();
var statearr_25379_25413 = state_25370__$1;
(statearr_25379_25413[(2)] = null);

(statearr_25379_25413[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__14822__auto__,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,___$1){
return (function() {
var camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto__ = null;
var camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto____0 = (function (){
var statearr_25380 = [null,null,null,null,null,null,null,null,null];
(statearr_25380[(0)] = camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto__);

(statearr_25380[(1)] = (1));

return statearr_25380;
});
var camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto____1 = (function (state_25370){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_25370);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e25381){if((e25381 instanceof Object)){
var ex__14726__auto__ = e25381;
var statearr_25382_25414 = state_25370;
(statearr_25382_25414[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_25370);

return cljs.core.cst$kw$recur;
} else {
throw e25381;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__25415 = state_25370;
state_25370 = G__25415;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto__ = function(state_25370){
switch(arguments.length){
case 0:
return camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto____1.call(this,state_25370);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto____0;
camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto____1;
return camelot$component$bulk_import$mapper$bulk_import_mapping_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,___$1))
})();
var state__14824__auto__ = (function (){var statearr_25383 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_25383[(6)] = c__14822__auto__);

return statearr_25383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,___$1))
);

return c__14822__auto__;
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.om$core$IWillUpdate$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.om$core$IWillUpdate$will_update$arity$3 = (function (_,___$1,___$2){
var self__ = this;
var ___$3 = this;
var fs = cljs.core.cst$kw$mappable_DASH_fields.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.data));
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$validation_DASH_problem,(function (){var or__6624__auto__ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs,___$3){
return (function (p1__25343_SHARP_,p2__25342_SHARP_){
var m = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mappings,cljs.core.first(p2__25342_SHARP_)], null));
if(cljs.core.truth_((function (){var and__6612__auto__ = m;
if(cljs.core.truth_(and__6612__auto__)){
return camelot.util.model.reason_mapping_invalid(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,fs),cljs.core.first(p2__25342_SHARP_),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$column_DASH_properties,m], null)),cljs.core.identity);
} else {
return and__6612__auto__;
}
})())){
return cljs.core.reduced(cljs.core.cst$kw$mismatch);
} else {
return null;
}
});})(fs,___$3))
,null,fs);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (or__6624__auto__,fs,___$3){
return (function (p1__25345_SHARP_,p2__25344_SHARP_){
var m = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mappings,cljs.core.first(p2__25344_SHARP_)], null));
if((m == null)){
return cljs.core.reduced(cljs.core.cst$kw$missing);
} else {
return null;
}
});})(or__6624__auto__,fs,___$3))
,null,camelot.util.model.required_fields(fs));
}
})());
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$mappable_DASH_fields.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__25384 = ({"className": "split-menu"});
var G__25385 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.bulk_import.mapper.import_status_dialog,self__.data));
var G__25386 = om.util.force_children((function (){var G__25388 = ({"className": "intro"});
var G__25389 = om.util.force_children((function (){var G__25390 = null;
var G__25391 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_title));
return React.DOM.h4(G__25390,G__25391);
})());
return React.DOM.div(G__25388,G__25389);
})());
var G__25387 = om.util.force_children((function (){var G__25392 = ({"className": "single-section"});
var G__25393 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.upload.file_upload_component,self__.data,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null),cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$analytics_DASH_event,"mapping-upload",cljs.core.cst$kw$pending_DASH_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.component.bulk_import.mapper.upload_pending_handler,self__.data),cljs.core.cst$kw$success_DASH_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.component.bulk_import.mapper.upload_success_handler,self__.data),cljs.core.cst$kw$failure_DASH_handler,((function (G__25392,G__25384,G__25385,G__25386,___$1){
return (function (){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$upload_DASH_pending,false);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$upload_DASH_failed,true);
});})(G__25392,G__25384,G__25385,G__25386,___$1))
,cljs.core.cst$kw$endpoint,"/surveys/bulkimport/columnmap"], null)], null)));
var G__25394 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$upload_DASH_pending.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__25395 = ({"className": "align-center"});
var G__25396 = om.util.force_children((function (){var G__25398 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__25398);
})());
var G__25397 = om.util.force_children((function (){var G__25399 = null;
var G__25400 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_scanning));
return React.DOM.p(G__25399,G__25400);
})());
return React.DOM.div(G__25395,G__25396,G__25397);
})():(cljs.core.truth_(cljs.core.cst$kw$upload_DASH_failed.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__25401 = ({"className": "validation-warning", "style": ({"margin-top": "1rem"})});
var G__25402 = om.util.force_children((function (){var G__25403 = null;
var G__25404 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$bulk_DASH_import$mapper_SLASH_invalid_DASH_csv));
return React.DOM.label(G__25403,G__25404);
})());
return React.DOM.p(G__25401,G__25402);
})():om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.bulk_import.mapper.column_mapping_form_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,state], null))
)));
return React.DOM.div(G__25392,G__25393,G__25394);
})());
return React.DOM.div(G__25384,G__25385,G__25386,G__25387);
} else {
var G__25405 = ({"className": "align-center"});
var G__25406 = om.util.force_children((function (){var G__25407 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__25407);
})());
return React.DOM.div(G__25405,G__25406);
}
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta25347], null);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.cljs$lang$type = true;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.cljs$lang$ctorStr = "camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25346";

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25346");
});

camelot.component.bulk_import.mapper.__GT_t_camelot$component$bulk_import$mapper25346 = (function camelot$component$bulk_import$mapper$bulk_import_mapping_component_$___GT_t_camelot$component$bulk_import$mapper25346(data__$1,owner__$1,meta25347){
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346(data__$1,owner__$1,meta25347));
});

}

return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25346(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.bulk_import.mapper.bulk_import_mapping_view = (function camelot$component$bulk_import$mapper$bulk_import_mapping_view(app,owner){
if(typeof camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416 = (function (app,owner,meta25417){
this.app = app;
this.owner = owner;
this.meta25417 = meta25417;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25418,meta25417__$1){
var self__ = this;
var _25418__$1 = this;
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416(self__.app,self__.owner,meta25417__$1));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25418){
var self__ = this;
var _25418__$1 = this;
return self__.meta25417;
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,cljs.core.cst$kw$bulk_DASH_import,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mappings,cljs.core.PersistentArrayMap.EMPTY], null));
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.prototype.om$core$IWillUnmount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,cljs.core.cst$kw$bulk_DASH_import,null);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var temp__4655__auto__ = cljs.core.cst$kw$bulk_DASH_import.cljs$core$IFn$_invoke$arity$1(self__.app);
if(cljs.core.truth_(temp__4655__auto__)){
var data = temp__4655__auto__;
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.bulk_import.mapper.bulk_import_mapping_component,data);
} else {
return null;
}
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta25417], null);
});

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.cljs$lang$type = true;

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.cljs$lang$ctorStr = "camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25416";

camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.bulk-import.mapper/t_camelot$component$bulk_import$mapper25416");
});

camelot.component.bulk_import.mapper.__GT_t_camelot$component$bulk_import$mapper25416 = (function camelot$component$bulk_import$mapper$bulk_import_mapping_view_$___GT_t_camelot$component$bulk_import$mapper25416(app__$1,owner__$1,meta25417){
return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416(app__$1,owner__$1,meta25417));
});

}

return (new camelot.component.bulk_import.mapper.t_camelot$component$bulk_import$mapper25416(app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
