// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.camera.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.core');
goog.require('camelot.nav');
goog.require('om.dom');
goog.require('camelot.rest');
goog.require('camelot.component.util');
goog.require('camelot.component.camera.manage');
goog.require('camelot.util.cursorise');
goog.require('camelot.translation.core');
goog.require('cljs.core.async');
goog.require('camelot.util.filter');
goog.require('clojure.string');
/**
 * Delete the camera and trigger a removal event.
 */
camelot.component.camera.core.delete$ = (function camelot$component$camera$core$delete(state,data,event){
event.preventDefault();

event.stopPropagation();

if(cljs.core.truth_((function (){var G__19785 = camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_confirm_DASH_delete);
return confirm(G__19785);
})())){
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/cameras/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(data))].join(''),(function (){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_19793){
var state_val_19794 = (state_19793[(1)]);
if((state_val_19794 === (1))){
var inst_19786 = cljs.core.cst$kw$chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_19787 = [cljs.core.cst$kw$event,cljs.core.cst$kw$data];
var inst_19788 = [cljs.core.cst$kw$delete,data];
var inst_19789 = cljs.core.PersistentHashMap.fromArrays(inst_19787,inst_19788);
var state_19793__$1 = state_19793;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19793__$1,(2),inst_19786,inst_19789);
} else {
if((state_val_19794 === (2))){
var inst_19791 = (state_19793[(2)]);
var state_19793__$1 = state_19793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19793__$1,inst_19791);
} else {
return null;
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$component$camera$core$delete_$_state_machine__14723__auto__ = null;
var camelot$component$camera$core$delete_$_state_machine__14723__auto____0 = (function (){
var statearr_19795 = [null,null,null,null,null,null,null];
(statearr_19795[(0)] = camelot$component$camera$core$delete_$_state_machine__14723__auto__);

(statearr_19795[(1)] = (1));

return statearr_19795;
});
var camelot$component$camera$core$delete_$_state_machine__14723__auto____1 = (function (state_19793){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_19793);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e19796){if((e19796 instanceof Object)){
var ex__14726__auto__ = e19796;
var statearr_19797_19799 = state_19793;
(statearr_19797_19799[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19793);

return cljs.core.cst$kw$recur;
} else {
throw e19796;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__19800 = state_19793;
state_19793 = G__19800;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$camera$core$delete_$_state_machine__14723__auto__ = function(state_19793){
switch(arguments.length){
case 0:
return camelot$component$camera$core$delete_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$camera$core$delete_$_state_machine__14723__auto____1.call(this,state_19793);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$camera$core$delete_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$camera$core$delete_$_state_machine__14723__auto____0;
camelot$component$camera$core$delete_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$camera$core$delete_$_state_machine__14723__auto____1;
return camelot$component$camera$core$delete_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_19798 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_19798[(6)] = c__14822__auto__);

return statearr_19798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
}));
} else {
return null;
}
});
camelot.component.camera.core.add_success_handler = (function camelot$component$camera$core$add_success_handler(data,resp){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$list,(function (p1__19801_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19801_SHARP_,camelot.util.cursorise.decursorise(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp)));
}));

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$new_DASH_camera_DASH_name,null);
});
camelot.component.camera.core.add_camera_handler = (function camelot$component$camera$core$add_camera_handler(data){
camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3("/cameras",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$new_DASH_camera_DASH_name.cljs$core$IFn$_invoke$arity$1(data)], null)], null),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.component.camera.core.add_success_handler,data));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-camera","create-click");
});
camelot.component.camera.core.validate_proposed_camera = (function camelot$component$camera$core$validate_proposed_camera(data){
return cljs.core.not((function (){var or__6624__auto__ = (cljs.core.cst$kw$new_DASH_camera_DASH_name.cljs$core$IFn$_invoke$arity$1(data) == null);
if(or__6624__auto__){
return or__6624__auto__;
} else {
var camera = clojure.string.lower_case(clojure.string.trim(cljs.core.cst$kw$new_DASH_camera_DASH_name.cljs$core$IFn$_invoke$arity$1(data)));
var or__6624__auto____$1 = cljs.core.empty_QMARK_(camera);
if(or__6624__auto____$1){
return or__6624__auto____$1;
} else {
return cljs.core.some(((function (or__6624__auto____$1,camera,or__6624__auto__){
return (function (p1__19802_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(camera,clojure.string.lower_case(clojure.string.trim(p1__19802_SHARP_)));
});})(or__6624__auto____$1,camera,or__6624__auto__))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(data)));
}
}
})());
});
camelot.component.camera.core.add_camera_component = (function camelot$component$camera$core$add_camera_component(data,owner){
if(typeof camelot.component.camera.core.t_camelot$component$camera$core19805 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.camera.core.t_camelot$component$camera$core19805 = (function (data,owner,meta19806){
this.data = data;
this.owner = owner;
this.meta19806 = meta19806;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.camera.core.t_camelot$component$camera$core19805.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19807,meta19806__$1){
var self__ = this;
var _19807__$1 = this;
return (new camelot.component.camera.core.t_camelot$component$camera$core19805(self__.data,self__.owner,meta19806__$1));
});

camelot.component.camera.core.t_camelot$component$camera$core19805.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19807){
var self__ = this;
var _19807__$1 = this;
return self__.meta19806;
});

camelot.component.camera.core.t_camelot$component$camera$core19805.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.camera.core.t_camelot$component$camera$core19805.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var is_valid = camelot.component.camera.core.validate_proposed_camera(self__.data);
var G__19808 = ({"className": "field-input-form", "onSubmit": ((function (is_valid,___$1){
return (function (p1__19803_SHARP_){
return p1__19803_SHARP_.preventDefault();
});})(is_valid,___$1))
});
var G__19809 = om.util.force_children((function (){var G__19811 = ({"className": "field-input", "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_new_DASH_camera_DASH_name_DASH_placeholder), "value": cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_camera_DASH_name], null)), "onChange": ((function (G__19808,is_valid,___$1){
return (function (p1__19804_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$new_DASH_camera_DASH_name,p1__19804_SHARP_.target.value);
});})(G__19808,is_valid,___$1))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__19811) : om.dom.input.call(null,G__19811));
})());
var G__19810 = om.util.force_children((function (){var G__19812 = ({"type": "submit", "disabled": (cljs.core.truth_(is_valid)?"":"disabled"), "title": (cljs.core.truth_(is_valid)?null:camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_invalid_DASH_title)), "className": "btn btn-primary input-field-submit", "onClick": ((function (G__19808,G__19809,is_valid,___$1){
return (function (){
return camelot.component.camera.core.add_camera_handler(self__.data);
});})(G__19808,G__19809,is_valid,___$1))
, "value": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_add)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__19812) : om.dom.input.call(null,G__19812));
})());
return React.DOM.form(G__19808,G__19809,G__19810);
});

camelot.component.camera.core.t_camelot$component$camera$core19805.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta19806], null);
});

camelot.component.camera.core.t_camelot$component$camera$core19805.cljs$lang$type = true;

camelot.component.camera.core.t_camelot$component$camera$core19805.cljs$lang$ctorStr = "camelot.component.camera.core/t_camelot$component$camera$core19805";

camelot.component.camera.core.t_camelot$component$camera$core19805.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.camera.core/t_camelot$component$camera$core19805");
});

camelot.component.camera.core.__GT_t_camelot$component$camera$core19805 = (function camelot$component$camera$core$add_camera_component_$___GT_t_camelot$component$camera$core19805(data__$1,owner__$1,meta19806){
return (new camelot.component.camera.core.t_camelot$component$camera$core19805(data__$1,owner__$1,meta19806));
});

}

return (new camelot.component.camera.core.t_camelot$component$camera$core19805(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.camera.core.camera_list_component = (function camelot$component$camera$core$camera_list_component(data,owner){
if(typeof camelot.component.camera.core.t_camelot$component$camera$core19813 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.camera.core.t_camelot$component$camera$core19813 = (function (data,owner,meta19814){
this.data = data;
this.owner = owner;
this.meta19814 = meta19814;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.camera.core.t_camelot$component$camera$core19813.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19815,meta19814__$1){
var self__ = this;
var _19815__$1 = this;
return (new camelot.component.camera.core.t_camelot$component$camera$core19813(self__.data,self__.owner,meta19814__$1));
});

camelot.component.camera.core.t_camelot$component$camera$core19813.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19815){
var self__ = this;
var _19815__$1 = this;
return self__.meta19814;
});

camelot.component.camera.core.t_camelot$component$camera$core19813.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.camera.core.t_camelot$component$camera$core19813.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__19816 = ({"className": "menu-item detailed dynamic", "onClick": ((function (___$1){
return (function (){
return camelot.nav.nav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/camera/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data))].join(''));
});})(___$1))
});
var G__19817 = om.util.force_children((function (){var G__19821 = ({"className": "pull-right fa fa-times remove top-corner", "onClick": cljs.core.partial.cljs$core$IFn$_invoke$arity$3(camelot.component.camera.core.delete$,state,self__.data)});
return React.DOM.div(G__19821);
})());
var G__19818 = om.util.force_children((function (){var G__19822 = ({"className": "status pull-right"});
var G__19823 = om.util.force_children(cljs.core.cst$kw$camera_DASH_status_DASH_description.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__19822,G__19823);
})());
var G__19819 = om.util.force_children((function (){var G__19824 = ({"className": "menu-item-title"});
var G__19825 = om.util.force_children(cljs.core.cst$kw$camera_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__19824,G__19825);
})());
var G__19820 = om.util.force_children((function (){var G__19826 = ({"className": "menu-item-description"});
var G__19827 = om.util.force_children(cljs.core.cst$kw$camera_DASH_notes.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__19826,G__19827);
})());
return React.DOM.div(G__19816,G__19817,G__19818,G__19819,G__19820);
});

camelot.component.camera.core.t_camelot$component$camera$core19813.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta19814], null);
});

camelot.component.camera.core.t_camelot$component$camera$core19813.cljs$lang$type = true;

camelot.component.camera.core.t_camelot$component$camera$core19813.cljs$lang$ctorStr = "camelot.component.camera.core/t_camelot$component$camera$core19813";

camelot.component.camera.core.t_camelot$component$camera$core19813.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.camera.core/t_camelot$component$camera$core19813");
});

camelot.component.camera.core.__GT_t_camelot$component$camera$core19813 = (function camelot$component$camera$core$camera_list_component_$___GT_t_camelot$component$camera$core19813(data__$1,owner__$1,meta19814){
return (new camelot.component.camera.core.t_camelot$component$camera$core19813(data__$1,owner__$1,meta19814));
});

}

return (new camelot.component.camera.core.t_camelot$component$camera$core19813(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.camera.core.manage_view = (function camelot$component$camera$core$manage_view(data,owner,p__19829){
var map__19830 = p__19829;
var map__19830__$1 = ((((!((map__19830 == null)))?((((map__19830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19830.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19830):map__19830);
var camera_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19830__$1,cljs.core.cst$kw$camera_DASH_id);
if(typeof camelot.component.camera.core.t_camelot$component$camera$core19832 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.camera.core.t_camelot$component$camera$core19832 = (function (data,owner,p__19829,map__19830,camera_id,meta19833){
this.data = data;
this.owner = owner;
this.p__19829 = p__19829;
this.map__19830 = map__19830;
this.camera_id = camera_id;
this.meta19833 = meta19833;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.camera.core.t_camelot$component$camera$core19832.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__19830,map__19830__$1,camera_id){
return (function (_19834,meta19833__$1){
var self__ = this;
var _19834__$1 = this;
return (new camelot.component.camera.core.t_camelot$component$camera$core19832(self__.data,self__.owner,self__.p__19829,self__.map__19830,self__.camera_id,meta19833__$1));
});})(map__19830,map__19830__$1,camera_id))
;

camelot.component.camera.core.t_camelot$component$camera$core19832.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__19830,map__19830__$1,camera_id){
return (function (_19834){
var self__ = this;
var _19834__$1 = this;
return self__.meta19833;
});})(map__19830,map__19830__$1,camera_id))
;

camelot.component.camera.core.t_camelot$component$camera$core19832.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.camera.core.t_camelot$component$camera$core19832.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__19830,map__19830__$1,camera_id){
return (function (_){
var self__ = this;
var ___$1 = this;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$data,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/cameras/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.camera_id)].join(''),((function (___$1,map__19830,map__19830__$1,camera_id){
return (function (p1__19828_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$data,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__19828_SHARP_));

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2("/cameras/",((function (___$1,map__19830,map__19830__$1,camera_id){
return (function (x){
var others = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (___$1,map__19830,map__19830__$1,camera_id){
return (function (v){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__19828_SHARP_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$value], null)),cljs.core.cst$kw$camera_DASH_name.cljs$core$IFn$_invoke$arity$1(v));
});})(___$1,map__19830,map__19830__$1,camera_id))
,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(x));
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,others);
});})(___$1,map__19830,map__19830__$1,camera_id))
);
});})(___$1,map__19830,map__19830__$1,camera_id))
);
});})(map__19830,map__19830__$1,camera_id))
;

camelot.component.camera.core.t_camelot$component$camera$core19832.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.camera.core.t_camelot$component$camera$core19832.prototype.om$core$IRender$render$arity$1 = ((function (map__19830,map__19830__$1,camera_id){
return (function (_){
var self__ = this;
var ___$1 = this;
if((cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data) == null)){
var G__19835 = ({"className": "align-center"});
var G__19836 = om.util.force_children((function (){var G__19837 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__19837);
})());
return React.DOM.div(G__19835,G__19836);
} else {
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.camera.manage.manage_component,self__.data);
}
});})(map__19830,map__19830__$1,camera_id))
;

camelot.component.camera.core.t_camelot$component$camera$core19832.getBasis = ((function (map__19830,map__19830__$1,camera_id){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__19829,cljs.core.cst$sym$map__19830,cljs.core.cst$sym$camera_DASH_id,cljs.core.cst$sym$meta19833], null);
});})(map__19830,map__19830__$1,camera_id))
;

camelot.component.camera.core.t_camelot$component$camera$core19832.cljs$lang$type = true;

camelot.component.camera.core.t_camelot$component$camera$core19832.cljs$lang$ctorStr = "camelot.component.camera.core/t_camelot$component$camera$core19832";

camelot.component.camera.core.t_camelot$component$camera$core19832.cljs$lang$ctorPrWriter = ((function (map__19830,map__19830__$1,camera_id){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.camera.core/t_camelot$component$camera$core19832");
});})(map__19830,map__19830__$1,camera_id))
;

camelot.component.camera.core.__GT_t_camelot$component$camera$core19832 = ((function (map__19830,map__19830__$1,camera_id){
return (function camelot$component$camera$core$manage_view_$___GT_t_camelot$component$camera$core19832(data__$1,owner__$1,p__19829__$1,map__19830__$2,camera_id__$1,meta19833){
return (new camelot.component.camera.core.t_camelot$component$camera$core19832(data__$1,owner__$1,p__19829__$1,map__19830__$2,camera_id__$1,meta19833));
});})(map__19830,map__19830__$1,camera_id))
;

}

return (new camelot.component.camera.core.t_camelot$component$camera$core19832(data,owner,p__19829,map__19830__$1,camera_id,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.camera.core.camera_menu_component = (function camelot$component$camera$core$camera_menu_component(data,owner){
if(typeof camelot.component.camera.core.t_camelot$component$camera$core19842 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.camera.core.t_camelot$component$camera$core19842 = (function (data,owner,meta19843){
this.data = data;
this.owner = owner;
this.meta19843 = meta19843;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19844,meta19843__$1){
var self__ = this;
var _19844__$1 = this;
return (new camelot.component.camera.core.t_camelot$component$camera$core19842(self__.data,self__.owner,meta19843__$1));
});

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19844){
var self__ = this;
var _19844__$1 = this;
return self__.meta19843;
});

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);
});

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
camelot.rest.get_resource("/cameras",((function (___$1){
return (function (p1__19838_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__19838_SHARP_));
});})(___$1))
);

var ch = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$chan);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,ch,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,ch,___$1){
return (function (state_19860){
var state_val_19861 = (state_19860[(1)]);
if((state_val_19861 === (1))){
var state_19860__$1 = state_19860;
var statearr_19862_19891 = state_19860__$1;
(statearr_19862_19891[(2)] = null);

(statearr_19862_19891[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19861 === (2))){
var state_19860__$1 = state_19860;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19860__$1,(4),ch);
} else {
if((state_val_19861 === (3))){
var inst_19858 = (state_19860[(2)]);
var state_19860__$1 = state_19860;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19860__$1,inst_19858);
} else {
if((state_val_19861 === (4))){
var inst_19847 = (state_19860[(7)]);
var inst_19847__$1 = (state_19860[(2)]);
var inst_19848 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(inst_19847__$1);
var inst_19849 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19848,cljs.core.cst$kw$delete);
var state_19860__$1 = (function (){var statearr_19863 = state_19860;
(statearr_19863[(7)] = inst_19847__$1);

return statearr_19863;
})();
if(inst_19849){
var statearr_19864_19892 = state_19860__$1;
(statearr_19864_19892[(1)] = (5));

} else {
var statearr_19865_19893 = state_19860__$1;
(statearr_19865_19893[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19861 === (5))){
var inst_19847 = (state_19860[(7)]);
var inst_19851 = (function (){var r = inst_19847;
return ((function (r,inst_19847,state_val_19861,c__14822__auto__,ch,___$1){
return (function (p1__19839_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (r,inst_19847,state_val_19861,c__14822__auto__,ch,___$1){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(r));
});})(r,inst_19847,state_val_19861,c__14822__auto__,ch,___$1))
,p1__19839_SHARP_);
});
;})(r,inst_19847,state_val_19861,c__14822__auto__,ch,___$1))
})();
var inst_19852 = om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,inst_19851);
var state_19860__$1 = state_19860;
var statearr_19866_19894 = state_19860__$1;
(statearr_19866_19894[(2)] = inst_19852);

(statearr_19866_19894[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19861 === (6))){
var state_19860__$1 = state_19860;
var statearr_19867_19895 = state_19860__$1;
(statearr_19867_19895[(2)] = null);

(statearr_19867_19895[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19861 === (7))){
var inst_19855 = (state_19860[(2)]);
var state_19860__$1 = (function (){var statearr_19868 = state_19860;
(statearr_19868[(8)] = inst_19855);

return statearr_19868;
})();
var statearr_19869_19896 = state_19860__$1;
(statearr_19869_19896[(2)] = null);

(statearr_19869_19896[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__14822__auto__,ch,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,ch,___$1){
return (function() {
var camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto__ = null;
var camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto____0 = (function (){
var statearr_19870 = [null,null,null,null,null,null,null,null,null];
(statearr_19870[(0)] = camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto__);

(statearr_19870[(1)] = (1));

return statearr_19870;
});
var camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto____1 = (function (state_19860){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_19860);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e19871){if((e19871 instanceof Object)){
var ex__14726__auto__ = e19871;
var statearr_19872_19897 = state_19860;
(statearr_19872_19897[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19860);

return cljs.core.cst$kw$recur;
} else {
throw e19871;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__19898 = state_19860;
state_19860 = G__19898;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto__ = function(state_19860){
switch(arguments.length){
case 0:
return camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto____1.call(this,state_19860);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto____0;
camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto____1;
return camelot$component$camera$core$camera_menu_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,ch,___$1))
})();
var state__14824__auto__ = (function (){var statearr_19873 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_19873[(6)] = c__14822__auto__);

return statearr_19873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,ch,___$1))
);

return c__14822__auto__;
});

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.om$core$IWillUnmount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);
});

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.camera.core.t_camelot$component$camera$core19842.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__19874 = ({"className": "section"});
var G__19875 = om.util.force_children((function (){var G__19880 = null;
var G__19881 = om.util.force_children((function (){var G__19882 = ({"className": "field-input", "value": cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data), "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_filter_DASH_cameras), "onChange": ((function (G__19880,G__19874,___$1){
return (function (p1__19840_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$filter,p1__19840_SHARP_.target.value);
});})(G__19880,G__19874,___$1))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__19882) : om.dom.input.call(null,G__19882));
})());
return React.DOM.div(G__19880,G__19881);
})());
var G__19876 = om.util.force_children((function (){var G__19883 = ({"className": "simple-menu scroll"});
var G__19884 = om.util.force_children((function (){var filtered = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__19883,G__19874,G__19875,___$1){
return (function (p1__19841_SHARP_){
if(((cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data) == null)) || (cljs.core.empty_QMARK_(cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data)))){
return true;
} else {
return cljs.core.re_matches(cljs.core.re_pattern([cljs.core.str.cljs$core$IFn$_invoke$arity$1("(?i).*"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".*")].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$camera_DASH_name.cljs$core$IFn$_invoke$arity$1(p1__19841_SHARP_)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$camera_DASH_status_DASH_description.cljs$core$IFn$_invoke$arity$1(p1__19841_SHARP_)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$camera_DASH_notes.cljs$core$IFn$_invoke$arity$1(p1__19841_SHARP_))].join(''));
}
});})(G__19883,G__19874,G__19875,___$1))
,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data)));
if(cljs.core.empty_QMARK_(filtered)){
return om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.blank_slate_component,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$item_DASH_name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_blank_DASH_item_DASH_name),cljs.core.cst$kw$advice,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$camera$core_SLASH_blank_DASH_filter_DASH_advice)], null)], null));
} else {
return om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.camera.core.camera_list_component,filtered,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$camera_DASH_id,cljs.core.cst$kw$init_DASH_state,state], null));
}
})());
return React.DOM.div(G__19883,G__19884);
})());
var G__19877 = om.util.force_children((function (){var G__19885 = ({"className": "sep"});
return React.DOM.div(G__19885);
})());
var G__19878 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.camera.core.add_camera_component,self__.data));
var G__19879 = om.util.force_children((function (){var G__19886 = ({"className": "btn btn-default", "onClick": ((function (G__19874,G__19875,G__19876,G__19877,G__19878,___$1){
return (function (){
camelot.nav.nav_BANG_("/cameras");

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-camera","advanced-click");
});})(G__19874,G__19875,G__19876,G__19877,G__19878,___$1))
});
var G__19887 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_advanced));
return React.DOM.button(G__19886,G__19887);
})());
return React.DOM.div(G__19874,G__19875,G__19876,G__19877,G__19878,G__19879);
} else {
var G__19888 = ({"className": "align-center"});
var G__19889 = om.util.force_children((function (){var G__19890 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__19890);
})());
return React.DOM.div(G__19888,G__19889);
}
});

camelot.component.camera.core.t_camelot$component$camera$core19842.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta19843], null);
});

camelot.component.camera.core.t_camelot$component$camera$core19842.cljs$lang$type = true;

camelot.component.camera.core.t_camelot$component$camera$core19842.cljs$lang$ctorStr = "camelot.component.camera.core/t_camelot$component$camera$core19842";

camelot.component.camera.core.t_camelot$component$camera$core19842.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.camera.core/t_camelot$component$camera$core19842");
});

camelot.component.camera.core.__GT_t_camelot$component$camera$core19842 = (function camelot$component$camera$core$camera_menu_component_$___GT_t_camelot$component$camera$core19842(data__$1,owner__$1,meta19843){
return (new camelot.component.camera.core.t_camelot$component$camera$core19842(data__$1,owner__$1,meta19843));
});

}

return (new camelot.component.camera.core.t_camelot$component$camera$core19842(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
