// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.deployment.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.core');
goog.require('om.dom');
goog.require('cljs.core.async');
goog.require('camelot.rest');
goog.require('camelot.nav');
goog.require('camelot.state');
goog.require('cljs_time.format');
goog.require('camelot.component.deployment.create');
goog.require('camelot.component.deployment.camera_check');
goog.require('camelot.component.deployment.shared');
goog.require('camelot.component.util');
goog.require('camelot.translation.core');
camelot.component.deployment.core.day_formatter = cljs_time.format.formatter.cljs$core$IFn$_invoke$arity$1("yyyy-MM-dd");
/**
 * Delete the trap station and trigger a removal event.
 */
camelot.component.deployment.core.delete$ = (function camelot$component$deployment$core$delete(state,data,event){
event.preventDefault();

event.stopPropagation();

if(cljs.core.truth_((function (){var G__23557 = camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_confirm_DASH_delete);
return confirm(G__23557);
})())){
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/trap-stations/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$trap_DASH_station_DASH_id.cljs$core$IFn$_invoke$arity$1(data))].join(''),(function (){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_23565){
var state_val_23566 = (state_23565[(1)]);
if((state_val_23566 === (1))){
var inst_23558 = cljs.core.cst$kw$chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_23559 = [cljs.core.cst$kw$event,cljs.core.cst$kw$data];
var inst_23560 = [cljs.core.cst$kw$delete,data];
var inst_23561 = cljs.core.PersistentHashMap.fromArrays(inst_23559,inst_23560);
var state_23565__$1 = state_23565;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23565__$1,(2),inst_23558,inst_23561);
} else {
if((state_val_23566 === (2))){
var inst_23563 = (state_23565[(2)]);
var state_23565__$1 = state_23565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23565__$1,inst_23563);
} else {
return null;
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$component$deployment$core$delete_$_state_machine__14723__auto__ = null;
var camelot$component$deployment$core$delete_$_state_machine__14723__auto____0 = (function (){
var statearr_23567 = [null,null,null,null,null,null,null];
(statearr_23567[(0)] = camelot$component$deployment$core$delete_$_state_machine__14723__auto__);

(statearr_23567[(1)] = (1));

return statearr_23567;
});
var camelot$component$deployment$core$delete_$_state_machine__14723__auto____1 = (function (state_23565){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_23565);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e23568){if((e23568 instanceof Object)){
var ex__14726__auto__ = e23568;
var statearr_23569_23571 = state_23565;
(statearr_23569_23571[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23565);

return cljs.core.cst$kw$recur;
} else {
throw e23568;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__23572 = state_23565;
state_23565 = G__23572;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$deployment$core$delete_$_state_machine__14723__auto__ = function(state_23565){
switch(arguments.length){
case 0:
return camelot$component$deployment$core$delete_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$deployment$core$delete_$_state_machine__14723__auto____1.call(this,state_23565);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$deployment$core$delete_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$core$delete_$_state_machine__14723__auto____0;
camelot$component$deployment$core$delete_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$core$delete_$_state_machine__14723__auto____1;
return camelot$component$deployment$core$delete_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_23570 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_23570[(6)] = c__14822__auto__);

return statearr_23570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
}));
} else {
return null;
}
});
/**
 * Entry in the page navigation menu.
 */
camelot.component.deployment.core.action_item_component = (function camelot$component$deployment$core$action_item_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core23573 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core23573 = (function (data,owner,meta23574){
this.data = data;
this.owner = owner;
this.meta23574 = meta23574;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.core.t_camelot$component$deployment$core23573.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23575,meta23574__$1){
var self__ = this;
var _23575__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23573(self__.data,self__.owner,meta23574__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core23573.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23575){
var self__ = this;
var _23575__$1 = this;
return self__.meta23574;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23573.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23573.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__23576 = ({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("menu-item"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$action.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(state)))?" active":""))].join(''), "onClick": ((function (___$1){
return (function (){
var c__14822__auto___23591 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___23591,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___23591,___$1){
return (function (state_23583){
var state_val_23584 = (state_23583[(1)]);
if((state_val_23584 === (1))){
var inst_23578 = cljs.core.cst$kw$active_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_23579 = cljs.core.cst$kw$action.cljs$core$IFn$_invoke$arity$1(self__.data);
var state_23583__$1 = state_23583;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23583__$1,(2),inst_23578,inst_23579);
} else {
if((state_val_23584 === (2))){
var inst_23581 = (state_23583[(2)]);
var state_23583__$1 = state_23583;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23583__$1,inst_23581);
} else {
return null;
}
}
});})(c__14822__auto___23591,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto___23591,___$1){
return (function() {
var camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto__ = null;
var camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto____0 = (function (){
var statearr_23585 = [null,null,null,null,null,null,null];
(statearr_23585[(0)] = camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto__);

(statearr_23585[(1)] = (1));

return statearr_23585;
});
var camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto____1 = (function (state_23583){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_23583);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e23586){if((e23586 instanceof Object)){
var ex__14726__auto__ = e23586;
var statearr_23587_23592 = state_23583;
(statearr_23587_23592[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23583);

return cljs.core.cst$kw$recur;
} else {
throw e23586;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__23593 = state_23583;
state_23583 = G__23593;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto__ = function(state_23583){
switch(arguments.length){
case 0:
return camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto____1.call(this,state_23583);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto____0;
camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto____1;
return camelot$component$deployment$core$action_item_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___23591,___$1))
})();
var state__14824__auto__ = (function (){var statearr_23588 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_23588[(6)] = c__14822__auto___23591);

return statearr_23588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___23591,___$1))
);


return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("deployment",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$action.cljs$core$IFn$_invoke$arity$1(self__.data))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-click")].join(''));
});})(___$1))
});
var G__23577 = om.util.force_children((function (){var G__23589 = ({"className": "menu-item-title"});
var G__23590 = om.util.force_children(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__23589,G__23590);
})());
return React.DOM.div(G__23576,G__23577);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23573.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23574], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23573.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core23573.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core23573";

camelot.component.deployment.core.t_camelot$component$deployment$core23573.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core23573");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core23573 = (function camelot$component$deployment$core$action_item_component_$___GT_t_camelot$component$deployment$core23573(data__$1,owner__$1,meta23574){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23573(data__$1,owner__$1,meta23574));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core23573(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Page navigation menu component.
 */
camelot.component.deployment.core.action_menu_component = (function camelot$component$deployment$core$action_menu_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core23594 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core23594 = (function (data,owner,meta23595){
this.data = data;
this.owner = owner;
this.meta23595 = meta23595;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.core.t_camelot$component$deployment$core23594.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23596,meta23595__$1){
var self__ = this;
var _23596__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23594(self__.data,self__.owner,meta23595__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core23594.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23596){
var self__ = this;
var _23596__$1 = this;
return self__.meta23595;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23594.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23594.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23594.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23594.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var chan = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$active_DASH_chan);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,chan,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,chan,___$1){
return (function (state_23605){
var state_val_23606 = (state_23605[(1)]);
if((state_val_23606 === (1))){
var state_23605__$1 = state_23605;
var statearr_23607_23618 = state_23605__$1;
(statearr_23607_23618[(2)] = null);

(statearr_23607_23618[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23606 === (2))){
var state_23605__$1 = state_23605;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23605__$1,(4),chan);
} else {
if((state_val_23606 === (3))){
var inst_23603 = (state_23605[(2)]);
var state_23605__$1 = state_23605;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23605__$1,inst_23603);
} else {
if((state_val_23606 === (4))){
var inst_23599 = (state_23605[(2)]);
var inst_23600 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$active,inst_23599);
var state_23605__$1 = (function (){var statearr_23608 = state_23605;
(statearr_23608[(7)] = inst_23600);

return statearr_23608;
})();
var statearr_23609_23619 = state_23605__$1;
(statearr_23609_23619[(2)] = null);

(statearr_23609_23619[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
});})(c__14822__auto__,chan,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,chan,___$1){
return (function() {
var camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto__ = null;
var camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto____0 = (function (){
var statearr_23610 = [null,null,null,null,null,null,null,null];
(statearr_23610[(0)] = camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto__);

(statearr_23610[(1)] = (1));

return statearr_23610;
});
var camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto____1 = (function (state_23605){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_23605);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e23611){if((e23611 instanceof Object)){
var ex__14726__auto__ = e23611;
var statearr_23612_23620 = state_23605;
(statearr_23612_23620[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23605);

return cljs.core.cst$kw$recur;
} else {
throw e23611;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__23621 = state_23605;
state_23605 = G__23621;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto__ = function(state_23605){
switch(arguments.length){
case 0:
return camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto____1.call(this,state_23605);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto____0;
camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto____1;
return camelot$component$deployment$core$action_menu_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,chan,___$1))
})();
var state__14824__auto__ = (function (){var statearr_23613 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_23613[(6)] = c__14822__auto__);

return statearr_23613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,chan,___$1))
);

return c__14822__auto__;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23594.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23594.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__23614 = ({"className": "section"});
var G__23615 = om.util.force_children((function (){var G__23616 = ({"className": "simple-menu"});
var G__23617 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.action_item_component,cljs.core.cst$kw$menu.cljs$core$IFn$_invoke$arity$1(self__.data),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$action,cljs.core.cst$kw$state,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$active,cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(self__.data))], null)));
return React.DOM.div(G__23616,G__23617);
})());
return React.DOM.div(G__23614,G__23615);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23594.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23595], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23594.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core23594.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core23594";

camelot.component.deployment.core.t_camelot$component$deployment$core23594.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core23594");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core23594 = (function camelot$component$deployment$core$action_menu_component_$___GT_t_camelot$component$deployment$core23594(data__$1,owner__$1,meta23595){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23594(data__$1,owner__$1,meta23595));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core23594(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.read_only_field_component = (function camelot$component$deployment$core$read_only_field_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core23622 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core23622 = (function (data,owner,meta23623){
this.data = data;
this.owner = owner;
this.meta23623 = meta23623;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.core.t_camelot$component$deployment$core23622.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23624,meta23623__$1){
var self__ = this;
var _23624__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23622(self__.data,self__.owner,meta23623__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core23622.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23624){
var self__ = this;
var _23624__$1 = this;
return self__.meta23623;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23622.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23622.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__23625 = ({"className": "field-details-item-container"});
var G__23626 = om.util.force_children((function (){var G__23628 = ({"className": "field-label"});
var G__23629 = om.util.force_children(cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(state));
return React.DOM.label(G__23628,G__23629);
})());
var G__23627 = om.util.force_children((function (){var G__23630 = ({"className": "field-details"});
var G__23631 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(state))?cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$value], null)):cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(state)));
return React.DOM.div(G__23630,G__23631);
})());
return React.DOM.div(G__23625,G__23626,G__23627);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23622.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23623], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23622.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core23622.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core23622";

camelot.component.deployment.core.t_camelot$component$deployment$core23622.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core23622");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core23622 = (function camelot$component$deployment$core$read_only_field_component_$___GT_t_camelot$component$deployment$core23622(data__$1,owner__$1,meta23623){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23622(data__$1,owner__$1,meta23623));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core23622(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for read-only details about the currently selected deployment.
 */
camelot.component.deployment.core.deployment_selected_details_component = (function camelot$component$deployment$core$deployment_selected_details_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core23632 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core23632 = (function (data,owner,meta23633){
this.data = data;
this.owner = owner;
this.meta23633 = meta23633;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.core.t_camelot$component$deployment$core23632.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23634,meta23633__$1){
var self__ = this;
var _23634__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23632(self__.data,self__.owner,meta23633__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core23632.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23634){
var self__ = this;
var _23634__$1 = this;
return self__.meta23633;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23632.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23632.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__23635 = ({"className": "section"});
var G__23636 = om.util.force_children((function (){var G__23640 = ({"className": "generic-container simple-menu"});
var G__23641 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$site_SLASH_site_DASH_name$label)], null)], null)):null));
var G__23642 = om.util.force_children((function (){var temp__4655__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_start_DASH_date,cljs.core.cst$kw$value], null));
if(cljs.core.truth_(temp__4655__auto__)){
var fv__23549__auto__ = temp__4655__auto__;
return om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$value,(function (){var fexpr__23653 = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs_time.format.unparse,camelot.component.deployment.core.day_formatter);
return (fexpr__23653.cljs$core$IFn$_invoke$arity$1 ? fexpr__23653.cljs$core$IFn$_invoke$arity$1(fv__23549__auto__) : fexpr__23653.call(null,fv__23549__auto__));
})(),cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_DASH_session_SLASH_trap_DASH_station_DASH_session_DASH_start_DASH_date$label)], null)], null));
} else {
return null;
}
})());
var G__23643 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_latitude,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_latitude,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_latitude$label)], null)], null)):null));
var G__23644 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_longitude,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_longitude,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_longitude$label)], null)], null)):null));
var G__23645 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$primary_DASH_camera_DASH_name,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$primary_DASH_camera_DASH_name,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_primary_DASH_camera_DASH_name)], null)], null)):null));
var G__23646 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$secondary_DASH_camera_DASH_name,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$secondary_DASH_camera_DASH_name,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_secondary_DASH_camera_DASH_name)], null)], null)):null));
var G__23647 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_altitude,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_altitude,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_altitude$label)], null)], null)):null));
var G__23648 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_above_DASH_ground,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_above_DASH_ground,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_distance_DASH_above_DASH_ground$label)], null)], null)):null));
var G__23649 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_road,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_road,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_distance_DASH_to_DASH_road$label)], null)], null)):null));
var G__23650 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_river,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_river,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_distance_DASH_to_DASH_river$label)], null)], null)):null));
var G__23651 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_settlement,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_distance_DASH_to_DASH_settlement,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_distance_DASH_to_DASH_settlement$label)], null)], null)):null));
var G__23652 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_notes,cljs.core.cst$kw$value], null)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.read_only_field_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$trap_DASH_station_DASH_notes,cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_notes$label)], null)], null)):null));
return React.DOM.div(G__23640,G__23641,G__23642,G__23643,G__23644,G__23645,G__23646,G__23647,G__23648,G__23649,G__23650,G__23651,G__23652);
})());
var G__23637 = om.util.force_children((function (){var G__23654 = ({"className": "sep"});
return React.DOM.div(G__23654);
})());
var G__23638 = om.util.force_children((function (){var G__23655 = ({"className": "btn btn-primary", "onClick": ((function (G__23635,G__23636,G__23637,___$1){
return (function (){
return camelot.nav.nav_BANG_(camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["deployments",cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_id,cljs.core.cst$kw$value], null)),"edit"], 0)));
});})(G__23635,G__23636,G__23637,___$1))
});
var G__23656 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_edit));
return React.DOM.button(G__23655,G__23656);
})());
var G__23639 = om.util.force_children((function (){var G__23657 = ({"className": "btn btn-default", "onClick": ((function (G__23635,G__23636,G__23637,G__23638,___$1){
return (function (){
camelot.nav.nav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/trap-station-sessions/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_id,cljs.core.cst$kw$value], null)))].join(''));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-survey","advanced-click");
});})(G__23635,G__23636,G__23637,G__23638,___$1))
});
var G__23658 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_advanced));
return React.DOM.button(G__23657,G__23658);
})());
return React.DOM.div(G__23635,G__23636,G__23637,G__23638,G__23639);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23632.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23633], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23632.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core23632.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core23632";

camelot.component.deployment.core.t_camelot$component$deployment$core23632.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core23632");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core23632 = (function camelot$component$deployment$core$deployment_selected_details_component_$___GT_t_camelot$component$deployment$core23632(data__$1,owner__$1,meta23633){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23632(data__$1,owner__$1,meta23633));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core23632(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.deployment_section_containers_component = (function camelot$component$deployment$core$deployment_section_containers_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core23659 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core23659 = (function (data,owner,meta23660){
this.data = data;
this.owner = owner;
this.meta23660 = meta23660;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.core.t_camelot$component$deployment$core23659.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23661,meta23660__$1){
var self__ = this;
var _23661__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23659(self__.data,self__.owner,meta23660__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core23659.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23661){
var self__ = this;
var _23661__$1 = this;
return self__.meta23660;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23659.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23659.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$can_DASH_edit_QMARK_,camelot.component.deployment.shared.can_edit_QMARK_(self__.data)], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23659.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23659.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(camelot.component.deployment.shared.can_edit_QMARK_(self__.data))){
return null;
} else {
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$active,cljs.core.cst$kw$details);
}
});

camelot.component.deployment.core.t_camelot$component$deployment$core23659.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23659.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__23662 = null;
var G__23663 = om.util.force_children((function (){var G__23665 = ({"className": "section-container"});
var G__23666 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.deployment.core.action_menu_component,self__.data));
return React.DOM.div(G__23665,G__23666);
})());
var G__23664 = om.util.force_children((function (){var G__23667 = ({"className": "section-container"});
var G__23668 = om.util.force_children((function (){var G__23669 = cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(self__.data);
var G__23669__$1 = (((G__23669 instanceof cljs.core.Keyword))?G__23669.fqn:null);
switch (G__23669__$1) {
case "details":
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.deployment.core.deployment_selected_details_component,self__.data);

break;
case "check":
return om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.camera_check.record_camera_check_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,state], null));

break;
default:
return null;

}
})());
return React.DOM.div(G__23667,G__23668);
})());
return React.DOM.div(G__23662,G__23663,G__23664);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23659.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23660], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23659.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core23659.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core23659";

camelot.component.deployment.core.t_camelot$component$deployment$core23659.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core23659");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core23659 = (function camelot$component$deployment$core$deployment_section_containers_component_$___GT_t_camelot$component$deployment$core23659(data__$1,owner__$1,meta23660){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23659(data__$1,owner__$1,meta23660));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core23659(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.edit_view_component = (function camelot$component$deployment$core$edit_view_component(app,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core23671 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core23671 = (function (app,owner,meta23672){
this.app = app;
this.owner = owner;
this.meta23672 = meta23672;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.core.t_camelot$component$deployment$core23671.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23673,meta23672__$1){
var self__ = this;
var _23673__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23671(self__.app,self__.owner,meta23672__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core23671.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23673){
var self__ = this;
var _23673__$1 = this;
return self__.meta23672;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23671.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23671.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.deployment.create.edit_component,self__.app);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23671.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23672], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23671.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core23671.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core23671";

camelot.component.deployment.core.t_camelot$component$deployment$core23671.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core23671");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core23671 = (function camelot$component$deployment$core$edit_view_component_$___GT_t_camelot$component$deployment$core23671(app__$1,owner__$1,meta23672){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23671(app__$1,owner__$1,meta23672));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core23671(app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.create_view_component = (function camelot$component$deployment$core$create_view_component(app,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core23674 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core23674 = (function (app,owner,meta23675){
this.app = app;
this.owner = owner;
this.meta23675 = meta23675;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.core.t_camelot$component$deployment$core23674.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23676,meta23675__$1){
var self__ = this;
var _23676__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23674(self__.app,self__.owner,meta23675__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core23674.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23676){
var self__ = this;
var _23676__$1 = this;
return self__.meta23675;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23674.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23674.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.deployment.create.view_component,self__.app);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23674.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23675], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23674.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core23674.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core23674";

camelot.component.deployment.core.t_camelot$component$deployment$core23674.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core23674");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core23674 = (function camelot$component$deployment$core$create_view_component_$___GT_t_camelot$component$deployment$core23674(app__$1,owner__$1,meta23675){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23674(app__$1,owner__$1,meta23675));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core23674(app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Top-level view for deployment components.
 */
camelot.component.deployment.core.deployment_view_component = (function camelot$component$deployment$core$deployment_view_component(app,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core23678 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core23678 = (function (app,owner,meta23679){
this.app = app;
this.owner = owner;
this.meta23679 = meta23679;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.core.t_camelot$component$deployment$core23678.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23680,meta23679__$1){
var self__ = this;
var _23680__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23678(self__.app,self__.owner,meta23679__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core23678.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23680){
var self__ = this;
var _23680__$1 = this;
return self__.meta23679;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23678.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23678.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,cljs.core.cst$kw$page_DASH_state,null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23678.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23678.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/deployment/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$page_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.app))].join(''),((function (___$1){
return (function (p1__23677_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,cljs.core.cst$kw$page_DASH_state,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__23677_SHARP_),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$validation_DASH_problem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,false], null)], null)], 0)),cljs.core.cst$kw$menu,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$action,cljs.core.cst$kw$check,cljs.core.cst$kw$name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_record_DASH_camera_DASH_check)], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$action,cljs.core.cst$kw$details,cljs.core.cst$kw$name,camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_details)], null)], null),cljs.core.cst$kw$active,cljs.core.cst$kw$check], null));
});})(___$1))
);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23678.prototype.om$core$IWillUnmount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23678.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,cljs.core.cst$kw$page_DASH_state,null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23678.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23678.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$page_DASH_state.cljs$core$IFn$_invoke$arity$1(self__.app))){
var G__23681 = ({"className": "split-menu"});
var G__23682 = om.util.force_children((function (){var G__23685 = ({"className": "back-button-container"});
var G__23686 = om.util.force_children((function (){var G__23687 = ({"className": "btn btn-default back", "onClick": ((function (G__23685,G__23681,___$1){
return (function (){
return camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$1((2));
});})(G__23685,G__23681,___$1))
});
var G__23688 = om.util.force_children((function (){var G__23691 = ({"className": "fa fa-mail-reply"});
return React.DOM.span(G__23691);
})());
var G__23689 = om.util.force_children(" ");
var G__23690 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_back));
return React.DOM.button(G__23687,G__23688,G__23689,G__23690);
})());
return React.DOM.div(G__23685,G__23686);
})());
var G__23683 = om.util.force_children((function (){var G__23692 = ({"className": "intro"});
var G__23693 = om.util.force_children((function (){var G__23694 = null;
var G__23695 = om.util.force_children(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$page_DASH_state,cljs.core.cst$kw$data,cljs.core.cst$kw$trap_DASH_station_DASH_name,cljs.core.cst$kw$value], null)));
return React.DOM.h4(G__23694,G__23695);
})());
return React.DOM.div(G__23692,G__23693);
})());
var G__23684 = om.util.force_children((function (){var G__23696 = null;
var G__23697 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.deployment.core.deployment_section_containers_component,cljs.core.cst$kw$page_DASH_state.cljs$core$IFn$_invoke$arity$1(self__.app)));
return React.DOM.div(G__23696,G__23697);
})());
return React.DOM.div(G__23681,G__23682,G__23683,G__23684);
} else {
var G__23698 = ({"className": "align-center"});
var G__23699 = om.util.force_children((function (){var G__23700 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__23700);
})());
return React.DOM.div(G__23698,G__23699);
}
});

camelot.component.deployment.core.t_camelot$component$deployment$core23678.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23679], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23678.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core23678.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core23678";

camelot.component.deployment.core.t_camelot$component$deployment$core23678.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core23678");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core23678 = (function camelot$component$deployment$core$deployment_view_component_$___GT_t_camelot$component$deployment$core23678(app__$1,owner__$1,meta23679){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23678(app__$1,owner__$1,meta23679));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core23678(app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.deployment_list_component = (function camelot$component$deployment$core$deployment_list_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core23701 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core23701 = (function (data,owner,meta23702){
this.data = data;
this.owner = owner;
this.meta23702 = meta23702;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.core.t_camelot$component$deployment$core23701.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23703,meta23702__$1){
var self__ = this;
var _23703__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23701(self__.data,self__.owner,meta23702__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core23701.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23703){
var self__ = this;
var _23703__$1 = this;
return self__.meta23702;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23701.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23701.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__23704 = ({"className": "menu-item detailed dynamic", "onClick": ((function (___$1){
return (function (){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("survey-deployment","trap-station-click");

return camelot.nav.nav_BANG_(camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["deployments",cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data)], 0)));
});})(___$1))
});
var G__23705 = om.util.force_children((function (){var G__23711 = ({"className": "pull-right fa fa-times remove top-corner", "onClick": cljs.core.partial.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.delete$,state,self__.data)});
return React.DOM.div(G__23711);
})());
var G__23706 = om.util.force_children((cljs.core.truth_((function (){var or__6624__auto__ = cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_end_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return (cljs.core.cst$kw$primary_DASH_camera_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data) == null);
}
})())?(function (){var G__23712 = ({"className": "status pull-right"});
var G__23713 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_finalised));
return React.DOM.span(G__23712,G__23713);
})():null));
var G__23707 = om.util.force_children((function (){var G__23714 = ({"className": "menu-item-title"});
var G__23715 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__23714,G__23715);
})());
var G__23708 = om.util.force_children((function (){var G__23716 = ({"className": "menu-item-description"});
var G__23717 = om.util.force_children((function (){var G__23724 = null;
var G__23725 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_latitude$label));
var G__23726 = om.util.force_children(":");
return React.DOM.label(G__23724,G__23725,G__23726);
})());
var G__23718 = om.util.force_children(" ");
var G__23719 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_latitude.cljs$core$IFn$_invoke$arity$1(self__.data));
var G__23720 = om.util.force_children(", ");
var G__23721 = om.util.force_children((function (){var G__23727 = null;
var G__23728 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$trap_DASH_station_SLASH_trap_DASH_station_DASH_longitude$label));
var G__23729 = om.util.force_children(":");
return React.DOM.label(G__23727,G__23728,G__23729);
})());
var G__23722 = om.util.force_children(" ");
var G__23723 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_longitude.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__23716,G__23717,G__23718,G__23719,G__23720,G__23721,G__23722,G__23723);
})());
var G__23709 = om.util.force_children((function (){var G__23730 = ({"className": "menu-item-description"});
var G__23731 = om.util.force_children((function (){var G__23734 = null;
var G__23735 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_start_DASH_date));
var G__23736 = om.util.force_children(":");
return React.DOM.label(G__23734,G__23735,G__23736);
})());
var G__23732 = om.util.force_children(" ");
var G__23733 = om.util.force_children(cljs_time.format.unparse(camelot.component.deployment.core.day_formatter,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_start_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data)));
return React.DOM.div(G__23730,G__23731,G__23732,G__23733);
})());
var G__23710 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_end_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__23737 = ({"className": "menu-item-description"});
var G__23738 = om.util.force_children((function (){var G__23741 = null;
var G__23742 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_end_DASH_date));
var G__23743 = om.util.force_children(":");
return React.DOM.label(G__23741,G__23742,G__23743);
})());
var G__23739 = om.util.force_children(" ");
var G__23740 = om.util.force_children(cljs_time.format.unparse(camelot.component.deployment.core.day_formatter,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_end_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data)));
return React.DOM.div(G__23737,G__23738,G__23739,G__23740);
})():null));
return React.DOM.div(G__23704,G__23705,G__23706,G__23707,G__23708,G__23709,G__23710);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23701.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23702], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23701.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core23701.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core23701";

camelot.component.deployment.core.t_camelot$component$deployment$core23701.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core23701");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core23701 = (function camelot$component$deployment$core$deployment_list_component_$___GT_t_camelot$component$deployment$core23701(data__$1,owner__$1,meta23702){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23701(data__$1,owner__$1,meta23702));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core23701(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.core.deployment_list_section_component = (function camelot$component$deployment$core$deployment_list_section_component(data,owner){
if(typeof camelot.component.deployment.core.t_camelot$component$deployment$core23746 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.core.t_camelot$component$deployment$core23746 = (function (data,owner,meta23747){
this.data = data;
this.owner = owner;
this.meta23747 = meta23747;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.core.t_camelot$component$deployment$core23746.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23748,meta23747__$1){
var self__ = this;
var _23748__$1 = this;
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23746(self__.data,self__.owner,meta23747__$1));
});

camelot.component.deployment.core.t_camelot$component$deployment$core23746.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23748){
var self__ = this;
var _23748__$1 = this;
return self__.meta23747;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23746.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23746.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23746.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23746.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$trap_DASH_stations,null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23746.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23746.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$deployment_DASH_sort_DASH_order,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_start_DASH_date);

camelot.rest.get_resource([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/deployment/survey/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null)))].join(''),((function (___$1){
return (function (p1__23744_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$trap_DASH_stations,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__23744_SHARP_));
});})(___$1))
);

var ch = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$chan);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,ch,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,ch,___$1){
return (function (state_23764){
var state_val_23765 = (state_23764[(1)]);
if((state_val_23765 === (1))){
var state_23764__$1 = state_23764;
var statearr_23766_23804 = state_23764__$1;
(statearr_23766_23804[(2)] = null);

(statearr_23766_23804[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23765 === (2))){
var state_23764__$1 = state_23764;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23764__$1,(4),ch);
} else {
if((state_val_23765 === (3))){
var inst_23762 = (state_23764[(2)]);
var state_23764__$1 = state_23764;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23764__$1,inst_23762);
} else {
if((state_val_23765 === (4))){
var inst_23751 = (state_23764[(7)]);
var inst_23751__$1 = (state_23764[(2)]);
var inst_23752 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(inst_23751__$1);
var inst_23753 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_23752,cljs.core.cst$kw$delete);
var state_23764__$1 = (function (){var statearr_23767 = state_23764;
(statearr_23767[(7)] = inst_23751__$1);

return statearr_23767;
})();
if(inst_23753){
var statearr_23768_23805 = state_23764__$1;
(statearr_23768_23805[(1)] = (5));

} else {
var statearr_23769_23806 = state_23764__$1;
(statearr_23769_23806[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23765 === (5))){
var inst_23751 = (state_23764[(7)]);
var inst_23755 = (function (){var r = inst_23751;
return ((function (r,inst_23751,state_val_23765,c__14822__auto__,ch,___$1){
return (function (p1__23745_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (r,inst_23751,state_val_23765,c__14822__auto__,ch,___$1){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(r));
});})(r,inst_23751,state_val_23765,c__14822__auto__,ch,___$1))
,p1__23745_SHARP_);
});
;})(r,inst_23751,state_val_23765,c__14822__auto__,ch,___$1))
})();
var inst_23756 = om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$trap_DASH_stations,inst_23755);
var state_23764__$1 = state_23764;
var statearr_23770_23807 = state_23764__$1;
(statearr_23770_23807[(2)] = inst_23756);

(statearr_23770_23807[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23765 === (6))){
var state_23764__$1 = state_23764;
var statearr_23771_23808 = state_23764__$1;
(statearr_23771_23808[(2)] = null);

(statearr_23771_23808[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23765 === (7))){
var inst_23759 = (state_23764[(2)]);
var state_23764__$1 = (function (){var statearr_23772 = state_23764;
(statearr_23772[(8)] = inst_23759);

return statearr_23772;
})();
var statearr_23773_23809 = state_23764__$1;
(statearr_23773_23809[(2)] = null);

(statearr_23773_23809[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__14822__auto__,ch,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,ch,___$1){
return (function() {
var camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto__ = null;
var camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto____0 = (function (){
var statearr_23774 = [null,null,null,null,null,null,null,null,null];
(statearr_23774[(0)] = camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto__);

(statearr_23774[(1)] = (1));

return statearr_23774;
});
var camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto____1 = (function (state_23764){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_23764);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e23775){if((e23775 instanceof Object)){
var ex__14726__auto__ = e23775;
var statearr_23776_23810 = state_23764;
(statearr_23776_23810[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23764);

return cljs.core.cst$kw$recur;
} else {
throw e23775;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__23811 = state_23764;
state_23764 = G__23811;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto__ = function(state_23764){
switch(arguments.length){
case 0:
return camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto____1.call(this,state_23764);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto____0;
camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto____1;
return camelot$component$deployment$core$deployment_list_section_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,ch,___$1))
})();
var state__14824__auto__ = (function (){var statearr_23777 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_23777[(6)] = c__14822__auto__);

return statearr_23777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,ch,___$1))
);

return c__14822__auto__;
});

camelot.component.deployment.core.t_camelot$component$deployment$core23746.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.core.t_camelot$component$deployment$core23746.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$trap_DASH_stations.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__23778 = ({"className": "section"});
var G__23779 = om.util.force_children((function (){var G__23782 = ({"className": "simple-menu"});
var G__23783 = om.util.force_children(((cljs.core.empty_QMARK_(cljs.core.cst$kw$trap_DASH_stations.cljs$core$IFn$_invoke$arity$1(self__.data)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.blank_slate_component,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$item_DASH_name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_blank_DASH_item_DASH_name_DASH_lc),cljs.core.cst$kw$advice,(function (){var G__23784 = null;
var G__23785 = om.util.force_children((function (){var G__23787 = null;
var G__23788 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_advice_DASH_context));
return React.DOM.p(G__23787,G__23788);
})());
var G__23786 = om.util.force_children((function (){var G__23789 = null;
var G__23790 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_advice_DASH_direction));
return React.DOM.p(G__23789,G__23790);
})());
return React.DOM.div(G__23784,G__23785,G__23786);
})()], null)], null)):(function (){var G__23791 = null;
var G__23792 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.shared.deployment_sort_menu,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$show_DASH_end_DASH_date,true], null)], null)));
var G__23793 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.core.deployment_list_component,cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (){var G__23794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.cst$kw$deployment_DASH_sort_DASH_order);
return (camelot.component.deployment.shared.deployment_sorters.cljs$core$IFn$_invoke$arity$1 ? camelot.component.deployment.shared.deployment_sorters.cljs$core$IFn$_invoke$arity$1(G__23794) : camelot.component.deployment.shared.deployment_sorters.call(null,G__23794));
})(),cljs.core.cst$kw$trap_DASH_stations.cljs$core$IFn$_invoke$arity$1(self__.data)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_id,cljs.core.cst$kw$init_DASH_state,state], null)));
return React.DOM.div(G__23791,G__23792,G__23793);
})()));
return React.DOM.div(G__23782,G__23783);
})());
var G__23780 = om.util.force_children((function (){var G__23795 = ({"className": "sep"});
return React.DOM.div(G__23795);
})());
var G__23781 = om.util.force_children((function (){var G__23796 = ({"className": "btn btn-primary", "onClick": ((function (G__23778,G__23779,G__23780,___$1){
return (function (){
camelot.nav.nav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/deployments/create")].join(''));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("survey-deployment","create-click");
});})(G__23778,G__23779,G__23780,___$1))
, "title": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_create_DASH_title)});
var G__23797 = om.util.force_children((function (){var G__23800 = ({"className": "fa fa-plus"});
return React.DOM.span(G__23800);
})());
var G__23798 = om.util.force_children(" ");
var G__23799 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$core_SLASH_create_DASH_button));
return React.DOM.button(G__23796,G__23797,G__23798,G__23799);
})());
return React.DOM.div(G__23778,G__23779,G__23780,G__23781);
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$deployment_DASH_sort_DASH_order,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_start_DASH_date);

var G__23801 = ({"className": "align-center"});
var G__23802 = om.util.force_children((function (){var G__23803 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__23803);
})());
return React.DOM.div(G__23801,G__23802);
}
});

camelot.component.deployment.core.t_camelot$component$deployment$core23746.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23747], null);
});

camelot.component.deployment.core.t_camelot$component$deployment$core23746.cljs$lang$type = true;

camelot.component.deployment.core.t_camelot$component$deployment$core23746.cljs$lang$ctorStr = "camelot.component.deployment.core/t_camelot$component$deployment$core23746";

camelot.component.deployment.core.t_camelot$component$deployment$core23746.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.core/t_camelot$component$deployment$core23746");
});

camelot.component.deployment.core.__GT_t_camelot$component$deployment$core23746 = (function camelot$component$deployment$core$deployment_list_section_component_$___GT_t_camelot$component$deployment$core23746(data__$1,owner__$1,meta23747){
return (new camelot.component.deployment.core.t_camelot$component$deployment$core23746(data__$1,owner__$1,meta23747));
});

}

return (new camelot.component.deployment.core.t_camelot$component$deployment$core23746(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
