// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.deployment.recent');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.core');
goog.require('camelot.nav');
goog.require('camelot.util.capture');
goog.require('camelot.component.deployment.shared');
goog.require('camelot.component.survey.create');
goog.require('camelot.component.progress_bar');
goog.require('om.dom');
goog.require('cljs.core.async');
goog.require('camelot.state');
goog.require('camelot.rest');
goog.require('cljs_time.format');
goog.require('camelot.component.util');
goog.require('camelot.translation.core');
camelot.component.deployment.recent.day_formatter = cljs_time.format.formatter.cljs$core$IFn$_invoke$arity$1("yyyy-MM-dd");
camelot.component.deployment.recent.help_text = camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_help_DASH_text);
/**
 * Delete the session camera and trigger a removal event.
 */
camelot.component.deployment.recent.delete$ = (function camelot$component$deployment$recent$delete(state,data,event){
event.preventDefault();

event.stopPropagation();

if(cljs.core.truth_((function (){var G__21664 = (cljs.core.truth_(cljs.core.cst$kw$has_DASH_uploaded_DASH_media.cljs$core$IFn$_invoke$arity$1(data))?camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_confirm_DASH_delete_DASH_has_DASH_media):camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_confirm_DASH_delete));
return confirm(G__21664);
})())){
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/trap-station-session-cameras/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera_DASH_id.cljs$core$IFn$_invoke$arity$1(data))].join(''),(function (){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_21672){
var state_val_21673 = (state_21672[(1)]);
if((state_val_21673 === (1))){
var inst_21665 = cljs.core.cst$kw$chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_21666 = [cljs.core.cst$kw$event,cljs.core.cst$kw$data];
var inst_21667 = [cljs.core.cst$kw$delete,data];
var inst_21668 = cljs.core.PersistentHashMap.fromArrays(inst_21666,inst_21667);
var state_21672__$1 = state_21672;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21672__$1,(2),inst_21665,inst_21668);
} else {
if((state_val_21673 === (2))){
var inst_21670 = (state_21672[(2)]);
var state_21672__$1 = state_21672;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21672__$1,inst_21670);
} else {
return null;
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$component$deployment$recent$delete_$_state_machine__14723__auto__ = null;
var camelot$component$deployment$recent$delete_$_state_machine__14723__auto____0 = (function (){
var statearr_21674 = [null,null,null,null,null,null,null];
(statearr_21674[(0)] = camelot$component$deployment$recent$delete_$_state_machine__14723__auto__);

(statearr_21674[(1)] = (1));

return statearr_21674;
});
var camelot$component$deployment$recent$delete_$_state_machine__14723__auto____1 = (function (state_21672){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_21672);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e21675){if((e21675 instanceof Object)){
var ex__14726__auto__ = e21675;
var statearr_21676_21678 = state_21672;
(statearr_21676_21678[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21672);

return cljs.core.cst$kw$recur;
} else {
throw e21675;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__21679 = state_21672;
state_21672 = G__21679;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$deployment$recent$delete_$_state_machine__14723__auto__ = function(state_21672){
switch(arguments.length){
case 0:
return camelot$component$deployment$recent$delete_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$deployment$recent$delete_$_state_machine__14723__auto____1.call(this,state_21672);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$deployment$recent$delete_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$recent$delete_$_state_machine__14723__auto____0;
camelot$component$deployment$recent$delete_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$recent$delete_$_state_machine__14723__auto____1;
return camelot$component$deployment$recent$delete_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_21677 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_21677[(6)] = c__14822__auto__);

return statearr_21677;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
}));
} else {
return null;
}
});
camelot.component.deployment.recent.add_upload_problem = (function camelot$component$deployment$recent$add_upload_problem(owner,event_details,desc){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.nav.analytics_event,"capture-upload"),event_details);

if((om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$errors) == null)){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$errors,desc);
} else {
return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$errors,(function (p1__21680_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__21680_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1(desc)].join('');
}));
}
});
camelot.component.deployment.recent.is_uploadable_QMARK_ = (function camelot$component$deployment$recent$is_uploadable_QMARK_(file){
return cljs.core.some((function (p1__21681_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(file.type,p1__21681_SHARP_);
}),cljs.core.keys(camelot.util.capture.image_mimes));
});
camelot.component.deployment.recent.unsupported_str = (function camelot$component$deployment$recent$unsupported_str(file){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(camelot.translation.core.translate.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_format_DASH_not_DASH_supported,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([file.name], 0))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n")].join('');
});
camelot.component.deployment.recent.upload_file = (function camelot$component$deployment$recent$upload_file(sesscam_id,owner,file,chan){
if(cljs.core.truth_(camelot.component.deployment.recent.is_uploadable_QMARK_(file))){
return camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$4("/capture/upload",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["session-camera-id",sesscam_id], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["file",file], null)], null),(function (p1__21682_SHARP_){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_21692){
var state_val_21693 = (state_21692[(1)]);
if((state_val_21693 === (1))){
var inst_21683 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__21682_SHARP_);
var inst_21684 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_21683);
var inst_21685 = [cljs.core.cst$kw$file,cljs.core.cst$kw$success,cljs.core.cst$kw$error];
var inst_21686 = (inst_21684 == null);
var inst_21687 = [file,inst_21686,inst_21684];
var inst_21688 = cljs.core.PersistentHashMap.fromArrays(inst_21685,inst_21687);
var state_21692__$1 = state_21692;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21692__$1,(2),chan,inst_21688);
} else {
if((state_val_21693 === (2))){
var inst_21690 = (state_21692[(2)]);
var state_21692__$1 = state_21692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21692__$1,inst_21690);
} else {
return null;
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__ = null;
var camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____0 = (function (){
var statearr_21694 = [null,null,null,null,null,null,null];
(statearr_21694[(0)] = camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__);

(statearr_21694[(1)] = (1));

return statearr_21694;
});
var camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____1 = (function (state_21692){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_21692);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e21695){if((e21695 instanceof Object)){
var ex__14726__auto__ = e21695;
var statearr_21696_21710 = state_21692;
(statearr_21696_21710[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21692);

return cljs.core.cst$kw$recur;
} else {
throw e21695;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__21711 = state_21692;
state_21692 = G__21711;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__ = function(state_21692){
switch(arguments.length){
case 0:
return camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____1.call(this,state_21692);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____0;
camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____1;
return camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_21697 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_21697[(6)] = c__14822__auto__);

return statearr_21697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
}),(function (){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_21704){
var state_val_21705 = (state_21704[(1)]);
if((state_val_21705 === (1))){
var inst_21698 = [cljs.core.cst$kw$file,cljs.core.cst$kw$success];
var inst_21699 = [file,false];
var inst_21700 = cljs.core.PersistentHashMap.fromArrays(inst_21698,inst_21699);
var state_21704__$1 = state_21704;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21704__$1,(2),chan,inst_21700);
} else {
if((state_val_21705 === (2))){
var inst_21702 = (state_21704[(2)]);
var state_21704__$1 = state_21704;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21704__$1,inst_21702);
} else {
return null;
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__ = null;
var camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____0 = (function (){
var statearr_21706 = [null,null,null,null,null,null,null];
(statearr_21706[(0)] = camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__);

(statearr_21706[(1)] = (1));

return statearr_21706;
});
var camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____1 = (function (state_21704){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_21704);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e21707){if((e21707 instanceof Object)){
var ex__14726__auto__ = e21707;
var statearr_21708_21712 = state_21704;
(statearr_21708_21712[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21704);

return cljs.core.cst$kw$recur;
} else {
throw e21707;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__21713 = state_21704;
state_21704 = G__21713;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__ = function(state_21704){
switch(arguments.length){
case 0:
return camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____1.call(this,state_21704);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____0;
camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto____1;
return camelot$component$deployment$recent$upload_file_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_21709 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_21709[(6)] = c__14822__auto__);

return statearr_21709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
}));
} else {
return camelot.component.deployment.recent.add_upload_problem(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["skipped",file.type], null),camelot.component.deployment.recent.unsupported_str(file));
}
});
camelot.component.deployment.recent.uploadable_count = (function camelot$component$deployment$recent$uploadable_count(fs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__21715_SHARP_,p2__21714_SHARP_){
if(cljs.core.truth_(camelot.component.deployment.recent.is_uploadable_QMARK_((fs[p2__21714_SHARP_])))){
return (p1__21715_SHARP_ + (1));
} else {
return p1__21715_SHARP_;
}
}),(0),cljs.core.range.cljs$core$IFn$_invoke$arity$1(fs.length));
});
camelot.component.deployment.recent.display_upload_failure = (function camelot$component$deployment$recent$display_upload_failure(owner,f,err){
var reason = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("' "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__6624__auto__ = err;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_upload_DASH_error);
}
})()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n")].join('');
var desc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("'"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(f.name),cljs.core.str.cljs$core$IFn$_invoke$arity$1(reason)].join('');
return camelot.component.deployment.recent.add_upload_problem(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["failed",f.type], null),desc);
});
camelot.component.deployment.recent.handle_upload_failure = (function camelot$component$deployment$recent$handle_upload_failure(owner,f,err){
camelot.component.deployment.recent.display_upload_failure(owner,f,err);

return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$failed,cljs.core.inc);
});
camelot.component.deployment.recent.drop_file_handler = (function camelot$component$deployment$recent$drop_file_handler(data,owner,files){
var uploadable = camelot.component.deployment.recent.uploadable_count(files);
var upl_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("capture-upload","upload-init");

om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$total,((function (uploadable,upl_chan){
return (function (p1__21716_SHARP_){
return (p1__21716_SHARP_ + files.length);
});})(uploadable,upl_chan))
);

om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$ignored,((function (uploadable,upl_chan){
return (function (p1__21717_SHARP_){
return (p1__21717_SHARP_ + (files.length - uploadable));
});})(uploadable,upl_chan))
);

var c__14822__auto___21756 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___21756,uploadable,upl_chan){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___21756,uploadable,upl_chan){
return (function (state_21737){
var state_val_21738 = (state_21737[(1)]);
if((state_val_21738 === (1))){
var state_21737__$1 = state_21737;
var statearr_21739_21757 = state_21737__$1;
(statearr_21739_21757[(2)] = null);

(statearr_21739_21757[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21738 === (2))){
var state_21737__$1 = state_21737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21737__$1,(4),upl_chan);
} else {
if((state_val_21738 === (3))){
var inst_21735 = (state_21737[(2)]);
var state_21737__$1 = state_21737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21737__$1,inst_21735);
} else {
if((state_val_21738 === (4))){
var inst_21720 = (state_21737[(7)]);
var inst_21720__$1 = (state_21737[(2)]);
var inst_21721 = cljs.core.cst$kw$success.cljs$core$IFn$_invoke$arity$1(inst_21720__$1);
var state_21737__$1 = (function (){var statearr_21740 = state_21737;
(statearr_21740[(7)] = inst_21720__$1);

return statearr_21740;
})();
if(cljs.core.truth_(inst_21721)){
var statearr_21741_21758 = state_21737__$1;
(statearr_21741_21758[(1)] = (5));

} else {
var statearr_21742_21759 = state_21737__$1;
(statearr_21742_21759[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21738 === (5))){
var inst_21720 = (state_21737[(7)]);
var inst_21723 = om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$complete,cljs.core.inc);
var inst_21724 = cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(inst_21720);
var inst_21725 = inst_21724.type;
var inst_21726 = camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$3("capture-upload","success",inst_21725);
var state_21737__$1 = (function (){var statearr_21743 = state_21737;
(statearr_21743[(8)] = inst_21723);

return statearr_21743;
})();
var statearr_21744_21760 = state_21737__$1;
(statearr_21744_21760[(2)] = inst_21726);

(statearr_21744_21760[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21738 === (6))){
var inst_21720 = (state_21737[(7)]);
var inst_21728 = cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(inst_21720);
var inst_21729 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_21720);
var inst_21730 = camelot.component.deployment.recent.handle_upload_failure(owner,inst_21728,inst_21729);
var state_21737__$1 = state_21737;
var statearr_21745_21761 = state_21737__$1;
(statearr_21745_21761[(2)] = inst_21730);

(statearr_21745_21761[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21738 === (7))){
var inst_21732 = (state_21737[(2)]);
var state_21737__$1 = (function (){var statearr_21746 = state_21737;
(statearr_21746[(9)] = inst_21732);

return statearr_21746;
})();
var statearr_21747_21762 = state_21737__$1;
(statearr_21747_21762[(2)] = null);

(statearr_21747_21762[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__14822__auto___21756,uploadable,upl_chan))
;
return ((function (switch__14722__auto__,c__14822__auto___21756,uploadable,upl_chan){
return (function() {
var camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto__ = null;
var camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto____0 = (function (){
var statearr_21748 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21748[(0)] = camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto__);

(statearr_21748[(1)] = (1));

return statearr_21748;
});
var camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto____1 = (function (state_21737){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_21737);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e21749){if((e21749 instanceof Object)){
var ex__14726__auto__ = e21749;
var statearr_21750_21763 = state_21737;
(statearr_21750_21763[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21737);

return cljs.core.cst$kw$recur;
} else {
throw e21749;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__21764 = state_21737;
state_21737 = G__21764;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto__ = function(state_21737){
switch(arguments.length){
case 0:
return camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto____1.call(this,state_21737);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto____0;
camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto____1;
return camelot$component$deployment$recent$drop_file_handler_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___21756,uploadable,upl_chan))
})();
var state__14824__auto__ = (function (){var statearr_21751 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_21751[(6)] = c__14822__auto___21756);

return statearr_21751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___21756,uploadable,upl_chan))
);


var seq__21752 = cljs.core.seq(cljs.core.range.cljs$core$IFn$_invoke$arity$1(files.length));
var chunk__21753 = null;
var count__21754 = (0);
var i__21755 = (0);
while(true){
if((i__21755 < count__21754)){
var idx = chunk__21753.cljs$core$IIndexed$_nth$arity$2(null,i__21755);
camelot.component.deployment.recent.upload_file(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera_DASH_id.cljs$core$IFn$_invoke$arity$1(data),owner,(files[idx]),upl_chan);

var G__21765 = seq__21752;
var G__21766 = chunk__21753;
var G__21767 = count__21754;
var G__21768 = (i__21755 + (1));
seq__21752 = G__21765;
chunk__21753 = G__21766;
count__21754 = G__21767;
i__21755 = G__21768;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__21752);
if(temp__4657__auto__){
var seq__21752__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__21752__$1)){
var c__7444__auto__ = cljs.core.chunk_first(seq__21752__$1);
var G__21769 = cljs.core.chunk_rest(seq__21752__$1);
var G__21770 = c__7444__auto__;
var G__21771 = cljs.core.count(c__7444__auto__);
var G__21772 = (0);
seq__21752 = G__21769;
chunk__21753 = G__21770;
count__21754 = G__21771;
i__21755 = G__21772;
continue;
} else {
var idx = cljs.core.first(seq__21752__$1);
camelot.component.deployment.recent.upload_file(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera_DASH_id.cljs$core$IFn$_invoke$arity$1(data),owner,(files[idx]),upl_chan);

var G__21773 = cljs.core.next(seq__21752__$1);
var G__21774 = null;
var G__21775 = (0);
var G__21776 = (0);
seq__21752 = G__21773;
chunk__21753 = G__21774;
count__21754 = G__21775;
i__21755 = G__21776;
continue;
}
} else {
return null;
}
}
break;
}
});
camelot.component.deployment.recent.recent_deployment_list_component = (function camelot$component$deployment$recent$recent_deployment_list_component(data,owner){
if(typeof camelot.component.deployment.recent.t_camelot$component$deployment$recent21780 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.recent.t_camelot$component$deployment$recent21780 = (function (data,owner,meta21781){
this.data = data;
this.owner = owner;
this.meta21781 = meta21781;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21782,meta21781__$1){
var self__ = this;
var _21782__$1 = this;
return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent21780(self__.data,self__.owner,meta21781__$1));
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21782){
var self__ = this;
var _21782__$1 = this;
return self__.meta21781;
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$total,(0),cljs.core.cst$kw$ignored,(0),cljs.core.cst$kw$complete,(0),cljs.core.cst$kw$failed,(0),cljs.core.cst$kw$errors,null], null);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var n = om.core.get_node.cljs$core$IFn$_invoke$arity$1(self__.owner);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$total,(0));

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$complete,(0));

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$failed,(0));

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$errors,null);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$ignored,(0));

n.addEventListener("dragenter",((function (n,___$1){
return (function (p1__21777_SHARP_){
p1__21777_SHARP_.stopPropagation();

return p1__21777_SHARP_.preventDefault();
});})(n,___$1))
);

n.addEventListener("dragover",((function (n,___$1){
return (function (p1__21778_SHARP_){
p1__21778_SHARP_.stopPropagation();

return p1__21778_SHARP_.preventDefault();
});})(n,___$1))
);

return n.addEventListener("drop",((function (n,___$1){
return (function (p1__21779_SHARP_){
p1__21779_SHARP_.stopPropagation();

p1__21779_SHARP_.preventDefault();

var fs = p1__21779_SHARP_.dataTransfer.files;
return camelot.component.deployment.recent.drop_file_handler(self__.data,self__.owner,fs);
});})(n,___$1))
);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__21783 = ({"className": "menu-item detailed dynamic no-click", "onClick": ((function (___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.display_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$notification,cljs.core.cst$kw$info], null),cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(state));
});})(___$1))
});
var G__21784 = om.util.force_children((function (){var G__21792 = ({"className": "pull-right fa fa-times remove top-corner", "onClick": cljs.core.partial.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.recent.delete$,state,self__.data)});
return React.DOM.div(G__21792);
})());
var G__21785 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$has_DASH_uploaded_DASH_media.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__21793 = ({"className": "status pull-right"});
var G__21794 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_media_DASH_uploaded));
return React.DOM.span(G__21793,G__21794);
})():null));
var G__21786 = om.util.force_children((function (){var G__21795 = ({"className": "menu-item-title"});
var G__21796 = om.util.force_children(cljs.core.cst$kw$camera_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
var G__21797 = om.util.force_children(" ");
var G__21798 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_at_DASH_lc));
var G__21799 = om.util.force_children(" ");
var G__21800 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.div(G__21795,G__21796,G__21797,G__21798,G__21799,G__21800);
})());
var G__21787 = om.util.force_children((cljs.core.truth_((function (){var and__6612__auto__ = cljs.core.cst$kw$total.cljs$core$IFn$_invoke$arity$1(state);
if(cljs.core.truth_(and__6612__auto__)){
return ((cljs.core.cst$kw$total.cljs$core$IFn$_invoke$arity$1(state) > (0))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$ignored.cljs$core$IFn$_invoke$arity$1(state) + cljs.core.cst$kw$failed.cljs$core$IFn$_invoke$arity$1(state)) + cljs.core.cst$kw$complete.cljs$core$IFn$_invoke$arity$1(state)),cljs.core.cst$kw$total.cljs$core$IFn$_invoke$arity$1(state)));
} else {
return and__6612__auto__;
}
})())?(function (){var G__21801 = ({"className": "pull-right fa fa-check fa-3x green"});
return React.DOM.span(G__21801);
})():null));
var G__21788 = om.util.force_children((function (){var G__21802 = ({"className": "menu-item-description"});
var G__21803 = om.util.force_children((function (){var G__21810 = null;
var G__21811 = om.util.force_children(" ");
var G__21812 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_date));
var G__21813 = om.util.force_children(":");
return React.DOM.label(G__21810,G__21811,G__21812,G__21813);
})());
var G__21804 = om.util.force_children(" ");
var G__21805 = om.util.force_children(cljs_time.format.unparse(camelot.component.deployment.recent.day_formatter,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_start_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data)));
var G__21806 = om.util.force_children(" ");
var G__21807 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_to_DASH_lc));
var G__21808 = om.util.force_children(" ");
var G__21809 = om.util.force_children(cljs_time.format.unparse(camelot.component.deployment.recent.day_formatter,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_end_DASH_date.cljs$core$IFn$_invoke$arity$1(self__.data)));
return React.DOM.div(G__21802,G__21803,G__21804,G__21805,G__21806,G__21807,G__21808,G__21809);
})());
var G__21789 = om.util.force_children((function (){var G__21814 = ({"className": "menu-item-description"});
var G__21815 = om.util.force_children((function (){var G__21820 = null;
var G__21821 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_gps_DASH_coordinates));
var G__21822 = om.util.force_children(":");
return React.DOM.label(G__21820,G__21821,G__21822);
})());
var G__21816 = om.util.force_children(" ");
var G__21817 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_latitude.cljs$core$IFn$_invoke$arity$1(self__.data));
var G__21818 = om.util.force_children(", ");
var G__21819 = om.util.force_children(cljs.core.cst$kw$trap_DASH_station_DASH_longitude.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.div(G__21814,G__21815,G__21816,G__21817,G__21818,G__21819);
})());
var G__21790 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.progress_bar.component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,cljs.core.select_keys(state,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$total,cljs.core.cst$kw$ignored,cljs.core.cst$kw$complete,cljs.core.cst$kw$failed], null))], null)));
var G__21791 = om.util.force_children(((((cljs.core.get.cljs$core$IFn$_invoke$arity$2(state,cljs.core.cst$kw$ignored) + cljs.core.get.cljs$core$IFn$_invoke$arity$2(state,cljs.core.cst$kw$failed)) === (0)))?null:(function (){var G__21823 = ({"className": "pointer"});
var G__21824 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_show_DASH_details));
return React.DOM.div(G__21823,G__21824);
})()));
return React.DOM.div(G__21783,G__21784,G__21785,G__21786,G__21787,G__21788,G__21789,G__21790,G__21791);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta21781], null);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.cljs$lang$type = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.cljs$lang$ctorStr = "camelot.component.deployment.recent/t_camelot$component$deployment$recent21780";

camelot.component.deployment.recent.t_camelot$component$deployment$recent21780.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.recent/t_camelot$component$deployment$recent21780");
});

camelot.component.deployment.recent.__GT_t_camelot$component$deployment$recent21780 = (function camelot$component$deployment$recent$recent_deployment_list_component_$___GT_t_camelot$component$deployment$recent21780(data__$1,owner__$1,meta21781){
return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent21780(data__$1,owner__$1,meta21781));
});

}

return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent21780(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.deployment.recent.recent_deployment_section_component = (function camelot$component$deployment$recent$recent_deployment_section_component(data,owner){
if(typeof camelot.component.deployment.recent.t_camelot$component$deployment$recent21827 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.deployment.recent.t_camelot$component$deployment$recent21827 = (function (data,owner,meta21828){
this.data = data;
this.owner = owner;
this.meta21828 = meta21828;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21829,meta21828__$1){
var self__ = this;
var _21829__$1 = this;
return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent21827(self__.data,self__.owner,meta21828__$1));
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21829){
var self__ = this;
var _21829__$1 = this;
return self__.meta21828;
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$recent_DASH_deployments,null);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$deployment_DASH_sort_DASH_order,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_end_DASH_date);

camelot.rest.get_resource([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/camera-deployment/survey/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/recent")].join(''),((function (___$1){
return (function (p1__21825_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$recent_DASH_deployments,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__21825_SHARP_));
});})(___$1))
);

var ch = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$chan);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,ch,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,ch,___$1){
return (function (state_21845){
var state_val_21846 = (state_21845[(1)]);
if((state_val_21846 === (1))){
var state_21845__$1 = state_21845;
var statearr_21847_21873 = state_21845__$1;
(statearr_21847_21873[(2)] = null);

(statearr_21847_21873[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21846 === (2))){
var state_21845__$1 = state_21845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21845__$1,(4),ch);
} else {
if((state_val_21846 === (3))){
var inst_21843 = (state_21845[(2)]);
var state_21845__$1 = state_21845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21845__$1,inst_21843);
} else {
if((state_val_21846 === (4))){
var inst_21832 = (state_21845[(7)]);
var inst_21832__$1 = (state_21845[(2)]);
var inst_21833 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(inst_21832__$1);
var inst_21834 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21833,cljs.core.cst$kw$delete);
var state_21845__$1 = (function (){var statearr_21848 = state_21845;
(statearr_21848[(7)] = inst_21832__$1);

return statearr_21848;
})();
if(inst_21834){
var statearr_21849_21874 = state_21845__$1;
(statearr_21849_21874[(1)] = (5));

} else {
var statearr_21850_21875 = state_21845__$1;
(statearr_21850_21875[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21846 === (5))){
var inst_21832 = (state_21845[(7)]);
var inst_21836 = (function (){var r = inst_21832;
return ((function (r,inst_21832,state_val_21846,c__14822__auto__,ch,___$1){
return (function (p1__21826_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (r,inst_21832,state_val_21846,c__14822__auto__,ch,___$1){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(r));
});})(r,inst_21832,state_val_21846,c__14822__auto__,ch,___$1))
,p1__21826_SHARP_);
});
;})(r,inst_21832,state_val_21846,c__14822__auto__,ch,___$1))
})();
var inst_21837 = om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$recent_DASH_deployments,inst_21836);
var state_21845__$1 = state_21845;
var statearr_21851_21876 = state_21845__$1;
(statearr_21851_21876[(2)] = inst_21837);

(statearr_21851_21876[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21846 === (6))){
var state_21845__$1 = state_21845;
var statearr_21852_21877 = state_21845__$1;
(statearr_21852_21877[(2)] = null);

(statearr_21852_21877[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21846 === (7))){
var inst_21840 = (state_21845[(2)]);
var state_21845__$1 = (function (){var statearr_21853 = state_21845;
(statearr_21853[(8)] = inst_21840);

return statearr_21853;
})();
var statearr_21854_21878 = state_21845__$1;
(statearr_21854_21878[(2)] = null);

(statearr_21854_21878[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__14822__auto__,ch,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,ch,___$1){
return (function() {
var camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto__ = null;
var camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto____0 = (function (){
var statearr_21855 = [null,null,null,null,null,null,null,null,null];
(statearr_21855[(0)] = camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto__);

(statearr_21855[(1)] = (1));

return statearr_21855;
});
var camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto____1 = (function (state_21845){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_21845);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e21856){if((e21856 instanceof Object)){
var ex__14726__auto__ = e21856;
var statearr_21857_21879 = state_21845;
(statearr_21857_21879[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21845);

return cljs.core.cst$kw$recur;
} else {
throw e21856;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__21880 = state_21845;
state_21845 = G__21880;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto__ = function(state_21845){
switch(arguments.length){
case 0:
return camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto____1.call(this,state_21845);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto____0;
camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto____1;
return camelot$component$deployment$recent$recent_deployment_section_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,ch,___$1))
})();
var state__14824__auto__ = (function (){var statearr_21858 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_21858[(6)] = c__14822__auto__);

return statearr_21858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,ch,___$1))
);

return c__14822__auto__;
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if((cljs.core.cst$kw$recent_DASH_deployments.cljs$core$IFn$_invoke$arity$1(self__.data) == null)){
var G__21859 = ({"className": "align-center"});
var G__21860 = om.util.force_children((function (){var G__21861 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__21861);
})());
return React.DOM.div(G__21859,G__21860);
} else {
var G__21862 = ({"className": "section"});
var G__21863 = om.util.force_children((function (){var G__21864 = ({"className": "simple-menu"});
var G__21865 = om.util.force_children(((cljs.core.empty_QMARK_(cljs.core.cst$kw$recent_DASH_deployments.cljs$core$IFn$_invoke$arity$1(self__.data)))?om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.blank_slate_component,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$item_DASH_name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_blank_DASH_item_DASH_name),cljs.core.cst$kw$advice,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$deployment$recent_SLASH_blank_DASH_advice)], null)], null)):(function (){var G__21866 = null;
var G__21867 = om.util.force_children((function (){var G__21870 = ({"className": "help-text"});
var G__21871 = om.util.force_children(camelot.component.deployment.recent.help_text);
return React.DOM.div(G__21870,G__21871);
})());
var G__21868 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.shared.deployment_sort_menu,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$show_DASH_end_DASH_date,true], null)], null)));
var G__21869 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.deployment.recent.recent_deployment_list_component,cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (){var G__21872 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.cst$kw$deployment_DASH_sort_DASH_order);
return (camelot.component.deployment.shared.deployment_sorters.cljs$core$IFn$_invoke$arity$1 ? camelot.component.deployment.shared.deployment_sorters.cljs$core$IFn$_invoke$arity$1(G__21872) : camelot.component.deployment.shared.deployment_sorters.call(null,G__21872));
})(),cljs.core.cst$kw$recent_DASH_deployments.cljs$core$IFn$_invoke$arity$1(self__.data)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera_DASH_id,cljs.core.cst$kw$init_DASH_state,state], null)));
return React.DOM.div(G__21866,G__21867,G__21868,G__21869);
})()));
return React.DOM.div(G__21864,G__21865);
})());
return React.DOM.div(G__21862,G__21863);
}
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta21828], null);
});

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.cljs$lang$type = true;

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.cljs$lang$ctorStr = "camelot.component.deployment.recent/t_camelot$component$deployment$recent21827";

camelot.component.deployment.recent.t_camelot$component$deployment$recent21827.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.deployment.recent/t_camelot$component$deployment$recent21827");
});

camelot.component.deployment.recent.__GT_t_camelot$component$deployment$recent21827 = (function camelot$component$deployment$recent$recent_deployment_section_component_$___GT_t_camelot$component$deployment$recent21827(data__$1,owner__$1,meta21828){
return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent21827(data__$1,owner__$1,meta21828));
});

}

return (new camelot.component.deployment.recent.t_camelot$component$deployment$recent21827(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
