// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.library.identify');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.dom');
goog.require('om.core');
goog.require('camelot.translation.core');
goog.require('camelot.component.library.util');
goog.require('camelot.component.util');
goog.require('camelot.component.library.sighting_fields');
goog.require('camelot.util.sighting_fields');
goog.require('camelot.rest');
goog.require('camelot.nav');
goog.require('clojure.string');
goog.require('camelot.util.cursorise');
goog.require('camelot.util.feature');
goog.require('camelot.state');
camelot.component.library.identify.show_panel_QMARK_ = (function camelot$component$library$identify$show_panel_QMARK_(data){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,cljs.core.cst$kw$show_DASH_identification_DASH_panel);
});
camelot.component.library.identify.species_option_component = (function camelot$component$library$identify$species_option_component(data,owner){
if(typeof camelot.component.library.identify.t_camelot$component$library$identify24864 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.library.identify.t_camelot$component$library$identify24864 = (function (data,owner,meta24865){
this.data = data;
this.owner = owner;
this.meta24865 = meta24865;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.library.identify.t_camelot$component$library$identify24864.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24866,meta24865__$1){
var self__ = this;
var _24866__$1 = this;
return (new camelot.component.library.identify.t_camelot$component$library$identify24864(self__.data,self__.owner,meta24865__$1));
});

camelot.component.library.identify.t_camelot$component$library$identify24864.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24866){
var self__ = this;
var _24866__$1 = this;
return self__.meta24865;
});

camelot.component.library.identify.t_camelot$component$library$identify24864.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.library.identify.t_camelot$component$library$identify24864.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__24867 = ({"value": cljs.core.cst$kw$taxonomy_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data)});
var G__24868 = cljs.core.cst$kw$taxonomy_DASH_label.cljs$core$IFn$_invoke$arity$1(self__.data);
return (om.dom.option.cljs$core$IFn$_invoke$arity$2 ? om.dom.option.cljs$core$IFn$_invoke$arity$2(G__24867,G__24868) : om.dom.option.call(null,G__24867,G__24868));
});

camelot.component.library.identify.t_camelot$component$library$identify24864.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24865], null);
});

camelot.component.library.identify.t_camelot$component$library$identify24864.cljs$lang$type = true;

camelot.component.library.identify.t_camelot$component$library$identify24864.cljs$lang$ctorStr = "camelot.component.library.identify/t_camelot$component$library$identify24864";

camelot.component.library.identify.t_camelot$component$library$identify24864.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.library.identify/t_camelot$component$library$identify24864");
});

camelot.component.library.identify.__GT_t_camelot$component$library$identify24864 = (function camelot$component$library$identify$species_option_component_$___GT_t_camelot$component$library$identify24864(data__$1,owner__$1,meta24865){
return (new camelot.component.library.identify.t_camelot$component$library$identify24864(data__$1,owner__$1,meta24865));
});

}

return (new camelot.component.library.identify.t_camelot$component$library$identify24864(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.library.identify.blank_sighting_input = (function camelot$component$library$identify$blank_sighting_input(data){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$identification,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$quantity,(1),cljs.core.cst$kw$species,(-1),cljs.core.cst$kw$sighting_DASH_id,null,cljs.core.cst$kw$sex,"unidentified",cljs.core.cst$kw$lifestage,"unidentified",cljs.core.cst$kw$sighting_DASH_fields,cljs.core.PersistentArrayMap.EMPTY], null));
});
camelot.component.library.identify.key_by_user_key = (function camelot$component$library$identify$key_by_user_key(sighting_fields){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,sf){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(sighting_fields,cljs.core.cst$kw$sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(sf));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,camelot.util.sighting_fields.user_key(sf),v);
}),cljs.core.PersistentArrayMap.EMPTY,camelot.component.library.util.survey_sighting_fields(cljs.core.first(camelot.component.library.util.selection_survey.cljs$core$IFn$_invoke$arity$0())));
});
camelot.component.library.identify.add_sighting = (function camelot$component$library$identify$add_sighting(){
var spp = cljs.reader.read_string(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.library_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$species], null)));
var qty = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.library_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$quantity], null));
var lifestage = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.library_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$lifestage], null));
var sex = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.library_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$sex], null));
var sighting_fields = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.library_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$sighting_DASH_fields], null));
var selected = cljs.core.cst$kw$selected_DASH_media_DASH_id.cljs$core$IFn$_invoke$arity$1(camelot.state.library_state());
var sighting_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.library_state(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$sighting_DASH_id], null));
var all_selected = camelot.component.library.util.all_media_selected.cljs$core$IFn$_invoke$arity$0();
var identification = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$quantity,qty,cljs.core.cst$kw$lifestage,(cljs.core.truth_(camelot.component.library.util.unidentified_QMARK_(lifestage))?null:lifestage),cljs.core.cst$kw$sex,(cljs.core.truth_(camelot.component.library.util.unidentified_QMARK_(sex))?null:sex),cljs.core.cst$kw$species,spp,cljs.core.cst$kw$sighting_DASH_fields,cljs.core.deref(sighting_fields)], null);
var add_sighting = ((function (spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification){
return (function (resp){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification){
return (function (p1__24869_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.second(p1__24869_SHARP_),cljs.core.cst$kw$sightings,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$sightings.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__24869_SHARP_)),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$taxonomy_DASH_id,spp,cljs.core.cst$kw$sighting_DASH_lifestage,lifestage,cljs.core.cst$kw$sighting_DASH_sex,sex,cljs.core.cst$kw$sighting_DASH_id,cljs.core.first(p1__24869_SHARP_),cljs.core.cst$kw$sighting_DASH_quantity,qty], null),camelot.component.library.identify.key_by_user_key(cljs.core.deref(sighting_fields))], 0))));

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.second(p1__24869_SHARP_),cljs.core.cst$kw$media_DASH_processed,true);
});})(spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification))
,cljs.core.zipmap(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp),all_selected)));

return camelot.component.library.util.show_identified_message();
});})(spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification))
;
var update_sighting = ((function (spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification,add_sighting){
return (function (resp){
return om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.component.library.util.find_with_id(camelot.state.library_state(),selected),cljs.core.cst$kw$sightings,((function (spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification,add_sighting){
return (function (p1__24870_SHARP_){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$sighting_DASH_id,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification,add_sighting){
return (function (r){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$sighting_DASH_id.cljs$core$IFn$_invoke$arity$1(r),sighting_id);
});})(spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification,add_sighting))
,p1__24870_SHARP_),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$taxonomy_DASH_id,spp,cljs.core.cst$kw$sighting_DASH_lifestage,lifestage,cljs.core.cst$kw$sighting_DASH_sex,sex,cljs.core.cst$kw$sighting_DASH_id,sighting_id,cljs.core.cst$kw$sighting_DASH_quantity,qty], null),camelot.component.library.identify.key_by_user_key(cljs.core.deref(sighting_fields))], 0))));
});})(spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification,add_sighting))
);
});})(spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification,add_sighting))
;
var success_handler = ((function (spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification,add_sighting,update_sighting){
return (function (resp){
if(typeof sighting_id === 'number'){
update_sighting(resp);
} else {
add_sighting(resp);
}

document.getElementById("media-collection-container").focus();

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.library_state(),cljs.core.cst$kw$show_DASH_identification_DASH_panel,false);

return camelot.component.library.identify.blank_sighting_input(camelot.state.library_state());
});})(spp,qty,lifestage,sex,sighting_fields,selected,sighting_id,all_selected,identification,add_sighting,update_sighting))
;
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([identification], 0));

if(typeof sighting_id === 'number'){
return camelot.rest.put_x.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/library/identify/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sighting_id)].join(''),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$identification,identification], null)], null),success_handler);
} else {
return camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3("/library/identify",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$identification,identification,cljs.core.cst$kw$media,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$media_DASH_id,all_selected)], null)], null),success_handler);
}
});
camelot.component.library.identify.sighting_option_component = (function camelot$component$library$identify$sighting_option_component(data,owner){
if(typeof camelot.component.library.identify.t_camelot$component$library$identify24871 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.library.identify.t_camelot$component$library$identify24871 = (function (data,owner,meta24872){
this.data = data;
this.owner = owner;
this.meta24872 = meta24872;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.library.identify.t_camelot$component$library$identify24871.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24873,meta24872__$1){
var self__ = this;
var _24873__$1 = this;
return (new camelot.component.library.identify.t_camelot$component$library$identify24871(self__.data,self__.owner,meta24872__$1));
});

camelot.component.library.identify.t_camelot$component$library$identify24871.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24873){
var self__ = this;
var _24873__$1 = this;
return self__.meta24872;
});

camelot.component.library.identify.t_camelot$component$library$identify24871.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.library.identify.t_camelot$component$library$identify24871.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__24874 = ({"value": cljs.core.cst$kw$key.cljs$core$IFn$_invoke$arity$1(self__.data)});
var G__24875 = cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(self__.data);
return (om.dom.option.cljs$core$IFn$_invoke$arity$2 ? om.dom.option.cljs$core$IFn$_invoke$arity$2(G__24874,G__24875) : om.dom.option.call(null,G__24874,G__24875));
});

camelot.component.library.identify.t_camelot$component$library$identify24871.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24872], null);
});

camelot.component.library.identify.t_camelot$component$library$identify24871.cljs$lang$type = true;

camelot.component.library.identify.t_camelot$component$library$identify24871.cljs$lang$ctorStr = "camelot.component.library.identify/t_camelot$component$library$identify24871";

camelot.component.library.identify.t_camelot$component$library$identify24871.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.library.identify/t_camelot$component$library$identify24871");
});

camelot.component.library.identify.__GT_t_camelot$component$library$identify24871 = (function camelot$component$library$identify$sighting_option_component_$___GT_t_camelot$component$library$identify24871(data__$1,owner__$1,meta24872){
return (new camelot.component.library.identify.t_camelot$component$library$identify24871(data__$1,owner__$1,meta24872));
});

}

return (new camelot.component.library.identify.t_camelot$component$library$identify24871(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.library.identify.sighting_lifestage_select_component = (function camelot$component$library$identify$sighting_lifestage_select_component(data,owner){
if(typeof camelot.component.library.identify.t_camelot$component$library$identify24877 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.library.identify.t_camelot$component$library$identify24877 = (function (data,owner,meta24878){
this.data = data;
this.owner = owner;
this.meta24878 = meta24878;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.library.identify.t_camelot$component$library$identify24877.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24879,meta24878__$1){
var self__ = this;
var _24879__$1 = this;
return (new camelot.component.library.identify.t_camelot$component$library$identify24877(self__.data,self__.owner,meta24878__$1));
});

camelot.component.library.identify.t_camelot$component$library$identify24877.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24879){
var self__ = this;
var _24879__$1 = this;
return self__.meta24878;
});

camelot.component.library.identify.t_camelot$component$library$identify24877.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.library.identify.t_camelot$component$library$identify24877.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__24880 = ({"className": "field-input", "value": cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$lifestage], null)), "onChange": ((function (___$1){
return (function (p1__24876_SHARP_){
var v = p1__24876_SHARP_.target.value;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$identification.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$lifestage,v);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$identification.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$dirty_DASH_state,true);
});})(___$1))
});
var G__24881 = om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.library.identify.sighting_option_component,(function (){var x__7467__auto__ = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,"unidentified",cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$sighting_SLASH_sighting_DASH_property$unidentified)], null);
return cljs.core._conj((function (){var x__7467__auto____$1 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,"adult",cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$sighting_SLASH_sighting_DASH_lifestage$adult)], null);
return cljs.core._conj((function (){var x__7467__auto____$2 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,"juvenile",cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$sighting_SLASH_sighting_DASH_lifestage$juvenile)], null);
return cljs.core._conj(cljs.core.List.EMPTY,x__7467__auto____$2);
})(),x__7467__auto____$1);
})(),x__7467__auto__);
})(),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$key], null));
return (om.dom.select.cljs$core$IFn$_invoke$arity$2 ? om.dom.select.cljs$core$IFn$_invoke$arity$2(G__24880,G__24881) : om.dom.select.call(null,G__24880,G__24881));
});

camelot.component.library.identify.t_camelot$component$library$identify24877.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24878], null);
});

camelot.component.library.identify.t_camelot$component$library$identify24877.cljs$lang$type = true;

camelot.component.library.identify.t_camelot$component$library$identify24877.cljs$lang$ctorStr = "camelot.component.library.identify/t_camelot$component$library$identify24877";

camelot.component.library.identify.t_camelot$component$library$identify24877.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.library.identify/t_camelot$component$library$identify24877");
});

camelot.component.library.identify.__GT_t_camelot$component$library$identify24877 = (function camelot$component$library$identify$sighting_lifestage_select_component_$___GT_t_camelot$component$library$identify24877(data__$1,owner__$1,meta24878){
return (new camelot.component.library.identify.t_camelot$component$library$identify24877(data__$1,owner__$1,meta24878));
});

}

return (new camelot.component.library.identify.t_camelot$component$library$identify24877(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.library.identify.sighting_sex_select_component = (function camelot$component$library$identify$sighting_sex_select_component(data,owner){
if(typeof camelot.component.library.identify.t_camelot$component$library$identify24883 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.library.identify.t_camelot$component$library$identify24883 = (function (data,owner,meta24884){
this.data = data;
this.owner = owner;
this.meta24884 = meta24884;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.library.identify.t_camelot$component$library$identify24883.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24885,meta24884__$1){
var self__ = this;
var _24885__$1 = this;
return (new camelot.component.library.identify.t_camelot$component$library$identify24883(self__.data,self__.owner,meta24884__$1));
});

camelot.component.library.identify.t_camelot$component$library$identify24883.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24885){
var self__ = this;
var _24885__$1 = this;
return self__.meta24884;
});

camelot.component.library.identify.t_camelot$component$library$identify24883.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.library.identify.t_camelot$component$library$identify24883.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__24886 = ({"className": "field-input", "value": cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$sex], null)), "onChange": ((function (___$1){
return (function (p1__24882_SHARP_){
var v = p1__24882_SHARP_.target.value;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$identification.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$sex,v);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$identification.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$dirty_DASH_state,true);
});})(___$1))
});
var G__24887 = om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.library.identify.sighting_option_component,(function (){var x__7467__auto__ = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,"unidentified",cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$sighting_SLASH_sighting_DASH_property$unidentified)], null);
return cljs.core._conj((function (){var x__7467__auto____$1 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,"M",cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$sighting_SLASH_sighting_DASH_sex$male)], null);
return cljs.core._conj((function (){var x__7467__auto____$2 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,"F",cljs.core.cst$kw$label,camelot.translation.core.translate(cljs.core.cst$kw$sighting_SLASH_sighting_DASH_sex$female)], null);
return cljs.core._conj(cljs.core.List.EMPTY,x__7467__auto____$2);
})(),x__7467__auto____$1);
})(),x__7467__auto__);
})(),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$key], null));
return (om.dom.select.cljs$core$IFn$_invoke$arity$2 ? om.dom.select.cljs$core$IFn$_invoke$arity$2(G__24886,G__24887) : om.dom.select.call(null,G__24886,G__24887));
});

camelot.component.library.identify.t_camelot$component$library$identify24883.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24884], null);
});

camelot.component.library.identify.t_camelot$component$library$identify24883.cljs$lang$type = true;

camelot.component.library.identify.t_camelot$component$library$identify24883.cljs$lang$ctorStr = "camelot.component.library.identify/t_camelot$component$library$identify24883";

camelot.component.library.identify.t_camelot$component$library$identify24883.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.library.identify/t_camelot$component$library$identify24883");
});

camelot.component.library.identify.__GT_t_camelot$component$library$identify24883 = (function camelot$component$library$identify$sighting_sex_select_component_$___GT_t_camelot$component$library$identify24883(data__$1,owner__$1,meta24884){
return (new camelot.component.library.identify.t_camelot$component$library$identify24883(data__$1,owner__$1,meta24884));
});

}

return (new camelot.component.library.identify.t_camelot$component$library$identify24883(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.library.identify.submit_identification = (function camelot$component$library$identify$submit_identification(){
return camelot.component.library.identify.add_sighting();
});
camelot.component.library.identify.validate_proposed_species = (function camelot$component$library$identify$validate_proposed_species(data){
return (!((cljs.core.cst$kw$new_DASH_species_DASH_name.cljs$core$IFn$_invoke$arity$1(data) == null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$new_DASH_species_DASH_name.cljs$core$IFn$_invoke$arity$1(data),/ /)),(2)));
});
camelot.component.library.identify.add_taxonomy_success_handler = (function camelot$component$library$identify$add_taxonomy_success_handler(data,resp){
var species = camelot.util.cursorise.decursorise(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp));
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$species,((function (species){
return (function (p1__24888_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__24888_SHARP_,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$taxonomy_DASH_id.cljs$core$IFn$_invoke$arity$1(species)],[species]));
});})(species))
);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$new_DASH_species_DASH_name,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification], null)),cljs.core.cst$kw$species,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$taxonomy_DASH_id.cljs$core$IFn$_invoke$arity$1(species))].join(''));

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$taxonomy_DASH_create_DASH_mode,false);
});
camelot.component.library.identify.add_taxonomy_handler = (function camelot$component$library$identify$add_taxonomy_handler(data){
var segments_24889 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$new_DASH_species_DASH_name.cljs$core$IFn$_invoke$arity$1(data),/ /);
camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3("/taxonomy",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$taxonomy_DASH_genus,cljs.core.first(segments_24889),cljs.core.cst$kw$taxonomy_DASH_species,cljs.core.second(segments_24889),cljs.core.cst$kw$taxonomy_DASH_common_DASH_name,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(segments_24889)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(segments_24889))].join('')], null),(cljs.core.truth_((function (){var and__6612__auto__ = cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(data);
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(data),(-1));
} else {
return and__6612__auto__;
}
})())?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(data)], null):cljs.core.PersistentArrayMap.EMPTY)], 0))], null),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.component.library.identify.add_taxonomy_success_handler,data));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("library-id","taxonomy-create");
});
camelot.component.library.identify.add_taxonomy_component = (function camelot$component$library$identify$add_taxonomy_component(data,owner){
if(typeof camelot.component.library.identify.t_camelot$component$library$identify24891 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.library.identify.t_camelot$component$library$identify24891 = (function (data,owner,meta24892){
this.data = data;
this.owner = owner;
this.meta24892 = meta24892;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.library.identify.t_camelot$component$library$identify24891.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24893,meta24892__$1){
var self__ = this;
var _24893__$1 = this;
return (new camelot.component.library.identify.t_camelot$component$library$identify24891(self__.data,self__.owner,meta24892__$1));
});

camelot.component.library.identify.t_camelot$component$library$identify24891.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24893){
var self__ = this;
var _24893__$1 = this;
return self__.meta24892;
});

camelot.component.library.identify.t_camelot$component$library$identify24891.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.library.identify.t_camelot$component$library$identify24891.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var is_valid = camelot.component.library.identify.validate_proposed_species(self__.data);
var G__24894 = ({"className": "field-input-form inline"});
var G__24895 = om.util.force_children((function (){var G__24897 = ({"className": "field-input inline long-input", "autoFocus": "autofocus", "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$identify_SLASH_taxonomy_DASH_add_DASH_placeholder), "value": cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_species_DASH_name], null)), "onChange": ((function (G__24894,is_valid,___$1){
return (function (p1__24890_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$new_DASH_species_DASH_name,p1__24890_SHARP_.target.value);
});})(G__24894,is_valid,___$1))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__24897) : om.dom.input.call(null,G__24897));
})());
var G__24896 = om.util.force_children((((cljs.core.empty_QMARK_(cljs.core.cst$kw$new_DASH_species_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data))) && (cljs.core.seq(cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(self__.data))))?(function (){var G__24898 = ({"type": "button", "className": "btn btn-default input-field-submit", "onClick": ((function (G__24894,G__24895,is_valid,___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$taxonomy_DASH_create_DASH_mode,false);
});})(G__24894,G__24895,is_valid,___$1))
, "value": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_cancel)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__24898) : om.dom.input.call(null,G__24898));
})():(function (){var G__24899 = ({"type": "button", "disabled": (cljs.core.truth_(is_valid)?"":"disabled"), "title": (cljs.core.truth_(is_valid)?null:camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$identify_SLASH_species_DASH_format_DASH_error)), "className": "btn btn-primary input-field-submit", "onClick": ((function (G__24894,G__24895,is_valid,___$1){
return (function (){
return camelot.component.library.identify.add_taxonomy_handler(self__.data);
});})(G__24894,G__24895,is_valid,___$1))
, "value": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_add)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__24899) : om.dom.input.call(null,G__24899));
})()));
return React.DOM.div(G__24894,G__24895,G__24896);
});

camelot.component.library.identify.t_camelot$component$library$identify24891.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24892], null);
});

camelot.component.library.identify.t_camelot$component$library$identify24891.cljs$lang$type = true;

camelot.component.library.identify.t_camelot$component$library$identify24891.cljs$lang$ctorStr = "camelot.component.library.identify/t_camelot$component$library$identify24891";

camelot.component.library.identify.t_camelot$component$library$identify24891.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.library.identify/t_camelot$component$library$identify24891");
});

camelot.component.library.identify.__GT_t_camelot$component$library$identify24891 = (function camelot$component$library$identify$add_taxonomy_component_$___GT_t_camelot$component$library$identify24891(data__$1,owner__$1,meta24892){
return (new camelot.component.library.identify.t_camelot$component$library$identify24891(data__$1,owner__$1,meta24892));
});

}

return (new camelot.component.library.identify.t_camelot$component$library$identify24891(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.library.identify.taxonomy_select_component = (function camelot$component$library$identify$taxonomy_select_component(data,owner){
if(typeof camelot.component.library.identify.t_camelot$component$library$identify24901 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.library.identify.t_camelot$component$library$identify24901 = (function (data,owner,meta24902){
this.data = data;
this.owner = owner;
this.meta24902 = meta24902;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.library.identify.t_camelot$component$library$identify24901.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24903,meta24902__$1){
var self__ = this;
var _24903__$1 = this;
return (new camelot.component.library.identify.t_camelot$component$library$identify24901(self__.data,self__.owner,meta24902__$1));
});

camelot.component.library.identify.t_camelot$component$library$identify24901.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24903){
var self__ = this;
var _24903__$1 = this;
return self__.meta24902;
});

camelot.component.library.identify.t_camelot$component$library$identify24901.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.library.identify.t_camelot$component$library$identify24901.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((function (){var or__6624__auto__ = cljs.core.empty_QMARK_(cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(self__.data));
if(or__6624__auto__){
return or__6624__auto__;
} else {
return cljs.core.cst$kw$taxonomy_DASH_create_DASH_mode.cljs$core$IFn$_invoke$arity$1(self__.data);
}
})())){
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.library.identify.add_taxonomy_component,self__.data);
} else {
var G__24904 = ({"className": "field-input", "id": "identify-species-select", "value": cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$species], null)), "onChange": ((function (___$1){
return (function (p1__24900_SHARP_){
var v = p1__24900_SHARP_.target.value;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,"create")){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$taxonomy_DASH_create_DASH_mode,true);

return om.core.get_node.cljs$core$IFn$_invoke$arity$1(self__.owner).focus();
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$identification.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$species,v);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$identification.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$dirty_DASH_state,true);
}
});})(___$1))
});
var G__24905 = om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.library.identify.species_option_component,cljs.core.cons(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$taxonomy_DASH_id,(-1),cljs.core.cst$kw$taxonomy_DASH_label,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_select)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("...")].join('')], null),cljs.core.reverse(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.List.EMPTY,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$taxonomy_DASH_label,cljs.core.vals(cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(self__.data)))),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$taxonomy_DASH_id,"create",cljs.core.cst$kw$taxonomy_DASH_label,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$identify_SLASH_add_DASH_new_DASH_species_DASH_label)], null)))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$taxonomy_DASH_id], null));
return (om.dom.select.cljs$core$IFn$_invoke$arity$2 ? om.dom.select.cljs$core$IFn$_invoke$arity$2(G__24904,G__24905) : om.dom.select.call(null,G__24904,G__24905));
}
});

camelot.component.library.identify.t_camelot$component$library$identify24901.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24902], null);
});

camelot.component.library.identify.t_camelot$component$library$identify24901.cljs$lang$type = true;

camelot.component.library.identify.t_camelot$component$library$identify24901.cljs$lang$ctorStr = "camelot.component.library.identify/t_camelot$component$library$identify24901";

camelot.component.library.identify.t_camelot$component$library$identify24901.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.library.identify/t_camelot$component$library$identify24901");
});

camelot.component.library.identify.__GT_t_camelot$component$library$identify24901 = (function camelot$component$library$identify$taxonomy_select_component_$___GT_t_camelot$component$library$identify24901(data__$1,owner__$1,meta24902){
return (new camelot.component.library.identify.t_camelot$component$library$identify24901(data__$1,owner__$1,meta24902));
});

}

return (new camelot.component.library.identify.t_camelot$component$library$identify24901(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.library.identify.identify_panel = (function camelot$component$library$identify$identify_panel(data,owner){
if(typeof camelot.component.library.identify.t_camelot$component$library$identify24907 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.library.identify.t_camelot$component$library$identify24907 = (function (data,owner,meta24908){
this.data = data;
this.owner = owner;
this.meta24908 = meta24908;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.library.identify.t_camelot$component$library$identify24907.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24909,meta24908__$1){
var self__ = this;
var _24909__$1 = this;
return (new camelot.component.library.identify.t_camelot$component$library$identify24907(self__.data,self__.owner,meta24908__$1));
});

camelot.component.library.identify.t_camelot$component$library$identify24907.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24909){
var self__ = this;
var _24909__$1 = this;
return self__.meta24908;
});

camelot.component.library.identify.t_camelot$component$library$identify24907.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.library.identify.t_camelot$component$library$identify24907.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$show_DASH_identification_DASH_panel.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__24910 = ({"id": "identification-panel", "className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("identification-panel")].join('')});
var G__24911 = om.util.force_children((function (){var G__24912 = ({"className": "identification-panel-content"});
var G__24913 = om.util.force_children((function (){var G__24918 = ({"className": "single-field", "required": true});
var G__24919 = om.util.force_children((function (){var G__24921 = ({"className": "field-label required"});
var G__24922 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$sighting_SLASH_taxonomy_DASH_id$label));
return React.DOM.label(G__24921,G__24922);
})());
var G__24920 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.library.identify.taxonomy_select_component,self__.data));
return React.DOM.div(G__24918,G__24919,G__24920);
})());
var G__24914 = om.util.force_children((function (){var G__24923 = null;
var G__24924 = om.util.force_children((function (){var G__24926 = ({"className": "field-label required"});
var G__24927 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$sighting_SLASH_sighting_DASH_quantity$label));
return React.DOM.label(G__24926,G__24927);
})());
var G__24925 = om.util.force_children((function (){var G__24928 = ({"type": "number", "min": "1", "required": true, "className": "field-input short-input", "value": cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$quantity], null)), "onChange": ((function (G__24923,G__24924,G__24912,G__24913,G__24910,___$1){
return (function (p1__24906_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$identification.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$quantity,cljs.reader.read_string(p1__24906_SHARP_.target.value));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("library-id","quantity-change");
});})(G__24923,G__24924,G__24912,G__24913,G__24910,___$1))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__24928) : om.dom.input.call(null,G__24928));
})());
return React.DOM.div(G__24923,G__24924,G__24925);
})());
var G__24915 = om.util.force_children((function (){var G__24929 = null;
var G__24930 = om.util.force_children((function (){var G__24931 = ({"className": "field"});
var G__24932 = om.util.force_children((function (){var G__24934 = null;
var G__24935 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$sighting_SLASH_sighting_DASH_sex$label));
return React.DOM.label(G__24934,G__24935);
})());
var G__24933 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.library.identify.sighting_sex_select_component,self__.data));
return React.DOM.span(G__24931,G__24932,G__24933);
})());
return React.DOM.div(G__24929,G__24930);
})());
var G__24916 = om.util.force_children((function (){var G__24936 = null;
var G__24937 = om.util.force_children((function (){var G__24938 = ({"className": "field"});
var G__24939 = om.util.force_children((function (){var G__24941 = null;
var G__24942 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$sighting_SLASH_sighting_DASH_lifestage$label));
return React.DOM.label(G__24941,G__24942);
})());
var G__24940 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.library.identify.sighting_lifestage_select_component,self__.data));
return React.DOM.span(G__24938,G__24939,G__24940);
})());
return React.DOM.div(G__24936,G__24937);
})());
var G__24917 = om.util.force_children((function (){var G__24943 = ({"className": "flex-row"});
var G__24944 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.library.sighting_fields.component,self__.data));
return React.DOM.div(G__24943,G__24944);
})());
return React.DOM.div(G__24912,G__24913,G__24914,G__24915,G__24916,G__24917);
})());
return React.DOM.div(G__24910,G__24911);
} else {
return null;
}
});

camelot.component.library.identify.t_camelot$component$library$identify24907.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24908], null);
});

camelot.component.library.identify.t_camelot$component$library$identify24907.cljs$lang$type = true;

camelot.component.library.identify.t_camelot$component$library$identify24907.cljs$lang$ctorStr = "camelot.component.library.identify/t_camelot$component$library$identify24907";

camelot.component.library.identify.t_camelot$component$library$identify24907.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.library.identify/t_camelot$component$library$identify24907");
});

camelot.component.library.identify.__GT_t_camelot$component$library$identify24907 = (function camelot$component$library$identify$identify_panel_$___GT_t_camelot$component$library$identify24907(data__$1,owner__$1,meta24908){
return (new camelot.component.library.identify.t_camelot$component$library$identify24907(data__$1,owner__$1,meta24908));
});

}

return (new camelot.component.library.identify.t_camelot$component$library$identify24907(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.library.identify.submit_allowed_QMARK_ = (function camelot$component$library$identify$submit_allowed_QMARK_(data){
var and__6612__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$species], null));
if(cljs.core.truth_(and__6612__auto__)){
return ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$species], null)) > (-1))) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$identification,cljs.core.cst$kw$quantity], null)) > (0))) && (cljs.core.not(cljs.core.cst$kw$taxonomy_DASH_create_DASH_mode.cljs$core$IFn$_invoke$arity$1(data)));
} else {
return and__6612__auto__;
}
});
camelot.component.library.identify.identify_component = (function camelot$component$library$identify$identify_component(data,owner){
if(typeof camelot.component.library.identify.t_camelot$component$library$identify24945 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.library.identify.t_camelot$component$library$identify24945 = (function (data,owner,meta24946){
this.data = data;
this.owner = owner;
this.meta24946 = meta24946;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.library.identify.t_camelot$component$library$identify24945.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24947,meta24946__$1){
var self__ = this;
var _24947__$1 = this;
return (new camelot.component.library.identify.t_camelot$component$library$identify24945(self__.data,self__.owner,meta24946__$1));
});

camelot.component.library.identify.t_camelot$component$library$identify24945.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24947){
var self__ = this;
var _24947__$1 = this;
return self__.meta24946;
});

camelot.component.library.identify.t_camelot$component$library$identify24945.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.library.identify.t_camelot$component$library$identify24945.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var submit_allowed = camelot.component.library.identify.submit_allowed_QMARK_(self__.data);
return om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.prompt_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$active_DASH_key,cljs.core.cst$kw$show_DASH_identification_DASH_panel,cljs.core.cst$kw$form_DASH_opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$onSubmit,((function (submit_allowed,___$1){
return (function (e){
e.preventDefault();

camelot.component.library.identify.submit_identification();

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("library-id","submit-identification");
});})(submit_allowed,___$1))
], null),cljs.core.cst$kw$title,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$identify_SLASH_identify_DASH_selected),cljs.core.cst$kw$body,om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.library.identify.identify_panel,self__.data),cljs.core.cst$kw$close_DASH_action,((function (submit_allowed,___$1){
return (function (){
camelot.component.library.identify.blank_sighting_input(self__.data);

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("library-id","cancel-identification");
});})(submit_allowed,___$1))
,cljs.core.cst$kw$actions,(function (){var G__24948 = ({"className": "button-container"});
var G__24949 = om.util.force_children((function (){var G__24951 = ({"type": "button", "className": "btn btn-default", "onClick": ((function (G__24948,submit_allowed,___$1){
return (function (){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$show_DASH_identification_DASH_panel,false);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search,cljs.core.cst$kw$mode], null),cljs.core.cst$kw$search);

camelot.component.library.identify.blank_sighting_input(self__.data);

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("library-id","cancel-identification");
});})(G__24948,submit_allowed,___$1))
, "value": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_cancel)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__24951) : om.dom.input.call(null,G__24951));
})());
var G__24950 = om.util.force_children((function (){var G__24952 = ({"className": "btn btn-primary", "type": "submit", "disabled": (cljs.core.truth_(submit_allowed)?null:"disabled"), "title": (cljs.core.truth_(submit_allowed)?null:camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$library$identify_SLASH_submit_DASH_not_DASH_allowed)), "value": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_submit)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__24952) : om.dom.input.call(null,G__24952));
})());
return React.DOM.div(G__24948,G__24949,G__24950);
})()], null)], null));
});

camelot.component.library.identify.t_camelot$component$library$identify24945.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24946], null);
});

camelot.component.library.identify.t_camelot$component$library$identify24945.cljs$lang$type = true;

camelot.component.library.identify.t_camelot$component$library$identify24945.cljs$lang$ctorStr = "camelot.component.library.identify/t_camelot$component$library$identify24945";

camelot.component.library.identify.t_camelot$component$library$identify24945.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.library.identify/t_camelot$component$library$identify24945");
});

camelot.component.library.identify.__GT_t_camelot$component$library$identify24945 = (function camelot$component$library$identify$identify_component_$___GT_t_camelot$component$library$identify24945(data__$1,owner__$1,meta24946){
return (new camelot.component.library.identify.t_camelot$component$library$identify24945(data__$1,owner__$1,meta24946));
});

}

return (new camelot.component.library.identify.t_camelot$component$library$identify24945(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
