// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.nav');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('camelot.nav');
goog.require('om.core');
goog.require('om.dom');
goog.require('camelot.component.progress_bar');
goog.require('cljs.core.async');
goog.require('camelot.rest');
goog.require('camelot.translation.core');
goog.require('goog.date.duration');
goog.require('clojure.string');
camelot.component.nav.bulk_import_refresh_long_timeout = (5000);
camelot.component.nav.bulk_import_refresh_short_timeout = (1000);
camelot.component.nav.time_elapsed = (function camelot$component$nav$time_elapsed(data){
var total = (cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$end_DASH_time], null)).getTime() - cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$start_DASH_time], null)).getTime());
var sec = cljs.core.mod((total / (1000)),(60));
var fsec = Math.floor(sec);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.date.duration.format(total)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fsec),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fsec,(1)))?"second":"seconds"))].join('');
});
camelot.component.nav.time_remaining_estimate = (function camelot$component$nav$time_remaining_estimate(data,progress){
var dif = (cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$end_DASH_time], null)).getTime() - cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$start_DASH_time], null)).getTime());
var todo = ((dif / progress) - dif);
var sec = cljs.core.mod((todo / (1000)),(60));
var fsec = Math.floor(sec);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.date.duration.format(todo)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fsec),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fsec,(1)))?"second":"seconds"))].join('');
});
camelot.component.nav.cancel_import = (function camelot$component$nav$cancel_import(data){
return camelot.rest.post_x_opts("/importer/cancel",cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$successs,(function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$cancelling_DASH_import,true);
}),cljs.core.cst$kw$suppress_DASH_error_DASH_dialog,true], null));
});
/**
 * Get the progress of the bulk import.
 */
camelot.component.nav.import_progress = (function camelot$component$nav$import_progress(data){
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),cljs.core.vals(cljs.core.select_keys(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$complete,cljs.core.cst$kw$failed,cljs.core.cst$kw$ignored], null)))) / (function (){var x__6960__auto__ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.vals(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts], null))));
var y__6961__auto__ = (1);
return ((x__6960__auto__ > y__6961__auto__) ? x__6960__auto__ : y__6961__auto__);
})());
});
/**
 * Hide the settings panel
 */
camelot.component.nav.settings_hide_BANG_ = (function camelot$component$nav$settings_hide_BANG_(){
var navelt = document.getElementById("settings-nav");
(navelt["className"] = clojure.string.replace_first((navelt["className"]),/active /,""));

return (document.getElementById("settings")["className"] = "");
});
/**
 * Show the settings panel
 */
camelot.component.nav.settings_show_BANG_ = (function camelot$component$nav$settings_show_BANG_(){
var navelt = document.getElementById("settings-nav");
(navelt["className"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("active "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(navelt.className)].join(''));

return (document.getElementById("settings")["className"] = "show");
});
/**
 * Toggle the settings panel show state
 */
camelot.component.nav.toggle_settings_BANG_ = (function camelot$component$nav$toggle_settings_BANG_(){
var navelt = document.getElementById("settings-nav");
if(clojure.string.includes_QMARK_(navelt.className,"active")){
return camelot.component.nav.settings_hide_BANG_();
} else {
return camelot.component.nav.settings_show_BANG_();
}
});
camelot.component.nav.bulk_import_details_panel_component = (function camelot$component$nav$bulk_import_details_panel_component(data,owner){
if(typeof camelot.component.nav.t_camelot$component$nav24465 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.nav.t_camelot$component$nav24465 = (function (data,owner,meta24466){
this.data = data;
this.owner = owner;
this.meta24466 = meta24466;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.nav.t_camelot$component$nav24465.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24467,meta24466__$1){
var self__ = this;
var _24467__$1 = this;
return (new camelot.component.nav.t_camelot$component$nav24465(self__.data,self__.owner,meta24466__$1));
});

camelot.component.nav.t_camelot$component$nav24465.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24467){
var self__ = this;
var _24467__$1 = this;
return self__.meta24466;
});

camelot.component.nav.t_camelot$component$nav24465.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.nav.t_camelot$component$nav24465.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var total = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),cljs.core.vals(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts], null))));
var progress = camelot.component.nav.import_progress(self__.data);
var G__24468 = ({"id": "bulk-import-details-panel", "onClick": ((function (total,progress,___$1){
return (function (p1__24464_SHARP_){
p1__24464_SHARP_.preventDefault();

return p1__24464_SHARP_.stopPropagation();
});})(total,progress,___$1))
, "className": (cljs.core.truth_((function (){var and__6612__auto__ = cljs.core.pos_int_QMARK_(total);
if(and__6612__auto__){
return cljs.core.cst$kw$show_DASH_bulk_DASH_import_DASH_details.cljs$core$IFn$_invoke$arity$1(self__.data);
} else {
return and__6612__auto__;
}
})())?"expanded":"")});
var G__24469 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$import_DASH_status.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__24470 = ({"className": "bulk-import-details-container"});
var G__24471 = om.util.force_children((function (){var G__24477 = ({"className": "progress-numbers"});
var G__24478 = om.util.force_children(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),cljs.core.vals(cljs.core.select_keys(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$complete,cljs.core.cst$kw$failed,cljs.core.cst$kw$ignored], null)))));
var G__24479 = om.util.force_children(" ");
var G__24480 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_of_DASH_lc));
var G__24481 = om.util.force_children(" ");
var G__24482 = om.util.force_children(total);
return React.DOM.span(G__24477,G__24478,G__24479,G__24480,G__24481,G__24482);
})());
var G__24472 = om.util.force_children((function (){var G__24483 = ({"className": "field-label"});
var G__24484 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_progress_DASH_label));
return React.DOM.label(G__24483,G__24484);
})());
var G__24473 = om.util.force_children((function (){var G__24485 = ({"className": "bulk-import-progress-bar"});
var G__24486 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.progress_bar.component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts], null)),cljs.core.cst$kw$total,total)], null)));
var G__24487 = om.util.force_children(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(progress,(1)))?null:(function (){var G__24488 = ({"className": "fa fa-times-circle cancel-button", "title": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_cancel), "onClick": ((function (G__24485,G__24486,G__24470,G__24471,G__24472,G__24468,total,progress,___$1){
return (function (){
return camelot.component.nav.cancel_import(self__.data);
});})(G__24485,G__24486,G__24470,G__24471,G__24472,G__24468,total,progress,___$1))
});
return React.DOM.span(G__24488);
})()));
return React.DOM.div(G__24485,G__24486,G__24487);
})());
var G__24474 = om.util.force_children(((cljs.core.pos_int_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts,cljs.core.cst$kw$ignored], null))))?(function (){var G__24489 = ({"className": "bulk-import-cancelled bulk-import-status"});
var G__24490 = om.util.force_children((function (){var G__24491 = ({"className": "fa fa-ban fa-2x", "title": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_cancelled)});
return React.DOM.span(G__24491);
})());
return React.DOM.p(G__24489,G__24490);
})():((cljs.core.pos_int_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts,cljs.core.cst$kw$failed], null))))?(function (){var G__24492 = ({"className": "bulk-import-failure bulk-import-status"});
var G__24493 = om.util.force_children((function (){var G__24494 = ({"className": "fa fa-exclamation-triangle fa-2x", "title": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_failures)});
return React.DOM.span(G__24494);
})());
return React.DOM.p(G__24492,G__24493);
})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(progress,(1)))?(function (){var G__24495 = ({"className": "bulk-import-success bulk-import-status"});
var G__24496 = om.util.force_children((function (){var G__24497 = ({"className": "fa fa-check fa-2x", "title": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_success)});
return React.DOM.span(G__24497);
})());
return React.DOM.p(G__24495,G__24496);
})():null))));
var G__24475 = om.util.force_children((((progress === (0)))?(function (){var G__24498 = null;
var G__24499 = om.util.force_children((function (){var G__24500 = ({"className": "field-label"});
var G__24501 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_calculating));
return React.DOM.label(G__24500,G__24501);
})());
return React.DOM.div(G__24498,G__24499);
})():((cljs.core.pos_int_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts,cljs.core.cst$kw$ignored], null))))?(function (){var G__24502 = null;
var G__24503 = om.util.force_children((function (){var G__24504 = ({"className": "field-label"});
var G__24505 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_cancelled));
return React.DOM.label(G__24504,G__24505);
})());
return React.DOM.div(G__24502,G__24503);
})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(progress,(1)))?(function (){var G__24506 = null;
var G__24507 = om.util.force_children((function (){var G__24509 = ({"className": "field-label"});
var G__24510 = om.util.force_children((((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts,cljs.core.cst$kw$failed], null)) === (0)))?camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_complete):camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_complete_DASH_with_DASH_errors)));
return React.DOM.label(G__24509,G__24510);
})());
var G__24508 = om.util.force_children((function (){var G__24511 = null;
var G__24512 = om.util.force_children(camelot.component.nav.time_elapsed(self__.data));
return React.DOM.p(G__24511,G__24512);
})());
return React.DOM.div(G__24506,G__24507,G__24508);
})():(function (){var G__24513 = null;
var G__24514 = om.util.force_children((function (){var G__24516 = ({"className": "field-label"});
var G__24517 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_time_DASH_remaining));
return React.DOM.label(G__24516,G__24517);
})());
var G__24515 = om.util.force_children((function (){var G__24518 = null;
var G__24519 = om.util.force_children(camelot.component.nav.time_remaining_estimate(self__.data,progress));
return React.DOM.p(G__24518,G__24519);
})());
return React.DOM.div(G__24513,G__24514,G__24515);
})()
))));
var G__24476 = om.util.force_children(((cljs.core.pos_int_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$counts,cljs.core.cst$kw$failed], null))))?(function (){var G__24520 = null;
var G__24521 = om.util.force_children((function (){var G__24523 = null;
var G__24524 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_failed_DASH_paths));
return React.DOM.label(G__24523,G__24524);
})());
var G__24522 = om.util.force_children((function (){var G__24525 = ({"rows": "8", "style": ({"width": "100%"})});
var G__24526 = clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$failed_DASH_paths], null)));
return (om.dom.textarea.cljs$core$IFn$_invoke$arity$2 ? om.dom.textarea.cljs$core$IFn$_invoke$arity$2(G__24525,G__24526) : om.dom.textarea.call(null,G__24525,G__24526));
})());
return React.DOM.div(G__24520,G__24521,G__24522);
})():null));
return React.DOM.div(G__24470,G__24471,G__24472,G__24473,G__24474,G__24475,G__24476);
})():null));
return React.DOM.div(G__24468,G__24469);
});

camelot.component.nav.t_camelot$component$nav24465.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24466], null);
});

camelot.component.nav.t_camelot$component$nav24465.cljs$lang$type = true;

camelot.component.nav.t_camelot$component$nav24465.cljs$lang$ctorStr = "camelot.component.nav/t_camelot$component$nav24465";

camelot.component.nav.t_camelot$component$nav24465.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.nav/t_camelot$component$nav24465");
});

camelot.component.nav.__GT_t_camelot$component$nav24465 = (function camelot$component$nav$bulk_import_details_panel_component_$___GT_t_camelot$component$nav24465(data__$1,owner__$1,meta24466){
return (new camelot.component.nav.t_camelot$component$nav24465(data__$1,owner__$1,meta24466));
});

}

return (new camelot.component.nav.t_camelot$component$nav24465(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Display the bulk import status, if available.
 */
camelot.component.nav.bulk_import_progress_component = (function camelot$component$nav$bulk_import_progress_component(data,owner){
if(typeof camelot.component.nav.t_camelot$component$nav24528 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.nav.t_camelot$component$nav24528 = (function (data,owner,meta24529){
this.data = data;
this.owner = owner;
this.meta24529 = meta24529;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.nav.t_camelot$component$nav24528.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24530,meta24529__$1){
var self__ = this;
var _24530__$1 = this;
return (new camelot.component.nav.t_camelot$component$nav24528(self__.data,self__.owner,meta24529__$1));
});

camelot.component.nav.t_camelot$component$nav24528.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24530){
var self__ = this;
var _24530__$1 = this;
return self__.meta24529;
});

camelot.component.nav.t_camelot$component$nav24528.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.nav.t_camelot$component$nav24528.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cmd_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.nav.t_camelot$component$nav24528.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.nav.t_camelot$component$nav24528.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,___$1){
return (function (state_24569){
var state_val_24570 = (state_24569[(1)]);
if((state_val_24570 === (7))){
var inst_24565 = (state_24569[(2)]);
var state_24569__$1 = state_24569;
var statearr_24571_24614 = state_24569__$1;
(statearr_24571_24614[(2)] = inst_24565);

(statearr_24571_24614[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24570 === (1))){
var inst_24531 = camelot.component.nav.bulk_import_refresh_long_timeout;
var state_24569__$1 = (function (){var statearr_24572 = state_24569;
(statearr_24572[(7)] = inst_24531);

return statearr_24572;
})();
var statearr_24573_24615 = state_24569__$1;
(statearr_24573_24615[(2)] = null);

(statearr_24573_24615[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24570 === (4))){
var inst_24536 = (state_24569[(8)]);
var inst_24544 = (state_24569[(9)]);
var inst_24542 = (state_24569[(10)]);
var inst_24542__$1 = (state_24569[(2)]);
var inst_24543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24542__$1,(0),null);
var inst_24544__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24542__$1,(1),null);
var inst_24545 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24544__$1,inst_24536);
var state_24569__$1 = (function (){var statearr_24574 = state_24569;
(statearr_24574[(11)] = inst_24543);

(statearr_24574[(9)] = inst_24544__$1);

(statearr_24574[(10)] = inst_24542__$1);

return statearr_24574;
})();
if(inst_24545){
var statearr_24575_24616 = state_24569__$1;
(statearr_24575_24616[(1)] = (5));

} else {
var statearr_24576_24617 = state_24569__$1;
(statearr_24576_24617[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24570 === (6))){
var inst_24536 = (state_24569[(8)]);
var inst_24543 = (state_24569[(11)]);
var inst_24544 = (state_24569[(9)]);
var inst_24531 = (state_24569[(7)]);
var inst_24542 = (state_24569[(10)]);
var inst_24549 = [cljs.core.cst$kw$success,cljs.core.cst$kw$suppress_DASH_error_DASH_dialog];
var inst_24550 = (function (){var tout = inst_24531;
var cch = inst_24536;
var vec__24533 = inst_24542;
var msg = inst_24543;
var port = inst_24544;
return ((function (tout,cch,vec__24533,msg,port,inst_24536,inst_24543,inst_24544,inst_24531,inst_24542,inst_24549,state_val_24570,c__14822__auto__,___$1){
return (function (p1__24527_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$import_DASH_status,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__24527_SHARP_));
});
;})(tout,cch,vec__24533,msg,port,inst_24536,inst_24543,inst_24544,inst_24531,inst_24542,inst_24549,state_val_24570,c__14822__auto__,___$1))
})();
var inst_24551 = [inst_24550,true];
var inst_24552 = cljs.core.PersistentHashMap.fromArrays(inst_24549,inst_24551);
var inst_24553 = camelot.rest.get_x_opts("/importer",inst_24552);
var inst_24554 = cljs.core.deref(self__.data);
var inst_24555 = camelot.component.nav.import_progress(inst_24554);
var inst_24556 = (inst_24555 > (0));
var inst_24557 = (inst_24555 < (1));
var inst_24558 = (inst_24556) && (inst_24557);
var state_24569__$1 = (function (){var statearr_24577 = state_24569;
(statearr_24577[(12)] = inst_24553);

return statearr_24577;
})();
if(cljs.core.truth_(inst_24558)){
var statearr_24578_24618 = state_24569__$1;
(statearr_24578_24618[(1)] = (8));

} else {
var statearr_24579_24619 = state_24569__$1;
(statearr_24579_24619[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24570 === (3))){
var inst_24567 = (state_24569[(2)]);
var state_24569__$1 = state_24569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24569__$1,inst_24567);
} else {
if((state_val_24570 === (2))){
var inst_24536 = (state_24569[(8)]);
var inst_24531 = (state_24569[(7)]);
var inst_24536__$1 = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$cmd_DASH_chan);
var inst_24537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24538 = cljs.core.async.timeout(inst_24531);
var inst_24539 = [inst_24536__$1,inst_24538];
var inst_24540 = (new cljs.core.PersistentVector(null,2,(5),inst_24537,inst_24539,null));
var state_24569__$1 = (function (){var statearr_24580 = state_24569;
(statearr_24580[(8)] = inst_24536__$1);

return statearr_24580;
})();
return cljs.core.async.ioc_alts_BANG_(state_24569__$1,(4),inst_24540);
} else {
if((state_val_24570 === (9))){
var state_24569__$1 = state_24569;
var statearr_24581_24620 = state_24569__$1;
(statearr_24581_24620[(2)] = camelot.component.nav.bulk_import_refresh_long_timeout);

(statearr_24581_24620[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24570 === (5))){
var inst_24547 = console.log("Bulk import poller cleaned up");
var state_24569__$1 = state_24569;
var statearr_24582_24621 = state_24569__$1;
(statearr_24582_24621[(2)] = inst_24547);

(statearr_24582_24621[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24570 === (10))){
var inst_24562 = (state_24569[(2)]);
var inst_24531 = inst_24562;
var state_24569__$1 = (function (){var statearr_24583 = state_24569;
(statearr_24583[(7)] = inst_24531);

return statearr_24583;
})();
var statearr_24584_24622 = state_24569__$1;
(statearr_24584_24622[(2)] = null);

(statearr_24584_24622[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24570 === (8))){
var state_24569__$1 = state_24569;
var statearr_24585_24623 = state_24569__$1;
(statearr_24585_24623[(2)] = camelot.component.nav.bulk_import_refresh_short_timeout);

(statearr_24585_24623[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,___$1){
return (function() {
var camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__ = null;
var camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____0 = (function (){
var statearr_24586 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24586[(0)] = camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__);

(statearr_24586[(1)] = (1));

return statearr_24586;
});
var camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____1 = (function (state_24569){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_24569);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e24587){if((e24587 instanceof Object)){
var ex__14726__auto__ = e24587;
var statearr_24588_24624 = state_24569;
(statearr_24588_24624[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_24569);

return cljs.core.cst$kw$recur;
} else {
throw e24587;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__24625 = state_24569;
state_24569 = G__24625;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__ = function(state_24569){
switch(arguments.length){
case 0:
return camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____1.call(this,state_24569);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____0;
camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____1;
return camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,___$1))
})();
var state__14824__auto__ = (function (){var statearr_24589 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_24589[(6)] = c__14822__auto__);

return statearr_24589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,___$1))
);

return c__14822__auto__;
});

camelot.component.nav.t_camelot$component$nav24528.prototype.om$core$IWillUnmount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.nav.t_camelot$component$nav24528.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,___$1){
return (function (state_24597){
var state_val_24598 = (state_24597[(1)]);
if((state_val_24598 === (1))){
var inst_24590 = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$cmd_DASH_chan);
var inst_24591 = [cljs.core.cst$kw$cmd];
var inst_24592 = [cljs.core.cst$kw$stop];
var inst_24593 = cljs.core.PersistentHashMap.fromArrays(inst_24591,inst_24592);
var state_24597__$1 = state_24597;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24597__$1,(2),inst_24590,inst_24593);
} else {
if((state_val_24598 === (2))){
var inst_24595 = (state_24597[(2)]);
var state_24597__$1 = state_24597;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24597__$1,inst_24595);
} else {
return null;
}
}
});})(c__14822__auto__,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,___$1){
return (function() {
var camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__ = null;
var camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____0 = (function (){
var statearr_24599 = [null,null,null,null,null,null,null];
(statearr_24599[(0)] = camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__);

(statearr_24599[(1)] = (1));

return statearr_24599;
});
var camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____1 = (function (state_24597){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_24597);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e24600){if((e24600 instanceof Object)){
var ex__14726__auto__ = e24600;
var statearr_24601_24626 = state_24597;
(statearr_24601_24626[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_24597);

return cljs.core.cst$kw$recur;
} else {
throw e24600;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__24627 = state_24597;
state_24597 = G__24627;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__ = function(state_24597){
switch(arguments.length){
case 0:
return camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____1.call(this,state_24597);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____0;
camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto____1;
return camelot$component$nav$bulk_import_progress_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,___$1))
})();
var state__14824__auto__ = (function (){var statearr_24602 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_24602[(6)] = c__14822__auto__);

return statearr_24602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,___$1))
);

return c__14822__auto__;
});

camelot.component.nav.t_camelot$component$nav24528.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.nav.t_camelot$component$nav24528.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var p = camelot.component.nav.import_progress(self__.data);
if((p > (0))){
var G__24603 = null;
var G__24604 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.nav.bulk_import_details_panel_component,self__.data));
var G__24605 = om.util.force_children((function (){var G__24606 = ({"className": "bulk-import-progress", "title": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$nav_SLASH_bulk_DASH_import_DASH_status)});
var G__24607 = om.util.force_children((function (){var G__24610 = ({"className": "fa fa-upload"});
return React.DOM.span(G__24610);
})());
var G__24608 = om.util.force_children(" ");
var G__24609 = om.util.force_children((function (){var G__24611 = null;
var G__24612 = om.util.force_children(((p * (100)) | (0)));
var G__24613 = om.util.force_children("%");
return React.DOM.span(G__24611,G__24612,G__24613);
})());
return React.DOM.div(G__24606,G__24607,G__24608,G__24609);
})());
return React.DOM.div(G__24603,G__24604,G__24605);
} else {
return null;
}
});

camelot.component.nav.t_camelot$component$nav24528.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24529], null);
});

camelot.component.nav.t_camelot$component$nav24528.cljs$lang$type = true;

camelot.component.nav.t_camelot$component$nav24528.cljs$lang$ctorStr = "camelot.component.nav/t_camelot$component$nav24528";

camelot.component.nav.t_camelot$component$nav24528.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.nav/t_camelot$component$nav24528");
});

camelot.component.nav.__GT_t_camelot$component$nav24528 = (function camelot$component$nav$bulk_import_progress_component_$___GT_t_camelot$component$nav24528(data__$1,owner__$1,meta24529){
return (new camelot.component.nav.t_camelot$component$nav24528(data__$1,owner__$1,meta24529));
});

}

return (new camelot.component.nav.t_camelot$component$nav24528(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Render a list item for an item in the navigation bar.
 */
camelot.component.nav.nav_item_component = (function camelot$component$nav$nav_item_component(data,owner){
if(typeof camelot.component.nav.t_camelot$component$nav24628 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.nav.t_camelot$component$nav24628 = (function (data,owner,meta24629){
this.data = data;
this.owner = owner;
this.meta24629 = meta24629;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.nav.t_camelot$component$nav24628.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24630,meta24629__$1){
var self__ = this;
var _24630__$1 = this;
return (new camelot.component.nav.t_camelot$component$nav24628(self__.data,self__.owner,meta24629__$1));
});

camelot.component.nav.t_camelot$component$nav24628.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24630){
var self__ = this;
var _24630__$1 = this;
return self__.meta24629;
});

camelot.component.nav.t_camelot$component$nav24628.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.nav.t_camelot$component$nav24628.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$function.cljs$core$IFn$_invoke$arity$1(self__.data),"settings")){
var G__24631 = ({"id": "settings-nav", "className": "icon-only", "onClick": ((function (___$1){
return (function (){
return camelot.component.nav.toggle_settings_BANG_();
});})(___$1))
});
var G__24632 = om.util.force_children((function (){var G__24633 = null;
var G__24634 = om.util.force_children((function (){var G__24635 = ({"className": "fa fa-cogs fa-2x"});
return React.DOM.span(G__24635);
})());
return React.DOM.a(G__24633,G__24634);
})());
return React.DOM.li(G__24631,G__24632);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$function.cljs$core$IFn$_invoke$arity$1(self__.data),"bulk-import-progress")){
var G__24636 = ({"id": "bulk-import-progress-nav", "onMouseOver": ((function (___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$show_DASH_bulk_DASH_import_DASH_details,true);
});})(___$1))
, "onMouseOut": ((function (___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$show_DASH_bulk_DASH_import_DASH_details,false);
});})(___$1))
});
var G__24637 = om.util.force_children((function (){var G__24638 = ({"className": "bulk-import-progress-container"});
var G__24639 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.nav.bulk_import_progress_component,self__.data));
return React.DOM.div(G__24638,G__24639);
})());
return React.DOM.li(G__24636,G__24637);
} else {
var G__24640 = ({"className": (cljs.core.truth_(cljs.core.cst$kw$experimental.cljs$core$IFn$_invoke$arity$1(self__.data))?"experimental":(cljs.core.truth_(cljs.core.cst$kw$deprecated.cljs$core$IFn$_invoke$arity$1(self__.data))?"deprecated":"")), "onClick": ((function (___$1){
return (function (){
return camelot.nav.nav_BANG_(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(self__.data));
});})(___$1))
});
var G__24641 = om.util.force_children((function (){var G__24642 = null;
var G__24643 = om.util.force_children(cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.a(G__24642,G__24643);
})());
return React.DOM.li(G__24640,G__24641);

}
}
});

camelot.component.nav.t_camelot$component$nav24628.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24629], null);
});

camelot.component.nav.t_camelot$component$nav24628.cljs$lang$type = true;

camelot.component.nav.t_camelot$component$nav24628.cljs$lang$ctorStr = "camelot.component.nav/t_camelot$component$nav24628";

camelot.component.nav.t_camelot$component$nav24628.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.nav/t_camelot$component$nav24628");
});

camelot.component.nav.__GT_t_camelot$component$nav24628 = (function camelot$component$nav$nav_item_component_$___GT_t_camelot$component$nav24628(data__$1,owner__$1,meta24629){
return (new camelot.component.nav.t_camelot$component$nav24628(data__$1,owner__$1,meta24629));
});

}

return (new camelot.component.nav.t_camelot$component$nav24628(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Render navigation bar and contents.
 */
camelot.component.nav.nav_component = (function camelot$component$nav$nav_component(data,owner){
if(typeof camelot.component.nav.t_camelot$component$nav24644 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.nav.t_camelot$component$nav24644 = (function (data,owner,meta24645){
this.data = data;
this.owner = owner;
this.meta24645 = meta24645;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.nav.t_camelot$component$nav24644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24646,meta24645__$1){
var self__ = this;
var _24646__$1 = this;
return (new camelot.component.nav.t_camelot$component$nav24644(self__.data,self__.owner,meta24645__$1));
});

camelot.component.nav.t_camelot$component$nav24644.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24646){
var self__ = this;
var _24646__$1 = this;
return self__.meta24645;
});

camelot.component.nav.t_camelot$component$nav24644.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.nav.t_camelot$component$nav24644.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__24647 = null;
var G__24648 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$loading.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__24650 = ({"className": "loading"});
var G__24651 = om.util.force_children((function (){var G__24653 = ({"src": "images/spinner.gif", "height": "32px"});
return React.DOM.img(G__24653);
})());
var G__24652 = om.util.force_children(cljs.core.cst$kw$loading.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.label(G__24650,G__24651,G__24652);
})():null));
var G__24649 = om.util.force_children(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(om.dom.ul,({"className": "nav navbar-nav"}),om.core.build_all.cljs$core$IFn$_invoke$arity$2(camelot.component.nav.nav_item_component,(cljs.core.truth_(cljs.core.cst$kw$restricted_DASH_mode.cljs$core$IFn$_invoke$arity$1(self__.data))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null):cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.cst$kw$menu_DASH_items.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$nav.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$application.cljs$core$IFn$_invoke$arity$1(self__.data))))))));
return React.DOM.div(G__24647,G__24648,G__24649);
});

camelot.component.nav.t_camelot$component$nav24644.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24645], null);
});

camelot.component.nav.t_camelot$component$nav24644.cljs$lang$type = true;

camelot.component.nav.t_camelot$component$nav24644.cljs$lang$ctorStr = "camelot.component.nav/t_camelot$component$nav24644";

camelot.component.nav.t_camelot$component$nav24644.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.nav/t_camelot$component$nav24644");
});

camelot.component.nav.__GT_t_camelot$component$nav24644 = (function camelot$component$nav$nav_component_$___GT_t_camelot$component$nav24644(data__$1,owner__$1,meta24645){
return (new camelot.component.nav.t_camelot$component$nav24644(data__$1,owner__$1,meta24645));
});

}

return (new camelot.component.nav.t_camelot$component$nav24644(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
