// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.site.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.core');
goog.require('camelot.nav');
goog.require('camelot.component.util');
goog.require('om.dom');
goog.require('camelot.rest');
goog.require('camelot.component.site.manage');
goog.require('camelot.util.cursorise');
goog.require('camelot.translation.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Delete the site and trigger a removal event.
 */
camelot.component.site.core.delete$ = (function camelot$component$site$core$delete(state,data,event){
event.preventDefault();

event.stopPropagation();

if(cljs.core.truth_((function (){var G__19965 = camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_confirm_DASH_delete);
return confirm(G__19965);
})())){
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/sites/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$site_DASH_id.cljs$core$IFn$_invoke$arity$1(data))].join(''),(function (){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_19973){
var state_val_19974 = (state_19973[(1)]);
if((state_val_19974 === (1))){
var inst_19966 = cljs.core.cst$kw$chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_19967 = [cljs.core.cst$kw$event,cljs.core.cst$kw$data];
var inst_19968 = [cljs.core.cst$kw$delete,data];
var inst_19969 = cljs.core.PersistentHashMap.fromArrays(inst_19967,inst_19968);
var state_19973__$1 = state_19973;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19973__$1,(2),inst_19966,inst_19969);
} else {
if((state_val_19974 === (2))){
var inst_19971 = (state_19973[(2)]);
var state_19973__$1 = state_19973;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19973__$1,inst_19971);
} else {
return null;
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$component$site$core$delete_$_state_machine__14723__auto__ = null;
var camelot$component$site$core$delete_$_state_machine__14723__auto____0 = (function (){
var statearr_19975 = [null,null,null,null,null,null,null];
(statearr_19975[(0)] = camelot$component$site$core$delete_$_state_machine__14723__auto__);

(statearr_19975[(1)] = (1));

return statearr_19975;
});
var camelot$component$site$core$delete_$_state_machine__14723__auto____1 = (function (state_19973){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_19973);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e19976){if((e19976 instanceof Object)){
var ex__14726__auto__ = e19976;
var statearr_19977_19979 = state_19973;
(statearr_19977_19979[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19973);

return cljs.core.cst$kw$recur;
} else {
throw e19976;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__19980 = state_19973;
state_19973 = G__19980;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$site$core$delete_$_state_machine__14723__auto__ = function(state_19973){
switch(arguments.length){
case 0:
return camelot$component$site$core$delete_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$site$core$delete_$_state_machine__14723__auto____1.call(this,state_19973);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$site$core$delete_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$site$core$delete_$_state_machine__14723__auto____0;
camelot$component$site$core$delete_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$site$core$delete_$_state_machine__14723__auto____1;
return camelot$component$site$core$delete_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_19978 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_19978[(6)] = c__14822__auto__);

return statearr_19978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
}));
} else {
return null;
}
});
camelot.component.site.core.add_success_handler = (function camelot$component$site$core$add_success_handler(data,resp){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$list,(function (p1__19981_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19981_SHARP_,camelot.util.cursorise.decursorise(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp)));
}));

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$new_DASH_site_DASH_name,null);
});
camelot.component.site.core.add_site_handler = (function camelot$component$site$core$add_site_handler(data){
camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3("/sites",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$new_DASH_site_DASH_name.cljs$core$IFn$_invoke$arity$1(data)], null)], null),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.component.site.core.add_success_handler,data));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-site","create-click");
});
camelot.component.site.core.validate_proposed_site = (function camelot$component$site$core$validate_proposed_site(data){
return cljs.core.not((function (){var or__6624__auto__ = (cljs.core.cst$kw$new_DASH_site_DASH_name.cljs$core$IFn$_invoke$arity$1(data) == null);
if(or__6624__auto__){
return or__6624__auto__;
} else {
var site = clojure.string.lower_case(clojure.string.trim(cljs.core.cst$kw$new_DASH_site_DASH_name.cljs$core$IFn$_invoke$arity$1(data)));
var or__6624__auto____$1 = cljs.core.empty_QMARK_(site);
if(or__6624__auto____$1){
return or__6624__auto____$1;
} else {
return cljs.core.some(((function (or__6624__auto____$1,site,or__6624__auto__){
return (function (p1__19982_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(site,clojure.string.lower_case(clojure.string.trim(p1__19982_SHARP_)));
});})(or__6624__auto____$1,site,or__6624__auto__))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(data)));
}
}
})());
});
camelot.component.site.core.add_site_component = (function camelot$component$site$core$add_site_component(data,owner){
if(typeof camelot.component.site.core.t_camelot$component$site$core19985 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.site.core.t_camelot$component$site$core19985 = (function (data,owner,meta19986){
this.data = data;
this.owner = owner;
this.meta19986 = meta19986;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.site.core.t_camelot$component$site$core19985.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19987,meta19986__$1){
var self__ = this;
var _19987__$1 = this;
return (new camelot.component.site.core.t_camelot$component$site$core19985(self__.data,self__.owner,meta19986__$1));
});

camelot.component.site.core.t_camelot$component$site$core19985.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19987){
var self__ = this;
var _19987__$1 = this;
return self__.meta19986;
});

camelot.component.site.core.t_camelot$component$site$core19985.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.site.core.t_camelot$component$site$core19985.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var is_valid = camelot.component.site.core.validate_proposed_site(self__.data);
var G__19988 = ({"className": "field-input-form", "onSubmit": ((function (is_valid,___$1){
return (function (p1__19983_SHARP_){
return p1__19983_SHARP_.preventDefault();
});})(is_valid,___$1))
});
var G__19989 = om.util.force_children((function (){var G__19991 = ({"className": "field-input", "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_new_DASH_site_DASH_name), "value": cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_site_DASH_name], null)), "onChange": ((function (G__19988,is_valid,___$1){
return (function (p1__19984_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$new_DASH_site_DASH_name,p1__19984_SHARP_.target.value);
});})(G__19988,is_valid,___$1))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__19991) : om.dom.input.call(null,G__19991));
})());
var G__19990 = om.util.force_children((function (){var G__19992 = ({"type": "submit", "disabled": (cljs.core.truth_(is_valid)?"":"disabled"), "title": (cljs.core.truth_(is_valid)?null:camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_validation_DASH_duplicate_DASH_site)), "className": "btn btn-primary input-field-submit", "onClick": ((function (G__19988,G__19989,is_valid,___$1){
return (function (){
return camelot.component.site.core.add_site_handler(self__.data);
});})(G__19988,G__19989,is_valid,___$1))
, "value": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_add)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__19992) : om.dom.input.call(null,G__19992));
})());
return React.DOM.form(G__19988,G__19989,G__19990);
});

camelot.component.site.core.t_camelot$component$site$core19985.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta19986], null);
});

camelot.component.site.core.t_camelot$component$site$core19985.cljs$lang$type = true;

camelot.component.site.core.t_camelot$component$site$core19985.cljs$lang$ctorStr = "camelot.component.site.core/t_camelot$component$site$core19985";

camelot.component.site.core.t_camelot$component$site$core19985.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.site.core/t_camelot$component$site$core19985");
});

camelot.component.site.core.__GT_t_camelot$component$site$core19985 = (function camelot$component$site$core$add_site_component_$___GT_t_camelot$component$site$core19985(data__$1,owner__$1,meta19986){
return (new camelot.component.site.core.t_camelot$component$site$core19985(data__$1,owner__$1,meta19986));
});

}

return (new camelot.component.site.core.t_camelot$component$site$core19985(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.site.core.site_list_component = (function camelot$component$site$core$site_list_component(data,owner){
if(typeof camelot.component.site.core.t_camelot$component$site$core19993 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.site.core.t_camelot$component$site$core19993 = (function (data,owner,meta19994){
this.data = data;
this.owner = owner;
this.meta19994 = meta19994;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.site.core.t_camelot$component$site$core19993.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_19995,meta19994__$1){
var self__ = this;
var _19995__$1 = this;
return (new camelot.component.site.core.t_camelot$component$site$core19993(self__.data,self__.owner,meta19994__$1));
});

camelot.component.site.core.t_camelot$component$site$core19993.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_19995){
var self__ = this;
var _19995__$1 = this;
return self__.meta19994;
});

camelot.component.site.core.t_camelot$component$site$core19993.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.site.core.t_camelot$component$site$core19993.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__19996 = ({"className": "menu-item detailed dynamic", "onClick": ((function (___$1){
return (function (){
return camelot.nav.nav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/site/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$site_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data))].join(''));
});})(___$1))
});
var G__19997 = om.util.force_children((function (){var G__20002 = ({"className": "pull-right fa fa-times remove top-corner", "onClick": cljs.core.partial.cljs$core$IFn$_invoke$arity$3(camelot.component.site.core.delete$,state,self__.data)});
return React.DOM.div(G__20002);
})());
var G__19998 = om.util.force_children((function (){var G__20003 = ({"className": "status pull-right"});
var G__20004 = om.util.force_children(cljs.core.cst$kw$site_DASH_city.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__20003,G__20004);
})());
var G__19999 = om.util.force_children((function (){var G__20005 = ({"className": "menu-item-title"});
var G__20006 = om.util.force_children(cljs.core.cst$kw$site_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__20005,G__20006);
})());
var G__20000 = om.util.force_children((function (){var G__20007 = ({"className": "menu-item-description"});
var G__20008 = om.util.force_children(((cljs.core.empty_QMARK_(cljs.core.cst$kw$site_DASH_sublocation.cljs$core$IFn$_invoke$arity$1(self__.data)))?null:(function (){var G__20010 = null;
var G__20011 = om.util.force_children((function (){var G__20014 = null;
var G__20015 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$site_SLASH_site_DASH_sublocation$label));
var G__20016 = om.util.force_children(":");
return React.DOM.label(G__20014,G__20015,G__20016);
})());
var G__20012 = om.util.force_children(" ");
var G__20013 = om.util.force_children(cljs.core.cst$kw$site_DASH_sublocation.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.div(G__20010,G__20011,G__20012,G__20013);
})()));
var G__20009 = om.util.force_children(((cljs.core.empty_QMARK_(cljs.core.cst$kw$site_DASH_state_DASH_province.cljs$core$IFn$_invoke$arity$1(self__.data)))?null:(function (){var G__20017 = null;
var G__20018 = om.util.force_children((function (){var G__20021 = null;
var G__20022 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$site_SLASH_site_DASH_state_DASH_province$label));
var G__20023 = om.util.force_children(":");
return React.DOM.label(G__20021,G__20022,G__20023);
})());
var G__20019 = om.util.force_children(" ");
var G__20020 = om.util.force_children(cljs.core.cst$kw$site_DASH_state_DASH_province.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.div(G__20017,G__20018,G__20019,G__20020);
})()));
return React.DOM.span(G__20007,G__20008,G__20009);
})());
var G__20001 = om.util.force_children((function (){var G__20024 = ({"className": "menu-item-description"});
var G__20025 = om.util.force_children(cljs.core.cst$kw$site_DASH_notes.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.div(G__20024,G__20025);
})());
return React.DOM.div(G__19996,G__19997,G__19998,G__19999,G__20000,G__20001);
});

camelot.component.site.core.t_camelot$component$site$core19993.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta19994], null);
});

camelot.component.site.core.t_camelot$component$site$core19993.cljs$lang$type = true;

camelot.component.site.core.t_camelot$component$site$core19993.cljs$lang$ctorStr = "camelot.component.site.core/t_camelot$component$site$core19993";

camelot.component.site.core.t_camelot$component$site$core19993.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.site.core/t_camelot$component$site$core19993");
});

camelot.component.site.core.__GT_t_camelot$component$site$core19993 = (function camelot$component$site$core$site_list_component_$___GT_t_camelot$component$site$core19993(data__$1,owner__$1,meta19994){
return (new camelot.component.site.core.t_camelot$component$site$core19993(data__$1,owner__$1,meta19994));
});

}

return (new camelot.component.site.core.t_camelot$component$site$core19993(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.site.core.manage_view = (function camelot$component$site$core$manage_view(data,owner,p__20027){
var map__20028 = p__20027;
var map__20028__$1 = ((((!((map__20028 == null)))?((((map__20028.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20028.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20028):map__20028);
var site_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20028__$1,cljs.core.cst$kw$site_DASH_id);
if(typeof camelot.component.site.core.t_camelot$component$site$core20030 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.site.core.t_camelot$component$site$core20030 = (function (data,owner,p__20027,map__20028,site_id,meta20031){
this.data = data;
this.owner = owner;
this.p__20027 = p__20027;
this.map__20028 = map__20028;
this.site_id = site_id;
this.meta20031 = meta20031;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.site.core.t_camelot$component$site$core20030.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20028,map__20028__$1,site_id){
return (function (_20032,meta20031__$1){
var self__ = this;
var _20032__$1 = this;
return (new camelot.component.site.core.t_camelot$component$site$core20030(self__.data,self__.owner,self__.p__20027,self__.map__20028,self__.site_id,meta20031__$1));
});})(map__20028,map__20028__$1,site_id))
;

camelot.component.site.core.t_camelot$component$site$core20030.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20028,map__20028__$1,site_id){
return (function (_20032){
var self__ = this;
var _20032__$1 = this;
return self__.meta20031;
});})(map__20028,map__20028__$1,site_id))
;

camelot.component.site.core.t_camelot$component$site$core20030.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.site.core.t_camelot$component$site$core20030.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__20028,map__20028__$1,site_id){
return (function (_){
var self__ = this;
var ___$1 = this;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$data,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/sites/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.site_id)].join(''),((function (___$1,map__20028,map__20028__$1,site_id){
return (function (p1__20026_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$data,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__20026_SHARP_));

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2("/sites/",((function (___$1,map__20028,map__20028__$1,site_id){
return (function (x){
var others = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (___$1,map__20028,map__20028__$1,site_id){
return (function (v){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__20026_SHARP_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$value], null)),cljs.core.cst$kw$site_DASH_name.cljs$core$IFn$_invoke$arity$1(v));
});})(___$1,map__20028,map__20028__$1,site_id))
,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(x));
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,others);
});})(___$1,map__20028,map__20028__$1,site_id))
);
});})(___$1,map__20028,map__20028__$1,site_id))
);
});})(map__20028,map__20028__$1,site_id))
;

camelot.component.site.core.t_camelot$component$site$core20030.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.site.core.t_camelot$component$site$core20030.prototype.om$core$IRender$render$arity$1 = ((function (map__20028,map__20028__$1,site_id){
return (function (_){
var self__ = this;
var ___$1 = this;
if((cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data) == null)){
var G__20033 = ({"className": "align-center"});
var G__20034 = om.util.force_children((function (){var G__20035 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__20035);
})());
return React.DOM.div(G__20033,G__20034);
} else {
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.site.manage.manage_component,self__.data);
}
});})(map__20028,map__20028__$1,site_id))
;

camelot.component.site.core.t_camelot$component$site$core20030.getBasis = ((function (map__20028,map__20028__$1,site_id){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__20027,cljs.core.cst$sym$map__20028,cljs.core.cst$sym$site_DASH_id,cljs.core.cst$sym$meta20031], null);
});})(map__20028,map__20028__$1,site_id))
;

camelot.component.site.core.t_camelot$component$site$core20030.cljs$lang$type = true;

camelot.component.site.core.t_camelot$component$site$core20030.cljs$lang$ctorStr = "camelot.component.site.core/t_camelot$component$site$core20030";

camelot.component.site.core.t_camelot$component$site$core20030.cljs$lang$ctorPrWriter = ((function (map__20028,map__20028__$1,site_id){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.site.core/t_camelot$component$site$core20030");
});})(map__20028,map__20028__$1,site_id))
;

camelot.component.site.core.__GT_t_camelot$component$site$core20030 = ((function (map__20028,map__20028__$1,site_id){
return (function camelot$component$site$core$manage_view_$___GT_t_camelot$component$site$core20030(data__$1,owner__$1,p__20027__$1,map__20028__$2,site_id__$1,meta20031){
return (new camelot.component.site.core.t_camelot$component$site$core20030(data__$1,owner__$1,p__20027__$1,map__20028__$2,site_id__$1,meta20031));
});})(map__20028,map__20028__$1,site_id))
;

}

return (new camelot.component.site.core.t_camelot$component$site$core20030(data,owner,p__20027,map__20028__$1,site_id,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.site.core.site_menu_component = (function camelot$component$site$core$site_menu_component(data,owner){
if(typeof camelot.component.site.core.t_camelot$component$site$core20040 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.site.core.t_camelot$component$site$core20040 = (function (data,owner,meta20041){
this.data = data;
this.owner = owner;
this.meta20041 = meta20041;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.site.core.t_camelot$component$site$core20040.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20042,meta20041__$1){
var self__ = this;
var _20042__$1 = this;
return (new camelot.component.site.core.t_camelot$component$site$core20040(self__.data,self__.owner,meta20041__$1));
});

camelot.component.site.core.t_camelot$component$site$core20040.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20042){
var self__ = this;
var _20042__$1 = this;
return self__.meta20041;
});

camelot.component.site.core.t_camelot$component$site$core20040.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.site.core.t_camelot$component$site$core20040.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.site.core.t_camelot$component$site$core20040.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.site.core.t_camelot$component$site$core20040.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);
});

camelot.component.site.core.t_camelot$component$site$core20040.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.site.core.t_camelot$component$site$core20040.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
camelot.rest.get_resource("/sites",((function (___$1){
return (function (p1__20036_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__20036_SHARP_));
});})(___$1))
);

var ch = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$chan);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,ch,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,ch,___$1){
return (function (state_20058){
var state_val_20059 = (state_20058[(1)]);
if((state_val_20059 === (1))){
var state_20058__$1 = state_20058;
var statearr_20060_20089 = state_20058__$1;
(statearr_20060_20089[(2)] = null);

(statearr_20060_20089[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20059 === (2))){
var state_20058__$1 = state_20058;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20058__$1,(4),ch);
} else {
if((state_val_20059 === (3))){
var inst_20056 = (state_20058[(2)]);
var state_20058__$1 = state_20058;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20058__$1,inst_20056);
} else {
if((state_val_20059 === (4))){
var inst_20045 = (state_20058[(7)]);
var inst_20045__$1 = (state_20058[(2)]);
var inst_20046 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(inst_20045__$1);
var inst_20047 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20046,cljs.core.cst$kw$delete);
var state_20058__$1 = (function (){var statearr_20061 = state_20058;
(statearr_20061[(7)] = inst_20045__$1);

return statearr_20061;
})();
if(inst_20047){
var statearr_20062_20090 = state_20058__$1;
(statearr_20062_20090[(1)] = (5));

} else {
var statearr_20063_20091 = state_20058__$1;
(statearr_20063_20091[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20059 === (5))){
var inst_20045 = (state_20058[(7)]);
var inst_20049 = (function (){var r = inst_20045;
return ((function (r,inst_20045,state_val_20059,c__14822__auto__,ch,___$1){
return (function (p1__20037_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (r,inst_20045,state_val_20059,c__14822__auto__,ch,___$1){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(r));
});})(r,inst_20045,state_val_20059,c__14822__auto__,ch,___$1))
,p1__20037_SHARP_);
});
;})(r,inst_20045,state_val_20059,c__14822__auto__,ch,___$1))
})();
var inst_20050 = om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,inst_20049);
var state_20058__$1 = state_20058;
var statearr_20064_20092 = state_20058__$1;
(statearr_20064_20092[(2)] = inst_20050);

(statearr_20064_20092[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20059 === (6))){
var state_20058__$1 = state_20058;
var statearr_20065_20093 = state_20058__$1;
(statearr_20065_20093[(2)] = null);

(statearr_20065_20093[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20059 === (7))){
var inst_20053 = (state_20058[(2)]);
var state_20058__$1 = (function (){var statearr_20066 = state_20058;
(statearr_20066[(8)] = inst_20053);

return statearr_20066;
})();
var statearr_20067_20094 = state_20058__$1;
(statearr_20067_20094[(2)] = null);

(statearr_20067_20094[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__14822__auto__,ch,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,ch,___$1){
return (function() {
var camelot$component$site$core$site_menu_component_$_state_machine__14723__auto__ = null;
var camelot$component$site$core$site_menu_component_$_state_machine__14723__auto____0 = (function (){
var statearr_20068 = [null,null,null,null,null,null,null,null,null];
(statearr_20068[(0)] = camelot$component$site$core$site_menu_component_$_state_machine__14723__auto__);

(statearr_20068[(1)] = (1));

return statearr_20068;
});
var camelot$component$site$core$site_menu_component_$_state_machine__14723__auto____1 = (function (state_20058){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20058);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20069){if((e20069 instanceof Object)){
var ex__14726__auto__ = e20069;
var statearr_20070_20095 = state_20058;
(statearr_20070_20095[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20058);

return cljs.core.cst$kw$recur;
} else {
throw e20069;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20096 = state_20058;
state_20058 = G__20096;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$site$core$site_menu_component_$_state_machine__14723__auto__ = function(state_20058){
switch(arguments.length){
case 0:
return camelot$component$site$core$site_menu_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$site$core$site_menu_component_$_state_machine__14723__auto____1.call(this,state_20058);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$site$core$site_menu_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$site$core$site_menu_component_$_state_machine__14723__auto____0;
camelot$component$site$core$site_menu_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$site$core$site_menu_component_$_state_machine__14723__auto____1;
return camelot$component$site$core$site_menu_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,ch,___$1))
})();
var state__14824__auto__ = (function (){var statearr_20071 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20071[(6)] = c__14822__auto__);

return statearr_20071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,ch,___$1))
);

return c__14822__auto__;
});

camelot.component.site.core.t_camelot$component$site$core20040.prototype.om$core$IWillUnmount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.site.core.t_camelot$component$site$core20040.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,null);
});

camelot.component.site.core.t_camelot$component$site$core20040.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.site.core.t_camelot$component$site$core20040.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__20072 = ({"className": "section"});
var G__20073 = om.util.force_children((function (){var G__20078 = null;
var G__20079 = om.util.force_children((function (){var G__20080 = ({"className": "field-input", "value": cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data), "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_filter_DASH_sites), "onChange": ((function (G__20078,G__20072,___$1){
return (function (p1__20038_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$filter,p1__20038_SHARP_.target.value);
});})(G__20078,G__20072,___$1))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__20080) : om.dom.input.call(null,G__20080));
})());
return React.DOM.div(G__20078,G__20079);
})());
var G__20074 = om.util.force_children((function (){var G__20081 = ({"className": "simple-menu scroll"});
var G__20082 = om.util.force_children((function (){var filtered = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__20081,G__20072,G__20073,___$1){
return (function (p1__20039_SHARP_){
if(((cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data) == null)) || (cljs.core.empty_QMARK_(cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data)))){
return true;
} else {
return cljs.core.re_matches(cljs.core.re_pattern([cljs.core.str.cljs$core$IFn$_invoke$arity$1("(?i).*"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(self__.data)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".*")].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$site_DASH_name.cljs$core$IFn$_invoke$arity$1(p1__20039_SHARP_)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$site_DASH_city.cljs$core$IFn$_invoke$arity$1(p1__20039_SHARP_)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$site_DASH_sublocation.cljs$core$IFn$_invoke$arity$1(p1__20039_SHARP_)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$site_DASH_state_DASH_province.cljs$core$IFn$_invoke$arity$1(p1__20039_SHARP_)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$site_DASH_country.cljs$core$IFn$_invoke$arity$1(p1__20039_SHARP_)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$site_DASH_notes.cljs$core$IFn$_invoke$arity$1(p1__20039_SHARP_))].join(''));
}
});})(G__20081,G__20072,G__20073,___$1))
,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data)));
if(cljs.core.empty_QMARK_(filtered)){
return om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.blank_slate_component,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$item_DASH_name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_item_DASH_name),cljs.core.cst$kw$advice,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$site$core_SLASH_advice)], null)], null));
} else {
return om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.site.core.site_list_component,filtered,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$site_DASH_id,cljs.core.cst$kw$init_DASH_state,state], null));
}
})());
return React.DOM.div(G__20081,G__20082);
})());
var G__20075 = om.util.force_children((function (){var G__20083 = ({"className": "sep"});
return React.DOM.div(G__20083);
})());
var G__20076 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.site.core.add_site_component,self__.data));
var G__20077 = om.util.force_children((function (){var G__20084 = ({"className": "btn btn-default", "onClick": ((function (G__20072,G__20073,G__20074,G__20075,G__20076,___$1){
return (function (){
camelot.nav.nav_BANG_("/sites");

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-site","advanced-click");
});})(G__20072,G__20073,G__20074,G__20075,G__20076,___$1))
});
var G__20085 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_advanced));
return React.DOM.button(G__20084,G__20085);
})());
return React.DOM.div(G__20072,G__20073,G__20074,G__20075,G__20076,G__20077);
} else {
var G__20086 = ({"className": "align-center"});
var G__20087 = om.util.force_children((function (){var G__20088 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__20088);
})());
return React.DOM.div(G__20086,G__20087);
}
});

camelot.component.site.core.t_camelot$component$site$core20040.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20041], null);
});

camelot.component.site.core.t_camelot$component$site$core20040.cljs$lang$type = true;

camelot.component.site.core.t_camelot$component$site$core20040.cljs$lang$ctorStr = "camelot.component.site.core/t_camelot$component$site$core20040";

camelot.component.site.core.t_camelot$component$site$core20040.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.site.core/t_camelot$component$site$core20040");
});

camelot.component.site.core.__GT_t_camelot$component$site$core20040 = (function camelot$component$site$core$site_menu_component_$___GT_t_camelot$component$site$core20040(data__$1,owner__$1,meta20041){
return (new camelot.component.site.core.t_camelot$component$site$core20040(data__$1,owner__$1,meta20041));
});

}

return (new camelot.component.site.core.t_camelot$component$site$core20040(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
