// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.species_search');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('camelot.rest');
goog.require('camelot.nav');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('goog.string');
goog.require('om.core');
goog.require('om.dom');
goog.require('camelot.state');
goog.require('camelot.translation.core');
camelot.component.species_search.db_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["Systema Dipterorum",null,"ITIS Global: The Integrated Taxonomic Information System",null,"ITIS Regional: The Integrated Taxonomic Information System",null,"FishBase",null,"WSC: World Spider Catalog",null], null), null);
camelot.component.species_search.get_classification = (function camelot$component$species_search$get_classification(rank,classifications){
var G__20862 = (function (){var or__6624__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__20861_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__20861_SHARP_,"rank"),rank);
}),classifications)),"name");
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return "";
}
})();
return goog.string.unescapeEntities(G__20862);
});
camelot.component.species_search.process_result = (function camelot$component$species_search$process_result(res){
var vec__20863 = clojure.string.split.cljs$core$IFn$_invoke$arity$2((function (){var G__20866 = (function (){var or__6624__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,"name");
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return "";
}
})();
return goog.string.unescapeEntities(G__20866);
})(),/ /);
var genus = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20863,(0),null);
var species = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20863,(1),null);
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,"id"),cljs.core.cst$kw$citation,cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,goog.string.unescapeEntities("bibliographic_citation")),cljs.core.cst$kw$species,species,cljs.core.cst$kw$genus,genus], null);
});
camelot.component.species_search.process_all_results = (function camelot$component$species_search$process_all_results(raw){
return cljs.core.vec(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.sorted_set_by,(function (p1__20867_SHARP_,p2__20868_SHARP_){
var g = cljs.core.compare(cljs.core.cst$kw$genus.cljs$core$IFn$_invoke$arity$1(p1__20867_SHARP_),cljs.core.cst$kw$genus.cljs$core$IFn$_invoke$arity$1(p2__20868_SHARP_));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(g,(0))){
return cljs.core.compare(cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(p1__20867_SHARP_),cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(p2__20868_SHARP_));
} else {
return g;
}
}),cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__20869_SHARP_){
var and__6612__auto__ = cljs.core.cst$kw$genus.cljs$core$IFn$_invoke$arity$1(p1__20869_SHARP_);
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(p1__20869_SHARP_);
} else {
return and__6612__auto__;
}
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2(camelot.component.species_search.process_result,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__20870_SHARP_){
return (cljs.core.contains_QMARK_(camelot.component.species_search.db_whitelist,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__20870_SHARP_,"source_database"))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__20870_SHARP_,"name_status"),"accepted name"));
}),cljs.core.get.cljs$core$IFn$_invoke$arity$2(raw,"results"))))));
});
camelot.component.species_search.lookup_species = (function camelot$component$species_search$lookup_species(chan,e){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_20890){
var state_val_20891 = (state_20890[(1)]);
if((state_val_20891 === (1))){
var inst_20872 = [cljs.core.cst$kw$busy];
var inst_20873 = [true];
var inst_20874 = cljs.core.PersistentHashMap.fromArrays(inst_20872,inst_20873);
var state_20890__$1 = state_20890;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20890__$1,(2),chan,inst_20874);
} else {
if((state_val_20891 === (2))){
var inst_20876 = (state_20890[(2)]);
var inst_20877 = [cljs.core.cst$kw$query_DASH_params];
var inst_20878 = ["search"];
var inst_20879 = e.target;
var inst_20880 = cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(inst_20879);
var inst_20881 = cljs.core.first(inst_20880);
var inst_20882 = inst_20881.value;
var inst_20883 = [inst_20882];
var inst_20884 = cljs.core.PersistentHashMap.fromArrays(inst_20878,inst_20883);
var inst_20885 = [inst_20884];
var inst_20886 = cljs.core.PersistentHashMap.fromArrays(inst_20877,inst_20885);
var inst_20887 = (function (){return ((function (inst_20876,inst_20877,inst_20878,inst_20879,inst_20880,inst_20881,inst_20882,inst_20883,inst_20884,inst_20885,inst_20886,state_val_20891,c__14822__auto__){
return (function (p1__20871_SHARP_){
var c__14822__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto____$1,inst_20876,inst_20877,inst_20878,inst_20879,inst_20880,inst_20881,inst_20882,inst_20883,inst_20884,inst_20885,inst_20886,state_val_20891,c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto____$1,inst_20876,inst_20877,inst_20878,inst_20879,inst_20880,inst_20881,inst_20882,inst_20883,inst_20884,inst_20885,inst_20886,state_val_20891,c__14822__auto__){
return (function (state_20900){
var state_val_20901 = (state_20900[(1)]);
if((state_val_20901 === (1))){
var inst_20892 = [cljs.core.cst$kw$busy,cljs.core.cst$kw$results];
var inst_20893 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__20871_SHARP_);
var inst_20894 = camelot.component.species_search.process_all_results(inst_20893);
var inst_20895 = [false,inst_20894];
var inst_20896 = cljs.core.PersistentHashMap.fromArrays(inst_20892,inst_20895);
var state_20900__$1 = state_20900;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20900__$1,(2),chan,inst_20896);
} else {
if((state_val_20901 === (2))){
var inst_20898 = (state_20900[(2)]);
var state_20900__$1 = state_20900;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20900__$1,inst_20898);
} else {
return null;
}
}
});})(c__14822__auto____$1,inst_20876,inst_20877,inst_20878,inst_20879,inst_20880,inst_20881,inst_20882,inst_20883,inst_20884,inst_20885,inst_20886,state_val_20891,c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto____$1,inst_20876,inst_20877,inst_20878,inst_20879,inst_20880,inst_20881,inst_20882,inst_20883,inst_20884,inst_20885,inst_20886,state_val_20891,c__14822__auto__){
return (function() {
var camelot$component$species_search$lookup_species_$_state_machine__14723__auto__ = null;
var camelot$component$species_search$lookup_species_$_state_machine__14723__auto____0 = (function (){
var statearr_20902 = [null,null,null,null,null,null,null];
(statearr_20902[(0)] = camelot$component$species_search$lookup_species_$_state_machine__14723__auto__);

(statearr_20902[(1)] = (1));

return statearr_20902;
});
var camelot$component$species_search$lookup_species_$_state_machine__14723__auto____1 = (function (state_20900){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20900);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20903){if((e20903 instanceof Object)){
var ex__14726__auto__ = e20903;
var statearr_20904_20911 = state_20900;
(statearr_20904_20911[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20900);

return cljs.core.cst$kw$recur;
} else {
throw e20903;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20912 = state_20900;
state_20900 = G__20912;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$species_search$lookup_species_$_state_machine__14723__auto__ = function(state_20900){
switch(arguments.length){
case 0:
return camelot$component$species_search$lookup_species_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$species_search$lookup_species_$_state_machine__14723__auto____1.call(this,state_20900);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$species_search$lookup_species_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$species_search$lookup_species_$_state_machine__14723__auto____0;
camelot$component$species_search$lookup_species_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$species_search$lookup_species_$_state_machine__14723__auto____1;
return camelot$component$species_search$lookup_species_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto____$1,inst_20876,inst_20877,inst_20878,inst_20879,inst_20880,inst_20881,inst_20882,inst_20883,inst_20884,inst_20885,inst_20886,state_val_20891,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_20905 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20905[(6)] = c__14822__auto____$1);

return statearr_20905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto____$1,inst_20876,inst_20877,inst_20878,inst_20879,inst_20880,inst_20881,inst_20882,inst_20883,inst_20884,inst_20885,inst_20886,state_val_20891,c__14822__auto__))
);

return c__14822__auto____$1;
});
;})(inst_20876,inst_20877,inst_20878,inst_20879,inst_20880,inst_20881,inst_20882,inst_20883,inst_20884,inst_20885,inst_20886,state_val_20891,c__14822__auto__))
})();
var inst_20888 = camelot.rest.get_x_raw("/species/search",inst_20886,inst_20887);
var state_20890__$1 = (function (){var statearr_20906 = state_20890;
(statearr_20906[(7)] = inst_20876);

return statearr_20906;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20890__$1,inst_20888);
} else {
return null;
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$component$species_search$lookup_species_$_state_machine__14723__auto__ = null;
var camelot$component$species_search$lookup_species_$_state_machine__14723__auto____0 = (function (){
var statearr_20907 = [null,null,null,null,null,null,null,null];
(statearr_20907[(0)] = camelot$component$species_search$lookup_species_$_state_machine__14723__auto__);

(statearr_20907[(1)] = (1));

return statearr_20907;
});
var camelot$component$species_search$lookup_species_$_state_machine__14723__auto____1 = (function (state_20890){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20890);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20908){if((e20908 instanceof Object)){
var ex__14726__auto__ = e20908;
var statearr_20909_20913 = state_20890;
(statearr_20909_20913[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20890);

return cljs.core.cst$kw$recur;
} else {
throw e20908;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20914 = state_20890;
state_20890 = G__20914;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$species_search$lookup_species_$_state_machine__14723__auto__ = function(state_20890){
switch(arguments.length){
case 0:
return camelot$component$species_search$lookup_species_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$species_search$lookup_species_$_state_machine__14723__auto____1.call(this,state_20890);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$species_search$lookup_species_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$species_search$lookup_species_$_state_machine__14723__auto____0;
camelot$component$species_search$lookup_species_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$species_search$lookup_species_$_state_machine__14723__auto____1;
return camelot$component$species_search$lookup_species_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_20910 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20910[(6)] = c__14822__auto__);

return statearr_20910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});
camelot.component.species_search.search_input_component = (function camelot$component$species_search$search_input_component(data,owner){
if(typeof camelot.component.species_search.t_camelot$component$species_search20917 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.species_search.t_camelot$component$species_search20917 = (function (data,owner,meta20918){
this.data = data;
this.owner = owner;
this.meta20918 = meta20918;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.species_search.t_camelot$component$species_search20917.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20919,meta20918__$1){
var self__ = this;
var _20919__$1 = this;
return (new camelot.component.species_search.t_camelot$component$species_search20917(self__.data,self__.owner,meta20918__$1));
});

camelot.component.species_search.t_camelot$component$species_search20917.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20919){
var self__ = this;
var _20919__$1 = this;
return self__.meta20918;
});

camelot.component.species_search.t_camelot$component$species_search20917.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.species_search.t_camelot$component$species_search20917.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$search,""], null);
});

camelot.component.species_search.t_camelot$component$species_search20917.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.species_search.t_camelot$component$species_search20917.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__20920 = ({"onSubmit": ((function (___$1){
return (function (p1__20915_SHARP_){
p1__20915_SHARP_.preventDefault();

if(cljs.core.truth_(cljs.core.cst$kw$busy.cljs$core$IFn$_invoke$arity$1(self__.data))){
return null;
} else {
return camelot.component.species_search.lookup_species(cljs.core.cst$kw$result_DASH_chan.cljs$core$IFn$_invoke$arity$1(state),p1__20915_SHARP_);
}
});})(___$1))
, "className": "field-input-form"});
var G__20921 = om.util.force_children((function (){var G__20923 = ({"type": "text", "name": "search", "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$species_DASH_search_SLASH_scientific_DASH_name), "className": "field-input inline long-input", "onChange": ((function (G__20920,___$1){
return (function (p1__20916_SHARP_){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$search,p1__20916_SHARP_.target.value);
});})(G__20920,___$1))
, "value": cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(state)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__20923) : om.dom.input.call(null,G__20923));
})());
var G__20922 = om.util.force_children((function (){var G__20924 = ({"type": "submit", "name": "submit", "disabled": ((((cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(state) == null)) || ((cljs.core.count(cljs.core.cst$kw$search.cljs$core$IFn$_invoke$arity$1(state).trim()) < (5))))?"disabled":""), "className": "btn btn-default input-field-submit", "value": camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_search)});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__20924) : om.dom.input.call(null,G__20924));
})());
return React.DOM.form(G__20920,G__20921,G__20922);
});

camelot.component.species_search.t_camelot$component$species_search20917.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20918], null);
});

camelot.component.species_search.t_camelot$component$species_search20917.cljs$lang$type = true;

camelot.component.species_search.t_camelot$component$species_search20917.cljs$lang$ctorStr = "camelot.component.species-search/t_camelot$component$species_search20917";

camelot.component.species_search.t_camelot$component$species_search20917.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.species-search/t_camelot$component$species_search20917");
});

camelot.component.species_search.__GT_t_camelot$component$species_search20917 = (function camelot$component$species_search$search_input_component_$___GT_t_camelot$component$species_search20917(data__$1,owner__$1,meta20918){
return (new camelot.component.species_search.t_camelot$component$species_search20917(data__$1,owner__$1,meta20918));
});

}

return (new camelot.component.species_search.t_camelot$component$species_search20917(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.species_search.truncate = (function camelot$component$species_search$truncate(s,nc){
if((cljs.core.count(s) > nc)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),nc)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("...")].join('');
} else {
return s;
}
});
camelot.component.species_search.search_result_component = (function camelot$component$species_search$search_result_component(data,owner){
if(typeof camelot.component.species_search.t_camelot$component$species_search20926 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.species_search.t_camelot$component$species_search20926 = (function (data,owner,meta20927){
this.data = data;
this.owner = owner;
this.meta20927 = meta20927;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.species_search.t_camelot$component$species_search20926.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20928,meta20927__$1){
var self__ = this;
var _20928__$1 = this;
return (new camelot.component.species_search.t_camelot$component$species_search20926(self__.data,self__.owner,meta20927__$1));
});

camelot.component.species_search.t_camelot$component$species_search20926.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20928){
var self__ = this;
var _20928__$1 = this;
return self__.meta20927;
});

camelot.component.species_search.t_camelot$component$species_search20926.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.species_search.t_camelot$component$species_search20926.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__20929 = ({"onClick": ((function (___$1){
return (function (){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,___$1){
return (function (state_20940){
var state_val_20941 = (state_20940[(1)]);
if((state_val_20941 === (1))){
var inst_20933 = cljs.core.cst$kw$select_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_20934 = [cljs.core.cst$kw$type,cljs.core.cst$kw$data];
var inst_20935 = [cljs.core.cst$kw$selection,self__.data];
var inst_20936 = cljs.core.PersistentHashMap.fromArrays(inst_20934,inst_20935);
var state_20940__$1 = state_20940;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20940__$1,(2),inst_20933,inst_20936);
} else {
if((state_val_20941 === (2))){
var inst_20938 = (state_20940[(2)]);
var state_20940__$1 = state_20940;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20940__$1,inst_20938);
} else {
return null;
}
}
});})(c__14822__auto__,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,___$1){
return (function() {
var camelot$component$species_search$search_result_component_$_state_machine__14723__auto__ = null;
var camelot$component$species_search$search_result_component_$_state_machine__14723__auto____0 = (function (){
var statearr_20942 = [null,null,null,null,null,null,null];
(statearr_20942[(0)] = camelot$component$species_search$search_result_component_$_state_machine__14723__auto__);

(statearr_20942[(1)] = (1));

return statearr_20942;
});
var camelot$component$species_search$search_result_component_$_state_machine__14723__auto____1 = (function (state_20940){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20940);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20943){if((e20943 instanceof Object)){
var ex__14726__auto__ = e20943;
var statearr_20944_20973 = state_20940;
(statearr_20944_20973[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20940);

return cljs.core.cst$kw$recur;
} else {
throw e20943;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20974 = state_20940;
state_20940 = G__20974;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$species_search$search_result_component_$_state_machine__14723__auto__ = function(state_20940){
switch(arguments.length){
case 0:
return camelot$component$species_search$search_result_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$species_search$search_result_component_$_state_machine__14723__auto____1.call(this,state_20940);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$species_search$search_result_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$species_search$search_result_component_$_state_machine__14723__auto____0;
camelot$component$species_search$search_result_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$species_search$search_result_component_$_state_machine__14723__auto____1;
return camelot$component$species_search$search_result_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,___$1))
})();
var state__14824__auto__ = (function (){var statearr_20945 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20945[(6)] = c__14822__auto__);

return statearr_20945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,___$1))
);

return c__14822__auto__;
});})(___$1))
});
var G__20930 = om.util.force_children((function (){var G__20946 = null;
var G__20947 = om.util.force_children(cljs.core.cst$kw$genus.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.td(G__20946,G__20947);
})());
var G__20931 = om.util.force_children((function (){var G__20948 = null;
var G__20949 = om.util.force_children(cljs.core.cst$kw$species.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.td(G__20948,G__20949);
})());
var G__20932 = om.util.force_children((function (){var G__20950 = ({"colSpan": "2", "className": "action-column"});
var G__20951 = om.util.force_children((function (){var G__20952 = ({"className": "button-container"});
var G__20953 = om.util.force_children((function (){var G__20955 = ({"className": "btn btn-default", "onClick": ((function (G__20952,G__20950,G__20929,G__20930,G__20931,___$1){
return (function (p1__20925_SHARP_){
p1__20925_SHARP_.preventDefault();

p1__20925_SHARP_.stopPropagation();

var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,G__20952,G__20950,G__20929,G__20930,G__20931,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,G__20952,G__20950,G__20929,G__20930,G__20931,___$1){
return (function (state_20965){
var state_val_20966 = (state_20965[(1)]);
if((state_val_20966 === (1))){
var inst_20957 = cljs.core.cst$kw$select_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_20958 = [cljs.core.cst$kw$type,cljs.core.cst$kw$data];
var inst_20959 = cljs.core.cst$kw$citation.cljs$core$IFn$_invoke$arity$1(self__.data);
var inst_20960 = [cljs.core.cst$kw$citation,inst_20959];
var inst_20961 = cljs.core.PersistentHashMap.fromArrays(inst_20958,inst_20960);
var state_20965__$1 = state_20965;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20965__$1,(2),inst_20957,inst_20961);
} else {
if((state_val_20966 === (2))){
var inst_20963 = (state_20965[(2)]);
var state_20965__$1 = state_20965;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20965__$1,inst_20963);
} else {
return null;
}
}
});})(c__14822__auto__,G__20952,G__20950,G__20929,G__20930,G__20931,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,G__20952,G__20950,G__20929,G__20930,G__20931,___$1){
return (function() {
var camelot$component$species_search$search_result_component_$_state_machine__14723__auto__ = null;
var camelot$component$species_search$search_result_component_$_state_machine__14723__auto____0 = (function (){
var statearr_20967 = [null,null,null,null,null,null,null];
(statearr_20967[(0)] = camelot$component$species_search$search_result_component_$_state_machine__14723__auto__);

(statearr_20967[(1)] = (1));

return statearr_20967;
});
var camelot$component$species_search$search_result_component_$_state_machine__14723__auto____1 = (function (state_20965){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20965);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20968){if((e20968 instanceof Object)){
var ex__14726__auto__ = e20968;
var statearr_20969_20975 = state_20965;
(statearr_20969_20975[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20965);

return cljs.core.cst$kw$recur;
} else {
throw e20968;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20976 = state_20965;
state_20965 = G__20976;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$species_search$search_result_component_$_state_machine__14723__auto__ = function(state_20965){
switch(arguments.length){
case 0:
return camelot$component$species_search$search_result_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$species_search$search_result_component_$_state_machine__14723__auto____1.call(this,state_20965);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$species_search$search_result_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$species_search$search_result_component_$_state_machine__14723__auto____0;
camelot$component$species_search$search_result_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$species_search$search_result_component_$_state_machine__14723__auto____1;
return camelot$component$species_search$search_result_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,G__20952,G__20950,G__20929,G__20930,G__20931,___$1))
})();
var state__14824__auto__ = (function (){var statearr_20970 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20970[(6)] = c__14822__auto__);

return statearr_20970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,G__20952,G__20950,G__20929,G__20930,G__20931,___$1))
);

return c__14822__auto__;
});})(G__20952,G__20950,G__20929,G__20930,G__20931,___$1))
});
var G__20956 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_citation));
return React.DOM.button(G__20955,G__20956);
})());
var G__20954 = om.util.force_children((function (){var G__20971 = ({"className": "btn btn-primary"});
var G__20972 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_add));
return React.DOM.button(G__20971,G__20972);
})());
return React.DOM.p(G__20952,G__20953,G__20954);
})());
return React.DOM.td(G__20950,G__20951);
})());
return React.DOM.tr(G__20929,G__20930,G__20931,G__20932);
});

camelot.component.species_search.t_camelot$component$species_search20926.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20927], null);
});

camelot.component.species_search.t_camelot$component$species_search20926.cljs$lang$type = true;

camelot.component.species_search.t_camelot$component$species_search20926.cljs$lang$ctorStr = "camelot.component.species-search/t_camelot$component$species_search20926";

camelot.component.species_search.t_camelot$component$species_search20926.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.species-search/t_camelot$component$species_search20926");
});

camelot.component.species_search.__GT_t_camelot$component$species_search20926 = (function camelot$component$species_search$search_result_component_$___GT_t_camelot$component$species_search20926(data__$1,owner__$1,meta20927){
return (new camelot.component.species_search.t_camelot$component$species_search20926(data__$1,owner__$1,meta20927));
});

}

return (new camelot.component.species_search.t_camelot$component$species_search20926(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.species_search.search_result_list_component = (function camelot$component$species_search$search_result_list_component(data,owner){
if(typeof camelot.component.species_search.t_camelot$component$species_search20977 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.species_search.t_camelot$component$species_search20977 = (function (data,owner,meta20978){
this.data = data;
this.owner = owner;
this.meta20978 = meta20978;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.species_search.t_camelot$component$species_search20977.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20979,meta20978__$1){
var self__ = this;
var _20979__$1 = this;
return (new camelot.component.species_search.t_camelot$component$species_search20977(self__.data,self__.owner,meta20978__$1));
});

camelot.component.species_search.t_camelot$component$species_search20977.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20979){
var self__ = this;
var _20979__$1 = this;
return self__.meta20978;
});

camelot.component.species_search.t_camelot$component$species_search20977.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.species_search.t_camelot$component$species_search20977.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$busy.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__20980 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__20980);
} else {
if(cljs.core.seq(cljs.core.cst$kw$search_DASH_results.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__20981 = ({"className": "scroll"});
var G__20982 = om.util.force_children((function (){var G__20983 = ({"className": "species-search-table"});
var G__20984 = om.util.force_children((function (){var G__20986 = null;
var G__20987 = om.util.force_children((function (){var G__20988 = ({"className": "table-heading"});
var G__20989 = om.util.force_children((function (){var G__20992 = null;
var G__20993 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$taxonomy_SLASH_taxonomy_DASH_genus$label));
return React.DOM.th(G__20992,G__20993);
})());
var G__20990 = om.util.force_children((function (){var G__20994 = null;
var G__20995 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$taxonomy_SLASH_taxonomy_DASH_species$label));
return React.DOM.th(G__20994,G__20995);
})());
var G__20991 = om.util.force_children((function (){var G__20996 = null;
var G__20997 = om.util.force_children("");
return React.DOM.th(G__20996,G__20997);
})());
return React.DOM.tr(G__20988,G__20989,G__20990,G__20991);
})());
return React.DOM.thead(G__20986,G__20987);
})());
var G__20985 = om.util.force_children((function (){var G__20998 = ({"className": "selectable"});
var G__20999 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.species_search.search_result_component,cljs.core.cst$kw$search_DASH_results.cljs$core$IFn$_invoke$arity$1(self__.data),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,state], null)));
return React.DOM.tbody(G__20998,G__20999);
})());
return React.DOM.table(G__20983,G__20984,G__20985);
})());
return React.DOM.div(G__20981,G__20982);
} else {
return React.DOM.span(null);
}
}
});

camelot.component.species_search.t_camelot$component$species_search20977.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20978], null);
});

camelot.component.species_search.t_camelot$component$species_search20977.cljs$lang$type = true;

camelot.component.species_search.t_camelot$component$species_search20977.cljs$lang$ctorStr = "camelot.component.species-search/t_camelot$component$species_search20977";

camelot.component.species_search.t_camelot$component$species_search20977.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.species-search/t_camelot$component$species_search20977");
});

camelot.component.species_search.__GT_t_camelot$component$species_search20977 = (function camelot$component$species_search$search_result_list_component_$___GT_t_camelot$component$species_search20977(data__$1,owner__$1,meta20978){
return (new camelot.component.species_search.t_camelot$component$species_search20977(data__$1,owner__$1,meta20978));
});

}

return (new camelot.component.species_search.t_camelot$component$species_search20977(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.species_search.citation_modal = (function camelot$component$species_search$citation_modal(data,owner){
if(typeof camelot.component.species_search.t_camelot$component$species_search21000 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.species_search.t_camelot$component$species_search21000 = (function (data,owner,meta21001){
this.data = data;
this.owner = owner;
this.meta21001 = meta21001;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.species_search.t_camelot$component$species_search21000.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21002,meta21001__$1){
var self__ = this;
var _21002__$1 = this;
return (new camelot.component.species_search.t_camelot$component$species_search21000(self__.data,self__.owner,meta21001__$1));
});

camelot.component.species_search.t_camelot$component$species_search21000.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21002){
var self__ = this;
var _21002__$1 = this;
return self__.meta21001;
});

camelot.component.species_search.t_camelot$component$species_search21000.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.species_search.t_camelot$component$species_search21000.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$citation.cljs$core$IFn$_invoke$arity$1(self__.data))){
var G__21003 = ({"className": "citation-modal"});
var G__21004 = om.util.force_children((function (){var G__21007 = null;
var G__21008 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_citation));
return React.DOM.h3(G__21007,G__21008);
})());
var G__21005 = om.util.force_children((function (){var G__21009 = ({"className": "citation-font"});
var G__21010 = om.util.force_children(cljs.core.cst$kw$citation.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.p(G__21009,G__21010);
})());
var G__21006 = om.util.force_children((function (){var G__21011 = ({"onClick": ((function (G__21003,G__21004,G__21005,___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$citation,null);
});})(G__21003,G__21004,G__21005,___$1))
, "className": "btn btn-primary hide-citation"});
var G__21012 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_hide));
return React.DOM.button(G__21011,G__21012);
})());
return React.DOM.div(G__21003,G__21004,G__21005,G__21006);
} else {
return null;
}
});

camelot.component.species_search.t_camelot$component$species_search21000.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta21001], null);
});

camelot.component.species_search.t_camelot$component$species_search21000.cljs$lang$type = true;

camelot.component.species_search.t_camelot$component$species_search21000.cljs$lang$ctorStr = "camelot.component.species-search/t_camelot$component$species_search21000";

camelot.component.species_search.t_camelot$component$species_search21000.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.species-search/t_camelot$component$species_search21000");
});

camelot.component.species_search.__GT_t_camelot$component$species_search21000 = (function camelot$component$species_search$citation_modal_$___GT_t_camelot$component$species_search21000(data__$1,owner__$1,meta21001){
return (new camelot.component.species_search.t_camelot$component$species_search21000(data__$1,owner__$1,meta21001));
});

}

return (new camelot.component.species_search.t_camelot$component$species_search21000(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.species_search.species_search_component = (function camelot$component$species_search$species_search_component(data,owner,p__21013){
var map__21014 = p__21013;
var map__21014__$1 = ((((!((map__21014 == null)))?((((map__21014.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21014.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21014):map__21014);
var extch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21014__$1,cljs.core.cst$kw$extch);
if(typeof camelot.component.species_search.t_camelot$component$species_search21016 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.species_search.t_camelot$component$species_search21016 = (function (data,owner,p__21013,map__21014,extch,meta21017){
this.data = data;
this.owner = owner;
this.p__21013 = p__21013;
this.map__21014 = map__21014;
this.extch = extch;
this.meta21017 = meta21017;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.species_search.t_camelot$component$species_search21016.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__21014,map__21014__$1,extch){
return (function (_21018,meta21017__$1){
var self__ = this;
var _21018__$1 = this;
return (new camelot.component.species_search.t_camelot$component$species_search21016(self__.data,self__.owner,self__.p__21013,self__.map__21014,self__.extch,meta21017__$1));
});})(map__21014,map__21014__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search21016.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__21014,map__21014__$1,extch){
return (function (_21018){
var self__ = this;
var _21018__$1 = this;
return self__.meta21017;
});})(map__21014,map__21014__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search21016.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.species_search.t_camelot$component$species_search21016.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__21014,map__21014__$1,extch){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$results,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),cljs.core.cst$kw$select_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});})(map__21014,map__21014__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search21016.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.species_search.t_camelot$component$species_search21016.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (map__21014,map__21014__$1,extch){
return (function (_){
var self__ = this;
var ___$1 = this;
var res = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$result_DASH_chan);
var sel = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$select_DASH_chan);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,res,sel,___$1,map__21014,map__21014__$1,extch){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,res,sel,___$1,map__21014,map__21014__$1,extch){
return (function (state_21077){
var state_val_21078 = (state_21077[(1)]);
if((state_val_21078 === (7))){
var inst_21072 = (state_21077[(2)]);
var state_21077__$1 = (function (){var statearr_21079 = state_21077;
(statearr_21079[(7)] = inst_21072);

return statearr_21079;
})();
var statearr_21080_21118 = state_21077__$1;
(statearr_21080_21118[(2)] = null);

(statearr_21080_21118[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (20))){
var inst_21062 = (state_21077[(2)]);
var state_21077__$1 = state_21077;
var statearr_21081_21119 = state_21077__$1;
(statearr_21081_21119[(2)] = inst_21062);

(statearr_21081_21119[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (1))){
var state_21077__$1 = state_21077;
var statearr_21082_21120 = state_21077__$1;
(statearr_21082_21120[(2)] = null);

(statearr_21082_21120[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (4))){
var inst_21027 = (state_21077[(2)]);
var inst_21028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21027,(0),null);
var inst_21029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21027,(1),null);
var inst_21030 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21029,res);
var state_21077__$1 = (function (){var statearr_21083 = state_21077;
(statearr_21083[(8)] = inst_21028);

return statearr_21083;
})();
if(inst_21030){
var statearr_21084_21121 = state_21077__$1;
(statearr_21084_21121[(1)] = (5));

} else {
var statearr_21085_21122 = state_21077__$1;
(statearr_21085_21122[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (15))){
var state_21077__$1 = state_21077;
if(cljs.core.truth_(self__.extch)){
var statearr_21086_21123 = state_21077__$1;
(statearr_21086_21123[(1)] = (17));

} else {
var statearr_21087_21124 = state_21077__$1;
(statearr_21087_21124[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (13))){
var inst_21047 = (state_21077[(2)]);
var state_21077__$1 = state_21077;
var statearr_21088_21125 = state_21077__$1;
(statearr_21088_21125[(2)] = inst_21047);

(statearr_21088_21125[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (6))){
var inst_21028 = (state_21077[(8)]);
var inst_21049 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_21028);
var inst_21050 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21049,cljs.core.cst$kw$citation);
var state_21077__$1 = state_21077;
if(inst_21050){
var statearr_21089_21126 = state_21077__$1;
(statearr_21089_21126[(1)] = (14));

} else {
var statearr_21090_21127 = state_21077__$1;
(statearr_21090_21127[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (17))){
var inst_21028 = (state_21077[(8)]);
var inst_21057 = [cljs.core.cst$kw$type,cljs.core.cst$kw$taxonomy];
var inst_21058 = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(inst_21028);
var inst_21059 = [cljs.core.cst$kw$search,inst_21058];
var inst_21060 = cljs.core.PersistentHashMap.fromArrays(inst_21057,inst_21059);
var state_21077__$1 = state_21077;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_21077__$1,(20),self__.extch,inst_21060);
} else {
if((state_val_21078 === (3))){
var inst_21075 = (state_21077[(2)]);
var state_21077__$1 = state_21077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21077__$1,inst_21075);
} else {
if((state_val_21078 === (12))){
var state_21077__$1 = state_21077;
var statearr_21091_21128 = state_21077__$1;
(statearr_21091_21128[(2)] = null);

(statearr_21091_21128[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (2))){
var inst_21023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21024 = [res,sel];
var inst_21025 = (new cljs.core.PersistentVector(null,2,(5),inst_21023,inst_21024,null));
var state_21077__$1 = state_21077;
return cljs.core.async.ioc_alts_BANG_(state_21077__$1,(4),inst_21025);
} else {
if((state_val_21078 === (19))){
var inst_21067 = (state_21077[(2)]);
var inst_21068 = camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("species-search","add-species");
var state_21077__$1 = (function (){var statearr_21092 = state_21077;
(statearr_21092[(9)] = inst_21067);

return statearr_21092;
})();
var statearr_21093_21129 = state_21077__$1;
(statearr_21093_21129[(2)] = inst_21068);

(statearr_21093_21129[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (11))){
var inst_21028 = (state_21077[(8)]);
var inst_21042 = cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(inst_21028);
var inst_21043 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$search_DASH_results,inst_21042);
var inst_21044 = camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("species-search","search");
var state_21077__$1 = (function (){var statearr_21094 = state_21077;
(statearr_21094[(10)] = inst_21043);

return statearr_21094;
})();
var statearr_21095_21130 = state_21077__$1;
(statearr_21095_21130[(2)] = inst_21044);

(statearr_21095_21130[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (9))){
var inst_21028 = (state_21077[(8)]);
var inst_21036 = cljs.core.cst$kw$busy.cljs$core$IFn$_invoke$arity$1(inst_21028);
var inst_21037 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$busy,inst_21036);
var state_21077__$1 = state_21077;
var statearr_21096_21131 = state_21077__$1;
(statearr_21096_21131[(2)] = inst_21037);

(statearr_21096_21131[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (5))){
var inst_21028 = (state_21077[(8)]);
var inst_21032 = cljs.core.cst$kw$busy.cljs$core$IFn$_invoke$arity$1(inst_21028);
var inst_21033 = (inst_21032 == null);
var state_21077__$1 = state_21077;
if(cljs.core.truth_(inst_21033)){
var statearr_21097_21132 = state_21077__$1;
(statearr_21097_21132[(1)] = (8));

} else {
var statearr_21098_21133 = state_21077__$1;
(statearr_21098_21133[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (14))){
var inst_21028 = (state_21077[(8)]);
var inst_21052 = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(inst_21028);
var inst_21053 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$citation,inst_21052);
var inst_21054 = camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("species-search","view-citation");
var state_21077__$1 = (function (){var statearr_21099 = state_21077;
(statearr_21099[(11)] = inst_21053);

return statearr_21099;
})();
var statearr_21100_21134 = state_21077__$1;
(statearr_21100_21134[(2)] = inst_21054);

(statearr_21100_21134[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (16))){
var inst_21070 = (state_21077[(2)]);
var state_21077__$1 = state_21077;
var statearr_21101_21135 = state_21077__$1;
(statearr_21101_21135[(2)] = inst_21070);

(statearr_21101_21135[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (10))){
var inst_21028 = (state_21077[(8)]);
var inst_21039 = (state_21077[(2)]);
var inst_21040 = cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(inst_21028);
var state_21077__$1 = (function (){var statearr_21102 = state_21077;
(statearr_21102[(12)] = inst_21039);

return statearr_21102;
})();
if(cljs.core.truth_(inst_21040)){
var statearr_21103_21136 = state_21077__$1;
(statearr_21103_21136[(1)] = (11));

} else {
var statearr_21104_21137 = state_21077__$1;
(statearr_21104_21137[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (18))){
var inst_21028 = (state_21077[(8)]);
var inst_21064 = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(inst_21028);
var inst_21065 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$selection,inst_21064);
var state_21077__$1 = state_21077;
var statearr_21105_21138 = state_21077__$1;
(statearr_21105_21138[(2)] = inst_21065);

(statearr_21105_21138[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21078 === (8))){
var state_21077__$1 = state_21077;
var statearr_21106_21139 = state_21077__$1;
(statearr_21106_21139[(2)] = null);

(statearr_21106_21139[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__,res,sel,___$1,map__21014,map__21014__$1,extch))
;
return ((function (switch__14722__auto__,c__14822__auto__,res,sel,___$1,map__21014,map__21014__$1,extch){
return (function() {
var camelot$component$species_search$species_search_component_$_state_machine__14723__auto__ = null;
var camelot$component$species_search$species_search_component_$_state_machine__14723__auto____0 = (function (){
var statearr_21107 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21107[(0)] = camelot$component$species_search$species_search_component_$_state_machine__14723__auto__);

(statearr_21107[(1)] = (1));

return statearr_21107;
});
var camelot$component$species_search$species_search_component_$_state_machine__14723__auto____1 = (function (state_21077){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_21077);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e21108){if((e21108 instanceof Object)){
var ex__14726__auto__ = e21108;
var statearr_21109_21140 = state_21077;
(statearr_21109_21140[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_21077);

return cljs.core.cst$kw$recur;
} else {
throw e21108;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__21141 = state_21077;
state_21077 = G__21141;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$species_search$species_search_component_$_state_machine__14723__auto__ = function(state_21077){
switch(arguments.length){
case 0:
return camelot$component$species_search$species_search_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$species_search$species_search_component_$_state_machine__14723__auto____1.call(this,state_21077);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$species_search$species_search_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$species_search$species_search_component_$_state_machine__14723__auto____0;
camelot$component$species_search$species_search_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$species_search$species_search_component_$_state_machine__14723__auto____1;
return camelot$component$species_search$species_search_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,res,sel,___$1,map__21014,map__21014__$1,extch))
})();
var state__14824__auto__ = (function (){var statearr_21110 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_21110[(6)] = c__14822__auto__);

return statearr_21110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,res,sel,___$1,map__21014,map__21014__$1,extch))
);

return c__14822__auto__;
});})(map__21014,map__21014__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search21016.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.species_search.t_camelot$component$species_search21016.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__21014,map__21014__$1,extch){
return (function (this$,state){
var self__ = this;
var this$__$1 = this;
var G__21111 = ({"className": "species-search"});
var G__21112 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.species_search.citation_modal,self__.data));
var G__21113 = om.util.force_children((function (){var G__21116 = ({"className": "field-label"});
var G__21117 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$species_DASH_search_SLASH_search_DASH_species));
return React.DOM.label(G__21116,G__21117);
})());
var G__21114 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.species_search.search_input_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$result_DASH_chan,cljs.core.cst$kw$result_DASH_chan.cljs$core$IFn$_invoke$arity$1(state)], null)], null)));
var G__21115 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.species_search.search_result_list_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$select_DASH_chan,cljs.core.cst$kw$select_DASH_chan.cljs$core$IFn$_invoke$arity$1(state)], null)], null)));
return React.DOM.div(G__21111,G__21112,G__21113,G__21114,G__21115);
});})(map__21014,map__21014__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search21016.getBasis = ((function (map__21014,map__21014__$1,extch){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__21013,cljs.core.cst$sym$map__21014,cljs.core.cst$sym$extch,cljs.core.cst$sym$meta21017], null);
});})(map__21014,map__21014__$1,extch))
;

camelot.component.species_search.t_camelot$component$species_search21016.cljs$lang$type = true;

camelot.component.species_search.t_camelot$component$species_search21016.cljs$lang$ctorStr = "camelot.component.species-search/t_camelot$component$species_search21016";

camelot.component.species_search.t_camelot$component$species_search21016.cljs$lang$ctorPrWriter = ((function (map__21014,map__21014__$1,extch){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.species-search/t_camelot$component$species_search21016");
});})(map__21014,map__21014__$1,extch))
;

camelot.component.species_search.__GT_t_camelot$component$species_search21016 = ((function (map__21014,map__21014__$1,extch){
return (function camelot$component$species_search$species_search_component_$___GT_t_camelot$component$species_search21016(data__$1,owner__$1,p__21013__$1,map__21014__$2,extch__$1,meta21017){
return (new camelot.component.species_search.t_camelot$component$species_search21016(data__$1,owner__$1,p__21013__$1,map__21014__$2,extch__$1,meta21017));
});})(map__21014,map__21014__$1,extch))
;

}

return (new camelot.component.species_search.t_camelot$component$species_search21016(data,owner,p__21013,map__21014__$1,extch,cljs.core.PersistentArrayMap.EMPTY));
});
