// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.survey.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.core');
goog.require('camelot.nav');
goog.require('camelot.util.feature');
goog.require('camelot.state');
goog.require('camelot.component.survey.create');
goog.require('camelot.component.survey.manage');
goog.require('camelot.component.survey.settings');
goog.require('camelot.component.survey.sighting_fields');
goog.require('om.dom');
goog.require('camelot.translation.core');
goog.require('camelot.rest');
goog.require('cljs.core.async');
camelot.component.survey.core.bulk_import_mode_QMARK_ = (function camelot$component$survey$core$bulk_import_mode_QMARK_(){
var and__6612__auto__ = camelot.util.feature.enabled_QMARK_(camelot.state.settings(),cljs.core.cst$kw$bulk_DASH_import);
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_bulk_DASH_import_DASH_mode,cljs.core.cst$kw$value], null));
} else {
return and__6612__auto__;
}
});
camelot.component.survey.core.survey_menu = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$action,cljs.core.cst$kw$deployment,cljs.core.cst$kw$name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$core_SLASH_manage_DASH_traps),cljs.core.cst$kw$condition,cljs.core.complement(camelot.component.survey.core.bulk_import_mode_QMARK_)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$action,cljs.core.cst$kw$upload,cljs.core.cst$kw$name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$core_SLASH_upload_DASH_captures),cljs.core.cst$kw$condition,cljs.core.complement(camelot.component.survey.core.bulk_import_mode_QMARK_)], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$action,cljs.core.cst$kw$import,cljs.core.cst$kw$name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$core_SLASH_import),cljs.core.cst$kw$condition,camelot.component.survey.core.bulk_import_mode_QMARK_], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$action,cljs.core.cst$kw$species,cljs.core.cst$kw$name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$core_SLASH_species)], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$action,cljs.core.cst$kw$files,cljs.core.cst$kw$name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$core_SLASH_files)], null),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$action,cljs.core.cst$kw$settings,cljs.core.cst$kw$name,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$core_SLASH_settings)], null)], null);
/**
 * Delete the survey and trigger a removal event.
 */
camelot.component.survey.core.delete$ = (function camelot$component$survey$core$delete(state,data,event){
event.preventDefault();

event.stopPropagation();

if(cljs.core.truth_((function (){var G__23963 = camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$core_SLASH_confirm_DASH_delete);
return confirm(G__23963);
})())){
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/surveys/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(data))].join(''),(function (){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_23971){
var state_val_23972 = (state_23971[(1)]);
if((state_val_23972 === (1))){
var inst_23964 = cljs.core.cst$kw$chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_23965 = [cljs.core.cst$kw$event,cljs.core.cst$kw$data];
var inst_23966 = [cljs.core.cst$kw$delete,data];
var inst_23967 = cljs.core.PersistentHashMap.fromArrays(inst_23965,inst_23966);
var state_23971__$1 = state_23971;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23971__$1,(2),inst_23964,inst_23967);
} else {
if((state_val_23972 === (2))){
var inst_23969 = (state_23971[(2)]);
var state_23971__$1 = state_23971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23971__$1,inst_23969);
} else {
return null;
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$component$survey$core$delete_$_state_machine__14723__auto__ = null;
var camelot$component$survey$core$delete_$_state_machine__14723__auto____0 = (function (){
var statearr_23973 = [null,null,null,null,null,null,null];
(statearr_23973[(0)] = camelot$component$survey$core$delete_$_state_machine__14723__auto__);

(statearr_23973[(1)] = (1));

return statearr_23973;
});
var camelot$component$survey$core$delete_$_state_machine__14723__auto____1 = (function (state_23971){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_23971);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e23974){if((e23974 instanceof Object)){
var ex__14726__auto__ = e23974;
var statearr_23975_23977 = state_23971;
(statearr_23975_23977[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_23971);

return cljs.core.cst$kw$recur;
} else {
throw e23974;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__23978 = state_23971;
state_23971 = G__23978;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$survey$core$delete_$_state_machine__14723__auto__ = function(state_23971){
switch(arguments.length){
case 0:
return camelot$component$survey$core$delete_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$survey$core$delete_$_state_machine__14723__auto____1.call(this,state_23971);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$survey$core$delete_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$survey$core$delete_$_state_machine__14723__auto____0;
camelot$component$survey$core$delete_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$survey$core$delete_$_state_machine__14723__auto____1;
return camelot$component$survey$core$delete_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_23976 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_23976[(6)] = c__14822__auto__);

return statearr_23976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
}));
} else {
return null;
}
});
camelot.component.survey.core.survey_list_component = (function camelot$component$survey$core$survey_list_component(data,owner){
if(typeof camelot.component.survey.core.t_camelot$component$survey$core23979 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.core.t_camelot$component$survey$core23979 = (function (data,owner,meta23980){
this.data = data;
this.owner = owner;
this.meta23980 = meta23980;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.core.t_camelot$component$survey$core23979.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23981,meta23980__$1){
var self__ = this;
var _23981__$1 = this;
return (new camelot.component.survey.core.t_camelot$component$survey$core23979(self__.data,self__.owner,meta23980__$1));
});

camelot.component.survey.core.t_camelot$component$survey$core23979.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23981){
var self__ = this;
var _23981__$1 = this;
return self__.meta23980;
});

camelot.component.survey.core.t_camelot$component$survey$core23979.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.core.t_camelot$component$survey$core23979.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__23982 = ({"className": "menu-item detailed dynamic", "onClick": ((function (___$1){
return (function (){
camelot.nav.nav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data))].join(''));

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-survey","survey-click");
});})(___$1))
});
var G__23983 = om.util.force_children((function (){var G__23986 = ({"className": "pull-right fa fa-times remove top-corner", "onClick": cljs.core.partial.cljs$core$IFn$_invoke$arity$3(camelot.component.survey.core.delete$,state,self__.data)});
return React.DOM.div(G__23986);
})());
var G__23984 = om.util.force_children((function (){var G__23987 = ({"className": "menu-item-title"});
var G__23988 = om.util.force_children(cljs.core.cst$kw$survey_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__23987,G__23988);
})());
var G__23985 = om.util.force_children((function (){var G__23989 = ({"className": "menu-item-description"});
var G__23990 = om.util.force_children(cljs.core.cst$kw$survey_DASH_notes.cljs$core$IFn$_invoke$arity$1(self__.data));
return React.DOM.span(G__23989,G__23990);
})());
return React.DOM.div(G__23982,G__23983,G__23984,G__23985);
});

camelot.component.survey.core.t_camelot$component$survey$core23979.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23980], null);
});

camelot.component.survey.core.t_camelot$component$survey$core23979.cljs$lang$type = true;

camelot.component.survey.core.t_camelot$component$survey$core23979.cljs$lang$ctorStr = "camelot.component.survey.core/t_camelot$component$survey$core23979";

camelot.component.survey.core.t_camelot$component$survey$core23979.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.core/t_camelot$component$survey$core23979");
});

camelot.component.survey.core.__GT_t_camelot$component$survey$core23979 = (function camelot$component$survey$core$survey_list_component_$___GT_t_camelot$component$survey$core23979(data__$1,owner__$1,meta23980){
return (new camelot.component.survey.core.t_camelot$component$survey$core23979(data__$1,owner__$1,meta23980));
});

}

return (new camelot.component.survey.core.t_camelot$component$survey$core23979(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.survey.core.edit_details_view = (function camelot$component$survey$core$edit_details_view(app,owner){
if(typeof camelot.component.survey.core.t_camelot$component$survey$core23991 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.core.t_camelot$component$survey$core23991 = (function (app,owner,meta23992){
this.app = app;
this.owner = owner;
this.meta23992 = meta23992;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.core.t_camelot$component$survey$core23991.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23993,meta23992__$1){
var self__ = this;
var _23993__$1 = this;
return (new camelot.component.survey.core.t_camelot$component$survey$core23991(self__.app,self__.owner,meta23992__$1));
});

camelot.component.survey.core.t_camelot$component$survey$core23991.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23993){
var self__ = this;
var _23993__$1 = this;
return self__.meta23992;
});

camelot.component.survey.core.t_camelot$component$survey$core23991.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.core.t_camelot$component$survey$core23991.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.survey.settings.edit_details_component,self__.app);
});

camelot.component.survey.core.t_camelot$component$survey$core23991.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23992], null);
});

camelot.component.survey.core.t_camelot$component$survey$core23991.cljs$lang$type = true;

camelot.component.survey.core.t_camelot$component$survey$core23991.cljs$lang$ctorStr = "camelot.component.survey.core/t_camelot$component$survey$core23991";

camelot.component.survey.core.t_camelot$component$survey$core23991.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.core/t_camelot$component$survey$core23991");
});

camelot.component.survey.core.__GT_t_camelot$component$survey$core23991 = (function camelot$component$survey$core$edit_details_view_$___GT_t_camelot$component$survey$core23991(app__$1,owner__$1,meta23992){
return (new camelot.component.survey.core.t_camelot$component$survey$core23991(app__$1,owner__$1,meta23992));
});

}

return (new camelot.component.survey.core.t_camelot$component$survey$core23991(app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.survey.core.sighting_fields_view = (function camelot$component$survey$core$sighting_fields_view(app,owner){
if(typeof camelot.component.survey.core.t_camelot$component$survey$core23994 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.core.t_camelot$component$survey$core23994 = (function (app,owner,meta23995){
this.app = app;
this.owner = owner;
this.meta23995 = meta23995;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.core.t_camelot$component$survey$core23994.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23996,meta23995__$1){
var self__ = this;
var _23996__$1 = this;
return (new camelot.component.survey.core.t_camelot$component$survey$core23994(self__.app,self__.owner,meta23995__$1));
});

camelot.component.survey.core.t_camelot$component$survey$core23994.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23996){
var self__ = this;
var _23996__$1 = this;
return self__.meta23995;
});

camelot.component.survey.core.t_camelot$component$survey$core23994.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.core.t_camelot$component$survey$core23994.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.survey.sighting_fields.manage_fields_component,self__.app);
});

camelot.component.survey.core.t_camelot$component$survey$core23994.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23995], null);
});

camelot.component.survey.core.t_camelot$component$survey$core23994.cljs$lang$type = true;

camelot.component.survey.core.t_camelot$component$survey$core23994.cljs$lang$ctorStr = "camelot.component.survey.core/t_camelot$component$survey$core23994";

camelot.component.survey.core.t_camelot$component$survey$core23994.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.core/t_camelot$component$survey$core23994");
});

camelot.component.survey.core.__GT_t_camelot$component$survey$core23994 = (function camelot$component$survey$core$sighting_fields_view_$___GT_t_camelot$component$survey$core23994(app__$1,owner__$1,meta23995){
return (new camelot.component.survey.core.t_camelot$component$survey$core23994(app__$1,owner__$1,meta23995));
});

}

return (new camelot.component.survey.core.t_camelot$component$survey$core23994(app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.survey.core.create_view_component = (function camelot$component$survey$core$create_view_component(app,owner){
if(typeof camelot.component.survey.core.t_camelot$component$survey$core23997 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.core.t_camelot$component$survey$core23997 = (function (app,owner,meta23998){
this.app = app;
this.owner = owner;
this.meta23998 = meta23998;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.core.t_camelot$component$survey$core23997.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23999,meta23998__$1){
var self__ = this;
var _23999__$1 = this;
return (new camelot.component.survey.core.t_camelot$component$survey$core23997(self__.app,self__.owner,meta23998__$1));
});

camelot.component.survey.core.t_camelot$component$survey$core23997.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23999){
var self__ = this;
var _23999__$1 = this;
return self__.meta23998;
});

camelot.component.survey.core.t_camelot$component$survey$core23997.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.core.t_camelot$component$survey$core23997.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.survey.create.create_survey_view_component,self__.app);
});

camelot.component.survey.core.t_camelot$component$survey$core23997.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta23998], null);
});

camelot.component.survey.core.t_camelot$component$survey$core23997.cljs$lang$type = true;

camelot.component.survey.core.t_camelot$component$survey$core23997.cljs$lang$ctorStr = "camelot.component.survey.core/t_camelot$component$survey$core23997";

camelot.component.survey.core.t_camelot$component$survey$core23997.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.core/t_camelot$component$survey$core23997");
});

camelot.component.survey.core.__GT_t_camelot$component$survey$core23997 = (function camelot$component$survey$core$create_view_component_$___GT_t_camelot$component$survey$core23997(app__$1,owner__$1,meta23998){
return (new camelot.component.survey.core.t_camelot$component$survey$core23997(app__$1,owner__$1,meta23998));
});

}

return (new camelot.component.survey.core.t_camelot$component$survey$core23997(app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.survey.core.survey_menu_component = (function camelot$component$survey$core$survey_menu_component(data,owner){
if(typeof camelot.component.survey.core.t_camelot$component$survey$core24001 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.core.t_camelot$component$survey$core24001 = (function (data,owner,meta24002){
this.data = data;
this.owner = owner;
this.meta24002 = meta24002;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.core.t_camelot$component$survey$core24001.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24003,meta24002__$1){
var self__ = this;
var _24003__$1 = this;
return (new camelot.component.survey.core.t_camelot$component$survey$core24001(self__.data,self__.owner,meta24002__$1));
});

camelot.component.survey.core.t_camelot$component$survey$core24001.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24003){
var self__ = this;
var _24003__$1 = this;
return self__.meta24002;
});

camelot.component.survey.core.t_camelot$component$survey$core24001.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.core.t_camelot$component$survey$core24001.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.survey.core.t_camelot$component$survey$core24001.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.core.t_camelot$component$survey$core24001.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var ch = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$chan);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,ch,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,ch,___$1){
return (function (state_24019){
var state_val_24020 = (state_24019[(1)]);
if((state_val_24020 === (1))){
var state_24019__$1 = state_24019;
var statearr_24021_24048 = state_24019__$1;
(statearr_24021_24048[(2)] = null);

(statearr_24021_24048[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24020 === (2))){
var state_24019__$1 = state_24019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24019__$1,(4),ch);
} else {
if((state_val_24020 === (3))){
var inst_24017 = (state_24019[(2)]);
var state_24019__$1 = state_24019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24019__$1,inst_24017);
} else {
if((state_val_24020 === (4))){
var inst_24006 = (state_24019[(7)]);
var inst_24006__$1 = (state_24019[(2)]);
var inst_24007 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(inst_24006__$1);
var inst_24008 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24007,cljs.core.cst$kw$delete);
var state_24019__$1 = (function (){var statearr_24022 = state_24019;
(statearr_24022[(7)] = inst_24006__$1);

return statearr_24022;
})();
if(inst_24008){
var statearr_24023_24049 = state_24019__$1;
(statearr_24023_24049[(1)] = (5));

} else {
var statearr_24024_24050 = state_24019__$1;
(statearr_24024_24050[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24020 === (5))){
var inst_24006 = (state_24019[(7)]);
var inst_24010 = (function (){var r = inst_24006;
return ((function (r,inst_24006,state_val_24020,c__14822__auto__,ch,___$1){
return (function (p1__24000_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (r,inst_24006,state_val_24020,c__14822__auto__,ch,___$1){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(r));
});})(r,inst_24006,state_val_24020,c__14822__auto__,ch,___$1))
,p1__24000_SHARP_);
});
;})(r,inst_24006,state_val_24020,c__14822__auto__,ch,___$1))
})();
var inst_24011 = om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$list,inst_24010);
var state_24019__$1 = state_24019;
var statearr_24025_24051 = state_24019__$1;
(statearr_24025_24051[(2)] = inst_24011);

(statearr_24025_24051[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24020 === (6))){
var state_24019__$1 = state_24019;
var statearr_24026_24052 = state_24019__$1;
(statearr_24026_24052[(2)] = null);

(statearr_24026_24052[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24020 === (7))){
var inst_24014 = (state_24019[(2)]);
var state_24019__$1 = (function (){var statearr_24027 = state_24019;
(statearr_24027[(8)] = inst_24014);

return statearr_24027;
})();
var statearr_24028_24053 = state_24019__$1;
(statearr_24028_24053[(2)] = null);

(statearr_24028_24053[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__14822__auto__,ch,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,ch,___$1){
return (function() {
var camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto__ = null;
var camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto____0 = (function (){
var statearr_24029 = [null,null,null,null,null,null,null,null,null];
(statearr_24029[(0)] = camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto__);

(statearr_24029[(1)] = (1));

return statearr_24029;
});
var camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto____1 = (function (state_24019){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_24019);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e24030){if((e24030 instanceof Object)){
var ex__14726__auto__ = e24030;
var statearr_24031_24054 = state_24019;
(statearr_24031_24054[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_24019);

return cljs.core.cst$kw$recur;
} else {
throw e24030;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__24055 = state_24019;
state_24019 = G__24055;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto__ = function(state_24019){
switch(arguments.length){
case 0:
return camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto____1.call(this,state_24019);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto____0;
camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto____1;
return camelot$component$survey$core$survey_menu_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,ch,___$1))
})();
var state__14824__auto__ = (function (){var statearr_24032 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_24032[(6)] = c__14822__auto__);

return statearr_24032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,ch,___$1))
);

return c__14822__auto__;
});

camelot.component.survey.core.t_camelot$component$survey$core24001.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.core.t_camelot$component$survey$core24001.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__24033 = ({"className": "section"});
var G__24034 = om.util.force_children((function (){var G__24038 = ({"className": "simple-menu"});
var G__24039 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.survey.core.survey_list_component,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$survey_DASH_name,cljs.core.cst$kw$list.cljs$core$IFn$_invoke$arity$1(self__.data)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$init_DASH_state,state], null)));
return React.DOM.div(G__24038,G__24039);
})());
var G__24035 = om.util.force_children((function (){var G__24040 = ({"className": "sep"});
return React.DOM.div(G__24040);
})());
var G__24036 = om.util.force_children((function (){var G__24041 = ({"className": "btn btn-primary", "onClick": ((function (G__24033,G__24034,G__24035,___$1){
return (function (){
camelot.nav.nav_BANG_("/survey/create");

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-survey","create-click");
});})(G__24033,G__24034,G__24035,___$1))
});
var G__24042 = om.util.force_children((function (){var G__24045 = ({"className": "fa fa-plus"});
return React.DOM.span(G__24045);
})());
var G__24043 = om.util.force_children(" ");
var G__24044 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$core_SLASH_create_DASH_survey));
return React.DOM.button(G__24041,G__24042,G__24043,G__24044);
})());
var G__24037 = om.util.force_children((function (){var G__24046 = ({"className": "btn btn-default", "onClick": ((function (G__24033,G__24034,G__24035,G__24036,___$1){
return (function (){
camelot.nav.nav_BANG_("/surveys");

return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("org-survey","advanced-click");
});})(G__24033,G__24034,G__24035,G__24036,___$1))
});
var G__24047 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_advanced));
return React.DOM.button(G__24046,G__24047);
})());
return React.DOM.div(G__24033,G__24034,G__24035,G__24036,G__24037);
});

camelot.component.survey.core.t_camelot$component$survey$core24001.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24002], null);
});

camelot.component.survey.core.t_camelot$component$survey$core24001.cljs$lang$type = true;

camelot.component.survey.core.t_camelot$component$survey$core24001.cljs$lang$ctorStr = "camelot.component.survey.core/t_camelot$component$survey$core24001";

camelot.component.survey.core.t_camelot$component$survey$core24001.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.core/t_camelot$component$survey$core24001");
});

camelot.component.survey.core.__GT_t_camelot$component$survey$core24001 = (function camelot$component$survey$core$survey_menu_component_$___GT_t_camelot$component$survey$core24001(data__$1,owner__$1,meta24002){
return (new camelot.component.survey.core.t_camelot$component$survey$core24001(data__$1,owner__$1,meta24002));
});

}

return (new camelot.component.survey.core.t_camelot$component$survey$core24001(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Render the view component for managing a survey.
 */
camelot.component.survey.core.survey_view_component = (function camelot$component$survey$core$survey_view_component(app,owner){
if(typeof camelot.component.survey.core.t_camelot$component$survey$core24057 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.core.t_camelot$component$survey$core24057 = (function (app,owner,meta24058){
this.app = app;
this.owner = owner;
this.meta24058 = meta24058;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.core.t_camelot$component$survey$core24057.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24059,meta24058__$1){
var self__ = this;
var _24059__$1 = this;
return (new camelot.component.survey.core.t_camelot$component$survey$core24057(self__.app,self__.owner,meta24058__$1));
});

camelot.component.survey.core.t_camelot$component$survey$core24057.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24059){
var self__ = this;
var _24059__$1 = this;
return self__.meta24058;
});

camelot.component.survey.core.t_camelot$component$survey$core24057.prototype.om$core$IDidMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.core.t_camelot$component$survey$core24057.prototype.om$core$IDidMount$did_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.cst$kw$survey_DASH_page_DASH_state.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.app)))){
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,cljs.core.cst$kw$survey_DASH_page_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$species,cljs.core.PersistentArrayMap.EMPTY], null));
}

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$survey_DASH_page_DASH_state,cljs.core.cst$kw$menu], null),cljs.core.vec(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (___$1){
return (function (p1__24056_SHARP_){
if((cljs.core.cst$kw$condition.cljs$core$IFn$_invoke$arity$1(p1__24056_SHARP_) == null)){
return true;
} else {
var fexpr__24060 = cljs.core.cst$kw$condition.cljs$core$IFn$_invoke$arity$1(p1__24056_SHARP_);
return (fexpr__24060.cljs$core$IFn$_invoke$arity$0 ? fexpr__24060.cljs$core$IFn$_invoke$arity$0() : fexpr__24060.call(null));
}
});})(___$1))
,camelot.component.survey.core.survey_menu)));

var active = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.app),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$survey_DASH_page_DASH_state,cljs.core.cst$kw$active], null));
if(cljs.core.truth_((function (){var and__6612__auto__ = active;
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.contains_QMARK_(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$action,cljs.core.cst$kw$menu.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$survey_DASH_page_DASH_state.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.app))))),active);
} else {
return and__6612__auto__;
}
})())){
return null;
} else {
return om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.app,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$survey_DASH_page_DASH_state], null),((function (active,___$1){
return (function (d){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$active,cljs.core.cst$kw$action.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$menu.cljs$core$IFn$_invoke$arity$1(d))));
});})(active,___$1))
);
}
});

camelot.component.survey.core.t_camelot$component$survey$core24057.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.core.t_camelot$component$survey$core24057.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.seq(cljs.core.cst$kw$survey_DASH_page_DASH_state.cljs$core$IFn$_invoke$arity$1(self__.app))){
return om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.survey.manage.survey_management_component,cljs.core.cst$kw$survey_DASH_page_DASH_state.cljs$core$IFn$_invoke$arity$1(self__.app));
} else {
var G__24061 = ({"className": "align-center"});
var G__24062 = om.util.force_children((function (){var G__24063 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__24063);
})());
return React.DOM.div(G__24061,G__24062);
}
});

camelot.component.survey.core.t_camelot$component$survey$core24057.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24058], null);
});

camelot.component.survey.core.t_camelot$component$survey$core24057.cljs$lang$type = true;

camelot.component.survey.core.t_camelot$component$survey$core24057.cljs$lang$ctorStr = "camelot.component.survey.core/t_camelot$component$survey$core24057";

camelot.component.survey.core.t_camelot$component$survey$core24057.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.core/t_camelot$component$survey$core24057");
});

camelot.component.survey.core.__GT_t_camelot$component$survey$core24057 = (function camelot$component$survey$core$survey_view_component_$___GT_t_camelot$component$survey$core24057(app__$1,owner__$1,meta24058){
return (new camelot.component.survey.core.t_camelot$component$survey$core24057(app__$1,owner__$1,meta24058));
});

}

return (new camelot.component.survey.core.t_camelot$component$survey$core24057(app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
