// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.component.survey.sighting_fields');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.core');
goog.require('om.dom');
goog.require('clojure.string');
goog.require('camelot.rest');
goog.require('camelot.translation.core');
goog.require('camelot.util.sighting_fields');
goog.require('camelot.component.util');
goog.require('camelot.state');
goog.require('camelot.nav');
goog.require('cljs.core.async');
goog.require('goog.date');
goog.require('camelot.validation.validated_component');
goog.require('camelot.util.cursorise');
goog.require('camelot.util.data');
/**
 * Minimal set of keys which a sighting field must possess.
 */
camelot.component.survey.sighting_fields.sighting_field_input_keys = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$sighting_DASH_field_DASH_key,null,cljs.core.cst$kw$sighting_DASH_field_DASH_label,null,cljs.core.cst$kw$sighting_DASH_field_DASH_default,null,cljs.core.cst$kw$sighting_DASH_field_DASH_datatype,null,cljs.core.cst$kw$sighting_DASH_field_DASH_ordering,null,cljs.core.cst$kw$sighting_DASH_field_DASH_required,null,cljs.core.cst$kw$sighting_DASH_field_DASH_affects_DASH_independence,null,cljs.core.cst$kw$sighting_DASH_field_DASH_options,null], null), null);
camelot.component.survey.sighting_fields.allowed_request_fields = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$survey_DASH_id], null),camelot.component.survey.sighting_fields.sighting_field_input_keys);
camelot.component.survey.sighting_fields.datatype_has_options_QMARK_ = (function camelot$component$survey$sighting_fields$datatype_has_options_QMARK_(data){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.util.sighting_fields.datatypes,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,cljs.core.cst$kw$sighting_DASH_field_DASH_datatype)),cljs.core.cst$kw$has_DASH_options], null));
});
/**
 * Set buffer based the selected sighting-field ID.
 */
camelot.component.survey.sighting_fields.update_buffer = (function camelot$component$survey$sighting_fields$update_buffer(data,sf_id){
var sf = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields,sf_id], null));
var vs = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$3(camelot.util.data.require_keys.cljs$core$IFn$_invoke$arity$2(sf,camelot.component.survey.sighting_fields.sighting_field_input_keys),cljs.core.cst$kw$sighting_DASH_field_DASH_datatype,((function (sf){
return (function (p1__20337_SHARP_){
var or__6624__auto__ = p1__20337_SHARP_;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return "text";
}
});})(sf))
),cljs.core.cst$kw$sighting_DASH_field_DASH_required,((function (sf){
return (function (p1__20338_SHARP_){
var or__6624__auto__ = p1__20338_SHARP_;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return "false";
}
});})(sf))
),cljs.core.cst$kw$sighting_DASH_field_DASH_affects_DASH_independence,((function (sf){
return (function (p1__20339_SHARP_){
var or__6624__auto__ = p1__20339_SHARP_;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return "false";
}
});})(sf))
),cljs.core.cst$kw$sighting_DASH_field_DASH_ordering,((function (sf){
return (function (p1__20340_SHARP_){
var or__6624__auto__ = p1__20340_SHARP_;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return (20);
}
});})(sf))
),cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_field_DASH_key_DASH_edited,!(cljs.core.empty_QMARK_(cljs.core.cst$kw$sighting_DASH_field_DASH_key.cljs$core$IFn$_invoke$arity$1(sf))));
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_buffer,vs);
});
camelot.component.survey.sighting_fields.survey_sighting_field_keys = (function camelot$component$survey$sighting_fields$survey_sighting_field_keys(data){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$sighting_DASH_field_DASH_key,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__20341_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(p1__20341_SHARP_),camelot.state.get_survey_id());
}),cljs.core.vals(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields.cljs$core$IFn$_invoke$arity$1(data)))));
});
camelot.component.survey.sighting_fields.compatible_sighting_fields = (function camelot$component$survey$sighting_fields$compatible_sighting_fields(data){
var sf_keys = camelot.component.survey.sighting_fields.survey_sighting_field_keys(data);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (sf_keys){
return (function (sf){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(sf),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sighting_DASH_field_DASH_label.cljs$core$IFn$_invoke$arity$1(sf)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" ("),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_surveys,cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(sf),cljs.core.cst$kw$survey_DASH_name], null))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(")")].join('')], null);
});})(sf_keys))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (sf_keys){
return (function (p1__20343_SHARP_){
var G__20344 = cljs.core.cst$kw$sighting_DASH_field_DASH_key.cljs$core$IFn$_invoke$arity$1(p1__20343_SHARP_);
return (sf_keys.cljs$core$IFn$_invoke$arity$1 ? sf_keys.cljs$core$IFn$_invoke$arity$1(G__20344) : sf_keys.call(null,G__20344));
});})(sf_keys))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (sf_keys){
return (function (p1__20342_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(p1__20342_SHARP_),camelot.state.get_survey_id());
});})(sf_keys))
,cljs.core.vals(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields.cljs$core$IFn$_invoke$arity$1(data)))));
});
/**
 * Render a component for a select option.
 */
camelot.component.survey.sighting_fields.select_option_component = (function camelot$component$survey$sighting_fields$select_option_component(p__20345,owner){
var vec__20346 = p__20345;
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20346,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20346,(1),null);
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349 = (function (p__20345,owner,vec__20346,key,value,meta20350){
this.p__20345 = p__20345;
this.owner = owner;
this.vec__20346 = vec__20346;
this.key = key;
this.value = value;
this.meta20350 = meta20350;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__20346,key,value){
return (function (_20351,meta20350__$1){
var self__ = this;
var _20351__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349(self__.p__20345,self__.owner,self__.vec__20346,self__.key,self__.value,meta20350__$1));
});})(vec__20346,key,value))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__20346,key,value){
return (function (_20351){
var self__ = this;
var _20351__$1 = this;
return self__.meta20350;
});})(vec__20346,key,value))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349.prototype.om$core$IRender$render$arity$1 = ((function (vec__20346,key,value){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__20352 = ({"value": self__.key});
var G__20353 = self__.value;
return (om.dom.option.cljs$core$IFn$_invoke$arity$2 ? om.dom.option.cljs$core$IFn$_invoke$arity$2(G__20352,G__20353) : om.dom.option.call(null,G__20352,G__20353));
});})(vec__20346,key,value))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349.getBasis = ((function (vec__20346,key,value){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__20345,cljs.core.cst$sym$owner,cljs.core.cst$sym$vec__20346,cljs.core.cst$sym$key,cljs.core.cst$sym$value,cljs.core.cst$sym$meta20350], null);
});})(vec__20346,key,value))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20349";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349.cljs$lang$ctorPrWriter = ((function (vec__20346,key,value){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20349");
});})(vec__20346,key,value))
;

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20349 = ((function (vec__20346,key,value){
return (function camelot$component$survey$sighting_fields$select_option_component_$___GT_t_camelot$component$survey$sighting_fields20349(p__20345__$1,owner__$1,vec__20346__$1,key__$1,value__$1,meta20350){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349(p__20345__$1,owner__$1,vec__20346__$1,key__$1,value__$1,meta20350));
});})(vec__20346,key,value))
;

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20349(p__20345,owner,vec__20346,key,value,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.survey.sighting_fields.copy_from_survey_component = (function camelot$component$survey$sighting_fields$copy_from_survey_component(data,owner){
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355 = (function (data,owner,meta20356){
this.data = data;
this.owner = owner;
this.meta20356 = meta20356;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20357,meta20356__$1){
var self__ = this;
var _20357__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355(self__.data,self__.owner,meta20356__$1));
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20357){
var self__ = this;
var _20357__$1 = this;
return self__.meta20356;
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var fields = camelot.component.survey.sighting_fields.compatible_sighting_fields(self__.data);
if(cljs.core.seq(fields)){
var G__20358 = null;
var G__20359 = om.util.force_children((function (){var G__20362 = null;
var G__20363 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_template));
return React.DOM.label(G__20362,G__20363);
})());
var G__20360 = om.util.force_children(": ");
var G__20361 = om.util.force_children((function (){var G__20364 = ({"onChange": ((function (G__20358,G__20359,G__20360,fields,___$1){
return (function (p1__20354_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_field_DASH_template_DASH_id,(function (){var v = p1__20354_SHARP_.target.value;
if(cljs.core.truth_(v)){
return cljs.reader.read_string(v);
} else {
return v;
}
})());
});})(G__20358,G__20359,G__20360,fields,___$1))
});
var G__20365 = om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.survey.sighting_fields.select_option_component,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fields,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["",camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_default_DASH_template)], null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key_DASH_fn,cljs.core.first], null));
return (om.dom.select.cljs$core$IFn$_invoke$arity$2 ? om.dom.select.cljs$core$IFn$_invoke$arity$2(G__20364,G__20365) : om.dom.select.call(null,G__20364,G__20365));
})());
return React.DOM.div(G__20358,G__20359,G__20360,G__20361);
} else {
return null;
}
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20356], null);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20355";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20355");
});

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20355 = (function camelot$component$survey$sighting_fields$copy_from_survey_component_$___GT_t_camelot$component$survey$sighting_fields20355(data__$1,owner__$1,meta20356){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355(data__$1,owner__$1,meta20356));
});

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20355(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Select the sighting field with the given ID.
 */
camelot.component.survey.sighting_fields.select_sighting_field = (function camelot$component$survey$sighting_fields$select_sighting_field(data,sf_id){
if(cljs.core.contains_QMARK_(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields.cljs$core$IFn$_invoke$arity$1(data),sf_id)){
camelot.component.survey.sighting_fields.update_buffer(data,sf_id);
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_buffer,null);
}

if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sf_id,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_new)) || (cljs.core.contains_QMARK_(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields.cljs$core$IFn$_invoke$arity$1(data),sf_id))){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id,sf_id);
} else {
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id,null);
}
});
/**
 * Select the sighting field with the given ID.
 */
camelot.component.survey.sighting_fields.copy_sighting_field = (function camelot$component$survey$sighting_fields$copy_sighting_field(data,sf_id){
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([sf_id], 0));

if(cljs.core.truth_(sf_id)){
camelot.component.survey.sighting_fields.update_buffer(data,sf_id);
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_buffer,null);
}

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_new);
});
/**
 * Menu item representing a single sighting field.
 */
camelot.component.survey.sighting_fields.sighting_field_menu_item = (function camelot$component$survey$sighting_fields$sighting_field_menu_item(data,owner){
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367 = (function (data,owner,meta20368){
this.data = data;
this.owner = owner;
this.meta20368 = meta20368;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20369,meta20368__$1){
var self__ = this;
var _20369__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367(self__.data,self__.owner,meta20368__$1));
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20369){
var self__ = this;
var _20369__$1 = this;
return self__.meta20368;
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var sid = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_item,cljs.core.cst$kw$sighting_DASH_field_DASH_id], null));
var G__20370 = ({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("menu-item"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_context,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id], null)),sid))?" active":""))].join(''), "onClick": ((function (sid,___$1){
return (function (){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("sighting-fields","survey-sighting-field-click");

return camelot.component.survey.sighting_fields.select_sighting_field(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_context.cljs$core$IFn$_invoke$arity$1(self__.data),sid);
});})(sid,___$1))
});
var G__20371 = om.util.force_children((function (){var G__20373 = ({"className": "pull-right fa fa-times remove top-corner", "onClick": ((function (G__20370,sid,___$1){
return (function (p1__20366_SHARP_){
p1__20366_SHARP_.preventDefault();

p1__20366_SHARP_.stopPropagation();

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_context.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_delete_DASH_sighting_DASH_field_DASH_id,sid);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_context.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_show_DASH_delete_DASH_sighting_DASH_field_DASH_prompt,true);
});})(G__20370,sid,___$1))
});
return React.DOM.div(G__20373);
})());
var G__20372 = om.util.force_children(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_item,cljs.core.cst$kw$sighting_DASH_field_DASH_label], null)));
return React.DOM.div(G__20370,G__20371,G__20372);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20368], null);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20367";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20367");
});

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20367 = (function camelot$component$survey$sighting_fields$sighting_field_menu_item_$___GT_t_camelot$component$survey$sighting_fields20367(data__$1,owner__$1,meta20368){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367(data__$1,owner__$1,meta20368));
});

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20367(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Side menu for sighting fields within a survey.
 */
camelot.component.survey.sighting_fields.menu_component = (function camelot$component$survey$sighting_fields$menu_component(data,owner){
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377 = (function (data,owner,meta20378){
this.data = data;
this.owner = owner;
this.meta20378 = meta20378;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20379,meta20378__$1){
var self__ = this;
var _20379__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377(self__.data,self__.owner,meta20378__$1));
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20379){
var self__ = this;
var _20379__$1 = this;
return self__.meta20378;
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var fields = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (___$1){
return (function (p1__20375_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_context,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_item],[self__.data,p1__20375_SHARP_]);
});})(___$1))
,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$sighting_DASH_field_DASH_ordering,cljs.core.cst$kw$sighting_DASH_field_DASH_label),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (___$1){
return (function (p1__20374_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(p1__20374_SHARP_),camelot.state.get_survey_id());
});})(___$1))
,cljs.core.vals(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields.cljs$core$IFn$_invoke$arity$1(self__.data)))));
var G__20380 = ({"className": "section"});
var G__20381 = om.util.force_children((function (){var G__20385 = ({"className": "simple-menu"});
var G__20386 = om.util.force_children(((cljs.core.seq(fields))?om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.survey.sighting_fields.sighting_field_menu_item,fields,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key_DASH_fn,((function (G__20385,G__20380,fields,___$1){
return (function (p1__20376_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__20376_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_item,cljs.core.cst$kw$sighting_DASH_field_DASH_id], null));
});})(G__20385,G__20380,fields,___$1))
], null)):om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.blank_slate_component,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$notice,camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_help_DASH_text)], null)], null))));
return React.DOM.div(G__20385,G__20386);
})());
var G__20382 = om.util.force_children((function (){var G__20387 = ({"className": "sep"});
return React.DOM.div(G__20387);
})());
var G__20383 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.survey.sighting_fields.copy_from_survey_component,self__.data));
var G__20384 = om.util.force_children((function (){var G__20388 = ({"className": "btn btn-primary", "onClick": ((function (G__20380,G__20381,G__20382,G__20383,fields,___$1){
return (function (){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("sighting-fields","new-field-click");

return camelot.component.survey.sighting_fields.copy_sighting_field(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_field_DASH_template_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data));
});})(G__20380,G__20381,G__20382,G__20383,fields,___$1))
});
var G__20389 = om.util.force_children(((typeof cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_field_DASH_template_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data) === 'number')?camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_new_DASH_field_DASH_from_DASH_template):camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_new_DASH_field)));
return React.DOM.button(G__20388,G__20389);
})());
return React.DOM.div(G__20380,G__20381,G__20382,G__20383,G__20384);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20378], null);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20377";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20377");
});

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20377 = (function camelot$component$survey$sighting_fields$menu_component_$___GT_t_camelot$component$survey$sighting_fields20377(data__$1,owner__$1,meta20378){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377(data__$1,owner__$1,meta20378));
});

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20377(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Return the translation for the field. Suffix may be either '.label' or '.description'.
 */
camelot.component.survey.sighting_fields.field_translation = (function camelot$component$survey$sighting_fields$field_translation(field,suffix){
var ns = "camelot.component.survey.sighting-fields";
return camelot.translation.core.translate(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(field)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(suffix)].join('')));
});
/**
 * Submit the current form.
 */
camelot.component.survey.sighting_fields.submit_button_component = (function camelot$component$survey$sighting_fields$submit_button_component(data,owner){
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390 = (function (data,owner,meta20391){
this.data = data;
this.owner = owner;
this.meta20391 = meta20391;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20392,meta20391__$1){
var self__ = this;
var _20392__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390(self__.data,self__.owner,meta20391__$1));
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20392){
var self__ = this;
var _20392__$1 = this;
return self__.meta20391;
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__20393 = ({"className": "btn btn-primary", "disabled": (cljs.core.truth_(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_validated.cljs$core$IFn$_invoke$arity$1(self__.data))?"":"disabled"), "onClick": ((function (___$1){
return (function (){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("sighting-fields","submit-click");

var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,___$1){
return (function (state_20405){
var state_val_20406 = (state_20405[(1)]);
if((state_val_20406 === (1))){
var inst_20395 = cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_20396 = [cljs.core.cst$kw$event,cljs.core.cst$kw$sighting_DASH_field_DASH_id,cljs.core.cst$kw$buffer];
var inst_20397 = cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data);
var inst_20398 = cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_buffer.cljs$core$IFn$_invoke$arity$1(self__.data);
var inst_20399 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_20398,cljs.core.cst$kw$sighting_DASH_field_DASH_datatype,cljs.core.keyword);
var inst_20400 = [cljs.core.cst$kw$submit,inst_20397,inst_20399];
var inst_20401 = cljs.core.PersistentHashMap.fromArrays(inst_20396,inst_20400);
var state_20405__$1 = state_20405;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20405__$1,(2),inst_20395,inst_20401);
} else {
if((state_val_20406 === (2))){
var inst_20403 = (state_20405[(2)]);
var state_20405__$1 = state_20405;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20405__$1,inst_20403);
} else {
return null;
}
}
});})(c__14822__auto__,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,___$1){
return (function() {
var camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto__ = null;
var camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto____0 = (function (){
var statearr_20407 = [null,null,null,null,null,null,null];
(statearr_20407[(0)] = camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto__);

(statearr_20407[(1)] = (1));

return statearr_20407;
});
var camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto____1 = (function (state_20405){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20405);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20408){if((e20408 instanceof Object)){
var ex__14726__auto__ = e20408;
var statearr_20409_20411 = state_20405;
(statearr_20409_20411[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20405);

return cljs.core.cst$kw$recur;
} else {
throw e20408;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20412 = state_20405;
state_20405 = G__20412;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto__ = function(state_20405){
switch(arguments.length){
case 0:
return camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto____1.call(this,state_20405);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto____0;
camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto____1;
return camelot$component$survey$sighting_fields$submit_button_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,___$1))
})();
var state__14824__auto__ = (function (){var statearr_20410 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20410[(6)] = c__14822__auto__);

return statearr_20410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,___$1))
);

return c__14822__auto__;
});})(___$1))
});
var G__20394 = om.util.force_children(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_new))?camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_create):camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_update)));
return React.DOM.button(G__20393,G__20394);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20391], null);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20390";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20390");
});

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20390 = (function camelot$component$survey$sighting_fields$submit_button_component_$___GT_t_camelot$component$survey$sighting_fields20390(data__$1,owner__$1,meta20391){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390(data__$1,owner__$1,meta20391));
});

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20390(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Cancel any changes.
 */
camelot.component.survey.sighting_fields.cancel_button_component = (function camelot$component$survey$sighting_fields$cancel_button_component(data,owner){
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413 = (function (data,owner,meta20414){
this.data = data;
this.owner = owner;
this.meta20414 = meta20414;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20415,meta20414__$1){
var self__ = this;
var _20415__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413(self__.data,self__.owner,meta20414__$1));
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20415){
var self__ = this;
var _20415__$1 = this;
return self__.meta20414;
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__20416 = ({"className": "btn btn-default", "onClick": ((function (___$1){
return (function (){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("sighting-fields","cancel-click");

var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,___$1){
return (function (state_20425){
var state_val_20426 = (state_20425[(1)]);
if((state_val_20426 === (1))){
var inst_20418 = cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_20419 = [cljs.core.cst$kw$event];
var inst_20420 = [cljs.core.cst$kw$cancel];
var inst_20421 = cljs.core.PersistentHashMap.fromArrays(inst_20419,inst_20420);
var state_20425__$1 = state_20425;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20425__$1,(2),inst_20418,inst_20421);
} else {
if((state_val_20426 === (2))){
var inst_20423 = (state_20425[(2)]);
var state_20425__$1 = state_20425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20425__$1,inst_20423);
} else {
return null;
}
}
});})(c__14822__auto__,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,___$1){
return (function() {
var camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto__ = null;
var camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto____0 = (function (){
var statearr_20427 = [null,null,null,null,null,null,null];
(statearr_20427[(0)] = camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto__);

(statearr_20427[(1)] = (1));

return statearr_20427;
});
var camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto____1 = (function (state_20425){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20425);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20428){if((e20428 instanceof Object)){
var ex__14726__auto__ = e20428;
var statearr_20429_20431 = state_20425;
(statearr_20429_20431[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20425);

return cljs.core.cst$kw$recur;
} else {
throw e20428;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20432 = state_20425;
state_20425 = G__20432;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto__ = function(state_20425){
switch(arguments.length){
case 0:
return camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto____1.call(this,state_20425);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto____0;
camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto____1;
return camelot$component$survey$sighting_fields$cancel_button_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,___$1))
})();
var state__14824__auto__ = (function (){var statearr_20430 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20430[(6)] = c__14822__auto__);

return statearr_20430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,___$1))
);

return c__14822__auto__;
});})(___$1))
});
var G__20417 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_cancel));
return React.DOM.button(G__20416,G__20417);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20414], null);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20413";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20413");
});

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20413 = (function camelot$component$survey$sighting_fields$cancel_button_component_$___GT_t_camelot$component$survey$sighting_fields20413(data__$1,owner__$1,meta20414){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413(data__$1,owner__$1,meta20414));
});

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20413(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Render a component for selections, adding in any additional attributes specified by `attrs`.
 * Options for select are given by the `options` option.
 */
camelot.component.survey.sighting_fields.select_component = (function camelot$component$survey$sighting_fields$select_component(data,owner,p__20434){
var map__20435 = p__20434;
var map__20435__$1 = ((((!((map__20435 == null)))?((((map__20435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20435.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20435):map__20435);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20435__$1,cljs.core.cst$kw$field);
var required = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20435__$1,cljs.core.cst$kw$required);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20435__$1,cljs.core.cst$kw$attrs);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20435__$1,cljs.core.cst$kw$options);
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437 = (function (data,owner,p__20434,map__20435,field,required,attrs,options,meta20438){
this.data = data;
this.owner = owner;
this.p__20434 = p__20434;
this.map__20435 = map__20435;
this.field = field;
this.required = required;
this.attrs = attrs;
this.options = options;
this.meta20438 = meta20438;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20435,map__20435__$1,field,required,attrs,options){
return (function (_20439,meta20438__$1){
var self__ = this;
var _20439__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437(self__.data,self__.owner,self__.p__20434,self__.map__20435,self__.field,self__.required,self__.attrs,self__.options,meta20438__$1));
});})(map__20435,map__20435__$1,field,required,attrs,options))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20435,map__20435__$1,field,required,attrs,options){
return (function (_20439){
var self__ = this;
var _20439__$1 = this;
return self__.meta20438;
});})(map__20435,map__20435__$1,field,required,attrs,options))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437.prototype.om$core$IRender$render$arity$1 = ((function (map__20435,map__20435__$1,field,required,attrs,options){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__20440 = null;
var G__20441 = om.util.force_children((function (){var G__20443 = ({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("field-label "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(self__.required)?"required":""))].join('')});
var G__20444 = om.util.force_children(camelot.translation.core.translate(camelot.component.survey.sighting_fields.field_translation(self__.field,".label")));
return React.DOM.label(G__20443,G__20444);
})());
var G__20442 = om.util.force_children((function (){var G__20445 = cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$className,"field-input",cljs.core.cst$kw$required,self__.required,cljs.core.cst$kw$onChange,((function (G__20440,G__20441,___$1,map__20435,map__20435__$1,field,required,attrs,options){
return (function (p1__20433_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,self__.field,p1__20433_SHARP_.target.value);
});})(G__20440,G__20441,___$1,map__20435,map__20435__$1,field,required,attrs,options))
,cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,self__.field),cljs.core.cst$kw$title,camelot.translation.core.translate(camelot.component.survey.sighting_fields.field_translation(self__.field,".description"))], null),(function (){var or__6624__auto__ = self__.attrs;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()], 0)));
var G__20446 = om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.survey.sighting_fields.select_option_component,self__.options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key_DASH_fn,cljs.core.first], null));
return (om.dom.select.cljs$core$IFn$_invoke$arity$2 ? om.dom.select.cljs$core$IFn$_invoke$arity$2(G__20445,G__20446) : om.dom.select.call(null,G__20445,G__20446));
})());
return React.DOM.div(G__20440,G__20441,G__20442);
});})(map__20435,map__20435__$1,field,required,attrs,options))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437.getBasis = ((function (map__20435,map__20435__$1,field,required,attrs,options){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__20434,cljs.core.cst$sym$map__20435,cljs.core.cst$sym$field,cljs.core.cst$sym$required,cljs.core.cst$sym$attrs,cljs.core.cst$sym$options,cljs.core.cst$sym$meta20438], null);
});})(map__20435,map__20435__$1,field,required,attrs,options))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20437";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437.cljs$lang$ctorPrWriter = ((function (map__20435,map__20435__$1,field,required,attrs,options){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20437");
});})(map__20435,map__20435__$1,field,required,attrs,options))
;

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20437 = ((function (map__20435,map__20435__$1,field,required,attrs,options){
return (function camelot$component$survey$sighting_fields$select_component_$___GT_t_camelot$component$survey$sighting_fields20437(data__$1,owner__$1,p__20434__$1,map__20435__$2,field__$1,required__$1,attrs__$1,options__$1,meta20438){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437(data__$1,owner__$1,p__20434__$1,map__20435__$2,field__$1,required__$1,attrs__$1,options__$1,meta20438));
});})(map__20435,map__20435__$1,field,required,attrs,options))
;

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20437(data,owner,p__20434,map__20435__$1,field,required,attrs,options,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Builds a component which executes the given function on change.
 */
camelot.component.survey.sighting_fields.build_text_input_component = (function camelot$component$survey$sighting_fields$build_text_input_component(onchange){
return (function (data,owner,p__20447){
var map__20448 = p__20447;
var map__20448__$1 = ((((!((map__20448 == null)))?((((map__20448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20448.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20448):map__20448);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20448__$1,cljs.core.cst$kw$field);
var required = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20448__$1,cljs.core.cst$kw$required);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20448__$1,cljs.core.cst$kw$attrs);
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450 = (function (onchange,data,owner,p__20447,map__20448,field,required,attrs,meta20451){
this.onchange = onchange;
this.data = data;
this.owner = owner;
this.p__20447 = p__20447;
this.map__20448 = map__20448;
this.field = field;
this.required = required;
this.attrs = attrs;
this.meta20451 = meta20451;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20448,map__20448__$1,field,required,attrs){
return (function (_20452,meta20451__$1){
var self__ = this;
var _20452__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450(self__.onchange,self__.data,self__.owner,self__.p__20447,self__.map__20448,self__.field,self__.required,self__.attrs,meta20451__$1));
});})(map__20448,map__20448__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20448,map__20448__$1,field,required,attrs){
return (function (_20452){
var self__ = this;
var _20452__$1 = this;
return self__.meta20451;
});})(map__20448,map__20448__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450.prototype.om$core$IRender$render$arity$1 = ((function (map__20448,map__20448__$1,field,required,attrs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__20453 = null;
var G__20454 = om.util.force_children((function (){var G__20456 = ({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("field-label "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(self__.required)?"required":""))].join('')});
var G__20457 = om.util.force_children(camelot.translation.core.translate(camelot.component.survey.sighting_fields.field_translation(self__.field,".label")));
return React.DOM.label(G__20456,G__20457);
})());
var G__20455 = om.util.force_children((function (){var G__20458 = cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$className,"field-input",cljs.core.cst$kw$required,self__.required,cljs.core.cst$kw$onChange,(self__.onchange.cljs$core$IFn$_invoke$arity$2 ? self__.onchange.cljs$core$IFn$_invoke$arity$2(self__.data,self__.field) : self__.onchange.call(null,self__.data,self__.field)),cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,self__.field),cljs.core.cst$kw$title,camelot.translation.core.translate(camelot.component.survey.sighting_fields.field_translation(self__.field,".description"))], null),(function (){var or__6624__auto__ = self__.attrs;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()], 0)));
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__20458) : om.dom.input.call(null,G__20458));
})());
return React.DOM.div(G__20453,G__20454,G__20455);
});})(map__20448,map__20448__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450.getBasis = ((function (map__20448,map__20448__$1,field,required,attrs){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$onchange,cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__20447,cljs.core.cst$sym$map__20448,cljs.core.cst$sym$field,cljs.core.cst$sym$required,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta20451], null);
});})(map__20448,map__20448__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20450";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450.cljs$lang$ctorPrWriter = ((function (map__20448,map__20448__$1,field,required,attrs){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20450");
});})(map__20448,map__20448__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20450 = ((function (map__20448,map__20448__$1,field,required,attrs){
return (function camelot$component$survey$sighting_fields$build_text_input_component_$___GT_t_camelot$component$survey$sighting_fields20450(onchange__$1,data__$1,owner__$1,p__20447__$1,map__20448__$2,field__$1,required__$1,attrs__$1,meta20451){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450(onchange__$1,data__$1,owner__$1,p__20447__$1,map__20448__$2,field__$1,required__$1,attrs__$1,meta20451));
});})(map__20448,map__20448__$1,field,required,attrs))
;

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20450(onchange,data,owner,p__20447,map__20448__$1,field,required,attrs,cljs.core.PersistentArrayMap.EMPTY));
});
});
camelot.component.survey.sighting_fields.label_to_field_key = (function camelot$component$survey$sighting_fields$label_to_field_key(label){
return clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.lower_case(label),/'/,""),/[^-0-9a-z]+/,"-"),/^-*/,""),/-*$/,"");
});
camelot.component.survey.sighting_fields.text_input_component = camelot.component.survey.sighting_fields.build_text_input_component((function (data,field){
return (function (p1__20459_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,field,p1__20459_SHARP_.target.value);
});
}));
camelot.component.survey.sighting_fields.field_label_input_component = camelot.component.survey.sighting_fields.build_text_input_component((function (data,field){
return (function (evt){
var v = evt.target.value;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,field,v);

if(cljs.core.truth_(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_field_DASH_key_DASH_edited.cljs$core$IFn$_invoke$arity$1(data))){
return null;
} else {
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$sighting_DASH_field_DASH_key,camelot.component.survey.sighting_fields.label_to_field_key(v));
}
});
}));
camelot.component.survey.sighting_fields.field_key_input_component = camelot.component.survey.sighting_fields.build_text_input_component((function (data,field){
return (function (evt){
var v = evt.target.value;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,field,v);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_field_DASH_key_DASH_edited,!(cljs.core.empty_QMARK_(v)));
});
}));
/**
 * Display and removal of a single list item.
 */
camelot.component.survey.sighting_fields.string_list_item = (function camelot$component$survey$sighting_fields$string_list_item(p__20460,owner){
var map__20461 = p__20460;
var map__20461__$1 = ((((!((map__20461 == null)))?((((map__20461.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20461.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20461):map__20461);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20461__$1,cljs.core.cst$kw$data);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20461__$1,cljs.core.cst$kw$field);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20461__$1,cljs.core.cst$kw$value);
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463 = (function (p__20460,owner,map__20461,data,field,value,meta20464){
this.p__20460 = p__20460;
this.owner = owner;
this.map__20461 = map__20461;
this.data = data;
this.field = field;
this.value = value;
this.meta20464 = meta20464;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20461,map__20461__$1,data,field,value){
return (function (_20465,meta20464__$1){
var self__ = this;
var _20465__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463(self__.p__20460,self__.owner,self__.map__20461,self__.data,self__.field,self__.value,meta20464__$1));
});})(map__20461,map__20461__$1,data,field,value))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20461,map__20461__$1,data,field,value){
return (function (_20465){
var self__ = this;
var _20465__$1 = this;
return self__.meta20464;
});})(map__20461,map__20461__$1,data,field,value))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463.prototype.om$core$IRender$render$arity$1 = ((function (map__20461,map__20461__$1,data,field,value){
return (function (_){
var self__ = this;
var ___$1 = this;
var rm_fn = ((function (___$1,map__20461,map__20461__$1,data,field,value){
return (function (){
return om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,self__.field,((function (___$1,map__20461,map__20461__$1,data,field,value){
return (function (v){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.createAsIfByAssoc([self__.value]),v);
});})(___$1,map__20461,map__20461__$1,data,field,value))
);
});})(___$1,map__20461,map__20461__$1,data,field,value))
;
var G__20466 = ({"className": "list-item"});
var G__20467 = om.util.force_children(self__.value);
var G__20468 = om.util.force_children((function (){var G__20469 = ({"className": "list-item-delete fa fa-times", "onClick": rm_fn});
return React.DOM.span(G__20469);
})());
return React.DOM.span(G__20466,G__20467,G__20468);
});})(map__20461,map__20461__$1,data,field,value))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463.getBasis = ((function (map__20461,map__20461__$1,data,field,value){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__20460,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__20461,cljs.core.cst$sym$data,cljs.core.cst$sym$field,cljs.core.cst$sym$value,cljs.core.cst$sym$meta20464], null);
});})(map__20461,map__20461__$1,data,field,value))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20463";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463.cljs$lang$ctorPrWriter = ((function (map__20461,map__20461__$1,data,field,value){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20463");
});})(map__20461,map__20461__$1,data,field,value))
;

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20463 = ((function (map__20461,map__20461__$1,data,field,value){
return (function camelot$component$survey$sighting_fields$string_list_item_$___GT_t_camelot$component$survey$sighting_fields20463(p__20460__$1,owner__$1,map__20461__$2,data__$1,field__$1,value__$1,meta20464){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463(p__20460__$1,owner__$1,map__20461__$2,data__$1,field__$1,value__$1,meta20464));
});})(map__20461,map__20461__$1,data,field,value))
;

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20463(p__20460,owner,map__20461__$1,data,field,value,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for managing lists of items
 */
camelot.component.survey.sighting_fields.field_options_component = (function camelot$component$survey$sighting_fields$field_options_component(data,owner,p__20474){
var map__20475 = p__20474;
var map__20475__$1 = ((((!((map__20475 == null)))?((((map__20475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20475.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20475):map__20475);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20475__$1,cljs.core.cst$kw$field);
var required = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20475__$1,cljs.core.cst$kw$required);
var attrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20475__$1,cljs.core.cst$kw$attrs);
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477 = (function (data,owner,p__20474,map__20475,field,required,attrs,meta20478){
this.data = data;
this.owner = owner;
this.p__20474 = p__20474;
this.map__20475 = map__20475;
this.field = field;
this.required = required;
this.attrs = attrs;
this.meta20478 = meta20478;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20475,map__20475__$1,field,required,attrs){
return (function (_20479,meta20478__$1){
var self__ = this;
var _20479__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477(self__.data,self__.owner,self__.p__20474,self__.map__20475,self__.field,self__.required,self__.attrs,meta20478__$1));
});})(map__20475,map__20475__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20475,map__20475__$1,field,required,attrs){
return (function (_20479){
var self__ = this;
var _20479__$1 = this;
return self__.meta20478;
});})(map__20475,map__20475__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__20475,map__20475__$1,field,required,attrs){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_text_DASH_value,""], null);
});})(map__20475,map__20475__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__20475,map__20475__$1,field,required,attrs){
return (function (this$,state){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(camelot.component.survey.sighting_fields.datatype_has_options_QMARK_(self__.data))){
var additem_BANG_ = ((function (this$__$1,map__20475,map__20475__$1,field,required,attrs){
return (function camelot$component$survey$sighting_fields$field_options_component_$_additem_BANG_(){
var v_20491 = clojure.string.trim(om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_text_DASH_value));
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([v_20491]),cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,self__.field)))){
} else {
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,self__.field,((function (v_20491,this$__$1,map__20475,map__20475__$1,field,required,attrs){
return (function (p1__20470_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20470_SHARP_,v_20491);
});})(v_20491,this$__$1,map__20475,map__20475__$1,field,required,attrs))
);
}

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_text_DASH_value,"");
});})(this$__$1,map__20475,map__20475__$1,field,required,attrs))
;
var G__20480_20492 = ({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("field-label "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(self__.required)?"required":""))].join('')});
var G__20481_20493 = om.util.force_children(camelot.translation.core.translate(camelot.component.survey.sighting_fields.field_translation(self__.field,".label")));
React.DOM.label(G__20480_20492,G__20481_20493);

var G__20482 = ({"className": "list-input"});
var G__20483 = om.util.force_children((function (){var G__20485 = ({"className": "list-input-add-container"});
var G__20486 = om.util.force_children((function (){var G__20488 = ({"type": "text", "className": "field-input", "placeholder": camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_add_DASH_option), "value": cljs.core.get.cljs$core$IFn$_invoke$arity$2(state,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_text_DASH_value), "required": self__.required, "onKeyDown": ((function (G__20485,G__20482,this$__$1,map__20475,map__20475__$1,field,required,attrs){
return (function (p1__20471_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__20471_SHARP_.key,"Enter")){
return additem_BANG_();
} else {
return null;
}
});})(G__20485,G__20482,this$__$1,map__20475,map__20475__$1,field,required,attrs))
, "onChange": ((function (G__20485,G__20482,this$__$1,map__20475,map__20475__$1,field,required,attrs){
return (function (p1__20472_SHARP_){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_text_DASH_value,p1__20472_SHARP_.target.value);
});})(G__20485,G__20482,this$__$1,map__20475,map__20475__$1,field,required,attrs))
});
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__20488) : om.dom.input.call(null,G__20488));
})());
var G__20487 = om.util.force_children((function (){var G__20489 = ({"className": "btn btn-primary", "onClick": additem_BANG_});
var G__20490 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_add));
return React.DOM.button(G__20489,G__20490);
})());
return React.DOM.div(G__20485,G__20486,G__20487);
})());
var G__20484 = om.util.force_children(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(om.dom.div,({"className": "list-input-items"}),om.core.build_all.cljs$core$IFn$_invoke$arity$3(camelot.component.survey.sighting_fields.string_list_item,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__20482,G__20483,this$__$1,map__20475,map__20475__$1,field,required,attrs){
return (function (p1__20473_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$data,cljs.core.cst$kw$field,cljs.core.cst$kw$value],[self__.data,self__.field,p1__20473_SHARP_]);
});})(G__20482,G__20483,this$__$1,map__20475,map__20475__$1,field,required,attrs))
,cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,self__.field)))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key_DASH_fn,cljs.core.identity], null))));
return React.DOM.div(G__20482,G__20483,G__20484);
} else {
return null;
}
});})(map__20475,map__20475__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477.getBasis = ((function (map__20475,map__20475__$1,field,required,attrs){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__20474,cljs.core.cst$sym$map__20475,cljs.core.cst$sym$field,cljs.core.cst$sym$required,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta20478], null);
});})(map__20475,map__20475__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20477";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477.cljs$lang$ctorPrWriter = ((function (map__20475,map__20475__$1,field,required,attrs){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20477");
});})(map__20475,map__20475__$1,field,required,attrs))
;

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20477 = ((function (map__20475,map__20475__$1,field,required,attrs){
return (function camelot$component$survey$sighting_fields$field_options_component_$___GT_t_camelot$component$survey$sighting_fields20477(data__$1,owner__$1,p__20474__$1,map__20475__$2,field__$1,required__$1,attrs__$1,meta20478){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477(data__$1,owner__$1,p__20474__$1,map__20475__$2,field__$1,required__$1,attrs__$1,meta20478));
});})(map__20475,map__20475__$1,field,required,attrs))
;

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20477(data,owner,p__20474,map__20475__$1,field,required,attrs,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for editing sighting field details.
 */
camelot.component.survey.sighting_fields.edit_component = (function camelot$component$survey$sighting_fields$edit_component(data,owner){
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495 = (function (data,owner,meta20496){
this.data = data;
this.owner = owner;
this.meta20496 = meta20496;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20497,meta20496__$1){
var self__ = this;
var _20497__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495(self__.data,self__.owner,meta20496__$1));
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20497){
var self__ = this;
var _20497__$1 = this;
return self__.meta20496;
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$result_DASH_vchan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var rvchan = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$result_DASH_vchan);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$validation_DASH_chan,camelot.validation.validated_component.component_validator(rvchan));

var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,rvchan,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,rvchan,___$1){
return (function (state_20529){
var state_val_20530 = (state_20529[(1)]);
if((state_val_20530 === (7))){
var inst_20517 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
if(cljs.core.truth_(inst_20517)){
var statearr_20531_20591 = state_20529__$1;
(statearr_20531_20591[(1)] = (11));

} else {
var statearr_20532_20592 = state_20529__$1;
(statearr_20532_20592[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20530 === (1))){
var state_20529__$1 = state_20529;
var statearr_20533_20593 = state_20529__$1;
(statearr_20533_20593[(2)] = null);

(statearr_20533_20593[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20530 === (4))){
var inst_20501 = (state_20529[(7)]);
var inst_20501__$1 = (state_20529[(2)]);
var inst_20503 = (inst_20501__$1 == null);
var inst_20504 = cljs.core.not(inst_20503);
var state_20529__$1 = (function (){var statearr_20534 = state_20529;
(statearr_20534[(7)] = inst_20501__$1);

return statearr_20534;
})();
if(inst_20504){
var statearr_20535_20594 = state_20529__$1;
(statearr_20535_20594[(1)] = (5));

} else {
var statearr_20536_20595 = state_20529__$1;
(statearr_20536_20595[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20530 === (13))){
var inst_20522 = (state_20529[(2)]);
var inst_20523 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20522,cljs.core.cst$kw$validated);
var inst_20524 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_validated,inst_20523);
var state_20529__$1 = (function (){var statearr_20537 = state_20529;
(statearr_20537[(8)] = inst_20524);

return statearr_20537;
})();
var statearr_20538_20596 = state_20529__$1;
(statearr_20538_20596[(2)] = null);

(statearr_20538_20596[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20530 === (6))){
var state_20529__$1 = state_20529;
var statearr_20539_20597 = state_20529__$1;
(statearr_20539_20597[(2)] = false);

(statearr_20539_20597[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20530 === (3))){
var inst_20527 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20529__$1,inst_20527);
} else {
if((state_val_20530 === (12))){
var inst_20501 = (state_20529[(7)]);
var state_20529__$1 = state_20529;
var statearr_20540_20598 = state_20529__$1;
(statearr_20540_20598[(2)] = inst_20501);

(statearr_20540_20598[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20530 === (2))){
var state_20529__$1 = state_20529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20529__$1,(4),rvchan);
} else {
if((state_val_20530 === (11))){
var inst_20501 = (state_20529[(7)]);
var inst_20519 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20501);
var state_20529__$1 = state_20529;
var statearr_20541_20599 = state_20529__$1;
(statearr_20541_20599[(2)] = inst_20519);

(statearr_20541_20599[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20530 === (9))){
var state_20529__$1 = state_20529;
var statearr_20542_20600 = state_20529__$1;
(statearr_20542_20600[(2)] = false);

(statearr_20542_20600[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20530 === (5))){
var inst_20501 = (state_20529[(7)]);
var inst_20506 = inst_20501.cljs$lang$protocol_mask$partition0$;
var inst_20507 = (inst_20506 & (64));
var inst_20508 = inst_20501.cljs$core$ISeq$;
var inst_20509 = (cljs.core.PROTOCOL_SENTINEL === inst_20508);
var inst_20510 = (inst_20507) || (inst_20509);
var state_20529__$1 = state_20529;
if(cljs.core.truth_(inst_20510)){
var statearr_20543_20601 = state_20529__$1;
(statearr_20543_20601[(1)] = (8));

} else {
var statearr_20544_20602 = state_20529__$1;
(statearr_20544_20602[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20530 === (10))){
var inst_20514 = (state_20529[(2)]);
var state_20529__$1 = state_20529;
var statearr_20545_20603 = state_20529__$1;
(statearr_20545_20603[(2)] = inst_20514);

(statearr_20545_20603[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20530 === (8))){
var state_20529__$1 = state_20529;
var statearr_20546_20604 = state_20529__$1;
(statearr_20546_20604[(2)] = true);

(statearr_20546_20604[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__,rvchan,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,rvchan,___$1){
return (function() {
var camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__ = null;
var camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____0 = (function (){
var statearr_20547 = [null,null,null,null,null,null,null,null,null];
(statearr_20547[(0)] = camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__);

(statearr_20547[(1)] = (1));

return statearr_20547;
});
var camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____1 = (function (state_20529){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20529);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20548){if((e20548 instanceof Object)){
var ex__14726__auto__ = e20548;
var statearr_20549_20605 = state_20529;
(statearr_20549_20605[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20529);

return cljs.core.cst$kw$recur;
} else {
throw e20548;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20606 = state_20529;
state_20529 = G__20606;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__ = function(state_20529){
switch(arguments.length){
case 0:
return camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____1.call(this,state_20529);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____0;
camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____1;
return camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,rvchan,___$1))
})();
var state__14824__auto__ = (function (){var statearr_20550 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20550[(6)] = c__14822__auto__);

return statearr_20550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,rvchan,___$1))
);

return c__14822__auto__;
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.prototype.om$core$IWillUnmount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,___$1){
return (function (state_20558){
var state_val_20559 = (state_20558[(1)]);
if((state_val_20559 === (1))){
var inst_20551 = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$result_DASH_vchan);
var inst_20552 = [cljs.core.cst$kw$command];
var inst_20553 = [cljs.core.cst$kw$unmount];
var inst_20554 = cljs.core.PersistentHashMap.fromArrays(inst_20552,inst_20553);
var state_20558__$1 = state_20558;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20558__$1,(2),inst_20551,inst_20554);
} else {
if((state_val_20559 === (2))){
var inst_20556 = (state_20558[(2)]);
var state_20558__$1 = state_20558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20558__$1,inst_20556);
} else {
return null;
}
}
});})(c__14822__auto__,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,___$1){
return (function() {
var camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__ = null;
var camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____0 = (function (){
var statearr_20560 = [null,null,null,null,null,null,null];
(statearr_20560[(0)] = camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__);

(statearr_20560[(1)] = (1));

return statearr_20560;
});
var camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____1 = (function (state_20558){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20558);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20561){if((e20561 instanceof Object)){
var ex__14726__auto__ = e20561;
var statearr_20562_20607 = state_20558;
(statearr_20562_20607[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20558);

return cljs.core.cst$kw$recur;
} else {
throw e20561;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20608 = state_20558;
state_20558 = G__20608;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__ = function(state_20558){
switch(arguments.length){
case 0:
return camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____1.call(this,state_20558);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____0;
camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto____1;
return camelot$component$survey$sighting_fields$edit_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,___$1))
})();
var state__14824__auto__ = (function (){var statearr_20563 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20563[(6)] = c__14822__auto__);

return statearr_20563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,___$1))
);

return c__14822__auto__;
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var temp__4655__auto__ = cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_buffer.cljs$core$IFn$_invoke$arity$1(self__.data);
if(cljs.core.truth_(temp__4655__auto__)){
var buf = temp__4655__auto__;
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_buffer,cljs.core.cst$kw$sighting_DASH_field_DASH_id], null)),cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_new))){
var G__20564 = ({"className": "section"});
var G__20565 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data))?(function (){var G__20566 = null;
var G__20567 = om.util.force_children((function (){var G__20569 = cljs.core.clj__GT_js(cljs.core.PersistentArrayMap.EMPTY);
var G__20570 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.validation.validated_component.wrapper,buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$data_DASH_key,cljs.core.cst$kw$sighting_DASH_field_DASH_label,cljs.core.cst$kw$validators,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [camelot.validation.validated_component.required(),camelot.validation.validated_component.max_length((255))], null),cljs.core.cst$kw$params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$sighting_DASH_field_DASH_label,cljs.core.cst$kw$required,true], null)], null),cljs.core.cst$kw$validation_DASH_chan,cljs.core.cst$kw$validation_DASH_chan.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$component,camelot.component.survey.sighting_fields.field_label_input_component], null)], null)));
var G__20571 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.validation.validated_component.wrapper,buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$data_DASH_key,cljs.core.cst$kw$sighting_DASH_field_DASH_key,cljs.core.cst$kw$validators,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [camelot.validation.validated_component.required(),camelot.validation.validated_component.keyword_like(),camelot.validation.validated_component.unique(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$sighting_DASH_field_DASH_key,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__20569,G__20570,G__20566,G__20564,buf,temp__4655__auto__,___$1){
return (function (p1__20494_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$survey_DASH_id.cljs$core$IFn$_invoke$arity$1(p1__20494_SHARP_),camelot.state.get_survey_id());
});})(G__20569,G__20570,G__20566,G__20564,buf,temp__4655__auto__,___$1))
,cljs.core.vals(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data)))))))], null),cljs.core.cst$kw$params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$sighting_DASH_field_DASH_key,cljs.core.cst$kw$required,true], null)], null),cljs.core.cst$kw$validation_DASH_chan,cljs.core.cst$kw$validation_DASH_chan.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$component,camelot.component.survey.sighting_fields.field_key_input_component], null)], null)));
var G__20572 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.validation.validated_component.wrapper,buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$data_DASH_key,cljs.core.cst$kw$sighting_DASH_field_DASH_datatype,cljs.core.cst$kw$validators,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [camelot.validation.validated_component.required()], null),cljs.core.cst$kw$params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$field,cljs.core.cst$kw$sighting_DASH_field_DASH_datatype,cljs.core.cst$kw$required,true,cljs.core.cst$kw$options,(function (){var f = ((function (G__20569,G__20570,G__20571,G__20566,G__20564,buf,temp__4655__auto__,___$1){
return (function camelot$component$survey$sighting_fields$edit_component_$_f(p__20582){
var vec__20583 = p__20582;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20583,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20583,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.name(k),camelot.translation.core.translate(cljs.core.cst$kw$translation_DASH_key.cljs$core$IFn$_invoke$arity$1(v))], null);
});})(G__20569,G__20570,G__20571,G__20566,G__20564,buf,temp__4655__auto__,___$1))
;
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,camelot.util.sighting_fields.datatypes));
})()], null)], null),cljs.core.cst$kw$validation_DASH_chan,cljs.core.cst$kw$validation_DASH_chan.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$component,camelot.component.survey.sighting_fields.select_component], null)], null)));
var G__20573 = om.util.force_children((function (){var G__20586 = ({"className": "sighting-field-options"});
var G__20587 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.validation.validated_component.wrapper,buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$data_DASH_key,cljs.core.cst$kw$sighting_DASH_field_DASH_options,cljs.core.cst$kw$validators,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [camelot.validation.validated_component.required_if(((function (G__20586,G__20569,G__20570,G__20571,G__20572,G__20566,G__20564,buf,temp__4655__auto__,___$1){
return (function (){
return camelot.component.survey.sighting_fields.datatype_has_options_QMARK_(buf);
});})(G__20586,G__20569,G__20570,G__20571,G__20572,G__20566,G__20564,buf,temp__4655__auto__,___$1))
)], null),cljs.core.cst$kw$params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,cljs.core.cst$kw$sighting_DASH_field_DASH_options], null)], null),cljs.core.cst$kw$validation_DASH_chan,cljs.core.cst$kw$validation_DASH_chan.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$component,camelot.component.survey.sighting_fields.field_options_component], null)], null)));
return React.DOM.div(G__20586,G__20587);
})());
var G__20574 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.validation.validated_component.wrapper,buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$data_DASH_key,cljs.core.cst$kw$sighting_DASH_field_DASH_required,cljs.core.cst$kw$validators,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [camelot.validation.validated_component.required()], null),cljs.core.cst$kw$params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$field,cljs.core.cst$kw$sighting_DASH_field_DASH_required,cljs.core.cst$kw$required,true,cljs.core.cst$kw$options,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, ["true",camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_yes),"false",camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_no)], null))], null)], null),cljs.core.cst$kw$validation_DASH_chan,cljs.core.cst$kw$validation_DASH_chan.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$component,camelot.component.survey.sighting_fields.select_component], null)], null)));
var G__20575 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.validation.validated_component.wrapper,buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$data_DASH_key,cljs.core.cst$kw$sighting_DASH_field_DASH_default,cljs.core.cst$kw$validators,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,cljs.core.cst$kw$sighting_DASH_field_DASH_default], null)], null),cljs.core.cst$kw$validation_DASH_chan,cljs.core.cst$kw$validation_DASH_chan.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$component,camelot.component.survey.sighting_fields.text_input_component], null)], null)));
var G__20576 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.validation.validated_component.wrapper,buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$data_DASH_key,cljs.core.cst$kw$sighting_DASH_field_DASH_affects_DASH_independence,cljs.core.cst$kw$validators,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [camelot.validation.validated_component.required()], null),cljs.core.cst$kw$params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$field,cljs.core.cst$kw$sighting_DASH_field_DASH_affects_DASH_independence,cljs.core.cst$kw$required,true,cljs.core.cst$kw$options,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, ["true",camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_yes),"false",camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_no)], null))], null)], null),cljs.core.cst$kw$validation_DASH_chan,cljs.core.cst$kw$validation_DASH_chan.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$component,camelot.component.survey.sighting_fields.select_component], null)], null)));
var G__20577 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.validation.validated_component.wrapper,buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$data_DASH_key,cljs.core.cst$kw$sighting_DASH_field_DASH_ordering,cljs.core.cst$kw$validators,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [camelot.validation.validated_component.required()], null),cljs.core.cst$kw$params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$field,cljs.core.cst$kw$sighting_DASH_field_DASH_ordering,cljs.core.cst$kw$required,true,cljs.core.cst$kw$attrs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,"number"], null)], null)], null),cljs.core.cst$kw$validation_DASH_chan,cljs.core.cst$kw$validation_DASH_chan.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$component,camelot.component.survey.sighting_fields.text_input_component], null)], null)));
return React.DOM.div(G__20569,G__20570,G__20571,G__20572,G__20573,G__20574,G__20575,G__20576,G__20577);
})());
var G__20568 = om.util.force_children((function (){var G__20588 = ({"className": "button-container"});
var G__20589 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.survey.sighting_fields.cancel_button_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,state], null)));
var G__20590 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.survey.sighting_fields.submit_button_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,state], null)));
return React.DOM.div(G__20588,G__20589,G__20590);
})());
return React.DOM.div(G__20566,G__20567,G__20568);
})():null));
return React.DOM.div(G__20564,G__20565);
} else {
return null;
}
} else {
camelot.component.survey.sighting_fields.update_buffer(self__.data,null);

return null;
}
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20496], null);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20495";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20495");
});

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20495 = (function camelot$component$survey$sighting_fields$edit_component_$___GT_t_camelot$component$survey$sighting_fields20495(data__$1,owner__$1,meta20496){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495(data__$1,owner__$1,meta20496));
});

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20495(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
camelot.component.survey.sighting_fields.assoc_sighting_field = (function camelot$component$survey$sighting_fields$assoc_sighting_field(data,sighting_field){
return om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields,(function (p1__20609_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__20609_SHARP_,cljs.core.cst$kw$sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(sighting_field),sighting_field);
}));
});
/**
 * Top-level component for managing a survey's sighting fields.
 */
camelot.component.survey.sighting_fields.manage_fields_component = (function camelot$component$survey$sighting_fields$manage_fields_component(data,owner){
if(typeof camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612 = (function (data,owner,meta20613){
this.data = data;
this.owner = owner;
this.meta20613 = meta20613;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20614,meta20613__$1){
var self__ = this;
var _20614__$1 = this;
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612(self__.data,self__.owner,meta20613__$1));
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20614){
var self__ = this;
var _20614__$1 = this;
return self__.meta20613;
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.prototype.om$core$IInitState$init_state$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0()], null);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2("/sighting-fields",((function (___$1){
return (function (r){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields,camelot.util.data.key_by(cljs.core.cst$kw$sighting_DASH_field_DASH_id,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(r)));
});})(___$1))
);

camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2("/surveys",((function (___$1){
return (function (r){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_surveys,camelot.util.data.key_by(cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(r)));
});})(___$1))
);

camelot.component.survey.sighting_fields.update_buffer(self__.data,null);

var ch = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_chan);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,ch,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,ch,___$1){
return (function (state_20672){
var state_val_20673 = (state_20672[(1)]);
if((state_val_20673 === (7))){
var inst_20667 = (state_20672[(2)]);
var state_20672__$1 = (function (){var statearr_20674 = state_20672;
(statearr_20674[(7)] = inst_20667);

return statearr_20674;
})();
var statearr_20675_20751 = state_20672__$1;
(statearr_20675_20751[(2)] = null);

(statearr_20675_20751[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (1))){
var state_20672__$1 = state_20672;
var statearr_20676_20752 = state_20672__$1;
(statearr_20676_20752[(2)] = null);

(statearr_20676_20752[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (4))){
var inst_20621 = (state_20672[(8)]);
var inst_20617 = (state_20672[(9)]);
var inst_20617__$1 = (state_20672[(2)]);
var inst_20621__$1 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(inst_20617__$1);
var inst_20622 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$submit,inst_20621__$1);
var state_20672__$1 = (function (){var statearr_20677 = state_20672;
(statearr_20677[(8)] = inst_20621__$1);

(statearr_20677[(9)] = inst_20617__$1);

return statearr_20677;
})();
if(inst_20622){
var statearr_20678_20753 = state_20672__$1;
(statearr_20678_20753[(1)] = (5));

} else {
var statearr_20679_20754 = state_20672__$1;
(statearr_20679_20754[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (15))){
var inst_20621 = (state_20672[(8)]);
var inst_20659 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20621)].join('');
var inst_20660 = (new Error(inst_20659));
var inst_20661 = (function(){throw inst_20660})();
var state_20672__$1 = state_20672;
var statearr_20680_20755 = state_20672__$1;
(statearr_20680_20755[(2)] = inst_20661);

(statearr_20680_20755[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (13))){
var inst_20665 = (state_20672[(2)]);
var state_20672__$1 = state_20672;
var statearr_20681_20756 = state_20672__$1;
(statearr_20681_20756[(2)] = inst_20665);

(statearr_20681_20756[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (6))){
var inst_20621 = (state_20672[(8)]);
var inst_20646 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$delete,inst_20621);
var state_20672__$1 = state_20672;
if(inst_20646){
var statearr_20682_20757 = state_20672__$1;
(statearr_20682_20757[(1)] = (11));

} else {
var statearr_20683_20758 = state_20672__$1;
(statearr_20683_20758[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (3))){
var inst_20670 = (state_20672[(2)]);
var state_20672__$1 = state_20672;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20672__$1,inst_20670);
} else {
if((state_val_20673 === (12))){
var inst_20621 = (state_20672[(8)]);
var inst_20655 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$cancel,inst_20621);
var state_20672__$1 = state_20672;
if(inst_20655){
var statearr_20684_20759 = state_20672__$1;
(statearr_20684_20759[(1)] = (14));

} else {
var statearr_20685_20760 = state_20672__$1;
(statearr_20685_20760[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (2))){
var state_20672__$1 = state_20672;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20672__$1,(4),ch);
} else {
if((state_val_20673 === (11))){
var inst_20621 = (state_20672[(8)]);
var inst_20617 = (state_20672[(9)]);
var inst_20648 = cljs.core.cst$kw$sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_20617);
var inst_20649 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("/sighting-fields/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20648)].join('');
var inst_20650 = (function (){var r = inst_20617;
var pred__20618 = cljs.core._EQ_;
var expr__20619 = inst_20621;
var sf_id = inst_20648;
return ((function (r,pred__20618,expr__20619,sf_id,inst_20621,inst_20617,inst_20648,inst_20649,state_val_20673,c__14822__auto__,ch,___$1){
return (function (){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields,((function (r,pred__20618,expr__20619,sf_id,inst_20621,inst_20617,inst_20648,inst_20649,state_val_20673,c__14822__auto__,ch,___$1){
return (function (m){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,sf_id);
});})(r,pred__20618,expr__20619,sf_id,inst_20621,inst_20617,inst_20648,inst_20649,state_val_20673,c__14822__auto__,ch,___$1))
);

return camelot.component.survey.sighting_fields.select_sighting_field(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data));
});
;})(r,pred__20618,expr__20619,sf_id,inst_20621,inst_20617,inst_20648,inst_20649,state_val_20673,c__14822__auto__,ch,___$1))
})();
var inst_20651 = camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2(inst_20649,inst_20650);
var inst_20652 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_delete_DASH_sighting_DASH_field_DASH_id,null);
var inst_20653 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_show_DASH_delete_DASH_sighting_DASH_field_DASH_prompt,false);
var state_20672__$1 = (function (){var statearr_20686 = state_20672;
(statearr_20686[(10)] = inst_20651);

(statearr_20686[(11)] = inst_20652);

return statearr_20686;
})();
var statearr_20687_20761 = state_20672__$1;
(statearr_20687_20761[(2)] = inst_20653);

(statearr_20687_20761[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (9))){
var inst_20628 = (state_20672[(12)]);
var inst_20621 = (state_20672[(8)]);
var inst_20627 = (state_20672[(13)]);
var inst_20617 = (state_20672[(9)]);
var inst_20638 = [cljs.core.cst$kw$data];
var inst_20639 = [inst_20627];
var inst_20640 = cljs.core.PersistentHashMap.fromArrays(inst_20638,inst_20639);
var inst_20641 = (function (){var r = inst_20617;
var pred__20618 = cljs.core._EQ_;
var expr__20619 = inst_20621;
var v = inst_20627;
var sf_id = inst_20628;
return ((function (r,pred__20618,expr__20619,v,sf_id,inst_20628,inst_20621,inst_20627,inst_20617,inst_20638,inst_20639,inst_20640,state_val_20673,c__14822__auto__,ch,___$1){
return (function (p1__20611_SHARP_){
camelot.component.survey.sighting_fields.assoc_sighting_field(self__.data,camelot.util.cursorise.decursorise(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__20611_SHARP_)));

camelot.component.survey.sighting_fields.select_sighting_field(self__.data,null);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_field_DASH_template_DASH_id,null);
});
;})(r,pred__20618,expr__20619,v,sf_id,inst_20628,inst_20621,inst_20627,inst_20617,inst_20638,inst_20639,inst_20640,state_val_20673,c__14822__auto__,ch,___$1))
})();
var inst_20642 = camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3("/sighting-fields",inst_20640,inst_20641);
var state_20672__$1 = state_20672;
var statearr_20688_20762 = state_20672__$1;
(statearr_20688_20762[(2)] = inst_20642);

(statearr_20688_20762[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (5))){
var inst_20628 = (state_20672[(12)]);
var inst_20617 = (state_20672[(9)]);
var inst_20624 = cljs.core.cst$kw$buffer.cljs$core$IFn$_invoke$arity$1(inst_20617);
var inst_20625 = camelot.state.get_survey_id();
var inst_20626 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20624,cljs.core.cst$kw$survey_DASH_id,inst_20625);
var inst_20627 = cljs.core.select_keys(inst_20626,camelot.component.survey.sighting_fields.allowed_request_fields);
var inst_20628__$1 = cljs.core.cst$kw$sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_20617);
var inst_20629 = typeof inst_20628__$1 === 'number';
var state_20672__$1 = (function (){var statearr_20689 = state_20672;
(statearr_20689[(12)] = inst_20628__$1);

(statearr_20689[(13)] = inst_20627);

return statearr_20689;
})();
if(cljs.core.truth_(inst_20629)){
var statearr_20690_20763 = state_20672__$1;
(statearr_20690_20763[(1)] = (8));

} else {
var statearr_20691_20764 = state_20672__$1;
(statearr_20691_20764[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (14))){
var inst_20657 = camelot.component.survey.sighting_fields.select_sighting_field(self__.data,null);
var state_20672__$1 = state_20672;
var statearr_20692_20765 = state_20672__$1;
(statearr_20692_20765[(2)] = inst_20657);

(statearr_20692_20765[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (16))){
var inst_20663 = (state_20672[(2)]);
var state_20672__$1 = state_20672;
var statearr_20693_20766 = state_20672__$1;
(statearr_20693_20766[(2)] = inst_20663);

(statearr_20693_20766[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (10))){
var inst_20644 = (state_20672[(2)]);
var state_20672__$1 = state_20672;
var statearr_20694_20767 = state_20672__$1;
(statearr_20694_20767[(2)] = inst_20644);

(statearr_20694_20767[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20673 === (8))){
var inst_20628 = (state_20672[(12)]);
var inst_20621 = (state_20672[(8)]);
var inst_20627 = (state_20672[(13)]);
var inst_20617 = (state_20672[(9)]);
var inst_20631 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("/sighting-fields/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20628)].join('');
var inst_20632 = [cljs.core.cst$kw$data];
var inst_20633 = [inst_20627];
var inst_20634 = cljs.core.PersistentHashMap.fromArrays(inst_20632,inst_20633);
var inst_20635 = (function (){var r = inst_20617;
var pred__20618 = cljs.core._EQ_;
var expr__20619 = inst_20621;
var v = inst_20627;
var sf_id = inst_20628;
return ((function (r,pred__20618,expr__20619,v,sf_id,inst_20628,inst_20621,inst_20627,inst_20617,inst_20631,inst_20632,inst_20633,inst_20634,state_val_20673,c__14822__auto__,ch,___$1){
return (function (p1__20610_SHARP_){
camelot.component.survey.sighting_fields.assoc_sighting_field(self__.data,camelot.util.cursorise.decursorise(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__20610_SHARP_)));

return camelot.component.survey.sighting_fields.select_sighting_field(self__.data,null);
});
;})(r,pred__20618,expr__20619,v,sf_id,inst_20628,inst_20621,inst_20627,inst_20617,inst_20631,inst_20632,inst_20633,inst_20634,state_val_20673,c__14822__auto__,ch,___$1))
})();
var inst_20636 = camelot.rest.put_x.cljs$core$IFn$_invoke$arity$3(inst_20631,inst_20634,inst_20635);
var state_20672__$1 = state_20672;
var statearr_20695_20768 = state_20672__$1;
(statearr_20695_20768[(2)] = inst_20636);

(statearr_20695_20768[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__,ch,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,ch,___$1){
return (function() {
var camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__ = null;
var camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____0 = (function (){
var statearr_20696 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20696[(0)] = camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__);

(statearr_20696[(1)] = (1));

return statearr_20696;
});
var camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____1 = (function (state_20672){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20672);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20697){if((e20697 instanceof Object)){
var ex__14726__auto__ = e20697;
var statearr_20698_20769 = state_20672;
(statearr_20698_20769[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20672);

return cljs.core.cst$kw$recur;
} else {
throw e20697;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20770 = state_20672;
state_20672 = G__20770;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__ = function(state_20672){
switch(arguments.length){
case 0:
return camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____1.call(this,state_20672);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____0;
camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____1;
return camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,ch,___$1))
})();
var state__14824__auto__ = (function (){var statearr_20699 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20699[(6)] = c__14822__auto__);

return statearr_20699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,ch,___$1))
);

return c__14822__auto__;
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.prototype.om$core$IWillUnmount$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.prototype.om$core$IWillUnmount$will_unmount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_selected_DASH_sighting_DASH_field_DASH_id,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_surveys,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_buffer,null);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_field_DASH_template_DASH_id,null);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((function (){var and__6612__auto__ = cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_surveys.cljs$core$IFn$_invoke$arity$1(self__.data);
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields.cljs$core$IFn$_invoke$arity$1(self__.data);
} else {
return and__6612__auto__;
}
})())){
var G__20700 = ({"className": "split-menu"});
var G__20701 = om.util.force_children((function (){var G__20705 = ({"className": "back-button-container"});
var G__20706 = om.util.force_children((function (){var G__20707 = ({"className": "btn btn-default back", "onClick": ((function (G__20705,G__20700,___$1){
return (function (){
return camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$1((1));
});})(G__20705,G__20700,___$1))
});
var G__20708 = om.util.force_children((function (){var G__20711 = ({"className": "fa fa-mail-reply"});
return React.DOM.span(G__20711);
})());
var G__20709 = om.util.force_children(" ");
var G__20710 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_back));
return React.DOM.button(G__20707,G__20708,G__20709,G__20710);
})());
return React.DOM.div(G__20705,G__20706);
})());
var G__20702 = om.util.force_children((function (){var G__20712 = ({"className": "intro"});
var G__20713 = om.util.force_children((function (){var G__20714 = null;
var G__20715 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_page_DASH_title));
return React.DOM.h4(G__20714,G__20715);
})());
return React.DOM.div(G__20712,G__20713);
})());
var G__20703 = om.util.force_children((function (){var G__20716 = null;
var G__20717 = om.util.force_children((function (){var G__20719 = ({"className": "section-container"});
var G__20720 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(camelot.component.survey.sighting_fields.menu_component,self__.data));
return React.DOM.div(G__20719,G__20720);
})());
var G__20718 = om.util.force_children((function (){var G__20721 = ({"className": "section-container"});
var G__20722 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.survey.sighting_fields.edit_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$state,state], null)));
return React.DOM.div(G__20721,G__20722);
})());
return React.DOM.div(G__20716,G__20717,G__20718);
})());
var G__20704 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(camelot.component.util.prompt_component,self__.data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$active_DASH_key,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_show_DASH_delete_DASH_sighting_DASH_field_DASH_prompt,cljs.core.cst$kw$title,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_sighting_DASH_fields,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_delete_DASH_sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$sighting_DASH_field_DASH_label], null)),cljs.core.cst$kw$body,(function (){var G__20723 = null;
var G__20724 = om.util.force_children((function (){var G__20725 = ({"className": "delete-question"});
var G__20726 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_delete_DASH_question));
return React.DOM.p(G__20725,G__20726);
})());
return React.DOM.div(G__20723,G__20724);
})(),cljs.core.cst$kw$actions,(function (){var G__20727 = ({"className": "button-container"});
var G__20728 = om.util.force_children((function (){var G__20730 = ({"className": "btn btn-default", "ref": "action-first", "onClick": ((function (G__20727,G__20700,G__20701,G__20702,G__20703,___$1){
return (function (){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.data,cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_show_DASH_delete_DASH_sighting_DASH_field_DASH_prompt,false);
});})(G__20727,G__20700,G__20701,G__20702,G__20703,___$1))
});
var G__20731 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_cancel));
return React.DOM.button(G__20730,G__20731);
})());
var G__20729 = om.util.force_children((function (){var G__20732 = ({"className": "btn btn-primary", "ref": "action-first", "onClick": ((function (G__20727,G__20728,G__20700,G__20701,G__20702,G__20703,___$1){
return (function (){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("sighting-fields","delete-click");

var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,G__20727,G__20728,G__20700,G__20701,G__20702,G__20703,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,G__20727,G__20728,G__20700,G__20701,G__20702,G__20703,___$1){
return (function (state_20742){
var state_val_20743 = (state_20742[(1)]);
if((state_val_20743 === (1))){
var inst_20734 = cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_20735 = [cljs.core.cst$kw$event,cljs.core.cst$kw$sighting_DASH_field_DASH_id];
var inst_20736 = cljs.core.cst$kw$camelot$component$survey$sighting_DASH_fields_SLASH_delete_DASH_sighting_DASH_field_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.data);
var inst_20737 = [cljs.core.cst$kw$delete,inst_20736];
var inst_20738 = cljs.core.PersistentHashMap.fromArrays(inst_20735,inst_20737);
var state_20742__$1 = state_20742;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20742__$1,(2),inst_20734,inst_20738);
} else {
if((state_val_20743 === (2))){
var inst_20740 = (state_20742[(2)]);
var state_20742__$1 = state_20742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20742__$1,inst_20740);
} else {
return null;
}
}
});})(c__14822__auto__,G__20727,G__20728,G__20700,G__20701,G__20702,G__20703,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,G__20727,G__20728,G__20700,G__20701,G__20702,G__20703,___$1){
return (function() {
var camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__ = null;
var camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____0 = (function (){
var statearr_20744 = [null,null,null,null,null,null,null];
(statearr_20744[(0)] = camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__);

(statearr_20744[(1)] = (1));

return statearr_20744;
});
var camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____1 = (function (state_20742){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20742);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20745){if((e20745 instanceof Object)){
var ex__14726__auto__ = e20745;
var statearr_20746_20771 = state_20742;
(statearr_20746_20771[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20742);

return cljs.core.cst$kw$recur;
} else {
throw e20745;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20772 = state_20742;
state_20742 = G__20772;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__ = function(state_20742){
switch(arguments.length){
case 0:
return camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____1.call(this,state_20742);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____0;
camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto____1;
return camelot$component$survey$sighting_fields$manage_fields_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,G__20727,G__20728,G__20700,G__20701,G__20702,G__20703,___$1))
})();
var state__14824__auto__ = (function (){var statearr_20747 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20747[(6)] = c__14822__auto__);

return statearr_20747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,G__20727,G__20728,G__20700,G__20701,G__20702,G__20703,___$1))
);

return c__14822__auto__;
});})(G__20727,G__20728,G__20700,G__20701,G__20702,G__20703,___$1))
});
var G__20733 = om.util.force_children(camelot.translation.core.translate(cljs.core.cst$kw$words_SLASH_delete));
return React.DOM.button(G__20732,G__20733);
})());
return React.DOM.div(G__20727,G__20728,G__20729);
})()], null)], null)));
return React.DOM.div(G__20700,G__20701,G__20702,G__20703,G__20704);
} else {
var G__20748 = ({"className": "align-center"});
var G__20749 = om.util.force_children((function (){var G__20750 = ({"className": "spinner", "src": "images/spinner.gif", "height": "32", "width": "32"});
return React.DOM.img(G__20750);
})());
return React.DOM.div(G__20748,G__20749);
}
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta20613], null);
});

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.cljs$lang$type = true;

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.cljs$lang$ctorStr = "camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20612";

camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.component.survey.sighting-fields/t_camelot$component$survey$sighting_fields20612");
});

camelot.component.survey.sighting_fields.__GT_t_camelot$component$survey$sighting_fields20612 = (function camelot$component$survey$sighting_fields$manage_fields_component_$___GT_t_camelot$component$survey$sighting_fields20612(data__$1,owner__$1,meta20613){
return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612(data__$1,owner__$1,meta20613));
});

}

return (new camelot.component.survey.sighting_fields.t_camelot$component$survey$sighting_fields20612(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
