// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.nav');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.events');
goog.require('goog.history.EventType');
goog.require('secretary.core');
goog.require('om.core');
goog.require('camelot.state');
goog.require('clojure.string');
goog.require('goog.History');
/**
 * Get the current location token
 */
camelot.nav.get_token = (function camelot$nav$get_token(){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(window.location.pathname),cljs.core.str.cljs$core$IFn$_invoke$arity$1(window.location.hash)].join('');
});
if(typeof camelot.nav.history !== 'undefined'){
} else {
camelot.nav.history = (function (){var G__16906 = (new goog.History());
var G__16907_16910 = G__16906;
var G__16908_16911 = goog.history.EventType.NAVIGATE;
var G__16909_16912 = ((function (G__16907_16910,G__16908_16911,G__16906){
return (function (p1__16905_SHARP_){
return secretary.core.dispatch_BANG_(p1__16905_SHARP_.token);
});})(G__16907_16910,G__16908_16911,G__16906))
;
goog.events.listen(G__16907_16910,G__16908_16911,G__16909_16912);

G__16906.setEnabled(true);

return G__16906;
})();
}
camelot.nav.survey_url = (function camelot$nav$survey_url(var_args){
var G__16915 = arguments.length;
switch (G__16915) {
case 0:
return camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__7768__auto__ = [];
var len__7749__auto___16917 = arguments.length;
var i__7750__auto___16918 = (0);
while(true){
if((i__7750__auto___16918 < len__7749__auto___16917)){
args_arr__7768__auto__.push((arguments[i__7750__auto___16918]));

var G__16919 = (i__7750__auto___16918 + (1));
i__7750__auto___16918 = G__16919;
continue;
} else {
}
break;
}

var argseq__7769__auto__ = (new cljs.core.IndexedSeq(args_arr__7768__auto__.slice((0)),(0),null));
return camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$variadic(argseq__7769__auto__);

}
});

camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$0 = (function (){
var survey_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null));
if((survey_id == null)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("/organisation")].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null)))].join('');
}
});

camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$variadic = (function (paths){
var survey_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null));
if(cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(paths,survey_id)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("/organisation")].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$survey_DASH_id,cljs.core.cst$kw$value], null))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("/",paths))].join('');
}
});

camelot.nav.survey_url.cljs$lang$applyTo = (function (seq16914){
return camelot.nav.survey_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16914));
});

camelot.nav.survey_url.cljs$lang$maxFixedArity = (0);

camelot.nav.fire_analytics = (function camelot$nav$fire_analytics(var_args){
var args__7756__auto__ = [];
var len__7749__auto___16921 = arguments.length;
var i__7750__auto___16922 = (0);
while(true){
if((i__7750__auto___16922 < len__7749__auto___16921)){
args__7756__auto__.push((arguments[i__7750__auto___16922]));

var G__16923 = (i__7750__auto___16922 + (1));
i__7750__auto___16922 = G__16923;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((0) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((0)),(0),null)):null);
return camelot.nav.fire_analytics.cljs$core$IFn$_invoke$arity$variadic(argseq__7757__auto__);
});

camelot.nav.fire_analytics.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core.truth_(cljs.core.cst$kw$send_DASH_usage_DASH_data.cljs$core$IFn$_invoke$arity$1(camelot.state.settings()))){
var temp__4655__auto__ = (window["cljs_ga"]);
if(cljs.core.truth_(temp__4655__auto__)){
var ga = temp__4655__auto__;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(ga,args);
} else {
return console.warn("Analytics library not found");
}
} else {
return null;
}
});

camelot.nav.fire_analytics.cljs$lang$maxFixedArity = (0);

camelot.nav.fire_analytics.cljs$lang$applyTo = (function (seq16920){
return camelot.nav.fire_analytics.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16920));
});

/**
 * Trigger an analytics event.
 */
camelot.nav.analytics_event = (function camelot$nav$analytics_event(var_args){
var G__16925 = arguments.length;
switch (G__16925) {
case 2:
return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2 = (function (component,action){
return camelot.nav.fire_analytics.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["send","event",component,action], 0));
});

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$3 = (function (component,action,label){
return camelot.nav.fire_analytics.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["send","event",component,action,label], 0));
});

camelot.nav.analytics_event.cljs$lang$maxFixedArity = 3;

/**
 * Trigger a pageview analytics event.
 */
camelot.nav.analytics_pageview = (function camelot$nav$analytics_pageview(page){
if(cljs.core.truth_(cljs.core.cst$kw$send_DASH_usage_DASH_data.cljs$core$IFn$_invoke$arity$1(camelot.state.settings()))){
var temp__4655__auto__ = (window["cljs_ga"]);
if(cljs.core.truth_(temp__4655__auto__)){
var ga = temp__4655__auto__;
(ga.cljs$core$IFn$_invoke$arity$3 ? ga.cljs$core$IFn$_invoke$arity$3("set","page",page) : ga.call(null,"set","page",page));

return (ga.cljs$core$IFn$_invoke$arity$2 ? ga.cljs$core$IFn$_invoke$arity$2("send","pageview") : ga.call(null,"send","pageview"));
} else {
return null;
}
} else {
return null;
}
});
camelot.nav.set_token_BANG_ = (function camelot$nav$set_token_BANG_(history,token){
var token__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(token,(0),(2)),"/#"))?cljs.core.subs.cljs$core$IFn$_invoke$arity$2(token,(2)):token);
camelot.nav.analytics_pageview(token__$1);

history.setToken(token__$1);

return token__$1;
});
/**
 * Navigate to a URL token, creating a breadcrumb
 */
camelot.nav.breadnav_BANG_ = (function camelot$nav$breadnav_BANG_(token,breadcrumb,state){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$nav_DASH_history,(function (h){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(h),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$token,camelot.nav.get_token(),cljs.core.cst$kw$label,breadcrumb,cljs.core.cst$kw$state,cljs.core.deref(state)], null));
}));

return camelot.nav.set_token_BANG_(camelot.nav.history,token);
});
/**
 * Navigate to a URL token
 */
camelot.nav.breadnav_consume_BANG_ = (function camelot$nav$breadnav_consume_BANG_(token){
om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$nav_DASH_history,(function (h){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__16927_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$token.cljs$core$IFn$_invoke$arity$1(p1__16927_SHARP_),token);
}),h);
}));

return camelot.nav.set_token_BANG_(camelot.nav.history,token);
});
/**
 * Navigate to a URL token
 */
camelot.nav.nav_BANG_ = (function camelot$nav$nav_BANG_(token){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$nav_DASH_history,cljs.core.PersistentVector.EMPTY);

return camelot.nav.set_token_BANG_(camelot.nav.history,token);
});
camelot.nav.nav_up_url = (function camelot$nav$nav_up_url(token,levels){
if((typeof token === 'string') && (typeof levels === 'number')){
} else {
throw (new Error("Assert failed: (and (string? token) (number? levels))"));
}

var url = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__16928_SHARP_){
return clojure.string.replace(p1__16928_SHARP_,/(.*)\/.+?$/,"$1");
}),token,cljs.core.range.cljs$core$IFn$_invoke$arity$1(levels));
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(url,"/#")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(url,""))){
return "/#/organisation";
} else {
return url;
}
});
/**
 * Navigate up 1 or more levels.
 */
camelot.nav.nav_up_BANG_ = (function camelot$nav$nav_up_BANG_(var_args){
var G__16930 = arguments.length;
switch (G__16930) {
case 0:
return camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$1((1));
});

camelot.nav.nav_up_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (levels){
return camelot.nav.nav_BANG_(camelot.nav.nav_up_url(camelot.nav.get_token(),levels));
});

camelot.nav.nav_up_BANG_.cljs$lang$maxFixedArity = 1;

