// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.rest');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('camelot.util.transit');
goog.require('camelot.util.misc');
goog.require('cljs_http.client');
goog.require('om.core');
goog.require('camelot.state');
goog.require('cljs.core.async');
camelot.rest.success_status_codes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
camelot.rest._build_error = (function camelot$rest$_build_error(method,url,params,status,response){
var sep = "\n--------\n";
var req = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Requested: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" via "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(method)].join('');
var stat = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Status Code: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(status),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n")].join('');
if((status === (0))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to contact server"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(req)].join('');
} else {
if((params == null)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(response),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(stat),cljs.core.str.cljs$core$IFn$_invoke$arity$1(req)].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(response),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(stat),cljs.core.str.cljs$core$IFn$_invoke$arity$1(req),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\nWith parameters: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(params),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n")].join('');

}
}
});
camelot.rest.build_error = (function camelot$rest$build_error(var_args){
var G__17739 = arguments.length;
switch (G__17739) {
case 4:
return camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4 = (function (method,url,status,response){
return camelot.rest._build_error(method,url,null,status,response);
});

camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5 = (function (method,url,params,status,response){
return camelot.rest._build_error(method,url,params,status,response);
});

camelot.rest.build_error.cljs$lang$maxFixedArity = 5;

camelot.rest.set_error_state_BANG_ = (function camelot$rest$set_error_state_BANG_(resource,response){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.display_state(),cljs.core.cst$kw$error,camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("POST",camelot.util.misc.with_baseurl(resource),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$params_DASH_unavailable,true], null),cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(response)));
});
/**
 * Send an normal (transit-free) GET request.
 */
camelot.rest.get_x_raw = (function camelot$rest$get_x_raw(x_url,params,cb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_17765){
var state_val_17766 = (state_17765[(1)]);
if((state_val_17766 === (1))){
var inst_17741 = camelot.util.misc.with_baseurl(x_url);
var inst_17742 = cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(inst_17741,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([params], 0));
var state_17765__$1 = state_17765;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17765__$1,(2),inst_17742);
} else {
if((state_val_17766 === (2))){
var inst_17744 = (state_17765[(7)]);
var inst_17744__$1 = (state_17765[(2)]);
var inst_17745 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_17744__$1);
var inst_17746 = [inst_17745];
var inst_17747 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_17746);
var inst_17748 = cljs.core.some(inst_17747,camelot.rest.success_status_codes);
var state_17765__$1 = (function (){var statearr_17767 = state_17765;
(statearr_17767[(7)] = inst_17744__$1);

return statearr_17767;
})();
if(cljs.core.truth_(inst_17748)){
var statearr_17768_17780 = state_17765__$1;
(statearr_17768_17780[(1)] = (3));

} else {
var statearr_17769_17781 = state_17765__$1;
(statearr_17769_17781[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17766 === (3))){
var state_17765__$1 = state_17765;
if(cljs.core.truth_(cb)){
var statearr_17770_17782 = state_17765__$1;
(statearr_17770_17782[(1)] = (6));

} else {
var statearr_17771_17783 = state_17765__$1;
(statearr_17771_17783[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17766 === (4))){
var inst_17744 = (state_17765[(7)]);
var inst_17756 = camelot.state.display_state();
var inst_17757 = camelot.util.misc.with_baseurl(x_url);
var inst_17758 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_17744);
var inst_17759 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_17744);
var inst_17760 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4("GET",inst_17757,inst_17758,inst_17759);
var inst_17761 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17756,cljs.core.cst$kw$error,inst_17760);
var state_17765__$1 = state_17765;
var statearr_17772_17784 = state_17765__$1;
(statearr_17772_17784[(2)] = inst_17761);

(statearr_17772_17784[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17766 === (5))){
var inst_17763 = (state_17765[(2)]);
var state_17765__$1 = state_17765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17765__$1,inst_17763);
} else {
if((state_val_17766 === (6))){
var inst_17744 = (state_17765[(7)]);
var inst_17751 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_17744) : cb.call(null,inst_17744));
var state_17765__$1 = state_17765;
var statearr_17773_17785 = state_17765__$1;
(statearr_17773_17785[(2)] = inst_17751);

(statearr_17773_17785[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17766 === (7))){
var state_17765__$1 = state_17765;
var statearr_17774_17786 = state_17765__$1;
(statearr_17774_17786[(2)] = null);

(statearr_17774_17786[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17766 === (8))){
var inst_17754 = (state_17765[(2)]);
var state_17765__$1 = state_17765;
var statearr_17775_17787 = state_17765__$1;
(statearr_17775_17787[(2)] = inst_17754);

(statearr_17775_17787[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$get_x_raw_$_state_machine__14723__auto__ = null;
var camelot$rest$get_x_raw_$_state_machine__14723__auto____0 = (function (){
var statearr_17776 = [null,null,null,null,null,null,null,null];
(statearr_17776[(0)] = camelot$rest$get_x_raw_$_state_machine__14723__auto__);

(statearr_17776[(1)] = (1));

return statearr_17776;
});
var camelot$rest$get_x_raw_$_state_machine__14723__auto____1 = (function (state_17765){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_17765);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e17777){if((e17777 instanceof Object)){
var ex__14726__auto__ = e17777;
var statearr_17778_17788 = state_17765;
(statearr_17778_17788[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17765);

return cljs.core.cst$kw$recur;
} else {
throw e17777;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__17789 = state_17765;
state_17765 = G__17789;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$get_x_raw_$_state_machine__14723__auto__ = function(state_17765){
switch(arguments.length){
case 0:
return camelot$rest$get_x_raw_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$get_x_raw_$_state_machine__14723__auto____1.call(this,state_17765);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$get_x_raw_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$get_x_raw_$_state_machine__14723__auto____0;
camelot$rest$get_x_raw_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$get_x_raw_$_state_machine__14723__auto____1;
return camelot$rest$get_x_raw_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_17779 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_17779[(6)] = c__14822__auto__);

return statearr_17779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});
/**
 * Make a request via GET.
 */
camelot.rest.get_x = (function camelot$rest$get_x(var_args){
var G__17791 = arguments.length;
switch (G__17791) {
case 2:
return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2 = (function (x_url,cb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_17816){
var state_val_17817 = (state_17816[(1)]);
if((state_val_17817 === (1))){
var inst_17792 = camelot.util.misc.with_baseurl(x_url);
var inst_17793 = camelot.util.transit.request(cljs_http.client.get,inst_17792,null);
var state_17816__$1 = state_17816;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17816__$1,(2),inst_17793);
} else {
if((state_val_17817 === (2))){
var inst_17795 = (state_17816[(7)]);
var inst_17795__$1 = (state_17816[(2)]);
var inst_17796 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_17795__$1);
var inst_17797 = [inst_17796];
var inst_17798 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_17797);
var inst_17799 = cljs.core.some(inst_17798,camelot.rest.success_status_codes);
var state_17816__$1 = (function (){var statearr_17818 = state_17816;
(statearr_17818[(7)] = inst_17795__$1);

return statearr_17818;
})();
if(cljs.core.truth_(inst_17799)){
var statearr_17819_17871 = state_17816__$1;
(statearr_17819_17871[(1)] = (3));

} else {
var statearr_17820_17872 = state_17816__$1;
(statearr_17820_17872[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17817 === (3))){
var state_17816__$1 = state_17816;
if(cljs.core.truth_(cb)){
var statearr_17821_17873 = state_17816__$1;
(statearr_17821_17873[(1)] = (6));

} else {
var statearr_17822_17874 = state_17816__$1;
(statearr_17822_17874[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17817 === (4))){
var inst_17795 = (state_17816[(7)]);
var inst_17807 = camelot.state.display_state();
var inst_17808 = camelot.util.misc.with_baseurl(x_url);
var inst_17809 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_17795);
var inst_17810 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_17795);
var inst_17811 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4("GET",inst_17808,inst_17809,inst_17810);
var inst_17812 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17807,cljs.core.cst$kw$error,inst_17811);
var state_17816__$1 = state_17816;
var statearr_17823_17875 = state_17816__$1;
(statearr_17823_17875[(2)] = inst_17812);

(statearr_17823_17875[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17817 === (5))){
var inst_17814 = (state_17816[(2)]);
var state_17816__$1 = state_17816;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17816__$1,inst_17814);
} else {
if((state_val_17817 === (6))){
var inst_17795 = (state_17816[(7)]);
var inst_17802 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_17795) : cb.call(null,inst_17795));
var state_17816__$1 = state_17816;
var statearr_17824_17876 = state_17816__$1;
(statearr_17824_17876[(2)] = inst_17802);

(statearr_17824_17876[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17817 === (7))){
var state_17816__$1 = state_17816;
var statearr_17825_17877 = state_17816__$1;
(statearr_17825_17877[(2)] = null);

(statearr_17825_17877[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17817 === (8))){
var inst_17805 = (state_17816[(2)]);
var state_17816__$1 = state_17816;
var statearr_17826_17878 = state_17816__$1;
(statearr_17826_17878[(2)] = inst_17805);

(statearr_17826_17878[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$state_machine__14723__auto__ = null;
var camelot$rest$state_machine__14723__auto____0 = (function (){
var statearr_17827 = [null,null,null,null,null,null,null,null];
(statearr_17827[(0)] = camelot$rest$state_machine__14723__auto__);

(statearr_17827[(1)] = (1));

return statearr_17827;
});
var camelot$rest$state_machine__14723__auto____1 = (function (state_17816){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_17816);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e17828){if((e17828 instanceof Object)){
var ex__14726__auto__ = e17828;
var statearr_17829_17879 = state_17816;
(statearr_17829_17879[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17816);

return cljs.core.cst$kw$recur;
} else {
throw e17828;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__17880 = state_17816;
state_17816 = G__17880;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$state_machine__14723__auto__ = function(state_17816){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$state_machine__14723__auto____1.call(this,state_17816);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__14723__auto____0;
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__14723__auto____1;
return camelot$rest$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_17830 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_17830[(6)] = c__14822__auto__);

return statearr_17830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});

camelot.rest.get_x.cljs$core$IFn$_invoke$arity$3 = (function (x_url,params,cb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_17855){
var state_val_17856 = (state_17855[(1)]);
if((state_val_17856 === (1))){
var inst_17831 = camelot.util.misc.with_baseurl(x_url);
var inst_17832 = camelot.util.transit.request(cljs_http.client.get,inst_17831,params);
var state_17855__$1 = state_17855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17855__$1,(2),inst_17832);
} else {
if((state_val_17856 === (2))){
var inst_17834 = (state_17855[(7)]);
var inst_17834__$1 = (state_17855[(2)]);
var inst_17835 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_17834__$1);
var inst_17836 = [inst_17835];
var inst_17837 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_17836);
var inst_17838 = cljs.core.some(inst_17837,camelot.rest.success_status_codes);
var state_17855__$1 = (function (){var statearr_17857 = state_17855;
(statearr_17857[(7)] = inst_17834__$1);

return statearr_17857;
})();
if(cljs.core.truth_(inst_17838)){
var statearr_17858_17881 = state_17855__$1;
(statearr_17858_17881[(1)] = (3));

} else {
var statearr_17859_17882 = state_17855__$1;
(statearr_17859_17882[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17856 === (3))){
var state_17855__$1 = state_17855;
if(cljs.core.truth_(cb)){
var statearr_17860_17883 = state_17855__$1;
(statearr_17860_17883[(1)] = (6));

} else {
var statearr_17861_17884 = state_17855__$1;
(statearr_17861_17884[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17856 === (4))){
var inst_17834 = (state_17855[(7)]);
var inst_17846 = camelot.state.display_state();
var inst_17847 = camelot.util.misc.with_baseurl(x_url);
var inst_17848 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_17834);
var inst_17849 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_17834);
var inst_17850 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4("GET",inst_17847,inst_17848,inst_17849);
var inst_17851 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17846,cljs.core.cst$kw$error,inst_17850);
var state_17855__$1 = state_17855;
var statearr_17862_17885 = state_17855__$1;
(statearr_17862_17885[(2)] = inst_17851);

(statearr_17862_17885[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17856 === (5))){
var inst_17853 = (state_17855[(2)]);
var state_17855__$1 = state_17855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17855__$1,inst_17853);
} else {
if((state_val_17856 === (6))){
var inst_17834 = (state_17855[(7)]);
var inst_17841 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_17834) : cb.call(null,inst_17834));
var state_17855__$1 = state_17855;
var statearr_17863_17886 = state_17855__$1;
(statearr_17863_17886[(2)] = inst_17841);

(statearr_17863_17886[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17856 === (7))){
var state_17855__$1 = state_17855;
var statearr_17864_17887 = state_17855__$1;
(statearr_17864_17887[(2)] = null);

(statearr_17864_17887[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17856 === (8))){
var inst_17844 = (state_17855[(2)]);
var state_17855__$1 = state_17855;
var statearr_17865_17888 = state_17855__$1;
(statearr_17865_17888[(2)] = inst_17844);

(statearr_17865_17888[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$state_machine__14723__auto__ = null;
var camelot$rest$state_machine__14723__auto____0 = (function (){
var statearr_17866 = [null,null,null,null,null,null,null,null];
(statearr_17866[(0)] = camelot$rest$state_machine__14723__auto__);

(statearr_17866[(1)] = (1));

return statearr_17866;
});
var camelot$rest$state_machine__14723__auto____1 = (function (state_17855){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_17855);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e17867){if((e17867 instanceof Object)){
var ex__14726__auto__ = e17867;
var statearr_17868_17889 = state_17855;
(statearr_17868_17889[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17855);

return cljs.core.cst$kw$recur;
} else {
throw e17867;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__17890 = state_17855;
state_17855 = G__17890;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$state_machine__14723__auto__ = function(state_17855){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$state_machine__14723__auto____1.call(this,state_17855);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__14723__auto____0;
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__14723__auto____1;
return camelot$rest$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_17869 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_17869[(6)] = c__14822__auto__);

return statearr_17869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});

camelot.rest.get_x.cljs$lang$maxFixedArity = 3;

/**
 * POST state
 */
camelot.rest.get_x_opts = (function camelot$rest$get_x_opts(resource,p__17891){
var map__17892 = p__17891;
var map__17892__$1 = ((((!((map__17892 == null)))?((((map__17892.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17892.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17892):map__17892);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17892__$1,cljs.core.cst$kw$params);
var success = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17892__$1,cljs.core.cst$kw$success);
var failure = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17892__$1,cljs.core.cst$kw$failure);
var suppress_error_dialog = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17892__$1,cljs.core.cst$kw$suppress_DASH_error_DASH_dialog);
var always = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17892__$1,cljs.core.cst$kw$always);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,map__17892,map__17892__$1,params,success,failure,suppress_error_dialog,always){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,map__17892,map__17892__$1,params,success,failure,suppress_error_dialog,always){
return (function (state_17932){
var state_val_17933 = (state_17932[(1)]);
if((state_val_17933 === (7))){
var state_17932__$1 = state_17932;
var statearr_17934_17961 = state_17932__$1;
(statearr_17934_17961[(2)] = null);

(statearr_17934_17961[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (1))){
var inst_17894 = camelot.util.misc.with_baseurl(resource);
var inst_17895 = camelot.util.transit.request(cljs_http.client.get,inst_17894,params);
var state_17932__$1 = state_17932;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17932__$1,(2),inst_17895);
} else {
if((state_val_17933 === (4))){
var state_17932__$1 = state_17932;
if(cljs.core.truth_(failure)){
var statearr_17935_17962 = state_17932__$1;
(statearr_17935_17962[(1)] = (9));

} else {
var statearr_17936_17963 = state_17932__$1;
(statearr_17936_17963[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (15))){
var inst_17897 = (state_17932[(7)]);
var inst_17927 = (always.cljs$core$IFn$_invoke$arity$1 ? always.cljs$core$IFn$_invoke$arity$1(inst_17897) : always.call(null,inst_17897));
var state_17932__$1 = state_17932;
var statearr_17937_17964 = state_17932__$1;
(statearr_17937_17964[(2)] = inst_17927);

(statearr_17937_17964[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (13))){
var inst_17897 = (state_17932[(7)]);
var inst_17916 = camelot.state.display_state();
var inst_17917 = camelot.util.misc.with_baseurl(resource);
var inst_17918 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_17897);
var inst_17919 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_17897);
var inst_17920 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("GET",inst_17917,params,inst_17918,inst_17919);
var inst_17921 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17916,cljs.core.cst$kw$error,inst_17920);
var state_17932__$1 = state_17932;
var statearr_17938_17965 = state_17932__$1;
(statearr_17938_17965[(2)] = inst_17921);

(statearr_17938_17965[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (6))){
var inst_17897 = (state_17932[(7)]);
var inst_17904 = (success.cljs$core$IFn$_invoke$arity$1 ? success.cljs$core$IFn$_invoke$arity$1(inst_17897) : success.call(null,inst_17897));
var state_17932__$1 = state_17932;
var statearr_17939_17966 = state_17932__$1;
(statearr_17939_17966[(2)] = inst_17904);

(statearr_17939_17966[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (17))){
var inst_17930 = (state_17932[(2)]);
var state_17932__$1 = state_17932;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17932__$1,inst_17930);
} else {
if((state_val_17933 === (3))){
var state_17932__$1 = state_17932;
if(cljs.core.truth_(success)){
var statearr_17940_17967 = state_17932__$1;
(statearr_17940_17967[(1)] = (6));

} else {
var statearr_17941_17968 = state_17932__$1;
(statearr_17941_17968[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (12))){
var state_17932__$1 = state_17932;
var statearr_17942_17969 = state_17932__$1;
(statearr_17942_17969[(2)] = null);

(statearr_17942_17969[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (2))){
var inst_17897 = (state_17932[(7)]);
var inst_17897__$1 = (state_17932[(2)]);
var inst_17898 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_17897__$1);
var inst_17899 = [inst_17898];
var inst_17900 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_17899);
var inst_17901 = cljs.core.some(inst_17900,camelot.rest.success_status_codes);
var state_17932__$1 = (function (){var statearr_17943 = state_17932;
(statearr_17943[(7)] = inst_17897__$1);

return statearr_17943;
})();
if(cljs.core.truth_(inst_17901)){
var statearr_17944_17970 = state_17932__$1;
(statearr_17944_17970[(1)] = (3));

} else {
var statearr_17945_17971 = state_17932__$1;
(statearr_17945_17971[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (11))){
var inst_17913 = (state_17932[(2)]);
var state_17932__$1 = (function (){var statearr_17946 = state_17932;
(statearr_17946[(8)] = inst_17913);

return statearr_17946;
})();
if(cljs.core.truth_(suppress_error_dialog)){
var statearr_17947_17972 = state_17932__$1;
(statearr_17947_17972[(1)] = (12));

} else {
var statearr_17948_17973 = state_17932__$1;
(statearr_17948_17973[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (9))){
var inst_17897 = (state_17932[(7)]);
var inst_17910 = (failure.cljs$core$IFn$_invoke$arity$1 ? failure.cljs$core$IFn$_invoke$arity$1(inst_17897) : failure.call(null,inst_17897));
var state_17932__$1 = state_17932;
var statearr_17949_17974 = state_17932__$1;
(statearr_17949_17974[(2)] = inst_17910);

(statearr_17949_17974[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (5))){
var inst_17925 = (state_17932[(2)]);
var state_17932__$1 = (function (){var statearr_17950 = state_17932;
(statearr_17950[(9)] = inst_17925);

return statearr_17950;
})();
if(cljs.core.truth_(always)){
var statearr_17951_17975 = state_17932__$1;
(statearr_17951_17975[(1)] = (15));

} else {
var statearr_17952_17976 = state_17932__$1;
(statearr_17952_17976[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (14))){
var inst_17923 = (state_17932[(2)]);
var state_17932__$1 = state_17932;
var statearr_17953_17977 = state_17932__$1;
(statearr_17953_17977[(2)] = inst_17923);

(statearr_17953_17977[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (16))){
var state_17932__$1 = state_17932;
var statearr_17954_17978 = state_17932__$1;
(statearr_17954_17978[(2)] = null);

(statearr_17954_17978[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (10))){
var state_17932__$1 = state_17932;
var statearr_17955_17979 = state_17932__$1;
(statearr_17955_17979[(2)] = null);

(statearr_17955_17979[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17933 === (8))){
var inst_17907 = (state_17932[(2)]);
var state_17932__$1 = state_17932;
var statearr_17956_17980 = state_17932__$1;
(statearr_17956_17980[(2)] = inst_17907);

(statearr_17956_17980[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__,map__17892,map__17892__$1,params,success,failure,suppress_error_dialog,always))
;
return ((function (switch__14722__auto__,c__14822__auto__,map__17892,map__17892__$1,params,success,failure,suppress_error_dialog,always){
return (function() {
var camelot$rest$get_x_opts_$_state_machine__14723__auto__ = null;
var camelot$rest$get_x_opts_$_state_machine__14723__auto____0 = (function (){
var statearr_17957 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17957[(0)] = camelot$rest$get_x_opts_$_state_machine__14723__auto__);

(statearr_17957[(1)] = (1));

return statearr_17957;
});
var camelot$rest$get_x_opts_$_state_machine__14723__auto____1 = (function (state_17932){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_17932);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e17958){if((e17958 instanceof Object)){
var ex__14726__auto__ = e17958;
var statearr_17959_17981 = state_17932;
(statearr_17959_17981[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17932);

return cljs.core.cst$kw$recur;
} else {
throw e17958;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__17982 = state_17932;
state_17932 = G__17982;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$get_x_opts_$_state_machine__14723__auto__ = function(state_17932){
switch(arguments.length){
case 0:
return camelot$rest$get_x_opts_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$get_x_opts_$_state_machine__14723__auto____1.call(this,state_17932);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$get_x_opts_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$get_x_opts_$_state_machine__14723__auto____0;
camelot$rest$get_x_opts_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$get_x_opts_$_state_machine__14723__auto____1;
return camelot$rest$get_x_opts_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,map__17892,map__17892__$1,params,success,failure,suppress_error_dialog,always))
})();
var state__14824__auto__ = (function (){var statearr_17960 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_17960[(6)] = c__14822__auto__);

return statearr_17960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,map__17892,map__17892__$1,params,success,failure,suppress_error_dialog,always))
);

return c__14822__auto__;
});
/**
 * Make a request via DELETE.
 */
camelot.rest.delete_x = (function camelot$rest$delete_x(var_args){
var G__17984 = arguments.length;
switch (G__17984) {
case 2:
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$2 = (function (x_url,cb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_18009){
var state_val_18010 = (state_18009[(1)]);
if((state_val_18010 === (1))){
var inst_17985 = camelot.util.misc.with_baseurl(x_url);
var inst_17986 = camelot.util.transit.request(cljs_http.client.delete$,inst_17985,null);
var state_18009__$1 = state_18009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18009__$1,(2),inst_17986);
} else {
if((state_val_18010 === (2))){
var inst_17988 = (state_18009[(7)]);
var inst_17988__$1 = (state_18009[(2)]);
var inst_17989 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_17988__$1);
var inst_17990 = [inst_17989];
var inst_17991 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_17990);
var inst_17992 = cljs.core.some(inst_17991,camelot.rest.success_status_codes);
var state_18009__$1 = (function (){var statearr_18011 = state_18009;
(statearr_18011[(7)] = inst_17988__$1);

return statearr_18011;
})();
if(cljs.core.truth_(inst_17992)){
var statearr_18012_18064 = state_18009__$1;
(statearr_18012_18064[(1)] = (3));

} else {
var statearr_18013_18065 = state_18009__$1;
(statearr_18013_18065[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18010 === (3))){
var state_18009__$1 = state_18009;
if(cljs.core.truth_(cb)){
var statearr_18014_18066 = state_18009__$1;
(statearr_18014_18066[(1)] = (6));

} else {
var statearr_18015_18067 = state_18009__$1;
(statearr_18015_18067[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18010 === (4))){
var inst_17988 = (state_18009[(7)]);
var inst_18000 = camelot.state.display_state();
var inst_18001 = camelot.util.misc.with_baseurl(x_url);
var inst_18002 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_17988);
var inst_18003 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_17988);
var inst_18004 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4("DELETE",inst_18001,inst_18002,inst_18003);
var inst_18005 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18000,cljs.core.cst$kw$error,inst_18004);
var state_18009__$1 = state_18009;
var statearr_18016_18068 = state_18009__$1;
(statearr_18016_18068[(2)] = inst_18005);

(statearr_18016_18068[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18010 === (5))){
var inst_18007 = (state_18009[(2)]);
var state_18009__$1 = state_18009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18009__$1,inst_18007);
} else {
if((state_val_18010 === (6))){
var inst_17988 = (state_18009[(7)]);
var inst_17995 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_17988) : cb.call(null,inst_17988));
var state_18009__$1 = state_18009;
var statearr_18017_18069 = state_18009__$1;
(statearr_18017_18069[(2)] = inst_17995);

(statearr_18017_18069[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18010 === (7))){
var state_18009__$1 = state_18009;
var statearr_18018_18070 = state_18009__$1;
(statearr_18018_18070[(2)] = null);

(statearr_18018_18070[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18010 === (8))){
var inst_17998 = (state_18009[(2)]);
var state_18009__$1 = state_18009;
var statearr_18019_18071 = state_18009__$1;
(statearr_18019_18071[(2)] = inst_17998);

(statearr_18019_18071[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$state_machine__14723__auto__ = null;
var camelot$rest$state_machine__14723__auto____0 = (function (){
var statearr_18020 = [null,null,null,null,null,null,null,null];
(statearr_18020[(0)] = camelot$rest$state_machine__14723__auto__);

(statearr_18020[(1)] = (1));

return statearr_18020;
});
var camelot$rest$state_machine__14723__auto____1 = (function (state_18009){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_18009);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e18021){if((e18021 instanceof Object)){
var ex__14726__auto__ = e18021;
var statearr_18022_18072 = state_18009;
(statearr_18022_18072[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18009);

return cljs.core.cst$kw$recur;
} else {
throw e18021;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__18073 = state_18009;
state_18009 = G__18073;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$state_machine__14723__auto__ = function(state_18009){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$state_machine__14723__auto____1.call(this,state_18009);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__14723__auto____0;
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__14723__auto____1;
return camelot$rest$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_18023 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_18023[(6)] = c__14822__auto__);

return statearr_18023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});

camelot.rest.delete_x.cljs$core$IFn$_invoke$arity$3 = (function (x_url,params,cb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_18048){
var state_val_18049 = (state_18048[(1)]);
if((state_val_18049 === (1))){
var inst_18024 = camelot.util.misc.with_baseurl(x_url);
var inst_18025 = camelot.util.transit.request(cljs_http.client.delete$,inst_18024,params);
var state_18048__$1 = state_18048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18048__$1,(2),inst_18025);
} else {
if((state_val_18049 === (2))){
var inst_18027 = (state_18048[(7)]);
var inst_18027__$1 = (state_18048[(2)]);
var inst_18028 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18027__$1);
var inst_18029 = [inst_18028];
var inst_18030 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_18029);
var inst_18031 = cljs.core.some(inst_18030,camelot.rest.success_status_codes);
var state_18048__$1 = (function (){var statearr_18050 = state_18048;
(statearr_18050[(7)] = inst_18027__$1);

return statearr_18050;
})();
if(cljs.core.truth_(inst_18031)){
var statearr_18051_18074 = state_18048__$1;
(statearr_18051_18074[(1)] = (3));

} else {
var statearr_18052_18075 = state_18048__$1;
(statearr_18052_18075[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18049 === (3))){
var state_18048__$1 = state_18048;
if(cljs.core.truth_(cb)){
var statearr_18053_18076 = state_18048__$1;
(statearr_18053_18076[(1)] = (6));

} else {
var statearr_18054_18077 = state_18048__$1;
(statearr_18054_18077[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18049 === (4))){
var inst_18027 = (state_18048[(7)]);
var inst_18039 = camelot.state.display_state();
var inst_18040 = camelot.util.misc.with_baseurl(x_url);
var inst_18041 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18027);
var inst_18042 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_18027);
var inst_18043 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("DELETE",inst_18040,params,inst_18041,inst_18042);
var inst_18044 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18039,cljs.core.cst$kw$error,inst_18043);
var state_18048__$1 = state_18048;
var statearr_18055_18078 = state_18048__$1;
(statearr_18055_18078[(2)] = inst_18044);

(statearr_18055_18078[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18049 === (5))){
var inst_18046 = (state_18048[(2)]);
var state_18048__$1 = state_18048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18048__$1,inst_18046);
} else {
if((state_val_18049 === (6))){
var inst_18027 = (state_18048[(7)]);
var inst_18034 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_18027) : cb.call(null,inst_18027));
var state_18048__$1 = state_18048;
var statearr_18056_18079 = state_18048__$1;
(statearr_18056_18079[(2)] = inst_18034);

(statearr_18056_18079[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18049 === (7))){
var state_18048__$1 = state_18048;
var statearr_18057_18080 = state_18048__$1;
(statearr_18057_18080[(2)] = null);

(statearr_18057_18080[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18049 === (8))){
var inst_18037 = (state_18048[(2)]);
var state_18048__$1 = state_18048;
var statearr_18058_18081 = state_18048__$1;
(statearr_18058_18081[(2)] = inst_18037);

(statearr_18058_18081[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$state_machine__14723__auto__ = null;
var camelot$rest$state_machine__14723__auto____0 = (function (){
var statearr_18059 = [null,null,null,null,null,null,null,null];
(statearr_18059[(0)] = camelot$rest$state_machine__14723__auto__);

(statearr_18059[(1)] = (1));

return statearr_18059;
});
var camelot$rest$state_machine__14723__auto____1 = (function (state_18048){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_18048);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e18060){if((e18060 instanceof Object)){
var ex__14726__auto__ = e18060;
var statearr_18061_18082 = state_18048;
(statearr_18061_18082[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18048);

return cljs.core.cst$kw$recur;
} else {
throw e18060;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__18083 = state_18048;
state_18048 = G__18083;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$state_machine__14723__auto__ = function(state_18048){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$state_machine__14723__auto____1.call(this,state_18048);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__14723__auto____0;
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__14723__auto____1;
return camelot$rest$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_18062 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_18062[(6)] = c__14822__auto__);

return statearr_18062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});

camelot.rest.delete_x.cljs$lang$maxFixedArity = 3;

/**
 * POST state
 */
camelot.rest.post_x_opts = (function camelot$rest$post_x_opts(resource,params,p__18084){
var map__18085 = p__18084;
var map__18085__$1 = ((((!((map__18085 == null)))?((((map__18085.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18085.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18085):map__18085);
var success = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18085__$1,cljs.core.cst$kw$success);
var failure = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18085__$1,cljs.core.cst$kw$failure);
var suppress_error_dialog = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18085__$1,cljs.core.cst$kw$suppress_DASH_error_DASH_dialog);
var always = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18085__$1,cljs.core.cst$kw$always);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,map__18085,map__18085__$1,success,failure,suppress_error_dialog,always){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,map__18085,map__18085__$1,success,failure,suppress_error_dialog,always){
return (function (state_18128){
var state_val_18129 = (state_18128[(1)]);
if((state_val_18129 === (7))){
var state_18128__$1 = state_18128;
var statearr_18130_18157 = state_18128__$1;
(statearr_18130_18157[(2)] = null);

(statearr_18130_18157[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (1))){
var inst_18087 = camelot.util.misc.with_baseurl(resource);
var inst_18088 = [cljs.core.cst$kw$data];
var inst_18089 = [params];
var inst_18090 = cljs.core.PersistentHashMap.fromArrays(inst_18088,inst_18089);
var inst_18091 = camelot.util.transit.request(cljs_http.client.post,inst_18087,inst_18090);
var state_18128__$1 = state_18128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18128__$1,(2),inst_18091);
} else {
if((state_val_18129 === (4))){
var state_18128__$1 = state_18128;
if(cljs.core.truth_(failure)){
var statearr_18131_18158 = state_18128__$1;
(statearr_18131_18158[(1)] = (9));

} else {
var statearr_18132_18159 = state_18128__$1;
(statearr_18132_18159[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (15))){
var inst_18093 = (state_18128[(7)]);
var inst_18123 = (always.cljs$core$IFn$_invoke$arity$1 ? always.cljs$core$IFn$_invoke$arity$1(inst_18093) : always.call(null,inst_18093));
var state_18128__$1 = state_18128;
var statearr_18133_18160 = state_18128__$1;
(statearr_18133_18160[(2)] = inst_18123);

(statearr_18133_18160[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (13))){
var inst_18093 = (state_18128[(7)]);
var inst_18112 = camelot.state.display_state();
var inst_18113 = camelot.util.misc.with_baseurl(resource);
var inst_18114 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18093);
var inst_18115 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_18093);
var inst_18116 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("POST",inst_18113,params,inst_18114,inst_18115);
var inst_18117 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18112,cljs.core.cst$kw$error,inst_18116);
var state_18128__$1 = state_18128;
var statearr_18134_18161 = state_18128__$1;
(statearr_18134_18161[(2)] = inst_18117);

(statearr_18134_18161[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (6))){
var inst_18093 = (state_18128[(7)]);
var inst_18100 = (success.cljs$core$IFn$_invoke$arity$1 ? success.cljs$core$IFn$_invoke$arity$1(inst_18093) : success.call(null,inst_18093));
var state_18128__$1 = state_18128;
var statearr_18135_18162 = state_18128__$1;
(statearr_18135_18162[(2)] = inst_18100);

(statearr_18135_18162[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (17))){
var inst_18126 = (state_18128[(2)]);
var state_18128__$1 = state_18128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18128__$1,inst_18126);
} else {
if((state_val_18129 === (3))){
var state_18128__$1 = state_18128;
if(cljs.core.truth_(success)){
var statearr_18136_18163 = state_18128__$1;
(statearr_18136_18163[(1)] = (6));

} else {
var statearr_18137_18164 = state_18128__$1;
(statearr_18137_18164[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (12))){
var state_18128__$1 = state_18128;
var statearr_18138_18165 = state_18128__$1;
(statearr_18138_18165[(2)] = null);

(statearr_18138_18165[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (2))){
var inst_18093 = (state_18128[(7)]);
var inst_18093__$1 = (state_18128[(2)]);
var inst_18094 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18093__$1);
var inst_18095 = [inst_18094];
var inst_18096 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_18095);
var inst_18097 = cljs.core.some(inst_18096,camelot.rest.success_status_codes);
var state_18128__$1 = (function (){var statearr_18139 = state_18128;
(statearr_18139[(7)] = inst_18093__$1);

return statearr_18139;
})();
if(cljs.core.truth_(inst_18097)){
var statearr_18140_18166 = state_18128__$1;
(statearr_18140_18166[(1)] = (3));

} else {
var statearr_18141_18167 = state_18128__$1;
(statearr_18141_18167[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (11))){
var inst_18109 = (state_18128[(2)]);
var state_18128__$1 = (function (){var statearr_18142 = state_18128;
(statearr_18142[(8)] = inst_18109);

return statearr_18142;
})();
if(cljs.core.truth_(suppress_error_dialog)){
var statearr_18143_18168 = state_18128__$1;
(statearr_18143_18168[(1)] = (12));

} else {
var statearr_18144_18169 = state_18128__$1;
(statearr_18144_18169[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (9))){
var inst_18093 = (state_18128[(7)]);
var inst_18106 = (failure.cljs$core$IFn$_invoke$arity$1 ? failure.cljs$core$IFn$_invoke$arity$1(inst_18093) : failure.call(null,inst_18093));
var state_18128__$1 = state_18128;
var statearr_18145_18170 = state_18128__$1;
(statearr_18145_18170[(2)] = inst_18106);

(statearr_18145_18170[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (5))){
var inst_18121 = (state_18128[(2)]);
var state_18128__$1 = (function (){var statearr_18146 = state_18128;
(statearr_18146[(9)] = inst_18121);

return statearr_18146;
})();
if(cljs.core.truth_(always)){
var statearr_18147_18171 = state_18128__$1;
(statearr_18147_18171[(1)] = (15));

} else {
var statearr_18148_18172 = state_18128__$1;
(statearr_18148_18172[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (14))){
var inst_18119 = (state_18128[(2)]);
var state_18128__$1 = state_18128;
var statearr_18149_18173 = state_18128__$1;
(statearr_18149_18173[(2)] = inst_18119);

(statearr_18149_18173[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (16))){
var state_18128__$1 = state_18128;
var statearr_18150_18174 = state_18128__$1;
(statearr_18150_18174[(2)] = null);

(statearr_18150_18174[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (10))){
var state_18128__$1 = state_18128;
var statearr_18151_18175 = state_18128__$1;
(statearr_18151_18175[(2)] = null);

(statearr_18151_18175[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18129 === (8))){
var inst_18103 = (state_18128[(2)]);
var state_18128__$1 = state_18128;
var statearr_18152_18176 = state_18128__$1;
(statearr_18152_18176[(2)] = inst_18103);

(statearr_18152_18176[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__,map__18085,map__18085__$1,success,failure,suppress_error_dialog,always))
;
return ((function (switch__14722__auto__,c__14822__auto__,map__18085,map__18085__$1,success,failure,suppress_error_dialog,always){
return (function() {
var camelot$rest$post_x_opts_$_state_machine__14723__auto__ = null;
var camelot$rest$post_x_opts_$_state_machine__14723__auto____0 = (function (){
var statearr_18153 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18153[(0)] = camelot$rest$post_x_opts_$_state_machine__14723__auto__);

(statearr_18153[(1)] = (1));

return statearr_18153;
});
var camelot$rest$post_x_opts_$_state_machine__14723__auto____1 = (function (state_18128){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_18128);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e18154){if((e18154 instanceof Object)){
var ex__14726__auto__ = e18154;
var statearr_18155_18177 = state_18128;
(statearr_18155_18177[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18128);

return cljs.core.cst$kw$recur;
} else {
throw e18154;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__18178 = state_18128;
state_18128 = G__18178;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$post_x_opts_$_state_machine__14723__auto__ = function(state_18128){
switch(arguments.length){
case 0:
return camelot$rest$post_x_opts_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$post_x_opts_$_state_machine__14723__auto____1.call(this,state_18128);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$post_x_opts_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$post_x_opts_$_state_machine__14723__auto____0;
camelot$rest$post_x_opts_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$post_x_opts_$_state_machine__14723__auto____1;
return camelot$rest$post_x_opts_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,map__18085,map__18085__$1,success,failure,suppress_error_dialog,always))
})();
var state__14824__auto__ = (function (){var statearr_18156 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_18156[(6)] = c__14822__auto__);

return statearr_18156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,map__18085,map__18085__$1,success,failure,suppress_error_dialog,always))
);

return c__14822__auto__;
});
/**
 * POST state
 */
camelot.rest.post_x = (function camelot$rest$post_x(var_args){
var G__18180 = arguments.length;
switch (G__18180) {
case 3:
return camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return camelot.rest.post_x.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

camelot.rest.post_x.cljs$core$IFn$_invoke$arity$3 = (function (resource,params,cb){
return camelot.rest.post_x_opts(resource,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(params),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$success,cb], null));
});

camelot.rest.post_x.cljs$core$IFn$_invoke$arity$4 = (function (resource,params,cb,failcb){
return camelot.rest.post_x_opts(resource,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(params),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$success,cb,cljs.core.cst$kw$failure,failcb,cljs.core.cst$kw$suppress_DASH_error_DASH_dialog,true], null));
});

camelot.rest.post_x.cljs$lang$maxFixedArity = 4;

/**
 * POST state
 */
camelot.rest.post_x_raw = (function camelot$rest$post_x_raw(var_args){
var G__18183 = arguments.length;
switch (G__18183) {
case 3:
return camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$3 = (function (resource,params,cb){
return camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$4(resource,params,cb,null);
});

camelot.rest.post_x_raw.cljs$core$IFn$_invoke$arity$4 = (function (resource,params,cb,failcb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_18216){
var state_val_18217 = (state_18216[(1)]);
if((state_val_18217 === (7))){
var state_18216__$1 = state_18216;
var statearr_18218_18236 = state_18216__$1;
(statearr_18218_18236[(2)] = null);

(statearr_18218_18236[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18217 === (1))){
var inst_18184 = camelot.util.misc.with_baseurl(resource);
var inst_18185 = [cljs.core.cst$kw$multipart_DASH_params];
var inst_18186 = [params];
var inst_18187 = cljs.core.PersistentHashMap.fromArrays(inst_18185,inst_18186);
var inst_18188 = cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(inst_18184,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_18187], 0));
var state_18216__$1 = state_18216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18216__$1,(2),inst_18188);
} else {
if((state_val_18217 === (4))){
var state_18216__$1 = state_18216;
if(cljs.core.truth_(failcb)){
var statearr_18219_18237 = state_18216__$1;
(statearr_18219_18237[(1)] = (9));

} else {
var statearr_18220_18238 = state_18216__$1;
(statearr_18220_18238[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18217 === (6))){
var inst_18190 = (state_18216[(7)]);
var inst_18197 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_18190) : cb.call(null,inst_18190));
var state_18216__$1 = state_18216;
var statearr_18221_18239 = state_18216__$1;
(statearr_18221_18239[(2)] = inst_18197);

(statearr_18221_18239[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18217 === (3))){
var state_18216__$1 = state_18216;
if(cljs.core.truth_(cb)){
var statearr_18222_18240 = state_18216__$1;
(statearr_18222_18240[(1)] = (6));

} else {
var statearr_18223_18241 = state_18216__$1;
(statearr_18223_18241[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18217 === (2))){
var inst_18190 = (state_18216[(7)]);
var inst_18190__$1 = (state_18216[(2)]);
var inst_18191 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18190__$1);
var inst_18192 = [inst_18191];
var inst_18193 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_18192);
var inst_18194 = cljs.core.some(inst_18193,camelot.rest.success_status_codes);
var state_18216__$1 = (function (){var statearr_18224 = state_18216;
(statearr_18224[(7)] = inst_18190__$1);

return statearr_18224;
})();
if(cljs.core.truth_(inst_18194)){
var statearr_18225_18242 = state_18216__$1;
(statearr_18225_18242[(1)] = (3));

} else {
var statearr_18226_18243 = state_18216__$1;
(statearr_18226_18243[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18217 === (11))){
var inst_18212 = (state_18216[(2)]);
var state_18216__$1 = state_18216;
var statearr_18227_18244 = state_18216__$1;
(statearr_18227_18244[(2)] = inst_18212);

(statearr_18227_18244[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18217 === (9))){
var inst_18203 = (failcb.cljs$core$IFn$_invoke$arity$0 ? failcb.cljs$core$IFn$_invoke$arity$0() : failcb.call(null));
var state_18216__$1 = state_18216;
var statearr_18228_18245 = state_18216__$1;
(statearr_18228_18245[(2)] = inst_18203);

(statearr_18228_18245[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18217 === (5))){
var inst_18214 = (state_18216[(2)]);
var state_18216__$1 = state_18216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18216__$1,inst_18214);
} else {
if((state_val_18217 === (10))){
var inst_18190 = (state_18216[(7)]);
var inst_18205 = camelot.state.display_state();
var inst_18206 = camelot.util.misc.with_baseurl(resource);
var inst_18207 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18190);
var inst_18208 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_18190);
var inst_18209 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("POST",inst_18206,params,inst_18207,inst_18208);
var inst_18210 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18205,cljs.core.cst$kw$error,inst_18209);
var state_18216__$1 = state_18216;
var statearr_18229_18246 = state_18216__$1;
(statearr_18229_18246[(2)] = inst_18210);

(statearr_18229_18246[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18217 === (8))){
var inst_18200 = (state_18216[(2)]);
var state_18216__$1 = state_18216;
var statearr_18230_18247 = state_18216__$1;
(statearr_18230_18247[(2)] = inst_18200);

(statearr_18230_18247[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$state_machine__14723__auto__ = null;
var camelot$rest$state_machine__14723__auto____0 = (function (){
var statearr_18231 = [null,null,null,null,null,null,null,null];
(statearr_18231[(0)] = camelot$rest$state_machine__14723__auto__);

(statearr_18231[(1)] = (1));

return statearr_18231;
});
var camelot$rest$state_machine__14723__auto____1 = (function (state_18216){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_18216);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e18232){if((e18232 instanceof Object)){
var ex__14726__auto__ = e18232;
var statearr_18233_18248 = state_18216;
(statearr_18233_18248[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18216);

return cljs.core.cst$kw$recur;
} else {
throw e18232;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__18249 = state_18216;
state_18216 = G__18249;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$state_machine__14723__auto__ = function(state_18216){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$state_machine__14723__auto____1.call(this,state_18216);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__14723__auto____0;
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__14723__auto____1;
return camelot$rest$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_18234 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_18234[(6)] = c__14822__auto__);

return statearr_18234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});

camelot.rest.post_x_raw.cljs$lang$maxFixedArity = 4;

/**
 * PUT state
 */
camelot.rest.put_x = (function camelot$rest$put_x(var_args){
var G__18251 = arguments.length;
switch (G__18251) {
case 3:
return camelot.rest.put_x.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return camelot.rest.put_x.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

camelot.rest.put_x.cljs$core$IFn$_invoke$arity$3 = (function (resource,params,cb){
return camelot.rest.put_x.cljs$core$IFn$_invoke$arity$4(resource,params,cb,null);
});

camelot.rest.put_x.cljs$core$IFn$_invoke$arity$4 = (function (resource,params,cb,failcb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_18281){
var state_val_18282 = (state_18281[(1)]);
if((state_val_18282 === (7))){
var state_18281__$1 = state_18281;
var statearr_18283_18302 = state_18281__$1;
(statearr_18283_18302[(2)] = null);

(statearr_18283_18302[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18282 === (1))){
var inst_18252 = camelot.util.misc.with_baseurl(resource);
var inst_18253 = camelot.util.transit.request(cljs_http.client.put,inst_18252,params);
var state_18281__$1 = state_18281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18281__$1,(2),inst_18253);
} else {
if((state_val_18282 === (4))){
var state_18281__$1 = state_18281;
if(cljs.core.truth_(failcb)){
var statearr_18284_18303 = state_18281__$1;
(statearr_18284_18303[(1)] = (9));

} else {
var statearr_18285_18304 = state_18281__$1;
(statearr_18285_18304[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18282 === (6))){
var inst_18255 = (state_18281[(7)]);
var inst_18262 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_18255) : cb.call(null,inst_18255));
var state_18281__$1 = state_18281;
var statearr_18286_18305 = state_18281__$1;
(statearr_18286_18305[(2)] = inst_18262);

(statearr_18286_18305[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18282 === (3))){
var state_18281__$1 = state_18281;
if(cljs.core.truth_(cb)){
var statearr_18287_18306 = state_18281__$1;
(statearr_18287_18306[(1)] = (6));

} else {
var statearr_18288_18307 = state_18281__$1;
(statearr_18288_18307[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18282 === (2))){
var inst_18255 = (state_18281[(7)]);
var inst_18255__$1 = (state_18281[(2)]);
var inst_18256 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18255__$1);
var inst_18257 = [inst_18256];
var inst_18258 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_18257);
var inst_18259 = cljs.core.some(inst_18258,camelot.rest.success_status_codes);
var state_18281__$1 = (function (){var statearr_18289 = state_18281;
(statearr_18289[(7)] = inst_18255__$1);

return statearr_18289;
})();
if(cljs.core.truth_(inst_18259)){
var statearr_18290_18308 = state_18281__$1;
(statearr_18290_18308[(1)] = (3));

} else {
var statearr_18291_18309 = state_18281__$1;
(statearr_18291_18309[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18282 === (11))){
var inst_18255 = (state_18281[(7)]);
var inst_18271 = (state_18281[(2)]);
var inst_18272 = camelot.state.display_state();
var inst_18273 = camelot.util.misc.with_baseurl(resource);
var inst_18274 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18255);
var inst_18275 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_18255);
var inst_18276 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("PUT",inst_18273,params,inst_18274,inst_18275);
var inst_18277 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18272,cljs.core.cst$kw$error,inst_18276);
var state_18281__$1 = (function (){var statearr_18292 = state_18281;
(statearr_18292[(8)] = inst_18271);

return statearr_18292;
})();
var statearr_18293_18310 = state_18281__$1;
(statearr_18293_18310[(2)] = inst_18277);

(statearr_18293_18310[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18282 === (9))){
var inst_18268 = (failcb.cljs$core$IFn$_invoke$arity$0 ? failcb.cljs$core$IFn$_invoke$arity$0() : failcb.call(null));
var state_18281__$1 = state_18281;
var statearr_18294_18311 = state_18281__$1;
(statearr_18294_18311[(2)] = inst_18268);

(statearr_18294_18311[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18282 === (5))){
var inst_18279 = (state_18281[(2)]);
var state_18281__$1 = state_18281;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18281__$1,inst_18279);
} else {
if((state_val_18282 === (10))){
var state_18281__$1 = state_18281;
var statearr_18295_18312 = state_18281__$1;
(statearr_18295_18312[(2)] = null);

(statearr_18295_18312[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18282 === (8))){
var inst_18265 = (state_18281[(2)]);
var state_18281__$1 = state_18281;
var statearr_18296_18313 = state_18281__$1;
(statearr_18296_18313[(2)] = inst_18265);

(statearr_18296_18313[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$state_machine__14723__auto__ = null;
var camelot$rest$state_machine__14723__auto____0 = (function (){
var statearr_18297 = [null,null,null,null,null,null,null,null,null];
(statearr_18297[(0)] = camelot$rest$state_machine__14723__auto__);

(statearr_18297[(1)] = (1));

return statearr_18297;
});
var camelot$rest$state_machine__14723__auto____1 = (function (state_18281){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_18281);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e18298){if((e18298 instanceof Object)){
var ex__14726__auto__ = e18298;
var statearr_18299_18314 = state_18281;
(statearr_18299_18314[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18281);

return cljs.core.cst$kw$recur;
} else {
throw e18298;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__18315 = state_18281;
state_18281 = G__18315;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$state_machine__14723__auto__ = function(state_18281){
switch(arguments.length){
case 0:
return camelot$rest$state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$state_machine__14723__auto____1.call(this,state_18281);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$state_machine__14723__auto____0;
camelot$rest$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$state_machine__14723__auto____1;
return camelot$rest$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_18300 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_18300[(6)] = c__14822__auto__);

return statearr_18300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});

camelot.rest.put_x.cljs$lang$maxFixedArity = 4;

/**
 * Retrieve global application details
 */
camelot.rest.get_application = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.rest.get_x,"/application");
/**
 * Retrieve screens
 */
camelot.rest.get_screens = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.rest.get_x,"/screens");
/**
 * Retrieve configuration
 */
camelot.rest.get_configuration = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.rest.get_x,"/settings");
/**
 * GET resource state
 */
camelot.rest.get_resource = (function camelot$rest$get_resource(resource,cb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_18340){
var state_val_18341 = (state_18340[(1)]);
if((state_val_18341 === (1))){
var inst_18316 = camelot.util.misc.with_baseurl(resource);
var inst_18317 = camelot.util.transit.request(cljs_http.client.get,inst_18316,null);
var state_18340__$1 = state_18340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18340__$1,(2),inst_18317);
} else {
if((state_val_18341 === (2))){
var inst_18319 = (state_18340[(7)]);
var inst_18319__$1 = (state_18340[(2)]);
var inst_18320 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18319__$1);
var inst_18321 = [inst_18320];
var inst_18322 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_18321);
var inst_18323 = cljs.core.some(inst_18322,camelot.rest.success_status_codes);
var state_18340__$1 = (function (){var statearr_18342 = state_18340;
(statearr_18342[(7)] = inst_18319__$1);

return statearr_18342;
})();
if(cljs.core.truth_(inst_18323)){
var statearr_18343_18355 = state_18340__$1;
(statearr_18343_18355[(1)] = (3));

} else {
var statearr_18344_18356 = state_18340__$1;
(statearr_18344_18356[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (3))){
var state_18340__$1 = state_18340;
if(cljs.core.truth_(cb)){
var statearr_18345_18357 = state_18340__$1;
(statearr_18345_18357[(1)] = (6));

} else {
var statearr_18346_18358 = state_18340__$1;
(statearr_18346_18358[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (4))){
var inst_18319 = (state_18340[(7)]);
var inst_18331 = camelot.state.display_state();
var inst_18332 = camelot.util.misc.with_baseurl(resource);
var inst_18333 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18319);
var inst_18334 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_18319);
var inst_18335 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$4("GET",inst_18332,inst_18333,inst_18334);
var inst_18336 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18331,cljs.core.cst$kw$error,inst_18335);
var state_18340__$1 = state_18340;
var statearr_18347_18359 = state_18340__$1;
(statearr_18347_18359[(2)] = inst_18336);

(statearr_18347_18359[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (5))){
var inst_18338 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18340__$1,inst_18338);
} else {
if((state_val_18341 === (6))){
var inst_18319 = (state_18340[(7)]);
var inst_18326 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_18319) : cb.call(null,inst_18319));
var state_18340__$1 = state_18340;
var statearr_18348_18360 = state_18340__$1;
(statearr_18348_18360[(2)] = inst_18326);

(statearr_18348_18360[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (7))){
var state_18340__$1 = state_18340;
var statearr_18349_18361 = state_18340__$1;
(statearr_18349_18361[(2)] = null);

(statearr_18349_18361[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (8))){
var inst_18329 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
var statearr_18350_18362 = state_18340__$1;
(statearr_18350_18362[(2)] = inst_18329);

(statearr_18350_18362[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$get_resource_$_state_machine__14723__auto__ = null;
var camelot$rest$get_resource_$_state_machine__14723__auto____0 = (function (){
var statearr_18351 = [null,null,null,null,null,null,null,null];
(statearr_18351[(0)] = camelot$rest$get_resource_$_state_machine__14723__auto__);

(statearr_18351[(1)] = (1));

return statearr_18351;
});
var camelot$rest$get_resource_$_state_machine__14723__auto____1 = (function (state_18340){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_18340);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e18352){if((e18352 instanceof Object)){
var ex__14726__auto__ = e18352;
var statearr_18353_18363 = state_18340;
(statearr_18353_18363[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18340);

return cljs.core.cst$kw$recur;
} else {
throw e18352;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__18364 = state_18340;
state_18340 = G__18364;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$get_resource_$_state_machine__14723__auto__ = function(state_18340){
switch(arguments.length){
case 0:
return camelot$rest$get_resource_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$get_resource_$_state_machine__14723__auto____1.call(this,state_18340);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$get_resource_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$get_resource_$_state_machine__14723__auto____0;
camelot$rest$get_resource_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$get_resource_$_state_machine__14723__auto____1;
return camelot$rest$get_resource_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_18354 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_18354[(6)] = c__14822__auto__);

return statearr_18354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});
/**
 * PUT resource state
 */
camelot.rest.put_resource = (function camelot$rest$put_resource(resource,params,cb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_18389){
var state_val_18390 = (state_18389[(1)]);
if((state_val_18390 === (1))){
var inst_18365 = camelot.util.misc.with_baseurl(resource);
var inst_18366 = camelot.util.transit.request(cljs_http.client.put,inst_18365,params);
var state_18389__$1 = state_18389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18389__$1,(2),inst_18366);
} else {
if((state_val_18390 === (2))){
var inst_18368 = (state_18389[(7)]);
var inst_18368__$1 = (state_18389[(2)]);
var inst_18369 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18368__$1);
var inst_18370 = [inst_18369];
var inst_18371 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_18370);
var inst_18372 = cljs.core.some(inst_18371,camelot.rest.success_status_codes);
var state_18389__$1 = (function (){var statearr_18391 = state_18389;
(statearr_18391[(7)] = inst_18368__$1);

return statearr_18391;
})();
if(cljs.core.truth_(inst_18372)){
var statearr_18392_18404 = state_18389__$1;
(statearr_18392_18404[(1)] = (3));

} else {
var statearr_18393_18405 = state_18389__$1;
(statearr_18393_18405[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18390 === (3))){
var state_18389__$1 = state_18389;
if(cljs.core.truth_(cb)){
var statearr_18394_18406 = state_18389__$1;
(statearr_18394_18406[(1)] = (6));

} else {
var statearr_18395_18407 = state_18389__$1;
(statearr_18395_18407[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18390 === (4))){
var inst_18368 = (state_18389[(7)]);
var inst_18380 = camelot.state.display_state();
var inst_18381 = camelot.util.misc.with_baseurl(resource);
var inst_18382 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18368);
var inst_18383 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_18368);
var inst_18384 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("PUT",inst_18381,params,inst_18382,inst_18383);
var inst_18385 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18380,cljs.core.cst$kw$error,inst_18384);
var state_18389__$1 = state_18389;
var statearr_18396_18408 = state_18389__$1;
(statearr_18396_18408[(2)] = inst_18385);

(statearr_18396_18408[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18390 === (5))){
var inst_18387 = (state_18389[(2)]);
var state_18389__$1 = state_18389;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18389__$1,inst_18387);
} else {
if((state_val_18390 === (6))){
var inst_18368 = (state_18389[(7)]);
var inst_18375 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_18368) : cb.call(null,inst_18368));
var state_18389__$1 = state_18389;
var statearr_18397_18409 = state_18389__$1;
(statearr_18397_18409[(2)] = inst_18375);

(statearr_18397_18409[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18390 === (7))){
var state_18389__$1 = state_18389;
var statearr_18398_18410 = state_18389__$1;
(statearr_18398_18410[(2)] = null);

(statearr_18398_18410[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18390 === (8))){
var inst_18378 = (state_18389[(2)]);
var state_18389__$1 = state_18389;
var statearr_18399_18411 = state_18389__$1;
(statearr_18399_18411[(2)] = inst_18378);

(statearr_18399_18411[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$put_resource_$_state_machine__14723__auto__ = null;
var camelot$rest$put_resource_$_state_machine__14723__auto____0 = (function (){
var statearr_18400 = [null,null,null,null,null,null,null,null];
(statearr_18400[(0)] = camelot$rest$put_resource_$_state_machine__14723__auto__);

(statearr_18400[(1)] = (1));

return statearr_18400;
});
var camelot$rest$put_resource_$_state_machine__14723__auto____1 = (function (state_18389){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_18389);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e18401){if((e18401 instanceof Object)){
var ex__14726__auto__ = e18401;
var statearr_18402_18412 = state_18389;
(statearr_18402_18412[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18389);

return cljs.core.cst$kw$recur;
} else {
throw e18401;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__18413 = state_18389;
state_18389 = G__18413;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$put_resource_$_state_machine__14723__auto__ = function(state_18389){
switch(arguments.length){
case 0:
return camelot$rest$put_resource_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$put_resource_$_state_machine__14723__auto____1.call(this,state_18389);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$put_resource_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$put_resource_$_state_machine__14723__auto____0;
camelot$rest$put_resource_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$put_resource_$_state_machine__14723__auto____1;
return camelot$rest$put_resource_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_18403 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_18403[(6)] = c__14822__auto__);

return statearr_18403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});
/**
 * POST resource state
 */
camelot.rest.post_resource = (function camelot$rest$post_resource(resource,params,cb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_18438){
var state_val_18439 = (state_18438[(1)]);
if((state_val_18439 === (1))){
var inst_18414 = camelot.util.misc.with_baseurl(resource);
var inst_18415 = camelot.util.transit.request(cljs_http.client.post,inst_18414,params);
var state_18438__$1 = state_18438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18438__$1,(2),inst_18415);
} else {
if((state_val_18439 === (2))){
var inst_18417 = (state_18438[(7)]);
var inst_18417__$1 = (state_18438[(2)]);
var inst_18418 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18417__$1);
var inst_18419 = [inst_18418];
var inst_18420 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_18419);
var inst_18421 = cljs.core.some(inst_18420,camelot.rest.success_status_codes);
var state_18438__$1 = (function (){var statearr_18440 = state_18438;
(statearr_18440[(7)] = inst_18417__$1);

return statearr_18440;
})();
if(cljs.core.truth_(inst_18421)){
var statearr_18441_18453 = state_18438__$1;
(statearr_18441_18453[(1)] = (3));

} else {
var statearr_18442_18454 = state_18438__$1;
(statearr_18442_18454[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18439 === (3))){
var state_18438__$1 = state_18438;
if(cljs.core.truth_(cb)){
var statearr_18443_18455 = state_18438__$1;
(statearr_18443_18455[(1)] = (6));

} else {
var statearr_18444_18456 = state_18438__$1;
(statearr_18444_18456[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18439 === (4))){
var inst_18417 = (state_18438[(7)]);
var inst_18429 = camelot.state.display_state();
var inst_18430 = camelot.util.misc.with_baseurl(resource);
var inst_18431 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18417);
var inst_18432 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_18417);
var inst_18433 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("POST",inst_18430,params,inst_18431,inst_18432);
var inst_18434 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18429,cljs.core.cst$kw$error,inst_18433);
var state_18438__$1 = state_18438;
var statearr_18445_18457 = state_18438__$1;
(statearr_18445_18457[(2)] = inst_18434);

(statearr_18445_18457[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18439 === (5))){
var inst_18436 = (state_18438[(2)]);
var state_18438__$1 = state_18438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18438__$1,inst_18436);
} else {
if((state_val_18439 === (6))){
var inst_18417 = (state_18438[(7)]);
var inst_18424 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_18417) : cb.call(null,inst_18417));
var state_18438__$1 = state_18438;
var statearr_18446_18458 = state_18438__$1;
(statearr_18446_18458[(2)] = inst_18424);

(statearr_18446_18458[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18439 === (7))){
var state_18438__$1 = state_18438;
var statearr_18447_18459 = state_18438__$1;
(statearr_18447_18459[(2)] = null);

(statearr_18447_18459[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18439 === (8))){
var inst_18427 = (state_18438[(2)]);
var state_18438__$1 = state_18438;
var statearr_18448_18460 = state_18438__$1;
(statearr_18448_18460[(2)] = inst_18427);

(statearr_18448_18460[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$post_resource_$_state_machine__14723__auto__ = null;
var camelot$rest$post_resource_$_state_machine__14723__auto____0 = (function (){
var statearr_18449 = [null,null,null,null,null,null,null,null];
(statearr_18449[(0)] = camelot$rest$post_resource_$_state_machine__14723__auto__);

(statearr_18449[(1)] = (1));

return statearr_18449;
});
var camelot$rest$post_resource_$_state_machine__14723__auto____1 = (function (state_18438){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_18438);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e18450){if((e18450 instanceof Object)){
var ex__14726__auto__ = e18450;
var statearr_18451_18461 = state_18438;
(statearr_18451_18461[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18438);

return cljs.core.cst$kw$recur;
} else {
throw e18450;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__18462 = state_18438;
state_18438 = G__18462;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$post_resource_$_state_machine__14723__auto__ = function(state_18438){
switch(arguments.length){
case 0:
return camelot$rest$post_resource_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$post_resource_$_state_machine__14723__auto____1.call(this,state_18438);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$post_resource_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$post_resource_$_state_machine__14723__auto____0;
camelot$rest$post_resource_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$post_resource_$_state_machine__14723__auto____1;
return camelot$rest$post_resource_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_18452 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_18452[(6)] = c__14822__auto__);

return statearr_18452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});
/**
 * DELETE resource
 */
camelot.rest.delete_resource = (function camelot$rest$delete_resource(resource,params,cb){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_18487){
var state_val_18488 = (state_18487[(1)]);
if((state_val_18488 === (1))){
var inst_18463 = camelot.util.misc.with_baseurl(resource);
var inst_18464 = camelot.util.transit.request(cljs_http.client.delete$,inst_18463,params);
var state_18487__$1 = state_18487;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18487__$1,(2),inst_18464);
} else {
if((state_val_18488 === (2))){
var inst_18466 = (state_18487[(7)]);
var inst_18466__$1 = (state_18487[(2)]);
var inst_18467 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18466__$1);
var inst_18468 = [inst_18467];
var inst_18469 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_18468);
var inst_18470 = cljs.core.some(inst_18469,camelot.rest.success_status_codes);
var state_18487__$1 = (function (){var statearr_18489 = state_18487;
(statearr_18489[(7)] = inst_18466__$1);

return statearr_18489;
})();
if(cljs.core.truth_(inst_18470)){
var statearr_18490_18502 = state_18487__$1;
(statearr_18490_18502[(1)] = (3));

} else {
var statearr_18491_18503 = state_18487__$1;
(statearr_18491_18503[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18488 === (3))){
var state_18487__$1 = state_18487;
if(cljs.core.truth_(cb)){
var statearr_18492_18504 = state_18487__$1;
(statearr_18492_18504[(1)] = (6));

} else {
var statearr_18493_18505 = state_18487__$1;
(statearr_18493_18505[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18488 === (4))){
var inst_18466 = (state_18487[(7)]);
var inst_18478 = camelot.state.display_state();
var inst_18479 = camelot.util.misc.with_baseurl(resource);
var inst_18480 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_18466);
var inst_18481 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_18466);
var inst_18482 = camelot.rest.build_error.cljs$core$IFn$_invoke$arity$5("DELETE",inst_18479,params,inst_18480,inst_18481);
var inst_18483 = om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(inst_18478,cljs.core.cst$kw$error,inst_18482);
var state_18487__$1 = state_18487;
var statearr_18494_18506 = state_18487__$1;
(statearr_18494_18506[(2)] = inst_18483);

(statearr_18494_18506[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18488 === (5))){
var inst_18485 = (state_18487[(2)]);
var state_18487__$1 = state_18487;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18487__$1,inst_18485);
} else {
if((state_val_18488 === (6))){
var inst_18466 = (state_18487[(7)]);
var inst_18473 = (cb.cljs$core$IFn$_invoke$arity$1 ? cb.cljs$core$IFn$_invoke$arity$1(inst_18466) : cb.call(null,inst_18466));
var state_18487__$1 = state_18487;
var statearr_18495_18507 = state_18487__$1;
(statearr_18495_18507[(2)] = inst_18473);

(statearr_18495_18507[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18488 === (7))){
var state_18487__$1 = state_18487;
var statearr_18496_18508 = state_18487__$1;
(statearr_18496_18508[(2)] = null);

(statearr_18496_18508[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18488 === (8))){
var inst_18476 = (state_18487[(2)]);
var state_18487__$1 = state_18487;
var statearr_18497_18509 = state_18487__$1;
(statearr_18497_18509[(2)] = inst_18476);

(statearr_18497_18509[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var camelot$rest$delete_resource_$_state_machine__14723__auto__ = null;
var camelot$rest$delete_resource_$_state_machine__14723__auto____0 = (function (){
var statearr_18498 = [null,null,null,null,null,null,null,null];
(statearr_18498[(0)] = camelot$rest$delete_resource_$_state_machine__14723__auto__);

(statearr_18498[(1)] = (1));

return statearr_18498;
});
var camelot$rest$delete_resource_$_state_machine__14723__auto____1 = (function (state_18487){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_18487);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e18499){if((e18499 instanceof Object)){
var ex__14726__auto__ = e18499;
var statearr_18500_18510 = state_18487;
(statearr_18500_18510[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18487);

return cljs.core.cst$kw$recur;
} else {
throw e18499;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__18511 = state_18487;
state_18487 = G__18511;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$rest$delete_resource_$_state_machine__14723__auto__ = function(state_18487){
switch(arguments.length){
case 0:
return camelot$rest$delete_resource_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$rest$delete_resource_$_state_machine__14723__auto____1.call(this,state_18487);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$rest$delete_resource_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$rest$delete_resource_$_state_machine__14723__auto____0;
camelot$rest$delete_resource_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$rest$delete_resource_$_state_machine__14723__auto____1;
return camelot$rest$delete_resource_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_18501 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_18501[(6)] = c__14822__auto__);

return statearr_18501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});
