// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.util.data');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
camelot.util.data.select_keys_inv = (function camelot$util$data$select_keys_inv(ks,data){
return cljs.core.select_keys(data,ks);
});
camelot.util.data.starts_with_QMARK_ = (function camelot$util$data$starts_with_QMARK_(prefix,s){
return cljs.core.re_matches(cljs.core.re_pattern([cljs.core.str.cljs$core$IFn$_invoke$arity$1("^"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".*")].join('')),s);
});
camelot.util.data.longest_prefix_match = (function camelot$util$data$longest_prefix_match(s,ps){
var G__20100 = ps;
var G__20100__$1 = (((G__20100 == null))?null:cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__20100){
return (function (p1__20099_SHARP_){
return camelot.util.data.starts_with_QMARK_(p1__20099_SHARP_,s);
});})(G__20100))
,G__20100));
var G__20100__$2 = (((G__20100__$1 == null))?null:cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.count,cljs.core._GT_,G__20100__$1));
if((G__20100__$2 == null)){
return null;
} else {
return cljs.core.first(G__20100__$2);
}
});
camelot.util.data.map_keys_reducer_fn = (function camelot$util$data$map_keys_reducer_fn(ks,acc,k,v){
if((cljs.core.contains_QMARK_(cljs.core.set(ks),k)) && (cljs.core.map_QMARK_(v))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([acc,cljs.core.reduce_kv((function (p1__20101_SHARP_,p2__20102_SHARP_,p3__20103_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__20101_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(k)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(p2__20102_SHARP_))].join('')),p3__20103_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,v)], 0));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v);
}
});
camelot.util.data.map_keys_to_key_prefix = (function camelot$util$data$map_keys_to_key_prefix(d,ks){
return cljs.core.reduce_kv(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.util.data.map_keys_reducer_fn,ks),cljs.core.PersistentArrayMap.EMPTY,d);
});
camelot.util.data.strip_prefix = (function camelot$util$data$strip_prefix(p,s){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(p));
});
camelot.util.data.strip_key_prefix = (function camelot$util$data$strip_key_prefix(k,p){
var n = clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((function (p1__20104_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__20104_SHARP_,"-");
}),camelot.util.data.strip_prefix(p,cljs.core.name(k))));
if(cljs.core.seq(n)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(n);
} else {
return null;
}
});
camelot.util.data.key_prefix_reducer_fn = (function camelot$util$data$key_prefix_reducer_fn(ks,acc,k,v){
var m = camelot.util.data.longest_prefix_match(cljs.core.name(k),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,ks));
if(cljs.core.truth_(m)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(m),((function (m){
return (function (p1__20105_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__20105_SHARP_,camelot.util.data.strip_key_prefix(k,m),v);
});})(m))
);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v);
}
});
camelot.util.data.key_prefix_to_map = (function camelot$util$data$key_prefix_to_map(d,ks){
return cljs.core.reduce_kv(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(camelot.util.data.key_prefix_reducer_fn,ks),cljs.core.PersistentArrayMap.EMPTY,d);
});
/**
 * Predicate returning true if n is a natural number (zero incl.).
 */
camelot.util.data.nat_QMARK_ = (function camelot$util$data$nat_QMARK_(n){
return (typeof n === 'number') && (((n === (0))) || ((n > (0))));
});
/**
 * Predicate returning true if x is a coll consisting representing a key and a
 *   value. False otherwise.
 */
camelot.util.data.pair_QMARK_ = (function camelot$util$data$pair_QMARK_(x){
var c = cljs.core.count(x);
return ((cljs.core.coll_QMARK_(x)) && (!(cljs.core.map_QMARK_(x))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c,(2)))) || ((cljs.core.map_QMARK_(x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c,(1))));
});
/**
 * Map applying f, a function taking two arguments: a key and a value. Return
 *   the result as a hash-map.
 */
camelot.util.data.map_val = (function camelot$util$data$map_val(f,xs){
if(cljs.core.ifn_QMARK_(f)){
} else {
throw (new Error("Assert failed: (ifn? f)"));
}

if(!(((xs == null)) || (cljs.core.coll_QMARK_(xs)))){
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("coll expected, but '"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(xs),cljs.core.str.cljs$core$IFn$_invoke$arity$1("' is not a coll")].join('')));
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__20106){
var vec__20107 = p__20106;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20107,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20107,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(v) : f.call(null,v))], null);
}),xs));
}
});
/**
 * Key `xs` by the result of applying `f` to each item.
 *   Should multiple items in xs return the same value of f, yield only the
 *   first.
 */
camelot.util.data.key_by = (function camelot$util$data$key_by(f,xs){
if(cljs.core.ifn_QMARK_(f)){
} else {
throw (new Error("Assert failed: (ifn? f)"));
}

if(!(((xs == null)) || (cljs.core.coll_QMARK_(xs)))){
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("coll expected, but '"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(xs),cljs.core.str.cljs$core$IFn$_invoke$arity$1("' is not a coll")].join('')));
} else {
return camelot.util.data.map_val((function (v){
return cljs.core.first(v);
}),cljs.core.group_by(f,xs));
}
});
/**
 * Add keys nominated in keyseq to smap with a default value.
 *   The resulting map will have all key-value pairs in smap, and additionally
 *   any keys in keyseq with the given default value, or nil should a default
 *   value not be provided.
 */
camelot.util.data.require_keys = (function camelot$util$data$require_keys(var_args){
var G__20112 = arguments.length;
switch (G__20112) {
case 2:
return camelot.util.data.require_keys.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return camelot.util.data.require_keys.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

camelot.util.data.require_keys.cljs$core$IFn$_invoke$arity$2 = (function (smap,keyseq){
return camelot.util.data.require_keys.cljs$core$IFn$_invoke$arity$3(smap,keyseq,null);
});

camelot.util.data.require_keys.cljs$core$IFn$_invoke$arity$3 = (function (smap,keyseq,default$){
var dm = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20110_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__20110_SHARP_,default$],null));
}),keyseq));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([dm,smap], 0));
});

camelot.util.data.require_keys.cljs$lang$maxFixedArity = 3;

/**
 * Like `select-keys`, but will always return a map with all keys in `keyseq`.
 *   `default` is an optional third argument for the value to use for a key not
 *   found in `map`.
 */
camelot.util.data.assign_keys = (function camelot$util$data$assign_keys(var_args){
var G__20115 = arguments.length;
switch (G__20115) {
case 2:
return camelot.util.data.assign_keys.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return camelot.util.data.assign_keys.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

camelot.util.data.assign_keys.cljs$core$IFn$_invoke$arity$2 = (function (smap,keyseq){
return camelot.util.data.assign_keys.cljs$core$IFn$_invoke$arity$3(smap,keyseq,null);
});

camelot.util.data.assign_keys.cljs$core$IFn$_invoke$arity$3 = (function (smap,keyseq,default$){
return camelot.util.data.require_keys.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(smap,keyseq),keyseq,default$);
});

camelot.util.data.assign_keys.cljs$lang$maxFixedArity = 3;

