// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.util.deployment');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('camelot.util.data');
camelot.util.deployment.assoc_cameras_for_group = (function camelot$util$deployment$assoc_cameras_for_group(p__22389){
var vec__22390 = p__22389;
var session_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22390,(0),null);
var group = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22390,(1),null);
var dissoc_list = ((function (vec__22390,session_id,group){
return (function (p1__22387_SHARP_,p2__22388_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,p1__22387_SHARP_,p2__22388_SHARP_);
});})(vec__22390,session_id,group))
;
var keys = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camera_DASH_id,cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$camera_DASH_status_DASH_id,cljs.core.cst$kw$camera_DASH_media_DASH_unrecoverable], null);
var vec__22393 = group;
var g1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22393,(0),null);
var g2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22393,(1),null);
return dissoc_list(camelot.util.data.map_keys_to_key_prefix(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([g1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$primary,cljs.core.select_keys(g1,keys)], null)], 0)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$secondary,cljs.core.select_keys(g2,keys)], null)], 0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$primary,cljs.core.cst$kw$secondary], null)),keys);
});
/**
 * Associate data for primary and secondary cameras.
 */
camelot.util.deployment.assoc_cameras = (function camelot$util$deployment$assoc_cameras(data){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(camelot.util.deployment.assoc_cameras_for_group,cljs.core.group_by(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_id,data));
});
/**
 * Convert primary and secondary camera data into a list of cameras, stripping the prefix.
 */
camelot.util.deployment.map_with_cameras_as_list = (function camelot$util$deployment$map_with_cameras_as_list(d){
var types = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$primary,cljs.core.cst$kw$secondary], null);
var nd = camelot.util.data.key_prefix_to_map(d,types);
var cams = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (types,nd){
return (function (p1__22396_SHARP_){
return camelot.util.data.nat_QMARK_(cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(p1__22396_SHARP_));
});})(types,nd))
,cljs.core.vals(camelot.util.data.select_keys_inv(types,nd)));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nd,cljs.core.cst$kw$cameras,cams),cljs.core.cst$kw$primary,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$secondary], 0));
});
/**
 * Predicate indicating whether a camera was removed from the next session.
 */
camelot.util.deployment.original_camera_removed_QMARK_ = (function camelot$util$deployment$original_camera_removed_QMARK_(active_status_id,camera){
var and__6612__auto__ = camelot.util.data.nat_QMARK_(cljs.core.cst$kw$camera_DASH_original_DASH_id.cljs$core$IFn$_invoke$arity$1(camera));
if(cljs.core.truth_(and__6612__auto__)){
return (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_original_DASH_id.cljs$core$IFn$_invoke$arity$1(camera),cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(camera))) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_status_DASH_id.cljs$core$IFn$_invoke$arity$1(camera),active_status_id));
} else {
return and__6612__auto__;
}
});
/**
 * Predicate returning true if the camera is/will be considered active.
 */
camelot.util.deployment.camera_active_QMARK_ = (function camelot$util$deployment$camera_active_QMARK_(active_status_id,camera){
var and__6612__auto__ = camelot.util.data.nat_QMARK_(cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(camera));
if(cljs.core.truth_(and__6612__auto__)){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_status_DASH_id.cljs$core$IFn$_invoke$arity$1(camera),active_status_id)) || ((cljs.core.cst$kw$camera_DASH_original_DASH_id.cljs$core$IFn$_invoke$arity$1(camera) == null)) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$camera_DASH_original_DASH_id.cljs$core$IFn$_invoke$arity$1(camera),cljs.core.cst$kw$camera_DASH_id.cljs$core$IFn$_invoke$arity$1(camera)));
} else {
return and__6612__auto__;
}
});
camelot.util.deployment.camera_id_key = (function camelot$util$deployment$camera_id_key(cam_type){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cam_type)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-camera-id")].join(''));
});
camelot.util.deployment.camera_status_id_key = (function camelot$util$deployment$camera_status_id_key(cam_type){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cam_type)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-camera-status-id")].join(''));
});
camelot.util.deployment.camera_media_unrecoverable_key = (function camelot$util$deployment$camera_media_unrecoverable_key(cam_type){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cam_type)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-camera-media-unrecoverable")].join(''));
});
