// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.validation.validated_component');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.core');
goog.require('om.dom');
goog.require('camelot.rest');
goog.require('camelot.translation.core');
goog.require('camelot.state');
goog.require('camelot.nav');
goog.require('cljs.core.async');
goog.require('goog.date');
goog.require('camelot.util.data');
goog.require('clojure.string');
/**
 * Create a new validator.
 */
camelot.validation.validated_component.validator = (function camelot$validation$validated_component$validator(f,msg){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_predicate,f,cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_msg,msg], null);
});
camelot.validation.validated_component.required = (function camelot$validation$validated_component$required(){
return camelot.validation.validated_component.validator((function (v){
return !(((v == null)) || (((cljs.core.coll_QMARK_(v)) && (cljs.core.empty_QMARK_(v))) || ((typeof v === 'string') && (cljs.core.empty_QMARK_(clojure.string.trim(v))))));
}),camelot.translation.core.translate(cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_not_DASH_empty));
});
camelot.validation.validated_component.required_if = (function camelot$validation$validated_component$required_if(pred){
return camelot.validation.validated_component.validator((function (v){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$0 ? pred.cljs$core$IFn$_invoke$arity$0() : pred.call(null)))){
return !(((v == null)) || (((typeof v === 'string') || (cljs.core.coll_QMARK_(v))) && (cljs.core.empty_QMARK_(v))));
} else {
return true;
}
}),camelot.translation.core.translate(cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_not_DASH_empty));
});
camelot.validation.validated_component.keyword_like = (function camelot$validation$validated_component$keyword_like(){
return camelot.validation.validated_component.validator((function (p1__20119_SHARP_){
var and__6612__auto__ = typeof p1__20119_SHARP_ === 'string';
if(and__6612__auto__){
return cljs.core.re_find(/^[-a-z0-9]+$/,p1__20119_SHARP_);
} else {
return and__6612__auto__;
}
}),camelot.translation.core.translate(cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_not_DASH_keyword));
});
camelot.validation.validated_component.max_length = (function camelot$validation$validated_component$max_length(n){
return camelot.validation.validated_component.validator((function (x){
return (cljs.core.count(x) < n);
}),camelot.translation.core.translate.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_too_DASH_long,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0)));
});
camelot.validation.validated_component.unique = (function camelot$validation$validated_component$unique(others){
return camelot.validation.validated_component.validator((function (x){
return !(cljs.core.contains_QMARK_(others,x));
}),camelot.translation.core.translate(cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_not_DASH_distinct));
});
camelot.validation.validated_component.validated_QMARK_ = (function camelot$validation$validated_component$validated_QMARK_(state){
return cljs.core.every_QMARK_(cljs.core.identity,cljs.core.vals(state));
});
/**
 * Takes a channel on to which form-wide validation results should be placed,
 *   and returns a channel to take validation results from individual
 *   components.
 */
camelot.validation.validated_component.component_validator = (function camelot$validation$validated_component$component_validator(result_chan){
var c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var c__14822__auto___20240 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___20240,c,state){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___20240,c,state){
return (function (state_20195){
var state_val_20196 = (state_20195[(1)]);
if((state_val_20196 === (7))){
var inst_20140 = (state_20195[(2)]);
var state_20195__$1 = state_20195;
if(cljs.core.truth_(inst_20140)){
var statearr_20197_20241 = state_20195__$1;
(statearr_20197_20241[(1)] = (11));

} else {
var statearr_20198_20242 = state_20195__$1;
(statearr_20198_20242[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (20))){
var inst_20168 = cljs.core.deref(state);
var inst_20169 = cljs.core.empty(inst_20168);
var state_20195__$1 = state_20195;
var statearr_20199_20243 = state_20195__$1;
(statearr_20199_20243[(2)] = inst_20169);

(statearr_20199_20243[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (27))){
var state_20195__$1 = state_20195;
var statearr_20200_20244 = state_20195__$1;
(statearr_20200_20244[(2)] = null);

(statearr_20200_20244[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (1))){
var state_20195__$1 = state_20195;
var statearr_20201_20245 = state_20195__$1;
(statearr_20201_20245[(2)] = null);

(statearr_20201_20245[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (24))){
var inst_20149 = (state_20195[(7)]);
var inst_20165 = (state_20195[(8)]);
var inst_20175 = camelot.validation.validated_component.validated_QMARK_(inst_20149);
var inst_20176 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_20175,inst_20165);
var state_20195__$1 = state_20195;
var statearr_20202_20246 = state_20195__$1;
(statearr_20202_20246[(2)] = inst_20176);

(statearr_20202_20246[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (4))){
var inst_20124 = (state_20195[(9)]);
var inst_20124__$1 = (state_20195[(2)]);
var inst_20126 = (inst_20124__$1 == null);
var inst_20127 = cljs.core.not(inst_20126);
var state_20195__$1 = (function (){var statearr_20203 = state_20195;
(statearr_20203[(9)] = inst_20124__$1);

return statearr_20203;
})();
if(inst_20127){
var statearr_20204_20247 = state_20195__$1;
(statearr_20204_20247[(1)] = (5));

} else {
var statearr_20205_20248 = state_20195__$1;
(statearr_20205_20248[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (15))){
var state_20195__$1 = state_20195;
var statearr_20206_20249 = state_20195__$1;
(statearr_20206_20249[(2)] = null);

(statearr_20206_20249[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (21))){
var inst_20166 = (state_20195[(10)]);
var state_20195__$1 = state_20195;
var statearr_20207_20250 = state_20195__$1;
(statearr_20207_20250[(2)] = inst_20166);

(statearr_20207_20250[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (13))){
var inst_20148 = (state_20195[(11)]);
var inst_20145 = (state_20195[(12)]);
var inst_20145__$1 = (state_20195[(2)]);
var inst_20146 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20145__$1,cljs.core.cst$kw$key);
var inst_20147 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20145__$1,cljs.core.cst$kw$success);
var inst_20148__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20145__$1,cljs.core.cst$kw$command);
var inst_20149 = cljs.core.deref(state);
var inst_20150 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_20148__$1,cljs.core.cst$kw$unmount);
var state_20195__$1 = (function (){var statearr_20208 = state_20195;
(statearr_20208[(13)] = inst_20146);

(statearr_20208[(11)] = inst_20148__$1);

(statearr_20208[(14)] = inst_20147);

(statearr_20208[(7)] = inst_20149);

(statearr_20208[(12)] = inst_20145__$1);

return statearr_20208;
})();
if(inst_20150){
var statearr_20209_20251 = state_20195__$1;
(statearr_20209_20251[(1)] = (14));

} else {
var statearr_20210_20252 = state_20195__$1;
(statearr_20210_20252[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (22))){
var inst_20172 = (state_20195[(15)]);
var inst_20172__$1 = (state_20195[(2)]);
var state_20195__$1 = (function (){var statearr_20211 = state_20195;
(statearr_20211[(15)] = inst_20172__$1);

return statearr_20211;
})();
if(cljs.core.truth_(inst_20172__$1)){
var statearr_20212_20253 = state_20195__$1;
(statearr_20212_20253[(1)] = (23));

} else {
var statearr_20213_20254 = state_20195__$1;
(statearr_20213_20254[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (29))){
var inst_20184 = (state_20195[(2)]);
var state_20195__$1 = state_20195;
var statearr_20214_20255 = state_20195__$1;
(statearr_20214_20255[(2)] = inst_20184);

(statearr_20214_20255[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (6))){
var state_20195__$1 = state_20195;
var statearr_20215_20256 = state_20195__$1;
(statearr_20215_20256[(2)] = false);

(statearr_20215_20256[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (28))){
var inst_20187 = (state_20195[(2)]);
var state_20195__$1 = (function (){var statearr_20216 = state_20195;
(statearr_20216[(16)] = inst_20187);

return statearr_20216;
})();
var statearr_20217_20257 = state_20195__$1;
(statearr_20217_20257[(2)] = null);

(statearr_20217_20257[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (25))){
var inst_20178 = (state_20195[(2)]);
var state_20195__$1 = state_20195;
if(cljs.core.truth_(inst_20178)){
var statearr_20218_20258 = state_20195__$1;
(statearr_20218_20258[(1)] = (26));

} else {
var statearr_20219_20259 = state_20195__$1;
(statearr_20219_20259[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (17))){
var inst_20146 = (state_20195[(13)]);
var inst_20147 = (state_20195[(14)]);
var inst_20155 = [inst_20146];
var inst_20156 = [inst_20147];
var inst_20157 = cljs.core.PersistentHashMap.fromArrays(inst_20155,inst_20156);
var inst_20158 = cljs.core.reset_BANG_(state,inst_20157);
var state_20195__$1 = state_20195;
var statearr_20220_20260 = state_20195__$1;
(statearr_20220_20260[(2)] = inst_20158);

(statearr_20220_20260[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (3))){
var inst_20193 = (state_20195[(2)]);
var state_20195__$1 = state_20195;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20195__$1,inst_20193);
} else {
if((state_val_20196 === (12))){
var inst_20124 = (state_20195[(9)]);
var state_20195__$1 = state_20195;
var statearr_20221_20261 = state_20195__$1;
(statearr_20221_20261[(2)] = inst_20124);

(statearr_20221_20261[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (2))){
var state_20195__$1 = state_20195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20195__$1,(4),c);
} else {
if((state_val_20196 === (23))){
var inst_20172 = (state_20195[(15)]);
var state_20195__$1 = state_20195;
var statearr_20222_20262 = state_20195__$1;
(statearr_20222_20262[(2)] = inst_20172);

(statearr_20222_20262[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (19))){
var inst_20149 = (state_20195[(7)]);
var inst_20166 = (state_20195[(10)]);
var inst_20163 = (state_20195[(2)]);
var inst_20164 = cljs.core.deref(state);
var inst_20165 = camelot.validation.validated_component.validated_QMARK_(inst_20164);
var inst_20166__$1 = (inst_20149 == null);
var state_20195__$1 = (function (){var statearr_20223 = state_20195;
(statearr_20223[(17)] = inst_20163);

(statearr_20223[(8)] = inst_20165);

(statearr_20223[(10)] = inst_20166__$1);

return statearr_20223;
})();
if(cljs.core.truth_(inst_20166__$1)){
var statearr_20224_20263 = state_20195__$1;
(statearr_20224_20263[(1)] = (20));

} else {
var statearr_20225_20264 = state_20195__$1;
(statearr_20225_20264[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (11))){
var inst_20124 = (state_20195[(9)]);
var inst_20142 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20124);
var state_20195__$1 = state_20195;
var statearr_20226_20265 = state_20195__$1;
(statearr_20226_20265[(2)] = inst_20142);

(statearr_20226_20265[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (9))){
var state_20195__$1 = state_20195;
var statearr_20227_20266 = state_20195__$1;
(statearr_20227_20266[(2)] = false);

(statearr_20227_20266[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (5))){
var inst_20124 = (state_20195[(9)]);
var inst_20129 = inst_20124.cljs$lang$protocol_mask$partition0$;
var inst_20130 = (inst_20129 & (64));
var inst_20131 = inst_20124.cljs$core$ISeq$;
var inst_20132 = (cljs.core.PROTOCOL_SENTINEL === inst_20131);
var inst_20133 = (inst_20130) || (inst_20132);
var state_20195__$1 = state_20195;
if(cljs.core.truth_(inst_20133)){
var statearr_20228_20267 = state_20195__$1;
(statearr_20228_20267[(1)] = (8));

} else {
var statearr_20229_20268 = state_20195__$1;
(statearr_20229_20268[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (14))){
var inst_20152 = cljs.core.deref(state);
var inst_20153 = (inst_20152 == null);
var state_20195__$1 = state_20195;
if(cljs.core.truth_(inst_20153)){
var statearr_20230_20269 = state_20195__$1;
(statearr_20230_20269[(1)] = (17));

} else {
var statearr_20231_20270 = state_20195__$1;
(statearr_20231_20270[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (26))){
var inst_20165 = (state_20195[(8)]);
var inst_20180 = [cljs.core.cst$kw$validated];
var inst_20181 = [inst_20165];
var inst_20182 = cljs.core.PersistentHashMap.fromArrays(inst_20180,inst_20181);
var state_20195__$1 = state_20195;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20195__$1,(29),result_chan,inst_20182);
} else {
if((state_val_20196 === (16))){
var inst_20191 = (state_20195[(2)]);
var state_20195__$1 = state_20195;
var statearr_20232_20271 = state_20195__$1;
(statearr_20232_20271[(2)] = inst_20191);

(statearr_20232_20271[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (10))){
var inst_20137 = (state_20195[(2)]);
var state_20195__$1 = state_20195;
var statearr_20233_20272 = state_20195__$1;
(statearr_20233_20272[(2)] = inst_20137);

(statearr_20233_20272[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (18))){
var inst_20146 = (state_20195[(13)]);
var inst_20148 = (state_20195[(11)]);
var inst_20147 = (state_20195[(14)]);
var inst_20149 = (state_20195[(7)]);
var inst_20145 = (state_20195[(12)]);
var inst_20160 = (function (){var map__20122 = inst_20145;
var key = inst_20146;
var success = inst_20147;
var command = inst_20148;
var pstate = inst_20149;
return ((function (map__20122,key,success,command,pstate,inst_20146,inst_20148,inst_20147,inst_20149,inst_20145,state_val_20196,c__14822__auto___20240,c,state){
return (function (p1__20120_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__20120_SHARP_,key,success);
});
;})(map__20122,key,success,command,pstate,inst_20146,inst_20148,inst_20147,inst_20149,inst_20145,state_val_20196,c__14822__auto___20240,c,state))
})();
var inst_20161 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,inst_20160);
var state_20195__$1 = state_20195;
var statearr_20234_20273 = state_20195__$1;
(statearr_20234_20273[(2)] = inst_20161);

(statearr_20234_20273[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20196 === (8))){
var state_20195__$1 = state_20195;
var statearr_20235_20274 = state_20195__$1;
(statearr_20235_20274[(2)] = true);

(statearr_20235_20274[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___20240,c,state))
;
return ((function (switch__14722__auto__,c__14822__auto___20240,c,state){
return (function() {
var camelot$validation$validated_component$component_validator_$_state_machine__14723__auto__ = null;
var camelot$validation$validated_component$component_validator_$_state_machine__14723__auto____0 = (function (){
var statearr_20236 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20236[(0)] = camelot$validation$validated_component$component_validator_$_state_machine__14723__auto__);

(statearr_20236[(1)] = (1));

return statearr_20236;
});
var camelot$validation$validated_component$component_validator_$_state_machine__14723__auto____1 = (function (state_20195){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20195);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20237){if((e20237 instanceof Object)){
var ex__14726__auto__ = e20237;
var statearr_20238_20275 = state_20195;
(statearr_20238_20275[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20195);

return cljs.core.cst$kw$recur;
} else {
throw e20237;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20276 = state_20195;
state_20195 = G__20276;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$validation$validated_component$component_validator_$_state_machine__14723__auto__ = function(state_20195){
switch(arguments.length){
case 0:
return camelot$validation$validated_component$component_validator_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$validation$validated_component$component_validator_$_state_machine__14723__auto____1.call(this,state_20195);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$validation$validated_component$component_validator_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$validation$validated_component$component_validator_$_state_machine__14723__auto____0;
camelot$validation$validated_component$component_validator_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$validation$validated_component$component_validator_$_state_machine__14723__auto____1;
return camelot$validation$validated_component$component_validator_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___20240,c,state))
})();
var state__14824__auto__ = (function (){var statearr_20239 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20239[(6)] = c__14822__auto___20240);

return statearr_20239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___20240,c,state))
);


return c;
});
camelot.validation.validated_component.apply_validator = (function camelot$validation$validated_component$apply_validator(data,acc,k,p__20277){
var map__20278 = p__20277;
var map__20278__$1 = ((((!((map__20278 == null)))?((((map__20278.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20278.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20278):map__20278);
var predicate = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20278__$1,cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_predicate);
var msg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20278__$1,cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_msg);
if(cljs.core.truth_((predicate.cljs$core$IFn$_invoke$arity$1 ? predicate.cljs$core$IFn$_invoke$arity$1(data) : predicate.call(null,data)))){
return null;
} else {
return cljs.core.reduced(k);
}
});
/**
 * Return `component`, wrapped in a validator.
 * 
 *   Usually this is not invoked directly, but injected via
 *   `camelot.macros.ui.validation/with-validation`.
 * 
 *   `validators` is a list of validators which must pass. See `validator'.
 *   `validation-chan` is the channel on to which validation results should be
 *   placed.  any parameters, such as opts, needing to be passed to the component
 *   can be passed via `params`.
 */
camelot.validation.validated_component.wrapper = (function camelot$validation$validated_component$wrapper(data,owner,p__20280){
var map__20281 = p__20280;
var map__20281__$1 = ((((!((map__20281 == null)))?((((map__20281.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20281.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20281):map__20281);
var data_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20281__$1,cljs.core.cst$kw$data_DASH_key);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20281__$1,cljs.core.cst$kw$component);
var validators = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20281__$1,cljs.core.cst$kw$validators);
var validation_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20281__$1,cljs.core.cst$kw$validation_DASH_chan);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20281__$1,cljs.core.cst$kw$params);
if(typeof camelot.validation.validated_component.t_camelot$validation$validated_component20283 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
camelot.validation.validated_component.t_camelot$validation$validated_component20283 = (function (data,owner,p__20280,map__20281,data_key,component,validators,validation_chan,params,meta20284){
this.data = data;
this.owner = owner;
this.p__20280 = p__20280;
this.map__20281 = map__20281;
this.data_key = data_key;
this.component = component;
this.validators = validators;
this.validation_chan = validation_chan;
this.params = params;
this.meta20284 = meta20284;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
camelot.validation.validated_component.t_camelot$validation$validated_component20283.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function (_20285,meta20284__$1){
var self__ = this;
var _20285__$1 = this;
return (new camelot.validation.validated_component.t_camelot$validation$validated_component20283(self__.data,self__.owner,self__.p__20280,self__.map__20281,self__.data_key,self__.component,self__.validators,self__.validation_chan,self__.params,meta20284__$1));
});})(map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
;

camelot.validation.validated_component.t_camelot$validation$validated_component20283.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function (_20285){
var self__ = this;
var _20285__$1 = this;
return self__.meta20284;
});})(map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
;

camelot.validation.validated_component.t_camelot$validation$validated_component20283.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.validation.validated_component.t_camelot$validation$validated_component20283.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_validator_DASH_failed,null], null);
});})(map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
;

camelot.validation.validated_component.t_camelot$validation$validated_component20283.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

camelot.validation.validated_component.t_camelot$validation$validated_component20283.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,(((self__.data_key instanceof cljs.core.Keyword))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.data_key], null):self__.data_key)))){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_show_DASH_messages,true);
} else {
}

var result_20304 = cljs.core.reduce_kv(((function (___$1,map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function (acc,k,v){
return camelot.validation.validated_component.apply_validator(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,self__.data_key),acc,k,v);
});})(___$1,map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
,null,self__.validators);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_validator_DASH_failed,result_20304);

var c__14822__auto___20305 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___20305,result_20304,___$1,map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___20305,result_20304,___$1,map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function (state_20293){
var state_val_20294 = (state_20293[(1)]);
if((state_val_20294 === (1))){
var inst_20286 = [cljs.core.cst$kw$key,cljs.core.cst$kw$success];
var inst_20287 = (result_20304 == null);
var inst_20288 = [self__.data_key,inst_20287];
var inst_20289 = cljs.core.PersistentHashMap.fromArrays(inst_20286,inst_20288);
var state_20293__$1 = state_20293;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20293__$1,(2),self__.validation_chan,inst_20289);
} else {
if((state_val_20294 === (2))){
var inst_20291 = (state_20293[(2)]);
var state_20293__$1 = state_20293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20293__$1,inst_20291);
} else {
return null;
}
}
});})(c__14822__auto___20305,result_20304,___$1,map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
;
return ((function (switch__14722__auto__,c__14822__auto___20305,result_20304,___$1,map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function() {
var camelot$validation$validated_component$wrapper_$_state_machine__14723__auto__ = null;
var camelot$validation$validated_component$wrapper_$_state_machine__14723__auto____0 = (function (){
var statearr_20295 = [null,null,null,null,null,null,null];
(statearr_20295[(0)] = camelot$validation$validated_component$wrapper_$_state_machine__14723__auto__);

(statearr_20295[(1)] = (1));

return statearr_20295;
});
var camelot$validation$validated_component$wrapper_$_state_machine__14723__auto____1 = (function (state_20293){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_20293);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e20296){if((e20296 instanceof Object)){
var ex__14726__auto__ = e20296;
var statearr_20297_20306 = state_20293;
(statearr_20297_20306[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20293);

return cljs.core.cst$kw$recur;
} else {
throw e20296;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__20307 = state_20293;
state_20293 = G__20307;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
camelot$validation$validated_component$wrapper_$_state_machine__14723__auto__ = function(state_20293){
switch(arguments.length){
case 0:
return camelot$validation$validated_component$wrapper_$_state_machine__14723__auto____0.call(this);
case 1:
return camelot$validation$validated_component$wrapper_$_state_machine__14723__auto____1.call(this,state_20293);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
camelot$validation$validated_component$wrapper_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = camelot$validation$validated_component$wrapper_$_state_machine__14723__auto____0;
camelot$validation$validated_component$wrapper_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = camelot$validation$validated_component$wrapper_$_state_machine__14723__auto____1;
return camelot$validation$validated_component$wrapper_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___20305,result_20304,___$1,map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
})();
var state__14824__auto__ = (function (){var statearr_20298 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_20298[(6)] = c__14822__auto___20305);

return statearr_20298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___20305,result_20304,___$1,map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
);


var show_warning = (function (){var and__6612__auto__ = cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_show_DASH_messages.cljs$core$IFn$_invoke$arity$1(state);
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.validators,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_validator_DASH_failed.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_msg], null));
} else {
return and__6612__auto__;
}
})();
var G__20299 = ({"className": "validated-component"});
var G__20300 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$3(self__.component,self__.data,self__.params));
var G__20301 = om.util.force_children((cljs.core.truth_(show_warning)?(function (){var G__20302 = ({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("validation-warning ")].join('')});
var G__20303 = om.util.force_children(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.validators,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_validator_DASH_failed.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$camelot$validation$validated_DASH_component_SLASH_msg], null)));
return React.DOM.div(G__20302,G__20303);
})():null));
return React.DOM.div(G__20299,G__20300,G__20301);
});})(map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
;

camelot.validation.validated_component.t_camelot$validation$validated_component20283.getBasis = ((function (map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__20280,cljs.core.cst$sym$map__20281,cljs.core.cst$sym$data_DASH_key,cljs.core.cst$sym$component,cljs.core.cst$sym$validators,cljs.core.cst$sym$validation_DASH_chan,cljs.core.cst$sym$params,cljs.core.cst$sym$meta20284], null);
});})(map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
;

camelot.validation.validated_component.t_camelot$validation$validated_component20283.cljs$lang$type = true;

camelot.validation.validated_component.t_camelot$validation$validated_component20283.cljs$lang$ctorStr = "camelot.validation.validated-component/t_camelot$validation$validated_component20283";

camelot.validation.validated_component.t_camelot$validation$validated_component20283.cljs$lang$ctorPrWriter = ((function (map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"camelot.validation.validated-component/t_camelot$validation$validated_component20283");
});})(map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
;

camelot.validation.validated_component.__GT_t_camelot$validation$validated_component20283 = ((function (map__20281,map__20281__$1,data_key,component,validators,validation_chan,params){
return (function camelot$validation$validated_component$wrapper_$___GT_t_camelot$validation$validated_component20283(data__$1,owner__$1,p__20280__$1,map__20281__$2,data_key__$1,component__$1,validators__$1,validation_chan__$1,params__$1,meta20284){
return (new camelot.validation.validated_component.t_camelot$validation$validated_component20283(data__$1,owner__$1,p__20280__$1,map__20281__$2,data_key__$1,component__$1,validators__$1,validation_chan__$1,params__$1,meta20284));
});})(map__20281,map__20281__$1,data_key,component,validators,validation_chan,params))
;

}

return (new camelot.validation.validated_component.t_camelot$validation$validated_component20283(data,owner,p__20280,map__20281__$1,data_key,component,validators,validation_chan,params,cljs.core.PersistentArrayMap.EMPTY));
});
