// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('camelot.view');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.core');
goog.require('om.dom');
goog.require('camelot.state');
goog.require('camelot.component.survey.core');
goog.require('camelot.component.bulk_import.core');
goog.require('camelot.component.bulk_import.mapper');
goog.require('camelot.component.deployment.core');
goog.require('camelot.component.organisation');
goog.require('camelot.component.nav');
goog.require('camelot.util.cursorise');
goog.require('smithy.core');
goog.require('camelot.nav');
goog.require('smithy.util');
goog.require('camelot.util.misc');
goog.require('camelot.rest');
goog.require('camelot.component.notification');
goog.require('camelot.component.library.core');
goog.require('secretary.core');
goog.require('camelot.component.report.core');
goog.require('camelot.component.camera.core');
goog.require('camelot.component.species.core');
goog.require('camelot.component.site.core');
/**
 * Update the state of the children defined for the selected resource type.
 */
camelot.view.load_resource_children = (function camelot$view$load_resource_children(vs){
var screen = smithy.util.get_screen(vs);
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$sidebar,cljs.core.cst$kw$resource], null));
var id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$id], null));
var ep = (cljs.core.truth_(id)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$endpoint)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join(''):cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$endpoint));
return camelot.rest.get_resource(ep,((function (screen,res,id,ep){
return (function (p1__26103_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$children,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__26103_SHARP_));
});})(screen,res,id,ep))
);
});
/**
 * Check required fields against the entered data
 */
camelot.view.validate = (function camelot$view$validate(vs){
var entries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(vs),cljs.core.cst$kw$schema);
var reqd = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (entries){
return (function (p__26105){
var vec__26106 = p__26105;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26106,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26106,(1),null);
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(v,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$required], null));
});})(entries))
,entries);
var invalid = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (entries,reqd){
return (function (p1__26104_SHARP_){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$buffer,cljs.core.first(p1__26104_SHARP_),cljs.core.cst$kw$value], null));
var or__6624__auto__ = (data == null);
if(or__6624__auto__){
return or__6624__auto__;
} else {
var or__6624__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(data,"");
if(or__6624__auto____$1){
return or__6624__auto____$1;
} else {
var or__6624__auto____$2 = (function (){var and__6612__auto__ = cljs.core.re_matches(/.*-id$/,cljs.core.name(cljs.core.first(p1__26104_SHARP_)));
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("-1",data);
} else {
return and__6612__auto__;
}
})();
if(cljs.core.truth_(or__6624__auto____$2)){
return or__6624__auto____$2;
} else {
return (cljs.core.coll_QMARK_(data)) && (cljs.core.empty_QMARK_(data));
}
}
}
});})(entries,reqd))
,reqd);
if((cljs.core.count(invalid) === (0))){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$show_DASH_validations,false);

return true;
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$show_DASH_validations,true);

return false;
}
});
/**
 * Mapping of keys to functions to generate drop-down menus.
 */
camelot.view.generators = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$camera_DASH_statuses,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vkey,cljs.core.cst$kw$camera_DASH_status_DASH_id,cljs.core.cst$kw$desc,cljs.core.cst$kw$camera_DASH_status_DASH_description,cljs.core.cst$kw$baseurl,"/camera-statuses"], null),cljs.core.cst$kw$survey_DASH_sites_DASH_available,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vkey,cljs.core.cst$kw$site_DASH_id,cljs.core.cst$kw$desc,cljs.core.cst$kw$site_DASH_name,cljs.core.cst$kw$baseurl,"/survey-sites"], null),cljs.core.cst$kw$taxonomy_DASH_available,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vkey,cljs.core.cst$kw$taxonomy_DASH_id,cljs.core.cst$kw$desc,cljs.core.cst$kw$taxonomy_DASH_label,cljs.core.cst$kw$baseurl,"/taxonomy"], null),cljs.core.cst$kw$species_DASH_mass,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vkey,cljs.core.cst$kw$species_DASH_mass_DASH_id,cljs.core.cst$kw$desc,cljs.core.cst$kw$species_DASH_mass_DASH_label,cljs.core.cst$kw$baseurl,"/species-mass"], null),cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_cameras_DASH_available,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vkey,cljs.core.cst$kw$camera_DASH_id,cljs.core.cst$kw$desc,cljs.core.cst$kw$camera_DASH_name,cljs.core.cst$kw$baseurl,"/trap-station-session-cameras"], null)], null);
camelot.view.create = (function camelot$view$create(success_key,error_key,vs,resources,key){

var parent_id = smithy.util.get_parent_resource_id(vs);
var basedata = cljs.core.deref(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer));
var data = (cljs.core.truth_(parent_id)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(basedata,smithy.util.get_screen_resource(vs,cljs.core.cst$kw$parent_DASH_id_DASH_key),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,parent_id], null)):basedata);
if(cljs.core.truth_(camelot.view.validate(vs))){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("create",smithy.util.get_resource_type_name(vs));

return camelot.rest.post_resource(smithy.util.get_endpoint(vs),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,data], null),((function (parent_id,basedata,data){
return (function (p1__26109_SHARP_){
camelot.view.load_resource_children(vs);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$readonly);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__26109_SHARP_));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__26109_SHARP_));

return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,success_key], null));
});})(parent_id,basedata,data))
);
} else {
return null;
}
});
camelot.view.map_to_params = (function camelot$view$map_to_params(m){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.reduce_kv((function (p1__26110_SHARP_,p2__26111_SHARP_,p3__26112_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__26110_SHARP_,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(p2__26111_SHARP_)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_((function (){var and__6612__auto__ = !((p3__26112_SHARP_ == null));
if(and__6612__auto__){
return (p3__26112_SHARP_["getTime"]);
} else {
return and__6612__auto__;
}
})())?p3__26112_SHARP_.getTime():p3__26112_SHARP_))].join(''));
}),cljs.core.PersistentVector.EMPTY,m));
});
camelot.view.create_nav = (function camelot$view$create_nav(success_key,error_key,vs,resources,key){

var basedata = cljs.core.deref(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer));
if(cljs.core.truth_(camelot.view.validate(vs))){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("create-nav",smithy.util.get_resource_type_name(vs));

return window.open(camelot.util.misc.with_baseurl([cljs.core.str.cljs$core$IFn$_invoke$arity$1(smithy.util.get_endpoint(vs)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(camelot.view.map_to_params(camelot.util.cursorise.decursorise(basedata)))].join('')));
} else {
return null;
}
});
camelot.view.submit_update = (function camelot$view$submit_update(success_key,error_key,vs,resources,key){

var cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,success_key], null));
if(cljs.core.truth_(camelot.view.validate(vs))){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(resources,key,cljs.core.deref(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer)));

camelot.component.nav.settings_hide_BANG_();

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("update",smithy.util.get_resource_type_name(vs));

return camelot.rest.put_resource(smithy.util.get_url(vs),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,cljs.core.deref(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer))], null),((function (cb){
return (function (){
if(cljs.core.truth_(smithy.util.settings_screen_QMARK_(vs))){
} else {
camelot.view.load_resource_children(vs);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$readonly);
}

if(cljs.core.truth_(cb)){
return (cb.cljs$core$IFn$_invoke$arity$0 ? cb.cljs$core$IFn$_invoke$arity$0() : cb.call(null));
} else {
return null;
}
});})(cb))
);
} else {
return null;
}
});
camelot.view.cancel_update = (function camelot$view$cancel_update(event_key,vs,resources,key){

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,cljs.core.deref(cljs.core.get.cljs$core$IFn$_invoke$arity$2(resources,key)));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$show_DASH_validations,false);

camelot.component.nav.settings_hide_BANG_();

camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("cancel-update",smithy.util.get_resource_type_name(vs));

if(cljs.core.truth_(smithy.util.settings_screen_QMARK_(vs))){
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$readonly);
}

var cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,event_key], null));
if(cljs.core.truth_(cb)){
return (cb.cljs$core$IFn$_invoke$arity$0 ? cb.cljs$core$IFn$_invoke$arity$0() : cb.call(null));
} else {
return null;
}
});
camelot.view.delete$ = (function camelot$view$delete(success_key,error_key,vs,resources,key){

var cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,success_key], null));
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("delete",smithy.util.get_resource_type_name(vs));

return camelot.rest.delete_resource(smithy.util.get_url(vs),cljs.core.PersistentArrayMap.EMPTY,((function (cb){
return (function (){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(resources,key,cljs.core.PersistentArrayMap.EMPTY);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,cljs.core.PersistentArrayMap.EMPTY);

camelot.view.load_resource_children(vs);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$create);

if(cljs.core.truth_(cb)){
return (cb.cljs$core$IFn$_invoke$arity$0 ? cb.cljs$core$IFn$_invoke$arity$0() : cb.call(null));
} else {
return null;
}
});})(cb))
);
});
camelot.view.delete_media = (function camelot$view$delete_media(success_key,error_key,vs,resources,key){

var cb = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,success_key], null));
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("delete-media",smithy.util.get_resource_type_name(vs));

return camelot.rest.delete_resource([cljs.core.str.cljs$core$IFn$_invoke$arity$1(smithy.util.get_url(vs)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/media")].join(''),cljs.core.PersistentArrayMap.EMPTY,((function (cb){
return (function (){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$create);

if(cljs.core.truth_(cb)){
return (cb.cljs$core$IFn$_invoke$arity$0 ? cb.cljs$core$IFn$_invoke$arity$0() : cb.call(null));
} else {
return null;
}
});})(cb))
);
});
/**
 * Drop-down menu generator for the given view-state.
 */
camelot.view.build_generator = (function camelot$view$build_generator(vs){
return (function (template,gendata,gen,genargs){
var to_dropdown = (function (p1__26113_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$vkey,cljs.core.cst$kw$desc],[cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__26113_SHARP_,cljs.core.cst$kw$vkey.cljs$core$IFn$_invoke$arity$1(template)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__26113_SHARP_,cljs.core.cst$kw$desc.cljs$core$IFn$_invoke$arity$1(template))]);
});
return camelot.rest.get_resource([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(template,cljs.core.cst$kw$baseurl)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)),cljs.core.cst$kw$create))?"available":"alternatives")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(genargs,cljs.core.cst$kw$id))].join(''),((function (to_dropdown){
return (function (p1__26114_SHARP_){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(gendata,gen,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(to_dropdown,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__26114_SHARP_)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vkey,"",cljs.core.cst$kw$desc,""], null)));
});})(to_dropdown))
);
});
});
/**
 * Mapping of actions to the corresponding action function.
 */
camelot.view.actions = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$edit_DASH_mode,cljs.core.cst$kw$trap_DASH_stations,cljs.core.cst$kw$survey_DASH_sites,cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_cameras,cljs.core.cst$kw$delete,cljs.core.cst$kw$load_DASH_resource_DASH_children,cljs.core.cst$kw$photos,cljs.core.cst$kw$delete_DASH_media,cljs.core.cst$kw$sightings,cljs.core.cst$kw$trap_DASH_station_DASH_sessions,cljs.core.cst$kw$media,cljs.core.cst$kw$load_DASH_resource],[(function (vs,rid){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$update);
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/trap-stations/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/survey-sites/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/trap-station-session-cameras/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
var screen = smithy.util.get_screen(vs);
if(cljs.core.truth_(confirm("Are you sure you wish to delete this?"))){
return camelot.view.delete$(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$success,cljs.core.cst$kw$event], null)),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$error,cljs.core.cst$kw$event], null)),vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details);
} else {
return null;
}
}),camelot.view.load_resource_children,(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/photos/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
var screen = smithy.util.get_screen(vs);
if(cljs.core.truth_(confirm("Are you sure you wish to delete all media taken in the session by this camera?"))){
return camelot.view.delete_media(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$success,cljs.core.cst$kw$event], null)),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$error,cljs.core.cst$kw$event], null)),vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details);
} else {
return null;
}
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/sightings/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/trap-station-sessions/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,rid){
return camelot.nav.breadnav_BANG_([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/media/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rid)].join(''),smithy.util.get_breadcrumb_label(vs),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$details], null)));
}),(function (vs,id){
var cs = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$children], null));
var rkey = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(vs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$resource,cljs.core.cst$kw$id], null));
var resource = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (cs,rkey){
return (function (p1__26115_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((id | (0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__26115_SHARP_,rkey));
});})(cs,rkey))
,cs));
if(cljs.core.truth_(resource)){
return camelot.rest.get_resource(cljs.core.cst$kw$uri.cljs$core$IFn$_invoke$arity$1(resource),((function (cs,rkey,resource){
return (function (resp){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(resp));

if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$resource_DASH_id], null)))){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$resource_DASH_id,null);
} else {
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$readonly);
}
});})(cs,rkey,resource))
);
} else {
return null;
}
})]);
/**
 * Mapping of events to event functions.
 */
camelot.view.events = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$nav_DASH_history,cljs.core.cst$kw$create_DASH_nav,cljs.core.cst$kw$settings_DASH_save,cljs.core.cst$kw$create,cljs.core.cst$kw$settings_DASH_cancel,cljs.core.cst$kw$update,cljs.core.cst$kw$delete,cljs.core.cst$kw$breadcrumb_DASH_item_DASH_click,cljs.core.cst$kw$build_DASH_generator,cljs.core.cst$kw$sidebar_DASH_item_DASH_click,cljs.core.cst$kw$sidebar_DASH_create_DASH_click,cljs.core.cst$kw$cancel_DASH_update,cljs.core.cst$kw$analytics_DASH_event],[(function (){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),cljs.core.cst$kw$nav_DASH_history);
}),camelot.view.create_nav,(function (d){
return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.resources_state(),cljs.core.cst$kw$settings,cljs.core.deref(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$buffer], null))));
}),camelot.view.create,(function (){
return cljs.core.identity((1));
}),camelot.view.submit_update,camelot.view.delete$,(function (token,vs,state){
camelot.nav.breadnav_consume_BANG_(token);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$readonly);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource),cljs.core.cst$kw$details,state);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,state);
}),camelot.view.build_generator,(function (vs,id){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("sidebar-navigate",smithy.util.get_resource_type_name(vs));

var fexpr__26116 = cljs.core.cst$kw$load_DASH_resource.cljs$core$IFn$_invoke$arity$1(camelot.view.actions);
return (fexpr__26116.cljs$core$IFn$_invoke$arity$2 ? fexpr__26116.cljs$core$IFn$_invoke$arity$2(vs,id) : fexpr__26116.call(null,vs,id));
}),(function (vs){
camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2("sidebar-create",smithy.util.get_resource_type_name(vs));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,cljs.core.PersistentArrayMap.EMPTY);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$screen),cljs.core.cst$kw$mode,cljs.core.cst$kw$create);
}),camelot.view.cancel_update,(function (event,action){
return camelot.nav.analytics_event.cljs$core$IFn$_invoke$arity$2(event,action);
})]);
/**
 * Render the navbar
 */
camelot.view.navbar = (function camelot$view$navbar(){
return om.core.root(camelot.component.nav.nav_component,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$target,document.getElementById("navigation")], null));
});
/**
 * Render the notification dialog
 */
camelot.view.notification_dialog = om.core.root(camelot.component.notification.notification_dialog_component,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$target,document.getElementById("notification-dialog")], null));
/**
 * Render the main page content
 */
camelot.view.generate_view = (function camelot$view$generate_view(var_args){
var args__7756__auto__ = [];
var len__7749__auto___26126 = arguments.length;
var i__7750__auto___26127 = (0);
while(true){
if((i__7750__auto___26127 < len__7749__auto___26126)){
args__7756__auto__.push((arguments[i__7750__auto___26127]));

var G__26128 = (i__7750__auto___26127 + (1));
i__7750__auto___26127 = G__26128;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic = (function (view,p__26120){
var vec__26121 = p__26120;
var map__26124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26121,(0),null);
var map__26124__$1 = ((((!((map__26124 == null)))?((((map__26124.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26124.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26124):map__26124);
var survey_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26124__$1,cljs.core.cst$kw$survey_DASH_id);
var page_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26124__$1,cljs.core.cst$kw$page_DASH_id);
var report_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26124__$1,cljs.core.cst$kw$report_DASH_key);
var camera_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26124__$1,cljs.core.cst$kw$camera_DASH_id);
var site_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26124__$1,cljs.core.cst$kw$site_DASH_id);
var taxonomy_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26124__$1,cljs.core.cst$kw$taxonomy_DASH_id);
var restricted_mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26124__$1,cljs.core.cst$kw$restricted_DASH_mode);
if(cljs.core.truth_(survey_id)){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$selected_DASH_survey,null);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$page_DASH_id,null);

return camelot.rest.get_x.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1("/surveys/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(survey_id)].join(''),((function (vec__26121,map__26124,map__26124__$1,survey_id,page_id,report_key,camera_id,site_id,taxonomy_id,restricted_mode){
return (function (p1__26117_SHARP_){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$selected_DASH_survey,cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(p1__26117_SHARP_));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$page_DASH_id,page_id);

return om.core.root(view,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$target,document.getElementById("page-content")], null));
});})(vec__26121,map__26124,map__26124__$1,survey_id,page_id,report_key,camera_id,site_id,taxonomy_id,restricted_mode))
);
} else {
return om.core.root(view,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$target,document.getElementById("page-content"),cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$report_DASH_key,report_key,cljs.core.cst$kw$camera_DASH_id,camera_id,cljs.core.cst$kw$taxonomy_DASH_id,taxonomy_id,cljs.core.cst$kw$restricted_DASH_mode,restricted_mode,cljs.core.cst$kw$site_DASH_id,site_id], null)], null));
}
});

camelot.view.generate_view.cljs$lang$maxFixedArity = (1);

camelot.view.generate_view.cljs$lang$applyTo = (function (seq26118){
var G__26119 = cljs.core.first(seq26118);
var seq26118__$1 = cljs.core.next(seq26118);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(G__26119,seq26118__$1);
});

/**
 * Render the settings panel
 */
camelot.view.settings_menu_view = (function camelot$view$settings_menu_view(){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$events,camelot.view.events);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$actions,camelot.view.actions);

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(camelot.state.app_state_cursor(),cljs.core.cst$kw$generators,camelot.view.generators);

if(cljs.core.truth_(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$screens.cljs$core$IFn$_invoke$arity$1(camelot.state.app_state_cursor())))){
return om.core.root(smithy.core.settings_view_component,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$target,document.getElementById("settings")], null));
} else {
return null;
}
});
camelot.view.page_content_view = (function camelot$view$page_content_view(type,mode,p__26129){
var map__26130 = p__26129;
var map__26130__$1 = ((((!((map__26130 == null)))?((((map__26130.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26130.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26130):map__26130);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26130__$1,cljs.core.cst$kw$id);
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26130__$1,cljs.core.cst$kw$resource_DASH_id);
if((!((cljs.core.cst$kw$view.cljs$core$IFn$_invoke$arity$1(camelot.state.app_state_cursor()) == null))) && (!((cljs.core.cst$kw$resources.cljs$core$IFn$_invoke$arity$1(camelot.state.app_state_cursor()) == null)))){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(camelot.state.app_state_cursor(),cljs.core.cst$kw$view),cljs.core.cst$kw$content,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$screen,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$mode,mode,cljs.core.cst$kw$id,id,cljs.core.cst$kw$resource_DASH_id,resource_id], null),cljs.core.cst$kw$buffer,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$selected_DASH_resource,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$generator_DASH_data,cljs.core.PersistentArrayMap.EMPTY], null));

return om.core.root(smithy.core.content_view_component,camelot.state.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$target,document.getElementById("page-content")], null));
} else {
return null;
}
});
var action__16778__auto___26137 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26132 = params__16779__auto__;
var map__26132__$1 = ((((!((map__26132 == null)))?((((map__26132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26132):map__26132);
return camelot.view.page_content_view(cljs.core.cst$kw$survey,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26134 = params__16779__auto__;
return camelot.view.page_content_view(cljs.core.cst$kw$survey,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/surveys",action__16778__auto___26137);

var action__16778__auto___26143 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26138 = params__16779__auto__;
var map__26138__$1 = ((((!((map__26138 == null)))?((((map__26138.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26138.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26138):map__26138);
var mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26138__$1,cljs.core.cst$kw$mode);
var rid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26138__$1,cljs.core.cst$kw$rid);
return camelot.view.page_content_view(cljs.core.cst$kw$survey,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(mode),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$resource_DASH_id,rid], null));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26140 = params__16779__auto__;
var mode = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26140,(0),null);
var rid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26140,(1),null);
return camelot.view.page_content_view(cljs.core.cst$kw$survey,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(mode),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$resource_DASH_id,rid], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/surveys/:mode/:rid",action__16778__auto___26143);

var action__16778__auto___26149 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26144 = params__16779__auto__;
var map__26144__$1 = ((((!((map__26144 == null)))?((((map__26144.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26144.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26144):map__26144);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26144__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26146 = params__16779__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26146,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/trap-station-session-cameras/:id",action__16778__auto___26149);

var action__16778__auto___26155 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26150 = params__16779__auto__;
var map__26150__$1 = ((((!((map__26150 == null)))?((((map__26150.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26150.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26150):map__26150);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26150__$1,cljs.core.cst$kw$id);
var mode = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26150__$1,cljs.core.cst$kw$mode);
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26150__$1,cljs.core.cst$kw$resource_DASH_id);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(mode),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$resource_DASH_id,resource_id,cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26152 = params__16779__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26152,(0),null);
var mode = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26152,(1),null);
var resource_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26152,(2),null);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session_DASH_camera,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(mode),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$resource_DASH_id,resource_id,cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/trap-station-session-cameras/:id/:mode/:resource-id",action__16778__auto___26155);

var action__16778__auto___26161 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26156 = params__16779__auto__;
var map__26156__$1 = ((((!((map__26156 == null)))?((((map__26156.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26156.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26156):map__26156);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26156__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26158 = params__16779__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26158,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station_DASH_session,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/trap-station-sessions/:id",action__16778__auto___26161);

var action__16778__auto___26167 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26162 = params__16779__auto__;
var map__26162__$1 = ((((!((map__26162 == null)))?((((map__26162.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26162.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26162):map__26162);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26162__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$media,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26164 = params__16779__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26164,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$media,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/media/:id",action__16778__auto___26167);

var action__16778__auto___26173 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26168 = params__16779__auto__;
var map__26168__$1 = ((((!((map__26168 == null)))?((((map__26168.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26168.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26168):map__26168);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26168__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$photo,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26170 = params__16779__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26170,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$photo,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/photos/:id",action__16778__auto___26173);

var action__16778__auto___26179 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26174 = params__16779__auto__;
var map__26174__$1 = ((((!((map__26174 == null)))?((((map__26174.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26174.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26174):map__26174);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26174__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$sighting,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26176 = params__16779__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26176,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$sighting,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/sightings/:id",action__16778__auto___26179);

var action__16778__auto___26185 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26180 = params__16779__auto__;
var map__26180__$1 = ((((!((map__26180 == null)))?((((map__26180.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26180.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26180):map__26180);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26180__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26182 = params__16779__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26182,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$trap_DASH_station,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/trap-stations/:id",action__16778__auto___26185);

var action__16778__auto___26191 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26186 = params__16779__auto__;
var map__26186__$1 = ((((!((map__26186 == null)))?((((map__26186.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26186.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26186):map__26186);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26186__$1,cljs.core.cst$kw$id);
return camelot.view.page_content_view(cljs.core.cst$kw$survey_DASH_site,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26188 = params__16779__auto__;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26188,(0),null);
return camelot.view.page_content_view(cljs.core.cst$kw$survey_DASH_site,cljs.core.cst$kw$create,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/survey-sites/:id",action__16778__auto___26191);

var action__16778__auto___26197 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26192 = params__16779__auto__;
var map__26192__$1 = ((((!((map__26192 == null)))?((((map__26192.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26192.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26192):map__26192);
return camelot.view.page_content_view(cljs.core.cst$kw$site,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26194 = params__16779__auto__;
return camelot.view.page_content_view(cljs.core.cst$kw$site,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/sites",action__16778__auto___26197);

var action__16778__auto___26203 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26198 = params__16779__auto__;
var map__26198__$1 = ((((!((map__26198 == null)))?((((map__26198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26198.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26198):map__26198);
return camelot.view.page_content_view(cljs.core.cst$kw$camera,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26200 = params__16779__auto__;
return camelot.view.page_content_view(cljs.core.cst$kw$camera,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/cameras",action__16778__auto___26203);

var action__16778__auto___26209 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26204 = params__16779__auto__;
var map__26204__$1 = ((((!((map__26204 == null)))?((((map__26204.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26204.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26204):map__26204);
return camelot.view.page_content_view(cljs.core.cst$kw$taxonomy,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26206 = params__16779__auto__;
return camelot.view.page_content_view(cljs.core.cst$kw$taxonomy,cljs.core.cst$kw$create,cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/taxonomy",action__16778__auto___26209);

var action__16778__auto___26215 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26210 = params__16779__auto__;
var map__26210__$1 = ((((!((map__26210 == null)))?((((map__26210.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26210.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26210):map__26210);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.library.core.library_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$restricted_DASH_mode,true], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26212 = params__16779__auto__;
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.library.core.library_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$restricted_DASH_mode,true], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/library/restricted",action__16778__auto___26215);

var action__16778__auto___26221 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26216 = params__16779__auto__;
var map__26216__$1 = ((((!((map__26216 == null)))?((((map__26216.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26216.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26216):map__26216);
return camelot.view.generate_view(camelot.component.library.core.library_view_component);
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26218 = params__16779__auto__;
return camelot.view.generate_view(camelot.component.library.core.library_view_component);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/library",action__16778__auto___26221);

var action__16778__auto___26227 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26222 = params__16779__auto__;
var map__26222__$1 = ((((!((map__26222 == null)))?((((map__26222.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26222.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26222):map__26222);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26222__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.library.core.library_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26224 = params__16779__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26224,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.library.core.library_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/library",action__16778__auto___26227);

var action__16778__auto___26233 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26228 = params__16779__auto__;
var map__26228__$1 = ((((!((map__26228 == null)))?((((map__26228.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26228.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26228):map__26228);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26228__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.bulk_import.core.bulk_import_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26230 = params__16779__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26230,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.bulk_import.core.bulk_import_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/bulk-import",action__16778__auto___26233);

var action__16778__auto___26239 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26234 = params__16779__auto__;
var map__26234__$1 = ((((!((map__26234 == null)))?((((map__26234.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26234.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26234):map__26234);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26234__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.bulk_import.mapper.bulk_import_mapping_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26236 = params__16779__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26236,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.bulk_import.mapper.bulk_import_mapping_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/bulk-import/mapper",action__16778__auto___26239);

var action__16778__auto___26245 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26240 = params__16779__auto__;
var map__26240__$1 = ((((!((map__26240 == null)))?((((map__26240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26240.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26240):map__26240);
return camelot.view.generate_view(camelot.component.organisation.organisation_view);
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26242 = params__16779__auto__;
return camelot.view.generate_view(camelot.component.organisation.organisation_view);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/organisation",action__16778__auto___26245);

var action__16778__auto___26251 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26246 = params__16779__auto__;
var map__26246__$1 = ((((!((map__26246 == null)))?((((map__26246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26246.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26246):map__26246);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26246__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.survey.core.survey_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26248 = params__16779__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26248,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.survey.core.survey_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey",action__16778__auto___26251);

var action__16778__auto___26257 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26252 = params__16779__auto__;
var map__26252__$1 = ((((!((map__26252 == null)))?((((map__26252.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26252.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26252):map__26252);
var taxonomy_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26252__$1,cljs.core.cst$kw$taxonomy_DASH_id);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.species.core.update_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$taxonomy_DASH_id,taxonomy_id], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26254 = params__16779__auto__;
var taxonomy_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26254,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.species.core.update_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$taxonomy_DASH_id,taxonomy_id], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/taxonomy/:taxonomy-id",action__16778__auto___26257);

var action__16778__auto___26263 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26258 = params__16779__auto__;
var map__26258__$1 = ((((!((map__26258 == null)))?((((map__26258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26258.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26258):map__26258);
var camera_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26258__$1,cljs.core.cst$kw$camera_DASH_id);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.camera.core.manage_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$camera_DASH_id,camera_id], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26260 = params__16779__auto__;
var camera_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26260,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.camera.core.manage_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$camera_DASH_id,camera_id], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/camera/:camera-id",action__16778__auto___26263);

var action__16778__auto___26269 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26264 = params__16779__auto__;
var map__26264__$1 = ((((!((map__26264 == null)))?((((map__26264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26264.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26264):map__26264);
var site_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26264__$1,cljs.core.cst$kw$site_DASH_id);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.site.core.manage_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$site_DASH_id,site_id], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26266 = params__16779__auto__;
var site_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26266,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.site.core.manage_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$site_DASH_id,site_id], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/site/:site-id",action__16778__auto___26269);

var action__16778__auto___26275 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26270 = params__16779__auto__;
var map__26270__$1 = ((((!((map__26270 == null)))?((((map__26270.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26270.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26270):map__26270);
var report_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26270__$1,cljs.core.cst$kw$report_DASH_key);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.report.core.configure_report_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$report_DASH_key,report_key], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26272 = params__16779__auto__;
var report_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26272,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.report.core.configure_report_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$report_DASH_key,report_key], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/report/:report-key",action__16778__auto___26275);

var action__16778__auto___26281 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26276 = params__16779__auto__;
var map__26276__$1 = ((((!((map__26276 == null)))?((((map__26276.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26276.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26276):map__26276);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26276__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.species.core.manage_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26278 = params__16779__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26278,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.species.core.manage_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/taxonomy",action__16778__auto___26281);

var action__16778__auto___26287 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26282 = params__16779__auto__;
var map__26282__$1 = ((((!((map__26282 == null)))?((((map__26282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26282.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26282):map__26282);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26282__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.survey.core.edit_details_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26284 = params__16779__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26284,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.survey.core.edit_details_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/details",action__16778__auto___26287);

var action__16778__auto___26293 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26288 = params__16779__auto__;
var map__26288__$1 = ((((!((map__26288 == null)))?((((map__26288.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26288.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26288):map__26288);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26288__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.survey.core.sighting_fields_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26290 = params__16779__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26290,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.survey.core.sighting_fields_view,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/sighting-fields",action__16778__auto___26293);

var action__16778__auto___26299 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26294 = params__16779__auto__;
var map__26294__$1 = ((((!((map__26294 == null)))?((((map__26294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26294.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26294):map__26294);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26294__$1,cljs.core.cst$kw$survey);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.create_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26296 = params__16779__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26296,(0),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.create_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$survey_DASH_id,survey], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/deployments/create",action__16778__auto___26299);

var action__16778__auto___26305 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26300 = params__16779__auto__;
var map__26300__$1 = ((((!((map__26300 == null)))?((((map__26300.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26300.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26300):map__26300);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26300__$1,cljs.core.cst$kw$survey);
var trap_station_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26300__$1,cljs.core.cst$kw$trap_DASH_station_DASH_id);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.edit_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$survey_DASH_id,survey,cljs.core.cst$kw$page_DASH_id,trap_station_id], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26302 = params__16779__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26302,(0),null);
var trap_station_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26302,(1),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.edit_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$survey_DASH_id,survey,cljs.core.cst$kw$page_DASH_id,trap_station_id], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/deployments/:trap-station-id/edit",action__16778__auto___26305);

var action__16778__auto___26311 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26306 = params__16779__auto__;
var map__26306__$1 = ((((!((map__26306 == null)))?((((map__26306.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26306.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26306):map__26306);
var survey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26306__$1,cljs.core.cst$kw$survey);
var trap_station_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26306__$1,cljs.core.cst$kw$trap_DASH_station_DASH_id);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.deployment_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$survey_DASH_id,survey,cljs.core.cst$kw$page_DASH_id,trap_station_id], null)], 0));
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26308 = params__16779__auto__;
var survey = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26308,(0),null);
var trap_station_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26308,(1),null);
return camelot.view.generate_view.cljs$core$IFn$_invoke$arity$variadic(camelot.component.deployment.core.deployment_view_component,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$survey_DASH_id,survey,cljs.core.cst$kw$page_DASH_id,trap_station_id], null)], 0));
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/:survey/deployments/:trap-station-id",action__16778__auto___26311);

var action__16778__auto___26317 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26312 = params__16779__auto__;
var map__26312__$1 = ((((!((map__26312 == null)))?((((map__26312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26312.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26312):map__26312);
return camelot.view.generate_view(camelot.component.survey.core.create_view_component);
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26314 = params__16779__auto__;
return camelot.view.generate_view(camelot.component.survey.core.create_view_component);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("/survey/create",action__16778__auto___26317);

var action__16778__auto___26323 = (function (params__16779__auto__){
if(cljs.core.map_QMARK_(params__16779__auto__)){
var map__26318 = params__16779__auto__;
var map__26318__$1 = ((((!((map__26318 == null)))?((((map__26318.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26318.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26318):map__26318);
return camelot.view.generate_view(camelot.component.notification.not_found_page_component);
} else {
if(cljs.core.vector_QMARK_(params__16779__auto__)){
var vec__26320 = params__16779__auto__;
return camelot.view.generate_view(camelot.component.notification.not_found_page_component);
} else {
return null;
}
}
});
secretary.core.add_route_BANG_("*",action__16778__auto___26323);

