// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__14868 = arguments.length;
switch (G__14868) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async14869 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14869 = (function (f,blockable,meta14870){
this.f = f;
this.blockable = blockable;
this.meta14870 = meta14870;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async14869.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14871,meta14870__$1){
var self__ = this;
var _14871__$1 = this;
return (new cljs.core.async.t_cljs$core$async14869(self__.f,self__.blockable,meta14870__$1));
});

cljs.core.async.t_cljs$core$async14869.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14871){
var self__ = this;
var _14871__$1 = this;
return self__.meta14870;
});

cljs.core.async.t_cljs$core$async14869.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14869.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14869.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async14869.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async14869.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta14870], null);
});

cljs.core.async.t_cljs$core$async14869.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14869.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14869";

cljs.core.async.t_cljs$core$async14869.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"cljs.core.async/t_cljs$core$async14869");
});

cljs.core.async.__GT_t_cljs$core$async14869 = (function cljs$core$async$__GT_t_cljs$core$async14869(f__$1,blockable__$1,meta14870){
return (new cljs.core.async.t_cljs$core$async14869(f__$1,blockable__$1,meta14870));
});

}

return (new cljs.core.async.t_cljs$core$async14869(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__14875 = arguments.length;
switch (G__14875) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__14878 = arguments.length;
switch (G__14878) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__14881 = arguments.length;
switch (G__14881) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_14883 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14883) : fn1.call(null,val_14883));
} else {
cljs.core.async.impl.dispatch.run(((function (val_14883,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14883) : fn1.call(null,val_14883));
});})(val_14883,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__14885 = arguments.length;
switch (G__14885) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7548__auto___14887 = n;
var x_14888 = (0);
while(true){
if((x_14888 < n__7548__auto___14887)){
(a[x_14888] = (0));

var G__14889 = (x_14888 + (1));
x_14888 = G__14889;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__14890 = (i + (1));
i = G__14890;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async14891 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14891 = (function (flag,meta14892){
this.flag = flag;
this.meta14892 = meta14892;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async14891.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_14893,meta14892__$1){
var self__ = this;
var _14893__$1 = this;
return (new cljs.core.async.t_cljs$core$async14891(self__.flag,meta14892__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async14891.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_14893){
var self__ = this;
var _14893__$1 = this;
return self__.meta14892;
});})(flag))
;

cljs.core.async.t_cljs$core$async14891.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14891.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async14891.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14891.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async14891.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta14892], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async14891.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14891.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14891";

cljs.core.async.t_cljs$core$async14891.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"cljs.core.async/t_cljs$core$async14891");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async14891 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14891(flag__$1,meta14892){
return (new cljs.core.async.t_cljs$core$async14891(flag__$1,meta14892));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async14891(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async14894 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14894 = (function (flag,cb,meta14895){
this.flag = flag;
this.cb = cb;
this.meta14895 = meta14895;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async14894.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14896,meta14895__$1){
var self__ = this;
var _14896__$1 = this;
return (new cljs.core.async.t_cljs$core$async14894(self__.flag,self__.cb,meta14895__$1));
});

cljs.core.async.t_cljs$core$async14894.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14896){
var self__ = this;
var _14896__$1 = this;
return self__.meta14895;
});

cljs.core.async.t_cljs$core$async14894.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14894.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async14894.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async14894.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async14894.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta14895], null);
});

cljs.core.async.t_cljs$core$async14894.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14894.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14894";

cljs.core.async.t_cljs$core$async14894.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"cljs.core.async/t_cljs$core$async14894");
});

cljs.core.async.__GT_t_cljs$core$async14894 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14894(flag__$1,cb__$1,meta14895){
return (new cljs.core.async.t_cljs$core$async14894(flag__$1,cb__$1,meta14895));
});

}

return (new cljs.core.async.t_cljs$core$async14894(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14897_SHARP_){
var G__14899 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14897_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14899) : fret.call(null,G__14899));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14898_SHARP_){
var G__14900 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14898_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14900) : fret.call(null,G__14900));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__6624__auto__ = wport;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14901 = (i + (1));
i = G__14901;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6624__auto__ = ret;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6612__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6612__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7756__auto__ = [];
var len__7749__auto___14907 = arguments.length;
var i__7750__auto___14908 = (0);
while(true){
if((i__7750__auto___14908 < len__7749__auto___14907)){
args__7756__auto__.push((arguments[i__7750__auto___14908]));

var G__14909 = (i__7750__auto___14908 + (1));
i__7750__auto___14908 = G__14909;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14904){
var map__14905 = p__14904;
var map__14905__$1 = ((((!((map__14905 == null)))?((((map__14905.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14905.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14905):map__14905);
var opts = map__14905__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14902){
var G__14903 = cljs.core.first(seq14902);
var seq14902__$1 = cljs.core.next(seq14902);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14903,seq14902__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__14911 = arguments.length;
switch (G__14911) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14822__auto___14957 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___14957){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___14957){
return (function (state_14935){
var state_val_14936 = (state_14935[(1)]);
if((state_val_14936 === (7))){
var inst_14931 = (state_14935[(2)]);
var state_14935__$1 = state_14935;
var statearr_14937_14958 = state_14935__$1;
(statearr_14937_14958[(2)] = inst_14931);

(statearr_14937_14958[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14936 === (1))){
var state_14935__$1 = state_14935;
var statearr_14938_14959 = state_14935__$1;
(statearr_14938_14959[(2)] = null);

(statearr_14938_14959[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14936 === (4))){
var inst_14914 = (state_14935[(7)]);
var inst_14914__$1 = (state_14935[(2)]);
var inst_14915 = (inst_14914__$1 == null);
var state_14935__$1 = (function (){var statearr_14939 = state_14935;
(statearr_14939[(7)] = inst_14914__$1);

return statearr_14939;
})();
if(cljs.core.truth_(inst_14915)){
var statearr_14940_14960 = state_14935__$1;
(statearr_14940_14960[(1)] = (5));

} else {
var statearr_14941_14961 = state_14935__$1;
(statearr_14941_14961[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14936 === (13))){
var state_14935__$1 = state_14935;
var statearr_14942_14962 = state_14935__$1;
(statearr_14942_14962[(2)] = null);

(statearr_14942_14962[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14936 === (6))){
var inst_14914 = (state_14935[(7)]);
var state_14935__$1 = state_14935;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14935__$1,(11),to,inst_14914);
} else {
if((state_val_14936 === (3))){
var inst_14933 = (state_14935[(2)]);
var state_14935__$1 = state_14935;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14935__$1,inst_14933);
} else {
if((state_val_14936 === (12))){
var state_14935__$1 = state_14935;
var statearr_14943_14963 = state_14935__$1;
(statearr_14943_14963[(2)] = null);

(statearr_14943_14963[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14936 === (2))){
var state_14935__$1 = state_14935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14935__$1,(4),from);
} else {
if((state_val_14936 === (11))){
var inst_14924 = (state_14935[(2)]);
var state_14935__$1 = state_14935;
if(cljs.core.truth_(inst_14924)){
var statearr_14944_14964 = state_14935__$1;
(statearr_14944_14964[(1)] = (12));

} else {
var statearr_14945_14965 = state_14935__$1;
(statearr_14945_14965[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14936 === (9))){
var state_14935__$1 = state_14935;
var statearr_14946_14966 = state_14935__$1;
(statearr_14946_14966[(2)] = null);

(statearr_14946_14966[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14936 === (5))){
var state_14935__$1 = state_14935;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14947_14967 = state_14935__$1;
(statearr_14947_14967[(1)] = (8));

} else {
var statearr_14948_14968 = state_14935__$1;
(statearr_14948_14968[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14936 === (14))){
var inst_14929 = (state_14935[(2)]);
var state_14935__$1 = state_14935;
var statearr_14949_14969 = state_14935__$1;
(statearr_14949_14969[(2)] = inst_14929);

(statearr_14949_14969[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14936 === (10))){
var inst_14921 = (state_14935[(2)]);
var state_14935__$1 = state_14935;
var statearr_14950_14970 = state_14935__$1;
(statearr_14950_14970[(2)] = inst_14921);

(statearr_14950_14970[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14936 === (8))){
var inst_14918 = cljs.core.async.close_BANG_(to);
var state_14935__$1 = state_14935;
var statearr_14951_14971 = state_14935__$1;
(statearr_14951_14971[(2)] = inst_14918);

(statearr_14951_14971[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___14957))
;
return ((function (switch__14722__auto__,c__14822__auto___14957){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_14952 = [null,null,null,null,null,null,null,null];
(statearr_14952[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_14952[(1)] = (1));

return statearr_14952;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_14935){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_14935);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e14953){if((e14953 instanceof Object)){
var ex__14726__auto__ = e14953;
var statearr_14954_14972 = state_14935;
(statearr_14954_14972[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14935);

return cljs.core.cst$kw$recur;
} else {
throw e14953;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__14973 = state_14935;
state_14935 = G__14973;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_14935){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_14935);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___14957))
})();
var state__14824__auto__ = (function (){var statearr_14955 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_14955[(6)] = c__14822__auto___14957);

return statearr_14955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___14957))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__14974){
var vec__14975 = p__14974;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14975,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14975,(1),null);
var job = vec__14975;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__14822__auto___15146 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___15146,res,vec__14975,v,p,job,jobs,results){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___15146,res,vec__14975,v,p,job,jobs,results){
return (function (state_14982){
var state_val_14983 = (state_14982[(1)]);
if((state_val_14983 === (1))){
var state_14982__$1 = state_14982;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14982__$1,(2),res,v);
} else {
if((state_val_14983 === (2))){
var inst_14979 = (state_14982[(2)]);
var inst_14980 = cljs.core.async.close_BANG_(res);
var state_14982__$1 = (function (){var statearr_14984 = state_14982;
(statearr_14984[(7)] = inst_14979);

return statearr_14984;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14982__$1,inst_14980);
} else {
return null;
}
}
});})(c__14822__auto___15146,res,vec__14975,v,p,job,jobs,results))
;
return ((function (switch__14722__auto__,c__14822__auto___15146,res,vec__14975,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0 = (function (){
var statearr_14985 = [null,null,null,null,null,null,null,null];
(statearr_14985[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__);

(statearr_14985[(1)] = (1));

return statearr_14985;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1 = (function (state_14982){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_14982);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e14986){if((e14986 instanceof Object)){
var ex__14726__auto__ = e14986;
var statearr_14987_15147 = state_14982;
(statearr_14987_15147[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_14982);

return cljs.core.cst$kw$recur;
} else {
throw e14986;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__15148 = state_14982;
state_14982 = G__15148;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__ = function(state_14982){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1.call(this,state_14982);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___15146,res,vec__14975,v,p,job,jobs,results))
})();
var state__14824__auto__ = (function (){var statearr_14988 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_14988[(6)] = c__14822__auto___15146);

return statearr_14988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___15146,res,vec__14975,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__14989){
var vec__14990 = p__14989;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14990,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14990,(1),null);
var job = vec__14990;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7548__auto___15149 = n;
var __15150 = (0);
while(true){
if((__15150 < n__7548__auto___15149)){
var G__14993_15151 = type;
var G__14993_15152__$1 = (((G__14993_15151 instanceof cljs.core.Keyword))?G__14993_15151.fqn:null);
switch (G__14993_15152__$1) {
case "compute":
var c__14822__auto___15154 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15150,c__14822__auto___15154,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (__15150,c__14822__auto___15154,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async){
return (function (state_15006){
var state_val_15007 = (state_15006[(1)]);
if((state_val_15007 === (1))){
var state_15006__$1 = state_15006;
var statearr_15008_15155 = state_15006__$1;
(statearr_15008_15155[(2)] = null);

(statearr_15008_15155[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (2))){
var state_15006__$1 = state_15006;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15006__$1,(4),jobs);
} else {
if((state_val_15007 === (3))){
var inst_15004 = (state_15006[(2)]);
var state_15006__$1 = state_15006;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15006__$1,inst_15004);
} else {
if((state_val_15007 === (4))){
var inst_14996 = (state_15006[(2)]);
var inst_14997 = process(inst_14996);
var state_15006__$1 = state_15006;
if(cljs.core.truth_(inst_14997)){
var statearr_15009_15156 = state_15006__$1;
(statearr_15009_15156[(1)] = (5));

} else {
var statearr_15010_15157 = state_15006__$1;
(statearr_15010_15157[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (5))){
var state_15006__$1 = state_15006;
var statearr_15011_15158 = state_15006__$1;
(statearr_15011_15158[(2)] = null);

(statearr_15011_15158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (6))){
var state_15006__$1 = state_15006;
var statearr_15012_15159 = state_15006__$1;
(statearr_15012_15159[(2)] = null);

(statearr_15012_15159[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15007 === (7))){
var inst_15002 = (state_15006[(2)]);
var state_15006__$1 = state_15006;
var statearr_15013_15160 = state_15006__$1;
(statearr_15013_15160[(2)] = inst_15002);

(statearr_15013_15160[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__15150,c__14822__auto___15154,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async))
;
return ((function (__15150,switch__14722__auto__,c__14822__auto___15154,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0 = (function (){
var statearr_15014 = [null,null,null,null,null,null,null];
(statearr_15014[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__);

(statearr_15014[(1)] = (1));

return statearr_15014;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1 = (function (state_15006){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_15006);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e15015){if((e15015 instanceof Object)){
var ex__14726__auto__ = e15015;
var statearr_15016_15161 = state_15006;
(statearr_15016_15161[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15006);

return cljs.core.cst$kw$recur;
} else {
throw e15015;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__15162 = state_15006;
state_15006 = G__15162;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__ = function(state_15006){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1.call(this,state_15006);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__;
})()
;})(__15150,switch__14722__auto__,c__14822__auto___15154,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async))
})();
var state__14824__auto__ = (function (){var statearr_15017 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_15017[(6)] = c__14822__auto___15154);

return statearr_15017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(__15150,c__14822__auto___15154,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async))
);


break;
case "async":
var c__14822__auto___15163 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15150,c__14822__auto___15163,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (__15150,c__14822__auto___15163,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async){
return (function (state_15030){
var state_val_15031 = (state_15030[(1)]);
if((state_val_15031 === (1))){
var state_15030__$1 = state_15030;
var statearr_15032_15164 = state_15030__$1;
(statearr_15032_15164[(2)] = null);

(statearr_15032_15164[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15031 === (2))){
var state_15030__$1 = state_15030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15030__$1,(4),jobs);
} else {
if((state_val_15031 === (3))){
var inst_15028 = (state_15030[(2)]);
var state_15030__$1 = state_15030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15030__$1,inst_15028);
} else {
if((state_val_15031 === (4))){
var inst_15020 = (state_15030[(2)]);
var inst_15021 = async(inst_15020);
var state_15030__$1 = state_15030;
if(cljs.core.truth_(inst_15021)){
var statearr_15033_15165 = state_15030__$1;
(statearr_15033_15165[(1)] = (5));

} else {
var statearr_15034_15166 = state_15030__$1;
(statearr_15034_15166[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15031 === (5))){
var state_15030__$1 = state_15030;
var statearr_15035_15167 = state_15030__$1;
(statearr_15035_15167[(2)] = null);

(statearr_15035_15167[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15031 === (6))){
var state_15030__$1 = state_15030;
var statearr_15036_15168 = state_15030__$1;
(statearr_15036_15168[(2)] = null);

(statearr_15036_15168[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15031 === (7))){
var inst_15026 = (state_15030[(2)]);
var state_15030__$1 = state_15030;
var statearr_15037_15169 = state_15030__$1;
(statearr_15037_15169[(2)] = inst_15026);

(statearr_15037_15169[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__15150,c__14822__auto___15163,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async))
;
return ((function (__15150,switch__14722__auto__,c__14822__auto___15163,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0 = (function (){
var statearr_15038 = [null,null,null,null,null,null,null];
(statearr_15038[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__);

(statearr_15038[(1)] = (1));

return statearr_15038;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1 = (function (state_15030){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_15030);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e15039){if((e15039 instanceof Object)){
var ex__14726__auto__ = e15039;
var statearr_15040_15170 = state_15030;
(statearr_15040_15170[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15030);

return cljs.core.cst$kw$recur;
} else {
throw e15039;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__15171 = state_15030;
state_15030 = G__15171;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__ = function(state_15030){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1.call(this,state_15030);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__;
})()
;})(__15150,switch__14722__auto__,c__14822__auto___15163,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async))
})();
var state__14824__auto__ = (function (){var statearr_15041 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_15041[(6)] = c__14822__auto___15163);

return statearr_15041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(__15150,c__14822__auto___15163,G__14993_15151,G__14993_15152__$1,n__7548__auto___15149,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14993_15152__$1)].join('')));

}

var G__15172 = (__15150 + (1));
__15150 = G__15172;
continue;
} else {
}
break;
}

var c__14822__auto___15173 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___15173,jobs,results,process,async){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___15173,jobs,results,process,async){
return (function (state_15063){
var state_val_15064 = (state_15063[(1)]);
if((state_val_15064 === (1))){
var state_15063__$1 = state_15063;
var statearr_15065_15174 = state_15063__$1;
(statearr_15065_15174[(2)] = null);

(statearr_15065_15174[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15064 === (2))){
var state_15063__$1 = state_15063;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15063__$1,(4),from);
} else {
if((state_val_15064 === (3))){
var inst_15061 = (state_15063[(2)]);
var state_15063__$1 = state_15063;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15063__$1,inst_15061);
} else {
if((state_val_15064 === (4))){
var inst_15044 = (state_15063[(7)]);
var inst_15044__$1 = (state_15063[(2)]);
var inst_15045 = (inst_15044__$1 == null);
var state_15063__$1 = (function (){var statearr_15066 = state_15063;
(statearr_15066[(7)] = inst_15044__$1);

return statearr_15066;
})();
if(cljs.core.truth_(inst_15045)){
var statearr_15067_15175 = state_15063__$1;
(statearr_15067_15175[(1)] = (5));

} else {
var statearr_15068_15176 = state_15063__$1;
(statearr_15068_15176[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15064 === (5))){
var inst_15047 = cljs.core.async.close_BANG_(jobs);
var state_15063__$1 = state_15063;
var statearr_15069_15177 = state_15063__$1;
(statearr_15069_15177[(2)] = inst_15047);

(statearr_15069_15177[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15064 === (6))){
var inst_15049 = (state_15063[(8)]);
var inst_15044 = (state_15063[(7)]);
var inst_15049__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_15050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15051 = [inst_15044,inst_15049__$1];
var inst_15052 = (new cljs.core.PersistentVector(null,2,(5),inst_15050,inst_15051,null));
var state_15063__$1 = (function (){var statearr_15070 = state_15063;
(statearr_15070[(8)] = inst_15049__$1);

return statearr_15070;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15063__$1,(8),jobs,inst_15052);
} else {
if((state_val_15064 === (7))){
var inst_15059 = (state_15063[(2)]);
var state_15063__$1 = state_15063;
var statearr_15071_15178 = state_15063__$1;
(statearr_15071_15178[(2)] = inst_15059);

(statearr_15071_15178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15064 === (8))){
var inst_15049 = (state_15063[(8)]);
var inst_15054 = (state_15063[(2)]);
var state_15063__$1 = (function (){var statearr_15072 = state_15063;
(statearr_15072[(9)] = inst_15054);

return statearr_15072;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15063__$1,(9),results,inst_15049);
} else {
if((state_val_15064 === (9))){
var inst_15056 = (state_15063[(2)]);
var state_15063__$1 = (function (){var statearr_15073 = state_15063;
(statearr_15073[(10)] = inst_15056);

return statearr_15073;
})();
var statearr_15074_15179 = state_15063__$1;
(statearr_15074_15179[(2)] = null);

(statearr_15074_15179[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___15173,jobs,results,process,async))
;
return ((function (switch__14722__auto__,c__14822__auto___15173,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0 = (function (){
var statearr_15075 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15075[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__);

(statearr_15075[(1)] = (1));

return statearr_15075;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1 = (function (state_15063){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_15063);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e15076){if((e15076 instanceof Object)){
var ex__14726__auto__ = e15076;
var statearr_15077_15180 = state_15063;
(statearr_15077_15180[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15063);

return cljs.core.cst$kw$recur;
} else {
throw e15076;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__15181 = state_15063;
state_15063 = G__15181;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__ = function(state_15063){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1.call(this,state_15063);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___15173,jobs,results,process,async))
})();
var state__14824__auto__ = (function (){var statearr_15078 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_15078[(6)] = c__14822__auto___15173);

return statearr_15078;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___15173,jobs,results,process,async))
);


var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,jobs,results,process,async){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,jobs,results,process,async){
return (function (state_15116){
var state_val_15117 = (state_15116[(1)]);
if((state_val_15117 === (7))){
var inst_15112 = (state_15116[(2)]);
var state_15116__$1 = state_15116;
var statearr_15118_15182 = state_15116__$1;
(statearr_15118_15182[(2)] = inst_15112);

(statearr_15118_15182[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (20))){
var state_15116__$1 = state_15116;
var statearr_15119_15183 = state_15116__$1;
(statearr_15119_15183[(2)] = null);

(statearr_15119_15183[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (1))){
var state_15116__$1 = state_15116;
var statearr_15120_15184 = state_15116__$1;
(statearr_15120_15184[(2)] = null);

(statearr_15120_15184[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (4))){
var inst_15081 = (state_15116[(7)]);
var inst_15081__$1 = (state_15116[(2)]);
var inst_15082 = (inst_15081__$1 == null);
var state_15116__$1 = (function (){var statearr_15121 = state_15116;
(statearr_15121[(7)] = inst_15081__$1);

return statearr_15121;
})();
if(cljs.core.truth_(inst_15082)){
var statearr_15122_15185 = state_15116__$1;
(statearr_15122_15185[(1)] = (5));

} else {
var statearr_15123_15186 = state_15116__$1;
(statearr_15123_15186[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (15))){
var inst_15094 = (state_15116[(8)]);
var state_15116__$1 = state_15116;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15116__$1,(18),to,inst_15094);
} else {
if((state_val_15117 === (21))){
var inst_15107 = (state_15116[(2)]);
var state_15116__$1 = state_15116;
var statearr_15124_15187 = state_15116__$1;
(statearr_15124_15187[(2)] = inst_15107);

(statearr_15124_15187[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (13))){
var inst_15109 = (state_15116[(2)]);
var state_15116__$1 = (function (){var statearr_15125 = state_15116;
(statearr_15125[(9)] = inst_15109);

return statearr_15125;
})();
var statearr_15126_15188 = state_15116__$1;
(statearr_15126_15188[(2)] = null);

(statearr_15126_15188[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (6))){
var inst_15081 = (state_15116[(7)]);
var state_15116__$1 = state_15116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15116__$1,(11),inst_15081);
} else {
if((state_val_15117 === (17))){
var inst_15102 = (state_15116[(2)]);
var state_15116__$1 = state_15116;
if(cljs.core.truth_(inst_15102)){
var statearr_15127_15189 = state_15116__$1;
(statearr_15127_15189[(1)] = (19));

} else {
var statearr_15128_15190 = state_15116__$1;
(statearr_15128_15190[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (3))){
var inst_15114 = (state_15116[(2)]);
var state_15116__$1 = state_15116;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15116__$1,inst_15114);
} else {
if((state_val_15117 === (12))){
var inst_15091 = (state_15116[(10)]);
var state_15116__$1 = state_15116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15116__$1,(14),inst_15091);
} else {
if((state_val_15117 === (2))){
var state_15116__$1 = state_15116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15116__$1,(4),results);
} else {
if((state_val_15117 === (19))){
var state_15116__$1 = state_15116;
var statearr_15129_15191 = state_15116__$1;
(statearr_15129_15191[(2)] = null);

(statearr_15129_15191[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (11))){
var inst_15091 = (state_15116[(2)]);
var state_15116__$1 = (function (){var statearr_15130 = state_15116;
(statearr_15130[(10)] = inst_15091);

return statearr_15130;
})();
var statearr_15131_15192 = state_15116__$1;
(statearr_15131_15192[(2)] = null);

(statearr_15131_15192[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (9))){
var state_15116__$1 = state_15116;
var statearr_15132_15193 = state_15116__$1;
(statearr_15132_15193[(2)] = null);

(statearr_15132_15193[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (5))){
var state_15116__$1 = state_15116;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15133_15194 = state_15116__$1;
(statearr_15133_15194[(1)] = (8));

} else {
var statearr_15134_15195 = state_15116__$1;
(statearr_15134_15195[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (14))){
var inst_15096 = (state_15116[(11)]);
var inst_15094 = (state_15116[(8)]);
var inst_15094__$1 = (state_15116[(2)]);
var inst_15095 = (inst_15094__$1 == null);
var inst_15096__$1 = cljs.core.not(inst_15095);
var state_15116__$1 = (function (){var statearr_15135 = state_15116;
(statearr_15135[(11)] = inst_15096__$1);

(statearr_15135[(8)] = inst_15094__$1);

return statearr_15135;
})();
if(inst_15096__$1){
var statearr_15136_15196 = state_15116__$1;
(statearr_15136_15196[(1)] = (15));

} else {
var statearr_15137_15197 = state_15116__$1;
(statearr_15137_15197[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (16))){
var inst_15096 = (state_15116[(11)]);
var state_15116__$1 = state_15116;
var statearr_15138_15198 = state_15116__$1;
(statearr_15138_15198[(2)] = inst_15096);

(statearr_15138_15198[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (10))){
var inst_15088 = (state_15116[(2)]);
var state_15116__$1 = state_15116;
var statearr_15139_15199 = state_15116__$1;
(statearr_15139_15199[(2)] = inst_15088);

(statearr_15139_15199[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (18))){
var inst_15099 = (state_15116[(2)]);
var state_15116__$1 = state_15116;
var statearr_15140_15200 = state_15116__$1;
(statearr_15140_15200[(2)] = inst_15099);

(statearr_15140_15200[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15117 === (8))){
var inst_15085 = cljs.core.async.close_BANG_(to);
var state_15116__$1 = state_15116;
var statearr_15141_15201 = state_15116__$1;
(statearr_15141_15201[(2)] = inst_15085);

(statearr_15141_15201[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__,jobs,results,process,async))
;
return ((function (switch__14722__auto__,c__14822__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0 = (function (){
var statearr_15142 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15142[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__);

(statearr_15142[(1)] = (1));

return statearr_15142;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1 = (function (state_15116){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_15116);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e15143){if((e15143 instanceof Object)){
var ex__14726__auto__ = e15143;
var statearr_15144_15202 = state_15116;
(statearr_15144_15202[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15116);

return cljs.core.cst$kw$recur;
} else {
throw e15143;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__15203 = state_15116;
state_15116 = G__15203;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__ = function(state_15116){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1.call(this,state_15116);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14723__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,jobs,results,process,async))
})();
var state__14824__auto__ = (function (){var statearr_15145 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_15145[(6)] = c__14822__auto__);

return statearr_15145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,jobs,results,process,async))
);

return c__14822__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__15205 = arguments.length;
switch (G__15205) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__15208 = arguments.length;
switch (G__15208) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__15211 = arguments.length;
switch (G__15211) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__14822__auto___15260 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___15260,tc,fc){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___15260,tc,fc){
return (function (state_15237){
var state_val_15238 = (state_15237[(1)]);
if((state_val_15238 === (7))){
var inst_15233 = (state_15237[(2)]);
var state_15237__$1 = state_15237;
var statearr_15239_15261 = state_15237__$1;
(statearr_15239_15261[(2)] = inst_15233);

(statearr_15239_15261[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15238 === (1))){
var state_15237__$1 = state_15237;
var statearr_15240_15262 = state_15237__$1;
(statearr_15240_15262[(2)] = null);

(statearr_15240_15262[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15238 === (4))){
var inst_15214 = (state_15237[(7)]);
var inst_15214__$1 = (state_15237[(2)]);
var inst_15215 = (inst_15214__$1 == null);
var state_15237__$1 = (function (){var statearr_15241 = state_15237;
(statearr_15241[(7)] = inst_15214__$1);

return statearr_15241;
})();
if(cljs.core.truth_(inst_15215)){
var statearr_15242_15263 = state_15237__$1;
(statearr_15242_15263[(1)] = (5));

} else {
var statearr_15243_15264 = state_15237__$1;
(statearr_15243_15264[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15238 === (13))){
var state_15237__$1 = state_15237;
var statearr_15244_15265 = state_15237__$1;
(statearr_15244_15265[(2)] = null);

(statearr_15244_15265[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15238 === (6))){
var inst_15214 = (state_15237[(7)]);
var inst_15220 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15214) : p.call(null,inst_15214));
var state_15237__$1 = state_15237;
if(cljs.core.truth_(inst_15220)){
var statearr_15245_15266 = state_15237__$1;
(statearr_15245_15266[(1)] = (9));

} else {
var statearr_15246_15267 = state_15237__$1;
(statearr_15246_15267[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15238 === (3))){
var inst_15235 = (state_15237[(2)]);
var state_15237__$1 = state_15237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15237__$1,inst_15235);
} else {
if((state_val_15238 === (12))){
var state_15237__$1 = state_15237;
var statearr_15247_15268 = state_15237__$1;
(statearr_15247_15268[(2)] = null);

(statearr_15247_15268[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15238 === (2))){
var state_15237__$1 = state_15237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15237__$1,(4),ch);
} else {
if((state_val_15238 === (11))){
var inst_15214 = (state_15237[(7)]);
var inst_15224 = (state_15237[(2)]);
var state_15237__$1 = state_15237;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15237__$1,(8),inst_15224,inst_15214);
} else {
if((state_val_15238 === (9))){
var state_15237__$1 = state_15237;
var statearr_15248_15269 = state_15237__$1;
(statearr_15248_15269[(2)] = tc);

(statearr_15248_15269[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15238 === (5))){
var inst_15217 = cljs.core.async.close_BANG_(tc);
var inst_15218 = cljs.core.async.close_BANG_(fc);
var state_15237__$1 = (function (){var statearr_15249 = state_15237;
(statearr_15249[(8)] = inst_15217);

return statearr_15249;
})();
var statearr_15250_15270 = state_15237__$1;
(statearr_15250_15270[(2)] = inst_15218);

(statearr_15250_15270[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15238 === (14))){
var inst_15231 = (state_15237[(2)]);
var state_15237__$1 = state_15237;
var statearr_15251_15271 = state_15237__$1;
(statearr_15251_15271[(2)] = inst_15231);

(statearr_15251_15271[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15238 === (10))){
var state_15237__$1 = state_15237;
var statearr_15252_15272 = state_15237__$1;
(statearr_15252_15272[(2)] = fc);

(statearr_15252_15272[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15238 === (8))){
var inst_15226 = (state_15237[(2)]);
var state_15237__$1 = state_15237;
if(cljs.core.truth_(inst_15226)){
var statearr_15253_15273 = state_15237__$1;
(statearr_15253_15273[(1)] = (12));

} else {
var statearr_15254_15274 = state_15237__$1;
(statearr_15254_15274[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___15260,tc,fc))
;
return ((function (switch__14722__auto__,c__14822__auto___15260,tc,fc){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_15255 = [null,null,null,null,null,null,null,null,null];
(statearr_15255[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_15255[(1)] = (1));

return statearr_15255;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_15237){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_15237);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e15256){if((e15256 instanceof Object)){
var ex__14726__auto__ = e15256;
var statearr_15257_15275 = state_15237;
(statearr_15257_15275[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15237);

return cljs.core.cst$kw$recur;
} else {
throw e15256;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__15276 = state_15237;
state_15237 = G__15276;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_15237){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_15237);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___15260,tc,fc))
})();
var state__14824__auto__ = (function (){var statearr_15258 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_15258[(6)] = c__14822__auto___15260);

return statearr_15258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___15260,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_15297){
var state_val_15298 = (state_15297[(1)]);
if((state_val_15298 === (7))){
var inst_15293 = (state_15297[(2)]);
var state_15297__$1 = state_15297;
var statearr_15299_15317 = state_15297__$1;
(statearr_15299_15317[(2)] = inst_15293);

(statearr_15299_15317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15298 === (1))){
var inst_15277 = init;
var state_15297__$1 = (function (){var statearr_15300 = state_15297;
(statearr_15300[(7)] = inst_15277);

return statearr_15300;
})();
var statearr_15301_15318 = state_15297__$1;
(statearr_15301_15318[(2)] = null);

(statearr_15301_15318[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15298 === (4))){
var inst_15280 = (state_15297[(8)]);
var inst_15280__$1 = (state_15297[(2)]);
var inst_15281 = (inst_15280__$1 == null);
var state_15297__$1 = (function (){var statearr_15302 = state_15297;
(statearr_15302[(8)] = inst_15280__$1);

return statearr_15302;
})();
if(cljs.core.truth_(inst_15281)){
var statearr_15303_15319 = state_15297__$1;
(statearr_15303_15319[(1)] = (5));

} else {
var statearr_15304_15320 = state_15297__$1;
(statearr_15304_15320[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15298 === (6))){
var inst_15277 = (state_15297[(7)]);
var inst_15280 = (state_15297[(8)]);
var inst_15284 = (state_15297[(9)]);
var inst_15284__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_15277,inst_15280) : f.call(null,inst_15277,inst_15280));
var inst_15285 = cljs.core.reduced_QMARK_(inst_15284__$1);
var state_15297__$1 = (function (){var statearr_15305 = state_15297;
(statearr_15305[(9)] = inst_15284__$1);

return statearr_15305;
})();
if(inst_15285){
var statearr_15306_15321 = state_15297__$1;
(statearr_15306_15321[(1)] = (8));

} else {
var statearr_15307_15322 = state_15297__$1;
(statearr_15307_15322[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15298 === (3))){
var inst_15295 = (state_15297[(2)]);
var state_15297__$1 = state_15297;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15297__$1,inst_15295);
} else {
if((state_val_15298 === (2))){
var state_15297__$1 = state_15297;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15297__$1,(4),ch);
} else {
if((state_val_15298 === (9))){
var inst_15284 = (state_15297[(9)]);
var inst_15277 = inst_15284;
var state_15297__$1 = (function (){var statearr_15308 = state_15297;
(statearr_15308[(7)] = inst_15277);

return statearr_15308;
})();
var statearr_15309_15323 = state_15297__$1;
(statearr_15309_15323[(2)] = null);

(statearr_15309_15323[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15298 === (5))){
var inst_15277 = (state_15297[(7)]);
var state_15297__$1 = state_15297;
var statearr_15310_15324 = state_15297__$1;
(statearr_15310_15324[(2)] = inst_15277);

(statearr_15310_15324[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15298 === (10))){
var inst_15291 = (state_15297[(2)]);
var state_15297__$1 = state_15297;
var statearr_15311_15325 = state_15297__$1;
(statearr_15311_15325[(2)] = inst_15291);

(statearr_15311_15325[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15298 === (8))){
var inst_15284 = (state_15297[(9)]);
var inst_15287 = cljs.core.deref(inst_15284);
var state_15297__$1 = state_15297;
var statearr_15312_15326 = state_15297__$1;
(statearr_15312_15326[(2)] = inst_15287);

(statearr_15312_15326[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14723__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14723__auto____0 = (function (){
var statearr_15313 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15313[(0)] = cljs$core$async$reduce_$_state_machine__14723__auto__);

(statearr_15313[(1)] = (1));

return statearr_15313;
});
var cljs$core$async$reduce_$_state_machine__14723__auto____1 = (function (state_15297){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_15297);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e15314){if((e15314 instanceof Object)){
var ex__14726__auto__ = e15314;
var statearr_15315_15327 = state_15297;
(statearr_15315_15327[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15297);

return cljs.core.cst$kw$recur;
} else {
throw e15314;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__15328 = state_15297;
state_15297 = G__15328;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14723__auto__ = function(state_15297){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14723__auto____1.call(this,state_15297);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14723__auto____0;
cljs$core$async$reduce_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14723__auto____1;
return cljs$core$async$reduce_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_15316 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_15316[(6)] = c__14822__auto__);

return statearr_15316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__15330 = arguments.length;
switch (G__15330) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_15355){
var state_val_15356 = (state_15355[(1)]);
if((state_val_15356 === (7))){
var inst_15337 = (state_15355[(2)]);
var state_15355__$1 = state_15355;
var statearr_15357_15378 = state_15355__$1;
(statearr_15357_15378[(2)] = inst_15337);

(statearr_15357_15378[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15356 === (1))){
var inst_15331 = cljs.core.seq(coll);
var inst_15332 = inst_15331;
var state_15355__$1 = (function (){var statearr_15358 = state_15355;
(statearr_15358[(7)] = inst_15332);

return statearr_15358;
})();
var statearr_15359_15379 = state_15355__$1;
(statearr_15359_15379[(2)] = null);

(statearr_15359_15379[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15356 === (4))){
var inst_15332 = (state_15355[(7)]);
var inst_15335 = cljs.core.first(inst_15332);
var state_15355__$1 = state_15355;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15355__$1,(7),ch,inst_15335);
} else {
if((state_val_15356 === (13))){
var inst_15349 = (state_15355[(2)]);
var state_15355__$1 = state_15355;
var statearr_15360_15380 = state_15355__$1;
(statearr_15360_15380[(2)] = inst_15349);

(statearr_15360_15380[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15356 === (6))){
var inst_15340 = (state_15355[(2)]);
var state_15355__$1 = state_15355;
if(cljs.core.truth_(inst_15340)){
var statearr_15361_15381 = state_15355__$1;
(statearr_15361_15381[(1)] = (8));

} else {
var statearr_15362_15382 = state_15355__$1;
(statearr_15362_15382[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15356 === (3))){
var inst_15353 = (state_15355[(2)]);
var state_15355__$1 = state_15355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15355__$1,inst_15353);
} else {
if((state_val_15356 === (12))){
var state_15355__$1 = state_15355;
var statearr_15363_15383 = state_15355__$1;
(statearr_15363_15383[(2)] = null);

(statearr_15363_15383[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15356 === (2))){
var inst_15332 = (state_15355[(7)]);
var state_15355__$1 = state_15355;
if(cljs.core.truth_(inst_15332)){
var statearr_15364_15384 = state_15355__$1;
(statearr_15364_15384[(1)] = (4));

} else {
var statearr_15365_15385 = state_15355__$1;
(statearr_15365_15385[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15356 === (11))){
var inst_15346 = cljs.core.async.close_BANG_(ch);
var state_15355__$1 = state_15355;
var statearr_15366_15386 = state_15355__$1;
(statearr_15366_15386[(2)] = inst_15346);

(statearr_15366_15386[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15356 === (9))){
var state_15355__$1 = state_15355;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15367_15387 = state_15355__$1;
(statearr_15367_15387[(1)] = (11));

} else {
var statearr_15368_15388 = state_15355__$1;
(statearr_15368_15388[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15356 === (5))){
var inst_15332 = (state_15355[(7)]);
var state_15355__$1 = state_15355;
var statearr_15369_15389 = state_15355__$1;
(statearr_15369_15389[(2)] = inst_15332);

(statearr_15369_15389[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15356 === (10))){
var inst_15351 = (state_15355[(2)]);
var state_15355__$1 = state_15355;
var statearr_15370_15390 = state_15355__$1;
(statearr_15370_15390[(2)] = inst_15351);

(statearr_15370_15390[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15356 === (8))){
var inst_15332 = (state_15355[(7)]);
var inst_15342 = cljs.core.next(inst_15332);
var inst_15332__$1 = inst_15342;
var state_15355__$1 = (function (){var statearr_15371 = state_15355;
(statearr_15371[(7)] = inst_15332__$1);

return statearr_15371;
})();
var statearr_15372_15391 = state_15355__$1;
(statearr_15372_15391[(2)] = null);

(statearr_15372_15391[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_15373 = [null,null,null,null,null,null,null,null];
(statearr_15373[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_15373[(1)] = (1));

return statearr_15373;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_15355){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_15355);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e15374){if((e15374 instanceof Object)){
var ex__14726__auto__ = e15374;
var statearr_15375_15392 = state_15355;
(statearr_15375_15392[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15355);

return cljs.core.cst$kw$recur;
} else {
throw e15374;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__15393 = state_15355;
state_15355 = G__15393;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_15355){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_15355);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_15376 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_15376[(6)] = c__14822__auto__);

return statearr_15376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7293__auto__ = (((_ == null))?null:_);
var m__7294__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7294__auto__.call(null,_));
} else {
var m__7294__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7294__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7293__auto__ = (((m == null))?null:m);
var m__7294__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7294__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7294__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7294__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7293__auto__ = (((m == null))?null:m);
var m__7294__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7294__auto__.call(null,m,ch));
} else {
var m__7294__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7294__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7293__auto__ = (((m == null))?null:m);
var m__7294__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7294__auto__.call(null,m));
} else {
var m__7294__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7294__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15394 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15394 = (function (ch,cs,meta15395){
this.ch = ch;
this.cs = cs;
this.meta15395 = meta15395;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async15394.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_15396,meta15395__$1){
var self__ = this;
var _15396__$1 = this;
return (new cljs.core.async.t_cljs$core$async15394(self__.ch,self__.cs,meta15395__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async15394.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_15396){
var self__ = this;
var _15396__$1 = this;
return self__.meta15395;
});})(cs))
;

cljs.core.async.t_cljs$core$async15394.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15394.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async15394.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15394.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15394.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15394.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async15394.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta15395], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async15394.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15394.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15394";

cljs.core.async.t_cljs$core$async15394.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"cljs.core.async/t_cljs$core$async15394");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async15394 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async15394(ch__$1,cs__$1,meta15395){
return (new cljs.core.async.t_cljs$core$async15394(ch__$1,cs__$1,meta15395));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async15394(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__14822__auto___15616 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___15616,cs,m,dchan,dctr,done){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___15616,cs,m,dchan,dctr,done){
return (function (state_15531){
var state_val_15532 = (state_15531[(1)]);
if((state_val_15532 === (7))){
var inst_15527 = (state_15531[(2)]);
var state_15531__$1 = state_15531;
var statearr_15533_15617 = state_15531__$1;
(statearr_15533_15617[(2)] = inst_15527);

(statearr_15533_15617[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (20))){
var inst_15430 = (state_15531[(7)]);
var inst_15442 = cljs.core.first(inst_15430);
var inst_15443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15442,(0),null);
var inst_15444 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15442,(1),null);
var state_15531__$1 = (function (){var statearr_15534 = state_15531;
(statearr_15534[(8)] = inst_15443);

return statearr_15534;
})();
if(cljs.core.truth_(inst_15444)){
var statearr_15535_15618 = state_15531__$1;
(statearr_15535_15618[(1)] = (22));

} else {
var statearr_15536_15619 = state_15531__$1;
(statearr_15536_15619[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (27))){
var inst_15479 = (state_15531[(9)]);
var inst_15474 = (state_15531[(10)]);
var inst_15399 = (state_15531[(11)]);
var inst_15472 = (state_15531[(12)]);
var inst_15479__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15472,inst_15474);
var inst_15480 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15479__$1,inst_15399,done);
var state_15531__$1 = (function (){var statearr_15537 = state_15531;
(statearr_15537[(9)] = inst_15479__$1);

return statearr_15537;
})();
if(cljs.core.truth_(inst_15480)){
var statearr_15538_15620 = state_15531__$1;
(statearr_15538_15620[(1)] = (30));

} else {
var statearr_15539_15621 = state_15531__$1;
(statearr_15539_15621[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (1))){
var state_15531__$1 = state_15531;
var statearr_15540_15622 = state_15531__$1;
(statearr_15540_15622[(2)] = null);

(statearr_15540_15622[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (24))){
var inst_15430 = (state_15531[(7)]);
var inst_15449 = (state_15531[(2)]);
var inst_15450 = cljs.core.next(inst_15430);
var inst_15408 = inst_15450;
var inst_15409 = null;
var inst_15410 = (0);
var inst_15411 = (0);
var state_15531__$1 = (function (){var statearr_15541 = state_15531;
(statearr_15541[(13)] = inst_15409);

(statearr_15541[(14)] = inst_15408);

(statearr_15541[(15)] = inst_15449);

(statearr_15541[(16)] = inst_15411);

(statearr_15541[(17)] = inst_15410);

return statearr_15541;
})();
var statearr_15542_15623 = state_15531__$1;
(statearr_15542_15623[(2)] = null);

(statearr_15542_15623[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (39))){
var state_15531__$1 = state_15531;
var statearr_15546_15624 = state_15531__$1;
(statearr_15546_15624[(2)] = null);

(statearr_15546_15624[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (4))){
var inst_15399 = (state_15531[(11)]);
var inst_15399__$1 = (state_15531[(2)]);
var inst_15400 = (inst_15399__$1 == null);
var state_15531__$1 = (function (){var statearr_15547 = state_15531;
(statearr_15547[(11)] = inst_15399__$1);

return statearr_15547;
})();
if(cljs.core.truth_(inst_15400)){
var statearr_15548_15625 = state_15531__$1;
(statearr_15548_15625[(1)] = (5));

} else {
var statearr_15549_15626 = state_15531__$1;
(statearr_15549_15626[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (15))){
var inst_15409 = (state_15531[(13)]);
var inst_15408 = (state_15531[(14)]);
var inst_15411 = (state_15531[(16)]);
var inst_15410 = (state_15531[(17)]);
var inst_15426 = (state_15531[(2)]);
var inst_15427 = (inst_15411 + (1));
var tmp15543 = inst_15409;
var tmp15544 = inst_15408;
var tmp15545 = inst_15410;
var inst_15408__$1 = tmp15544;
var inst_15409__$1 = tmp15543;
var inst_15410__$1 = tmp15545;
var inst_15411__$1 = inst_15427;
var state_15531__$1 = (function (){var statearr_15550 = state_15531;
(statearr_15550[(13)] = inst_15409__$1);

(statearr_15550[(14)] = inst_15408__$1);

(statearr_15550[(18)] = inst_15426);

(statearr_15550[(16)] = inst_15411__$1);

(statearr_15550[(17)] = inst_15410__$1);

return statearr_15550;
})();
var statearr_15551_15627 = state_15531__$1;
(statearr_15551_15627[(2)] = null);

(statearr_15551_15627[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (21))){
var inst_15453 = (state_15531[(2)]);
var state_15531__$1 = state_15531;
var statearr_15555_15628 = state_15531__$1;
(statearr_15555_15628[(2)] = inst_15453);

(statearr_15555_15628[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (31))){
var inst_15479 = (state_15531[(9)]);
var inst_15483 = done(null);
var inst_15484 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15479);
var state_15531__$1 = (function (){var statearr_15556 = state_15531;
(statearr_15556[(19)] = inst_15483);

return statearr_15556;
})();
var statearr_15557_15629 = state_15531__$1;
(statearr_15557_15629[(2)] = inst_15484);

(statearr_15557_15629[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (32))){
var inst_15473 = (state_15531[(20)]);
var inst_15471 = (state_15531[(21)]);
var inst_15474 = (state_15531[(10)]);
var inst_15472 = (state_15531[(12)]);
var inst_15486 = (state_15531[(2)]);
var inst_15487 = (inst_15474 + (1));
var tmp15552 = inst_15473;
var tmp15553 = inst_15471;
var tmp15554 = inst_15472;
var inst_15471__$1 = tmp15553;
var inst_15472__$1 = tmp15554;
var inst_15473__$1 = tmp15552;
var inst_15474__$1 = inst_15487;
var state_15531__$1 = (function (){var statearr_15558 = state_15531;
(statearr_15558[(20)] = inst_15473__$1);

(statearr_15558[(22)] = inst_15486);

(statearr_15558[(21)] = inst_15471__$1);

(statearr_15558[(10)] = inst_15474__$1);

(statearr_15558[(12)] = inst_15472__$1);

return statearr_15558;
})();
var statearr_15559_15630 = state_15531__$1;
(statearr_15559_15630[(2)] = null);

(statearr_15559_15630[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (40))){
var inst_15499 = (state_15531[(23)]);
var inst_15503 = done(null);
var inst_15504 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15499);
var state_15531__$1 = (function (){var statearr_15560 = state_15531;
(statearr_15560[(24)] = inst_15503);

return statearr_15560;
})();
var statearr_15561_15631 = state_15531__$1;
(statearr_15561_15631[(2)] = inst_15504);

(statearr_15561_15631[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (33))){
var inst_15490 = (state_15531[(25)]);
var inst_15492 = cljs.core.chunked_seq_QMARK_(inst_15490);
var state_15531__$1 = state_15531;
if(inst_15492){
var statearr_15562_15632 = state_15531__$1;
(statearr_15562_15632[(1)] = (36));

} else {
var statearr_15563_15633 = state_15531__$1;
(statearr_15563_15633[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (13))){
var inst_15420 = (state_15531[(26)]);
var inst_15423 = cljs.core.async.close_BANG_(inst_15420);
var state_15531__$1 = state_15531;
var statearr_15564_15634 = state_15531__$1;
(statearr_15564_15634[(2)] = inst_15423);

(statearr_15564_15634[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (22))){
var inst_15443 = (state_15531[(8)]);
var inst_15446 = cljs.core.async.close_BANG_(inst_15443);
var state_15531__$1 = state_15531;
var statearr_15565_15635 = state_15531__$1;
(statearr_15565_15635[(2)] = inst_15446);

(statearr_15565_15635[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (36))){
var inst_15490 = (state_15531[(25)]);
var inst_15494 = cljs.core.chunk_first(inst_15490);
var inst_15495 = cljs.core.chunk_rest(inst_15490);
var inst_15496 = cljs.core.count(inst_15494);
var inst_15471 = inst_15495;
var inst_15472 = inst_15494;
var inst_15473 = inst_15496;
var inst_15474 = (0);
var state_15531__$1 = (function (){var statearr_15566 = state_15531;
(statearr_15566[(20)] = inst_15473);

(statearr_15566[(21)] = inst_15471);

(statearr_15566[(10)] = inst_15474);

(statearr_15566[(12)] = inst_15472);

return statearr_15566;
})();
var statearr_15567_15636 = state_15531__$1;
(statearr_15567_15636[(2)] = null);

(statearr_15567_15636[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (41))){
var inst_15490 = (state_15531[(25)]);
var inst_15506 = (state_15531[(2)]);
var inst_15507 = cljs.core.next(inst_15490);
var inst_15471 = inst_15507;
var inst_15472 = null;
var inst_15473 = (0);
var inst_15474 = (0);
var state_15531__$1 = (function (){var statearr_15568 = state_15531;
(statearr_15568[(20)] = inst_15473);

(statearr_15568[(27)] = inst_15506);

(statearr_15568[(21)] = inst_15471);

(statearr_15568[(10)] = inst_15474);

(statearr_15568[(12)] = inst_15472);

return statearr_15568;
})();
var statearr_15569_15637 = state_15531__$1;
(statearr_15569_15637[(2)] = null);

(statearr_15569_15637[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (43))){
var state_15531__$1 = state_15531;
var statearr_15570_15638 = state_15531__$1;
(statearr_15570_15638[(2)] = null);

(statearr_15570_15638[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (29))){
var inst_15515 = (state_15531[(2)]);
var state_15531__$1 = state_15531;
var statearr_15571_15639 = state_15531__$1;
(statearr_15571_15639[(2)] = inst_15515);

(statearr_15571_15639[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (44))){
var inst_15524 = (state_15531[(2)]);
var state_15531__$1 = (function (){var statearr_15572 = state_15531;
(statearr_15572[(28)] = inst_15524);

return statearr_15572;
})();
var statearr_15573_15640 = state_15531__$1;
(statearr_15573_15640[(2)] = null);

(statearr_15573_15640[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (6))){
var inst_15463 = (state_15531[(29)]);
var inst_15462 = cljs.core.deref(cs);
var inst_15463__$1 = cljs.core.keys(inst_15462);
var inst_15464 = cljs.core.count(inst_15463__$1);
var inst_15465 = cljs.core.reset_BANG_(dctr,inst_15464);
var inst_15470 = cljs.core.seq(inst_15463__$1);
var inst_15471 = inst_15470;
var inst_15472 = null;
var inst_15473 = (0);
var inst_15474 = (0);
var state_15531__$1 = (function (){var statearr_15574 = state_15531;
(statearr_15574[(20)] = inst_15473);

(statearr_15574[(30)] = inst_15465);

(statearr_15574[(21)] = inst_15471);

(statearr_15574[(10)] = inst_15474);

(statearr_15574[(12)] = inst_15472);

(statearr_15574[(29)] = inst_15463__$1);

return statearr_15574;
})();
var statearr_15575_15641 = state_15531__$1;
(statearr_15575_15641[(2)] = null);

(statearr_15575_15641[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (28))){
var inst_15471 = (state_15531[(21)]);
var inst_15490 = (state_15531[(25)]);
var inst_15490__$1 = cljs.core.seq(inst_15471);
var state_15531__$1 = (function (){var statearr_15576 = state_15531;
(statearr_15576[(25)] = inst_15490__$1);

return statearr_15576;
})();
if(inst_15490__$1){
var statearr_15577_15642 = state_15531__$1;
(statearr_15577_15642[(1)] = (33));

} else {
var statearr_15578_15643 = state_15531__$1;
(statearr_15578_15643[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (25))){
var inst_15473 = (state_15531[(20)]);
var inst_15474 = (state_15531[(10)]);
var inst_15476 = (inst_15474 < inst_15473);
var inst_15477 = inst_15476;
var state_15531__$1 = state_15531;
if(cljs.core.truth_(inst_15477)){
var statearr_15579_15644 = state_15531__$1;
(statearr_15579_15644[(1)] = (27));

} else {
var statearr_15580_15645 = state_15531__$1;
(statearr_15580_15645[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (34))){
var state_15531__$1 = state_15531;
var statearr_15581_15646 = state_15531__$1;
(statearr_15581_15646[(2)] = null);

(statearr_15581_15646[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (17))){
var state_15531__$1 = state_15531;
var statearr_15582_15647 = state_15531__$1;
(statearr_15582_15647[(2)] = null);

(statearr_15582_15647[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (3))){
var inst_15529 = (state_15531[(2)]);
var state_15531__$1 = state_15531;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15531__$1,inst_15529);
} else {
if((state_val_15532 === (12))){
var inst_15458 = (state_15531[(2)]);
var state_15531__$1 = state_15531;
var statearr_15583_15648 = state_15531__$1;
(statearr_15583_15648[(2)] = inst_15458);

(statearr_15583_15648[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (2))){
var state_15531__$1 = state_15531;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15531__$1,(4),ch);
} else {
if((state_val_15532 === (23))){
var state_15531__$1 = state_15531;
var statearr_15584_15649 = state_15531__$1;
(statearr_15584_15649[(2)] = null);

(statearr_15584_15649[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (35))){
var inst_15513 = (state_15531[(2)]);
var state_15531__$1 = state_15531;
var statearr_15585_15650 = state_15531__$1;
(statearr_15585_15650[(2)] = inst_15513);

(statearr_15585_15650[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (19))){
var inst_15430 = (state_15531[(7)]);
var inst_15434 = cljs.core.chunk_first(inst_15430);
var inst_15435 = cljs.core.chunk_rest(inst_15430);
var inst_15436 = cljs.core.count(inst_15434);
var inst_15408 = inst_15435;
var inst_15409 = inst_15434;
var inst_15410 = inst_15436;
var inst_15411 = (0);
var state_15531__$1 = (function (){var statearr_15586 = state_15531;
(statearr_15586[(13)] = inst_15409);

(statearr_15586[(14)] = inst_15408);

(statearr_15586[(16)] = inst_15411);

(statearr_15586[(17)] = inst_15410);

return statearr_15586;
})();
var statearr_15587_15651 = state_15531__$1;
(statearr_15587_15651[(2)] = null);

(statearr_15587_15651[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (11))){
var inst_15408 = (state_15531[(14)]);
var inst_15430 = (state_15531[(7)]);
var inst_15430__$1 = cljs.core.seq(inst_15408);
var state_15531__$1 = (function (){var statearr_15588 = state_15531;
(statearr_15588[(7)] = inst_15430__$1);

return statearr_15588;
})();
if(inst_15430__$1){
var statearr_15589_15652 = state_15531__$1;
(statearr_15589_15652[(1)] = (16));

} else {
var statearr_15590_15653 = state_15531__$1;
(statearr_15590_15653[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (9))){
var inst_15460 = (state_15531[(2)]);
var state_15531__$1 = state_15531;
var statearr_15591_15654 = state_15531__$1;
(statearr_15591_15654[(2)] = inst_15460);

(statearr_15591_15654[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (5))){
var inst_15406 = cljs.core.deref(cs);
var inst_15407 = cljs.core.seq(inst_15406);
var inst_15408 = inst_15407;
var inst_15409 = null;
var inst_15410 = (0);
var inst_15411 = (0);
var state_15531__$1 = (function (){var statearr_15592 = state_15531;
(statearr_15592[(13)] = inst_15409);

(statearr_15592[(14)] = inst_15408);

(statearr_15592[(16)] = inst_15411);

(statearr_15592[(17)] = inst_15410);

return statearr_15592;
})();
var statearr_15593_15655 = state_15531__$1;
(statearr_15593_15655[(2)] = null);

(statearr_15593_15655[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (14))){
var state_15531__$1 = state_15531;
var statearr_15594_15656 = state_15531__$1;
(statearr_15594_15656[(2)] = null);

(statearr_15594_15656[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (45))){
var inst_15521 = (state_15531[(2)]);
var state_15531__$1 = state_15531;
var statearr_15595_15657 = state_15531__$1;
(statearr_15595_15657[(2)] = inst_15521);

(statearr_15595_15657[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (26))){
var inst_15463 = (state_15531[(29)]);
var inst_15517 = (state_15531[(2)]);
var inst_15518 = cljs.core.seq(inst_15463);
var state_15531__$1 = (function (){var statearr_15596 = state_15531;
(statearr_15596[(31)] = inst_15517);

return statearr_15596;
})();
if(inst_15518){
var statearr_15597_15658 = state_15531__$1;
(statearr_15597_15658[(1)] = (42));

} else {
var statearr_15598_15659 = state_15531__$1;
(statearr_15598_15659[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (16))){
var inst_15430 = (state_15531[(7)]);
var inst_15432 = cljs.core.chunked_seq_QMARK_(inst_15430);
var state_15531__$1 = state_15531;
if(inst_15432){
var statearr_15599_15660 = state_15531__$1;
(statearr_15599_15660[(1)] = (19));

} else {
var statearr_15600_15661 = state_15531__$1;
(statearr_15600_15661[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (38))){
var inst_15510 = (state_15531[(2)]);
var state_15531__$1 = state_15531;
var statearr_15601_15662 = state_15531__$1;
(statearr_15601_15662[(2)] = inst_15510);

(statearr_15601_15662[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (30))){
var state_15531__$1 = state_15531;
var statearr_15602_15663 = state_15531__$1;
(statearr_15602_15663[(2)] = null);

(statearr_15602_15663[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (10))){
var inst_15409 = (state_15531[(13)]);
var inst_15411 = (state_15531[(16)]);
var inst_15419 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15409,inst_15411);
var inst_15420 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15419,(0),null);
var inst_15421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15419,(1),null);
var state_15531__$1 = (function (){var statearr_15603 = state_15531;
(statearr_15603[(26)] = inst_15420);

return statearr_15603;
})();
if(cljs.core.truth_(inst_15421)){
var statearr_15604_15664 = state_15531__$1;
(statearr_15604_15664[(1)] = (13));

} else {
var statearr_15605_15665 = state_15531__$1;
(statearr_15605_15665[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (18))){
var inst_15456 = (state_15531[(2)]);
var state_15531__$1 = state_15531;
var statearr_15606_15666 = state_15531__$1;
(statearr_15606_15666[(2)] = inst_15456);

(statearr_15606_15666[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (42))){
var state_15531__$1 = state_15531;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15531__$1,(45),dchan);
} else {
if((state_val_15532 === (37))){
var inst_15499 = (state_15531[(23)]);
var inst_15399 = (state_15531[(11)]);
var inst_15490 = (state_15531[(25)]);
var inst_15499__$1 = cljs.core.first(inst_15490);
var inst_15500 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15499__$1,inst_15399,done);
var state_15531__$1 = (function (){var statearr_15607 = state_15531;
(statearr_15607[(23)] = inst_15499__$1);

return statearr_15607;
})();
if(cljs.core.truth_(inst_15500)){
var statearr_15608_15667 = state_15531__$1;
(statearr_15608_15667[(1)] = (39));

} else {
var statearr_15609_15668 = state_15531__$1;
(statearr_15609_15668[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15532 === (8))){
var inst_15411 = (state_15531[(16)]);
var inst_15410 = (state_15531[(17)]);
var inst_15413 = (inst_15411 < inst_15410);
var inst_15414 = inst_15413;
var state_15531__$1 = state_15531;
if(cljs.core.truth_(inst_15414)){
var statearr_15610_15669 = state_15531__$1;
(statearr_15610_15669[(1)] = (10));

} else {
var statearr_15611_15670 = state_15531__$1;
(statearr_15611_15670[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___15616,cs,m,dchan,dctr,done))
;
return ((function (switch__14722__auto__,c__14822__auto___15616,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14723__auto__ = null;
var cljs$core$async$mult_$_state_machine__14723__auto____0 = (function (){
var statearr_15612 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15612[(0)] = cljs$core$async$mult_$_state_machine__14723__auto__);

(statearr_15612[(1)] = (1));

return statearr_15612;
});
var cljs$core$async$mult_$_state_machine__14723__auto____1 = (function (state_15531){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_15531);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e15613){if((e15613 instanceof Object)){
var ex__14726__auto__ = e15613;
var statearr_15614_15671 = state_15531;
(statearr_15614_15671[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15531);

return cljs.core.cst$kw$recur;
} else {
throw e15613;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__15672 = state_15531;
state_15531 = G__15672;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14723__auto__ = function(state_15531){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14723__auto____1.call(this,state_15531);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14723__auto____0;
cljs$core$async$mult_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14723__auto____1;
return cljs$core$async$mult_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___15616,cs,m,dchan,dctr,done))
})();
var state__14824__auto__ = (function (){var statearr_15615 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_15615[(6)] = c__14822__auto___15616);

return statearr_15615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___15616,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__15674 = arguments.length;
switch (G__15674) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7293__auto__ = (((m == null))?null:m);
var m__7294__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7294__auto__.call(null,m,ch));
} else {
var m__7294__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7294__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7293__auto__ = (((m == null))?null:m);
var m__7294__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7294__auto__.call(null,m,ch));
} else {
var m__7294__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7294__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7293__auto__ = (((m == null))?null:m);
var m__7294__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7294__auto__.call(null,m));
} else {
var m__7294__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7294__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7293__auto__ = (((m == null))?null:m);
var m__7294__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7294__auto__.call(null,m,state_map));
} else {
var m__7294__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7294__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7293__auto__ = (((m == null))?null:m);
var m__7294__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7294__auto__.call(null,m,mode));
} else {
var m__7294__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7294__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7756__auto__ = [];
var len__7749__auto___15686 = arguments.length;
var i__7750__auto___15687 = (0);
while(true){
if((i__7750__auto___15687 < len__7749__auto___15686)){
args__7756__auto__.push((arguments[i__7750__auto___15687]));

var G__15688 = (i__7750__auto___15687 + (1));
i__7750__auto___15687 = G__15688;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((3) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7757__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15680){
var map__15681 = p__15680;
var map__15681__$1 = ((((!((map__15681 == null)))?((((map__15681.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15681.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15681):map__15681);
var opts = map__15681__$1;
var statearr_15683_15689 = state;
(statearr_15683_15689[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__15681,map__15681__$1,opts){
return (function (val){
var statearr_15684_15690 = state;
(statearr_15684_15690[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__15681,map__15681__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_15685_15691 = state;
(statearr_15685_15691[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15676){
var G__15677 = cljs.core.first(seq15676);
var seq15676__$1 = cljs.core.next(seq15676);
var G__15678 = cljs.core.first(seq15676__$1);
var seq15676__$2 = cljs.core.next(seq15676__$1);
var G__15679 = cljs.core.first(seq15676__$2);
var seq15676__$3 = cljs.core.next(seq15676__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15677,G__15678,G__15679,seq15676__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async15692 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15692 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta15693){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta15693 = meta15693;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async15692.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15694,meta15693__$1){
var self__ = this;
var _15694__$1 = this;
return (new cljs.core.async.t_cljs$core$async15692(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta15693__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15692.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_15694){
var self__ = this;
var _15694__$1 = this;
return self__.meta15693;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15692.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15692.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15692.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15692.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15692.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15692.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15692.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15692.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15692.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta15693], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async15692.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15692.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15692";

cljs.core.async.t_cljs$core$async15692.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"cljs.core.async/t_cljs$core$async15692");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async15692 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async15692(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta15693){
return (new cljs.core.async.t_cljs$core$async15692(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta15693));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async15692(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14822__auto___15856 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___15856,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___15856,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_15796){
var state_val_15797 = (state_15796[(1)]);
if((state_val_15797 === (7))){
var inst_15711 = (state_15796[(2)]);
var state_15796__$1 = state_15796;
var statearr_15798_15857 = state_15796__$1;
(statearr_15798_15857[(2)] = inst_15711);

(statearr_15798_15857[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (20))){
var inst_15723 = (state_15796[(7)]);
var state_15796__$1 = state_15796;
var statearr_15799_15858 = state_15796__$1;
(statearr_15799_15858[(2)] = inst_15723);

(statearr_15799_15858[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (27))){
var state_15796__$1 = state_15796;
var statearr_15800_15859 = state_15796__$1;
(statearr_15800_15859[(2)] = null);

(statearr_15800_15859[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (1))){
var inst_15698 = (state_15796[(8)]);
var inst_15698__$1 = calc_state();
var inst_15700 = (inst_15698__$1 == null);
var inst_15701 = cljs.core.not(inst_15700);
var state_15796__$1 = (function (){var statearr_15801 = state_15796;
(statearr_15801[(8)] = inst_15698__$1);

return statearr_15801;
})();
if(inst_15701){
var statearr_15802_15860 = state_15796__$1;
(statearr_15802_15860[(1)] = (2));

} else {
var statearr_15803_15861 = state_15796__$1;
(statearr_15803_15861[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (24))){
var inst_15756 = (state_15796[(9)]);
var inst_15747 = (state_15796[(10)]);
var inst_15770 = (state_15796[(11)]);
var inst_15770__$1 = (inst_15747.cljs$core$IFn$_invoke$arity$1 ? inst_15747.cljs$core$IFn$_invoke$arity$1(inst_15756) : inst_15747.call(null,inst_15756));
var state_15796__$1 = (function (){var statearr_15804 = state_15796;
(statearr_15804[(11)] = inst_15770__$1);

return statearr_15804;
})();
if(cljs.core.truth_(inst_15770__$1)){
var statearr_15805_15862 = state_15796__$1;
(statearr_15805_15862[(1)] = (29));

} else {
var statearr_15806_15863 = state_15796__$1;
(statearr_15806_15863[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (4))){
var inst_15714 = (state_15796[(2)]);
var state_15796__$1 = state_15796;
if(cljs.core.truth_(inst_15714)){
var statearr_15807_15864 = state_15796__$1;
(statearr_15807_15864[(1)] = (8));

} else {
var statearr_15808_15865 = state_15796__$1;
(statearr_15808_15865[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (15))){
var inst_15741 = (state_15796[(2)]);
var state_15796__$1 = state_15796;
if(cljs.core.truth_(inst_15741)){
var statearr_15809_15866 = state_15796__$1;
(statearr_15809_15866[(1)] = (19));

} else {
var statearr_15810_15867 = state_15796__$1;
(statearr_15810_15867[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (21))){
var inst_15746 = (state_15796[(12)]);
var inst_15746__$1 = (state_15796[(2)]);
var inst_15747 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15746__$1,cljs.core.cst$kw$solos);
var inst_15748 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15746__$1,cljs.core.cst$kw$mutes);
var inst_15749 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15746__$1,cljs.core.cst$kw$reads);
var state_15796__$1 = (function (){var statearr_15811 = state_15796;
(statearr_15811[(13)] = inst_15748);

(statearr_15811[(10)] = inst_15747);

(statearr_15811[(12)] = inst_15746__$1);

return statearr_15811;
})();
return cljs.core.async.ioc_alts_BANG_(state_15796__$1,(22),inst_15749);
} else {
if((state_val_15797 === (31))){
var inst_15778 = (state_15796[(2)]);
var state_15796__$1 = state_15796;
if(cljs.core.truth_(inst_15778)){
var statearr_15812_15868 = state_15796__$1;
(statearr_15812_15868[(1)] = (32));

} else {
var statearr_15813_15869 = state_15796__$1;
(statearr_15813_15869[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (32))){
var inst_15755 = (state_15796[(14)]);
var state_15796__$1 = state_15796;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15796__$1,(35),out,inst_15755);
} else {
if((state_val_15797 === (33))){
var inst_15746 = (state_15796[(12)]);
var inst_15723 = inst_15746;
var state_15796__$1 = (function (){var statearr_15814 = state_15796;
(statearr_15814[(7)] = inst_15723);

return statearr_15814;
})();
var statearr_15815_15870 = state_15796__$1;
(statearr_15815_15870[(2)] = null);

(statearr_15815_15870[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (13))){
var inst_15723 = (state_15796[(7)]);
var inst_15730 = inst_15723.cljs$lang$protocol_mask$partition0$;
var inst_15731 = (inst_15730 & (64));
var inst_15732 = inst_15723.cljs$core$ISeq$;
var inst_15733 = (cljs.core.PROTOCOL_SENTINEL === inst_15732);
var inst_15734 = (inst_15731) || (inst_15733);
var state_15796__$1 = state_15796;
if(cljs.core.truth_(inst_15734)){
var statearr_15816_15871 = state_15796__$1;
(statearr_15816_15871[(1)] = (16));

} else {
var statearr_15817_15872 = state_15796__$1;
(statearr_15817_15872[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (22))){
var inst_15756 = (state_15796[(9)]);
var inst_15755 = (state_15796[(14)]);
var inst_15754 = (state_15796[(2)]);
var inst_15755__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15754,(0),null);
var inst_15756__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15754,(1),null);
var inst_15757 = (inst_15755__$1 == null);
var inst_15758 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15756__$1,change);
var inst_15759 = (inst_15757) || (inst_15758);
var state_15796__$1 = (function (){var statearr_15818 = state_15796;
(statearr_15818[(9)] = inst_15756__$1);

(statearr_15818[(14)] = inst_15755__$1);

return statearr_15818;
})();
if(cljs.core.truth_(inst_15759)){
var statearr_15819_15873 = state_15796__$1;
(statearr_15819_15873[(1)] = (23));

} else {
var statearr_15820_15874 = state_15796__$1;
(statearr_15820_15874[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (36))){
var inst_15746 = (state_15796[(12)]);
var inst_15723 = inst_15746;
var state_15796__$1 = (function (){var statearr_15821 = state_15796;
(statearr_15821[(7)] = inst_15723);

return statearr_15821;
})();
var statearr_15822_15875 = state_15796__$1;
(statearr_15822_15875[(2)] = null);

(statearr_15822_15875[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (29))){
var inst_15770 = (state_15796[(11)]);
var state_15796__$1 = state_15796;
var statearr_15823_15876 = state_15796__$1;
(statearr_15823_15876[(2)] = inst_15770);

(statearr_15823_15876[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (6))){
var state_15796__$1 = state_15796;
var statearr_15824_15877 = state_15796__$1;
(statearr_15824_15877[(2)] = false);

(statearr_15824_15877[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (28))){
var inst_15766 = (state_15796[(2)]);
var inst_15767 = calc_state();
var inst_15723 = inst_15767;
var state_15796__$1 = (function (){var statearr_15825 = state_15796;
(statearr_15825[(7)] = inst_15723);

(statearr_15825[(15)] = inst_15766);

return statearr_15825;
})();
var statearr_15826_15878 = state_15796__$1;
(statearr_15826_15878[(2)] = null);

(statearr_15826_15878[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (25))){
var inst_15792 = (state_15796[(2)]);
var state_15796__$1 = state_15796;
var statearr_15827_15879 = state_15796__$1;
(statearr_15827_15879[(2)] = inst_15792);

(statearr_15827_15879[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (34))){
var inst_15790 = (state_15796[(2)]);
var state_15796__$1 = state_15796;
var statearr_15828_15880 = state_15796__$1;
(statearr_15828_15880[(2)] = inst_15790);

(statearr_15828_15880[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (17))){
var state_15796__$1 = state_15796;
var statearr_15829_15881 = state_15796__$1;
(statearr_15829_15881[(2)] = false);

(statearr_15829_15881[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (3))){
var state_15796__$1 = state_15796;
var statearr_15830_15882 = state_15796__$1;
(statearr_15830_15882[(2)] = false);

(statearr_15830_15882[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (12))){
var inst_15794 = (state_15796[(2)]);
var state_15796__$1 = state_15796;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15796__$1,inst_15794);
} else {
if((state_val_15797 === (2))){
var inst_15698 = (state_15796[(8)]);
var inst_15703 = inst_15698.cljs$lang$protocol_mask$partition0$;
var inst_15704 = (inst_15703 & (64));
var inst_15705 = inst_15698.cljs$core$ISeq$;
var inst_15706 = (cljs.core.PROTOCOL_SENTINEL === inst_15705);
var inst_15707 = (inst_15704) || (inst_15706);
var state_15796__$1 = state_15796;
if(cljs.core.truth_(inst_15707)){
var statearr_15831_15883 = state_15796__$1;
(statearr_15831_15883[(1)] = (5));

} else {
var statearr_15832_15884 = state_15796__$1;
(statearr_15832_15884[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (23))){
var inst_15755 = (state_15796[(14)]);
var inst_15761 = (inst_15755 == null);
var state_15796__$1 = state_15796;
if(cljs.core.truth_(inst_15761)){
var statearr_15833_15885 = state_15796__$1;
(statearr_15833_15885[(1)] = (26));

} else {
var statearr_15834_15886 = state_15796__$1;
(statearr_15834_15886[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (35))){
var inst_15781 = (state_15796[(2)]);
var state_15796__$1 = state_15796;
if(cljs.core.truth_(inst_15781)){
var statearr_15835_15887 = state_15796__$1;
(statearr_15835_15887[(1)] = (36));

} else {
var statearr_15836_15888 = state_15796__$1;
(statearr_15836_15888[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (19))){
var inst_15723 = (state_15796[(7)]);
var inst_15743 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_15723);
var state_15796__$1 = state_15796;
var statearr_15837_15889 = state_15796__$1;
(statearr_15837_15889[(2)] = inst_15743);

(statearr_15837_15889[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (11))){
var inst_15723 = (state_15796[(7)]);
var inst_15727 = (inst_15723 == null);
var inst_15728 = cljs.core.not(inst_15727);
var state_15796__$1 = state_15796;
if(inst_15728){
var statearr_15838_15890 = state_15796__$1;
(statearr_15838_15890[(1)] = (13));

} else {
var statearr_15839_15891 = state_15796__$1;
(statearr_15839_15891[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (9))){
var inst_15698 = (state_15796[(8)]);
var state_15796__$1 = state_15796;
var statearr_15840_15892 = state_15796__$1;
(statearr_15840_15892[(2)] = inst_15698);

(statearr_15840_15892[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (5))){
var state_15796__$1 = state_15796;
var statearr_15841_15893 = state_15796__$1;
(statearr_15841_15893[(2)] = true);

(statearr_15841_15893[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (14))){
var state_15796__$1 = state_15796;
var statearr_15842_15894 = state_15796__$1;
(statearr_15842_15894[(2)] = false);

(statearr_15842_15894[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (26))){
var inst_15756 = (state_15796[(9)]);
var inst_15763 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_15756);
var state_15796__$1 = state_15796;
var statearr_15843_15895 = state_15796__$1;
(statearr_15843_15895[(2)] = inst_15763);

(statearr_15843_15895[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (16))){
var state_15796__$1 = state_15796;
var statearr_15844_15896 = state_15796__$1;
(statearr_15844_15896[(2)] = true);

(statearr_15844_15896[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (38))){
var inst_15786 = (state_15796[(2)]);
var state_15796__$1 = state_15796;
var statearr_15845_15897 = state_15796__$1;
(statearr_15845_15897[(2)] = inst_15786);

(statearr_15845_15897[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (30))){
var inst_15748 = (state_15796[(13)]);
var inst_15756 = (state_15796[(9)]);
var inst_15747 = (state_15796[(10)]);
var inst_15773 = cljs.core.empty_QMARK_(inst_15747);
var inst_15774 = (inst_15748.cljs$core$IFn$_invoke$arity$1 ? inst_15748.cljs$core$IFn$_invoke$arity$1(inst_15756) : inst_15748.call(null,inst_15756));
var inst_15775 = cljs.core.not(inst_15774);
var inst_15776 = (inst_15773) && (inst_15775);
var state_15796__$1 = state_15796;
var statearr_15846_15898 = state_15796__$1;
(statearr_15846_15898[(2)] = inst_15776);

(statearr_15846_15898[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (10))){
var inst_15698 = (state_15796[(8)]);
var inst_15719 = (state_15796[(2)]);
var inst_15720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15719,cljs.core.cst$kw$solos);
var inst_15721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15719,cljs.core.cst$kw$mutes);
var inst_15722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15719,cljs.core.cst$kw$reads);
var inst_15723 = inst_15698;
var state_15796__$1 = (function (){var statearr_15847 = state_15796;
(statearr_15847[(16)] = inst_15721);

(statearr_15847[(7)] = inst_15723);

(statearr_15847[(17)] = inst_15722);

(statearr_15847[(18)] = inst_15720);

return statearr_15847;
})();
var statearr_15848_15899 = state_15796__$1;
(statearr_15848_15899[(2)] = null);

(statearr_15848_15899[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (18))){
var inst_15738 = (state_15796[(2)]);
var state_15796__$1 = state_15796;
var statearr_15849_15900 = state_15796__$1;
(statearr_15849_15900[(2)] = inst_15738);

(statearr_15849_15900[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (37))){
var state_15796__$1 = state_15796;
var statearr_15850_15901 = state_15796__$1;
(statearr_15850_15901[(2)] = null);

(statearr_15850_15901[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15797 === (8))){
var inst_15698 = (state_15796[(8)]);
var inst_15716 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_15698);
var state_15796__$1 = state_15796;
var statearr_15851_15902 = state_15796__$1;
(statearr_15851_15902[(2)] = inst_15716);

(statearr_15851_15902[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___15856,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14722__auto__,c__14822__auto___15856,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14723__auto__ = null;
var cljs$core$async$mix_$_state_machine__14723__auto____0 = (function (){
var statearr_15852 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15852[(0)] = cljs$core$async$mix_$_state_machine__14723__auto__);

(statearr_15852[(1)] = (1));

return statearr_15852;
});
var cljs$core$async$mix_$_state_machine__14723__auto____1 = (function (state_15796){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_15796);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e15853){if((e15853 instanceof Object)){
var ex__14726__auto__ = e15853;
var statearr_15854_15903 = state_15796;
(statearr_15854_15903[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15796);

return cljs.core.cst$kw$recur;
} else {
throw e15853;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__15904 = state_15796;
state_15796 = G__15904;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14723__auto__ = function(state_15796){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14723__auto____1.call(this,state_15796);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14723__auto____0;
cljs$core$async$mix_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14723__auto____1;
return cljs$core$async$mix_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___15856,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__14824__auto__ = (function (){var statearr_15855 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_15855[(6)] = c__14822__auto___15856);

return statearr_15855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___15856,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7293__auto__ = (((p == null))?null:p);
var m__7294__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7294__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7294__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7294__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7293__auto__ = (((p == null))?null:p);
var m__7294__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7294__auto__.call(null,p,v,ch));
} else {
var m__7294__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7294__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__15906 = arguments.length;
switch (G__15906) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7293__auto__ = (((p == null))?null:p);
var m__7294__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7294__auto__.call(null,p));
} else {
var m__7294__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7294__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7293__auto__ = (((p == null))?null:p);
var m__7294__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7293__auto__)]);
if(!((m__7294__auto__ == null))){
return (m__7294__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7294__auto__.call(null,p,v));
} else {
var m__7294__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7294__auto____$1 == null))){
return (m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7294__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7294__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__15910 = arguments.length;
switch (G__15910) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6624__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6624__auto__,mults){
return (function (p1__15908_SHARP_){
if(cljs.core.truth_((p1__15908_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__15908_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__15908_SHARP_.call(null,topic)))){
return p1__15908_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__15908_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6624__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async15911 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15911 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta15912){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta15912 = meta15912;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async15911.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_15913,meta15912__$1){
var self__ = this;
var _15913__$1 = this;
return (new cljs.core.async.t_cljs$core$async15911(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta15912__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15911.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_15913){
var self__ = this;
var _15913__$1 = this;
return self__.meta15912;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15911.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15911.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15911.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15911.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15911.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15911.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15911.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15911.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta15912], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15911.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15911.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15911";

cljs.core.async.t_cljs$core$async15911.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"cljs.core.async/t_cljs$core$async15911");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async15911 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async15911(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15912){
return (new cljs.core.async.t_cljs$core$async15911(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15912));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async15911(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14822__auto___16031 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___16031,mults,ensure_mult,p){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___16031,mults,ensure_mult,p){
return (function (state_15985){
var state_val_15986 = (state_15985[(1)]);
if((state_val_15986 === (7))){
var inst_15981 = (state_15985[(2)]);
var state_15985__$1 = state_15985;
var statearr_15987_16032 = state_15985__$1;
(statearr_15987_16032[(2)] = inst_15981);

(statearr_15987_16032[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (20))){
var state_15985__$1 = state_15985;
var statearr_15988_16033 = state_15985__$1;
(statearr_15988_16033[(2)] = null);

(statearr_15988_16033[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (1))){
var state_15985__$1 = state_15985;
var statearr_15989_16034 = state_15985__$1;
(statearr_15989_16034[(2)] = null);

(statearr_15989_16034[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (24))){
var inst_15964 = (state_15985[(7)]);
var inst_15973 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_15964);
var state_15985__$1 = state_15985;
var statearr_15990_16035 = state_15985__$1;
(statearr_15990_16035[(2)] = inst_15973);

(statearr_15990_16035[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (4))){
var inst_15916 = (state_15985[(8)]);
var inst_15916__$1 = (state_15985[(2)]);
var inst_15917 = (inst_15916__$1 == null);
var state_15985__$1 = (function (){var statearr_15991 = state_15985;
(statearr_15991[(8)] = inst_15916__$1);

return statearr_15991;
})();
if(cljs.core.truth_(inst_15917)){
var statearr_15992_16036 = state_15985__$1;
(statearr_15992_16036[(1)] = (5));

} else {
var statearr_15993_16037 = state_15985__$1;
(statearr_15993_16037[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (15))){
var inst_15958 = (state_15985[(2)]);
var state_15985__$1 = state_15985;
var statearr_15994_16038 = state_15985__$1;
(statearr_15994_16038[(2)] = inst_15958);

(statearr_15994_16038[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (21))){
var inst_15978 = (state_15985[(2)]);
var state_15985__$1 = (function (){var statearr_15995 = state_15985;
(statearr_15995[(9)] = inst_15978);

return statearr_15995;
})();
var statearr_15996_16039 = state_15985__$1;
(statearr_15996_16039[(2)] = null);

(statearr_15996_16039[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (13))){
var inst_15940 = (state_15985[(10)]);
var inst_15942 = cljs.core.chunked_seq_QMARK_(inst_15940);
var state_15985__$1 = state_15985;
if(inst_15942){
var statearr_15997_16040 = state_15985__$1;
(statearr_15997_16040[(1)] = (16));

} else {
var statearr_15998_16041 = state_15985__$1;
(statearr_15998_16041[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (22))){
var inst_15970 = (state_15985[(2)]);
var state_15985__$1 = state_15985;
if(cljs.core.truth_(inst_15970)){
var statearr_15999_16042 = state_15985__$1;
(statearr_15999_16042[(1)] = (23));

} else {
var statearr_16000_16043 = state_15985__$1;
(statearr_16000_16043[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (6))){
var inst_15916 = (state_15985[(8)]);
var inst_15966 = (state_15985[(11)]);
var inst_15964 = (state_15985[(7)]);
var inst_15964__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_15916) : topic_fn.call(null,inst_15916));
var inst_15965 = cljs.core.deref(mults);
var inst_15966__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15965,inst_15964__$1);
var state_15985__$1 = (function (){var statearr_16001 = state_15985;
(statearr_16001[(11)] = inst_15966__$1);

(statearr_16001[(7)] = inst_15964__$1);

return statearr_16001;
})();
if(cljs.core.truth_(inst_15966__$1)){
var statearr_16002_16044 = state_15985__$1;
(statearr_16002_16044[(1)] = (19));

} else {
var statearr_16003_16045 = state_15985__$1;
(statearr_16003_16045[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (25))){
var inst_15975 = (state_15985[(2)]);
var state_15985__$1 = state_15985;
var statearr_16004_16046 = state_15985__$1;
(statearr_16004_16046[(2)] = inst_15975);

(statearr_16004_16046[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (17))){
var inst_15940 = (state_15985[(10)]);
var inst_15949 = cljs.core.first(inst_15940);
var inst_15950 = cljs.core.async.muxch_STAR_(inst_15949);
var inst_15951 = cljs.core.async.close_BANG_(inst_15950);
var inst_15952 = cljs.core.next(inst_15940);
var inst_15926 = inst_15952;
var inst_15927 = null;
var inst_15928 = (0);
var inst_15929 = (0);
var state_15985__$1 = (function (){var statearr_16005 = state_15985;
(statearr_16005[(12)] = inst_15929);

(statearr_16005[(13)] = inst_15928);

(statearr_16005[(14)] = inst_15927);

(statearr_16005[(15)] = inst_15951);

(statearr_16005[(16)] = inst_15926);

return statearr_16005;
})();
var statearr_16006_16047 = state_15985__$1;
(statearr_16006_16047[(2)] = null);

(statearr_16006_16047[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (3))){
var inst_15983 = (state_15985[(2)]);
var state_15985__$1 = state_15985;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15985__$1,inst_15983);
} else {
if((state_val_15986 === (12))){
var inst_15960 = (state_15985[(2)]);
var state_15985__$1 = state_15985;
var statearr_16007_16048 = state_15985__$1;
(statearr_16007_16048[(2)] = inst_15960);

(statearr_16007_16048[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (2))){
var state_15985__$1 = state_15985;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15985__$1,(4),ch);
} else {
if((state_val_15986 === (23))){
var state_15985__$1 = state_15985;
var statearr_16008_16049 = state_15985__$1;
(statearr_16008_16049[(2)] = null);

(statearr_16008_16049[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (19))){
var inst_15916 = (state_15985[(8)]);
var inst_15966 = (state_15985[(11)]);
var inst_15968 = cljs.core.async.muxch_STAR_(inst_15966);
var state_15985__$1 = state_15985;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15985__$1,(22),inst_15968,inst_15916);
} else {
if((state_val_15986 === (11))){
var inst_15940 = (state_15985[(10)]);
var inst_15926 = (state_15985[(16)]);
var inst_15940__$1 = cljs.core.seq(inst_15926);
var state_15985__$1 = (function (){var statearr_16009 = state_15985;
(statearr_16009[(10)] = inst_15940__$1);

return statearr_16009;
})();
if(inst_15940__$1){
var statearr_16010_16050 = state_15985__$1;
(statearr_16010_16050[(1)] = (13));

} else {
var statearr_16011_16051 = state_15985__$1;
(statearr_16011_16051[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (9))){
var inst_15962 = (state_15985[(2)]);
var state_15985__$1 = state_15985;
var statearr_16012_16052 = state_15985__$1;
(statearr_16012_16052[(2)] = inst_15962);

(statearr_16012_16052[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (5))){
var inst_15923 = cljs.core.deref(mults);
var inst_15924 = cljs.core.vals(inst_15923);
var inst_15925 = cljs.core.seq(inst_15924);
var inst_15926 = inst_15925;
var inst_15927 = null;
var inst_15928 = (0);
var inst_15929 = (0);
var state_15985__$1 = (function (){var statearr_16013 = state_15985;
(statearr_16013[(12)] = inst_15929);

(statearr_16013[(13)] = inst_15928);

(statearr_16013[(14)] = inst_15927);

(statearr_16013[(16)] = inst_15926);

return statearr_16013;
})();
var statearr_16014_16053 = state_15985__$1;
(statearr_16014_16053[(2)] = null);

(statearr_16014_16053[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (14))){
var state_15985__$1 = state_15985;
var statearr_16018_16054 = state_15985__$1;
(statearr_16018_16054[(2)] = null);

(statearr_16018_16054[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (16))){
var inst_15940 = (state_15985[(10)]);
var inst_15944 = cljs.core.chunk_first(inst_15940);
var inst_15945 = cljs.core.chunk_rest(inst_15940);
var inst_15946 = cljs.core.count(inst_15944);
var inst_15926 = inst_15945;
var inst_15927 = inst_15944;
var inst_15928 = inst_15946;
var inst_15929 = (0);
var state_15985__$1 = (function (){var statearr_16019 = state_15985;
(statearr_16019[(12)] = inst_15929);

(statearr_16019[(13)] = inst_15928);

(statearr_16019[(14)] = inst_15927);

(statearr_16019[(16)] = inst_15926);

return statearr_16019;
})();
var statearr_16020_16055 = state_15985__$1;
(statearr_16020_16055[(2)] = null);

(statearr_16020_16055[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (10))){
var inst_15929 = (state_15985[(12)]);
var inst_15928 = (state_15985[(13)]);
var inst_15927 = (state_15985[(14)]);
var inst_15926 = (state_15985[(16)]);
var inst_15934 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15927,inst_15929);
var inst_15935 = cljs.core.async.muxch_STAR_(inst_15934);
var inst_15936 = cljs.core.async.close_BANG_(inst_15935);
var inst_15937 = (inst_15929 + (1));
var tmp16015 = inst_15928;
var tmp16016 = inst_15927;
var tmp16017 = inst_15926;
var inst_15926__$1 = tmp16017;
var inst_15927__$1 = tmp16016;
var inst_15928__$1 = tmp16015;
var inst_15929__$1 = inst_15937;
var state_15985__$1 = (function (){var statearr_16021 = state_15985;
(statearr_16021[(12)] = inst_15929__$1);

(statearr_16021[(13)] = inst_15928__$1);

(statearr_16021[(14)] = inst_15927__$1);

(statearr_16021[(17)] = inst_15936);

(statearr_16021[(16)] = inst_15926__$1);

return statearr_16021;
})();
var statearr_16022_16056 = state_15985__$1;
(statearr_16022_16056[(2)] = null);

(statearr_16022_16056[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (18))){
var inst_15955 = (state_15985[(2)]);
var state_15985__$1 = state_15985;
var statearr_16023_16057 = state_15985__$1;
(statearr_16023_16057[(2)] = inst_15955);

(statearr_16023_16057[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15986 === (8))){
var inst_15929 = (state_15985[(12)]);
var inst_15928 = (state_15985[(13)]);
var inst_15931 = (inst_15929 < inst_15928);
var inst_15932 = inst_15931;
var state_15985__$1 = state_15985;
if(cljs.core.truth_(inst_15932)){
var statearr_16024_16058 = state_15985__$1;
(statearr_16024_16058[(1)] = (10));

} else {
var statearr_16025_16059 = state_15985__$1;
(statearr_16025_16059[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___16031,mults,ensure_mult,p))
;
return ((function (switch__14722__auto__,c__14822__auto___16031,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_16026 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16026[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_16026[(1)] = (1));

return statearr_16026;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_15985){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_15985);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e16027){if((e16027 instanceof Object)){
var ex__14726__auto__ = e16027;
var statearr_16028_16060 = state_15985;
(statearr_16028_16060[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15985);

return cljs.core.cst$kw$recur;
} else {
throw e16027;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__16061 = state_15985;
state_15985 = G__16061;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_15985){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_15985);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___16031,mults,ensure_mult,p))
})();
var state__14824__auto__ = (function (){var statearr_16029 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_16029[(6)] = c__14822__auto___16031);

return statearr_16029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___16031,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__16063 = arguments.length;
switch (G__16063) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__16066 = arguments.length;
switch (G__16066) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__16069 = arguments.length;
switch (G__16069) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__14822__auto___16136 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___16136,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___16136,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_16108){
var state_val_16109 = (state_16108[(1)]);
if((state_val_16109 === (7))){
var state_16108__$1 = state_16108;
var statearr_16110_16137 = state_16108__$1;
(statearr_16110_16137[(2)] = null);

(statearr_16110_16137[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (1))){
var state_16108__$1 = state_16108;
var statearr_16111_16138 = state_16108__$1;
(statearr_16111_16138[(2)] = null);

(statearr_16111_16138[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (4))){
var inst_16072 = (state_16108[(7)]);
var inst_16074 = (inst_16072 < cnt);
var state_16108__$1 = state_16108;
if(cljs.core.truth_(inst_16074)){
var statearr_16112_16139 = state_16108__$1;
(statearr_16112_16139[(1)] = (6));

} else {
var statearr_16113_16140 = state_16108__$1;
(statearr_16113_16140[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (15))){
var inst_16104 = (state_16108[(2)]);
var state_16108__$1 = state_16108;
var statearr_16114_16141 = state_16108__$1;
(statearr_16114_16141[(2)] = inst_16104);

(statearr_16114_16141[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (13))){
var inst_16097 = cljs.core.async.close_BANG_(out);
var state_16108__$1 = state_16108;
var statearr_16115_16142 = state_16108__$1;
(statearr_16115_16142[(2)] = inst_16097);

(statearr_16115_16142[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (6))){
var state_16108__$1 = state_16108;
var statearr_16116_16143 = state_16108__$1;
(statearr_16116_16143[(2)] = null);

(statearr_16116_16143[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (3))){
var inst_16106 = (state_16108[(2)]);
var state_16108__$1 = state_16108;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16108__$1,inst_16106);
} else {
if((state_val_16109 === (12))){
var inst_16094 = (state_16108[(8)]);
var inst_16094__$1 = (state_16108[(2)]);
var inst_16095 = cljs.core.some(cljs.core.nil_QMARK_,inst_16094__$1);
var state_16108__$1 = (function (){var statearr_16117 = state_16108;
(statearr_16117[(8)] = inst_16094__$1);

return statearr_16117;
})();
if(cljs.core.truth_(inst_16095)){
var statearr_16118_16144 = state_16108__$1;
(statearr_16118_16144[(1)] = (13));

} else {
var statearr_16119_16145 = state_16108__$1;
(statearr_16119_16145[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (2))){
var inst_16071 = cljs.core.reset_BANG_(dctr,cnt);
var inst_16072 = (0);
var state_16108__$1 = (function (){var statearr_16120 = state_16108;
(statearr_16120[(7)] = inst_16072);

(statearr_16120[(9)] = inst_16071);

return statearr_16120;
})();
var statearr_16121_16146 = state_16108__$1;
(statearr_16121_16146[(2)] = null);

(statearr_16121_16146[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (11))){
var inst_16072 = (state_16108[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_16108,(10),Object,null,(9));
var inst_16081 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_16072) : chs__$1.call(null,inst_16072));
var inst_16082 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_16072) : done.call(null,inst_16072));
var inst_16083 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16081,inst_16082);
var state_16108__$1 = state_16108;
var statearr_16122_16147 = state_16108__$1;
(statearr_16122_16147[(2)] = inst_16083);


cljs.core.async.impl.ioc_helpers.process_exception(state_16108__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (9))){
var inst_16072 = (state_16108[(7)]);
var inst_16085 = (state_16108[(2)]);
var inst_16086 = (inst_16072 + (1));
var inst_16072__$1 = inst_16086;
var state_16108__$1 = (function (){var statearr_16123 = state_16108;
(statearr_16123[(7)] = inst_16072__$1);

(statearr_16123[(10)] = inst_16085);

return statearr_16123;
})();
var statearr_16124_16148 = state_16108__$1;
(statearr_16124_16148[(2)] = null);

(statearr_16124_16148[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (5))){
var inst_16092 = (state_16108[(2)]);
var state_16108__$1 = (function (){var statearr_16125 = state_16108;
(statearr_16125[(11)] = inst_16092);

return statearr_16125;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16108__$1,(12),dchan);
} else {
if((state_val_16109 === (14))){
var inst_16094 = (state_16108[(8)]);
var inst_16099 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_16094);
var state_16108__$1 = state_16108;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16108__$1,(16),out,inst_16099);
} else {
if((state_val_16109 === (16))){
var inst_16101 = (state_16108[(2)]);
var state_16108__$1 = (function (){var statearr_16126 = state_16108;
(statearr_16126[(12)] = inst_16101);

return statearr_16126;
})();
var statearr_16127_16149 = state_16108__$1;
(statearr_16127_16149[(2)] = null);

(statearr_16127_16149[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (10))){
var inst_16076 = (state_16108[(2)]);
var inst_16077 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_16108__$1 = (function (){var statearr_16128 = state_16108;
(statearr_16128[(13)] = inst_16076);

return statearr_16128;
})();
var statearr_16129_16150 = state_16108__$1;
(statearr_16129_16150[(2)] = inst_16077);


cljs.core.async.impl.ioc_helpers.process_exception(state_16108__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_16109 === (8))){
var inst_16090 = (state_16108[(2)]);
var state_16108__$1 = state_16108;
var statearr_16130_16151 = state_16108__$1;
(statearr_16130_16151[(2)] = inst_16090);

(statearr_16130_16151[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___16136,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14722__auto__,c__14822__auto___16136,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_16131 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16131[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_16131[(1)] = (1));

return statearr_16131;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_16108){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_16108);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e16132){if((e16132 instanceof Object)){
var ex__14726__auto__ = e16132;
var statearr_16133_16152 = state_16108;
(statearr_16133_16152[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16108);

return cljs.core.cst$kw$recur;
} else {
throw e16132;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__16153 = state_16108;
state_16108 = G__16153;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_16108){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_16108);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___16136,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__14824__auto__ = (function (){var statearr_16134 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_16134[(6)] = c__14822__auto___16136);

return statearr_16134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___16136,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__16156 = arguments.length;
switch (G__16156) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14822__auto___16210 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___16210,out){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___16210,out){
return (function (state_16188){
var state_val_16189 = (state_16188[(1)]);
if((state_val_16189 === (7))){
var inst_16168 = (state_16188[(7)]);
var inst_16167 = (state_16188[(8)]);
var inst_16167__$1 = (state_16188[(2)]);
var inst_16168__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16167__$1,(0),null);
var inst_16169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16167__$1,(1),null);
var inst_16170 = (inst_16168__$1 == null);
var state_16188__$1 = (function (){var statearr_16190 = state_16188;
(statearr_16190[(7)] = inst_16168__$1);

(statearr_16190[(9)] = inst_16169);

(statearr_16190[(8)] = inst_16167__$1);

return statearr_16190;
})();
if(cljs.core.truth_(inst_16170)){
var statearr_16191_16211 = state_16188__$1;
(statearr_16191_16211[(1)] = (8));

} else {
var statearr_16192_16212 = state_16188__$1;
(statearr_16192_16212[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16189 === (1))){
var inst_16157 = cljs.core.vec(chs);
var inst_16158 = inst_16157;
var state_16188__$1 = (function (){var statearr_16193 = state_16188;
(statearr_16193[(10)] = inst_16158);

return statearr_16193;
})();
var statearr_16194_16213 = state_16188__$1;
(statearr_16194_16213[(2)] = null);

(statearr_16194_16213[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16189 === (4))){
var inst_16158 = (state_16188[(10)]);
var state_16188__$1 = state_16188;
return cljs.core.async.ioc_alts_BANG_(state_16188__$1,(7),inst_16158);
} else {
if((state_val_16189 === (6))){
var inst_16184 = (state_16188[(2)]);
var state_16188__$1 = state_16188;
var statearr_16195_16214 = state_16188__$1;
(statearr_16195_16214[(2)] = inst_16184);

(statearr_16195_16214[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16189 === (3))){
var inst_16186 = (state_16188[(2)]);
var state_16188__$1 = state_16188;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16188__$1,inst_16186);
} else {
if((state_val_16189 === (2))){
var inst_16158 = (state_16188[(10)]);
var inst_16160 = cljs.core.count(inst_16158);
var inst_16161 = (inst_16160 > (0));
var state_16188__$1 = state_16188;
if(cljs.core.truth_(inst_16161)){
var statearr_16197_16215 = state_16188__$1;
(statearr_16197_16215[(1)] = (4));

} else {
var statearr_16198_16216 = state_16188__$1;
(statearr_16198_16216[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16189 === (11))){
var inst_16158 = (state_16188[(10)]);
var inst_16177 = (state_16188[(2)]);
var tmp16196 = inst_16158;
var inst_16158__$1 = tmp16196;
var state_16188__$1 = (function (){var statearr_16199 = state_16188;
(statearr_16199[(11)] = inst_16177);

(statearr_16199[(10)] = inst_16158__$1);

return statearr_16199;
})();
var statearr_16200_16217 = state_16188__$1;
(statearr_16200_16217[(2)] = null);

(statearr_16200_16217[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16189 === (9))){
var inst_16168 = (state_16188[(7)]);
var state_16188__$1 = state_16188;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16188__$1,(11),out,inst_16168);
} else {
if((state_val_16189 === (5))){
var inst_16182 = cljs.core.async.close_BANG_(out);
var state_16188__$1 = state_16188;
var statearr_16201_16218 = state_16188__$1;
(statearr_16201_16218[(2)] = inst_16182);

(statearr_16201_16218[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16189 === (10))){
var inst_16180 = (state_16188[(2)]);
var state_16188__$1 = state_16188;
var statearr_16202_16219 = state_16188__$1;
(statearr_16202_16219[(2)] = inst_16180);

(statearr_16202_16219[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16189 === (8))){
var inst_16168 = (state_16188[(7)]);
var inst_16158 = (state_16188[(10)]);
var inst_16169 = (state_16188[(9)]);
var inst_16167 = (state_16188[(8)]);
var inst_16172 = (function (){var cs = inst_16158;
var vec__16163 = inst_16167;
var v = inst_16168;
var c = inst_16169;
return ((function (cs,vec__16163,v,c,inst_16168,inst_16158,inst_16169,inst_16167,state_val_16189,c__14822__auto___16210,out){
return (function (p1__16154_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__16154_SHARP_);
});
;})(cs,vec__16163,v,c,inst_16168,inst_16158,inst_16169,inst_16167,state_val_16189,c__14822__auto___16210,out))
})();
var inst_16173 = cljs.core.filterv(inst_16172,inst_16158);
var inst_16158__$1 = inst_16173;
var state_16188__$1 = (function (){var statearr_16203 = state_16188;
(statearr_16203[(10)] = inst_16158__$1);

return statearr_16203;
})();
var statearr_16204_16220 = state_16188__$1;
(statearr_16204_16220[(2)] = null);

(statearr_16204_16220[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___16210,out))
;
return ((function (switch__14722__auto__,c__14822__auto___16210,out){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_16205 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16205[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_16205[(1)] = (1));

return statearr_16205;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_16188){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_16188);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e16206){if((e16206 instanceof Object)){
var ex__14726__auto__ = e16206;
var statearr_16207_16221 = state_16188;
(statearr_16207_16221[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16188);

return cljs.core.cst$kw$recur;
} else {
throw e16206;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__16222 = state_16188;
state_16188 = G__16222;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_16188){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_16188);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___16210,out))
})();
var state__14824__auto__ = (function (){var statearr_16208 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_16208[(6)] = c__14822__auto___16210);

return statearr_16208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___16210,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__16224 = arguments.length;
switch (G__16224) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14822__auto___16269 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___16269,out){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___16269,out){
return (function (state_16248){
var state_val_16249 = (state_16248[(1)]);
if((state_val_16249 === (7))){
var inst_16230 = (state_16248[(7)]);
var inst_16230__$1 = (state_16248[(2)]);
var inst_16231 = (inst_16230__$1 == null);
var inst_16232 = cljs.core.not(inst_16231);
var state_16248__$1 = (function (){var statearr_16250 = state_16248;
(statearr_16250[(7)] = inst_16230__$1);

return statearr_16250;
})();
if(inst_16232){
var statearr_16251_16270 = state_16248__$1;
(statearr_16251_16270[(1)] = (8));

} else {
var statearr_16252_16271 = state_16248__$1;
(statearr_16252_16271[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16249 === (1))){
var inst_16225 = (0);
var state_16248__$1 = (function (){var statearr_16253 = state_16248;
(statearr_16253[(8)] = inst_16225);

return statearr_16253;
})();
var statearr_16254_16272 = state_16248__$1;
(statearr_16254_16272[(2)] = null);

(statearr_16254_16272[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16249 === (4))){
var state_16248__$1 = state_16248;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16248__$1,(7),ch);
} else {
if((state_val_16249 === (6))){
var inst_16243 = (state_16248[(2)]);
var state_16248__$1 = state_16248;
var statearr_16255_16273 = state_16248__$1;
(statearr_16255_16273[(2)] = inst_16243);

(statearr_16255_16273[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16249 === (3))){
var inst_16245 = (state_16248[(2)]);
var inst_16246 = cljs.core.async.close_BANG_(out);
var state_16248__$1 = (function (){var statearr_16256 = state_16248;
(statearr_16256[(9)] = inst_16245);

return statearr_16256;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16248__$1,inst_16246);
} else {
if((state_val_16249 === (2))){
var inst_16225 = (state_16248[(8)]);
var inst_16227 = (inst_16225 < n);
var state_16248__$1 = state_16248;
if(cljs.core.truth_(inst_16227)){
var statearr_16257_16274 = state_16248__$1;
(statearr_16257_16274[(1)] = (4));

} else {
var statearr_16258_16275 = state_16248__$1;
(statearr_16258_16275[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16249 === (11))){
var inst_16225 = (state_16248[(8)]);
var inst_16235 = (state_16248[(2)]);
var inst_16236 = (inst_16225 + (1));
var inst_16225__$1 = inst_16236;
var state_16248__$1 = (function (){var statearr_16259 = state_16248;
(statearr_16259[(8)] = inst_16225__$1);

(statearr_16259[(10)] = inst_16235);

return statearr_16259;
})();
var statearr_16260_16276 = state_16248__$1;
(statearr_16260_16276[(2)] = null);

(statearr_16260_16276[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16249 === (9))){
var state_16248__$1 = state_16248;
var statearr_16261_16277 = state_16248__$1;
(statearr_16261_16277[(2)] = null);

(statearr_16261_16277[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16249 === (5))){
var state_16248__$1 = state_16248;
var statearr_16262_16278 = state_16248__$1;
(statearr_16262_16278[(2)] = null);

(statearr_16262_16278[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16249 === (10))){
var inst_16240 = (state_16248[(2)]);
var state_16248__$1 = state_16248;
var statearr_16263_16279 = state_16248__$1;
(statearr_16263_16279[(2)] = inst_16240);

(statearr_16263_16279[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16249 === (8))){
var inst_16230 = (state_16248[(7)]);
var state_16248__$1 = state_16248;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16248__$1,(11),out,inst_16230);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___16269,out))
;
return ((function (switch__14722__auto__,c__14822__auto___16269,out){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_16264 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16264[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_16264[(1)] = (1));

return statearr_16264;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_16248){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_16248);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e16265){if((e16265 instanceof Object)){
var ex__14726__auto__ = e16265;
var statearr_16266_16280 = state_16248;
(statearr_16266_16280[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16248);

return cljs.core.cst$kw$recur;
} else {
throw e16265;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__16281 = state_16248;
state_16248 = G__16281;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_16248){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_16248);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___16269,out))
})();
var state__14824__auto__ = (function (){var statearr_16267 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_16267[(6)] = c__14822__auto___16269);

return statearr_16267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___16269,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16283 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16283 = (function (f,ch,meta16284){
this.f = f;
this.ch = ch;
this.meta16284 = meta16284;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16283.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16285,meta16284__$1){
var self__ = this;
var _16285__$1 = this;
return (new cljs.core.async.t_cljs$core$async16283(self__.f,self__.ch,meta16284__$1));
});

cljs.core.async.t_cljs$core$async16283.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16285){
var self__ = this;
var _16285__$1 = this;
return self__.meta16284;
});

cljs.core.async.t_cljs$core$async16283.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16283.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async16283.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async16283.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16283.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async16286 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16286 = (function (f,ch,meta16284,_,fn1,meta16287){
this.f = f;
this.ch = ch;
this.meta16284 = meta16284;
this._ = _;
this.fn1 = fn1;
this.meta16287 = meta16287;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16286.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_16288,meta16287__$1){
var self__ = this;
var _16288__$1 = this;
return (new cljs.core.async.t_cljs$core$async16286(self__.f,self__.ch,self__.meta16284,self__._,self__.fn1,meta16287__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async16286.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_16288){
var self__ = this;
var _16288__$1 = this;
return self__.meta16287;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16286.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16286.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16286.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async16286.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__16282_SHARP_){
var G__16289 = (((p1__16282_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__16282_SHARP_) : self__.f.call(null,p1__16282_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__16289) : f1.call(null,G__16289));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async16286.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16284,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async16283], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta16287], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async16286.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16286.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16286";

cljs.core.async.t_cljs$core$async16286.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"cljs.core.async/t_cljs$core$async16286");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async16286 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16286(f__$1,ch__$1,meta16284__$1,___$2,fn1__$1,meta16287){
return (new cljs.core.async.t_cljs$core$async16286(f__$1,ch__$1,meta16284__$1,___$2,fn1__$1,meta16287));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async16286(self__.f,self__.ch,self__.meta16284,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6612__auto__ = ret;
if(cljs.core.truth_(and__6612__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__6612__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__16290 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__16290) : self__.f.call(null,G__16290));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async16283.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16283.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async16283.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16284], null);
});

cljs.core.async.t_cljs$core$async16283.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16283.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16283";

cljs.core.async.t_cljs$core$async16283.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"cljs.core.async/t_cljs$core$async16283");
});

cljs.core.async.__GT_t_cljs$core$async16283 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16283(f__$1,ch__$1,meta16284){
return (new cljs.core.async.t_cljs$core$async16283(f__$1,ch__$1,meta16284));
});

}

return (new cljs.core.async.t_cljs$core$async16283(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async16291 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16291 = (function (f,ch,meta16292){
this.f = f;
this.ch = ch;
this.meta16292 = meta16292;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16291.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16293,meta16292__$1){
var self__ = this;
var _16293__$1 = this;
return (new cljs.core.async.t_cljs$core$async16291(self__.f,self__.ch,meta16292__$1));
});

cljs.core.async.t_cljs$core$async16291.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16293){
var self__ = this;
var _16293__$1 = this;
return self__.meta16292;
});

cljs.core.async.t_cljs$core$async16291.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16291.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async16291.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16291.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16291.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16291.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async16291.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16292], null);
});

cljs.core.async.t_cljs$core$async16291.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16291.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16291";

cljs.core.async.t_cljs$core$async16291.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"cljs.core.async/t_cljs$core$async16291");
});

cljs.core.async.__GT_t_cljs$core$async16291 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16291(f__$1,ch__$1,meta16292){
return (new cljs.core.async.t_cljs$core$async16291(f__$1,ch__$1,meta16292));
});

}

return (new cljs.core.async.t_cljs$core$async16291(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async16294 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16294 = (function (p,ch,meta16295){
this.p = p;
this.ch = ch;
this.meta16295 = meta16295;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async16294.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16296,meta16295__$1){
var self__ = this;
var _16296__$1 = this;
return (new cljs.core.async.t_cljs$core$async16294(self__.p,self__.ch,meta16295__$1));
});

cljs.core.async.t_cljs$core$async16294.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16296){
var self__ = this;
var _16296__$1 = this;
return self__.meta16295;
});

cljs.core.async.t_cljs$core$async16294.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16294.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async16294.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async16294.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16294.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async16294.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16294.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async16294.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16295], null);
});

cljs.core.async.t_cljs$core$async16294.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16294.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16294";

cljs.core.async.t_cljs$core$async16294.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"cljs.core.async/t_cljs$core$async16294");
});

cljs.core.async.__GT_t_cljs$core$async16294 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16294(p__$1,ch__$1,meta16295){
return (new cljs.core.async.t_cljs$core$async16294(p__$1,ch__$1,meta16295));
});

}

return (new cljs.core.async.t_cljs$core$async16294(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__16298 = arguments.length;
switch (G__16298) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14822__auto___16338 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___16338,out){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___16338,out){
return (function (state_16319){
var state_val_16320 = (state_16319[(1)]);
if((state_val_16320 === (7))){
var inst_16315 = (state_16319[(2)]);
var state_16319__$1 = state_16319;
var statearr_16321_16339 = state_16319__$1;
(statearr_16321_16339[(2)] = inst_16315);

(statearr_16321_16339[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16320 === (1))){
var state_16319__$1 = state_16319;
var statearr_16322_16340 = state_16319__$1;
(statearr_16322_16340[(2)] = null);

(statearr_16322_16340[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16320 === (4))){
var inst_16301 = (state_16319[(7)]);
var inst_16301__$1 = (state_16319[(2)]);
var inst_16302 = (inst_16301__$1 == null);
var state_16319__$1 = (function (){var statearr_16323 = state_16319;
(statearr_16323[(7)] = inst_16301__$1);

return statearr_16323;
})();
if(cljs.core.truth_(inst_16302)){
var statearr_16324_16341 = state_16319__$1;
(statearr_16324_16341[(1)] = (5));

} else {
var statearr_16325_16342 = state_16319__$1;
(statearr_16325_16342[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16320 === (6))){
var inst_16301 = (state_16319[(7)]);
var inst_16306 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_16301) : p.call(null,inst_16301));
var state_16319__$1 = state_16319;
if(cljs.core.truth_(inst_16306)){
var statearr_16326_16343 = state_16319__$1;
(statearr_16326_16343[(1)] = (8));

} else {
var statearr_16327_16344 = state_16319__$1;
(statearr_16327_16344[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16320 === (3))){
var inst_16317 = (state_16319[(2)]);
var state_16319__$1 = state_16319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16319__$1,inst_16317);
} else {
if((state_val_16320 === (2))){
var state_16319__$1 = state_16319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16319__$1,(4),ch);
} else {
if((state_val_16320 === (11))){
var inst_16309 = (state_16319[(2)]);
var state_16319__$1 = state_16319;
var statearr_16328_16345 = state_16319__$1;
(statearr_16328_16345[(2)] = inst_16309);

(statearr_16328_16345[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16320 === (9))){
var state_16319__$1 = state_16319;
var statearr_16329_16346 = state_16319__$1;
(statearr_16329_16346[(2)] = null);

(statearr_16329_16346[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16320 === (5))){
var inst_16304 = cljs.core.async.close_BANG_(out);
var state_16319__$1 = state_16319;
var statearr_16330_16347 = state_16319__$1;
(statearr_16330_16347[(2)] = inst_16304);

(statearr_16330_16347[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16320 === (10))){
var inst_16312 = (state_16319[(2)]);
var state_16319__$1 = (function (){var statearr_16331 = state_16319;
(statearr_16331[(8)] = inst_16312);

return statearr_16331;
})();
var statearr_16332_16348 = state_16319__$1;
(statearr_16332_16348[(2)] = null);

(statearr_16332_16348[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16320 === (8))){
var inst_16301 = (state_16319[(7)]);
var state_16319__$1 = state_16319;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16319__$1,(11),out,inst_16301);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___16338,out))
;
return ((function (switch__14722__auto__,c__14822__auto___16338,out){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_16333 = [null,null,null,null,null,null,null,null,null];
(statearr_16333[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_16333[(1)] = (1));

return statearr_16333;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_16319){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_16319);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e16334){if((e16334 instanceof Object)){
var ex__14726__auto__ = e16334;
var statearr_16335_16349 = state_16319;
(statearr_16335_16349[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16319);

return cljs.core.cst$kw$recur;
} else {
throw e16334;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__16350 = state_16319;
state_16319 = G__16350;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_16319){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_16319);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___16338,out))
})();
var state__14824__auto__ = (function (){var statearr_16336 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_16336[(6)] = c__14822__auto___16338);

return statearr_16336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___16338,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__16352 = arguments.length;
switch (G__16352) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__){
return (function (state_16415){
var state_val_16416 = (state_16415[(1)]);
if((state_val_16416 === (7))){
var inst_16411 = (state_16415[(2)]);
var state_16415__$1 = state_16415;
var statearr_16417_16455 = state_16415__$1;
(statearr_16417_16455[(2)] = inst_16411);

(statearr_16417_16455[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (20))){
var inst_16381 = (state_16415[(7)]);
var inst_16392 = (state_16415[(2)]);
var inst_16393 = cljs.core.next(inst_16381);
var inst_16367 = inst_16393;
var inst_16368 = null;
var inst_16369 = (0);
var inst_16370 = (0);
var state_16415__$1 = (function (){var statearr_16418 = state_16415;
(statearr_16418[(8)] = inst_16392);

(statearr_16418[(9)] = inst_16369);

(statearr_16418[(10)] = inst_16368);

(statearr_16418[(11)] = inst_16370);

(statearr_16418[(12)] = inst_16367);

return statearr_16418;
})();
var statearr_16419_16456 = state_16415__$1;
(statearr_16419_16456[(2)] = null);

(statearr_16419_16456[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (1))){
var state_16415__$1 = state_16415;
var statearr_16420_16457 = state_16415__$1;
(statearr_16420_16457[(2)] = null);

(statearr_16420_16457[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (4))){
var inst_16356 = (state_16415[(13)]);
var inst_16356__$1 = (state_16415[(2)]);
var inst_16357 = (inst_16356__$1 == null);
var state_16415__$1 = (function (){var statearr_16421 = state_16415;
(statearr_16421[(13)] = inst_16356__$1);

return statearr_16421;
})();
if(cljs.core.truth_(inst_16357)){
var statearr_16422_16458 = state_16415__$1;
(statearr_16422_16458[(1)] = (5));

} else {
var statearr_16423_16459 = state_16415__$1;
(statearr_16423_16459[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (15))){
var state_16415__$1 = state_16415;
var statearr_16427_16460 = state_16415__$1;
(statearr_16427_16460[(2)] = null);

(statearr_16427_16460[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (21))){
var state_16415__$1 = state_16415;
var statearr_16428_16461 = state_16415__$1;
(statearr_16428_16461[(2)] = null);

(statearr_16428_16461[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (13))){
var inst_16369 = (state_16415[(9)]);
var inst_16368 = (state_16415[(10)]);
var inst_16370 = (state_16415[(11)]);
var inst_16367 = (state_16415[(12)]);
var inst_16377 = (state_16415[(2)]);
var inst_16378 = (inst_16370 + (1));
var tmp16424 = inst_16369;
var tmp16425 = inst_16368;
var tmp16426 = inst_16367;
var inst_16367__$1 = tmp16426;
var inst_16368__$1 = tmp16425;
var inst_16369__$1 = tmp16424;
var inst_16370__$1 = inst_16378;
var state_16415__$1 = (function (){var statearr_16429 = state_16415;
(statearr_16429[(14)] = inst_16377);

(statearr_16429[(9)] = inst_16369__$1);

(statearr_16429[(10)] = inst_16368__$1);

(statearr_16429[(11)] = inst_16370__$1);

(statearr_16429[(12)] = inst_16367__$1);

return statearr_16429;
})();
var statearr_16430_16462 = state_16415__$1;
(statearr_16430_16462[(2)] = null);

(statearr_16430_16462[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (22))){
var state_16415__$1 = state_16415;
var statearr_16431_16463 = state_16415__$1;
(statearr_16431_16463[(2)] = null);

(statearr_16431_16463[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (6))){
var inst_16356 = (state_16415[(13)]);
var inst_16365 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_16356) : f.call(null,inst_16356));
var inst_16366 = cljs.core.seq(inst_16365);
var inst_16367 = inst_16366;
var inst_16368 = null;
var inst_16369 = (0);
var inst_16370 = (0);
var state_16415__$1 = (function (){var statearr_16432 = state_16415;
(statearr_16432[(9)] = inst_16369);

(statearr_16432[(10)] = inst_16368);

(statearr_16432[(11)] = inst_16370);

(statearr_16432[(12)] = inst_16367);

return statearr_16432;
})();
var statearr_16433_16464 = state_16415__$1;
(statearr_16433_16464[(2)] = null);

(statearr_16433_16464[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (17))){
var inst_16381 = (state_16415[(7)]);
var inst_16385 = cljs.core.chunk_first(inst_16381);
var inst_16386 = cljs.core.chunk_rest(inst_16381);
var inst_16387 = cljs.core.count(inst_16385);
var inst_16367 = inst_16386;
var inst_16368 = inst_16385;
var inst_16369 = inst_16387;
var inst_16370 = (0);
var state_16415__$1 = (function (){var statearr_16434 = state_16415;
(statearr_16434[(9)] = inst_16369);

(statearr_16434[(10)] = inst_16368);

(statearr_16434[(11)] = inst_16370);

(statearr_16434[(12)] = inst_16367);

return statearr_16434;
})();
var statearr_16435_16465 = state_16415__$1;
(statearr_16435_16465[(2)] = null);

(statearr_16435_16465[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (3))){
var inst_16413 = (state_16415[(2)]);
var state_16415__$1 = state_16415;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16415__$1,inst_16413);
} else {
if((state_val_16416 === (12))){
var inst_16401 = (state_16415[(2)]);
var state_16415__$1 = state_16415;
var statearr_16436_16466 = state_16415__$1;
(statearr_16436_16466[(2)] = inst_16401);

(statearr_16436_16466[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (2))){
var state_16415__$1 = state_16415;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16415__$1,(4),in$);
} else {
if((state_val_16416 === (23))){
var inst_16409 = (state_16415[(2)]);
var state_16415__$1 = state_16415;
var statearr_16437_16467 = state_16415__$1;
(statearr_16437_16467[(2)] = inst_16409);

(statearr_16437_16467[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (19))){
var inst_16396 = (state_16415[(2)]);
var state_16415__$1 = state_16415;
var statearr_16438_16468 = state_16415__$1;
(statearr_16438_16468[(2)] = inst_16396);

(statearr_16438_16468[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (11))){
var inst_16367 = (state_16415[(12)]);
var inst_16381 = (state_16415[(7)]);
var inst_16381__$1 = cljs.core.seq(inst_16367);
var state_16415__$1 = (function (){var statearr_16439 = state_16415;
(statearr_16439[(7)] = inst_16381__$1);

return statearr_16439;
})();
if(inst_16381__$1){
var statearr_16440_16469 = state_16415__$1;
(statearr_16440_16469[(1)] = (14));

} else {
var statearr_16441_16470 = state_16415__$1;
(statearr_16441_16470[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (9))){
var inst_16403 = (state_16415[(2)]);
var inst_16404 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_16415__$1 = (function (){var statearr_16442 = state_16415;
(statearr_16442[(15)] = inst_16403);

return statearr_16442;
})();
if(cljs.core.truth_(inst_16404)){
var statearr_16443_16471 = state_16415__$1;
(statearr_16443_16471[(1)] = (21));

} else {
var statearr_16444_16472 = state_16415__$1;
(statearr_16444_16472[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (5))){
var inst_16359 = cljs.core.async.close_BANG_(out);
var state_16415__$1 = state_16415;
var statearr_16445_16473 = state_16415__$1;
(statearr_16445_16473[(2)] = inst_16359);

(statearr_16445_16473[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (14))){
var inst_16381 = (state_16415[(7)]);
var inst_16383 = cljs.core.chunked_seq_QMARK_(inst_16381);
var state_16415__$1 = state_16415;
if(inst_16383){
var statearr_16446_16474 = state_16415__$1;
(statearr_16446_16474[(1)] = (17));

} else {
var statearr_16447_16475 = state_16415__$1;
(statearr_16447_16475[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (16))){
var inst_16399 = (state_16415[(2)]);
var state_16415__$1 = state_16415;
var statearr_16448_16476 = state_16415__$1;
(statearr_16448_16476[(2)] = inst_16399);

(statearr_16448_16476[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16416 === (10))){
var inst_16368 = (state_16415[(10)]);
var inst_16370 = (state_16415[(11)]);
var inst_16375 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16368,inst_16370);
var state_16415__$1 = state_16415;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16415__$1,(13),out,inst_16375);
} else {
if((state_val_16416 === (18))){
var inst_16381 = (state_16415[(7)]);
var inst_16390 = cljs.core.first(inst_16381);
var state_16415__$1 = state_16415;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16415__$1,(20),out,inst_16390);
} else {
if((state_val_16416 === (8))){
var inst_16369 = (state_16415[(9)]);
var inst_16370 = (state_16415[(11)]);
var inst_16372 = (inst_16370 < inst_16369);
var inst_16373 = inst_16372;
var state_16415__$1 = state_16415;
if(cljs.core.truth_(inst_16373)){
var statearr_16449_16477 = state_16415__$1;
(statearr_16449_16477[(1)] = (10));

} else {
var statearr_16450_16478 = state_16415__$1;
(statearr_16450_16478[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__))
;
return ((function (switch__14722__auto__,c__14822__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14723__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14723__auto____0 = (function (){
var statearr_16451 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16451[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14723__auto__);

(statearr_16451[(1)] = (1));

return statearr_16451;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14723__auto____1 = (function (state_16415){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_16415);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e16452){if((e16452 instanceof Object)){
var ex__14726__auto__ = e16452;
var statearr_16453_16479 = state_16415;
(statearr_16453_16479[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16415);

return cljs.core.cst$kw$recur;
} else {
throw e16452;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__16480 = state_16415;
state_16415 = G__16480;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14723__auto__ = function(state_16415){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14723__auto____1.call(this,state_16415);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14723__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14723__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__))
})();
var state__14824__auto__ = (function (){var statearr_16454 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_16454[(6)] = c__14822__auto__);

return statearr_16454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__))
);

return c__14822__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__16482 = arguments.length;
switch (G__16482) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__16485 = arguments.length;
switch (G__16485) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__16488 = arguments.length;
switch (G__16488) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14822__auto___16535 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___16535,out){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___16535,out){
return (function (state_16512){
var state_val_16513 = (state_16512[(1)]);
if((state_val_16513 === (7))){
var inst_16507 = (state_16512[(2)]);
var state_16512__$1 = state_16512;
var statearr_16514_16536 = state_16512__$1;
(statearr_16514_16536[(2)] = inst_16507);

(statearr_16514_16536[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16513 === (1))){
var inst_16489 = null;
var state_16512__$1 = (function (){var statearr_16515 = state_16512;
(statearr_16515[(7)] = inst_16489);

return statearr_16515;
})();
var statearr_16516_16537 = state_16512__$1;
(statearr_16516_16537[(2)] = null);

(statearr_16516_16537[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16513 === (4))){
var inst_16492 = (state_16512[(8)]);
var inst_16492__$1 = (state_16512[(2)]);
var inst_16493 = (inst_16492__$1 == null);
var inst_16494 = cljs.core.not(inst_16493);
var state_16512__$1 = (function (){var statearr_16517 = state_16512;
(statearr_16517[(8)] = inst_16492__$1);

return statearr_16517;
})();
if(inst_16494){
var statearr_16518_16538 = state_16512__$1;
(statearr_16518_16538[(1)] = (5));

} else {
var statearr_16519_16539 = state_16512__$1;
(statearr_16519_16539[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16513 === (6))){
var state_16512__$1 = state_16512;
var statearr_16520_16540 = state_16512__$1;
(statearr_16520_16540[(2)] = null);

(statearr_16520_16540[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16513 === (3))){
var inst_16509 = (state_16512[(2)]);
var inst_16510 = cljs.core.async.close_BANG_(out);
var state_16512__$1 = (function (){var statearr_16521 = state_16512;
(statearr_16521[(9)] = inst_16509);

return statearr_16521;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16512__$1,inst_16510);
} else {
if((state_val_16513 === (2))){
var state_16512__$1 = state_16512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16512__$1,(4),ch);
} else {
if((state_val_16513 === (11))){
var inst_16492 = (state_16512[(8)]);
var inst_16501 = (state_16512[(2)]);
var inst_16489 = inst_16492;
var state_16512__$1 = (function (){var statearr_16522 = state_16512;
(statearr_16522[(10)] = inst_16501);

(statearr_16522[(7)] = inst_16489);

return statearr_16522;
})();
var statearr_16523_16541 = state_16512__$1;
(statearr_16523_16541[(2)] = null);

(statearr_16523_16541[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16513 === (9))){
var inst_16492 = (state_16512[(8)]);
var state_16512__$1 = state_16512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16512__$1,(11),out,inst_16492);
} else {
if((state_val_16513 === (5))){
var inst_16492 = (state_16512[(8)]);
var inst_16489 = (state_16512[(7)]);
var inst_16496 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16492,inst_16489);
var state_16512__$1 = state_16512;
if(inst_16496){
var statearr_16525_16542 = state_16512__$1;
(statearr_16525_16542[(1)] = (8));

} else {
var statearr_16526_16543 = state_16512__$1;
(statearr_16526_16543[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16513 === (10))){
var inst_16504 = (state_16512[(2)]);
var state_16512__$1 = state_16512;
var statearr_16527_16544 = state_16512__$1;
(statearr_16527_16544[(2)] = inst_16504);

(statearr_16527_16544[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16513 === (8))){
var inst_16489 = (state_16512[(7)]);
var tmp16524 = inst_16489;
var inst_16489__$1 = tmp16524;
var state_16512__$1 = (function (){var statearr_16528 = state_16512;
(statearr_16528[(7)] = inst_16489__$1);

return statearr_16528;
})();
var statearr_16529_16545 = state_16512__$1;
(statearr_16529_16545[(2)] = null);

(statearr_16529_16545[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___16535,out))
;
return ((function (switch__14722__auto__,c__14822__auto___16535,out){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_16530 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16530[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_16530[(1)] = (1));

return statearr_16530;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_16512){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_16512);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e16531){if((e16531 instanceof Object)){
var ex__14726__auto__ = e16531;
var statearr_16532_16546 = state_16512;
(statearr_16532_16546[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16512);

return cljs.core.cst$kw$recur;
} else {
throw e16531;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__16547 = state_16512;
state_16512 = G__16547;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_16512){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_16512);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___16535,out))
})();
var state__14824__auto__ = (function (){var statearr_16533 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_16533[(6)] = c__14822__auto___16535);

return statearr_16533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___16535,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__16549 = arguments.length;
switch (G__16549) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14822__auto___16615 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___16615,out){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___16615,out){
return (function (state_16587){
var state_val_16588 = (state_16587[(1)]);
if((state_val_16588 === (7))){
var inst_16583 = (state_16587[(2)]);
var state_16587__$1 = state_16587;
var statearr_16589_16616 = state_16587__$1;
(statearr_16589_16616[(2)] = inst_16583);

(statearr_16589_16616[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16588 === (1))){
var inst_16550 = (new Array(n));
var inst_16551 = inst_16550;
var inst_16552 = (0);
var state_16587__$1 = (function (){var statearr_16590 = state_16587;
(statearr_16590[(7)] = inst_16552);

(statearr_16590[(8)] = inst_16551);

return statearr_16590;
})();
var statearr_16591_16617 = state_16587__$1;
(statearr_16591_16617[(2)] = null);

(statearr_16591_16617[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16588 === (4))){
var inst_16555 = (state_16587[(9)]);
var inst_16555__$1 = (state_16587[(2)]);
var inst_16556 = (inst_16555__$1 == null);
var inst_16557 = cljs.core.not(inst_16556);
var state_16587__$1 = (function (){var statearr_16592 = state_16587;
(statearr_16592[(9)] = inst_16555__$1);

return statearr_16592;
})();
if(inst_16557){
var statearr_16593_16618 = state_16587__$1;
(statearr_16593_16618[(1)] = (5));

} else {
var statearr_16594_16619 = state_16587__$1;
(statearr_16594_16619[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16588 === (15))){
var inst_16577 = (state_16587[(2)]);
var state_16587__$1 = state_16587;
var statearr_16595_16620 = state_16587__$1;
(statearr_16595_16620[(2)] = inst_16577);

(statearr_16595_16620[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16588 === (13))){
var state_16587__$1 = state_16587;
var statearr_16596_16621 = state_16587__$1;
(statearr_16596_16621[(2)] = null);

(statearr_16596_16621[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16588 === (6))){
var inst_16552 = (state_16587[(7)]);
var inst_16573 = (inst_16552 > (0));
var state_16587__$1 = state_16587;
if(cljs.core.truth_(inst_16573)){
var statearr_16597_16622 = state_16587__$1;
(statearr_16597_16622[(1)] = (12));

} else {
var statearr_16598_16623 = state_16587__$1;
(statearr_16598_16623[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16588 === (3))){
var inst_16585 = (state_16587[(2)]);
var state_16587__$1 = state_16587;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16587__$1,inst_16585);
} else {
if((state_val_16588 === (12))){
var inst_16551 = (state_16587[(8)]);
var inst_16575 = cljs.core.vec(inst_16551);
var state_16587__$1 = state_16587;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16587__$1,(15),out,inst_16575);
} else {
if((state_val_16588 === (2))){
var state_16587__$1 = state_16587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16587__$1,(4),ch);
} else {
if((state_val_16588 === (11))){
var inst_16567 = (state_16587[(2)]);
var inst_16568 = (new Array(n));
var inst_16551 = inst_16568;
var inst_16552 = (0);
var state_16587__$1 = (function (){var statearr_16599 = state_16587;
(statearr_16599[(7)] = inst_16552);

(statearr_16599[(10)] = inst_16567);

(statearr_16599[(8)] = inst_16551);

return statearr_16599;
})();
var statearr_16600_16624 = state_16587__$1;
(statearr_16600_16624[(2)] = null);

(statearr_16600_16624[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16588 === (9))){
var inst_16551 = (state_16587[(8)]);
var inst_16565 = cljs.core.vec(inst_16551);
var state_16587__$1 = state_16587;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16587__$1,(11),out,inst_16565);
} else {
if((state_val_16588 === (5))){
var inst_16560 = (state_16587[(11)]);
var inst_16552 = (state_16587[(7)]);
var inst_16555 = (state_16587[(9)]);
var inst_16551 = (state_16587[(8)]);
var inst_16559 = (inst_16551[inst_16552] = inst_16555);
var inst_16560__$1 = (inst_16552 + (1));
var inst_16561 = (inst_16560__$1 < n);
var state_16587__$1 = (function (){var statearr_16601 = state_16587;
(statearr_16601[(11)] = inst_16560__$1);

(statearr_16601[(12)] = inst_16559);

return statearr_16601;
})();
if(cljs.core.truth_(inst_16561)){
var statearr_16602_16625 = state_16587__$1;
(statearr_16602_16625[(1)] = (8));

} else {
var statearr_16603_16626 = state_16587__$1;
(statearr_16603_16626[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16588 === (14))){
var inst_16580 = (state_16587[(2)]);
var inst_16581 = cljs.core.async.close_BANG_(out);
var state_16587__$1 = (function (){var statearr_16605 = state_16587;
(statearr_16605[(13)] = inst_16580);

return statearr_16605;
})();
var statearr_16606_16627 = state_16587__$1;
(statearr_16606_16627[(2)] = inst_16581);

(statearr_16606_16627[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16588 === (10))){
var inst_16571 = (state_16587[(2)]);
var state_16587__$1 = state_16587;
var statearr_16607_16628 = state_16587__$1;
(statearr_16607_16628[(2)] = inst_16571);

(statearr_16607_16628[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16588 === (8))){
var inst_16560 = (state_16587[(11)]);
var inst_16551 = (state_16587[(8)]);
var tmp16604 = inst_16551;
var inst_16551__$1 = tmp16604;
var inst_16552 = inst_16560;
var state_16587__$1 = (function (){var statearr_16608 = state_16587;
(statearr_16608[(7)] = inst_16552);

(statearr_16608[(8)] = inst_16551__$1);

return statearr_16608;
})();
var statearr_16609_16629 = state_16587__$1;
(statearr_16609_16629[(2)] = null);

(statearr_16609_16629[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___16615,out))
;
return ((function (switch__14722__auto__,c__14822__auto___16615,out){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_16610 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16610[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_16610[(1)] = (1));

return statearr_16610;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_16587){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_16587);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e16611){if((e16611 instanceof Object)){
var ex__14726__auto__ = e16611;
var statearr_16612_16630 = state_16587;
(statearr_16612_16630[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16587);

return cljs.core.cst$kw$recur;
} else {
throw e16611;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__16631 = state_16587;
state_16587 = G__16631;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_16587){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_16587);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___16615,out))
})();
var state__14824__auto__ = (function (){var statearr_16613 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_16613[(6)] = c__14822__auto___16615);

return statearr_16613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___16615,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__16633 = arguments.length;
switch (G__16633) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14822__auto___16703 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___16703,out){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___16703,out){
return (function (state_16675){
var state_val_16676 = (state_16675[(1)]);
if((state_val_16676 === (7))){
var inst_16671 = (state_16675[(2)]);
var state_16675__$1 = state_16675;
var statearr_16677_16704 = state_16675__$1;
(statearr_16677_16704[(2)] = inst_16671);

(statearr_16677_16704[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16676 === (1))){
var inst_16634 = [];
var inst_16635 = inst_16634;
var inst_16636 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_16675__$1 = (function (){var statearr_16678 = state_16675;
(statearr_16678[(7)] = inst_16636);

(statearr_16678[(8)] = inst_16635);

return statearr_16678;
})();
var statearr_16679_16705 = state_16675__$1;
(statearr_16679_16705[(2)] = null);

(statearr_16679_16705[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16676 === (4))){
var inst_16639 = (state_16675[(9)]);
var inst_16639__$1 = (state_16675[(2)]);
var inst_16640 = (inst_16639__$1 == null);
var inst_16641 = cljs.core.not(inst_16640);
var state_16675__$1 = (function (){var statearr_16680 = state_16675;
(statearr_16680[(9)] = inst_16639__$1);

return statearr_16680;
})();
if(inst_16641){
var statearr_16681_16706 = state_16675__$1;
(statearr_16681_16706[(1)] = (5));

} else {
var statearr_16682_16707 = state_16675__$1;
(statearr_16682_16707[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16676 === (15))){
var inst_16665 = (state_16675[(2)]);
var state_16675__$1 = state_16675;
var statearr_16683_16708 = state_16675__$1;
(statearr_16683_16708[(2)] = inst_16665);

(statearr_16683_16708[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16676 === (13))){
var state_16675__$1 = state_16675;
var statearr_16684_16709 = state_16675__$1;
(statearr_16684_16709[(2)] = null);

(statearr_16684_16709[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16676 === (6))){
var inst_16635 = (state_16675[(8)]);
var inst_16660 = inst_16635.length;
var inst_16661 = (inst_16660 > (0));
var state_16675__$1 = state_16675;
if(cljs.core.truth_(inst_16661)){
var statearr_16685_16710 = state_16675__$1;
(statearr_16685_16710[(1)] = (12));

} else {
var statearr_16686_16711 = state_16675__$1;
(statearr_16686_16711[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16676 === (3))){
var inst_16673 = (state_16675[(2)]);
var state_16675__$1 = state_16675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16675__$1,inst_16673);
} else {
if((state_val_16676 === (12))){
var inst_16635 = (state_16675[(8)]);
var inst_16663 = cljs.core.vec(inst_16635);
var state_16675__$1 = state_16675;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16675__$1,(15),out,inst_16663);
} else {
if((state_val_16676 === (2))){
var state_16675__$1 = state_16675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16675__$1,(4),ch);
} else {
if((state_val_16676 === (11))){
var inst_16643 = (state_16675[(10)]);
var inst_16639 = (state_16675[(9)]);
var inst_16653 = (state_16675[(2)]);
var inst_16654 = [];
var inst_16655 = inst_16654.push(inst_16639);
var inst_16635 = inst_16654;
var inst_16636 = inst_16643;
var state_16675__$1 = (function (){var statearr_16687 = state_16675;
(statearr_16687[(11)] = inst_16653);

(statearr_16687[(7)] = inst_16636);

(statearr_16687[(8)] = inst_16635);

(statearr_16687[(12)] = inst_16655);

return statearr_16687;
})();
var statearr_16688_16712 = state_16675__$1;
(statearr_16688_16712[(2)] = null);

(statearr_16688_16712[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16676 === (9))){
var inst_16635 = (state_16675[(8)]);
var inst_16651 = cljs.core.vec(inst_16635);
var state_16675__$1 = state_16675;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16675__$1,(11),out,inst_16651);
} else {
if((state_val_16676 === (5))){
var inst_16643 = (state_16675[(10)]);
var inst_16639 = (state_16675[(9)]);
var inst_16636 = (state_16675[(7)]);
var inst_16643__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_16639) : f.call(null,inst_16639));
var inst_16644 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16643__$1,inst_16636);
var inst_16645 = cljs.core.keyword_identical_QMARK_(inst_16636,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_16646 = (inst_16644) || (inst_16645);
var state_16675__$1 = (function (){var statearr_16689 = state_16675;
(statearr_16689[(10)] = inst_16643__$1);

return statearr_16689;
})();
if(cljs.core.truth_(inst_16646)){
var statearr_16690_16713 = state_16675__$1;
(statearr_16690_16713[(1)] = (8));

} else {
var statearr_16691_16714 = state_16675__$1;
(statearr_16691_16714[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16676 === (14))){
var inst_16668 = (state_16675[(2)]);
var inst_16669 = cljs.core.async.close_BANG_(out);
var state_16675__$1 = (function (){var statearr_16693 = state_16675;
(statearr_16693[(13)] = inst_16668);

return statearr_16693;
})();
var statearr_16694_16715 = state_16675__$1;
(statearr_16694_16715[(2)] = inst_16669);

(statearr_16694_16715[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16676 === (10))){
var inst_16658 = (state_16675[(2)]);
var state_16675__$1 = state_16675;
var statearr_16695_16716 = state_16675__$1;
(statearr_16695_16716[(2)] = inst_16658);

(statearr_16695_16716[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16676 === (8))){
var inst_16643 = (state_16675[(10)]);
var inst_16639 = (state_16675[(9)]);
var inst_16635 = (state_16675[(8)]);
var inst_16648 = inst_16635.push(inst_16639);
var tmp16692 = inst_16635;
var inst_16635__$1 = tmp16692;
var inst_16636 = inst_16643;
var state_16675__$1 = (function (){var statearr_16696 = state_16675;
(statearr_16696[(14)] = inst_16648);

(statearr_16696[(7)] = inst_16636);

(statearr_16696[(8)] = inst_16635__$1);

return statearr_16696;
})();
var statearr_16697_16717 = state_16675__$1;
(statearr_16697_16717[(2)] = null);

(statearr_16697_16717[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto___16703,out))
;
return ((function (switch__14722__auto__,c__14822__auto___16703,out){
return (function() {
var cljs$core$async$state_machine__14723__auto__ = null;
var cljs$core$async$state_machine__14723__auto____0 = (function (){
var statearr_16698 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16698[(0)] = cljs$core$async$state_machine__14723__auto__);

(statearr_16698[(1)] = (1));

return statearr_16698;
});
var cljs$core$async$state_machine__14723__auto____1 = (function (state_16675){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_16675);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e16699){if((e16699 instanceof Object)){
var ex__14726__auto__ = e16699;
var statearr_16700_16718 = state_16675;
(statearr_16700_16718[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16675);

return cljs.core.cst$kw$recur;
} else {
throw e16699;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__16719 = state_16675;
state_16675 = G__16719;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs$core$async$state_machine__14723__auto__ = function(state_16675){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14723__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14723__auto____1.call(this,state_16675);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14723__auto____0;
cljs$core$async$state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14723__auto____1;
return cljs$core$async$state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___16703,out))
})();
var state__14824__auto__ = (function (){var statearr_16701 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_16701[(6)] = c__14822__auto___16703);

return statearr_16701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___16703,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

