// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__6612__auto__ = v;
if(cljs.core.truth_(and__6612__auto__)){
return (v > (0));
} else {
return and__6612__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__17228_SHARP_,p2__17227_SHARP_){
var vec__17229 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__17227_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17229,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17229,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17228_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_(url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.cst$kw$server_DASH_name,uri.getDomain(),cljs.core.cst$kw$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.cst$kw$uri,uri.getPath(),cljs.core.cst$kw$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),cljs.core.cst$kw$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode(cljs.core.name(k))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode([cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17232_SHARP_){
return cljs_http.client.encode_val(k,p1__17232_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__17233){
var vec__17234 = p__17233;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17234,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17234,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__17237_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17237_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__6612__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$head,request_method);
if(and__6612__auto__){
var and__6612__auto____$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((204),cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response));
if(and__6612__auto____$1){
return cljs.core.re_find(cljs.core.re_pattern([cljs.core.str.cljs$core$IFn$_invoke$arity$1("(?i)"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__6612__auto____$1;
}
} else {
return and__6612__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4655__auto__ = cljs.core.cst$kw$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request)], 0));
var G__17238 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$edn_DASH_params),cljs.core.cst$kw$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([params], 0))),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17238) : client.call(null,G__17238));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__17239_SHARP_){
return cljs_http.client.decode_body(p1__17239_SHARP_,cljs.reader.read_string,"application/edn",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17247 = arguments.length;
var i__7750__auto___17248 = (0);
while(true){
if((i__7750__auto___17248 < len__7749__auto___17247)){
args__7756__auto__.push((arguments[i__7750__auto___17248]));

var G__17249 = (i__7750__auto___17248 + (1));
i__7750__auto___17248 = G__17249;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__17242){
var vec__17243 = p__17242;
var default_headers = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17243,(0),null);
return ((function (vec__17243,default_headers){
return (function (request){
var temp__4655__auto__ = (function (){var or__6624__auto__ = cljs.core.cst$kw$default_DASH_headers.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var default_headers__$1 = temp__4655__auto__;
var G__17246 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(request,cljs.core.cst$kw$default_DASH_headers,default_headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17246) : client.call(null,G__17246));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__17243,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq17240){
var G__17241 = cljs.core.first(seq17240);
var seq17240__$1 = cljs.core.next(seq17240);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__17241,seq17240__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17257 = arguments.length;
var i__7750__auto___17258 = (0);
while(true){
if((i__7750__auto___17258 < len__7749__auto___17257)){
args__7756__auto__.push((arguments[i__7750__auto___17258]));

var G__17259 = (i__7750__auto___17258 + (1));
i__7750__auto___17258 = G__17259;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__17252){
var vec__17253 = p__17252;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17253,(0),null);
return ((function (vec__17253,accept){
return (function (request){
var temp__4655__auto__ = (function (){var or__6624__auto__ = cljs.core.cst$kw$accept.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var accept__$1 = temp__4655__auto__;
var G__17256 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17256) : client.call(null,G__17256));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__17253,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq17250){
var G__17251 = cljs.core.first(seq17250);
var seq17250__$1 = cljs.core.next(seq17250);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__17251,seq17250__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17267 = arguments.length;
var i__7750__auto___17268 = (0);
while(true){
if((i__7750__auto___17268 < len__7749__auto___17267)){
args__7756__auto__.push((arguments[i__7750__auto___17268]));

var G__17269 = (i__7750__auto___17268 + (1));
i__7750__auto___17268 = G__17269;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__17262){
var vec__17263 = p__17262;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17263,(0),null);
return ((function (vec__17263,content_type){
return (function (request){
var temp__4655__auto__ = (function (){var or__6624__auto__ = cljs.core.cst$kw$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var content_type__$1 = temp__4655__auto__;
var G__17266 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17266) : client.call(null,G__17266));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
;})(vec__17263,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq17260){
var G__17261 = cljs.core.first(seq17260);
var seq17260__$1 = cljs.core.next(seq17260);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__17261,seq17260__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$encoding,cljs.core.cst$kw$json,cljs.core.cst$kw$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$decoding,cljs.core.cst$kw$json,cljs.core.cst$kw$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4655__auto__ = cljs.core.cst$kw$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var map__17270 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs_http.client.default_transit_opts,cljs.core.cst$kw$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__17270__$1 = ((((!((map__17270 == null)))?((((map__17270.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17270.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17270):map__17270);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17270__$1,cljs.core.cst$kw$encoding);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17270__$1,cljs.core.cst$kw$encoding_DASH_opts);
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request)], 0));
var G__17272 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$transit_DASH_params),cljs.core.cst$kw$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17272) : client.call(null,G__17272));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__17275 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs_http.client.default_transit_opts,cljs.core.cst$kw$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__17275__$1 = ((((!((map__17275 == null)))?((((map__17275.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17275.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17275):map__17275);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17275__$1,cljs.core.cst$kw$decoding);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17275__$1,cljs.core.cst$kw$decoding_DASH_opts);
var transit_decode = ((function (map__17275,map__17275__$1,decoding,decoding_opts){
return (function (p1__17273_SHARP_){
return cljs_http.util.transit_decode(p1__17273_SHARP_,decoding,decoding_opts);
});})(map__17275,map__17275__$1,decoding,decoding_opts))
;
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(((function (map__17275,map__17275__$1,decoding,decoding_opts,transit_decode){
return (function (p1__17274_SHARP_){
return cljs_http.client.decode_body(p1__17274_SHARP_,transit_decode,"application/transit+json",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
});})(map__17275,map__17275__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4655__auto__ = cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request)], 0));
var G__17277 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$json_DASH_params),cljs.core.cst$kw$body,cljs_http.util.json_encode(params)),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17277) : client.call(null,G__17277));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__17278_SHARP_){
return cljs_http.client.decode_body(p1__17278_SHARP_,cljs_http.util.json_decode,"application/json",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request))], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__17279){
var map__17280 = p__17279;
var map__17280__$1 = ((((!((map__17280 == null)))?((((map__17280.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17280.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17280):map__17280);
var req = map__17280__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17280__$1,cljs.core.cst$kw$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__17282 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$query_DASH_params),cljs.core.cst$kw$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17282) : client.call(null,G__17282));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__17283){
var map__17284 = p__17283;
var map__17284__$1 = ((((!((map__17284 == null)))?((((map__17284.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17284.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17284):map__17284);
var request = map__17284__$1;
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17284__$1,cljs.core.cst$kw$form_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17284__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17284__$1,cljs.core.cst$kw$headers);
if(cljs.core.truth_((function (){var and__6612__auto__ = form_params;
if(cljs.core.truth_(and__6612__auto__)){
var fexpr__17286 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$patch,null,cljs.core.cst$kw$delete,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$put,null], null), null);
return (fexpr__17286.cljs$core$IFn$_invoke$arity$1 ? fexpr__17286.cljs$core$IFn$_invoke$arity$1(request_method) : fexpr__17286.call(null,request_method));
} else {
return and__6612__auto__;
}
})())){
var headers__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers], 0));
var G__17287 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$form_DASH_params),cljs.core.cst$kw$body,cljs_http.client.generate_query_string(form_params)),cljs.core.cst$kw$headers,headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17287) : client.call(null,G__17287));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__17288_17298 = cljs.core.seq(params);
var chunk__17289_17299 = null;
var count__17290_17300 = (0);
var i__17291_17301 = (0);
while(true){
if((i__17291_17301 < count__17290_17300)){
var vec__17292_17302 = chunk__17289_17299.cljs$core$IIndexed$_nth$arity$2(null,i__17291_17301);
var k_17303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17292_17302,(0),null);
var v_17304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17292_17302,(1),null);
if(cljs.core.coll_QMARK_(v_17304)){
form_data.append(cljs.core.name(k_17303),cljs.core.first(v_17304),cljs.core.second(v_17304));
} else {
form_data.append(cljs.core.name(k_17303),v_17304);
}

var G__17305 = seq__17288_17298;
var G__17306 = chunk__17289_17299;
var G__17307 = count__17290_17300;
var G__17308 = (i__17291_17301 + (1));
seq__17288_17298 = G__17305;
chunk__17289_17299 = G__17306;
count__17290_17300 = G__17307;
i__17291_17301 = G__17308;
continue;
} else {
var temp__4657__auto___17309 = cljs.core.seq(seq__17288_17298);
if(temp__4657__auto___17309){
var seq__17288_17310__$1 = temp__4657__auto___17309;
if(cljs.core.chunked_seq_QMARK_(seq__17288_17310__$1)){
var c__7444__auto___17311 = cljs.core.chunk_first(seq__17288_17310__$1);
var G__17312 = cljs.core.chunk_rest(seq__17288_17310__$1);
var G__17313 = c__7444__auto___17311;
var G__17314 = cljs.core.count(c__7444__auto___17311);
var G__17315 = (0);
seq__17288_17298 = G__17312;
chunk__17289_17299 = G__17313;
count__17290_17300 = G__17314;
i__17291_17301 = G__17315;
continue;
} else {
var vec__17295_17316 = cljs.core.first(seq__17288_17310__$1);
var k_17317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17295_17316,(0),null);
var v_17318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17295_17316,(1),null);
if(cljs.core.coll_QMARK_(v_17318)){
form_data.append(cljs.core.name(k_17317),cljs.core.first(v_17318),cljs.core.second(v_17318));
} else {
form_data.append(cljs.core.name(k_17317),v_17318);
}

var G__17319 = cljs.core.next(seq__17288_17310__$1);
var G__17320 = null;
var G__17321 = (0);
var G__17322 = (0);
seq__17288_17298 = G__17319;
chunk__17289_17299 = G__17320;
count__17290_17300 = G__17321;
i__17291_17301 = G__17322;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__17323){
var map__17324 = p__17323;
var map__17324__$1 = ((((!((map__17324 == null)))?((((map__17324.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17324.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17324):map__17324);
var request = map__17324__$1;
var multipart_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17324__$1,cljs.core.cst$kw$multipart_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17324__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core.truth_((function (){var and__6612__auto__ = multipart_params;
if(cljs.core.truth_(and__6612__auto__)){
var fexpr__17326 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$patch,null,cljs.core.cst$kw$delete,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$put,null], null), null);
return (fexpr__17326.cljs$core$IFn$_invoke$arity$1 ? fexpr__17326.cljs$core$IFn$_invoke$arity$1(request_method) : fexpr__17326.call(null,request_method));
} else {
return and__6612__auto__;
}
})())){
var G__17327 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.cst$kw$multipart_DASH_params),cljs.core.cst$kw$body,cljs_http.client.generate_form_data(multipart_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17327) : client.call(null,G__17327));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4655__auto__ = cljs.core.cst$kw$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var m = temp__4655__auto__;
var G__17328 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$method),cljs.core.cst$kw$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17328) : client.call(null,G__17328));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__17329_SHARP_){
var G__17330 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17329_SHARP_,cljs.core.cst$kw$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17330) : client.call(null,G__17330));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__17332){
var map__17333 = p__17332;
var map__17333__$1 = ((((!((map__17333 == null)))?((((map__17333.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17333.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17333):map__17333);
var req = map__17333__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17333__$1,cljs.core.cst$kw$query_DASH_params);
var temp__4655__auto__ = cljs_http.client.parse_url(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4655__auto__)){
var spec = temp__4655__auto__;
var G__17335 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,spec], 0)),cljs.core.cst$kw$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params], null),((function (spec,temp__4655__auto__,map__17333,map__17333__$1,req,query_params){
return (function (p1__17331_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p1__17331_SHARP_,query_params], 0));
});})(spec,temp__4655__auto__,map__17333,map__17333__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17335) : client.call(null,G__17335));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17343 = arguments.length;
var i__7750__auto___17344 = (0);
while(true){
if((i__7750__auto___17344 < len__7749__auto___17343)){
args__7756__auto__.push((arguments[i__7750__auto___17344]));

var G__17345 = (i__7750__auto___17344 + (1));
i__7750__auto___17344 = G__17345;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__17338){
var vec__17339 = p__17338;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17339,(0),null);
return ((function (vec__17339,credentials){
return (function (req){
var credentials__$1 = (function (){var or__6624__auto__ = cljs.core.cst$kw$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__17342 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17342) : client.call(null,G__17342));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
;})(vec__17339,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq17336){
var G__17337 = cljs.core.first(seq17336);
var seq17336__$1 = cljs.core.next(seq17336);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__17337,seq17336__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4655__auto__ = cljs.core.cst$kw$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var oauth_token = temp__4655__auto__;
var G__17346 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"authorization"], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Bearer "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__17346) : client.call(null,G__17346));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4655__auto__ = cljs.core.cst$kw$channel.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var custom_channel = temp__4655__auto__;
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request)),custom_channel);
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request) : client.call(null,request));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers(cljs_http.client.wrap_channel_from_request_map(cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_multipart_params(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17354 = arguments.length;
var i__7750__auto___17355 = (0);
while(true){
if((i__7750__auto___17355 < len__7749__auto___17354)){
args__7756__auto__.push((arguments[i__7750__auto___17355]));

var G__17356 = (i__7750__auto___17355 + (1));
i__7750__auto___17355 = G__17356;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__17349){
var vec__17350 = p__17349;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17350,(0),null);
var G__17353 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$delete,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__17353) : cljs_http.client.request.call(null,G__17353));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq17347){
var G__17348 = cljs.core.first(seq17347);
var seq17347__$1 = cljs.core.next(seq17347);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__17348,seq17347__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17364 = arguments.length;
var i__7750__auto___17365 = (0);
while(true){
if((i__7750__auto___17365 < len__7749__auto___17364)){
args__7756__auto__.push((arguments[i__7750__auto___17365]));

var G__17366 = (i__7750__auto___17365 + (1));
i__7750__auto___17365 = G__17366;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__17359){
var vec__17360 = p__17359;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17360,(0),null);
var G__17363 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$get,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__17363) : cljs_http.client.request.call(null,G__17363));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq17357){
var G__17358 = cljs.core.first(seq17357);
var seq17357__$1 = cljs.core.next(seq17357);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__17358,seq17357__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17374 = arguments.length;
var i__7750__auto___17375 = (0);
while(true){
if((i__7750__auto___17375 < len__7749__auto___17374)){
args__7756__auto__.push((arguments[i__7750__auto___17375]));

var G__17376 = (i__7750__auto___17375 + (1));
i__7750__auto___17375 = G__17376;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__17369){
var vec__17370 = p__17369;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17370,(0),null);
var G__17373 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$head,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__17373) : cljs_http.client.request.call(null,G__17373));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq17367){
var G__17368 = cljs.core.first(seq17367);
var seq17367__$1 = cljs.core.next(seq17367);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__17368,seq17367__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17384 = arguments.length;
var i__7750__auto___17385 = (0);
while(true){
if((i__7750__auto___17385 < len__7749__auto___17384)){
args__7756__auto__.push((arguments[i__7750__auto___17385]));

var G__17386 = (i__7750__auto___17385 + (1));
i__7750__auto___17385 = G__17386;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__17379){
var vec__17380 = p__17379;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17380,(0),null);
var G__17383 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$jsonp,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__17383) : cljs_http.client.request.call(null,G__17383));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq17377){
var G__17378 = cljs.core.first(seq17377);
var seq17377__$1 = cljs.core.next(seq17377);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__17378,seq17377__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17394 = arguments.length;
var i__7750__auto___17395 = (0);
while(true){
if((i__7750__auto___17395 < len__7749__auto___17394)){
args__7756__auto__.push((arguments[i__7750__auto___17395]));

var G__17396 = (i__7750__auto___17395 + (1));
i__7750__auto___17395 = G__17396;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__17389){
var vec__17390 = p__17389;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17390,(0),null);
var G__17393 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$move,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__17393) : cljs_http.client.request.call(null,G__17393));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq17387){
var G__17388 = cljs.core.first(seq17387);
var seq17387__$1 = cljs.core.next(seq17387);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__17388,seq17387__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17404 = arguments.length;
var i__7750__auto___17405 = (0);
while(true){
if((i__7750__auto___17405 < len__7749__auto___17404)){
args__7756__auto__.push((arguments[i__7750__auto___17405]));

var G__17406 = (i__7750__auto___17405 + (1));
i__7750__auto___17405 = G__17406;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__17399){
var vec__17400 = p__17399;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17400,(0),null);
var G__17403 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$options,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__17403) : cljs_http.client.request.call(null,G__17403));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq17397){
var G__17398 = cljs.core.first(seq17397);
var seq17397__$1 = cljs.core.next(seq17397);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__17398,seq17397__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17414 = arguments.length;
var i__7750__auto___17415 = (0);
while(true){
if((i__7750__auto___17415 < len__7749__auto___17414)){
args__7756__auto__.push((arguments[i__7750__auto___17415]));

var G__17416 = (i__7750__auto___17415 + (1));
i__7750__auto___17415 = G__17416;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__17409){
var vec__17410 = p__17409;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17410,(0),null);
var G__17413 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$patch,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__17413) : cljs_http.client.request.call(null,G__17413));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq17407){
var G__17408 = cljs.core.first(seq17407);
var seq17407__$1 = cljs.core.next(seq17407);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__17408,seq17407__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17424 = arguments.length;
var i__7750__auto___17425 = (0);
while(true){
if((i__7750__auto___17425 < len__7749__auto___17424)){
args__7756__auto__.push((arguments[i__7750__auto___17425]));

var G__17426 = (i__7750__auto___17425 + (1));
i__7750__auto___17425 = G__17426;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__17419){
var vec__17420 = p__17419;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17420,(0),null);
var G__17423 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$post,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__17423) : cljs_http.client.request.call(null,G__17423));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq17417){
var G__17418 = cljs.core.first(seq17417);
var seq17417__$1 = cljs.core.next(seq17417);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__17418,seq17417__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__7756__auto__ = [];
var len__7749__auto___17434 = arguments.length;
var i__7750__auto___17435 = (0);
while(true){
if((i__7750__auto___17435 < len__7749__auto___17434)){
args__7756__auto__.push((arguments[i__7750__auto___17435]));

var G__17436 = (i__7750__auto___17435 + (1));
i__7750__auto___17435 = G__17436;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__17429){
var vec__17430 = p__17429;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17430,(0),null);
var G__17433 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$put,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__17433) : cljs_http.client.request.call(null,G__17433));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq17427){
var G__17428 = cljs.core.first(seq17427);
var seq17427__$1 = cljs.core.next(seq17427);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__17428,seq17427__$1);
});

