// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.XhrIo');
goog.require('goog.net.Jsonp');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4657__auto__ = (function (){var fexpr__17162 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__17162.cljs$core$IFn$_invoke$arity$1 ? fexpr__17162.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__17162.call(null,channel));
})();
if(cljs.core.truth_(temp__4657__auto__)){
var req = temp__4657__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__17163){
var vec__17164 = p__17163;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17164,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17164,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__17167 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__17167)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__17167)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__17167)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__17167)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__17167)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__17167)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17167)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__17168){
var map__17169 = p__17168;
var map__17169__$1 = ((((!((map__17169 == null)))?((((map__17169.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17169.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17169):map__17169);
var request = map__17169__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17169__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17169__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17169__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__6624__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__17171 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__17171,default_headers);

cljs_http.core.apply_response_type_BANG_(G__17171,response_type);

G__17171.setTimeoutInterval(timeout);

G__17171.setWithCredentials(send_credentials);

return G__17171;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__17172){
var map__17173 = p__17172;
var map__17173__$1 = ((((!((map__17173 == null)))?((((map__17173.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17173.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17173):map__17173);
var request = map__17173__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17173__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17173__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17173__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17173__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17173__$1,cljs.core.cst$kw$cancel);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__6624__auto__ = request_method;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__17173,map__17173__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__17175 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__17175) : cljs_http.core.error_kw.call(null,G__17175));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__17173,map__17173__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__14822__auto___17197 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___17197,channel,request_url,method,headers__$1,xhr,map__17173,map__17173__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___17197,channel,request_url,method,headers__$1,xhr,map__17173,map__17173__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function (state_17186){
var state_val_17187 = (state_17186[(1)]);
if((state_val_17187 === (1))){
var state_17186__$1 = state_17186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17186__$1,(2),cancel);
} else {
if((state_val_17187 === (2))){
var inst_17177 = (state_17186[(2)]);
var inst_17178 = xhr.isComplete();
var inst_17179 = cljs.core.not(inst_17178);
var state_17186__$1 = (function (){var statearr_17188 = state_17186;
(statearr_17188[(7)] = inst_17177);

return statearr_17188;
})();
if(inst_17179){
var statearr_17189_17198 = state_17186__$1;
(statearr_17189_17198[(1)] = (3));

} else {
var statearr_17190_17199 = state_17186__$1;
(statearr_17190_17199[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17187 === (3))){
var inst_17181 = xhr.abort();
var state_17186__$1 = state_17186;
var statearr_17191_17200 = state_17186__$1;
(statearr_17191_17200[(2)] = inst_17181);

(statearr_17191_17200[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17187 === (4))){
var state_17186__$1 = state_17186;
var statearr_17192_17201 = state_17186__$1;
(statearr_17192_17201[(2)] = null);

(statearr_17192_17201[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17187 === (5))){
var inst_17184 = (state_17186[(2)]);
var state_17186__$1 = state_17186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17186__$1,inst_17184);
} else {
return null;
}
}
}
}
}
});})(c__14822__auto___17197,channel,request_url,method,headers__$1,xhr,map__17173,map__17173__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
;
return ((function (switch__14722__auto__,c__14822__auto___17197,channel,request_url,method,headers__$1,xhr,map__17173,map__17173__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel){
return (function() {
var cljs_http$core$xhr_$_state_machine__14723__auto__ = null;
var cljs_http$core$xhr_$_state_machine__14723__auto____0 = (function (){
var statearr_17193 = [null,null,null,null,null,null,null,null];
(statearr_17193[(0)] = cljs_http$core$xhr_$_state_machine__14723__auto__);

(statearr_17193[(1)] = (1));

return statearr_17193;
});
var cljs_http$core$xhr_$_state_machine__14723__auto____1 = (function (state_17186){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_17186);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e17194){if((e17194 instanceof Object)){
var ex__14726__auto__ = e17194;
var statearr_17195_17202 = state_17186;
(statearr_17195_17202[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17186);

return cljs.core.cst$kw$recur;
} else {
throw e17194;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__17203 = state_17186;
state_17186 = G__17203;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__14723__auto__ = function(state_17186){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__14723__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__14723__auto____1.call(this,state_17186);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$xhr_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__14723__auto____0;
cljs_http$core$xhr_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__14723__auto____1;
return cljs_http$core$xhr_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___17197,channel,request_url,method,headers__$1,xhr,map__17173,map__17173__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
})();
var state__14824__auto__ = (function (){var statearr_17196 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_17196[(6)] = c__14822__auto___17197);

return statearr_17196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___17197,channel,request_url,method,headers__$1,xhr,map__17173,map__17173__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__17204){
var map__17205 = p__17204;
var map__17205__$1 = ((((!((map__17205 == null)))?((((map__17205.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17205.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17205):map__17205);
var request = map__17205__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17205__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17205__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17205__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__17205__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_17218 = jsonp.send(null,((function (channel,jsonp,map__17205,map__17205__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__17205,map__17205__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__17205,map__17205__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__17205,map__17205__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_17218], null));

if(cljs.core.truth_(cancel)){
var c__14822__auto___17219 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___17219,req_17218,channel,jsonp,map__17205,map__17205__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___17219,req_17218,channel,jsonp,map__17205,map__17205__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_17211){
var state_val_17212 = (state_17211[(1)]);
if((state_val_17212 === (1))){
var state_17211__$1 = state_17211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17211__$1,(2),cancel);
} else {
if((state_val_17212 === (2))){
var inst_17208 = (state_17211[(2)]);
var inst_17209 = jsonp.cancel(req_17218);
var state_17211__$1 = (function (){var statearr_17213 = state_17211;
(statearr_17213[(7)] = inst_17208);

return statearr_17213;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17211__$1,inst_17209);
} else {
return null;
}
}
});})(c__14822__auto___17219,req_17218,channel,jsonp,map__17205,map__17205__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__14722__auto__,c__14822__auto___17219,req_17218,channel,jsonp,map__17205,map__17205__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__14723__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__14723__auto____0 = (function (){
var statearr_17214 = [null,null,null,null,null,null,null,null];
(statearr_17214[(0)] = cljs_http$core$jsonp_$_state_machine__14723__auto__);

(statearr_17214[(1)] = (1));

return statearr_17214;
});
var cljs_http$core$jsonp_$_state_machine__14723__auto____1 = (function (state_17211){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_17211);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e17215){if((e17215 instanceof Object)){
var ex__14726__auto__ = e17215;
var statearr_17216_17220 = state_17211;
(statearr_17216_17220[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17211);

return cljs.core.cst$kw$recur;
} else {
throw e17215;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__17221 = state_17211;
state_17211 = G__17221;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__14723__auto__ = function(state_17211){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__14723__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__14723__auto____1.call(this,state_17211);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs_http$core$jsonp_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__14723__auto____0;
cljs_http$core$jsonp_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__14723__auto____1;
return cljs_http$core$jsonp_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___17219,req_17218,channel,jsonp,map__17205,map__17205__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__14824__auto__ = (function (){var statearr_17217 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_17217[(6)] = c__14822__auto___17219);

return statearr_17217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___17219,req_17218,channel,jsonp,map__17205,map__17205__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__17222){
var map__17223 = p__17222;
var map__17223__$1 = ((((!((map__17223 == null)))?((((map__17223.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17223.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17223):map__17223);
var request = map__17223__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17223__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
