// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('smithy.impl.components');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.core');
goog.require('om.dom');
goog.require('smithy.impl.inputs');
goog.require('smithy.util');
goog.require('goog.date.UtcDateTime');
goog.require('goog.i18n.DateTimeFormat');
/**
 * Component for an item in the action menu.
 */
smithy.impl.components.actionmenu_item_component = (function smithy$impl$components$actionmenu_item_component(p__24205,owner){
var map__24206 = p__24205;
var map__24206__$1 = ((((!((map__24206 == null)))?((((map__24206.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24206.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24206):map__24206);
var vkey = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24206__$1,cljs.core.cst$kw$vkey);
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24206__$1,cljs.core.cst$kw$action);
var desc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24206__$1,cljs.core.cst$kw$desc);
if(typeof smithy.impl.components.t_smithy$impl$components24208 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24208 = (function (p__24205,owner,map__24206,vkey,action,desc,meta24209){
this.p__24205 = p__24205;
this.owner = owner;
this.map__24206 = map__24206;
this.vkey = vkey;
this.action = action;
this.desc = desc;
this.meta24209 = meta24209;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24208.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__24206,map__24206__$1,vkey,action,desc){
return (function (_24210,meta24209__$1){
var self__ = this;
var _24210__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24208(self__.p__24205,self__.owner,self__.map__24206,self__.vkey,self__.action,self__.desc,meta24209__$1));
});})(map__24206,map__24206__$1,vkey,action,desc))
;

smithy.impl.components.t_smithy$impl$components24208.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__24206,map__24206__$1,vkey,action,desc){
return (function (_24210){
var self__ = this;
var _24210__$1 = this;
return self__.meta24209;
});})(map__24206,map__24206__$1,vkey,action,desc))
;

smithy.impl.components.t_smithy$impl$components24208.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24208.prototype.om$core$IRender$render$arity$1 = ((function (map__24206,map__24206__$1,vkey,action,desc){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__24211 = ({"value": self__.action});
var G__24212 = self__.desc;
return (om.dom.option.cljs$core$IFn$_invoke$arity$2 ? om.dom.option.cljs$core$IFn$_invoke$arity$2(G__24211,G__24212) : om.dom.option.call(null,G__24211,G__24212));
});})(map__24206,map__24206__$1,vkey,action,desc))
;

smithy.impl.components.t_smithy$impl$components24208.getBasis = ((function (map__24206,map__24206__$1,vkey,action,desc){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__24205,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__24206,cljs.core.cst$sym$vkey,cljs.core.cst$sym$action,cljs.core.cst$sym$desc,cljs.core.cst$sym$meta24209], null);
});})(map__24206,map__24206__$1,vkey,action,desc))
;

smithy.impl.components.t_smithy$impl$components24208.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24208.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24208";

smithy.impl.components.t_smithy$impl$components24208.cljs$lang$ctorPrWriter = ((function (map__24206,map__24206__$1,vkey,action,desc){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24208");
});})(map__24206,map__24206__$1,vkey,action,desc))
;

smithy.impl.components.__GT_t_smithy$impl$components24208 = ((function (map__24206,map__24206__$1,vkey,action,desc){
return (function smithy$impl$components$actionmenu_item_component_$___GT_t_smithy$impl$components24208(p__24205__$1,owner__$1,map__24206__$2,vkey__$1,action__$1,desc__$1,meta24209){
return (new smithy.impl.components.t_smithy$impl$components24208(p__24205__$1,owner__$1,map__24206__$2,vkey__$1,action__$1,desc__$1,meta24209));
});})(map__24206,map__24206__$1,vkey,action,desc))
;

}

return (new smithy.impl.components.t_smithy$impl$components24208(p__24205,owner,map__24206__$1,vkey,action,desc,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Handler for action menu selection events.
 */
smithy.impl.components.select_action_event_handler = (function smithy$impl$components$select_action_event_handler(vs,e){
var value = e.target.value;
var event = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(smithy.util.get_resource_type_name(vs)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-actionmenu")].join('');
var action = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$actions_DASH_ref,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(value)], null));
var fexpr__24213_24216 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$analytics_DASH_event], null));
(fexpr__24213_24216.cljs$core$IFn$_invoke$arity$2 ? fexpr__24213_24216.cljs$core$IFn$_invoke$arity$2(event,value) : fexpr__24213_24216.call(null,event,value));

if(cljs.core.truth_(action)){
var G__24214 = vs;
var G__24215 = smithy.util.get_resource_id(vs);
return (action.cljs$core$IFn$_invoke$arity$2 ? action.cljs$core$IFn$_invoke$arity$2(G__24214,G__24215) : action.call(null,G__24214,G__24215));
} else {
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Missing action: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(value))].join('')], 0));
}
});
/**
 * Return the menu options formatted for on Om's build-all.
 */
smithy.impl.components.actionmenu_builder_list = (function smithy$impl$components$actionmenu_builder_list(vs,key){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24217_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([key,cljs.core.cst$kw$action,cljs.core.cst$kw$desc],[cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(p1__24217_SHARP_),cljs.core.name(cljs.core.cst$kw$action.cljs$core$IFn$_invoke$arity$1(p1__24217_SHARP_)),cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(p1__24217_SHARP_)]);
}),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(vs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$actionmenu,cljs.core.cst$kw$menu], null))),cljs.core.PersistentArrayMap.createAsIfByAssoc([key,"",cljs.core.cst$kw$action,null,cljs.core.cst$kw$desc,"Actions..."]));
});
/**
 * Component for the Action Menu drop-down
 */
smithy.impl.components.actionmenu_component = (function smithy$impl$components$actionmenu_component(vs,owner){
if(typeof smithy.impl.components.t_smithy$impl$components24219 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24219 = (function (vs,owner,meta24220){
this.vs = vs;
this.owner = owner;
this.meta24220 = meta24220;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24219.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24221,meta24220__$1){
var self__ = this;
var _24221__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24219(self__.vs,self__.owner,meta24220__$1));
});

smithy.impl.components.t_smithy$impl$components24219.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24221){
var self__ = this;
var _24221__$1 = this;
return self__.meta24220;
});

smithy.impl.components.t_smithy$impl$components24219.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24219.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$action_DASH_menu_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.vs),"")){
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.vs,cljs.core.cst$kw$action_DASH_menu_DASH_id,"");
} else {
}

var key = cljs.core.cst$kw$vkey;
var G__24222 = ({"className": "actionmenu", "value": cljs.core.cst$kw$action_DASH_menu_DASH_id.cljs$core$IFn$_invoke$arity$1(self__.vs), "onChange": ((function (key,___$1){
return (function (p1__24218_SHARP_){
smithy.impl.components.select_action_event_handler(self__.vs,p1__24218_SHARP_);

return om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(self__.vs,cljs.core.cst$kw$action_DASH_menu_DASH_id,p1__24218_SHARP_.target.value);
});})(key,___$1))
});
var G__24223 = om.core.build_all.cljs$core$IFn$_invoke$arity$3(smithy.impl.components.actionmenu_item_component,smithy.impl.components.actionmenu_builder_list(self__.vs,key),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,key], null));
return (om.dom.select.cljs$core$IFn$_invoke$arity$2 ? om.dom.select.cljs$core$IFn$_invoke$arity$2(G__24222,G__24223) : om.dom.select.call(null,G__24222,G__24223));
});

smithy.impl.components.t_smithy$impl$components24219.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24220], null);
});

smithy.impl.components.t_smithy$impl$components24219.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24219.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24219";

smithy.impl.components.t_smithy$impl$components24219.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24219");
});

smithy.impl.components.__GT_t_smithy$impl$components24219 = (function smithy$impl$components$actionmenu_component_$___GT_t_smithy$impl$components24219(vs__$1,owner__$1,meta24220){
return (new smithy.impl.components.t_smithy$impl$components24219(vs__$1,owner__$1,meta24220));
});

}

return (new smithy.impl.components.t_smithy$impl$components24219(vs,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for input fields of any type.
 */
smithy.impl.components.field_component = (function smithy$impl$components$field_component(p__24224,owner){
var vec__24225 = p__24224;
var menu_item = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24225,(0),null);
var vs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24225,(1),null);
var buf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24225,(2),null);
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24225,(3),null);
if(typeof smithy.impl.components.t_smithy$impl$components24228 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24228 = (function (p__24224,owner,vec__24225,menu_item,vs,buf,opts,meta24229){
this.p__24224 = p__24224;
this.owner = owner;
this.vec__24225 = vec__24225;
this.menu_item = menu_item;
this.vs = vs;
this.buf = buf;
this.opts = opts;
this.meta24229 = meta24229;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24228.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__24225,menu_item,vs,buf,opts){
return (function (_24230,meta24229__$1){
var self__ = this;
var _24230__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24228(self__.p__24224,self__.owner,self__.vec__24225,self__.menu_item,self__.vs,self__.buf,self__.opts,meta24229__$1));
});})(vec__24225,menu_item,vs,buf,opts))
;

smithy.impl.components.t_smithy$impl$components24228.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__24225,menu_item,vs,buf,opts){
return (function (_24230){
var self__ = this;
var _24230__$1 = this;
return self__.meta24229;
});})(vec__24225,menu_item,vs,buf,opts))
;

smithy.impl.components.t_smithy$impl$components24228.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24228.prototype.om$core$IRender$render$arity$1 = ((function (vec__24225,menu_item,vs,buf,opts){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(self__.menu_item),cljs.core.cst$kw$label)){
var G__24231 = ({"className": "section-heading"});
var G__24232 = om.util.force_children(cljs.core.second(self__.menu_item));
return React.DOM.h4(G__24231,G__24232);
} else {
var value = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(self__.vs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.first(self__.menu_item)], null));
var G__24233 = ({"className": (cljs.core.truth_((function (){var and__6612__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$show_DASH_validations], null));
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(value,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$required], null));
} else {
return and__6612__auto__;
}
})())?"field-container show-validations":"field-container")});
var G__24234 = om.util.force_children((function (){var G__24237 = ({"className": "field-required-label"});
var G__24238 = om.util.force_children("Required");
return React.DOM.label(G__24237,G__24238);
})());
var G__24235 = om.util.force_children((function (){var G__24239 = ({"className": "field-label", "title": cljs.core.get.cljs$core$IFn$_invoke$arity$2(value,cljs.core.cst$kw$description)});
var G__24240 = om.util.force_children(cljs.core.get.cljs$core$IFn$_invoke$arity$2(value,cljs.core.cst$kw$label));
var G__24241 = om.util.force_children((cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(value,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$required], null)))?(function (){var G__24242 = ({"className": "required-asterisk"});
var G__24243 = om.util.force_children("*");
return React.DOM.label(G__24242,G__24243);
})():null));
return React.DOM.label(G__24239,G__24240,G__24241);
})());
var G__24236 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.inputs.input_field,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(self__.menu_item),value,self__.buf,(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(value,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$detailed], null)))?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([self__.opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$detailed,true], null)], 0)):self__.opts)], null)));
return React.DOM.div(G__24233,G__24234,G__24235,G__24236);
}
});})(vec__24225,menu_item,vs,buf,opts))
;

smithy.impl.components.t_smithy$impl$components24228.getBasis = ((function (vec__24225,menu_item,vs,buf,opts){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__24224,cljs.core.cst$sym$owner,cljs.core.cst$sym$vec__24225,cljs.core.cst$sym$menu_DASH_item,cljs.core.cst$sym$vs,cljs.core.cst$sym$buf,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta24229], null);
});})(vec__24225,menu_item,vs,buf,opts))
;

smithy.impl.components.t_smithy$impl$components24228.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24228.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24228";

smithy.impl.components.t_smithy$impl$components24228.cljs$lang$ctorPrWriter = ((function (vec__24225,menu_item,vs,buf,opts){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24228");
});})(vec__24225,menu_item,vs,buf,opts))
;

smithy.impl.components.__GT_t_smithy$impl$components24228 = ((function (vec__24225,menu_item,vs,buf,opts){
return (function smithy$impl$components$field_component_$___GT_t_smithy$impl$components24228(p__24224__$1,owner__$1,vec__24225__$1,menu_item__$1,vs__$1,buf__$1,opts__$1,meta24229){
return (new smithy.impl.components.t_smithy$impl$components24228(p__24224__$1,owner__$1,vec__24225__$1,menu_item__$1,vs__$1,buf__$1,opts__$1,meta24229));
});})(vec__24225,menu_item,vs,buf,opts))
;

}

return (new smithy.impl.components.t_smithy$impl$components24228(p__24224,owner,vec__24225,menu_item,vs,buf,opts,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Render all fields in the body
 */
smithy.impl.components.body_component = (function smithy$impl$components$body_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components24245 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24245 = (function (data,owner,meta24246){
this.data = data;
this.owner = owner;
this.meta24246 = meta24246;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24245.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24247,meta24246__$1){
var self__ = this;
var _24247__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24245(self__.data,self__.owner,meta24246__$1));
});

smithy.impl.components.t_smithy$impl$components24245.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24247){
var self__ = this;
var _24247__$1 = this;
return self__.meta24246;
});

smithy.impl.components.t_smithy$impl$components24245.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24245.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.cst$kw$vs.cljs$core$IFn$_invoke$arity$1(self__.data);
var gens = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$generator_DASH_fn,(function (){var f = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$build_DASH_generator], null));
if(cljs.core.truth_(f)){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(vs) : f.call(null,vs));
} else {
return null;
}
})(),cljs.core.cst$kw$generators,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$generators_DASH_ref),cljs.core.cst$kw$generator_DASH_data,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$generator_DASH_data),cljs.core.cst$kw$generator_DASH_args,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)),cljs.core.cst$kw$create))?smithy.util.get_parent_resource_id(vs):smithy.util.get_resource_id(vs))], null),cljs.core.cst$kw$image_DASH_resource_DASH_url,"/media/photo"], null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(om.dom.div,({"className": "section-body"}),om.core.build_all.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.field_component,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vs,gens,___$1){
return (function (p1__24244_SHARP_){
return (new cljs.core.PersistentVector(null,4,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__24244_SHARP_,vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer),((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)),cljs.core.cst$kw$readonly))?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([gens,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$disabled,true], null)], 0)):gens)],null));
});})(vs,gens,___$1))
,cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$screen.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$layout))));
});

smithy.impl.components.t_smithy$impl$components24245.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24246], null);
});

smithy.impl.components.t_smithy$impl$components24245.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24245.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24245";

smithy.impl.components.t_smithy$impl$components24245.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24245");
});

smithy.impl.components.__GT_t_smithy$impl$components24245 = (function smithy$impl$components$body_component_$___GT_t_smithy$impl$components24245(data__$1,owner__$1,meta24246){
return (new smithy.impl.components.t_smithy$impl$components24245(data__$1,owner__$1,meta24246));
});

}

return (new smithy.impl.components.t_smithy$impl$components24245(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Button-group component for finalising an update
 */
smithy.impl.components.update_button_component = (function smithy$impl$components$update_button_component(p__24248){
var map__24249 = p__24248;
var map__24249__$1 = ((((!((map__24249 == null)))?((((map__24249.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24249.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24249):map__24249);
var vs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24249__$1,cljs.core.cst$kw$vs);
var update = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24249__$1,cljs.core.cst$kw$update);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24249__$1,cljs.core.cst$kw$cancel);
var delete$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24249__$1,cljs.core.cst$kw$delete);
if(typeof smithy.impl.components.t_smithy$impl$components24251 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24251 = (function (p__24248,map__24249,vs,update,cancel,delete$,meta24252){
this.p__24248 = p__24248;
this.map__24249 = map__24249;
this.vs = vs;
this.update = update;
this.cancel = cancel;
this.delete$ = delete$;
this.meta24252 = meta24252;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24251.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__24249,map__24249__$1,vs,update,cancel,delete$){
return (function (_24253,meta24252__$1){
var self__ = this;
var _24253__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24251(self__.p__24248,self__.map__24249,self__.vs,self__.update,self__.cancel,self__.delete$,meta24252__$1));
});})(map__24249,map__24249__$1,vs,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components24251.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__24249,map__24249__$1,vs,update,cancel,delete$){
return (function (_24253){
var self__ = this;
var _24253__$1 = this;
return self__.meta24252;
});})(map__24249,map__24249__$1,vs,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components24251.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24251.prototype.om$core$IRender$render$arity$1 = ((function (map__24249,map__24249__$1,vs,update,cancel,delete$){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__24254 = ({"className": "button-container"});
var G__24255 = om.util.force_children((function (){var G__24257 = ({"className": "btn btn-default", "onClick": self__.cancel});
var G__24258 = om.util.force_children(" Cancel");
return React.DOM.button(G__24257,G__24258);
})());
var G__24256 = om.util.force_children((function (){var G__24259 = ({"className": "btn btn-primary", "onClick": self__.update});
var G__24260 = om.util.force_children(" Update");
return React.DOM.button(G__24259,G__24260);
})());
return React.DOM.div(G__24254,G__24255,G__24256);
});})(map__24249,map__24249__$1,vs,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components24251.getBasis = ((function (map__24249,map__24249__$1,vs,update,cancel,delete$){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__24248,cljs.core.cst$sym$map__24249,cljs.core.cst$sym$vs,cljs.core.cst$sym$update,cljs.core.cst$sym$cancel,cljs.core.cst$sym$delete,cljs.core.cst$sym$meta24252], null);
});})(map__24249,map__24249__$1,vs,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components24251.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24251.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24251";

smithy.impl.components.t_smithy$impl$components24251.cljs$lang$ctorPrWriter = ((function (map__24249,map__24249__$1,vs,update,cancel,delete$){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24251");
});})(map__24249,map__24249__$1,vs,update,cancel,delete$))
;

smithy.impl.components.__GT_t_smithy$impl$components24251 = ((function (map__24249,map__24249__$1,vs,update,cancel,delete$){
return (function smithy$impl$components$update_button_component_$___GT_t_smithy$impl$components24251(p__24248__$1,map__24249__$2,vs__$1,update__$1,cancel__$1,delete$__$1,meta24252){
return (new smithy.impl.components.t_smithy$impl$components24251(p__24248__$1,map__24249__$2,vs__$1,update__$1,cancel__$1,delete$__$1,meta24252));
});})(map__24249,map__24249__$1,vs,update,cancel,delete$))
;

}

return (new smithy.impl.components.t_smithy$impl$components24251(p__24248,map__24249__$1,vs,update,cancel,delete$,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for Update Mode
 */
smithy.impl.components.resource_update_component = (function smithy$impl$components$resource_update_component(p__24261,owner){
var map__24262 = p__24261;
var map__24262__$1 = ((((!((map__24262 == null)))?((((map__24262.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24262.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24262):map__24262);
var k = map__24262__$1;
var vs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24262__$1,cljs.core.cst$kw$vs);
var screen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24262__$1,cljs.core.cst$kw$screen);
var update = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24262__$1,cljs.core.cst$kw$update);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24262__$1,cljs.core.cst$kw$cancel);
var delete$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24262__$1,cljs.core.cst$kw$delete);
if(typeof smithy.impl.components.t_smithy$impl$components24264 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24264 = (function (p__24261,owner,map__24262,k,vs,screen,update,cancel,delete$,meta24265){
this.p__24261 = p__24261;
this.owner = owner;
this.map__24262 = map__24262;
this.k = k;
this.vs = vs;
this.screen = screen;
this.update = update;
this.cancel = cancel;
this.delete$ = delete$;
this.meta24265 = meta24265;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24264.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$){
return (function (_24266,meta24265__$1){
var self__ = this;
var _24266__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24264(self__.p__24261,self__.owner,self__.map__24262,self__.k,self__.vs,self__.screen,self__.update,self__.cancel,self__.delete$,meta24265__$1));
});})(map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components24264.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$){
return (function (_24266){
var self__ = this;
var _24266__$1 = this;
return self__.meta24265;
});})(map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components24264.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24264.prototype.om$core$IRender$render$arity$1 = ((function (map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__24267 = null;
var G__24268 = om.util.force_children((function (){var G__24271 = null;
var G__24272 = om.util.force_children([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Update "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(smithy.util.get_screen_title(self__.vs))].join(''));
return React.DOM.h4(G__24271,G__24272);
})());
var G__24269 = om.util.force_children((function (){var G__24273 = null;
var G__24274 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.body_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vs,self__.vs,cljs.core.cst$kw$screen,self__.screen], null)));
return React.DOM.div(G__24273,G__24274);
})());
var G__24270 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.update_button_component,self__.k));
return React.DOM.div(G__24267,G__24268,G__24269,G__24270);
});})(map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components24264.getBasis = ((function (map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__24261,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__24262,cljs.core.cst$sym$k,cljs.core.cst$sym$vs,cljs.core.cst$sym$screen,cljs.core.cst$sym$update,cljs.core.cst$sym$cancel,cljs.core.cst$sym$delete,cljs.core.cst$sym$meta24265], null);
});})(map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$))
;

smithy.impl.components.t_smithy$impl$components24264.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24264.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24264";

smithy.impl.components.t_smithy$impl$components24264.cljs$lang$ctorPrWriter = ((function (map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24264");
});})(map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$))
;

smithy.impl.components.__GT_t_smithy$impl$components24264 = ((function (map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$){
return (function smithy$impl$components$resource_update_component_$___GT_t_smithy$impl$components24264(p__24261__$1,owner__$1,map__24262__$2,k__$1,vs__$1,screen__$1,update__$1,cancel__$1,delete$__$1,meta24265){
return (new smithy.impl.components.t_smithy$impl$components24264(p__24261__$1,owner__$1,map__24262__$2,k__$1,vs__$1,screen__$1,update__$1,cancel__$1,delete$__$1,meta24265));
});})(map__24262,map__24262__$1,k,vs,screen,update,cancel,delete$))
;

}

return (new smithy.impl.components.t_smithy$impl$components24264(p__24261,owner,map__24262__$1,k,vs,screen,update,cancel,delete$,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for Readonly Mode
 */
smithy.impl.components.resource_view_component = (function smithy$impl$components$resource_view_component(p__24275,owner){
var map__24276 = p__24275;
var map__24276__$1 = ((((!((map__24276 == null)))?((((map__24276.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24276.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24276):map__24276);
var vs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24276__$1,cljs.core.cst$kw$vs);
var screen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24276__$1,cljs.core.cst$kw$screen);
if(typeof smithy.impl.components.t_smithy$impl$components24278 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24278 = (function (p__24275,owner,map__24276,vs,screen,meta24279){
this.p__24275 = p__24275;
this.owner = owner;
this.map__24276 = map__24276;
this.vs = vs;
this.screen = screen;
this.meta24279 = meta24279;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24278.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__24276,map__24276__$1,vs,screen){
return (function (_24280,meta24279__$1){
var self__ = this;
var _24280__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24278(self__.p__24275,self__.owner,self__.map__24276,self__.vs,self__.screen,meta24279__$1));
});})(map__24276,map__24276__$1,vs,screen))
;

smithy.impl.components.t_smithy$impl$components24278.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__24276,map__24276__$1,vs,screen){
return (function (_24280){
var self__ = this;
var _24280__$1 = this;
return self__.meta24279;
});})(map__24276,map__24276__$1,vs,screen))
;

smithy.impl.components.t_smithy$impl$components24278.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24278.prototype.om$core$IRender$render$arity$1 = ((function (map__24276,map__24276__$1,vs,screen){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__24281 = null;
var G__24282 = om.util.force_children((cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(self__.vs),cljs.core.cst$kw$actionmenu))?om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.actionmenu_component,self__.vs):null));
var G__24283 = om.util.force_children((function (){var G__24285 = null;
var G__24286 = om.util.force_children(smithy.util.get_screen_title(self__.vs));
return React.DOM.h4(G__24285,G__24286);
})());
var G__24284 = om.util.force_children((function (){var G__24287 = null;
var G__24288 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.body_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vs,self__.vs,cljs.core.cst$kw$screen,self__.screen], null)));
return React.DOM.div(G__24287,G__24288);
})());
return React.DOM.div(G__24281,G__24282,G__24283,G__24284);
});})(map__24276,map__24276__$1,vs,screen))
;

smithy.impl.components.t_smithy$impl$components24278.getBasis = ((function (map__24276,map__24276__$1,vs,screen){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__24275,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__24276,cljs.core.cst$sym$vs,cljs.core.cst$sym$screen,cljs.core.cst$sym$meta24279], null);
});})(map__24276,map__24276__$1,vs,screen))
;

smithy.impl.components.t_smithy$impl$components24278.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24278.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24278";

smithy.impl.components.t_smithy$impl$components24278.cljs$lang$ctorPrWriter = ((function (map__24276,map__24276__$1,vs,screen){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24278");
});})(map__24276,map__24276__$1,vs,screen))
;

smithy.impl.components.__GT_t_smithy$impl$components24278 = ((function (map__24276,map__24276__$1,vs,screen){
return (function smithy$impl$components$resource_view_component_$___GT_t_smithy$impl$components24278(p__24275__$1,owner__$1,map__24276__$2,vs__$1,screen__$1,meta24279){
return (new smithy.impl.components.t_smithy$impl$components24278(p__24275__$1,owner__$1,map__24276__$2,vs__$1,screen__$1,meta24279));
});})(map__24276,map__24276__$1,vs,screen))
;

}

return (new smithy.impl.components.t_smithy$impl$components24278(p__24275,owner,map__24276__$1,vs,screen,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for Create Mode
 */
smithy.impl.components.resource_create_component = (function smithy$impl$components$resource_create_component(p__24289,owner){
var map__24290 = p__24289;
var map__24290__$1 = ((((!((map__24290 == null)))?((((map__24290.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24290.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24290):map__24290);
var vs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24290__$1,cljs.core.cst$kw$vs);
var screen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24290__$1,cljs.core.cst$kw$screen);
var create = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24290__$1,cljs.core.cst$kw$create);
if(typeof smithy.impl.components.t_smithy$impl$components24292 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24292 = (function (p__24289,owner,map__24290,vs,screen,create,meta24293){
this.p__24289 = p__24289;
this.owner = owner;
this.map__24290 = map__24290;
this.vs = vs;
this.screen = screen;
this.create = create;
this.meta24293 = meta24293;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24292.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__24290,map__24290__$1,vs,screen,create){
return (function (_24294,meta24293__$1){
var self__ = this;
var _24294__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24292(self__.p__24289,self__.owner,self__.map__24290,self__.vs,self__.screen,self__.create,meta24293__$1));
});})(map__24290,map__24290__$1,vs,screen,create))
;

smithy.impl.components.t_smithy$impl$components24292.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__24290,map__24290__$1,vs,screen,create){
return (function (_24294){
var self__ = this;
var _24294__$1 = this;
return self__.meta24293;
});})(map__24290,map__24290__$1,vs,screen,create))
;

smithy.impl.components.t_smithy$impl$components24292.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24292.prototype.om$core$IRender$render$arity$1 = ((function (map__24290,map__24290__$1,vs,screen,create){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__24295 = null;
var G__24296 = om.util.force_children((cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.vs,cljs.core.cst$kw$title_DASH_override))?(function (){var G__24299 = null;
var G__24300 = om.util.force_children(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.vs,cljs.core.cst$kw$title_DASH_override));
return React.DOM.h4(G__24299,G__24300);
})():(function (){var G__24301 = null;
var G__24302 = om.util.force_children([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Create "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(smithy.util.get_screen_title(self__.vs))].join(''));
return React.DOM.h4(G__24301,G__24302);
})()));
var G__24297 = om.util.force_children((function (){var G__24303 = null;
var G__24304 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.body_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vs,self__.vs,cljs.core.cst$kw$screen,self__.screen], null)));
return React.DOM.div(G__24303,G__24304);
})());
var G__24298 = om.util.force_children((function (){var G__24305 = ({"className": "button-container"});
var G__24306 = om.util.force_children((function (){var G__24307 = ({"className": "btn btn-primary fa fa-plus fa-2x", "onClick": self__.create});
var G__24308 = om.util.force_children(" Create");
return React.DOM.button(G__24307,G__24308);
})());
return React.DOM.div(G__24305,G__24306);
})());
return React.DOM.div(G__24295,G__24296,G__24297,G__24298);
});})(map__24290,map__24290__$1,vs,screen,create))
;

smithy.impl.components.t_smithy$impl$components24292.getBasis = ((function (map__24290,map__24290__$1,vs,screen,create){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__24289,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__24290,cljs.core.cst$sym$vs,cljs.core.cst$sym$screen,cljs.core.cst$sym$create,cljs.core.cst$sym$meta24293], null);
});})(map__24290,map__24290__$1,vs,screen,create))
;

smithy.impl.components.t_smithy$impl$components24292.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24292.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24292";

smithy.impl.components.t_smithy$impl$components24292.cljs$lang$ctorPrWriter = ((function (map__24290,map__24290__$1,vs,screen,create){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24292");
});})(map__24290,map__24290__$1,vs,screen,create))
;

smithy.impl.components.__GT_t_smithy$impl$components24292 = ((function (map__24290,map__24290__$1,vs,screen,create){
return (function smithy$impl$components$resource_create_component_$___GT_t_smithy$impl$components24292(p__24289__$1,owner__$1,map__24290__$2,vs__$1,screen__$1,create__$1,meta24293){
return (new smithy.impl.components.t_smithy$impl$components24292(p__24289__$1,owner__$1,map__24290__$2,vs__$1,screen__$1,create__$1,meta24293));
});})(map__24290,map__24290__$1,vs,screen,create))
;

}

return (new smithy.impl.components.t_smithy$impl$components24292(p__24289,owner,map__24290__$1,vs,screen,create,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Component for a single navigation item in the sidebar.
 */
smithy.impl.components.sidebar_item_component = (function smithy$impl$components$sidebar_item_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components24309 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24309 = (function (data,owner,meta24310){
this.data = data;
this.owner = owner;
this.meta24310 = meta24310;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24309.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24311,meta24310__$1){
var self__ = this;
var _24311__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24309(self__.data,self__.owner,meta24310__$1));
});

smithy.impl.components.t_smithy$impl$components24309.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24311){
var self__ = this;
var _24311__$1 = this;
return self__.meta24310;
});

smithy.impl.components.t_smithy$impl$components24309.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24309.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__24312 = ({"className": "sidebar-item", "onClick": ((function (___$1){
return (function (){
var G__24315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.cst$kw$view_DASH_state);
var G__24316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.cst$kw$resource_DASH_id);
var fexpr__24314 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$view_DASH_state,cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$sidebar_DASH_item_DASH_click], null));
return (fexpr__24314.cljs$core$IFn$_invoke$arity$2 ? fexpr__24314.cljs$core$IFn$_invoke$arity$2(G__24315,G__24316) : fexpr__24314.call(null,G__24315,G__24316));
});})(___$1))
});
var G__24313 = om.util.force_children((function (){var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$item.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.data,cljs.core.cst$kw$label));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.type(label),goog.date.UtcDateTime)){
var df = (new goog.i18n.DateTimeFormat("yyyy-MM-dd HH:mm:ss"));
var G__24317 = null;
var G__24318 = om.util.force_children(df.format((function (){var G__24319 = label.getTime();
return (goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1 ? goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1(G__24319) : goog.date.UtcDateTime.fromTimestamp.call(null,G__24319));
})()));
return React.DOM.a(G__24317,G__24318);
} else {
var G__24320 = null;
var G__24321 = om.util.force_children(label);
return React.DOM.a(G__24320,G__24321);
}
})());
return React.DOM.li(G__24312,G__24313);
});

smithy.impl.components.t_smithy$impl$components24309.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24310], null);
});

smithy.impl.components.t_smithy$impl$components24309.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24309.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24309";

smithy.impl.components.t_smithy$impl$components24309.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24309");
});

smithy.impl.components.__GT_t_smithy$impl$components24309 = (function smithy$impl$components$sidebar_item_component_$___GT_t_smithy$impl$components24309(data__$1,owner__$1,meta24310){
return (new smithy.impl.components.t_smithy$impl$components24309(data__$1,owner__$1,meta24310));
});

}

return (new smithy.impl.components.t_smithy$impl$components24309(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Return the built components for the sidebar items.
 */
smithy.impl.components.build_sidebar_item_components = (function smithy$impl$components$build_sidebar_item_components(vs){
var screen = smithy.util.get_screen(vs);
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$sidebar,cljs.core.cst$kw$resource], null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(om.dom.ul,null,(function (){var G__24324 = null;
var G__24325 = om.util.force_children(cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$title));
return React.DOM.li(G__24324,G__24325);
})(),om.core.build_all.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.sidebar_item_component,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (screen,res){
return (function (p1__24322_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$item,cljs.core.cst$kw$view_DASH_state,cljs.core.cst$kw$label,cljs.core.cst$kw$id,cljs.core.cst$kw$resource_DASH_id,cljs.core.cst$kw$uri],[p1__24322_SHARP_,vs,cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$label),cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$id),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__24322_SHARP_,cljs.core.get.cljs$core$IFn$_invoke$arity$2(res,cljs.core.cst$kw$id)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__24322_SHARP_,cljs.core.cst$kw$uri)]);
});})(screen,res))
,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (screen,res){
return (function (p1__24323_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__24323_SHARP_,cljs.core.cst$kw$label.cljs$core$IFn$_invoke$arity$1(res));
});})(screen,res))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_resource,cljs.core.cst$kw$children], null))))));
});
/**
 * Component for the navigation sidebar.
 */
smithy.impl.components.sidebar_component = (function smithy$impl$components$sidebar_component(vs,owner){
if(typeof smithy.impl.components.t_smithy$impl$components24326 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24326 = (function (vs,owner,meta24327){
this.vs = vs;
this.owner = owner;
this.meta24327 = meta24327;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24326.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24328,meta24327__$1){
var self__ = this;
var _24328__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24326(self__.vs,self__.owner,meta24327__$1));
});

smithy.impl.components.t_smithy$impl$components24326.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24328){
var self__ = this;
var _24328__$1 = this;
return self__.meta24327;
});

smithy.impl.components.t_smithy$impl$components24326.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24326.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var fexpr__24329 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$actions_DASH_ref,cljs.core.cst$kw$load_DASH_resource_DASH_children], null));
return (fexpr__24329.cljs$core$IFn$_invoke$arity$1 ? fexpr__24329.cljs$core$IFn$_invoke$arity$1(self__.vs) : fexpr__24329.call(null,self__.vs));
});

smithy.impl.components.t_smithy$impl$components24326.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24326.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__24330 = ({"className": "sidebar"});
var G__24331 = om.util.force_children(((cljs.core.not(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(smithy.util.get_screen(self__.vs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$resource,cljs.core.cst$kw$non_DASH_creatable], null))))?(function (){var G__24333 = ({"className": "create-record-btn btn btn-primary fa fa-plus fa-2x", "disabled": cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)),cljs.core.cst$kw$create), "onClick": ((function (G__24330,___$1){
return (function (){
var fexpr__24334 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$sidebar_DASH_create_DASH_click], null));
return (fexpr__24334.cljs$core$IFn$_invoke$arity$1 ? fexpr__24334.cljs$core$IFn$_invoke$arity$1(self__.vs) : fexpr__24334.call(null,self__.vs));
});})(G__24330,___$1))
});
return React.DOM.button(G__24333);
})():null));
var G__24332 = om.util.force_children(smithy.impl.components.build_sidebar_item_components(self__.vs));
return React.DOM.div(G__24330,G__24331,G__24332);
});

smithy.impl.components.t_smithy$impl$components24326.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24327], null);
});

smithy.impl.components.t_smithy$impl$components24326.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24326.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24326";

smithy.impl.components.t_smithy$impl$components24326.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24326");
});

smithy.impl.components.__GT_t_smithy$impl$components24326 = (function smithy$impl$components$sidebar_component_$___GT_t_smithy$impl$components24326(vs__$1,owner__$1,meta24327){
return (new smithy.impl.components.t_smithy$impl$components24326(vs__$1,owner__$1,meta24327));
});

}

return (new smithy.impl.components.t_smithy$impl$components24326(vs,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Builder for a Update-Mode component
 */
smithy.impl.components.build_update_component = (function smithy$impl$components$build_update_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components24335 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24335 = (function (data,owner,meta24336){
this.data = data;
this.owner = owner;
this.meta24336 = meta24336;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24335.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24337,meta24336__$1){
var self__ = this;
var _24337__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24335(self__.data,self__.owner,meta24336__$1));
});

smithy.impl.components.t_smithy$impl$components24335.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24337){
var self__ = this;
var _24337__$1 = this;
return self__.meta24336;
});

smithy.impl.components.t_smithy$impl$components24335.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24335.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.cst$kw$vs.cljs$core$IFn$_invoke$arity$1(self__.data);
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$buffer))){
var screen = smithy.util.get_screen(vs);
var rupdate = ((function (screen,vs,___$1){
return (function (){
var G__24339 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$update,cljs.core.cst$kw$submit,cljs.core.cst$kw$success,cljs.core.cst$kw$event], null));
var G__24340 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$update,cljs.core.cst$kw$submit,cljs.core.cst$kw$error,cljs.core.cst$kw$event], null));
var G__24341 = vs;
var G__24342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource);
var G__24343 = cljs.core.cst$kw$details;
var fexpr__24338 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$update], null));
return (fexpr__24338.cljs$core$IFn$_invoke$arity$5 ? fexpr__24338.cljs$core$IFn$_invoke$arity$5(G__24339,G__24340,G__24341,G__24342,G__24343) : fexpr__24338.call(null,G__24339,G__24340,G__24341,G__24342,G__24343));
});})(screen,vs,___$1))
;
var rcancel = ((function (screen,rupdate,vs,___$1){
return (function (){
var G__24345 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$update,cljs.core.cst$kw$cancel,cljs.core.cst$kw$event], null));
var G__24346 = vs;
var G__24347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource);
var G__24348 = cljs.core.cst$kw$details;
var fexpr__24344 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$cancel_DASH_update], null));
return (fexpr__24344.cljs$core$IFn$_invoke$arity$4 ? fexpr__24344.cljs$core$IFn$_invoke$arity$4(G__24345,G__24346,G__24347,G__24348) : fexpr__24344.call(null,G__24345,G__24346,G__24347,G__24348));
});})(screen,rupdate,vs,___$1))
;
var rdelete = ((function (screen,rupdate,rcancel,vs,___$1){
return (function (){
var G__24350 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$success,cljs.core.cst$kw$event], null));
var G__24351 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$delete,cljs.core.cst$kw$submit,cljs.core.cst$kw$error,cljs.core.cst$kw$event], null));
var G__24352 = vs;
var G__24353 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource);
var G__24354 = cljs.core.cst$kw$details;
var fexpr__24349 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$delete], null));
return (fexpr__24349.cljs$core$IFn$_invoke$arity$5 ? fexpr__24349.cljs$core$IFn$_invoke$arity$5(G__24350,G__24351,G__24352,G__24353,G__24354) : fexpr__24349.call(null,G__24350,G__24351,G__24352,G__24353,G__24354));
});})(screen,rupdate,rcancel,vs,___$1))
;
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.resource_update_component,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$vs,vs,cljs.core.cst$kw$screen,screen,cljs.core.cst$kw$update,rupdate,cljs.core.cst$kw$cancel,rcancel,cljs.core.cst$kw$delete,rdelete], null));
} else {
var G__24355 = null;
var G__24356 = om.util.force_children("Loading...");
return React.DOM.span(G__24355,G__24356);
}
});

smithy.impl.components.t_smithy$impl$components24335.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24336], null);
});

smithy.impl.components.t_smithy$impl$components24335.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24335.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24335";

smithy.impl.components.t_smithy$impl$components24335.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24335");
});

smithy.impl.components.__GT_t_smithy$impl$components24335 = (function smithy$impl$components$build_update_component_$___GT_t_smithy$impl$components24335(data__$1,owner__$1,meta24336){
return (new smithy.impl.components.t_smithy$impl$components24335(data__$1,owner__$1,meta24336));
});

}

return (new smithy.impl.components.t_smithy$impl$components24335(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Builder for a Readonly-Mode component
 */
smithy.impl.components.build_readonly_component = (function smithy$impl$components$build_readonly_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components24357 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24357 = (function (data,owner,meta24358){
this.data = data;
this.owner = owner;
this.meta24358 = meta24358;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24357.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24359,meta24358__$1){
var self__ = this;
var _24359__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24357(self__.data,self__.owner,meta24358__$1));
});

smithy.impl.components.t_smithy$impl$components24357.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24359){
var self__ = this;
var _24359__$1 = this;
return self__.meta24358;
});

smithy.impl.components.t_smithy$impl$components24357.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24357.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$vs,cljs.core.cst$kw$buffer], null)))){
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.resource_view_component,self__.data);
} else {
var G__24360 = null;
var G__24361 = om.util.force_children("Loading...");
return React.DOM.span(G__24360,G__24361);
}
});

smithy.impl.components.t_smithy$impl$components24357.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24358], null);
});

smithy.impl.components.t_smithy$impl$components24357.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24357.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24357";

smithy.impl.components.t_smithy$impl$components24357.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24357");
});

smithy.impl.components.__GT_t_smithy$impl$components24357 = (function smithy$impl$components$build_readonly_component_$___GT_t_smithy$impl$components24357(data__$1,owner__$1,meta24358){
return (new smithy.impl.components.t_smithy$impl$components24357(data__$1,owner__$1,meta24358));
});

}

return (new smithy.impl.components.t_smithy$impl$components24357(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Builder for a Create-Mode component
 */
smithy.impl.components.build_create_component = (function smithy$impl$components$build_create_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components24362 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24362 = (function (data,owner,meta24363){
this.data = data;
this.owner = owner;
this.meta24363 = meta24363;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24362.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24364,meta24363__$1){
var self__ = this;
var _24364__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24362(self__.data,self__.owner,meta24363__$1));
});

smithy.impl.components.t_smithy$impl$components24362.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24364){
var self__ = this;
var _24364__$1 = this;
return self__.meta24363;
});

smithy.impl.components.t_smithy$impl$components24362.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24362.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.cst$kw$vs.cljs$core$IFn$_invoke$arity$1(self__.data);
var screen = cljs.core.cst$kw$screen.cljs$core$IFn$_invoke$arity$1(self__.data);
var create_fn = ((function (vs,screen,___$1){
return (function (){
var G__24366 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$create,cljs.core.cst$kw$submit,cljs.core.cst$kw$success,cljs.core.cst$kw$event], null));
var G__24367 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$states,cljs.core.cst$kw$create,cljs.core.cst$kw$submit,cljs.core.cst$kw$error,cljs.core.cst$kw$event], null));
var G__24368 = vs;
var G__24369 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vs,cljs.core.cst$kw$selected_DASH_resource);
var G__24370 = cljs.core.cst$kw$details;
var fexpr__24365 = (cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$nav_DASH_to], null)))?cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$create_DASH_nav], null)):cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$create], null)));
return (fexpr__24365.cljs$core$IFn$_invoke$arity$5 ? fexpr__24365.cljs$core$IFn$_invoke$arity$5(G__24366,G__24367,G__24368,G__24369,G__24370) : fexpr__24365.call(null,G__24366,G__24367,G__24368,G__24369,G__24370));
});})(vs,screen,___$1))
;
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(screen,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$resource,cljs.core.cst$kw$non_DASH_creatable], null)))){
return null;
} else {
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.resource_create_component,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$vs,vs,cljs.core.cst$kw$screen,screen,cljs.core.cst$kw$create,create_fn], null));
}
});

smithy.impl.components.t_smithy$impl$components24362.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24363], null);
});

smithy.impl.components.t_smithy$impl$components24362.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24362.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24362";

smithy.impl.components.t_smithy$impl$components24362.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24362");
});

smithy.impl.components.__GT_t_smithy$impl$components24362 = (function smithy$impl$components$build_create_component_$___GT_t_smithy$impl$components24362(data__$1,owner__$1,meta24363){
return (new smithy.impl.components.t_smithy$impl$components24362(data__$1,owner__$1,meta24363));
});

}

return (new smithy.impl.components.t_smithy$impl$components24362(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * A single segment in the breadcrumbs component.
 */
smithy.impl.components.breadcrumb_item_component = (function smithy$impl$components$breadcrumb_item_component(p__24371,owner){
var map__24372 = p__24371;
var map__24372__$1 = ((((!((map__24372 == null)))?((((map__24372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24372.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24372):map__24372);
var vs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24372__$1,cljs.core.cst$kw$vs);
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24372__$1,cljs.core.cst$kw$token);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24372__$1,cljs.core.cst$kw$label);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24372__$1,cljs.core.cst$kw$state);
if(typeof smithy.impl.components.t_smithy$impl$components24374 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24374 = (function (p__24371,owner,map__24372,vs,token,label,state,meta24375){
this.p__24371 = p__24371;
this.owner = owner;
this.map__24372 = map__24372;
this.vs = vs;
this.token = token;
this.label = label;
this.state = state;
this.meta24375 = meta24375;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24374.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__24372,map__24372__$1,vs,token,label,state){
return (function (_24376,meta24375__$1){
var self__ = this;
var _24376__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24374(self__.p__24371,self__.owner,self__.map__24372,self__.vs,self__.token,self__.label,self__.state,meta24375__$1));
});})(map__24372,map__24372__$1,vs,token,label,state))
;

smithy.impl.components.t_smithy$impl$components24374.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__24372,map__24372__$1,vs,token,label,state){
return (function (_24376){
var self__ = this;
var _24376__$1 = this;
return self__.meta24375;
});})(map__24372,map__24372__$1,vs,token,label,state))
;

smithy.impl.components.t_smithy$impl$components24374.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24374.prototype.om$core$IRender$render$arity$1 = ((function (map__24372,map__24372__$1,vs,token,label,state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__24377 = ({"className": "breadcrumb-item"});
var G__24378 = om.util.force_children((function (){var G__24379 = ({"onClick": ((function (G__24377,___$1,map__24372,map__24372__$1,vs,token,label,state){
return (function (){
var fexpr__24381 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$breadcrumb_DASH_item_DASH_click], null));
return (fexpr__24381.cljs$core$IFn$_invoke$arity$3 ? fexpr__24381.cljs$core$IFn$_invoke$arity$3(self__.token,self__.vs,self__.state) : fexpr__24381.call(null,self__.token,self__.vs,self__.state));
});})(G__24377,___$1,map__24372,map__24372__$1,vs,token,label,state))
});
var G__24380 = om.util.force_children(self__.label);
return React.DOM.a(G__24379,G__24380);
})());
return React.DOM.span(G__24377,G__24378);
});})(map__24372,map__24372__$1,vs,token,label,state))
;

smithy.impl.components.t_smithy$impl$components24374.getBasis = ((function (map__24372,map__24372__$1,vs,token,label,state){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__24371,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__24372,cljs.core.cst$sym$vs,cljs.core.cst$sym$token,cljs.core.cst$sym$label,cljs.core.cst$sym$state,cljs.core.cst$sym$meta24375], null);
});})(map__24372,map__24372__$1,vs,token,label,state))
;

smithy.impl.components.t_smithy$impl$components24374.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24374.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24374";

smithy.impl.components.t_smithy$impl$components24374.cljs$lang$ctorPrWriter = ((function (map__24372,map__24372__$1,vs,token,label,state){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24374");
});})(map__24372,map__24372__$1,vs,token,label,state))
;

smithy.impl.components.__GT_t_smithy$impl$components24374 = ((function (map__24372,map__24372__$1,vs,token,label,state){
return (function smithy$impl$components$breadcrumb_item_component_$___GT_t_smithy$impl$components24374(p__24371__$1,owner__$1,map__24372__$2,vs__$1,token__$1,label__$1,state__$1,meta24375){
return (new smithy.impl.components.t_smithy$impl$components24374(p__24371__$1,owner__$1,map__24372__$2,vs__$1,token__$1,label__$1,state__$1,meta24375));
});})(map__24372,map__24372__$1,vs,token,label,state))
;

}

return (new smithy.impl.components.t_smithy$impl$components24374(p__24371,owner,map__24372__$1,vs,token,label,state,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Navigation Breadcrumbs component.
 */
smithy.impl.components.breadcrumb_component = (function smithy$impl$components$breadcrumb_component(vs,owner){
if(typeof smithy.impl.components.t_smithy$impl$components24383 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24383 = (function (vs,owner,meta24384){
this.vs = vs;
this.owner = owner;
this.meta24384 = meta24384;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24383.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24385,meta24384__$1){
var self__ = this;
var _24385__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24383(self__.vs,self__.owner,meta24384__$1));
});

smithy.impl.components.t_smithy$impl$components24383.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24385){
var self__ = this;
var _24385__$1 = this;
return self__.meta24384;
});

smithy.impl.components.t_smithy$impl$components24383.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24383.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var hist_fn = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$events_DASH_ref,cljs.core.cst$kw$nav_DASH_history], null));
var history = (function (){var and__6612__auto__ = hist_fn;
if(cljs.core.truth_(and__6612__auto__)){
return (hist_fn.cljs$core$IFn$_invoke$arity$0 ? hist_fn.cljs$core$IFn$_invoke$arity$0() : hist_fn.call(null));
} else {
return and__6612__auto__;
}
})();
if(cljs.core.empty_QMARK_(history)){
return null;
} else {
var G__24386 = ({"className": "breadcrumbs"});
var G__24387 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(smithy.impl.components.breadcrumb_item_component,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__24386,hist_fn,history,___$1){
return (function (p1__24382_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__24382_SHARP_,cljs.core.cst$kw$vs,self__.vs);
});})(G__24386,hist_fn,history,___$1))
,history),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$token], null)));
return React.DOM.div(G__24386,G__24387);
}
});

smithy.impl.components.t_smithy$impl$components24383.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vs,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24384], null);
});

smithy.impl.components.t_smithy$impl$components24383.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24383.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24383";

smithy.impl.components.t_smithy$impl$components24383.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24383");
});

smithy.impl.components.__GT_t_smithy$impl$components24383 = (function smithy$impl$components$breadcrumb_component_$___GT_t_smithy$impl$components24383(vs__$1,owner__$1,meta24384){
return (new smithy.impl.components.t_smithy$impl$components24383(vs__$1,owner__$1,meta24384));
});

}

return (new smithy.impl.components.t_smithy$impl$components24383(vs,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Wrap a component for the current view mode.
 */
smithy.impl.components.content_component = (function smithy$impl$components$content_component(data,owner){
if(typeof smithy.impl.components.t_smithy$impl$components24388 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24388 = (function (data,owner,meta24389){
this.data = data;
this.owner = owner;
this.meta24389 = meta24389;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24388.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24390,meta24389__$1){
var self__ = this;
var _24390__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24388(self__.data,self__.owner,meta24389__$1));
});

smithy.impl.components.t_smithy$impl$components24388.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24390){
var self__ = this;
var _24390__$1 = this;
return self__.meta24389;
});

smithy.impl.components.t_smithy$impl$components24388.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24388.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.cst$kw$vs.cljs$core$IFn$_invoke$arity$1(self__.data);
var G__24391 = ({"className": "main-content"});
var G__24392 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.breadcrumb_component,vs));
var G__24393 = om.util.force_children((function (){var G__24394 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null));
var G__24394__$1 = (((G__24394 instanceof cljs.core.Keyword))?G__24394.fqn:null);
switch (G__24394__$1) {
case "update":
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.build_update_component,self__.data);

break;
case "readonly":
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.build_readonly_component,self__.data);

break;
case "create":
return om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.build_create_component,self__.data);

break;
default:
var G__24395 = null;
var G__24396 = om.util.force_children([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to find mode: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$mode], null)))].join(''));
return React.DOM.span(G__24395,G__24396);

}
})());
return React.DOM.div(G__24391,G__24392,G__24393);
});

smithy.impl.components.t_smithy$impl$components24388.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24389], null);
});

smithy.impl.components.t_smithy$impl$components24388.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24388.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24388";

smithy.impl.components.t_smithy$impl$components24388.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24388");
});

smithy.impl.components.__GT_t_smithy$impl$components24388 = (function smithy$impl$components$content_component_$___GT_t_smithy$impl$components24388(data__$1,owner__$1,meta24389){
return (new smithy.impl.components.t_smithy$impl$components24388(data__$1,owner__$1,meta24389));
});

}

return (new smithy.impl.components.t_smithy$impl$components24388(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Build a view component for `type', where type is a screen type.
 */
smithy.impl.components.build_view_component = (function smithy$impl$components$build_view_component(type){
return (function (app,owner){
if(typeof smithy.impl.components.t_smithy$impl$components24399 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
smithy.impl.components.t_smithy$impl$components24399 = (function (type,app,owner,meta24400){
this.type = type;
this.app = app;
this.owner = owner;
this.meta24400 = meta24400;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
smithy.impl.components.t_smithy$impl$components24399.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24401,meta24400__$1){
var self__ = this;
var _24401__$1 = this;
return (new smithy.impl.components.t_smithy$impl$components24399(self__.type,self__.app,self__.owner,meta24400__$1));
});

smithy.impl.components.t_smithy$impl$components24399.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24401){
var self__ = this;
var _24401__$1 = this;
return self__.meta24400;
});

smithy.impl.components.t_smithy$impl$components24399.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24399.prototype.om$core$IWillMount$will_mount$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$view,self__.type], null));
if(cljs.core.truth_(cljs.core.cst$kw$screens_DASH_ref_DASH_override.cljs$core$IFn$_invoke$arity$1(vs))){
} else {
om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$screens_DASH_ref,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.app,cljs.core.cst$kw$screens));
}

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$events_DASH_ref,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.app,cljs.core.cst$kw$events));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$actions_DASH_ref,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.app,cljs.core.cst$kw$actions));

om.core.update_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$generators_DASH_ref,cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.app,cljs.core.cst$kw$generators));

return om.core.transact_BANG_.cljs$core$IFn$_invoke$arity$3(vs,cljs.core.cst$kw$buffer,((function (vs,___$1){
return (function (p1__24398_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,p1__24398_SHARP_);
});})(vs,___$1))
);
});

smithy.impl.components.t_smithy$impl$components24399.prototype.om$core$IRender$ = cljs.core.PROTOCOL_SENTINEL;

smithy.impl.components.t_smithy$impl$components24399.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vs = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$view,self__.type], null));
var screen = smithy.util.get_screen(vs);
var temp__4655__auto___24405 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$screen,cljs.core.cst$kw$resource_DASH_id], null));
if(cljs.core.truth_(temp__4655__auto___24405)){
var rid_24406 = temp__4655__auto___24405;
var temp__4655__auto___24407__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(vs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$actions_DASH_ref,cljs.core.cst$kw$load_DASH_resource], null));
if(cljs.core.truth_(temp__4655__auto___24407__$1)){
var f_24408 = temp__4655__auto___24407__$1;
(f_24408.cljs$core$IFn$_invoke$arity$2 ? f_24408.cljs$core$IFn$_invoke$arity$2(vs,rid_24406) : f_24408.call(null,vs,rid_24406));
} else {
}
} else {
}

var G__24402 = ({"className": "main-content-container"});
var G__24403 = om.util.force_children((cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(screen,cljs.core.cst$kw$sidebar))?om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.sidebar_component,vs):null));
var G__24404 = om.util.force_children(om.core.build.cljs$core$IFn$_invoke$arity$2(smithy.impl.components.content_component,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vs,vs,cljs.core.cst$kw$screen,screen], null)));
return React.DOM.div(G__24402,G__24403,G__24404);
});

smithy.impl.components.t_smithy$impl$components24399.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$type,cljs.core.cst$sym$app,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24400], null);
});

smithy.impl.components.t_smithy$impl$components24399.cljs$lang$type = true;

smithy.impl.components.t_smithy$impl$components24399.cljs$lang$ctorStr = "smithy.impl.components/t_smithy$impl$components24399";

smithy.impl.components.t_smithy$impl$components24399.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"smithy.impl.components/t_smithy$impl$components24399");
});

smithy.impl.components.__GT_t_smithy$impl$components24399 = (function smithy$impl$components$build_view_component_$___GT_t_smithy$impl$components24399(type__$1,app__$1,owner__$1,meta24400){
return (new smithy.impl.components.t_smithy$impl$components24399(type__$1,app__$1,owner__$1,meta24400));
});

}

return (new smithy.impl.components.t_smithy$impl$components24399(type,app,owner,cljs.core.PersistentArrayMap.EMPTY));
});
});
smithy.impl.components.content_view_component = smithy.impl.components.build_view_component(cljs.core.cst$kw$content);
smithy.impl.components.settings_view_component = smithy.impl.components.build_view_component(cljs.core.cst$kw$settings);
