// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('taoensso.encore');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.reader');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('goog.string.StringBuffer');
goog.require('goog.events');
goog.require('goog.net.XhrIo');
goog.require('goog.net.XhrIoPool');
goog.require('goog.Uri.QueryData');
goog.require('goog.structs');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
/**
 * Used for lib-consumer version assertions
 */
taoensso.encore.encore_version = 1.38;
taoensso.encore.assert_min_encore_version = (function taoensso$encore$assert_min_encore_version(min_version){
if((taoensso.encore.encore_version < min_version)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((taoensso.encore.format.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.format.cljs$core$IFn$_invoke$arity$3("Insufficient com.taoensso/encore version: %s < %s. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).",taoensso.encore.encore_version,min_version) : taoensso.encore.format.call(null,"Insufficient com.taoensso/encore version: %s < %s. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).",taoensso.encore.encore_version,min_version)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$min_DASH_version,min_version,cljs.core.cst$kw$this_DASH_version,taoensso.encore.encore_version], null));
} else {
return null;
}
});
taoensso.encore.read_edn = (function taoensso$encore$read_edn(s){
return cljs.reader.read_string(s);
});
taoensso.encore.pr_edn = (function taoensso$encore$pr_edn(var_args){
var G__18780 = arguments.length;
switch (G__18780) {
case 1:
return taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$1 = (function (x){
return taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$2(null,x);
});

taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$2 = (function (opts,x){
var _STAR_print_level_STAR_18781 = cljs.core._STAR_print_level_STAR_;
var _STAR_print_length_STAR_18782 = cljs.core._STAR_print_length_STAR_;
cljs.core._STAR_print_level_STAR_ = null;

cljs.core._STAR_print_length_STAR_ = null;

try{return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}finally {cljs.core._STAR_print_length_STAR_ = _STAR_print_length_STAR_18782;

cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_18781;
}});

taoensso.encore.pr_edn.cljs$lang$maxFixedArity = 2;

/**
 * Handles optional docstrings & attr maps for a macro def's name.
 *   Stolen from `clojure.tools.macro`.
 */
taoensso.encore.name_with_attrs = (function taoensso$encore$name_with_attrs(name,macro_args){
var vec__18784 = ((typeof cljs.core.first(macro_args) === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(macro_args),cljs.core.next(macro_args)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,macro_args], null));
var docstring = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18784,(0),null);
var macro_args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18784,(1),null);
var vec__18787 = ((cljs.core.map_QMARK_(cljs.core.first(macro_args__$1)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(macro_args__$1),cljs.core.next(macro_args__$1)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY,macro_args__$1], null));
var attr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18787,(0),null);
var macro_args__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18787,(1),null);
var attr__$1 = (cljs.core.truth_(docstring)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(attr,cljs.core.cst$kw$doc,docstring):attr);
var attr__$2 = (cljs.core.truth_(cljs.core.meta(name))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.meta(name),attr__$1):attr__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(name,attr__$2),macro_args__$2], null);
});
taoensso.encore.kw_identical_QMARK_ = cljs.core.keyword_identical_QMARK_;
taoensso.encore.stringy_QMARK_ = (function taoensso$encore$stringy_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) || (typeof x === 'string');
});
taoensso.encore.atom_QMARK_ = (function taoensso$encore$atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
taoensso.encore.chan_QMARK_ = (function taoensso$encore$chan_QMARK_(x){
return (x instanceof cljs.core.async.impl.channels.ManyToManyChannel);
});
taoensso.encore.re_pattern_QMARK_ = (function taoensso$encore$re_pattern_QMARK_(x){
return (x instanceof RegExp);
});
taoensso.encore.error_QMARK_ = (function taoensso$encore$error_QMARK_(x){
return (x instanceof Error);
});
/**
 * Returns data map iff `x` is an error of any type on platform.
 */
taoensso.encore.error_data = (function taoensso$encore$error_data(x){
var temp__4657__auto__ = (function (){var or__6624__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
if((x instanceof Error)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return null;
}
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var data_map = temp__4657__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (){var err = x;
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$err_DASH_type,cljs.core.type(err),cljs.core.cst$kw$err_DASH_msg,err.message,cljs.core.cst$kw$err_DASH_cause,err.cause], null);
})(),data_map], 0));
} else {
return null;
}
});
taoensso.encore.nnil_QMARK_ = (function taoensso$encore$nnil_QMARK_(x){
return !((x == null));
});
taoensso.encore.nblank_QMARK_ = (function taoensso$encore$nblank_QMARK_(x){
return !(clojure.string.blank_QMARK_(x));
});
taoensso.encore.nneg_QMARK_ = (function taoensso$encore$nneg_QMARK_(x){
return !((x < (0)));
});
taoensso.encore.pos_int_QMARK_ = (function taoensso$encore$pos_int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) && ((x > (0)));
});
taoensso.encore.nneg_int_QMARK_ = (function taoensso$encore$nneg_int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) && (!((x < (0))));
});
taoensso.encore.nvec_QMARK_ = (function taoensso$encore$nvec_QMARK_(n,x){
return (cljs.core.vector_QMARK_(x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(x),n));
});
taoensso.encore.udt_QMARK_ = taoensso.encore.nneg_int_QMARK_;
taoensso.encore.vec2_QMARK_ = (function taoensso$encore$vec2_QMARK_(x){
return taoensso.encore.nvec_QMARK_((2),x);
});
taoensso.encore.vec3_QMARK_ = (function taoensso$encore$vec3_QMARK_(x){
return taoensso.encore.nvec_QMARK_((3),x);
});
taoensso.encore.distinct_elements_QMARK_ = (function taoensso$encore$distinct_elements_QMARK_(x){
return (cljs.core.set_QMARK_(x)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(x),cljs.core.count((taoensso.encore.set_STAR_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.set_STAR_.cljs$core$IFn$_invoke$arity$1(x) : taoensso.encore.set_STAR_.call(null,x)))));
});
taoensso.encore.nblank_str_QMARK_ = (function taoensso$encore$nblank_str_QMARK_(x){
return (typeof x === 'string') && (!(clojure.string.blank_QMARK_(x)));
});
taoensso.encore.nneg_num_QMARK_ = (function taoensso$encore$nneg_num_QMARK_(x){
return (typeof x === 'number') && (!((x < (0))));
});
taoensso.encore.pos_num_QMARK_ = (function taoensso$encore$pos_num_QMARK_(x){
return (typeof x === 'number') && ((x > (0)));
});
taoensso.encore.zero_num_QMARK_ = (function taoensso$encore$zero_num_QMARK_(x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),x);
});
taoensso.encore.as__QMARK_nblank = (function taoensso$encore$as__QMARK_nblank(x){
if(typeof x === 'string'){
if(clojure.string.blank_QMARK_(x)){
return null;
} else {
return x;
}
} else {
return null;
}
});
taoensso.encore.as__QMARK_kw = (function taoensso$encore$as__QMARK_kw(x){
if((x instanceof cljs.core.Keyword)){
return x;
} else {
if(typeof x === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(x);
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_name = (function taoensso$encore$as__QMARK_name(x){
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if(typeof x === 'string'){
return x;
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_bool = (function taoensso$encore$as__QMARK_bool(x){
if((x == null)){
return null;
} else {
if((x === true) || (x === false)){
return x;
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,(0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"false")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"FALSE")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"0"))){
return false;
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,(1))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"true")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"TRUE")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"1"))){
return true;
} else {
return null;
}
}
}
}
});
taoensso.encore.as__QMARK_int = (function taoensso$encore$as__QMARK_int(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return cljs.core.long$(x);
} else {
if(typeof x === 'string'){
var x__$1 = parseInt(x,(10));
if(cljs.core.truth_(isNaN(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.as__QMARK_float = (function taoensso$encore$as__QMARK_float(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return x;
} else {
if(typeof x === 'string'){
var x__$1 = parseFloat(x);
if(cljs.core.truth_(isNan(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.nnil_EQ_ = (function taoensso$encore$nnil_EQ_(var_args){
var G__18796 = arguments.length;
switch (G__18796) {
case 2:
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__7768__auto__ = [];
var len__7749__auto___18798 = arguments.length;
var i__7750__auto___18799 = (0);
while(true){
if((i__7750__auto___18799 < len__7749__auto___18798)){
args_arr__7768__auto__.push((arguments[i__7750__auto___18799]));

var G__18800 = (i__7750__auto___18799 + (1));
i__7750__auto___18799 = G__18800;
continue;
} else {
}
break;
}

var argseq__7769__auto__ = (new cljs.core.IndexedSeq(args_arr__7768__auto__.slice((2)),(0),null));
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7769__auto__);

}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var and__6612__auto__ = taoensso.encore.nnil_QMARK_(x);
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y);
} else {
return and__6612__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
var and__6612__auto__ = taoensso.encore.nnil_QMARK_(x);
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more);
} else {
return and__6612__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$lang$applyTo = (function (seq18793){
var G__18794 = cljs.core.first(seq18793);
var seq18793__$1 = cljs.core.next(seq18793);
var G__18795 = cljs.core.first(seq18793__$1);
var seq18793__$2 = cljs.core.next(seq18793__$1);
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__18794,G__18795,seq18793__$2);
});

taoensso.encore.nnil_EQ_.cljs$lang$maxFixedArity = (2);

taoensso.encore.vec_STAR_ = (function taoensso$encore$vec_STAR_(x){
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
return cljs.core.vec(x);
}
});
taoensso.encore.set_STAR_ = (function taoensso$encore$set_STAR_(x){
if(cljs.core.set_QMARK_(x)){
return x;
} else {
return cljs.core.set(x);
}
});
taoensso.encore.ks_EQ_ = (function taoensso$encore$ks_EQ_(ks,m){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_LT__EQ_ = (function taoensso$encore$ks_LT__EQ_(ks,m){
return clojure.set.subset_QMARK_(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_GT__EQ_ = (function taoensso$encore$ks_GT__EQ_(ks,m){
return clojure.set.superset_QMARK_(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_nnil_QMARK_ = (function taoensso$encore$ks_nnil_QMARK_(ks,m){
return cljs.core.every_QMARK_((function (p1__18801_SHARP_){
return taoensso.encore.nnil_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,p1__18801_SHARP_));
}),ks);
});
taoensso.encore.assertion_error = (function taoensso$encore$assertion_error(msg){
return (new Error(msg));
});
/**
 * Implementation detail.
 */
taoensso.encore.hthrow = (function taoensso$encore$hthrow(var_args){
var args__7756__auto__ = [];
var len__7749__auto___18812 = arguments.length;
var i__7750__auto___18813 = (0);
while(true){
if((i__7750__auto___18813 < len__7749__auto___18812)){
args__7756__auto__.push((arguments[i__7750__auto___18813]));

var G__18814 = (i__7750__auto___18813 + (1));
i__7750__auto___18813 = G__18814;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((5) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((5)),(0),null)):null);
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__7757__auto__);
});

taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic = (function (hard_QMARK_,ns_str,_QMARK_line,form,val,p__18808){
var vec__18809 = p__18808;
var _QMARK_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18809,(0),null);
var pattern = "Condition failed in `%s:%s` [pred-form, val]: [%s, %s]";
var line_str = (function (){var or__6624__auto__ = _QMARK_line;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return "?";
}
})();
var form_str = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__6624__auto__ = form;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return "<nil>";
}
})())].join('');
var val_str = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__6624__auto__ = val;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return "<nil>";
}
})())].join('');
var _QMARK_err_str = (function (){var temp__4657__auto__ = _QMARK_err;
if(cljs.core.truth_(temp__4657__auto__)){
var e = temp__4657__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err)].join('');
} else {
return null;
}
})();
var msg = (function (){var m = (taoensso.encore.format.cljs$core$IFn$_invoke$arity$5 ? taoensso.encore.format.cljs$core$IFn$_invoke$arity$5(pattern,ns_str,line_str,form_str,val_str) : taoensso.encore.format.call(null,pattern,ns_str,line_str,form_str,val_str));
if(cljs.core.not(_QMARK_err_str)){
return m;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(m),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\nPredicate error: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err_str)].join('');
}
})();
throw ((cljs.core.not(hard_QMARK_))?taoensso.encore.assertion_error(msg):cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$ns,ns_str,cljs.core.cst$kw$_QMARK_line,_QMARK_line,cljs.core.cst$kw$form,form,cljs.core.cst$kw$val,val,cljs.core.cst$kw$_QMARK_err,_QMARK_err], null)));
});

taoensso.encore.hthrow.cljs$lang$maxFixedArity = (5);

taoensso.encore.hthrow.cljs$lang$applyTo = (function (seq18802){
var G__18803 = cljs.core.first(seq18802);
var seq18802__$1 = cljs.core.next(seq18802);
var G__18804 = cljs.core.first(seq18802__$1);
var seq18802__$2 = cljs.core.next(seq18802__$1);
var G__18805 = cljs.core.first(seq18802__$2);
var seq18802__$3 = cljs.core.next(seq18802__$2);
var G__18806 = cljs.core.first(seq18802__$3);
var seq18802__$4 = cljs.core.next(seq18802__$3);
var G__18807 = cljs.core.first(seq18802__$4);
var seq18802__$5 = cljs.core.next(seq18802__$4);
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic(G__18803,G__18804,G__18805,G__18806,G__18807,seq18802__$5);
});

taoensso.encore.non_throwing = (function taoensso$encore$non_throwing(pred){
return (function (x){
var vec__18815 = (function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(x) : pred.call(null,x))], null);
}catch (e18818){if((e18818 instanceof Error)){
var e__10251__auto__ = e18818;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__10251__auto__], null);
} else {
throw e18818;

}
}})();
var _QMARK_r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18815,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18815,(1),null);
return _QMARK_r;
});
});
/**
 * Implementation detail.
 */
taoensso.encore.hpred = (function taoensso$encore$hpred(pred_form){
if(!(cljs.core.vector_QMARK_(pred_form))){
return pred_form;
} else {
var vec__18822 = pred_form;
var seq__18823 = cljs.core.seq(vec__18822);
var first__18824 = cljs.core.first(seq__18823);
var seq__18823__$1 = cljs.core.next(seq__18823);
var type = first__18824;
var first__18824__$1 = cljs.core.first(seq__18823__$1);
var seq__18823__$2 = cljs.core.next(seq__18823__$1);
var p1 = first__18824__$1;
var first__18824__$2 = cljs.core.first(seq__18823__$2);
var seq__18823__$3 = cljs.core.next(seq__18823__$2);
var p2 = first__18824__$2;
var more = seq__18823__$3;
var G__18825 = type;
var G__18825__$1 = (((G__18825 instanceof cljs.core.Keyword))?G__18825.fqn:null);
switch (G__18825__$1) {
case "=":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1,x);
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "not=":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(p1,x);
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "set=":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "set<=":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return clojure.set.subset_QMARK_(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "set>=":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return clojure.set.superset_QMARK_(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "ks=":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return taoensso.encore.ks_EQ_(p1,x);
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "ks<=":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return taoensso.encore.ks_LT__EQ_(p1,x);
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "ks>=":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return taoensso.encore.ks_GT__EQ_(p1,x);
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "ks-nnil?":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return taoensso.encore.ks_nnil_QMARK_(p1,x);
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "el":
case "in":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x);
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "not-el":
case "not-in":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x));
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "not":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
var and__6612__auto__ = ((cljs.core.not(p1))?true:cljs.core.not((function (){var fexpr__18827 = (taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1));
return (fexpr__18827.cljs$core$IFn$_invoke$arity$1 ? fexpr__18827.cljs$core$IFn$_invoke$arity$1(x) : fexpr__18827.call(null,x));
})()));
if(and__6612__auto__){
var and__6612__auto____$1 = ((cljs.core.not(p2))?true:cljs.core.not((function (){var fexpr__18829 = (taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2));
return (fexpr__18829.cljs$core$IFn$_invoke$arity$1 ? fexpr__18829.cljs$core$IFn$_invoke$arity$1(x) : fexpr__18829.call(null,x));
})()));
if(and__6612__auto____$1){
return cljs.core.every_QMARK_(((function (and__6612__auto____$1,and__6612__auto__,G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (p1__18819_SHARP_){
return cljs.core.not((function (){var fexpr__18830 = (taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__18819_SHARP_) : taoensso.encore.hpred.call(null,p1__18819_SHARP_));
return (fexpr__18830.cljs$core$IFn$_invoke$arity$1 ? fexpr__18830.cljs$core$IFn$_invoke$arity$1(x) : fexpr__18830.call(null,x));
})());
});})(and__6612__auto____$1,and__6612__auto__,G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))
,more);
} else {
return and__6612__auto____$1;
}
} else {
return and__6612__auto__;
}
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "or":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
var or__6624__auto__ = (cljs.core.truth_(p1)?(function (){var fexpr__18832 = taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1)));
return (fexpr__18832.cljs$core$IFn$_invoke$arity$1 ? fexpr__18832.cljs$core$IFn$_invoke$arity$1(x) : fexpr__18832.call(null,x));
})():null);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
var or__6624__auto____$1 = (cljs.core.truth_(p2)?(function (){var fexpr__18834 = taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2)));
return (fexpr__18834.cljs$core$IFn$_invoke$arity$1 ? fexpr__18834.cljs$core$IFn$_invoke$arity$1(x) : fexpr__18834.call(null,x));
})():null);
if(cljs.core.truth_(or__6624__auto____$1)){
return or__6624__auto____$1;
} else {
return cljs.core.some(((function (or__6624__auto____$1,or__6624__auto__,G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (p1__18820_SHARP_){
var fexpr__18835 = taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__18820_SHARP_) : taoensso.encore.hpred.call(null,p1__18820_SHARP_)));
return (fexpr__18835.cljs$core$IFn$_invoke$arity$1 ? fexpr__18835.cljs$core$IFn$_invoke$arity$1(x) : fexpr__18835.call(null,x));
});})(or__6624__auto____$1,or__6624__auto__,G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))
,more);
}
}
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
case "and":
return ((function (G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (x){
var and__6612__auto__ = ((cljs.core.not(p1))?true:(function (){var fexpr__18837 = (taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1));
return (fexpr__18837.cljs$core$IFn$_invoke$arity$1 ? fexpr__18837.cljs$core$IFn$_invoke$arity$1(x) : fexpr__18837.call(null,x));
})());
if(cljs.core.truth_(and__6612__auto__)){
var and__6612__auto____$1 = ((cljs.core.not(p2))?true:(function (){var fexpr__18839 = (taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2));
return (fexpr__18839.cljs$core$IFn$_invoke$arity$1 ? fexpr__18839.cljs$core$IFn$_invoke$arity$1(x) : fexpr__18839.call(null,x));
})());
if(cljs.core.truth_(and__6612__auto____$1)){
return cljs.core.every_QMARK_(((function (and__6612__auto____$1,and__6612__auto__,G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more){
return (function (p1__18821_SHARP_){
var fexpr__18840 = (taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__18821_SHARP_) : taoensso.encore.hpred.call(null,p1__18821_SHARP_));
return (fexpr__18840.cljs$core$IFn$_invoke$arity$1 ? fexpr__18840.cljs$core$IFn$_invoke$arity$1(x) : fexpr__18840.call(null,x));
});})(and__6612__auto____$1,and__6612__auto__,G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))
,more);
} else {
return and__6612__auto____$1;
}
} else {
return and__6612__auto__;
}
});
;})(G__18825,G__18825__$1,vec__18822,seq__18823,first__18824,seq__18823__$1,type,first__18824__$1,seq__18823__$2,p1,first__18824__$2,seq__18823__$3,p2,more))

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18825__$1)].join('')));

}
}
});
/**
 * Implementation detail.
 */
taoensso.encore.hcond = (function taoensso$encore$hcond(hard_QMARK_,ns_str,line,x_,x_form,pred,pred_form){
var vec__18842 = (function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(x_)], null);
}catch (e18848){if((e18848 instanceof Error)){
var e__10251__auto__ = e18848;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__10251__auto__], null);
} else {
throw e18848;

}
}})();
var _QMARK_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18842,(0),null);
var _QMARK_x_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18842,(1),null);
var have_x_QMARK_ = (_QMARK_x_err == null);
var vec__18845 = ((have_x_QMARK_)?(function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var fexpr__18850 = taoensso.encore.hpred(pred);
return (fexpr__18850.cljs$core$IFn$_invoke$arity$1 ? fexpr__18850.cljs$core$IFn$_invoke$arity$1(_QMARK_x) : fexpr__18850.call(null,_QMARK_x));
})()], null);
}catch (e18849){if((e18849 instanceof Error)){
var e__10251__auto__ = e18849;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__10251__auto__], null);
} else {
throw e18849;

}
}})():null);
var pass_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18845,(0),null);
var _QMARK_pred_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18845,(1),null);
if(cljs.core.truth_(pass_QMARK_)){
return _QMARK_x;
} else {
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic(hard_QMARK_,ns_str,line,(function (){var x__7467__auto__ = pred_form;
return cljs.core._conj((function (){var x__7467__auto____$1 = x_form;
return cljs.core._conj(cljs.core.List.EMPTY,x__7467__auto____$1);
})(),x__7467__auto__);
})(),((have_x_QMARK_)?_QMARK_x:_QMARK_x_err),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([_QMARK_pred_err], 0));
}
});
/**
 * Like `name` but fully qualified: includes namespace in string when present.
 */
taoensso.encore.fq_name = (function taoensso$encore$fq_name(x){
if(typeof x === 'string'){
return x;
} else {
var n = cljs.core.name(x);
var temp__4655__auto__ = cljs.core.namespace(x);
if(cljs.core.truth_(temp__4655__auto__)){
var ns = temp__4655__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('');
} else {
return n;
}
}
});
taoensso.encore.explode_keyword = (function taoensso$encore$explode_keyword(k){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(taoensso.encore.fq_name(k),/[\.\/]/);
});
taoensso.encore.merge_keywords = (function taoensso$encore$merge_keywords(var_args){
var args__7756__auto__ = [];
var len__7749__auto___18857 = arguments.length;
var i__7750__auto___18858 = (0);
while(true){
if((i__7750__auto___18858 < len__7749__auto___18857)){
args__7756__auto__.push((arguments[i__7750__auto___18858]));

var G__18859 = (i__7750__auto___18858 + (1));
i__7750__auto___18858 = G__18859;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic = (function (ks,p__18853){
var vec__18854 = p__18853;
var no_slash_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18854,(0),null);
var parts = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.PersistentVector.EMPTY,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.explode_keyword,cljs.core.filterv(cljs.core.identity,ks)));
if(cljs.core.empty_QMARK_(parts)){
return null;
} else {
if(cljs.core.truth_(no_slash_QMARK_)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",parts));
} else {
var ppop = cljs.core.pop(parts);
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(((cljs.core.empty_QMARK_(ppop))?null:clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ppop)),cljs.core.peek(parts));
}
}
});

taoensso.encore.merge_keywords.cljs$lang$maxFixedArity = (1);

taoensso.encore.merge_keywords.cljs$lang$applyTo = (function (seq18851){
var G__18852 = cljs.core.first(seq18851);
var seq18851__$1 = cljs.core.next(seq18851);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic(G__18852,seq18851__$1);
});

taoensso.encore.clamp = (function taoensso$encore$clamp(nmin,nmax,n){
if((n < nmin)){
return nmin;
} else {
if((n > nmax)){
return nmax;
} else {
return n;
}
}
});
taoensso.encore.pow = (function taoensso$encore$pow(n,exp){
return Math.pow(n,exp);
});
taoensso.encore.abs = (function taoensso$encore$abs(n){
if((n < (0))){
return (- n);
} else {
return n;
}
});
taoensso.encore.round = (function taoensso$encore$round(var_args){
var args__7756__auto__ = [];
var len__7749__auto___18867 = arguments.length;
var i__7750__auto___18868 = (0);
while(true){
if((i__7750__auto___18868 < len__7749__auto___18867)){
args__7756__auto__.push((arguments[i__7750__auto___18868]));

var G__18869 = (i__7750__auto___18868 + (1));
i__7750__auto___18868 = G__18869;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__18862){
var vec__18863 = p__18862;
var type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18863,(0),null);
var nplaces = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18863,(1),null);
var n__$1 = n;
var modifier = (cljs.core.truth_(nplaces)?Math.pow(10.0,nplaces):null);
var n_STAR_ = ((cljs.core.not(modifier))?n__$1:(n__$1 * modifier));
var rounded = (function (){var G__18866 = (function (){var or__6624__auto__ = type;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.cst$kw$round;
}
})();
var G__18866__$1 = (((G__18866 instanceof cljs.core.Keyword))?G__18866.fqn:null);
switch (G__18866__$1) {
case "round":
return Math.round(n_STAR_);

break;
case "floor":
return Math.floor(n_STAR_);

break;
case "ceil":
return Math.ceil(n_STAR_);

break;
case "trunc":
return cljs.core.long$(n_STAR_);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unknown round type",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,type], null));

}
})();
if(cljs.core.not(modifier)){
return cljs.core.long$(rounded);
} else {
return (rounded / modifier);
}
});

taoensso.encore.round.cljs$lang$maxFixedArity = (1);

taoensso.encore.round.cljs$lang$applyTo = (function (seq18860){
var G__18861 = cljs.core.first(seq18860);
var seq18860__$1 = cljs.core.next(seq18860);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic(G__18861,seq18860__$1);
});

taoensso.encore.round_STAR_ = taoensso.encore.round;
/**
 * Optimized common case.
 */
taoensso.encore.round1 = (function taoensso$encore$round1(n){
return ((function (){var G__18871 = (n * 10.0);
return Math.round(G__18871);
})() / 10.0);
});
/**
 * Optimized common case.
 */
taoensso.encore.round2 = (function taoensso$encore$round2(n){
return ((function (){var G__18872 = (n * 100.0);
return Math.round(G__18872);
})() / 100.0);
});
/**
 * Returns binary exponential backoff value.
 */
taoensso.encore.exp_backoff = (function taoensso$encore$exp_backoff(var_args){
var args__7756__auto__ = [];
var len__7749__auto___18883 = arguments.length;
var i__7750__auto___18884 = (0);
while(true){
if((i__7750__auto___18884 < len__7749__auto___18883)){
args__7756__auto__.push((arguments[i__7750__auto___18884]));

var G__18885 = (i__7750__auto___18884 + (1));
i__7750__auto___18884 = G__18885;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic = (function (nattempt,p__18875){
var vec__18876 = p__18875;
var map__18879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18876,(0),null);
var map__18879__$1 = ((((!((map__18879 == null)))?((((map__18879.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18879.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18879):map__18879);
var min_SINGLEQUOTE_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18879__$1,cljs.core.cst$kw$min);
var max_SINGLEQUOTE_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18879__$1,cljs.core.cst$kw$max);
var factor = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__18879__$1,cljs.core.cst$kw$factor,(1000));
var binary_exp = (function (){var G__18881 = (2);
var G__18882 = (nattempt - (1));
return Math.pow(G__18881,G__18882);
})();
var time = (((binary_exp + cljs.core.rand.cljs$core$IFn$_invoke$arity$1(binary_exp)) * 0.5) * factor);
return cljs.core.long$((function (){var time__$1 = (cljs.core.truth_(min_SINGLEQUOTE_)?(function (){var x__6960__auto__ = min_SINGLEQUOTE_;
var y__6961__auto__ = time;
return ((x__6960__auto__ > y__6961__auto__) ? x__6960__auto__ : y__6961__auto__);
})():time);
var time__$2 = (cljs.core.truth_(max_SINGLEQUOTE_)?(function (){var x__6967__auto__ = max_SINGLEQUOTE_;
var y__6968__auto__ = time__$1;
return ((x__6967__auto__ < y__6968__auto__) ? x__6967__auto__ : y__6968__auto__);
})():time__$1);
return time__$2;
})());
});

taoensso.encore.exp_backoff.cljs$lang$maxFixedArity = (1);

taoensso.encore.exp_backoff.cljs$lang$applyTo = (function (seq18873){
var G__18874 = cljs.core.first(seq18873);
var seq18873__$1 = cljs.core.next(seq18873);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic(G__18874,seq18873__$1);
});

taoensso.encore.now_dt = (function taoensso$encore$now_dt(){
return (new Date());
});
taoensso.encore.now_udt = (function taoensso$encore$now_udt(){
return (new Date()).getTime();
});
/**
 * Useful for testing.
 */
taoensso.encore.now_udt_mock_fn = (function taoensso$encore$now_udt_mock_fn(var_args){
var args__7756__auto__ = [];
var len__7749__auto___18891 = arguments.length;
var i__7750__auto___18892 = (0);
while(true){
if((i__7750__auto___18892 < len__7749__auto___18891)){
args__7756__auto__.push((arguments[i__7750__auto___18892]));

var G__18893 = (i__7750__auto___18892 + (1));
i__7750__auto___18892 = G__18893;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((0) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((0)),(0),null)):null);
return taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__7757__auto__);
});

taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p__18887){
var vec__18888 = p__18887;
var mock_udts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18888,(0),null);
var mock_udts__$1 = (function (){var or__6624__auto__ = mock_udts;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();
}
})();
var idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((-1));
return ((function (mock_udts__$1,idx,vec__18888,mock_udts){
return (function (){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(mock_udts__$1,cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(idx,cljs.core.inc));
});
;})(mock_udts__$1,idx,vec__18888,mock_udts))
});

taoensso.encore.now_udt_mock_fn.cljs$lang$maxFixedArity = (0);

taoensso.encore.now_udt_mock_fn.cljs$lang$applyTo = (function (seq18886){
return taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18886));
});

taoensso.encore.secs__GT_ms = (function taoensso$encore$secs__GT_ms(secs){
return cljs.core.long$((secs * 1000.0));
});
taoensso.encore.ms__GT_secs = (function taoensso$encore$ms__GT_secs(ms){
return cljs.core.quot(ms,(1000));
});
/**
 * Returns number of milliseconds in period defined by given args.
 */
taoensso.encore.ms = (function taoensso$encore$ms(var_args){
var args__7756__auto__ = [];
var len__7749__auto___18899 = arguments.length;
var i__7750__auto___18900 = (0);
while(true){
if((i__7750__auto___18900 < len__7749__auto___18899)){
args__7756__auto__.push((arguments[i__7750__auto___18900]));

var G__18901 = (i__7750__auto___18900 + (1));
i__7750__auto___18900 = G__18901;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((0) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((0)),(0),null)):null);
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(argseq__7757__auto__);
});

taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic = (function (p__18895){
var map__18896 = p__18895;
var map__18896__$1 = ((((!((map__18896 == null)))?((((map__18896.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18896.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18896):map__18896);
var opts = map__18896__$1;
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18896__$1,cljs.core.cst$kw$years);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18896__$1,cljs.core.cst$kw$months);
var weeks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18896__$1,cljs.core.cst$kw$weeks);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18896__$1,cljs.core.cst$kw$days);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18896__$1,cljs.core.cst$kw$hours);
var mins = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18896__$1,cljs.core.cst$kw$mins);
var secs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18896__$1,cljs.core.cst$kw$secs);
var msecs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18896__$1,cljs.core.cst$kw$msecs);
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18896__$1,cljs.core.cst$kw$ms);
if(cljs.core.truth_(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__18896,map__18896__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (have_in__18898){
return taoensso.encore.hcond(false,"taoensso.encore",675,(new cljs.core.Delay(((function (map__18896,map__18896__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (){
return have_in__18898;
});})(map__18896,map__18896__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,null)),cljs.core.cst$sym$have_DASH_in__18898,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$kw$msecs,null,cljs.core.cst$kw$secs,null,cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$mins,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$ms,null,cljs.core.cst$kw$weeks,null], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$kw$msecs,null,cljs.core.cst$kw$secs,null,cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$mins,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$ms,null,cljs.core.cst$kw$weeks,null], null), null));
});})(map__18896,map__18896__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,cljs.core.keys(opts)))){
} else {
throw (new Error("Assert failed: (have #{:msecs :secs :months :days :mins :hours :years :ms :weeks} :in (keys opts))"));
}

return taoensso.encore.round((((((((((cljs.core.truth_(years)?(((((years * (1000)) * (60)) * (60)) * (24)) * (365)):0.0) + (cljs.core.truth_(months)?(((((months * (1000)) * (60)) * (60)) * (24)) * 29.53):0.0)) + (cljs.core.truth_(weeks)?(((((weeks * (1000)) * (60)) * (60)) * (24)) * (7)):0.0)) + (cljs.core.truth_(days)?((((days * (1000)) * (60)) * (60)) * (24)):0.0)) + (cljs.core.truth_(hours)?(((hours * (1000)) * (60)) * (60)):0.0)) + (cljs.core.truth_(mins)?((mins * (1000)) * (60)):0.0)) + (cljs.core.truth_(secs)?(secs * (1000)):0.0)) + (cljs.core.truth_(msecs)?msecs:0.0)) + (cljs.core.truth_(ms)?ms:0.0)));
});

taoensso.encore.ms.cljs$lang$maxFixedArity = (0);

taoensso.encore.ms.cljs$lang$applyTo = (function (seq18894){
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18894));
});

taoensso.encore.secs = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(taoensso.encore.ms__GT_secs,taoensso.encore.ms);
taoensso.encore.singleton_QMARK_ = (function taoensso$encore$singleton_QMARK_(coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(coll),(1));
} else {
return cljs.core.not(cljs.core.next(coll));
}
});
taoensso.encore.__GT__QMARK_singleton = (function taoensso$encore$__GT__QMARK_singleton(coll){
if(cljs.core.truth_(taoensso.encore.singleton_QMARK_(coll))){
var vec__18906 = coll;
var c1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18906,(0),null);
return c1;
} else {
return null;
}
});
taoensso.encore.__GT_vec = (function taoensso$encore$__GT_vec(x){
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
if(cljs.core.sequential_QMARK_(x)){
return cljs.core.vec(x);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);

}
}
});
taoensso.encore.vsplit_first = (function taoensso$encore$vsplit_first(v){
var vec__18909 = v;
var v1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18909,(0),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v1,(((cljs.core.count(v) > (1)))?cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(v,(1)):null)], null);
});
taoensso.encore.nnil_set = (function taoensso$encore$nnil_set(x){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(taoensso.encore.set_STAR_(x),null);
});
taoensso.encore.conj_some = (function taoensso$encore$conj_some(var_args){
var G__18916 = arguments.length;
switch (G__18916) {
case 2:
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__7768__auto__ = [];
var len__7749__auto___18918 = arguments.length;
var i__7750__auto___18919 = (0);
while(true){
if((i__7750__auto___18919 < len__7749__auto___18918)){
args_arr__7768__auto__.push((arguments[i__7750__auto___18919]));

var G__18920 = (i__7750__auto___18919 + (1));
i__7750__auto___18919 = G__18920;
continue;
} else {
}
break;
}

var argseq__7769__auto__ = (new cljs.core.IndexedSeq(args_arr__7768__auto__.slice((2)),(0),null));
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7769__auto__);

}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2 = (function (coll,_QMARK_x){
if(cljs.core.truth_(taoensso.encore.nnil_QMARK_(_QMARK_x))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,_QMARK_x);
} else {
return coll;
}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic = (function (coll,_QMARK_x,_QMARK_xs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(taoensso.encore.conj_some,taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2(coll,_QMARK_x),_QMARK_xs);
});

taoensso.encore.conj_some.cljs$lang$applyTo = (function (seq18913){
var G__18914 = cljs.core.first(seq18913);
var seq18913__$1 = cljs.core.next(seq18913);
var G__18915 = cljs.core.first(seq18913__$1);
var seq18913__$2 = cljs.core.next(seq18913__$1);
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic(G__18914,G__18915,seq18913__$2);
});

taoensso.encore.conj_some.cljs$lang$maxFixedArity = (2);

/**
 * `run!` from Clojure 1.7+
 */
taoensso.encore.backport_run_BANG_ = (function taoensso$encore$backport_run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__18922_SHARP_,p2__18921_SHARP_){
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(p2__18921_SHARP_) : proc.call(null,p2__18921_SHARP_));
}),null,coll);
});
taoensso.encore.translate_signed_idx = (function taoensso$encore$translate_signed_idx(signed_idx,max_idx){
if((signed_idx >= (0))){
var x__6967__auto__ = signed_idx;
var y__6968__auto__ = max_idx;
return ((x__6967__auto__ < y__6968__auto__) ? x__6967__auto__ : y__6968__auto__);
} else {
var x__6960__auto__ = (0);
var y__6961__auto__ = (signed_idx + max_idx);
return ((x__6960__auto__ > y__6961__auto__) ? x__6960__auto__ : y__6961__auto__);
}
});
/**
 * Returns [<inclusive-start-idx*> <exclusive-end-idx*>] for counted 0-indexed
 *   input (str, vec, etc.) with support for:
 *  * Clamping of indexes beyond limits.
 *  * Max-length -> end-index.
 *  * -ive indexes (as +ive indexes but work from back of input):
 *    (+0) (+1) (+2) (+3) (+4)  ; inclusive +ive indexes
 *      h    e    l    l    o   ; 5 count
 *    (-5) (-4) (-3) (-2) (-1)  ; inclusive -ive indexes
 */
taoensso.encore.sub_indexes = (function taoensso$encore$sub_indexes(var_args){
var args__7756__auto__ = [];
var len__7749__auto___18929 = arguments.length;
var i__7750__auto___18930 = (0);
while(true){
if((i__7750__auto___18930 < len__7749__auto___18929)){
args__7756__auto__.push((arguments[i__7750__auto___18930]));

var G__18931 = (i__7750__auto___18930 + (1));
i__7750__auto___18930 = G__18931;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((2) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((2)),(0),null)):null);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7757__auto__);
});

taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic = (function (x,start_idx,p__18926){
var map__18927 = p__18926;
var map__18927__$1 = ((((!((map__18927 == null)))?((((map__18927.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18927.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18927):map__18927);
var max_len = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18927__$1,cljs.core.cst$kw$max_DASH_len);
var end_idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18927__$1,cljs.core.cst$kw$end_DASH_idx);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (map__18927,map__18927__$1,max_len,end_idx){
return (function (){
return max_len;
});})(map__18927,map__18927__$1,max_len,end_idx))
,null)),cljs.core.cst$sym$max_DASH_len,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$nneg_DASH_int_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? nneg-int?] max-len)"));
}

var start_idx__$1 = start_idx;
var xlen = cljs.core.count(x);
var start_idx_STAR_ = taoensso.encore.translate_signed_idx(start_idx__$1,xlen);
var end_idx_STAR_ = (cljs.core.truth_(max_len)?(function (){var n1__10404__auto__ = (start_idx_STAR_ + max_len);
var n2__10405__auto__ = xlen;
if((n1__10404__auto__ > n2__10405__auto__)){
return n2__10405__auto__;
} else {
return n1__10404__auto__;
}
})():(cljs.core.truth_(end_idx)?(taoensso.encore.translate_signed_idx(end_idx,xlen) + (1)):xlen
));
if((start_idx_STAR_ > end_idx_STAR_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_idx_STAR_,end_idx_STAR_], null);
}
});

taoensso.encore.sub_indexes.cljs$lang$maxFixedArity = (2);

taoensso.encore.sub_indexes.cljs$lang$applyTo = (function (seq18923){
var G__18924 = cljs.core.first(seq18923);
var seq18923__$1 = cljs.core.next(seq18923);
var G__18925 = cljs.core.first(seq18923__$1);
var seq18923__$2 = cljs.core.next(seq18923__$1);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(G__18924,G__18925,seq18923__$2);
});

/**
 * Like `subvec` but uses `sub-indexes`.
 */
taoensso.encore.subvec_STAR_ = (function taoensso$encore$subvec_STAR_(var_args){
var args__7756__auto__ = [];
var len__7749__auto___18942 = arguments.length;
var i__7750__auto___18943 = (0);
while(true){
if((i__7750__auto___18943 < len__7749__auto___18942)){
args__7756__auto__.push((arguments[i__7750__auto___18943]));

var G__18944 = (i__7750__auto___18943 + (1));
i__7750__auto___18943 = G__18944;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((2) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((2)),(0),null)):null);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7757__auto__);
});

taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (v,start_idx,p__18935){
var vec__18936 = p__18935;
var _QMARK_max_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18936,(0),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__18936,_QMARK_max_len){
return (function (){
return v;
});})(vec__18936,_QMARK_max_len))
,null)),cljs.core.cst$sym$v,cljs.core.vector_QMARK_,cljs.core.cst$sym$vector_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? vector? v)"));
}

var vec__18939 = taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(v,start_idx,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_len,_QMARK_max_len], 0));
var start_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18939,(0),null);
var end_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18939,(1),null);
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.subvec_STAR_.cljs$lang$maxFixedArity = (2);

taoensso.encore.subvec_STAR_.cljs$lang$applyTo = (function (seq18932){
var G__18933 = cljs.core.first(seq18932);
var seq18932__$1 = cljs.core.next(seq18932);
var G__18934 = cljs.core.first(seq18932__$1);
var seq18932__$2 = cljs.core.next(seq18932__$1);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__18933,G__18934,seq18932__$2);
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.encore.Swapped = (function (new_val,return_val,__meta,__extmap,__hash){
this.new_val = new_val;
this.return_val = return_val;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7250__auto__,k__7251__auto__){
var self__ = this;
var this__7250__auto____$1 = this;
return this__7250__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7251__auto__,null);
});

taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7252__auto__,k18946,else__7253__auto__){
var self__ = this;
var this__7252__auto____$1 = this;
var G__18950 = k18946;
var G__18950__$1 = (((G__18950 instanceof cljs.core.Keyword))?G__18950.fqn:null);
switch (G__18950__$1) {
case "new-val":
return self__.new_val;

break;
case "return-val":
return self__.return_val;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k18946,else__7253__auto__);

}
});

taoensso.encore.Swapped.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7264__auto__,writer__7265__auto__,opts__7266__auto__){
var self__ = this;
var this__7264__auto____$1 = this;
var pr_pair__7267__auto__ = ((function (this__7264__auto____$1){
return (function (keyval__7268__auto__){
return cljs.core.pr_sequential_writer(writer__7265__auto__,cljs.core.pr_writer,""," ","",opts__7266__auto__,keyval__7268__auto__);
});})(this__7264__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7265__auto__,pr_pair__7267__auto__,"#taoensso.encore.Swapped{",", ","}",opts__7266__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$new_DASH_val,self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$return_DASH_val,self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__18945){
var self__ = this;
var G__18945__$1 = this;
return (new cljs.core.RecordIter((0),G__18945__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_val,cljs.core.cst$kw$return_DASH_val], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.encore.Swapped.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7248__auto__){
var self__ = this;
var this__7248__auto____$1 = this;
return self__.__meta;
});

taoensso.encore.Swapped.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7245__auto__){
var self__ = this;
var this__7245__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7254__auto__){
var self__ = this;
var this__7254__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7246__auto__){
var self__ = this;
var this__7246__auto____$1 = this;
var h__7064__auto__ = self__.__hash;
if(!((h__7064__auto__ == null))){
return h__7064__auto__;
} else {
var h__7064__auto____$1 = (function (){var fexpr__18951 = ((function (h__7064__auto__,this__7246__auto____$1){
return (function (coll__7247__auto__){
return (67130970 ^ cljs.core.hash_unordered_coll(coll__7247__auto__));
});})(h__7064__auto__,this__7246__auto____$1))
;
return fexpr__18951(this__7246__auto____$1);
})();
self__.__hash = h__7064__auto____$1;

return h__7064__auto____$1;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this18947,other18948){
var self__ = this;
var this18947__$1 = this;
return (!((other18948 == null))) && ((this18947__$1.constructor === other18948.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18947__$1.new_val,other18948.new_val)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18947__$1.return_val,other18948.return_val)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this18947__$1.__extmap,other18948.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7259__auto__,k__7260__auto__){
var self__ = this;
var this__7259__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$return_DASH_val,null,cljs.core.cst$kw$new_DASH_val,null], null), null),k__7260__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7259__auto____$1),self__.__meta),k__7260__auto__);
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7260__auto__)),null));
}
});

taoensso.encore.Swapped.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7257__auto__,k__7258__auto__,G__18945){
var self__ = this;
var this__7257__auto____$1 = this;
var pred__18952 = cljs.core.keyword_identical_QMARK_;
var expr__18953 = k__7258__auto__;
if(cljs.core.truth_((function (){var G__18955 = cljs.core.cst$kw$new_DASH_val;
var G__18956 = expr__18953;
return (pred__18952.cljs$core$IFn$_invoke$arity$2 ? pred__18952.cljs$core$IFn$_invoke$arity$2(G__18955,G__18956) : pred__18952.call(null,G__18955,G__18956));
})())){
return (new taoensso.encore.Swapped(G__18945,self__.return_val,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__18957 = cljs.core.cst$kw$return_DASH_val;
var G__18958 = expr__18953;
return (pred__18952.cljs$core$IFn$_invoke$arity$2 ? pred__18952.cljs$core$IFn$_invoke$arity$2(G__18957,G__18958) : pred__18952.call(null,G__18957,G__18958));
})())){
return (new taoensso.encore.Swapped(self__.new_val,G__18945,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7258__auto__,G__18945),null));
}
}
});

taoensso.encore.Swapped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7262__auto__){
var self__ = this;
var this__7262__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$new_DASH_val,self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$return_DASH_val,self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7249__auto__,G__18945){
var self__ = this;
var this__7249__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,G__18945,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7255__auto__,entry__7256__auto__){
var self__ = this;
var this__7255__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7256__auto__)){
return this__7255__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7256__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7256__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7255__auto____$1,entry__7256__auto__);
}
});

taoensso.encore.Swapped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$new_DASH_val,cljs.core.cst$sym$return_DASH_val], null);
});

taoensso.encore.Swapped.cljs$lang$type = true;

taoensso.encore.Swapped.cljs$lang$ctorPrSeq = (function (this__7286__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"taoensso.encore/Swapped");
});

taoensso.encore.Swapped.cljs$lang$ctorPrWriter = (function (this__7286__auto__,writer__7287__auto__){
return cljs.core._write(writer__7287__auto__,"taoensso.encore/Swapped");
});

taoensso.encore.__GT_Swapped = (function taoensso$encore$__GT_Swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});

taoensso.encore.map__GT_Swapped = (function taoensso$encore$map__GT_Swapped(G__18949){
return (new taoensso.encore.Swapped(cljs.core.cst$kw$new_DASH_val.cljs$core$IFn$_invoke$arity$1(G__18949),cljs.core.cst$kw$return_DASH_val.cljs$core$IFn$_invoke$arity$1(G__18949),null,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__18949,cljs.core.cst$kw$new_DASH_val,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$return_DASH_val], 0))),null));
});

taoensso.encore.swapped = (function taoensso$encore$swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});
taoensso.encore.swapped_QMARK_ = (function taoensso$encore$swapped_QMARK_(x){
return (x instanceof taoensso.encore.Swapped);
});
taoensso.encore.swapped_STAR_ = (function taoensso$encore$swapped_STAR_(x){
if(cljs.core.truth_(taoensso.encore.swapped_QMARK_(x))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_val.cljs$core$IFn$_invoke$arity$1(x),cljs.core.cst$kw$return_DASH_val.cljs$core$IFn$_invoke$arity$1(x)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,x], null);
}
});
/**
 * [<new-val> <return-val>]
 */
taoensso.encore.swapped_STAR__in = (function taoensso$encore$swapped_STAR__in(m,ks,f){
if(cljs.core.truth_((function (){var G__18960 = f;
var G__18961 = cljs.core.cst$kw$swap_SLASH_dissoc;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__18960,G__18961) : taoensso.encore.kw_identical_QMARK_.call(null,G__18960,G__18961));
})())){
return taoensso.encore.swapped_STAR_((function (){var G__18962 = m;
var G__18963 = cljs.core.butlast(ks);
var G__18964 = cljs.core.last(ks);
return (taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3(G__18962,G__18963,G__18964) : taoensso.encore.dissoc_in.call(null,G__18962,G__18963,G__18964));
})());
} else {
var old_val_in = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(m,ks);
var vec__18965 = taoensso.encore.swapped_STAR_((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_val_in) : f.call(null,old_val_in)));
var new_val_in = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18965,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18965,(1),null);
var new_val = (cljs.core.truth_((function (){var G__18968 = new_val_in;
var G__18969 = cljs.core.cst$kw$swap_SLASH_dissoc;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__18968,G__18969) : taoensso.encore.kw_identical_QMARK_.call(null,G__18968,G__18969));
})())?(function (){var G__18970 = m;
var G__18971 = cljs.core.butlast(ks);
var G__18972 = cljs.core.last(ks);
return (taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3(G__18970,G__18971,G__18972) : taoensso.encore.dissoc_in.call(null,G__18970,G__18971,G__18972));
})():cljs.core.assoc_in(m,ks,new_val_in));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_val,return_val], null);
}
});
/**
 * Reduces input with
 *   [<type> <ks> <reset-val-or-swap-fn>] or
 *       [<ks> <reset-val-or-swap-fn>] ops.
 */
taoensso.encore.replace_in_STAR_ = (function taoensso$encore$replace_in_STAR_(_QMARK_vf_type,m,ops){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (accum,_QMARK_op){
if(cljs.core.not(_QMARK_op)){
return accum;
} else {
var vec__18973 = ((cljs.core.not(_QMARK_vf_type))?_QMARK_op:cljs.core.cons(_QMARK_vf_type,_QMARK_op));
var vf_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18973,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18973,(1),null);
var valf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18973,(2),null);
var G__18976 = vf_type;
var G__18976__$1 = (((G__18976 instanceof cljs.core.Keyword))?G__18976.fqn:null);
switch (G__18976__$1) {
case "reset":
if(cljs.core.empty_QMARK_(ks)){
return valf;
} else {
return cljs.core.assoc_in(accum,ks,valf);
}

break;
case "swap":
if(cljs.core.empty_QMARK_(ks)){
return (valf.cljs$core$IFn$_invoke$arity$1 ? valf.cljs$core$IFn$_invoke$arity$1(accum) : valf.call(null,accum));
} else {
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(taoensso.encore.swapped_STAR__in(accum,ks,valf),(0));
}

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18976__$1)].join('')));

}
}
}),m,ops);
});
/**
 * Experimental. For use with `swap!`, etc.
 */
taoensso.encore.replace_in = (function taoensso$encore$replace_in(var_args){
var args__7756__auto__ = [];
var len__7749__auto___18980 = arguments.length;
var i__7750__auto___18981 = (0);
while(true){
if((i__7750__auto___18981 < len__7749__auto___18980)){
args__7756__auto__.push((arguments[i__7750__auto___18981]));

var G__18982 = (i__7750__auto___18981 + (1));
i__7750__auto___18981 = G__18982;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ops){
return taoensso.encore.replace_in_STAR_(null,m,ops);
});

taoensso.encore.replace_in.cljs$lang$maxFixedArity = (1);

taoensso.encore.replace_in.cljs$lang$applyTo = (function (seq18978){
var G__18979 = cljs.core.first(seq18978);
var seq18978__$1 = cljs.core.next(seq18978);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic(G__18979,seq18978__$1);
});

/**
 * More powerful version of `swap!`:
 *  * Supports optional `update-in` semantics.
 *  * Swap fn can return `(swapped <new-val> <return-val>)` rather than just
 *    <new-val>. This is useful when writing atomic pull fns, etc.
 */
taoensso.encore.swap_in_BANG_ = (function taoensso$encore$swap_in_BANG_(var_args){
var G__18988 = arguments.length;
switch (G__18988) {
case 3:
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__7768__auto__ = [];
var len__7749__auto___18996 = arguments.length;
var i__7750__auto___18997 = (0);
while(true){
if((i__7750__auto___18997 < len__7749__auto___18996)){
args_arr__7768__auto__.push((arguments[i__7750__auto___18997]));

var G__18998 = (i__7750__auto___18997 + (1));
i__7750__auto___18997 = G__18998;
continue;
} else {
}
break;
}

var argseq__7769__auto__ = (new cljs.core.IndexedSeq(args_arr__7768__auto__.slice((3)),(0),null));
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7769__auto__);

}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,f){
if(cljs.core.empty_QMARK_(ks)){
while(true){
var old_val = cljs.core.deref(atom_);
var vec__18989 = taoensso.encore.swapped_STAR_((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_val) : f.call(null,old_val)));
var new_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18989,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18989,(1),null);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
} else {
while(true){
var old_val = cljs.core.deref(atom_);
var vec__18992 = taoensso.encore.swapped_STAR__in(old_val,ks,f);
var new_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18992,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18992,(1),null);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,f,more){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(more);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$more),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count more))"));
}

var pairs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,f], null)], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),more));
while(true){
var old_val = cljs.core.deref(atom_);
var new_val = taoensso.encore.replace_in_STAR_(cljs.core.cst$kw$swap,old_val,pairs);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old_val,cljs.core.cst$kw$new,new_val], null);
}
break;
}
});

taoensso.encore.swap_in_BANG_.cljs$lang$applyTo = (function (seq18984){
var G__18985 = cljs.core.first(seq18984);
var seq18984__$1 = cljs.core.next(seq18984);
var G__18986 = cljs.core.first(seq18984__$1);
var seq18984__$2 = cljs.core.next(seq18984__$1);
var G__18987 = cljs.core.first(seq18984__$2);
var seq18984__$3 = cljs.core.next(seq18984__$2);
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18985,G__18986,G__18987,seq18984__$3);
});

taoensso.encore.swap_in_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Is to `reset!` as `swap-in!` is to `swap!`.
 */
taoensso.encore.reset_in_BANG_ = (function taoensso$encore$reset_in_BANG_(var_args){
var G__19004 = arguments.length;
switch (G__19004) {
case 3:
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__7768__auto__ = [];
var len__7749__auto___19006 = arguments.length;
var i__7750__auto___19007 = (0);
while(true){
if((i__7750__auto___19007 < len__7749__auto___19006)){
args_arr__7768__auto__.push((arguments[i__7750__auto___19007]));

var G__19008 = (i__7750__auto___19007 + (1));
i__7750__auto___19007 = G__19008;
continue;
} else {
}
break;
}

var argseq__7769__auto__ = (new cljs.core.IndexedSeq(args_arr__7768__auto__.slice((3)),(0),null));
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7769__auto__);

}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,new_val){
if(cljs.core.empty_QMARK_(ks)){
return cljs.core.reset_BANG_(atom_,new_val);
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atom_,(function (old_val){
return cljs.core.assoc_in(old_val,ks,new_val);
}));
}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,new_val,more){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(more);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$more),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count more))"));
}

var pairs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,new_val], null)], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),more));
while(true){
var old_val = cljs.core.deref(atom_);
var new_val__$1 = taoensso.encore.replace_in_STAR_(cljs.core.cst$kw$reset,old_val,pairs);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val__$1))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old_val,cljs.core.cst$kw$new,new_val__$1], null);
}
break;
}
});

taoensso.encore.reset_in_BANG_.cljs$lang$applyTo = (function (seq19000){
var G__19001 = cljs.core.first(seq19000);
var seq19000__$1 = cljs.core.next(seq19000);
var G__19002 = cljs.core.first(seq19000__$1);
var seq19000__$2 = cljs.core.next(seq19000__$1);
var G__19003 = cljs.core.first(seq19000__$2);
var seq19000__$3 = cljs.core.next(seq19000__$2);
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19001,G__19002,G__19003,seq19000__$3);
});

taoensso.encore.reset_in_BANG_.cljs$lang$maxFixedArity = (3);

taoensso.encore.dissoc_in = (function taoensso$encore$dissoc_in(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19012 = arguments.length;
var i__7750__auto___19013 = (0);
while(true){
if((i__7750__auto___19013 < len__7749__auto___19012)){
args__7756__auto__.push((arguments[i__7750__auto___19013]));

var G__19014 = (i__7750__auto___19013 + (1));
i__7750__auto___19013 = G__19014;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((2) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((2)),(0),null)):null);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7757__auto__);
});

taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ks,dissoc_ks){
if(cljs.core.empty_QMARK_(ks)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,m,dissoc_ks);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(cljs.core.update_in,m,ks,cljs.core.dissoc,dissoc_ks);
}
});

taoensso.encore.dissoc_in.cljs$lang$maxFixedArity = (2);

taoensso.encore.dissoc_in.cljs$lang$applyTo = (function (seq19009){
var G__19010 = cljs.core.first(seq19009);
var seq19009__$1 = cljs.core.next(seq19009);
var G__19011 = cljs.core.first(seq19009__$1);
var seq19009__$2 = cljs.core.next(seq19009__$1);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic(G__19010,G__19011,seq19009__$2);
});

taoensso.encore.contains_in_QMARK_ = (function taoensso$encore$contains_in_QMARK_(coll,ks){
return cljs.core.contains_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.butlast(ks)),cljs.core.last(ks));
});
/**
 * Assocs each kv iff its value is not nil.
 */
taoensso.encore.assoc_some = (function taoensso$encore$assoc_some(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19027 = arguments.length;
var i__7750__auto___19028 = (0);
while(true){
if((i__7750__auto___19028 < len__7749__auto___19027)){
args__7756__auto__.push((arguments[i__7750__auto___19028]));

var G__19029 = (i__7750__auto___19028 + (1));
i__7750__auto___19028 = G__19029;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(kvs);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$kvs),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count kvs))"));
}

return cljs.core.into.cljs$core$IFn$_invoke$arity$2((function (){var or__6624__auto__ = m;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__7413__auto__ = (function taoensso$encore$iter__19017(s__19018){
return (new cljs.core.LazySeq(null,(function (){
var s__19018__$1 = s__19018;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19018__$1);
if(temp__4657__auto__){
var s__19018__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19018__$2)){
var c__7411__auto__ = cljs.core.chunk_first(s__19018__$2);
var size__7412__auto__ = cljs.core.count(c__7411__auto__);
var b__19020 = cljs.core.chunk_buffer(size__7412__auto__);
if((function (){var i__19019 = (0);
while(true){
if((i__19019 < size__7412__auto__)){
var vec__19021 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7411__auto__,i__19019);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19021,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19021,(1),null);
if(!((v == null))){
cljs.core.chunk_append(b__19020,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__19030 = (i__19019 + (1));
i__19019 = G__19030;
continue;
} else {
var G__19031 = (i__19019 + (1));
i__19019 = G__19031;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19020),taoensso$encore$iter__19017(cljs.core.chunk_rest(s__19018__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19020),null);
}
} else {
var vec__19024 = cljs.core.first(s__19018__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19024,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19024,(1),null);
if(!((v == null))){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__19017(cljs.core.rest(s__19018__$2)));
} else {
var G__19032 = cljs.core.rest(s__19018__$2);
s__19018__$1 = G__19032;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7413__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
})());
});

taoensso.encore.assoc_some.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_some.cljs$lang$applyTo = (function (seq19015){
var G__19016 = cljs.core.first(seq19015);
var seq19015__$1 = cljs.core.next(seq19015);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic(G__19016,seq19015__$1);
});

/**
 * Assocs each kv iff its val is truthy.
 */
taoensso.encore.assoc_when = (function taoensso$encore$assoc_when(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19045 = arguments.length;
var i__7750__auto___19046 = (0);
while(true){
if((i__7750__auto___19046 < len__7749__auto___19045)){
args__7756__auto__.push((arguments[i__7750__auto___19046]));

var G__19047 = (i__7750__auto___19046 + (1));
i__7750__auto___19046 = G__19047;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(kvs);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$kvs),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count kvs))"));
}

return cljs.core.into.cljs$core$IFn$_invoke$arity$2((function (){var or__6624__auto__ = m;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__7413__auto__ = (function taoensso$encore$iter__19035(s__19036){
return (new cljs.core.LazySeq(null,(function (){
var s__19036__$1 = s__19036;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19036__$1);
if(temp__4657__auto__){
var s__19036__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19036__$2)){
var c__7411__auto__ = cljs.core.chunk_first(s__19036__$2);
var size__7412__auto__ = cljs.core.count(c__7411__auto__);
var b__19038 = cljs.core.chunk_buffer(size__7412__auto__);
if((function (){var i__19037 = (0);
while(true){
if((i__19037 < size__7412__auto__)){
var vec__19039 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7411__auto__,i__19037);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19039,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19039,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append(b__19038,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__19048 = (i__19037 + (1));
i__19037 = G__19048;
continue;
} else {
var G__19049 = (i__19037 + (1));
i__19037 = G__19049;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19038),taoensso$encore$iter__19035(cljs.core.chunk_rest(s__19036__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19038),null);
}
} else {
var vec__19042 = cljs.core.first(s__19036__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19042,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19042,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__19035(cljs.core.rest(s__19036__$2)));
} else {
var G__19050 = cljs.core.rest(s__19036__$2);
s__19036__$1 = G__19050;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7413__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
})());
});

taoensso.encore.assoc_when.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_when.cljs$lang$applyTo = (function (seq19033){
var G__19034 = cljs.core.first(seq19033);
var seq19033__$1 = cljs.core.next(seq19033);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__19034,seq19033__$1);
});

taoensso.encore.queue_QMARK_ = (function taoensso$encore$queue_QMARK_(x){
return (x instanceof cljs.core.PersistentQueue);
});
/**
 * Returns a PersistentQueue.
 */
taoensso.encore.queue = (function taoensso$encore$queue(var_args){
var G__19052 = arguments.length;
switch (G__19052) {
case 0:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentQueue.EMPTY;
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0(),coll);
});

taoensso.encore.queue.cljs$lang$maxFixedArity = 1;

taoensso.encore.queue_STAR_ = (function taoensso$encore$queue_STAR_(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19055 = arguments.length;
var i__7750__auto___19056 = (0);
while(true){
if((i__7750__auto___19056 < len__7749__auto___19055)){
args__7756__auto__.push((arguments[i__7750__auto___19056]));

var G__19057 = (i__7750__auto___19056 + (1));
i__7750__auto___19056 = G__19057;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((0) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((0)),(0),null)):null);
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__7757__auto__);
});

taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (items){
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1(items);
});

taoensso.encore.queue_STAR_.cljs$lang$maxFixedArity = (0);

taoensso.encore.queue_STAR_.cljs$lang$applyTo = (function (seq19054){
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19054));
});

/**
 * (seq     {:a :A}) => ([:a :A])
 * (seq-kvs {:a :A}) => (:a :A)
 */
taoensso.encore.seq_kvs = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.concat);
/**
 * Like `apply` but assumes last arg is a map whose elements should be applied
 *   to `f` as an unpaired seq:
 *  (mapply (fn [x & {:keys [y z]}] (str x y z)) 1 {:y 2 :z 3})
 *    where fn will receive args as: `(1 :y 2 :z 3)`.
 */
taoensso.encore.mapply = (function taoensso$encore$mapply(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19061 = arguments.length;
var i__7750__auto___19062 = (0);
while(true){
if((i__7750__auto___19062 < len__7749__auto___19061)){
args__7756__auto__.push((arguments[i__7750__auto___19062]));

var G__19063 = (i__7750__auto___19062 + (1));
i__7750__auto___19062 = G__19063;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(args),(function (){var G__19060 = cljs.core.last(args);
return (taoensso.encore.seq_kvs.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.seq_kvs.cljs$core$IFn$_invoke$arity$1(G__19060) : taoensso.encore.seq_kvs.call(null,G__19060));
})()));
});

taoensso.encore.mapply.cljs$lang$maxFixedArity = (1);

taoensso.encore.mapply.cljs$lang$applyTo = (function (seq19058){
var G__19059 = cljs.core.first(seq19058);
var seq19058__$1 = cljs.core.next(seq19058);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic(G__19059,seq19058__$1);
});

/**
 * Workaround for Clojure versions [1.4, 1.5) that blow up on `reduce-kv`s
 *   against a nil coll, Ref. http://dev.clojure.org/jira/browse/CLJ-1098.
 */
taoensso.encore.clj1098 = (function taoensso$encore$clj1098(x){
var or__6624__auto__ = x;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
taoensso.encore.map_kvs = (function taoensso$encore$map_kvs(kf,vf,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var kf__$1 = ((cljs.core.not((function (){var G__19064 = kf;
var G__19065 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19064,G__19065) : taoensso.encore.kw_identical_QMARK_.call(null,G__19064,G__19065));
})()))?kf:(function (k,_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k);
}));
var vf__$1 = ((cljs.core.not((function (){var G__19066 = vf;
var G__19067 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19066,G__19067) : taoensso.encore.kw_identical_QMARK_.call(null,G__19066,G__19067));
})()))?vf:((function (kf__$1){
return (function (_,v){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(v);
});})(kf__$1))
);
return cljs.core.persistent_BANG_(cljs.core.reduce_kv(((function (kf__$1,vf__$1){
return (function (m__$1,k,v){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,(cljs.core.truth_(kf__$1)?(kf__$1.cljs$core$IFn$_invoke$arity$2 ? kf__$1.cljs$core$IFn$_invoke$arity$2(k,v) : kf__$1.call(null,k,v)):k),(cljs.core.truth_(vf__$1)?(vf__$1.cljs$core$IFn$_invoke$arity$2 ? vf__$1.cljs$core$IFn$_invoke$arity$2(k,v) : vf__$1.call(null,k,v)):v));
});})(kf__$1,vf__$1))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),m));
}
});
taoensso.encore.map_keys = (function taoensso$encore$map_keys(f,m){
return taoensso.encore.map_kvs((function (k,_){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(k) : f.call(null,k));
}),null,m);
});
taoensso.encore.map_vals = (function taoensso$encore$map_vals(f,m){
return taoensso.encore.map_kvs(null,(function (_,v){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(v) : f.call(null,v));
}),m);
});
taoensso.encore.filter_kvs = (function taoensso$encore$filter_kvs(predk,predv,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((function (){var and__6612__auto__ = (predk.cljs$core$IFn$_invoke$arity$1 ? predk.cljs$core$IFn$_invoke$arity$1(k) : predk.call(null,k));
if(cljs.core.truth_(and__6612__auto__)){
return (predv.cljs$core$IFn$_invoke$arity$1 ? predv.cljs$core$IFn$_invoke$arity$1(v) : predv.call(null,v));
} else {
return and__6612__auto__;
}
})())){
return m__$1;
} else {
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m__$1,k);
}
}),m,m);
}
});
taoensso.encore.filter_keys = (function taoensso$encore$filter_keys(pred,m){
return taoensso.encore.filter_kvs(pred,cljs.core.constantly(true),m);
});
taoensso.encore.filter_vals = (function taoensso$encore$filter_vals(pred,m){
return taoensso.encore.filter_kvs(cljs.core.constantly(true),pred,m);
});
/**
 * Smaller, common-case version of `filter-vals`. Esp useful with `nil?`/`blank?`
 *   pred when constructing maps: {:foo (when _ <...>) :bar (when _ <...>)} in a
 *   way that preservers :or semantics.
 */
taoensso.encore.remove_vals = (function taoensso$encore$remove_vals(pred,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(v) : pred.call(null,v)))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m__$1,k);
} else {
return m__$1;
}
}),m,m);
}
});
taoensso.encore.keywordize_map = (function taoensso$encore$keywordize_map(m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),v);
}),cljs.core.PersistentArrayMap.EMPTY,m);
}
});
/**
 * Cross between `hash-map` & `map-kvs`.
 */
taoensso.encore.as_map = (function taoensso$encore$as_map(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19086 = arguments.length;
var i__7750__auto___19087 = (0);
while(true){
if((i__7750__auto___19087 < len__7749__auto___19086)){
args__7756__auto__.push((arguments[i__7750__auto___19087]));

var G__19088 = (i__7750__auto___19087 + (1));
i__7750__auto___19087 = G__19088;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic = (function (kvs,p__19070){
var vec__19071 = p__19070;
var kf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19071,(0),null);
var vf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19071,(1),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__19071,kf,vf){
return (function (){
return kvs;
});})(vec__19071,kf,vf))
,null)),cljs.core.cst$sym$kvs,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.sequential_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$sequential_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? sequential?] kvs)"));
}

if((function (){
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__19071,kf,vf){
return (function (){
return kf;
});})(vec__19071,kf,vf))
,null)),cljs.core.cst$sym$kf,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.ifn_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$ifn_QMARK_], null)),taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__19071,kf,vf){
return (function (){
return vf;
});})(vec__19071,kf,vf))
,null)),cljs.core.cst$sym$vf,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.ifn_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$ifn_QMARK_], null))], null);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? ifn?] kf vf)"));
}

var _PERCENT_ = ((cljs.core.empty_QMARK_(kvs))?cljs.core.PersistentArrayMap.EMPTY:(function (){var kf__$1 = ((cljs.core.not((function (){var G__19074 = kf;
var G__19075 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19074,G__19075) : taoensso.encore.kw_identical_QMARK_.call(null,G__19074,G__19075));
})()))?kf:((function (vec__19071,kf,vf){
return (function (k,_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k);
});})(vec__19071,kf,vf))
);
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var G__19079 = kvs;
var vec__19080 = G__19079;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19080,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19080,(1),null);
var s = vec__19080;
var m__$1 = m;
var G__19079__$1 = G__19079;
while(true){
var m__$2 = m__$1;
var vec__19083 = G__19079__$1;
var k__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19083,(0),null);
var v__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19083,(1),null);
var s__$1 = vec__19083;
var k__$2 = ((cljs.core.not(kf__$1))?k__$1:(kf__$1.cljs$core$IFn$_invoke$arity$2 ? kf__$1.cljs$core$IFn$_invoke$arity$2(k__$1,v__$1) : kf__$1.call(null,k__$1,v__$1)));
var v__$2 = ((cljs.core.not(vf))?v__$1:(vf.cljs$core$IFn$_invoke$arity$2 ? vf.cljs$core$IFn$_invoke$arity$2(k__$2,v__$1) : vf.call(null,k__$2,v__$1)));
var new_m = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$2,k__$2,v__$2);
var temp__4655__auto__ = cljs.core.nnext(s__$1);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
var G__19089 = new_m;
var G__19090 = n;
m__$1 = G__19089;
G__19079__$1 = G__19090;
continue;
} else {
return cljs.core.persistent_BANG_(new_m);
}
break;
}
})());
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (_PERCENT_,vec__19071,kf,vf){
return (function (){
return _PERCENT_;
});})(_PERCENT_,vec__19071,kf,vf))
,null)),cljs.core.cst$sym$_PERCENT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$map_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? map?] %)"));
}

return _PERCENT_;
});

taoensso.encore.as_map.cljs$lang$maxFixedArity = (1);

taoensso.encore.as_map.cljs$lang$applyTo = (function (seq19068){
var G__19069 = cljs.core.first(seq19068);
var seq19068__$1 = cljs.core.next(seq19068);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic(G__19069,seq19068__$1);
});

/**
 * Faster `zipmap` using transients.
 */
taoensso.encore.fzipmap = (function taoensso$encore$fzipmap(ks,vs){
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks__$1 = cljs.core.seq(ks);
var vs__$1 = cljs.core.seq(vs);
while(true){
if(!((ks__$1) && (vs__$1))){
return cljs.core.persistent_BANG_(m);
} else {
var G__19091 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,cljs.core.first(ks__$1),cljs.core.first(vs__$1));
var G__19092 = cljs.core.next(ks__$1);
var G__19093 = cljs.core.next(vs__$1);
m = G__19091;
ks__$1 = G__19092;
vs__$1 = G__19093;
continue;
}
break;
}
});
/**
 * Like `into` but supports multiple "from"s.
 */
taoensso.encore.into_all = (function taoensso$encore$into_all(var_args){
var G__19098 = arguments.length;
switch (G__19098) {
case 2:
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__7768__auto__ = [];
var len__7749__auto___19100 = arguments.length;
var i__7750__auto___19101 = (0);
while(true){
if((i__7750__auto___19101 < len__7749__auto___19100)){
args_arr__7768__auto__.push((arguments[i__7750__auto___19101]));

var G__19102 = (i__7750__auto___19101 + (1));
i__7750__auto___19101 = G__19102;
continue;
} else {
}
break;
}

var argseq__7769__auto__ = (new cljs.core.IndexedSeq(args_arr__7768__auto__.slice((2)),(0),null));
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7769__auto__);

}
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(to,from);
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic = (function (to,from,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.into.cljs$core$IFn$_invoke$arity$2(to,from),more);
});

taoensso.encore.into_all.cljs$lang$applyTo = (function (seq19095){
var G__19096 = cljs.core.first(seq19095);
var seq19095__$1 = cljs.core.next(seq19095);
var G__19097 = cljs.core.first(seq19095__$1);
var seq19095__$2 = cljs.core.next(seq19095__$1);
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic(G__19096,G__19097,seq19095__$2);
});

taoensso.encore.into_all.cljs$lang$maxFixedArity = (2);

/**
 * Greedy version of `interleave`, Ref. http://goo.gl/KvzqWb.
 */
taoensso.encore.interleave_all = (function taoensso$encore$interleave_all(var_args){
var G__19107 = arguments.length;
switch (G__19107) {
case 0:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__7768__auto__ = [];
var len__7749__auto___19109 = arguments.length;
var i__7750__auto___19110 = (0);
while(true){
if((i__7750__auto___19110 < len__7749__auto___19109)){
args_arr__7768__auto__.push((arguments[i__7750__auto___19110]));

var G__19111 = (i__7750__auto___19110 + (1));
i__7750__auto___19110 = G__19111;
continue;
} else {
}
break;
}

var argseq__7769__auto__ = (new cljs.core.IndexedSeq(args_arr__7768__auto__.slice((2)),(0),null));
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7769__auto__);

}
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
if(s1){
return s1;
} else {
if(s2){
return s2;
} else {
return null;
}
}
}
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0))));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(taoensso.encore.interleave_all,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
}),null,null));
});

taoensso.encore.interleave_all.cljs$lang$applyTo = (function (seq19104){
var G__19105 = cljs.core.first(seq19104);
var seq19104__$1 = cljs.core.next(seq19104);
var G__19106 = cljs.core.first(seq19104__$1);
var seq19104__$2 = cljs.core.next(seq19104__$1);
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic(G__19105,G__19106,seq19104__$2);
});

taoensso.encore.interleave_all.cljs$lang$maxFixedArity = (2);

taoensso.encore.takev = (function taoensso$encore$takev(n,coll){
if(cljs.core.vector_QMARK_(coll)){
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(coll,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
} else {
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll));
}
});
/**
 * Prefer `set` when order doesn't matter (much faster).
 */
taoensso.encore.distinctv = (function taoensso$encore$distinctv(var_args){
var G__19113 = arguments.length;
switch (G__19113) {
case 1:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.persistent_BANG_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__19114,in$){
var vec__19115 = p__19114;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19115,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19115,(1),null);
if(!(cljs.core.contains_QMARK_(seen,in$))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,in$),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,in$)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$(cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll),(0)));
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.persistent_BANG_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__19118,in$){
var vec__19119 = p__19118;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19119,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19119,(1),null);
var in_STAR_ = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(in$) : keyfn.call(null,in$));
if(!(cljs.core.contains_QMARK_(seen,in_STAR_))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,in$),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,in_STAR_)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$(cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll),(0)));
});

taoensso.encore.distinctv.cljs$lang$maxFixedArity = 2;

/**
 * Like `sort-by` for distinct. Based on clojure.core/distinct.
 */
taoensso.encore.distinct_by = (function taoensso$encore$distinct_by(keyfn,coll){
var step = (function taoensso$encore$distinct_by_$_step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
var fexpr__19127 = (function (p__19128,seen__$1){
while(true){
var vec__19129 = p__19128;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19129,(0),null);
var xs__$1 = vec__19129;
var temp__4657__auto__ = cljs.core.seq(xs__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var v_STAR_ = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(v) : keyfn.call(null,v));
if(cljs.core.contains_QMARK_(seen__$1,v_STAR_)){
var G__19132 = cljs.core.rest(s);
var G__19133 = seen__$1;
p__19128 = G__19132;
seen__$1 = G__19133;
continue;
} else {
return cljs.core.cons(v,taoensso$encore$distinct_by_$_step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,v_STAR_)));
}
} else {
return null;
}
break;
}
});
return fexpr__19127(xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
taoensso.encore.removev = (function taoensso$encore$removev(pred,coll){
return cljs.core.filterv(cljs.core.complement(pred),coll);
});

/**
 * distinctv` transducer.
 */
taoensso.encore.xdistinct = (function taoensso$encore$xdistinct(var_args){
var G__19139 = arguments.length;
switch (G__19139) {
case 0:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (seen_){
return (function() {
var G__19141 = null;
var G__19141__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__19141__1 = (function (acc){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(acc) : rf.call(null,acc));
});
var G__19141__2 = (function (acc,input){
if(cljs.core.contains_QMARK_(cljs.core.deref(seen_),input)){
return acc;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(seen_,cljs.core.conj,input);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,input) : rf.call(null,acc,input));
}
});
G__19141 = function(acc,input){
switch(arguments.length){
case 0:
return G__19141__0.call(this);
case 1:
return G__19141__1.call(this,acc);
case 2:
return G__19141__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__19141.cljs$core$IFn$_invoke$arity$0 = G__19141__0;
G__19141.cljs$core$IFn$_invoke$arity$1 = G__19141__1;
G__19141.cljs$core$IFn$_invoke$arity$2 = G__19141__2;
return G__19141;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (function (rf){
var seen_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (seen_){
return (function() {
var G__19142 = null;
var G__19142__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__19142__1 = (function (acc){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(acc) : rf.call(null,acc));
});
var G__19142__2 = (function (acc,input){
var k = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(input) : keyfn.call(null,input));
if(cljs.core.contains_QMARK_(cljs.core.deref(seen_),k)){
return acc;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(seen_,cljs.core.conj,k);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,input) : rf.call(null,acc,input));
}
});
G__19142 = function(acc,input){
switch(arguments.length){
case 0:
return G__19142__0.call(this);
case 1:
return G__19142__1.call(this,acc);
case 2:
return G__19142__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__19142.cljs$core$IFn$_invoke$arity$0 = G__19142__0;
G__19142.cljs$core$IFn$_invoke$arity$1 = G__19142__1;
G__19142.cljs$core$IFn$_invoke$arity$2 = G__19142__2;
return G__19142;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1(keyfn),coll);
});

taoensso.encore.xdistinct.cljs$lang$maxFixedArity = 2;

/**
 * Reverse comparator.
 */
taoensso.encore.rcompare = (function taoensso$encore$rcompare(x,y){
return cljs.core.compare(y,x);
});
taoensso.encore.nested_merge_with = (function taoensso$encore$nested_merge_with(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19145 = arguments.length;
var i__7750__auto___19146 = (0);
while(true){
if((i__7750__auto___19146 < len__7749__auto___19145)){
args__7756__auto__.push((arguments[i__7750__auto___19146]));

var G__19147 = (i__7750__auto___19146 + (1));
i__7750__auto___19146 = G__19147;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key(e);
var rv = cljs.core.val(e);
if(!(cljs.core.contains_QMARK_(m,k))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,rv);
} else {
var lv = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if((cljs.core.map_QMARK_(lv)) && (cljs.core.map_QMARK_(rv))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lv,rv], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(lv,rv) : f.call(null,lv,rv)));
}
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__6624__auto__ = m1;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

taoensso.encore.nested_merge_with.cljs$lang$maxFixedArity = (1);

taoensso.encore.nested_merge_with.cljs$lang$applyTo = (function (seq19143){
var G__19144 = cljs.core.first(seq19143);
var seq19143__$1 = cljs.core.next(seq19143);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(G__19144,seq19143__$1);
});

taoensso.encore.nested_merge = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nested_merge_with,(function (x,y){
if((cljs.core.map_QMARK_(x)) && ((y == null))){
return x;
} else {
return y;
}
}));
/**
 * Returns the 'greatest' element in coll in O(n) time.
 */
taoensso.encore.greatest = (function taoensso$encore$greatest(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19156 = arguments.length;
var i__7750__auto___19157 = (0);
while(true){
if((i__7750__auto___19157 < len__7749__auto___19156)){
args__7756__auto__.push((arguments[i__7750__auto___19157]));

var G__19158 = (i__7750__auto___19157 + (1));
i__7750__auto___19157 = G__19158;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__19152){
var vec__19153 = p__19152;
var _QMARK_comparator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19153,(0),null);
var comparator = (function (){var or__6624__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (comparator,vec__19153,_QMARK_comparator){
return (function (p1__19148_SHARP_,p2__19149_SHARP_){
if(((comparator.cljs$core$IFn$_invoke$arity$2 ? comparator.cljs$core$IFn$_invoke$arity$2(p1__19148_SHARP_,p2__19149_SHARP_) : comparator.call(null,p1__19148_SHARP_,p2__19149_SHARP_)) > (0))){
return p2__19149_SHARP_;
} else {
return p1__19148_SHARP_;
}
});})(comparator,vec__19153,_QMARK_comparator))
,coll);
});

taoensso.encore.greatest.cljs$lang$maxFixedArity = (1);

taoensso.encore.greatest.cljs$lang$applyTo = (function (seq19150){
var G__19151 = cljs.core.first(seq19150);
var seq19150__$1 = cljs.core.next(seq19150);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic(G__19151,seq19150__$1);
});

/**
 * Returns the 'least' element in coll in O(n) time.
 */
taoensso.encore.least = (function taoensso$encore$least(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19167 = arguments.length;
var i__7750__auto___19168 = (0);
while(true){
if((i__7750__auto___19168 < len__7749__auto___19167)){
args__7756__auto__.push((arguments[i__7750__auto___19168]));

var G__19169 = (i__7750__auto___19168 + (1));
i__7750__auto___19168 = G__19169;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__19163){
var vec__19164 = p__19163;
var _QMARK_comparator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19164,(0),null);
var comparator = (function (){var or__6624__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (comparator,vec__19164,_QMARK_comparator){
return (function (p1__19159_SHARP_,p2__19160_SHARP_){
if(((comparator.cljs$core$IFn$_invoke$arity$2 ? comparator.cljs$core$IFn$_invoke$arity$2(p1__19159_SHARP_,p2__19160_SHARP_) : comparator.call(null,p1__19159_SHARP_,p2__19160_SHARP_)) < (0))){
return p2__19160_SHARP_;
} else {
return p1__19159_SHARP_;
}
});})(comparator,vec__19164,_QMARK_comparator))
,coll);
});

taoensso.encore.least.cljs$lang$maxFixedArity = (1);

taoensso.encore.least.cljs$lang$applyTo = (function (seq19161){
var G__19162 = cljs.core.first(seq19161);
var seq19161__$1 = cljs.core.next(seq19161);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic(G__19162,seq19161__$1);
});

/**
 * Like `repeatedly` but faster and `conj`s items into given collection.
 */
taoensso.encore.repeatedly_into = (function taoensso$encore$repeatedly_into(coll,n,f){
if((coll instanceof clojure.lang.IEditableCollection)){
var v = cljs.core.transient$(coll);
var idx = (0);
while(true){
if((idx >= n)){
return cljs.core.persistent_BANG_(v);
} else {
var G__19170 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
var G__19171 = (idx + (1));
v = G__19170;
idx = G__19171;
continue;
}
break;
}
} else {
var v = coll;
var idx = (0);
while(true){
if((idx >= n)){
return v;
} else {
var G__19172 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
var G__19173 = (idx + (1));
v = G__19172;
idx = G__19173;
continue;
}
break;
}
}
});
taoensso.encore.undefined__GT_nil = (function taoensso$encore$undefined__GT_nil(x){
if((void 0 === x)){
return null;
} else {
return x;
}
});
taoensso.encore.nil__GT_str = (function taoensso$encore$nil__GT_str(x){
if(((void 0 === x)) || ((x == null))){
return "nil";
} else {
return x;
}
});
taoensso.encore.spaced_str_with_nils = (function taoensso$encore$spaced_str_with_nils(xs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,xs));
});
taoensso.encore.spaced_str = (function taoensso$encore$spaced_str(xs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.undefined__GT_nil,xs));
});
taoensso.encore.format_STAR_ = (function taoensso$encore$format_STAR_(fmt,args){
var fmt__$1 = (function (){var or__6624__auto__ = fmt;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return "";
}
})();
var args__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt__$1,args__$1);
});
/**
 * Like `clojure.core/format` but:
 *  * Returns "" when fmt is nil rather than throwing an NPE.
 *  * Formats nil as "nil" rather than "null".
 *  * Provides ClojureScript support via goog.string.format (this has fewer
 *    formatting options than Clojure's `format`!).
 */
taoensso.encore.format = (function taoensso$encore$format(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19176 = arguments.length;
var i__7750__auto___19177 = (0);
while(true){
if((i__7750__auto___19177 < len__7749__auto___19176)){
args__7756__auto__.push((arguments[i__7750__auto___19177]));

var G__19178 = (i__7750__auto___19177 + (1));
i__7750__auto___19177 = G__19178;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return taoensso.encore.format_STAR_(fmt,args);
});

taoensso.encore.format.cljs$lang$maxFixedArity = (1);

taoensso.encore.format.cljs$lang$applyTo = (function (seq19174){
var G__19175 = cljs.core.first(seq19174);
var seq19174__$1 = cljs.core.next(seq19174);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic(G__19175,seq19174__$1);
});

/**
 * Workaround for http://dev.clojure.org/jira/browse/CLJS-794,
 *                http://dev.clojure.org/jira/browse/CLJS-911.
 */
taoensso.encore.str_replace = (function taoensso$encore$str_replace(s,match,replacement){
var replacement__$1 = ((!(cljs.core.fn_QMARK_(replacement)))?replacement:(function() { 
var G__19180__delegate = function (args){
var G__19179 = cljs.core.vec(args);
return (replacement.cljs$core$IFn$_invoke$arity$1 ? replacement.cljs$core$IFn$_invoke$arity$1(G__19179) : replacement.call(null,G__19179));
};
var G__19180 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19181__i = 0, G__19181__a = new Array(arguments.length -  0);
while (G__19181__i < G__19181__a.length) {G__19181__a[G__19181__i] = arguments[G__19181__i + 0]; ++G__19181__i;}
  args = new cljs.core.IndexedSeq(G__19181__a,0,null);
} 
return G__19180__delegate.call(this,args);};
G__19180.cljs$lang$maxFixedArity = 0;
G__19180.cljs$lang$applyTo = (function (arglist__19182){
var args = cljs.core.seq(arglist__19182);
return G__19180__delegate(args);
});
G__19180.cljs$core$IFn$_invoke$arity$variadic = G__19180__delegate;
return G__19180;
})()
);
if(typeof match === 'string'){
return s.replace((new RegExp(goog.string.regExpEscape(match),"g")),replacement__$1);
} else {
if((match instanceof RegExp)){
var flags = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("g"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(match.ignoreCase)?"i":null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(match.multiline)?"m":null))].join('');
return s.replace((new RegExp(match.source,flags)),replacement__$1);
} else {
throw [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid match arg: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(match)].join('');

}
}
});
/**
 * Gives a consistent, flexible, cross-platform substring API built on
 *   `sub-indexes`.
 */
taoensso.encore.substr = (function taoensso$encore$substr(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19193 = arguments.length;
var i__7750__auto___19194 = (0);
while(true){
if((i__7750__auto___19194 < len__7749__auto___19193)){
args__7756__auto__.push((arguments[i__7750__auto___19194]));

var G__19195 = (i__7750__auto___19194 + (1));
i__7750__auto___19194 = G__19195;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((2) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((2)),(0),null)):null);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7757__auto__);
});

taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic = (function (s,start_idx,p__19186){
var vec__19187 = p__19186;
var _QMARK_max_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19187,(0),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__19187,_QMARK_max_len){
return (function (){
return s;
});})(vec__19187,_QMARK_max_len))
,null)),cljs.core.cst$sym$s,cljs.core.string_QMARK_,cljs.core.cst$sym$string_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? string? s)"));
}

var vec__19190 = taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(s,start_idx,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_len,_QMARK_max_len], 0));
var start_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19190,(0),null);
var end_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19190,(1),null);
return s.substring(start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.substr.cljs$lang$maxFixedArity = (2);

taoensso.encore.substr.cljs$lang$applyTo = (function (seq19183){
var G__19184 = cljs.core.first(seq19183);
var seq19183__$1 = cljs.core.next(seq19183);
var G__19185 = cljs.core.first(seq19183__$1);
var seq19183__$2 = cljs.core.next(seq19183__$1);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(G__19184,G__19185,seq19183__$2);
});

taoensso.encore.str_contains_QMARK_ = (function taoensso$encore$str_contains_QMARK_(s,substr){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((-1),s.indexOf(substr));
});
taoensso.encore.str_starts_with_QMARK_ = (function taoensso$encore$str_starts_with_QMARK_(s,substr){
return (s.indexOf(substr) === (0));
});
taoensso.encore.str_ends_with_QMARK_ = (function taoensso$encore$str_ends_with_QMARK_(s,substr){
var s_len = s.length;
var substr_len = substr.length;
if((s_len >= substr_len)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((-1),s.indexOf(substr,(s_len - substr_len)));
} else {
return null;
}
});
taoensso.encore.str__QMARK_index = (function taoensso$encore$str__QMARK_index(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19203 = arguments.length;
var i__7750__auto___19204 = (0);
while(true){
if((i__7750__auto___19204 < len__7749__auto___19203)){
args__7756__auto__.push((arguments[i__7750__auto___19204]));

var G__19205 = (i__7750__auto___19204 + (1));
i__7750__auto___19204 = G__19205;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((2) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((2)),(0),null)):null);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7757__auto__);
});

taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic = (function (s,substr,p__19199){
var vec__19200 = p__19199;
var start_idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19200,(0),null);
var last_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19200,(1),null);
var start_idx__$1 = ((function (){var or__6624__auto__ = start_idx;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return (0);
}
})() | (0));
var result = ((cljs.core.truth_(last_QMARK_)?s.lastIndexOf(substr,start_idx__$1):s.indexOf(substr,start_idx__$1)) | (0));
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(result,(-1))){
return result;
} else {
return null;
}
});

taoensso.encore.str__QMARK_index.cljs$lang$maxFixedArity = (2);

taoensso.encore.str__QMARK_index.cljs$lang$applyTo = (function (seq19196){
var G__19197 = cljs.core.first(seq19196);
var seq19196__$1 = cljs.core.next(seq19196);
var G__19198 = cljs.core.first(seq19196__$1);
var seq19196__$2 = cljs.core.next(seq19196__$1);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic(G__19197,G__19198,seq19196__$2);
});

/**
 * Like `clojure.string/join` but ensures no double separators.
 */
taoensso.encore.join_once = (function taoensso$encore$join_once(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19208 = arguments.length;
var i__7750__auto___19209 = (0);
while(true){
if((i__7750__auto___19209 < len__7749__auto___19208)){
args__7756__auto__.push((arguments[i__7750__auto___19209]));

var G__19210 = (i__7750__auto___19209 + (1));
i__7750__auto___19209 = G__19210;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic = (function (separator,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s1,s2){
var s1__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1)].join('');
var s2__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2)].join('');
if(cljs.core.truth_(taoensso.encore.str_ends_with_QMARK_(s1__$1,separator))){
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s2__$1,separator))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1.substring((1)))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
}
} else {
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s2__$1,separator))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s1__$1,"")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s2__$1,""))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(separator),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
}
}
}
}),null,coll);
});

taoensso.encore.join_once.cljs$lang$maxFixedArity = (1);

taoensso.encore.join_once.cljs$lang$applyTo = (function (seq19206){
var G__19207 = cljs.core.first(seq19206);
var seq19206__$1 = cljs.core.next(seq19206);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic(G__19207,seq19206__$1);
});

/**
 * Joins string paths (URLs, file paths, etc.) ensuring correct "/"
 *   interposition.
 */
taoensso.encore.path = (function taoensso$encore$path(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19212 = arguments.length;
var i__7750__auto___19213 = (0);
while(true){
if((i__7750__auto___19213 < len__7749__auto___19212)){
args__7756__auto__.push((arguments[i__7750__auto___19213]));

var G__19214 = (i__7750__auto___19213 + (1));
i__7750__auto___19213 = G__19214;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((0) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((0)),(0),null)):null);
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(argseq__7757__auto__);
});

taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic = (function (parts){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.join_once,"/",parts);
});

taoensso.encore.path.cljs$lang$maxFixedArity = (0);

taoensso.encore.path.cljs$lang$applyTo = (function (seq19211){
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19211));
});

/**
 * Converts all word breaks of any form and length (including line breaks of any
 *   form, tabs, spaces, etc.) to a single regular space.
 */
taoensso.encore.norm_word_breaks = (function taoensso$encore$norm_word_breaks(s){
return clojure.string.replace([cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/\s+/," ");
});
taoensso.encore.count_words = (function taoensso$encore$count_words(s){
if(clojure.string.blank_QMARK_(s)){
return (0);
} else {
return cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/\s+/));
}
});
/**
 * Returns a UUIDv4 string of form "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx",
 *   Ref. http://www.ietf.org/rfc/rfc4122.txt,
 *     https://gist.github.com/franks42/4159427
 */
taoensso.encore.uuid_str = (function taoensso$encore$uuid_str(var_args){
var G__19216 = arguments.length;
switch (G__19216) {
case 1:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1 = (function (max_length){
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0(),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([max_length], 0));
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0 = (function (){
var hex = (function (){
return cljs.core.rand_int((15)).toString((16));
});
var rhex = ((8) | ((3) & cljs.core.rand_int((14)))).toString((16));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("4"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rhex),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex())].join('');
});

taoensso.encore.uuid_str.cljs$lang$maxFixedArity = 1;

taoensso.encore.gc_rate = (1.0 / (16000));
taoensso.encore.gc_now_QMARK_ = (function taoensso$encore$gc_now_QMARK_(){
return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0() <= taoensso.encore.gc_rate);
});
/**
 * Swaps associative value at key and returns the new value.
 *   Specialized, fast `swap-in!` for use mostly by memoization utils.
 */
taoensso.encore.swap_val_BANG_ = (function taoensso$encore$swap_val_BANG_(atom_,k,f){
while(true){
var old_m = cljs.core.deref(atom_);
var new_v = (function (){var G__19218 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(old_m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__19218) : f.call(null,G__19218));
})();
var new_m = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(old_m,k,new_v);
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_(atom_,old_m,new_m))){
return new_v;
} else {
continue;
}
break;
}
});
/**
 * As `clojure.core/memoize` but uses delays to avoid write races.
 */
taoensso.encore.memoize_ = (function taoensso$encore$memoize_(f){
var cache_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (cache_){
return (function() { 
var G__19219__delegate = function (args){
return cljs.core.deref((function (){var or__6624__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_),args);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return taoensso.encore.swap_val_BANG_(cache_,args,((function (or__6624__auto__,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_(_QMARK_dv)){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__6624__auto__,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
});})(or__6624__auto__,cache_))
,null));
}
});})(or__6624__auto__,cache_))
);
}
})());
};
var G__19219 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19220__i = 0, G__19220__a = new Array(arguments.length -  0);
while (G__19220__i < G__19220__a.length) {G__19220__a[G__19220__i] = arguments[G__19220__i + 0]; ++G__19220__i;}
  args = new cljs.core.IndexedSeq(G__19220__a,0,null);
} 
return G__19219__delegate.call(this,args);};
G__19219.cljs$lang$maxFixedArity = 0;
G__19219.cljs$lang$applyTo = (function (arglist__19221){
var args = cljs.core.seq(arglist__19221);
return G__19219__delegate(args);
});
G__19219.cljs$core$IFn$_invoke$arity$variadic = G__19219__delegate;
return G__19219;
})()
;
;})(cache_))
});
/**
 * Great for Reactjs render op caching on mobile devices, etc.
 */
taoensso.encore.memoize1 = (function taoensso$encore$memoize1(f){
var cache_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (cache_){
return (function() { 
var G__19222__delegate = function (args){
return cljs.core.deref((function (){var or__6624__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_),args);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cache_,((function (or__6624__auto__,cache_){
return (function (cache){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cache,args))){
return cache;
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([args,(new cljs.core.Delay(((function (or__6624__auto__,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
});})(or__6624__auto__,cache_))
,null))]);
}
});})(or__6624__auto__,cache_))
),args);
}
})());
};
var G__19222 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19223__i = 0, G__19223__a = new Array(arguments.length -  0);
while (G__19223__i < G__19223__a.length) {G__19223__a[G__19223__i] = arguments[G__19223__i + 0]; ++G__19223__i;}
  args = new cljs.core.IndexedSeq(G__19223__a,0,null);
} 
return G__19222__delegate.call(this,args);};
G__19222.cljs$lang$maxFixedArity = 0;
G__19222.cljs$lang$applyTo = (function (arglist__19224){
var args = cljs.core.seq(arglist__19224);
return G__19222__delegate(args);
});
G__19222.cljs$core$IFn$_invoke$arity$variadic = G__19222__delegate;
return G__19222;
})()
;
;})(cache_))
});
/**
 * Like `(memoize* f)` but takes an explicit cache atom (possibly nil)
 *   and immediately applies memoized f to given arguments.
 */
taoensso.encore.memoized = (function taoensso$encore$memoized(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19229 = arguments.length;
var i__7750__auto___19230 = (0);
while(true){
if((i__7750__auto___19230 < len__7749__auto___19229)){
args__7756__auto__.push((arguments[i__7750__auto___19230]));

var G__19231 = (i__7750__auto___19230 + (1));
i__7750__auto___19230 = G__19231;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((2) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((2)),(0),null)):null);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7757__auto__);
});

taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic = (function (cache,f,args){
if(cljs.core.not(cache)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
} else {
return cljs.core.deref(taoensso.encore.swap_val_BANG_(cache,args,(function (p1__19225_SHARP_){
if(cljs.core.truth_(p1__19225_SHARP_)){
return p1__19225_SHARP_;
} else {
return (new cljs.core.Delay((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}),null));
}
})));
}
});

taoensso.encore.memoized.cljs$lang$maxFixedArity = (2);

taoensso.encore.memoized.cljs$lang$applyTo = (function (seq19226){
var G__19227 = cljs.core.first(seq19226);
var seq19226__$1 = cljs.core.next(seq19226);
var G__19228 = cljs.core.first(seq19226__$1);
var seq19226__$2 = cljs.core.next(seq19226__$1);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic(G__19227,G__19228,seq19226__$2);
});

/**
 * Like `clojure.core/memoize` but:
 *  * Uses delays to prevent race conditions on writes.
 *  * Supports auto invalidation & gc with `ttl-ms` option.
 *  * Supports manual invalidation by prepending args with `:mem/del` or `:mem/fresh`.
 *  * Supports cache size limit & gc with `cache-size` option.
 */
taoensso.encore.memoize_STAR_ = (function taoensso$encore$memoize_STAR_(var_args){
var G__19235 = arguments.length;
switch (G__19235) {
case 1:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
var cache_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (cache_){
return (function() { 
var G__19305__delegate = function (p__19236){
var vec__19237 = p__19236;
var seq__19238 = cljs.core.seq(vec__19237);
var first__19239 = cljs.core.first(seq__19238);
var seq__19238__$1 = cljs.core.next(seq__19238);
var arg1 = first__19239;
var argn = seq__19238__$1;
var args = vec__19237;
if(cljs.core.truth_((function (){var G__19240 = arg1;
var G__19241 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19240,G__19241) : taoensso.encore.kw_identical_QMARK_.call(null,G__19240,G__19241));
})())){
if(cljs.core.truth_((function (){var G__19242 = cljs.core.first(argn);
var G__19243 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19242,G__19243) : taoensso.encore.kw_identical_QMARK_.call(null,G__19242,G__19243));
})())){
cljs.core.reset_BANG_(cache_,cljs.core.PersistentArrayMap.EMPTY);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_,cljs.core.dissoc,argn);
}

return null;
} else {
var fresh_QMARK_ = (function (){var G__19244 = arg1;
var G__19245 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19244,G__19245) : taoensso.encore.kw_identical_QMARK_.call(null,G__19244,G__19245));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
return cljs.core.deref((function (){var or__6624__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_),args__$1);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return taoensso.encore.swap_val_BANG_(cache_,args__$1,((function (or__6624__auto__,fresh_QMARK_,args__$1,vec__19237,seq__19238,first__19239,seq__19238__$1,arg1,argn,args,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_((function (){var and__6612__auto__ = _QMARK_dv;
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.not(fresh_QMARK_);
} else {
return and__6612__auto__;
}
})())){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__6624__auto__,fresh_QMARK_,args__$1,vec__19237,seq__19238,first__19239,seq__19238__$1,arg1,argn,args,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(or__6624__auto__,fresh_QMARK_,args__$1,vec__19237,seq__19238,first__19239,seq__19238__$1,arg1,argn,args,cache_))
,null));
}
});})(or__6624__auto__,fresh_QMARK_,args__$1,vec__19237,seq__19238,first__19239,seq__19238__$1,arg1,argn,args,cache_))
);
}
})());
}
};
var G__19305 = function (var_args){
var p__19236 = null;
if (arguments.length > 0) {
var G__19306__i = 0, G__19306__a = new Array(arguments.length -  0);
while (G__19306__i < G__19306__a.length) {G__19306__a[G__19306__i] = arguments[G__19306__i + 0]; ++G__19306__i;}
  p__19236 = new cljs.core.IndexedSeq(G__19306__a,0,null);
} 
return G__19305__delegate.call(this,p__19236);};
G__19305.cljs$lang$maxFixedArity = 0;
G__19305.cljs$lang$applyTo = (function (arglist__19307){
var p__19236 = cljs.core.seq(arglist__19307);
return G__19305__delegate(p__19236);
});
G__19305.cljs$core$IFn$_invoke$arity$variadic = G__19305__delegate;
return G__19305;
})()
;
;})(cache_))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (ttl_ms,f){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return ttl_ms;
}),null)),cljs.core.cst$sym$ttl_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_], null));


var cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return ((function (cache){
return (function() { 
var G__19308__delegate = function (p__19246){
var vec__19247 = p__19246;
var seq__19248 = cljs.core.seq(vec__19247);
var first__19249 = cljs.core.first(seq__19248);
var seq__19248__$1 = cljs.core.next(seq__19248);
var arg1 = first__19249;
var argn = seq__19248__$1;
var args = vec__19247;
if(cljs.core.truth_((function (){var G__19250 = arg1;
var G__19251 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19250,G__19251) : taoensso.encore.kw_identical_QMARK_.call(null,G__19250,G__19251));
})())){
if(cljs.core.truth_((function (){var G__19252 = cljs.core.first(argn);
var G__19253 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19252,G__19253) : taoensso.encore.kw_identical_QMARK_.call(null,G__19252,G__19253));
})())){
cljs.core.reset_BANG_(cache,cljs.core.PersistentArrayMap.EMPTY);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache,cljs.core.dissoc,argn);
}

return null;
} else {
if(cljs.core.truth_(taoensso.encore.gc_now_QMARK_())){
var instant_19309 = taoensso.encore.now_udt();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cache,((function (instant_19309,vec__19247,seq__19248,first__19249,seq__19248__$1,arg1,argn,args,cache){
return (function (m){
return cljs.core.reduce_kv(((function (instant_19309,vec__19247,seq__19248,first__19249,seq__19248__$1,arg1,argn,args,cache){
return (function (m_STAR_,k,p__19254){
var vec__19255 = p__19254;
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19255,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19255,(1),null);
var cv = vec__19255;
if(((instant_19309 - udt) > ttl_ms)){
return m_STAR_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR_,k,cv);
}
});})(instant_19309,vec__19247,seq__19248,first__19249,seq__19248__$1,arg1,argn,args,cache))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.encore.clj1098(m));
});})(instant_19309,vec__19247,seq__19248,first__19249,seq__19248__$1,arg1,argn,args,cache))
);
} else {
}

var fresh_QMARK_ = (function (){var G__19261 = arg1;
var G__19262 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19261,G__19262) : taoensso.encore.kw_identical_QMARK_.call(null,G__19261,G__19262));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var instant = taoensso.encore.now_udt();
var vec__19258 = taoensso.encore.swap_val_BANG_(cache,args__$1,((function (fresh_QMARK_,args__$1,instant,vec__19247,seq__19248,first__19249,seq__19248__$1,arg1,argn,args,cache){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__6612__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__6612__auto__)){
var and__6612__auto____$1 = cljs.core.not(fresh_QMARK_);
if(and__6612__auto____$1){
var vec__19266 = _QMARK_cv;
var _dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19266,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19266,(1),null);
return ((instant - udt) < ttl_ms);
} else {
return and__6612__auto____$1;
}
} else {
return and__6612__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,instant,vec__19247,seq__19248,first__19249,seq__19248__$1,arg1,argn,args,cache){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(fresh_QMARK_,args__$1,instant,vec__19247,seq__19248,first__19249,seq__19248__$1,arg1,argn,args,cache))
,null)),instant], null);
}
});})(fresh_QMARK_,args__$1,instant,vec__19247,seq__19248,first__19249,seq__19248__$1,arg1,argn,args,cache))
);
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19258,(0),null);
return cljs.core.deref(dv);
}
};
var G__19308 = function (var_args){
var p__19246 = null;
if (arguments.length > 0) {
var G__19310__i = 0, G__19310__a = new Array(arguments.length -  0);
while (G__19310__i < G__19310__a.length) {G__19310__a[G__19310__i] = arguments[G__19310__i + 0]; ++G__19310__i;}
  p__19246 = new cljs.core.IndexedSeq(G__19310__a,0,null);
} 
return G__19308__delegate.call(this,p__19246);};
G__19308.cljs$lang$maxFixedArity = 0;
G__19308.cljs$lang$applyTo = (function (arglist__19311){
var p__19246 = cljs.core.seq(arglist__19311);
return G__19308__delegate(p__19246);
});
G__19308.cljs$core$IFn$_invoke$arity$variadic = G__19308__delegate;
return G__19308;
})()
;
;})(cache))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (cache_size,ttl_ms,f){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return ttl_ms;
}),null)),cljs.core.cst$sym$ttl_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_], null));


taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cache_size;
}),null)),cljs.core.cst$sym$cache_DASH_size,taoensso.encore.pos_int_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_);


var state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tick,(0)], null));
return ((function (state){
return (function() { 
var G__19312__delegate = function (p__19269){
var vec__19270 = p__19269;
var seq__19271 = cljs.core.seq(vec__19270);
var first__19272 = cljs.core.first(seq__19271);
var seq__19271__$1 = cljs.core.next(seq__19271);
var arg1 = first__19272;
var argn = seq__19271__$1;
var args = vec__19270;
if(cljs.core.truth_((function (){var G__19273 = arg1;
var G__19274 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19273,G__19274) : taoensso.encore.kw_identical_QMARK_.call(null,G__19273,G__19274));
})())){
if(cljs.core.truth_((function (){var G__19275 = cljs.core.first(argn);
var G__19276 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19275,G__19276) : taoensso.encore.kw_identical_QMARK_.call(null,G__19275,G__19276));
})())){
cljs.core.reset_BANG_(state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tick,(0)], null));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state,cljs.core.dissoc,argn);
}

return null;
} else {
if(cljs.core.truth_(taoensso.encore.gc_now_QMARK_())){
var instant_19313 = taoensso.encore.now_udt();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (instant_19313,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state){
return (function (m){
var m_STAR_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,cljs.core.cst$kw$tick);
var m_STAR___$1 = ((cljs.core.not(ttl_ms))?m_STAR_:cljs.core.reduce_kv(((function (m_STAR_,instant_19313,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state){
return (function (m_STAR___$1,k,p__19277){
var vec__19278 = p__19277;
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19278,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19278,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19278,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19278,(3),null);
var cv = vec__19278;
if(((instant_19313 - udt) > ttl_ms)){
return m_STAR___$1;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR___$1,k,cv);
}
});})(m_STAR_,instant_19313,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.encore.clj1098(m_STAR_)));
var n_to_prune = (cljs.core.count(m_STAR___$1) - cache_size);
var m_STAR___$2 = ((!((n_to_prune > (0))))?m_STAR___$1:cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,m_STAR___$1,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_19313,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state){
return (function (p1__19233_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__19233_SHARP_,(1));
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_19313,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state))
,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n_to_prune,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_19313,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state){
return (function (p1__19232_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__19232_SHARP_,(0));
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_19313,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state))
,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_19313,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state){
return (function (k){
var vec__19281 = (m_STAR___$1.cljs$core$IFn$_invoke$arity$1 ? m_STAR___$1.cljs$core$IFn$_invoke$arity$1(k) : m_STAR___$1.call(null,k));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19281,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19281,(1),null);
var tick_lru = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19281,(2),null);
var tick_lfu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19281,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(tick_lru + tick_lfu),k], null);
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_19313,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state))
,cljs.core.keys(m_STAR___$1)))))));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR___$2,cljs.core.cst$kw$tick,cljs.core.cst$kw$tick.cljs$core$IFn$_invoke$arity$1(m));
});})(instant_19313,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state))
);
} else {
}

var fresh_QMARK_ = (function (){var G__19287 = arg1;
var G__19288 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__19287,G__19288) : taoensso.encore.kw_identical_QMARK_.call(null,G__19287,G__19288));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var _QMARK_instant = (cljs.core.truth_(ttl_ms)?taoensso.encore.now_udt():null);
var tick_SINGLEQUOTE_ = cljs.core.cst$kw$tick.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
var vec__19284 = taoensso.encore.swap_val_BANG_(state,args__$1,((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__6612__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__6612__auto__)){
var and__6612__auto____$1 = cljs.core.not(fresh_QMARK_);
if(and__6612__auto____$1){
var or__6624__auto__ = (_QMARK_instant == null);
if(or__6624__auto__){
return or__6624__auto__;
} else {
var vec__19298 = _QMARK_cv;
var _dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19298,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19298,(1),null);
return ((_QMARK_instant - udt) < ttl_ms);
}
} else {
return and__6612__auto____$1;
}
} else {
return and__6612__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state))
,null)),_QMARK_instant,tick_SINGLEQUOTE_,(1)], null);
}
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state))
);
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19284,(0),null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__19284,dv,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state){
return (function (m){
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,args__$1);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__19301 = temp__4657__auto__;
var dv__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19301,(0),null);
var _QMARK_udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19301,(1),null);
var tick_lru = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19301,(2),null);
var tick_lfu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19301,(3),null);
var cv = vec__19301;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.cst$kw$tick,(tick_SINGLEQUOTE_ + (1)),args__$1,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [dv__$1,_QMARK_udt,tick_SINGLEQUOTE_,(tick_lfu + (1))], null)])], 0));
} else {
return null;
}
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__19284,dv,vec__19270,seq__19271,first__19272,seq__19271__$1,arg1,argn,args,state))
);

return cljs.core.deref(dv);
}
};
var G__19312 = function (var_args){
var p__19269 = null;
if (arguments.length > 0) {
var G__19314__i = 0, G__19314__a = new Array(arguments.length -  0);
while (G__19314__i < G__19314__a.length) {G__19314__a[G__19314__i] = arguments[G__19314__i + 0]; ++G__19314__i;}
  p__19269 = new cljs.core.IndexedSeq(G__19314__a,0,null);
} 
return G__19312__delegate.call(this,p__19269);};
G__19312.cljs$lang$maxFixedArity = 0;
G__19312.cljs$lang$applyTo = (function (arglist__19315){
var p__19269 = cljs.core.seq(arglist__19315);
return G__19312__delegate(p__19269);
});
G__19312.cljs$core$IFn$_invoke$arity$variadic = G__19312__delegate;
return G__19312;
})()
;
;})(state))
});

taoensso.encore.memoize_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * Takes one or more rate specs of form [ncalls-limit window-ms ?spec-id] and
 *   returns a (fn [& [req-id])) that returns `nil` (=> all rate limits passed), or
 *   [<ms-wait> <worst-offending-spec-id>] / <ms-wait>.
 */
taoensso.encore.rate_limiter_STAR_ = (function taoensso$encore$rate_limiter_STAR_(specs){
if(cljs.core.empty_QMARK_(specs)){
return cljs.core.constantly(null);
} else {
var vspecs = cljs.core.vec(specs);
var vstates_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var max_win_ms = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(0),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vspecs,vstates_){
return (function (p__19316){
var vec__19317 = p__19316;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19317,(0),null);
var win_ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19317,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19317,(2),null);
var spec = vec__19317;
return win_ms;
});})(vspecs,vstates_))
,vspecs));
var nspecs = cljs.core.count(vspecs);
var nid_specs = cljs.core.count(cljs.core.filterv(((function (vspecs,vstates_,max_win_ms,nspecs){
return (function (p__19320){
var vec__19321 = p__19320;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19321,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19321,(1),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19321,(2),null);
return id;
});})(vspecs,vstates_,max_win_ms,nspecs))
,vspecs));
var _ = ((((nid_specs === (0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(nid_specs,nspecs)))?null:(function(){throw (new Error("Assert failed: (or (zero? nid-specs) (= nid-specs nspecs))"))})());
var return_ids_QMARK_ = !((nid_specs === (0)));
return ((function (vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function() { 
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate = function (p__19324){
var vec__19325 = p__19324;
var req_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19325,(0),null);
var instant = taoensso.encore.now_udt();
if(cljs.core.truth_((function (){var and__6612__auto__ = req_id;
if(cljs.core.truth_(and__6612__auto__)){
return taoensso.encore.gc_now_QMARK_();
} else {
return and__6612__auto__;
}
})())){
taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(vstates_,cljs.core.PersistentVector.EMPTY,((function (instant,vec__19325,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function taoensso$encore$rate_limiter_STAR__$_check_rate_limits_$_gc(m){
var m__$1 = taoensso.encore.clj1098(m);
return cljs.core.reduce_kv(((function (m__$1,instant,vec__19325,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (m_STAR_,req_id__$1,vstate){
var max_udt_win_start = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (m__$1,instant,vec__19325,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (acc,p__19328){
var vec__19329 = p__19328;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19329,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19329,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19329,(2),null);
var x__6960__auto__ = acc;
var y__6961__auto__ = udt;
return ((x__6960__auto__ > y__6961__auto__) ? x__6960__auto__ : y__6961__auto__);
});})(m__$1,instant,vec__19325,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,(0),vstate);
var min_win_ms_elapsed = (instant - max_udt_win_start);
if((min_win_ms_elapsed > max_win_ms)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m_STAR_,req_id__$1);
} else {
return m_STAR_;
}
});})(m__$1,instant,vec__19325,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,m__$1,m__$1);
});})(instant,vec__19325,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
} else {
}

return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(vstates_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [req_id], null),((function (instant,vec__19325,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (_QMARK_vstate){
if(cljs.core.not(_QMARK_vstate)){
return taoensso.encore.swapped(cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(nspecs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),instant], null))),null);
} else {
var vec__19332 = (function (){var in_vspecs = vspecs;
var in_vstate = _QMARK_vstate;
var out_vstate = cljs.core.PersistentVector.EMPTY;
var _QMARK_worst_limit_offence = null;
while(true){
var vec__19335 = in_vspecs;
var seq__19336 = cljs.core.seq(vec__19335);
var first__19337 = cljs.core.first(seq__19336);
var seq__19336__$1 = cljs.core.next(seq__19336);
var vec__19338 = first__19337;
var ncalls_limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19338,(0),null);
var win_ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19338,(1),null);
var _QMARK_spec_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19338,(2),null);
var next_in_vspecs = seq__19336__$1;
var vec__19341 = in_vstate;
var seq__19342 = cljs.core.seq(vec__19341);
var first__19343 = cljs.core.first(seq__19342);
var seq__19342__$1 = cljs.core.next(seq__19342);
var vec__19344 = first__19343;
var ncalls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19344,(0),null);
var udt_win_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19344,(1),null);
var next_in_vstate = seq__19342__$1;
var win_ms_elapsed = (instant - udt_win_start);
var reset_due_QMARK_ = (win_ms_elapsed >= win_ms);
var rate_limited_QMARK_ = (!(reset_due_QMARK_)) && ((ncalls >= ncalls_limit));
var new_out_vstate = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out_vstate,((reset_due_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),instant], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls,udt_win_start], null)));
var new__QMARK_worst_limit_offence = ((!(rate_limited_QMARK_))?_QMARK_worst_limit_offence:(function (){var ms_wait = (win_ms - win_ms_elapsed);
if((function (){var or__6624__auto__ = (_QMARK_worst_limit_offence == null);
if(or__6624__auto__){
return or__6624__auto__;
} else {
var vec__19350 = _QMARK_worst_limit_offence;
var max_ms_wait = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19350,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19350,(1),null);
return (ms_wait > max_ms_wait);
}
})()){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ms_wait,_QMARK_spec_id], null);
} else {
return _QMARK_worst_limit_offence;
}
})());
if(cljs.core.not(next_in_vspecs)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_out_vstate,new__QMARK_worst_limit_offence], null);
} else {
var G__19360 = next_in_vspecs;
var G__19361 = next_in_vstate;
var G__19362 = new_out_vstate;
var G__19363 = new__QMARK_worst_limit_offence;
in_vspecs = G__19360;
in_vstate = G__19361;
out_vstate = G__19362;
_QMARK_worst_limit_offence = G__19363;
continue;
}
break;
}
})();
var vstate_with_resets = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19332,(0),null);
var _QMARK_worst_limit_offence = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19332,(1),null);
var all_limits_pass_QMARK_ = (_QMARK_worst_limit_offence == null);
var new_vstate = ((!(all_limits_pass_QMARK_))?vstate_with_resets:cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vec__19332,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__19325,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (p__19353){
var vec__19354 = p__19353;
var ncalls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19354,(0),null);
var udt_win_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19354,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(ncalls + (1)),udt_win_start], null);
});})(vec__19332,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__19325,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,vstate_with_resets));
var result = (function (){var temp__4657__auto__ = _QMARK_worst_limit_offence;
if(cljs.core.truth_(temp__4657__auto__)){
var wlo = temp__4657__auto__;
if(return_ids_QMARK_){
return wlo;
} else {
var vec__19357 = wlo;
var ms_wait = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19357,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19357,(1),null);
return ms_wait;
}
} else {
return null;
}
})();
return taoensso.encore.swapped(new_vstate,result);
}
});})(instant,vec__19325,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
};
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits = function (var_args){
var p__19324 = null;
if (arguments.length > 0) {
var G__19364__i = 0, G__19364__a = new Array(arguments.length -  0);
while (G__19364__i < G__19364__a.length) {G__19364__a[G__19364__i] = arguments[G__19364__i + 0]; ++G__19364__i;}
  p__19324 = new cljs.core.IndexedSeq(G__19364__a,0,null);
} 
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate.call(this,p__19324);};
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$maxFixedArity = 0;
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$applyTo = (function (arglist__19365){
var p__19324 = cljs.core.seq(arglist__19365);
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate(p__19324);
});
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$core$IFn$_invoke$arity$variadic = taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate;
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits;
})()
;
;})(vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
}
});
taoensso.encore.rate_limit = (function taoensso$encore$rate_limit(specs,f){
var rl = taoensso.encore.rate_limiter_STAR_(specs);
return ((function (rl){
return (function() { 
var G__19366__delegate = function (args){
var temp__4655__auto__ = (rl.cljs$core$IFn$_invoke$arity$0 ? rl.cljs$core$IFn$_invoke$arity$0() : rl.call(null));
if(cljs.core.truth_(temp__4655__auto__)){
var backoff = temp__4655__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,backoff], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),null], null);
}
};
var G__19366 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19367__i = 0, G__19367__a = new Array(arguments.length -  0);
while (G__19367__i < G__19367__a.length) {G__19367__a[G__19367__i] = arguments[G__19367__i + 0]; ++G__19367__i;}
  args = new cljs.core.IndexedSeq(G__19367__a,0,null);
} 
return G__19366__delegate.call(this,args);};
G__19366.cljs$lang$maxFixedArity = 0;
G__19366.cljs$lang$applyTo = (function (arglist__19368){
var args = cljs.core.seq(arglist__19368);
return G__19366__delegate(args);
});
G__19366.cljs$core$IFn$_invoke$arity$variadic = G__19366__delegate;
return G__19366;
})()
;
;})(rl))
});
taoensso.encore.nano_time = (function (){var temp__4655__auto__ = (function (){var and__6612__auto__ = typeof window !== 'undefined';
if(and__6612__auto__){
return (window["performance"]);
} else {
return and__6612__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var perf = temp__4655__auto__;
var temp__4655__auto____$1 = (function (){var or__6624__auto__ = (perf["now"]);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
var or__6624__auto____$1 = (perf["mozNow"]);
if(cljs.core.truth_(or__6624__auto____$1)){
return or__6624__auto____$1;
} else {
var or__6624__auto____$2 = (perf["msNow"]);
if(cljs.core.truth_(or__6624__auto____$2)){
return or__6624__auto____$2;
} else {
var or__6624__auto____$3 = (perf["oNow"]);
if(cljs.core.truth_(or__6624__auto____$3)){
return or__6624__auto____$3;
} else {
return (perf["webkitNow"]);
}
}
}
}
})();
if(cljs.core.truth_(temp__4655__auto____$1)){
var f = temp__4655__auto____$1;
return ((function (f,temp__4655__auto____$1,perf,temp__4655__auto__){
return (function (){
return cljs.core.long$((1000000.0 * f.call(perf)));
});
;})(f,temp__4655__auto____$1,perf,temp__4655__auto__))
} else {
return ((function (temp__4655__auto____$1,perf,temp__4655__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt());
});
;})(temp__4655__auto____$1,perf,temp__4655__auto__))
}
} else {
return ((function (temp__4655__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt());
});
;})(temp__4655__auto__))
}
})();
taoensso.encore.qb_min_times = (function taoensso$encore$qb_min_times(times){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,times);
});
taoensso.encore.console_log = (function (){var temp__4655__auto__ = (function (){var and__6612__auto__ = typeof console !== 'undefined';
if(and__6612__auto__){
return console.log;
} else {
return and__6612__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return ((function (f,temp__4655__auto__){
return (function (xs){
return f.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(xs));
});
;})(f,temp__4655__auto__))
} else {
return ((function (temp__4655__auto__){
return (function (xs){
return null;
});
;})(temp__4655__auto__))
}
})();

taoensso.encore.log = (function taoensso$encore$log(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19380 = arguments.length;
var i__7750__auto___19381 = (0);
while(true){
if((i__7750__auto___19381 < len__7749__auto___19380)){
args__7756__auto__.push((arguments[i__7750__auto___19381]));

var G__19382 = (i__7750__auto___19381 + (1));
i__7750__auto___19381 = G__19382;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((0) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((0)),(0),null)):null);
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(argseq__7757__auto__);
});

taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(xs) : taoensso.encore.console_log.call(null,xs));
});

taoensso.encore.log.cljs$lang$maxFixedArity = (0);

taoensso.encore.log.cljs$lang$applyTo = (function (seq19369){
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19369));
});


taoensso.encore.logp = (function taoensso$encore$logp(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19383 = arguments.length;
var i__7750__auto___19384 = (0);
while(true){
if((i__7750__auto___19384 < len__7749__auto___19383)){
args__7756__auto__.push((arguments[i__7750__auto___19384]));

var G__19385 = (i__7750__auto___19384 + (1));
i__7750__auto___19384 = G__19385;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((0) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((0)),(0),null)):null);
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(argseq__7757__auto__);
});

taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var G__19371 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.spaced_str(xs)], null);
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(G__19371) : taoensso.encore.console_log.call(null,G__19371));
});

taoensso.encore.logp.cljs$lang$maxFixedArity = (0);

taoensso.encore.logp.cljs$lang$applyTo = (function (seq19370){
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19370));
});


taoensso.encore.logf = (function taoensso$encore$logf(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19386 = arguments.length;
var i__7750__auto___19387 = (0);
while(true){
if((i__7750__auto___19387 < len__7749__auto___19386)){
args__7756__auto__.push((arguments[i__7750__auto___19387]));

var G__19388 = (i__7750__auto___19387 + (1));
i__7750__auto___19387 = G__19388;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
var G__19374 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.format_STAR_(fmt,xs)], null);
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(G__19374) : taoensso.encore.console_log.call(null,G__19374));
});

taoensso.encore.logf.cljs$lang$maxFixedArity = (1);

taoensso.encore.logf.cljs$lang$applyTo = (function (seq19372){
var G__19373 = cljs.core.first(seq19372);
var seq19372__$1 = cljs.core.next(seq19372);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic(G__19373,seq19372__$1);
});


taoensso.encore.sayp = (function taoensso$encore$sayp(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19389 = arguments.length;
var i__7750__auto___19390 = (0);
while(true){
if((i__7750__auto___19390 < len__7749__auto___19389)){
args__7756__auto__.push((arguments[i__7750__auto___19390]));

var G__19391 = (i__7750__auto___19390 + (1));
i__7750__auto___19390 = G__19391;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((0) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((0)),(0),null)):null);
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(argseq__7757__auto__);
});

taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var G__19376 = taoensso.encore.spaced_str(xs);
return alert(G__19376);
});

taoensso.encore.sayp.cljs$lang$maxFixedArity = (0);

taoensso.encore.sayp.cljs$lang$applyTo = (function (seq19375){
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq19375));
});


taoensso.encore.sayf = (function taoensso$encore$sayf(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19392 = arguments.length;
var i__7750__auto___19393 = (0);
while(true){
if((i__7750__auto___19393 < len__7749__auto___19392)){
args__7756__auto__.push((arguments[i__7750__auto___19393]));

var G__19394 = (i__7750__auto___19393 + (1));
i__7750__auto___19393 = G__19394;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
var G__19379 = taoensso.encore.format_STAR_(fmt,xs);
return alert(G__19379);
});

taoensso.encore.sayf.cljs$lang$maxFixedArity = (1);

taoensso.encore.sayf.cljs$lang$applyTo = (function (seq19377){
var G__19378 = cljs.core.first(seq19377);
var seq19377__$1 = cljs.core.next(seq19377);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic(G__19378,seq19377__$1);
});

/**
 * Returns browser window's current location. Forgeable.
 */
taoensso.encore.get_window_location = (function taoensso$encore$get_window_location(){
var loc_STAR_ = window.location;
var loc = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$href,loc_STAR_.href,cljs.core.cst$kw$protocol,loc_STAR_.protocol,cljs.core.cst$kw$hostname,loc_STAR_.hostname,cljs.core.cst$kw$host,loc_STAR_.host,cljs.core.cst$kw$pathname,loc_STAR_.pathname,cljs.core.cst$kw$search,loc_STAR_.search,cljs.core.cst$kw$hash,loc_STAR_.hash], null);
return loc;
});
taoensso.encore.xhr_pool_ = (new cljs.core.Delay((function (){
return (new goog.net.XhrIoPool());
}),null));
/**
 * Returns an immediately available XhrIo instance, or nil. The instance must be
 *   released back to pool manually.
 */
taoensso.encore.get_pooled_xhr_BANG_ = (function taoensso$encore$get_pooled_xhr_BANG_(){
var result = cljs.core.deref(taoensso.encore.xhr_pool_).getObject();
if((void 0 === result)){
return null;
} else {
return result;
}
});
/**
 * [uri method get-or-post-params] -> [uri post-content]
 */
taoensso.encore.coerce_xhr_params = (function taoensso$encore$coerce_xhr_params(uri,method,params){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return params;
}),null)),cljs.core.cst$sym$params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$map_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? map?] params)"));
}

var _QMARK_pstr = ((cljs.core.empty_QMARK_(params))?null:(function (){var s = (function (){var G__19395 = (new goog.structs.Map(cljs.core.clj__GT_js(params)));
return goog.Uri.QueryData.createFromMap(G__19395);
})().toString();
if(clojure.string.blank_QMARK_(s)){
return null;
} else {
return s;
}
})());
var G__19396 = method;
var G__19396__$1 = (((G__19396 instanceof cljs.core.Keyword))?G__19396.fqn:null);
switch (G__19396__$1) {
case "get":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(_QMARK_pstr)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(uri),cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_pstr)].join(''):uri),null], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
case "put":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19396__$1)].join('')));

}
});
/**
 * Alpha - subject to change.
 *   Simple+lightweight Ajax via Google Closure. Returns nil, or the xhr instance.
 *   Ref. https://developers.google.com/closure/library/docs/xhrio.
 * 
 *   (ajax-lite "/my-post-route"
 *  {:method     :post
 *   :params     {:username "Rich Hickey"
 *                :type     "Awesome"}
 *   :headers    {"Foo" "Bar"}
 *   :resp-type  :text
 *   :timeout-ms 7000
 *   :with-credentials? false ; Enable if using CORS (requires xhr v2+)
 *  }
 *  (fn async-callback [resp-map]
 *    (let [{:keys [success? ?status ?error ?content ?content-type]} resp-map]
 *      ;; ?status  - 200, 404, ..., or nil on no response
 *      ;; ?error   - e/o #{:xhr-pool-depleted :exception :http-error :abort
 *      ;;                  :timeout :no-content <http-error-status> nil}
 *      (js/alert (str "Ajax response: " resp-map)))))
 */
taoensso.encore.ajax_lite = (function taoensso$encore$ajax_lite(uri,p__19400,callback){
var map__19401 = p__19400;
var map__19401__$1 = ((((!((map__19401 == null)))?((((map__19401.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19401.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19401):map__19401);
var opts = map__19401__$1;
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19401__$1,cljs.core.cst$kw$method,cljs.core.cst$kw$get);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19401__$1,cljs.core.cst$kw$params);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19401__$1,cljs.core.cst$kw$headers);
var timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19401__$1,cljs.core.cst$kw$timeout_DASH_ms,(10000));
var resp_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19401__$1,cljs.core.cst$kw$resp_DASH_type,cljs.core.cst$kw$auto);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19401__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var progress_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19401__$1,cljs.core.cst$kw$progress_DASH_fn);
var errorf = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19401__$1,cljs.core.cst$kw$errorf,taoensso.encore.logf);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (map__19401,map__19401__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (){
return timeout_ms;
});})(map__19401,map__19401__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
,null)),cljs.core.cst$sym$timeout_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$nneg_DASH_int_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? nneg-int?] timeout-ms)"));
}

var temp__4655__auto__ = taoensso.encore.get_pooled_xhr_BANG_();
if(cljs.core.truth_(temp__4655__auto__)){
var xhr = temp__4655__auto__;
try{var timeout_ms__$1 = (function (){var or__6624__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return timeout_ms;
}
})();
var method_STAR_ = (function (){var G__19407 = method;
var G__19407__$1 = (((G__19407 instanceof cljs.core.Keyword))?G__19407.fqn:null);
switch (G__19407__$1) {
case "get":
return "GET";

break;
case "post":
return "POST";

break;
case "put":
return "PUT";

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19407__$1)].join('')));

}
})();
var params__$1 = taoensso.encore.map_keys(cljs.core.name,params);
var headers__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["X-Requested-With","XMLHTTPRequest"], null),taoensso.encore.map_keys(cljs.core.name,headers)], 0));
var vec__19404 = taoensso.encore.coerce_xhr_params(uri,method,params__$1);
var uri_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19404,(0),null);
var post_content_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19404,(1),null);
var headers_STAR_ = cljs.core.clj__GT_js(((cljs.core.not(post_content_STAR_))?headers__$1:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(headers__$1,"Content-Type","application/x-www-form-urlencoded; charset=UTF-8")));
var G__19408_19429 = xhr;
var G__19409_19430 = G__19408_19429;
var G__19410_19431 = goog.net.EventType.READY;
var G__19411_19432 = ((function (G__19409_19430,G__19410_19431,G__19408_19429,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__19404,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__19401,map__19401__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (_){
return cljs.core.deref(taoensso.encore.xhr_pool_).releaseObject(xhr);
});})(G__19409_19430,G__19410_19431,G__19408_19429,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__19404,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__19401,map__19401__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listenOnce(G__19409_19430,G__19410_19431,G__19411_19432);

var G__19412_19433 = G__19408_19429;
var G__19413_19434 = goog.net.EventType.COMPLETE;
var G__19414_19435 = ((function (G__19412_19433,G__19413_19434,G__19408_19429,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__19404,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__19401,map__19401__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function taoensso$encore$ajax_lite_$_wrapped_callback(resp){
var status = xhr.getStatus();
var success_QMARK_ = xhr.isSuccess();
var _QMARK_http_status = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(status,(-1)))?status:null);
var _QMARK_content_type = (cljs.core.truth_(_QMARK_http_status)?xhr.getResponseHeader("Content-Type"):null);
var _QMARK_content = (cljs.core.truth_(_QMARK_http_status)?(function (){var resp_type__$1 = ((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(resp_type,cljs.core.cst$kw$auto)))?resp_type:(function (){var pred__19415 = ((function (status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__19412_19433,G__19413_19434,G__19408_19429,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__19404,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__19401,map__19401__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (p1__19399_SHARP_,p2__19398_SHARP_){
return taoensso.encore.str_contains_QMARK_(p2__19398_SHARP_,p1__19399_SHARP_);
});})(status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__19412_19433,G__19413_19434,G__19408_19429,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__19404,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__19401,map__19401__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
var expr__19416 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_content_type)].join('');
if(cljs.core.truth_(pred__19415("/edn",expr__19416))){
return cljs.core.cst$kw$edn;
} else {
if(cljs.core.truth_(pred__19415("/json",expr__19416))){
return cljs.core.cst$kw$json;
} else {
if(cljs.core.truth_(pred__19415("/xml",expr__19416))){
return cljs.core.cst$kw$xml;
} else {
if(cljs.core.truth_(pred__19415("/html",expr__19416))){
return cljs.core.cst$kw$text;
} else {
return cljs.core.cst$kw$text;
}
}
}
}
})());
try{var G__19419 = resp_type__$1;
var G__19419__$1 = (((G__19419 instanceof cljs.core.Keyword))?G__19419.fqn:null);
switch (G__19419__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
case "xml":
return xhr.getResponseXml();

break;
case "edn":
return cljs.reader.read_string(xhr.getResponseText());

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19419__$1)].join('')));

}
}catch (e19418){if((e19418 instanceof Error)){
var e = e19418;
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ajax_SLASH_bad_DASH_response_DASH_type,resp_type__$1,cljs.core.cst$kw$ajax_SLASH_resp_DASH_as_DASH_text,xhr.getResponseText()], null);
} else {
throw e19418;

}
}})():null);
var cb_arg = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$raw_DASH_resp,resp,cljs.core.cst$kw$xhr,xhr,cljs.core.cst$kw$success_QMARK_,success_QMARK_,cljs.core.cst$kw$_QMARK_content_DASH_type,(cljs.core.truth_(_QMARK_http_status)?_QMARK_content_type:null),cljs.core.cst$kw$_QMARK_content,_QMARK_content,cljs.core.cst$kw$_QMARK_status,_QMARK_http_status,cljs.core.cst$kw$_QMARK_error,(function (){var or__6624__auto__ = (cljs.core.truth_(_QMARK_http_status)?(function (){var n = _QMARK_http_status;
if(cljs.core.truth_(success_QMARK_)){
return null;
} else {
return _QMARK_http_status;
}
})():cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.createAsIfByAssoc([goog.net.ErrorCode.EXCEPTION,cljs.core.cst$kw$exception,goog.net.ErrorCode.HTTP_ERROR,cljs.core.cst$kw$http_DASH_error,goog.net.ErrorCode.ABORT,cljs.core.cst$kw$abort,goog.net.ErrorCode.TIMEOUT,cljs.core.cst$kw$timeout]),xhr.getLastErrorCode(),cljs.core.cst$kw$unknown));
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
if(((_QMARK_content == null)) && (cljs.core.not((function (){var fexpr__19421 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(204),null,(1223),null], null), null);
return (fexpr__19421.cljs$core$IFn$_invoke$arity$1 ? fexpr__19421.cljs$core$IFn$_invoke$arity$1(_QMARK_http_status) : fexpr__19421.call(null,_QMARK_http_status));
})()))){
return cljs.core.cst$kw$no_DASH_content;
} else {
return null;
}
}
})()], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(cb_arg) : callback.call(null,cb_arg));
});})(G__19412_19433,G__19413_19434,G__19408_19429,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__19404,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__19401,map__19401__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listenOnce(G__19412_19433,G__19413_19434,G__19414_19435);


var temp__4657__auto___19437 = progress_fn;
if(cljs.core.truth_(temp__4657__auto___19437)){
var pf_19438 = temp__4657__auto___19437;
var G__19422_19439 = xhr;
var G__19423_19440 = goog.net.EventType.PROGRESS;
var G__19424_19441 = ((function (G__19422_19439,G__19423_19440,pf_19438,temp__4657__auto___19437,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__19404,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__19401,map__19401__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (ev){
var length_computable_QMARK_ = ev.lengthComputable;
var loaded = ev.loaded;
var total = ev.total;
var _QMARK_ratio = (cljs.core.truth_((function (){var and__6612__auto__ = length_computable_QMARK_;
if(cljs.core.truth_(and__6612__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(total,(0));
} else {
return and__6612__auto__;
}
})())?(loaded / total):null);
var G__19425 = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$_QMARK_ratio,_QMARK_ratio,cljs.core.cst$kw$length_DASH_computable_QMARK_,length_computable_QMARK_,cljs.core.cst$kw$loaded,loaded,cljs.core.cst$kw$total,total,cljs.core.cst$kw$ev,ev], null);
return (pf_19438.cljs$core$IFn$_invoke$arity$1 ? pf_19438.cljs$core$IFn$_invoke$arity$1(G__19425) : pf_19438.call(null,G__19425));
});})(G__19422_19439,G__19423_19440,pf_19438,temp__4657__auto___19437,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__19404,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__19401,map__19401__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listen(G__19422_19439,G__19423_19440,G__19424_19441);
} else {
}

var G__19426_19442 = xhr;
var temp__4657__auto___19443 = cljs.core.cst$kw$always;
if(cljs.core.truth_(temp__4657__auto___19443)){
var x_19444 = temp__4657__auto___19443;
G__19426_19442.setTimeoutInterval((function (){var or__6624__auto__ = timeout_ms__$1;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return (0);
}
})());
} else {
}

var temp__4657__auto___19445 = with_credentials_QMARK_;
if(cljs.core.truth_(temp__4657__auto___19445)){
var x_19446 = temp__4657__auto___19445;
G__19426_19442.setWithCredentials(true);
} else {
}

var temp__4657__auto___19447 = cljs.core.cst$kw$always;
if(cljs.core.truth_(temp__4657__auto___19447)){
var x_19448 = temp__4657__auto___19447;
G__19426_19442.send(uri_STAR_,method_STAR_,post_content_STAR_,headers_STAR_);
} else {
}


return xhr;
}catch (e19403){if((e19403 instanceof Error)){
var e = e19403;
cljs.core.deref(taoensso.encore.xhr_pool_).releaseObject(xhr);

return null;
} else {
throw e19403;

}
}} else {
var G__19427_19449 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_QMARK_error,cljs.core.cst$kw$xhr_DASH_pool_DASH_depleted], null);
(callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__19427_19449) : callback.call(null,G__19427_19449));

return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1.
 */
taoensso.encore.url_encode = (function taoensso$encore$url_encode(s){
if(cljs.core.truth_(s)){
return clojure.string.replace(clojure.string.replace((function (){var G__19450 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join('');
var G__19451 = s;
return encodeURIComponent(G__19450,G__19451);
})(),"*","%2A"),"'","%27");
} else {
return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1.
 */
taoensso.encore.url_decode = (function taoensso$encore$url_decode(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19458 = arguments.length;
var i__7750__auto___19459 = (0);
while(true){
if((i__7750__auto___19459 < len__7749__auto___19458)){
args__7756__auto__.push((arguments[i__7750__auto___19459]));

var G__19460 = (i__7750__auto___19459 + (1));
i__7750__auto___19459 = G__19460;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__19454){
var vec__19455 = p__19454;
var encoding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19455,(0),null);
if(cljs.core.truth_(s)){
return decodeURIComponent(s);
} else {
return null;
}
});

taoensso.encore.url_decode.cljs$lang$maxFixedArity = (1);

taoensso.encore.url_decode.cljs$lang$applyTo = (function (seq19452){
var G__19453 = cljs.core.first(seq19452);
var seq19452__$1 = cljs.core.next(seq19452);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(G__19453,seq19452__$1);
});

taoensso.encore.format_query_string = (function taoensso$encore$format_query_string(m){
var param = (function (k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.url_encode(cljs.core.name(k))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.url_encode(v))].join('');
});
var join = ((function (param){
return (function (strs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",strs);
});})(param))
;
if(cljs.core.empty_QMARK_(m)){
return null;
} else {
return join((function (){var iter__7413__auto__ = ((function (param,join){
return (function taoensso$encore$format_query_string_$_iter__19461(s__19462){
return (new cljs.core.LazySeq(null,((function (param,join){
return (function (){
var s__19462__$1 = s__19462;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__19462__$1);
if(temp__4657__auto__){
var s__19462__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19462__$2)){
var c__7411__auto__ = cljs.core.chunk_first(s__19462__$2);
var size__7412__auto__ = cljs.core.count(c__7411__auto__);
var b__19464 = cljs.core.chunk_buffer(size__7412__auto__);
if((function (){var i__19463 = (0);
while(true){
if((i__19463 < size__7412__auto__)){
var vec__19465 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7411__auto__,i__19463);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19465,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19465,(1),null);
cljs.core.chunk_append(b__19464,((cljs.core.sequential_QMARK_(v))?join(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(param,k),(function (){var or__6624__auto__ = cljs.core.seq(v);
if(or__6624__auto__){
return or__6624__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param(k,v)));

var G__19471 = (i__19463 + (1));
i__19463 = G__19471;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19464),taoensso$encore$format_query_string_$_iter__19461(cljs.core.chunk_rest(s__19462__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19464),null);
}
} else {
var vec__19468 = cljs.core.first(s__19462__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19468,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19468,(1),null);
return cljs.core.cons(((cljs.core.sequential_QMARK_(v))?join(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(param,k),(function (){var or__6624__auto__ = cljs.core.seq(v);
if(or__6624__auto__){
return or__6624__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param(k,v)),taoensso$encore$format_query_string_$_iter__19461(cljs.core.rest(s__19462__$2)));
}
} else {
return null;
}
break;
}
});})(param,join))
,null,null));
});})(param,join))
;
return iter__7413__auto__(m);
})());
}
});
taoensso.encore.assoc_conj = (function taoensso$encore$assoc_conj(m,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var temp__4655__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(temp__4655__auto__)){
var cur = temp__4655__auto__;
if(cljs.core.vector_QMARK_(cur)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cur,v);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cur,v], null);
}
} else {
return v;
}
})());
});
/**
 * Based on `ring-codec/form-decode`.
 */
taoensso.encore.parse_query_params = (function taoensso$encore$parse_query_params(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19481 = arguments.length;
var i__7750__auto___19482 = (0);
while(true){
if((i__7750__auto___19482 < len__7749__auto___19481)){
args__7756__auto__.push((arguments[i__7750__auto___19482]));

var G__19483 = (i__7750__auto___19482 + (1));
i__7750__auto___19482 = G__19483;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__19474){
var vec__19475 = p__19474;
var keywordize_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19475,(0),null);
var encoding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19475,(1),null);
var _PERCENT_ = ((clojure.string.blank_QMARK_(s))?cljs.core.PersistentArrayMap.EMPTY:(function (){var s__$1 = (cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s,"?"))?taoensso.encore.substr(s,(1)):s);
if(cljs.core.not(taoensso.encore.str_contains_QMARK_(s__$1,"="))){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var m = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (s__$1,vec__19475,keywordize_QMARK_,encoding){
return (function (m,param){
var temp__4655__auto__ = clojure.string.split.cljs$core$IFn$_invoke$arity$3(param,/=/,(2));
if(cljs.core.truth_(temp__4655__auto__)){
var vec__19478 = temp__4655__auto__;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19478,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19478,(1),null);
return taoensso.encore.assoc_conj(m,taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(k,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([encoding], 0)),taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(v,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([encoding], 0)));
} else {
return m;
}
});})(s__$1,vec__19475,keywordize_QMARK_,encoding))
,cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2(s__$1,/&/));
if(cljs.core.not(keywordize_QMARK_)){
return m;
} else {
return taoensso.encore.keywordize_map(m);
}
}
})());
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (_PERCENT_,vec__19475,keywordize_QMARK_,encoding){
return (function (){
return _PERCENT_;
});})(_PERCENT_,vec__19475,keywordize_QMARK_,encoding))
,null)),cljs.core.cst$sym$_PERCENT_,cljs.core.map_QMARK_,cljs.core.cst$sym$map_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? map? %)"));
}

return _PERCENT_;
});

taoensso.encore.parse_query_params.cljs$lang$maxFixedArity = (1);

taoensso.encore.parse_query_params.cljs$lang$applyTo = (function (seq19472){
var G__19473 = cljs.core.first(seq19472);
var seq19472__$1 = cljs.core.next(seq19472);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic(G__19473,seq19472__$1);
});

taoensso.encore.merge_url_with_query_string = (function taoensso$encore$merge_url_with_query_string(url,m){
var vec__19484 = clojure.string.split.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join(''),/\?/,(2));
var url__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19484,(0),null);
var _QMARK_qstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19484,(1),null);
var qmap = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(cljs.core.truth_(_QMARK_qstr)?taoensso.encore.keywordize_map(taoensso.encore.parse_query_params(_QMARK_qstr)):null),taoensso.encore.keywordize_map(m)], 0));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(url__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var temp__4657__auto__ = taoensso.encore.format_query_string(qmap);
if(cljs.core.truth_(temp__4657__auto__)){
var qstr = temp__4657__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(qstr)].join('');
} else {
return null;
}
})())].join('');
});
taoensso.encore.memoize_1 = taoensso.encore.memoize1;
taoensso.encore.logging_level = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$debug);
taoensso.encore.set_exp_backoff_timeout_BANG_ = (function taoensso$encore$set_exp_backoff_timeout_BANG_(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19493 = arguments.length;
var i__7750__auto___19494 = (0);
while(true){
if((i__7750__auto___19494 < len__7749__auto___19493)){
args__7756__auto__.push((arguments[i__7750__auto___19494]));

var G__19495 = (i__7750__auto___19494 + (1));
i__7750__auto___19494 = G__19495;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (nullary_f,p__19489){
var vec__19490 = p__19489;
var nattempt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19490,(0),null);
return window.setTimeout(nullary_f,taoensso.encore.exp_backoff((function (){var or__6624__auto__ = nattempt;
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return (0);
}
})()));
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$applyTo = (function (seq19487){
var G__19488 = cljs.core.first(seq19487);
var seq19487__$1 = cljs.core.next(seq19487);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19488,seq19487__$1);
});

taoensso.encore.keys_EQ_ = (function taoensso$encore$keys_EQ_(m,ks){
return taoensso.encore.ks_EQ_(ks,m);
});
taoensso.encore.keys_LT__EQ_ = (function taoensso$encore$keys_LT__EQ_(m,ks){
return taoensso.encore.ks_LT__EQ_(ks,m);
});
taoensso.encore.keys_GT__EQ_ = (function taoensso$encore$keys_GT__EQ_(m,ks){
return taoensso.encore.ks_GT__EQ_(ks,m);
});
taoensso.encore.keys_EQ_nnil_QMARK_ = (function taoensso$encore$keys_EQ_nnil_QMARK_(m,ks){
return taoensso.encore.ks_nnil_QMARK_(ks,m);
});
taoensso.encore.parse_bool = taoensso.encore.as__QMARK_bool;
taoensso.encore.parse_int = taoensso.encore.as__QMARK_int;
taoensso.encore.parse_float = taoensso.encore.as__QMARK_float;
taoensso.encore.as_bool = (function taoensso$encore$as_bool(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2200,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_bool(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_bool,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.as_int = (function taoensso$encore$as_int(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2201,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_int(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_int,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.as_float = (function taoensso$encore$as_float(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2202,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_float(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_float,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.merge_deep_with = taoensso.encore.nested_merge_with;
taoensso.encore.merge_deep = taoensso.encore.nested_merge;
taoensso.encore.rate_limiter = (function taoensso$encore$rate_limiter(ncalls_limit,window_ms){
return taoensso.encore.rate_limiter_STAR_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
});
taoensso.encore.rate_limited = (function taoensso$encore$rate_limited(ncalls_limit,window_ms,f){
var rl = taoensso.encore.rate_limiter_STAR_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
return ((function (rl){
return (function() { 
var G__19496__delegate = function (args){
var temp__4655__auto__ = (rl.cljs$core$IFn$_invoke$arity$0 ? rl.cljs$core$IFn$_invoke$arity$0() : rl.call(null));
if(cljs.core.truth_(temp__4655__auto__)){
var backoff_ms = temp__4655__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$backoff_DASH_ms,backoff_ms], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$result,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null))], null);
}
};
var G__19496 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19497__i = 0, G__19497__a = new Array(arguments.length -  0);
while (G__19497__i < G__19497__a.length) {G__19497__a[G__19497__i] = arguments[G__19497__i + 0]; ++G__19497__i;}
  args = new cljs.core.IndexedSeq(G__19497__a,0,null);
} 
return G__19496__delegate.call(this,args);};
G__19496.cljs$lang$maxFixedArity = 0;
G__19496.cljs$lang$applyTo = (function (arglist__19498){
var args = cljs.core.seq(arglist__19498);
return G__19496__delegate(args);
});
G__19496.cljs$core$IFn$_invoke$arity$variadic = G__19496__delegate;
return G__19496;
})()
;
;})(rl))
});
if(typeof taoensso.encore._STAR_log_level_STAR_ !== 'undefined'){
} else {
/**
 * DEPRECATED
 */
taoensso.encore._STAR_log_level_STAR_ = cljs.core.cst$kw$debug;
}

taoensso.encore.log_QMARK_ = (function (){var __GT_n = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$trace,(1),cljs.core.cst$kw$debug,(2),cljs.core.cst$kw$info,(3),cljs.core.cst$kw$warn,(4),cljs.core.cst$kw$error,(5),cljs.core.cst$kw$fatal,(6),cljs.core.cst$kw$report,(7)], null);
return ((function (__GT_n){
return (function (level){
return ((__GT_n.cljs$core$IFn$_invoke$arity$1 ? __GT_n.cljs$core$IFn$_invoke$arity$1(level) : __GT_n.call(null,level)) >= (__GT_n.cljs$core$IFn$_invoke$arity$1 ? __GT_n.cljs$core$IFn$_invoke$arity$1(taoensso.encore._STAR_log_level_STAR_) : __GT_n.call(null,taoensso.encore._STAR_log_level_STAR_)));
});
;})(__GT_n))
})();

taoensso.encore.tracef = (function taoensso$encore$tracef(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19520 = arguments.length;
var i__7750__auto___19521 = (0);
while(true){
if((i__7750__auto___19521 < len__7749__auto___19520)){
args__7756__auto__.push((arguments[i__7750__auto___19521]));

var G__19522 = (i__7750__auto___19521 + (1));
i__7750__auto___19521 = G__19522;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__19501 = cljs.core.cst$kw$trace;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__19501) : taoensso.encore.log_QMARK_.call(null,G__19501));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.tracef.cljs$lang$maxFixedArity = (1);

taoensso.encore.tracef.cljs$lang$applyTo = (function (seq19499){
var G__19500 = cljs.core.first(seq19499);
var seq19499__$1 = cljs.core.next(seq19499);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic(G__19500,seq19499__$1);
});


taoensso.encore.debugf = (function taoensso$encore$debugf(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19523 = arguments.length;
var i__7750__auto___19524 = (0);
while(true){
if((i__7750__auto___19524 < len__7749__auto___19523)){
args__7756__auto__.push((arguments[i__7750__auto___19524]));

var G__19525 = (i__7750__auto___19524 + (1));
i__7750__auto___19524 = G__19525;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__19504 = cljs.core.cst$kw$debug;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__19504) : taoensso.encore.log_QMARK_.call(null,G__19504));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.debugf.cljs$lang$maxFixedArity = (1);

taoensso.encore.debugf.cljs$lang$applyTo = (function (seq19502){
var G__19503 = cljs.core.first(seq19502);
var seq19502__$1 = cljs.core.next(seq19502);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic(G__19503,seq19502__$1);
});


taoensso.encore.infof = (function taoensso$encore$infof(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19526 = arguments.length;
var i__7750__auto___19527 = (0);
while(true){
if((i__7750__auto___19527 < len__7749__auto___19526)){
args__7756__auto__.push((arguments[i__7750__auto___19527]));

var G__19528 = (i__7750__auto___19527 + (1));
i__7750__auto___19527 = G__19528;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__19507 = cljs.core.cst$kw$info;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__19507) : taoensso.encore.log_QMARK_.call(null,G__19507));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.infof.cljs$lang$maxFixedArity = (1);

taoensso.encore.infof.cljs$lang$applyTo = (function (seq19505){
var G__19506 = cljs.core.first(seq19505);
var seq19505__$1 = cljs.core.next(seq19505);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic(G__19506,seq19505__$1);
});


taoensso.encore.warnf = (function taoensso$encore$warnf(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19529 = arguments.length;
var i__7750__auto___19530 = (0);
while(true){
if((i__7750__auto___19530 < len__7749__auto___19529)){
args__7756__auto__.push((arguments[i__7750__auto___19530]));

var G__19531 = (i__7750__auto___19530 + (1));
i__7750__auto___19530 = G__19531;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__19510 = cljs.core.cst$kw$warn;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__19510) : taoensso.encore.log_QMARK_.call(null,G__19510));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("WARN: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.warnf.cljs$lang$maxFixedArity = (1);

taoensso.encore.warnf.cljs$lang$applyTo = (function (seq19508){
var G__19509 = cljs.core.first(seq19508);
var seq19508__$1 = cljs.core.next(seq19508);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic(G__19509,seq19508__$1);
});


taoensso.encore.errorf = (function taoensso$encore$errorf(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19532 = arguments.length;
var i__7750__auto___19533 = (0);
while(true){
if((i__7750__auto___19533 < len__7749__auto___19532)){
args__7756__auto__.push((arguments[i__7750__auto___19533]));

var G__19534 = (i__7750__auto___19533 + (1));
i__7750__auto___19533 = G__19534;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__19513 = cljs.core.cst$kw$error;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__19513) : taoensso.encore.log_QMARK_.call(null,G__19513));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ERROR: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.errorf.cljs$lang$maxFixedArity = (1);

taoensso.encore.errorf.cljs$lang$applyTo = (function (seq19511){
var G__19512 = cljs.core.first(seq19511);
var seq19511__$1 = cljs.core.next(seq19511);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic(G__19512,seq19511__$1);
});


taoensso.encore.fatalf = (function taoensso$encore$fatalf(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19535 = arguments.length;
var i__7750__auto___19536 = (0);
while(true){
if((i__7750__auto___19536 < len__7749__auto___19535)){
args__7756__auto__.push((arguments[i__7750__auto___19536]));

var G__19537 = (i__7750__auto___19536 + (1));
i__7750__auto___19536 = G__19537;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__19516 = cljs.core.cst$kw$fatal;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__19516) : taoensso.encore.log_QMARK_.call(null,G__19516));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FATAL: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.fatalf.cljs$lang$maxFixedArity = (1);

taoensso.encore.fatalf.cljs$lang$applyTo = (function (seq19514){
var G__19515 = cljs.core.first(seq19514);
var seq19514__$1 = cljs.core.next(seq19514);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic(G__19515,seq19514__$1);
});


taoensso.encore.reportf = (function taoensso$encore$reportf(var_args){
var args__7756__auto__ = [];
var len__7749__auto___19538 = arguments.length;
var i__7750__auto___19539 = (0);
while(true){
if((i__7750__auto___19539 < len__7749__auto___19538)){
args__7756__auto__.push((arguments[i__7750__auto___19539]));

var G__19540 = (i__7750__auto___19539 + (1));
i__7750__auto___19539 = G__19540;
continue;
} else {
}
break;
}

var argseq__7757__auto__ = ((((1) < args__7756__auto__.length))?(new cljs.core.IndexedSeq(args__7756__auto__.slice((1)),(0),null)):null);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7757__auto__);
});

taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__19519 = cljs.core.cst$kw$report;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__19519) : taoensso.encore.log_QMARK_.call(null,G__19519));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.reportf.cljs$lang$maxFixedArity = (1);

taoensso.encore.reportf.cljs$lang$applyTo = (function (seq19517){
var G__19518 = cljs.core.first(seq19517);
var seq19517__$1 = cljs.core.next(seq19517);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic(G__19518,seq19517__$1);
});

