// Compiled by ClojureScript 1.9.671 {:static-fns true, :optimize-constants true}
goog.provide('typeahead.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('om.core');
goog.require('cljs.core.async');
goog.require('om.dom');
goog.require('clojure.string');
typeahead.core.term_separator_re = /[|+ :]/;
typeahead.core.__GT_basic_entry = (function typeahead$core$__GT_basic_entry(term){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$term,term,cljs.core.cst$kw$props,cljs.core.PersistentArrayMap.EMPTY], null);
});
/**
 * Add a list of characters to an index, implemented as a trie.
 */
typeahead.core.into_index = (function typeahead$core$into_index(idx,cs,props){
if(cljs.core.empty_QMARK_(cs)){
if(cljs.core.empty_QMARK_(idx)){
return props;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(idx,"",props);
}
} else {
var c = cljs.core.first(cs);
var next = (function (){var G__24955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(idx,c);
var G__24956 = cljs.core.rest(cs);
var G__24957 = props;
return (typeahead.core.into_index.cljs$core$IFn$_invoke$arity$3 ? typeahead.core.into_index.cljs$core$IFn$_invoke$arity$3(G__24955,G__24956,G__24957) : typeahead.core.into_index.call(null,G__24955,G__24956,G__24957));
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(idx,cljs.core.cst$kw$props),c,((cljs.core.contains_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(idx,c),cljs.core.cst$kw$props))?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, ["",cljs.core.get.cljs$core$IFn$_invoke$arity$2(idx,c)], null),next], 0)):next));
}
});
/**
 * Given an existing index, add a new word.
 */
typeahead.core.index_single = (function typeahead$core$index_single(idx,p__24958){
var map__24959 = p__24958;
var map__24959__$1 = ((((!((map__24959 == null)))?((((map__24959.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24959.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24959):map__24959);
var term = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,cljs.core.cst$kw$term);
var props = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,cljs.core.cst$kw$props);
return typeahead.core.into_index(idx,cljs.core.seq(clojure.string.lower_case([cljs.core.str.cljs$core$IFn$_invoke$arity$1(term)].join(''))),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$props,props], null));
});
typeahead.core.transforming_index = (function typeahead$core$transforming_index(transformer,phrases){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(typeahead.core.index_single,cljs.core.PersistentArrayMap.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(transformer,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([phrases], 0))));
});
/**
 * Index the words of a list of phrases, returning the result as a trie.
 */
typeahead.core.word_index = (function typeahead$core$word_index(phrases){
return typeahead.core.transforming_index((function (p1__24961_SHARP_){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$term,x,cljs.core.cst$kw$props,(function (){var or__6624__auto__ = cljs.core.cst$kw$props.cljs$core$IFn$_invoke$arity$1(p1__24961_SHARP_);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})()], null);
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$term.cljs$core$IFn$_invoke$arity$1(p1__24961_SHARP_),typeahead.core.term_separator_re));
}),phrases);
});
/**
 * Index a list of phrases, returning the result as a trie.
 */
typeahead.core.phrase_index = (function typeahead$core$phrase_index(phrases){
return typeahead.core.transforming_index((function (p1__24962_SHARP_){
var x__7467__auto__ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__24962_SHARP_,cljs.core.cst$kw$props,(function (){var or__6624__auto__ = cljs.core.cst$kw$props.cljs$core$IFn$_invoke$arity$1(p1__24962_SHARP_);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})());
return cljs.core._conj(cljs.core.List.EMPTY,x__7467__auto__);
}),phrases);
});
typeahead.core.completion_option_component = (function typeahead$core$completion_option_component(data,owner){
if(typeof typeahead.core.t_typeahead$core24963 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
typeahead.core.t_typeahead$core24963 = (function (data,owner,meta24964){
this.data = data;
this.owner = owner;
this.meta24964 = meta24964;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
typeahead.core.t_typeahead$core24963.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_24965,meta24964__$1){
var self__ = this;
var _24965__$1 = this;
return (new typeahead.core.t_typeahead$core24963(self__.data,self__.owner,meta24964__$1));
});

typeahead.core.t_typeahead$core24963.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_24965){
var self__ = this;
var _24965__$1 = this;
return self__.meta24964;
});

typeahead.core.t_typeahead$core24963.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

typeahead.core.t_typeahead$core24963.prototype.om$core$IRenderState$render_state$arity$2 = (function (_,state){
var self__ = this;
var ___$1 = this;
var G__24966 = ({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("menu-item"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(self__.data),cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index.cljs$core$IFn$_invoke$arity$1(state)))?" active":""))].join(''), "onClick": ((function (___$1){
return (function (){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_async_DASH_pending,true);

var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,___$1){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,___$1){
return (function (state_24979){
var state_val_24980 = (state_24979[(1)]);
if((state_val_24980 === (1))){
var inst_24968 = cljs.core.cst$kw$typeahead$core_SLASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_24969 = [cljs.core.cst$kw$typeahead$core_SLASH_select];
var inst_24970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24971 = [cljs.core.cst$kw$entry,cljs.core.cst$kw$completion];
var inst_24972 = (new cljs.core.PersistentVector(null,2,(5),inst_24970,inst_24971,null));
var inst_24973 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,inst_24972);
var inst_24974 = [inst_24973];
var inst_24975 = cljs.core.PersistentHashMap.fromArrays(inst_24969,inst_24974);
var state_24979__$1 = state_24979;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24979__$1,(2),inst_24968,inst_24975);
} else {
if((state_val_24980 === (2))){
var inst_24977 = (state_24979[(2)]);
var state_24979__$1 = state_24979;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24979__$1,inst_24977);
} else {
return null;
}
}
});})(c__14822__auto__,___$1))
;
return ((function (switch__14722__auto__,c__14822__auto__,___$1){
return (function() {
var typeahead$core$completion_option_component_$_state_machine__14723__auto__ = null;
var typeahead$core$completion_option_component_$_state_machine__14723__auto____0 = (function (){
var statearr_24981 = [null,null,null,null,null,null,null];
(statearr_24981[(0)] = typeahead$core$completion_option_component_$_state_machine__14723__auto__);

(statearr_24981[(1)] = (1));

return statearr_24981;
});
var typeahead$core$completion_option_component_$_state_machine__14723__auto____1 = (function (state_24979){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_24979);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e24982){if((e24982 instanceof Object)){
var ex__14726__auto__ = e24982;
var statearr_24983_24985 = state_24979;
(statearr_24983_24985[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_24979);

return cljs.core.cst$kw$recur;
} else {
throw e24982;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__24986 = state_24979;
state_24979 = G__24986;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
typeahead$core$completion_option_component_$_state_machine__14723__auto__ = function(state_24979){
switch(arguments.length){
case 0:
return typeahead$core$completion_option_component_$_state_machine__14723__auto____0.call(this);
case 1:
return typeahead$core$completion_option_component_$_state_machine__14723__auto____1.call(this,state_24979);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
typeahead$core$completion_option_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = typeahead$core$completion_option_component_$_state_machine__14723__auto____0;
typeahead$core$completion_option_component_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = typeahead$core$completion_option_component_$_state_machine__14723__auto____1;
return typeahead$core$completion_option_component_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,___$1))
})();
var state__14824__auto__ = (function (){var statearr_24984 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_24984[(6)] = c__14822__auto__);

return statearr_24984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,___$1))
);

return c__14822__auto__;
});})(___$1))
});
var G__24967 = om.util.force_children(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$entry,cljs.core.cst$kw$completion], null)));
return React.DOM.div(G__24966,G__24967);
});

typeahead.core.t_typeahead$core24963.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta24964], null);
});

typeahead.core.t_typeahead$core24963.cljs$lang$type = true;

typeahead.core.t_typeahead$core24963.cljs$lang$ctorStr = "typeahead.core/t_typeahead$core24963";

typeahead.core.t_typeahead$core24963.cljs$lang$ctorPrWriter = (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"typeahead.core/t_typeahead$core24963");
});

typeahead.core.__GT_t_typeahead$core24963 = (function typeahead$core$completion_option_component_$___GT_t_typeahead$core24963(data__$1,owner__$1,meta24964){
return (new typeahead.core.t_typeahead$core24963(data__$1,owner__$1,meta24964));
});

}

return (new typeahead.core.t_typeahead$core24963(data,owner,cljs.core.PersistentArrayMap.EMPTY));
});
typeahead.core.completion_list_component = (function typeahead$core$completion_list_component(data,owner,p__24989){
var map__24990 = p__24989;
var map__24990__$1 = ((((!((map__24990 == null)))?((((map__24990.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24990.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24990):map__24990);
var show_create = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24990__$1,cljs.core.cst$kw$show_DASH_create);
var result_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24990__$1,cljs.core.cst$kw$result_DASH_limit);
if(typeof typeahead.core.t_typeahead$core24992 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
typeahead.core.t_typeahead$core24992 = (function (data,owner,p__24989,map__24990,show_create,result_limit,meta24993){
this.data = data;
this.owner = owner;
this.p__24989 = p__24989;
this.map__24990 = map__24990;
this.show_create = show_create;
this.result_limit = result_limit;
this.meta24993 = meta24993;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
typeahead.core.t_typeahead$core24992.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__24990,map__24990__$1,show_create,result_limit){
return (function (_24994,meta24993__$1){
var self__ = this;
var _24994__$1 = this;
return (new typeahead.core.t_typeahead$core24992(self__.data,self__.owner,self__.p__24989,self__.map__24990,self__.show_create,self__.result_limit,meta24993__$1));
});})(map__24990,map__24990__$1,show_create,result_limit))
;

typeahead.core.t_typeahead$core24992.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__24990,map__24990__$1,show_create,result_limit){
return (function (_24994){
var self__ = this;
var _24994__$1 = this;
return self__.meta24993;
});})(map__24990,map__24990__$1,show_create,result_limit))
;

typeahead.core.t_typeahead$core24992.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

typeahead.core.t_typeahead$core24992.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__24990,map__24990__$1,show_create,result_limit){
return (function (_,state){
var self__ = this;
var ___$1 = this;
if(cljs.core.seq(self__.data)){
var G__24995 = ({"className": "typeahead-menu"});
var G__24996 = om.util.force_children(om.core.build_all.cljs$core$IFn$_invoke$arity$3(typeahead.core.completion_option_component,cljs.core.vec(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (G__24995,___$1,map__24990,map__24990__$1,show_create,result_limit){
return (function (p1__24988_SHARP_,p2__24987_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$entry,cljs.core.cst$kw$index],[p2__24987_SHARP_,p1__24988_SHARP_]);
});})(G__24995,___$1,map__24990,map__24990__$1,show_create,result_limit))
,self__.data)),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$typeahead$core_SLASH_chan,cljs.core.cst$kw$typeahead$core_SLASH_chan.cljs$core$IFn$_invoke$arity$1(state)], null),cljs.core.cst$kw$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,cljs.core.mod(cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index.cljs$core$IFn$_invoke$arity$1(state),cljs.core.count(self__.data))], null),cljs.core.cst$kw$key,cljs.core.cst$kw$index], null)));
return React.DOM.div(G__24995,G__24996);
} else {
return null;
}
});})(map__24990,map__24990__$1,show_create,result_limit))
;

typeahead.core.t_typeahead$core24992.getBasis = ((function (map__24990,map__24990__$1,show_create,result_limit){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__24989,cljs.core.cst$sym$map__24990,cljs.core.cst$sym$show_DASH_create,cljs.core.cst$sym$result_DASH_limit,cljs.core.cst$sym$meta24993], null);
});})(map__24990,map__24990__$1,show_create,result_limit))
;

typeahead.core.t_typeahead$core24992.cljs$lang$type = true;

typeahead.core.t_typeahead$core24992.cljs$lang$ctorStr = "typeahead.core/t_typeahead$core24992";

typeahead.core.t_typeahead$core24992.cljs$lang$ctorPrWriter = ((function (map__24990,map__24990__$1,show_create,result_limit){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"typeahead.core/t_typeahead$core24992");
});})(map__24990,map__24990__$1,show_create,result_limit))
;

typeahead.core.__GT_t_typeahead$core24992 = ((function (map__24990,map__24990__$1,show_create,result_limit){
return (function typeahead$core$completion_list_component_$___GT_t_typeahead$core24992(data__$1,owner__$1,p__24989__$1,map__24990__$2,show_create__$1,result_limit__$1,meta24993){
return (new typeahead.core.t_typeahead$core24992(data__$1,owner__$1,p__24989__$1,map__24990__$2,show_create__$1,result_limit__$1,meta24993));
});})(map__24990,map__24990__$1,show_create,result_limit))
;

}

return (new typeahead.core.t_typeahead$core24992(data,owner,p__24989,map__24990__$1,show_create,result_limit,cljs.core.PersistentArrayMap.EMPTY));
});
typeahead.core.match_builder = (function typeahead$core$match_builder(data){
if(cljs.core.contains_QMARK_(data,cljs.core.cst$kw$props)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
} else {
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p1__24997_SHARP_){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (x){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__24997_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}),(function (){var G__24998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,p1__24997_SHARP_);
return (typeahead.core.match_builder.cljs$core$IFn$_invoke$arity$1 ? typeahead.core.match_builder.cljs$core$IFn$_invoke$arity$1(G__24998) : typeahead.core.match_builder.call(null,G__24998));
})());
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.keys(data)], 0));
}
});
typeahead.core.search_reducer = (function typeahead$core$search_reducer(acc,s){
var r = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,s);
if((r == null)){
return cljs.core.reduced(cljs.core.PersistentArrayMap.EMPTY);
} else {
return r;
}
});
/**
 * Return all possible completions given the index data and a prefix.
 */
typeahead.core.complete = (function typeahead$core$complete(data,prefix){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (p1__25000_SHARP_,p2__25001_SHARP_){
return cljs.core.compare(clojure.string.lower_case(p1__25000_SHARP_),clojure.string.lower_case(p2__25001_SHARP_));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24999_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__24999_SHARP_)].join('');
}),typeahead.core.match_builder(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(typeahead.core.search_reducer,data,cljs.core.seq(clojure.string.lower_case(prefix))))));
});
typeahead.core.props_for_subtree = (function typeahead$core$props_for_subtree(st){
var or__6624__auto__ = cljs.core.cst$kw$props.cljs$core$IFn$_invoke$arity$1(st);
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(st,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["",cljs.core.cst$kw$props], null));
}
});
/**
 * Return the props for search, or nil if search is not in the index.
 */
typeahead.core.ifind = (function typeahead$core$ifind(index,search){
if((search == null)){
return null;
} else {
return typeahead.core.props_for_subtree(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(typeahead.core.search_reducer,index,cljs.core.seq(clojure.string.lower_case(search))));
}
});
typeahead.core.term_separators = (function typeahead$core$term_separators(search){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__25004_SHARP_){
return cljs.core.re_matches(typeahead.core.term_separator_re,cljs.core.second(p1__25004_SHARP_));
}),cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (p1__25002_SHARP_,p2__25003_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__25002_SHARP_,p2__25003_SHARP_],null));
}),cljs.core.seq(clojure.string.lower_case(search)))));
});
typeahead.core.next_separator = (function typeahead$core$next_separator(search,point){
var or__6624__auto__ = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__25005_SHARP_){
return (p1__25005_SHARP_ >= point);
}),typeahead.core.term_separators(search)));
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return cljs.core.count(search);
}
});
/**
 * Return the term at a given cursor position.
 */
typeahead.core.term_at_point = (function typeahead$core$term_at_point(search,point){
var p = typeahead.core.next_separator(search,(function (){var x__6967__auto__ = cljs.core.count(search);
var y__6968__auto__ = point;
return ((x__6967__auto__ < y__6968__auto__) ? x__6967__auto__ : y__6968__auto__);
})());
if(cljs.core.truth_((function (){var or__6624__auto__ = (point === (0));
if(or__6624__auto__){
return or__6624__auto__;
} else {
return cljs.core.re_matches(typeahead.core.term_separator_re,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(search,(point - (1))))].join(''));
}
})())){
return "";
} else {
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.first(cljs.core.split_at(p,search))),typeahead.core.term_separator_re));
}
});
typeahead.core.splice = (function typeahead$core$splice(all,new$,start,end){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(start,all)),new$),(function (){var tail = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(end,all);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(tail),":")){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),tail);
} else {
return tail;
}
})());
});
typeahead.core.insertion_chars = (function typeahead$core$insertion_chars(insertion){
var qd = (cljs.core.truth_(cljs.core.re_matches(/.*[\ \|].*/,insertion))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1("\""),cljs.core.str.cljs$core$IFn$_invoke$arity$1(insertion),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join(''):insertion);
return cljs.core.seq(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(insertion),":"))?qd:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(qd),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" ")].join('')));
});
typeahead.core.replace_term = (function typeahead$core$replace_term(search,point,selection_end,insertion,multi_term){
if(cljs.core.truth_(multi_term)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(point,selection_end)){
var term = typeahead.core.term_at_point(search,point);
var end = typeahead.core.next_separator(search,point);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,typeahead.core.splice(cljs.core.seq(search),typeahead.core.insertion_chars(insertion),(end - cljs.core.count(term)),end));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,typeahead.core.splice(cljs.core.seq(search),typeahead.core.insertion_chars(insertion),point,selection_end));
}
} else {
return insertion;
}
});
/**
 * Return the field responsible for setting context at point, if any.
 */
typeahead.core.field_context = (function typeahead$core$field_context(search,point){
if((point === (0))){
return null;
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__25007_SHARP_,p2__25006_SHARP_){
var c = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(search,p2__25006_SHARP_);
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c,"|")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c," "))){
return cljs.core.reduced(null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c,":")){
return cljs.core.reduced(typeahead.core.term_at_point(search,p2__25006_SHARP_));
} else {
return null;

}
}
}),null,cljs.core.range.cljs$core$IFn$_invoke$arity$3((point - (1)),(0),(-1)));
}
});
typeahead.core.already_complete_QMARK_ = (function typeahead$core$already_complete_QMARK_(cs,v){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cs),(1))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cs),v));
});
/**
 * Input component with typeahead-style completion.
 */
typeahead.core.typeahead = (function typeahead$core$typeahead(data,owner,p__25010){
var map__25011 = p__25010;
var map__25011__$1 = ((((!((map__25011 == null)))?((((map__25011.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25011.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25011):map__25011);
var create_text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25011__$1,cljs.core.cst$kw$create_DASH_text);
var create_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25011__$1,cljs.core.cst$kw$create_DASH_fn);
var input_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25011__$1,cljs.core.cst$kw$input_DASH_config);
var multi_term = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25011__$1,cljs.core.cst$kw$multi_DASH_term);
if(typeof typeahead.core.t_typeahead$core25013 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {om.core.IWillUpdate}
 * @implements {cljs.core.IWithMeta}
*/
typeahead.core.t_typeahead$core25013 = (function (data,owner,p__25010,map__25011,create_text,create_fn,input_config,multi_term,meta25014){
this.data = data;
this.owner = owner;
this.p__25010 = p__25010;
this.map__25011 = map__25011;
this.create_text = create_text;
this.create_fn = create_fn;
this.input_config = input_config;
this.multi_term = multi_term;
this.meta25014 = meta25014;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
typeahead.core.t_typeahead$core25013.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (_25015,meta25014__$1){
var self__ = this;
var _25015__$1 = this;
return (new typeahead.core.t_typeahead$core25013(self__.data,self__.owner,self__.p__25010,self__.map__25011,self__.create_text,self__.create_fn,self__.input_config,self__.multi_term,meta25014__$1));
});})(map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core25013.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (_25015){
var self__ = this;
var _25015__$1 = this;
return self__.meta25014;
});})(map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core25013.prototype.om$core$IInitState$ = cljs.core.PROTOCOL_SENTINEL;

typeahead.core.t_typeahead$core25013.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$typeahead$core_SLASH_value,"",cljs.core.cst$kw$typeahead$core_SLASH_int_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1))),cljs.core.cst$kw$typeahead$core_SLASH_completion_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0(),cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,(0)], null);
});})(map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core25013.prototype.om$core$IWillUpdate$ = cljs.core.PROTOCOL_SENTINEL;

typeahead.core.t_typeahead$core25013.prototype.om$core$IWillUpdate$will_update$arity$3 = ((function (map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (_,props,state){
var self__ = this;
var ___$1 = this;
var si = om.core.get_node.cljs$core$IFn$_invoke$arity$2(self__.owner,"search-input");
var ctx = typeahead.core.field_context(cljs.core.cst$kw$typeahead$core_SLASH_value.cljs$core$IFn$_invoke$arity$1(state),si.selectionStart);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$typeahead$core_SLASH_context.cljs$core$IFn$_invoke$arity$1(state),ctx)){
} else {
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_context,ctx);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_completions,null);

var cfn_25152 = cljs.core.cst$kw$completion_DASH_fn.cljs$core$IFn$_invoke$arity$1(typeahead.core.ifind(self__.data,ctx));
var and__6612__auto___25153 = cfn_25152;
if(cljs.core.truth_(and__6612__auto___25153)){
var G__25016_25154 = clojure.string.lower_case(ctx);
var G__25017_25155 = cljs.core.cst$kw$typeahead$core_SLASH_completion_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
(cfn_25152.cljs$core$IFn$_invoke$arity$2 ? cfn_25152.cljs$core$IFn$_invoke$arity$2(G__25016_25154,G__25017_25155) : cfn_25152.call(null,G__25016_25154,G__25017_25155));
} else {
}
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_term,(function (){var G__25019 = cljs.core.cst$kw$typeahead$core_SLASH_value.cljs$core$IFn$_invoke$arity$1(state);
var G__25020 = si.selectionStart;
var fexpr__25018 = (cljs.core.truth_(self__.multi_term)?typeahead.core.term_at_point:cljs.core.identity);
return (fexpr__25018.cljs$core$IFn$_invoke$arity$2 ? fexpr__25018.cljs$core$IFn$_invoke$arity$2(G__25019,G__25020) : fexpr__25018.call(null,G__25019,G__25020));
})());

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(document.activeElement,si)){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_is_DASH_focused,true);
} else {
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,si,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,si,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (state_25026){
var state_val_25027 = (state_25026[(1)]);
if((state_val_25027 === (1))){
var inst_25021 = cljs.core.async.timeout((100));
var state_25026__$1 = state_25026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25026__$1,(2),inst_25021);
} else {
if((state_val_25027 === (2))){
var inst_25023 = (state_25026[(2)]);
var inst_25024 = om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_is_DASH_focused,false);
var state_25026__$1 = (function (){var statearr_25028 = state_25026;
(statearr_25028[(7)] = inst_25023);

return statearr_25028;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_25026__$1,inst_25024);
} else {
return null;
}
}
});})(c__14822__auto__,si,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;
return ((function (switch__14722__auto__,c__14822__auto__,si,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function() {
var typeahead$core$typeahead_$_state_machine__14723__auto__ = null;
var typeahead$core$typeahead_$_state_machine__14723__auto____0 = (function (){
var statearr_25029 = [null,null,null,null,null,null,null,null];
(statearr_25029[(0)] = typeahead$core$typeahead_$_state_machine__14723__auto__);

(statearr_25029[(1)] = (1));

return statearr_25029;
});
var typeahead$core$typeahead_$_state_machine__14723__auto____1 = (function (state_25026){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_25026);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e25030){if((e25030 instanceof Object)){
var ex__14726__auto__ = e25030;
var statearr_25031_25156 = state_25026;
(statearr_25031_25156[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_25026);

return cljs.core.cst$kw$recur;
} else {
throw e25030;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__25157 = state_25026;
state_25026 = G__25157;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
typeahead$core$typeahead_$_state_machine__14723__auto__ = function(state_25026){
switch(arguments.length){
case 0:
return typeahead$core$typeahead_$_state_machine__14723__auto____0.call(this);
case 1:
return typeahead$core$typeahead_$_state_machine__14723__auto____1.call(this,state_25026);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
typeahead$core$typeahead_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = typeahead$core$typeahead_$_state_machine__14723__auto____0;
typeahead$core$typeahead_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = typeahead$core$typeahead_$_state_machine__14723__auto____1;
return typeahead$core$typeahead_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,si,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
})();
var state__14824__auto__ = (function (){var statearr_25032 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_25032[(6)] = c__14822__auto__);

return statearr_25032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,si,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
);

return c__14822__auto__;
}
});})(map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core25013.prototype.om$core$IWillMount$ = cljs.core.PROTOCOL_SENTINEL;

typeahead.core.t_typeahead$core25013.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (_){
var self__ = this;
var ___$1 = this;
var ic = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_int_DASH_chan);
var cc = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_completion_DASH_chan);
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,ic,cc,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,ic,cc,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (state_25085){
var state_val_25086 = (state_25085[(1)]);
if((state_val_25086 === (7))){
var inst_25079 = (state_25085[(2)]);
var inst_25080 = om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,(0));
var state_25085__$1 = (function (){var statearr_25087 = state_25085;
(statearr_25087[(7)] = inst_25079);

(statearr_25087[(8)] = inst_25080);

return statearr_25087;
})();
var statearr_25088_25158 = state_25085__$1;
(statearr_25088_25158[(2)] = null);

(statearr_25088_25158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (1))){
var state_25085__$1 = state_25085;
var statearr_25089_25159 = state_25085__$1;
(statearr_25089_25159[(2)] = null);

(statearr_25089_25159[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (4))){
var inst_25041 = (state_25085[(2)]);
var inst_25042 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25041,(0),null);
var inst_25043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25041,(1),null);
var inst_25044 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_25043,ic);
var state_25085__$1 = (function (){var statearr_25090 = state_25085;
(statearr_25090[(9)] = inst_25042);

return statearr_25090;
})();
if(inst_25044){
var statearr_25091_25160 = state_25085__$1;
(statearr_25091_25160[(1)] = (5));

} else {
var statearr_25092_25161 = state_25085__$1;
(statearr_25092_25161[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (15))){
var state_25085__$1 = state_25085;
var statearr_25093_25162 = state_25085__$1;
(statearr_25093_25162[(2)] = null);

(statearr_25093_25162[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (13))){
var inst_25054 = (state_25085[(10)]);
var inst_25053 = (state_25085[(11)]);
var inst_25051 = (state_25085[(12)]);
var inst_25052 = (state_25085[(13)]);
var inst_25061 = (state_25085[(14)]);
var inst_25059 = (state_25085[(2)]);
var inst_25060 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25054),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25059)].join('');
var inst_25061__$1 = typeahead.core.replace_term(inst_25051,inst_25052,inst_25053,inst_25060,self__.multi_term);
var inst_25062 = om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_value,inst_25061__$1);
var inst_25063 = om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_async_DASH_pending,false);
var inst_25064 = cljs.core.cst$kw$onChange.cljs$core$IFn$_invoke$arity$1(self__.input_config);
var state_25085__$1 = (function (){var statearr_25094 = state_25085;
(statearr_25094[(15)] = inst_25063);

(statearr_25094[(16)] = inst_25062);

(statearr_25094[(14)] = inst_25061__$1);

return statearr_25094;
})();
if(cljs.core.truth_(inst_25064)){
var statearr_25095_25163 = state_25085__$1;
(statearr_25095_25163[(1)] = (14));

} else {
var statearr_25096_25164 = state_25085__$1;
(statearr_25096_25164[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (6))){
var inst_25042 = (state_25085[(9)]);
var inst_25077 = om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_completions,inst_25042);
var state_25085__$1 = state_25085;
var statearr_25097_25165 = state_25085__$1;
(statearr_25097_25165[(2)] = inst_25077);

(statearr_25097_25165[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (3))){
var inst_25083 = (state_25085[(2)]);
var state_25085__$1 = state_25085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25085__$1,inst_25083);
} else {
if((state_val_25086 === (12))){
var state_25085__$1 = state_25085;
var statearr_25098_25166 = state_25085__$1;
(statearr_25098_25166[(2)] = "");

(statearr_25098_25166[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (2))){
var inst_25037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25038 = [ic,cc];
var inst_25039 = (new cljs.core.PersistentVector(null,2,(5),inst_25037,inst_25038,null));
var state_25085__$1 = state_25085;
return cljs.core.async.ioc_alts_BANG_(state_25085__$1,(4),inst_25039);
} else {
if((state_val_25086 === (11))){
var state_25085__$1 = state_25085;
var statearr_25099_25167 = state_25085__$1;
(statearr_25099_25167[(2)] = ":");

(statearr_25099_25167[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (9))){
var state_25085__$1 = state_25085;
var statearr_25100_25168 = state_25085__$1;
(statearr_25100_25168[(2)] = null);

(statearr_25100_25168[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (5))){
var inst_25042 = (state_25085[(9)]);
var inst_25046 = cljs.core.cst$kw$typeahead$core_SLASH_select.cljs$core$IFn$_invoke$arity$1(inst_25042);
var state_25085__$1 = state_25085;
if(cljs.core.truth_(inst_25046)){
var statearr_25101_25169 = state_25085__$1;
(statearr_25101_25169[(1)] = (8));

} else {
var statearr_25102_25170 = state_25085__$1;
(statearr_25102_25170[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (14))){
var inst_25061 = (state_25085[(14)]);
var inst_25066 = cljs.core.cst$kw$onChange.cljs$core$IFn$_invoke$arity$1(self__.input_config);
var inst_25067 = (inst_25066.cljs$core$IFn$_invoke$arity$1 ? inst_25066.cljs$core$IFn$_invoke$arity$1(inst_25061) : inst_25066.call(null,inst_25061));
var state_25085__$1 = state_25085;
var statearr_25103_25171 = state_25085__$1;
(statearr_25103_25171[(2)] = inst_25067);

(statearr_25103_25171[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (16))){
var inst_25070 = (state_25085[(2)]);
var inst_25071 = om.core.get_node.cljs$core$IFn$_invoke$arity$2(self__.owner,"search-input");
var inst_25072 = inst_25071.focus();
var state_25085__$1 = (function (){var statearr_25104 = state_25085;
(statearr_25104[(17)] = inst_25070);

return statearr_25104;
})();
var statearr_25105_25172 = state_25085__$1;
(statearr_25105_25172[(2)] = inst_25072);

(statearr_25105_25172[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (10))){
var inst_25075 = (state_25085[(2)]);
var state_25085__$1 = state_25085;
var statearr_25106_25173 = state_25085__$1;
(statearr_25106_25173[(2)] = inst_25075);

(statearr_25106_25173[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25086 === (8))){
var inst_25042 = (state_25085[(9)]);
var inst_25048 = om.core.get_node.cljs$core$IFn$_invoke$arity$2(self__.owner,"search-input");
var inst_25049 = cljs.core.cst$kw$typeahead$core_SLASH_select.cljs$core$IFn$_invoke$arity$1(inst_25042);
var inst_25050 = typeahead.core.ifind(self__.data,inst_25049);
var inst_25051 = om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_value);
var inst_25052 = inst_25048.selectionStart;
var inst_25053 = inst_25048.selectionEnd;
var inst_25054 = cljs.core.cst$kw$typeahead$core_SLASH_select.cljs$core$IFn$_invoke$arity$1(inst_25042);
var inst_25055 = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(inst_25050);
var state_25085__$1 = (function (){var statearr_25107 = state_25085;
(statearr_25107[(10)] = inst_25054);

(statearr_25107[(11)] = inst_25053);

(statearr_25107[(12)] = inst_25051);

(statearr_25107[(13)] = inst_25052);

return statearr_25107;
})();
if(cljs.core.truth_(inst_25055)){
var statearr_25108_25174 = state_25085__$1;
(statearr_25108_25174[(1)] = (11));

} else {
var statearr_25109_25175 = state_25085__$1;
(statearr_25109_25175[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__14822__auto__,ic,cc,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;
return ((function (switch__14722__auto__,c__14822__auto__,ic,cc,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function() {
var typeahead$core$typeahead_$_state_machine__14723__auto__ = null;
var typeahead$core$typeahead_$_state_machine__14723__auto____0 = (function (){
var statearr_25110 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25110[(0)] = typeahead$core$typeahead_$_state_machine__14723__auto__);

(statearr_25110[(1)] = (1));

return statearr_25110;
});
var typeahead$core$typeahead_$_state_machine__14723__auto____1 = (function (state_25085){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_25085);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e25111){if((e25111 instanceof Object)){
var ex__14726__auto__ = e25111;
var statearr_25112_25176 = state_25085;
(statearr_25112_25176[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_25085);

return cljs.core.cst$kw$recur;
} else {
throw e25111;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__25177 = state_25085;
state_25085 = G__25177;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
typeahead$core$typeahead_$_state_machine__14723__auto__ = function(state_25085){
switch(arguments.length){
case 0:
return typeahead$core$typeahead_$_state_machine__14723__auto____0.call(this);
case 1:
return typeahead$core$typeahead_$_state_machine__14723__auto____1.call(this,state_25085);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
typeahead$core$typeahead_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = typeahead$core$typeahead_$_state_machine__14723__auto____0;
typeahead$core$typeahead_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = typeahead$core$typeahead_$_state_machine__14723__auto____1;
return typeahead$core$typeahead_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,ic,cc,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
})();
var state__14824__auto__ = (function (){var statearr_25113 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_25113[(6)] = c__14822__auto__);

return statearr_25113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,ic,cc,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
);

return c__14822__auto__;
});})(map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core25013.prototype.om$core$IRenderState$ = cljs.core.PROTOCOL_SENTINEL;

typeahead.core.t_typeahead$core25013.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (_,state){
var self__ = this;
var ___$1 = this;
var v = cljs.core.cst$kw$typeahead$core_SLASH_term.cljs$core$IFn$_invoke$arity$1(state);
var ctx = cljs.core.cst$kw$typeahead$core_SLASH_completions.cljs$core$IFn$_invoke$arity$1(state);
var G__25114 = ({"className": "typeahead"});
var G__25115 = om.util.force_children((function (){var G__25118 = cljs.core.clj__GT_js(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([self__.input_config,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$value,cljs.core.cst$kw$typeahead$core_SLASH_value.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$ref,"search-input",cljs.core.cst$kw$disabled,(cljs.core.truth_(cljs.core.cst$kw$disabled.cljs$core$IFn$_invoke$arity$1(state))?"disabled":""),cljs.core.cst$kw$onKeyDown,((function (G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (e){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(e.keyCode,(38))){
om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,cljs.core.dec);

e.preventDefault();

e.stopPropagation();

return om.core.refresh_BANG_(self__.owner);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(e.keyCode,(40))){
om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,cljs.core.inc);

e.preventDefault();

e.stopPropagation();

return om.core.refresh_BANG_(self__.owner);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(e.keyCode,(13))){
e.preventDefault();

e.stopPropagation();

if(!((cljs.core.empty_QMARK_(v)) && (cljs.core.empty_QMARK_(ctx)))){
var comps_25178 = typeahead.core.complete((function (){var or__6624__auto__ = (function (){var and__6612__auto__ = cljs.core.cst$kw$typeahead$core_SLASH_context.cljs$core$IFn$_invoke$arity$1(state);
if(cljs.core.truth_(and__6612__auto__)){
return ctx;
} else {
return and__6612__auto__;
}
})();
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return self__.data;
}
})(),v);
if(cljs.core.seq(comps_25178)){
var c__14822__auto___25179 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto___25179,comps_25178,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto___25179,comps_25178,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (state_25130){
var state_val_25131 = (state_25130[(1)]);
if((state_val_25131 === (1))){
var inst_25119 = cljs.core.cst$kw$typeahead$core_SLASH_int_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var inst_25120 = [cljs.core.cst$kw$typeahead$core_SLASH_select];
var inst_25121 = cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index.cljs$core$IFn$_invoke$arity$1(state);
var inst_25122 = cljs.core.count(comps_25178);
var inst_25123 = cljs.core.mod(inst_25121,inst_25122);
var inst_25124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(comps_25178,inst_25123);
var inst_25125 = [inst_25124];
var inst_25126 = cljs.core.PersistentHashMap.fromArrays(inst_25120,inst_25125);
var state_25130__$1 = state_25130;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25130__$1,(2),inst_25119,inst_25126);
} else {
if((state_val_25131 === (2))){
var inst_25128 = (state_25130[(2)]);
var state_25130__$1 = state_25130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25130__$1,inst_25128);
} else {
return null;
}
}
});})(c__14822__auto___25179,comps_25178,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;
return ((function (switch__14722__auto__,c__14822__auto___25179,comps_25178,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function() {
var typeahead$core$typeahead_$_state_machine__14723__auto__ = null;
var typeahead$core$typeahead_$_state_machine__14723__auto____0 = (function (){
var statearr_25132 = [null,null,null,null,null,null,null];
(statearr_25132[(0)] = typeahead$core$typeahead_$_state_machine__14723__auto__);

(statearr_25132[(1)] = (1));

return statearr_25132;
});
var typeahead$core$typeahead_$_state_machine__14723__auto____1 = (function (state_25130){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_25130);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e25133){if((e25133 instanceof Object)){
var ex__14726__auto__ = e25133;
var statearr_25134_25180 = state_25130;
(statearr_25134_25180[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_25130);

return cljs.core.cst$kw$recur;
} else {
throw e25133;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__25181 = state_25130;
state_25130 = G__25181;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
typeahead$core$typeahead_$_state_machine__14723__auto__ = function(state_25130){
switch(arguments.length){
case 0:
return typeahead$core$typeahead_$_state_machine__14723__auto____0.call(this);
case 1:
return typeahead$core$typeahead_$_state_machine__14723__auto____1.call(this,state_25130);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
typeahead$core$typeahead_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = typeahead$core$typeahead_$_state_machine__14723__auto____0;
typeahead$core$typeahead_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = typeahead$core$typeahead_$_state_machine__14723__auto____1;
return typeahead$core$typeahead_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto___25179,comps_25178,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
})();
var state__14824__auto__ = (function (){var statearr_25135 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_25135[(6)] = c__14822__auto___25179);

return statearr_25135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto___25179,comps_25178,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
);

} else {
if(cljs.core.truth_(cljs.core.cst$kw$onKeyDown.cljs$core$IFn$_invoke$arity$1(self__.input_config))){
var fexpr__25136_25182 = cljs.core.cst$kw$onKeyDown.cljs$core$IFn$_invoke$arity$1(self__.input_config);
(fexpr__25136_25182.cljs$core$IFn$_invoke$arity$1 ? fexpr__25136_25182.cljs$core$IFn$_invoke$arity$1(e) : fexpr__25136_25182.call(null,e));
} else {
}
}
} else {
if(cljs.core.truth_(cljs.core.cst$kw$onKeyDown.cljs$core$IFn$_invoke$arity$1(self__.input_config))){
var fexpr__25137_25183 = cljs.core.cst$kw$onKeyDown.cljs$core$IFn$_invoke$arity$1(self__.input_config);
(fexpr__25137_25183.cljs$core$IFn$_invoke$arity$1 ? fexpr__25137_25183.cljs$core$IFn$_invoke$arity$1(e) : fexpr__25137_25183.call(null,e));
} else {
}
}

return om.core.refresh_BANG_(self__.owner);
} else {
return null;
}
}
}
});})(G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
,cljs.core.cst$kw$onChange,((function (G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (p1__25008_SHARP_){
var tv = p1__25008_SHARP_.target.value;
if(cljs.core.truth_(cljs.core.cst$kw$onChange.cljs$core$IFn$_invoke$arity$1(self__.input_config))){
var fexpr__25138_25184 = cljs.core.cst$kw$onChange.cljs$core$IFn$_invoke$arity$1(self__.input_config);
(fexpr__25138_25184.cljs$core$IFn$_invoke$arity$1 ? fexpr__25138_25184.cljs$core$IFn$_invoke$arity$1(tv) : fexpr__25138_25184.call(null,tv));
} else {
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$typeahead$core_SLASH_value,tv);

if(cljs.core.truth_(tv)){
var c__14822__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14822__auto__,tv,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (){
var f__14823__auto__ = (function (){var switch__14722__auto__ = ((function (c__14822__auto__,tv,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (state_25143){
var state_val_25144 = (state_25143[(1)]);
if((state_val_25144 === (1))){
var inst_25139 = cljs.core.cst$kw$typeahead$core_SLASH_int_DASH_chan.cljs$core$IFn$_invoke$arity$1(state);
var state_25143__$1 = state_25143;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_25143__$1,(2),inst_25139,tv);
} else {
if((state_val_25144 === (2))){
var inst_25141 = (state_25143[(2)]);
var state_25143__$1 = state_25143;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25143__$1,inst_25141);
} else {
return null;
}
}
});})(c__14822__auto__,tv,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;
return ((function (switch__14722__auto__,c__14822__auto__,tv,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function() {
var typeahead$core$typeahead_$_state_machine__14723__auto__ = null;
var typeahead$core$typeahead_$_state_machine__14723__auto____0 = (function (){
var statearr_25145 = [null,null,null,null,null,null,null];
(statearr_25145[(0)] = typeahead$core$typeahead_$_state_machine__14723__auto__);

(statearr_25145[(1)] = (1));

return statearr_25145;
});
var typeahead$core$typeahead_$_state_machine__14723__auto____1 = (function (state_25143){
while(true){
var ret_value__14724__auto__ = (function (){try{while(true){
var result__14725__auto__ = switch__14722__auto__(state_25143);
if(cljs.core.keyword_identical_QMARK_(result__14725__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14725__auto__;
}
break;
}
}catch (e25146){if((e25146 instanceof Object)){
var ex__14726__auto__ = e25146;
var statearr_25147_25185 = state_25143;
(statearr_25147_25185[(5)] = ex__14726__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_25143);

return cljs.core.cst$kw$recur;
} else {
throw e25146;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14724__auto__,cljs.core.cst$kw$recur)){
var G__25186 = state_25143;
state_25143 = G__25186;
continue;
} else {
return ret_value__14724__auto__;
}
break;
}
});
typeahead$core$typeahead_$_state_machine__14723__auto__ = function(state_25143){
switch(arguments.length){
case 0:
return typeahead$core$typeahead_$_state_machine__14723__auto____0.call(this);
case 1:
return typeahead$core$typeahead_$_state_machine__14723__auto____1.call(this,state_25143);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
typeahead$core$typeahead_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$0 = typeahead$core$typeahead_$_state_machine__14723__auto____0;
typeahead$core$typeahead_$_state_machine__14723__auto__.cljs$core$IFn$_invoke$arity$1 = typeahead$core$typeahead_$_state_machine__14723__auto____1;
return typeahead$core$typeahead_$_state_machine__14723__auto__;
})()
;})(switch__14722__auto__,c__14822__auto__,tv,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
})();
var state__14824__auto__ = (function (){var statearr_25148 = (f__14823__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14823__auto__.cljs$core$IFn$_invoke$arity$0() : f__14823__auto__.call(null));
(statearr_25148[(6)] = c__14822__auto__);

return statearr_25148;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14824__auto__);
});})(c__14822__auto__,tv,G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
);

return c__14822__auto__;
} else {
return null;
}
});})(G__25114,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
], null)], 0)));
return (om.dom.input.cljs$core$IFn$_invoke$arity$1 ? om.dom.input.cljs$core$IFn$_invoke$arity$1(G__25118) : om.dom.input.call(null,G__25118));
})());
var G__25116 = om.util.force_children((cljs.core.truth_(cljs.core.cst$kw$disabled.cljs$core$IFn$_invoke$arity$1(state))?(function (){var G__25149 = ({"className": "typeahead-spinner"});
var G__25150 = om.util.force_children((function (){var G__25151 = ({"src": "images/spinner.gif", "height": "16", "width": "16"});
return React.DOM.img(G__25151);
})());
return React.DOM.div(G__25149,G__25150);
})():null));
var G__25117 = om.util.force_children((((cljs.core.empty_QMARK_(v)) && (cljs.core.empty_QMARK_(ctx)))?null:(function (){var completions = typeahead.core.complete((function (){var or__6624__auto__ = (function (){var and__6612__auto__ = cljs.core.cst$kw$typeahead$core_SLASH_context.cljs$core$IFn$_invoke$arity$1(state);
if(cljs.core.truth_(and__6612__auto__)){
return ctx;
} else {
return and__6612__auto__;
}
})();
if(cljs.core.truth_(or__6624__auto__)){
return or__6624__auto__;
} else {
return self__.data;
}
})(),v);
if(cljs.core.truth_((function (){var and__6612__auto__ = cljs.core.not(typeahead.core.already_complete_QMARK_(completions,v));
if(and__6612__auto__){
return cljs.core.cst$kw$typeahead$core_SLASH_is_DASH_focused.cljs$core$IFn$_invoke$arity$1(state);
} else {
return and__6612__auto__;
}
})())){
return om.core.build.cljs$core$IFn$_invoke$arity$3(typeahead.core.completion_list_component,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (completions,G__25114,G__25115,G__25116,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (p1__25009_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$completion,cljs.core.cst$kw$context],[p1__25009_SHARP_,null]);
});})(completions,G__25114,G__25115,G__25116,v,ctx,___$1,map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
,completions),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$init_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$typeahead$core_SLASH_chan,cljs.core.cst$kw$typeahead$core_SLASH_int_DASH_chan.cljs$core$IFn$_invoke$arity$1(state)], null),cljs.core.cst$kw$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index,cljs.core.cst$kw$typeahead$core_SLASH_selection_DASH_index.cljs$core$IFn$_invoke$arity$1(state)], null),cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$show_DASH_create,!((self__.create_fn == null))], null)], null));
} else {
return null;
}
})()));
return React.DOM.div(G__25114,G__25115,G__25116,G__25117);
});})(map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core25013.getBasis = ((function (map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$data,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__25010,cljs.core.cst$sym$map__25011,cljs.core.cst$sym$create_DASH_text,cljs.core.cst$sym$create_DASH_fn,cljs.core.cst$sym$input_DASH_config,cljs.core.cst$sym$multi_DASH_term,cljs.core.cst$sym$meta25014], null);
});})(map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.t_typeahead$core25013.cljs$lang$type = true;

typeahead.core.t_typeahead$core25013.cljs$lang$ctorStr = "typeahead.core/t_typeahead$core25013";

typeahead.core.t_typeahead$core25013.cljs$lang$ctorPrWriter = ((function (map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function (this__7235__auto__,writer__7236__auto__,opt__7237__auto__){
return cljs.core._write(writer__7236__auto__,"typeahead.core/t_typeahead$core25013");
});})(map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;

typeahead.core.__GT_t_typeahead$core25013 = ((function (map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term){
return (function typeahead$core$typeahead_$___GT_t_typeahead$core25013(data__$1,owner__$1,p__25010__$1,map__25011__$2,create_text__$1,create_fn__$1,input_config__$1,multi_term__$1,meta25014){
return (new typeahead.core.t_typeahead$core25013(data__$1,owner__$1,p__25010__$1,map__25011__$2,create_text__$1,create_fn__$1,input_config__$1,multi_term__$1,meta25014));
});})(map__25011,map__25011__$1,create_text,create_fn,input_config,multi_term))
;

}

return (new typeahead.core.t_typeahead$core25013(data,owner,p__25010,map__25011__$1,create_text,create_fn,input_config,multi_term,cljs.core.PersistentArrayMap.EMPTY));
});
